// Copyright (c) 2005 Rowley Associates Limited.

var initialised = false;
var titleNode;
var breadcrumbNode;
var previousAnchor;
var upAnchor;
var nextAnchor;

function
setAnchor(anchor, node)
{
  if (node)
    {
      var srcAnchor = node.getElementsByTagName("A").item(0);
      anchor.setAttribute("href", srcAnchor.getAttribute("href"));
      anchor.setAttribute("target", srcAnchor.getAttribute("target"));
      anchor.className = "active";
    }
  else
    {
      anchor.removeAttribute("href");
      anchor.className = "disabled";
    }
}

function
getFirstDivContentNode(node)
{
  var result = node.getElementsByTagName("DIV").item(0);
  if (result.getAttribute("id") == "content")
    return result;
  return null;
}

function
updateCurrentNode()
{
  var currentNode = top.frames[1].currentNode;

  // Set the page title
  while (titleNode.firstChild)
    titleNode.removeChild(titleNode.firstChild);
  titleNode.appendChild(document.createTextNode(getFirstDivContentNode(currentNode).firstChild.data));

  // Sort out the navigation anchors
  setAnchor(previousAnchor, top.frames[1].currentPreviousNode);
  setAnchor(nextAnchor, top.frames[1].currentNextNode);
  setAnchor(upAnchor, top.frames[1].currentUpNode);

  // Delete any existing breadcrumb trail
  while (breadcrumbNode.firstChild)
    breadcrumbNode.removeChild(breadcrumbNode.firstChild);

  // Create new breadcrumb trail based on current node
  currentNode = top.frames[1].upNode(currentNode);
  while (currentNode)
    {
      if (breadcrumbNode.firstChild)
        breadcrumbNode.insertBefore(document.createTextNode(" > "), breadcrumbNode.firstChild);
      var divContentNode = getFirstDivContentNode(currentNode);
      if (divContentNode.parentNode.tagName == "A")
        {
          var anchor = divContentNode.parentNode;
          var newanchor = document.createElement("A");
          newanchor.setAttribute("href", anchor.getAttribute("href"));
          newanchor.setAttribute("target", anchor.getAttribute("target"));
          newanchor.appendChild(document.createTextNode(divContentNode.firstChild.data));
          breadcrumbNode.insertBefore(newanchor, breadcrumbNode.firstChild);
        }
      else
        {
          breadcrumbNode.insertBefore(document.createTextNode(divContentNode.firstChild.data), breadcrumbNode.firstChild);
        }
      currentNode = top.frames[1].upNode(currentNode);
    }
}

function
initialise()
{
  var elements;

  if (!top.frames[1].initialised)
    {
      /* Try again later if other frames have not loaded yet */
      setTimeout("initialise()", 500);
      return;
    }

  titleNode = document.getElementsByTagName("H1").item(0);
  elements = document.getElementsByTagName("DIV");
  for (var i = 0; i < elements.length; ++i)
    {
      if (elements[i].id == "nav_breadcrumb")
        {
          breadcrumbNode = elements[i];
          break;
        }
    }

  elements = document.getElementsByTagName("A");
  for (var i = 0; i < elements.length; ++i)
    { 
      if (elements[i].id == "nav_prev")
        {
          previousAnchor = elements[i];
          previousAnchor.onclick = top.frames[1].previousNodeClickedEvent;
        }
      else if (elements[i].id == "nav_up")
        {
          upAnchor = elements[i];
          upAnchor.onclick = top.frames[1].upNodeClickedEvent;
        }
      else if (elements[i].id == "nav_next")
        {
          nextAnchor = elements[i];
          nextAnchor.onclick = top.frames[1].nextNodeClickedEvent;
        }
    }
  initialised = true;
}
