// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// test2
// A CTL application that creates a task which is scheduled when a button is pressed.
// This illustrates the use of an event set between an ISR and a task

#include <string.h>
#include <ctl_api.h>

#define CALLSTACKSIZE 16 // this is only required for AVR builds
#define STACKSIZE 64
unsigned otherStack[1+STACKSIZE+1];

CTL_TASK_t mainTask, otherTask;
unsigned e1=0;

unsigned count = 0;
unsigned count2 = 0;

void 
buttonPressedISR(void)
{
  count++;
  ctl_events_set_clear(&e1, 1, 0);
}
          
void 
other(void *p)
{
  unsigned leds = 0;
  while (1)
    {
      ctl_events_wait(CTL_EVENT_WAIT_ALL_EVENTS, &e1, 1, 1, ctl_get_current_time()+ctl_get_ticks_per_second());  
      ctl_events_set_clear(&e1, 0, 1);
      leds ^= 0xFFFFFFFF;
      ctl_board_set_leds(leds);
    }
}

void
ctl_handle_error(CTL_ERROR_CODE_t e)
{
  while (1);
}

int main(void)
{
  ctl_board_init();
  ctl_task_init(&mainTask, 255, "main");
  ctl_start_timer(ctl_increment_tick_from_isr);
  ctl_board_on_button_pressed(buttonPressedISR);
  memset(otherStack, 0xcd, sizeof(otherStack));
  otherStack[0]=otherStack[1+STACKSIZE]=0xfacefeed;
  ctl_task_run(&otherTask, 1, other, 0, "other", STACKSIZE, otherStack+1, CALLSTACKSIZE);
  ctl_task_set_priority(&mainTask, 0);
  while (1)
    {
      ;
    }
}
