// CrossWorks Tasking Library.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef CrossWorks_Tasking_Library_Private
#define CrossWorks_Tasking_Library_Private

#ifdef __cplusplus
extern "C" {
#endif

// sets the task stack so that entrypoint will execute with parameter and will return to exitpoint
void 
ctl_private_init_registers(CTL_TASK_t *t, 
                           void (*entrypoint)(void *),
                           void *parameter,                                                                                    
                           void (*exitpoint)(void)
#ifdef CTL_TWO_STACKS
                           ,unsigned *call_stack);
#else
                           );
#endif

// save current context to save and start running in restore context
void 
ctl_private_switch_context(CTL_TASK_t *save, 
                           CTL_TASK_t *restore);

// save current context to save and start running in restore context
void 
ctl_private_switch_isr_context(void *savedRegisters, 
                               CTL_TASK_t *save, 
                               CTL_TASK_t *restore);

// return from ISR
void 
ctl_private_isr_return(void *savedRegisters);

// reschedule assuming interrupts are disabled
void
ctl_private_reschedule(void);

#ifdef __cplusplus
}
#endif

#endif
