// time.h
//
// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __time_H
#define __time_H

#include "__crossworks.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __SIZE_T_DEFINED
#define __SIZE_T_DEFINED
typedef __SIZE_T size_t;
#endif

typedef long clock_t;
typedef long time_t;

struct tm 
{
  int tm_sec;     /* seconds after the minute - [0,59] */
  int tm_min;     /* minutes after the hour - [0,59] */
  int tm_hour;    /* hours since midnight - [0,23] */
  int tm_mday;    /* day of the month - [1,31] */
  int tm_mon;     /* months since January - [0,11] */
  int tm_year;    /* years since 1900 */
  int tm_wday;    /* days since Sunday - [0,6] */
  int tm_yday;    /* days since January 1 - [0,365] */
  int tm_isdst;   /* daylight savings time flag */
};

clock_t clock(void);
time_t time(time_t *tp);
double difftime(time_t time2, time_t time1);
time_t mktime(struct tm *tp);
char *asctime(const struct tm *tp);
char *asctime_r(const struct tm *tp, char *buf);
char *ctime(const time_t *tp);
char *ctime_r(const time_t *tp, char *buf);
struct tm *gmtime(const time_t *tp);
struct tm *gmtime_r(const time_t *tp, struct tm *result);
struct tm *localtime(const time_t *tp);
struct tm *localtime_r(const time_t *tp, struct tm *result);
size_t strftime(char *s, size_t smax, const char *fmt, const struct tm *tp);

#ifdef __cplusplus
}
#endif

#endif
