// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 Generic Timer Interrupt Example
//
// Description
// -----------
// This example demonstrates an interrupt handler and setting up a timer.
//
////////////////////////////////////////////////////////////////////////////////

#include <ctl_api.h>

static int count;
static int onNotOff;

void
onTimer(void)
{ 
  count++;
  if (count == ctl_get_ticks_per_second())
    {
      onNotOff = !onNotOff;
      count = 0;
    }
  ctl_board_set_leds(onNotOff);
}

int
main(void)
{
  int v = 0;

  ctl_board_init();
  ctl_start_timer(onTimer);
  ctl_global_interrupts_enable();

  while(1)
    v++;
  
  return 0;
}
