// Rowley C Compiler, runtime support.
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __setjmp_h
#define __setjmp_h

#ifdef __cplusplus
extern "C" {
#endif

#if defined(__CROSSWORKS_AVR)
#if __AVR_FLASH_SIZE > 128
typedef unsigned char jmp_buf[25];  // R2-R19, R28-R29, PC, SP: 8M devices
#else
typedef unsigned char jmp_buf[24];  // R2-R19, R28-R29, PC, SP: 8K-128K devices 
#endif
#elif defined(__CROSSWORKS_MSP430)
typedef unsigned jmp_buf[10];       // R4-R11, PC, SP
#elif defined(__CROSSWORKS_MAXQ)
typedef unsigned jmp_buf[14];       // A[0]-A[3], A[8]-A[15], SP, PC
#elif defined(__CROSSWORKS_MAXQ30)
typedef unsigned jmp_buf[14];       // A[0]-A[3], A[8]-A[15], SP, PC
#elif defined(__GNUC__)
typedef unsigned jmp_buf[11];       // R4-R14
#endif

int setjmp(jmp_buf env);
void longjmp(jmp_buf env, int val);

#ifdef __cplusplus
}
#endif

#endif
