// locale.h
//
// Copyright (c) 2007 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __locale_H
#define __locale_H

#include "__crossworks.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef NULL
#define NULL 0
#endif

#define LC_ALL 0
#define LC_COLLATE 1
#define LC_CTYPE 2
#define LC_MESSAGES 3
#define LC_MONETARY 4
#define LC_NUMERIC 5
#define LC_TIME 6

struct lconv
{
  char *currency_symbol;
  char *decimal_point;
  char frac_digits;
  char *grouping;
  char *int_curr_symbol;
  char int_frac_digits;
  char *mon_decimal_point;
  char *mon_grouping;
  char *mon_thousands_sep;
  char *negative_sign;
  char n_cs_precedes;
  char n_sep_by_space;
  char n_sign_posn;
  char *positive_sign;
  char p_cs_precedes;
  char p_sep_by_space;
  char p_sign_posn;
  char *thousands_sep;
};

struct lconv *localeconv(void);
char *setlocale(int, const char *);

#ifdef __cplusplus
}
#endif

#endif
