// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// test7
// A CTL application that creates two tasks of the same priority and sets the timeslice period
// to illustrate time slicing

#include <string.h>
#include <ctl_api.h>

CTL_TASK_t mainTask,other1Task,other2Task;
int other1count, other2count;

#define CALLSTACKSIZE 16 // this is only required for AVR builds
#define STACKSIZE 64
unsigned other1Stack[1+STACKSIZE+1], other2Stack[1+STACKSIZE+1]; // allocate 1 word before and after to aid debugging stack space problems

void 
other1(void *p)
{
  while (1)
    {
      other1count++;          
      ctl_board_set_leds(0);
    }  
}

void 
other2(void *p)
{
  while (1)
    {
      other2count++;   
      ctl_board_set_leds(0xFFFFFFFF);        
    }  
}

void
ctl_handle_error(CTL_ERROR_CODE_t e)
{
  while (1);
}

int
main(void)
{  
  ctl_board_init();  
  ctl_task_init(&mainTask, 255, "main");
  ctl_start_timer(ctl_increment_tick_from_isr);
  ctl_timeslice_period = ctl_get_ticks_per_second();  
  memset(other1Stack, 0xcd, sizeof(other1Stack));
  memset(other2Stack, 0xcd, sizeof(other2Stack));
  other1Stack[0]=other1Stack[1+STACKSIZE]=other2Stack[0]=other2Stack[1+STACKSIZE]=0xfacefeed;
  ctl_task_run(&other1Task, 1, other1, 0, "other1", STACKSIZE, other1Stack+1, CALLSTACKSIZE);
  ctl_task_run(&other2Task, 1, other2, 0, "other2", STACKSIZE, other2Stack+1, CALLSTACKSIZE);
  ctl_task_set_priority(&mainTask, 0);
  while (1)
    {
      ;
    }
}
