/*****************************************************************************
 * Copyright (c) 2006 Rowley Associates Limited.                             *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

#ifndef libmem_loader_h
#define libmem_loader_h

/*! \brief Start up a libmem loader that uses direct remote procedure calls.
 *
 *  This form of loader should run on all ARM targets.
 *
 *  \param comm_buffer_start A pointer to the start of an area of RAM that can
 *                           be used by the host to store data passed to
 *                           the remotely called libmem functions.
 *
 *  \param comm_buffer_end   A pointer to the last byte of the of an area of
 *                           RAM that can be used by the host to store data
 *                           passed to the remotely called libmem functions.
 */
void libmem_rpc_loader_start(void *comm_buffer_start, void *comm_buffer_end);

/*! \brief Start up a libmem loader that uses remote procedure calls via the
 *         ARM's debug comms channel.
 *
 *  This form of loader will only run on ARM7 and ARM9s with the debug comms
 *  channel. It offers some performance advantage over the direct RPC loader.
 *
 *  \param comm_buffer_start A pointer to the start of an area of RAM that can
 *                           be used by the host to store data passed to
 *                           the remotely called libmem functions.
 *
 *  \param comm_buffer_end   A pointer to the last byte of the of an area of
 *                           RAM that can be used by the host to store data
 *                           passed to the remotely called libmem functions.
 */
void libmem_dcc_rpc_loader_start(void *comm_buffer_start, void *comm_buffer_end);


typedef int (*libmem_dcc_loader_set_param_fn_t)(unsigned int parameter, unsigned int value);

/*! \brief Start up a libmem loader that uses the "Comms Channel Loader" protocol.
 *
 *  This form of loader will only run on ARM7 and ARM9s with the debug comms
 *  channel. 
 *
 *  \param set_param_fn  A pointer to the function to call when a loader set parameter
 *                       message is received or NULL if not required.
 */

void libmem_dcc_loader_start(libmem_dcc_loader_set_param_fn_t set_param_fn);


#define LIBMEM_RPC_LOADER_MAGIC_NUMBER 0x76E9C416


#endif

