/*****************************************************************************
 * Copyright (c) 2006 Rowley Associates Limited.                             *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

#ifndef APP_ENTRY_POINT
#define APP_ENTRY_POINT main
#endif

  .global reset_handler

  .section .init, "ax"
  .code 16
  .align 2
  .thumb_func

reset_handler:
  /* Initialise the stack pointer */
  ldr r0, =__stack_end__
  mov sp, r0

  /* Copy from initialised data section to data section (if necessary). */
  ldr r0, =__data_load_start__
  ldr r1, =__data_start__
  cmp r0, r1
  beq copy_data_end
  
  ldr r2, =__data_end__
  sub r2, r2, r1
  beq copy_data_end

copy_data_loop:
  ldrb r3, [r0]
  add r0, #1
  strb r3, [r1]
  add r1, #1
  sub r2, r2, #1
  bne copy_data_loop
copy_data_end:  

  /* Zero the bss. */
  ldr r0, =__bss_start__
  ldr r1, =__bss_end__
  mov r2, #0
zero_bss_loop:
  cmp r0, r1
  beq zero_bss_end
  strb r2, [r0]
  add r0, #1
  b zero_bss_loop
zero_bss_end:    

  /* Call constructors */
  ldr r0, =__ctors_start__
  ldr r1, =__ctors_end__
ctor_loop:
  cmp r0, r1
  beq ctor_end
  ldr r2, [r0]
  add r0, #4
  push {r0-r1}
  mov lr, pc
  bx r2
  pop {r0-r1}
  b ctor_loop
ctor_end:

  /* Setup initial call frame */
  mov r0, #0
  mov lr, r0
  mov r12, sp

start:
  /* Jump to application entry point */
  mov r0, #0
  mov r1, #0
  ldr r2, =APP_ENTRY_POINT
  blx r2

  /* Call destructors */
  ldr r0, =__dtors_start__
  ldr r1, =__dtors_end__
dtor_loop:
  cmp r0, r1
  beq dtor_end
  ldr r2, [r0]
  add r0, #4
  push {r0-r1}
  mov lr, pc
  bx r2
  pop {r0-r1}
  b dtor_loop
dtor_end:

  /* Returned from application entry point, loop forever. */
exit_loop:
  b exit_loop

