/*****************************************************************************
 * FLASH Loader for iSYSTEM ITPXA250 (Toshiba TC58FVB800)                    *
 *                                                                           *
 * Copyright (c) 2004 Rowley Associates Limited.                             *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

#include <libmem.h>
#include <libmem_loader.h>

extern void __comm_buffer_start__, __comm_buffer_end__;

int
main(void)
{
  const int flash1_max_geometry_regions = 4;
  libmem_driver_handle_t ram_handle, flash1_handle;
  libmem_geometry_t flash1_geometry[] =
    {
       1, 0x00004000,
       2, 0x00002000,
       1, 0x00008000,
      15, 0x00010000,
    };

  /* Register FLASH driver */
  libmem_register_cfi_0002_16_driver(&flash1_handle, (unsigned char *)0x00100000, 0x00100000, flash1_geometry, 0);

  /* Run the loader */
  libmem_rpc_loader_start(&__comm_buffer_start__, &__comm_buffer_end__ - 1);

  return 0;
}

