/*****************************************************************************
 * FLASH loader for an STR73x.                                               *
 *                                                                           *
 * Copyright (c) 2005 Rowley Associates Limited.                             *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

#include <libmem.h>
#include <libmem_loader.h>
#include <targets/STR73x.h>

static int
loader_set_param(unsigned int parameter, unsigned int value)
{
  return 1;
}

int
main(void)
{
  libmem_driver_handle_t str73x_libmem_driver_handle;

  /* Register FLASH drivers */
  libstr73x_register_libmem_driver(&str73x_libmem_driver_handle);

  /* Run the loader */
  libmem_dcc_loader_start(loader_set_param);

  return 0;
} 

