/*****************************************************************************
 * Copyright (c) 2005 Rowley Associates Limited.                             *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

  .section .vectors, "ax"
  .code 32
  .align 0
  .global _vectors
  .global reset_handler
  
/*****************************************************************************
 * Exception Vectors                                                         *
 *****************************************************************************/
_vectors:
  ldr pc, [pc, #reset_handler_address - . - 8]  /* reset */
  ldr pc, [pc, #undef_handler_address - . - 8]  /* undefined instruction */
  ldr pc, [pc, #swi_handler_address - . - 8]    /* swi handler */
  ldr pc, [pc, #pabort_handler_address - . - 8] /* abort prefetch */
  ldr pc, [pc, #dabort_handler_address - . - 8] /* abort data */
  nop
  ldr pc, [pc, #irq_handler_address - . - 8]    /* irq */
  ldr pc, [pc, #fiq_handler_address - . - 8]    /* fiq */

reset_handler_address:
  .word reset_handler
undef_handler_address:
  .word undef_handler
swi_handler_address:
  .word swi_handler
pabort_handler_address:
  .word pabort_handler
dabort_handler_address:
  .word dabort_handler
irq_handler_address:
  .word irq_handler
fiq_handler_address:
  .word fiq_handler

  .section .init, "ax"
  .code 32
  .align 0

#ifndef PROCESSOR_CLOCK_FREQUENCY
#define PROCESSOR_CLOCK_FREQUENCY 24000000
#endif

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 *                                                                            *
 ******************************************************************************/
reset_handler:
#ifdef __FLASH_BUILD
  /* Copy exception vectors into RAM */
  mov r8, #0xa0000000
  ldr r9, =_vectors
  ldmia r9!, {r0-r7}
  stmia r8!, {r0-r7}
  ldmia r9!, {r0-r6}
  stmia r8!, {r0-r6}     
#endif

  // Enable access to CMU
  LDR r0, =0xFFFFF600
  LDR r1, =0x50FA
  STRH r1, [r0, #0x24] // CMU_WE = 0x50FA  
  LDR r1, =0xAF05
  STRH r1, [r0, #0x24] // CMU_WE = 0xAF05

  LDR r1, =0x07
  STRH r1, [r0, #0x10] // CMU_CTRL = 0x07 - select main oscillator and PLL as clock sources

  // Disable access to CMU
  LDR r1, =0
  STR r1, [r0, #0x24] // CMU_WE = 0x00

  // Switch on the PLL
  LDR r0, =0x60000000
#if OSCILLATOR_CLOCK_FREQUENCY==8000000  
#if PROCESSOR_CLOCK_FREQUENCY==24000000
  LDR r1, =((1<<6)|(1<<4)|(1<<0))  // PRCCU_PLLCR = FREF_RANGE|MX=CLK2*12|DX=PLLCK/2 = 8/2*12/2=24Mhz
#elif PROCESSOR_CLOCK_FREQUENCY==32000000
  LDR r1, =((1<<6)|(3<<4)|(1<<0))  // PRCCU_PLLCR = FREF_RANGE|MX=CLK2*16|DX=PLLCK/2 = 8/2*16/2=32Mhz
#endif
#else
#error OSCILLATOR_CLOCK_FREQUENCY not defined
#endif
  STR r1, [r0, #0x18] 

  LDR r1, =((1<<15)|(1<<3)|(1<<0)) // PRCCU_CFR = DIV2 | CK2_16 | CSU_CKSEL
  STR r1, [r0, #0x08] 
1:
  ldr r1, [r0, #0x8]
  tst r1, #0x0002
  beq 1b /* Wait for PLL to lock */

  // set up the internal RAM at 0x0
  LDR r0, =0x40000000
  LDR r1, [r0]
  ORR r1, r1, #1
  STR r1, [r0, #0x00]      

  /* Jump to the default C runtime startup code. */
  b _start

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 * These are declared weak symbols so they can be redefined in user code.     * 
 *                                                                            *
 ******************************************************************************/

undef_handler:
  b undef_handler
  
swi_handler:
  b swi_handler
  
pabort_handler:
  b pabort_handler
  
dabort_handler:
  b dabort_handler
  
irq_handler:
  b irq_handler
  
fiq_handler:
  b fiq_handler

  .weak undef_handler, swi_handler, pabort_handler, dabort_handler, irq_handler, fiq_handler
