// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <ctl_api.h>
#include <targets/STR73x.h>

#define LEDS (0xFFFF)

void
ctl_board_init(void)
{
  // Leds are on PORT4
  CFG_PCGR0 |= CFG_PCGR0_PORT4_MASK;
  IOPORT4_PC0 |= LEDS;
  IOPORT4_PC1 &= ~LEDS;
  IOPORT4_PC2 |= LEDS;
  IOPORT4_PD  &= ~LEDS;
}

void ctl_board_set_leds(unsigned v)
{
  if (v)
    IOPORT4_PD |= LEDS;
  else
    IOPORT4_PD &= ~LEDS;
}

static CTL_ISR_FN_t userButtonISR;

static void
buttonISR(void)
{
  unsigned int x;
  userButtonISR();
}

void 
ctl_board_on_button_pressed(CTL_ISR_FN_t isr)
{
  // SEL Button is on PORT5
  CFG_PCGR0 |= CFG_PCGR0_EIC_MASK | CFG_PCGR0_PORT5_MASK;
  IOPORT5_PC0 |= (1<<10);
  IOPORT5_PC1 &= ~(1<<10);
  IOPORT5_PC2 &= ~(1<<10);

  // Enable external interrupt source 8 on rising edge
  CFG_EITE0 |= (1<<8);
  CFG_EITE1 &= ~(1<<8);
  CFG_EITE2 |= (1<<8);

  userButtonISR = isr;
  ctl_set_isr(8, 1, CTL_ISR_TRIGGER_FIXED, buttonISR, 0);
  ctl_unmask_isr(8);
}

