/******************************************************************************
  Target Script for LPD SDKLH79520_10.

  Copyright (c) 2005 Rowley Associates Limited.

  This file may be distributed under the terms of the License Agreement
  provided with this software.

  THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ******************************************************************************/

function Reset()
{
  TargetInterface.trst();
  TargetInterface.beginDebugAccess();
  /* Perform a soft reset of the target */
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  TargetInterface.pokeWord(0xFFFE200C, 0xDEAD);
  TargetInterface.endDebugAccess(true);
  TargetInterface.waitForDebugState(1000);
  TargetInterface.trst();
}

function RAMReset()
{
  Reset();
  TargetInterface.pokeWord(0xFFFE2008, 2); /* RCPCRemapCtrl: Locate internal static memory at 0x00000000 */
}

function FLASHReset()
{
  Reset();
  TargetInterface.pokeWord(0xFFFE2008, 0); /* RCPCRemapCtrl: Locate external static memory at 0x00000000 */
}

