// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <ctl_api.h>
#include <targets/LH754xx.h>

#define TIMER0_INT 4

static CTL_ISR_FN_t userTimerISR;

static void
timerISR(void)
{
  userTimerISR();
  /* Clear the timer 0 interrupt */
  Timer0_STATUS = 1;
}

void
ctl_start_timer(CTL_ISR_FN_t isr)
{
  /* Interrupt on timer 0 overflow */
  Timer0_INT_CTRL = 1;
  /* Start timer 0 */
  Timer0_CTRL = 2;
  userTimerISR = isr;
  ctl_set_isr(TIMER0_INT, 0, CTL_ISR_TRIGGER_FIXED, timerISR, 0);
  ctl_unmask_isr(TIMER0_INT);
}

unsigned long
ctl_get_ticks_per_second(void)
{
  return 1000;
}