// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <ctl_api.h>
#include <targets/MC9328MXL.h>

#define LEDS ((1 << 2) | (1 << 23))

#define GPIO_INT_PORTC 13

void
ctl_board_init(void)
{  
  /* Initialise LED */
  GPIO_DDIR_A |= LEDS;
  GPIO_GIUS_A |= 1 << 2;
  GPIO_OCR1_A |= 3 << 4;
  GPIO_OCR2_A |= 3 << 14;
}

static CTL_ISR_FN_t userButtonISR;
static void
buttonISR(void)
{
  userButtonISR();
  GPIO_ISR_C = GPIO_ISR_C;
}

void
ctl_board_on_button_pressed(CTL_ISR_FN_t isr)
{
  userButtonISR = isr;

  /* Configure GPIO port C pin 13 as GPIO input */    
  GPIO_GIUS_C |= 1 << 13;
  GPIO_GPR_C |= 1 << 13;
  GPIO_DDIR_C &= ~(1 << 13);

  /* Positive edge sensitive interrupt */
  GPIO_ICR1_C &= ~(3 << 26);

  /* Unmask GPIO interrupt */
  GPIO_IMR_C |= 1 << 13;

  ctl_set_isr(GPIO_INT_PORTC, 0, CTL_ISR_TRIGGER_LOW_LEVEL, buttonISR, 0);
  ctl_unmask_isr(GPIO_INT_PORTC);
}

void
ctl_board_set_leds(unsigned v)
{
  if (v)
    GPIO_DR_A |= LEDS;
  else
    GPIO_DR_A &= ~LEDS;
}
