/*****************************************************************************
 * FLASH loader for Cogent CSB637.                                            *
 *                                                                           *
 * Copyright (c) 2005 Rowley Associates Limited.                             *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

#include <libmem.h>
#include <libmem_loader.h>

int
main(void)
{
  const int flash1_max_geometry_regions = 4;
  libmem_driver_handle_t ram_handle, flash1_handle;
  libmem_geometry_t flash1_geometry[flash1_max_geometry_regions];
  libmem_flash_info_t flash1_info;
  
  /* Register a RAM driver that covers the entire memory range, as this has 
     been registered first it will only be used if memory range is not covered
     by another driver. */     
  libmem_register_ram_driver(&ram_handle, (unsigned char *)0x00000000, 0);

  /* Register FLASH driver */
  // libmem_register_cfi_driver(&flash1_handle, (unsigned char *)0x10000000, flash1_geometry, flash1_max_geometry_regions, &flash1_info);

  /* Run the loader */
  libmem_dcc_loader_start(0);

  return 0;
} 

