/*****************************************************************************
 * FLASH loader for EB40A                                                    *
 *                                                                           *
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/
                                                  
#include <libmem.h>
#include <libmem_loader.h>

int
main(void)
{
  libmem_driver_handle_t flash1_handle;
  unsigned char *flash1_start = (unsigned char *)0x01000000;
  libmem_flash_info_t flash1_info;

  libmem_geometry_t flash1_geometry[] =
    {
      { 8, 0x00002000 },
      { 31, 0x00010000 },
      { 0, 0 },
    };

  libmem_register_cfi_0002_16_driver(&flash1_handle, (unsigned char *)flash1_start, libmem_get_geometry_size(flash1_geometry), flash1_geometry, 0);

  /* Run the loader */
  libmem_dcc_loader_start(0);

  return 0;
}

