/******************************************************************************
  Target Script for Atmel EB40A

  Copyright (c) 2005 Rowley Associates Limited.

  This file may be distributed under the terms of the License Agreement
  provided with this software.

  THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ******************************************************************************/

WD_WDCLKS_MCK8 = 0;
WD_WDCLKS_MCK32 = 1;
WD_WDCLKS_MCK128 = 2;
WD_WDCLKS_MCK1024 = 3;

function EB40A_Reset()
{
  // Get the target interface into debug state for the peeks and pokes
  TargetInterface.beginDebugAccess();

  // Set a breakpoint on reset vector
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0x00000000, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);

  // Disable watchdog
  TargetInterface.pokeWord(0xFFFF8000, 0x2340); // WD_OMR
  // Initialize the WD Clock Mode Register - By default the maximum watchdog MCK 
  // divider is used (MCK/1024), if your target has a particularly slow clock
  // you may need to reduce the WDCLKS watchdog MCK divider so that the target
  // will reset within a reasonable time.
  TargetInterface.pokeWord(0xFFFF8004, 0x373C | WD_WDCLKS_MCK1024); // WD_CMR
  // Restart the timer
  TargetInterface.pokeWord(0xFFFF8008, 0xC071); // WD_CR
  // Enable the watchdog and internal reset generation
  TargetInterface.pokeWord(0xFFFF8000, 0x2343); // WD_OMR
  // Release target from debug state.
  TargetInterface.endDebugAccess(true);

  // Wait for CPU to reset and hit the breakpoint
  TargetInterface.waitForDebugState(5000);

  // Reset the Embedded ICE macrocell
  TargetInterface.trst();

  // Disable the watchdog
  TargetInterface.pokeWord(0xFFFF8000, 0x2340); // WD_OMR
}

function EB40A_ResetWithRamAtZero()
{
  EB40A_Reset();
  TargetInterface.pokeWord(0xFFE00000, 0x1002539);
  TargetInterface.pokeWord(0xFFE00024, 6);
  // Cancel remapping, put SRAM at zero.
  TargetInterface.pokeWord(0xFFE00020, 1);
}

function EB40A_ResetWithFlashAtZero()
{
  EB40A_Reset();
}

