// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <ctl_api.h>
#include <targets/AT91x408xx.h>

#define FIQ_INT   0       /* Fast Interrupt */
#define SWIRQ_INT 1       /* Soft Interrupt (generated by the AIC) */
#define US0_INT   2       /* USART Channel 0 interrupt */
#define US1_INT   3       /* USART Channel 1 interrupt */
#define TC0_INT   4       /* Timer Channel 0 interrupt */
#define TC1_INT   5       /* Timer Channel 1 interrupt */
#define TC2_INT   6       /* Timer Channel 2 interrupt */
#define WDI_INT   7       /* Watchdog interrupt */
#define PIO_INT   8       /* Parallel I/O Controller A interrupt */
#define IRQ0_INT  16      /* External interrupt 0 */
#define IRQ1_INT  17      /* External interrupt 1 */
#define IRQ2_INT  18      /* External interrupt 2 */

#define TC_CLKEN            0x1
#define TC_CLKDIS           0x2
#define TC_SWTRG            0x4

#define TC_CPCTRG (1 << 14)

#define TC_CLKS                  0x7
#define TC_CLKS_MCK2             0x0
#define TC_CLKS_MCK8             0x1
#define TC_CLKS_MCK32            0x2
#define TC_CLKS_MCK128           0x3
#define TC_CLKS_MCK1024          0x4

#define TC_CLKS_SLCK             0x4

#define TC_CLKS_XC0              0x5
#define TC_CLKS_XC1              0x6
#define TC_CLKS_XC2              0x7

#define TC_COVFS            0x1         /* Counter Overflow Status */
#define TC_LOVRS            0x2         /* Load Overrun Status */
#define TC_CPAS             0x4         /* RA Compare Status */
#define TC_CPBS             0x8         /* RB Compare Status */
#define TC_CPCS             0x10        /* RC Compare Status */
#define TC_LDRAS            0x20        /* RA Loading Status */
#define TC_LDRBS            0x40        /* RB Loading Status */
#define TC_ETRGS            0x80        /* External Trigger Status */
#define TC_CLKSTA           0x10000     /* Clock Status */
#define TC_MTIOA            0x20000     /* TIOA Mirror */
#define TC_MTIOB            0x40000     /* TIOB Status */

static CTL_ISR_FN_t userTimerISR;

static void
timerISR(void)
{
  userTimerISR();
  /* Clear the timer interrupt */
  unsigned x = TC0_SR;
}

void
ctl_start_timer(CTL_ISR_FN_t isr)
{
  TC0_CCR = TC_CLKDIS;
  TC0_IDR = 0xFFFFFFFF;
  TC0_CMR = TC_CLKS_MCK128 | TC_CPCTRG;
  TC0_RC = MCKFrequency() / 128 / ctl_get_ticks_per_second();
  TC0_IER = TC_CPCS;
  TC0_CCR = TC_CLKEN | TC_SWTRG;
  userTimerISR = isr;
  ctl_set_isr(TC0_INT, 1, CTL_ISR_TRIGGER_LOW_LEVEL, timerISR, 0);
  ctl_unmask_isr(TC0_INT);
}

