/*****************************************************************************
 * Loader for Evaluator-7T                                                   *
 *                                                                           *
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

#include <targets/S3C4510B.h>
#include <libmem.h>
#include <libmem_loader.h>

int
main(void)
{
  libmem_driver_handle_t flash1_handle;
  unsigned char *flash1_start = (unsigned char *)((ROMCON0 & 0x000FFC00) << 6);
  libmem_flash_info_t flash1_info;
  const int flash1_max_geometry_regions = 4;
  libmem_geometry_t flash1_geometry[flash1_max_geometry_regions];
  size_t size;

  /* Get CFI FLASH information and geometry */
  libmem_cfi_get_info(flash1_start, &size, flash1_geometry, flash1_max_geometry_regions, &flash1_info);

  /* Register FLASH driver */
  libmem_register_sst39xFx00A_16_driver(&flash1_handle, flash1_start, size, flash1_geometry, &flash1_info);

  /* Run the loader */
  libmem_dcc_loader_start(0);

  return 0;
}

