/*****************************************************************************
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/
  .section .vectors, "ax"
  .code 32
  .align 0
  .global _vectors

#ifdef __FLASH_BUILD

/*****************************************************************************
 * Exception Vectors (Prior to remap)                                        *
 *****************************************************************************/
  b reset_handler 
  b undef_handler
  b swi_handler
  b pabort_handler
  b dabort_handler
  .word 0 
  b irq_handler
  b fiq_handler

#endif

/*****************************************************************************
 * Exception Vectors                                                         *
 *****************************************************************************/
_vectors:
  ldr pc, [pc, #reset_handler_address - . - 8] /* reset */
  ldr pc, [pc, #undef_handler_address - . - 8] /* undefined instruction */
  ldr pc, [pc, #swi_handler_address - . - 8] /* swi handler */
  ldr pc, [pc, #pabort_handler_address - . - 8] /* abort prefetch */
  ldr pc, [pc, #dabort_handler_address - . - 8] /* abort data */
  nop
  ldr pc, [pc, #irq_handler_address - . - 8]
  ldr pc, [pc, #fiq_handler_address - . - 8]

reset_handler_address:
  .word reset_handler
undef_handler_address:
  .word undef_handler
swi_handler_address:
  .word swi_handler
pabort_handler_address:
  .word pabort_handler
dabort_handler_address:
  .word dabort_handler
irq_handler_address:
  .word irq_handler
fiq_handler_address:
  .word fiq_handler

  .section .init, "ax"
  .code 32
  .align 0

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 *                                                                            *
 ******************************************************************************/

reset_handler:
#ifdef __FLASH_BUILD
  ldr r0, SYSCFG
  ldr r1, SYSCFG_val
  str r1, [r0]

  ldr lr, =copy_vectors
  sub r0, pc, #(+.-memory_configuration+8)
  ldmia r0, {r0-r12}
  stmia r0, {r1-r12}
  mov pc, lr

copy_vectors:
  /* Copy exception vectors into RAM */
  mov r8, #0x00000000
  ldr r9, =_vectors
  ldmia r9!, {r0-r7}
  stmia r8!, {r0-r7}
  ldmia r9!, {r0-r6}
  stmia r8!, {r0-r6}     
#endif /* __FLASH_BUILD */
  
  b _start

#ifdef __FLASH_BUILD
/*****************************************************************************
 * Register settings for the following memory configuration:                 *
 *                                                                           *
 *                     ----------------------                                *
 *                    | ROMCON0 - 512K FLASH | 0x01800000 - 0x0187FFFF       *
 *                    |----------------------|                               *
 *                    | ROMCON2 - 256K SRAM  | 0x00040000 - 0x0007FFFF       *
 *                    |----------------------|                               *
 *                    | ROMCON1 - 256K SRAM  | 0x00000000 - 0x0003FFFF       *
 *                     ----------------------                                *
 *                                                                           *
 *****************************************************************************/
memory_configuration:
  .word 0x03FF3010 // &EXTDBWIDTH
  .word 0x0000003E // EXTDBWIDTH
  .word 0x18860030 // ROMCON0
  .word 0x00400010 // ROMCON1
  .word 0x00801010 // ROMCON2
  .word 0x08018020 // ROMCON3
  .word 0x0A020040 // ROMCON4
  .word 0x0C028040 // ROMCON5
  .word 0x00000000 // DRAMCON0
  .word 0x00000000 // DRAMCON1
  .word 0x00000000 // DRAMCON2
  .word 0x00000000 // DRAMCON3
  .word 0x9C218360 // REFEXTCON
SYSCFG:
  .word 0x03FF0000 // &SYSCFG
SYSCFG_val:
  .word 0x03FFFFA0 // SYSCFG
#endif /* __FLASH_BUILD */

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 * These are declared weak symbols so they can be redefined in user code.     * 
 *                                                                            *
 ******************************************************************************/

undef_handler:
  b undef_handler
  
swi_handler:
  b swi_handler
  
pabort_handler:
  b pabort_handler
  
dabort_handler:
  b dabort_handler
  
irq_handler:
  b irq_handler
  
fiq_handler:
  b fiq_handler

  .weak undef_handler, swi_handler, pabort_handler, dabort_handler, irq_handler, fiq_handler
                                                    

                  
