// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <ctl_api.h>
#include <targets/S3C4510B.h>

#define IO_RISING_EDGE_INT0	(1 << 0)
#define IO_ENABLE_INT0		(1 << 4)
#define IO_ACTIVE_HIGH_INT0	(1 << 3)

void
ctl_board_init(void)
{
  IOPMOD = 0x1FCF0;
}

void
ctl_board_on_button_pressed(CTL_ISR_FN_t isr)
{
  IOPCON |= IO_ENABLE_INT0;              // enable int0
  IOPCON |= IO_ACTIVE_HIGH_INT0;         // set as active high
  IOPCON |= IO_RISING_EDGE_INT0;         // allow for RISING EDGE  
  ctl_set_isr(0, 0, 0, isr, 0);
  ctl_unmask_isr(0);        
}

void
ctl_board_set_leds(unsigned v)
{
  if (v)
    IOPDATA = 0xFFFFFFFF;
  else
    IOPDATA = 0;
}

