// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//     Logic Product Development SDKLH79520-10  Timer Interrupt Example
//
// Description
// -----------
// This example demonstrates setting up interrupt handlers and timers.
//
////////////////////////////////////////////////////////////////////////////////

#include <__armlib.h>
#include <targets/LH79520.h>

#define TIMER0_INT 17
#define TIMER1_INT 18

#define EXTENDED_GPIO_REG *((volatile unsigned char *)0x55600000)

static int timer0Count, timer1Count;

static void timer0ISR(void) __attribute__ ((interrupt ("IRQ")));

static void
timer0ISR(void)
{
  if (++timer0Count % 2)
    EXTENDED_GPIO_REG |= 1;
  else
    EXTENDED_GPIO_REG &= ~1;
  /* Clear the timer 0 interrupt */
  TIMER0Clear = 0;
  /* Update VIC priorities */
  VectorAddr = 0;
}

static void timer1ISR(void) __attribute__ ((interrupt ("IRQ")));

static
void
timer1ISR(void)
{
  if (++timer1Count % 2)
    EXTENDED_GPIO_REG |= 2;
  else
    EXTENDED_GPIO_REG &= ~2;
  /* Clear the timer 1 interrupt */
  TIMER1Clear = 0;
  /* Update VIC priorities */
  VectorAddr = 0;
}

int
main(void)
{
  /* Initialise LEDs */
  EXTENDED_GPIO_REG &= ~3;

  /* Write "ldr pc, [pc, #-0xFF0]" instruction to IRQ exception vector */
  *(volatile unsigned long *)(0x00000018) = 0xE51FFFF0; 

  /* Timer 0 interrupt is an IRQ interrupt */
  IntSelect &= ~(1 << TIMER0_INT);
  /* Enable timer 0 interrupt */
  IntEnable = 1 << TIMER0_INT;
  /* Use slot 0 for timer 0 interrupt */
  VectCntl0 = 0x20 | TIMER0_INT;
  /* Set the address of ISR for slot 0 */
  VectAddr0 = (unsigned int)timer0ISR;

  /* Timer 1 interrupt is an IRQ interrupt */
  IntSelect &= ~(1 << TIMER1_INT);
  /* Enable timer 1 interrupt */
  IntEnable = 1 << TIMER1_INT;
  /* Use slot 1 for timer 1 interrupt */
  VectCntl1 = 0x20 | TIMER1_INT;
  /* Set the address of ISR for slot 1 */
  VectAddr1 = (unsigned int)timer1ISR;

  /* Enable clock to timer 0 and 1 */
  PeriphClkCtrl &= ~0x10;

  /* Start timer 0, set clock division to 256 */
  TIMER0Control = 0x88;

  /* Start timer 1, set clock division to 16 */
  TIMER1Control = 0x84;

  /* Enable Interrupts */
  __ARMLIB_enableIRQ();
  
  while (timer0Count < 5 && timer1Count < 5);

  return 0; 
}
