// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                Freescale MC9328MXL Interrupt Example
///
// Description
// -----------
// This example demonstrates setting up interrupt handlers.
//
// On the M9328MXLADS board press the S17 button to raise an interrupt.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/MC9328MXL.h>
#include "../common/interrupt.h"

#define GPIO_INT_PORTC 13

#define LEDS ((1 << 2) | (1 << 23))

static int count = 0;

static void
gpio_portc_isr(void)
{
  unsigned long sr = GPIO_ISR_C;
  if (sr & 1 << 13)
    GPIO_DR_A ^= LEDS;
  GPIO_ISR_C = sr;
}

int
main(void)
{
  /* Initialise LED */
  GPIO_DDIR_A |= LEDS;
  GPIO_GIUS_A |= 1 << 2;
  GPIO_OCR1_A |= 3 << 4;
  GPIO_OCR2_A |= 3 << 14;

  /* Configure GPIO port C pin 13 as GPIO input */    
  GPIO_GIUS_C |= 1 << 13;
  GPIO_GPR_C |= 1 << 13;
  GPIO_DDIR_C &= ~(1 << 13);

  /* Positive edge sensitive interrupt */
  GPIO_ICR1_C &= ~(3 << 26);

  /* Unmask GPIO interrupt */
  GPIO_IMR_C |= 1 << 13;

  /* Initialise interrupt vectors */
  interrupt_init();

  /* Setup GPIO port C ISR */
  interrupt_set_isr(GPIO_INT_PORTC, gpio_portc_isr);
  interrupt_enable(GPIO_INT_PORTC, 0);

  while (count < 10);

  return 0; 
}
