// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                Freescale MC9328MXL Interrupt Function
//
// Description
// -----------
// This module contains functions for setting up interrupts on the 
// MC9328MXL.
//
////////////////////////////////////////////////////////////////////////////////

#ifndef interrupt_h
#define interrupt_h

typedef void (*isr_fn_t)(void);

void interrupt_init(void);

void interrupt_set_isr(int n, isr_fn_t fn);

void interrupt_enable(int n, int fiq);

void interrupt_disable(int n);

#endif

