// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 Analog ADuC7020 Timer Interrupt Example
//
// Description
// -----------
// This example demonstrates setting up interrupt handlers and timers.
//
////////////////////////////////////////////////////////////////////////////////

#include <ctl_api.h>
#include <targets/ADuC7020.h>

#define TIMER0_INT 2
#define TIMER1_INT 3

static int timer0Count, timer1Count;

static void
timer0ISR(void)
{
  if (++timer0Count % 2)
    ctl_board_set_leds(1);
  else
    ctl_board_set_leds(0);
  /* Clear the timer 0 interrupt */
  T0CLRI = 0;
}

static void
timer1ISR(void)
{
  ++timer1Count;
  T1CLRI = 0;
}

int
main(void)
{
  ctl_board_init();

  ctl_set_isr(TIMER0_INT, 0, CTL_ISR_TRIGGER_FIXED, timer0ISR, 0);
  ctl_unmask_isr(TIMER0_INT);

  ctl_set_isr(TIMER1_INT, 0, CTL_ISR_TRIGGER_FIXED, timer1ISR, 0);
  ctl_unmask_isr(TIMER1_INT);

  T0LD = 0;
  T0CON = 0x88; /* Timer 0 enable, free-running, core clock / 256 */

  T1LD = 0;
  T1CON = 0x88; /* Timer 1 enable, free-running, core clock / 256 */

  ctl_global_interrupts_enable();
  
  while (timer0Count < 5 || timer1Count < 5);

  return 0; 
}
