// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                    Analog ADuC7020 Interrupt Example
//
// Description
// -----------
// This example demonstrates setting up an interrupt handler.
//
////////////////////////////////////////////////////////////////////////////////

#include <ctl_api.h>
#include <targets/ADuC7020.h>

#define IRQ0_INT 15

static int count;

static void
buttonISR(void)
{
  if (count++ % 2)
    ctl_board_set_leds(1);
  else
    ctl_board_set_leds(0);    
}

int
main(void)
{
  ctl_board_init();
  ctl_set_isr(IRQ0_INT, 1, CTL_ISR_TRIGGER_FIXED, buttonISR, 0);
  ctl_unmask_isr(IRQ0_INT);
  ctl_global_interrupts_enable();
  return 0; 
}
