// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                ARM Evaluator-7T Timer Interrupt Example
//
// Description
// -----------
// This example demonstrates a simple interrupt handler and setting up a timer.
//
////////////////////////////////////////////////////////////////////////////////

#include <ctl_api.h>
#include <targets/S3C4510B.h>

static int count;

static void
timerISR(void)
{
  count++;
  ctl_board_set_leds(count&1);
}

int
main(void)
{
  ctl_board_init();
  TDATA1 = 5000000; // interrupt frequency
  TMOD = (1<<3)|(1<<4); // enable timer1 in interval mode
  ctl_set_isr(11, 1, 0, timerISR, 0);
  ctl_unmask_isr(11);
  ctl_global_interrupts_enable();
  return 0; 
}
