// STR73x register and bit definitions.
//
// Copyright (c) 2006 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef STR73x_h
#define STR73x_h

#define ARBTOR (*(volatile unsigned long *)0x20000000)
#define ARBTOR_TIMEOUT_MASK 0xFFFF
#define ARBTOR_TIMEOUT_BIT 0

#define ARBPRIOR (*(volatile unsigned long *)0x20000004)
#define ARBPRIOR_PRIORITY_MASK 0x3
#define ARBPRIOR_PRIORITY_BIT 0

#define ARBCTLR (*(volatile unsigned long *)0x20000008)
#define ARBCTLR_ABORT_MASK 0x2
#define ARBCTLR_ABORT 0x2
#define ARBCTLR_ABORT_BIT 1

#define CFG_R0 (*(volatile unsigned long *)0x40000000)
#define CFG_R0_REMAP_MASK 0x1
#define CFG_R0_REMAP 0x1
#define CFG_R0_REMAP_BIT 0
#define CFG_R0_DMABSPI0_MASK 0x10
#define CFG_R0_DMABSPI0 0x10
#define CFG_R0_DMABSPI0_BIT 4
#define CFG_R0_DMABSPI1_MASK 0x20
#define CFG_R0_DMABSPI1 0x20
#define CFG_R0_DMABSPI1_BIT 5
#define CFG_R0_JTBT_MASK 0x80
#define CFG_R0_JTBT 0x80
#define CFG_R0_JTBT_BIT 7
#define CFG_R0_USER2_MASK 0x100
#define CFG_R0_USER2 0x100
#define CFG_R0_USER2_BIT 8
#define CFG_R0_USER1_MASK 0x200
#define CFG_R0_USER1 0x200
#define CFG_R0_USER1_BIT 9
#define CFG_R0_BOOT_MASK 0x400
#define CFG_R0_BOOT 0x400
#define CFG_R0_BOOT_BIT 10
#define CFG_R0_T_MODE_MASK 0x800
#define CFG_R0_T_MODE 0x800
#define CFG_R0_T_MODE_BIT 11

#define CFG_EITE0 (*(volatile unsigned long *)0x40000004)
#define CFG_EITE0_EITE0_MASK 0xFFFF
#define CFG_EITE0_EITE0_BIT 0

#define CFG_PCGR0 (*(volatile unsigned long *)0x40000008)
#define CFG_PCGR0_RAM_MASK 0x1
#define CFG_PCGR0_RAM 0x1
#define CFG_PCGR0_RAM_BIT 0
#define CFG_PCGR0_I2C0_MASK 0x2
#define CFG_PCGR0_I2C0 0x2
#define CFG_PCGR0_I2C0_BIT 1
#define CFG_PCGR0_WIU_MASK 0x4
#define CFG_PCGR0_WIU 0x4
#define CFG_PCGR0_WIU_BIT 2
#define CFG_PCGR0_UART0_MASK 0x10
#define CFG_PCGR0_UART0 0x10
#define CFG_PCGR0_UART0_BIT 4
#define CFG_PCGR0_UART1_MASK 0x20
#define CFG_PCGR0_UART1 0x20
#define CFG_PCGR0_UART1_BIT 5
#define CFG_PCGR0_TIM0_MASK 0x40
#define CFG_PCGR0_TIM0 0x40
#define CFG_PCGR0_TIM0_BIT 6
#define CFG_PCGR0_TIM1_MASK 0x80
#define CFG_PCGR0_TIM1 0x80
#define CFG_PCGR0_TIM1_BIT 7
#define CFG_PCGR0_TB0_MASK 0x100
#define CFG_PCGR0_TB0 0x100
#define CFG_PCGR0_TB0_BIT 8
#define CFG_PCGR0_CAN0_MASK 0x400
#define CFG_PCGR0_CAN0 0x400
#define CFG_PCGR0_CAN0_BIT 10
#define CFG_PCGR0_CAN1_MASK 0x800
#define CFG_PCGR0_CAN1 0x800
#define CFG_PCGR0_CAN1_BIT 11
#define CFG_PCGR0_PWM0_MASK 0x1000
#define CFG_PCGR0_PWM0 0x1000
#define CFG_PCGR0_PWM0_BIT 12
#define CFG_PCGR0_PWM1_MASK 0x2000
#define CFG_PCGR0_PWM1 0x2000
#define CFG_PCGR0_PWM1_BIT 13
#define CFG_PCGR0_PWM2_MASK 0x4000
#define CFG_PCGR0_PWM2 0x4000
#define CFG_PCGR0_PWM2_BIT 14
#define CFG_PCGR0_PWM3_MASK 0x8000
#define CFG_PCGR0_PWM3 0x8000
#define CFG_PCGR0_PWM3_BIT 15
#define CFG_PCGR0_PWM4_MASK 0x10000
#define CFG_PCGR0_PWM4 0x10000
#define CFG_PCGR0_PWM4_BIT 16
#define CFG_PCGR0_PWM5_MASK 0x20000
#define CFG_PCGR0_PWM5 0x20000
#define CFG_PCGR0_PWM5_BIT 17
#define CFG_PCGR0_PORT0_MASK 0x40000
#define CFG_PCGR0_PORT0 0x40000
#define CFG_PCGR0_PORT0_BIT 18
#define CFG_PCGR0_PORT1_MASK 0x80000
#define CFG_PCGR0_PORT1 0x80000
#define CFG_PCGR0_PORT1_BIT 19
#define CFG_PCGR0_PORT2_MASK 0x100000
#define CFG_PCGR0_PORT2 0x100000
#define CFG_PCGR0_PORT2_BIT 20
#define CFG_PCGR0_PORT3_MASK 0x200000
#define CFG_PCGR0_PORT3 0x200000
#define CFG_PCGR0_PORT3_BIT 21
#define CFG_PCGR0_PORT4_MASK 0x400000
#define CFG_PCGR0_PORT4 0x400000
#define CFG_PCGR0_PORT4_BIT 22
#define CFG_PCGR0_PORT5_MASK 0x800000
#define CFG_PCGR0_PORT5 0x800000
#define CFG_PCGR0_PORT5_BIT 23
#define CFG_PCGR0_PORT6_MASK 0x1000000
#define CFG_PCGR0_PORT6 0x1000000
#define CFG_PCGR0_PORT6_BIT 24
#define CFG_PCGR0_BSPI0_MASK 0x2000000
#define CFG_PCGR0_BSPI0 0x2000000
#define CFG_PCGR0_BSPI0_BIT 25
#define CFG_PCGR0_BSPI1_MASK 0x4000000
#define CFG_PCGR0_BSPI1 0x4000000
#define CFG_PCGR0_BSPI1_BIT 26
#define CFG_PCGR0_BSPI2_MASK 0x8000000
#define CFG_PCGR0_BSPI2 0x8000000
#define CFG_PCGR0_BSPI2_BIT 27
#define CFG_PCGR0_ADC_MASK 0x10000000
#define CFG_PCGR0_ADC 0x10000000
#define CFG_PCGR0_ADC_BIT 28
#define CFG_PCGR0_EIC_MASK 0x20000000
#define CFG_PCGR0_EIC 0x20000000
#define CFG_PCGR0_EIC_BIT 29
#define CFG_PCGR0_WAKE_UP_TIMER_MASK 0x40000000
#define CFG_PCGR0_WAKE_UP_TIMER 0x40000000
#define CFG_PCGR0_WAKE_UP_TIMER_BIT 30

#define CFG_PCGR1 (*(volatile unsigned long *)0x4000000C)
#define CFG_PCGR1_I2C1_MASK 0x1
#define CFG_PCGR1_I2C1 0x1
#define CFG_PCGR1_I2C1_BIT 0
#define CFG_PCGR1_TIM5_MASK 0x8
#define CFG_PCGR1_TIM5 0x8
#define CFG_PCGR1_TIM5_BIT 3
#define CFG_PCGR1_TIM6_MASK 0x10
#define CFG_PCGR1_TIM6 0x10
#define CFG_PCGR1_TIM6_BIT 4
#define CFG_PCGR1_TIM7_MASK 0x20
#define CFG_PCGR1_TIM7 0x20
#define CFG_PCGR1_TIM7_BIT 5
#define CFG_PCGR1_TIM8_MASK 0x40
#define CFG_PCGR1_TIM8 0x40
#define CFG_PCGR1_TIM8_BIT 6
#define CFG_PCGR1_TIM9_MASK 0x80
#define CFG_PCGR1_TIM9 0x80
#define CFG_PCGR1_TIM9_BIT 7
#define CFG_PCGR1_UART2_MASK 0x100
#define CFG_PCGR1_UART2 0x100
#define CFG_PCGR1_UART2_BIT 8
#define CFG_PCGR1_UART3_MASK 0x200
#define CFG_PCGR1_UART3 0x200
#define CFG_PCGR1_UART3_BIT 9
#define CFG_PCGR1_TB1_MASK 0x2000
#define CFG_PCGR1_TB1 0x2000
#define CFG_PCGR1_TB1_BIT 13
#define CFG_PCGR1_TB2_MASK 0x4000
#define CFG_PCGR1_TB2 0x4000
#define CFG_PCGR1_TB2_BIT 14
#define CFG_PCGR1_TIM2_MASK 0x10000
#define CFG_PCGR1_TIM2 0x10000
#define CFG_PCGR1_TIM2_BIT 16
#define CFG_PCGR1_TIM3_MASK 0x20000
#define CFG_PCGR1_TIM3 0x20000
#define CFG_PCGR1_TIM3_BIT 17
#define CFG_PCGR1_TIM4_MASK 0x40000
#define CFG_PCGR1_TIM4 0x40000
#define CFG_PCGR1_TIM4_BIT 18
#define CFG_PCGR1_RTC_MASK 0x80000
#define CFG_PCGR1_RTC 0x80000
#define CFG_PCGR1_RTC_BIT 19
#define CFG_PCGR1_DMA0_MASK 0x100000
#define CFG_PCGR1_DMA0 0x100000
#define CFG_PCGR1_DMA0_BIT 20
#define CFG_PCGR1_DMA1_MASK 0x200000
#define CFG_PCGR1_DMA1 0x200000
#define CFG_PCGR1_DMA1_BIT 21
#define CFG_PCGR1_DMA2_MASK 0x400000
#define CFG_PCGR1_DMA2 0x400000
#define CFG_PCGR1_DMA2_BIT 22
#define CFG_PCGR1_DMA3_MASK 0x800000
#define CFG_PCGR1_DMA3 0x800000
#define CFG_PCGR1_DMA3_BIT 23
#define CFG_PCGR1_NATIVE_BUS_ARBITER_MASK 0x20000000
#define CFG_PCGR1_NATIVE_BUS_ARBITER 0x20000000
#define CFG_PCGR1_NATIVE_BUS_ARBITER_BIT 29
#define CFG_PCGR1_AHB_ARBITER_MASK 0x40000000
#define CFG_PCGR1_AHB_ARBITER 0x40000000
#define CFG_PCGR1_AHB_ARBITER_BIT 30

#define CFG_PECGR0 (*(volatile unsigned long *)0x40000010)
#define CFG_PECGR0_RAM_MASK 0x1
#define CFG_PECGR0_RAM 0x1
#define CFG_PECGR0_RAM_BIT 0
#define CFG_PECGR0_I2C0_MASK 0x2
#define CFG_PECGR0_I2C0 0x2
#define CFG_PECGR0_I2C0_BIT 1
#define CFG_PECGR0_WIU_MASK 0x4
#define CFG_PECGR0_WIU 0x4
#define CFG_PECGR0_WIU_BIT 2
#define CFG_PECGR0_UART0_MASK 0x10
#define CFG_PECGR0_UART0 0x10
#define CFG_PECGR0_UART0_BIT 4
#define CFG_PECGR0_UART1_MASK 0x20
#define CFG_PECGR0_UART1 0x20
#define CFG_PECGR0_UART1_BIT 5
#define CFG_PECGR0_TIM0_MASK 0x40
#define CFG_PECGR0_TIM0 0x40
#define CFG_PECGR0_TIM0_BIT 6
#define CFG_PECGR0_TIM1_MASK 0x80
#define CFG_PECGR0_TIM1 0x80
#define CFG_PECGR0_TIM1_BIT 7
#define CFG_PECGR0_TB0_MASK 0x100
#define CFG_PECGR0_TB0 0x100
#define CFG_PECGR0_TB0_BIT 8
#define CFG_PECGR0_CAN0_MASK 0x400
#define CFG_PECGR0_CAN0 0x400
#define CFG_PECGR0_CAN0_BIT 10
#define CFG_PECGR0_CAN1_MASK 0x800
#define CFG_PECGR0_CAN1 0x800
#define CFG_PECGR0_CAN1_BIT 11
#define CFG_PECGR0_PWM0_MASK 0x1000
#define CFG_PECGR0_PWM0 0x1000
#define CFG_PECGR0_PWM0_BIT 12
#define CFG_PECGR0_PWM1_MASK 0x2000
#define CFG_PECGR0_PWM1 0x2000
#define CFG_PECGR0_PWM1_BIT 13
#define CFG_PECGR0_PWM2_MASK 0x4000
#define CFG_PECGR0_PWM2 0x4000
#define CFG_PECGR0_PWM2_BIT 14
#define CFG_PECGR0_PWM3_MASK 0x8000
#define CFG_PECGR0_PWM3 0x8000
#define CFG_PECGR0_PWM3_BIT 15
#define CFG_PECGR0_PWM4_MASK 0x10000
#define CFG_PECGR0_PWM4 0x10000
#define CFG_PECGR0_PWM4_BIT 16
#define CFG_PECGR0_PWM5_MASK 0x20000
#define CFG_PECGR0_PWM5 0x20000
#define CFG_PECGR0_PWM5_BIT 17
#define CFG_PECGR0_PORT0_MASK 0x40000
#define CFG_PECGR0_PORT0 0x40000
#define CFG_PECGR0_PORT0_BIT 18
#define CFG_PECGR0_PORT1_MASK 0x80000
#define CFG_PECGR0_PORT1 0x80000
#define CFG_PECGR0_PORT1_BIT 19
#define CFG_PECGR0_PORT2_MASK 0x100000
#define CFG_PECGR0_PORT2 0x100000
#define CFG_PECGR0_PORT2_BIT 20
#define CFG_PECGR0_PORT3_MASK 0x200000
#define CFG_PECGR0_PORT3 0x200000
#define CFG_PECGR0_PORT3_BIT 21
#define CFG_PECGR0_PORT4_MASK 0x400000
#define CFG_PECGR0_PORT4 0x400000
#define CFG_PECGR0_PORT4_BIT 22
#define CFG_PECGR0_PORT5_MASK 0x800000
#define CFG_PECGR0_PORT5 0x800000
#define CFG_PECGR0_PORT5_BIT 23
#define CFG_PECGR0_PORT6_MASK 0x1000000
#define CFG_PECGR0_PORT6 0x1000000
#define CFG_PECGR0_PORT6_BIT 24
#define CFG_PECGR0_BSPI0_MASK 0x2000000
#define CFG_PECGR0_BSPI0 0x2000000
#define CFG_PECGR0_BSPI0_BIT 25
#define CFG_PECGR0_BSPI1_MASK 0x4000000
#define CFG_PECGR0_BSPI1 0x4000000
#define CFG_PECGR0_BSPI1_BIT 26
#define CFG_PECGR0_BSPI2_MASK 0x8000000
#define CFG_PECGR0_BSPI2 0x8000000
#define CFG_PECGR0_BSPI2_BIT 27
#define CFG_PECGR0_ADC_MASK 0x10000000
#define CFG_PECGR0_ADC 0x10000000
#define CFG_PECGR0_ADC_BIT 28
#define CFG_PECGR0_EIC_MASK 0x20000000
#define CFG_PECGR0_EIC 0x20000000
#define CFG_PECGR0_EIC_BIT 29
#define CFG_PECGR0_WAKE_UP_TIMER_MASK 0x40000000
#define CFG_PECGR0_WAKE_UP_TIMER 0x40000000
#define CFG_PECGR0_WAKE_UP_TIMER_BIT 30

#define CFG_PECGR1 (*(volatile unsigned long *)0x40000014)
#define CFG_PECGR1_I2C1_MASK 0x1
#define CFG_PECGR1_I2C1 0x1
#define CFG_PECGR1_I2C1_BIT 0
#define CFG_PECGR1_TIM5_MASK 0x8
#define CFG_PECGR1_TIM5 0x8
#define CFG_PECGR1_TIM5_BIT 3
#define CFG_PECGR1_TIM6_MASK 0x10
#define CFG_PECGR1_TIM6 0x10
#define CFG_PECGR1_TIM6_BIT 4
#define CFG_PECGR1_TIM7_MASK 0x20
#define CFG_PECGR1_TIM7 0x20
#define CFG_PECGR1_TIM7_BIT 5
#define CFG_PECGR1_TIM8_MASK 0x40
#define CFG_PECGR1_TIM8 0x40
#define CFG_PECGR1_TIM8_BIT 6
#define CFG_PECGR1_TIM9_MASK 0x80
#define CFG_PECGR1_TIM9 0x80
#define CFG_PECGR1_TIM9_BIT 7
#define CFG_PECGR1_UART2_MASK 0x100
#define CFG_PECGR1_UART2 0x100
#define CFG_PECGR1_UART2_BIT 8
#define CFG_PECGR1_UART3_MASK 0x200
#define CFG_PECGR1_UART3 0x200
#define CFG_PECGR1_UART3_BIT 9
#define CFG_PECGR1_TB1_MASK 0x2000
#define CFG_PECGR1_TB1 0x2000
#define CFG_PECGR1_TB1_BIT 13
#define CFG_PECGR1_TB2_MASK 0x4000
#define CFG_PECGR1_TB2 0x4000
#define CFG_PECGR1_TB2_BIT 14
#define CFG_PECGR1_TIM2_MASK 0x10000
#define CFG_PECGR1_TIM2 0x10000
#define CFG_PECGR1_TIM2_BIT 16
#define CFG_PECGR1_TIM3_MASK 0x20000
#define CFG_PECGR1_TIM3 0x20000
#define CFG_PECGR1_TIM3_BIT 17
#define CFG_PECGR1_TIM4_MASK 0x40000
#define CFG_PECGR1_TIM4 0x40000
#define CFG_PECGR1_TIM4_BIT 18
#define CFG_PECGR1_RTC_MASK 0x80000
#define CFG_PECGR1_RTC 0x80000
#define CFG_PECGR1_RTC_BIT 19
#define CFG_PECGR1_DMA0_MASK 0x100000
#define CFG_PECGR1_DMA0 0x100000
#define CFG_PECGR1_DMA0_BIT 20
#define CFG_PECGR1_DMA1_MASK 0x200000
#define CFG_PECGR1_DMA1 0x200000
#define CFG_PECGR1_DMA1_BIT 21
#define CFG_PECGR1_DMA2_MASK 0x400000
#define CFG_PECGR1_DMA2 0x400000
#define CFG_PECGR1_DMA2_BIT 22
#define CFG_PECGR1_DMA3_MASK 0x800000
#define CFG_PECGR1_DMA3 0x800000
#define CFG_PECGR1_DMA3_BIT 23
#define CFG_PECGR1_NATIVE_BUS_ARBITER_MASK 0x20000000
#define CFG_PECGR1_NATIVE_BUS_ARBITER 0x20000000
#define CFG_PECGR1_NATIVE_BUS_ARBITER_BIT 29
#define CFG_PECGR1_AHB_ARBITER_MASK 0x40000000
#define CFG_PECGR1_AHB_ARBITER 0x40000000
#define CFG_PECGR1_AHB_ARBITER_BIT 30

#define CFG_PCGRB0 (*(volatile unsigned long *)0x40000018)
#define CFG_PCGRB0_RAM_MASK 0x1
#define CFG_PCGRB0_RAM 0x1
#define CFG_PCGRB0_RAM_BIT 0
#define CFG_PCGRB0_I2C0_MASK 0x2
#define CFG_PCGRB0_I2C0 0x2
#define CFG_PCGRB0_I2C0_BIT 1
#define CFG_PCGRB0_WIU_MASK 0x4
#define CFG_PCGRB0_WIU 0x4
#define CFG_PCGRB0_WIU_BIT 2
#define CFG_PCGRB0_UART0_MASK 0x10
#define CFG_PCGRB0_UART0 0x10
#define CFG_PCGRB0_UART0_BIT 4
#define CFG_PCGRB0_UART1_MASK 0x20
#define CFG_PCGRB0_UART1 0x20
#define CFG_PCGRB0_UART1_BIT 5
#define CFG_PCGRB0_TIM0_MASK 0x40
#define CFG_PCGRB0_TIM0 0x40
#define CFG_PCGRB0_TIM0_BIT 6
#define CFG_PCGRB0_TIM1_MASK 0x80
#define CFG_PCGRB0_TIM1 0x80
#define CFG_PCGRB0_TIM1_BIT 7
#define CFG_PCGRB0_TB0_MASK 0x100
#define CFG_PCGRB0_TB0 0x100
#define CFG_PCGRB0_TB0_BIT 8
#define CFG_PCGRB0_CAN0_MASK 0x400
#define CFG_PCGRB0_CAN0 0x400
#define CFG_PCGRB0_CAN0_BIT 10
#define CFG_PCGRB0_CAN1_MASK 0x800
#define CFG_PCGRB0_CAN1 0x800
#define CFG_PCGRB0_CAN1_BIT 11
#define CFG_PCGRB0_PWM0_MASK 0x1000
#define CFG_PCGRB0_PWM0 0x1000
#define CFG_PCGRB0_PWM0_BIT 12
#define CFG_PCGRB0_PWM1_MASK 0x2000
#define CFG_PCGRB0_PWM1 0x2000
#define CFG_PCGRB0_PWM1_BIT 13
#define CFG_PCGRB0_PWM2_MASK 0x4000
#define CFG_PCGRB0_PWM2 0x4000
#define CFG_PCGRB0_PWM2_BIT 14
#define CFG_PCGRB0_PWM3_MASK 0x8000
#define CFG_PCGRB0_PWM3 0x8000
#define CFG_PCGRB0_PWM3_BIT 15
#define CFG_PCGRB0_PWM4_MASK 0x10000
#define CFG_PCGRB0_PWM4 0x10000
#define CFG_PCGRB0_PWM4_BIT 16
#define CFG_PCGRB0_PWM5_MASK 0x20000
#define CFG_PCGRB0_PWM5 0x20000
#define CFG_PCGRB0_PWM5_BIT 17
#define CFG_PCGRB0_PORT0_MASK 0x40000
#define CFG_PCGRB0_PORT0 0x40000
#define CFG_PCGRB0_PORT0_BIT 18
#define CFG_PCGRB0_PORT1_MASK 0x80000
#define CFG_PCGRB0_PORT1 0x80000
#define CFG_PCGRB0_PORT1_BIT 19
#define CFG_PCGRB0_PORT2_MASK 0x100000
#define CFG_PCGRB0_PORT2 0x100000
#define CFG_PCGRB0_PORT2_BIT 20
#define CFG_PCGRB0_PORT3_MASK 0x200000
#define CFG_PCGRB0_PORT3 0x200000
#define CFG_PCGRB0_PORT3_BIT 21
#define CFG_PCGRB0_PORT4_MASK 0x400000
#define CFG_PCGRB0_PORT4 0x400000
#define CFG_PCGRB0_PORT4_BIT 22
#define CFG_PCGRB0_PORT5_MASK 0x800000
#define CFG_PCGRB0_PORT5 0x800000
#define CFG_PCGRB0_PORT5_BIT 23
#define CFG_PCGRB0_PORT6_MASK 0x1000000
#define CFG_PCGRB0_PORT6 0x1000000
#define CFG_PCGRB0_PORT6_BIT 24
#define CFG_PCGRB0_BSPI0_MASK 0x2000000
#define CFG_PCGRB0_BSPI0 0x2000000
#define CFG_PCGRB0_BSPI0_BIT 25
#define CFG_PCGRB0_BSPI1_MASK 0x4000000
#define CFG_PCGRB0_BSPI1 0x4000000
#define CFG_PCGRB0_BSPI1_BIT 26
#define CFG_PCGRB0_BSPI2_MASK 0x8000000
#define CFG_PCGRB0_BSPI2 0x8000000
#define CFG_PCGRB0_BSPI2_BIT 27
#define CFG_PCGRB0_ADC_MASK 0x10000000
#define CFG_PCGRB0_ADC 0x10000000
#define CFG_PCGRB0_ADC_BIT 28
#define CFG_PCGRB0_EIC_MASK 0x20000000
#define CFG_PCGRB0_EIC 0x20000000
#define CFG_PCGRB0_EIC_BIT 29
#define CFG_PCGRB0_WAKE_UP_TIMER_MASK 0x40000000
#define CFG_PCGRB0_WAKE_UP_TIMER 0x40000000
#define CFG_PCGRB0_WAKE_UP_TIMER_BIT 30

#define CFG_PCGRB1 (*(volatile unsigned long *)0x4000001C)
#define CFG_PCGRB1_I2C1_MASK 0x1
#define CFG_PCGRB1_I2C1 0x1
#define CFG_PCGRB1_I2C1_BIT 0
#define CFG_PCGRB1_TIM5_MASK 0x8
#define CFG_PCGRB1_TIM5 0x8
#define CFG_PCGRB1_TIM5_BIT 3
#define CFG_PCGRB1_TIM6_MASK 0x10
#define CFG_PCGRB1_TIM6 0x10
#define CFG_PCGRB1_TIM6_BIT 4
#define CFG_PCGRB1_TIM7_MASK 0x20
#define CFG_PCGRB1_TIM7 0x20
#define CFG_PCGRB1_TIM7_BIT 5
#define CFG_PCGRB1_TIM8_MASK 0x40
#define CFG_PCGRB1_TIM8 0x40
#define CFG_PCGRB1_TIM8_BIT 6
#define CFG_PCGRB1_TIM9_MASK 0x80
#define CFG_PCGRB1_TIM9 0x80
#define CFG_PCGRB1_TIM9_BIT 7
#define CFG_PCGRB1_UART2_MASK 0x100
#define CFG_PCGRB1_UART2 0x100
#define CFG_PCGRB1_UART2_BIT 8
#define CFG_PCGRB1_UART3_MASK 0x200
#define CFG_PCGRB1_UART3 0x200
#define CFG_PCGRB1_UART3_BIT 9
#define CFG_PCGRB1_TB1_MASK 0x2000
#define CFG_PCGRB1_TB1 0x2000
#define CFG_PCGRB1_TB1_BIT 13
#define CFG_PCGRB1_TB2_MASK 0x4000
#define CFG_PCGRB1_TB2 0x4000
#define CFG_PCGRB1_TB2_BIT 14
#define CFG_PCGRB1_TIM2_MASK 0x10000
#define CFG_PCGRB1_TIM2 0x10000
#define CFG_PCGRB1_TIM2_BIT 16
#define CFG_PCGRB1_TIM3_MASK 0x20000
#define CFG_PCGRB1_TIM3 0x20000
#define CFG_PCGRB1_TIM3_BIT 17
#define CFG_PCGRB1_TIM4_MASK 0x40000
#define CFG_PCGRB1_TIM4 0x40000
#define CFG_PCGRB1_TIM4_BIT 18
#define CFG_PCGRB1_RTC_MASK 0x80000
#define CFG_PCGRB1_RTC 0x80000
#define CFG_PCGRB1_RTC_BIT 19
#define CFG_PCGRB1_DMA0_MASK 0x100000
#define CFG_PCGRB1_DMA0 0x100000
#define CFG_PCGRB1_DMA0_BIT 20
#define CFG_PCGRB1_DMA1_MASK 0x200000
#define CFG_PCGRB1_DMA1 0x200000
#define CFG_PCGRB1_DMA1_BIT 21
#define CFG_PCGRB1_DMA2_MASK 0x400000
#define CFG_PCGRB1_DMA2 0x400000
#define CFG_PCGRB1_DMA2_BIT 22
#define CFG_PCGRB1_DMA3_MASK 0x800000
#define CFG_PCGRB1_DMA3 0x800000
#define CFG_PCGRB1_DMA3_BIT 23
#define CFG_PCGRB1_NATIVE_BUS_ARBITER_MASK 0x20000000
#define CFG_PCGRB1_NATIVE_BUS_ARBITER 0x20000000
#define CFG_PCGRB1_NATIVE_BUS_ARBITER_BIT 29
#define CFG_PCGRB1_AHB_ARBITER_MASK 0x40000000
#define CFG_PCGRB1_AHB_ARBITER 0x40000000
#define CFG_PCGRB1_AHB_ARBITER_BIT 30

#define CFG_TIMSR (*(volatile unsigned long *)0x40000020)
#define CFG_TIMSR_TIMECKS_MASK 0x3FF
#define CFG_TIMSR_TIMECKS_BIT 0

#define CFG_EITE1 (*(volatile unsigned long *)0x40000024)
#define CFG_EITE1_EITE1_MASK 0xFFFF
#define CFG_EITE1_EITE1_BIT 0

#define CFG_EITE2 (*(volatile unsigned long *)0x40000028)
#define CFG_EITE2_EITE2_MASK 0xFFFF
#define CFG_EITE2_EITE2_BIT 0

#define CFG_ESPR (*(volatile unsigned long *)0x4000002C)
#define CFG_ESPR_UART0_MASK 0x1
#define CFG_ESPR_UART0 0x1
#define CFG_ESPR_UART0_BIT 0
#define CFG_ESPR_UART1_MASK 0x2
#define CFG_ESPR_UART1 0x2
#define CFG_ESPR_UART1_BIT 1
#define CFG_ESPR_UART2_MASK 0x4
#define CFG_ESPR_UART2 0x4
#define CFG_ESPR_UART2_BIT 2
#define CFG_ESPR_UART3_MASK 0x8
#define CFG_ESPR_UART3 0x8
#define CFG_ESPR_UART3_BIT 3
#define CFG_ESPR_BSPI0_MASK 0x10
#define CFG_ESPR_BSPI0 0x10
#define CFG_ESPR_BSPI0_BIT 4
#define CFG_ESPR_BSPI1_MASK 0x20
#define CFG_ESPR_BSPI1 0x20
#define CFG_ESPR_BSPI1_BIT 5
#define CFG_ESPR_BSPI2_MASK 0x40
#define CFG_ESPR_BSPI2 0x40
#define CFG_ESPR_BSPI2_BIT 6

#define CFG_R1 (*(volatile unsigned long *)0x40000030)
#define CFG_R1_LPVRCC_MASK 0x3
#define CFG_R1_LPVRCC_BIT 0
#define CFG_R1_EIFILT_MASK 0x4
#define CFG_R1_EIFILT 0x4
#define CFG_R1_EIFILT_BIT 2
#define CFG_R1_WUPOS_MASK 0x8
#define CFG_R1_WUPOS 0x8
#define CFG_R1_WUPOS_BIT 3
#define CFG_R1_FLPOD_MASK 0x1F0
#define CFG_R1_FLPOD_BIT 4

#define CFG_DSR (*(volatile unsigned long *)0x40000034)

#define PRCCU_CCR (*(volatile unsigned long *)0x60000000)
#define PRCCU_CCR_LPO_WFI_MASK 0x1
#define PRCCU_CCR_LPO_WFI 0x1
#define PRCCU_CCR_LPO_WFI_BIT 0
#define PRCCU_CCR_WFI_CKSEL_MASK 0x2
#define PRCCU_CCR_WFI_CKSEL 0x2
#define PRCCU_CCR_WFI_CKSEL_BIT 1
#define PRCCU_CCR_SRES_EN_MASK 0x8
#define PRCCU_CCR_SRES_EN 0x8
#define PRCCU_CCR_SRES_EN_BIT 3
#define PRCCU_CCR_EN_LOCK_MASK 0x80
#define PRCCU_CCR_EN_LOCK 0x80
#define PRCCU_CCR_EN_LOCK_BIT 7
#define PRCCU_CCR_EN_CK2_16_MASK 0x200
#define PRCCU_CCR_EN_CK2_16 0x200
#define PRCCU_CCR_EN_CK2_16_BIT 9
#define PRCCU_CCR_EN_STOP_MASK 0x400
#define PRCCU_CCR_EN_STOP 0x400
#define PRCCU_CCR_EN_STOP_BIT 10
#define PRCCU_CCR_EN_HALT_MASK 0x800
#define PRCCU_CCR_EN_HALT 0x800
#define PRCCU_CCR_EN_HALT_BIT 11

#define PRCCU_VRCTR (*(volatile unsigned long *)0x60000004)
#define PRCCU_VRCTR_VRPR_MASK 0x3
#define PRCCU_VRCTR_VRPR_BIT 0
#define PRCCU_VRCTR_VROK_MASK 0x4
#define PRCCU_VRCTR_VROK 0x4
#define PRCCU_VRCTR_VROK_BIT 2
#define PRCCU_VRCTR_VROFF_REG_MASK 0x8
#define PRCCU_VRCTR_VROFF_REG 0x8
#define PRCCU_VRCTR_VROFF_REG_BIT 3
#define PRCCU_VRCTR_VRLPW_MASK 0x10
#define PRCCU_VRCTR_VRLPW 0x10
#define PRCCU_VRCTR_VRLPW_BIT 4

#define PRCCU_CFR (*(volatile unsigned long *)0x60000008)
#define PRCCU_CFR_CSU_CKSEL_MASK 0x1
#define PRCCU_CFR_CSU_CKSEL 0x1
#define PRCCU_CFR_CSU_CKSEL_BIT 0
#define PRCCU_CFR_LOCK_MASK 0x2
#define PRCCU_CFR_LOCK 0x2
#define PRCCU_CFR_LOCK_BIT 1
#define PRCCU_CFR_CK2_16_MASK 0x8
#define PRCCU_CFR_CK2_16 0x8
#define PRCCU_CFR_CK2_16_BIT 3
#define PRCCU_CFR_SOFT_RES_MASK 0x20
#define PRCCU_CFR_SOFT_RES 0x20
#define PRCCU_CFR_SOFT_RES_BIT 5
#define PRCCU_CFR_WDG_RES_MASK 0x40
#define PRCCU_CFR_WDG_RES 0x40
#define PRCCU_CFR_WDG_RES_BIT 6
#define PRCCU_CFR_LVD_INT_MASK 0x100
#define PRCCU_CFR_LVD_INT 0x100
#define PRCCU_CFR_LVD_INT_BIT 8
#define PRCCU_CFR_LOCK_I_MASK 0x800
#define PRCCU_CFR_LOCK_I 0x800
#define PRCCU_CFR_LOCK_I_BIT 11
#define PRCCU_CFR_CK2_16_I_MASK 0x2000
#define PRCCU_CFR_CK2_16_I 0x2000
#define PRCCU_CFR_CK2_16_I_BIT 13
#define PRCCU_CFR_STOP_I_MASK 0x4000
#define PRCCU_CFR_STOP_I 0x4000
#define PRCCU_CFR_STOP_I_BIT 14
#define PRCCU_CFR_DIV2_MASK 0x8000
#define PRCCU_CFR_DIV2 0x8000
#define PRCCU_CFR_DIV2_BIT 15

#define PRCCU_PCR (*(volatile unsigned long *)0x60000018)
#define PRCCU_PCR_DX0_MASK 0x1
#define PRCCU_PCR_DX0 0x1
#define PRCCU_PCR_DX0_BIT 0
#define PRCCU_PCR_DX1_MASK 0x2
#define PRCCU_PCR_DX1 0x2
#define PRCCU_PCR_DX1_BIT 1
#define PRCCU_PCR_DX2_MASK 0x4
#define PRCCU_PCR_DX2 0x4
#define PRCCU_PCR_DX2_BIT 2
#define PRCCU_PCR_MX0_MASK 0x10
#define PRCCU_PCR_MX0 0x10
#define PRCCU_PCR_MX0_BIT 4
#define PRCCU_PCR_MX1_MASK 0x20
#define PRCCU_PCR_MX1 0x20
#define PRCCU_PCR_MX1_BIT 5
#define PRCCU_PCR_FREF_RANGE_MASK 0x40
#define PRCCU_PCR_FREF_RANGE 0x40
#define PRCCU_PCR_FREF_RANGE_BIT 6
#define PRCCU_PCR_FREEN_MASK 0x80
#define PRCCU_PCR_FREEN 0x80
#define PRCCU_PCR_FREEN_BIT 7

#define PRCCU_SYSMR (*(volatile unsigned long *)0x60000020)
#define PRCCU_SYSMR_WFI_MASK 0x1
#define PRCCU_SYSMR_WFI 0x1
#define PRCCU_SYSMR_WFI_BIT 0
#define PRCCU_SYSMR_HALT_MASK 0x2
#define PRCCU_SYSMR_HALT 0x2
#define PRCCU_SYSMR_HALT_BIT 1

#define PRCCU_RTCP (*(volatile unsigned long *)0x60000028)
#define PRCCU_RTCP_RTP_MASK 0xF
#define PRCCU_RTCP_RTP_BIT 0

#define FLASH_CR0 (*(volatile unsigned *)0x80100000)
#define FLASH_CR0_BSY0_MASK 0x2
#define FLASH_CR0_BSY0 0x2
#define FLASH_CR0_BSY0_BIT 1
#define FLASH_CR0_LOCK_MASK 0x10
#define FLASH_CR0_LOCK 0x10
#define FLASH_CR0_LOCK_BIT 4
#define FLASH_CR0_PWD_MASK 0x8000
#define FLASH_CR0_PWD 0x8000
#define FLASH_CR0_PWD_BIT 15
#define FLASH_CR0_JBM_MASK 0x80000
#define FLASH_CR0_JBM 0x80000
#define FLASH_CR0_JBM_BIT 19
#define FLASH_CR0_INTP_MASK 0x100000
#define FLASH_CR0_INTP 0x100000
#define FLASH_CR0_INTP_BIT 20
#define FLASH_CR0_INTM_MASK 0x200000
#define FLASH_CR0_INTM 0x200000
#define FLASH_CR0_INTM_BIT 21
#define FLASH_CR0_SMBM_MASK 0x400000
#define FLASH_CR0_SMBM 0x400000
#define FLASH_CR0_SMBM_BIT 22
#define FLASH_CR0_SPR_MASK 0x1000000
#define FLASH_CR0_SPR 0x1000000
#define FLASH_CR0_SPR_BIT 24
#define FLASH_CR0_SER_MASK 0x8000000
#define FLASH_CR0_SER 0x8000000
#define FLASH_CR0_SER_BIT 27
#define FLASH_CR0_DWPG_MASK 0x10000000
#define FLASH_CR0_DWPG 0x10000000
#define FLASH_CR0_DWPG_BIT 28
#define FLASH_CR0_WPG_MASK 0x20000000
#define FLASH_CR0_WPG 0x20000000
#define FLASH_CR0_WPG_BIT 29
#define FLASH_CR0_SUSP_MASK 0x40000000
#define FLASH_CR0_SUSP 0x40000000
#define FLASH_CR0_SUSP_BIT 30
#define FLASH_CR0_WMS_MASK 0x80000000
#define FLASH_CR0_WMS 0x80000000
#define FLASH_CR0_WMS_BIT 31

#define FLASH_CR1 (*(volatile unsigned *)0x80100004)
#define FLASH_CR1_B0F_MASK 0xFF
#define FLASH_CR1_B0F_BIT 0

#define FLASH_DR0 (*(volatile unsigned *)0x80010008)

#define FLASH_DR1 (*(volatile unsigned *)0x8001000C)

#define FLASH_AR (*(volatile unsigned *)0x80010010)

#define FLASH_ER (*(volatile unsigned *)0x80010014)
#define FLASH_ER_ERR_MASK 0x1
#define FLASH_ER_ERR 0x1
#define FLASH_ER_ERR_BIT 0
#define FLASH_ER_ERER_MASK 0x2
#define FLASH_ER_ERER 0x2
#define FLASH_ER_ERER_BIT 1
#define FLASH_ER_PGER_MASK 0x4
#define FLASH_ER_PGER 0x4
#define FLASH_ER_PGER_BIT 2
#define FLASH_ER__10ER_MASK 0x8
#define FLASH_ER__10ER 0x8
#define FLASH_ER__10ER_BIT 3
#define FLASH_ER_SEQER_MASK 0x40
#define FLASH_ER_SEQER 0x40
#define FLASH_ER_SEQER_BIT 6
#define FLASH_ER_REQER_MASK 0x80
#define FLASH_ER_REQER 0x80
#define FLASH_ER_REQER_BIT 7
#define FLASH_ER_WPF_MASK 0x100
#define FLASH_ER_WPF 0x100
#define FLASH_ER_WPF_BIT 8

#define FLASH_NVWPAR (*(volatile unsigned *)0x8010DFB0)
#define FLASH_NVWPAR_W0P_MASK 0xFF
#define FLASH_NVWPAR_W0P_BIT 0
#define FLASH_NVWPAR_W1P0_MASK 0x10000
#define FLASH_NVWPAR_W1P0 0x10000
#define FLASH_NVWPAR_W1P0_BIT 16
#define FLASH_NVWPAR_W1P1_MASK 0x20000
#define FLASH_NVWPAR_W1P1 0x20000
#define FLASH_NVWPAR_W1P1_BIT 17

#define FLASH_NVAPR0 (*(volatile unsigned *)0x8010DFB8)
#define FLASH_NVAPR0_DBGP_MASK 0x2
#define FLASH_NVAPR0_DBGP 0x2
#define FLASH_NVAPR0_DBGP_BIT 1

#define FLASH_NVAPR1 (*(volatile unsigned *)0x8010DFBC)
#define FLASH_NVAPR1_PDS_MASK 0xFFFF
#define FLASH_NVAPR1_PDS_BIT 0
#define FLASH_NVAPR1_PEN_MASK 0xFFFF0000
#define FLASH_NVAPR1_PEN_BIT 16

#define APB0_BSR (*(volatile unsigned long *)0xFFFF8000)
#define APB0_BSR_ABORT_MASK 0x1
#define APB0_BSR_ABORT 0x1
#define APB0_BSR_ABORT_BIT 0
#define APB0_BSR_OUTM_MASK 0x10
#define APB0_BSR_OUTM 0x10
#define APB0_BSR_OUTM_BIT 4
#define APB0_BSR_ABPT_MASK 0x20
#define APB0_BSR_ABPT 0x20
#define APB0_BSR_ABPT_BIT 5

#define APB0_TOR (*(volatile unsigned long *)0xFFFF8004)
#define APB0_TOR_TOUT_CNT_MASK 0x1F
#define APB0_TOR_TOUT_CNT_BIT 0
#define APB0_TOR_ABTEN_MASK 0x100
#define APB0_TOR_ABTEN 0x100
#define APB0_TOR_ABTEN_BIT 8

#define APB0_OMR (*(volatile unsigned long *)0xFFFF8008)
#define APB0_OMR_nRW_MASK 0x80
#define APB0_OMR_nRW 0x80
#define APB0_OMR_nRW_BIT 7
#define APB0_OMR_PERIPHERAL_ADDRESS_MASK 0xFFFF00
#define APB0_OMR_PERIPHERAL_ADDRESS_BIT 8

#define APB0_TOER (*(volatile unsigned long *)0xFFFF800C)
#define APB0_TOER_nRW_MASK 0x80
#define APB0_TOER_nRW 0x80
#define APB0_TOER_nRW_BIT 7
#define APB0_TOER_PERIPHERAL_ADDRESS_MASK 0xFFFF00
#define APB0_TOER_PERIPHERAL_ADDRESS_BIT 8

#define I2C0_CR (*(volatile unsigned char *)0xFFFF8400)
#define I2C0_CR_ITE_MASK 0x1
#define I2C0_CR_ITE 0x1
#define I2C0_CR_ITE_BIT 0
#define I2C0_CR_STOP_MASK 0x2
#define I2C0_CR_STOP 0x2
#define I2C0_CR_STOP_BIT 1
#define I2C0_CR_ACK_MASK 0x4
#define I2C0_CR_ACK 0x4
#define I2C0_CR_ACK_BIT 2
#define I2C0_CR_START_MASK 0x8
#define I2C0_CR_START 0x8
#define I2C0_CR_START_BIT 3
#define I2C0_CR_ENGC_MASK 0x10
#define I2C0_CR_ENGC 0x10
#define I2C0_CR_ENGC_BIT 4
#define I2C0_CR_PE_MASK 0x20
#define I2C0_CR_PE 0x20
#define I2C0_CR_PE_BIT 5

#define I2C0_SR1 (*(volatile unsigned char *)0xFFFF8404)
#define I2C0_SR1_SB_MASK 0x1
#define I2C0_SR1_SB 0x1
#define I2C0_SR1_SB_BIT 0
#define I2C0_SR1_M_SL_MASK 0x2
#define I2C0_SR1_M_SL 0x2
#define I2C0_SR1_M_SL_BIT 1
#define I2C0_SR1_ADSL_MASK 0x4
#define I2C0_SR1_ADSL 0x4
#define I2C0_SR1_ADSL_BIT 2
#define I2C0_SR1_BTF_MASK 0x8
#define I2C0_SR1_BTF 0x8
#define I2C0_SR1_BTF_BIT 3
#define I2C0_SR1_BUSY_MASK 0x10
#define I2C0_SR1_BUSY 0x10
#define I2C0_SR1_BUSY_BIT 4
#define I2C0_SR1_TRA_MASK 0x20
#define I2C0_SR1_TRA 0x20
#define I2C0_SR1_TRA_BIT 5
#define I2C0_SR1_ADD10_MASK 0x40
#define I2C0_SR1_ADD10 0x40
#define I2C0_SR1_ADD10_BIT 6
#define I2C0_SR1_EVF_MASK 0x80
#define I2C0_SR1_EVF 0x80
#define I2C0_SR1_EVF_BIT 7

#define I2C0_SR2 (*(volatile unsigned char *)0xFFFF8408)
#define I2C0_SR2_GCAL_MASK 0x1
#define I2C0_SR2_GCAL 0x1
#define I2C0_SR2_GCAL_BIT 0
#define I2C0_SR2_BERR_MASK 0x2
#define I2C0_SR2_BERR 0x2
#define I2C0_SR2_BERR_BIT 1
#define I2C0_SR2_ARLO_MASK 0x4
#define I2C0_SR2_ARLO 0x4
#define I2C0_SR2_ARLO_BIT 2
#define I2C0_SR2_STOPF_MASK 0x8
#define I2C0_SR2_STOPF 0x8
#define I2C0_SR2_STOPF_BIT 3
#define I2C0_SR2_AF_MASK 0x10
#define I2C0_SR2_AF 0x10
#define I2C0_SR2_AF_BIT 4
#define I2C0_SR2_ENDAD_MASK 0x20
#define I2C0_SR2_ENDAD 0x20
#define I2C0_SR2_ENDAD_BIT 5

#define I2C0_CCR (*(volatile unsigned char *)0xFFFF840C)
#define I2C0_CCR_CC0_MASK 0x1
#define I2C0_CCR_CC0 0x1
#define I2C0_CCR_CC0_BIT 0
#define I2C0_CCR_CC1_MASK 0x2
#define I2C0_CCR_CC1 0x2
#define I2C0_CCR_CC1_BIT 1
#define I2C0_CCR_CC2_MASK 0x4
#define I2C0_CCR_CC2 0x4
#define I2C0_CCR_CC2_BIT 2
#define I2C0_CCR_CC3_MASK 0x8
#define I2C0_CCR_CC3 0x8
#define I2C0_CCR_CC3_BIT 3
#define I2C0_CCR_CC4_MASK 0x10
#define I2C0_CCR_CC4 0x10
#define I2C0_CCR_CC4_BIT 4
#define I2C0_CCR_CC5_MASK 0x20
#define I2C0_CCR_CC5 0x20
#define I2C0_CCR_CC5_BIT 5
#define I2C0_CCR_CC6_MASK 0x40
#define I2C0_CCR_CC6 0x40
#define I2C0_CCR_CC6_BIT 6
#define I2C0_CCR_FM_SM_MASK 0x80
#define I2C0_CCR_FM_SM 0x80
#define I2C0_CCR_FM_SM_BIT 7

#define I2C0_OAR1 (*(volatile unsigned char *)0xFFFF8410)
#define I2C0_OAR1_ADD0_MASK 0x1
#define I2C0_OAR1_ADD0 0x1
#define I2C0_OAR1_ADD0_BIT 0
#define I2C0_OAR1_ADD1_MASK 0x2
#define I2C0_OAR1_ADD1 0x2
#define I2C0_OAR1_ADD1_BIT 1
#define I2C0_OAR1_ADD2_MASK 0x4
#define I2C0_OAR1_ADD2 0x4
#define I2C0_OAR1_ADD2_BIT 2
#define I2C0_OAR1_ADD3_MASK 0x8
#define I2C0_OAR1_ADD3 0x8
#define I2C0_OAR1_ADD3_BIT 3
#define I2C0_OAR1_ADD4_MASK 0x10
#define I2C0_OAR1_ADD4 0x10
#define I2C0_OAR1_ADD4_BIT 4
#define I2C0_OAR1_ADD5_MASK 0x20
#define I2C0_OAR1_ADD5 0x20
#define I2C0_OAR1_ADD5_BIT 5
#define I2C0_OAR1_ADD6_MASK 0x40
#define I2C0_OAR1_ADD6 0x40
#define I2C0_OAR1_ADD6_BIT 6
#define I2C0_OAR1_ADD7_MASK 0x80
#define I2C0_OAR1_ADD7 0x80
#define I2C0_OAR1_ADD7_BIT 7

#define I2C0_OAR2 (*(volatile unsigned char *)0xFFFF8414)
#define I2C0_OAR2_ADD8_MASK 0x2
#define I2C0_OAR2_ADD8 0x2
#define I2C0_OAR2_ADD8_BIT 1
#define I2C0_OAR2_ADD9_MASK 0x4
#define I2C0_OAR2_ADD9 0x4
#define I2C0_OAR2_ADD9_BIT 2
#define I2C0_OAR2_FR0_MASK 0x20
#define I2C0_OAR2_FR0 0x20
#define I2C0_OAR2_FR0_BIT 5
#define I2C0_OAR2_FR1_MASK 0x40
#define I2C0_OAR2_FR1 0x40
#define I2C0_OAR2_FR1_BIT 6
#define I2C0_OAR2_FR2_MASK 0x80
#define I2C0_OAR2_FR2 0x80
#define I2C0_OAR2_FR2_BIT 7

#define I2C0_DR (*(volatile unsigned char *)0xFFFF8418)
#define I2C0_DR_D0_MASK 0x1
#define I2C0_DR_D0 0x1
#define I2C0_DR_D0_BIT 0
#define I2C0_DR_D1_MASK 0x2
#define I2C0_DR_D1 0x2
#define I2C0_DR_D1_BIT 1
#define I2C0_DR_D2_MASK 0x4
#define I2C0_DR_D2 0x4
#define I2C0_DR_D2_BIT 2
#define I2C0_DR_D3_MASK 0x8
#define I2C0_DR_D3 0x8
#define I2C0_DR_D3_BIT 3
#define I2C0_DR_D4_MASK 0x10
#define I2C0_DR_D4 0x10
#define I2C0_DR_D4_BIT 4
#define I2C0_DR_D5_MASK 0x20
#define I2C0_DR_D5 0x20
#define I2C0_DR_D5_BIT 5
#define I2C0_DR_D6_MASK 0x40
#define I2C0_DR_D6 0x40
#define I2C0_DR_D6_BIT 6
#define I2C0_DR_D7_MASK 0x80
#define I2C0_DR_D7 0x80
#define I2C0_DR_D7_BIT 7

#define I2C0_ECCR (*(volatile unsigned char *)0xFFFF841C)
#define I2C0_ECCR_CC7_MASK 0x1
#define I2C0_ECCR_CC7 0x1
#define I2C0_ECCR_CC7_BIT 0
#define I2C0_ECCR_CC8_MASK 0x2
#define I2C0_ECCR_CC8 0x2
#define I2C0_ECCR_CC8_BIT 1
#define I2C0_ECCR_CC9_MASK 0x4
#define I2C0_ECCR_CC9 0x4
#define I2C0_ECCR_CC9_BIT 2
#define I2C0_ECCR_CC10_MASK 0x8
#define I2C0_ECCR_CC10 0x8
#define I2C0_ECCR_CC10_BIT 3
#define I2C0_ECCR_CC11_MASK 0x10
#define I2C0_ECCR_CC11 0x10
#define I2C0_ECCR_CC11_BIT 4

#define I2C1_CR (*(volatile unsigned char *)0xFFFF8800)
#define I2C1_CR_ITE_MASK 0x1
#define I2C1_CR_ITE 0x1
#define I2C1_CR_ITE_BIT 0
#define I2C1_CR_STOP_MASK 0x2
#define I2C1_CR_STOP 0x2
#define I2C1_CR_STOP_BIT 1
#define I2C1_CR_ACK_MASK 0x4
#define I2C1_CR_ACK 0x4
#define I2C1_CR_ACK_BIT 2
#define I2C1_CR_START_MASK 0x8
#define I2C1_CR_START 0x8
#define I2C1_CR_START_BIT 3
#define I2C1_CR_ENGC_MASK 0x10
#define I2C1_CR_ENGC 0x10
#define I2C1_CR_ENGC_BIT 4
#define I2C1_CR_PE_MASK 0x20
#define I2C1_CR_PE 0x20
#define I2C1_CR_PE_BIT 5

#define I2C1_SR1 (*(volatile unsigned char *)0xFFFF8804)
#define I2C1_SR1_SB_MASK 0x1
#define I2C1_SR1_SB 0x1
#define I2C1_SR1_SB_BIT 0
#define I2C1_SR1_M_SL_MASK 0x2
#define I2C1_SR1_M_SL 0x2
#define I2C1_SR1_M_SL_BIT 1
#define I2C1_SR1_ADSL_MASK 0x4
#define I2C1_SR1_ADSL 0x4
#define I2C1_SR1_ADSL_BIT 2
#define I2C1_SR1_BTF_MASK 0x8
#define I2C1_SR1_BTF 0x8
#define I2C1_SR1_BTF_BIT 3
#define I2C1_SR1_BUSY_MASK 0x10
#define I2C1_SR1_BUSY 0x10
#define I2C1_SR1_BUSY_BIT 4
#define I2C1_SR1_TRA_MASK 0x20
#define I2C1_SR1_TRA 0x20
#define I2C1_SR1_TRA_BIT 5
#define I2C1_SR1_ADD10_MASK 0x40
#define I2C1_SR1_ADD10 0x40
#define I2C1_SR1_ADD10_BIT 6
#define I2C1_SR1_EVF_MASK 0x80
#define I2C1_SR1_EVF 0x80
#define I2C1_SR1_EVF_BIT 7

#define I2C1_SR2 (*(volatile unsigned char *)0xFFFF8808)
#define I2C1_SR2_GCAL_MASK 0x1
#define I2C1_SR2_GCAL 0x1
#define I2C1_SR2_GCAL_BIT 0
#define I2C1_SR2_BERR_MASK 0x2
#define I2C1_SR2_BERR 0x2
#define I2C1_SR2_BERR_BIT 1
#define I2C1_SR2_ARLO_MASK 0x4
#define I2C1_SR2_ARLO 0x4
#define I2C1_SR2_ARLO_BIT 2
#define I2C1_SR2_STOPF_MASK 0x8
#define I2C1_SR2_STOPF 0x8
#define I2C1_SR2_STOPF_BIT 3
#define I2C1_SR2_AF_MASK 0x10
#define I2C1_SR2_AF 0x10
#define I2C1_SR2_AF_BIT 4
#define I2C1_SR2_ENDAD_MASK 0x20
#define I2C1_SR2_ENDAD 0x20
#define I2C1_SR2_ENDAD_BIT 5

#define I2C1_CCR (*(volatile unsigned char *)0xFFFF880C)
#define I2C1_CCR_CC0_MASK 0x1
#define I2C1_CCR_CC0 0x1
#define I2C1_CCR_CC0_BIT 0
#define I2C1_CCR_CC1_MASK 0x2
#define I2C1_CCR_CC1 0x2
#define I2C1_CCR_CC1_BIT 1
#define I2C1_CCR_CC2_MASK 0x4
#define I2C1_CCR_CC2 0x4
#define I2C1_CCR_CC2_BIT 2
#define I2C1_CCR_CC3_MASK 0x8
#define I2C1_CCR_CC3 0x8
#define I2C1_CCR_CC3_BIT 3
#define I2C1_CCR_CC4_MASK 0x10
#define I2C1_CCR_CC4 0x10
#define I2C1_CCR_CC4_BIT 4
#define I2C1_CCR_CC5_MASK 0x20
#define I2C1_CCR_CC5 0x20
#define I2C1_CCR_CC5_BIT 5
#define I2C1_CCR_CC6_MASK 0x40
#define I2C1_CCR_CC6 0x40
#define I2C1_CCR_CC6_BIT 6
#define I2C1_CCR_FM_SM_MASK 0x80
#define I2C1_CCR_FM_SM 0x80
#define I2C1_CCR_FM_SM_BIT 7

#define I2C1_OAR1 (*(volatile unsigned char *)0xFFFF8810)
#define I2C1_OAR1_ADD0_MASK 0x1
#define I2C1_OAR1_ADD0 0x1
#define I2C1_OAR1_ADD0_BIT 0
#define I2C1_OAR1_ADD1_MASK 0x2
#define I2C1_OAR1_ADD1 0x2
#define I2C1_OAR1_ADD1_BIT 1
#define I2C1_OAR1_ADD2_MASK 0x4
#define I2C1_OAR1_ADD2 0x4
#define I2C1_OAR1_ADD2_BIT 2
#define I2C1_OAR1_ADD3_MASK 0x8
#define I2C1_OAR1_ADD3 0x8
#define I2C1_OAR1_ADD3_BIT 3
#define I2C1_OAR1_ADD4_MASK 0x10
#define I2C1_OAR1_ADD4 0x10
#define I2C1_OAR1_ADD4_BIT 4
#define I2C1_OAR1_ADD5_MASK 0x20
#define I2C1_OAR1_ADD5 0x20
#define I2C1_OAR1_ADD5_BIT 5
#define I2C1_OAR1_ADD6_MASK 0x40
#define I2C1_OAR1_ADD6 0x40
#define I2C1_OAR1_ADD6_BIT 6
#define I2C1_OAR1_ADD7_MASK 0x80
#define I2C1_OAR1_ADD7 0x80
#define I2C1_OAR1_ADD7_BIT 7

#define I2C1_OAR2 (*(volatile unsigned char *)0xFFFF8814)
#define I2C1_OAR2_ADD8_MASK 0x2
#define I2C1_OAR2_ADD8 0x2
#define I2C1_OAR2_ADD8_BIT 1
#define I2C1_OAR2_ADD9_MASK 0x4
#define I2C1_OAR2_ADD9 0x4
#define I2C1_OAR2_ADD9_BIT 2
#define I2C1_OAR2_FR0_MASK 0x20
#define I2C1_OAR2_FR0 0x20
#define I2C1_OAR2_FR0_BIT 5
#define I2C1_OAR2_FR1_MASK 0x40
#define I2C1_OAR2_FR1 0x40
#define I2C1_OAR2_FR1_BIT 6
#define I2C1_OAR2_FR2_MASK 0x80
#define I2C1_OAR2_FR2 0x80
#define I2C1_OAR2_FR2_BIT 7

#define I2C1_DR (*(volatile unsigned char *)0xFFFF8818)
#define I2C1_DR_D0_MASK 0x1
#define I2C1_DR_D0 0x1
#define I2C1_DR_D0_BIT 0
#define I2C1_DR_D1_MASK 0x2
#define I2C1_DR_D1 0x2
#define I2C1_DR_D1_BIT 1
#define I2C1_DR_D2_MASK 0x4
#define I2C1_DR_D2 0x4
#define I2C1_DR_D2_BIT 2
#define I2C1_DR_D3_MASK 0x8
#define I2C1_DR_D3 0x8
#define I2C1_DR_D3_BIT 3
#define I2C1_DR_D4_MASK 0x10
#define I2C1_DR_D4 0x10
#define I2C1_DR_D4_BIT 4
#define I2C1_DR_D5_MASK 0x20
#define I2C1_DR_D5 0x20
#define I2C1_DR_D5_BIT 5
#define I2C1_DR_D6_MASK 0x40
#define I2C1_DR_D6 0x40
#define I2C1_DR_D6_BIT 6
#define I2C1_DR_D7_MASK 0x80
#define I2C1_DR_D7 0x80
#define I2C1_DR_D7_BIT 7

#define I2C1_ECCR (*(volatile unsigned char *)0xFFFF881C)
#define I2C1_ECCR_CC7_MASK 0x1
#define I2C1_ECCR_CC7 0x1
#define I2C1_ECCR_CC7_BIT 0
#define I2C1_ECCR_CC8_MASK 0x2
#define I2C1_ECCR_CC8 0x2
#define I2C1_ECCR_CC8_BIT 1
#define I2C1_ECCR_CC9_MASK 0x4
#define I2C1_ECCR_CC9 0x4
#define I2C1_ECCR_CC9_BIT 2
#define I2C1_ECCR_CC10_MASK 0x8
#define I2C1_ECCR_CC10 0x8
#define I2C1_ECCR_CC10_BIT 3
#define I2C1_ECCR_CC11_MASK 0x10
#define I2C1_ECCR_CC11 0x10
#define I2C1_ECCR_CC11_BIT 4

#define TB0_CR (*(volatile unsigned short *)0xFFFF9800)
#define TB0_CR_SC_MASK 0x2
#define TB0_CR_SC 0x2
#define TB0_CR_SC_BIT 1
#define TB0_CR_EE_MASK 0x4
#define TB0_CR_EE 0x4
#define TB0_CR_EE_BIT 2

#define TB0_PR (*(volatile unsigned short *)0xFFFF9804)

#define TB0_VR (*(volatile unsigned short *)0xFFFF9808)

#define TB0_CNT (*(volatile unsigned short *)0xFFFF980C)

#define TB0_SR (*(volatile unsigned short *)0xFFFF9810)
#define TB0_SR_EC_MASK 0x1
#define TB0_SR_EC 0x1
#define TB0_SR_EC_BIT 0

#define TB0_MR (*(volatile unsigned short *)0xFFFF9814)
#define TB0_MR_ECM_MASK 0x1
#define TB0_MR_ECM 0x1
#define TB0_MR_ECM_BIT 0

#define TB1_CR (*(volatile unsigned short *)0xFFFF9900)
#define TB1_CR_SC_MASK 0x2
#define TB1_CR_SC 0x2
#define TB1_CR_SC_BIT 1
#define TB1_CR_EE_MASK 0x4
#define TB1_CR_EE 0x4
#define TB1_CR_EE_BIT 2

#define TB1_PR (*(volatile unsigned short *)0xFFFF9904)

#define TB1_VR (*(volatile unsigned short *)0xFFFF9908)

#define TB1_CNT (*(volatile unsigned short *)0xFFFF990C)

#define TB1_SR (*(volatile unsigned short *)0xFFFF9910)
#define TB1_SR_EC_MASK 0x1
#define TB1_SR_EC 0x1
#define TB1_SR_EC_BIT 0

#define TB1_MR (*(volatile unsigned short *)0xFFFF9914)
#define TB1_MR_ECM_MASK 0x1
#define TB1_MR_ECM 0x1
#define TB1_MR_ECM_BIT 0

#define TB2_CR (*(volatile unsigned short *)0xFFFF9A00)
#define TB2_CR_SC_MASK 0x2
#define TB2_CR_SC 0x2
#define TB2_CR_SC_BIT 1
#define TB2_CR_EE_MASK 0x4
#define TB2_CR_EE 0x4
#define TB2_CR_EE_BIT 2

#define TB2_PR (*(volatile unsigned short *)0xFFFF9A04)

#define TB2_VR (*(volatile unsigned short *)0xFFFF9A08)

#define TB2_CNT (*(volatile unsigned short *)0xFFFF9A0C)

#define TB2_SR (*(volatile unsigned short *)0xFFFF9A10)
#define TB2_SR_EC_MASK 0x1
#define TB2_SR_EC 0x1
#define TB2_SR_EC_BIT 0

#define TB2_MR (*(volatile unsigned short *)0xFFFF9A14)
#define TB2_MR_ECM_MASK 0x1
#define TB2_MR_ECM 0x1
#define TB2_MR_ECM_BIT 0

#define UART0_BR (*(volatile unsigned short *)0xFFFF9C00)

#define UART0_TxBUFR (*(volatile unsigned short *)0xFFFF9C04)

#define UART0_RxBUFR (*(volatile unsigned short *)0xFFFF9C08)

#define UART0_CR (*(volatile unsigned short *)0xFFFF9C0C)
#define UART0_CR_Mode_MASK 0x7
#define UART0_CR_Mode_BIT 0
#define UART0_CR_Stop_Bits_MASK 0x18
#define UART0_CR_Stop_Bits_BIT 3
#define UART0_CR_Parity_Odd_MASK 0x20
#define UART0_CR_Parity_Odd 0x20
#define UART0_CR_Parity_Odd_BIT 5
#define UART0_CR_Loop_Back_MASK 0x40
#define UART0_CR_Loop_Back 0x40
#define UART0_CR_Loop_Back_BIT 6
#define UART0_CR_Run_MASK 0x80
#define UART0_CR_Run 0x80
#define UART0_CR_Run_BIT 7
#define UART0_CR_RxEnable_MASK 0x100
#define UART0_CR_RxEnable 0x100
#define UART0_CR_RxEnable_BIT 8
#define UART0_CR_FifoEnable_MASK 0x400
#define UART0_CR_FifoEnable 0x400
#define UART0_CR_FifoEnable_BIT 10

#define UART0_IER (*(volatile unsigned short *)0xFFFF9C10)

#define UART0_SR (*(volatile unsigned short *)0xFFFF9C14)

#define UART0_TOR (*(volatile unsigned short *)0xFFFF9C1C)

#define UART0_TxRSTR (*(volatile unsigned short *)0xFFFF9C20)

#define UART0_RxRSTR (*(volatile unsigned short *)0xFFFF9C24)

#define UART2_BR (*(volatile unsigned short *)0xFFFF9E00)

#define UART2_TxBUFR (*(volatile unsigned short *)0xFFFF9E04)

#define UART2_RxBUFR (*(volatile unsigned short *)0xFFFF9E08)

#define UART2_CR (*(volatile unsigned short *)0xFFFF9E0C)
#define UART2_CR_Mode_MASK 0x7
#define UART2_CR_Mode_BIT 0
#define UART2_CR_Stop_Bits_MASK 0x18
#define UART2_CR_Stop_Bits_BIT 3
#define UART2_CR_Parity_Odd_MASK 0x20
#define UART2_CR_Parity_Odd 0x20
#define UART2_CR_Parity_Odd_BIT 5
#define UART2_CR_Loop_Back_MASK 0x40
#define UART2_CR_Loop_Back 0x40
#define UART2_CR_Loop_Back_BIT 6
#define UART2_CR_Run_MASK 0x80
#define UART2_CR_Run 0x80
#define UART2_CR_Run_BIT 7
#define UART2_CR_RxEnable_MASK 0x100
#define UART2_CR_RxEnable 0x100
#define UART2_CR_RxEnable_BIT 8
#define UART2_CR_FifoEnable_MASK 0x400
#define UART2_CR_FifoEnable 0x400
#define UART2_CR_FifoEnable_BIT 10

#define UART2_IER (*(volatile unsigned short *)0xFFFF9E10)

#define UART2_SR (*(volatile unsigned short *)0xFFFF9E14)

#define UART2_TOR (*(volatile unsigned short *)0xFFFF9E1C)

#define UART2_TxRSTR (*(volatile unsigned short *)0xFFFF9E20)

#define UART2_RxRSTR (*(volatile unsigned short *)0xFFFF9E24)

#define UART1_BR (*(volatile unsigned short *)0xFFFFA000)

#define UART1_TxBUFR (*(volatile unsigned short *)0xFFFFA004)

#define UART1_RxBUFR (*(volatile unsigned short *)0xFFFFA008)

#define UART1_CR (*(volatile unsigned short *)0xFFFFA00C)
#define UART1_CR_Mode_MASK 0x7
#define UART1_CR_Mode_BIT 0
#define UART1_CR_Stop_Bits_MASK 0x18
#define UART1_CR_Stop_Bits_BIT 3
#define UART1_CR_Parity_Odd_MASK 0x20
#define UART1_CR_Parity_Odd 0x20
#define UART1_CR_Parity_Odd_BIT 5
#define UART1_CR_Loop_Back_MASK 0x40
#define UART1_CR_Loop_Back 0x40
#define UART1_CR_Loop_Back_BIT 6
#define UART1_CR_Run_MASK 0x80
#define UART1_CR_Run 0x80
#define UART1_CR_Run_BIT 7
#define UART1_CR_RxEnable_MASK 0x100
#define UART1_CR_RxEnable 0x100
#define UART1_CR_RxEnable_BIT 8
#define UART1_CR_FifoEnable_MASK 0x400
#define UART1_CR_FifoEnable 0x400
#define UART1_CR_FifoEnable_BIT 10

#define UART1_IER (*(volatile unsigned short *)0xFFFFA010)

#define UART1_SR (*(volatile unsigned short *)0xFFFFA014)

#define UART1_TOR (*(volatile unsigned short *)0xFFFFA01C)

#define UART1_TxRSTR (*(volatile unsigned short *)0xFFFFA020)

#define UART1_RxRSTR (*(volatile unsigned short *)0xFFFFA024)

#define UART3_BR (*(volatile unsigned short *)0xFFFFA200)

#define UART3_TxBUFR (*(volatile unsigned short *)0xFFFFA204)

#define UART3_RxBUFR (*(volatile unsigned short *)0xFFFFA208)

#define UART3_CR (*(volatile unsigned short *)0xFFFFA20C)
#define UART3_CR_Mode_MASK 0x7
#define UART3_CR_Mode_BIT 0
#define UART3_CR_Stop_Bits_MASK 0x18
#define UART3_CR_Stop_Bits_BIT 3
#define UART3_CR_Parity_Odd_MASK 0x20
#define UART3_CR_Parity_Odd 0x20
#define UART3_CR_Parity_Odd_BIT 5
#define UART3_CR_Loop_Back_MASK 0x40
#define UART3_CR_Loop_Back 0x40
#define UART3_CR_Loop_Back_BIT 6
#define UART3_CR_Run_MASK 0x80
#define UART3_CR_Run 0x80
#define UART3_CR_Run_BIT 7
#define UART3_CR_RxEnable_MASK 0x100
#define UART3_CR_RxEnable 0x100
#define UART3_CR_RxEnable_BIT 8
#define UART3_CR_FifoEnable_MASK 0x400
#define UART3_CR_FifoEnable 0x400
#define UART3_CR_FifoEnable_BIT 10

#define UART3_IER (*(volatile unsigned short *)0xFFFFA210)

#define UART3_SR (*(volatile unsigned short *)0xFFFFA214)

#define UART3_TOR (*(volatile unsigned short *)0xFFFFA21C)

#define UART3_TxRSTR (*(volatile unsigned short *)0xFFFFA220)

#define UART3_RxRSTR (*(volatile unsigned short *)0xFFFFA224)

#define WDG_CR (*(volatile unsigned short *)0xFFFFA400)
#define WDG_CR_WE_MASK 0x1
#define WDG_CR_WE 0x1
#define WDG_CR_WE_BIT 0
#define WDG_CR_SC_MASK 0x2
#define WDG_CR_SC 0x2
#define WDG_CR_SC_BIT 1

#define WDG_PR (*(volatile unsigned short *)0xFFFFA404)
#define WDG_PR_PR_MASK 0xFF
#define WDG_PR_PR_BIT 0

#define WDG_VR (*(volatile unsigned short *)0xFFFFA408)

#define WDG_CNT (*(volatile unsigned short *)0xFFFFA40C)

#define WDG_SR (*(volatile unsigned short *)0xFFFFA410)

#define WDG_MR (*(volatile unsigned short *)0xFFFFA414)

#define WDG_KR (*(volatile unsigned short *)0xFFFFA418)

#define WUT_CR (*(volatile unsigned short *)0xFFFFA600)
#define WUT_CR_WE_MASK 0x1
#define WUT_CR_WE 0x1
#define WUT_CR_WE_BIT 0
#define WUT_CR_SC_MASK 0x2
#define WUT_CR_SC 0x2
#define WUT_CR_SC_BIT 1
#define WUT_CR_EE_MASK 0x4
#define WUT_CR_EE 0x4
#define WUT_CR_EE_BIT 2

#define WUT_PR (*(volatile unsigned short *)0xFFFFA604)
#define WUT_PR_PR_MASK 0xFF
#define WUT_PR_PR_BIT 0

#define WUT_VR (*(volatile unsigned short *)0xFFFFA608)

#define WUT_CNT (*(volatile unsigned short *)0xFFFFA60C)

#define WUT_SR (*(volatile unsigned short *)0xFFFFA610)
#define WUT_SR_EC_MASK 0x1
#define WUT_SR_EC 0x1
#define WUT_SR_EC_BIT 0
#define WUT_SR_BSYCR_MASK 0x2
#define WUT_SR_BSYCR 0x2
#define WUT_SR_BSYCR_BIT 1
#define WUT_SR_BSYPR_MASK 0x4
#define WUT_SR_BSYPR 0x4
#define WUT_SR_BSYPR_BIT 2
#define WUT_SR_BSYVR_MASK 0x8
#define WUT_SR_BSYVR 0x8
#define WUT_SR_BSYVR_BIT 3

#define WUT_MR (*(volatile unsigned short *)0xFFFFA614)
#define WUT_MR_ECM_MASK 0x1
#define WUT_MR_ECM 0x1
#define WUT_MR_ECM_BIT 0
#define WUT_MR_BSYMSK_MASK 0x2
#define WUT_MR_BSYMSK 0x2
#define WUT_MR_BSYMSK_BIT 1

#define TIM0_ICAR (*(volatile unsigned short *)0xFFFFA800)

#define TIM0_ICBR (*(volatile unsigned short *)0xFFFFA804)

#define TIM0_OCAR (*(volatile unsigned short *)0xFFFFA808)

#define TIM0_OCBR (*(volatile unsigned short *)0xFFFFA80C)

#define TIM0_CNTR (*(volatile unsigned short *)0xFFFFA810)

#define TIM0_CR1 (*(volatile unsigned short *)0xFFFFA814)
#define TIM0_CR1_ECKEN_MASK 0x1
#define TIM0_CR1_ECKEN 0x1
#define TIM0_CR1_ECKEN_BIT 0
#define TIM0_CR1_EXEDG_MASK 0x2
#define TIM0_CR1_EXEDG 0x2
#define TIM0_CR1_EXEDG_BIT 1
#define TIM0_CR1_IEDGA_MASK 0x4
#define TIM0_CR1_IEDGA 0x4
#define TIM0_CR1_IEDGA_BIT 2
#define TIM0_CR1_IEDGB_MASK 0x8
#define TIM0_CR1_IEDGB 0x8
#define TIM0_CR1_IEDGB_BIT 3
#define TIM0_CR1_PWM_MASK 0x10
#define TIM0_CR1_PWM 0x10
#define TIM0_CR1_PWM_BIT 4
#define TIM0_CR1_OPM_MASK 0x20
#define TIM0_CR1_OPM 0x20
#define TIM0_CR1_OPM_BIT 5
#define TIM0_CR1_OCAE_MASK 0x40
#define TIM0_CR1_OCAE 0x40
#define TIM0_CR1_OCAE_BIT 6
#define TIM0_CR1_OCBE_MASK 0x80
#define TIM0_CR1_OCBE 0x80
#define TIM0_CR1_OCBE_BIT 7
#define TIM0_CR1_OLVLA_MASK 0x100
#define TIM0_CR1_OLVLA 0x100
#define TIM0_CR1_OLVLA_BIT 8
#define TIM0_CR1_OLVLB_MASK 0x200
#define TIM0_CR1_OLVLB 0x200
#define TIM0_CR1_OLVLB_BIT 9
#define TIM0_CR1_FOLVLA_MASK 0x400
#define TIM0_CR1_FOLVLA 0x400
#define TIM0_CR1_FOLVLA_BIT 10
#define TIM0_CR1_FOLVLB_MASK 0x800
#define TIM0_CR1_FOLVLB 0x800
#define TIM0_CR1_FOLVLB_BIT 11
#define TIM0_CR1_DMAS0_MASK 0x1000
#define TIM0_CR1_DMAS0 0x1000
#define TIM0_CR1_DMAS0_BIT 12
#define TIM0_CR1_DMAS1_MASK 0x2000
#define TIM0_CR1_DMAS1 0x2000
#define TIM0_CR1_DMAS1_BIT 13
#define TIM0_CR1_PWMI_MASK 0x4000
#define TIM0_CR1_PWMI 0x4000
#define TIM0_CR1_PWMI_BIT 14
#define TIM0_CR1_EN_MASK 0x8000
#define TIM0_CR1_EN 0x8000
#define TIM0_CR1_EN_BIT 15

#define TIM0_CR2 (*(volatile unsigned short *)0xFFFFA818)
#define TIM0_CR2_CC0_MASK 0x1
#define TIM0_CR2_CC0 0x1
#define TIM0_CR2_CC0_BIT 0
#define TIM0_CR2_CC1_MASK 0x2
#define TIM0_CR2_CC1 0x2
#define TIM0_CR2_CC1_BIT 1
#define TIM0_CR2_CC2_MASK 0x4
#define TIM0_CR2_CC2 0x4
#define TIM0_CR2_CC2_BIT 2
#define TIM0_CR2_CC3_MASK 0x8
#define TIM0_CR2_CC3 0x8
#define TIM0_CR2_CC3_BIT 3
#define TIM0_CR2_CC4_MASK 0x10
#define TIM0_CR2_CC4 0x10
#define TIM0_CR2_CC4_BIT 4
#define TIM0_CR2_CC5_MASK 0x20
#define TIM0_CR2_CC5 0x20
#define TIM0_CR2_CC5_BIT 5
#define TIM0_CR2_CC6_MASK 0x40
#define TIM0_CR2_CC6 0x40
#define TIM0_CR2_CC6_BIT 6
#define TIM0_CR2_CC7_MASK 0x80
#define TIM0_CR2_CC7 0x80
#define TIM0_CR2_CC7_BIT 7
#define TIM0_CR2_DMAIE_MASK 0x400
#define TIM0_CR2_DMAIE 0x400
#define TIM0_CR2_DMAIE_BIT 10
#define TIM0_CR2_OCBIE_MASK 0x800
#define TIM0_CR2_OCBIE 0x800
#define TIM0_CR2_OCBIE_BIT 11
#define TIM0_CR2_ICBIE_MASK 0x1000
#define TIM0_CR2_ICBIE 0x1000
#define TIM0_CR2_ICBIE_BIT 12
#define TIM0_CR2_TOE_MASK 0x2000
#define TIM0_CR2_TOE 0x2000
#define TIM0_CR2_TOE_BIT 13
#define TIM0_CR2_OCAIE_MASK 0x4000
#define TIM0_CR2_OCAIE 0x4000
#define TIM0_CR2_OCAIE_BIT 14
#define TIM0_CR2_ICAIE_MASK 0x8000
#define TIM0_CR2_ICAIE 0x8000
#define TIM0_CR2_ICAIE_BIT 15

#define TIM0_SR (*(volatile unsigned short *)0xFFFFA81C)
#define TIM0_SR_OCFB_MASK 0x800
#define TIM0_SR_OCFB 0x800
#define TIM0_SR_OCFB_BIT 11
#define TIM0_SR_ICFB_MASK 0x1000
#define TIM0_SR_ICFB 0x1000
#define TIM0_SR_ICFB_BIT 12
#define TIM0_SR_TOF_MASK 0x2000
#define TIM0_SR_TOF 0x2000
#define TIM0_SR_TOF_BIT 13
#define TIM0_SR_OCFA_MASK 0x4000
#define TIM0_SR_OCFA 0x4000
#define TIM0_SR_OCFA_BIT 14
#define TIM0_SR_ICFA_MASK 0x8000
#define TIM0_SR_ICFA 0x8000
#define TIM0_SR_ICFA_BIT 15

#define TIM1_ICAR (*(volatile unsigned short *)0xFFFFAC00)

#define TIM1_ICBR (*(volatile unsigned short *)0xFFFFAC04)

#define TIM1_OCAR (*(volatile unsigned short *)0xFFFFAC08)

#define TIM1_OCBR (*(volatile unsigned short *)0xFFFFAC0C)

#define TIM1_CNTR (*(volatile unsigned short *)0xFFFFAC10)

#define TIM1_CR1 (*(volatile unsigned short *)0xFFFFAC14)
#define TIM1_CR1_ECKEN_MASK 0x1
#define TIM1_CR1_ECKEN 0x1
#define TIM1_CR1_ECKEN_BIT 0
#define TIM1_CR1_EXEDG_MASK 0x2
#define TIM1_CR1_EXEDG 0x2
#define TIM1_CR1_EXEDG_BIT 1
#define TIM1_CR1_IEDGA_MASK 0x4
#define TIM1_CR1_IEDGA 0x4
#define TIM1_CR1_IEDGA_BIT 2
#define TIM1_CR1_IEDGB_MASK 0x8
#define TIM1_CR1_IEDGB 0x8
#define TIM1_CR1_IEDGB_BIT 3
#define TIM1_CR1_PWM_MASK 0x10
#define TIM1_CR1_PWM 0x10
#define TIM1_CR1_PWM_BIT 4
#define TIM1_CR1_OPM_MASK 0x20
#define TIM1_CR1_OPM 0x20
#define TIM1_CR1_OPM_BIT 5
#define TIM1_CR1_OCAE_MASK 0x40
#define TIM1_CR1_OCAE 0x40
#define TIM1_CR1_OCAE_BIT 6
#define TIM1_CR1_OCBE_MASK 0x80
#define TIM1_CR1_OCBE 0x80
#define TIM1_CR1_OCBE_BIT 7
#define TIM1_CR1_OLVLA_MASK 0x100
#define TIM1_CR1_OLVLA 0x100
#define TIM1_CR1_OLVLA_BIT 8
#define TIM1_CR1_OLVLB_MASK 0x200
#define TIM1_CR1_OLVLB 0x200
#define TIM1_CR1_OLVLB_BIT 9
#define TIM1_CR1_FOLVLA_MASK 0x400
#define TIM1_CR1_FOLVLA 0x400
#define TIM1_CR1_FOLVLA_BIT 10
#define TIM1_CR1_FOLVLB_MASK 0x800
#define TIM1_CR1_FOLVLB 0x800
#define TIM1_CR1_FOLVLB_BIT 11
#define TIM1_CR1_DMAS0_MASK 0x1000
#define TIM1_CR1_DMAS0 0x1000
#define TIM1_CR1_DMAS0_BIT 12
#define TIM1_CR1_DMAS1_MASK 0x2000
#define TIM1_CR1_DMAS1 0x2000
#define TIM1_CR1_DMAS1_BIT 13
#define TIM1_CR1_PWMI_MASK 0x4000
#define TIM1_CR1_PWMI 0x4000
#define TIM1_CR1_PWMI_BIT 14
#define TIM1_CR1_EN_MASK 0x8000
#define TIM1_CR1_EN 0x8000
#define TIM1_CR1_EN_BIT 15

#define TIM1_CR2 (*(volatile unsigned short *)0xFFFFAC18)
#define TIM1_CR2_CC0_MASK 0x1
#define TIM1_CR2_CC0 0x1
#define TIM1_CR2_CC0_BIT 0
#define TIM1_CR2_CC1_MASK 0x2
#define TIM1_CR2_CC1 0x2
#define TIM1_CR2_CC1_BIT 1
#define TIM1_CR2_CC2_MASK 0x4
#define TIM1_CR2_CC2 0x4
#define TIM1_CR2_CC2_BIT 2
#define TIM1_CR2_CC3_MASK 0x8
#define TIM1_CR2_CC3 0x8
#define TIM1_CR2_CC3_BIT 3
#define TIM1_CR2_CC4_MASK 0x10
#define TIM1_CR2_CC4 0x10
#define TIM1_CR2_CC4_BIT 4
#define TIM1_CR2_CC5_MASK 0x20
#define TIM1_CR2_CC5 0x20
#define TIM1_CR2_CC5_BIT 5
#define TIM1_CR2_CC6_MASK 0x40
#define TIM1_CR2_CC6 0x40
#define TIM1_CR2_CC6_BIT 6
#define TIM1_CR2_CC7_MASK 0x80
#define TIM1_CR2_CC7 0x80
#define TIM1_CR2_CC7_BIT 7
#define TIM1_CR2_DMAIE_MASK 0x400
#define TIM1_CR2_DMAIE 0x400
#define TIM1_CR2_DMAIE_BIT 10
#define TIM1_CR2_OCBIE_MASK 0x800
#define TIM1_CR2_OCBIE 0x800
#define TIM1_CR2_OCBIE_BIT 11
#define TIM1_CR2_ICBIE_MASK 0x1000
#define TIM1_CR2_ICBIE 0x1000
#define TIM1_CR2_ICBIE_BIT 12
#define TIM1_CR2_TOE_MASK 0x2000
#define TIM1_CR2_TOE 0x2000
#define TIM1_CR2_TOE_BIT 13
#define TIM1_CR2_OCAIE_MASK 0x4000
#define TIM1_CR2_OCAIE 0x4000
#define TIM1_CR2_OCAIE_BIT 14
#define TIM1_CR2_ICAIE_MASK 0x8000
#define TIM1_CR2_ICAIE 0x8000
#define TIM1_CR2_ICAIE_BIT 15

#define TIM1_SR (*(volatile unsigned short *)0xFFFFAC1C)
#define TIM1_SR_OCFB_MASK 0x800
#define TIM1_SR_OCFB 0x800
#define TIM1_SR_OCFB_BIT 11
#define TIM1_SR_ICFB_MASK 0x1000
#define TIM1_SR_ICFB 0x1000
#define TIM1_SR_ICFB_BIT 12
#define TIM1_SR_TOF_MASK 0x2000
#define TIM1_SR_TOF 0x2000
#define TIM1_SR_TOF_BIT 13
#define TIM1_SR_OCFA_MASK 0x4000
#define TIM1_SR_OCFA 0x4000
#define TIM1_SR_OCFA_BIT 14
#define TIM1_SR_ICFA_MASK 0x8000
#define TIM1_SR_ICFA 0x8000
#define TIM1_SR_ICFA_BIT 15

#define TIM5_ICAR (*(volatile unsigned short *)0xFFFFB000)

#define TIM5_ICBR (*(volatile unsigned short *)0xFFFFB004)

#define TIM5_OCAR (*(volatile unsigned short *)0xFFFFB008)

#define TIM5_OCBR (*(volatile unsigned short *)0xFFFFB00C)

#define TIM5_CNTR (*(volatile unsigned short *)0xFFFFB010)

#define TIM5_CR1 (*(volatile unsigned short *)0xFFFFB014)
#define TIM5_CR1_ECKEN_MASK 0x1
#define TIM5_CR1_ECKEN 0x1
#define TIM5_CR1_ECKEN_BIT 0
#define TIM5_CR1_EXEDG_MASK 0x2
#define TIM5_CR1_EXEDG 0x2
#define TIM5_CR1_EXEDG_BIT 1
#define TIM5_CR1_IEDGA_MASK 0x4
#define TIM5_CR1_IEDGA 0x4
#define TIM5_CR1_IEDGA_BIT 2
#define TIM5_CR1_IEDGB_MASK 0x8
#define TIM5_CR1_IEDGB 0x8
#define TIM5_CR1_IEDGB_BIT 3
#define TIM5_CR1_PWM_MASK 0x10
#define TIM5_CR1_PWM 0x10
#define TIM5_CR1_PWM_BIT 4
#define TIM5_CR1_OPM_MASK 0x20
#define TIM5_CR1_OPM 0x20
#define TIM5_CR1_OPM_BIT 5
#define TIM5_CR1_OCAE_MASK 0x40
#define TIM5_CR1_OCAE 0x40
#define TIM5_CR1_OCAE_BIT 6
#define TIM5_CR1_OCBE_MASK 0x80
#define TIM5_CR1_OCBE 0x80
#define TIM5_CR1_OCBE_BIT 7
#define TIM5_CR1_OLVLA_MASK 0x100
#define TIM5_CR1_OLVLA 0x100
#define TIM5_CR1_OLVLA_BIT 8
#define TIM5_CR1_OLVLB_MASK 0x200
#define TIM5_CR1_OLVLB 0x200
#define TIM5_CR1_OLVLB_BIT 9
#define TIM5_CR1_FOLVLA_MASK 0x400
#define TIM5_CR1_FOLVLA 0x400
#define TIM5_CR1_FOLVLA_BIT 10
#define TIM5_CR1_FOLVLB_MASK 0x800
#define TIM5_CR1_FOLVLB 0x800
#define TIM5_CR1_FOLVLB_BIT 11
#define TIM5_CR1_DMAS0_MASK 0x1000
#define TIM5_CR1_DMAS0 0x1000
#define TIM5_CR1_DMAS0_BIT 12
#define TIM5_CR1_DMAS1_MASK 0x2000
#define TIM5_CR1_DMAS1 0x2000
#define TIM5_CR1_DMAS1_BIT 13
#define TIM5_CR1_PWMI_MASK 0x4000
#define TIM5_CR1_PWMI 0x4000
#define TIM5_CR1_PWMI_BIT 14
#define TIM5_CR1_EN_MASK 0x8000
#define TIM5_CR1_EN 0x8000
#define TIM5_CR1_EN_BIT 15

#define TIM5_CR2 (*(volatile unsigned short *)0xFFFFB018)
#define TIM5_CR2_CC0_MASK 0x1
#define TIM5_CR2_CC0 0x1
#define TIM5_CR2_CC0_BIT 0
#define TIM5_CR2_CC1_MASK 0x2
#define TIM5_CR2_CC1 0x2
#define TIM5_CR2_CC1_BIT 1
#define TIM5_CR2_CC2_MASK 0x4
#define TIM5_CR2_CC2 0x4
#define TIM5_CR2_CC2_BIT 2
#define TIM5_CR2_CC3_MASK 0x8
#define TIM5_CR2_CC3 0x8
#define TIM5_CR2_CC3_BIT 3
#define TIM5_CR2_CC4_MASK 0x10
#define TIM5_CR2_CC4 0x10
#define TIM5_CR2_CC4_BIT 4
#define TIM5_CR2_CC5_MASK 0x20
#define TIM5_CR2_CC5 0x20
#define TIM5_CR2_CC5_BIT 5
#define TIM5_CR2_CC6_MASK 0x40
#define TIM5_CR2_CC6 0x40
#define TIM5_CR2_CC6_BIT 6
#define TIM5_CR2_CC7_MASK 0x80
#define TIM5_CR2_CC7 0x80
#define TIM5_CR2_CC7_BIT 7
#define TIM5_CR2_DMAIE_MASK 0x400
#define TIM5_CR2_DMAIE 0x400
#define TIM5_CR2_DMAIE_BIT 10
#define TIM5_CR2_OCBIE_MASK 0x800
#define TIM5_CR2_OCBIE 0x800
#define TIM5_CR2_OCBIE_BIT 11
#define TIM5_CR2_ICBIE_MASK 0x1000
#define TIM5_CR2_ICBIE 0x1000
#define TIM5_CR2_ICBIE_BIT 12
#define TIM5_CR2_TOE_MASK 0x2000
#define TIM5_CR2_TOE 0x2000
#define TIM5_CR2_TOE_BIT 13
#define TIM5_CR2_OCAIE_MASK 0x4000
#define TIM5_CR2_OCAIE 0x4000
#define TIM5_CR2_OCAIE_BIT 14
#define TIM5_CR2_ICAIE_MASK 0x8000
#define TIM5_CR2_ICAIE 0x8000
#define TIM5_CR2_ICAIE_BIT 15

#define TIM5_SR (*(volatile unsigned short *)0xFFFFB01C)
#define TIM5_SR_OCFB_MASK 0x800
#define TIM5_SR_OCFB 0x800
#define TIM5_SR_OCFB_BIT 11
#define TIM5_SR_ICFB_MASK 0x1000
#define TIM5_SR_ICFB 0x1000
#define TIM5_SR_ICFB_BIT 12
#define TIM5_SR_TOF_MASK 0x2000
#define TIM5_SR_TOF 0x2000
#define TIM5_SR_TOF_BIT 13
#define TIM5_SR_OCFA_MASK 0x4000
#define TIM5_SR_OCFA 0x4000
#define TIM5_SR_OCFA_BIT 14
#define TIM5_SR_ICFA_MASK 0x8000
#define TIM5_SR_ICFA 0x8000
#define TIM5_SR_ICFA_BIT 15

#define TIM6_ICAR (*(volatile unsigned short *)0xFFFFB080)

#define TIM6_ICBR (*(volatile unsigned short *)0xFFFFB084)

#define TIM6_OCAR (*(volatile unsigned short *)0xFFFFB088)

#define TIM6_OCBR (*(volatile unsigned short *)0xFFFFB08C)

#define TIM6_CNTR (*(volatile unsigned short *)0xFFFFB090)

#define TIM6_CR1 (*(volatile unsigned short *)0xFFFFB094)
#define TIM6_CR1_ECKEN_MASK 0x1
#define TIM6_CR1_ECKEN 0x1
#define TIM6_CR1_ECKEN_BIT 0
#define TIM6_CR1_EXEDG_MASK 0x2
#define TIM6_CR1_EXEDG 0x2
#define TIM6_CR1_EXEDG_BIT 1
#define TIM6_CR1_IEDGA_MASK 0x4
#define TIM6_CR1_IEDGA 0x4
#define TIM6_CR1_IEDGA_BIT 2
#define TIM6_CR1_IEDGB_MASK 0x8
#define TIM6_CR1_IEDGB 0x8
#define TIM6_CR1_IEDGB_BIT 3
#define TIM6_CR1_PWM_MASK 0x10
#define TIM6_CR1_PWM 0x10
#define TIM6_CR1_PWM_BIT 4
#define TIM6_CR1_OPM_MASK 0x20
#define TIM6_CR1_OPM 0x20
#define TIM6_CR1_OPM_BIT 5
#define TIM6_CR1_OCAE_MASK 0x40
#define TIM6_CR1_OCAE 0x40
#define TIM6_CR1_OCAE_BIT 6
#define TIM6_CR1_OCBE_MASK 0x80
#define TIM6_CR1_OCBE 0x80
#define TIM6_CR1_OCBE_BIT 7
#define TIM6_CR1_OLVLA_MASK 0x100
#define TIM6_CR1_OLVLA 0x100
#define TIM6_CR1_OLVLA_BIT 8
#define TIM6_CR1_OLVLB_MASK 0x200
#define TIM6_CR1_OLVLB 0x200
#define TIM6_CR1_OLVLB_BIT 9
#define TIM6_CR1_FOLVLA_MASK 0x400
#define TIM6_CR1_FOLVLA 0x400
#define TIM6_CR1_FOLVLA_BIT 10
#define TIM6_CR1_FOLVLB_MASK 0x800
#define TIM6_CR1_FOLVLB 0x800
#define TIM6_CR1_FOLVLB_BIT 11
#define TIM6_CR1_DMAS0_MASK 0x1000
#define TIM6_CR1_DMAS0 0x1000
#define TIM6_CR1_DMAS0_BIT 12
#define TIM6_CR1_DMAS1_MASK 0x2000
#define TIM6_CR1_DMAS1 0x2000
#define TIM6_CR1_DMAS1_BIT 13
#define TIM6_CR1_PWMI_MASK 0x4000
#define TIM6_CR1_PWMI 0x4000
#define TIM6_CR1_PWMI_BIT 14
#define TIM6_CR1_EN_MASK 0x8000
#define TIM6_CR1_EN 0x8000
#define TIM6_CR1_EN_BIT 15

#define TIM6_CR2 (*(volatile unsigned short *)0xFFFFB098)
#define TIM6_CR2_CC0_MASK 0x1
#define TIM6_CR2_CC0 0x1
#define TIM6_CR2_CC0_BIT 0
#define TIM6_CR2_CC1_MASK 0x2
#define TIM6_CR2_CC1 0x2
#define TIM6_CR2_CC1_BIT 1
#define TIM6_CR2_CC2_MASK 0x4
#define TIM6_CR2_CC2 0x4
#define TIM6_CR2_CC2_BIT 2
#define TIM6_CR2_CC3_MASK 0x8
#define TIM6_CR2_CC3 0x8
#define TIM6_CR2_CC3_BIT 3
#define TIM6_CR2_CC4_MASK 0x10
#define TIM6_CR2_CC4 0x10
#define TIM6_CR2_CC4_BIT 4
#define TIM6_CR2_CC5_MASK 0x20
#define TIM6_CR2_CC5 0x20
#define TIM6_CR2_CC5_BIT 5
#define TIM6_CR2_CC6_MASK 0x40
#define TIM6_CR2_CC6 0x40
#define TIM6_CR2_CC6_BIT 6
#define TIM6_CR2_CC7_MASK 0x80
#define TIM6_CR2_CC7 0x80
#define TIM6_CR2_CC7_BIT 7
#define TIM6_CR2_DMAIE_MASK 0x400
#define TIM6_CR2_DMAIE 0x400
#define TIM6_CR2_DMAIE_BIT 10
#define TIM6_CR2_OCBIE_MASK 0x800
#define TIM6_CR2_OCBIE 0x800
#define TIM6_CR2_OCBIE_BIT 11
#define TIM6_CR2_ICBIE_MASK 0x1000
#define TIM6_CR2_ICBIE 0x1000
#define TIM6_CR2_ICBIE_BIT 12
#define TIM6_CR2_TOE_MASK 0x2000
#define TIM6_CR2_TOE 0x2000
#define TIM6_CR2_TOE_BIT 13
#define TIM6_CR2_OCAIE_MASK 0x4000
#define TIM6_CR2_OCAIE 0x4000
#define TIM6_CR2_OCAIE_BIT 14
#define TIM6_CR2_ICAIE_MASK 0x8000
#define TIM6_CR2_ICAIE 0x8000
#define TIM6_CR2_ICAIE_BIT 15

#define TIM6_SR (*(volatile unsigned short *)0xFFFFB09C)
#define TIM6_SR_OCFB_MASK 0x800
#define TIM6_SR_OCFB 0x800
#define TIM6_SR_OCFB_BIT 11
#define TIM6_SR_ICFB_MASK 0x1000
#define TIM6_SR_ICFB 0x1000
#define TIM6_SR_ICFB_BIT 12
#define TIM6_SR_TOF_MASK 0x2000
#define TIM6_SR_TOF 0x2000
#define TIM6_SR_TOF_BIT 13
#define TIM6_SR_OCFA_MASK 0x4000
#define TIM6_SR_OCFA 0x4000
#define TIM6_SR_OCFA_BIT 14
#define TIM6_SR_ICFA_MASK 0x8000
#define TIM6_SR_ICFA 0x8000
#define TIM6_SR_ICFA_BIT 15

#define TIM7_ICAR (*(volatile unsigned short *)0xFFFFB100)

#define TIM7_ICBR (*(volatile unsigned short *)0xFFFFB104)

#define TIM7_OCAR (*(volatile unsigned short *)0xFFFFB108)

#define TIM7_OCBR (*(volatile unsigned short *)0xFFFFB10C)

#define TIM7_CNTR (*(volatile unsigned short *)0xFFFFB110)

#define TIM7_CR1 (*(volatile unsigned short *)0xFFFFB114)
#define TIM7_CR1_ECKEN_MASK 0x1
#define TIM7_CR1_ECKEN 0x1
#define TIM7_CR1_ECKEN_BIT 0
#define TIM7_CR1_EXEDG_MASK 0x2
#define TIM7_CR1_EXEDG 0x2
#define TIM7_CR1_EXEDG_BIT 1
#define TIM7_CR1_IEDGA_MASK 0x4
#define TIM7_CR1_IEDGA 0x4
#define TIM7_CR1_IEDGA_BIT 2
#define TIM7_CR1_IEDGB_MASK 0x8
#define TIM7_CR1_IEDGB 0x8
#define TIM7_CR1_IEDGB_BIT 3
#define TIM7_CR1_PWM_MASK 0x10
#define TIM7_CR1_PWM 0x10
#define TIM7_CR1_PWM_BIT 4
#define TIM7_CR1_OPM_MASK 0x20
#define TIM7_CR1_OPM 0x20
#define TIM7_CR1_OPM_BIT 5
#define TIM7_CR1_OCAE_MASK 0x40
#define TIM7_CR1_OCAE 0x40
#define TIM7_CR1_OCAE_BIT 6
#define TIM7_CR1_OCBE_MASK 0x80
#define TIM7_CR1_OCBE 0x80
#define TIM7_CR1_OCBE_BIT 7
#define TIM7_CR1_OLVLA_MASK 0x100
#define TIM7_CR1_OLVLA 0x100
#define TIM7_CR1_OLVLA_BIT 8
#define TIM7_CR1_OLVLB_MASK 0x200
#define TIM7_CR1_OLVLB 0x200
#define TIM7_CR1_OLVLB_BIT 9
#define TIM7_CR1_FOLVLA_MASK 0x400
#define TIM7_CR1_FOLVLA 0x400
#define TIM7_CR1_FOLVLA_BIT 10
#define TIM7_CR1_FOLVLB_MASK 0x800
#define TIM7_CR1_FOLVLB 0x800
#define TIM7_CR1_FOLVLB_BIT 11
#define TIM7_CR1_DMAS0_MASK 0x1000
#define TIM7_CR1_DMAS0 0x1000
#define TIM7_CR1_DMAS0_BIT 12
#define TIM7_CR1_DMAS1_MASK 0x2000
#define TIM7_CR1_DMAS1 0x2000
#define TIM7_CR1_DMAS1_BIT 13
#define TIM7_CR1_PWMI_MASK 0x4000
#define TIM7_CR1_PWMI 0x4000
#define TIM7_CR1_PWMI_BIT 14
#define TIM7_CR1_EN_MASK 0x8000
#define TIM7_CR1_EN 0x8000
#define TIM7_CR1_EN_BIT 15

#define TIM7_CR2 (*(volatile unsigned short *)0xFFFFB118)
#define TIM7_CR2_CC0_MASK 0x1
#define TIM7_CR2_CC0 0x1
#define TIM7_CR2_CC0_BIT 0
#define TIM7_CR2_CC1_MASK 0x2
#define TIM7_CR2_CC1 0x2
#define TIM7_CR2_CC1_BIT 1
#define TIM7_CR2_CC2_MASK 0x4
#define TIM7_CR2_CC2 0x4
#define TIM7_CR2_CC2_BIT 2
#define TIM7_CR2_CC3_MASK 0x8
#define TIM7_CR2_CC3 0x8
#define TIM7_CR2_CC3_BIT 3
#define TIM7_CR2_CC4_MASK 0x10
#define TIM7_CR2_CC4 0x10
#define TIM7_CR2_CC4_BIT 4
#define TIM7_CR2_CC5_MASK 0x20
#define TIM7_CR2_CC5 0x20
#define TIM7_CR2_CC5_BIT 5
#define TIM7_CR2_CC6_MASK 0x40
#define TIM7_CR2_CC6 0x40
#define TIM7_CR2_CC6_BIT 6
#define TIM7_CR2_CC7_MASK 0x80
#define TIM7_CR2_CC7 0x80
#define TIM7_CR2_CC7_BIT 7
#define TIM7_CR2_DMAIE_MASK 0x400
#define TIM7_CR2_DMAIE 0x400
#define TIM7_CR2_DMAIE_BIT 10
#define TIM7_CR2_OCBIE_MASK 0x800
#define TIM7_CR2_OCBIE 0x800
#define TIM7_CR2_OCBIE_BIT 11
#define TIM7_CR2_ICBIE_MASK 0x1000
#define TIM7_CR2_ICBIE 0x1000
#define TIM7_CR2_ICBIE_BIT 12
#define TIM7_CR2_TOE_MASK 0x2000
#define TIM7_CR2_TOE 0x2000
#define TIM7_CR2_TOE_BIT 13
#define TIM7_CR2_OCAIE_MASK 0x4000
#define TIM7_CR2_OCAIE 0x4000
#define TIM7_CR2_OCAIE_BIT 14
#define TIM7_CR2_ICAIE_MASK 0x8000
#define TIM7_CR2_ICAIE 0x8000
#define TIM7_CR2_ICAIE_BIT 15

#define TIM7_SR (*(volatile unsigned short *)0xFFFFB11C)
#define TIM7_SR_OCFB_MASK 0x800
#define TIM7_SR_OCFB 0x800
#define TIM7_SR_OCFB_BIT 11
#define TIM7_SR_ICFB_MASK 0x1000
#define TIM7_SR_ICFB 0x1000
#define TIM7_SR_ICFB_BIT 12
#define TIM7_SR_TOF_MASK 0x2000
#define TIM7_SR_TOF 0x2000
#define TIM7_SR_TOF_BIT 13
#define TIM7_SR_OCFA_MASK 0x4000
#define TIM7_SR_OCFA 0x4000
#define TIM7_SR_OCFA_BIT 14
#define TIM7_SR_ICFA_MASK 0x8000
#define TIM7_SR_ICFA 0x8000
#define TIM7_SR_ICFA_BIT 15

#define TIM8_ICAR (*(volatile unsigned short *)0xFFFFB180)

#define TIM8_ICBR (*(volatile unsigned short *)0xFFFFB184)

#define TIM8_OCAR (*(volatile unsigned short *)0xFFFFB188)

#define TIM8_OCBR (*(volatile unsigned short *)0xFFFFB18C)

#define TIM8_CNTR (*(volatile unsigned short *)0xFFFFB190)

#define TIM8_CR1 (*(volatile unsigned short *)0xFFFFB194)
#define TIM8_CR1_ECKEN_MASK 0x1
#define TIM8_CR1_ECKEN 0x1
#define TIM8_CR1_ECKEN_BIT 0
#define TIM8_CR1_EXEDG_MASK 0x2
#define TIM8_CR1_EXEDG 0x2
#define TIM8_CR1_EXEDG_BIT 1
#define TIM8_CR1_IEDGA_MASK 0x4
#define TIM8_CR1_IEDGA 0x4
#define TIM8_CR1_IEDGA_BIT 2
#define TIM8_CR1_IEDGB_MASK 0x8
#define TIM8_CR1_IEDGB 0x8
#define TIM8_CR1_IEDGB_BIT 3
#define TIM8_CR1_PWM_MASK 0x10
#define TIM8_CR1_PWM 0x10
#define TIM8_CR1_PWM_BIT 4
#define TIM8_CR1_OPM_MASK 0x20
#define TIM8_CR1_OPM 0x20
#define TIM8_CR1_OPM_BIT 5
#define TIM8_CR1_OCAE_MASK 0x40
#define TIM8_CR1_OCAE 0x40
#define TIM8_CR1_OCAE_BIT 6
#define TIM8_CR1_OCBE_MASK 0x80
#define TIM8_CR1_OCBE 0x80
#define TIM8_CR1_OCBE_BIT 7
#define TIM8_CR1_OLVLA_MASK 0x100
#define TIM8_CR1_OLVLA 0x100
#define TIM8_CR1_OLVLA_BIT 8
#define TIM8_CR1_OLVLB_MASK 0x200
#define TIM8_CR1_OLVLB 0x200
#define TIM8_CR1_OLVLB_BIT 9
#define TIM8_CR1_FOLVLA_MASK 0x400
#define TIM8_CR1_FOLVLA 0x400
#define TIM8_CR1_FOLVLA_BIT 10
#define TIM8_CR1_FOLVLB_MASK 0x800
#define TIM8_CR1_FOLVLB 0x800
#define TIM8_CR1_FOLVLB_BIT 11
#define TIM8_CR1_DMAS0_MASK 0x1000
#define TIM8_CR1_DMAS0 0x1000
#define TIM8_CR1_DMAS0_BIT 12
#define TIM8_CR1_DMAS1_MASK 0x2000
#define TIM8_CR1_DMAS1 0x2000
#define TIM8_CR1_DMAS1_BIT 13
#define TIM8_CR1_PWMI_MASK 0x4000
#define TIM8_CR1_PWMI 0x4000
#define TIM8_CR1_PWMI_BIT 14
#define TIM8_CR1_EN_MASK 0x8000
#define TIM8_CR1_EN 0x8000
#define TIM8_CR1_EN_BIT 15

#define TIM8_CR2 (*(volatile unsigned short *)0xFFFFB198)
#define TIM8_CR2_CC0_MASK 0x1
#define TIM8_CR2_CC0 0x1
#define TIM8_CR2_CC0_BIT 0
#define TIM8_CR2_CC1_MASK 0x2
#define TIM8_CR2_CC1 0x2
#define TIM8_CR2_CC1_BIT 1
#define TIM8_CR2_CC2_MASK 0x4
#define TIM8_CR2_CC2 0x4
#define TIM8_CR2_CC2_BIT 2
#define TIM8_CR2_CC3_MASK 0x8
#define TIM8_CR2_CC3 0x8
#define TIM8_CR2_CC3_BIT 3
#define TIM8_CR2_CC4_MASK 0x10
#define TIM8_CR2_CC4 0x10
#define TIM8_CR2_CC4_BIT 4
#define TIM8_CR2_CC5_MASK 0x20
#define TIM8_CR2_CC5 0x20
#define TIM8_CR2_CC5_BIT 5
#define TIM8_CR2_CC6_MASK 0x40
#define TIM8_CR2_CC6 0x40
#define TIM8_CR2_CC6_BIT 6
#define TIM8_CR2_CC7_MASK 0x80
#define TIM8_CR2_CC7 0x80
#define TIM8_CR2_CC7_BIT 7
#define TIM8_CR2_DMAIE_MASK 0x400
#define TIM8_CR2_DMAIE 0x400
#define TIM8_CR2_DMAIE_BIT 10
#define TIM8_CR2_OCBIE_MASK 0x800
#define TIM8_CR2_OCBIE 0x800
#define TIM8_CR2_OCBIE_BIT 11
#define TIM8_CR2_ICBIE_MASK 0x1000
#define TIM8_CR2_ICBIE 0x1000
#define TIM8_CR2_ICBIE_BIT 12
#define TIM8_CR2_TOE_MASK 0x2000
#define TIM8_CR2_TOE 0x2000
#define TIM8_CR2_TOE_BIT 13
#define TIM8_CR2_OCAIE_MASK 0x4000
#define TIM8_CR2_OCAIE 0x4000
#define TIM8_CR2_OCAIE_BIT 14
#define TIM8_CR2_ICAIE_MASK 0x8000
#define TIM8_CR2_ICAIE 0x8000
#define TIM8_CR2_ICAIE_BIT 15

#define TIM8_SR (*(volatile unsigned short *)0xFFFFB19C)
#define TIM8_SR_OCFB_MASK 0x800
#define TIM8_SR_OCFB 0x800
#define TIM8_SR_OCFB_BIT 11
#define TIM8_SR_ICFB_MASK 0x1000
#define TIM8_SR_ICFB 0x1000
#define TIM8_SR_ICFB_BIT 12
#define TIM8_SR_TOF_MASK 0x2000
#define TIM8_SR_TOF 0x2000
#define TIM8_SR_TOF_BIT 13
#define TIM8_SR_OCFA_MASK 0x4000
#define TIM8_SR_OCFA 0x4000
#define TIM8_SR_OCFA_BIT 14
#define TIM8_SR_ICFA_MASK 0x8000
#define TIM8_SR_ICFA 0x8000
#define TIM8_SR_ICFA_BIT 15

#define TIM9_ICAR (*(volatile unsigned short *)0xFFFFB200)

#define TIM9_ICBR (*(volatile unsigned short *)0xFFFFB204)

#define TIM9_OCAR (*(volatile unsigned short *)0xFFFFB208)

#define TIM9_OCBR (*(volatile unsigned short *)0xFFFFB20C)

#define TIM9_CNTR (*(volatile unsigned short *)0xFFFFB210)

#define TIM9_CR1 (*(volatile unsigned short *)0xFFFFB214)
#define TIM9_CR1_ECKEN_MASK 0x1
#define TIM9_CR1_ECKEN 0x1
#define TIM9_CR1_ECKEN_BIT 0
#define TIM9_CR1_EXEDG_MASK 0x2
#define TIM9_CR1_EXEDG 0x2
#define TIM9_CR1_EXEDG_BIT 1
#define TIM9_CR1_IEDGA_MASK 0x4
#define TIM9_CR1_IEDGA 0x4
#define TIM9_CR1_IEDGA_BIT 2
#define TIM9_CR1_IEDGB_MASK 0x8
#define TIM9_CR1_IEDGB 0x8
#define TIM9_CR1_IEDGB_BIT 3
#define TIM9_CR1_PWM_MASK 0x10
#define TIM9_CR1_PWM 0x10
#define TIM9_CR1_PWM_BIT 4
#define TIM9_CR1_OPM_MASK 0x20
#define TIM9_CR1_OPM 0x20
#define TIM9_CR1_OPM_BIT 5
#define TIM9_CR1_OCAE_MASK 0x40
#define TIM9_CR1_OCAE 0x40
#define TIM9_CR1_OCAE_BIT 6
#define TIM9_CR1_OCBE_MASK 0x80
#define TIM9_CR1_OCBE 0x80
#define TIM9_CR1_OCBE_BIT 7
#define TIM9_CR1_OLVLA_MASK 0x100
#define TIM9_CR1_OLVLA 0x100
#define TIM9_CR1_OLVLA_BIT 8
#define TIM9_CR1_OLVLB_MASK 0x200
#define TIM9_CR1_OLVLB 0x200
#define TIM9_CR1_OLVLB_BIT 9
#define TIM9_CR1_FOLVLA_MASK 0x400
#define TIM9_CR1_FOLVLA 0x400
#define TIM9_CR1_FOLVLA_BIT 10
#define TIM9_CR1_FOLVLB_MASK 0x800
#define TIM9_CR1_FOLVLB 0x800
#define TIM9_CR1_FOLVLB_BIT 11
#define TIM9_CR1_DMAS0_MASK 0x1000
#define TIM9_CR1_DMAS0 0x1000
#define TIM9_CR1_DMAS0_BIT 12
#define TIM9_CR1_DMAS1_MASK 0x2000
#define TIM9_CR1_DMAS1 0x2000
#define TIM9_CR1_DMAS1_BIT 13
#define TIM9_CR1_PWMI_MASK 0x4000
#define TIM9_CR1_PWMI 0x4000
#define TIM9_CR1_PWMI_BIT 14
#define TIM9_CR1_EN_MASK 0x8000
#define TIM9_CR1_EN 0x8000
#define TIM9_CR1_EN_BIT 15

#define TIM9_CR2 (*(volatile unsigned short *)0xFFFFB218)
#define TIM9_CR2_CC0_MASK 0x1
#define TIM9_CR2_CC0 0x1
#define TIM9_CR2_CC0_BIT 0
#define TIM9_CR2_CC1_MASK 0x2
#define TIM9_CR2_CC1 0x2
#define TIM9_CR2_CC1_BIT 1
#define TIM9_CR2_CC2_MASK 0x4
#define TIM9_CR2_CC2 0x4
#define TIM9_CR2_CC2_BIT 2
#define TIM9_CR2_CC3_MASK 0x8
#define TIM9_CR2_CC3 0x8
#define TIM9_CR2_CC3_BIT 3
#define TIM9_CR2_CC4_MASK 0x10
#define TIM9_CR2_CC4 0x10
#define TIM9_CR2_CC4_BIT 4
#define TIM9_CR2_CC5_MASK 0x20
#define TIM9_CR2_CC5 0x20
#define TIM9_CR2_CC5_BIT 5
#define TIM9_CR2_CC6_MASK 0x40
#define TIM9_CR2_CC6 0x40
#define TIM9_CR2_CC6_BIT 6
#define TIM9_CR2_CC7_MASK 0x80
#define TIM9_CR2_CC7 0x80
#define TIM9_CR2_CC7_BIT 7
#define TIM9_CR2_DMAIE_MASK 0x400
#define TIM9_CR2_DMAIE 0x400
#define TIM9_CR2_DMAIE_BIT 10
#define TIM9_CR2_OCBIE_MASK 0x800
#define TIM9_CR2_OCBIE 0x800
#define TIM9_CR2_OCBIE_BIT 11
#define TIM9_CR2_ICBIE_MASK 0x1000
#define TIM9_CR2_ICBIE 0x1000
#define TIM9_CR2_ICBIE_BIT 12
#define TIM9_CR2_TOE_MASK 0x2000
#define TIM9_CR2_TOE 0x2000
#define TIM9_CR2_TOE_BIT 13
#define TIM9_CR2_OCAIE_MASK 0x4000
#define TIM9_CR2_OCAIE 0x4000
#define TIM9_CR2_OCAIE_BIT 14
#define TIM9_CR2_ICAIE_MASK 0x8000
#define TIM9_CR2_ICAIE 0x8000
#define TIM9_CR2_ICAIE_BIT 15

#define TIM9_SR (*(volatile unsigned short *)0xFFFFB21C)
#define TIM9_SR_OCFB_MASK 0x800
#define TIM9_SR_OCFB 0x800
#define TIM9_SR_OCFB_BIT 11
#define TIM9_SR_ICFB_MASK 0x1000
#define TIM9_SR_ICFB 0x1000
#define TIM9_SR_ICFB_BIT 12
#define TIM9_SR_TOF_MASK 0x2000
#define TIM9_SR_TOF 0x2000
#define TIM9_SR_TOF_BIT 13
#define TIM9_SR_OCFA_MASK 0x4000
#define TIM9_SR_OCFA 0x4000
#define TIM9_SR_OCFA_BIT 14
#define TIM9_SR_ICFA_MASK 0x8000
#define TIM9_SR_ICFA 0x8000
#define TIM9_SR_ICFA_BIT 15

#define WIU_CTRL (*(volatile unsigned short *)0xFFFFB800)
#define WIU_CTRL_WKUP-INT_MASK 0x1
#define WIU_CTRL_WKUP-INT 0x1
#define WIU_CTRL_WKUP-INT_BIT 0
#define WIU_CTRL_INT_EN_MASK 0x2
#define WIU_CTRL_INT_EN 0x2
#define WIU_CTRL_INT_EN_BIT 1
#define WIU_CTRL_STOP_MASK 0x4
#define WIU_CTRL_STOP 0x4
#define WIU_CTRL_STOP_BIT 2

#define WIU_MR (*(volatile unsigned short *)0xFFFFB804)

#define WIU_TR (*(volatile unsigned short *)0xFFFFB808)

#define WIU_PR (*(volatile unsigned short *)0xFFFFB80C)

#define WIU_INTR (*(volatile unsigned short *)0xFFFFB810)

#define APB1_BSR (*(volatile unsigned long *)0xFFFFC000)
#define APB1_BSR_ABORT_MASK 0x1
#define APB1_BSR_ABORT 0x1
#define APB1_BSR_ABORT_BIT 0
#define APB1_BSR_OUTM_MASK 0x10
#define APB1_BSR_OUTM 0x10
#define APB1_BSR_OUTM_BIT 4
#define APB1_BSR_ABPT_MASK 0x20
#define APB1_BSR_ABPT 0x20
#define APB1_BSR_ABPT_BIT 5

#define APB1_TOR (*(volatile unsigned long *)0xFFFFC004)
#define APB1_TOR_TOUT_CNT_MASK 0x1F
#define APB1_TOR_TOUT_CNT_BIT 0
#define APB1_TOR_ABTEN_MASK 0x100
#define APB1_TOR_ABTEN 0x100
#define APB1_TOR_ABTEN_BIT 8

#define APB1_OMR (*(volatile unsigned long *)0xFFFFC008)
#define APB1_OMR_nRW_MASK 0x80
#define APB1_OMR_nRW 0x80
#define APB1_OMR_nRW_BIT 7
#define APB1_OMR_PERIPHERAL_ADDRESS_MASK 0xFFFF00
#define APB1_OMR_PERIPHERAL_ADDRESS_BIT 8

#define APB1_TOER (*(volatile unsigned long *)0xFFFFC00C)
#define APB1_TOER_nRW_MASK 0x80
#define APB1_TOER_nRW 0x80
#define APB1_TOER_nRW_BIT 7
#define APB1_TOER_PERIPHERAL_ADDRESS_MASK 0xFFFF00
#define APB1_TOER_PERIPHERAL_ADDRESS_BIT 8

#define CAN0_CR (*(volatile unsigned short *)0xFFFFC400)
#define CAN0_CR_Init_MASK 0x1
#define CAN0_CR_Init 0x1
#define CAN0_CR_Init_BIT 0
#define CAN0_CR_IE_MASK 0x2
#define CAN0_CR_IE 0x2
#define CAN0_CR_IE_BIT 1
#define CAN0_CR_SIE_MASK 0x4
#define CAN0_CR_SIE 0x4
#define CAN0_CR_SIE_BIT 2
#define CAN0_CR_EIE_MASK 0x8
#define CAN0_CR_EIE 0x8
#define CAN0_CR_EIE_BIT 3
#define CAN0_CR_DAR_MASK 0x20
#define CAN0_CR_DAR 0x20
#define CAN0_CR_DAR_BIT 5
#define CAN0_CR_CCE_MASK 0x40
#define CAN0_CR_CCE 0x40
#define CAN0_CR_CCE_BIT 6
#define CAN0_CR_Test_MASK 0x80
#define CAN0_CR_Test 0x80
#define CAN0_CR_Test_BIT 7

#define CAN0_SR (*(volatile unsigned short *)0xFFFFC404)
#define CAN0_SR_LEC_MASK 0x7
#define CAN0_SR_LEC_BIT 0
#define CAN0_SR_TxOk_MASK 0x8
#define CAN0_SR_TxOk 0x8
#define CAN0_SR_TxOk_BIT 3
#define CAN0_SR_RxOk_MASK 0x10
#define CAN0_SR_RxOk 0x10
#define CAN0_SR_RxOk_BIT 4
#define CAN0_SR_EPass_MASK 0x20
#define CAN0_SR_EPass 0x20
#define CAN0_SR_EPass_BIT 5
#define CAN0_SR_EWarn_MASK 0x40
#define CAN0_SR_EWarn 0x40
#define CAN0_SR_EWarn_BIT 6
#define CAN0_SR_BOff_MASK 0x80
#define CAN0_SR_BOff 0x80
#define CAN0_SR_BOff_BIT 7

#define CAN0_ERR (*(volatile unsigned short *)0xFFFFC408)
#define CAN0_ERR_TEC7_0_MASK 0xFF
#define CAN0_ERR_TEC7_0_BIT 0
#define CAN0_ERR_REC6_0_MASK 0x7F00
#define CAN0_ERR_REC6_0_BIT 8
#define CAN0_ERR_RP_MASK 0x8000
#define CAN0_ERR_RP 0x8000
#define CAN0_ERR_RP_BIT 15

#define CAN0_BTR (*(volatile unsigned short *)0xFFFFC40C)
#define CAN0_BTR_BRP_MASK 0x3F
#define CAN0_BTR_BRP_BIT 0
#define CAN0_BTR_SJW_MASK 0xC0
#define CAN0_BTR_SJW_BIT 6
#define CAN0_BTR_TSeg1_MASK 0xF00
#define CAN0_BTR_TSeg1_BIT 8
#define CAN0_BTR_TSeg2_MASK 0x7000
#define CAN0_BTR_TSeg2_BIT 12

#define CAN0_IDR (*(volatile unsigned short *)0xFFFFC410)
#define CAN0_IDR_IntId7_0_MASK 0xFF
#define CAN0_IDR_IntId7_0_BIT 0
#define CAN0_IDR_IntId15_8_MASK 0xFF00
#define CAN0_IDR_IntId15_8_BIT 8

#define CAN0_TESTR (*(volatile unsigned short *)0xFFFFC414)
#define CAN0_TESTR_Basic_MASK 0x4
#define CAN0_TESTR_Basic 0x4
#define CAN0_TESTR_Basic_BIT 2
#define CAN0_TESTR_Silent_MASK 0x8
#define CAN0_TESTR_Silent 0x8
#define CAN0_TESTR_Silent_BIT 3
#define CAN0_TESTR_LBack_MASK 0x10
#define CAN0_TESTR_LBack 0x10
#define CAN0_TESTR_LBack_BIT 4
#define CAN0_TESTR_Tx0_MASK 0x20
#define CAN0_TESTR_Tx0 0x20
#define CAN0_TESTR_Tx0_BIT 5
#define CAN0_TESTR_Tx1_MASK 0x40
#define CAN0_TESTR_Tx1 0x40
#define CAN0_TESTR_Tx1_BIT 6
#define CAN0_TESTR_Rx1_MASK 0x80
#define CAN0_TESTR_Rx1 0x80
#define CAN0_TESTR_Rx1_BIT 7

#define CAN0_BRPR (*(volatile unsigned short *)0xFFFFC418)

#define CAN0_IF1_CRR (*(volatile unsigned short *)0xFFFFC420)
#define CAN0_IF1_CRR_Message_Number_MASK 0x3F
#define CAN0_IF1_CRR_Message_Number_BIT 0
#define CAN0_IF1_CRR_Busy_MASK 0x8000
#define CAN0_IF1_CRR_Busy 0x8000
#define CAN0_IF1_CRR_Busy_BIT 15

#define CAN0_IF1_CMR (*(volatile unsigned short *)0xFFFFC424)
#define CAN0_IF1_CMR_Data_B_MASK 0x1
#define CAN0_IF1_CMR_Data_B 0x1
#define CAN0_IF1_CMR_Data_B_BIT 0
#define CAN0_IF1_CMR_Data_A_MASK 0x2
#define CAN0_IF1_CMR_Data_A 0x2
#define CAN0_IF1_CMR_Data_A_BIT 1
#define CAN0_IF1_CMR_TxRqst_NewDat_MASK 0x4
#define CAN0_IF1_CMR_TxRqst_NewDat 0x4
#define CAN0_IF1_CMR_TxRqst_NewDat_BIT 2
#define CAN0_IF1_CMR_ClrIntPnd_MASK 0x8
#define CAN0_IF1_CMR_ClrIntPnd 0x8
#define CAN0_IF1_CMR_ClrIntPnd_BIT 3
#define CAN0_IF1_CMR_Control_MASK 0x10
#define CAN0_IF1_CMR_Control 0x10
#define CAN0_IF1_CMR_Control_BIT 4
#define CAN0_IF1_CMR_Arb_MASK 0x20
#define CAN0_IF1_CMR_Arb 0x20
#define CAN0_IF1_CMR_Arb_BIT 5
#define CAN0_IF1_CMR_Mask_MASK 0x40
#define CAN0_IF1_CMR_Mask 0x40
#define CAN0_IF1_CMR_Mask_BIT 6
#define CAN0_IF1_CMR_WR_RD_MASK 0x80
#define CAN0_IF1_CMR_WR_RD 0x80
#define CAN0_IF1_CMR_WR_RD_BIT 7

#define CAN0_IF1_M1R (*(volatile unsigned short *)0xFFFFC428)

#define CAN0_IF1_M2R (*(volatile unsigned short *)0xFFFFC42C)
#define CAN0_IF1_M2R_Msk28_16_MASK 0x1FFF
#define CAN0_IF1_M2R_Msk28_16_BIT 0
#define CAN0_IF1_M2R_MDir_MASK 0x4000
#define CAN0_IF1_M2R_MDir 0x4000
#define CAN0_IF1_M2R_MDir_BIT 14
#define CAN0_IF1_M2R_MXtd_MASK 0x8000
#define CAN0_IF1_M2R_MXtd 0x8000
#define CAN0_IF1_M2R_MXtd_BIT 15

#define CAN0_IF1_A1R (*(volatile unsigned short *)0xFFFFC430)

#define CAN0_IF1_A2R (*(volatile unsigned short *)0xFFFFC434)
#define CAN0_IF1_A2R_ID28_16_MASK 0x1FFF
#define CAN0_IF1_A2R_ID28_16_BIT 0
#define CAN0_IF1_A2R_Dir_MASK 0x2000
#define CAN0_IF1_A2R_Dir 0x2000
#define CAN0_IF1_A2R_Dir_BIT 13
#define CAN0_IF1_A2R_Xtd_MASK 0x4000
#define CAN0_IF1_A2R_Xtd 0x4000
#define CAN0_IF1_A2R_Xtd_BIT 14
#define CAN0_IF1_A2R_MsgVaI_MASK 0x8000
#define CAN0_IF1_A2R_MsgVaI 0x8000
#define CAN0_IF1_A2R_MsgVaI_BIT 15

#define CAN0_IF1_MCR (*(volatile unsigned short *)0xFFFFC438)
#define CAN0_IF1_MCR_DLC3_0_MASK 0xF
#define CAN0_IF1_MCR_DLC3_0_BIT 0
#define CAN0_IF1_MCR_EoB_MASK 0x80
#define CAN0_IF1_MCR_EoB 0x80
#define CAN0_IF1_MCR_EoB_BIT 7
#define CAN0_IF1_MCR_TxRqst_MASK 0x100
#define CAN0_IF1_MCR_TxRqst 0x100
#define CAN0_IF1_MCR_TxRqst_BIT 8
#define CAN0_IF1_MCR_RmtEn_MASK 0x200
#define CAN0_IF1_MCR_RmtEn 0x200
#define CAN0_IF1_MCR_RmtEn_BIT 9
#define CAN0_IF1_MCR_RxlE_MASK 0x400
#define CAN0_IF1_MCR_RxlE 0x400
#define CAN0_IF1_MCR_RxlE_BIT 10
#define CAN0_IF1_MCR_TxlE_MASK 0x800
#define CAN0_IF1_MCR_TxlE 0x800
#define CAN0_IF1_MCR_TxlE_BIT 11
#define CAN0_IF1_MCR_UMask_MASK 0x1000
#define CAN0_IF1_MCR_UMask 0x1000
#define CAN0_IF1_MCR_UMask_BIT 12
#define CAN0_IF1_MCR_IntPnd_MASK 0x2000
#define CAN0_IF1_MCR_IntPnd 0x2000
#define CAN0_IF1_MCR_IntPnd_BIT 13
#define CAN0_IF1_MCR_MsgLst_MASK 0x4000
#define CAN0_IF1_MCR_MsgLst 0x4000
#define CAN0_IF1_MCR_MsgLst_BIT 14
#define CAN0_IF1_MCR_NewDat_MASK 0x8000
#define CAN0_IF1_MCR_NewDat 0x8000
#define CAN0_IF1_MCR_NewDat_BIT 15

#define CAN0_IF1_DA1R (*(volatile unsigned short *)0xFFFFC43C)

#define CAN0_IF1_DA2R (*(volatile unsigned short *)0xFFFFC440)

#define CAN0_IF1_DB1R (*(volatile unsigned short *)0xFFFFC444)

#define CAN0_IF1_DB2R (*(volatile unsigned short *)0xFFFFC448)

#define CAN0_IF2_CRR (*(volatile unsigned short *)0xFFFFC480)
#define CAN0_IF2_CRR_Message_Number_MASK 0x3F
#define CAN0_IF2_CRR_Message_Number_BIT 0
#define CAN0_IF2_CRR_Busy_MASK 0x8000
#define CAN0_IF2_CRR_Busy 0x8000
#define CAN0_IF2_CRR_Busy_BIT 15

#define CAN0_IF2_CMR (*(volatile unsigned short *)0xFFFFC484)
#define CAN0_IF2_CMR_Data_B_MASK 0x1
#define CAN0_IF2_CMR_Data_B 0x1
#define CAN0_IF2_CMR_Data_B_BIT 0
#define CAN0_IF2_CMR_Data_A_MASK 0x2
#define CAN0_IF2_CMR_Data_A 0x2
#define CAN0_IF2_CMR_Data_A_BIT 1
#define CAN0_IF2_CMR_TxRqst_NewDat_MASK 0x4
#define CAN0_IF2_CMR_TxRqst_NewDat 0x4
#define CAN0_IF2_CMR_TxRqst_NewDat_BIT 2
#define CAN0_IF2_CMR_ClrIntPnd_MASK 0x8
#define CAN0_IF2_CMR_ClrIntPnd 0x8
#define CAN0_IF2_CMR_ClrIntPnd_BIT 3
#define CAN0_IF2_CMR_Control_MASK 0x10
#define CAN0_IF2_CMR_Control 0x10
#define CAN0_IF2_CMR_Control_BIT 4
#define CAN0_IF2_CMR_Arb_MASK 0x20
#define CAN0_IF2_CMR_Arb 0x20
#define CAN0_IF2_CMR_Arb_BIT 5
#define CAN0_IF2_CMR_Mask_MASK 0x40
#define CAN0_IF2_CMR_Mask 0x40
#define CAN0_IF2_CMR_Mask_BIT 6
#define CAN0_IF2_CMR_WR_RD_MASK 0x80
#define CAN0_IF2_CMR_WR_RD 0x80
#define CAN0_IF2_CMR_WR_RD_BIT 7

#define CAN0_IF2_M1R (*(volatile unsigned short *)0xFFFFC488)

#define CAN0_IF2_M2R (*(volatile unsigned short *)0xFFFFC48C)
#define CAN0_IF2_M2R_Msk28_16_MASK 0x1FFF
#define CAN0_IF2_M2R_Msk28_16_BIT 0
#define CAN0_IF2_M2R_MDir_MASK 0x4000
#define CAN0_IF2_M2R_MDir 0x4000
#define CAN0_IF2_M2R_MDir_BIT 14
#define CAN0_IF2_M2R_MXtd_MASK 0x8000
#define CAN0_IF2_M2R_MXtd 0x8000
#define CAN0_IF2_M2R_MXtd_BIT 15

#define CAN0_IF2_A1R (*(volatile unsigned short *)0xFFFFC490)

#define CAN0_IF2_A2R (*(volatile unsigned short *)0xFFFFC494)
#define CAN0_IF2_A2R_ID28_16_MASK 0x1FFF
#define CAN0_IF2_A2R_ID28_16_BIT 0
#define CAN0_IF2_A2R_Dir_MASK 0x2000
#define CAN0_IF2_A2R_Dir 0x2000
#define CAN0_IF2_A2R_Dir_BIT 13
#define CAN0_IF2_A2R_Xtd_MASK 0x4000
#define CAN0_IF2_A2R_Xtd 0x4000
#define CAN0_IF2_A2R_Xtd_BIT 14
#define CAN0_IF2_A2R_MsgVaI_MASK 0x8000
#define CAN0_IF2_A2R_MsgVaI 0x8000
#define CAN0_IF2_A2R_MsgVaI_BIT 15

#define CAN0_IF2_MCR (*(volatile unsigned short *)0xFFFFC498)
#define CAN0_IF2_MCR_DLC3_0_MASK 0xF
#define CAN0_IF2_MCR_DLC3_0_BIT 0
#define CAN0_IF2_MCR_EoB_MASK 0x80
#define CAN0_IF2_MCR_EoB 0x80
#define CAN0_IF2_MCR_EoB_BIT 7
#define CAN0_IF2_MCR_TxRqst_MASK 0x100
#define CAN0_IF2_MCR_TxRqst 0x100
#define CAN0_IF2_MCR_TxRqst_BIT 8
#define CAN0_IF2_MCR_RmtEn_MASK 0x200
#define CAN0_IF2_MCR_RmtEn 0x200
#define CAN0_IF2_MCR_RmtEn_BIT 9
#define CAN0_IF2_MCR_RxlE_MASK 0x400
#define CAN0_IF2_MCR_RxlE 0x400
#define CAN0_IF2_MCR_RxlE_BIT 10
#define CAN0_IF2_MCR_TxlE_MASK 0x800
#define CAN0_IF2_MCR_TxlE 0x800
#define CAN0_IF2_MCR_TxlE_BIT 11
#define CAN0_IF2_MCR_UMask_MASK 0x1000
#define CAN0_IF2_MCR_UMask 0x1000
#define CAN0_IF2_MCR_UMask_BIT 12
#define CAN0_IF2_MCR_IntPnd_MASK 0x2000
#define CAN0_IF2_MCR_IntPnd 0x2000
#define CAN0_IF2_MCR_IntPnd_BIT 13
#define CAN0_IF2_MCR_MsgLst_MASK 0x4000
#define CAN0_IF2_MCR_MsgLst 0x4000
#define CAN0_IF2_MCR_MsgLst_BIT 14
#define CAN0_IF2_MCR_NewDat_MASK 0x8000
#define CAN0_IF2_MCR_NewDat 0x8000
#define CAN0_IF2_MCR_NewDat_BIT 15

#define CAN0_IF2_DA1R (*(volatile unsigned short *)0xFFFFC49C)

#define CAN0_IF2_DA2R (*(volatile unsigned short *)0xFFFFC4A0)

#define CAN0_IF2_DB1R (*(volatile unsigned short *)0xFFFFC4A4)

#define CAN0_IF2_DB2R (*(volatile unsigned short *)0xFFFFC4A8)

#define CAN0_TxR1R (*(volatile unsigned short *)0xFFFFC400)

#define CAN0_TxR2R (*(volatile unsigned short *)0xFFFFC404)

#define CAN0_ND1R (*(volatile unsigned short *)0xFFFFC420)

#define CAN0_ND2R (*(volatile unsigned short *)0xFFFFC424)

#define CAN0_IP1R (*(volatile unsigned short *)0xFFFFC440)
#define CAN0_IP1R_IntPnd8_1_MASK 0xFF
#define CAN0_IP1R_IntPnd8_1_BIT 0
#define CAN0_IP1R_IntPnd16_9_MASK 0xFF00
#define CAN0_IP1R_IntPnd16_9_BIT 8

#define CAN0_IP2R (*(volatile unsigned short *)0xFFFFC444)
#define CAN0_IP2R_IntPnd24_17_MASK 0xFF
#define CAN0_IP2R_IntPnd24_17_BIT 0
#define CAN0_IP2R_IntPnd32_25_MASK 0xFF00
#define CAN0_IP2R_IntPnd32_25_BIT 8

#define CAN0_MV1R (*(volatile unsigned short *)0xFFFFC460)
#define CAN0_MV1R_MsgVal8_1_MASK 0xFF
#define CAN0_MV1R_MsgVal8_1_BIT 0
#define CAN0_MV1R_MsgVal16_9_MASK 0xFF00
#define CAN0_MV1R_MsgVal16_9_BIT 8

#define CAN0_MV2R (*(volatile unsigned short *)0xFFFFC464)
#define CAN0_MV2R_MsgVal24_17_MASK 0xFF
#define CAN0_MV2R_MsgVal24_17_BIT 0
#define CAN0_MV2R_MsgVal32_25_MASK 0xFF00
#define CAN0_MV2R_MsgVal32_25_BIT 8

#define CAN1_CR (*(volatile unsigned short *)0xFFFFC800)
#define CAN1_CR_Init_MASK 0x1
#define CAN1_CR_Init 0x1
#define CAN1_CR_Init_BIT 0
#define CAN1_CR_IE_MASK 0x2
#define CAN1_CR_IE 0x2
#define CAN1_CR_IE_BIT 1
#define CAN1_CR_SIE_MASK 0x4
#define CAN1_CR_SIE 0x4
#define CAN1_CR_SIE_BIT 2
#define CAN1_CR_EIE_MASK 0x8
#define CAN1_CR_EIE 0x8
#define CAN1_CR_EIE_BIT 3
#define CAN1_CR_DAR_MASK 0x20
#define CAN1_CR_DAR 0x20
#define CAN1_CR_DAR_BIT 5
#define CAN1_CR_CCE_MASK 0x40
#define CAN1_CR_CCE 0x40
#define CAN1_CR_CCE_BIT 6
#define CAN1_CR_Test_MASK 0x80
#define CAN1_CR_Test 0x80
#define CAN1_CR_Test_BIT 7

#define CAN1_SR (*(volatile unsigned short *)0xFFFFC804)
#define CAN1_SR_LEC_MASK 0x7
#define CAN1_SR_LEC_BIT 0
#define CAN1_SR_TxOk_MASK 0x8
#define CAN1_SR_TxOk 0x8
#define CAN1_SR_TxOk_BIT 3
#define CAN1_SR_RxOk_MASK 0x10
#define CAN1_SR_RxOk 0x10
#define CAN1_SR_RxOk_BIT 4
#define CAN1_SR_EPass_MASK 0x20
#define CAN1_SR_EPass 0x20
#define CAN1_SR_EPass_BIT 5
#define CAN1_SR_EWarn_MASK 0x40
#define CAN1_SR_EWarn 0x40
#define CAN1_SR_EWarn_BIT 6
#define CAN1_SR_BOff_MASK 0x80
#define CAN1_SR_BOff 0x80
#define CAN1_SR_BOff_BIT 7

#define CAN1_ERR (*(volatile unsigned short *)0xFFFFC808)
#define CAN1_ERR_TEC7_0_MASK 0xFF
#define CAN1_ERR_TEC7_0_BIT 0
#define CAN1_ERR_REC6_0_MASK 0x7F00
#define CAN1_ERR_REC6_0_BIT 8
#define CAN1_ERR_RP_MASK 0x8000
#define CAN1_ERR_RP 0x8000
#define CAN1_ERR_RP_BIT 15

#define CAN1_BTR (*(volatile unsigned short *)0xFFFFC80C)
#define CAN1_BTR_BRP_MASK 0x3F
#define CAN1_BTR_BRP_BIT 0
#define CAN1_BTR_SJW_MASK 0xC0
#define CAN1_BTR_SJW_BIT 6
#define CAN1_BTR_TSeg1_MASK 0xF00
#define CAN1_BTR_TSeg1_BIT 8
#define CAN1_BTR_TSeg2_MASK 0x7000
#define CAN1_BTR_TSeg2_BIT 12

#define CAN1_IDR (*(volatile unsigned short *)0xFFFFC810)
#define CAN1_IDR_IntId7_0_MASK 0xFF
#define CAN1_IDR_IntId7_0_BIT 0
#define CAN1_IDR_IntId15_8_MASK 0xFF00
#define CAN1_IDR_IntId15_8_BIT 8

#define CAN1_TESTR (*(volatile unsigned short *)0xFFFFC814)
#define CAN1_TESTR_Basic_MASK 0x4
#define CAN1_TESTR_Basic 0x4
#define CAN1_TESTR_Basic_BIT 2
#define CAN1_TESTR_Silent_MASK 0x8
#define CAN1_TESTR_Silent 0x8
#define CAN1_TESTR_Silent_BIT 3
#define CAN1_TESTR_LBack_MASK 0x10
#define CAN1_TESTR_LBack 0x10
#define CAN1_TESTR_LBack_BIT 4
#define CAN1_TESTR_Tx0_MASK 0x20
#define CAN1_TESTR_Tx0 0x20
#define CAN1_TESTR_Tx0_BIT 5
#define CAN1_TESTR_Tx1_MASK 0x40
#define CAN1_TESTR_Tx1 0x40
#define CAN1_TESTR_Tx1_BIT 6
#define CAN1_TESTR_Rx1_MASK 0x80
#define CAN1_TESTR_Rx1 0x80
#define CAN1_TESTR_Rx1_BIT 7

#define CAN1_BRPR (*(volatile unsigned short *)0xFFFFC818)

#define CAN1_IF1_CRR (*(volatile unsigned short *)0xFFFFC820)
#define CAN1_IF1_CRR_Message_Number_MASK 0x3F
#define CAN1_IF1_CRR_Message_Number_BIT 0
#define CAN1_IF1_CRR_Busy_MASK 0x8000
#define CAN1_IF1_CRR_Busy 0x8000
#define CAN1_IF1_CRR_Busy_BIT 15

#define CAN1_IF1_CMR (*(volatile unsigned short *)0xFFFFC824)
#define CAN1_IF1_CMR_Data_B_MASK 0x1
#define CAN1_IF1_CMR_Data_B 0x1
#define CAN1_IF1_CMR_Data_B_BIT 0
#define CAN1_IF1_CMR_Data_A_MASK 0x2
#define CAN1_IF1_CMR_Data_A 0x2
#define CAN1_IF1_CMR_Data_A_BIT 1
#define CAN1_IF1_CMR_TxRqst_NewDat_MASK 0x4
#define CAN1_IF1_CMR_TxRqst_NewDat 0x4
#define CAN1_IF1_CMR_TxRqst_NewDat_BIT 2
#define CAN1_IF1_CMR_ClrIntPnd_MASK 0x8
#define CAN1_IF1_CMR_ClrIntPnd 0x8
#define CAN1_IF1_CMR_ClrIntPnd_BIT 3
#define CAN1_IF1_CMR_Control_MASK 0x10
#define CAN1_IF1_CMR_Control 0x10
#define CAN1_IF1_CMR_Control_BIT 4
#define CAN1_IF1_CMR_Arb_MASK 0x20
#define CAN1_IF1_CMR_Arb 0x20
#define CAN1_IF1_CMR_Arb_BIT 5
#define CAN1_IF1_CMR_Mask_MASK 0x40
#define CAN1_IF1_CMR_Mask 0x40
#define CAN1_IF1_CMR_Mask_BIT 6
#define CAN1_IF1_CMR_WR_RD_MASK 0x80
#define CAN1_IF1_CMR_WR_RD 0x80
#define CAN1_IF1_CMR_WR_RD_BIT 7

#define CAN1_IF1_M1R (*(volatile unsigned short *)0xFFFFC828)

#define CAN1_IF1_M2R (*(volatile unsigned short *)0xFFFFC82C)
#define CAN1_IF1_M2R_Msk28_16_MASK 0x1FFF
#define CAN1_IF1_M2R_Msk28_16_BIT 0
#define CAN1_IF1_M2R_MDir_MASK 0x4000
#define CAN1_IF1_M2R_MDir 0x4000
#define CAN1_IF1_M2R_MDir_BIT 14
#define CAN1_IF1_M2R_MXtd_MASK 0x8000
#define CAN1_IF1_M2R_MXtd 0x8000
#define CAN1_IF1_M2R_MXtd_BIT 15

#define CAN1_IF1_A1R (*(volatile unsigned short *)0xFFFFC830)

#define CAN1_IF1_A2R (*(volatile unsigned short *)0xFFFFC834)
#define CAN1_IF1_A2R_ID28_16_MASK 0x1FFF
#define CAN1_IF1_A2R_ID28_16_BIT 0
#define CAN1_IF1_A2R_Dir_MASK 0x2000
#define CAN1_IF1_A2R_Dir 0x2000
#define CAN1_IF1_A2R_Dir_BIT 13
#define CAN1_IF1_A2R_Xtd_MASK 0x4000
#define CAN1_IF1_A2R_Xtd 0x4000
#define CAN1_IF1_A2R_Xtd_BIT 14
#define CAN1_IF1_A2R_MsgVaI_MASK 0x8000
#define CAN1_IF1_A2R_MsgVaI 0x8000
#define CAN1_IF1_A2R_MsgVaI_BIT 15

#define CAN1_IF1_MCR (*(volatile unsigned short *)0xFFFFC838)
#define CAN1_IF1_MCR_DLC3_0_MASK 0xF
#define CAN1_IF1_MCR_DLC3_0_BIT 0
#define CAN1_IF1_MCR_EoB_MASK 0x80
#define CAN1_IF1_MCR_EoB 0x80
#define CAN1_IF1_MCR_EoB_BIT 7
#define CAN1_IF1_MCR_TxRqst_MASK 0x100
#define CAN1_IF1_MCR_TxRqst 0x100
#define CAN1_IF1_MCR_TxRqst_BIT 8
#define CAN1_IF1_MCR_RmtEn_MASK 0x200
#define CAN1_IF1_MCR_RmtEn 0x200
#define CAN1_IF1_MCR_RmtEn_BIT 9
#define CAN1_IF1_MCR_RxlE_MASK 0x400
#define CAN1_IF1_MCR_RxlE 0x400
#define CAN1_IF1_MCR_RxlE_BIT 10
#define CAN1_IF1_MCR_TxlE_MASK 0x800
#define CAN1_IF1_MCR_TxlE 0x800
#define CAN1_IF1_MCR_TxlE_BIT 11
#define CAN1_IF1_MCR_UMask_MASK 0x1000
#define CAN1_IF1_MCR_UMask 0x1000
#define CAN1_IF1_MCR_UMask_BIT 12
#define CAN1_IF1_MCR_IntPnd_MASK 0x2000
#define CAN1_IF1_MCR_IntPnd 0x2000
#define CAN1_IF1_MCR_IntPnd_BIT 13
#define CAN1_IF1_MCR_MsgLst_MASK 0x4000
#define CAN1_IF1_MCR_MsgLst 0x4000
#define CAN1_IF1_MCR_MsgLst_BIT 14
#define CAN1_IF1_MCR_NewDat_MASK 0x8000
#define CAN1_IF1_MCR_NewDat 0x8000
#define CAN1_IF1_MCR_NewDat_BIT 15

#define CAN1_IF1_DA1R (*(volatile unsigned short *)0xFFFFC83C)

#define CAN1_IF1_DA2R (*(volatile unsigned short *)0xFFFFC840)

#define CAN1_IF1_DB1R (*(volatile unsigned short *)0xFFFFC844)

#define CAN1_IF1_DB2R (*(volatile unsigned short *)0xFFFFC848)

#define CAN1_IF2_CRR (*(volatile unsigned short *)0xFFFFC880)
#define CAN1_IF2_CRR_Message_Number_MASK 0x3F
#define CAN1_IF2_CRR_Message_Number_BIT 0
#define CAN1_IF2_CRR_Busy_MASK 0x8000
#define CAN1_IF2_CRR_Busy 0x8000
#define CAN1_IF2_CRR_Busy_BIT 15

#define CAN1_IF2_CMR (*(volatile unsigned short *)0xFFFFC884)
#define CAN1_IF2_CMR_Data_B_MASK 0x1
#define CAN1_IF2_CMR_Data_B 0x1
#define CAN1_IF2_CMR_Data_B_BIT 0
#define CAN1_IF2_CMR_Data_A_MASK 0x2
#define CAN1_IF2_CMR_Data_A 0x2
#define CAN1_IF2_CMR_Data_A_BIT 1
#define CAN1_IF2_CMR_TxRqst_NewDat_MASK 0x4
#define CAN1_IF2_CMR_TxRqst_NewDat 0x4
#define CAN1_IF2_CMR_TxRqst_NewDat_BIT 2
#define CAN1_IF2_CMR_ClrIntPnd_MASK 0x8
#define CAN1_IF2_CMR_ClrIntPnd 0x8
#define CAN1_IF2_CMR_ClrIntPnd_BIT 3
#define CAN1_IF2_CMR_Control_MASK 0x10
#define CAN1_IF2_CMR_Control 0x10
#define CAN1_IF2_CMR_Control_BIT 4
#define CAN1_IF2_CMR_Arb_MASK 0x20
#define CAN1_IF2_CMR_Arb 0x20
#define CAN1_IF2_CMR_Arb_BIT 5
#define CAN1_IF2_CMR_Mask_MASK 0x40
#define CAN1_IF2_CMR_Mask 0x40
#define CAN1_IF2_CMR_Mask_BIT 6
#define CAN1_IF2_CMR_WR_RD_MASK 0x80
#define CAN1_IF2_CMR_WR_RD 0x80
#define CAN1_IF2_CMR_WR_RD_BIT 7

#define CAN1_IF2_M1R (*(volatile unsigned short *)0xFFFFC888)

#define CAN1_IF2_M2R (*(volatile unsigned short *)0xFFFFC88C)
#define CAN1_IF2_M2R_Msk28_16_MASK 0x1FFF
#define CAN1_IF2_M2R_Msk28_16_BIT 0
#define CAN1_IF2_M2R_MDir_MASK 0x4000
#define CAN1_IF2_M2R_MDir 0x4000
#define CAN1_IF2_M2R_MDir_BIT 14
#define CAN1_IF2_M2R_MXtd_MASK 0x8000
#define CAN1_IF2_M2R_MXtd 0x8000
#define CAN1_IF2_M2R_MXtd_BIT 15

#define CAN1_IF2_A1R (*(volatile unsigned short *)0xFFFFC890)

#define CAN1_IF2_A2R (*(volatile unsigned short *)0xFFFFC894)
#define CAN1_IF2_A2R_ID28_16_MASK 0x1FFF
#define CAN1_IF2_A2R_ID28_16_BIT 0
#define CAN1_IF2_A2R_Dir_MASK 0x2000
#define CAN1_IF2_A2R_Dir 0x2000
#define CAN1_IF2_A2R_Dir_BIT 13
#define CAN1_IF2_A2R_Xtd_MASK 0x4000
#define CAN1_IF2_A2R_Xtd 0x4000
#define CAN1_IF2_A2R_Xtd_BIT 14
#define CAN1_IF2_A2R_MsgVaI_MASK 0x8000
#define CAN1_IF2_A2R_MsgVaI 0x8000
#define CAN1_IF2_A2R_MsgVaI_BIT 15

#define CAN1_IF2_MCR (*(volatile unsigned short *)0xFFFFC898)
#define CAN1_IF2_MCR_DLC3_0_MASK 0xF
#define CAN1_IF2_MCR_DLC3_0_BIT 0
#define CAN1_IF2_MCR_EoB_MASK 0x80
#define CAN1_IF2_MCR_EoB 0x80
#define CAN1_IF2_MCR_EoB_BIT 7
#define CAN1_IF2_MCR_TxRqst_MASK 0x100
#define CAN1_IF2_MCR_TxRqst 0x100
#define CAN1_IF2_MCR_TxRqst_BIT 8
#define CAN1_IF2_MCR_RmtEn_MASK 0x200
#define CAN1_IF2_MCR_RmtEn 0x200
#define CAN1_IF2_MCR_RmtEn_BIT 9
#define CAN1_IF2_MCR_RxlE_MASK 0x400
#define CAN1_IF2_MCR_RxlE 0x400
#define CAN1_IF2_MCR_RxlE_BIT 10
#define CAN1_IF2_MCR_TxlE_MASK 0x800
#define CAN1_IF2_MCR_TxlE 0x800
#define CAN1_IF2_MCR_TxlE_BIT 11
#define CAN1_IF2_MCR_UMask_MASK 0x1000
#define CAN1_IF2_MCR_UMask 0x1000
#define CAN1_IF2_MCR_UMask_BIT 12
#define CAN1_IF2_MCR_IntPnd_MASK 0x2000
#define CAN1_IF2_MCR_IntPnd 0x2000
#define CAN1_IF2_MCR_IntPnd_BIT 13
#define CAN1_IF2_MCR_MsgLst_MASK 0x4000
#define CAN1_IF2_MCR_MsgLst 0x4000
#define CAN1_IF2_MCR_MsgLst_BIT 14
#define CAN1_IF2_MCR_NewDat_MASK 0x8000
#define CAN1_IF2_MCR_NewDat 0x8000
#define CAN1_IF2_MCR_NewDat_BIT 15

#define CAN1_IF2_DA1R (*(volatile unsigned short *)0xFFFFC89C)

#define CAN1_IF2_DA2R (*(volatile unsigned short *)0xFFFFC8A0)

#define CAN1_IF2_DB1R (*(volatile unsigned short *)0xFFFFC8A4)

#define CAN1_IF2_DB2R (*(volatile unsigned short *)0xFFFFC8A8)

#define CAN1_TxR1R (*(volatile unsigned short *)0xFFFFC800)

#define CAN1_TxR2R (*(volatile unsigned short *)0xFFFFC804)

#define CAN1_ND1R (*(volatile unsigned short *)0xFFFFC820)

#define CAN1_ND2R (*(volatile unsigned short *)0xFFFFC824)

#define CAN1_IP1R (*(volatile unsigned short *)0xFFFFC840)
#define CAN1_IP1R_IntPnd8_1_MASK 0xFF
#define CAN1_IP1R_IntPnd8_1_BIT 0
#define CAN1_IP1R_IntPnd16_9_MASK 0xFF00
#define CAN1_IP1R_IntPnd16_9_BIT 8

#define CAN1_IP2R (*(volatile unsigned short *)0xFFFFC844)
#define CAN1_IP2R_IntPnd24_17_MASK 0xFF
#define CAN1_IP2R_IntPnd24_17_BIT 0
#define CAN1_IP2R_IntPnd32_25_MASK 0xFF00
#define CAN1_IP2R_IntPnd32_25_BIT 8

#define CAN1_MV1R (*(volatile unsigned short *)0xFFFFC860)
#define CAN1_MV1R_MsgVal8_1_MASK 0xFF
#define CAN1_MV1R_MsgVal8_1_BIT 0
#define CAN1_MV1R_MsgVal16_9_MASK 0xFF00
#define CAN1_MV1R_MsgVal16_9_BIT 8

#define CAN1_MV2R (*(volatile unsigned short *)0xFFFFC864)
#define CAN1_MV2R_MsgVal24_17_MASK 0xFF
#define CAN1_MV2R_MsgVal24_17_BIT 0
#define CAN1_MV2R_MsgVal32_25_MASK 0xFF00
#define CAN1_MV2R_MsgVal32_25_BIT 8

#define CAN2_CR (*(volatile unsigned short *)0xFFFFCC00)
#define CAN2_CR_Init_MASK 0x1
#define CAN2_CR_Init 0x1
#define CAN2_CR_Init_BIT 0
#define CAN2_CR_IE_MASK 0x2
#define CAN2_CR_IE 0x2
#define CAN2_CR_IE_BIT 1
#define CAN2_CR_SIE_MASK 0x4
#define CAN2_CR_SIE 0x4
#define CAN2_CR_SIE_BIT 2
#define CAN2_CR_EIE_MASK 0x8
#define CAN2_CR_EIE 0x8
#define CAN2_CR_EIE_BIT 3
#define CAN2_CR_DAR_MASK 0x20
#define CAN2_CR_DAR 0x20
#define CAN2_CR_DAR_BIT 5
#define CAN2_CR_CCE_MASK 0x40
#define CAN2_CR_CCE 0x40
#define CAN2_CR_CCE_BIT 6
#define CAN2_CR_Test_MASK 0x80
#define CAN2_CR_Test 0x80
#define CAN2_CR_Test_BIT 7

#define CAN2_SR (*(volatile unsigned short *)0xFFFFCC04)
#define CAN2_SR_LEC_MASK 0x7
#define CAN2_SR_LEC_BIT 0
#define CAN2_SR_TxOk_MASK 0x8
#define CAN2_SR_TxOk 0x8
#define CAN2_SR_TxOk_BIT 3
#define CAN2_SR_RxOk_MASK 0x10
#define CAN2_SR_RxOk 0x10
#define CAN2_SR_RxOk_BIT 4
#define CAN2_SR_EPass_MASK 0x20
#define CAN2_SR_EPass 0x20
#define CAN2_SR_EPass_BIT 5
#define CAN2_SR_EWarn_MASK 0x40
#define CAN2_SR_EWarn 0x40
#define CAN2_SR_EWarn_BIT 6
#define CAN2_SR_BOff_MASK 0x80
#define CAN2_SR_BOff 0x80
#define CAN2_SR_BOff_BIT 7

#define CAN2_ERR (*(volatile unsigned short *)0xFFFFCC08)
#define CAN2_ERR_TEC7_0_MASK 0xFF
#define CAN2_ERR_TEC7_0_BIT 0
#define CAN2_ERR_REC6_0_MASK 0x7F00
#define CAN2_ERR_REC6_0_BIT 8
#define CAN2_ERR_RP_MASK 0x8000
#define CAN2_ERR_RP 0x8000
#define CAN2_ERR_RP_BIT 15

#define CAN2_BTR (*(volatile unsigned short *)0xFFFFCC0C)
#define CAN2_BTR_BRP_MASK 0x3F
#define CAN2_BTR_BRP_BIT 0
#define CAN2_BTR_SJW_MASK 0xC0
#define CAN2_BTR_SJW_BIT 6
#define CAN2_BTR_TSeg1_MASK 0xF00
#define CAN2_BTR_TSeg1_BIT 8
#define CAN2_BTR_TSeg2_MASK 0x7000
#define CAN2_BTR_TSeg2_BIT 12

#define CAN2_IDR (*(volatile unsigned short *)0xFFFFCC10)
#define CAN2_IDR_IntId7_0_MASK 0xFF
#define CAN2_IDR_IntId7_0_BIT 0
#define CAN2_IDR_IntId15_8_MASK 0xFF00
#define CAN2_IDR_IntId15_8_BIT 8

#define CAN2_TESTR (*(volatile unsigned short *)0xFFFFCC14)
#define CAN2_TESTR_Basic_MASK 0x4
#define CAN2_TESTR_Basic 0x4
#define CAN2_TESTR_Basic_BIT 2
#define CAN2_TESTR_Silent_MASK 0x8
#define CAN2_TESTR_Silent 0x8
#define CAN2_TESTR_Silent_BIT 3
#define CAN2_TESTR_LBack_MASK 0x10
#define CAN2_TESTR_LBack 0x10
#define CAN2_TESTR_LBack_BIT 4
#define CAN2_TESTR_Tx0_MASK 0x20
#define CAN2_TESTR_Tx0 0x20
#define CAN2_TESTR_Tx0_BIT 5
#define CAN2_TESTR_Tx1_MASK 0x40
#define CAN2_TESTR_Tx1 0x40
#define CAN2_TESTR_Tx1_BIT 6
#define CAN2_TESTR_Rx1_MASK 0x80
#define CAN2_TESTR_Rx1 0x80
#define CAN2_TESTR_Rx1_BIT 7

#define CAN2_BRPR (*(volatile unsigned short *)0xFFFFCC18)

#define CAN2_IF1_CRR (*(volatile unsigned short *)0xFFFFCC20)
#define CAN2_IF1_CRR_Message_Number_MASK 0x3F
#define CAN2_IF1_CRR_Message_Number_BIT 0
#define CAN2_IF1_CRR_Busy_MASK 0x8000
#define CAN2_IF1_CRR_Busy 0x8000
#define CAN2_IF1_CRR_Busy_BIT 15

#define CAN2_IF1_CMR (*(volatile unsigned short *)0xFFFFCC24)
#define CAN2_IF1_CMR_Data_B_MASK 0x1
#define CAN2_IF1_CMR_Data_B 0x1
#define CAN2_IF1_CMR_Data_B_BIT 0
#define CAN2_IF1_CMR_Data_A_MASK 0x2
#define CAN2_IF1_CMR_Data_A 0x2
#define CAN2_IF1_CMR_Data_A_BIT 1
#define CAN2_IF1_CMR_TxRqst_NewDat_MASK 0x4
#define CAN2_IF1_CMR_TxRqst_NewDat 0x4
#define CAN2_IF1_CMR_TxRqst_NewDat_BIT 2
#define CAN2_IF1_CMR_ClrIntPnd_MASK 0x8
#define CAN2_IF1_CMR_ClrIntPnd 0x8
#define CAN2_IF1_CMR_ClrIntPnd_BIT 3
#define CAN2_IF1_CMR_Control_MASK 0x10
#define CAN2_IF1_CMR_Control 0x10
#define CAN2_IF1_CMR_Control_BIT 4
#define CAN2_IF1_CMR_Arb_MASK 0x20
#define CAN2_IF1_CMR_Arb 0x20
#define CAN2_IF1_CMR_Arb_BIT 5
#define CAN2_IF1_CMR_Mask_MASK 0x40
#define CAN2_IF1_CMR_Mask 0x40
#define CAN2_IF1_CMR_Mask_BIT 6
#define CAN2_IF1_CMR_WR_RD_MASK 0x80
#define CAN2_IF1_CMR_WR_RD 0x80
#define CAN2_IF1_CMR_WR_RD_BIT 7

#define CAN2_IF1_M1R (*(volatile unsigned short *)0xFFFFCC28)

#define CAN2_IF1_M2R (*(volatile unsigned short *)0xFFFFCC2C)
#define CAN2_IF1_M2R_Msk28_16_MASK 0x1FFF
#define CAN2_IF1_M2R_Msk28_16_BIT 0
#define CAN2_IF1_M2R_MDir_MASK 0x4000
#define CAN2_IF1_M2R_MDir 0x4000
#define CAN2_IF1_M2R_MDir_BIT 14
#define CAN2_IF1_M2R_MXtd_MASK 0x8000
#define CAN2_IF1_M2R_MXtd 0x8000
#define CAN2_IF1_M2R_MXtd_BIT 15

#define CAN2_IF1_A1R (*(volatile unsigned short *)0xFFFFCC30)

#define CAN2_IF1_A2R (*(volatile unsigned short *)0xFFFFCC34)
#define CAN2_IF1_A2R_ID28_16_MASK 0x1FFF
#define CAN2_IF1_A2R_ID28_16_BIT 0
#define CAN2_IF1_A2R_Dir_MASK 0x2000
#define CAN2_IF1_A2R_Dir 0x2000
#define CAN2_IF1_A2R_Dir_BIT 13
#define CAN2_IF1_A2R_Xtd_MASK 0x4000
#define CAN2_IF1_A2R_Xtd 0x4000
#define CAN2_IF1_A2R_Xtd_BIT 14
#define CAN2_IF1_A2R_MsgVaI_MASK 0x8000
#define CAN2_IF1_A2R_MsgVaI 0x8000
#define CAN2_IF1_A2R_MsgVaI_BIT 15

#define CAN2_IF1_MCR (*(volatile unsigned short *)0xFFFFCC38)
#define CAN2_IF1_MCR_DLC3_0_MASK 0xF
#define CAN2_IF1_MCR_DLC3_0_BIT 0
#define CAN2_IF1_MCR_EoB_MASK 0x80
#define CAN2_IF1_MCR_EoB 0x80
#define CAN2_IF1_MCR_EoB_BIT 7
#define CAN2_IF1_MCR_TxRqst_MASK 0x100
#define CAN2_IF1_MCR_TxRqst 0x100
#define CAN2_IF1_MCR_TxRqst_BIT 8
#define CAN2_IF1_MCR_RmtEn_MASK 0x200
#define CAN2_IF1_MCR_RmtEn 0x200
#define CAN2_IF1_MCR_RmtEn_BIT 9
#define CAN2_IF1_MCR_RxlE_MASK 0x400
#define CAN2_IF1_MCR_RxlE 0x400
#define CAN2_IF1_MCR_RxlE_BIT 10
#define CAN2_IF1_MCR_TxlE_MASK 0x800
#define CAN2_IF1_MCR_TxlE 0x800
#define CAN2_IF1_MCR_TxlE_BIT 11
#define CAN2_IF1_MCR_UMask_MASK 0x1000
#define CAN2_IF1_MCR_UMask 0x1000
#define CAN2_IF1_MCR_UMask_BIT 12
#define CAN2_IF1_MCR_IntPnd_MASK 0x2000
#define CAN2_IF1_MCR_IntPnd 0x2000
#define CAN2_IF1_MCR_IntPnd_BIT 13
#define CAN2_IF1_MCR_MsgLst_MASK 0x4000
#define CAN2_IF1_MCR_MsgLst 0x4000
#define CAN2_IF1_MCR_MsgLst_BIT 14
#define CAN2_IF1_MCR_NewDat_MASK 0x8000
#define CAN2_IF1_MCR_NewDat 0x8000
#define CAN2_IF1_MCR_NewDat_BIT 15

#define CAN2_IF1_DA1R (*(volatile unsigned short *)0xFFFFCC3C)

#define CAN2_IF1_DA2R (*(volatile unsigned short *)0xFFFFCC40)

#define CAN2_IF1_DB1R (*(volatile unsigned short *)0xFFFFCC44)

#define CAN2_IF1_DB2R (*(volatile unsigned short *)0xFFFFCC48)

#define CAN2_IF2_CRR (*(volatile unsigned short *)0xFFFFCC80)
#define CAN2_IF2_CRR_Message_Number_MASK 0x3F
#define CAN2_IF2_CRR_Message_Number_BIT 0
#define CAN2_IF2_CRR_Busy_MASK 0x8000
#define CAN2_IF2_CRR_Busy 0x8000
#define CAN2_IF2_CRR_Busy_BIT 15

#define CAN2_IF2_CMR (*(volatile unsigned short *)0xFFFFCC84)
#define CAN2_IF2_CMR_Data_B_MASK 0x1
#define CAN2_IF2_CMR_Data_B 0x1
#define CAN2_IF2_CMR_Data_B_BIT 0
#define CAN2_IF2_CMR_Data_A_MASK 0x2
#define CAN2_IF2_CMR_Data_A 0x2
#define CAN2_IF2_CMR_Data_A_BIT 1
#define CAN2_IF2_CMR_TxRqst_NewDat_MASK 0x4
#define CAN2_IF2_CMR_TxRqst_NewDat 0x4
#define CAN2_IF2_CMR_TxRqst_NewDat_BIT 2
#define CAN2_IF2_CMR_ClrIntPnd_MASK 0x8
#define CAN2_IF2_CMR_ClrIntPnd 0x8
#define CAN2_IF2_CMR_ClrIntPnd_BIT 3
#define CAN2_IF2_CMR_Control_MASK 0x10
#define CAN2_IF2_CMR_Control 0x10
#define CAN2_IF2_CMR_Control_BIT 4
#define CAN2_IF2_CMR_Arb_MASK 0x20
#define CAN2_IF2_CMR_Arb 0x20
#define CAN2_IF2_CMR_Arb_BIT 5
#define CAN2_IF2_CMR_Mask_MASK 0x40
#define CAN2_IF2_CMR_Mask 0x40
#define CAN2_IF2_CMR_Mask_BIT 6
#define CAN2_IF2_CMR_WR_RD_MASK 0x80
#define CAN2_IF2_CMR_WR_RD 0x80
#define CAN2_IF2_CMR_WR_RD_BIT 7

#define CAN2_IF2_M1R (*(volatile unsigned short *)0xFFFFCC88)

#define CAN2_IF2_M2R (*(volatile unsigned short *)0xFFFFCC8C)
#define CAN2_IF2_M2R_Msk28_16_MASK 0x1FFF
#define CAN2_IF2_M2R_Msk28_16_BIT 0
#define CAN2_IF2_M2R_MDir_MASK 0x4000
#define CAN2_IF2_M2R_MDir 0x4000
#define CAN2_IF2_M2R_MDir_BIT 14
#define CAN2_IF2_M2R_MXtd_MASK 0x8000
#define CAN2_IF2_M2R_MXtd 0x8000
#define CAN2_IF2_M2R_MXtd_BIT 15

#define CAN2_IF2_A1R (*(volatile unsigned short *)0xFFFFCC90)

#define CAN2_IF2_A2R (*(volatile unsigned short *)0xFFFFCC94)
#define CAN2_IF2_A2R_ID28_16_MASK 0x1FFF
#define CAN2_IF2_A2R_ID28_16_BIT 0
#define CAN2_IF2_A2R_Dir_MASK 0x2000
#define CAN2_IF2_A2R_Dir 0x2000
#define CAN2_IF2_A2R_Dir_BIT 13
#define CAN2_IF2_A2R_Xtd_MASK 0x4000
#define CAN2_IF2_A2R_Xtd 0x4000
#define CAN2_IF2_A2R_Xtd_BIT 14
#define CAN2_IF2_A2R_MsgVaI_MASK 0x8000
#define CAN2_IF2_A2R_MsgVaI 0x8000
#define CAN2_IF2_A2R_MsgVaI_BIT 15

#define CAN2_IF2_MCR (*(volatile unsigned short *)0xFFFFCC98)
#define CAN2_IF2_MCR_DLC3_0_MASK 0xF
#define CAN2_IF2_MCR_DLC3_0_BIT 0
#define CAN2_IF2_MCR_EoB_MASK 0x80
#define CAN2_IF2_MCR_EoB 0x80
#define CAN2_IF2_MCR_EoB_BIT 7
#define CAN2_IF2_MCR_TxRqst_MASK 0x100
#define CAN2_IF2_MCR_TxRqst 0x100
#define CAN2_IF2_MCR_TxRqst_BIT 8
#define CAN2_IF2_MCR_RmtEn_MASK 0x200
#define CAN2_IF2_MCR_RmtEn 0x200
#define CAN2_IF2_MCR_RmtEn_BIT 9
#define CAN2_IF2_MCR_RxlE_MASK 0x400
#define CAN2_IF2_MCR_RxlE 0x400
#define CAN2_IF2_MCR_RxlE_BIT 10
#define CAN2_IF2_MCR_TxlE_MASK 0x800
#define CAN2_IF2_MCR_TxlE 0x800
#define CAN2_IF2_MCR_TxlE_BIT 11
#define CAN2_IF2_MCR_UMask_MASK 0x1000
#define CAN2_IF2_MCR_UMask 0x1000
#define CAN2_IF2_MCR_UMask_BIT 12
#define CAN2_IF2_MCR_IntPnd_MASK 0x2000
#define CAN2_IF2_MCR_IntPnd 0x2000
#define CAN2_IF2_MCR_IntPnd_BIT 13
#define CAN2_IF2_MCR_MsgLst_MASK 0x4000
#define CAN2_IF2_MCR_MsgLst 0x4000
#define CAN2_IF2_MCR_MsgLst_BIT 14
#define CAN2_IF2_MCR_NewDat_MASK 0x8000
#define CAN2_IF2_MCR_NewDat 0x8000
#define CAN2_IF2_MCR_NewDat_BIT 15

#define CAN2_IF2_DA1R (*(volatile unsigned short *)0xFFFFCC9C)

#define CAN2_IF2_DA2R (*(volatile unsigned short *)0xFFFFCCA0)

#define CAN2_IF2_DB1R (*(volatile unsigned short *)0xFFFFCCA4)

#define CAN2_IF2_DB2R (*(volatile unsigned short *)0xFFFFCCA8)

#define CAN2_TxR1R (*(volatile unsigned short *)0xFFFFCC00)

#define CAN2_TxR2R (*(volatile unsigned short *)0xFFFFCC04)

#define CAN2_ND1R (*(volatile unsigned short *)0xFFFFCC20)

#define CAN2_ND2R (*(volatile unsigned short *)0xFFFFCC24)

#define CAN2_IP1R (*(volatile unsigned short *)0xFFFFCC40)
#define CAN2_IP1R_IntPnd8_1_MASK 0xFF
#define CAN2_IP1R_IntPnd8_1_BIT 0
#define CAN2_IP1R_IntPnd16_9_MASK 0xFF00
#define CAN2_IP1R_IntPnd16_9_BIT 8

#define CAN2_IP2R (*(volatile unsigned short *)0xFFFFCC44)
#define CAN2_IP2R_IntPnd24_17_MASK 0xFF
#define CAN2_IP2R_IntPnd24_17_BIT 0
#define CAN2_IP2R_IntPnd32_25_MASK 0xFF00
#define CAN2_IP2R_IntPnd32_25_BIT 8

#define CAN2_MV1R (*(volatile unsigned short *)0xFFFFCC60)
#define CAN2_MV1R_MsgVal8_1_MASK 0xFF
#define CAN2_MV1R_MsgVal8_1_BIT 0
#define CAN2_MV1R_MsgVal16_9_MASK 0xFF00
#define CAN2_MV1R_MsgVal16_9_BIT 8

#define CAN2_MV2R (*(volatile unsigned short *)0xFFFFCC64)
#define CAN2_MV2R_MsgVal24_17_MASK 0xFF
#define CAN2_MV2R_MsgVal24_17_BIT 0
#define CAN2_MV2R_MsgVal32_25_MASK 0xFF00
#define CAN2_MV2R_MsgVal32_25_BIT 8

#define PWM0_PRS0 (*(volatile unsigned short *)0xFFFFD000)
#define PWM0_PRS0_PR00_MASK 0x1
#define PWM0_PRS0_PR00 0x1
#define PWM0_PRS0_PR00_BIT 0
#define PWM0_PRS0_PR01_MASK 0x2
#define PWM0_PRS0_PR01 0x2
#define PWM0_PRS0_PR01_BIT 1
#define PWM0_PRS0_PR02_MASK 0xC
#define PWM0_PRS0_PR02_BIT 2

#define PWM0_PRS1 (*(volatile unsigned short *)0xFFFFD004)
#define PWM0_PRS1_PR10_MASK 0x1
#define PWM0_PRS1_PR10 0x1
#define PWM0_PRS1_PR10_BIT 0
#define PWM0_PRS1_PR11_MASK 0x2
#define PWM0_PRS1_PR11 0x2
#define PWM0_PRS1_PR11_BIT 1
#define PWM0_PRS1_PR12_MASK 0xC
#define PWM0_PRS1_PR12_BIT 2
#define PWM0_PRS1_PR13_MASK 0x8
#define PWM0_PRS1_PR13 0x8
#define PWM0_PRS1_PR13_BIT 3
#define PWM0_PRS1_PR14_MASK 0x10
#define PWM0_PRS1_PR14 0x10
#define PWM0_PRS1_PR14_BIT 4

#define PWM0_PEN (*(volatile unsigned short *)0xFFFFD008)
#define PWM0_PEN_PE_MASK 0x1
#define PWM0_PEN_PE 0x1
#define PWM0_PEN_PE_BIT 0

#define PWM0_PLS (*(volatile unsigned short *)0xFFFFD00C)
#define PWM0_PLS_PL_MASK 0x1
#define PWM0_PLS_PL 0x1
#define PWM0_PLS_PL_BIT 0

#define PWM0_CPI (*(volatile unsigned short *)0xFFFFD010)
#define PWM0_CPI_CP_MASK 0x1
#define PWM0_CPI_CP 0x1
#define PWM0_CPI_CP_BIT 0

#define PWM0_IM (*(volatile unsigned short *)0xFFFFD014)
#define PWM0_IM_IM_MASK 0x1
#define PWM0_IM_IM 0x1
#define PWM0_IM_IM_BIT 0

#define PWM0_DUT (*(volatile unsigned short *)0xFFFFD01C)

#define PWM0_PER (*(volatile unsigned short *)0xFFFFD020)

#define PWM1_PRS0 (*(volatile unsigned short *)0xFFFFD040)
#define PWM1_PRS0_PR00_MASK 0x1
#define PWM1_PRS0_PR00 0x1
#define PWM1_PRS0_PR00_BIT 0
#define PWM1_PRS0_PR01_MASK 0x2
#define PWM1_PRS0_PR01 0x2
#define PWM1_PRS0_PR01_BIT 1
#define PWM1_PRS0_PR02_MASK 0xC
#define PWM1_PRS0_PR02_BIT 2

#define PWM1_PRS1 (*(volatile unsigned short *)0xFFFFD044)
#define PWM1_PRS1_PR10_MASK 0x1
#define PWM1_PRS1_PR10 0x1
#define PWM1_PRS1_PR10_BIT 0
#define PWM1_PRS1_PR11_MASK 0x2
#define PWM1_PRS1_PR11 0x2
#define PWM1_PRS1_PR11_BIT 1
#define PWM1_PRS1_PR12_MASK 0xC
#define PWM1_PRS1_PR12_BIT 2
#define PWM1_PRS1_PR13_MASK 0x8
#define PWM1_PRS1_PR13 0x8
#define PWM1_PRS1_PR13_BIT 3
#define PWM1_PRS1_PR14_MASK 0x10
#define PWM1_PRS1_PR14 0x10
#define PWM1_PRS1_PR14_BIT 4

#define PWM1_PEN (*(volatile unsigned short *)0xFFFFD048)
#define PWM1_PEN_PE_MASK 0x1
#define PWM1_PEN_PE 0x1
#define PWM1_PEN_PE_BIT 0

#define PWM1_PLS (*(volatile unsigned short *)0xFFFFD04C)
#define PWM1_PLS_PL_MASK 0x1
#define PWM1_PLS_PL 0x1
#define PWM1_PLS_PL_BIT 0

#define PWM1_CPI (*(volatile unsigned short *)0xFFFFD050)
#define PWM1_CPI_CP_MASK 0x1
#define PWM1_CPI_CP 0x1
#define PWM1_CPI_CP_BIT 0

#define PWM1_IM (*(volatile unsigned short *)0xFFFFD054)
#define PWM1_IM_IM_MASK 0x1
#define PWM1_IM_IM 0x1
#define PWM1_IM_IM_BIT 0

#define PWM1_DUT (*(volatile unsigned short *)0xFFFFD05C)

#define PWM1_PER (*(volatile unsigned short *)0xFFFFD060)

#define PWM2_PRS0 (*(volatile unsigned short *)0xFFFFD080)
#define PWM2_PRS0_PR00_MASK 0x1
#define PWM2_PRS0_PR00 0x1
#define PWM2_PRS0_PR00_BIT 0
#define PWM2_PRS0_PR01_MASK 0x2
#define PWM2_PRS0_PR01 0x2
#define PWM2_PRS0_PR01_BIT 1
#define PWM2_PRS0_PR02_MASK 0xC
#define PWM2_PRS0_PR02_BIT 2

#define PWM2_PRS1 (*(volatile unsigned short *)0xFFFFD084)
#define PWM2_PRS1_PR10_MASK 0x1
#define PWM2_PRS1_PR10 0x1
#define PWM2_PRS1_PR10_BIT 0
#define PWM2_PRS1_PR11_MASK 0x2
#define PWM2_PRS1_PR11 0x2
#define PWM2_PRS1_PR11_BIT 1
#define PWM2_PRS1_PR12_MASK 0xC
#define PWM2_PRS1_PR12_BIT 2
#define PWM2_PRS1_PR13_MASK 0x8
#define PWM2_PRS1_PR13 0x8
#define PWM2_PRS1_PR13_BIT 3
#define PWM2_PRS1_PR14_MASK 0x10
#define PWM2_PRS1_PR14 0x10
#define PWM2_PRS1_PR14_BIT 4

#define PWM2_PEN (*(volatile unsigned short *)0xFFFFD088)
#define PWM2_PEN_PE_MASK 0x1
#define PWM2_PEN_PE 0x1
#define PWM2_PEN_PE_BIT 0

#define PWM2_PLS (*(volatile unsigned short *)0xFFFFD08C)
#define PWM2_PLS_PL_MASK 0x1
#define PWM2_PLS_PL 0x1
#define PWM2_PLS_PL_BIT 0

#define PWM2_CPI (*(volatile unsigned short *)0xFFFFD090)
#define PWM2_CPI_CP_MASK 0x1
#define PWM2_CPI_CP 0x1
#define PWM2_CPI_CP_BIT 0

#define PWM2_IM (*(volatile unsigned short *)0xFFFFD094)
#define PWM2_IM_IM_MASK 0x1
#define PWM2_IM_IM 0x1
#define PWM2_IM_IM_BIT 0

#define PWM2_DUT (*(volatile unsigned short *)0xFFFFD09C)

#define PWM2_PER (*(volatile unsigned short *)0xFFFFD0A0)

#define PWM3_PRS0 (*(volatile unsigned short *)0xFFFFD0C0)
#define PWM3_PRS0_PR00_MASK 0x1
#define PWM3_PRS0_PR00 0x1
#define PWM3_PRS0_PR00_BIT 0
#define PWM3_PRS0_PR01_MASK 0x2
#define PWM3_PRS0_PR01 0x2
#define PWM3_PRS0_PR01_BIT 1
#define PWM3_PRS0_PR02_MASK 0xC
#define PWM3_PRS0_PR02_BIT 2

#define PWM3_PRS1 (*(volatile unsigned short *)0xFFFFD0C4)
#define PWM3_PRS1_PR10_MASK 0x1
#define PWM3_PRS1_PR10 0x1
#define PWM3_PRS1_PR10_BIT 0
#define PWM3_PRS1_PR11_MASK 0x2
#define PWM3_PRS1_PR11 0x2
#define PWM3_PRS1_PR11_BIT 1
#define PWM3_PRS1_PR12_MASK 0xC
#define PWM3_PRS1_PR12_BIT 2
#define PWM3_PRS1_PR13_MASK 0x8
#define PWM3_PRS1_PR13 0x8
#define PWM3_PRS1_PR13_BIT 3
#define PWM3_PRS1_PR14_MASK 0x10
#define PWM3_PRS1_PR14 0x10
#define PWM3_PRS1_PR14_BIT 4

#define PWM3_PEN (*(volatile unsigned short *)0xFFFFD0C8)
#define PWM3_PEN_PE_MASK 0x1
#define PWM3_PEN_PE 0x1
#define PWM3_PEN_PE_BIT 0

#define PWM3_PLS (*(volatile unsigned short *)0xFFFFD0CC)
#define PWM3_PLS_PL_MASK 0x1
#define PWM3_PLS_PL 0x1
#define PWM3_PLS_PL_BIT 0

#define PWM3_CPI (*(volatile unsigned short *)0xFFFFD0D0)
#define PWM3_CPI_CP_MASK 0x1
#define PWM3_CPI_CP 0x1
#define PWM3_CPI_CP_BIT 0

#define PWM3_IM (*(volatile unsigned short *)0xFFFFD0D4)
#define PWM3_IM_IM_MASK 0x1
#define PWM3_IM_IM 0x1
#define PWM3_IM_IM_BIT 0

#define PWM3_DUT (*(volatile unsigned short *)0xFFFFD0DC)

#define PWM3_PER (*(volatile unsigned short *)0xFFFFD0E0)

#define PWM4_PRS0 (*(volatile unsigned short *)0xFFFFD100)
#define PWM4_PRS0_PR00_MASK 0x1
#define PWM4_PRS0_PR00 0x1
#define PWM4_PRS0_PR00_BIT 0
#define PWM4_PRS0_PR01_MASK 0x2
#define PWM4_PRS0_PR01 0x2
#define PWM4_PRS0_PR01_BIT 1
#define PWM4_PRS0_PR02_MASK 0xC
#define PWM4_PRS0_PR02_BIT 2

#define PWM4_PRS1 (*(volatile unsigned short *)0xFFFFD104)
#define PWM4_PRS1_PR10_MASK 0x1
#define PWM4_PRS1_PR10 0x1
#define PWM4_PRS1_PR10_BIT 0
#define PWM4_PRS1_PR11_MASK 0x2
#define PWM4_PRS1_PR11 0x2
#define PWM4_PRS1_PR11_BIT 1
#define PWM4_PRS1_PR12_MASK 0xC
#define PWM4_PRS1_PR12_BIT 2
#define PWM4_PRS1_PR13_MASK 0x8
#define PWM4_PRS1_PR13 0x8
#define PWM4_PRS1_PR13_BIT 3
#define PWM4_PRS1_PR14_MASK 0x10
#define PWM4_PRS1_PR14 0x10
#define PWM4_PRS1_PR14_BIT 4

#define PWM4_PEN (*(volatile unsigned short *)0xFFFFD108)
#define PWM4_PEN_PE_MASK 0x1
#define PWM4_PEN_PE 0x1
#define PWM4_PEN_PE_BIT 0

#define PWM4_PLS (*(volatile unsigned short *)0xFFFFD10C)
#define PWM4_PLS_PL_MASK 0x1
#define PWM4_PLS_PL 0x1
#define PWM4_PLS_PL_BIT 0

#define PWM4_CPI (*(volatile unsigned short *)0xFFFFD110)
#define PWM4_CPI_CP_MASK 0x1
#define PWM4_CPI_CP 0x1
#define PWM4_CPI_CP_BIT 0

#define PWM4_IM (*(volatile unsigned short *)0xFFFFD114)
#define PWM4_IM_IM_MASK 0x1
#define PWM4_IM_IM 0x1
#define PWM4_IM_IM_BIT 0

#define PWM4_DUT (*(volatile unsigned short *)0xFFFFD11C)

#define PWM4_PER (*(volatile unsigned short *)0xFFFFD120)

#define PWM5_PRS0 (*(volatile unsigned short *)0xFFFFD140)
#define PWM5_PRS0_PR00_MASK 0x1
#define PWM5_PRS0_PR00 0x1
#define PWM5_PRS0_PR00_BIT 0
#define PWM5_PRS0_PR01_MASK 0x2
#define PWM5_PRS0_PR01 0x2
#define PWM5_PRS0_PR01_BIT 1
#define PWM5_PRS0_PR02_MASK 0xC
#define PWM5_PRS0_PR02_BIT 2

#define PWM5_PRS1 (*(volatile unsigned short *)0xFFFFD144)
#define PWM5_PRS1_PR10_MASK 0x1
#define PWM5_PRS1_PR10 0x1
#define PWM5_PRS1_PR10_BIT 0
#define PWM5_PRS1_PR11_MASK 0x2
#define PWM5_PRS1_PR11 0x2
#define PWM5_PRS1_PR11_BIT 1
#define PWM5_PRS1_PR12_MASK 0xC
#define PWM5_PRS1_PR12_BIT 2
#define PWM5_PRS1_PR13_MASK 0x8
#define PWM5_PRS1_PR13 0x8
#define PWM5_PRS1_PR13_BIT 3
#define PWM5_PRS1_PR14_MASK 0x10
#define PWM5_PRS1_PR14 0x10
#define PWM5_PRS1_PR14_BIT 4

#define PWM5_PEN (*(volatile unsigned short *)0xFFFFD148)
#define PWM5_PEN_PE_MASK 0x1
#define PWM5_PEN_PE 0x1
#define PWM5_PEN_PE_BIT 0

#define PWM5_PLS (*(volatile unsigned short *)0xFFFFD14C)
#define PWM5_PLS_PL_MASK 0x1
#define PWM5_PLS_PL 0x1
#define PWM5_PLS_PL_BIT 0

#define PWM5_CPI (*(volatile unsigned short *)0xFFFFD150)
#define PWM5_CPI_CP_MASK 0x1
#define PWM5_CPI_CP 0x1
#define PWM5_CPI_CP_BIT 0

#define PWM5_IM (*(volatile unsigned short *)0xFFFFD154)
#define PWM5_IM_IM_MASK 0x1
#define PWM5_IM_IM 0x1
#define PWM5_IM_IM_BIT 0

#define PWM5_DUT (*(volatile unsigned short *)0xFFFFD15C)

#define PWM5_PER (*(volatile unsigned short *)0xFFFFD160)

#define IOPORT0_PC0 (*(volatile unsigned short *)0xFFFFD400)

#define IOPORT0_PC1 (*(volatile unsigned short *)0xFFFFD404)

#define IOPORT0_PC2 (*(volatile unsigned short *)0xFFFFD408)

#define IOPORT0_PD (*(volatile unsigned short *)0xFFFFD40C)

#define IOPORT1_PC0 (*(volatile unsigned short *)0xFFFFD410)

#define IOPORT1_PC1 (*(volatile unsigned short *)0xFFFFD414)

#define IOPORT1_PC2 (*(volatile unsigned short *)0xFFFFD418)

#define IOPORT1_PD (*(volatile unsigned short *)0xFFFFD41C)

#define IOPORT2_PC0 (*(volatile unsigned short *)0xFFFFD420)

#define IOPORT2_PC1 (*(volatile unsigned short *)0xFFFFD424)

#define IOPORT2_PC2 (*(volatile unsigned short *)0xFFFFD428)

#define IOPORT2_PD (*(volatile unsigned short *)0xFFFFD42C)

#define IOPORT3_PC0 (*(volatile unsigned short *)0xFFFFD430)

#define IOPORT3_PC1 (*(volatile unsigned short *)0xFFFFD434)

#define IOPORT3_PC2 (*(volatile unsigned short *)0xFFFFD438)

#define IOPORT3_PD (*(volatile unsigned short *)0xFFFFD43C)

#define IOPORT4_PC0 (*(volatile unsigned short *)0xFFFFD440)

#define IOPORT4_PC1 (*(volatile unsigned short *)0xFFFFD444)

#define IOPORT4_PC2 (*(volatile unsigned short *)0xFFFFD448)

#define IOPORT4_PD (*(volatile unsigned short *)0xFFFFD44C)

#define IOPORT5_PC0 (*(volatile unsigned short *)0xFFFFD450)

#define IOPORT5_PC1 (*(volatile unsigned short *)0xFFFFD454)

#define IOPORT5_PC2 (*(volatile unsigned short *)0xFFFFD458)

#define IOPORT5_PD (*(volatile unsigned short *)0xFFFFD45C)

#define IOPORT6_PC0 (*(volatile unsigned short *)0xFFFFD460)

#define IOPORT6_PC1 (*(volatile unsigned short *)0xFFFFD464)

#define IOPORT6_PC2 (*(volatile unsigned short *)0xFFFFD468)

#define IOPORT6_PD (*(volatile unsigned short *)0xFFFFD46C)

#define BSPI0_RXR (*(volatile unsigned short *)0xFFFFD800)

#define BSPI0_TXR (*(volatile unsigned short *)0xFFFFD804)

#define BSPI0_CSR1 (*(volatile unsigned short *)0xFFFFD808)
#define BSPI0_CSR1_BSPE_MASK 0x1
#define BSPI0_CSR1_BSPE 0x1
#define BSPI0_CSR1_BSPE_BIT 0
#define BSPI0_CSR1_MSTR_MASK 0x2
#define BSPI0_CSR1_MSTR 0x2
#define BSPI0_CSR1_MSTR_BIT 1
#define BSPI0_CSR1_RIE_MASK 0xC
#define BSPI0_CSR1_RIE_BIT 2
#define BSPI0_CSR1_REIE_MASK 0x10
#define BSPI0_CSR1_REIE 0x10
#define BSPI0_CSR1_REIE_BIT 4
#define BSPI0_CSR1_BEIE_MASK 0x80
#define BSPI0_CSR1_BEIE 0x80
#define BSPI0_CSR1_BEIE_BIT 7
#define BSPI0_CSR1_CPOL_MASK 0x100
#define BSPI0_CSR1_CPOL 0x100
#define BSPI0_CSR1_CPOL_BIT 8
#define BSPI0_CSR1_CPHA_MASK 0x200
#define BSPI0_CSR1_CPHA 0x200
#define BSPI0_CSR1_CPHA_BIT 9
#define BSPI0_CSR1_WL_MASK 0xC00
#define BSPI0_CSR1_WL_BIT 10
#define BSPI0_CSR1_RFE_MASK 0xF000
#define BSPI0_CSR1_RFE_BIT 12

#define BSPI0_CSR2 (*(volatile unsigned short *)0xFFFFD80C)
#define BSPI0_CSR2_DFIFO_MASK 0x1
#define BSPI0_CSR2_DFIFO 0x1
#define BSPI0_CSR2_DFIFO_BIT 0
#define BSPI0_CSR2_BERR_MASK 0x4
#define BSPI0_CSR2_BERR 0x4
#define BSPI0_CSR2_BERR_BIT 2
#define BSPI0_CSR2_RFNE_MASK 0x8
#define BSPI0_CSR2_RFNE 0x8
#define BSPI0_CSR2_RFNE_BIT 3
#define BSPI0_CSR2_RFF_MASK 0x10
#define BSPI0_CSR2_RFF 0x10
#define BSPI0_CSR2_RFF_BIT 4
#define BSPI0_CSR2_ROFL_MASK 0x20
#define BSPI0_CSR2_ROFL 0x20
#define BSPI0_CSR2_ROFL_BIT 5
#define BSPI0_CSR2_TFE_MASK 0x40
#define BSPI0_CSR2_TFE 0x40
#define BSPI0_CSR2_TFE_BIT 6
#define BSPI0_CSR2_TUFL_MASK 0x80
#define BSPI0_CSR2_TUFL 0x80
#define BSPI0_CSR2_TUFL_BIT 7
#define BSPI0_CSR2_TFF_MASK 0x100
#define BSPI0_CSR2_TFF 0x100
#define BSPI0_CSR2_TFF_BIT 8
#define BSPI0_CSR2_TFNE_MASK 0x200
#define BSPI0_CSR2_TFNE 0x200
#define BSPI0_CSR2_TFNE_BIT 9
#define BSPI0_CSR2_TFE_MASK 0x3C00
#define BSPI0_CSR2_TFE_BIT 10
#define BSPI0_CSR2_TIE_MASK 0xC000
#define BSPI0_CSR2_TIE_BIT 14

#define BSPI0_CLK (*(volatile unsigned short *)0xFFFFD810)

#define BSPI0_CSR3 (*(volatile unsigned short *)0xFFFFD814)
#define BSPI0_CSR3_MASK_SS_MASK 0x1
#define BSPI0_CSR3_MASK_SS 0x1
#define BSPI0_CSR3_MASK_SS_BIT 0
#define BSPI0_CSR3_DMA_EN_MASK 0x2
#define BSPI0_CSR3_DMA_EN 0x2
#define BSPI0_CSR3_DMA_EN_BIT 1
#define BSPI0_CSR3_TBURST_LEN_MASK 0xC
#define BSPI0_CSR3_TBURST_LEN_BIT 2
#define BSPI0_CSR3_RBURST_LEN_MASK 0x30
#define BSPI0_CSR3_RBURST_LEN_BIT 4
#define BSPI0_CSR3_TREQ_EN_MASK 0x40
#define BSPI0_CSR3_TREQ_EN 0x40
#define BSPI0_CSR3_TREQ_EN_BIT 6
#define BSPI0_CSR3_RREQ_EN_MASK 0x80
#define BSPI0_CSR3_RREQ_EN 0x80
#define BSPI0_CSR3_RREQ_EN_BIT 7

#define BSPI1_RXR (*(volatile unsigned short *)0xFFFFDC00)

#define BSPI1_TXR (*(volatile unsigned short *)0xFFFFDC04)

#define BSPI1_CSR1 (*(volatile unsigned short *)0xFFFFDC08)
#define BSPI1_CSR1_BSPE_MASK 0x1
#define BSPI1_CSR1_BSPE 0x1
#define BSPI1_CSR1_BSPE_BIT 0
#define BSPI1_CSR1_MSTR_MASK 0x2
#define BSPI1_CSR1_MSTR 0x2
#define BSPI1_CSR1_MSTR_BIT 1
#define BSPI1_CSR1_RIE_MASK 0xC
#define BSPI1_CSR1_RIE_BIT 2
#define BSPI1_CSR1_REIE_MASK 0x10
#define BSPI1_CSR1_REIE 0x10
#define BSPI1_CSR1_REIE_BIT 4
#define BSPI1_CSR1_BEIE_MASK 0x80
#define BSPI1_CSR1_BEIE 0x80
#define BSPI1_CSR1_BEIE_BIT 7
#define BSPI1_CSR1_CPOL_MASK 0x100
#define BSPI1_CSR1_CPOL 0x100
#define BSPI1_CSR1_CPOL_BIT 8
#define BSPI1_CSR1_CPHA_MASK 0x200
#define BSPI1_CSR1_CPHA 0x200
#define BSPI1_CSR1_CPHA_BIT 9
#define BSPI1_CSR1_WL_MASK 0xC00
#define BSPI1_CSR1_WL_BIT 10
#define BSPI1_CSR1_RFE_MASK 0xF000
#define BSPI1_CSR1_RFE_BIT 12

#define BSPI1_CSR2 (*(volatile unsigned short *)0xFFFFDC0C)
#define BSPI1_CSR2_DFIFO_MASK 0x1
#define BSPI1_CSR2_DFIFO 0x1
#define BSPI1_CSR2_DFIFO_BIT 0
#define BSPI1_CSR2_BERR_MASK 0x4
#define BSPI1_CSR2_BERR 0x4
#define BSPI1_CSR2_BERR_BIT 2
#define BSPI1_CSR2_RFNE_MASK 0x8
#define BSPI1_CSR2_RFNE 0x8
#define BSPI1_CSR2_RFNE_BIT 3
#define BSPI1_CSR2_RFF_MASK 0x10
#define BSPI1_CSR2_RFF 0x10
#define BSPI1_CSR2_RFF_BIT 4
#define BSPI1_CSR2_ROFL_MASK 0x20
#define BSPI1_CSR2_ROFL 0x20
#define BSPI1_CSR2_ROFL_BIT 5
#define BSPI1_CSR2_TFE_MASK 0x40
#define BSPI1_CSR2_TFE 0x40
#define BSPI1_CSR2_TFE_BIT 6
#define BSPI1_CSR2_TUFL_MASK 0x80
#define BSPI1_CSR2_TUFL 0x80
#define BSPI1_CSR2_TUFL_BIT 7
#define BSPI1_CSR2_TFF_MASK 0x100
#define BSPI1_CSR2_TFF 0x100
#define BSPI1_CSR2_TFF_BIT 8
#define BSPI1_CSR2_TFNE_MASK 0x200
#define BSPI1_CSR2_TFNE 0x200
#define BSPI1_CSR2_TFNE_BIT 9
#define BSPI1_CSR2_TFE_MASK 0x3C00
#define BSPI1_CSR2_TFE_BIT 10
#define BSPI1_CSR2_TIE_MASK 0xC000
#define BSPI1_CSR2_TIE_BIT 14

#define BSPI1_CLK (*(volatile unsigned short *)0xFFFFDC10)

#define BSPI1_CSR3 (*(volatile unsigned short *)0xFFFFDC14)
#define BSPI1_CSR3_MASK_SS_MASK 0x1
#define BSPI1_CSR3_MASK_SS 0x1
#define BSPI1_CSR3_MASK_SS_BIT 0
#define BSPI1_CSR3_DMA_EN_MASK 0x2
#define BSPI1_CSR3_DMA_EN 0x2
#define BSPI1_CSR3_DMA_EN_BIT 1
#define BSPI1_CSR3_TBURST_LEN_MASK 0xC
#define BSPI1_CSR3_TBURST_LEN_BIT 2
#define BSPI1_CSR3_RBURST_LEN_MASK 0x30
#define BSPI1_CSR3_RBURST_LEN_BIT 4
#define BSPI1_CSR3_TREQ_EN_MASK 0x40
#define BSPI1_CSR3_TREQ_EN 0x40
#define BSPI1_CSR3_TREQ_EN_BIT 6
#define BSPI1_CSR3_RREQ_EN_MASK 0x80
#define BSPI1_CSR3_RREQ_EN 0x80
#define BSPI1_CSR3_RREQ_EN_BIT 7

#define BSPI2_RXR (*(volatile unsigned short *)0xFFFFE000)

#define BSPI2_TXR (*(volatile unsigned short *)0xFFFFE004)

#define BSPI2_CSR1 (*(volatile unsigned short *)0xFFFFE008)
#define BSPI2_CSR1_BSPE_MASK 0x1
#define BSPI2_CSR1_BSPE 0x1
#define BSPI2_CSR1_BSPE_BIT 0
#define BSPI2_CSR1_MSTR_MASK 0x2
#define BSPI2_CSR1_MSTR 0x2
#define BSPI2_CSR1_MSTR_BIT 1
#define BSPI2_CSR1_RIE_MASK 0xC
#define BSPI2_CSR1_RIE_BIT 2
#define BSPI2_CSR1_REIE_MASK 0x10
#define BSPI2_CSR1_REIE 0x10
#define BSPI2_CSR1_REIE_BIT 4
#define BSPI2_CSR1_BEIE_MASK 0x80
#define BSPI2_CSR1_BEIE 0x80
#define BSPI2_CSR1_BEIE_BIT 7
#define BSPI2_CSR1_CPOL_MASK 0x100
#define BSPI2_CSR1_CPOL 0x100
#define BSPI2_CSR1_CPOL_BIT 8
#define BSPI2_CSR1_CPHA_MASK 0x200
#define BSPI2_CSR1_CPHA 0x200
#define BSPI2_CSR1_CPHA_BIT 9
#define BSPI2_CSR1_WL_MASK 0xC00
#define BSPI2_CSR1_WL_BIT 10
#define BSPI2_CSR1_RFE_MASK 0xF000
#define BSPI2_CSR1_RFE_BIT 12

#define BSPI2_CSR2 (*(volatile unsigned short *)0xFFFFE00C)
#define BSPI2_CSR2_DFIFO_MASK 0x1
#define BSPI2_CSR2_DFIFO 0x1
#define BSPI2_CSR2_DFIFO_BIT 0
#define BSPI2_CSR2_BERR_MASK 0x4
#define BSPI2_CSR2_BERR 0x4
#define BSPI2_CSR2_BERR_BIT 2
#define BSPI2_CSR2_RFNE_MASK 0x8
#define BSPI2_CSR2_RFNE 0x8
#define BSPI2_CSR2_RFNE_BIT 3
#define BSPI2_CSR2_RFF_MASK 0x10
#define BSPI2_CSR2_RFF 0x10
#define BSPI2_CSR2_RFF_BIT 4
#define BSPI2_CSR2_ROFL_MASK 0x20
#define BSPI2_CSR2_ROFL 0x20
#define BSPI2_CSR2_ROFL_BIT 5
#define BSPI2_CSR2_TFE_MASK 0x40
#define BSPI2_CSR2_TFE 0x40
#define BSPI2_CSR2_TFE_BIT 6
#define BSPI2_CSR2_TUFL_MASK 0x80
#define BSPI2_CSR2_TUFL 0x80
#define BSPI2_CSR2_TUFL_BIT 7
#define BSPI2_CSR2_TFF_MASK 0x100
#define BSPI2_CSR2_TFF 0x100
#define BSPI2_CSR2_TFF_BIT 8
#define BSPI2_CSR2_TFNE_MASK 0x200
#define BSPI2_CSR2_TFNE 0x200
#define BSPI2_CSR2_TFNE_BIT 9
#define BSPI2_CSR2_TFE_MASK 0x3C00
#define BSPI2_CSR2_TFE_BIT 10
#define BSPI2_CSR2_TIE_MASK 0xC000
#define BSPI2_CSR2_TIE_BIT 14

#define BSPI2_CLK (*(volatile unsigned short *)0xFFFFE010)

#define BSPI2_CSR3 (*(volatile unsigned short *)0xFFFFE014)
#define BSPI2_CSR3_MASK_SS_MASK 0x1
#define BSPI2_CSR3_MASK_SS 0x1
#define BSPI2_CSR3_MASK_SS_BIT 0
#define BSPI2_CSR3_DMA_EN_MASK 0x2
#define BSPI2_CSR3_DMA_EN 0x2
#define BSPI2_CSR3_DMA_EN_BIT 1
#define BSPI2_CSR3_TBURST_LEN_MASK 0xC
#define BSPI2_CSR3_TBURST_LEN_BIT 2
#define BSPI2_CSR3_RBURST_LEN_MASK 0x30
#define BSPI2_CSR3_RBURST_LEN_BIT 4
#define BSPI2_CSR3_TREQ_EN_MASK 0x40
#define BSPI2_CSR3_TREQ_EN 0x40
#define BSPI2_CSR3_TREQ_EN_BIT 6
#define BSPI2_CSR3_RREQ_EN_MASK 0x80
#define BSPI2_CSR3_RREQ_EN 0x80
#define BSPI2_CSR3_RREQ_EN_BIT 7

#define TIM2_ICAR (*(volatile unsigned short *)0xFFFFE400)

#define TIM2_ICBR (*(volatile unsigned short *)0xFFFFE404)

#define TIM2_OCAR (*(volatile unsigned short *)0xFFFFE408)

#define TIM2_OCBR (*(volatile unsigned short *)0xFFFFE40C)

#define TIM2_CNTR (*(volatile unsigned short *)0xFFFFE410)

#define TIM2_CR1 (*(volatile unsigned short *)0xFFFFE414)
#define TIM2_CR1_ECKEN_MASK 0x1
#define TIM2_CR1_ECKEN 0x1
#define TIM2_CR1_ECKEN_BIT 0
#define TIM2_CR1_EXEDG_MASK 0x2
#define TIM2_CR1_EXEDG 0x2
#define TIM2_CR1_EXEDG_BIT 1
#define TIM2_CR1_IEDGA_MASK 0x4
#define TIM2_CR1_IEDGA 0x4
#define TIM2_CR1_IEDGA_BIT 2
#define TIM2_CR1_IEDGB_MASK 0x8
#define TIM2_CR1_IEDGB 0x8
#define TIM2_CR1_IEDGB_BIT 3
#define TIM2_CR1_PWM_MASK 0x10
#define TIM2_CR1_PWM 0x10
#define TIM2_CR1_PWM_BIT 4
#define TIM2_CR1_OPM_MASK 0x20
#define TIM2_CR1_OPM 0x20
#define TIM2_CR1_OPM_BIT 5
#define TIM2_CR1_OCAE_MASK 0x40
#define TIM2_CR1_OCAE 0x40
#define TIM2_CR1_OCAE_BIT 6
#define TIM2_CR1_OCBE_MASK 0x80
#define TIM2_CR1_OCBE 0x80
#define TIM2_CR1_OCBE_BIT 7
#define TIM2_CR1_OLVLA_MASK 0x100
#define TIM2_CR1_OLVLA 0x100
#define TIM2_CR1_OLVLA_BIT 8
#define TIM2_CR1_OLVLB_MASK 0x200
#define TIM2_CR1_OLVLB 0x200
#define TIM2_CR1_OLVLB_BIT 9
#define TIM2_CR1_FOLVLA_MASK 0x400
#define TIM2_CR1_FOLVLA 0x400
#define TIM2_CR1_FOLVLA_BIT 10
#define TIM2_CR1_FOLVLB_MASK 0x800
#define TIM2_CR1_FOLVLB 0x800
#define TIM2_CR1_FOLVLB_BIT 11
#define TIM2_CR1_DMAS0_MASK 0x1000
#define TIM2_CR1_DMAS0 0x1000
#define TIM2_CR1_DMAS0_BIT 12
#define TIM2_CR1_DMAS1_MASK 0x2000
#define TIM2_CR1_DMAS1 0x2000
#define TIM2_CR1_DMAS1_BIT 13
#define TIM2_CR1_PWMI_MASK 0x4000
#define TIM2_CR1_PWMI 0x4000
#define TIM2_CR1_PWMI_BIT 14
#define TIM2_CR1_EN_MASK 0x8000
#define TIM2_CR1_EN 0x8000
#define TIM2_CR1_EN_BIT 15

#define TIM2_CR2 (*(volatile unsigned short *)0xFFFFE418)
#define TIM2_CR2_CC0_MASK 0x1
#define TIM2_CR2_CC0 0x1
#define TIM2_CR2_CC0_BIT 0
#define TIM2_CR2_CC1_MASK 0x2
#define TIM2_CR2_CC1 0x2
#define TIM2_CR2_CC1_BIT 1
#define TIM2_CR2_CC2_MASK 0x4
#define TIM2_CR2_CC2 0x4
#define TIM2_CR2_CC2_BIT 2
#define TIM2_CR2_CC3_MASK 0x8
#define TIM2_CR2_CC3 0x8
#define TIM2_CR2_CC3_BIT 3
#define TIM2_CR2_CC4_MASK 0x10
#define TIM2_CR2_CC4 0x10
#define TIM2_CR2_CC4_BIT 4
#define TIM2_CR2_CC5_MASK 0x20
#define TIM2_CR2_CC5 0x20
#define TIM2_CR2_CC5_BIT 5
#define TIM2_CR2_CC6_MASK 0x40
#define TIM2_CR2_CC6 0x40
#define TIM2_CR2_CC6_BIT 6
#define TIM2_CR2_CC7_MASK 0x80
#define TIM2_CR2_CC7 0x80
#define TIM2_CR2_CC7_BIT 7
#define TIM2_CR2_DMAIE_MASK 0x400
#define TIM2_CR2_DMAIE 0x400
#define TIM2_CR2_DMAIE_BIT 10
#define TIM2_CR2_OCBIE_MASK 0x800
#define TIM2_CR2_OCBIE 0x800
#define TIM2_CR2_OCBIE_BIT 11
#define TIM2_CR2_ICBIE_MASK 0x1000
#define TIM2_CR2_ICBIE 0x1000
#define TIM2_CR2_ICBIE_BIT 12
#define TIM2_CR2_TOE_MASK 0x2000
#define TIM2_CR2_TOE 0x2000
#define TIM2_CR2_TOE_BIT 13
#define TIM2_CR2_OCAIE_MASK 0x4000
#define TIM2_CR2_OCAIE 0x4000
#define TIM2_CR2_OCAIE_BIT 14
#define TIM2_CR2_ICAIE_MASK 0x8000
#define TIM2_CR2_ICAIE 0x8000
#define TIM2_CR2_ICAIE_BIT 15

#define TIM2_SR (*(volatile unsigned short *)0xFFFFE41C)
#define TIM2_SR_OCFB_MASK 0x800
#define TIM2_SR_OCFB 0x800
#define TIM2_SR_OCFB_BIT 11
#define TIM2_SR_ICFB_MASK 0x1000
#define TIM2_SR_ICFB 0x1000
#define TIM2_SR_ICFB_BIT 12
#define TIM2_SR_TOF_MASK 0x2000
#define TIM2_SR_TOF 0x2000
#define TIM2_SR_TOF_BIT 13
#define TIM2_SR_OCFA_MASK 0x4000
#define TIM2_SR_OCFA 0x4000
#define TIM2_SR_OCFA_BIT 14
#define TIM2_SR_ICFA_MASK 0x8000
#define TIM2_SR_ICFA 0x8000
#define TIM2_SR_ICFA_BIT 15

#define TIM3_ICAR (*(volatile unsigned short *)0xFFFFE800)

#define TIM3_ICBR (*(volatile unsigned short *)0xFFFFE804)

#define TIM3_OCAR (*(volatile unsigned short *)0xFFFFE808)

#define TIM3_OCBR (*(volatile unsigned short *)0xFFFFE80C)

#define TIM3_CNTR (*(volatile unsigned short *)0xFFFFE810)

#define TIM3_CR1 (*(volatile unsigned short *)0xFFFFE814)
#define TIM3_CR1_ECKEN_MASK 0x1
#define TIM3_CR1_ECKEN 0x1
#define TIM3_CR1_ECKEN_BIT 0
#define TIM3_CR1_EXEDG_MASK 0x2
#define TIM3_CR1_EXEDG 0x2
#define TIM3_CR1_EXEDG_BIT 1
#define TIM3_CR1_IEDGA_MASK 0x4
#define TIM3_CR1_IEDGA 0x4
#define TIM3_CR1_IEDGA_BIT 2
#define TIM3_CR1_IEDGB_MASK 0x8
#define TIM3_CR1_IEDGB 0x8
#define TIM3_CR1_IEDGB_BIT 3
#define TIM3_CR1_PWM_MASK 0x10
#define TIM3_CR1_PWM 0x10
#define TIM3_CR1_PWM_BIT 4
#define TIM3_CR1_OPM_MASK 0x20
#define TIM3_CR1_OPM 0x20
#define TIM3_CR1_OPM_BIT 5
#define TIM3_CR1_OCAE_MASK 0x40
#define TIM3_CR1_OCAE 0x40
#define TIM3_CR1_OCAE_BIT 6
#define TIM3_CR1_OCBE_MASK 0x80
#define TIM3_CR1_OCBE 0x80
#define TIM3_CR1_OCBE_BIT 7
#define TIM3_CR1_OLVLA_MASK 0x100
#define TIM3_CR1_OLVLA 0x100
#define TIM3_CR1_OLVLA_BIT 8
#define TIM3_CR1_OLVLB_MASK 0x200
#define TIM3_CR1_OLVLB 0x200
#define TIM3_CR1_OLVLB_BIT 9
#define TIM3_CR1_FOLVLA_MASK 0x400
#define TIM3_CR1_FOLVLA 0x400
#define TIM3_CR1_FOLVLA_BIT 10
#define TIM3_CR1_FOLVLB_MASK 0x800
#define TIM3_CR1_FOLVLB 0x800
#define TIM3_CR1_FOLVLB_BIT 11
#define TIM3_CR1_DMAS0_MASK 0x1000
#define TIM3_CR1_DMAS0 0x1000
#define TIM3_CR1_DMAS0_BIT 12
#define TIM3_CR1_DMAS1_MASK 0x2000
#define TIM3_CR1_DMAS1 0x2000
#define TIM3_CR1_DMAS1_BIT 13
#define TIM3_CR1_PWMI_MASK 0x4000
#define TIM3_CR1_PWMI 0x4000
#define TIM3_CR1_PWMI_BIT 14
#define TIM3_CR1_EN_MASK 0x8000
#define TIM3_CR1_EN 0x8000
#define TIM3_CR1_EN_BIT 15

#define TIM3_CR2 (*(volatile unsigned short *)0xFFFFE818)
#define TIM3_CR2_CC0_MASK 0x1
#define TIM3_CR2_CC0 0x1
#define TIM3_CR2_CC0_BIT 0
#define TIM3_CR2_CC1_MASK 0x2
#define TIM3_CR2_CC1 0x2
#define TIM3_CR2_CC1_BIT 1
#define TIM3_CR2_CC2_MASK 0x4
#define TIM3_CR2_CC2 0x4
#define TIM3_CR2_CC2_BIT 2
#define TIM3_CR2_CC3_MASK 0x8
#define TIM3_CR2_CC3 0x8
#define TIM3_CR2_CC3_BIT 3
#define TIM3_CR2_CC4_MASK 0x10
#define TIM3_CR2_CC4 0x10
#define TIM3_CR2_CC4_BIT 4
#define TIM3_CR2_CC5_MASK 0x20
#define TIM3_CR2_CC5 0x20
#define TIM3_CR2_CC5_BIT 5
#define TIM3_CR2_CC6_MASK 0x40
#define TIM3_CR2_CC6 0x40
#define TIM3_CR2_CC6_BIT 6
#define TIM3_CR2_CC7_MASK 0x80
#define TIM3_CR2_CC7 0x80
#define TIM3_CR2_CC7_BIT 7
#define TIM3_CR2_DMAIE_MASK 0x400
#define TIM3_CR2_DMAIE 0x400
#define TIM3_CR2_DMAIE_BIT 10
#define TIM3_CR2_OCBIE_MASK 0x800
#define TIM3_CR2_OCBIE 0x800
#define TIM3_CR2_OCBIE_BIT 11
#define TIM3_CR2_ICBIE_MASK 0x1000
#define TIM3_CR2_ICBIE 0x1000
#define TIM3_CR2_ICBIE_BIT 12
#define TIM3_CR2_TOE_MASK 0x2000
#define TIM3_CR2_TOE 0x2000
#define TIM3_CR2_TOE_BIT 13
#define TIM3_CR2_OCAIE_MASK 0x4000
#define TIM3_CR2_OCAIE 0x4000
#define TIM3_CR2_OCAIE_BIT 14
#define TIM3_CR2_ICAIE_MASK 0x8000
#define TIM3_CR2_ICAIE 0x8000
#define TIM3_CR2_ICAIE_BIT 15

#define TIM3_SR (*(volatile unsigned short *)0xFFFFE81C)
#define TIM3_SR_OCFB_MASK 0x800
#define TIM3_SR_OCFB 0x800
#define TIM3_SR_OCFB_BIT 11
#define TIM3_SR_ICFB_MASK 0x1000
#define TIM3_SR_ICFB 0x1000
#define TIM3_SR_ICFB_BIT 12
#define TIM3_SR_TOF_MASK 0x2000
#define TIM3_SR_TOF 0x2000
#define TIM3_SR_TOF_BIT 13
#define TIM3_SR_OCFA_MASK 0x4000
#define TIM3_SR_OCFA 0x4000
#define TIM3_SR_OCFA_BIT 14
#define TIM3_SR_ICFA_MASK 0x8000
#define TIM3_SR_ICFA 0x8000
#define TIM3_SR_ICFA_BIT 15

#define TIM4_ICAR (*(volatile unsigned short *)0xFFFFEC00)

#define TIM4_ICBR (*(volatile unsigned short *)0xFFFFEC04)

#define TIM4_OCAR (*(volatile unsigned short *)0xFFFFEC08)

#define TIM4_OCBR (*(volatile unsigned short *)0xFFFFEC0C)

#define TIM4_CNTR (*(volatile unsigned short *)0xFFFFEC10)

#define TIM4_CR1 (*(volatile unsigned short *)0xFFFFEC14)
#define TIM4_CR1_ECKEN_MASK 0x1
#define TIM4_CR1_ECKEN 0x1
#define TIM4_CR1_ECKEN_BIT 0
#define TIM4_CR1_EXEDG_MASK 0x2
#define TIM4_CR1_EXEDG 0x2
#define TIM4_CR1_EXEDG_BIT 1
#define TIM4_CR1_IEDGA_MASK 0x4
#define TIM4_CR1_IEDGA 0x4
#define TIM4_CR1_IEDGA_BIT 2
#define TIM4_CR1_IEDGB_MASK 0x8
#define TIM4_CR1_IEDGB 0x8
#define TIM4_CR1_IEDGB_BIT 3
#define TIM4_CR1_PWM_MASK 0x10
#define TIM4_CR1_PWM 0x10
#define TIM4_CR1_PWM_BIT 4
#define TIM4_CR1_OPM_MASK 0x20
#define TIM4_CR1_OPM 0x20
#define TIM4_CR1_OPM_BIT 5
#define TIM4_CR1_OCAE_MASK 0x40
#define TIM4_CR1_OCAE 0x40
#define TIM4_CR1_OCAE_BIT 6
#define TIM4_CR1_OCBE_MASK 0x80
#define TIM4_CR1_OCBE 0x80
#define TIM4_CR1_OCBE_BIT 7
#define TIM4_CR1_OLVLA_MASK 0x100
#define TIM4_CR1_OLVLA 0x100
#define TIM4_CR1_OLVLA_BIT 8
#define TIM4_CR1_OLVLB_MASK 0x200
#define TIM4_CR1_OLVLB 0x200
#define TIM4_CR1_OLVLB_BIT 9
#define TIM4_CR1_FOLVLA_MASK 0x400
#define TIM4_CR1_FOLVLA 0x400
#define TIM4_CR1_FOLVLA_BIT 10
#define TIM4_CR1_FOLVLB_MASK 0x800
#define TIM4_CR1_FOLVLB 0x800
#define TIM4_CR1_FOLVLB_BIT 11
#define TIM4_CR1_DMAS0_MASK 0x1000
#define TIM4_CR1_DMAS0 0x1000
#define TIM4_CR1_DMAS0_BIT 12
#define TIM4_CR1_DMAS1_MASK 0x2000
#define TIM4_CR1_DMAS1 0x2000
#define TIM4_CR1_DMAS1_BIT 13
#define TIM4_CR1_PWMI_MASK 0x4000
#define TIM4_CR1_PWMI 0x4000
#define TIM4_CR1_PWMI_BIT 14
#define TIM4_CR1_EN_MASK 0x8000
#define TIM4_CR1_EN 0x8000
#define TIM4_CR1_EN_BIT 15

#define TIM4_CR2 (*(volatile unsigned short *)0xFFFFEC18)
#define TIM4_CR2_CC0_MASK 0x1
#define TIM4_CR2_CC0 0x1
#define TIM4_CR2_CC0_BIT 0
#define TIM4_CR2_CC1_MASK 0x2
#define TIM4_CR2_CC1 0x2
#define TIM4_CR2_CC1_BIT 1
#define TIM4_CR2_CC2_MASK 0x4
#define TIM4_CR2_CC2 0x4
#define TIM4_CR2_CC2_BIT 2
#define TIM4_CR2_CC3_MASK 0x8
#define TIM4_CR2_CC3 0x8
#define TIM4_CR2_CC3_BIT 3
#define TIM4_CR2_CC4_MASK 0x10
#define TIM4_CR2_CC4 0x10
#define TIM4_CR2_CC4_BIT 4
#define TIM4_CR2_CC5_MASK 0x20
#define TIM4_CR2_CC5 0x20
#define TIM4_CR2_CC5_BIT 5
#define TIM4_CR2_CC6_MASK 0x40
#define TIM4_CR2_CC6 0x40
#define TIM4_CR2_CC6_BIT 6
#define TIM4_CR2_CC7_MASK 0x80
#define TIM4_CR2_CC7 0x80
#define TIM4_CR2_CC7_BIT 7
#define TIM4_CR2_DMAIE_MASK 0x400
#define TIM4_CR2_DMAIE 0x400
#define TIM4_CR2_DMAIE_BIT 10
#define TIM4_CR2_OCBIE_MASK 0x800
#define TIM4_CR2_OCBIE 0x800
#define TIM4_CR2_OCBIE_BIT 11
#define TIM4_CR2_ICBIE_MASK 0x1000
#define TIM4_CR2_ICBIE 0x1000
#define TIM4_CR2_ICBIE_BIT 12
#define TIM4_CR2_TOE_MASK 0x2000
#define TIM4_CR2_TOE 0x2000
#define TIM4_CR2_TOE_BIT 13
#define TIM4_CR2_OCAIE_MASK 0x4000
#define TIM4_CR2_OCAIE 0x4000
#define TIM4_CR2_OCAIE_BIT 14
#define TIM4_CR2_ICAIE_MASK 0x8000
#define TIM4_CR2_ICAIE 0x8000
#define TIM4_CR2_ICAIE_BIT 15

#define TIM4_SR (*(volatile unsigned short *)0xFFFFEC1C)
#define TIM4_SR_OCFB_MASK 0x800
#define TIM4_SR_OCFB 0x800
#define TIM4_SR_OCFB_BIT 11
#define TIM4_SR_ICFB_MASK 0x1000
#define TIM4_SR_ICFB 0x1000
#define TIM4_SR_ICFB_BIT 12
#define TIM4_SR_TOF_MASK 0x2000
#define TIM4_SR_TOF 0x2000
#define TIM4_SR_TOF_BIT 13
#define TIM4_SR_OCFA_MASK 0x4000
#define TIM4_SR_OCFA 0x4000
#define TIM4_SR_OCFA_BIT 14
#define TIM4_SR_ICFA_MASK 0x8000
#define TIM4_SR_ICFA 0x8000
#define TIM4_SR_ICFA_BIT 15

#define DMA0_SOURCEL0 (*(volatile unsigned short *)0xFFFFF000)

#define DMA0_SOURCEH0 (*(volatile unsigned short *)0xFFFFF004)

#define DMA0_DESTL0 (*(volatile unsigned short *)0xFFFFF008)

#define DMA0_DESTH0 (*(volatile unsigned short *)0xFFFFF00C)

#define DMA0_MAX0 (*(volatile unsigned short *)0xFFFFF010)

#define DMA0_CTRL0 (*(volatile unsigned short *)0xFFFFF014)
#define DMA0_CTRL0_Enable_MASK 0x1
#define DMA0_CTRL0_Enable 0x1
#define DMA0_CTRL0_Enable_BIT 0
#define DMA0_CTRL0_Solnc_MASK 0x2
#define DMA0_CTRL0_Solnc 0x2
#define DMA0_CTRL0_Solnc_BIT 1
#define DMA0_CTRL0_Delnc_MASK 0x4
#define DMA0_CTRL0_Delnc 0x4
#define DMA0_CTRL0_Delnc_BIT 2
#define DMA0_CTRL0_SoSize_MASK 0x18
#define DMA0_CTRL0_SoSize_BIT 3
#define DMA0_CTRL0_SoBurst_MASK 0x60
#define DMA0_CTRL0_SoBurst_BIT 5
#define DMA0_CTRL0_DeSize_MASK 0x180
#define DMA0_CTRL0_DeSize_BIT 7
#define DMA0_CTRL0_Circular_MASK 0x200
#define DMA0_CTRL0_Circular 0x200
#define DMA0_CTRL0_Circular_BIT 9
#define DMA0_CTRL0_Dir_MASK 0x2000
#define DMA0_CTRL0_Dir 0x2000
#define DMA0_CTRL0_Dir_BIT 13

#define DMA0_SOCURRH0 (*(volatile unsigned short *)0xFFFFF018)

#define DMA0_SOCURRL0 (*(volatile unsigned short *)0xFFFFF01C)

#define DMA0_DECURRH0 (*(volatile unsigned short *)0xFFFFF020)

#define DMA0_DECURRL0 (*(volatile unsigned short *)0xFFFFF024)

#define DMA0_TCNT0 (*(volatile unsigned short *)0xFFFFF028)

#define DMA0_LUBUFF0 (*(volatile unsigned short *)0xFFFFF02C)

#define DMA0_SOURCEL1 (*(volatile unsigned short *)0xFFFFF040)

#define DMA0_SOURCEH1 (*(volatile unsigned short *)0xFFFFF044)

#define DMA0_DESTL1 (*(volatile unsigned short *)0xFFFFF048)

#define DMA0_DESTH1 (*(volatile unsigned short *)0xFFFFF04C)

#define DMA0_MAX1 (*(volatile unsigned short *)0xFFFFF050)

#define DMA0_CTRL1 (*(volatile unsigned short *)0xFFFFF054)
#define DMA0_CTRL1_Enable_MASK 0x1
#define DMA0_CTRL1_Enable 0x1
#define DMA0_CTRL1_Enable_BIT 0
#define DMA0_CTRL1_Solnc_MASK 0x2
#define DMA0_CTRL1_Solnc 0x2
#define DMA0_CTRL1_Solnc_BIT 1
#define DMA0_CTRL1_Delnc_MASK 0x4
#define DMA0_CTRL1_Delnc 0x4
#define DMA0_CTRL1_Delnc_BIT 2
#define DMA0_CTRL1_SoSize_MASK 0x18
#define DMA0_CTRL1_SoSize_BIT 3
#define DMA0_CTRL1_SoBurst_MASK 0x60
#define DMA0_CTRL1_SoBurst_BIT 5
#define DMA0_CTRL1_DeSize_MASK 0x180
#define DMA0_CTRL1_DeSize_BIT 7
#define DMA0_CTRL1_Circular_MASK 0x200
#define DMA0_CTRL1_Circular 0x200
#define DMA0_CTRL1_Circular_BIT 9
#define DMA0_CTRL1_Dir_MASK 0x2000
#define DMA0_CTRL1_Dir 0x2000
#define DMA0_CTRL1_Dir_BIT 13

#define DMA0_SOCURRH1 (*(volatile unsigned short *)0xFFFFF058)

#define DMA0_SOCURRL1 (*(volatile unsigned short *)0xFFFFF05C)

#define DMA0_DECURRH1 (*(volatile unsigned short *)0xFFFFF060)

#define DMA0_DECURRL1 (*(volatile unsigned short *)0xFFFFF064)

#define DMA0_TCNT1 (*(volatile unsigned short *)0xFFFFF068)

#define DMA0_LUBUFF1 (*(volatile unsigned short *)0xFFFFF06C)

#define DMA0_SOURCEL2 (*(volatile unsigned short *)0xFFFFF080)

#define DMA0_SOURCEH2 (*(volatile unsigned short *)0xFFFFF084)

#define DMA0_DESTL2 (*(volatile unsigned short *)0xFFFFF088)

#define DMA0_DESTH2 (*(volatile unsigned short *)0xFFFFF08C)

#define DMA0_MAX2 (*(volatile unsigned short *)0xFFFFF090)

#define DMA0_CTRL2 (*(volatile unsigned short *)0xFFFFF094)
#define DMA0_CTRL2_Enable_MASK 0x1
#define DMA0_CTRL2_Enable 0x1
#define DMA0_CTRL2_Enable_BIT 0
#define DMA0_CTRL2_Solnc_MASK 0x2
#define DMA0_CTRL2_Solnc 0x2
#define DMA0_CTRL2_Solnc_BIT 1
#define DMA0_CTRL2_Delnc_MASK 0x4
#define DMA0_CTRL2_Delnc 0x4
#define DMA0_CTRL2_Delnc_BIT 2
#define DMA0_CTRL2_SoSize_MASK 0x18
#define DMA0_CTRL2_SoSize_BIT 3
#define DMA0_CTRL2_SoBurst_MASK 0x60
#define DMA0_CTRL2_SoBurst_BIT 5
#define DMA0_CTRL2_DeSize_MASK 0x180
#define DMA0_CTRL2_DeSize_BIT 7
#define DMA0_CTRL2_Circular_MASK 0x200
#define DMA0_CTRL2_Circular 0x200
#define DMA0_CTRL2_Circular_BIT 9
#define DMA0_CTRL2_Dir_MASK 0x2000
#define DMA0_CTRL2_Dir 0x2000
#define DMA0_CTRL2_Dir_BIT 13

#define DMA0_SOCURRH2 (*(volatile unsigned short *)0xFFFFF098)

#define DMA0_SOCURRL2 (*(volatile unsigned short *)0xFFFFF09C)

#define DMA0_DECURRH2 (*(volatile unsigned short *)0xFFFFF0A0)

#define DMA0_DECURRL2 (*(volatile unsigned short *)0xFFFFF0A4)

#define DMA0_TCNT2 (*(volatile unsigned short *)0xFFFFF0A8)

#define DMA0_LUBUFF2 (*(volatile unsigned short *)0xFFFFF0AC)

#define DMA0_SOURCEL3 (*(volatile unsigned short *)0xFFFFF0C0)

#define DMA0_SOURCEH3 (*(volatile unsigned short *)0xFFFFF0C4)

#define DMA0_DESTL3 (*(volatile unsigned short *)0xFFFFF0C8)

#define DMA0_DESTH3 (*(volatile unsigned short *)0xFFFFF0CC)

#define DMA0_MAX3 (*(volatile unsigned short *)0xFFFFF0D0)

#define DMA0_CTRL3 (*(volatile unsigned short *)0xFFFFF0D4)
#define DMA0_CTRL3_Enable_MASK 0x1
#define DMA0_CTRL3_Enable 0x1
#define DMA0_CTRL3_Enable_BIT 0
#define DMA0_CTRL3_Solnc_MASK 0x2
#define DMA0_CTRL3_Solnc 0x2
#define DMA0_CTRL3_Solnc_BIT 1
#define DMA0_CTRL3_Delnc_MASK 0x4
#define DMA0_CTRL3_Delnc 0x4
#define DMA0_CTRL3_Delnc_BIT 2
#define DMA0_CTRL3_SoSize_MASK 0x18
#define DMA0_CTRL3_SoSize_BIT 3
#define DMA0_CTRL3_SoBurst_MASK 0x60
#define DMA0_CTRL3_SoBurst_BIT 5
#define DMA0_CTRL3_DeSize_MASK 0x180
#define DMA0_CTRL3_DeSize_BIT 7
#define DMA0_CTRL3_Circular_MASK 0x200
#define DMA0_CTRL3_Circular 0x200
#define DMA0_CTRL3_Circular_BIT 9
#define DMA0_CTRL3_Dir_MASK 0x2000
#define DMA0_CTRL3_Dir 0x2000
#define DMA0_CTRL3_Dir_BIT 13

#define DMA0_SOCURRH3 (*(volatile unsigned short *)0xFFFFF0D8)

#define DMA0_SOCURRL3 (*(volatile unsigned short *)0xFFFFF0DC)

#define DMA0_DECURRH3 (*(volatile unsigned short *)0xFFFFF0E0)

#define DMA0_DECURRL3 (*(volatile unsigned short *)0xFFFFF0E4)

#define DMA0_TCNT3 (*(volatile unsigned short *)0xFFFFF0E8)

#define DMA0_LUBUFF3 (*(volatile unsigned short *)0xFFFFF0EC)

#define DMA0_MASK (*(volatile unsigned short *)0xFFFFF0F0)
#define DMA0_MASK_SIM0_MASK 0x1
#define DMA0_MASK_SIM0 0x1
#define DMA0_MASK_SIM0_BIT 0
#define DMA0_MASK_SIM1_MASK 0x2
#define DMA0_MASK_SIM1 0x2
#define DMA0_MASK_SIM1_BIT 1
#define DMA0_MASK_SIM2_MASK 0x4
#define DMA0_MASK_SIM2 0x4
#define DMA0_MASK_SIM2_BIT 2
#define DMA0_MASK_SIM3_MASK 0x8
#define DMA0_MASK_SIM3 0x8
#define DMA0_MASK_SIM3_BIT 3
#define DMA0_MASK_SEM0_MASK 0x10
#define DMA0_MASK_SEM0 0x10
#define DMA0_MASK_SEM0_BIT 4
#define DMA0_MASK_SEM1_MASK 0x20
#define DMA0_MASK_SEM1 0x20
#define DMA0_MASK_SEM1_BIT 5
#define DMA0_MASK_SEM2_MASK 0x40
#define DMA0_MASK_SEM2 0x40
#define DMA0_MASK_SEM2_BIT 6
#define DMA0_MASK_SEM3_MASK 0x80
#define DMA0_MASK_SEM3 0x80
#define DMA0_MASK_SEM3_BIT 7

#define DMA0_CLR (*(volatile unsigned short *)0xFFFFF0F4)
#define DMA0_CLR_SIC0_MASK 0x1
#define DMA0_CLR_SIC0 0x1
#define DMA0_CLR_SIC0_BIT 0
#define DMA0_CLR_SIC1_MASK 0x2
#define DMA0_CLR_SIC1 0x2
#define DMA0_CLR_SIC1_BIT 1
#define DMA0_CLR_SIC2_MASK 0x4
#define DMA0_CLR_SIC2 0x4
#define DMA0_CLR_SIC2_BIT 2
#define DMA0_CLR_SIC3_MASK 0x8
#define DMA0_CLR_SIC3 0x8
#define DMA0_CLR_SIC3_BIT 3
#define DMA0_CLR_SEC0_MASK 0x10
#define DMA0_CLR_SEC0 0x10
#define DMA0_CLR_SEC0_BIT 4
#define DMA0_CLR_SEC1_MASK 0x20
#define DMA0_CLR_SEC1 0x20
#define DMA0_CLR_SEC1_BIT 5
#define DMA0_CLR_SEC2_MASK 0x40
#define DMA0_CLR_SEC2 0x40
#define DMA0_CLR_SEC2_BIT 6
#define DMA0_CLR_SEC3_MASK 0x80
#define DMA0_CLR_SEC3 0x80
#define DMA0_CLR_SEC3_BIT 7

#define DMA0_STATUS (*(volatile unsigned short *)0xFFFFF0F8)
#define DMA0_STATUS_INT0_MASK 0x1
#define DMA0_STATUS_INT0 0x1
#define DMA0_STATUS_INT0_BIT 0
#define DMA0_STATUS_INT1_MASK 0x2
#define DMA0_STATUS_INT1 0x2
#define DMA0_STATUS_INT1_BIT 1
#define DMA0_STATUS_INT2_MASK 0x4
#define DMA0_STATUS_INT2 0x4
#define DMA0_STATUS_INT2_BIT 2
#define DMA0_STATUS_INT3_MASK 0x8
#define DMA0_STATUS_INT3 0x8
#define DMA0_STATUS_INT3_BIT 3
#define DMA0_STATUS_ERR0_MASK 0x10
#define DMA0_STATUS_ERR0 0x10
#define DMA0_STATUS_ERR0_BIT 4
#define DMA0_STATUS_ERR1_MASK 0x20
#define DMA0_STATUS_ERR1 0x20
#define DMA0_STATUS_ERR1_BIT 5
#define DMA0_STATUS_ERR2_MASK 0x40
#define DMA0_STATUS_ERR2 0x40
#define DMA0_STATUS_ERR2_BIT 6
#define DMA0_STATUS_ERR3_MASK 0x80
#define DMA0_STATUS_ERR3 0x80
#define DMA0_STATUS_ERR3_BIT 7
#define DMA0_STATUS_ACT0_MASK 0x100
#define DMA0_STATUS_ACT0 0x100
#define DMA0_STATUS_ACT0_BIT 8
#define DMA0_STATUS_ACT1_MASK 0x200
#define DMA0_STATUS_ACT1 0x200
#define DMA0_STATUS_ACT1_BIT 9
#define DMA0_STATUS_ACT2_MASK 0x400
#define DMA0_STATUS_ACT2 0x400
#define DMA0_STATUS_ACT2_BIT 10
#define DMA0_STATUS_ACT3_MASK 0x800
#define DMA0_STATUS_ACT3 0x800
#define DMA0_STATUS_ACT3_BIT 11

#define DMA0_LAST (*(volatile unsigned short *)0xFFFFF0FC)
#define DMA0_LAST_LAST0_MASK 0x1
#define DMA0_LAST_LAST0 0x1
#define DMA0_LAST_LAST0_BIT 0
#define DMA0_LAST_LAST1_MASK 0x2
#define DMA0_LAST_LAST1 0x2
#define DMA0_LAST_LAST1_BIT 1
#define DMA0_LAST_LAST2_MASK 0x4
#define DMA0_LAST_LAST2 0x4
#define DMA0_LAST_LAST2_BIT 2
#define DMA0_LAST_LAST3_MASK 0x8
#define DMA0_LAST_LAST3 0x8
#define DMA0_LAST_LAST3_BIT 3

#define DMA1_SOURCEL0 (*(volatile unsigned short *)0xFFFFF100)

#define DMA1_SOURCEH0 (*(volatile unsigned short *)0xFFFFF104)

#define DMA1_DESTL0 (*(volatile unsigned short *)0xFFFFF108)

#define DMA1_DESTH0 (*(volatile unsigned short *)0xFFFFF10C)

#define DMA1_MAX0 (*(volatile unsigned short *)0xFFFFF110)

#define DMA1_CTRL0 (*(volatile unsigned short *)0xFFFFF114)
#define DMA1_CTRL0_Enable_MASK 0x1
#define DMA1_CTRL0_Enable 0x1
#define DMA1_CTRL0_Enable_BIT 0
#define DMA1_CTRL0_Solnc_MASK 0x2
#define DMA1_CTRL0_Solnc 0x2
#define DMA1_CTRL0_Solnc_BIT 1
#define DMA1_CTRL0_Delnc_MASK 0x4
#define DMA1_CTRL0_Delnc 0x4
#define DMA1_CTRL0_Delnc_BIT 2
#define DMA1_CTRL0_SoSize_MASK 0x18
#define DMA1_CTRL0_SoSize_BIT 3
#define DMA1_CTRL0_SoBurst_MASK 0x60
#define DMA1_CTRL0_SoBurst_BIT 5
#define DMA1_CTRL0_DeSize_MASK 0x180
#define DMA1_CTRL0_DeSize_BIT 7
#define DMA1_CTRL0_Circular_MASK 0x200
#define DMA1_CTRL0_Circular 0x200
#define DMA1_CTRL0_Circular_BIT 9
#define DMA1_CTRL0_Dir_MASK 0x2000
#define DMA1_CTRL0_Dir 0x2000
#define DMA1_CTRL0_Dir_BIT 13

#define DMA1_SOCURRH0 (*(volatile unsigned short *)0xFFFFF118)

#define DMA1_SOCURRL0 (*(volatile unsigned short *)0xFFFFF11C)

#define DMA1_DECURRH0 (*(volatile unsigned short *)0xFFFFF120)

#define DMA1_DECURRL0 (*(volatile unsigned short *)0xFFFFF124)

#define DMA1_TCNT0 (*(volatile unsigned short *)0xFFFFF128)

#define DMA1_LUBUFF0 (*(volatile unsigned short *)0xFFFFF12C)

#define DMA1_SOURCEL1 (*(volatile unsigned short *)0xFFFFF140)

#define DMA1_SOURCEH1 (*(volatile unsigned short *)0xFFFFF144)

#define DMA1_DESTL1 (*(volatile unsigned short *)0xFFFFF148)

#define DMA1_DESTH1 (*(volatile unsigned short *)0xFFFFF14C)

#define DMA1_MAX1 (*(volatile unsigned short *)0xFFFFF150)

#define DMA1_CTRL1 (*(volatile unsigned short *)0xFFFFF154)
#define DMA1_CTRL1_Enable_MASK 0x1
#define DMA1_CTRL1_Enable 0x1
#define DMA1_CTRL1_Enable_BIT 0
#define DMA1_CTRL1_Solnc_MASK 0x2
#define DMA1_CTRL1_Solnc 0x2
#define DMA1_CTRL1_Solnc_BIT 1
#define DMA1_CTRL1_Delnc_MASK 0x4
#define DMA1_CTRL1_Delnc 0x4
#define DMA1_CTRL1_Delnc_BIT 2
#define DMA1_CTRL1_SoSize_MASK 0x18
#define DMA1_CTRL1_SoSize_BIT 3
#define DMA1_CTRL1_SoBurst_MASK 0x60
#define DMA1_CTRL1_SoBurst_BIT 5
#define DMA1_CTRL1_DeSize_MASK 0x180
#define DMA1_CTRL1_DeSize_BIT 7
#define DMA1_CTRL1_Circular_MASK 0x200
#define DMA1_CTRL1_Circular 0x200
#define DMA1_CTRL1_Circular_BIT 9
#define DMA1_CTRL1_Dir_MASK 0x2000
#define DMA1_CTRL1_Dir 0x2000
#define DMA1_CTRL1_Dir_BIT 13

#define DMA1_SOCURRH1 (*(volatile unsigned short *)0xFFFFF158)

#define DMA1_SOCURRL1 (*(volatile unsigned short *)0xFFFFF15C)

#define DMA1_DECURRH1 (*(volatile unsigned short *)0xFFFFF160)

#define DMA1_DECURRL1 (*(volatile unsigned short *)0xFFFFF164)

#define DMA1_TCNT1 (*(volatile unsigned short *)0xFFFFF168)

#define DMA1_LUBUFF1 (*(volatile unsigned short *)0xFFFFF16C)

#define DMA1_SOURCEL2 (*(volatile unsigned short *)0xFFFFF180)

#define DMA1_SOURCEH2 (*(volatile unsigned short *)0xFFFFF184)

#define DMA1_DESTL2 (*(volatile unsigned short *)0xFFFFF188)

#define DMA1_DESTH2 (*(volatile unsigned short *)0xFFFFF18C)

#define DMA1_MAX2 (*(volatile unsigned short *)0xFFFFF190)

#define DMA1_CTRL2 (*(volatile unsigned short *)0xFFFFF194)
#define DMA1_CTRL2_Enable_MASK 0x1
#define DMA1_CTRL2_Enable 0x1
#define DMA1_CTRL2_Enable_BIT 0
#define DMA1_CTRL2_Solnc_MASK 0x2
#define DMA1_CTRL2_Solnc 0x2
#define DMA1_CTRL2_Solnc_BIT 1
#define DMA1_CTRL2_Delnc_MASK 0x4
#define DMA1_CTRL2_Delnc 0x4
#define DMA1_CTRL2_Delnc_BIT 2
#define DMA1_CTRL2_SoSize_MASK 0x18
#define DMA1_CTRL2_SoSize_BIT 3
#define DMA1_CTRL2_SoBurst_MASK 0x60
#define DMA1_CTRL2_SoBurst_BIT 5
#define DMA1_CTRL2_DeSize_MASK 0x180
#define DMA1_CTRL2_DeSize_BIT 7
#define DMA1_CTRL2_Circular_MASK 0x200
#define DMA1_CTRL2_Circular 0x200
#define DMA1_CTRL2_Circular_BIT 9
#define DMA1_CTRL2_Dir_MASK 0x2000
#define DMA1_CTRL2_Dir 0x2000
#define DMA1_CTRL2_Dir_BIT 13

#define DMA1_SOCURRH2 (*(volatile unsigned short *)0xFFFFF198)

#define DMA1_SOCURRL2 (*(volatile unsigned short *)0xFFFFF19C)

#define DMA1_DECURRH2 (*(volatile unsigned short *)0xFFFFF1A0)

#define DMA1_DECURRL2 (*(volatile unsigned short *)0xFFFFF1A4)

#define DMA1_TCNT2 (*(volatile unsigned short *)0xFFFFF1A8)

#define DMA1_LUBUFF2 (*(volatile unsigned short *)0xFFFFF1AC)

#define DMA1_SOURCEL3 (*(volatile unsigned short *)0xFFFFF1C0)

#define DMA1_SOURCEH3 (*(volatile unsigned short *)0xFFFFF1C4)

#define DMA1_DESTL3 (*(volatile unsigned short *)0xFFFFF1C8)

#define DMA1_DESTH3 (*(volatile unsigned short *)0xFFFFF1CC)

#define DMA1_MAX3 (*(volatile unsigned short *)0xFFFFF1D0)

#define DMA1_CTRL3 (*(volatile unsigned short *)0xFFFFF1D4)
#define DMA1_CTRL3_Enable_MASK 0x1
#define DMA1_CTRL3_Enable 0x1
#define DMA1_CTRL3_Enable_BIT 0
#define DMA1_CTRL3_Solnc_MASK 0x2
#define DMA1_CTRL3_Solnc 0x2
#define DMA1_CTRL3_Solnc_BIT 1
#define DMA1_CTRL3_Delnc_MASK 0x4
#define DMA1_CTRL3_Delnc 0x4
#define DMA1_CTRL3_Delnc_BIT 2
#define DMA1_CTRL3_SoSize_MASK 0x18
#define DMA1_CTRL3_SoSize_BIT 3
#define DMA1_CTRL3_SoBurst_MASK 0x60
#define DMA1_CTRL3_SoBurst_BIT 5
#define DMA1_CTRL3_DeSize_MASK 0x180
#define DMA1_CTRL3_DeSize_BIT 7
#define DMA1_CTRL3_Circular_MASK 0x200
#define DMA1_CTRL3_Circular 0x200
#define DMA1_CTRL3_Circular_BIT 9
#define DMA1_CTRL3_Dir_MASK 0x2000
#define DMA1_CTRL3_Dir 0x2000
#define DMA1_CTRL3_Dir_BIT 13

#define DMA1_SOCURRH3 (*(volatile unsigned short *)0xFFFFF1D8)

#define DMA1_SOCURRL3 (*(volatile unsigned short *)0xFFFFF1DC)

#define DMA1_DECURRH3 (*(volatile unsigned short *)0xFFFFF1E0)

#define DMA1_DECURRL3 (*(volatile unsigned short *)0xFFFFF1E4)

#define DMA1_TCNT3 (*(volatile unsigned short *)0xFFFFF1E8)

#define DMA1_LUBUFF3 (*(volatile unsigned short *)0xFFFFF1EC)

#define DMA1_MASK (*(volatile unsigned short *)0xFFFFF1F0)
#define DMA1_MASK_SIM0_MASK 0x1
#define DMA1_MASK_SIM0 0x1
#define DMA1_MASK_SIM0_BIT 0
#define DMA1_MASK_SIM1_MASK 0x2
#define DMA1_MASK_SIM1 0x2
#define DMA1_MASK_SIM1_BIT 1
#define DMA1_MASK_SIM2_MASK 0x4
#define DMA1_MASK_SIM2 0x4
#define DMA1_MASK_SIM2_BIT 2
#define DMA1_MASK_SIM3_MASK 0x8
#define DMA1_MASK_SIM3 0x8
#define DMA1_MASK_SIM3_BIT 3
#define DMA1_MASK_SEM0_MASK 0x10
#define DMA1_MASK_SEM0 0x10
#define DMA1_MASK_SEM0_BIT 4
#define DMA1_MASK_SEM1_MASK 0x20
#define DMA1_MASK_SEM1 0x20
#define DMA1_MASK_SEM1_BIT 5
#define DMA1_MASK_SEM2_MASK 0x40
#define DMA1_MASK_SEM2 0x40
#define DMA1_MASK_SEM2_BIT 6
#define DMA1_MASK_SEM3_MASK 0x80
#define DMA1_MASK_SEM3 0x80
#define DMA1_MASK_SEM3_BIT 7

#define DMA1_CLR (*(volatile unsigned short *)0xFFFFF1F4)
#define DMA1_CLR_SIC0_MASK 0x1
#define DMA1_CLR_SIC0 0x1
#define DMA1_CLR_SIC0_BIT 0
#define DMA1_CLR_SIC1_MASK 0x2
#define DMA1_CLR_SIC1 0x2
#define DMA1_CLR_SIC1_BIT 1
#define DMA1_CLR_SIC2_MASK 0x4
#define DMA1_CLR_SIC2 0x4
#define DMA1_CLR_SIC2_BIT 2
#define DMA1_CLR_SIC3_MASK 0x8
#define DMA1_CLR_SIC3 0x8
#define DMA1_CLR_SIC3_BIT 3
#define DMA1_CLR_SEC0_MASK 0x10
#define DMA1_CLR_SEC0 0x10
#define DMA1_CLR_SEC0_BIT 4
#define DMA1_CLR_SEC1_MASK 0x20
#define DMA1_CLR_SEC1 0x20
#define DMA1_CLR_SEC1_BIT 5
#define DMA1_CLR_SEC2_MASK 0x40
#define DMA1_CLR_SEC2 0x40
#define DMA1_CLR_SEC2_BIT 6
#define DMA1_CLR_SEC3_MASK 0x80
#define DMA1_CLR_SEC3 0x80
#define DMA1_CLR_SEC3_BIT 7

#define DMA1_STATUS (*(volatile unsigned short *)0xFFFFF1F8)
#define DMA1_STATUS_INT0_MASK 0x1
#define DMA1_STATUS_INT0 0x1
#define DMA1_STATUS_INT0_BIT 0
#define DMA1_STATUS_INT1_MASK 0x2
#define DMA1_STATUS_INT1 0x2
#define DMA1_STATUS_INT1_BIT 1
#define DMA1_STATUS_INT2_MASK 0x4
#define DMA1_STATUS_INT2 0x4
#define DMA1_STATUS_INT2_BIT 2
#define DMA1_STATUS_INT3_MASK 0x8
#define DMA1_STATUS_INT3 0x8
#define DMA1_STATUS_INT3_BIT 3
#define DMA1_STATUS_ERR0_MASK 0x10
#define DMA1_STATUS_ERR0 0x10
#define DMA1_STATUS_ERR0_BIT 4
#define DMA1_STATUS_ERR1_MASK 0x20
#define DMA1_STATUS_ERR1 0x20
#define DMA1_STATUS_ERR1_BIT 5
#define DMA1_STATUS_ERR2_MASK 0x40
#define DMA1_STATUS_ERR2 0x40
#define DMA1_STATUS_ERR2_BIT 6
#define DMA1_STATUS_ERR3_MASK 0x80
#define DMA1_STATUS_ERR3 0x80
#define DMA1_STATUS_ERR3_BIT 7
#define DMA1_STATUS_ACT0_MASK 0x100
#define DMA1_STATUS_ACT0 0x100
#define DMA1_STATUS_ACT0_BIT 8
#define DMA1_STATUS_ACT1_MASK 0x200
#define DMA1_STATUS_ACT1 0x200
#define DMA1_STATUS_ACT1_BIT 9
#define DMA1_STATUS_ACT2_MASK 0x400
#define DMA1_STATUS_ACT2 0x400
#define DMA1_STATUS_ACT2_BIT 10
#define DMA1_STATUS_ACT3_MASK 0x800
#define DMA1_STATUS_ACT3 0x800
#define DMA1_STATUS_ACT3_BIT 11

#define DMA1_LAST (*(volatile unsigned short *)0xFFFFF1FC)
#define DMA1_LAST_LAST0_MASK 0x1
#define DMA1_LAST_LAST0 0x1
#define DMA1_LAST_LAST0_BIT 0
#define DMA1_LAST_LAST1_MASK 0x2
#define DMA1_LAST_LAST1 0x2
#define DMA1_LAST_LAST1_BIT 1
#define DMA1_LAST_LAST2_MASK 0x4
#define DMA1_LAST_LAST2 0x4
#define DMA1_LAST_LAST2_BIT 2
#define DMA1_LAST_LAST3_MASK 0x8
#define DMA1_LAST_LAST3 0x8
#define DMA1_LAST_LAST3_BIT 3

#define DMA2_SOURCEL0 (*(volatile unsigned short *)0xFFFFF200)

#define DMA2_SOURCEH0 (*(volatile unsigned short *)0xFFFFF204)

#define DMA2_DESTL0 (*(volatile unsigned short *)0xFFFFF208)

#define DMA2_DESTH0 (*(volatile unsigned short *)0xFFFFF20C)

#define DMA2_MAX0 (*(volatile unsigned short *)0xFFFFF210)

#define DMA2_CTRL0 (*(volatile unsigned short *)0xFFFFF214)
#define DMA2_CTRL0_Enable_MASK 0x1
#define DMA2_CTRL0_Enable 0x1
#define DMA2_CTRL0_Enable_BIT 0
#define DMA2_CTRL0_Solnc_MASK 0x2
#define DMA2_CTRL0_Solnc 0x2
#define DMA2_CTRL0_Solnc_BIT 1
#define DMA2_CTRL0_Delnc_MASK 0x4
#define DMA2_CTRL0_Delnc 0x4
#define DMA2_CTRL0_Delnc_BIT 2
#define DMA2_CTRL0_SoSize_MASK 0x18
#define DMA2_CTRL0_SoSize_BIT 3
#define DMA2_CTRL0_SoBurst_MASK 0x60
#define DMA2_CTRL0_SoBurst_BIT 5
#define DMA2_CTRL0_DeSize_MASK 0x180
#define DMA2_CTRL0_DeSize_BIT 7
#define DMA2_CTRL0_Circular_MASK 0x200
#define DMA2_CTRL0_Circular 0x200
#define DMA2_CTRL0_Circular_BIT 9
#define DMA2_CTRL0_Dir_MASK 0x2000
#define DMA2_CTRL0_Dir 0x2000
#define DMA2_CTRL0_Dir_BIT 13

#define DMA2_SOCURRH0 (*(volatile unsigned short *)0xFFFFF218)

#define DMA2_SOCURRL0 (*(volatile unsigned short *)0xFFFFF21C)

#define DMA2_DECURRH0 (*(volatile unsigned short *)0xFFFFF220)

#define DMA2_DECURRL0 (*(volatile unsigned short *)0xFFFFF224)

#define DMA2_TCNT0 (*(volatile unsigned short *)0xFFFFF228)

#define DMA2_LUBUFF0 (*(volatile unsigned short *)0xFFFFF22C)

#define DMA2_SOURCEL1 (*(volatile unsigned short *)0xFFFFF240)

#define DMA2_SOURCEH1 (*(volatile unsigned short *)0xFFFFF244)

#define DMA2_DESTL1 (*(volatile unsigned short *)0xFFFFF248)

#define DMA2_DESTH1 (*(volatile unsigned short *)0xFFFFF24C)

#define DMA2_MAX1 (*(volatile unsigned short *)0xFFFFF250)

#define DMA2_CTRL1 (*(volatile unsigned short *)0xFFFFF254)
#define DMA2_CTRL1_Enable_MASK 0x1
#define DMA2_CTRL1_Enable 0x1
#define DMA2_CTRL1_Enable_BIT 0
#define DMA2_CTRL1_Solnc_MASK 0x2
#define DMA2_CTRL1_Solnc 0x2
#define DMA2_CTRL1_Solnc_BIT 1
#define DMA2_CTRL1_Delnc_MASK 0x4
#define DMA2_CTRL1_Delnc 0x4
#define DMA2_CTRL1_Delnc_BIT 2
#define DMA2_CTRL1_SoSize_MASK 0x18
#define DMA2_CTRL1_SoSize_BIT 3
#define DMA2_CTRL1_SoBurst_MASK 0x60
#define DMA2_CTRL1_SoBurst_BIT 5
#define DMA2_CTRL1_DeSize_MASK 0x180
#define DMA2_CTRL1_DeSize_BIT 7
#define DMA2_CTRL1_Circular_MASK 0x200
#define DMA2_CTRL1_Circular 0x200
#define DMA2_CTRL1_Circular_BIT 9
#define DMA2_CTRL1_Dir_MASK 0x2000
#define DMA2_CTRL1_Dir 0x2000
#define DMA2_CTRL1_Dir_BIT 13

#define DMA2_SOCURRH1 (*(volatile unsigned short *)0xFFFFF258)

#define DMA2_SOCURRL1 (*(volatile unsigned short *)0xFFFFF25C)

#define DMA2_DECURRH1 (*(volatile unsigned short *)0xFFFFF260)

#define DMA2_DECURRL1 (*(volatile unsigned short *)0xFFFFF264)

#define DMA2_TCNT1 (*(volatile unsigned short *)0xFFFFF268)

#define DMA2_LUBUFF1 (*(volatile unsigned short *)0xFFFFF26C)

#define DMA2_SOURCEL2 (*(volatile unsigned short *)0xFFFFF280)

#define DMA2_SOURCEH2 (*(volatile unsigned short *)0xFFFFF284)

#define DMA2_DESTL2 (*(volatile unsigned short *)0xFFFFF288)

#define DMA2_DESTH2 (*(volatile unsigned short *)0xFFFFF28C)

#define DMA2_MAX2 (*(volatile unsigned short *)0xFFFFF290)

#define DMA2_CTRL2 (*(volatile unsigned short *)0xFFFFF294)
#define DMA2_CTRL2_Enable_MASK 0x1
#define DMA2_CTRL2_Enable 0x1
#define DMA2_CTRL2_Enable_BIT 0
#define DMA2_CTRL2_Solnc_MASK 0x2
#define DMA2_CTRL2_Solnc 0x2
#define DMA2_CTRL2_Solnc_BIT 1
#define DMA2_CTRL2_Delnc_MASK 0x4
#define DMA2_CTRL2_Delnc 0x4
#define DMA2_CTRL2_Delnc_BIT 2
#define DMA2_CTRL2_SoSize_MASK 0x18
#define DMA2_CTRL2_SoSize_BIT 3
#define DMA2_CTRL2_SoBurst_MASK 0x60
#define DMA2_CTRL2_SoBurst_BIT 5
#define DMA2_CTRL2_DeSize_MASK 0x180
#define DMA2_CTRL2_DeSize_BIT 7
#define DMA2_CTRL2_Circular_MASK 0x200
#define DMA2_CTRL2_Circular 0x200
#define DMA2_CTRL2_Circular_BIT 9
#define DMA2_CTRL2_Dir_MASK 0x2000
#define DMA2_CTRL2_Dir 0x2000
#define DMA2_CTRL2_Dir_BIT 13

#define DMA2_SOCURRH2 (*(volatile unsigned short *)0xFFFFF298)

#define DMA2_SOCURRL2 (*(volatile unsigned short *)0xFFFFF29C)

#define DMA2_DECURRH2 (*(volatile unsigned short *)0xFFFFF2A0)

#define DMA2_DECURRL2 (*(volatile unsigned short *)0xFFFFF2A4)

#define DMA2_TCNT2 (*(volatile unsigned short *)0xFFFFF2A8)

#define DMA2_LUBUFF2 (*(volatile unsigned short *)0xFFFFF2AC)

#define DMA2_SOURCEL3 (*(volatile unsigned short *)0xFFFFF2C0)

#define DMA2_SOURCEH3 (*(volatile unsigned short *)0xFFFFF2C4)

#define DMA2_DESTL3 (*(volatile unsigned short *)0xFFFFF2C8)

#define DMA2_DESTH3 (*(volatile unsigned short *)0xFFFFF2CC)

#define DMA2_MAX3 (*(volatile unsigned short *)0xFFFFF2D0)

#define DMA2_CTRL3 (*(volatile unsigned short *)0xFFFFF2D4)
#define DMA2_CTRL3_Enable_MASK 0x1
#define DMA2_CTRL3_Enable 0x1
#define DMA2_CTRL3_Enable_BIT 0
#define DMA2_CTRL3_Solnc_MASK 0x2
#define DMA2_CTRL3_Solnc 0x2
#define DMA2_CTRL3_Solnc_BIT 1
#define DMA2_CTRL3_Delnc_MASK 0x4
#define DMA2_CTRL3_Delnc 0x4
#define DMA2_CTRL3_Delnc_BIT 2
#define DMA2_CTRL3_SoSize_MASK 0x18
#define DMA2_CTRL3_SoSize_BIT 3
#define DMA2_CTRL3_SoBurst_MASK 0x60
#define DMA2_CTRL3_SoBurst_BIT 5
#define DMA2_CTRL3_DeSize_MASK 0x180
#define DMA2_CTRL3_DeSize_BIT 7
#define DMA2_CTRL3_Circular_MASK 0x200
#define DMA2_CTRL3_Circular 0x200
#define DMA2_CTRL3_Circular_BIT 9
#define DMA2_CTRL3_Dir_MASK 0x2000
#define DMA2_CTRL3_Dir 0x2000
#define DMA2_CTRL3_Dir_BIT 13

#define DMA2_SOCURRH3 (*(volatile unsigned short *)0xFFFFF2D8)

#define DMA2_SOCURRL3 (*(volatile unsigned short *)0xFFFFF2DC)

#define DMA2_DECURRH3 (*(volatile unsigned short *)0xFFFFF2E0)

#define DMA2_DECURRL3 (*(volatile unsigned short *)0xFFFFF2E4)

#define DMA2_TCNT3 (*(volatile unsigned short *)0xFFFFF2E8)

#define DMA2_LUBUFF3 (*(volatile unsigned short *)0xFFFFF2EC)

#define DMA2_MASK (*(volatile unsigned short *)0xFFFFF2F0)
#define DMA2_MASK_SIM0_MASK 0x1
#define DMA2_MASK_SIM0 0x1
#define DMA2_MASK_SIM0_BIT 0
#define DMA2_MASK_SIM1_MASK 0x2
#define DMA2_MASK_SIM1 0x2
#define DMA2_MASK_SIM1_BIT 1
#define DMA2_MASK_SIM2_MASK 0x4
#define DMA2_MASK_SIM2 0x4
#define DMA2_MASK_SIM2_BIT 2
#define DMA2_MASK_SIM3_MASK 0x8
#define DMA2_MASK_SIM3 0x8
#define DMA2_MASK_SIM3_BIT 3
#define DMA2_MASK_SEM0_MASK 0x10
#define DMA2_MASK_SEM0 0x10
#define DMA2_MASK_SEM0_BIT 4
#define DMA2_MASK_SEM1_MASK 0x20
#define DMA2_MASK_SEM1 0x20
#define DMA2_MASK_SEM1_BIT 5
#define DMA2_MASK_SEM2_MASK 0x40
#define DMA2_MASK_SEM2 0x40
#define DMA2_MASK_SEM2_BIT 6
#define DMA2_MASK_SEM3_MASK 0x80
#define DMA2_MASK_SEM3 0x80
#define DMA2_MASK_SEM3_BIT 7

#define DMA2_CLR (*(volatile unsigned short *)0xFFFFF2F4)
#define DMA2_CLR_SIC0_MASK 0x1
#define DMA2_CLR_SIC0 0x1
#define DMA2_CLR_SIC0_BIT 0
#define DMA2_CLR_SIC1_MASK 0x2
#define DMA2_CLR_SIC1 0x2
#define DMA2_CLR_SIC1_BIT 1
#define DMA2_CLR_SIC2_MASK 0x4
#define DMA2_CLR_SIC2 0x4
#define DMA2_CLR_SIC2_BIT 2
#define DMA2_CLR_SIC3_MASK 0x8
#define DMA2_CLR_SIC3 0x8
#define DMA2_CLR_SIC3_BIT 3
#define DMA2_CLR_SEC0_MASK 0x10
#define DMA2_CLR_SEC0 0x10
#define DMA2_CLR_SEC0_BIT 4
#define DMA2_CLR_SEC1_MASK 0x20
#define DMA2_CLR_SEC1 0x20
#define DMA2_CLR_SEC1_BIT 5
#define DMA2_CLR_SEC2_MASK 0x40
#define DMA2_CLR_SEC2 0x40
#define DMA2_CLR_SEC2_BIT 6
#define DMA2_CLR_SEC3_MASK 0x80
#define DMA2_CLR_SEC3 0x80
#define DMA2_CLR_SEC3_BIT 7

#define DMA2_STATUS (*(volatile unsigned short *)0xFFFFF2F8)
#define DMA2_STATUS_INT0_MASK 0x1
#define DMA2_STATUS_INT0 0x1
#define DMA2_STATUS_INT0_BIT 0
#define DMA2_STATUS_INT1_MASK 0x2
#define DMA2_STATUS_INT1 0x2
#define DMA2_STATUS_INT1_BIT 1
#define DMA2_STATUS_INT2_MASK 0x4
#define DMA2_STATUS_INT2 0x4
#define DMA2_STATUS_INT2_BIT 2
#define DMA2_STATUS_INT3_MASK 0x8
#define DMA2_STATUS_INT3 0x8
#define DMA2_STATUS_INT3_BIT 3
#define DMA2_STATUS_ERR0_MASK 0x10
#define DMA2_STATUS_ERR0 0x10
#define DMA2_STATUS_ERR0_BIT 4
#define DMA2_STATUS_ERR1_MASK 0x20
#define DMA2_STATUS_ERR1 0x20
#define DMA2_STATUS_ERR1_BIT 5
#define DMA2_STATUS_ERR2_MASK 0x40
#define DMA2_STATUS_ERR2 0x40
#define DMA2_STATUS_ERR2_BIT 6
#define DMA2_STATUS_ERR3_MASK 0x80
#define DMA2_STATUS_ERR3 0x80
#define DMA2_STATUS_ERR3_BIT 7
#define DMA2_STATUS_ACT0_MASK 0x100
#define DMA2_STATUS_ACT0 0x100
#define DMA2_STATUS_ACT0_BIT 8
#define DMA2_STATUS_ACT1_MASK 0x200
#define DMA2_STATUS_ACT1 0x200
#define DMA2_STATUS_ACT1_BIT 9
#define DMA2_STATUS_ACT2_MASK 0x400
#define DMA2_STATUS_ACT2 0x400
#define DMA2_STATUS_ACT2_BIT 10
#define DMA2_STATUS_ACT3_MASK 0x800
#define DMA2_STATUS_ACT3 0x800
#define DMA2_STATUS_ACT3_BIT 11

#define DMA2_LAST (*(volatile unsigned short *)0xFFFFF2FC)
#define DMA2_LAST_LAST0_MASK 0x1
#define DMA2_LAST_LAST0 0x1
#define DMA2_LAST_LAST0_BIT 0
#define DMA2_LAST_LAST1_MASK 0x2
#define DMA2_LAST_LAST1 0x2
#define DMA2_LAST_LAST1_BIT 1
#define DMA2_LAST_LAST2_MASK 0x4
#define DMA2_LAST_LAST2 0x4
#define DMA2_LAST_LAST2_BIT 2
#define DMA2_LAST_LAST3_MASK 0x8
#define DMA2_LAST_LAST3 0x8
#define DMA2_LAST_LAST3_BIT 3

#define DMA3_SOURCEL0 (*(volatile unsigned short *)0xFFFFF300)

#define DMA3_SOURCEH0 (*(volatile unsigned short *)0xFFFFF304)

#define DMA3_DESTL0 (*(volatile unsigned short *)0xFFFFF308)

#define DMA3_DESTH0 (*(volatile unsigned short *)0xFFFFF30C)

#define DMA3_MAX0 (*(volatile unsigned short *)0xFFFFF310)

#define DMA3_CTRL0 (*(volatile unsigned short *)0xFFFFF314)
#define DMA3_CTRL0_Enable_MASK 0x1
#define DMA3_CTRL0_Enable 0x1
#define DMA3_CTRL0_Enable_BIT 0
#define DMA3_CTRL0_Solnc_MASK 0x2
#define DMA3_CTRL0_Solnc 0x2
#define DMA3_CTRL0_Solnc_BIT 1
#define DMA3_CTRL0_Delnc_MASK 0x4
#define DMA3_CTRL0_Delnc 0x4
#define DMA3_CTRL0_Delnc_BIT 2
#define DMA3_CTRL0_SoSize_MASK 0x18
#define DMA3_CTRL0_SoSize_BIT 3
#define DMA3_CTRL0_SoBurst_MASK 0x60
#define DMA3_CTRL0_SoBurst_BIT 5
#define DMA3_CTRL0_DeSize_MASK 0x180
#define DMA3_CTRL0_DeSize_BIT 7
#define DMA3_CTRL0_Circular_MASK 0x200
#define DMA3_CTRL0_Circular 0x200
#define DMA3_CTRL0_Circular_BIT 9
#define DMA3_CTRL0_Dir_MASK 0x2000
#define DMA3_CTRL0_Dir 0x2000
#define DMA3_CTRL0_Dir_BIT 13

#define DMA3_SOCURRH0 (*(volatile unsigned short *)0xFFFFF318)

#define DMA3_SOCURRL0 (*(volatile unsigned short *)0xFFFFF31C)

#define DMA3_DECURRH0 (*(volatile unsigned short *)0xFFFFF320)

#define DMA3_DECURRL0 (*(volatile unsigned short *)0xFFFFF324)

#define DMA3_TCNT0 (*(volatile unsigned short *)0xFFFFF328)

#define DMA3_LUBUFF0 (*(volatile unsigned short *)0xFFFFF32C)

#define DMA3_SOURCEL1 (*(volatile unsigned short *)0xFFFFF340)

#define DMA3_SOURCEH1 (*(volatile unsigned short *)0xFFFFF344)

#define DMA3_DESTL1 (*(volatile unsigned short *)0xFFFFF348)

#define DMA3_DESTH1 (*(volatile unsigned short *)0xFFFFF34C)

#define DMA3_MAX1 (*(volatile unsigned short *)0xFFFFF350)

#define DMA3_CTRL1 (*(volatile unsigned short *)0xFFFFF354)
#define DMA3_CTRL1_Enable_MASK 0x1
#define DMA3_CTRL1_Enable 0x1
#define DMA3_CTRL1_Enable_BIT 0
#define DMA3_CTRL1_Solnc_MASK 0x2
#define DMA3_CTRL1_Solnc 0x2
#define DMA3_CTRL1_Solnc_BIT 1
#define DMA3_CTRL1_Delnc_MASK 0x4
#define DMA3_CTRL1_Delnc 0x4
#define DMA3_CTRL1_Delnc_BIT 2
#define DMA3_CTRL1_SoSize_MASK 0x18
#define DMA3_CTRL1_SoSize_BIT 3
#define DMA3_CTRL1_SoBurst_MASK 0x60
#define DMA3_CTRL1_SoBurst_BIT 5
#define DMA3_CTRL1_DeSize_MASK 0x180
#define DMA3_CTRL1_DeSize_BIT 7
#define DMA3_CTRL1_Circular_MASK 0x200
#define DMA3_CTRL1_Circular 0x200
#define DMA3_CTRL1_Circular_BIT 9
#define DMA3_CTRL1_Dir_MASK 0x2000
#define DMA3_CTRL1_Dir 0x2000
#define DMA3_CTRL1_Dir_BIT 13

#define DMA3_SOCURRH1 (*(volatile unsigned short *)0xFFFFF358)

#define DMA3_SOCURRL1 (*(volatile unsigned short *)0xFFFFF35C)

#define DMA3_DECURRH1 (*(volatile unsigned short *)0xFFFFF360)

#define DMA3_DECURRL1 (*(volatile unsigned short *)0xFFFFF364)

#define DMA3_TCNT1 (*(volatile unsigned short *)0xFFFFF368)

#define DMA3_LUBUFF1 (*(volatile unsigned short *)0xFFFFF36C)

#define DMA3_SOURCEL2 (*(volatile unsigned short *)0xFFFFF380)

#define DMA3_SOURCEH2 (*(volatile unsigned short *)0xFFFFF384)

#define DMA3_DESTL2 (*(volatile unsigned short *)0xFFFFF388)

#define DMA3_DESTH2 (*(volatile unsigned short *)0xFFFFF38C)

#define DMA3_MAX2 (*(volatile unsigned short *)0xFFFFF390)

#define DMA3_CTRL2 (*(volatile unsigned short *)0xFFFFF394)
#define DMA3_CTRL2_Enable_MASK 0x1
#define DMA3_CTRL2_Enable 0x1
#define DMA3_CTRL2_Enable_BIT 0
#define DMA3_CTRL2_Solnc_MASK 0x2
#define DMA3_CTRL2_Solnc 0x2
#define DMA3_CTRL2_Solnc_BIT 1
#define DMA3_CTRL2_Delnc_MASK 0x4
#define DMA3_CTRL2_Delnc 0x4
#define DMA3_CTRL2_Delnc_BIT 2
#define DMA3_CTRL2_SoSize_MASK 0x18
#define DMA3_CTRL2_SoSize_BIT 3
#define DMA3_CTRL2_SoBurst_MASK 0x60
#define DMA3_CTRL2_SoBurst_BIT 5
#define DMA3_CTRL2_DeSize_MASK 0x180
#define DMA3_CTRL2_DeSize_BIT 7
#define DMA3_CTRL2_Circular_MASK 0x200
#define DMA3_CTRL2_Circular 0x200
#define DMA3_CTRL2_Circular_BIT 9
#define DMA3_CTRL2_Dir_MASK 0x2000
#define DMA3_CTRL2_Dir 0x2000
#define DMA3_CTRL2_Dir_BIT 13

#define DMA3_SOCURRH2 (*(volatile unsigned short *)0xFFFFF398)

#define DMA3_SOCURRL2 (*(volatile unsigned short *)0xFFFFF39C)

#define DMA3_DECURRH2 (*(volatile unsigned short *)0xFFFFF3A0)

#define DMA3_DECURRL2 (*(volatile unsigned short *)0xFFFFF3A4)

#define DMA3_TCNT2 (*(volatile unsigned short *)0xFFFFF3A8)

#define DMA3_LUBUFF2 (*(volatile unsigned short *)0xFFFFF3AC)

#define DMA3_SOURCEL3 (*(volatile unsigned short *)0xFFFFF3C0)

#define DMA3_SOURCEH3 (*(volatile unsigned short *)0xFFFFF3C4)

#define DMA3_DESTL3 (*(volatile unsigned short *)0xFFFFF3C8)

#define DMA3_DESTH3 (*(volatile unsigned short *)0xFFFFF3CC)

#define DMA3_MAX3 (*(volatile unsigned short *)0xFFFFF3D0)

#define DMA3_CTRL3 (*(volatile unsigned short *)0xFFFFF3D4)
#define DMA3_CTRL3_Enable_MASK 0x1
#define DMA3_CTRL3_Enable 0x1
#define DMA3_CTRL3_Enable_BIT 0
#define DMA3_CTRL3_Solnc_MASK 0x2
#define DMA3_CTRL3_Solnc 0x2
#define DMA3_CTRL3_Solnc_BIT 1
#define DMA3_CTRL3_Delnc_MASK 0x4
#define DMA3_CTRL3_Delnc 0x4
#define DMA3_CTRL3_Delnc_BIT 2
#define DMA3_CTRL3_SoSize_MASK 0x18
#define DMA3_CTRL3_SoSize_BIT 3
#define DMA3_CTRL3_SoBurst_MASK 0x60
#define DMA3_CTRL3_SoBurst_BIT 5
#define DMA3_CTRL3_DeSize_MASK 0x180
#define DMA3_CTRL3_DeSize_BIT 7
#define DMA3_CTRL3_Circular_MASK 0x200
#define DMA3_CTRL3_Circular 0x200
#define DMA3_CTRL3_Circular_BIT 9
#define DMA3_CTRL3_Dir_MASK 0x2000
#define DMA3_CTRL3_Dir 0x2000
#define DMA3_CTRL3_Dir_BIT 13

#define DMA3_SOCURRH3 (*(volatile unsigned short *)0xFFFFF3D8)

#define DMA3_SOCURRL3 (*(volatile unsigned short *)0xFFFFF3DC)

#define DMA3_DECURRH3 (*(volatile unsigned short *)0xFFFFF3E0)

#define DMA3_DECURRL3 (*(volatile unsigned short *)0xFFFFF3E4)

#define DMA3_TCNT3 (*(volatile unsigned short *)0xFFFFF3E8)

#define DMA3_LUBUFF3 (*(volatile unsigned short *)0xFFFFF3EC)

#define DMA3_MASK (*(volatile unsigned short *)0xFFFFF3F0)
#define DMA3_MASK_SIM0_MASK 0x1
#define DMA3_MASK_SIM0 0x1
#define DMA3_MASK_SIM0_BIT 0
#define DMA3_MASK_SIM1_MASK 0x2
#define DMA3_MASK_SIM1 0x2
#define DMA3_MASK_SIM1_BIT 1
#define DMA3_MASK_SIM2_MASK 0x4
#define DMA3_MASK_SIM2 0x4
#define DMA3_MASK_SIM2_BIT 2
#define DMA3_MASK_SIM3_MASK 0x8
#define DMA3_MASK_SIM3 0x8
#define DMA3_MASK_SIM3_BIT 3
#define DMA3_MASK_SEM0_MASK 0x10
#define DMA3_MASK_SEM0 0x10
#define DMA3_MASK_SEM0_BIT 4
#define DMA3_MASK_SEM1_MASK 0x20
#define DMA3_MASK_SEM1 0x20
#define DMA3_MASK_SEM1_BIT 5
#define DMA3_MASK_SEM2_MASK 0x40
#define DMA3_MASK_SEM2 0x40
#define DMA3_MASK_SEM2_BIT 6
#define DMA3_MASK_SEM3_MASK 0x80
#define DMA3_MASK_SEM3 0x80
#define DMA3_MASK_SEM3_BIT 7

#define DMA3_CLR (*(volatile unsigned short *)0xFFFFF3F4)
#define DMA3_CLR_SIC0_MASK 0x1
#define DMA3_CLR_SIC0 0x1
#define DMA3_CLR_SIC0_BIT 0
#define DMA3_CLR_SIC1_MASK 0x2
#define DMA3_CLR_SIC1 0x2
#define DMA3_CLR_SIC1_BIT 1
#define DMA3_CLR_SIC2_MASK 0x4
#define DMA3_CLR_SIC2 0x4
#define DMA3_CLR_SIC2_BIT 2
#define DMA3_CLR_SIC3_MASK 0x8
#define DMA3_CLR_SIC3 0x8
#define DMA3_CLR_SIC3_BIT 3
#define DMA3_CLR_SEC0_MASK 0x10
#define DMA3_CLR_SEC0 0x10
#define DMA3_CLR_SEC0_BIT 4
#define DMA3_CLR_SEC1_MASK 0x20
#define DMA3_CLR_SEC1 0x20
#define DMA3_CLR_SEC1_BIT 5
#define DMA3_CLR_SEC2_MASK 0x40
#define DMA3_CLR_SEC2 0x40
#define DMA3_CLR_SEC2_BIT 6
#define DMA3_CLR_SEC3_MASK 0x80
#define DMA3_CLR_SEC3 0x80
#define DMA3_CLR_SEC3_BIT 7

#define DMA3_STATUS (*(volatile unsigned short *)0xFFFFF3F8)
#define DMA3_STATUS_INT0_MASK 0x1
#define DMA3_STATUS_INT0 0x1
#define DMA3_STATUS_INT0_BIT 0
#define DMA3_STATUS_INT1_MASK 0x2
#define DMA3_STATUS_INT1 0x2
#define DMA3_STATUS_INT1_BIT 1
#define DMA3_STATUS_INT2_MASK 0x4
#define DMA3_STATUS_INT2 0x4
#define DMA3_STATUS_INT2_BIT 2
#define DMA3_STATUS_INT3_MASK 0x8
#define DMA3_STATUS_INT3 0x8
#define DMA3_STATUS_INT3_BIT 3
#define DMA3_STATUS_ERR0_MASK 0x10
#define DMA3_STATUS_ERR0 0x10
#define DMA3_STATUS_ERR0_BIT 4
#define DMA3_STATUS_ERR1_MASK 0x20
#define DMA3_STATUS_ERR1 0x20
#define DMA3_STATUS_ERR1_BIT 5
#define DMA3_STATUS_ERR2_MASK 0x40
#define DMA3_STATUS_ERR2 0x40
#define DMA3_STATUS_ERR2_BIT 6
#define DMA3_STATUS_ERR3_MASK 0x80
#define DMA3_STATUS_ERR3 0x80
#define DMA3_STATUS_ERR3_BIT 7
#define DMA3_STATUS_ACT0_MASK 0x100
#define DMA3_STATUS_ACT0 0x100
#define DMA3_STATUS_ACT0_BIT 8
#define DMA3_STATUS_ACT1_MASK 0x200
#define DMA3_STATUS_ACT1 0x200
#define DMA3_STATUS_ACT1_BIT 9
#define DMA3_STATUS_ACT2_MASK 0x400
#define DMA3_STATUS_ACT2 0x400
#define DMA3_STATUS_ACT2_BIT 10
#define DMA3_STATUS_ACT3_MASK 0x800
#define DMA3_STATUS_ACT3 0x800
#define DMA3_STATUS_ACT3_BIT 11

#define DMA3_LAST (*(volatile unsigned short *)0xFFFFF3FC)
#define DMA3_LAST_LAST0_MASK 0x1
#define DMA3_LAST_LAST0 0x1
#define DMA3_LAST_LAST0_BIT 0
#define DMA3_LAST_LAST1_MASK 0x2
#define DMA3_LAST_LAST1 0x2
#define DMA3_LAST_LAST1_BIT 1
#define DMA3_LAST_LAST2_MASK 0x4
#define DMA3_LAST_LAST2 0x4
#define DMA3_LAST_LAST2_BIT 2
#define DMA3_LAST_LAST3_MASK 0x8
#define DMA3_LAST_LAST3 0x8
#define DMA3_LAST_LAST3_BIT 3

#define RTC_CRH (*(volatile unsigned short *)0xFFFFF400)
#define RTC_CRH_SEN_MASK 0x1
#define RTC_CRH_SEN 0x1
#define RTC_CRH_SEN_BIT 0
#define RTC_CRH_AEN_MASK 0x2
#define RTC_CRH_AEN 0x2
#define RTC_CRH_AEN_BIT 1
#define RTC_CRH_OWEN_MASK 0x4
#define RTC_CRH_OWEN 0x4
#define RTC_CRH_OWEN_BIT 2
#define RTC_CRH_GEN_MASK 0x8
#define RTC_CRH_GEN 0x8
#define RTC_CRH_GEN_BIT 3

#define RTC_CRL (*(volatile unsigned short *)0xFFFFF404)
#define RTC_CRL_SIR_MASK 0x1
#define RTC_CRL_SIR 0x1
#define RTC_CRL_SIR_BIT 0
#define RTC_CRL_AIR_MASK 0x2
#define RTC_CRL_AIR 0x2
#define RTC_CRL_AIR_BIT 1
#define RTC_CRL_OWIR_MASK 0x4
#define RTC_CRL_OWIR 0x4
#define RTC_CRL_OWIR_BIT 2
#define RTC_CRL_GIR_MASK 0x8
#define RTC_CRL_GIR 0x8
#define RTC_CRL_GIR_BIT 3
#define RTC_CRL_CNF_MASK 0x10
#define RTC_CRL_CNF 0x10
#define RTC_CRL_CNF_BIT 4
#define RTC_CRL_RTOFF_MASK 0x20
#define RTC_CRL_RTOFF 0x20
#define RTC_CRL_RTOFF_BIT 5

#define RTC_PRLH (*(volatile unsigned short *)0xFFFFF408)

#define RTC_PRLL (*(volatile unsigned short *)0xFFFFF40C)

#define RTC_DIVH (*(volatile unsigned short *)0xFFFFF410)

#define RTC_DIVL (*(volatile unsigned short *)0xFFFFF414)

#define RTC_CNTH (*(volatile unsigned short *)0xFFFFF418)

#define RTC_CNTL (*(volatile unsigned short *)0xFFFFF41C)

#define RTC_ALRH (*(volatile unsigned short *)0xFFFFF420)

#define RTC_ALRL (*(volatile unsigned short *)0xFFFFF424)

#define CMU_RCCTL (*(volatile unsigned short *)0xFFFFF600)
#define CMU_RCCTL_SEN_MASK 0x1
#define CMU_RCCTL_SEN 0x1
#define CMU_RCCTL_SEN_BIT 0
#define CMU_RCCTL_AEN_MASK 0x2
#define CMU_RCCTL_AEN 0x2
#define CMU_RCCTL_AEN_BIT 1
#define CMU_RCCTL_OWEN_MASK 0x4
#define CMU_RCCTL_OWEN 0x4
#define CMU_RCCTL_OWEN_BIT 2
#define CMU_RCCTL_GEN_MASK 0x8
#define CMU_RCCTL_GEN 0x8
#define CMU_RCCTL_GEN_BIT 3

#define CMU_FDISP (*(volatile unsigned short *)0xFFFFF604)
#define CMU_FDISP_SIR_MASK 0x1
#define CMU_FDISP_SIR 0x1
#define CMU_FDISP_SIR_BIT 0
#define CMU_FDISP_AIR_MASK 0x2
#define CMU_FDISP_AIR 0x2
#define CMU_FDISP_AIR_BIT 1
#define CMU_FDISP_OWIR_MASK 0x4
#define CMU_FDISP_OWIR 0x4
#define CMU_FDISP_OWIR_BIT 2
#define CMU_FDISP_GIR_MASK 0x8
#define CMU_FDISP_GIR 0x8
#define CMU_FDISP_GIR_BIT 3
#define CMU_FDISP_CNF_MASK 0x10
#define CMU_FDISP_CNF 0x10
#define CMU_FDISP_CNF_BIT 4
#define CMU_FDISP_RTOFF_MASK 0x20
#define CMU_FDISP_RTOFF 0x20
#define CMU_FDISP_RTOFF_BIT 5

#define CMU_FRH (*(volatile unsigned short *)0xFFFFF608)

#define CMU_FRL (*(volatile unsigned short *)0xFFFFF60C)

#define CMU_CTRL (*(volatile unsigned short *)0xFFFFF610)
#define CMU_CTRL_CKSEL0_MASK 0x1
#define CMU_CTRL_CKSEL0 0x1
#define CMU_CTRL_CKSEL0_BIT 0
#define CMU_CTRL_CKSEL1_MASK 0x2
#define CMU_CTRL_CKSEL1 0x2
#define CMU_CTRL_CKSEL1_BIT 1
#define CMU_CTRL_CKSEL2_MASK 0x4
#define CMU_CTRL_CKSEL2 0x4
#define CMU_CTRL_CKSEL2_BIT 2
#define CMU_CTRL_REN_MASK 0x8
#define CMU_CTRL_REN 0x8
#define CMU_CTRL_REN_BIT 3
#define CMU_CTRL_SFM_MASK 0x10
#define CMU_CTRL_SFM 0x10
#define CMU_CTRL_SFM_BIT 4
#define CMU_CTRL_RCSS_MASK 0x20
#define CMU_CTRL_RCSS 0x20
#define CMU_CTRL_RCSS_BIT 5
#define CMU_CTRL_RCHSE_MASK 0x40
#define CMU_CTRL_RCHSE 0x40
#define CMU_CTRL_RCHSE_BIT 6
#define CMU_CTRL_RCFS_MASK 0x80
#define CMU_CTRL_RCFS 0x80
#define CMU_CTRL_RCFS_BIT 7
#define CMU_CTRL_RCFR_MASK 0x100
#define CMU_CTRL_RCFR 0x100
#define CMU_CTRL_RCFR_BIT 8
#define CMU_CTRL_CRF_MASK 0x200
#define CMU_CTRL_CRF 0x200
#define CMU_CTRL_CRF_BIT 9
#define CMU_CTRL_OSCS_MASK 0x400
#define CMU_CTRL_OSCS 0x400
#define CMU_CTRL_OSCS_BIT 10

#define CMU_STAT (*(volatile unsigned short *)0xFFFFF614)
#define CMU_STAT_CKON0_MASK 0x1
#define CMU_STAT_CKON0 0x1
#define CMU_STAT_CKON0_BIT 0
#define CMU_STAT_CKON1_MASK 0x2
#define CMU_STAT_CKON1 0x2
#define CMU_STAT_CKON1_BIT 1
#define CMU_STAT_CKON2_MASK 0x4
#define CMU_STAT_CKON2 0x4
#define CMU_STAT_CKON2_BIT 2
#define CMU_STAT_RON_MASK 0x8
#define CMU_STAT_RON 0x8
#define CMU_STAT_RON_BIT 3
#define CMU_STAT_CRFR_MASK 0x10
#define CMU_STAT_CRFR 0x10
#define CMU_STAT_CRFR_BIT 4

#define CMU_IS (*(volatile unsigned short *)0xFFFFF618)
#define CMU_IS_OLR_MASK 0x1
#define CMU_IS_OLR 0x1
#define CMU_IS_OLR_BIT 0
#define CMU_IS_EOC_MASK 0x2
#define CMU_IS_EOC 0x2
#define CMU_IS_EOC_BIT 1
#define CMU_IS_FLL_MASK 0x4
#define CMU_IS_FLL 0x4
#define CMU_IS_FLL_BIT 2
#define CMU_IS_ROI_MASK 0x8
#define CMU_IS_ROI 0x8
#define CMU_IS_ROI_BIT 3

#define CMU_IM (*(volatile unsigned short *)0xFFFFF61C)
#define CMU_IM_OLRM_MASK 0x1
#define CMU_IM_OLRM 0x1
#define CMU_IM_OLRM_BIT 0
#define CMU_IM_EOCM_MASK 0x2
#define CMU_IM_EOCM 0x2
#define CMU_IM_EOCM_BIT 1
#define CMU_IM_FLLM_MASK 0x4
#define CMU_IM_FLLM 0x4
#define CMU_IM_FLLM_BIT 2
#define CMU_IM_ROIM_MASK 0x8
#define CMU_IM_ROIM 0x8
#define CMU_IM_ROIM_BIT 3

#define CMU_EOCV (*(volatile unsigned short *)0xFFFFF620)

#define CMU_WE (*(volatile unsigned short *)0xFFFFF624)

#define ADC_CLR0 (*(volatile unsigned short *)0xFFFFF800)
#define ADC_CLR0_START_MASK 0x1
#define ADC_CLR0_START 0x1
#define ADC_CLR0_START_BIT 0
#define ADC_CLR0_CAL_MASK 0x2
#define ADC_CLR0_CAL 0x2
#define ADC_CLR0_CAL_BIT 1

#define ADC_CLR1 (*(volatile unsigned short *)0xFFFFF804)
#define ADC_CLR1_SMPP_MASK 0xF
#define ADC_CLR1_SMPP_BIT 0
#define ADC_CLR1_CNVP_MASK 0xE0
#define ADC_CLR1_CNVP_BIT 5
#define ADC_CLR1_SPEN_MASK 0x8000
#define ADC_CLR1_SPEN 0x8000
#define ADC_CLR1_SPEN_BIT 15

#define ADC_CLR2 (*(volatile unsigned short *)0xFFFFF808)
#define ADC_CLR2_FCH_MASK 0x7
#define ADC_CLR2_FCH_BIT 0
#define ADC_CLR2_NCH_MASK 0x3C0
#define ADC_CLR2_NCH_BIT 6
#define ADC_CLR2_MODE_MASK 0x8000
#define ADC_CLR2_MODE 0x8000
#define ADC_CLR2_MODE_BIT 15

#define ADC_CLR3 (*(volatile unsigned short *)0xFFFFF80C)
#define ADC_CLR3_JFCH_MASK 0x7
#define ADC_CLR3_JFCH_BIT 0
#define ADC_CLR3_JNCH_MASK 0x3C0
#define ADC_CLR3_JNCH_BIT 6
#define ADC_CLR3_JSTART_MASK 0x8000
#define ADC_CLR3_JSTART 0x8000
#define ADC_CLR3_JSTART_BIT 15

#define ADC_CLR4 (*(volatile unsigned short *)0xFFFFF810)
#define ADC_CLR4_NOAVRG_MASK 0x20
#define ADC_CLR4_NOAVRG 0x20
#define ADC_CLR4_NOAVRG_BIT 5
#define ADC_CLR4_ACKO_MASK 0x4000
#define ADC_CLR4_ACKO 0x4000
#define ADC_CLR4_ACKO_BIT 14
#define ADC_CLR4_PWDN_MASK 0x8000
#define ADC_CLR4_PWDN 0x8000
#define ADC_CLR4_PWDN_BIT 15

#define ADC_TRA0 (*(volatile unsigned short *)0xFFFFF814)
#define ADC_TRA0_THRH_MASK 0x3FF
#define ADC_TRA0_THRH_BIT 0
#define ADC_TRA0_THRCH_MASK 0xFC00
#define ADC_TRA0_THRCH_BIT 10

#define ADC_TRA1 (*(volatile unsigned short *)0xFFFFF818)
#define ADC_TRA1_THRH_MASK 0x3FF
#define ADC_TRA1_THRH_BIT 0
#define ADC_TRA1_THRCH_MASK 0xFC00
#define ADC_TRA1_THRCH_BIT 10

#define ADC_TRA2 (*(volatile unsigned short *)0xFFFFF81C)
#define ADC_TRA2_THRH_MASK 0x3FF
#define ADC_TRA2_THRH_BIT 0
#define ADC_TRA2_THRCH_MASK 0xFC00
#define ADC_TRA2_THRCH_BIT 10

#define ADC_TRA3 (*(volatile unsigned short *)0xFFFFF820)
#define ADC_TRA3_THRH_MASK 0x3FF
#define ADC_TRA3_THRH_BIT 0
#define ADC_TRA3_THRCH_MASK 0xFC00
#define ADC_TRA3_THRCH_BIT 10

#define ADC_TRB0 (*(volatile unsigned short *)0xFFFFF824)
#define ADC_TRB0_THRL_MASK 0x3FF
#define ADC_TRB0_THRL_BIT 0
#define ADC_TRB0_THREN_MASK 0x8000
#define ADC_TRB0_THREN 0x8000
#define ADC_TRB0_THREN_BIT 15

#define ADC_TRB1 (*(volatile unsigned short *)0xFFFFF828)
#define ADC_TRB1_THRL_MASK 0x3FF
#define ADC_TRB1_THRL_BIT 0
#define ADC_TRB1_THREN_MASK 0x400
#define ADC_TRB1_THREN 0x400
#define ADC_TRB1_THREN_BIT 10

#define ADC_TRB2 (*(volatile unsigned short *)0xFFFFF82C)
#define ADC_TRB2_THRL_MASK 0x3FF
#define ADC_TRB2_THRL_BIT 0
#define ADC_TRB2_THREN_MASK 0x400
#define ADC_TRB2_THREN 0x400
#define ADC_TRB2_THREN_BIT 10

#define ADC_TRB3 (*(volatile unsigned short *)0xFFFFF830)
#define ADC_TRB3_THRL_MASK 0x3FF
#define ADC_TRB3_THRL_BIT 0
#define ADC_TRB3_THREN_MASK 0x400
#define ADC_TRB3_THREN 0x400
#define ADC_TRB3_THREN_BIT 10

#define ADC_DMAR (*(volatile unsigned short *)0xFFFFF834)
#define ADC_DMAR_DMA0_MASK 0x1
#define ADC_DMAR_DMA0 0x1
#define ADC_DMAR_DMA0_BIT 0
#define ADC_DMAR_DMA1_MASK 0x2
#define ADC_DMAR_DMA1 0x2
#define ADC_DMAR_DMA1_BIT 1
#define ADC_DMAR_DMA2_MASK 0x4
#define ADC_DMAR_DMA2 0x4
#define ADC_DMAR_DMA2_BIT 2
#define ADC_DMAR_DMA3_MASK 0x8
#define ADC_DMAR_DMA3 0x8
#define ADC_DMAR_DMA3_BIT 3
#define ADC_DMAR_DMA4_MASK 0x10
#define ADC_DMAR_DMA4 0x10
#define ADC_DMAR_DMA4_BIT 4
#define ADC_DMAR_DMA5_MASK 0x20
#define ADC_DMAR_DMA5 0x20
#define ADC_DMAR_DMA5_BIT 5
#define ADC_DMAR_DMA6_MASK 0x40
#define ADC_DMAR_DMA6 0x40
#define ADC_DMAR_DMA6_BIT 6
#define ADC_DMAR_DMA7_MASK 0x80
#define ADC_DMAR_DMA7 0x80
#define ADC_DMAR_DMA7_BIT 7
#define ADC_DMAR_DMA8_MASK 0x100
#define ADC_DMAR_DMA8 0x100
#define ADC_DMAR_DMA8_BIT 8
#define ADC_DMAR_DMA9_MASK 0x200
#define ADC_DMAR_DMA9 0x200
#define ADC_DMAR_DMA9_BIT 9
#define ADC_DMAR_DMA10_MASK 0x400
#define ADC_DMAR_DMA10 0x400
#define ADC_DMAR_DMA10_BIT 10
#define ADC_DMAR_DMA11_MASK 0x800
#define ADC_DMAR_DMA11 0x800
#define ADC_DMAR_DMA11_BIT 11
#define ADC_DMAR_DMA12_MASK 0x1000
#define ADC_DMAR_DMA12 0x1000
#define ADC_DMAR_DMA12_BIT 12
#define ADC_DMAR_DMA13_MASK 0x2000
#define ADC_DMAR_DMA13 0x2000
#define ADC_DMAR_DMA13_BIT 13
#define ADC_DMAR_DMA14_MASK 0x4000
#define ADC_DMAR_DMA14 0x4000
#define ADC_DMAR_DMA14_BIT 14
#define ADC_DMAR_DMA15_MASK 0x8000
#define ADC_DMAR_DMA15 0x8000
#define ADC_DMAR_DMA15_BIT 15

#define ADC_DMAE (*(volatile unsigned short *)0xFFFFF844)
#define ADC_DMAE_DENCH_MASK 0xF
#define ADC_DMAE_DENCH_BIT 0
#define ADC_DMAE_DMAEN_MASK 0x8000
#define ADC_DMAE_DMAEN 0x8000
#define ADC_DMAE_DMAEN_BIT 15

#define ADC_PBR (*(volatile unsigned short *)0xFFFFF848)
#define ADC_PBR_ECH_MASK 0x1
#define ADC_PBR_ECH 0x1
#define ADC_PBR_ECH_BIT 0
#define ADC_PBR_EOC_MASK 0x2
#define ADC_PBR_EOC 0x2
#define ADC_PBR_EOC_BIT 1
#define ADC_PBR_JECH_MASK 0x4
#define ADC_PBR_JECH 0x4
#define ADC_PBR_JECH_BIT 2
#define ADC_PBR_JEOC_MASK 0x8
#define ADC_PBR_JEOC 0x8
#define ADC_PBR_JEOC_BIT 3
#define ADC_PBR_THR0_MASK 0x30
#define ADC_PBR_THR0_BIT 4
#define ADC_PBR_THR1_MASK 0xC0
#define ADC_PBR_THR1_BIT 6
#define ADC_PBR_THR2_MASK 0x300
#define ADC_PBR_THR2_BIT 8
#define ADC_PBR_THR3_MASK 0xC00
#define ADC_PBR_THR3_BIT 10

#define ADC_IMR (*(volatile unsigned short *)0xFFFFF84C)
#define ADC_IMR_MSKECH_MASK 0x1
#define ADC_IMR_MSKECH 0x1
#define ADC_IMR_MSKECH_BIT 0
#define ADC_IMR_MSKEOC_MASK 0x2
#define ADC_IMR_MSKEOC 0x2
#define ADC_IMR_MSKEOC_BIT 1
#define ADC_IMR_MSKJECH_MASK 0x4
#define ADC_IMR_MSKJECH 0x4
#define ADC_IMR_MSKJECH_BIT 2
#define ADC_IMR_MSKJEOC_MASK 0x8
#define ADC_IMR_MSKJEOC 0x8
#define ADC_IMR_MSKJEOC_BIT 3
#define ADC_IMR_MSK0L_MASK 0x10
#define ADC_IMR_MSK0L 0x10
#define ADC_IMR_MSK0L_BIT 4
#define ADC_IMR_MSK0H_MASK 0x20
#define ADC_IMR_MSK0H 0x20
#define ADC_IMR_MSK0H_BIT 5
#define ADC_IMR_MSK1L_MASK 0x40
#define ADC_IMR_MSK1L 0x40
#define ADC_IMR_MSK1L_BIT 6
#define ADC_IMR_MSK1H_MASK 0x80
#define ADC_IMR_MSK1H 0x80
#define ADC_IMR_MSK1H_BIT 7
#define ADC_IMR_MSK2L_MASK 0x100
#define ADC_IMR_MSK2L 0x100
#define ADC_IMR_MSK2L_BIT 8
#define ADC_IMR_MSK2H_MASK 0x200
#define ADC_IMR_MSK2H 0x200
#define ADC_IMR_MSK2H_BIT 9
#define ADC_IMR_MSK3L_MASK 0x400
#define ADC_IMR_MSK3L 0x400
#define ADC_IMR_MSK3L_BIT 10
#define ADC_IMR_MSK3H_MASK 0x800
#define ADC_IMR_MSK3H 0x800
#define ADC_IMR_MSK3H_BIT 11

#define ADC_D0 (*(volatile unsigned short *)0xFFFFF850)
#define ADC_D0_CDATA_MASK 0x7FF
#define ADC_D0_CDATA_BIT 0

#define ADC_D1 (*(volatile unsigned short *)0xFFFFF854)
#define ADC_D1_CDATA_MASK 0x7FF
#define ADC_D1_CDATA_BIT 0

#define ADC_D2 (*(volatile unsigned short *)0xFFFFF858)
#define ADC_D2_CDATA_MASK 0x7FF
#define ADC_D2_CDATA_BIT 0

#define ADC_D3 (*(volatile unsigned short *)0xFFFFF85C)
#define ADC_D3_CDATA_MASK 0x7FF
#define ADC_D3_CDATA_BIT 0

#define ADC_D4 (*(volatile unsigned short *)0xFFFFF860)
#define ADC_D4_CDATA_MASK 0x7FF
#define ADC_D4_CDATA_BIT 0

#define ADC_D5 (*(volatile unsigned short *)0xFFFFF864)
#define ADC_D5_CDATA_MASK 0x7FF
#define ADC_D5_CDATA_BIT 0

#define ADC_D6 (*(volatile unsigned short *)0xFFFFF868)
#define ADC_D6_CDATA_MASK 0x7FF
#define ADC_D6_CDATA_BIT 0

#define ADC_D7 (*(volatile unsigned short *)0xFFFFF86C)
#define ADC_D7_CDATA_MASK 0x7FF
#define ADC_D7_CDATA_BIT 0

#define ADC_D8 (*(volatile unsigned short *)0xFFFFF870)
#define ADC_D8_CDATA_MASK 0x7FF
#define ADC_D8_CDATA_BIT 0

#define ADC_D9 (*(volatile unsigned short *)0xFFFFF874)
#define ADC_D9_CDATA_MASK 0x7FF
#define ADC_D9_CDATA_BIT 0

#define ADC_D10 (*(volatile unsigned short *)0xFFFFF878)
#define ADC_D10_CDATA_MASK 0x7FF
#define ADC_D10_CDATA_BIT 0

#define ADC_D11 (*(volatile unsigned short *)0xFFFFF87C)
#define ADC_D11_CDATA_MASK 0x7FF
#define ADC_D11_CDATA_BIT 0

#define ADC_D12 (*(volatile unsigned short *)0xFFFFF880)
#define ADC_D12_CDATA_MASK 0x7FF
#define ADC_D12_CDATA_BIT 0

#define ADC_D13 (*(volatile unsigned short *)0xFFFFF884)
#define ADC_D13_CDATA_MASK 0x7FF
#define ADC_D13_CDATA_BIT 0

#define ADC_D14 (*(volatile unsigned short *)0xFFFFF888)
#define ADC_D14_CDATA_MASK 0x7FF
#define ADC_D14_CDATA_BIT 0

#define ADC_D15 (*(volatile unsigned short *)0xFFFFF88C)
#define ADC_D15_CDATA_MASK 0x7FF
#define ADC_D15_CDATA_BIT 0

#define EIC_ICR (*(volatile unsigned long *)0xFFFFFC00)
#define EIC_ICR_IRQ_EN_MASK 0x1
#define EIC_ICR_IRQ_EN 0x1
#define EIC_ICR_IRQ_EN_BIT 0
#define EIC_ICR_FIQ_EN_MASK 0x2
#define EIC_ICR_FIQ_EN 0x2
#define EIC_ICR_FIQ_EN_BIT 1

#define EIC_CICR (*(volatile unsigned long *)0xFFFFFC04)

#define EIC_CIPR (*(volatile unsigned long *)0xFFFFFC08)

#define EIC_FEIR (*(volatile unsigned long *)0xFFFFFC10)

#define EIC_FEIR (*(volatile unsigned long *)0xFFFFFC14)

#define EIC_IVR (*(volatile unsigned long *)0xFFFFFC18)
#define EIC_IVR_Jump_Offset_MASK 0xFFFF
#define EIC_IVR_Jump_Offset_BIT 0
#define EIC_IVR_Jump_Opcode_Or_Base_Address_MASK 0xFFFF0000
#define EIC_IVR_Jump_Opcode_Or_Base_Address_BIT 16

#define EIC_FIR (*(volatile unsigned long *)0xFFFFFC1C)

#define EIC_IER0 (*(volatile unsigned long *)0xFFFFFC20)

#define EIC_IER1 (*(volatile unsigned long *)0xFFFFFC24)

#define EIC_IPR0 (*(volatile unsigned long *)0xFFFFFC40)

#define EIC_IPR1 (*(volatile unsigned long *)0xFFFFFC44)

#define EIC_SIR0 (*(volatile unsigned long *)0xFFFFFC60)
#define EIC_SIR0_SIPL0_MASK 0xF
#define EIC_SIR0_SIPL0_BIT 0
#define EIC_SIR0_SIV0_MASK 0xFFFF0000
#define EIC_SIR0_SIV0_BIT 16

#define EIC_SIR1 (*(volatile unsigned long *)0xFFFFFC64)
#define EIC_SIR1_SIPL1_MASK 0xF
#define EIC_SIR1_SIPL1_BIT 0
#define EIC_SIR1_SIV1_MASK 0xFFFF0000
#define EIC_SIR1_SIV1_BIT 16

#define EIC_SIR2 (*(volatile unsigned long *)0xFFFFFC68)
#define EIC_SIR2_SIPL2_MASK 0xF
#define EIC_SIR2_SIPL2_BIT 0
#define EIC_SIR2_SIV2_MASK 0xFFFF0000
#define EIC_SIR2_SIV2_BIT 16

#define EIC_SIR3 (*(volatile unsigned long *)0xFFFFFC6C)
#define EIC_SIR3_SIPL3_MASK 0xF
#define EIC_SIR3_SIPL3_BIT 0
#define EIC_SIR3_SIV3_MASK 0xFFFF0000
#define EIC_SIR3_SIV3_BIT 16

#define EIC_SIR4 (*(volatile unsigned long *)0xFFFFFC70)
#define EIC_SIR4_SIPL4_MASK 0xF
#define EIC_SIR4_SIPL4_BIT 0
#define EIC_SIR4_SIV4_MASK 0xFFFF0000
#define EIC_SIR4_SIV4_BIT 16

#define EIC_SIR5 (*(volatile unsigned long *)0xFFFFFC74)
#define EIC_SIR5_SIPL5_MASK 0xF
#define EIC_SIR5_SIPL5_BIT 0
#define EIC_SIR5_SIV5_MASK 0xFFFF0000
#define EIC_SIR5_SIV5_BIT 16

#define EIC_SIR6 (*(volatile unsigned long *)0xFFFFFC78)
#define EIC_SIR6_SIPL6_MASK 0xF
#define EIC_SIR6_SIPL6_BIT 0
#define EIC_SIR6_SIV6_MASK 0xFFFF0000
#define EIC_SIR6_SIV6_BIT 16

#define EIC_SIR7 (*(volatile unsigned long *)0xFFFFFC7C)
#define EIC_SIR7_SIPL7_MASK 0xF
#define EIC_SIR7_SIPL7_BIT 0
#define EIC_SIR7_SIV7_MASK 0xFFFF0000
#define EIC_SIR7_SIV7_BIT 16

#define EIC_SIR8 (*(volatile unsigned long *)0xFFFFFC80)
#define EIC_SIR8_SIPL8_MASK 0xF
#define EIC_SIR8_SIPL8_BIT 0
#define EIC_SIR8_SIV8_MASK 0xFFFF0000
#define EIC_SIR8_SIV8_BIT 16

#define EIC_SIR9 (*(volatile unsigned long *)0xFFFFFC84)
#define EIC_SIR9_SIPL9_MASK 0xF
#define EIC_SIR9_SIPL9_BIT 0
#define EIC_SIR9_SIV9_MASK 0xFFFF0000
#define EIC_SIR9_SIV9_BIT 16

#define EIC_SIR10 (*(volatile unsigned long *)0xFFFFFC88)
#define EIC_SIR10_SIPL10_MASK 0xF
#define EIC_SIR10_SIPL10_BIT 0
#define EIC_SIR10_SIV10_MASK 0xFFFF0000
#define EIC_SIR10_SIV10_BIT 16

#define EIC_SIR11 (*(volatile unsigned long *)0xFFFFFC8C)
#define EIC_SIR11_SIPL11_MASK 0xF
#define EIC_SIR11_SIPL11_BIT 0
#define EIC_SIR11_SIV11_MASK 0xFFFF0000
#define EIC_SIR11_SIV11_BIT 16

#define EIC_SIR12 (*(volatile unsigned long *)0xFFFFFC90)
#define EIC_SIR12_SIPL12_MASK 0xF
#define EIC_SIR12_SIPL12_BIT 0
#define EIC_SIR12_SIV12_MASK 0xFFFF0000
#define EIC_SIR12_SIV12_BIT 16

#define EIC_SIR13 (*(volatile unsigned long *)0xFFFFFC94)
#define EIC_SIR13_SIPL13_MASK 0xF
#define EIC_SIR13_SIPL13_BIT 0
#define EIC_SIR13_SIV13_MASK 0xFFFF0000
#define EIC_SIR13_SIV13_BIT 16

#define EIC_SIR14 (*(volatile unsigned long *)0xFFFFFC98)
#define EIC_SIR14_SIPL14_MASK 0xF
#define EIC_SIR14_SIPL14_BIT 0
#define EIC_SIR14_SIV14_MASK 0xFFFF0000
#define EIC_SIR14_SIV14_BIT 16

#define EIC_SIR15 (*(volatile unsigned long *)0xFFFFFC9C)
#define EIC_SIR15_SIPL15_MASK 0xF
#define EIC_SIR15_SIPL15_BIT 0
#define EIC_SIR15_SIV15_MASK 0xFFFF0000
#define EIC_SIR15_SIV15_BIT 16

#define EIC_SIR16 (*(volatile unsigned long *)0xFFFFFCA0)
#define EIC_SIR16_SIPL16_MASK 0xF
#define EIC_SIR16_SIPL16_BIT 0
#define EIC_SIR16_SIV16_MASK 0xFFFF0000
#define EIC_SIR16_SIV16_BIT 16

#define EIC_SIR17 (*(volatile unsigned long *)0xFFFFFCA4)
#define EIC_SIR17_SIPL17_MASK 0xF
#define EIC_SIR17_SIPL17_BIT 0
#define EIC_SIR17_SIV17_MASK 0xFFFF0000
#define EIC_SIR17_SIV17_BIT 16

#define EIC_SIR18 (*(volatile unsigned long *)0xFFFFFCA8)
#define EIC_SIR18_SIPL18_MASK 0xF
#define EIC_SIR18_SIPL18_BIT 0
#define EIC_SIR18_SIV18_MASK 0xFFFF0000
#define EIC_SIR18_SIV18_BIT 16

#define EIC_SIR19 (*(volatile unsigned long *)0xFFFFFCAC)
#define EIC_SIR19_SIPL19_MASK 0xF
#define EIC_SIR19_SIPL19_BIT 0
#define EIC_SIR19_SIV19_MASK 0xFFFF0000
#define EIC_SIR19_SIV19_BIT 16

#define EIC_SIR20 (*(volatile unsigned long *)0xFFFFFCB0)
#define EIC_SIR20_SIPL20_MASK 0xF
#define EIC_SIR20_SIPL20_BIT 0
#define EIC_SIR20_SIV20_MASK 0xFFFF0000
#define EIC_SIR20_SIV20_BIT 16

#define EIC_SIR21 (*(volatile unsigned long *)0xFFFFFCB4)
#define EIC_SIR21_SIPL21_MASK 0xF
#define EIC_SIR21_SIPL21_BIT 0
#define EIC_SIR21_SIV21_MASK 0xFFFF0000
#define EIC_SIR21_SIV21_BIT 16

#define EIC_SIR22 (*(volatile unsigned long *)0xFFFFFCB8)
#define EIC_SIR22_SIPL22_MASK 0xF
#define EIC_SIR22_SIPL22_BIT 0
#define EIC_SIR22_SIV22_MASK 0xFFFF0000
#define EIC_SIR22_SIV22_BIT 16

#define EIC_SIR23 (*(volatile unsigned long *)0xFFFFFCBC)
#define EIC_SIR23_SIPL23_MASK 0xF
#define EIC_SIR23_SIPL23_BIT 0
#define EIC_SIR23_SIV23_MASK 0xFFFF0000
#define EIC_SIR23_SIV23_BIT 16

#define EIC_SIR24 (*(volatile unsigned long *)0xFFFFFCC0)
#define EIC_SIR24_SIPL24_MASK 0xF
#define EIC_SIR24_SIPL24_BIT 0
#define EIC_SIR24_SIV24_MASK 0xFFFF0000
#define EIC_SIR24_SIV24_BIT 16

#define EIC_SIR25 (*(volatile unsigned long *)0xFFFFFCC4)
#define EIC_SIR25_SIPL25_MASK 0xF
#define EIC_SIR25_SIPL25_BIT 0
#define EIC_SIR25_SIV25_MASK 0xFFFF0000
#define EIC_SIR25_SIV25_BIT 16

#define EIC_SIR26 (*(volatile unsigned long *)0xFFFFFCC8)
#define EIC_SIR26_SIPL26_MASK 0xF
#define EIC_SIR26_SIPL26_BIT 0
#define EIC_SIR26_SIV26_MASK 0xFFFF0000
#define EIC_SIR26_SIV26_BIT 16

#define EIC_SIR27 (*(volatile unsigned long *)0xFFFFFCCC)
#define EIC_SIR27_SIPL27_MASK 0xF
#define EIC_SIR27_SIPL27_BIT 0
#define EIC_SIR27_SIV27_MASK 0xFFFF0000
#define EIC_SIR27_SIV27_BIT 16

#define EIC_SIR28 (*(volatile unsigned long *)0xFFFFFCD0)
#define EIC_SIR28_SIPL28_MASK 0xF
#define EIC_SIR28_SIPL28_BIT 0
#define EIC_SIR28_SIV28_MASK 0xFFFF0000
#define EIC_SIR28_SIV28_BIT 16

#define EIC_SIR29 (*(volatile unsigned long *)0xFFFFFCD4)
#define EIC_SIR29_SIPL29_MASK 0xF
#define EIC_SIR29_SIPL29_BIT 0
#define EIC_SIR29_SIV29_MASK 0xFFFF0000
#define EIC_SIR29_SIV29_BIT 16

#define EIC_SIR30 (*(volatile unsigned long *)0xFFFFFCD8)
#define EIC_SIR30_SIPL30_MASK 0xF
#define EIC_SIR30_SIPL30_BIT 0
#define EIC_SIR30_SIV30_MASK 0xFFFF0000
#define EIC_SIR30_SIV30_BIT 16

#define EIC_SIR31 (*(volatile unsigned long *)0xFFFFFCDC)
#define EIC_SIR31_SIPL31_MASK 0xF
#define EIC_SIR31_SIPL31_BIT 0
#define EIC_SIR31_SIV31_MASK 0xFFFF0000
#define EIC_SIR31_SIV31_BIT 16

#define EIC_SIR32 (*(volatile unsigned long *)0xFFFFFCE0)
#define EIC_SIR32_SIPL32_MASK 0xF
#define EIC_SIR32_SIPL32_BIT 0
#define EIC_SIR32_SIV32_MASK 0xFFFF0000
#define EIC_SIR32_SIV32_BIT 16

#define EIC_SIR33 (*(volatile unsigned long *)0xFFFFFCE4)
#define EIC_SIR33_SIPL33_MASK 0xF
#define EIC_SIR33_SIPL33_BIT 0
#define EIC_SIR33_SIV33_MASK 0xFFFF0000
#define EIC_SIR33_SIV33_BIT 16

#define EIC_SIR34 (*(volatile unsigned long *)0xFFFFFCE8)
#define EIC_SIR34_SIPL34_MASK 0xF
#define EIC_SIR34_SIPL34_BIT 0
#define EIC_SIR34_SIV34_MASK 0xFFFF0000
#define EIC_SIR34_SIV34_BIT 16

#define EIC_SIR35 (*(volatile unsigned long *)0xFFFFFCEC)
#define EIC_SIR35_SIPL35_MASK 0xF
#define EIC_SIR35_SIPL35_BIT 0
#define EIC_SIR35_SIV35_MASK 0xFFFF0000
#define EIC_SIR35_SIV35_BIT 16

#define EIC_SIR36 (*(volatile unsigned long *)0xFFFFFCF0)
#define EIC_SIR36_SIPL36_MASK 0xF
#define EIC_SIR36_SIPL36_BIT 0
#define EIC_SIR36_SIV36_MASK 0xFFFF0000
#define EIC_SIR36_SIV36_BIT 16

#define EIC_SIR37 (*(volatile unsigned long *)0xFFFFFCF4)
#define EIC_SIR37_SIPL37_MASK 0xF
#define EIC_SIR37_SIPL37_BIT 0
#define EIC_SIR37_SIV37_MASK 0xFFFF0000
#define EIC_SIR37_SIV37_BIT 16

#define EIC_SIR38 (*(volatile unsigned long *)0xFFFFFCF8)
#define EIC_SIR38_SIPL38_MASK 0xF
#define EIC_SIR38_SIPL38_BIT 0
#define EIC_SIR38_SIV38_MASK 0xFFFF0000
#define EIC_SIR38_SIV38_BIT 16

#define EIC_SIR39 (*(volatile unsigned long *)0xFFFFFCFC)
#define EIC_SIR39_SIPL39_MASK 0xF
#define EIC_SIR39_SIPL39_BIT 0
#define EIC_SIR39_SIV39_MASK 0xFFFF0000
#define EIC_SIR39_SIV39_BIT 16

#define EIC_SIR40 (*(volatile unsigned long *)0xFFFFFD00)
#define EIC_SIR40_SIPL40_MASK 0xF
#define EIC_SIR40_SIPL40_BIT 0
#define EIC_SIR40_SIV40_MASK 0xFFFF0000
#define EIC_SIR40_SIV40_BIT 16

#define EIC_SIR41 (*(volatile unsigned long *)0xFFFFFD04)
#define EIC_SIR41_SIPL41_MASK 0xF
#define EIC_SIR41_SIPL41_BIT 0
#define EIC_SIR41_SIV41_MASK 0xFFFF0000
#define EIC_SIR41_SIV41_BIT 16

#define EIC_SIR42 (*(volatile unsigned long *)0xFFFFFD08)
#define EIC_SIR42_SIPL42_MASK 0xF
#define EIC_SIR42_SIPL42_BIT 0
#define EIC_SIR42_SIV42_MASK 0xFFFF0000
#define EIC_SIR42_SIV42_BIT 16

#define EIC_SIR43 (*(volatile unsigned long *)0xFFFFFD0C)
#define EIC_SIR43_SIPL43_MASK 0xF
#define EIC_SIR43_SIPL43_BIT 0
#define EIC_SIR43_SIV43_MASK 0xFFFF0000
#define EIC_SIR43_SIV43_BIT 16

#define EIC_SIR44 (*(volatile unsigned long *)0xFFFFFD10)
#define EIC_SIR44_SIPL44_MASK 0xF
#define EIC_SIR44_SIPL44_BIT 0
#define EIC_SIR44_SIV44_MASK 0xFFFF0000
#define EIC_SIR44_SIV44_BIT 16

#define EIC_SIR45 (*(volatile unsigned long *)0xFFFFFD14)
#define EIC_SIR45_SIPL45_MASK 0xF
#define EIC_SIR45_SIPL45_BIT 0
#define EIC_SIR45_SIV45_MASK 0xFFFF0000
#define EIC_SIR45_SIV45_BIT 16

#define EIC_SIR46 (*(volatile unsigned long *)0xFFFFFD18)
#define EIC_SIR46_SIPL118_MASK 0xF
#define EIC_SIR46_SIPL118_BIT 0
#define EIC_SIR46_SIV118_MASK 0xFFFF0000
#define EIC_SIR46_SIV118_BIT 16

#define EIC_SIR47 (*(volatile unsigned long *)0xFFFFFD1C)
#define EIC_SIR47_SIPL11C_MASK 0xF
#define EIC_SIR47_SIPL11C_BIT 0
#define EIC_SIR47_SIV11C_MASK 0xFFFF0000
#define EIC_SIR47_SIV11C_BIT 16

#define EIC_SIR48 (*(volatile unsigned long *)0xFFFFFD20)
#define EIC_SIR48_SIPL48_MASK 0xF
#define EIC_SIR48_SIPL48_BIT 0
#define EIC_SIR48_SIV48_MASK 0xFFFF0000
#define EIC_SIR48_SIV48_BIT 16

#define EIC_SIR49 (*(volatile unsigned long *)0xFFFFFD24)
#define EIC_SIR49_SIPL49_MASK 0xF
#define EIC_SIR49_SIPL49_BIT 0
#define EIC_SIR49_SIV49_MASK 0xFFFF0000
#define EIC_SIR49_SIV49_BIT 16

#define EIC_SIR50 (*(volatile unsigned long *)0xFFFFFD28)
#define EIC_SIR50_SIPL50_MASK 0xF
#define EIC_SIR50_SIPL50_BIT 0
#define EIC_SIR50_SIV50_MASK 0xFFFF0000
#define EIC_SIR50_SIV50_BIT 16

#define EIC_SIR51 (*(volatile unsigned long *)0xFFFFFD2C)
#define EIC_SIR51_SIPL51_MASK 0xF
#define EIC_SIR51_SIPL51_BIT 0
#define EIC_SIR51_SIV51_MASK 0xFFFF0000
#define EIC_SIR51_SIV51_BIT 16

#define EIC_SIR52 (*(volatile unsigned long *)0xFFFFFD30)
#define EIC_SIR52_SIPL52_MASK 0xF
#define EIC_SIR52_SIPL52_BIT 0
#define EIC_SIR52_SIV52_MASK 0xFFFF0000
#define EIC_SIR52_SIV52_BIT 16

#define EIC_SIR53 (*(volatile unsigned long *)0xFFFFFD34)
#define EIC_SIR53_SIPL53_MASK 0xF
#define EIC_SIR53_SIPL53_BIT 0
#define EIC_SIR53_SIV53_MASK 0xFFFF0000
#define EIC_SIR53_SIV53_BIT 16

#define EIC_SIR54 (*(volatile unsigned long *)0xFFFFFD38)
#define EIC_SIR54_SIPL54_MASK 0xF
#define EIC_SIR54_SIPL54_BIT 0
#define EIC_SIR54_SIV54_MASK 0xFFFF0000
#define EIC_SIR54_SIV54_BIT 16

#define EIC_SIR55 (*(volatile unsigned long *)0xFFFFFD3C)
#define EIC_SIR55_SIPL55_MASK 0xF
#define EIC_SIR55_SIPL55_BIT 0
#define EIC_SIR55_SIV55_MASK 0xFFFF0000
#define EIC_SIR55_SIV55_BIT 16

#define EIC_SIR56 (*(volatile unsigned long *)0xFFFFFD40)
#define EIC_SIR56_SIPL56_MASK 0xF
#define EIC_SIR56_SIPL56_BIT 0
#define EIC_SIR56_SIV56_MASK 0xFFFF0000
#define EIC_SIR56_SIV56_BIT 16

#define EIC_SIR57 (*(volatile unsigned long *)0xFFFFFD44)
#define EIC_SIR57_SIPL57_MASK 0xF
#define EIC_SIR57_SIPL57_BIT 0
#define EIC_SIR57_SIV57_MASK 0xFFFF0000
#define EIC_SIR57_SIV57_BIT 16

#define EIC_SIR58 (*(volatile unsigned long *)0xFFFFFD48)
#define EIC_SIR58_SIPL58_MASK 0xF
#define EIC_SIR58_SIPL58_BIT 0
#define EIC_SIR58_SIV58_MASK 0xFFFF0000
#define EIC_SIR58_SIV58_BIT 16

#define EIC_SIR59 (*(volatile unsigned long *)0xFFFFFD4C)
#define EIC_SIR59_SIPL59_MASK 0xF
#define EIC_SIR59_SIPL59_BIT 0
#define EIC_SIR59_SIV59_MASK 0xFFFF0000
#define EIC_SIR59_SIV59_BIT 16

#define EIC_SIR60 (*(volatile unsigned long *)0xFFFFFD50)
#define EIC_SIR60_SIPL60_MASK 0xF
#define EIC_SIR60_SIPL60_BIT 0
#define EIC_SIR60_SIV60_MASK 0xFFFF0000
#define EIC_SIR60_SIV60_BIT 16

#define EIC_SIR61 (*(volatile unsigned long *)0xFFFFFD54)
#define EIC_SIR61_SIPL61_MASK 0xF
#define EIC_SIR61_SIPL61_BIT 0
#define EIC_SIR61_SIV61_MASK 0xFFFF0000
#define EIC_SIR61_SIV61_BIT 16

#define EIC_SIR62 (*(volatile unsigned long *)0xFFFFFD58)
#define EIC_SIR62_SIPL62_MASK 0xF
#define EIC_SIR62_SIPL62_BIT 0
#define EIC_SIR62_SIV62_MASK 0xFFFF0000
#define EIC_SIR62_SIV62_BIT 16

#define EIC_SIR63 (*(volatile unsigned long *)0xFFFFFD5C)
#define EIC_SIR63_SIPL63_MASK 0xF
#define EIC_SIR63_SIPL63_BIT 0
#define EIC_SIR63_SIV63_MASK 0xFFFF0000
#define EIC_SIR63_SIV63_BIT 16


#endif
