// MC9328MXL register and bit definitions.
//
// Copyright (c) 2006 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef MC9328MXL_h
#define MC9328MXL_h

#define AIPI1_BASE 0x200000

#define AIPI1_PSR0 (*(volatile unsigned *)0x200000)
#define AIPI1_PSR0_OFFSET 0x0

#define AIPI1_PSR1 (*(volatile unsigned *)0x200004)
#define AIPI1_PSR1_OFFSET 0x4

#define AIPI1_PAR (*(volatile unsigned *)0x200008)
#define AIPI1_PAR_OFFSET 0x8

#define AIPI1_PCR (*(volatile unsigned *)0x20000C)
#define AIPI1_PCR_OFFSET 0xC

#define AIPI1_TSR (*(volatile unsigned *)0x200010)
#define AIPI1_TSR_OFFSET 0x10

#define WDT_BASE 0x201000

#define WDT_WCR (*(volatile unsigned *)0x201000)
#define WDT_WCR_OFFSET 0x0

#define WDT_WSR (*(volatile unsigned *)0x201004)
#define WDT_WSR_OFFSET 0x4

#define WDT_WSTR (*(volatile unsigned *)0x201008)
#define WDT_WSTR_OFFSET 0x8

#define TIMER1_BASE 0x202000

#define TIMER1_TCTL (*(volatile unsigned *)0x202000)
#define TIMER1_TCTL_OFFSET 0x0

#define TIMER1_TPRER (*(volatile unsigned *)0x202004)
#define TIMER1_TPRER_OFFSET 0x4

#define TIMER1_TCMP (*(volatile unsigned *)0x202008)
#define TIMER1_TCMP_OFFSET 0x8

#define TIMER1_TCR (*(volatile unsigned *)0x20200C)
#define TIMER1_TCR_OFFSET 0xC

#define TIMER1_TCN (*(volatile unsigned *)0x202010)
#define TIMER1_TCN_OFFSET 0x10

#define TIMER1_TSTAT (*(volatile unsigned *)0x202014)
#define TIMER1_TSTAT_OFFSET 0x14

#define TIMER2_BASE 0x203000

#define TIMER2_TCTL (*(volatile unsigned *)0x203000)
#define TIMER2_TCTL_OFFSET 0x0

#define TIMER2_TPRER (*(volatile unsigned *)0x203004)
#define TIMER2_TPRER_OFFSET 0x4

#define TIMER2_TCMP (*(volatile unsigned *)0x203008)
#define TIMER2_TCMP_OFFSET 0x8

#define TIMER2_TCR (*(volatile unsigned *)0x20300C)
#define TIMER2_TCR_OFFSET 0xC

#define TIMER2_TCN (*(volatile unsigned *)0x203010)
#define TIMER2_TCN_OFFSET 0x10

#define TIMER2_TSTAT (*(volatile unsigned *)0x203014)
#define TIMER2_TSTAT_OFFSET 0x14

#define RTC_BASE 0x204000

#define RTC_HOURMIN (*(volatile unsigned *)0x204000)
#define RTC_HOURMIN_OFFSET 0x0

#define RTC_SECONDS (*(volatile unsigned *)0x204004)
#define RTC_SECONDS_OFFSET 0x4

#define RTC_ALRM_HM (*(volatile unsigned *)0x204008)
#define RTC_ALRM_HM_OFFSET 0x8

#define RTC_ALRM_SEC (*(volatile unsigned *)0x20400C)
#define RTC_ALRM_SEC_OFFSET 0xC

#define RTC_RCCTL (*(volatile unsigned *)0x204010)
#define RTC_RCCTL_OFFSET 0x10

#define RTC_RTCISR (*(volatile unsigned *)0x204014)
#define RTC_RTCISR_OFFSET 0x14

#define RTC_RTCIENR (*(volatile unsigned *)0x204018)
#define RTC_RTCIENR_OFFSET 0x18

#define RTC_STPWCH (*(volatile unsigned *)0x20401C)
#define RTC_STPWCH_OFFSET 0x1C

#define RTC_DAYR (*(volatile unsigned *)0x204020)
#define RTC_DAYR_OFFSET 0x20

#define RTC_DAYALARM (*(volatile unsigned *)0x204024)
#define RTC_DAYALARM_OFFSET 0x24

#define LCDC_BASE 0x205000

#define LCDC_SSA (*(volatile unsigned *)0x205000)
#define LCDC_SSA_OFFSET 0x0

#define LCDC_SIZE (*(volatile unsigned *)0x205004)
#define LCDC_SIZE_OFFSET 0x4

#define LCDC_VPW (*(volatile unsigned *)0x205008)
#define LCDC_VPW_OFFSET 0x8

#define LCDC_CPOS (*(volatile unsigned *)0x20500C)
#define LCDC_CPOS_OFFSET 0xC

#define LCDC_LCWHB (*(volatile unsigned *)0x205010)
#define LCDC_LCWHB_OFFSET 0x10

#define LCDC_LCHCC (*(volatile unsigned *)0x205014)
#define LCDC_LCHCC_OFFSET 0x14

#define LCDC_PCR (*(volatile unsigned *)0x205018)
#define LCDC_PCR_OFFSET 0x18

#define LCDC_HCR (*(volatile unsigned *)0x20501C)
#define LCDC_HCR_OFFSET 0x1C

#define LCDC_VCR (*(volatile unsigned *)0x205020)
#define LCDC_VCR_OFFSET 0x20

#define LCDC_POS (*(volatile unsigned *)0x205024)
#define LCDC_POS_OFFSET 0x24

#define LCDC_LSCR1 (*(volatile unsigned *)0x205028)
#define LCDC_LSCR1_OFFSET 0x28

#define LCDC_PWMR (*(volatile unsigned *)0x20502C)
#define LCDC_PWMR_OFFSET 0x2C

#define LCDC_DMACR (*(volatile unsigned *)0x205030)
#define LCDC_DMACR_OFFSET 0x30

#define LCDC_RMCR (*(volatile unsigned *)0x205034)
#define LCDC_RMCR_OFFSET 0x34

#define LCDC_LCDICR (*(volatile unsigned *)0x205038)
#define LCDC_LCDICR_OFFSET 0x38

#define LCDC_LCDISR (*(volatile unsigned *)0x205040)
#define LCDC_LCDISR_OFFSET 0x40

#define UART1_BASE 0x206000

#define UART1_RX0D (*(volatile unsigned *)0x206000)
#define UART1_RX0D_OFFSET 0x0

#define UART1_RX1D (*(volatile unsigned *)0x206004)
#define UART1_RX1D_OFFSET 0x4

#define UART1_RX2D (*(volatile unsigned *)0x206008)
#define UART1_RX2D_OFFSET 0x8

#define UART1_RX3D (*(volatile unsigned *)0x20600C)
#define UART1_RX3D_OFFSET 0xC

#define UART1_RX4D (*(volatile unsigned *)0x206010)
#define UART1_RX4D_OFFSET 0x10

#define UART1_RX5D (*(volatile unsigned *)0x206014)
#define UART1_RX5D_OFFSET 0x14

#define UART1_RX6D (*(volatile unsigned *)0x206018)
#define UART1_RX6D_OFFSET 0x18

#define UART1_RX7D (*(volatile unsigned *)0x20601C)
#define UART1_RX7D_OFFSET 0x1C

#define UART1_RX8D (*(volatile unsigned *)0x206020)
#define UART1_RX8D_OFFSET 0x20

#define UART1_RX9D (*(volatile unsigned *)0x206024)
#define UART1_RX9D_OFFSET 0x24

#define UART1_RX10D (*(volatile unsigned *)0x206028)
#define UART1_RX10D_OFFSET 0x28

#define UART1_RX11D (*(volatile unsigned *)0x20602C)
#define UART1_RX11D_OFFSET 0x2C

#define UART1_RX12D (*(volatile unsigned *)0x206030)
#define UART1_RX12D_OFFSET 0x30

#define UART1_RX13D (*(volatile unsigned *)0x206034)
#define UART1_RX13D_OFFSET 0x34

#define UART1_RX14D (*(volatile unsigned *)0x206038)
#define UART1_RX14D_OFFSET 0x38

#define UART1_RX15D (*(volatile unsigned *)0x20603C)
#define UART1_RX15D_OFFSET 0x3C

#define UART1_TX0D (*(volatile unsigned *)0x206040)
#define UART1_TX0D_OFFSET 0x40

#define UART1_TX1D (*(volatile unsigned *)0x206044)
#define UART1_TX1D_OFFSET 0x44

#define UART1_TX2D (*(volatile unsigned *)0x206048)
#define UART1_TX2D_OFFSET 0x48

#define UART1_TX3D (*(volatile unsigned *)0x20604C)
#define UART1_TX3D_OFFSET 0x4C

#define UART1_TX4D (*(volatile unsigned *)0x206050)
#define UART1_TX4D_OFFSET 0x50

#define UART1_TX5D (*(volatile unsigned *)0x206054)
#define UART1_TX5D_OFFSET 0x54

#define UART1_TX6D (*(volatile unsigned *)0x206058)
#define UART1_TX6D_OFFSET 0x58

#define UART1_TX7D (*(volatile unsigned *)0x20605C)
#define UART1_TX7D_OFFSET 0x5C

#define UART1_TX8D (*(volatile unsigned *)0x206060)
#define UART1_TX8D_OFFSET 0x60

#define UART1_TX9D (*(volatile unsigned *)0x206064)
#define UART1_TX9D_OFFSET 0x64

#define UART1_TX10D (*(volatile unsigned *)0x206068)
#define UART1_TX10D_OFFSET 0x68

#define UART1_TX11D (*(volatile unsigned *)0x20606C)
#define UART1_TX11D_OFFSET 0x6C

#define UART1_TX12D (*(volatile unsigned *)0x206070)
#define UART1_TX12D_OFFSET 0x70

#define UART1_TX13D (*(volatile unsigned *)0x206074)
#define UART1_TX13D_OFFSET 0x74

#define UART1_TX14D (*(volatile unsigned *)0x206078)
#define UART1_TX14D_OFFSET 0x78

#define UART1_TX15D (*(volatile unsigned *)0x20607C)
#define UART1_TX15D_OFFSET 0x7C

#define UART1_CR1 (*(volatile unsigned *)0x206080)
#define UART1_CR1_OFFSET 0x80

#define UART1_CR2 (*(volatile unsigned *)0x206084)
#define UART1_CR2_OFFSET 0x84

#define UART1_CR3 (*(volatile unsigned *)0x206088)
#define UART1_CR3_OFFSET 0x88

#define UART1_CR4 (*(volatile unsigned *)0x20608C)
#define UART1_CR4_OFFSET 0x8C

#define UART1_FCR (*(volatile unsigned *)0x206090)
#define UART1_FCR_OFFSET 0x90

#define UART1_SR1 (*(volatile unsigned *)0x206094)
#define UART1_SR1_OFFSET 0x94

#define UART1_SR2 (*(volatile unsigned *)0x206098)
#define UART1_SR2_OFFSET 0x98

#define UART1_ESC (*(volatile unsigned *)0x20609C)
#define UART1_ESC_OFFSET 0x9C

#define UART1_TIM (*(volatile unsigned *)0x2060A0)
#define UART1_TIM_OFFSET 0xA0

#define UART1_BIR (*(volatile unsigned *)0x2060A4)
#define UART1_BIR_OFFSET 0xA4

#define UART1_BMR (*(volatile unsigned *)0x2060A8)
#define UART1_BMR_OFFSET 0xA8

#define UART1_BRC (*(volatile unsigned *)0x2060AC)
#define UART1_BRC_OFFSET 0xAC

#define UART1_BIPR1 (*(volatile unsigned *)0x2060B0)
#define UART1_BIPR1_OFFSET 0xB0

#define UART1_BIPR2 (*(volatile unsigned *)0x2060B4)
#define UART1_BIPR2_OFFSET 0xB4

#define UART1_BIPR3 (*(volatile unsigned *)0x2060B8)
#define UART1_BIPR3_OFFSET 0xB8

#define UART1_BIPR4 (*(volatile unsigned *)0x2060BC)
#define UART1_BIPR4_OFFSET 0xBC

#define UART1_BMPR1 (*(volatile unsigned *)0x2060C0)
#define UART1_BMPR1_OFFSET 0xC0

#define UART1_BMPR2 (*(volatile unsigned *)0x2060C4)
#define UART1_BMPR2_OFFSET 0xC4

#define UART1_BMPR3 (*(volatile unsigned *)0x2060C8)
#define UART1_BMPR3_OFFSET 0xC8

#define UART1_BMPR4 (*(volatile unsigned *)0x2060CC)
#define UART1_BMPR4_OFFSET 0xCC

#define UART1_TS (*(volatile unsigned *)0x2060D0)
#define UART1_TS_OFFSET 0xD0

#define UART2_BASE 0x207000

#define UART2_RX0D (*(volatile unsigned *)0x207000)
#define UART2_RX0D_OFFSET 0x0

#define UART2_RX1D (*(volatile unsigned *)0x207004)
#define UART2_RX1D_OFFSET 0x4

#define UART2_RX2D (*(volatile unsigned *)0x207008)
#define UART2_RX2D_OFFSET 0x8

#define UART2_RX3D (*(volatile unsigned *)0x20700C)
#define UART2_RX3D_OFFSET 0xC

#define UART2_RX4D (*(volatile unsigned *)0x207010)
#define UART2_RX4D_OFFSET 0x10

#define UART2_RX5D (*(volatile unsigned *)0x207014)
#define UART2_RX5D_OFFSET 0x14

#define UART2_RX6D (*(volatile unsigned *)0x207018)
#define UART2_RX6D_OFFSET 0x18

#define UART2_RX7D (*(volatile unsigned *)0x20701C)
#define UART2_RX7D_OFFSET 0x1C

#define UART2_RX8D (*(volatile unsigned *)0x207020)
#define UART2_RX8D_OFFSET 0x20

#define UART2_RX9D (*(volatile unsigned *)0x207024)
#define UART2_RX9D_OFFSET 0x24

#define UART2_RX10D (*(volatile unsigned *)0x207028)
#define UART2_RX10D_OFFSET 0x28

#define UART2_RX11D (*(volatile unsigned *)0x20702C)
#define UART2_RX11D_OFFSET 0x2C

#define UART2_RX12D (*(volatile unsigned *)0x207030)
#define UART2_RX12D_OFFSET 0x30

#define UART2_RX13D (*(volatile unsigned *)0x207034)
#define UART2_RX13D_OFFSET 0x34

#define UART2_RX14D (*(volatile unsigned *)0x207038)
#define UART2_RX14D_OFFSET 0x38

#define UART2_RX15D (*(volatile unsigned *)0x20703C)
#define UART2_RX15D_OFFSET 0x3C

#define UART2_TX0D (*(volatile unsigned *)0x207040)
#define UART2_TX0D_OFFSET 0x40

#define UART2_TX1D (*(volatile unsigned *)0x207044)
#define UART2_TX1D_OFFSET 0x44

#define UART2_TX2D (*(volatile unsigned *)0x207048)
#define UART2_TX2D_OFFSET 0x48

#define UART2_TX3D (*(volatile unsigned *)0x20704C)
#define UART2_TX3D_OFFSET 0x4C

#define UART2_TX4D (*(volatile unsigned *)0x207050)
#define UART2_TX4D_OFFSET 0x50

#define UART2_TX5D (*(volatile unsigned *)0x207054)
#define UART2_TX5D_OFFSET 0x54

#define UART2_TX6D (*(volatile unsigned *)0x207058)
#define UART2_TX6D_OFFSET 0x58

#define UART2_TX7D (*(volatile unsigned *)0x20705C)
#define UART2_TX7D_OFFSET 0x5C

#define UART2_TX8D (*(volatile unsigned *)0x207060)
#define UART2_TX8D_OFFSET 0x60

#define UART2_TX9D (*(volatile unsigned *)0x207064)
#define UART2_TX9D_OFFSET 0x64

#define UART2_TX10D (*(volatile unsigned *)0x207068)
#define UART2_TX10D_OFFSET 0x68

#define UART2_TX11D (*(volatile unsigned *)0x20706C)
#define UART2_TX11D_OFFSET 0x6C

#define UART2_TX12D (*(volatile unsigned *)0x207070)
#define UART2_TX12D_OFFSET 0x70

#define UART2_TX13D (*(volatile unsigned *)0x207074)
#define UART2_TX13D_OFFSET 0x74

#define UART2_TX14D (*(volatile unsigned *)0x207078)
#define UART2_TX14D_OFFSET 0x78

#define UART2_TX15D (*(volatile unsigned *)0x20707C)
#define UART2_TX15D_OFFSET 0x7C

#define UART2_CR1 (*(volatile unsigned *)0x207080)
#define UART2_CR1_OFFSET 0x80

#define UART2_CR2 (*(volatile unsigned *)0x207084)
#define UART2_CR2_OFFSET 0x84

#define UART2_CR3 (*(volatile unsigned *)0x207088)
#define UART2_CR3_OFFSET 0x88

#define UART2_CR4 (*(volatile unsigned *)0x20708C)
#define UART2_CR4_OFFSET 0x8C

#define UART2_FCR (*(volatile unsigned *)0x207090)
#define UART2_FCR_OFFSET 0x90

#define UART2_SR1 (*(volatile unsigned *)0x207094)
#define UART2_SR1_OFFSET 0x94

#define UART2_SR2 (*(volatile unsigned *)0x207098)
#define UART2_SR2_OFFSET 0x98

#define UART2_ESC (*(volatile unsigned *)0x20709C)
#define UART2_ESC_OFFSET 0x9C

#define UART2_TIM (*(volatile unsigned *)0x2070A0)
#define UART2_TIM_OFFSET 0xA0

#define UART2_BIR (*(volatile unsigned *)0x2070A4)
#define UART2_BIR_OFFSET 0xA4

#define UART2_BMR (*(volatile unsigned *)0x2070A8)
#define UART2_BMR_OFFSET 0xA8

#define UART2_BRC (*(volatile unsigned *)0x2070AC)
#define UART2_BRC_OFFSET 0xAC

#define UART2_BIPR1 (*(volatile unsigned *)0x2070B0)
#define UART2_BIPR1_OFFSET 0xB0

#define UART2_BIPR2 (*(volatile unsigned *)0x2070B4)
#define UART2_BIPR2_OFFSET 0xB4

#define UART2_BIPR3 (*(volatile unsigned *)0x2070B8)
#define UART2_BIPR3_OFFSET 0xB8

#define UART2_BIPR4 (*(volatile unsigned *)0x2070BC)
#define UART2_BIPR4_OFFSET 0xBC

#define UART2_BMPR1 (*(volatile unsigned *)0x2070C0)
#define UART2_BMPR1_OFFSET 0xC0

#define UART2_BMPR2 (*(volatile unsigned *)0x2070C4)
#define UART2_BMPR2_OFFSET 0xC4

#define UART2_BMPR3 (*(volatile unsigned *)0x2070C8)
#define UART2_BMPR3_OFFSET 0xC8

#define UART2_BMPR4 (*(volatile unsigned *)0x2070CC)
#define UART2_BMPR4_OFFSET 0xCC

#define UART2_TS (*(volatile unsigned *)0x2070D0)
#define UART2_TS_OFFSET 0xD0

#define PWM_BASE 0x208000

#define PWM_PWMC (*(volatile unsigned *)0x208000)
#define PWM_PWMC_OFFSET 0x0

#define PWM_PWMS (*(volatile unsigned *)0x208004)
#define PWM_PWMS_OFFSET 0x4

#define PWM_PWMP (*(volatile unsigned *)0x208008)
#define PWM_PWMP_OFFSET 0x8

#define PWM_PWMCNT (*(volatile unsigned *)0x20800C)
#define PWM_PWMCNT_OFFSET 0xC

#define DMAC_BASE 0x209000

#define DMAC_DCR (*(volatile unsigned *)0x209000)
#define DMAC_DCR_OFFSET 0x0

#define DMAC_DISR (*(volatile unsigned *)0x209004)
#define DMAC_DISR_OFFSET 0x4

#define DMAC_DIMR (*(volatile unsigned *)0x209008)
#define DMAC_DIMR_OFFSET 0x8

#define DMAC_DBTOSR (*(volatile unsigned *)0x20900C)
#define DMAC_DBTOSR_OFFSET 0xC

#define DMAC_DRTOSR (*(volatile unsigned *)0x209010)
#define DMAC_DRTOSR_OFFSET 0x10

#define DMAC_DSESR (*(volatile unsigned *)0x209014)
#define DMAC_DSESR_OFFSET 0x14

#define DMAC_DBOSR (*(volatile unsigned *)0x209018)
#define DMAC_DBOSR_OFFSET 0x18

#define DMAC_DBTOCR (*(volatile unsigned *)0x20901C)
#define DMAC_DBTOCR_OFFSET 0x1C

#define DMAC_WSRA (*(volatile unsigned *)0x209040)
#define DMAC_WSRA_OFFSET 0x40

#define DMAC_XSRA (*(volatile unsigned *)0x209044)
#define DMAC_XSRA_OFFSET 0x44

#define DMAC_YSRA (*(volatile unsigned *)0x209048)
#define DMAC_YSRA_OFFSET 0x48

#define DMAC_WSRB (*(volatile unsigned *)0x20904C)
#define DMAC_WSRB_OFFSET 0x4C

#define DMAC_XSRB (*(volatile unsigned *)0x209050)
#define DMAC_XSRB_OFFSET 0x50

#define DMAC_YSRB (*(volatile unsigned *)0x209054)
#define DMAC_YSRB_OFFSET 0x54

#define DMAC_SAR0 (*(volatile unsigned *)0x209080)
#define DMAC_SAR0_OFFSET 0x80

#define DMAC_DAR0 (*(volatile unsigned *)0x209084)
#define DMAC_DAR0_OFFSET 0x84

#define DMAC_CNTR0 (*(volatile unsigned *)0x209088)
#define DMAC_CNTR0_OFFSET 0x88

#define DMAC_CCR0 (*(volatile unsigned *)0x20908C)
#define DMAC_CCR0_OFFSET 0x8C

#define DMAC_RSSR0 (*(volatile unsigned *)0x209090)
#define DMAC_RSSR0_OFFSET 0x90

#define DMAC_BLR0 (*(volatile unsigned *)0x209094)
#define DMAC_BLR0_OFFSET 0x94

#define DMAC_RTOR0 (*(volatile unsigned *)0x209098)
#define DMAC_RTOR0_OFFSET 0x98

#define DMAC_BUCR0 (*(volatile unsigned *)0x209098)
#define DMAC_BUCR0_OFFSET 0x98

#define DMAC_SAR1 (*(volatile unsigned *)0x2090C0)
#define DMAC_SAR1_OFFSET 0xC0

#define DMAC_DAR1 (*(volatile unsigned *)0x2090C4)
#define DMAC_DAR1_OFFSET 0xC4

#define DMAC_CNTR1 (*(volatile unsigned *)0x2090C8)
#define DMAC_CNTR1_OFFSET 0xC8

#define DMAC_CCR1 (*(volatile unsigned *)0x2090CC)
#define DMAC_CCR1_OFFSET 0xCC

#define DMAC_RSSR1 (*(volatile unsigned *)0x2090D0)
#define DMAC_RSSR1_OFFSET 0xD0

#define DMAC_BLR1 (*(volatile unsigned *)0x2090D4)
#define DMAC_BLR1_OFFSET 0xD4

#define DMAC_RTOR1 (*(volatile unsigned *)0x2090D8)
#define DMAC_RTOR1_OFFSET 0xD8

#define DMAC_BUCR1 (*(volatile unsigned *)0x2090D8)
#define DMAC_BUCR1_OFFSET 0xD8

#define DMAC_SAR2 (*(volatile unsigned *)0x209100)
#define DMAC_SAR2_OFFSET 0x100

#define DMAC_DAR2 (*(volatile unsigned *)0x209104)
#define DMAC_DAR2_OFFSET 0x104

#define DMAC_CNTR2 (*(volatile unsigned *)0x209108)
#define DMAC_CNTR2_OFFSET 0x108

#define DMAC_CCR2 (*(volatile unsigned *)0x20910C)
#define DMAC_CCR2_OFFSET 0x10C

#define DMAC_RSSR2 (*(volatile unsigned *)0x209110)
#define DMAC_RSSR2_OFFSET 0x110

#define DMAC_BLR2 (*(volatile unsigned *)0x209114)
#define DMAC_BLR2_OFFSET 0x114

#define DMAC_RTOR2 (*(volatile unsigned *)0x209118)
#define DMAC_RTOR2_OFFSET 0x118

#define DMAC_BUCR2 (*(volatile unsigned *)0x209118)
#define DMAC_BUCR2_OFFSET 0x118

#define DMAC_SAR3 (*(volatile unsigned *)0x209140)
#define DMAC_SAR3_OFFSET 0x140

#define DMAC_DAR3 (*(volatile unsigned *)0x209144)
#define DMAC_DAR3_OFFSET 0x144

#define DMAC_CNTR3 (*(volatile unsigned *)0x209148)
#define DMAC_CNTR3_OFFSET 0x148

#define DMAC_CCR3 (*(volatile unsigned *)0x20914C)
#define DMAC_CCR3_OFFSET 0x14C

#define DMAC_RSSR3 (*(volatile unsigned *)0x209150)
#define DMAC_RSSR3_OFFSET 0x150

#define DMAC_BLR3 (*(volatile unsigned *)0x209154)
#define DMAC_BLR3_OFFSET 0x154

#define DMAC_RTOR3 (*(volatile unsigned *)0x209158)
#define DMAC_RTOR3_OFFSET 0x158

#define DMAC_BUCR3 (*(volatile unsigned *)0x209158)
#define DMAC_BUCR3_OFFSET 0x158

#define DMAC_SAR4 (*(volatile unsigned *)0x209180)
#define DMAC_SAR4_OFFSET 0x180

#define DMAC_DAR4 (*(volatile unsigned *)0x209184)
#define DMAC_DAR4_OFFSET 0x184

#define DMAC_CNTR4 (*(volatile unsigned *)0x209188)
#define DMAC_CNTR4_OFFSET 0x188

#define DMAC_CCR4 (*(volatile unsigned *)0x20918C)
#define DMAC_CCR4_OFFSET 0x18C

#define DMAC_RSSR4 (*(volatile unsigned *)0x209190)
#define DMAC_RSSR4_OFFSET 0x190

#define DMAC_BLR4 (*(volatile unsigned *)0x209194)
#define DMAC_BLR4_OFFSET 0x194

#define DMAC_RTOR4 (*(volatile unsigned *)0x209198)
#define DMAC_RTOR4_OFFSET 0x198

#define DMAC_BUCR4 (*(volatile unsigned *)0x209198)
#define DMAC_BUCR4_OFFSET 0x198

#define DMAC_SAR5 (*(volatile unsigned *)0x2091C0)
#define DMAC_SAR5_OFFSET 0x1C0

#define DMAC_DAR5 (*(volatile unsigned *)0x2091C4)
#define DMAC_DAR5_OFFSET 0x1C4

#define DMAC_CNTR5 (*(volatile unsigned *)0x2091C8)
#define DMAC_CNTR5_OFFSET 0x1C8

#define DMAC_CCR5 (*(volatile unsigned *)0x2091CC)
#define DMAC_CCR5_OFFSET 0x1CC

#define DMAC_RSSR5 (*(volatile unsigned *)0x2091D0)
#define DMAC_RSSR5_OFFSET 0x1D0

#define DMAC_BLR5 (*(volatile unsigned *)0x2091D4)
#define DMAC_BLR5_OFFSET 0x1D4

#define DMAC_RTOR5 (*(volatile unsigned *)0x2091D8)
#define DMAC_RTOR5_OFFSET 0x1D8

#define DMAC_BUCR5 (*(volatile unsigned *)0x2091D8)
#define DMAC_BUCR5_OFFSET 0x1D8

#define DMAC_SAR6 (*(volatile unsigned *)0x209200)
#define DMAC_SAR6_OFFSET 0x200

#define DMAC_DAR6 (*(volatile unsigned *)0x209204)
#define DMAC_DAR6_OFFSET 0x204

#define DMAC_CNTR6 (*(volatile unsigned *)0x209208)
#define DMAC_CNTR6_OFFSET 0x208

#define DMAC_CCR6 (*(volatile unsigned *)0x20920C)
#define DMAC_CCR6_OFFSET 0x20C

#define DMAC_RSSR6 (*(volatile unsigned *)0x209210)
#define DMAC_RSSR6_OFFSET 0x210

#define DMAC_BLR6 (*(volatile unsigned *)0x209214)
#define DMAC_BLR6_OFFSET 0x214

#define DMAC_RTOR6 (*(volatile unsigned *)0x209218)
#define DMAC_RTOR6_OFFSET 0x218

#define DMAC_BUCR6 (*(volatile unsigned *)0x209218)
#define DMAC_BUCR6_OFFSET 0x218

#define DMAC_SAR7 (*(volatile unsigned *)0x209240)
#define DMAC_SAR7_OFFSET 0x240

#define DMAC_DAR7 (*(volatile unsigned *)0x209244)
#define DMAC_DAR7_OFFSET 0x244

#define DMAC_CNTR7 (*(volatile unsigned *)0x209248)
#define DMAC_CNTR7_OFFSET 0x248

#define DMAC_CCR7 (*(volatile unsigned *)0x20924C)
#define DMAC_CCR7_OFFSET 0x24C

#define DMAC_RSSR7 (*(volatile unsigned *)0x209250)
#define DMAC_RSSR7_OFFSET 0x250

#define DMAC_BLR7 (*(volatile unsigned *)0x209254)
#define DMAC_BLR7_OFFSET 0x254

#define DMAC_RTOR7 (*(volatile unsigned *)0x209258)
#define DMAC_RTOR7_OFFSET 0x258

#define DMAC_BUCR7 (*(volatile unsigned *)0x209258)
#define DMAC_BUCR7_OFFSET 0x258

#define DMAC_SAR8 (*(volatile unsigned *)0x209280)
#define DMAC_SAR8_OFFSET 0x280

#define DMAC_DAR8 (*(volatile unsigned *)0x209284)
#define DMAC_DAR8_OFFSET 0x284

#define DMAC_CNTR8 (*(volatile unsigned *)0x209288)
#define DMAC_CNTR8_OFFSET 0x288

#define DMAC_CCR8 (*(volatile unsigned *)0x20928C)
#define DMAC_CCR8_OFFSET 0x28C

#define DMAC_RSSR8 (*(volatile unsigned *)0x209290)
#define DMAC_RSSR8_OFFSET 0x290

#define DMAC_BLR8 (*(volatile unsigned *)0x209294)
#define DMAC_BLR8_OFFSET 0x294

#define DMAC_RTOR8 (*(volatile unsigned *)0x209298)
#define DMAC_RTOR8_OFFSET 0x298

#define DMAC_BUCR8 (*(volatile unsigned *)0x209298)
#define DMAC_BUCR8_OFFSET 0x298

#define DMAC_SAR9 (*(volatile unsigned *)0x2092C0)
#define DMAC_SAR9_OFFSET 0x2C0

#define DMAC_DAR9 (*(volatile unsigned *)0x2092C4)
#define DMAC_DAR9_OFFSET 0x2C4

#define DMAC_CNTR9 (*(volatile unsigned *)0x2092C8)
#define DMAC_CNTR9_OFFSET 0x2C8

#define DMAC_CCR9 (*(volatile unsigned *)0x2092CC)
#define DMAC_CCR9_OFFSET 0x2CC

#define DMAC_RSSR9 (*(volatile unsigned *)0x2092D0)
#define DMAC_RSSR9_OFFSET 0x2D0

#define DMAC_BLR9 (*(volatile unsigned *)0x2092D4)
#define DMAC_BLR9_OFFSET 0x2D4

#define DMAC_RTOR9 (*(volatile unsigned *)0x2092D8)
#define DMAC_RTOR9_OFFSET 0x2D8

#define DMAC_BUCR9 (*(volatile unsigned *)0x2092D8)
#define DMAC_BUCR9_OFFSET 0x2D8

#define DMAC_SAR10 (*(volatile unsigned *)0x209300)
#define DMAC_SAR10_OFFSET 0x300

#define DMAC_DAR10 (*(volatile unsigned *)0x209304)
#define DMAC_DAR10_OFFSET 0x304

#define DMAC_CNTR10 (*(volatile unsigned *)0x209308)
#define DMAC_CNTR10_OFFSET 0x308

#define DMAC_CCR10 (*(volatile unsigned *)0x20930C)
#define DMAC_CCR10_OFFSET 0x30C

#define DMAC_RSSR10 (*(volatile unsigned *)0x209310)
#define DMAC_RSSR10_OFFSET 0x310

#define DMAC_BLR10 (*(volatile unsigned *)0x209314)
#define DMAC_BLR10_OFFSET 0x314

#define DMAC_RTOR10 (*(volatile unsigned *)0x209318)
#define DMAC_RTOR10_OFFSET 0x318

#define DMAC_BUCR10 (*(volatile unsigned *)0x209318)
#define DMAC_BUCR10_OFFSET 0x318

#define AIPI2_BASE 0x210000

#define AIPI2_PSR0 (*(volatile unsigned *)0x210000)
#define AIPI2_PSR0_OFFSET 0x0

#define AIPI2_PSR1 (*(volatile unsigned *)0x210004)
#define AIPI2_PSR1_OFFSET 0x4

#define AIPI2_PAR (*(volatile unsigned *)0x210008)
#define AIPI2_PAR_OFFSET 0x8

#define AIPI2_PCR (*(volatile unsigned *)0x21000C)
#define AIPI2_PCR_OFFSET 0xC

#define AIPI2_TSR (*(volatile unsigned *)0x210010)
#define AIPI2_TSR_OFFSET 0x10

#define USB_BASE 0x212000

#define USB_FRAME (*(volatile unsigned *)0x212000)
#define USB_FRAME_OFFSET 0x0

#define USB_SPEC (*(volatile unsigned *)0x212004)
#define USB_SPEC_OFFSET 0x4

#define USB_STAT (*(volatile unsigned *)0x212008)
#define USB_STAT_OFFSET 0x8

#define USB_CTRL (*(volatile unsigned *)0x21200C)
#define USB_CTRL_OFFSET 0xC

#define USB_DADR (*(volatile unsigned *)0x212010)
#define USB_DADR_OFFSET 0x10

#define USB_DDAT (*(volatile unsigned *)0x212014)
#define USB_DDAT_OFFSET 0x14

#define USB_INTR (*(volatile unsigned *)0x212018)
#define USB_INTR_OFFSET 0x18

#define USB_MASK (*(volatile unsigned *)0x21201C)
#define USB_MASK_OFFSET 0x1C

#define USB_ENAB (*(volatile unsigned *)0x212024)
#define USB_ENAB_OFFSET 0x24

#define USB_EP0_STAT (*(volatile unsigned *)0x212030)
#define USB_EP0_STAT_OFFSET 0x30

#define USB_EP0_INTR (*(volatile unsigned *)0x212034)
#define USB_EP0_INTR_OFFSET 0x34

#define USB_EP0_MASK (*(volatile unsigned *)0x212038)
#define USB_EP0_MASK_OFFSET 0x38

#define USB_EP0_FDAT (*(volatile unsigned *)0x21203C)
#define USB_EP0_FDAT_OFFSET 0x3C

#define USB_EP0_FSTAT (*(volatile unsigned *)0x212040)
#define USB_EP0_FSTAT_OFFSET 0x40

#define USB_EP0_FCTRL (*(volatile unsigned *)0x212044)
#define USB_EP0_FCTRL_OFFSET 0x44

#define USB_EP0_LRFP (*(volatile unsigned *)0x212048)
#define USB_EP0_LRFP_OFFSET 0x48

#define USB_EP0_LWFP (*(volatile unsigned *)0x21204C)
#define USB_EP0_LWFP_OFFSET 0x4C

#define USB_EP0_FALRM (*(volatile unsigned *)0x212050)
#define USB_EP0_FALRM_OFFSET 0x50

#define USB_EP0_FRDP (*(volatile unsigned *)0x212054)
#define USB_EP0_FRDP_OFFSET 0x54

#define USB_EP0_FWRP (*(volatile unsigned *)0x212058)
#define USB_EP0_FWRP_OFFSET 0x58

#define USB_EP1_STAT (*(volatile unsigned *)0x212060)
#define USB_EP1_STAT_OFFSET 0x60

#define USB_EP1_INTR (*(volatile unsigned *)0x212064)
#define USB_EP1_INTR_OFFSET 0x64

#define USB_EP1_MASK (*(volatile unsigned *)0x212068)
#define USB_EP1_MASK_OFFSET 0x68

#define USB_EP1_FDAT (*(volatile unsigned *)0x21206C)
#define USB_EP1_FDAT_OFFSET 0x6C

#define USB_EP1_FSTAT (*(volatile unsigned *)0x212070)
#define USB_EP1_FSTAT_OFFSET 0x70

#define USB_EP1_FCTRL (*(volatile unsigned *)0x212074)
#define USB_EP1_FCTRL_OFFSET 0x74

#define USB_EP1_LRFP (*(volatile unsigned *)0x212078)
#define USB_EP1_LRFP_OFFSET 0x78

#define USB_EP1_LWFP (*(volatile unsigned *)0x21207C)
#define USB_EP1_LWFP_OFFSET 0x7C

#define USB_EP1_FALRM (*(volatile unsigned *)0x212080)
#define USB_EP1_FALRM_OFFSET 0x80

#define USB_EP1_FRDP (*(volatile unsigned *)0x212084)
#define USB_EP1_FRDP_OFFSET 0x84

#define USB_EP1_FWRP (*(volatile unsigned *)0x212088)
#define USB_EP1_FWRP_OFFSET 0x88

#define USB_EP2_STAT (*(volatile unsigned *)0x212090)
#define USB_EP2_STAT_OFFSET 0x90

#define USB_EP2_INTR (*(volatile unsigned *)0x212094)
#define USB_EP2_INTR_OFFSET 0x94

#define USB_EP2_MASK (*(volatile unsigned *)0x212098)
#define USB_EP2_MASK_OFFSET 0x98

#define USB_EP2_FDAT (*(volatile unsigned *)0x21209C)
#define USB_EP2_FDAT_OFFSET 0x9C

#define USB_EP2_FSTAT (*(volatile unsigned *)0x2120A0)
#define USB_EP2_FSTAT_OFFSET 0xA0

#define USB_EP2_FCTRL (*(volatile unsigned *)0x2120A4)
#define USB_EP2_FCTRL_OFFSET 0xA4

#define USB_EP2_LRFP (*(volatile unsigned *)0x2120A8)
#define USB_EP2_LRFP_OFFSET 0xA8

#define USB_EP2_LWFP (*(volatile unsigned *)0x2120AC)
#define USB_EP2_LWFP_OFFSET 0xAC

#define USB_EP2_FALRM (*(volatile unsigned *)0x2120B0)
#define USB_EP2_FALRM_OFFSET 0xB0

#define USB_EP2_FRDP (*(volatile unsigned *)0x2120B4)
#define USB_EP2_FRDP_OFFSET 0xB4

#define USB_EP2_FWRP (*(volatile unsigned *)0x2120B8)
#define USB_EP2_FWRP_OFFSET 0xB8

#define USB_EP3_STAT (*(volatile unsigned *)0x2120C0)
#define USB_EP3_STAT_OFFSET 0xC0

#define USB_EP3_INTR (*(volatile unsigned *)0x2120C4)
#define USB_EP3_INTR_OFFSET 0xC4

#define USB_EP3_MASK (*(volatile unsigned *)0x2120C8)
#define USB_EP3_MASK_OFFSET 0xC8

#define USB_EP3_FDAT (*(volatile unsigned *)0x2120CC)
#define USB_EP3_FDAT_OFFSET 0xCC

#define USB_EP3_FSTAT (*(volatile unsigned *)0x2120D0)
#define USB_EP3_FSTAT_OFFSET 0xD0

#define USB_EP3_FCTRL (*(volatile unsigned *)0x2120D4)
#define USB_EP3_FCTRL_OFFSET 0xD4

#define USB_EP3_LRFP (*(volatile unsigned *)0x2120D8)
#define USB_EP3_LRFP_OFFSET 0xD8

#define USB_EP3_LWFP (*(volatile unsigned *)0x2120DC)
#define USB_EP3_LWFP_OFFSET 0xDC

#define USB_EP3_FALRM (*(volatile unsigned *)0x2120E0)
#define USB_EP3_FALRM_OFFSET 0xE0

#define USB_EP3_FRDP (*(volatile unsigned *)0x2120E4)
#define USB_EP3_FRDP_OFFSET 0xE4

#define USB_EP3_FWRP (*(volatile unsigned *)0x2120E8)
#define USB_EP3_FWRP_OFFSET 0xE8

#define USB_EP4_STAT (*(volatile unsigned *)0x2120F0)
#define USB_EP4_STAT_OFFSET 0xF0

#define USB_EP4_INTR (*(volatile unsigned *)0x2120F4)
#define USB_EP4_INTR_OFFSET 0xF4

#define USB_EP4_MASK (*(volatile unsigned *)0x2120F8)
#define USB_EP4_MASK_OFFSET 0xF8

#define USB_EP4_FDAT (*(volatile unsigned *)0x2120FC)
#define USB_EP4_FDAT_OFFSET 0xFC

#define USB_EP4_FSTAT (*(volatile unsigned *)0x212100)
#define USB_EP4_FSTAT_OFFSET 0x100

#define USB_EP4_FCTRL (*(volatile unsigned *)0x212104)
#define USB_EP4_FCTRL_OFFSET 0x104

#define USB_EP4_LRFP (*(volatile unsigned *)0x212108)
#define USB_EP4_LRFP_OFFSET 0x108

#define USB_EP4_LWFP (*(volatile unsigned *)0x21210C)
#define USB_EP4_LWFP_OFFSET 0x10C

#define USB_EP4_FALRM (*(volatile unsigned *)0x212110)
#define USB_EP4_FALRM_OFFSET 0x110

#define USB_EP4_FRDP (*(volatile unsigned *)0x212114)
#define USB_EP4_FRDP_OFFSET 0x114

#define USB_EP4_FWRP (*(volatile unsigned *)0x212118)
#define USB_EP4_FWRP_OFFSET 0x118

#define USB_EP5_STAT (*(volatile unsigned *)0x212120)
#define USB_EP5_STAT_OFFSET 0x120

#define USB_EP5_INTR (*(volatile unsigned *)0x212124)
#define USB_EP5_INTR_OFFSET 0x124

#define USB_EP5_MASK (*(volatile unsigned *)0x212128)
#define USB_EP5_MASK_OFFSET 0x128

#define USB_EP5_FDAT (*(volatile unsigned *)0x21212C)
#define USB_EP5_FDAT_OFFSET 0x12C

#define USB_EP5_FSTAT (*(volatile unsigned *)0x212130)
#define USB_EP5_FSTAT_OFFSET 0x130

#define USB_EP5_FCTRL (*(volatile unsigned *)0x212134)
#define USB_EP5_FCTRL_OFFSET 0x134

#define USB_EP5_LRFP (*(volatile unsigned *)0x212138)
#define USB_EP5_LRFP_OFFSET 0x138

#define USB_EP5_LWFP (*(volatile unsigned *)0x21213C)
#define USB_EP5_LWFP_OFFSET 0x13C

#define USB_EP5_FALRM (*(volatile unsigned *)0x212140)
#define USB_EP5_FALRM_OFFSET 0x140

#define USB_EP5_FRDP (*(volatile unsigned *)0x212144)
#define USB_EP5_FRDP_OFFSET 0x144

#define USB_EP5_FWRP (*(volatile unsigned *)0x212148)
#define USB_EP5_FWRP_OFFSET 0x148

#define SPI1_BASE 0x213000

#define SPI1_RXDATAREG (*(volatile unsigned *)0x213000)
#define SPI1_RXDATAREG_OFFSET 0x0

#define SPI1_TXDATAREG (*(volatile unsigned *)0x213004)
#define SPI1_TXDATAREG_OFFSET 0x4

#define SPI1_CONTROLREG (*(volatile unsigned *)0x213008)
#define SPI1_CONTROLREG_OFFSET 0x8

#define SPI1_INTREG (*(volatile unsigned *)0x21300C)
#define SPI1_INTREG_OFFSET 0xC

#define SPI1_TESTREG (*(volatile unsigned *)0x213010)
#define SPI1_TESTREG_OFFSET 0x10

#define SPI1_PERIODREG (*(volatile unsigned *)0x213014)
#define SPI1_PERIODREG_OFFSET 0x14

#define SPI1_DMAREG (*(volatile unsigned *)0x213018)
#define SPI1_DMAREG_OFFSET 0x18

#define SPI1_RESETREG (*(volatile unsigned *)0x21301C)
#define SPI1_RESETREG_OFFSET 0x1C

#define MMCSD_BASE 0x214000

#define MMCSD_STR_STP_CLK (*(volatile unsigned *)0x214000)
#define MMCSD_STR_STP_CLK_OFFSET 0x0

#define MMCSD_STATUS (*(volatile unsigned *)0x214004)
#define MMCSD_STATUS_OFFSET 0x4

#define MMCSD_CLK_RATE (*(volatile unsigned *)0x214008)
#define MMCSD_CLK_RATE_OFFSET 0x8

#define MMCSD_CMD_DAT_CONT (*(volatile unsigned *)0x21400C)
#define MMCSD_CMD_DAT_CONT_OFFSET 0xC

#define MMCSD_RES_TO (*(volatile unsigned *)0x214010)
#define MMCSD_RES_TO_OFFSET 0x10

#define MMCSD_READ_TO (*(volatile unsigned *)0x214014)
#define MMCSD_READ_TO_OFFSET 0x14

#define MMCSD_BLK_LEN (*(volatile unsigned *)0x214018)
#define MMCSD_BLK_LEN_OFFSET 0x18

#define MMCSD_NOB (*(volatile unsigned *)0x21401C)
#define MMCSD_NOB_OFFSET 0x1C

#define MMCSD_REV_NO (*(volatile unsigned *)0x214020)
#define MMCSD_REV_NO_OFFSET 0x20

#define MMCSD_INT_MASK (*(volatile unsigned *)0x214024)
#define MMCSD_INT_MASK_OFFSET 0x24

#define MMCSD_CMD (*(volatile unsigned *)0x214028)
#define MMCSD_CMD_OFFSET 0x28

#define MMCSD_ARGH (*(volatile unsigned *)0x21402C)
#define MMCSD_ARGH_OFFSET 0x2C

#define MMCSD_ARGL (*(volatile unsigned *)0x214030)
#define MMCSD_ARGL_OFFSET 0x30

#define MMCSD_RES_FIFO (*(volatile unsigned *)0x214034)
#define MMCSD_RES_FIFO_OFFSET 0x34

#define MMCSD_BUFFER_ACCESS (*(volatile unsigned *)0x214038)
#define MMCSD_BUFFER_ACCESS_OFFSET 0x38

#define I2C_BASE 0x217000

#define I2C_IADR (*(volatile unsigned *)0x217000)
#define I2C_IADR_OFFSET 0x0

#define I2C_IFDR (*(volatile unsigned *)0x217004)
#define I2C_IFDR_OFFSET 0x4

#define I2C_I2CR (*(volatile unsigned *)0x217008)
#define I2C_I2CR_OFFSET 0x8

#define I2C_I2SR (*(volatile unsigned *)0x21700C)
#define I2C_I2SR_OFFSET 0xC

#define I2C_I2DR (*(volatile unsigned *)0x217010)
#define I2C_I2DR_OFFSET 0x10

#define SSI_BASE 0x218000

#define SSI_STX (*(volatile unsigned *)0x218000)
#define SSI_STX_OFFSET 0x0

#define SSI_SRX (*(volatile unsigned *)0x218004)
#define SSI_SRX_OFFSET 0x4

#define SSI_SCSR (*(volatile unsigned *)0x218008)
#define SSI_SCSR_OFFSET 0x8

#define SSI_STCR (*(volatile unsigned *)0x21800C)
#define SSI_STCR_OFFSET 0xC

#define SSI_SRCR (*(volatile unsigned *)0x218010)
#define SSI_SRCR_OFFSET 0x10

#define SSI_STCCR (*(volatile unsigned *)0x218014)
#define SSI_STCCR_OFFSET 0x14

#define SSI_SRCCR (*(volatile unsigned *)0x218018)
#define SSI_SRCCR_OFFSET 0x18

#define SSI_STSR (*(volatile unsigned *)0x21801C)
#define SSI_STSR_OFFSET 0x1C

#define SSI_SFCSR (*(volatile unsigned *)0x218020)
#define SSI_SFCSR_OFFSET 0x20

#define SSI_SOR (*(volatile unsigned *)0x218028)
#define SSI_SOR_OFFSET 0x28

#define SPI2_BASE 0x219000

#define SPI2_RXDATAREG (*(volatile unsigned *)0x219000)
#define SPI2_RXDATAREG_OFFSET 0x0

#define SPI2_TXDATAREG (*(volatile unsigned *)0x219004)
#define SPI2_TXDATAREG_OFFSET 0x4

#define SPI2_CONTROLREG (*(volatile unsigned *)0x219008)
#define SPI2_CONTROLREG_OFFSET 0x8

#define SPI2_INTREG (*(volatile unsigned *)0x21900C)
#define SPI2_INTREG_OFFSET 0xC

#define SPI2_TESTREG (*(volatile unsigned *)0x219010)
#define SPI2_TESTREG_OFFSET 0x10

#define SPI2_PERIODREG (*(volatile unsigned *)0x219014)
#define SPI2_PERIODREG_OFFSET 0x14

#define SPI2_DMAREG (*(volatile unsigned *)0x219018)
#define SPI2_DMAREG_OFFSET 0x18

#define SPI2_RESETREG (*(volatile unsigned *)0x21901C)
#define SPI2_RESETREG_OFFSET 0x1C

#define MSHC_BASE 0x21A000

#define MSHC_MSCMD (*(volatile unsigned short *)0x21A000)
#define MSHC_MSCMD_OFFSET 0x0

#define MSHC_MSCS (*(volatile unsigned short *)0x21A002)
#define MSHC_MSCS_OFFSET 0x2

#define MSHC_MSTDATA (*(volatile unsigned short *)0x21A004)
#define MSHC_MSTDATA_OFFSET 0x4

#define MSHC_MSRDATA (*(volatile unsigned short *)0x21A004)
#define MSHC_MSRDATA_OFFSET 0x4

#define MSHC_MSICS (*(volatile unsigned short *)0x21A006)
#define MSHC_MSICS_OFFSET 0x6

#define MSHC_MSPPCD (*(volatile unsigned short *)0x21A008)
#define MSHC_MSPPCD_OFFSET 0x8

#define MSHC_MSC2 (*(volatile unsigned short *)0x21A00A)
#define MSHC_MSC2_OFFSET 0xA

#define MSHC_MSACD (*(volatile unsigned short *)0x21A00C)
#define MSHC_MSACD_OFFSET 0xC

#define MSHC_MSFAECS (*(volatile unsigned short *)0x21A00E)
#define MSHC_MSFAECS_OFFSET 0xE

#define MSHC_MSCLKD (*(volatile unsigned short *)0x21A010)
#define MSHC_MSCLKD_OFFSET 0x10

#define MSHC_MSDRQC (*(volatile unsigned short *)0x21A012)
#define MSHC_MSDRQC_OFFSET 0x12

#define PLLCLK_BASE 0x21B000

#define PLLCLK_CSCR (*(volatile unsigned *)0x21B000)
#define PLLCLK_CSCR_OFFSET 0x0

#define PLLCLK_MPCTL0 (*(volatile unsigned *)0x21B004)
#define PLLCLK_MPCTL0_OFFSET 0x4

#define PLLCLK_MPCTL1 (*(volatile unsigned *)0x21B008)
#define PLLCLK_MPCTL1_OFFSET 0x8

#define PLLCLK_SPCTL0 (*(volatile unsigned *)0x21B00C)
#define PLLCLK_SPCTL0_OFFSET 0xC

#define PLLCLK_SPCTL1 (*(volatile unsigned *)0x21B010)
#define PLLCLK_SPCTL1_OFFSET 0x10

#define PLLCLK_PCDR (*(volatile unsigned *)0x21B020)
#define PLLCLK_PCDR_OFFSET 0x20

#define CRM_BASE 0x21B800

#define CRM_RSR (*(volatile unsigned *)0x21B800)
#define CRM_RSR_OFFSET 0x0

#define CRM_SIDR (*(volatile unsigned *)0x21B804)
#define CRM_SIDR_OFFSET 0x4

#define CRM_FMCR (*(volatile unsigned *)0x21B808)
#define CRM_FMCR_OFFSET 0x8

#define CRM_GPCR (*(volatile unsigned *)0x21B80C)
#define CRM_GPCR_OFFSET 0xC

#define CRM_GCCR (*(volatile unsigned *)0x21B810)
#define CRM_GCCR_OFFSET 0x10

#define GPIO_BASE 0x21C000

#define GPIO_DDIR_A (*(volatile unsigned *)0x21C000)
#define GPIO_DDIR_A_OFFSET 0x0

#define GPIO_OCR1_A (*(volatile unsigned *)0x21C004)
#define GPIO_OCR1_A_OFFSET 0x4

#define GPIO_OCR2_A (*(volatile unsigned *)0x21C008)
#define GPIO_OCR2_A_OFFSET 0x8

#define GPIO_ICONFA1_A (*(volatile unsigned *)0x21C00C)
#define GPIO_ICONFA1_A_OFFSET 0xC

#define GPIO_ICONFA2_A (*(volatile unsigned *)0x21C010)
#define GPIO_ICONFA2_A_OFFSET 0x10

#define GPIO_ICONFB1_A (*(volatile unsigned *)0x21C014)
#define GPIO_ICONFB1_A_OFFSET 0x14

#define GPIO_ICONFB2_A (*(volatile unsigned *)0x21C018)
#define GPIO_ICONFB2_A_OFFSET 0x18

#define GPIO_DR_A (*(volatile unsigned *)0x21C01C)
#define GPIO_DR_A_OFFSET 0x1C

#define GPIO_GIUS_A (*(volatile unsigned *)0x21C020)
#define GPIO_GIUS_A_OFFSET 0x20

#define GPIO_SSR_A (*(volatile unsigned *)0x21C024)
#define GPIO_SSR_A_OFFSET 0x24

#define GPIO_ICR1_A (*(volatile unsigned *)0x21C028)
#define GPIO_ICR1_A_OFFSET 0x28

#define GPIO_ICR2_A (*(volatile unsigned *)0x21C02C)
#define GPIO_ICR2_A_OFFSET 0x2C

#define GPIO_IMR_A (*(volatile unsigned *)0x21C030)
#define GPIO_IMR_A_OFFSET 0x30

#define GPIO_ISR_A (*(volatile unsigned *)0x21C034)
#define GPIO_ISR_A_OFFSET 0x34

#define GPIO_GPR_A (*(volatile unsigned *)0x21C038)
#define GPIO_GPR_A_OFFSET 0x38

#define GPIO_SWR_A (*(volatile unsigned *)0x21C03C)
#define GPIO_SWR_A_OFFSET 0x3C

#define GPIO_PUEN_A (*(volatile unsigned *)0x21C040)
#define GPIO_PUEN_A_OFFSET 0x40

#define GPIO_DDIR_B (*(volatile unsigned *)0x21C100)
#define GPIO_DDIR_B_OFFSET 0x100

#define GPIO_OCR1_B (*(volatile unsigned *)0x21C104)
#define GPIO_OCR1_B_OFFSET 0x104

#define GPIO_OCR2_B (*(volatile unsigned *)0x21C108)
#define GPIO_OCR2_B_OFFSET 0x108

#define GPIO_ICONFA1_B (*(volatile unsigned *)0x21C10C)
#define GPIO_ICONFA1_B_OFFSET 0x10C

#define GPIO_ICONFA2_B (*(volatile unsigned *)0x21C110)
#define GPIO_ICONFA2_B_OFFSET 0x110

#define GPIO_ICONFB1_B (*(volatile unsigned *)0x21C114)
#define GPIO_ICONFB1_B_OFFSET 0x114

#define GPIO_ICONFB2_B (*(volatile unsigned *)0x21C118)
#define GPIO_ICONFB2_B_OFFSET 0x118

#define GPIO_DR_B (*(volatile unsigned *)0x21C11C)
#define GPIO_DR_B_OFFSET 0x11C

#define GPIO_GIUS_B (*(volatile unsigned *)0x21C120)
#define GPIO_GIUS_B_OFFSET 0x120

#define GPIO_SSR_B (*(volatile unsigned *)0x21C124)
#define GPIO_SSR_B_OFFSET 0x124

#define GPIO_ICR1_B (*(volatile unsigned *)0x21C128)
#define GPIO_ICR1_B_OFFSET 0x128

#define GPIO_ICR2_B (*(volatile unsigned *)0x21C12C)
#define GPIO_ICR2_B_OFFSET 0x12C

#define GPIO_IMR_B (*(volatile unsigned *)0x21C130)
#define GPIO_IMR_B_OFFSET 0x130

#define GPIO_ISR_B (*(volatile unsigned *)0x21C134)
#define GPIO_ISR_B_OFFSET 0x134

#define GPIO_GPR_B (*(volatile unsigned *)0x21C138)
#define GPIO_GPR_B_OFFSET 0x138

#define GPIO_SWR_B (*(volatile unsigned *)0x21C13C)
#define GPIO_SWR_B_OFFSET 0x13C

#define GPIO_PUEN_B (*(volatile unsigned *)0x21C140)
#define GPIO_PUEN_B_OFFSET 0x140

#define GPIO_DDIR_C (*(volatile unsigned *)0x21C200)
#define GPIO_DDIR_C_OFFSET 0x200

#define GPIO_OCR1_C (*(volatile unsigned *)0x21C204)
#define GPIO_OCR1_C_OFFSET 0x204

#define GPIO_OCR2_C (*(volatile unsigned *)0x21C208)
#define GPIO_OCR2_C_OFFSET 0x208

#define GPIO_ICONFA1_C (*(volatile unsigned *)0x21C20C)
#define GPIO_ICONFA1_C_OFFSET 0x20C

#define GPIO_ICONFA2_C (*(volatile unsigned *)0x21C210)
#define GPIO_ICONFA2_C_OFFSET 0x210

#define GPIO_ICONFB1_C (*(volatile unsigned *)0x21C214)
#define GPIO_ICONFB1_C_OFFSET 0x214

#define GPIO_ICONFB2_C (*(volatile unsigned *)0x21C218)
#define GPIO_ICONFB2_C_OFFSET 0x218

#define GPIO_DR_C (*(volatile unsigned *)0x21C21C)
#define GPIO_DR_C_OFFSET 0x21C

#define GPIO_GIUS_C (*(volatile unsigned *)0x21C220)
#define GPIO_GIUS_C_OFFSET 0x220

#define GPIO_SSR_C (*(volatile unsigned *)0x21C224)
#define GPIO_SSR_C_OFFSET 0x224

#define GPIO_ICR1_C (*(volatile unsigned *)0x21C228)
#define GPIO_ICR1_C_OFFSET 0x228

#define GPIO_ICR2_C (*(volatile unsigned *)0x21C22C)
#define GPIO_ICR2_C_OFFSET 0x22C

#define GPIO_IMR_C (*(volatile unsigned *)0x21C230)
#define GPIO_IMR_C_OFFSET 0x230

#define GPIO_ISR_C (*(volatile unsigned *)0x21C234)
#define GPIO_ISR_C_OFFSET 0x234

#define GPIO_GPR_C (*(volatile unsigned *)0x21C238)
#define GPIO_GPR_C_OFFSET 0x238

#define GPIO_SWR_C (*(volatile unsigned *)0x21C23C)
#define GPIO_SWR_C_OFFSET 0x23C

#define GPIO_PUEN_C (*(volatile unsigned *)0x21C240)
#define GPIO_PUEN_C_OFFSET 0x240

#define GPIO_DDIR_D (*(volatile unsigned *)0x21C300)
#define GPIO_DDIR_D_OFFSET 0x300

#define GPIO_OCR1_D (*(volatile unsigned *)0x21C304)
#define GPIO_OCR1_D_OFFSET 0x304

#define GPIO_OCR2_D (*(volatile unsigned *)0x21C308)
#define GPIO_OCR2_D_OFFSET 0x308

#define GPIO_ICONFA1_D (*(volatile unsigned *)0x21C30C)
#define GPIO_ICONFA1_D_OFFSET 0x30C

#define GPIO_ICONFA2_D (*(volatile unsigned *)0x21C310)
#define GPIO_ICONFA2_D_OFFSET 0x310

#define GPIO_ICONFB1_D (*(volatile unsigned *)0x21C314)
#define GPIO_ICONFB1_D_OFFSET 0x314

#define GPIO_ICONFB2_D (*(volatile unsigned *)0x21C318)
#define GPIO_ICONFB2_D_OFFSET 0x318

#define GPIO_DR_D (*(volatile unsigned *)0x21C31C)
#define GPIO_DR_D_OFFSET 0x31C

#define GPIO_GIUS_D (*(volatile unsigned *)0x21C320)
#define GPIO_GIUS_D_OFFSET 0x320

#define GPIO_SSR_D (*(volatile unsigned *)0x21C324)
#define GPIO_SSR_D_OFFSET 0x324

#define GPIO_ICR1_D (*(volatile unsigned *)0x21C328)
#define GPIO_ICR1_D_OFFSET 0x328

#define GPIO_ICR2_D (*(volatile unsigned *)0x21C32C)
#define GPIO_ICR2_D_OFFSET 0x32C

#define GPIO_IMR_D (*(volatile unsigned *)0x21C330)
#define GPIO_IMR_D_OFFSET 0x330

#define GPIO_ISR_D (*(volatile unsigned *)0x21C334)
#define GPIO_ISR_D_OFFSET 0x334

#define GPIO_GPR_D (*(volatile unsigned *)0x21C338)
#define GPIO_GPR_D_OFFSET 0x338

#define GPIO_SWR_D (*(volatile unsigned *)0x21C33C)
#define GPIO_SWR_D_OFFSET 0x33C

#define GPIO_PUEN_D (*(volatile unsigned *)0x21C340)
#define GPIO_PUEN_D_OFFSET 0x340

#define EIM_BASE 0x220000

#define EIM_CS0U (*(volatile unsigned *)0x220000)
#define EIM_CS0U_OFFSET 0x0

#define EIM_CS0L (*(volatile unsigned *)0x220004)
#define EIM_CS0L_OFFSET 0x4

#define EIM_CS1U (*(volatile unsigned *)0x220008)
#define EIM_CS1U_OFFSET 0x8

#define EIM_CS1L (*(volatile unsigned *)0x22000C)
#define EIM_CS1L_OFFSET 0xC

#define EIM_CS2U (*(volatile unsigned *)0x220010)
#define EIM_CS2U_OFFSET 0x10

#define EIM_CS2L (*(volatile unsigned *)0x220014)
#define EIM_CS2L_OFFSET 0x14

#define EIM_CS3U (*(volatile unsigned *)0x220018)
#define EIM_CS3U_OFFSET 0x18

#define EIM_CS3L (*(volatile unsigned *)0x22001C)
#define EIM_CS3L_OFFSET 0x1C

#define EIM_CS4U (*(volatile unsigned *)0x220020)
#define EIM_CS4U_OFFSET 0x20

#define EIM_CS4L (*(volatile unsigned *)0x220024)
#define EIM_CS4L_OFFSET 0x24

#define EIM_CS5U (*(volatile unsigned *)0x220028)
#define EIM_CS5U_OFFSET 0x28

#define EIM_CS5L (*(volatile unsigned *)0x22002C)
#define EIM_CS5L_OFFSET 0x2C

#define EIM_EIM (*(volatile unsigned *)0x220030)
#define EIM_EIM_OFFSET 0x30

#define SDRAMC_BASE 0x221000

#define SDRAMC_SDCTL0 (*(volatile unsigned *)0x221000)
#define SDRAMC_SDCTL0_OFFSET 0x0

#define SDRAMC_SDCTL1 (*(volatile unsigned *)0x221004)
#define SDRAMC_SDCTL1_OFFSET 0x4

#define SDRAMC_SDRST (*(volatile unsigned *)0x221018)
#define SDRAMC_SDRST_OFFSET 0x18

#define SDRAMC_MISCELLANEOUS (*(volatile unsigned *)0x221014)
#define SDRAMC_MISCELLANEOUS_OFFSET 0x14

#define MMA_BASE 0x222000

#define MMA_MAC_MOD (*(volatile unsigned *)0x222000)
#define MMA_MAC_MOD_OFFSET 0x0

#define MMA_MAC_CTRL (*(volatile unsigned *)0x222004)
#define MMA_MAC_CTRL_OFFSET 0x4

#define MMA_MAC_MULT (*(volatile unsigned *)0x222008)
#define MMA_MAC_MULT_OFFSET 0x8

#define MMA_MAC_ACCU (*(volatile unsigned *)0x22200C)
#define MMA_MAC_ACCU_OFFSET 0xC

#define MMA_MAC_INTR (*(volatile unsigned *)0x222010)
#define MMA_MAC_INTR_OFFSET 0x10

#define MMA_MAC_INTR_MASK (*(volatile unsigned *)0x222014)
#define MMA_MAC_INTR_MASK_OFFSET 0x14

#define MMA_MAC_FIFO (*(volatile unsigned *)0x222018)
#define MMA_MAC_FIFO_OFFSET 0x18

#define MMA_MAC_FIFO_STAT (*(volatile unsigned *)0x22201C)
#define MMA_MAC_FIFO_STAT_OFFSET 0x1C

#define MMA_MAC_BURST (*(volatile unsigned *)0x222020)
#define MMA_MAC_BURST_OFFSET 0x20

#define MMA_MAC_BITSEL (*(volatile unsigned *)0x222024)
#define MMA_MAC_BITSEL_OFFSET 0x24

#define MMA_MAC_XYACCU (*(volatile unsigned *)0x222040)
#define MMA_MAC_XYACCU_OFFSET 0x40

#define MMA_MAC_XBASE (*(volatile unsigned *)0x222200)
#define MMA_MAC_XBASE_OFFSET 0x200

#define MMA_MAC_XINDEX (*(volatile unsigned *)0x222204)
#define MMA_MAC_XINDEX_OFFSET 0x204

#define MMA_MAC_XLENGTH (*(volatile unsigned *)0x222208)
#define MMA_MAC_XLENGTH_OFFSET 0x208

#define MMA_MAC_XMODIFY (*(volatile unsigned *)0x22220C)
#define MMA_MAC_XMODIFY_OFFSET 0x20C

#define MMA_MAC_XINCR (*(volatile unsigned *)0x222210)
#define MMA_MAC_XINCR_OFFSET 0x210

#define MMA_MAC_XCOUNT (*(volatile unsigned *)0x222214)
#define MMA_MAC_XCOUNT_OFFSET 0x214

#define MMA_MAC_XYACCU (*(volatile unsigned *)0x222040)
#define MMA_MAC_XYACCU_OFFSET 0x40

#define MMA_MAC_YBASE (*(volatile unsigned *)0x222300)
#define MMA_MAC_YBASE_OFFSET 0x300

#define MMA_MAC_YINDEX (*(volatile unsigned *)0x222304)
#define MMA_MAC_YINDEX_OFFSET 0x304

#define MMA_MAC_YLENGTH (*(volatile unsigned *)0x222308)
#define MMA_MAC_YLENGTH_OFFSET 0x308

#define MMA_MAC_YMODIFY (*(volatile unsigned *)0x22230C)
#define MMA_MAC_YMODIFY_OFFSET 0x30C

#define MMA_MAC_YINCR (*(volatile unsigned *)0x222310)
#define MMA_MAC_YINCR_OFFSET 0x310

#define MMA_MAC_YCOUNT (*(volatile unsigned *)0x222314)
#define MMA_MAC_YCOUNT_OFFSET 0x314

#define MMA_DCTCTRL (*(volatile unsigned *)0x222400)
#define MMA_DCTCTRL_OFFSET 0x400

#define MMA_DCTVERSION (*(volatile unsigned *)0x222404)
#define MMA_DCTVERSION_OFFSET 0x404

#define MMA_DCTIRQENA (*(volatile unsigned *)0x222408)
#define MMA_DCTIRQENA_OFFSET 0x408

#define MMA_DCTIRQSTAT (*(volatile unsigned *)0x22240C)
#define MMA_DCTIRQSTAT_OFFSET 0x40C

#define MMA_DCTSRCDATA (*(volatile unsigned *)0x222410)
#define MMA_DCTSRCDATA_OFFSET 0x410

#define MMA_DCTDESDATA (*(volatile unsigned *)0x222414)
#define MMA_DCTDESDATA_OFFSET 0x414

#define MMA_DCTXOFF (*(volatile unsigned *)0x222418)
#define MMA_DCTXOFF_OFFSET 0x418

#define MMA_DCTOFF (*(volatile unsigned *)0x22241C)
#define MMA_DCTOFF_OFFSET 0x41C

#define MMA_DCTXYCNT (*(volatile unsigned *)0x222420)
#define MMA_DCTXYCNT_OFFSET 0x420

#define MMA_DCTSKIP (*(volatile unsigned *)0x222424)
#define MMA_DCTSKIP_OFFSET 0x424

#define MMA_DCTFIFO (*(volatile unsigned *)0x222500)
#define MMA_DCTFIFO_OFFSET 0x500

#define AITC_BASE 0x223000

#define AITC_INTCNTL (*(volatile unsigned *)0x223000)
#define AITC_INTCNTL_OFFSET 0x0

#define AITC_NIMASK (*(volatile unsigned *)0x223004)
#define AITC_NIMASK_OFFSET 0x4

#define AITC_INTENNUM (*(volatile unsigned *)0x223008)
#define AITC_INTENNUM_OFFSET 0x8

#define AITC_INTDISNUM (*(volatile unsigned *)0x22300C)
#define AITC_INTDISNUM_OFFSET 0xC

#define AITC_INTENABLEH (*(volatile unsigned *)0x223010)
#define AITC_INTENABLEH_OFFSET 0x10

#define AITC_INTENABLEL (*(volatile unsigned *)0x223014)
#define AITC_INTENABLEL_OFFSET 0x14

#define AITC_INTTYPEH (*(volatile unsigned *)0x223018)
#define AITC_INTTYPEH_OFFSET 0x18

#define AITC_INTTYPEL (*(volatile unsigned *)0x22301C)
#define AITC_INTTYPEL_OFFSET 0x1C

#define AITC_NIPRIORITY7 (*(volatile unsigned *)0x223020)
#define AITC_NIPRIORITY7_OFFSET 0x20

#define AITC_NIPRIORITY6 (*(volatile unsigned *)0x223024)
#define AITC_NIPRIORITY6_OFFSET 0x24

#define AITC_NIPRIORITY5 (*(volatile unsigned *)0x223028)
#define AITC_NIPRIORITY5_OFFSET 0x28

#define AITC_NIPRIORITY4 (*(volatile unsigned *)0x22302C)
#define AITC_NIPRIORITY4_OFFSET 0x2C

#define AITC_NIPRIORITY3 (*(volatile unsigned *)0x223030)
#define AITC_NIPRIORITY3_OFFSET 0x30

#define AITC_NIPRIORITY2 (*(volatile unsigned *)0x223034)
#define AITC_NIPRIORITY2_OFFSET 0x34

#define AITC_NIPRIORITY1 (*(volatile unsigned *)0x223038)
#define AITC_NIPRIORITY1_OFFSET 0x38

#define AITC_NIPRIORITY0 (*(volatile unsigned *)0x22303C)
#define AITC_NIPRIORITY0_OFFSET 0x3C

#define AITC_NIVECSR (*(volatile unsigned *)0x223040)
#define AITC_NIVECSR_OFFSET 0x40

#define AITC_FIVECSR (*(volatile unsigned *)0x223044)
#define AITC_FIVECSR_OFFSET 0x44

#define AITC_INTSRCH (*(volatile unsigned *)0x223048)
#define AITC_INTSRCH_OFFSET 0x48

#define AITC_INTSRCL (*(volatile unsigned *)0x22304C)
#define AITC_INTSRCL_OFFSET 0x4C

#define AITC_INTFRCH (*(volatile unsigned *)0x223050)
#define AITC_INTFRCH_OFFSET 0x50

#define AITC_INTFRCL (*(volatile unsigned *)0x223054)
#define AITC_INTFRCL_OFFSET 0x54

#define AITC_NIPNDH (*(volatile unsigned *)0x223058)
#define AITC_NIPNDH_OFFSET 0x58

#define AITC_NIPNDL (*(volatile unsigned *)0x22305C)
#define AITC_NIPNDL_OFFSET 0x5C

#define AITC_FIPNDH (*(volatile unsigned *)0x223060)
#define AITC_FIPNDH_OFFSET 0x60

#define AITC_FIPNDL (*(volatile unsigned *)0x223064)
#define AITC_FIPNDL_OFFSET 0x64

#define CSI_BASE 0x224000

#define CSI_CR1 (*(volatile unsigned *)0x224000)
#define CSI_CR1_OFFSET 0x0

#define CSI_CR2 (*(volatile unsigned *)0x224004)
#define CSI_CR2_OFFSET 0x4

#define CSI_SR (*(volatile unsigned *)0x224008)
#define CSI_SR_OFFSET 0x8

#define CSI_STATR (*(volatile unsigned *)0x22400C)
#define CSI_STATR_OFFSET 0xC

#define CSI_RXR (*(volatile unsigned *)0x224010)
#define CSI_RXR_OFFSET 0x10


#endif
