// AT91SAM7A1 register and bit definitions.
//
// Copyright (c) 2006 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef AT91SAM7A1_h
#define AT91SAM7A1_h

#define AMC_BASE 0xFFE00000

#define AMC_CSR0 (*(volatile unsigned long *)0xFFE00000)
#define AMC_CSR0_OFFSET 0x0
#define AMC_CSR0_DBW_MASK 0x3
#define AMC_CSR0_DBW_BIT 0
#define AMC_CSR0_NWS_MASK 0x1C
#define AMC_CSR0_NWS_BIT 2
#define AMC_CSR0_WSE_MASK 0x20
#define AMC_CSR0_WSE 0x20
#define AMC_CSR0_WSE_BIT 5
#define AMC_CSR0_PAGES0_MASK 0x80
#define AMC_CSR0_PAGES0 0x80
#define AMC_CSR0_PAGES0_BIT 7
#define AMC_CSR0_PAGES1_MASK 0x100
#define AMC_CSR0_PAGES1 0x100
#define AMC_CSR0_PAGES1_BIT 8
#define AMC_CSR0_TDF_MASK 0xE00
#define AMC_CSR0_TDF_BIT 9
#define AMC_CSR0_BAT_MASK 0x1000
#define AMC_CSR0_BAT 0x1000
#define AMC_CSR0_BAT_BIT 12
#define AMC_CSR0_CSEN_MASK 0x2000
#define AMC_CSR0_CSEN 0x2000
#define AMC_CSR0_CSEN_BIT 13
#define AMC_CSR0_BA_MASK 0x3FF00000
#define AMC_CSR0_BA_BIT 20

#define AMC_CSR1 (*(volatile unsigned long *)0xFFE00004)
#define AMC_CSR1_OFFSET 0x4
#define AMC_CSR1_DBW_MASK 0x3
#define AMC_CSR1_DBW_BIT 0
#define AMC_CSR1_NWS_MASK 0x1C
#define AMC_CSR1_NWS_BIT 2
#define AMC_CSR1_WSE_MASK 0x20
#define AMC_CSR1_WSE 0x20
#define AMC_CSR1_WSE_BIT 5
#define AMC_CSR1_PAGES0_MASK 0x80
#define AMC_CSR1_PAGES0 0x80
#define AMC_CSR1_PAGES0_BIT 7
#define AMC_CSR1_PAGES1_MASK 0x100
#define AMC_CSR1_PAGES1 0x100
#define AMC_CSR1_PAGES1_BIT 8
#define AMC_CSR1_TDF_MASK 0xE00
#define AMC_CSR1_TDF_BIT 9
#define AMC_CSR1_BAT_MASK 0x1000
#define AMC_CSR1_BAT 0x1000
#define AMC_CSR1_BAT_BIT 12
#define AMC_CSR1_CSEN_MASK 0x2000
#define AMC_CSR1_CSEN 0x2000
#define AMC_CSR1_CSEN_BIT 13
#define AMC_CSR1_BA_MASK 0x3FF00000
#define AMC_CSR1_BA_BIT 20

#define AMC_CSR2 (*(volatile unsigned long *)0xFFE00008)
#define AMC_CSR2_OFFSET 0x8
#define AMC_CSR2_DBW_MASK 0x3
#define AMC_CSR2_DBW_BIT 0
#define AMC_CSR2_NWS_MASK 0x1C
#define AMC_CSR2_NWS_BIT 2
#define AMC_CSR2_WSE_MASK 0x20
#define AMC_CSR2_WSE 0x20
#define AMC_CSR2_WSE_BIT 5
#define AMC_CSR2_PAGES0_MASK 0x80
#define AMC_CSR2_PAGES0 0x80
#define AMC_CSR2_PAGES0_BIT 7
#define AMC_CSR2_PAGES1_MASK 0x100
#define AMC_CSR2_PAGES1 0x100
#define AMC_CSR2_PAGES1_BIT 8
#define AMC_CSR2_TDF_MASK 0xE00
#define AMC_CSR2_TDF_BIT 9
#define AMC_CSR2_BAT_MASK 0x1000
#define AMC_CSR2_BAT 0x1000
#define AMC_CSR2_BAT_BIT 12
#define AMC_CSR2_CSEN_MASK 0x2000
#define AMC_CSR2_CSEN 0x2000
#define AMC_CSR2_CSEN_BIT 13
#define AMC_CSR2_BA_MASK 0x3FF00000
#define AMC_CSR2_BA_BIT 20

#define AMC_CSR3 (*(volatile unsigned long *)0xFFE0000C)
#define AMC_CSR3_OFFSET 0xC
#define AMC_CSR3_DBW_MASK 0x3
#define AMC_CSR3_DBW_BIT 0
#define AMC_CSR3_NWS_MASK 0x1C
#define AMC_CSR3_NWS_BIT 2
#define AMC_CSR3_WSE_MASK 0x20
#define AMC_CSR3_WSE 0x20
#define AMC_CSR3_WSE_BIT 5
#define AMC_CSR3_PAGES0_MASK 0x80
#define AMC_CSR3_PAGES0 0x80
#define AMC_CSR3_PAGES0_BIT 7
#define AMC_CSR3_PAGES1_MASK 0x100
#define AMC_CSR3_PAGES1 0x100
#define AMC_CSR3_PAGES1_BIT 8
#define AMC_CSR3_TDF_MASK 0xE00
#define AMC_CSR3_TDF_BIT 9
#define AMC_CSR3_BAT_MASK 0x1000
#define AMC_CSR3_BAT 0x1000
#define AMC_CSR3_BAT_BIT 12
#define AMC_CSR3_CSEN_MASK 0x2000
#define AMC_CSR3_CSEN 0x2000
#define AMC_CSR3_CSEN_BIT 13
#define AMC_CSR3_BA_MASK 0x3FF00000
#define AMC_CSR3_BA_BIT 20

#define AMC_RCR (*(volatile unsigned long *)0xFFE00020)
#define AMC_RCR_OFFSET 0x20
#define AMC_RCR_RCB_MASK 0x1
#define AMC_RCR_RCB 0x1
#define AMC_RCR_RCB_BIT 0

#define AMC_MCR (*(volatile unsigned long *)0xFFE00024)
#define AMC_MCR_OFFSET 0x24
#define AMC_MCR_ALE_MASK 0x7
#define AMC_MCR_ALE_BIT 0
#define AMC_MCR_DRP_MASK 0x10
#define AMC_MCR_DRP 0x10
#define AMC_MCR_DRP_BIT 4

#define SFM_BASE 0xFFF00000

#define SFM_CIDR (*(volatile unsigned long *)0xFFF00000)
#define SFM_CIDR_OFFSET 0x0
#define SFM_CIDR_NVPMS_MASK 0xF
#define SFM_CIDR_NVPMS_BIT 0
#define SFM_CIDR_NVDMS_MASK 0xF0
#define SFM_CIDR_NVDMS_BIT 4
#define SFM_CIDR_IRS_MASK 0xF00
#define SFM_CIDR_IRS_BIT 8
#define SFM_CIDR_NVPMT_MASK 0xF000
#define SFM_CIDR_NVPMT_BIT 12
#define SFM_CIDR_ARCH_MASK 0xF0000
#define SFM_CIDR_ARCH_BIT 16
#define SFM_CIDR_EXT_MASK 0x80000000
#define SFM_CIDR_EXT 0x80000000
#define SFM_CIDR_EXT_BIT 31

#define SFM_EXID (*(volatile unsigned long *)0xFFF00004)
#define SFM_EXID_OFFSET 0x4
#define SFM_EXID_REVT_MASK 0xF
#define SFM_EXID_REVT_BIT 0
#define SFM_EXID_REVS_MASK 0xF0
#define SFM_EXID_REVS_BIT 4
#define SFM_EXID_REVF_MASK 0xF00
#define SFM_EXID_REVF_BIT 8
#define SFM_EXID_PRJCT_MASK 0xF000
#define SFM_EXID_PRJCT_BIT 12
#define SFM_EXID_PRJCS_MASK 0xF0000
#define SFM_EXID_PRJCS_BIT 16
#define SFM_EXID_PRJCF_MASK 0xF00000
#define SFM_EXID_PRJCF_BIT 20
#define SFM_EXID_TYPE_MASK 0xF000000
#define SFM_EXID_TYPE_BIT 24
#define SFM_EXID_EXT_MASK 0x80000000
#define SFM_EXID_EXT 0x80000000
#define SFM_EXID_EXT_BIT 31

#define SFM_RSR (*(volatile unsigned long *)0xFFF00008)
#define SFM_RSR_OFFSET 0x8
#define SFM_RSR_RESET_MASK 0xFF
#define SFM_RSR_RESET_BIT 0

#define WD_BASE 0xFFFA0000

#define WD_CR (*(volatile unsigned long *)0xFFFA0060)
#define WD_CR_OFFSET 0x60
#define WD_CR_RSTKEY_MASK 0xFFFF
#define WD_CR_RSTKEY_BIT 0

#define WD_MR (*(volatile unsigned long *)0xFFFA0064)
#define WD_MR_OFFSET 0x64
#define WD_MR_WDPDIV_MASK 0x7
#define WD_MR_WDPDIV_BIT 0
#define WD_MR_PCV_MASK 0xFFFF00
#define WD_MR_PCV_BIT 8
#define WD_MR_CKEY_MASK 0xFF000000
#define WD_MR_CKEY_BIT 24

#define WD_OMR (*(volatile unsigned long *)0xFFFA0068)
#define WD_OMR_OFFSET 0x68
#define WD_OMR_WDEN_MASK 0x1
#define WD_OMR_WDEN 0x1
#define WD_OMR_WDEN_BIT 0
#define WD_OMR_TSTEN_MASK 0x2
#define WD_OMR_TSTEN 0x2
#define WD_OMR_TSTEN_BIT 1
#define WD_OMR_OKEY_MASK 0xFFF0
#define WD_OMR_OKEY_BIT 4

#define WD_CSR (*(volatile unsigned long *)0xFFFA006C)
#define WD_CSR_OFFSET 0x6C
#define WD_CSR_WDPEND_MASK 0x1
#define WD_CSR_WDPEND 0x1
#define WD_CSR_WDPEND_BIT 0
#define WD_CSR_WDOVF_MASK 0x2
#define WD_CSR_WDOVF 0x2
#define WD_CSR_WDOVF_BIT 1

#define WD_SR (*(volatile unsigned long *)0xFFFA006C)
#define WD_SR_OFFSET 0x6C
#define WD_SR_WDPEND_MASK 0x1
#define WD_SR_WDPEND 0x1
#define WD_SR_WDPEND_BIT 0
#define WD_SR_WDOVF_MASK 0x2
#define WD_SR_WDOVF 0x2
#define WD_SR_WDOVF_BIT 1
#define WD_SR_PENDING_MASK 0x100
#define WD_SR_PENDING 0x100
#define WD_SR_PENDING_BIT 8
#define WD_SR_RESTART_MASK 0x200
#define WD_SR_RESTART 0x200
#define WD_SR_RESTART_BIT 9

#define WD_IER (*(volatile unsigned long *)0xFFFA0074)
#define WD_IER_OFFSET 0x74
#define WD_IER_WDPEND_MASK 0x1
#define WD_IER_WDPEND 0x1
#define WD_IER_WDPEND_BIT 0
#define WD_IER_WDOVF_MASK 0x2
#define WD_IER_WDOVF 0x2
#define WD_IER_WDOVF_BIT 1

#define WD_IDR (*(volatile unsigned long *)0xFFFA0078)
#define WD_IDR_OFFSET 0x78
#define WD_IDR_WDPEND_MASK 0x1
#define WD_IDR_WDPEND 0x1
#define WD_IDR_WDPEND_BIT 0
#define WD_IDR_WDOVF_MASK 0x2
#define WD_IDR_WDOVF 0x2
#define WD_IDR_WDOVF_BIT 1

#define WD_IMR (*(volatile unsigned long *)0xFFFA007C)
#define WD_IMR_OFFSET 0x7C
#define WD_IMR_WDPEND_MASK 0x1
#define WD_IMR_WDPEND 0x1
#define WD_IMR_WDPEND_BIT 0
#define WD_IMR_WDOVF_MASK 0x2
#define WD_IMR_WDOVF 0x2
#define WD_IMR_WDOVF_BIT 1

#define WD_PWR (*(volatile unsigned long *)0xFFFA0080)
#define WD_PWR_OFFSET 0x80
#define WD_PWR_RSTALW_MASK 0x1
#define WD_PWR_RSTALW 0x1
#define WD_PWR_RSTALW_BIT 0
#define WD_PWR_PWL_MASK 0xFFFF00
#define WD_PWR_PWL_BIT 8
#define WD_PWR_PWKEY_MASK 0xFF000000
#define WD_PWR_PWKEY_BIT 24

#define WT_BASE 0xFFFA4000

#define WT_CR (*(volatile unsigned long *)0xFFFA4060)
#define WT_CR_OFFSET 0x60
#define WT_CR_SWRST_MASK 0x1
#define WT_CR_SWRST 0x1
#define WT_CR_SWRST_BIT 0
#define WT_CR_SECSEN_MASK 0x2
#define WT_CR_SECSEN 0x2
#define WT_CR_SECSEN_BIT 1
#define WT_CR_SECSDIS_MASK 0x4
#define WT_CR_SECSDIS 0x4
#define WT_CR_SECSDIS_BIT 2
#define WT_CR_ALARMEN_MASK 0x8
#define WT_CR_ALARMEN 0x8
#define WT_CR_ALARMEN_BIT 3
#define WT_CR_ALARMDIS_MASK 0x10
#define WT_CR_ALARMDIS 0x10
#define WT_CR_ALARMDIS_BIT 4

#define WT_MR (*(volatile unsigned long *)0xFFFA4064)
#define WT_MR_OFFSET 0x64
#define WT_MR_SECRST_MASK 0x1
#define WT_MR_SECRST 0x1
#define WT_MR_SECRST_BIT 0

#define WT_CSR (*(volatile unsigned long *)0xFFFA406C)
#define WT_CSR_OFFSET 0x6C
#define WT_CSR_ALARM_MASK 0x1
#define WT_CSR_ALARM 0x1
#define WT_CSR_ALARM_BIT 0
#define WT_CSR_SECSEN_MASK 0x2
#define WT_CSR_SECSEN 0x2
#define WT_CSR_SECSEN_BIT 1
#define WT_CSR_SECSDIS_MASK 0x4
#define WT_CSR_SECSDIS 0x4
#define WT_CSR_SECSDIS_BIT 2
#define WT_CSR_ALARMEN_MASK 0x8
#define WT_CSR_ALARMEN 0x8
#define WT_CSR_ALARMEN_BIT 3
#define WT_CSR_ALARMDIS_MASK 0x10
#define WT_CSR_ALARMDIS 0x10
#define WT_CSR_ALARMDIS_BIT 4

#define WT_SR (*(volatile unsigned long *)0xFFFA4070)
#define WT_SR_OFFSET 0x70
#define WT_SR_ALARM_MASK 0x1
#define WT_SR_ALARM 0x1
#define WT_SR_ALARM_BIT 0
#define WT_SR_SECSEN_MASK 0x2
#define WT_SR_SECSEN 0x2
#define WT_SR_SECSEN_BIT 1
#define WT_SR_SECSDIS_MASK 0x4
#define WT_SR_SECSDIS 0x4
#define WT_SR_SECSDIS_BIT 2
#define WT_SR_ALARMEN_MASK 0x8
#define WT_SR_ALARMEN 0x8
#define WT_SR_ALARMEN_BIT 3
#define WT_SR_ALARMDIS_MASK 0x10
#define WT_SR_ALARMDIS 0x10
#define WT_SR_ALARMDIS_BIT 4
#define WT_SR_WSEC_MASK 0x20
#define WT_SR_WSEC 0x20
#define WT_SR_WSEC_BIT 5
#define WT_SR_SECENS_MASK 0x100
#define WT_SR_SECENS 0x100
#define WT_SR_SECENS_BIT 8
#define WT_SR_ALARMENS_MASK 0x200
#define WT_SR_ALARMENS 0x200
#define WT_SR_ALARMENS_BIT 9

#define WT_IER (*(volatile unsigned long *)0xFFFA4074)
#define WT_IER_OFFSET 0x74
#define WT_IER_ALARM_MASK 0x1
#define WT_IER_ALARM 0x1
#define WT_IER_ALARM_BIT 0
#define WT_IER_SECSEN_MASK 0x2
#define WT_IER_SECSEN 0x2
#define WT_IER_SECSEN_BIT 1
#define WT_IER_SECSDIS_MASK 0x4
#define WT_IER_SECSDIS 0x4
#define WT_IER_SECSDIS_BIT 2
#define WT_IER_ALARMEN_MASK 0x8
#define WT_IER_ALARMEN 0x8
#define WT_IER_ALARMEN_BIT 3
#define WT_IER_ALARMDIS_MASK 0x10
#define WT_IER_ALARMDIS 0x10
#define WT_IER_ALARMDIS_BIT 4

#define WT_IDR (*(volatile unsigned long *)0xFFFA4078)
#define WT_IDR_OFFSET 0x78
#define WT_IDR_ALARM_MASK 0x1
#define WT_IDR_ALARM 0x1
#define WT_IDR_ALARM_BIT 0
#define WT_IDR_SECSEN_MASK 0x2
#define WT_IDR_SECSEN 0x2
#define WT_IDR_SECSEN_BIT 1
#define WT_IDR_SECSDIS_MASK 0x4
#define WT_IDR_SECSDIS 0x4
#define WT_IDR_SECSDIS_BIT 2
#define WT_IDR_ALARMEN_MASK 0x8
#define WT_IDR_ALARMEN 0x8
#define WT_IDR_ALARMEN_BIT 3
#define WT_IDR_ALARMDIS_MASK 0x10
#define WT_IDR_ALARMDIS 0x10
#define WT_IDR_ALARMDIS_BIT 4

#define WT_IMR (*(volatile unsigned long *)0xFFFA407C)
#define WT_IMR_OFFSET 0x7C
#define WT_IMR_ALARM_MASK 0x1
#define WT_IMR_ALARM 0x1
#define WT_IMR_ALARM_BIT 0
#define WT_IMR_SECSEN_MASK 0x2
#define WT_IMR_SECSEN 0x2
#define WT_IMR_SECSEN_BIT 1
#define WT_IMR_SECSDIS_MASK 0x4
#define WT_IMR_SECSDIS 0x4
#define WT_IMR_SECSDIS_BIT 2
#define WT_IMR_ALARMEN_MASK 0x8
#define WT_IMR_ALARMEN 0x8
#define WT_IMR_ALARMEN_BIT 3
#define WT_IMR_ALARMDIS_MASK 0x10
#define WT_IMR_ALARMDIS 0x10
#define WT_IMR_ALARMDIS_BIT 4

#define WT_SECS (*(volatile unsigned long *)0xFFFA4080)
#define WT_SECS_OFFSET 0x80
#define WT_SECS_SECONDS_MASK 0x0
#define WT_SECS_SECONDS_BIT 0

#define WT_ALARM (*(volatile unsigned long *)0xFFFA4084)
#define WT_ALARM_OFFSET 0x84
#define WT_ALARM_ALARMREG_MASK 0x0
#define WT_ALARM_ALARMREG_BIT 0

#define USART0_BASE 0xFFFA8000

#define US0_PER (*(volatile unsigned long *)0xFFFA8000)
#define US0_PER_OFFSET 0x0
#define US0_PER_SCK_MASK 0x10000
#define US0_PER_SCK 0x10000
#define US0_PER_SCK_BIT 16
#define US0_PER_TXD_MASK 0x20000
#define US0_PER_TXD 0x20000
#define US0_PER_TXD_BIT 17
#define US0_PER_RXD_MASK 0x40000
#define US0_PER_RXD 0x40000
#define US0_PER_RXD_BIT 18

#define US0_PDR (*(volatile unsigned long *)0xFFFA8004)
#define US0_PDR_OFFSET 0x4
#define US0_PDR_SCK_MASK 0x10000
#define US0_PDR_SCK 0x10000
#define US0_PDR_SCK_BIT 16
#define US0_PDR_TXD_MASK 0x20000
#define US0_PDR_TXD 0x20000
#define US0_PDR_TXD_BIT 17
#define US0_PDR_RXD_MASK 0x40000
#define US0_PDR_RXD 0x40000
#define US0_PDR_RXD_BIT 18

#define US0_PSR (*(volatile unsigned long *)0xFFFA8008)
#define US0_PSR_OFFSET 0x8
#define US0_PSR_SCK_MASK 0x10000
#define US0_PSR_SCK 0x10000
#define US0_PSR_SCK_BIT 16
#define US0_PSR_TXD_MASK 0x20000
#define US0_PSR_TXD 0x20000
#define US0_PSR_TXD_BIT 17
#define US0_PSR_RXD_MASK 0x40000
#define US0_PSR_RXD 0x40000
#define US0_PSR_RXD_BIT 18

#define US0_OER (*(volatile unsigned long *)0xFFFA8010)
#define US0_OER_OFFSET 0x10
#define US0_OER_SCK_MASK 0x10000
#define US0_OER_SCK 0x10000
#define US0_OER_SCK_BIT 16
#define US0_OER_TXD_MASK 0x20000
#define US0_OER_TXD 0x20000
#define US0_OER_TXD_BIT 17
#define US0_OER_RXD_MASK 0x40000
#define US0_OER_RXD 0x40000
#define US0_OER_RXD_BIT 18

#define US0_ODR (*(volatile unsigned long *)0xFFFA8014)
#define US0_ODR_OFFSET 0x14
#define US0_ODR_SCK_MASK 0x10000
#define US0_ODR_SCK 0x10000
#define US0_ODR_SCK_BIT 16
#define US0_ODR_TXD_MASK 0x20000
#define US0_ODR_TXD 0x20000
#define US0_ODR_TXD_BIT 17
#define US0_ODR_RXD_MASK 0x40000
#define US0_ODR_RXD 0x40000
#define US0_ODR_RXD_BIT 18

#define US0_OSR (*(volatile unsigned long *)0xFFFA8018)
#define US0_OSR_OFFSET 0x18
#define US0_OSR_SCK_MASK 0x10000
#define US0_OSR_SCK 0x10000
#define US0_OSR_SCK_BIT 16
#define US0_OSR_TXD_MASK 0x20000
#define US0_OSR_TXD 0x20000
#define US0_OSR_TXD_BIT 17
#define US0_OSR_RXD_MASK 0x40000
#define US0_OSR_RXD 0x40000
#define US0_OSR_RXD_BIT 18

#define US0_SODR (*(volatile unsigned long *)0xFFFA8030)
#define US0_SODR_OFFSET 0x30
#define US0_SODR_SCK_MASK 0x10000
#define US0_SODR_SCK 0x10000
#define US0_SODR_SCK_BIT 16
#define US0_SODR_TXD_MASK 0x20000
#define US0_SODR_TXD 0x20000
#define US0_SODR_TXD_BIT 17
#define US0_SODR_RXD_MASK 0x40000
#define US0_SODR_RXD 0x40000
#define US0_SODR_RXD_BIT 18

#define US0_CODR (*(volatile unsigned long *)0xFFFA8034)
#define US0_CODR_OFFSET 0x34
#define US0_CODR_SCK_MASK 0x10000
#define US0_CODR_SCK 0x10000
#define US0_CODR_SCK_BIT 16
#define US0_CODR_TXD_MASK 0x20000
#define US0_CODR_TXD 0x20000
#define US0_CODR_TXD_BIT 17
#define US0_CODR_RXD_MASK 0x40000
#define US0_CODR_RXD 0x40000
#define US0_CODR_RXD_BIT 18

#define US0_ODSR (*(volatile unsigned long *)0xFFFA8038)
#define US0_ODSR_OFFSET 0x38
#define US0_ODSR_SCK_MASK 0x10000
#define US0_ODSR_SCK 0x10000
#define US0_ODSR_SCK_BIT 16
#define US0_ODSR_TXD_MASK 0x20000
#define US0_ODSR_TXD 0x20000
#define US0_ODSR_TXD_BIT 17
#define US0_ODSR_RXD_MASK 0x40000
#define US0_ODSR_RXD 0x40000
#define US0_ODSR_RXD_BIT 18

#define US0_PDSR (*(volatile unsigned long *)0xFFFA803C)
#define US0_PDSR_OFFSET 0x3C
#define US0_PDSR_SCK_MASK 0x10000
#define US0_PDSR_SCK 0x10000
#define US0_PDSR_SCK_BIT 16
#define US0_PDSR_TXD_MASK 0x20000
#define US0_PDSR_TXD 0x20000
#define US0_PDSR_TXD_BIT 17
#define US0_PDSR_RXD_MASK 0x40000
#define US0_PDSR_RXD 0x40000
#define US0_PDSR_RXD_BIT 18

#define US0_MDER (*(volatile unsigned long *)0xFFFA8040)
#define US0_MDER_OFFSET 0x40
#define US0_MDER_SCK_MASK 0x10000
#define US0_MDER_SCK 0x10000
#define US0_MDER_SCK_BIT 16
#define US0_MDER_TXD_MASK 0x20000
#define US0_MDER_TXD 0x20000
#define US0_MDER_TXD_BIT 17
#define US0_MDER_RXD_MASK 0x40000
#define US0_MDER_RXD 0x40000
#define US0_MDER_RXD_BIT 18

#define US0_MDDR (*(volatile unsigned long *)0xFFFA8044)
#define US0_MDDR_OFFSET 0x44
#define US0_MDDR_SCK_MASK 0x10000
#define US0_MDDR_SCK 0x10000
#define US0_MDDR_SCK_BIT 16
#define US0_MDDR_TXD_MASK 0x20000
#define US0_MDDR_TXD 0x20000
#define US0_MDDR_TXD_BIT 17
#define US0_MDDR_RXD_MASK 0x40000
#define US0_MDDR_RXD 0x40000
#define US0_MDDR_RXD_BIT 18

#define US0_MDSR (*(volatile unsigned long *)0xFFFA8048)
#define US0_MDSR_OFFSET 0x48
#define US0_MDSR_SCK_MASK 0x10000
#define US0_MDSR_SCK 0x10000
#define US0_MDSR_SCK_BIT 16
#define US0_MDSR_TXD_MASK 0x20000
#define US0_MDSR_TXD 0x20000
#define US0_MDSR_TXD_BIT 17
#define US0_MDSR_RXD_MASK 0x40000
#define US0_MDSR_RXD 0x40000
#define US0_MDSR_RXD_BIT 18

#define US0_ECR (*(volatile unsigned long *)0xFFFA8050)
#define US0_ECR_OFFSET 0x50
#define US0_ECR_PIO_MASK 0x1
#define US0_ECR_PIO 0x1
#define US0_ECR_PIO_BIT 0
#define US0_ECR_USART_MASK 0x2
#define US0_ECR_USART 0x2
#define US0_ECR_USART_BIT 1

#define US0_DCR (*(volatile unsigned long *)0xFFFA8054)
#define US0_DCR_OFFSET 0x54
#define US0_DCR_PIO_MASK 0x1
#define US0_DCR_PIO 0x1
#define US0_DCR_PIO_BIT 0
#define US0_DCR_USART_MASK 0x2
#define US0_DCR_USART 0x2
#define US0_DCR_USART_BIT 1

#define US0_PMSR (*(volatile unsigned long *)0xFFFA8058)
#define US0_PMSR_OFFSET 0x58
#define US0_PMSR_PIO_MASK 0x1
#define US0_PMSR_PIO 0x1
#define US0_PMSR_PIO_BIT 0
#define US0_PMSR_USART_MASK 0x2
#define US0_PMSR_USART 0x2
#define US0_PMSR_USART_BIT 1

#define US0_CR (*(volatile unsigned long *)0xFFFA8060)
#define US0_CR_OFFSET 0x60
#define US0_CR_SWRST_MASK 0x1
#define US0_CR_SWRST 0x1
#define US0_CR_SWRST_BIT 0
#define US0_CR_RSTRX_MASK 0x4
#define US0_CR_RSTRX 0x4
#define US0_CR_RSTRX_BIT 2
#define US0_CR_RSTTX_MASK 0x8
#define US0_CR_RSTTX 0x8
#define US0_CR_RSTTX_BIT 3
#define US0_CR_RXEN_MASK 0x10
#define US0_CR_RXEN 0x10
#define US0_CR_RXEN_BIT 4
#define US0_CR_RXDIS_MASK 0x20
#define US0_CR_RXDIS 0x20
#define US0_CR_RXDIS_BIT 5
#define US0_CR_TXEN_MASK 0x40
#define US0_CR_TXEN 0x40
#define US0_CR_TXEN_BIT 6
#define US0_CR_TXDIS_MASK 0x80
#define US0_CR_TXDIS 0x80
#define US0_CR_TXDIS_BIT 7
#define US0_CR_RSTSTA_MASK 0x100
#define US0_CR_RSTSTA 0x100
#define US0_CR_RSTSTA_BIT 8
#define US0_CR_STTBRK_MASK 0x200
#define US0_CR_STTBRK 0x200
#define US0_CR_STTBRK_BIT 9
#define US0_CR_STPBRK_MASK 0x400
#define US0_CR_STPBRK 0x400
#define US0_CR_STPBRK_BIT 10
#define US0_CR_STTTO_MASK 0x800
#define US0_CR_STTTO 0x800
#define US0_CR_STTTO_BIT 11
#define US0_CR_SENDA_MASK 0x1000
#define US0_CR_SENDA 0x1000
#define US0_CR_SENDA_BIT 12

#define US0_MR (*(volatile unsigned long *)0xFFFA8064)
#define US0_MR_OFFSET 0x64
#define US0_MR_USCLKS_MASK 0x30
#define US0_MR_USCLKS_BIT 4
#define US0_MR_CHRL_MASK 0xC0
#define US0_MR_CHRL_BIT 6
#define US0_MR_SYNC_MASK 0x100
#define US0_MR_SYNC 0x100
#define US0_MR_SYNC_BIT 8
#define US0_MR_PAR_MASK 0xE00
#define US0_MR_PAR_BIT 9
#define US0_MR_NBSTOP_MASK 0x3000
#define US0_MR_NBSTOP_BIT 12
#define US0_MR_CHMODE_MASK 0xC000
#define US0_MR_CHMODE_BIT 14
#define US0_MR_MODE9_MASK 0x20000
#define US0_MR_MODE9 0x20000
#define US0_MR_MODE9_BIT 17
#define US0_MR_CLKO_MASK 0x40000
#define US0_MR_CLKO 0x40000
#define US0_MR_CLKO_BIT 18

#define US0_SR (*(volatile unsigned long *)0xFFFA8070)
#define US0_SR_OFFSET 0x70
#define US0_SR_RXRDY_MASK 0x1
#define US0_SR_RXRDY 0x1
#define US0_SR_RXRDY_BIT 0
#define US0_SR_TXRDY_MASK 0x2
#define US0_SR_TXRDY 0x2
#define US0_SR_TXRDY_BIT 1
#define US0_SR_RXBRK_MASK 0x4
#define US0_SR_RXBRK 0x4
#define US0_SR_RXBRK_BIT 2
#define US0_SR_ENDRX_MASK 0x8
#define US0_SR_ENDRX 0x8
#define US0_SR_ENDRX_BIT 3
#define US0_SR_ENDTX_MASK 0x10
#define US0_SR_ENDTX 0x10
#define US0_SR_ENDTX_BIT 4
#define US0_SR_USOVRE_MASK 0x20
#define US0_SR_USOVRE 0x20
#define US0_SR_USOVRE_BIT 5
#define US0_SR_FRAME_MASK 0x40
#define US0_SR_FRAME 0x40
#define US0_SR_FRAME_BIT 6
#define US0_SR_PARE_MASK 0x80
#define US0_SR_PARE 0x80
#define US0_SR_PARE_BIT 7
#define US0_SR_TIMEOUT_MASK 0x100
#define US0_SR_TIMEOUT 0x100
#define US0_SR_TIMEOUT_BIT 8
#define US0_SR_TXEMPTY_MASK 0x200
#define US0_SR_TXEMPTY 0x200
#define US0_SR_TXEMPTY_BIT 9
#define US0_SR_IDLE_MASK 0x400
#define US0_SR_IDLE 0x400
#define US0_SR_IDLE_BIT 10
#define US0_SR_IDLEFLAG_MASK 0x800
#define US0_SR_IDLEFLAG 0x800
#define US0_SR_IDLEFLAG_BIT 11
#define US0_SR_SCK_MASK 0x10000
#define US0_SR_SCK 0x10000
#define US0_SR_SCK_BIT 16
#define US0_SR_TXD_MASK 0x20000
#define US0_SR_TXD 0x20000
#define US0_SR_TXD_BIT 17
#define US0_SR_RXD_MASK 0x40000
#define US0_SR_RXD 0x40000
#define US0_SR_RXD_BIT 18

#define US0_IER (*(volatile unsigned long *)0xFFFA8074)
#define US0_IER_OFFSET 0x74
#define US0_IER_RXRDY_MASK 0x1
#define US0_IER_RXRDY 0x1
#define US0_IER_RXRDY_BIT 0
#define US0_IER_TXRDY_MASK 0x2
#define US0_IER_TXRDY 0x2
#define US0_IER_TXRDY_BIT 1
#define US0_IER_RXBRK_MASK 0x4
#define US0_IER_RXBRK 0x4
#define US0_IER_RXBRK_BIT 2
#define US0_IER_ENDRX_MASK 0x8
#define US0_IER_ENDRX 0x8
#define US0_IER_ENDRX_BIT 3
#define US0_IER_ENDTX_MASK 0x10
#define US0_IER_ENDTX 0x10
#define US0_IER_ENDTX_BIT 4
#define US0_IER_USOVRE_MASK 0x20
#define US0_IER_USOVRE 0x20
#define US0_IER_USOVRE_BIT 5
#define US0_IER_FRAME_MASK 0x40
#define US0_IER_FRAME 0x40
#define US0_IER_FRAME_BIT 6
#define US0_IER_PARE_MASK 0x80
#define US0_IER_PARE 0x80
#define US0_IER_PARE_BIT 7
#define US0_IER_TIMEOUT_MASK 0x100
#define US0_IER_TIMEOUT 0x100
#define US0_IER_TIMEOUT_BIT 8
#define US0_IER_TXEMPTY_MASK 0x200
#define US0_IER_TXEMPTY 0x200
#define US0_IER_TXEMPTY_BIT 9
#define US0_IER_IDLE_MASK 0x400
#define US0_IER_IDLE 0x400
#define US0_IER_IDLE_BIT 10
#define US0_IER_SCK_MASK 0x10000
#define US0_IER_SCK 0x10000
#define US0_IER_SCK_BIT 16
#define US0_IER_TXD_MASK 0x20000
#define US0_IER_TXD 0x20000
#define US0_IER_TXD_BIT 17
#define US0_IER_RXD_MASK 0x40000
#define US0_IER_RXD 0x40000
#define US0_IER_RXD_BIT 18

#define US0_IDR (*(volatile unsigned long *)0xFFFA8078)
#define US0_IDR_OFFSET 0x78
#define US0_IDR_RXRDY_MASK 0x1
#define US0_IDR_RXRDY 0x1
#define US0_IDR_RXRDY_BIT 0
#define US0_IDR_TXRDY_MASK 0x2
#define US0_IDR_TXRDY 0x2
#define US0_IDR_TXRDY_BIT 1
#define US0_IDR_RXBRK_MASK 0x4
#define US0_IDR_RXBRK 0x4
#define US0_IDR_RXBRK_BIT 2
#define US0_IDR_ENDRX_MASK 0x8
#define US0_IDR_ENDRX 0x8
#define US0_IDR_ENDRX_BIT 3
#define US0_IDR_ENDTX_MASK 0x10
#define US0_IDR_ENDTX 0x10
#define US0_IDR_ENDTX_BIT 4
#define US0_IDR_USOVRE_MASK 0x20
#define US0_IDR_USOVRE 0x20
#define US0_IDR_USOVRE_BIT 5
#define US0_IDR_FRAME_MASK 0x40
#define US0_IDR_FRAME 0x40
#define US0_IDR_FRAME_BIT 6
#define US0_IDR_PARE_MASK 0x80
#define US0_IDR_PARE 0x80
#define US0_IDR_PARE_BIT 7
#define US0_IDR_TIMEOUT_MASK 0x100
#define US0_IDR_TIMEOUT 0x100
#define US0_IDR_TIMEOUT_BIT 8
#define US0_IDR_TXEMPTY_MASK 0x200
#define US0_IDR_TXEMPTY 0x200
#define US0_IDR_TXEMPTY_BIT 9
#define US0_IDR_IDLE_MASK 0x400
#define US0_IDR_IDLE 0x400
#define US0_IDR_IDLE_BIT 10
#define US0_IDR_SCK_MASK 0x10000
#define US0_IDR_SCK 0x10000
#define US0_IDR_SCK_BIT 16
#define US0_IDR_TXD_MASK 0x20000
#define US0_IDR_TXD 0x20000
#define US0_IDR_TXD_BIT 17
#define US0_IDR_RXD_MASK 0x40000
#define US0_IDR_RXD 0x40000
#define US0_IDR_RXD_BIT 18

#define US0_IMR (*(volatile unsigned long *)0xFFFA807C)
#define US0_IMR_OFFSET 0x7C
#define US0_IMR_RXRDY_MASK 0x1
#define US0_IMR_RXRDY 0x1
#define US0_IMR_RXRDY_BIT 0
#define US0_IMR_TXRDY_MASK 0x2
#define US0_IMR_TXRDY 0x2
#define US0_IMR_TXRDY_BIT 1
#define US0_IMR_RXBRK_MASK 0x4
#define US0_IMR_RXBRK 0x4
#define US0_IMR_RXBRK_BIT 2
#define US0_IMR_ENDRX_MASK 0x8
#define US0_IMR_ENDRX 0x8
#define US0_IMR_ENDRX_BIT 3
#define US0_IMR_ENDTX_MASK 0x10
#define US0_IMR_ENDTX 0x10
#define US0_IMR_ENDTX_BIT 4
#define US0_IMR_USOVRE_MASK 0x20
#define US0_IMR_USOVRE 0x20
#define US0_IMR_USOVRE_BIT 5
#define US0_IMR_FRAME_MASK 0x40
#define US0_IMR_FRAME 0x40
#define US0_IMR_FRAME_BIT 6
#define US0_IMR_PARE_MASK 0x80
#define US0_IMR_PARE 0x80
#define US0_IMR_PARE_BIT 7
#define US0_IMR_TIMEOUT_MASK 0x100
#define US0_IMR_TIMEOUT 0x100
#define US0_IMR_TIMEOUT_BIT 8
#define US0_IMR_TXEMPTY_MASK 0x200
#define US0_IMR_TXEMPTY 0x200
#define US0_IMR_TXEMPTY_BIT 9
#define US0_IMR_IDLE_MASK 0x400
#define US0_IMR_IDLE 0x400
#define US0_IMR_IDLE_BIT 10
#define US0_IMR_SCK_MASK 0x10000
#define US0_IMR_SCK 0x10000
#define US0_IMR_SCK_BIT 16
#define US0_IMR_TXD_MASK 0x20000
#define US0_IMR_TXD 0x20000
#define US0_IMR_TXD_BIT 17
#define US0_IMR_RXD_MASK 0x40000
#define US0_IMR_RXD 0x40000
#define US0_IMR_RXD_BIT 18

#define US0_RHR (*(volatile unsigned long *)0xFFFA8080)
#define US0_RHR_OFFSET 0x80
#define US0_RHR_RXCHR_MASK 0x1FF
#define US0_RHR_RXCHR_BIT 0

#define US0_THR (*(volatile unsigned long *)0xFFFA8084)
#define US0_THR_OFFSET 0x84
#define US0_THR_TXCHR_MASK 0x1FF
#define US0_THR_TXCHR_BIT 0

#define US0_BRGR (*(volatile unsigned long *)0xFFFA8088)
#define US0_BRGR_OFFSET 0x88
#define US0_BRGR_CD_MASK 0xFFFF
#define US0_BRGR_CD_BIT 0

#define US0_RTOR (*(volatile unsigned long *)0xFFFA808C)
#define US0_RTOR_OFFSET 0x8C
#define US0_RTOR_TO_MASK 0xFF
#define US0_RTOR_TO_BIT 0

#define US0_TTGR (*(volatile unsigned long *)0xFFFA8090)
#define US0_TTGR_OFFSET 0x90
#define US0_TTGR_TG_MASK 0xFF
#define US0_TTGR_TG_BIT 0

#define USART1_BASE 0xFFFAC000

#define US1_PER (*(volatile unsigned long *)0xFFFAC000)
#define US1_PER_OFFSET 0x0
#define US1_PER_SCK_MASK 0x10000
#define US1_PER_SCK 0x10000
#define US1_PER_SCK_BIT 16
#define US1_PER_TXD_MASK 0x20000
#define US1_PER_TXD 0x20000
#define US1_PER_TXD_BIT 17
#define US1_PER_RXD_MASK 0x40000
#define US1_PER_RXD 0x40000
#define US1_PER_RXD_BIT 18

#define US1_PDR (*(volatile unsigned long *)0xFFFAC004)
#define US1_PDR_OFFSET 0x4
#define US1_PDR_SCK_MASK 0x10000
#define US1_PDR_SCK 0x10000
#define US1_PDR_SCK_BIT 16
#define US1_PDR_TXD_MASK 0x20000
#define US1_PDR_TXD 0x20000
#define US1_PDR_TXD_BIT 17
#define US1_PDR_RXD_MASK 0x40000
#define US1_PDR_RXD 0x40000
#define US1_PDR_RXD_BIT 18

#define US1_PSR (*(volatile unsigned long *)0xFFFAC008)
#define US1_PSR_OFFSET 0x8
#define US1_PSR_SCK_MASK 0x10000
#define US1_PSR_SCK 0x10000
#define US1_PSR_SCK_BIT 16
#define US1_PSR_TXD_MASK 0x20000
#define US1_PSR_TXD 0x20000
#define US1_PSR_TXD_BIT 17
#define US1_PSR_RXD_MASK 0x40000
#define US1_PSR_RXD 0x40000
#define US1_PSR_RXD_BIT 18

#define US1_OER (*(volatile unsigned long *)0xFFFAC010)
#define US1_OER_OFFSET 0x10
#define US1_OER_SCK_MASK 0x10000
#define US1_OER_SCK 0x10000
#define US1_OER_SCK_BIT 16
#define US1_OER_TXD_MASK 0x20000
#define US1_OER_TXD 0x20000
#define US1_OER_TXD_BIT 17
#define US1_OER_RXD_MASK 0x40000
#define US1_OER_RXD 0x40000
#define US1_OER_RXD_BIT 18

#define US1_ODR (*(volatile unsigned long *)0xFFFAC014)
#define US1_ODR_OFFSET 0x14
#define US1_ODR_SCK_MASK 0x10000
#define US1_ODR_SCK 0x10000
#define US1_ODR_SCK_BIT 16
#define US1_ODR_TXD_MASK 0x20000
#define US1_ODR_TXD 0x20000
#define US1_ODR_TXD_BIT 17
#define US1_ODR_RXD_MASK 0x40000
#define US1_ODR_RXD 0x40000
#define US1_ODR_RXD_BIT 18

#define US1_OSR (*(volatile unsigned long *)0xFFFAC018)
#define US1_OSR_OFFSET 0x18
#define US1_OSR_SCK_MASK 0x10000
#define US1_OSR_SCK 0x10000
#define US1_OSR_SCK_BIT 16
#define US1_OSR_TXD_MASK 0x20000
#define US1_OSR_TXD 0x20000
#define US1_OSR_TXD_BIT 17
#define US1_OSR_RXD_MASK 0x40000
#define US1_OSR_RXD 0x40000
#define US1_OSR_RXD_BIT 18

#define US1_SODR (*(volatile unsigned long *)0xFFFAC030)
#define US1_SODR_OFFSET 0x30
#define US1_SODR_SCK_MASK 0x10000
#define US1_SODR_SCK 0x10000
#define US1_SODR_SCK_BIT 16
#define US1_SODR_TXD_MASK 0x20000
#define US1_SODR_TXD 0x20000
#define US1_SODR_TXD_BIT 17
#define US1_SODR_RXD_MASK 0x40000
#define US1_SODR_RXD 0x40000
#define US1_SODR_RXD_BIT 18

#define US1_CODR (*(volatile unsigned long *)0xFFFAC034)
#define US1_CODR_OFFSET 0x34
#define US1_CODR_SCK_MASK 0x10000
#define US1_CODR_SCK 0x10000
#define US1_CODR_SCK_BIT 16
#define US1_CODR_TXD_MASK 0x20000
#define US1_CODR_TXD 0x20000
#define US1_CODR_TXD_BIT 17
#define US1_CODR_RXD_MASK 0x40000
#define US1_CODR_RXD 0x40000
#define US1_CODR_RXD_BIT 18

#define US1_ODSR (*(volatile unsigned long *)0xFFFAC038)
#define US1_ODSR_OFFSET 0x38
#define US1_ODSR_SCK_MASK 0x10000
#define US1_ODSR_SCK 0x10000
#define US1_ODSR_SCK_BIT 16
#define US1_ODSR_TXD_MASK 0x20000
#define US1_ODSR_TXD 0x20000
#define US1_ODSR_TXD_BIT 17
#define US1_ODSR_RXD_MASK 0x40000
#define US1_ODSR_RXD 0x40000
#define US1_ODSR_RXD_BIT 18

#define US1_PDSR (*(volatile unsigned long *)0xFFFAC03C)
#define US1_PDSR_OFFSET 0x3C
#define US1_PDSR_SCK_MASK 0x10000
#define US1_PDSR_SCK 0x10000
#define US1_PDSR_SCK_BIT 16
#define US1_PDSR_TXD_MASK 0x20000
#define US1_PDSR_TXD 0x20000
#define US1_PDSR_TXD_BIT 17
#define US1_PDSR_RXD_MASK 0x40000
#define US1_PDSR_RXD 0x40000
#define US1_PDSR_RXD_BIT 18

#define US1_MDER (*(volatile unsigned long *)0xFFFAC040)
#define US1_MDER_OFFSET 0x40
#define US1_MDER_SCK_MASK 0x10000
#define US1_MDER_SCK 0x10000
#define US1_MDER_SCK_BIT 16
#define US1_MDER_TXD_MASK 0x20000
#define US1_MDER_TXD 0x20000
#define US1_MDER_TXD_BIT 17
#define US1_MDER_RXD_MASK 0x40000
#define US1_MDER_RXD 0x40000
#define US1_MDER_RXD_BIT 18

#define US1_MDDR (*(volatile unsigned long *)0xFFFAC044)
#define US1_MDDR_OFFSET 0x44
#define US1_MDDR_SCK_MASK 0x10000
#define US1_MDDR_SCK 0x10000
#define US1_MDDR_SCK_BIT 16
#define US1_MDDR_TXD_MASK 0x20000
#define US1_MDDR_TXD 0x20000
#define US1_MDDR_TXD_BIT 17
#define US1_MDDR_RXD_MASK 0x40000
#define US1_MDDR_RXD 0x40000
#define US1_MDDR_RXD_BIT 18

#define US1_MDSR (*(volatile unsigned long *)0xFFFAC048)
#define US1_MDSR_OFFSET 0x48
#define US1_MDSR_SCK_MASK 0x10000
#define US1_MDSR_SCK 0x10000
#define US1_MDSR_SCK_BIT 16
#define US1_MDSR_TXD_MASK 0x20000
#define US1_MDSR_TXD 0x20000
#define US1_MDSR_TXD_BIT 17
#define US1_MDSR_RXD_MASK 0x40000
#define US1_MDSR_RXD 0x40000
#define US1_MDSR_RXD_BIT 18

#define US1_ECR (*(volatile unsigned long *)0xFFFAC050)
#define US1_ECR_OFFSET 0x50
#define US1_ECR_PIO_MASK 0x1
#define US1_ECR_PIO 0x1
#define US1_ECR_PIO_BIT 0
#define US1_ECR_USART_MASK 0x2
#define US1_ECR_USART 0x2
#define US1_ECR_USART_BIT 1

#define US1_DCR (*(volatile unsigned long *)0xFFFAC054)
#define US1_DCR_OFFSET 0x54
#define US1_DCR_PIO_MASK 0x1
#define US1_DCR_PIO 0x1
#define US1_DCR_PIO_BIT 0
#define US1_DCR_USART_MASK 0x2
#define US1_DCR_USART 0x2
#define US1_DCR_USART_BIT 1

#define US1_PMSR (*(volatile unsigned long *)0xFFFAC058)
#define US1_PMSR_OFFSET 0x58
#define US1_PMSR_PIO_MASK 0x1
#define US1_PMSR_PIO 0x1
#define US1_PMSR_PIO_BIT 0
#define US1_PMSR_USART_MASK 0x2
#define US1_PMSR_USART 0x2
#define US1_PMSR_USART_BIT 1

#define US1_CR (*(volatile unsigned long *)0xFFFAC060)
#define US1_CR_OFFSET 0x60
#define US1_CR_SWRST_MASK 0x1
#define US1_CR_SWRST 0x1
#define US1_CR_SWRST_BIT 0
#define US1_CR_RSTRX_MASK 0x4
#define US1_CR_RSTRX 0x4
#define US1_CR_RSTRX_BIT 2
#define US1_CR_RSTTX_MASK 0x8
#define US1_CR_RSTTX 0x8
#define US1_CR_RSTTX_BIT 3
#define US1_CR_RXEN_MASK 0x10
#define US1_CR_RXEN 0x10
#define US1_CR_RXEN_BIT 4
#define US1_CR_RXDIS_MASK 0x20
#define US1_CR_RXDIS 0x20
#define US1_CR_RXDIS_BIT 5
#define US1_CR_TXEN_MASK 0x40
#define US1_CR_TXEN 0x40
#define US1_CR_TXEN_BIT 6
#define US1_CR_TXDIS_MASK 0x80
#define US1_CR_TXDIS 0x80
#define US1_CR_TXDIS_BIT 7
#define US1_CR_RSTSTA_MASK 0x100
#define US1_CR_RSTSTA 0x100
#define US1_CR_RSTSTA_BIT 8
#define US1_CR_STTBRK_MASK 0x200
#define US1_CR_STTBRK 0x200
#define US1_CR_STTBRK_BIT 9
#define US1_CR_STPBRK_MASK 0x400
#define US1_CR_STPBRK 0x400
#define US1_CR_STPBRK_BIT 10
#define US1_CR_STTTO_MASK 0x800
#define US1_CR_STTTO 0x800
#define US1_CR_STTTO_BIT 11
#define US1_CR_SENDA_MASK 0x1000
#define US1_CR_SENDA 0x1000
#define US1_CR_SENDA_BIT 12

#define US1_MR (*(volatile unsigned long *)0xFFFAC064)
#define US1_MR_OFFSET 0x64
#define US1_MR_USCLKS_MASK 0x30
#define US1_MR_USCLKS_BIT 4
#define US1_MR_CHRL_MASK 0xC0
#define US1_MR_CHRL_BIT 6
#define US1_MR_SYNC_MASK 0x100
#define US1_MR_SYNC 0x100
#define US1_MR_SYNC_BIT 8
#define US1_MR_PAR_MASK 0xE00
#define US1_MR_PAR_BIT 9
#define US1_MR_NBSTOP_MASK 0x3000
#define US1_MR_NBSTOP_BIT 12
#define US1_MR_CHMODE_MASK 0xC000
#define US1_MR_CHMODE_BIT 14
#define US1_MR_MODE9_MASK 0x20000
#define US1_MR_MODE9 0x20000
#define US1_MR_MODE9_BIT 17
#define US1_MR_CLKO_MASK 0x40000
#define US1_MR_CLKO 0x40000
#define US1_MR_CLKO_BIT 18

#define US1_SR (*(volatile unsigned long *)0xFFFAC070)
#define US1_SR_OFFSET 0x70
#define US1_SR_RXRDY_MASK 0x1
#define US1_SR_RXRDY 0x1
#define US1_SR_RXRDY_BIT 0
#define US1_SR_TXRDY_MASK 0x2
#define US1_SR_TXRDY 0x2
#define US1_SR_TXRDY_BIT 1
#define US1_SR_RXBRK_MASK 0x4
#define US1_SR_RXBRK 0x4
#define US1_SR_RXBRK_BIT 2
#define US1_SR_ENDRX_MASK 0x8
#define US1_SR_ENDRX 0x8
#define US1_SR_ENDRX_BIT 3
#define US1_SR_ENDTX_MASK 0x10
#define US1_SR_ENDTX 0x10
#define US1_SR_ENDTX_BIT 4
#define US1_SR_USOVRE_MASK 0x20
#define US1_SR_USOVRE 0x20
#define US1_SR_USOVRE_BIT 5
#define US1_SR_FRAME_MASK 0x40
#define US1_SR_FRAME 0x40
#define US1_SR_FRAME_BIT 6
#define US1_SR_PARE_MASK 0x80
#define US1_SR_PARE 0x80
#define US1_SR_PARE_BIT 7
#define US1_SR_TIMEOUT_MASK 0x100
#define US1_SR_TIMEOUT 0x100
#define US1_SR_TIMEOUT_BIT 8
#define US1_SR_TXEMPTY_MASK 0x200
#define US1_SR_TXEMPTY 0x200
#define US1_SR_TXEMPTY_BIT 9
#define US1_SR_IDLE_MASK 0x400
#define US1_SR_IDLE 0x400
#define US1_SR_IDLE_BIT 10
#define US1_SR_IDLEFLAG_MASK 0x800
#define US1_SR_IDLEFLAG 0x800
#define US1_SR_IDLEFLAG_BIT 11
#define US1_SR_SCK_MASK 0x10000
#define US1_SR_SCK 0x10000
#define US1_SR_SCK_BIT 16
#define US1_SR_TXD_MASK 0x20000
#define US1_SR_TXD 0x20000
#define US1_SR_TXD_BIT 17
#define US1_SR_RXD_MASK 0x40000
#define US1_SR_RXD 0x40000
#define US1_SR_RXD_BIT 18

#define US1_IER (*(volatile unsigned long *)0xFFFAC074)
#define US1_IER_OFFSET 0x74
#define US1_IER_RXRDY_MASK 0x1
#define US1_IER_RXRDY 0x1
#define US1_IER_RXRDY_BIT 0
#define US1_IER_TXRDY_MASK 0x2
#define US1_IER_TXRDY 0x2
#define US1_IER_TXRDY_BIT 1
#define US1_IER_RXBRK_MASK 0x4
#define US1_IER_RXBRK 0x4
#define US1_IER_RXBRK_BIT 2
#define US1_IER_ENDRX_MASK 0x8
#define US1_IER_ENDRX 0x8
#define US1_IER_ENDRX_BIT 3
#define US1_IER_ENDTX_MASK 0x10
#define US1_IER_ENDTX 0x10
#define US1_IER_ENDTX_BIT 4
#define US1_IER_USOVRE_MASK 0x20
#define US1_IER_USOVRE 0x20
#define US1_IER_USOVRE_BIT 5
#define US1_IER_FRAME_MASK 0x40
#define US1_IER_FRAME 0x40
#define US1_IER_FRAME_BIT 6
#define US1_IER_PARE_MASK 0x80
#define US1_IER_PARE 0x80
#define US1_IER_PARE_BIT 7
#define US1_IER_TIMEOUT_MASK 0x100
#define US1_IER_TIMEOUT 0x100
#define US1_IER_TIMEOUT_BIT 8
#define US1_IER_TXEMPTY_MASK 0x200
#define US1_IER_TXEMPTY 0x200
#define US1_IER_TXEMPTY_BIT 9
#define US1_IER_IDLE_MASK 0x400
#define US1_IER_IDLE 0x400
#define US1_IER_IDLE_BIT 10
#define US1_IER_SCK_MASK 0x10000
#define US1_IER_SCK 0x10000
#define US1_IER_SCK_BIT 16
#define US1_IER_TXD_MASK 0x20000
#define US1_IER_TXD 0x20000
#define US1_IER_TXD_BIT 17
#define US1_IER_RXD_MASK 0x40000
#define US1_IER_RXD 0x40000
#define US1_IER_RXD_BIT 18

#define US1_IDR (*(volatile unsigned long *)0xFFFAC078)
#define US1_IDR_OFFSET 0x78
#define US1_IDR_RXRDY_MASK 0x1
#define US1_IDR_RXRDY 0x1
#define US1_IDR_RXRDY_BIT 0
#define US1_IDR_TXRDY_MASK 0x2
#define US1_IDR_TXRDY 0x2
#define US1_IDR_TXRDY_BIT 1
#define US1_IDR_RXBRK_MASK 0x4
#define US1_IDR_RXBRK 0x4
#define US1_IDR_RXBRK_BIT 2
#define US1_IDR_ENDRX_MASK 0x8
#define US1_IDR_ENDRX 0x8
#define US1_IDR_ENDRX_BIT 3
#define US1_IDR_ENDTX_MASK 0x10
#define US1_IDR_ENDTX 0x10
#define US1_IDR_ENDTX_BIT 4
#define US1_IDR_USOVRE_MASK 0x20
#define US1_IDR_USOVRE 0x20
#define US1_IDR_USOVRE_BIT 5
#define US1_IDR_FRAME_MASK 0x40
#define US1_IDR_FRAME 0x40
#define US1_IDR_FRAME_BIT 6
#define US1_IDR_PARE_MASK 0x80
#define US1_IDR_PARE 0x80
#define US1_IDR_PARE_BIT 7
#define US1_IDR_TIMEOUT_MASK 0x100
#define US1_IDR_TIMEOUT 0x100
#define US1_IDR_TIMEOUT_BIT 8
#define US1_IDR_TXEMPTY_MASK 0x200
#define US1_IDR_TXEMPTY 0x200
#define US1_IDR_TXEMPTY_BIT 9
#define US1_IDR_IDLE_MASK 0x400
#define US1_IDR_IDLE 0x400
#define US1_IDR_IDLE_BIT 10
#define US1_IDR_SCK_MASK 0x10000
#define US1_IDR_SCK 0x10000
#define US1_IDR_SCK_BIT 16
#define US1_IDR_TXD_MASK 0x20000
#define US1_IDR_TXD 0x20000
#define US1_IDR_TXD_BIT 17
#define US1_IDR_RXD_MASK 0x40000
#define US1_IDR_RXD 0x40000
#define US1_IDR_RXD_BIT 18

#define US1_IMR (*(volatile unsigned long *)0xFFFAC07C)
#define US1_IMR_OFFSET 0x7C
#define US1_IMR_RXRDY_MASK 0x1
#define US1_IMR_RXRDY 0x1
#define US1_IMR_RXRDY_BIT 0
#define US1_IMR_TXRDY_MASK 0x2
#define US1_IMR_TXRDY 0x2
#define US1_IMR_TXRDY_BIT 1
#define US1_IMR_RXBRK_MASK 0x4
#define US1_IMR_RXBRK 0x4
#define US1_IMR_RXBRK_BIT 2
#define US1_IMR_ENDRX_MASK 0x8
#define US1_IMR_ENDRX 0x8
#define US1_IMR_ENDRX_BIT 3
#define US1_IMR_ENDTX_MASK 0x10
#define US1_IMR_ENDTX 0x10
#define US1_IMR_ENDTX_BIT 4
#define US1_IMR_USOVRE_MASK 0x20
#define US1_IMR_USOVRE 0x20
#define US1_IMR_USOVRE_BIT 5
#define US1_IMR_FRAME_MASK 0x40
#define US1_IMR_FRAME 0x40
#define US1_IMR_FRAME_BIT 6
#define US1_IMR_PARE_MASK 0x80
#define US1_IMR_PARE 0x80
#define US1_IMR_PARE_BIT 7
#define US1_IMR_TIMEOUT_MASK 0x100
#define US1_IMR_TIMEOUT 0x100
#define US1_IMR_TIMEOUT_BIT 8
#define US1_IMR_TXEMPTY_MASK 0x200
#define US1_IMR_TXEMPTY 0x200
#define US1_IMR_TXEMPTY_BIT 9
#define US1_IMR_IDLE_MASK 0x400
#define US1_IMR_IDLE 0x400
#define US1_IMR_IDLE_BIT 10
#define US1_IMR_SCK_MASK 0x10000
#define US1_IMR_SCK 0x10000
#define US1_IMR_SCK_BIT 16
#define US1_IMR_TXD_MASK 0x20000
#define US1_IMR_TXD 0x20000
#define US1_IMR_TXD_BIT 17
#define US1_IMR_RXD_MASK 0x40000
#define US1_IMR_RXD 0x40000
#define US1_IMR_RXD_BIT 18

#define US1_RHR (*(volatile unsigned long *)0xFFFAC080)
#define US1_RHR_OFFSET 0x80
#define US1_RHR_RXCHR_MASK 0x1FF
#define US1_RHR_RXCHR_BIT 0

#define US1_THR (*(volatile unsigned long *)0xFFFAC084)
#define US1_THR_OFFSET 0x84
#define US1_THR_TXCHR_MASK 0x1FF
#define US1_THR_TXCHR_BIT 0

#define US1_BRGR (*(volatile unsigned long *)0xFFFAC088)
#define US1_BRGR_OFFSET 0x88
#define US1_BRGR_CD_MASK 0xFFFF
#define US1_BRGR_CD_BIT 0

#define US1_RTOR (*(volatile unsigned long *)0xFFFAC08C)
#define US1_RTOR_OFFSET 0x8C
#define US1_RTOR_TO_MASK 0xFF
#define US1_RTOR_TO_BIT 0

#define US1_TTGR (*(volatile unsigned long *)0xFFFAC090)
#define US1_TTGR_OFFSET 0x90
#define US1_TTGR_TG_MASK 0xFF
#define US1_TTGR_TG_BIT 0

#define USART2_BASE 0xFFFB0000

#define US2_PER (*(volatile unsigned long *)0xFFFB0000)
#define US2_PER_OFFSET 0x0
#define US2_PER_SCK_MASK 0x10000
#define US2_PER_SCK 0x10000
#define US2_PER_SCK_BIT 16
#define US2_PER_TXD_MASK 0x20000
#define US2_PER_TXD 0x20000
#define US2_PER_TXD_BIT 17
#define US2_PER_RXD_MASK 0x40000
#define US2_PER_RXD 0x40000
#define US2_PER_RXD_BIT 18

#define US2_PDR (*(volatile unsigned long *)0xFFFB0004)
#define US2_PDR_OFFSET 0x4
#define US2_PDR_SCK_MASK 0x10000
#define US2_PDR_SCK 0x10000
#define US2_PDR_SCK_BIT 16
#define US2_PDR_TXD_MASK 0x20000
#define US2_PDR_TXD 0x20000
#define US2_PDR_TXD_BIT 17
#define US2_PDR_RXD_MASK 0x40000
#define US2_PDR_RXD 0x40000
#define US2_PDR_RXD_BIT 18

#define US2_PSR (*(volatile unsigned long *)0xFFFB0008)
#define US2_PSR_OFFSET 0x8
#define US2_PSR_SCK_MASK 0x10000
#define US2_PSR_SCK 0x10000
#define US2_PSR_SCK_BIT 16
#define US2_PSR_TXD_MASK 0x20000
#define US2_PSR_TXD 0x20000
#define US2_PSR_TXD_BIT 17
#define US2_PSR_RXD_MASK 0x40000
#define US2_PSR_RXD 0x40000
#define US2_PSR_RXD_BIT 18

#define US2_OER (*(volatile unsigned long *)0xFFFB0010)
#define US2_OER_OFFSET 0x10
#define US2_OER_SCK_MASK 0x10000
#define US2_OER_SCK 0x10000
#define US2_OER_SCK_BIT 16
#define US2_OER_TXD_MASK 0x20000
#define US2_OER_TXD 0x20000
#define US2_OER_TXD_BIT 17
#define US2_OER_RXD_MASK 0x40000
#define US2_OER_RXD 0x40000
#define US2_OER_RXD_BIT 18

#define US2_ODR (*(volatile unsigned long *)0xFFFB0014)
#define US2_ODR_OFFSET 0x14
#define US2_ODR_SCK_MASK 0x10000
#define US2_ODR_SCK 0x10000
#define US2_ODR_SCK_BIT 16
#define US2_ODR_TXD_MASK 0x20000
#define US2_ODR_TXD 0x20000
#define US2_ODR_TXD_BIT 17
#define US2_ODR_RXD_MASK 0x40000
#define US2_ODR_RXD 0x40000
#define US2_ODR_RXD_BIT 18

#define US2_OSR (*(volatile unsigned long *)0xFFFB0018)
#define US2_OSR_OFFSET 0x18
#define US2_OSR_SCK_MASK 0x10000
#define US2_OSR_SCK 0x10000
#define US2_OSR_SCK_BIT 16
#define US2_OSR_TXD_MASK 0x20000
#define US2_OSR_TXD 0x20000
#define US2_OSR_TXD_BIT 17
#define US2_OSR_RXD_MASK 0x40000
#define US2_OSR_RXD 0x40000
#define US2_OSR_RXD_BIT 18

#define US2_SODR (*(volatile unsigned long *)0xFFFB0030)
#define US2_SODR_OFFSET 0x30
#define US2_SODR_SCK_MASK 0x10000
#define US2_SODR_SCK 0x10000
#define US2_SODR_SCK_BIT 16
#define US2_SODR_TXD_MASK 0x20000
#define US2_SODR_TXD 0x20000
#define US2_SODR_TXD_BIT 17
#define US2_SODR_RXD_MASK 0x40000
#define US2_SODR_RXD 0x40000
#define US2_SODR_RXD_BIT 18

#define US2_CODR (*(volatile unsigned long *)0xFFFB0034)
#define US2_CODR_OFFSET 0x34
#define US2_CODR_SCK_MASK 0x10000
#define US2_CODR_SCK 0x10000
#define US2_CODR_SCK_BIT 16
#define US2_CODR_TXD_MASK 0x20000
#define US2_CODR_TXD 0x20000
#define US2_CODR_TXD_BIT 17
#define US2_CODR_RXD_MASK 0x40000
#define US2_CODR_RXD 0x40000
#define US2_CODR_RXD_BIT 18

#define US2_ODSR (*(volatile unsigned long *)0xFFFB0038)
#define US2_ODSR_OFFSET 0x38
#define US2_ODSR_SCK_MASK 0x10000
#define US2_ODSR_SCK 0x10000
#define US2_ODSR_SCK_BIT 16
#define US2_ODSR_TXD_MASK 0x20000
#define US2_ODSR_TXD 0x20000
#define US2_ODSR_TXD_BIT 17
#define US2_ODSR_RXD_MASK 0x40000
#define US2_ODSR_RXD 0x40000
#define US2_ODSR_RXD_BIT 18

#define US2_PDSR (*(volatile unsigned long *)0xFFFB003C)
#define US2_PDSR_OFFSET 0x3C
#define US2_PDSR_SCK_MASK 0x10000
#define US2_PDSR_SCK 0x10000
#define US2_PDSR_SCK_BIT 16
#define US2_PDSR_TXD_MASK 0x20000
#define US2_PDSR_TXD 0x20000
#define US2_PDSR_TXD_BIT 17
#define US2_PDSR_RXD_MASK 0x40000
#define US2_PDSR_RXD 0x40000
#define US2_PDSR_RXD_BIT 18

#define US2_MDER (*(volatile unsigned long *)0xFFFB0040)
#define US2_MDER_OFFSET 0x40
#define US2_MDER_SCK_MASK 0x10000
#define US2_MDER_SCK 0x10000
#define US2_MDER_SCK_BIT 16
#define US2_MDER_TXD_MASK 0x20000
#define US2_MDER_TXD 0x20000
#define US2_MDER_TXD_BIT 17
#define US2_MDER_RXD_MASK 0x40000
#define US2_MDER_RXD 0x40000
#define US2_MDER_RXD_BIT 18

#define US2_MDDR (*(volatile unsigned long *)0xFFFB0044)
#define US2_MDDR_OFFSET 0x44
#define US2_MDDR_SCK_MASK 0x10000
#define US2_MDDR_SCK 0x10000
#define US2_MDDR_SCK_BIT 16
#define US2_MDDR_TXD_MASK 0x20000
#define US2_MDDR_TXD 0x20000
#define US2_MDDR_TXD_BIT 17
#define US2_MDDR_RXD_MASK 0x40000
#define US2_MDDR_RXD 0x40000
#define US2_MDDR_RXD_BIT 18

#define US2_MDSR (*(volatile unsigned long *)0xFFFB0048)
#define US2_MDSR_OFFSET 0x48
#define US2_MDSR_SCK_MASK 0x10000
#define US2_MDSR_SCK 0x10000
#define US2_MDSR_SCK_BIT 16
#define US2_MDSR_TXD_MASK 0x20000
#define US2_MDSR_TXD 0x20000
#define US2_MDSR_TXD_BIT 17
#define US2_MDSR_RXD_MASK 0x40000
#define US2_MDSR_RXD 0x40000
#define US2_MDSR_RXD_BIT 18

#define US2_ECR (*(volatile unsigned long *)0xFFFB0050)
#define US2_ECR_OFFSET 0x50
#define US2_ECR_PIO_MASK 0x1
#define US2_ECR_PIO 0x1
#define US2_ECR_PIO_BIT 0
#define US2_ECR_USART_MASK 0x2
#define US2_ECR_USART 0x2
#define US2_ECR_USART_BIT 1

#define US2_DCR (*(volatile unsigned long *)0xFFFB0054)
#define US2_DCR_OFFSET 0x54
#define US2_DCR_PIO_MASK 0x1
#define US2_DCR_PIO 0x1
#define US2_DCR_PIO_BIT 0
#define US2_DCR_USART_MASK 0x2
#define US2_DCR_USART 0x2
#define US2_DCR_USART_BIT 1

#define US2_PMSR (*(volatile unsigned long *)0xFFFB0058)
#define US2_PMSR_OFFSET 0x58
#define US2_PMSR_PIO_MASK 0x1
#define US2_PMSR_PIO 0x1
#define US2_PMSR_PIO_BIT 0
#define US2_PMSR_USART_MASK 0x2
#define US2_PMSR_USART 0x2
#define US2_PMSR_USART_BIT 1

#define US2_CR (*(volatile unsigned long *)0xFFFB0060)
#define US2_CR_OFFSET 0x60
#define US2_CR_SWRST_MASK 0x1
#define US2_CR_SWRST 0x1
#define US2_CR_SWRST_BIT 0
#define US2_CR_RSTRX_MASK 0x4
#define US2_CR_RSTRX 0x4
#define US2_CR_RSTRX_BIT 2
#define US2_CR_RSTTX_MASK 0x8
#define US2_CR_RSTTX 0x8
#define US2_CR_RSTTX_BIT 3
#define US2_CR_RXEN_MASK 0x10
#define US2_CR_RXEN 0x10
#define US2_CR_RXEN_BIT 4
#define US2_CR_RXDIS_MASK 0x20
#define US2_CR_RXDIS 0x20
#define US2_CR_RXDIS_BIT 5
#define US2_CR_TXEN_MASK 0x40
#define US2_CR_TXEN 0x40
#define US2_CR_TXEN_BIT 6
#define US2_CR_TXDIS_MASK 0x80
#define US2_CR_TXDIS 0x80
#define US2_CR_TXDIS_BIT 7
#define US2_CR_RSTSTA_MASK 0x100
#define US2_CR_RSTSTA 0x100
#define US2_CR_RSTSTA_BIT 8
#define US2_CR_STTBRK_MASK 0x200
#define US2_CR_STTBRK 0x200
#define US2_CR_STTBRK_BIT 9
#define US2_CR_STPBRK_MASK 0x400
#define US2_CR_STPBRK 0x400
#define US2_CR_STPBRK_BIT 10
#define US2_CR_STTTO_MASK 0x800
#define US2_CR_STTTO 0x800
#define US2_CR_STTTO_BIT 11
#define US2_CR_SENDA_MASK 0x1000
#define US2_CR_SENDA 0x1000
#define US2_CR_SENDA_BIT 12

#define US2_MR (*(volatile unsigned long *)0xFFFB0064)
#define US2_MR_OFFSET 0x64
#define US2_MR_USCLKS_MASK 0x30
#define US2_MR_USCLKS_BIT 4
#define US2_MR_CHRL_MASK 0xC0
#define US2_MR_CHRL_BIT 6
#define US2_MR_SYNC_MASK 0x100
#define US2_MR_SYNC 0x100
#define US2_MR_SYNC_BIT 8
#define US2_MR_PAR_MASK 0xE00
#define US2_MR_PAR_BIT 9
#define US2_MR_NBSTOP_MASK 0x3000
#define US2_MR_NBSTOP_BIT 12
#define US2_MR_CHMODE_MASK 0xC000
#define US2_MR_CHMODE_BIT 14
#define US2_MR_MODE9_MASK 0x20000
#define US2_MR_MODE9 0x20000
#define US2_MR_MODE9_BIT 17
#define US2_MR_CLKO_MASK 0x40000
#define US2_MR_CLKO 0x40000
#define US2_MR_CLKO_BIT 18

#define US2_SR (*(volatile unsigned long *)0xFFFB0070)
#define US2_SR_OFFSET 0x70
#define US2_SR_RXRDY_MASK 0x1
#define US2_SR_RXRDY 0x1
#define US2_SR_RXRDY_BIT 0
#define US2_SR_TXRDY_MASK 0x2
#define US2_SR_TXRDY 0x2
#define US2_SR_TXRDY_BIT 1
#define US2_SR_RXBRK_MASK 0x4
#define US2_SR_RXBRK 0x4
#define US2_SR_RXBRK_BIT 2
#define US2_SR_ENDRX_MASK 0x8
#define US2_SR_ENDRX 0x8
#define US2_SR_ENDRX_BIT 3
#define US2_SR_ENDTX_MASK 0x10
#define US2_SR_ENDTX 0x10
#define US2_SR_ENDTX_BIT 4
#define US2_SR_USOVRE_MASK 0x20
#define US2_SR_USOVRE 0x20
#define US2_SR_USOVRE_BIT 5
#define US2_SR_FRAME_MASK 0x40
#define US2_SR_FRAME 0x40
#define US2_SR_FRAME_BIT 6
#define US2_SR_PARE_MASK 0x80
#define US2_SR_PARE 0x80
#define US2_SR_PARE_BIT 7
#define US2_SR_TIMEOUT_MASK 0x100
#define US2_SR_TIMEOUT 0x100
#define US2_SR_TIMEOUT_BIT 8
#define US2_SR_TXEMPTY_MASK 0x200
#define US2_SR_TXEMPTY 0x200
#define US2_SR_TXEMPTY_BIT 9
#define US2_SR_IDLE_MASK 0x400
#define US2_SR_IDLE 0x400
#define US2_SR_IDLE_BIT 10
#define US2_SR_IDLEFLAG_MASK 0x800
#define US2_SR_IDLEFLAG 0x800
#define US2_SR_IDLEFLAG_BIT 11
#define US2_SR_SCK_MASK 0x10000
#define US2_SR_SCK 0x10000
#define US2_SR_SCK_BIT 16
#define US2_SR_TXD_MASK 0x20000
#define US2_SR_TXD 0x20000
#define US2_SR_TXD_BIT 17
#define US2_SR_RXD_MASK 0x40000
#define US2_SR_RXD 0x40000
#define US2_SR_RXD_BIT 18

#define US2_IER (*(volatile unsigned long *)0xFFFB0074)
#define US2_IER_OFFSET 0x74
#define US2_IER_RXRDY_MASK 0x1
#define US2_IER_RXRDY 0x1
#define US2_IER_RXRDY_BIT 0
#define US2_IER_TXRDY_MASK 0x2
#define US2_IER_TXRDY 0x2
#define US2_IER_TXRDY_BIT 1
#define US2_IER_RXBRK_MASK 0x4
#define US2_IER_RXBRK 0x4
#define US2_IER_RXBRK_BIT 2
#define US2_IER_ENDRX_MASK 0x8
#define US2_IER_ENDRX 0x8
#define US2_IER_ENDRX_BIT 3
#define US2_IER_ENDTX_MASK 0x10
#define US2_IER_ENDTX 0x10
#define US2_IER_ENDTX_BIT 4
#define US2_IER_USOVRE_MASK 0x20
#define US2_IER_USOVRE 0x20
#define US2_IER_USOVRE_BIT 5
#define US2_IER_FRAME_MASK 0x40
#define US2_IER_FRAME 0x40
#define US2_IER_FRAME_BIT 6
#define US2_IER_PARE_MASK 0x80
#define US2_IER_PARE 0x80
#define US2_IER_PARE_BIT 7
#define US2_IER_TIMEOUT_MASK 0x100
#define US2_IER_TIMEOUT 0x100
#define US2_IER_TIMEOUT_BIT 8
#define US2_IER_TXEMPTY_MASK 0x200
#define US2_IER_TXEMPTY 0x200
#define US2_IER_TXEMPTY_BIT 9
#define US2_IER_IDLE_MASK 0x400
#define US2_IER_IDLE 0x400
#define US2_IER_IDLE_BIT 10
#define US2_IER_SCK_MASK 0x10000
#define US2_IER_SCK 0x10000
#define US2_IER_SCK_BIT 16
#define US2_IER_TXD_MASK 0x20000
#define US2_IER_TXD 0x20000
#define US2_IER_TXD_BIT 17
#define US2_IER_RXD_MASK 0x40000
#define US2_IER_RXD 0x40000
#define US2_IER_RXD_BIT 18

#define US2_IDR (*(volatile unsigned long *)0xFFFB0078)
#define US2_IDR_OFFSET 0x78
#define US2_IDR_RXRDY_MASK 0x1
#define US2_IDR_RXRDY 0x1
#define US2_IDR_RXRDY_BIT 0
#define US2_IDR_TXRDY_MASK 0x2
#define US2_IDR_TXRDY 0x2
#define US2_IDR_TXRDY_BIT 1
#define US2_IDR_RXBRK_MASK 0x4
#define US2_IDR_RXBRK 0x4
#define US2_IDR_RXBRK_BIT 2
#define US2_IDR_ENDRX_MASK 0x8
#define US2_IDR_ENDRX 0x8
#define US2_IDR_ENDRX_BIT 3
#define US2_IDR_ENDTX_MASK 0x10
#define US2_IDR_ENDTX 0x10
#define US2_IDR_ENDTX_BIT 4
#define US2_IDR_USOVRE_MASK 0x20
#define US2_IDR_USOVRE 0x20
#define US2_IDR_USOVRE_BIT 5
#define US2_IDR_FRAME_MASK 0x40
#define US2_IDR_FRAME 0x40
#define US2_IDR_FRAME_BIT 6
#define US2_IDR_PARE_MASK 0x80
#define US2_IDR_PARE 0x80
#define US2_IDR_PARE_BIT 7
#define US2_IDR_TIMEOUT_MASK 0x100
#define US2_IDR_TIMEOUT 0x100
#define US2_IDR_TIMEOUT_BIT 8
#define US2_IDR_TXEMPTY_MASK 0x200
#define US2_IDR_TXEMPTY 0x200
#define US2_IDR_TXEMPTY_BIT 9
#define US2_IDR_IDLE_MASK 0x400
#define US2_IDR_IDLE 0x400
#define US2_IDR_IDLE_BIT 10
#define US2_IDR_SCK_MASK 0x10000
#define US2_IDR_SCK 0x10000
#define US2_IDR_SCK_BIT 16
#define US2_IDR_TXD_MASK 0x20000
#define US2_IDR_TXD 0x20000
#define US2_IDR_TXD_BIT 17
#define US2_IDR_RXD_MASK 0x40000
#define US2_IDR_RXD 0x40000
#define US2_IDR_RXD_BIT 18

#define US2_IMR (*(volatile unsigned long *)0xFFFB007C)
#define US2_IMR_OFFSET 0x7C
#define US2_IMR_RXRDY_MASK 0x1
#define US2_IMR_RXRDY 0x1
#define US2_IMR_RXRDY_BIT 0
#define US2_IMR_TXRDY_MASK 0x2
#define US2_IMR_TXRDY 0x2
#define US2_IMR_TXRDY_BIT 1
#define US2_IMR_RXBRK_MASK 0x4
#define US2_IMR_RXBRK 0x4
#define US2_IMR_RXBRK_BIT 2
#define US2_IMR_ENDRX_MASK 0x8
#define US2_IMR_ENDRX 0x8
#define US2_IMR_ENDRX_BIT 3
#define US2_IMR_ENDTX_MASK 0x10
#define US2_IMR_ENDTX 0x10
#define US2_IMR_ENDTX_BIT 4
#define US2_IMR_USOVRE_MASK 0x20
#define US2_IMR_USOVRE 0x20
#define US2_IMR_USOVRE_BIT 5
#define US2_IMR_FRAME_MASK 0x40
#define US2_IMR_FRAME 0x40
#define US2_IMR_FRAME_BIT 6
#define US2_IMR_PARE_MASK 0x80
#define US2_IMR_PARE 0x80
#define US2_IMR_PARE_BIT 7
#define US2_IMR_TIMEOUT_MASK 0x100
#define US2_IMR_TIMEOUT 0x100
#define US2_IMR_TIMEOUT_BIT 8
#define US2_IMR_TXEMPTY_MASK 0x200
#define US2_IMR_TXEMPTY 0x200
#define US2_IMR_TXEMPTY_BIT 9
#define US2_IMR_IDLE_MASK 0x400
#define US2_IMR_IDLE 0x400
#define US2_IMR_IDLE_BIT 10
#define US2_IMR_SCK_MASK 0x10000
#define US2_IMR_SCK 0x10000
#define US2_IMR_SCK_BIT 16
#define US2_IMR_TXD_MASK 0x20000
#define US2_IMR_TXD 0x20000
#define US2_IMR_TXD_BIT 17
#define US2_IMR_RXD_MASK 0x40000
#define US2_IMR_RXD 0x40000
#define US2_IMR_RXD_BIT 18

#define US2_RHR (*(volatile unsigned long *)0xFFFB0080)
#define US2_RHR_OFFSET 0x80
#define US2_RHR_RXCHR_MASK 0x1FF
#define US2_RHR_RXCHR_BIT 0

#define US2_THR (*(volatile unsigned long *)0xFFFB0084)
#define US2_THR_OFFSET 0x84
#define US2_THR_TXCHR_MASK 0x1FF
#define US2_THR_TXCHR_BIT 0

#define US2_BRGR (*(volatile unsigned long *)0xFFFB0088)
#define US2_BRGR_OFFSET 0x88
#define US2_BRGR_CD_MASK 0xFFFF
#define US2_BRGR_CD_BIT 0

#define US2_RTOR (*(volatile unsigned long *)0xFFFB008C)
#define US2_RTOR_OFFSET 0x8C
#define US2_RTOR_TO_MASK 0xFF
#define US2_RTOR_TO_BIT 0

#define US2_TTGR (*(volatile unsigned long *)0xFFFB0090)
#define US2_TTGR_OFFSET 0x90
#define US2_TTGR_TG_MASK 0xFF
#define US2_TTGR_TG_BIT 0

#define SPI_BASE 0xFFFB4000

#define SPI_PER (*(volatile unsigned long *)0xFFFB4000)
#define SPI_PER_OFFSET 0x0
#define SPI_PER_SPCK_MASK 0x10000
#define SPI_PER_SPCK 0x10000
#define SPI_PER_SPCK_BIT 16
#define SPI_PER_MISO_MASK 0x20000
#define SPI_PER_MISO 0x20000
#define SPI_PER_MISO_BIT 17
#define SPI_PER_MOSI_MASK 0x40000
#define SPI_PER_MOSI 0x40000
#define SPI_PER_MOSI_BIT 18
#define SPI_PER_NPCS0_MASK 0x80000
#define SPI_PER_NPCS0 0x80000
#define SPI_PER_NPCS0_BIT 19
#define SPI_PER_NPCS1_MASK 0x100000
#define SPI_PER_NPCS1 0x100000
#define SPI_PER_NPCS1_BIT 20
#define SPI_PER_NPCS2_MASK 0x200000
#define SPI_PER_NPCS2 0x200000
#define SPI_PER_NPCS2_BIT 21
#define SPI_PER_NPCS3_MASK 0x400000
#define SPI_PER_NPCS3 0x400000
#define SPI_PER_NPCS3_BIT 22

#define SPI_PDR (*(volatile unsigned long *)0xFFFB4004)
#define SPI_PDR_OFFSET 0x4
#define SPI_PDR_SPCK_MASK 0x10000
#define SPI_PDR_SPCK 0x10000
#define SPI_PDR_SPCK_BIT 16
#define SPI_PDR_MISO_MASK 0x20000
#define SPI_PDR_MISO 0x20000
#define SPI_PDR_MISO_BIT 17
#define SPI_PDR_MOSI_MASK 0x40000
#define SPI_PDR_MOSI 0x40000
#define SPI_PDR_MOSI_BIT 18
#define SPI_PDR_NPCS0_MASK 0x80000
#define SPI_PDR_NPCS0 0x80000
#define SPI_PDR_NPCS0_BIT 19
#define SPI_PDR_NPCS1_MASK 0x100000
#define SPI_PDR_NPCS1 0x100000
#define SPI_PDR_NPCS1_BIT 20
#define SPI_PDR_NPCS2_MASK 0x200000
#define SPI_PDR_NPCS2 0x200000
#define SPI_PDR_NPCS2_BIT 21
#define SPI_PDR_NPCS3_MASK 0x400000
#define SPI_PDR_NPCS3 0x400000
#define SPI_PDR_NPCS3_BIT 22

#define SPI_PSR (*(volatile unsigned long *)0xFFFB4008)
#define SPI_PSR_OFFSET 0x8
#define SPI_PSR_SPCK_MASK 0x10000
#define SPI_PSR_SPCK 0x10000
#define SPI_PSR_SPCK_BIT 16
#define SPI_PSR_MISO_MASK 0x20000
#define SPI_PSR_MISO 0x20000
#define SPI_PSR_MISO_BIT 17
#define SPI_PSR_MOSI_MASK 0x40000
#define SPI_PSR_MOSI 0x40000
#define SPI_PSR_MOSI_BIT 18
#define SPI_PSR_NPCS0_MASK 0x80000
#define SPI_PSR_NPCS0 0x80000
#define SPI_PSR_NPCS0_BIT 19
#define SPI_PSR_NPCS1_MASK 0x100000
#define SPI_PSR_NPCS1 0x100000
#define SPI_PSR_NPCS1_BIT 20
#define SPI_PSR_NPCS2_MASK 0x200000
#define SPI_PSR_NPCS2 0x200000
#define SPI_PSR_NPCS2_BIT 21
#define SPI_PSR_NPCS3_MASK 0x400000
#define SPI_PSR_NPCS3 0x400000
#define SPI_PSR_NPCS3_BIT 22

#define SPI_OER (*(volatile unsigned long *)0xFFFB4010)
#define SPI_OER_OFFSET 0x10
#define SPI_OER_SPCK_MASK 0x10000
#define SPI_OER_SPCK 0x10000
#define SPI_OER_SPCK_BIT 16
#define SPI_OER_MISO_MASK 0x20000
#define SPI_OER_MISO 0x20000
#define SPI_OER_MISO_BIT 17
#define SPI_OER_MOSI_MASK 0x40000
#define SPI_OER_MOSI 0x40000
#define SPI_OER_MOSI_BIT 18
#define SPI_OER_NPCS0_MASK 0x80000
#define SPI_OER_NPCS0 0x80000
#define SPI_OER_NPCS0_BIT 19
#define SPI_OER_NPCS1_MASK 0x100000
#define SPI_OER_NPCS1 0x100000
#define SPI_OER_NPCS1_BIT 20
#define SPI_OER_NPCS2_MASK 0x200000
#define SPI_OER_NPCS2 0x200000
#define SPI_OER_NPCS2_BIT 21
#define SPI_OER_NPCS3_MASK 0x400000
#define SPI_OER_NPCS3 0x400000
#define SPI_OER_NPCS3_BIT 22

#define SPI_ODR (*(volatile unsigned long *)0xFFFB4014)
#define SPI_ODR_OFFSET 0x14
#define SPI_ODR_SPCK_MASK 0x10000
#define SPI_ODR_SPCK 0x10000
#define SPI_ODR_SPCK_BIT 16
#define SPI_ODR_MISO_MASK 0x20000
#define SPI_ODR_MISO 0x20000
#define SPI_ODR_MISO_BIT 17
#define SPI_ODR_MOSI_MASK 0x40000
#define SPI_ODR_MOSI 0x40000
#define SPI_ODR_MOSI_BIT 18
#define SPI_ODR_NPCS0_MASK 0x80000
#define SPI_ODR_NPCS0 0x80000
#define SPI_ODR_NPCS0_BIT 19
#define SPI_ODR_NPCS1_MASK 0x100000
#define SPI_ODR_NPCS1 0x100000
#define SPI_ODR_NPCS1_BIT 20
#define SPI_ODR_NPCS2_MASK 0x200000
#define SPI_ODR_NPCS2 0x200000
#define SPI_ODR_NPCS2_BIT 21
#define SPI_ODR_NPCS3_MASK 0x400000
#define SPI_ODR_NPCS3 0x400000
#define SPI_ODR_NPCS3_BIT 22

#define SPI_OSR (*(volatile unsigned long *)0xFFFB4018)
#define SPI_OSR_OFFSET 0x18
#define SPI_OSR_SPCK_MASK 0x10000
#define SPI_OSR_SPCK 0x10000
#define SPI_OSR_SPCK_BIT 16
#define SPI_OSR_MISO_MASK 0x20000
#define SPI_OSR_MISO 0x20000
#define SPI_OSR_MISO_BIT 17
#define SPI_OSR_MOSI_MASK 0x40000
#define SPI_OSR_MOSI 0x40000
#define SPI_OSR_MOSI_BIT 18
#define SPI_OSR_NPCS0_MASK 0x80000
#define SPI_OSR_NPCS0 0x80000
#define SPI_OSR_NPCS0_BIT 19
#define SPI_OSR_NPCS1_MASK 0x100000
#define SPI_OSR_NPCS1 0x100000
#define SPI_OSR_NPCS1_BIT 20
#define SPI_OSR_NPCS2_MASK 0x200000
#define SPI_OSR_NPCS2 0x200000
#define SPI_OSR_NPCS2_BIT 21
#define SPI_OSR_NPCS3_MASK 0x400000
#define SPI_OSR_NPCS3 0x400000
#define SPI_OSR_NPCS3_BIT 22

#define SPI_SODR (*(volatile unsigned long *)0xFFFB4030)
#define SPI_SODR_OFFSET 0x30
#define SPI_SODR_SPCK_MASK 0x10000
#define SPI_SODR_SPCK 0x10000
#define SPI_SODR_SPCK_BIT 16
#define SPI_SODR_MISO_MASK 0x20000
#define SPI_SODR_MISO 0x20000
#define SPI_SODR_MISO_BIT 17
#define SPI_SODR_MOSI_MASK 0x40000
#define SPI_SODR_MOSI 0x40000
#define SPI_SODR_MOSI_BIT 18
#define SPI_SODR_NPCS0_MASK 0x80000
#define SPI_SODR_NPCS0 0x80000
#define SPI_SODR_NPCS0_BIT 19
#define SPI_SODR_NPCS1_MASK 0x100000
#define SPI_SODR_NPCS1 0x100000
#define SPI_SODR_NPCS1_BIT 20
#define SPI_SODR_NPCS2_MASK 0x200000
#define SPI_SODR_NPCS2 0x200000
#define SPI_SODR_NPCS2_BIT 21
#define SPI_SODR_NPCS3_MASK 0x400000
#define SPI_SODR_NPCS3 0x400000
#define SPI_SODR_NPCS3_BIT 22

#define SPI_CODR (*(volatile unsigned long *)0xFFFB4034)
#define SPI_CODR_OFFSET 0x34
#define SPI_CODR_SPCK_MASK 0x10000
#define SPI_CODR_SPCK 0x10000
#define SPI_CODR_SPCK_BIT 16
#define SPI_CODR_MISO_MASK 0x20000
#define SPI_CODR_MISO 0x20000
#define SPI_CODR_MISO_BIT 17
#define SPI_CODR_MOSI_MASK 0x40000
#define SPI_CODR_MOSI 0x40000
#define SPI_CODR_MOSI_BIT 18
#define SPI_CODR_NPCS0_MASK 0x80000
#define SPI_CODR_NPCS0 0x80000
#define SPI_CODR_NPCS0_BIT 19
#define SPI_CODR_NPCS1_MASK 0x100000
#define SPI_CODR_NPCS1 0x100000
#define SPI_CODR_NPCS1_BIT 20
#define SPI_CODR_NPCS2_MASK 0x200000
#define SPI_CODR_NPCS2 0x200000
#define SPI_CODR_NPCS2_BIT 21
#define SPI_CODR_NPCS3_MASK 0x400000
#define SPI_CODR_NPCS3 0x400000
#define SPI_CODR_NPCS3_BIT 22

#define SPI_ODSR (*(volatile unsigned long *)0xFFFB4038)
#define SPI_ODSR_OFFSET 0x38
#define SPI_ODSR_SPCK_MASK 0x10000
#define SPI_ODSR_SPCK 0x10000
#define SPI_ODSR_SPCK_BIT 16
#define SPI_ODSR_MISO_MASK 0x20000
#define SPI_ODSR_MISO 0x20000
#define SPI_ODSR_MISO_BIT 17
#define SPI_ODSR_MOSI_MASK 0x40000
#define SPI_ODSR_MOSI 0x40000
#define SPI_ODSR_MOSI_BIT 18
#define SPI_ODSR_NPCS0_MASK 0x80000
#define SPI_ODSR_NPCS0 0x80000
#define SPI_ODSR_NPCS0_BIT 19
#define SPI_ODSR_NPCS1_MASK 0x100000
#define SPI_ODSR_NPCS1 0x100000
#define SPI_ODSR_NPCS1_BIT 20
#define SPI_ODSR_NPCS2_MASK 0x200000
#define SPI_ODSR_NPCS2 0x200000
#define SPI_ODSR_NPCS2_BIT 21
#define SPI_ODSR_NPCS3_MASK 0x400000
#define SPI_ODSR_NPCS3 0x400000
#define SPI_ODSR_NPCS3_BIT 22

#define SPI_PDSR (*(volatile unsigned long *)0xFFFB403C)
#define SPI_PDSR_OFFSET 0x3C
#define SPI_PDSR_SPCK_MASK 0x10000
#define SPI_PDSR_SPCK 0x10000
#define SPI_PDSR_SPCK_BIT 16
#define SPI_PDSR_MISO_MASK 0x20000
#define SPI_PDSR_MISO 0x20000
#define SPI_PDSR_MISO_BIT 17
#define SPI_PDSR_MOSI_MASK 0x40000
#define SPI_PDSR_MOSI 0x40000
#define SPI_PDSR_MOSI_BIT 18
#define SPI_PDSR_NPCS0_MASK 0x80000
#define SPI_PDSR_NPCS0 0x80000
#define SPI_PDSR_NPCS0_BIT 19
#define SPI_PDSR_NPCS1_MASK 0x100000
#define SPI_PDSR_NPCS1 0x100000
#define SPI_PDSR_NPCS1_BIT 20
#define SPI_PDSR_NPCS2_MASK 0x200000
#define SPI_PDSR_NPCS2 0x200000
#define SPI_PDSR_NPCS2_BIT 21
#define SPI_PDSR_NPCS3_MASK 0x400000
#define SPI_PDSR_NPCS3 0x400000
#define SPI_PDSR_NPCS3_BIT 22

#define SPI_MDER (*(volatile unsigned long *)0xFFFB4040)
#define SPI_MDER_OFFSET 0x40
#define SPI_MDER_SPCK_MASK 0x10000
#define SPI_MDER_SPCK 0x10000
#define SPI_MDER_SPCK_BIT 16
#define SPI_MDER_MISO_MASK 0x20000
#define SPI_MDER_MISO 0x20000
#define SPI_MDER_MISO_BIT 17
#define SPI_MDER_MOSI_MASK 0x40000
#define SPI_MDER_MOSI 0x40000
#define SPI_MDER_MOSI_BIT 18
#define SPI_MDER_NPCS0_MASK 0x80000
#define SPI_MDER_NPCS0 0x80000
#define SPI_MDER_NPCS0_BIT 19
#define SPI_MDER_NPCS1_MASK 0x100000
#define SPI_MDER_NPCS1 0x100000
#define SPI_MDER_NPCS1_BIT 20
#define SPI_MDER_NPCS2_MASK 0x200000
#define SPI_MDER_NPCS2 0x200000
#define SPI_MDER_NPCS2_BIT 21
#define SPI_MDER_NPCS3_MASK 0x400000
#define SPI_MDER_NPCS3 0x400000
#define SPI_MDER_NPCS3_BIT 22

#define SPI_MDDR (*(volatile unsigned long *)0xFFFB4044)
#define SPI_MDDR_OFFSET 0x44
#define SPI_MDDR_SPCK_MASK 0x10000
#define SPI_MDDR_SPCK 0x10000
#define SPI_MDDR_SPCK_BIT 16
#define SPI_MDDR_MISO_MASK 0x20000
#define SPI_MDDR_MISO 0x20000
#define SPI_MDDR_MISO_BIT 17
#define SPI_MDDR_MOSI_MASK 0x40000
#define SPI_MDDR_MOSI 0x40000
#define SPI_MDDR_MOSI_BIT 18
#define SPI_MDDR_NPCS0_MASK 0x80000
#define SPI_MDDR_NPCS0 0x80000
#define SPI_MDDR_NPCS0_BIT 19
#define SPI_MDDR_NPCS1_MASK 0x100000
#define SPI_MDDR_NPCS1 0x100000
#define SPI_MDDR_NPCS1_BIT 20
#define SPI_MDDR_NPCS2_MASK 0x200000
#define SPI_MDDR_NPCS2 0x200000
#define SPI_MDDR_NPCS2_BIT 21
#define SPI_MDDR_NPCS3_MASK 0x400000
#define SPI_MDDR_NPCS3 0x400000
#define SPI_MDDR_NPCS3_BIT 22

#define SPI_MDSR (*(volatile unsigned long *)0xFFFB4048)
#define SPI_MDSR_OFFSET 0x48
#define SPI_MDSR_SPCK_MASK 0x10000
#define SPI_MDSR_SPCK 0x10000
#define SPI_MDSR_SPCK_BIT 16
#define SPI_MDSR_MISO_MASK 0x20000
#define SPI_MDSR_MISO 0x20000
#define SPI_MDSR_MISO_BIT 17
#define SPI_MDSR_MOSI_MASK 0x40000
#define SPI_MDSR_MOSI 0x40000
#define SPI_MDSR_MOSI_BIT 18
#define SPI_MDSR_NPCS0_MASK 0x80000
#define SPI_MDSR_NPCS0 0x80000
#define SPI_MDSR_NPCS0_BIT 19
#define SPI_MDSR_NPCS1_MASK 0x100000
#define SPI_MDSR_NPCS1 0x100000
#define SPI_MDSR_NPCS1_BIT 20
#define SPI_MDSR_NPCS2_MASK 0x200000
#define SPI_MDSR_NPCS2 0x200000
#define SPI_MDSR_NPCS2_BIT 21
#define SPI_MDSR_NPCS3_MASK 0x400000
#define SPI_MDSR_NPCS3 0x400000
#define SPI_MDSR_NPCS3_BIT 22

#define SPI_ECR (*(volatile unsigned long *)0xFFFB4050)
#define SPI_ECR_OFFSET 0x50
#define SPI_ECR_PIO_MASK 0x1
#define SPI_ECR_PIO 0x1
#define SPI_ECR_PIO_BIT 0
#define SPI_ECR_SPI_MASK 0x2
#define SPI_ECR_SPI 0x2
#define SPI_ECR_SPI_BIT 1

#define SPI_DCR (*(volatile unsigned long *)0xFFFB4054)
#define SPI_DCR_OFFSET 0x54
#define SPI_DCR_PIO_MASK 0x1
#define SPI_DCR_PIO 0x1
#define SPI_DCR_PIO_BIT 0
#define SPI_DCR_SPI_MASK 0x2
#define SPI_DCR_SPI 0x2
#define SPI_DCR_SPI_BIT 1

#define SPI_PMSR (*(volatile unsigned long *)0xFFFB4058)
#define SPI_PMSR_OFFSET 0x58
#define SPI_PMSR_PIO_MASK 0x1
#define SPI_PMSR_PIO 0x1
#define SPI_PMSR_PIO_BIT 0
#define SPI_PMSR_SPI_MASK 0x2
#define SPI_PMSR_SPI 0x2
#define SPI_PMSR_SPI_BIT 1

#define SPI_CR (*(volatile unsigned long *)0xFFFB4060)
#define SPI_CR_OFFSET 0x60
#define SPI_CR_SWRST_MASK 0x1
#define SPI_CR_SWRST 0x1
#define SPI_CR_SWRST_BIT 0
#define SPI_CR_SPIEN_MASK 0x2
#define SPI_CR_SPIEN 0x2
#define SPI_CR_SPIEN_BIT 1
#define SPI_CR_SPIDIS_MASK 0x4
#define SPI_CR_SPIDIS 0x4
#define SPI_CR_SPIDIS_BIT 2

#define SPI_MR (*(volatile unsigned long *)0xFFFB4064)
#define SPI_MR_OFFSET 0x64
#define SPI_MR_MSTR_MASK 0x1
#define SPI_MR_MSTR 0x1
#define SPI_MR_MSTR_BIT 0
#define SPI_MR_PS_MASK 0x2
#define SPI_MR_PS 0x2
#define SPI_MR_PS_BIT 1
#define SPI_MR_PCSDEC_MASK 0x4
#define SPI_MR_PCSDEC 0x4
#define SPI_MR_PCSDEC_BIT 2
#define SPI_MR_DIV32_MASK 0x8
#define SPI_MR_DIV32 0x8
#define SPI_MR_DIV32_BIT 3
#define SPI_MR_LLB_MASK 0x80
#define SPI_MR_LLB 0x80
#define SPI_MR_LLB_BIT 7
#define SPI_MR_PCS_MASK 0xF0000
#define SPI_MR_PCS_BIT 16
#define SPI_MR_DLYBCS_MASK 0x1000000
#define SPI_MR_DLYBCS 0x1000000
#define SPI_MR_DLYBCS_BIT 24

#define SPI_SR (*(volatile unsigned long *)0xFFFB4070)
#define SPI_SR_OFFSET 0x70
#define SPI_SR_RDRF_MASK 0x1
#define SPI_SR_RDRF 0x1
#define SPI_SR_RDRF_BIT 0
#define SPI_SR_TDRE_MASK 0x2
#define SPI_SR_TDRE 0x2
#define SPI_SR_TDRE_BIT 1
#define SPI_SR_MODF_MASK 0x4
#define SPI_SR_MODF 0x4
#define SPI_SR_MODF_BIT 2
#define SPI_SR_SPIOVRE_MASK 0x8
#define SPI_SR_SPIOVRE 0x8
#define SPI_SR_SPIOVRE_BIT 3
#define SPI_SR_REND_MASK 0x10
#define SPI_SR_REND 0x10
#define SPI_SR_REND_BIT 4
#define SPI_SR_TEND_MASK 0x20
#define SPI_SR_TEND 0x20
#define SPI_SR_TEND_BIT 5
#define SPI_SR_SPIENS_MASK 0x100
#define SPI_SR_SPIENS 0x100
#define SPI_SR_SPIENS_BIT 8
#define SPI_SR_SPCK_MASK 0x10000
#define SPI_SR_SPCK 0x10000
#define SPI_SR_SPCK_BIT 16
#define SPI_SR_MISO_MASK 0x20000
#define SPI_SR_MISO 0x20000
#define SPI_SR_MISO_BIT 17
#define SPI_SR_MOSI_MASK 0x40000
#define SPI_SR_MOSI 0x40000
#define SPI_SR_MOSI_BIT 18
#define SPI_SR_NPCS0_MASK 0x80000
#define SPI_SR_NPCS0 0x80000
#define SPI_SR_NPCS0_BIT 19
#define SPI_SR_NPCS1_MASK 0x100000
#define SPI_SR_NPCS1 0x100000
#define SPI_SR_NPCS1_BIT 20
#define SPI_SR_NPCS2_MASK 0x200000
#define SPI_SR_NPCS2 0x200000
#define SPI_SR_NPCS2_BIT 21
#define SPI_SR_NPCS3_MASK 0x400000
#define SPI_SR_NPCS3 0x400000
#define SPI_SR_NPCS3_BIT 22

#define SPI_IER (*(volatile unsigned long *)0xFFFB4074)
#define SPI_IER_OFFSET 0x74
#define SPI_IER_RDRF_MASK 0x1
#define SPI_IER_RDRF 0x1
#define SPI_IER_RDRF_BIT 0
#define SPI_IER_TDRE_MASK 0x2
#define SPI_IER_TDRE 0x2
#define SPI_IER_TDRE_BIT 1
#define SPI_IER_MODF_MASK 0x4
#define SPI_IER_MODF 0x4
#define SPI_IER_MODF_BIT 2
#define SPI_IER_SPIOVRE_MASK 0x8
#define SPI_IER_SPIOVRE 0x8
#define SPI_IER_SPIOVRE_BIT 3
#define SPI_IER_REND_MASK 0x10
#define SPI_IER_REND 0x10
#define SPI_IER_REND_BIT 4
#define SPI_IER_TEND_MASK 0x20
#define SPI_IER_TEND 0x20
#define SPI_IER_TEND_BIT 5
#define SPI_IER_SPCK_MASK 0x10000
#define SPI_IER_SPCK 0x10000
#define SPI_IER_SPCK_BIT 16
#define SPI_IER_MISO_MASK 0x20000
#define SPI_IER_MISO 0x20000
#define SPI_IER_MISO_BIT 17
#define SPI_IER_MOSI_MASK 0x40000
#define SPI_IER_MOSI 0x40000
#define SPI_IER_MOSI_BIT 18
#define SPI_IER_NPCS0_MASK 0x80000
#define SPI_IER_NPCS0 0x80000
#define SPI_IER_NPCS0_BIT 19
#define SPI_IER_NPCS1_MASK 0x100000
#define SPI_IER_NPCS1 0x100000
#define SPI_IER_NPCS1_BIT 20
#define SPI_IER_NPCS2_MASK 0x200000
#define SPI_IER_NPCS2 0x200000
#define SPI_IER_NPCS2_BIT 21
#define SPI_IER_NPCS3_MASK 0x400000
#define SPI_IER_NPCS3 0x400000
#define SPI_IER_NPCS3_BIT 22

#define SPI_IDR (*(volatile unsigned long *)0xFFFB4078)
#define SPI_IDR_OFFSET 0x78
#define SPI_IDR_RDRF_MASK 0x1
#define SPI_IDR_RDRF 0x1
#define SPI_IDR_RDRF_BIT 0
#define SPI_IDR_TDRE_MASK 0x2
#define SPI_IDR_TDRE 0x2
#define SPI_IDR_TDRE_BIT 1
#define SPI_IDR_MODF_MASK 0x4
#define SPI_IDR_MODF 0x4
#define SPI_IDR_MODF_BIT 2
#define SPI_IDR_SPIOVRE_MASK 0x8
#define SPI_IDR_SPIOVRE 0x8
#define SPI_IDR_SPIOVRE_BIT 3
#define SPI_IDR_REND_MASK 0x10
#define SPI_IDR_REND 0x10
#define SPI_IDR_REND_BIT 4
#define SPI_IDR_TEND_MASK 0x20
#define SPI_IDR_TEND 0x20
#define SPI_IDR_TEND_BIT 5
#define SPI_IDR_SPCK_MASK 0x10000
#define SPI_IDR_SPCK 0x10000
#define SPI_IDR_SPCK_BIT 16
#define SPI_IDR_MISO_MASK 0x20000
#define SPI_IDR_MISO 0x20000
#define SPI_IDR_MISO_BIT 17
#define SPI_IDR_MOSI_MASK 0x40000
#define SPI_IDR_MOSI 0x40000
#define SPI_IDR_MOSI_BIT 18
#define SPI_IDR_NPCS0_MASK 0x80000
#define SPI_IDR_NPCS0 0x80000
#define SPI_IDR_NPCS0_BIT 19
#define SPI_IDR_NPCS1_MASK 0x100000
#define SPI_IDR_NPCS1 0x100000
#define SPI_IDR_NPCS1_BIT 20
#define SPI_IDR_NPCS2_MASK 0x200000
#define SPI_IDR_NPCS2 0x200000
#define SPI_IDR_NPCS2_BIT 21
#define SPI_IDR_NPCS3_MASK 0x400000
#define SPI_IDR_NPCS3 0x400000
#define SPI_IDR_NPCS3_BIT 22

#define SPI_IMR (*(volatile unsigned long *)0xFFFB407C)
#define SPI_IMR_OFFSET 0x7C
#define SPI_IMR_RDRF_MASK 0x1
#define SPI_IMR_RDRF 0x1
#define SPI_IMR_RDRF_BIT 0
#define SPI_IMR_TDRE_MASK 0x2
#define SPI_IMR_TDRE 0x2
#define SPI_IMR_TDRE_BIT 1
#define SPI_IMR_MODF_MASK 0x4
#define SPI_IMR_MODF 0x4
#define SPI_IMR_MODF_BIT 2
#define SPI_IMR_SPIOVRE_MASK 0x8
#define SPI_IMR_SPIOVRE 0x8
#define SPI_IMR_SPIOVRE_BIT 3
#define SPI_IMR_REND_MASK 0x10
#define SPI_IMR_REND 0x10
#define SPI_IMR_REND_BIT 4
#define SPI_IMR_TEND_MASK 0x20
#define SPI_IMR_TEND 0x20
#define SPI_IMR_TEND_BIT 5
#define SPI_IMR_SPCK_MASK 0x10000
#define SPI_IMR_SPCK 0x10000
#define SPI_IMR_SPCK_BIT 16
#define SPI_IMR_MISO_MASK 0x20000
#define SPI_IMR_MISO 0x20000
#define SPI_IMR_MISO_BIT 17
#define SPI_IMR_MOSI_MASK 0x40000
#define SPI_IMR_MOSI 0x40000
#define SPI_IMR_MOSI_BIT 18
#define SPI_IMR_NPCS0_MASK 0x80000
#define SPI_IMR_NPCS0 0x80000
#define SPI_IMR_NPCS0_BIT 19
#define SPI_IMR_NPCS1_MASK 0x100000
#define SPI_IMR_NPCS1 0x100000
#define SPI_IMR_NPCS1_BIT 20
#define SPI_IMR_NPCS2_MASK 0x200000
#define SPI_IMR_NPCS2 0x200000
#define SPI_IMR_NPCS2_BIT 21
#define SPI_IMR_NPCS3_MASK 0x400000
#define SPI_IMR_NPCS3 0x400000
#define SPI_IMR_NPCS3_BIT 22

#define SPI_RDR (*(volatile unsigned long *)0xFFFB4080)
#define SPI_RDR_OFFSET 0x80
#define SPI_RDR_RD_MASK 0xFFFF
#define SPI_RDR_RD_BIT 0
#define SPI_RDR_PCS_MASK 0xF0000
#define SPI_RDR_PCS_BIT 16

#define SPI_TDR (*(volatile unsigned long *)0xFFFB4084)
#define SPI_TDR_OFFSET 0x84
#define SPI_TDR_TD_MASK 0xFFFF
#define SPI_TDR_TD_BIT 0
#define SPI_TDR_PCS_MASK 0xF0000
#define SPI_TDR_PCS_BIT 16

#define SPI_CSR0 (*(volatile unsigned long *)0xFFFB4090)
#define SPI_CSR0_OFFSET 0x90
#define SPI_CSR0_CPOL_MASK 0x1
#define SPI_CSR0_CPOL 0x1
#define SPI_CSR0_CPOL_BIT 0
#define SPI_CSR0_NCPHA_MASK 0x1
#define SPI_CSR0_NCPHA 0x1
#define SPI_CSR0_NCPHA_BIT 0
#define SPI_CSR0_BITS_MASK 0xF0
#define SPI_CSR0_BITS_BIT 4
#define SPI_CSR0_SCBR_MASK 0xFF00
#define SPI_CSR0_SCBR_BIT 8
#define SPI_CSR0_DLYBS_MASK 0xFF0000
#define SPI_CSR0_DLYBS_BIT 16
#define SPI_CSR0_DLYBCT_MASK 0xFF000000
#define SPI_CSR0_DLYBCT_BIT 24

#define SPI_CSR1 (*(volatile unsigned long *)0xFFFB4094)
#define SPI_CSR1_OFFSET 0x94
#define SPI_CSR1_CPOL_MASK 0x1
#define SPI_CSR1_CPOL 0x1
#define SPI_CSR1_CPOL_BIT 0
#define SPI_CSR1_NCPHA_MASK 0x1
#define SPI_CSR1_NCPHA 0x1
#define SPI_CSR1_NCPHA_BIT 0
#define SPI_CSR1_BITS_MASK 0xF0
#define SPI_CSR1_BITS_BIT 4
#define SPI_CSR1_SCBR_MASK 0xFF00
#define SPI_CSR1_SCBR_BIT 8
#define SPI_CSR1_DLYBS_MASK 0xFF0000
#define SPI_CSR1_DLYBS_BIT 16
#define SPI_CSR1_DLYBCT_MASK 0xFF000000
#define SPI_CSR1_DLYBCT_BIT 24

#define SPI_CSR2 (*(volatile unsigned long *)0xFFFB4098)
#define SPI_CSR2_OFFSET 0x98
#define SPI_CSR2_CPOL_MASK 0x1
#define SPI_CSR2_CPOL 0x1
#define SPI_CSR2_CPOL_BIT 0
#define SPI_CSR2_NCPHA_MASK 0x1
#define SPI_CSR2_NCPHA 0x1
#define SPI_CSR2_NCPHA_BIT 0
#define SPI_CSR2_BITS_MASK 0xF0
#define SPI_CSR2_BITS_BIT 4
#define SPI_CSR2_SCBR_MASK 0xFF00
#define SPI_CSR2_SCBR_BIT 8
#define SPI_CSR2_DLYBS_MASK 0xFF0000
#define SPI_CSR2_DLYBS_BIT 16
#define SPI_CSR2_DLYBCT_MASK 0xFF000000
#define SPI_CSR2_DLYBCT_BIT 24

#define SPI_CSR3 (*(volatile unsigned long *)0xFFFB409C)
#define SPI_CSR3_OFFSET 0x9C
#define SPI_CSR3_CPOL_MASK 0x1
#define SPI_CSR3_CPOL 0x1
#define SPI_CSR3_CPOL_BIT 0
#define SPI_CSR3_NCPHA_MASK 0x1
#define SPI_CSR3_NCPHA 0x1
#define SPI_CSR3_NCPHA_BIT 0
#define SPI_CSR3_BITS_MASK 0xF0
#define SPI_CSR3_BITS_BIT 4
#define SPI_CSR3_SCBR_MASK 0xFF00
#define SPI_CSR3_SCBR_BIT 8
#define SPI_CSR3_DLYBS_MASK 0xFF0000
#define SPI_CSR3_DLYBS_BIT 16
#define SPI_CSR3_DLYBCT_MASK 0xFF000000
#define SPI_CSR3_DLYBCT_BIT 24

#define ADC0_BASE 0xFFFC0000

#define ADC0_ECR (*(volatile unsigned long *)0xFFFC0050)
#define ADC0_ECR_OFFSET 0x50
#define ADC0_ECR_ADC_MASK 0x2
#define ADC0_ECR_ADC 0x2
#define ADC0_ECR_ADC_BIT 1

#define ADC0_DCR (*(volatile unsigned long *)0xFFFC0054)
#define ADC0_DCR_OFFSET 0x54
#define ADC0_DCR_ADC_MASK 0x2
#define ADC0_DCR_ADC 0x2
#define ADC0_DCR_ADC_BIT 1

#define ADC0_PMSR (*(volatile unsigned long *)0xFFFC0058)
#define ADC0_PMSR_OFFSET 0x58
#define ADC0_PMSR_ADC_MASK 0x2
#define ADC0_PMSR_ADC 0x2
#define ADC0_PMSR_ADC_BIT 1

#define ADC0_CR (*(volatile unsigned long *)0xFFFC0060)
#define ADC0_CR_OFFSET 0x60
#define ADC0_CR_SWRST_MASK 0x1
#define ADC0_CR_SWRST 0x1
#define ADC0_CR_SWRST_BIT 0
#define ADC0_CR_ADCEN_MASK 0x2
#define ADC0_CR_ADCEN 0x2
#define ADC0_CR_ADCEN_BIT 1
#define ADC0_CR_ADCDIS_MASK 0x4
#define ADC0_CR_ADCDIS 0x4
#define ADC0_CR_ADCDIS_BIT 2
#define ADC0_CR_START_MASK 0x8
#define ADC0_CR_START 0x8
#define ADC0_CR_START_BIT 3
#define ADC0_CR_STOP_MASK 0x10
#define ADC0_CR_STOP 0x10
#define ADC0_CR_STOP_BIT 4

#define ADC0_MR (*(volatile unsigned long *)0xFFFC0064)
#define ADC0_MR_OFFSET 0x64
#define ADC0_MR_PRLVAL_MASK 0x1F
#define ADC0_MR_PRLVAL_BIT 0
#define ADC0_MR_STOPEN_MASK 0x40
#define ADC0_MR_STOPEN 0x40
#define ADC0_MR_STOPEN_BIT 6
#define ADC0_MR_STARTUPTIME_MASK 0xFF00
#define ADC0_MR_STARTUPTIME_BIT 8
#define ADC0_MR_NBRCH_MASK 0x70000
#define ADC0_MR_NBRCH_BIT 16
#define ADC0_MR_CONTCV_MASK 0x80000
#define ADC0_MR_CONTCV 0x80000
#define ADC0_MR_CONTCV_BIT 19

#define ADC0_CMR (*(volatile unsigned long *)0xFFFC0068)
#define ADC0_CMR_OFFSET 0x68
#define ADC0_CMR_CV1_MASK 0x7
#define ADC0_CMR_CV1_BIT 0
#define ADC0_CMR_CV2_MASK 0x70
#define ADC0_CMR_CV2_BIT 4
#define ADC0_CMR_CV3_MASK 0x700
#define ADC0_CMR_CV3_BIT 8
#define ADC0_CMR_CV4_MASK 0x7000
#define ADC0_CMR_CV4_BIT 12
#define ADC0_CMR_CV5_MASK 0x70000
#define ADC0_CMR_CV5_BIT 16
#define ADC0_CMR_CV6_MASK 0x700000
#define ADC0_CMR_CV6_BIT 20
#define ADC0_CMR_CV7_MASK 0x7000000
#define ADC0_CMR_CV7_BIT 24
#define ADC0_CMR_CV8_MASK 0x70000000
#define ADC0_CMR_CV8_BIT 28

#define ADC0_CSR (*(volatile unsigned long *)0xFFFC006C)
#define ADC0_CSR_OFFSET 0x6C
#define ADC0_CSR_OVR_MASK 0x4
#define ADC0_CSR_OVR 0x4
#define ADC0_CSR_OVR_BIT 2
#define ADC0_CSR_TEND_MASK 0x8
#define ADC0_CSR_TEND 0x8
#define ADC0_CSR_TEND_BIT 3

#define ADC0_SR (*(volatile unsigned long *)0xFFFC0070)
#define ADC0_SR_OFFSET 0x70
#define ADC0_SR_EOC_MASK 0x1
#define ADC0_SR_EOC 0x1
#define ADC0_SR_EOC_BIT 0
#define ADC0_SR_READY_MASK 0x2
#define ADC0_SR_READY 0x2
#define ADC0_SR_READY_BIT 1
#define ADC0_SR_OVR_MASK 0x4
#define ADC0_SR_OVR 0x4
#define ADC0_SR_OVR_BIT 2
#define ADC0_SR_TEND_MASK 0x8
#define ADC0_SR_TEND 0x8
#define ADC0_SR_TEND_BIT 3
#define ADC0_SR_ADCENS_MASK 0x100
#define ADC0_SR_ADCENS 0x100
#define ADC0_SR_ADCENS_BIT 8
#define ADC0_SR_CTCVS_MASK 0x200
#define ADC0_SR_CTCVS 0x200
#define ADC0_SR_CTCVS_BIT 9

#define ADC0_IER (*(volatile unsigned long *)0xFFFC0074)
#define ADC0_IER_OFFSET 0x74
#define ADC0_IER_EOC_MASK 0x1
#define ADC0_IER_EOC 0x1
#define ADC0_IER_EOC_BIT 0
#define ADC0_IER_READY_MASK 0x2
#define ADC0_IER_READY 0x2
#define ADC0_IER_READY_BIT 1
#define ADC0_IER_OVR_MASK 0x4
#define ADC0_IER_OVR 0x4
#define ADC0_IER_OVR_BIT 2
#define ADC0_IER_TEND_MASK 0x8
#define ADC0_IER_TEND 0x8
#define ADC0_IER_TEND_BIT 3

#define ADC0_IDR (*(volatile unsigned long *)0xFFFC0078)
#define ADC0_IDR_OFFSET 0x78
#define ADC0_IDR_EOC_MASK 0x1
#define ADC0_IDR_EOC 0x1
#define ADC0_IDR_EOC_BIT 0
#define ADC0_IDR_READY_MASK 0x2
#define ADC0_IDR_READY 0x2
#define ADC0_IDR_READY_BIT 1
#define ADC0_IDR_OVR_MASK 0x4
#define ADC0_IDR_OVR 0x4
#define ADC0_IDR_OVR_BIT 2
#define ADC0_IDR_TEND_MASK 0x8
#define ADC0_IDR_TEND 0x8
#define ADC0_IDR_TEND_BIT 3

#define ADC0_IMR (*(volatile unsigned long *)0xFFFC007C)
#define ADC0_IMR_OFFSET 0x7C
#define ADC0_IMR_EOC_MASK 0x1
#define ADC0_IMR_EOC 0x1
#define ADC0_IMR_EOC_BIT 0
#define ADC0_IMR_READY_MASK 0x2
#define ADC0_IMR_READY 0x2
#define ADC0_IMR_READY_BIT 1
#define ADC0_IMR_OVR_MASK 0x4
#define ADC0_IMR_OVR 0x4
#define ADC0_IMR_OVR_BIT 2
#define ADC0_IMR_TEND_MASK 0x8
#define ADC0_IMR_TEND 0x8
#define ADC0_IMR_TEND_BIT 3

#define ADC0_CDR (*(volatile unsigned long *)0xFFFC0080)
#define ADC0_CDR_OFFSET 0x80
#define ADC0_CDR_DATA_MASK 0x3FF
#define ADC0_CDR_DATA_BIT 0

#define ADC0_TSTR (*(volatile unsigned long *)0xFFFC0090)
#define ADC0_TSTR_OFFSET 0x90
#define ADC0_TSTR_TEST_MASK 0x1
#define ADC0_TSTR_TEST 0x1
#define ADC0_TSTR_TEST_BIT 0

#define GPT0_BASE 0xFFFC8000

#define GPT0C0_PER (*(volatile unsigned long *)0xFFFC8000)
#define GPT0C0_PER_OFFSET 0x0
#define GPT0C0_PER_TIOB_MASK 0x10000
#define GPT0C0_PER_TIOB 0x10000
#define GPT0C0_PER_TIOB_BIT 16
#define GPT0C0_PER_TIOA_MASK 0x20000
#define GPT0C0_PER_TIOA 0x20000
#define GPT0C0_PER_TIOA_BIT 17
#define GPT0C0_PER_TCLK_MASK 0x40000
#define GPT0C0_PER_TCLK 0x40000
#define GPT0C0_PER_TCLK_BIT 18

#define GPT0C0_PDR (*(volatile unsigned long *)0xFFFC8004)
#define GPT0C0_PDR_OFFSET 0x4
#define GPT0C0_PDR_TIOB_MASK 0x10000
#define GPT0C0_PDR_TIOB 0x10000
#define GPT0C0_PDR_TIOB_BIT 16
#define GPT0C0_PDR_TIOA_MASK 0x20000
#define GPT0C0_PDR_TIOA 0x20000
#define GPT0C0_PDR_TIOA_BIT 17
#define GPT0C0_PDR_TCLK_MASK 0x40000
#define GPT0C0_PDR_TCLK 0x40000
#define GPT0C0_PDR_TCLK_BIT 18

#define GPT0C0_PSR (*(volatile unsigned long *)0xFFFC8008)
#define GPT0C0_PSR_OFFSET 0x8
#define GPT0C0_PSR_TIOB_MASK 0x10000
#define GPT0C0_PSR_TIOB 0x10000
#define GPT0C0_PSR_TIOB_BIT 16
#define GPT0C0_PSR_TIOA_MASK 0x20000
#define GPT0C0_PSR_TIOA 0x20000
#define GPT0C0_PSR_TIOA_BIT 17
#define GPT0C0_PSR_TCLK_MASK 0x40000
#define GPT0C0_PSR_TCLK 0x40000
#define GPT0C0_PSR_TCLK_BIT 18

#define GPT0C0_OER (*(volatile unsigned long *)0xFFFC8010)
#define GPT0C0_OER_OFFSET 0x10
#define GPT0C0_OER_TIOB_MASK 0x10000
#define GPT0C0_OER_TIOB 0x10000
#define GPT0C0_OER_TIOB_BIT 16
#define GPT0C0_OER_TIOA_MASK 0x20000
#define GPT0C0_OER_TIOA 0x20000
#define GPT0C0_OER_TIOA_BIT 17
#define GPT0C0_OER_TCLK_MASK 0x40000
#define GPT0C0_OER_TCLK 0x40000
#define GPT0C0_OER_TCLK_BIT 18

#define GPT0C0_ODR (*(volatile unsigned long *)0xFFFC8014)
#define GPT0C0_ODR_OFFSET 0x14
#define GPT0C0_ODR_TIOB_MASK 0x10000
#define GPT0C0_ODR_TIOB 0x10000
#define GPT0C0_ODR_TIOB_BIT 16
#define GPT0C0_ODR_TIOA_MASK 0x20000
#define GPT0C0_ODR_TIOA 0x20000
#define GPT0C0_ODR_TIOA_BIT 17
#define GPT0C0_ODR_TCLK_MASK 0x40000
#define GPT0C0_ODR_TCLK 0x40000
#define GPT0C0_ODR_TCLK_BIT 18

#define GPT0C0_OSR (*(volatile unsigned long *)0xFFFC8018)
#define GPT0C0_OSR_OFFSET 0x18
#define GPT0C0_OSR_TIOB_MASK 0x10000
#define GPT0C0_OSR_TIOB 0x10000
#define GPT0C0_OSR_TIOB_BIT 16
#define GPT0C0_OSR_TIOA_MASK 0x20000
#define GPT0C0_OSR_TIOA 0x20000
#define GPT0C0_OSR_TIOA_BIT 17
#define GPT0C0_OSR_TCLK_MASK 0x40000
#define GPT0C0_OSR_TCLK 0x40000
#define GPT0C0_OSR_TCLK_BIT 18

#define GPT0C0_SODR (*(volatile unsigned long *)0xFFFC8030)
#define GPT0C0_SODR_OFFSET 0x30
#define GPT0C0_SODR_TIOB_MASK 0x10000
#define GPT0C0_SODR_TIOB 0x10000
#define GPT0C0_SODR_TIOB_BIT 16
#define GPT0C0_SODR_TIOA_MASK 0x20000
#define GPT0C0_SODR_TIOA 0x20000
#define GPT0C0_SODR_TIOA_BIT 17
#define GPT0C0_SODR_TCLK_MASK 0x40000
#define GPT0C0_SODR_TCLK 0x40000
#define GPT0C0_SODR_TCLK_BIT 18

#define GPT0C0_CODR (*(volatile unsigned long *)0xFFFC8034)
#define GPT0C0_CODR_OFFSET 0x34
#define GPT0C0_CODR_TIOB_MASK 0x10000
#define GPT0C0_CODR_TIOB 0x10000
#define GPT0C0_CODR_TIOB_BIT 16
#define GPT0C0_CODR_TIOA_MASK 0x20000
#define GPT0C0_CODR_TIOA 0x20000
#define GPT0C0_CODR_TIOA_BIT 17
#define GPT0C0_CODR_TCLK_MASK 0x40000
#define GPT0C0_CODR_TCLK 0x40000
#define GPT0C0_CODR_TCLK_BIT 18

#define GPT0C0_ODSR (*(volatile unsigned long *)0xFFFC8038)
#define GPT0C0_ODSR_OFFSET 0x38
#define GPT0C0_ODSR_TIOB_MASK 0x10000
#define GPT0C0_ODSR_TIOB 0x10000
#define GPT0C0_ODSR_TIOB_BIT 16
#define GPT0C0_ODSR_TIOA_MASK 0x20000
#define GPT0C0_ODSR_TIOA 0x20000
#define GPT0C0_ODSR_TIOA_BIT 17
#define GPT0C0_ODSR_TCLK_MASK 0x40000
#define GPT0C0_ODSR_TCLK 0x40000
#define GPT0C0_ODSR_TCLK_BIT 18

#define GPT0C0_PDSR (*(volatile unsigned long *)0xFFFC803C)
#define GPT0C0_PDSR_OFFSET 0x3C
#define GPT0C0_PDSR_TIOB_MASK 0x10000
#define GPT0C0_PDSR_TIOB 0x10000
#define GPT0C0_PDSR_TIOB_BIT 16
#define GPT0C0_PDSR_TIOA_MASK 0x20000
#define GPT0C0_PDSR_TIOA 0x20000
#define GPT0C0_PDSR_TIOA_BIT 17
#define GPT0C0_PDSR_TCLK_MASK 0x40000
#define GPT0C0_PDSR_TCLK 0x40000
#define GPT0C0_PDSR_TCLK_BIT 18

#define GPT0C0_MDER (*(volatile unsigned long *)0xFFFC8040)
#define GPT0C0_MDER_OFFSET 0x40
#define GPT0C0_MDER_TIOB_MASK 0x10000
#define GPT0C0_MDER_TIOB 0x10000
#define GPT0C0_MDER_TIOB_BIT 16
#define GPT0C0_MDER_TIOA_MASK 0x20000
#define GPT0C0_MDER_TIOA 0x20000
#define GPT0C0_MDER_TIOA_BIT 17
#define GPT0C0_MDER_TCLK_MASK 0x40000
#define GPT0C0_MDER_TCLK 0x40000
#define GPT0C0_MDER_TCLK_BIT 18

#define GPT0C0_MDDR (*(volatile unsigned long *)0xFFFC8044)
#define GPT0C0_MDDR_OFFSET 0x44
#define GPT0C0_MDDR_TIOB_MASK 0x10000
#define GPT0C0_MDDR_TIOB 0x10000
#define GPT0C0_MDDR_TIOB_BIT 16
#define GPT0C0_MDDR_TIOA_MASK 0x20000
#define GPT0C0_MDDR_TIOA 0x20000
#define GPT0C0_MDDR_TIOA_BIT 17
#define GPT0C0_MDDR_TCLK_MASK 0x40000
#define GPT0C0_MDDR_TCLK 0x40000
#define GPT0C0_MDDR_TCLK_BIT 18

#define GPT0C0_MDSR (*(volatile unsigned long *)0xFFFC8048)
#define GPT0C0_MDSR_OFFSET 0x48
#define GPT0C0_MDSR_TIOB_MASK 0x10000
#define GPT0C0_MDSR_TIOB 0x10000
#define GPT0C0_MDSR_TIOB_BIT 16
#define GPT0C0_MDSR_TIOA_MASK 0x20000
#define GPT0C0_MDSR_TIOA 0x20000
#define GPT0C0_MDSR_TIOA_BIT 17
#define GPT0C0_MDSR_TCLK_MASK 0x40000
#define GPT0C0_MDSR_TCLK 0x40000
#define GPT0C0_MDSR_TCLK_BIT 18

#define GPT0C0_ECR (*(volatile unsigned long *)0xFFFC8050)
#define GPT0C0_ECR_OFFSET 0x50
#define GPT0C0_ECR_PIO_MASK 0x1
#define GPT0C0_ECR_PIO 0x1
#define GPT0C0_ECR_PIO_BIT 0
#define GPT0C0_ECR_GPT_MASK 0x2
#define GPT0C0_ECR_GPT 0x2
#define GPT0C0_ECR_GPT_BIT 1

#define GPT0C0_DCR (*(volatile unsigned long *)0xFFFC8054)
#define GPT0C0_DCR_OFFSET 0x54
#define GPT0C0_DCR_PIO_MASK 0x1
#define GPT0C0_DCR_PIO 0x1
#define GPT0C0_DCR_PIO_BIT 0
#define GPT0C0_DCR_GPT_MASK 0x2
#define GPT0C0_DCR_GPT 0x2
#define GPT0C0_DCR_GPT_BIT 1

#define GPT0C0_PMSR (*(volatile unsigned long *)0xFFFC8058)
#define GPT0C0_PMSR_OFFSET 0x58
#define GPT0C0_PMSR_PIO_MASK 0x1
#define GPT0C0_PMSR_PIO 0x1
#define GPT0C0_PMSR_PIO_BIT 0
#define GPT0C0_PMSR_GPT_MASK 0x2
#define GPT0C0_PMSR_GPT 0x2
#define GPT0C0_PMSR_GPT_BIT 1

#define GPT0C0_CR (*(volatile unsigned long *)0xFFFC8060)
#define GPT0C0_CR_OFFSET 0x60
#define GPT0C0_CR_SWRST_MASK 0x1
#define GPT0C0_CR_SWRST 0x1
#define GPT0C0_CR_SWRST_BIT 0
#define GPT0C0_CR_CLKEN_MASK 0x2
#define GPT0C0_CR_CLKEN 0x2
#define GPT0C0_CR_CLKEN_BIT 1
#define GPT0C0_CR_CLKDIS_MASK 0x4
#define GPT0C0_CR_CLKDIS 0x4
#define GPT0C0_CR_CLKDIS_BIT 2
#define GPT0C0_CR_SWTRG_MASK 0x8
#define GPT0C0_CR_SWTRG 0x8
#define GPT0C0_CR_SWTRG_BIT 3

#define GPT0C0_MR (*(volatile unsigned long *)0xFFFC8064)
#define GPT0C0_MR_OFFSET 0x64
#define GPT0C0_MR_CLKS_MASK 0x7
#define GPT0C0_MR_CLKS_BIT 0
#define GPT0C0_MR_CLKI_MASK 0x8
#define GPT0C0_MR_CLKI 0x8
#define GPT0C0_MR_CLKI_BIT 3
#define GPT0C0_MR_BURST_MASK 0x30
#define GPT0C0_MR_BURST_BIT 4
#define GPT0C0_MR_LDBSTOP_MASK 0x40
#define GPT0C0_MR_LDBSTOP 0x40
#define GPT0C0_MR_LDBSTOP_BIT 6
#define GPT0C0_MR_LDBIS_MASK 0x80
#define GPT0C0_MR_LDBIS 0x80
#define GPT0C0_MR_LDBIS_BIT 7
#define GPT0C0_MR_ETRGEDG_MASK 0x300
#define GPT0C0_MR_ETRGEDG_BIT 8
#define GPT0C0_MR_ABETRG_MASK 0x400
#define GPT0C0_MR_ABETRG 0x400
#define GPT0C0_MR_ABETRG_BIT 10
#define GPT0C0_MR_CPCTRG_MASK 0x4000
#define GPT0C0_MR_CPCTRG 0x4000
#define GPT0C0_MR_CPCTRG_BIT 14
#define GPT0C0_MR_WAVE_MASK 0x8000
#define GPT0C0_MR_WAVE 0x8000
#define GPT0C0_MR_WAVE_BIT 15
#define GPT0C0_MR_LDRA_MASK 0x30000
#define GPT0C0_MR_LDRA_BIT 16
#define GPT0C0_MR_LDRB_MASK 0xC0000
#define GPT0C0_MR_LDRB_BIT 18

#define GPT0C0_MR_WFM (*(volatile unsigned long *)0xFFFC8064)
#define GPT0C0_MR_WFM_OFFSET 0x64
#define GPT0C0_MR_WFM_CLKS_MASK 0x7
#define GPT0C0_MR_WFM_CLKS_BIT 0
#define GPT0C0_MR_WFM_CLKI_MASK 0x8
#define GPT0C0_MR_WFM_CLKI 0x8
#define GPT0C0_MR_WFM_CLKI_BIT 3
#define GPT0C0_MR_WFM_BURST_MASK 0x30
#define GPT0C0_MR_WFM_BURST_BIT 4
#define GPT0C0_MR_WFM_CPCSTOP_MASK 0x40
#define GPT0C0_MR_WFM_CPCSTOP 0x40
#define GPT0C0_MR_WFM_CPCSTOP_BIT 6
#define GPT0C0_MR_WFM_CPCDIS_MASK 0x80
#define GPT0C0_MR_WFM_CPCDIS 0x80
#define GPT0C0_MR_WFM_CPCDIS_BIT 7
#define GPT0C0_MR_WFM_EEVTEDG_MASK 0x300
#define GPT0C0_MR_WFM_EEVTEDG_BIT 8
#define GPT0C0_MR_WFM_EEVT_MASK 0xC00
#define GPT0C0_MR_WFM_EEVT_BIT 10
#define GPT0C0_MR_WFM_ENETRG_MASK 0x1000
#define GPT0C0_MR_WFM_ENETRG 0x1000
#define GPT0C0_MR_WFM_ENETRG_BIT 12
#define GPT0C0_MR_WFM_CPCTRG_MASK 0x4000
#define GPT0C0_MR_WFM_CPCTRG 0x4000
#define GPT0C0_MR_WFM_CPCTRG_BIT 14
#define GPT0C0_MR_WFM_WAVE_MASK 0x18000
#define GPT0C0_MR_WFM_WAVE_BIT 15
#define GPT0C0_MR_WFM_ACPA_MASK 0x30000
#define GPT0C0_MR_WFM_ACPA_BIT 16
#define GPT0C0_MR_WFM_ACPC_MASK 0xC0000
#define GPT0C0_MR_WFM_ACPC_BIT 18
#define GPT0C0_MR_WFM_AEEVT_MASK 0x300000
#define GPT0C0_MR_WFM_AEEVT_BIT 20
#define GPT0C0_MR_WFM_ASWTRG_MASK 0xC00000
#define GPT0C0_MR_WFM_ASWTRG_BIT 22
#define GPT0C0_MR_WFM_BCPB_MASK 0x3000000
#define GPT0C0_MR_WFM_BCPB_BIT 24
#define GPT0C0_MR_WFM_BCPC_MASK 0xC000000
#define GPT0C0_MR_WFM_BCPC_BIT 26
#define GPT0C0_MR_WFM_BEEVT_MASK 0x30000000
#define GPT0C0_MR_WFM_BEEVT_BIT 28
#define GPT0C0_MR_WFM_BSWTRG_MASK 0xC0000000
#define GPT0C0_MR_WFM_BSWTRG_BIT 30

#define GPT0C0_SR (*(volatile unsigned long *)0xFFFC8070)
#define GPT0C0_SR_OFFSET 0x70
#define GPT0C0_SR_COVFS_MASK 0x1
#define GPT0C0_SR_COVFS 0x1
#define GPT0C0_SR_COVFS_BIT 0
#define GPT0C0_SR_LOVRS_MASK 0x2
#define GPT0C0_SR_LOVRS 0x2
#define GPT0C0_SR_LOVRS_BIT 1
#define GPT0C0_SR_CPCS_MASK 0x10
#define GPT0C0_SR_CPCS 0x10
#define GPT0C0_SR_CPCS_BIT 4
#define GPT0C0_SR_LDRAS_MASK 0x20
#define GPT0C0_SR_LDRAS 0x20
#define GPT0C0_SR_LDRAS_BIT 5
#define GPT0C0_SR_LDRBS_MASK 0x40
#define GPT0C0_SR_LDRBS 0x40
#define GPT0C0_SR_LDRBS_BIT 6
#define GPT0C0_SR_ETRGS_MASK 0x80
#define GPT0C0_SR_ETRGS 0x80
#define GPT0C0_SR_ETRGS_BIT 7
#define GPT0C0_SR_CLKSTA_MASK 0x100
#define GPT0C0_SR_CLKSTA 0x100
#define GPT0C0_SR_CLKSTA_BIT 8
#define GPT0C0_SR_MTIOA_MASK 0x200
#define GPT0C0_SR_MTIOA 0x200
#define GPT0C0_SR_MTIOA_BIT 9
#define GPT0C0_SR_MTIOB_MASK 0x400
#define GPT0C0_SR_MTIOB 0x400
#define GPT0C0_SR_MTIOB_BIT 10
#define GPT0C0_SR_TIOBS_MASK 0x10000
#define GPT0C0_SR_TIOBS 0x10000
#define GPT0C0_SR_TIOBS_BIT 16
#define GPT0C0_SR_TIOAS_MASK 0x20000
#define GPT0C0_SR_TIOAS 0x20000
#define GPT0C0_SR_TIOAS_BIT 17
#define GPT0C0_SR_TCLKS_MASK 0x40000
#define GPT0C0_SR_TCLKS 0x40000
#define GPT0C0_SR_TCLKS_BIT 18

#define GPT0C0_SR_WFM (*(volatile unsigned long *)0xFFFC8070)
#define GPT0C0_SR_WFM_OFFSET 0x70
#define GPT0C0_SR_WFM_COVFS_MASK 0x1
#define GPT0C0_SR_WFM_COVFS 0x1
#define GPT0C0_SR_WFM_COVFS_BIT 0
#define GPT0C0_SR_WFM_CPAS_MASK 0x4
#define GPT0C0_SR_WFM_CPAS 0x4
#define GPT0C0_SR_WFM_CPAS_BIT 2
#define GPT0C0_SR_WFM_CPBS_MASK 0x8
#define GPT0C0_SR_WFM_CPBS 0x8
#define GPT0C0_SR_WFM_CPBS_BIT 3
#define GPT0C0_SR_WFM_CPCS_MASK 0x10
#define GPT0C0_SR_WFM_CPCS 0x10
#define GPT0C0_SR_WFM_CPCS_BIT 4
#define GPT0C0_SR_WFM_ETRGS_MASK 0x80
#define GPT0C0_SR_WFM_ETRGS 0x80
#define GPT0C0_SR_WFM_ETRGS_BIT 7
#define GPT0C0_SR_WFM_CLKSTA_MASK 0x100
#define GPT0C0_SR_WFM_CLKSTA 0x100
#define GPT0C0_SR_WFM_CLKSTA_BIT 8
#define GPT0C0_SR_WFM_MTIOA_MASK 0x200
#define GPT0C0_SR_WFM_MTIOA 0x200
#define GPT0C0_SR_WFM_MTIOA_BIT 9
#define GPT0C0_SR_WFM_MTIOB_MASK 0x400
#define GPT0C0_SR_WFM_MTIOB 0x400
#define GPT0C0_SR_WFM_MTIOB_BIT 10
#define GPT0C0_SR_WFM_TIOBS_MASK 0x10000
#define GPT0C0_SR_WFM_TIOBS 0x10000
#define GPT0C0_SR_WFM_TIOBS_BIT 16
#define GPT0C0_SR_WFM_TIOAS_MASK 0x20000
#define GPT0C0_SR_WFM_TIOAS 0x20000
#define GPT0C0_SR_WFM_TIOAS_BIT 17
#define GPT0C0_SR_WFM_TCLKS_MASK 0x40000
#define GPT0C0_SR_WFM_TCLKS 0x40000
#define GPT0C0_SR_WFM_TCLKS_BIT 18

#define GPT0C0_IER (*(volatile unsigned long *)0xFFFC8074)
#define GPT0C0_IER_OFFSET 0x74
#define GPT0C0_IER_COVFS_MASK 0x1
#define GPT0C0_IER_COVFS 0x1
#define GPT0C0_IER_COVFS_BIT 0
#define GPT0C0_IER_LOVRS_MASK 0x2
#define GPT0C0_IER_LOVRS 0x2
#define GPT0C0_IER_LOVRS_BIT 1
#define GPT0C0_IER_CPCS_MASK 0x10
#define GPT0C0_IER_CPCS 0x10
#define GPT0C0_IER_CPCS_BIT 4
#define GPT0C0_IER_LDRAS_MASK 0x20
#define GPT0C0_IER_LDRAS 0x20
#define GPT0C0_IER_LDRAS_BIT 5
#define GPT0C0_IER_LDRBS_MASK 0x40
#define GPT0C0_IER_LDRBS 0x40
#define GPT0C0_IER_LDRBS_BIT 6
#define GPT0C0_IER_ETRGS_MASK 0x80
#define GPT0C0_IER_ETRGS 0x80
#define GPT0C0_IER_ETRGS_BIT 7
#define GPT0C0_IER_TIOBS_MASK 0x10000
#define GPT0C0_IER_TIOBS 0x10000
#define GPT0C0_IER_TIOBS_BIT 16
#define GPT0C0_IER_TIOAS_MASK 0x20000
#define GPT0C0_IER_TIOAS 0x20000
#define GPT0C0_IER_TIOAS_BIT 17
#define GPT0C0_IER_TCLKS_MASK 0x40000
#define GPT0C0_IER_TCLKS 0x40000
#define GPT0C0_IER_TCLKS_BIT 18

#define GPT0C0_IER_WFM (*(volatile unsigned long *)0xFFFC8074)
#define GPT0C0_IER_WFM_OFFSET 0x74
#define GPT0C0_IER_WFM_COVFS_MASK 0x1
#define GPT0C0_IER_WFM_COVFS 0x1
#define GPT0C0_IER_WFM_COVFS_BIT 0
#define GPT0C0_IER_WFM_CPAS_MASK 0x4
#define GPT0C0_IER_WFM_CPAS 0x4
#define GPT0C0_IER_WFM_CPAS_BIT 2
#define GPT0C0_IER_WFM_CPBS_MASK 0x8
#define GPT0C0_IER_WFM_CPBS 0x8
#define GPT0C0_IER_WFM_CPBS_BIT 3
#define GPT0C0_IER_WFM_CPCS_MASK 0x10
#define GPT0C0_IER_WFM_CPCS 0x10
#define GPT0C0_IER_WFM_CPCS_BIT 4
#define GPT0C0_IER_WFM_ETRGS_MASK 0x80
#define GPT0C0_IER_WFM_ETRGS 0x80
#define GPT0C0_IER_WFM_ETRGS_BIT 7
#define GPT0C0_IER_WFM_TIOBS_MASK 0x10000
#define GPT0C0_IER_WFM_TIOBS 0x10000
#define GPT0C0_IER_WFM_TIOBS_BIT 16
#define GPT0C0_IER_WFM_TIOAS_MASK 0x20000
#define GPT0C0_IER_WFM_TIOAS 0x20000
#define GPT0C0_IER_WFM_TIOAS_BIT 17
#define GPT0C0_IER_WFM_TCLKS_MASK 0x40000
#define GPT0C0_IER_WFM_TCLKS 0x40000
#define GPT0C0_IER_WFM_TCLKS_BIT 18

#define GPT0C0_IDR (*(volatile unsigned long *)0xFFFC8078)
#define GPT0C0_IDR_OFFSET 0x78
#define GPT0C0_IDR_COVFS_MASK 0x1
#define GPT0C0_IDR_COVFS 0x1
#define GPT0C0_IDR_COVFS_BIT 0
#define GPT0C0_IDR_LOVRS_MASK 0x2
#define GPT0C0_IDR_LOVRS 0x2
#define GPT0C0_IDR_LOVRS_BIT 1
#define GPT0C0_IDR_CPCS_MASK 0x10
#define GPT0C0_IDR_CPCS 0x10
#define GPT0C0_IDR_CPCS_BIT 4
#define GPT0C0_IDR_LDRAS_MASK 0x20
#define GPT0C0_IDR_LDRAS 0x20
#define GPT0C0_IDR_LDRAS_BIT 5
#define GPT0C0_IDR_LDRBS_MASK 0x40
#define GPT0C0_IDR_LDRBS 0x40
#define GPT0C0_IDR_LDRBS_BIT 6
#define GPT0C0_IDR_ETRGS_MASK 0x80
#define GPT0C0_IDR_ETRGS 0x80
#define GPT0C0_IDR_ETRGS_BIT 7
#define GPT0C0_IDR_TIOBS_MASK 0x10000
#define GPT0C0_IDR_TIOBS 0x10000
#define GPT0C0_IDR_TIOBS_BIT 16
#define GPT0C0_IDR_TIOAS_MASK 0x20000
#define GPT0C0_IDR_TIOAS 0x20000
#define GPT0C0_IDR_TIOAS_BIT 17
#define GPT0C0_IDR_TCLKS_MASK 0x40000
#define GPT0C0_IDR_TCLKS 0x40000
#define GPT0C0_IDR_TCLKS_BIT 18

#define GPT0C0_IDR_WFM (*(volatile unsigned long *)0xFFFC8078)
#define GPT0C0_IDR_WFM_OFFSET 0x78
#define GPT0C0_IDR_WFM_COVFS_MASK 0x1
#define GPT0C0_IDR_WFM_COVFS 0x1
#define GPT0C0_IDR_WFM_COVFS_BIT 0
#define GPT0C0_IDR_WFM_CPAS_MASK 0x4
#define GPT0C0_IDR_WFM_CPAS 0x4
#define GPT0C0_IDR_WFM_CPAS_BIT 2
#define GPT0C0_IDR_WFM_CPBS_MASK 0x8
#define GPT0C0_IDR_WFM_CPBS 0x8
#define GPT0C0_IDR_WFM_CPBS_BIT 3
#define GPT0C0_IDR_WFM_CPCS_MASK 0x10
#define GPT0C0_IDR_WFM_CPCS 0x10
#define GPT0C0_IDR_WFM_CPCS_BIT 4
#define GPT0C0_IDR_WFM_ETRGS_MASK 0x80
#define GPT0C0_IDR_WFM_ETRGS 0x80
#define GPT0C0_IDR_WFM_ETRGS_BIT 7
#define GPT0C0_IDR_WFM_TIOBS_MASK 0x10000
#define GPT0C0_IDR_WFM_TIOBS 0x10000
#define GPT0C0_IDR_WFM_TIOBS_BIT 16
#define GPT0C0_IDR_WFM_TIOAS_MASK 0x20000
#define GPT0C0_IDR_WFM_TIOAS 0x20000
#define GPT0C0_IDR_WFM_TIOAS_BIT 17
#define GPT0C0_IDR_WFM_TCLKS_MASK 0x40000
#define GPT0C0_IDR_WFM_TCLKS 0x40000
#define GPT0C0_IDR_WFM_TCLKS_BIT 18

#define GPT0C0_IMR (*(volatile unsigned long *)0xFFFC807C)
#define GPT0C0_IMR_OFFSET 0x7C
#define GPT0C0_IMR_COVFS_MASK 0x1
#define GPT0C0_IMR_COVFS 0x1
#define GPT0C0_IMR_COVFS_BIT 0
#define GPT0C0_IMR_LOVRS_MASK 0x2
#define GPT0C0_IMR_LOVRS 0x2
#define GPT0C0_IMR_LOVRS_BIT 1
#define GPT0C0_IMR_CPCS_MASK 0x10
#define GPT0C0_IMR_CPCS 0x10
#define GPT0C0_IMR_CPCS_BIT 4
#define GPT0C0_IMR_LDRAS_MASK 0x20
#define GPT0C0_IMR_LDRAS 0x20
#define GPT0C0_IMR_LDRAS_BIT 5
#define GPT0C0_IMR_LDRBS_MASK 0x40
#define GPT0C0_IMR_LDRBS 0x40
#define GPT0C0_IMR_LDRBS_BIT 6
#define GPT0C0_IMR_ETRGS_MASK 0x80
#define GPT0C0_IMR_ETRGS 0x80
#define GPT0C0_IMR_ETRGS_BIT 7
#define GPT0C0_IMR_TIOBS_MASK 0x10000
#define GPT0C0_IMR_TIOBS 0x10000
#define GPT0C0_IMR_TIOBS_BIT 16
#define GPT0C0_IMR_TIOAS_MASK 0x20000
#define GPT0C0_IMR_TIOAS 0x20000
#define GPT0C0_IMR_TIOAS_BIT 17
#define GPT0C0_IMR_TCLKS_MASK 0x40000
#define GPT0C0_IMR_TCLKS 0x40000
#define GPT0C0_IMR_TCLKS_BIT 18

#define GPT0C0_IMR_WFM (*(volatile unsigned long *)0xFFFC807C)
#define GPT0C0_IMR_WFM_OFFSET 0x7C
#define GPT0C0_IMR_WFM_COVFS_MASK 0x1
#define GPT0C0_IMR_WFM_COVFS 0x1
#define GPT0C0_IMR_WFM_COVFS_BIT 0
#define GPT0C0_IMR_WFM_CPAS_MASK 0x4
#define GPT0C0_IMR_WFM_CPAS 0x4
#define GPT0C0_IMR_WFM_CPAS_BIT 2
#define GPT0C0_IMR_WFM_CPBS_MASK 0x8
#define GPT0C0_IMR_WFM_CPBS 0x8
#define GPT0C0_IMR_WFM_CPBS_BIT 3
#define GPT0C0_IMR_WFM_CPCS_MASK 0x10
#define GPT0C0_IMR_WFM_CPCS 0x10
#define GPT0C0_IMR_WFM_CPCS_BIT 4
#define GPT0C0_IMR_WFM_ETRGS_MASK 0x80
#define GPT0C0_IMR_WFM_ETRGS 0x80
#define GPT0C0_IMR_WFM_ETRGS_BIT 7
#define GPT0C0_IMR_WFM_TIOBS_MASK 0x10000
#define GPT0C0_IMR_WFM_TIOBS 0x10000
#define GPT0C0_IMR_WFM_TIOBS_BIT 16
#define GPT0C0_IMR_WFM_TIOAS_MASK 0x20000
#define GPT0C0_IMR_WFM_TIOAS 0x20000
#define GPT0C0_IMR_WFM_TIOAS_BIT 17
#define GPT0C0_IMR_WFM_TCLKS_MASK 0x40000
#define GPT0C0_IMR_WFM_TCLKS 0x40000
#define GPT0C0_IMR_WFM_TCLKS_BIT 18

#define GPT0C0_CV (*(volatile unsigned long *)0xFFFC8080)
#define GPT0C0_CV_OFFSET 0x80
#define GPT0C0_CV_CV_MASK 0xFFFF
#define GPT0C0_CV_CV_BIT 0

#define GPT0C0_RA (*(volatile unsigned long *)0xFFFC8084)
#define GPT0C0_RA_OFFSET 0x84
#define GPT0C0_RA_RA_MASK 0xFFFF
#define GPT0C0_RA_RA_BIT 0

#define GPT0C0_RB (*(volatile unsigned long *)0xFFFC8088)
#define GPT0C0_RB_OFFSET 0x88
#define GPT0C0_RB_RB_MASK 0xFFFF
#define GPT0C0_RB_RB_BIT 0

#define GPT0C0_RC (*(volatile unsigned long *)0xFFFC808C)
#define GPT0C0_RC_OFFSET 0x8C
#define GPT0C0_RC_RC_MASK 0xFFFF
#define GPT0C0_RC_RC_BIT 0

#define GPT0C1_PER (*(volatile unsigned long *)0xFFFC8100)
#define GPT0C1_PER_OFFSET 0x100
#define GPT0C1_PER_TIOB_MASK 0x10000
#define GPT0C1_PER_TIOB 0x10000
#define GPT0C1_PER_TIOB_BIT 16
#define GPT0C1_PER_TIOA_MASK 0x20000
#define GPT0C1_PER_TIOA 0x20000
#define GPT0C1_PER_TIOA_BIT 17
#define GPT0C1_PER_TCLK_MASK 0x40000
#define GPT0C1_PER_TCLK 0x40000
#define GPT0C1_PER_TCLK_BIT 18

#define GPT0C1_PDR (*(volatile unsigned long *)0xFFFC8104)
#define GPT0C1_PDR_OFFSET 0x104
#define GPT0C1_PDR_TIOB_MASK 0x10000
#define GPT0C1_PDR_TIOB 0x10000
#define GPT0C1_PDR_TIOB_BIT 16
#define GPT0C1_PDR_TIOA_MASK 0x20000
#define GPT0C1_PDR_TIOA 0x20000
#define GPT0C1_PDR_TIOA_BIT 17
#define GPT0C1_PDR_TCLK_MASK 0x40000
#define GPT0C1_PDR_TCLK 0x40000
#define GPT0C1_PDR_TCLK_BIT 18

#define GPT0C1_PSR (*(volatile unsigned long *)0xFFFC8108)
#define GPT0C1_PSR_OFFSET 0x108
#define GPT0C1_PSR_TIOB_MASK 0x10000
#define GPT0C1_PSR_TIOB 0x10000
#define GPT0C1_PSR_TIOB_BIT 16
#define GPT0C1_PSR_TIOA_MASK 0x20000
#define GPT0C1_PSR_TIOA 0x20000
#define GPT0C1_PSR_TIOA_BIT 17
#define GPT0C1_PSR_TCLK_MASK 0x40000
#define GPT0C1_PSR_TCLK 0x40000
#define GPT0C1_PSR_TCLK_BIT 18

#define GPT0C1_OER (*(volatile unsigned long *)0xFFFC8110)
#define GPT0C1_OER_OFFSET 0x110
#define GPT0C1_OER_TIOB_MASK 0x10000
#define GPT0C1_OER_TIOB 0x10000
#define GPT0C1_OER_TIOB_BIT 16
#define GPT0C1_OER_TIOA_MASK 0x20000
#define GPT0C1_OER_TIOA 0x20000
#define GPT0C1_OER_TIOA_BIT 17
#define GPT0C1_OER_TCLK_MASK 0x40000
#define GPT0C1_OER_TCLK 0x40000
#define GPT0C1_OER_TCLK_BIT 18

#define GPT0C1_ODR (*(volatile unsigned long *)0xFFFC8114)
#define GPT0C1_ODR_OFFSET 0x114
#define GPT0C1_ODR_TIOB_MASK 0x10000
#define GPT0C1_ODR_TIOB 0x10000
#define GPT0C1_ODR_TIOB_BIT 16
#define GPT0C1_ODR_TIOA_MASK 0x20000
#define GPT0C1_ODR_TIOA 0x20000
#define GPT0C1_ODR_TIOA_BIT 17
#define GPT0C1_ODR_TCLK_MASK 0x40000
#define GPT0C1_ODR_TCLK 0x40000
#define GPT0C1_ODR_TCLK_BIT 18

#define GPT0C1_OSR (*(volatile unsigned long *)0xFFFC8118)
#define GPT0C1_OSR_OFFSET 0x118
#define GPT0C1_OSR_TIOB_MASK 0x10000
#define GPT0C1_OSR_TIOB 0x10000
#define GPT0C1_OSR_TIOB_BIT 16
#define GPT0C1_OSR_TIOA_MASK 0x20000
#define GPT0C1_OSR_TIOA 0x20000
#define GPT0C1_OSR_TIOA_BIT 17
#define GPT0C1_OSR_TCLK_MASK 0x40000
#define GPT0C1_OSR_TCLK 0x40000
#define GPT0C1_OSR_TCLK_BIT 18

#define GPT0C1_SODR (*(volatile unsigned long *)0xFFFC8130)
#define GPT0C1_SODR_OFFSET 0x130
#define GPT0C1_SODR_TIOB_MASK 0x10000
#define GPT0C1_SODR_TIOB 0x10000
#define GPT0C1_SODR_TIOB_BIT 16
#define GPT0C1_SODR_TIOA_MASK 0x20000
#define GPT0C1_SODR_TIOA 0x20000
#define GPT0C1_SODR_TIOA_BIT 17
#define GPT0C1_SODR_TCLK_MASK 0x40000
#define GPT0C1_SODR_TCLK 0x40000
#define GPT0C1_SODR_TCLK_BIT 18

#define GPT0C1_CODR (*(volatile unsigned long *)0xFFFC8134)
#define GPT0C1_CODR_OFFSET 0x134
#define GPT0C1_CODR_TIOB_MASK 0x10000
#define GPT0C1_CODR_TIOB 0x10000
#define GPT0C1_CODR_TIOB_BIT 16
#define GPT0C1_CODR_TIOA_MASK 0x20000
#define GPT0C1_CODR_TIOA 0x20000
#define GPT0C1_CODR_TIOA_BIT 17
#define GPT0C1_CODR_TCLK_MASK 0x40000
#define GPT0C1_CODR_TCLK 0x40000
#define GPT0C1_CODR_TCLK_BIT 18

#define GPT0C1_ODSR (*(volatile unsigned long *)0xFFFC8138)
#define GPT0C1_ODSR_OFFSET 0x138
#define GPT0C1_ODSR_TIOB_MASK 0x10000
#define GPT0C1_ODSR_TIOB 0x10000
#define GPT0C1_ODSR_TIOB_BIT 16
#define GPT0C1_ODSR_TIOA_MASK 0x20000
#define GPT0C1_ODSR_TIOA 0x20000
#define GPT0C1_ODSR_TIOA_BIT 17
#define GPT0C1_ODSR_TCLK_MASK 0x40000
#define GPT0C1_ODSR_TCLK 0x40000
#define GPT0C1_ODSR_TCLK_BIT 18

#define GPT0C1_PDSR (*(volatile unsigned long *)0xFFFC813C)
#define GPT0C1_PDSR_OFFSET 0x13C
#define GPT0C1_PDSR_TIOB_MASK 0x10000
#define GPT0C1_PDSR_TIOB 0x10000
#define GPT0C1_PDSR_TIOB_BIT 16
#define GPT0C1_PDSR_TIOA_MASK 0x20000
#define GPT0C1_PDSR_TIOA 0x20000
#define GPT0C1_PDSR_TIOA_BIT 17
#define GPT0C1_PDSR_TCLK_MASK 0x40000
#define GPT0C1_PDSR_TCLK 0x40000
#define GPT0C1_PDSR_TCLK_BIT 18

#define GPT0C1_MDER (*(volatile unsigned long *)0xFFFC8140)
#define GPT0C1_MDER_OFFSET 0x140
#define GPT0C1_MDER_TIOB_MASK 0x10000
#define GPT0C1_MDER_TIOB 0x10000
#define GPT0C1_MDER_TIOB_BIT 16
#define GPT0C1_MDER_TIOA_MASK 0x20000
#define GPT0C1_MDER_TIOA 0x20000
#define GPT0C1_MDER_TIOA_BIT 17
#define GPT0C1_MDER_TCLK_MASK 0x40000
#define GPT0C1_MDER_TCLK 0x40000
#define GPT0C1_MDER_TCLK_BIT 18

#define GPT0C1_MDDR (*(volatile unsigned long *)0xFFFC8144)
#define GPT0C1_MDDR_OFFSET 0x144
#define GPT0C1_MDDR_TIOB_MASK 0x10000
#define GPT0C1_MDDR_TIOB 0x10000
#define GPT0C1_MDDR_TIOB_BIT 16
#define GPT0C1_MDDR_TIOA_MASK 0x20000
#define GPT0C1_MDDR_TIOA 0x20000
#define GPT0C1_MDDR_TIOA_BIT 17
#define GPT0C1_MDDR_TCLK_MASK 0x40000
#define GPT0C1_MDDR_TCLK 0x40000
#define GPT0C1_MDDR_TCLK_BIT 18

#define GPT0C1_MDSR (*(volatile unsigned long *)0xFFFC8148)
#define GPT0C1_MDSR_OFFSET 0x148
#define GPT0C1_MDSR_TIOB_MASK 0x10000
#define GPT0C1_MDSR_TIOB 0x10000
#define GPT0C1_MDSR_TIOB_BIT 16
#define GPT0C1_MDSR_TIOA_MASK 0x20000
#define GPT0C1_MDSR_TIOA 0x20000
#define GPT0C1_MDSR_TIOA_BIT 17
#define GPT0C1_MDSR_TCLK_MASK 0x40000
#define GPT0C1_MDSR_TCLK 0x40000
#define GPT0C1_MDSR_TCLK_BIT 18

#define GPT0C1_ECR (*(volatile unsigned long *)0xFFFC8150)
#define GPT0C1_ECR_OFFSET 0x150
#define GPT0C1_ECR_PIO_MASK 0x1
#define GPT0C1_ECR_PIO 0x1
#define GPT0C1_ECR_PIO_BIT 0
#define GPT0C1_ECR_GPT_MASK 0x2
#define GPT0C1_ECR_GPT 0x2
#define GPT0C1_ECR_GPT_BIT 1

#define GPT0C1_DCR (*(volatile unsigned long *)0xFFFC8154)
#define GPT0C1_DCR_OFFSET 0x154
#define GPT0C1_DCR_PIO_MASK 0x1
#define GPT0C1_DCR_PIO 0x1
#define GPT0C1_DCR_PIO_BIT 0
#define GPT0C1_DCR_GPT_MASK 0x2
#define GPT0C1_DCR_GPT 0x2
#define GPT0C1_DCR_GPT_BIT 1

#define GPT0C1_PMSR (*(volatile unsigned long *)0xFFFC8158)
#define GPT0C1_PMSR_OFFSET 0x158
#define GPT0C1_PMSR_PIO_MASK 0x1
#define GPT0C1_PMSR_PIO 0x1
#define GPT0C1_PMSR_PIO_BIT 0
#define GPT0C1_PMSR_GPT_MASK 0x2
#define GPT0C1_PMSR_GPT 0x2
#define GPT0C1_PMSR_GPT_BIT 1

#define GPT0C1_CR (*(volatile unsigned long *)0xFFFC8160)
#define GPT0C1_CR_OFFSET 0x160
#define GPT0C1_CR_SWRST_MASK 0x1
#define GPT0C1_CR_SWRST 0x1
#define GPT0C1_CR_SWRST_BIT 0
#define GPT0C1_CR_CLKEN_MASK 0x2
#define GPT0C1_CR_CLKEN 0x2
#define GPT0C1_CR_CLKEN_BIT 1
#define GPT0C1_CR_CLKDIS_MASK 0x4
#define GPT0C1_CR_CLKDIS 0x4
#define GPT0C1_CR_CLKDIS_BIT 2
#define GPT0C1_CR_SWTRG_MASK 0x8
#define GPT0C1_CR_SWTRG 0x8
#define GPT0C1_CR_SWTRG_BIT 3

#define GPT0C1_MR (*(volatile unsigned long *)0xFFFC8164)
#define GPT0C1_MR_OFFSET 0x164
#define GPT0C1_MR_CLKS_MASK 0x7
#define GPT0C1_MR_CLKS_BIT 0
#define GPT0C1_MR_CLKI_MASK 0x8
#define GPT0C1_MR_CLKI 0x8
#define GPT0C1_MR_CLKI_BIT 3
#define GPT0C1_MR_BURST_MASK 0x30
#define GPT0C1_MR_BURST_BIT 4
#define GPT0C1_MR_LDBSTOP_MASK 0x40
#define GPT0C1_MR_LDBSTOP 0x40
#define GPT0C1_MR_LDBSTOP_BIT 6
#define GPT0C1_MR_LDBIS_MASK 0x80
#define GPT0C1_MR_LDBIS 0x80
#define GPT0C1_MR_LDBIS_BIT 7
#define GPT0C1_MR_ETRGEDG_MASK 0x300
#define GPT0C1_MR_ETRGEDG_BIT 8
#define GPT0C1_MR_ABETRG_MASK 0x400
#define GPT0C1_MR_ABETRG 0x400
#define GPT0C1_MR_ABETRG_BIT 10
#define GPT0C1_MR_CPCTRG_MASK 0x4000
#define GPT0C1_MR_CPCTRG 0x4000
#define GPT0C1_MR_CPCTRG_BIT 14
#define GPT0C1_MR_WAVE_MASK 0x8000
#define GPT0C1_MR_WAVE 0x8000
#define GPT0C1_MR_WAVE_BIT 15
#define GPT0C1_MR_LDRA_MASK 0x30000
#define GPT0C1_MR_LDRA_BIT 16
#define GPT0C1_MR_LDRB_MASK 0xC0000
#define GPT0C1_MR_LDRB_BIT 18

#define GPT0C1_MR_WFM (*(volatile unsigned long *)0xFFFC8164)
#define GPT0C1_MR_WFM_OFFSET 0x164
#define GPT0C1_MR_WFM_CLKS_MASK 0x7
#define GPT0C1_MR_WFM_CLKS_BIT 0
#define GPT0C1_MR_WFM_CLKI_MASK 0x8
#define GPT0C1_MR_WFM_CLKI 0x8
#define GPT0C1_MR_WFM_CLKI_BIT 3
#define GPT0C1_MR_WFM_BURST_MASK 0x30
#define GPT0C1_MR_WFM_BURST_BIT 4
#define GPT0C1_MR_WFM_CPCSTOP_MASK 0x40
#define GPT0C1_MR_WFM_CPCSTOP 0x40
#define GPT0C1_MR_WFM_CPCSTOP_BIT 6
#define GPT0C1_MR_WFM_CPCDIS_MASK 0x80
#define GPT0C1_MR_WFM_CPCDIS 0x80
#define GPT0C1_MR_WFM_CPCDIS_BIT 7
#define GPT0C1_MR_WFM_EEVTEDG_MASK 0x300
#define GPT0C1_MR_WFM_EEVTEDG_BIT 8
#define GPT0C1_MR_WFM_EEVT_MASK 0xC00
#define GPT0C1_MR_WFM_EEVT_BIT 10
#define GPT0C1_MR_WFM_ENETRG_MASK 0x1000
#define GPT0C1_MR_WFM_ENETRG 0x1000
#define GPT0C1_MR_WFM_ENETRG_BIT 12
#define GPT0C1_MR_WFM_CPCTRG_MASK 0x4000
#define GPT0C1_MR_WFM_CPCTRG 0x4000
#define GPT0C1_MR_WFM_CPCTRG_BIT 14
#define GPT0C1_MR_WFM_WAVE_MASK 0x18000
#define GPT0C1_MR_WFM_WAVE_BIT 15
#define GPT0C1_MR_WFM_ACPA_MASK 0x30000
#define GPT0C1_MR_WFM_ACPA_BIT 16
#define GPT0C1_MR_WFM_ACPC_MASK 0xC0000
#define GPT0C1_MR_WFM_ACPC_BIT 18
#define GPT0C1_MR_WFM_AEEVT_MASK 0x300000
#define GPT0C1_MR_WFM_AEEVT_BIT 20
#define GPT0C1_MR_WFM_ASWTRG_MASK 0xC00000
#define GPT0C1_MR_WFM_ASWTRG_BIT 22
#define GPT0C1_MR_WFM_BCPB_MASK 0x3000000
#define GPT0C1_MR_WFM_BCPB_BIT 24
#define GPT0C1_MR_WFM_BCPC_MASK 0xC000000
#define GPT0C1_MR_WFM_BCPC_BIT 26
#define GPT0C1_MR_WFM_BEEVT_MASK 0x30000000
#define GPT0C1_MR_WFM_BEEVT_BIT 28
#define GPT0C1_MR_WFM_BSWTRG_MASK 0xC0000000
#define GPT0C1_MR_WFM_BSWTRG_BIT 30

#define GPT0C1_SR (*(volatile unsigned long *)0xFFFC8170)
#define GPT0C1_SR_OFFSET 0x170
#define GPT0C1_SR_COVFS_MASK 0x1
#define GPT0C1_SR_COVFS 0x1
#define GPT0C1_SR_COVFS_BIT 0
#define GPT0C1_SR_LOVRS_MASK 0x2
#define GPT0C1_SR_LOVRS 0x2
#define GPT0C1_SR_LOVRS_BIT 1
#define GPT0C1_SR_CPCS_MASK 0x10
#define GPT0C1_SR_CPCS 0x10
#define GPT0C1_SR_CPCS_BIT 4
#define GPT0C1_SR_LDRAS_MASK 0x20
#define GPT0C1_SR_LDRAS 0x20
#define GPT0C1_SR_LDRAS_BIT 5
#define GPT0C1_SR_LDRBS_MASK 0x40
#define GPT0C1_SR_LDRBS 0x40
#define GPT0C1_SR_LDRBS_BIT 6
#define GPT0C1_SR_ETRGS_MASK 0x80
#define GPT0C1_SR_ETRGS 0x80
#define GPT0C1_SR_ETRGS_BIT 7
#define GPT0C1_SR_CLKSTA_MASK 0x100
#define GPT0C1_SR_CLKSTA 0x100
#define GPT0C1_SR_CLKSTA_BIT 8
#define GPT0C1_SR_MTIOA_MASK 0x200
#define GPT0C1_SR_MTIOA 0x200
#define GPT0C1_SR_MTIOA_BIT 9
#define GPT0C1_SR_MTIOB_MASK 0x400
#define GPT0C1_SR_MTIOB 0x400
#define GPT0C1_SR_MTIOB_BIT 10
#define GPT0C1_SR_TIOBS_MASK 0x10000
#define GPT0C1_SR_TIOBS 0x10000
#define GPT0C1_SR_TIOBS_BIT 16
#define GPT0C1_SR_TIOAS_MASK 0x20000
#define GPT0C1_SR_TIOAS 0x20000
#define GPT0C1_SR_TIOAS_BIT 17
#define GPT0C1_SR_TCLKS_MASK 0x40000
#define GPT0C1_SR_TCLKS 0x40000
#define GPT0C1_SR_TCLKS_BIT 18

#define GPT0C1_SR_WFM (*(volatile unsigned long *)0xFFFC8170)
#define GPT0C1_SR_WFM_OFFSET 0x170
#define GPT0C1_SR_WFM_COVFS_MASK 0x1
#define GPT0C1_SR_WFM_COVFS 0x1
#define GPT0C1_SR_WFM_COVFS_BIT 0
#define GPT0C1_SR_WFM_CPAS_MASK 0x4
#define GPT0C1_SR_WFM_CPAS 0x4
#define GPT0C1_SR_WFM_CPAS_BIT 2
#define GPT0C1_SR_WFM_CPBS_MASK 0x8
#define GPT0C1_SR_WFM_CPBS 0x8
#define GPT0C1_SR_WFM_CPBS_BIT 3
#define GPT0C1_SR_WFM_CPCS_MASK 0x10
#define GPT0C1_SR_WFM_CPCS 0x10
#define GPT0C1_SR_WFM_CPCS_BIT 4
#define GPT0C1_SR_WFM_ETRGS_MASK 0x80
#define GPT0C1_SR_WFM_ETRGS 0x80
#define GPT0C1_SR_WFM_ETRGS_BIT 7
#define GPT0C1_SR_WFM_CLKSTA_MASK 0x100
#define GPT0C1_SR_WFM_CLKSTA 0x100
#define GPT0C1_SR_WFM_CLKSTA_BIT 8
#define GPT0C1_SR_WFM_MTIOA_MASK 0x200
#define GPT0C1_SR_WFM_MTIOA 0x200
#define GPT0C1_SR_WFM_MTIOA_BIT 9
#define GPT0C1_SR_WFM_MTIOB_MASK 0x400
#define GPT0C1_SR_WFM_MTIOB 0x400
#define GPT0C1_SR_WFM_MTIOB_BIT 10
#define GPT0C1_SR_WFM_TIOBS_MASK 0x10000
#define GPT0C1_SR_WFM_TIOBS 0x10000
#define GPT0C1_SR_WFM_TIOBS_BIT 16
#define GPT0C1_SR_WFM_TIOAS_MASK 0x20000
#define GPT0C1_SR_WFM_TIOAS 0x20000
#define GPT0C1_SR_WFM_TIOAS_BIT 17
#define GPT0C1_SR_WFM_TCLKS_MASK 0x40000
#define GPT0C1_SR_WFM_TCLKS 0x40000
#define GPT0C1_SR_WFM_TCLKS_BIT 18

#define GPT0C1_IER (*(volatile unsigned long *)0xFFFC8174)
#define GPT0C1_IER_OFFSET 0x174
#define GPT0C1_IER_COVFS_MASK 0x1
#define GPT0C1_IER_COVFS 0x1
#define GPT0C1_IER_COVFS_BIT 0
#define GPT0C1_IER_LOVRS_MASK 0x2
#define GPT0C1_IER_LOVRS 0x2
#define GPT0C1_IER_LOVRS_BIT 1
#define GPT0C1_IER_CPCS_MASK 0x10
#define GPT0C1_IER_CPCS 0x10
#define GPT0C1_IER_CPCS_BIT 4
#define GPT0C1_IER_LDRAS_MASK 0x20
#define GPT0C1_IER_LDRAS 0x20
#define GPT0C1_IER_LDRAS_BIT 5
#define GPT0C1_IER_LDRBS_MASK 0x40
#define GPT0C1_IER_LDRBS 0x40
#define GPT0C1_IER_LDRBS_BIT 6
#define GPT0C1_IER_ETRGS_MASK 0x80
#define GPT0C1_IER_ETRGS 0x80
#define GPT0C1_IER_ETRGS_BIT 7
#define GPT0C1_IER_TIOBS_MASK 0x10000
#define GPT0C1_IER_TIOBS 0x10000
#define GPT0C1_IER_TIOBS_BIT 16
#define GPT0C1_IER_TIOAS_MASK 0x20000
#define GPT0C1_IER_TIOAS 0x20000
#define GPT0C1_IER_TIOAS_BIT 17
#define GPT0C1_IER_TCLKS_MASK 0x40000
#define GPT0C1_IER_TCLKS 0x40000
#define GPT0C1_IER_TCLKS_BIT 18

#define GPT0C1_IER_WFM (*(volatile unsigned long *)0xFFFC8174)
#define GPT0C1_IER_WFM_OFFSET 0x174
#define GPT0C1_IER_WFM_COVFS_MASK 0x1
#define GPT0C1_IER_WFM_COVFS 0x1
#define GPT0C1_IER_WFM_COVFS_BIT 0
#define GPT0C1_IER_WFM_CPAS_MASK 0x4
#define GPT0C1_IER_WFM_CPAS 0x4
#define GPT0C1_IER_WFM_CPAS_BIT 2
#define GPT0C1_IER_WFM_CPBS_MASK 0x8
#define GPT0C1_IER_WFM_CPBS 0x8
#define GPT0C1_IER_WFM_CPBS_BIT 3
#define GPT0C1_IER_WFM_CPCS_MASK 0x10
#define GPT0C1_IER_WFM_CPCS 0x10
#define GPT0C1_IER_WFM_CPCS_BIT 4
#define GPT0C1_IER_WFM_ETRGS_MASK 0x80
#define GPT0C1_IER_WFM_ETRGS 0x80
#define GPT0C1_IER_WFM_ETRGS_BIT 7
#define GPT0C1_IER_WFM_TIOBS_MASK 0x10000
#define GPT0C1_IER_WFM_TIOBS 0x10000
#define GPT0C1_IER_WFM_TIOBS_BIT 16
#define GPT0C1_IER_WFM_TIOAS_MASK 0x20000
#define GPT0C1_IER_WFM_TIOAS 0x20000
#define GPT0C1_IER_WFM_TIOAS_BIT 17
#define GPT0C1_IER_WFM_TCLKS_MASK 0x40000
#define GPT0C1_IER_WFM_TCLKS 0x40000
#define GPT0C1_IER_WFM_TCLKS_BIT 18

#define GPT0C1_IDR (*(volatile unsigned long *)0xFFFC8178)
#define GPT0C1_IDR_OFFSET 0x178
#define GPT0C1_IDR_COVFS_MASK 0x1
#define GPT0C1_IDR_COVFS 0x1
#define GPT0C1_IDR_COVFS_BIT 0
#define GPT0C1_IDR_LOVRS_MASK 0x2
#define GPT0C1_IDR_LOVRS 0x2
#define GPT0C1_IDR_LOVRS_BIT 1
#define GPT0C1_IDR_CPCS_MASK 0x10
#define GPT0C1_IDR_CPCS 0x10
#define GPT0C1_IDR_CPCS_BIT 4
#define GPT0C1_IDR_LDRAS_MASK 0x20
#define GPT0C1_IDR_LDRAS 0x20
#define GPT0C1_IDR_LDRAS_BIT 5
#define GPT0C1_IDR_LDRBS_MASK 0x40
#define GPT0C1_IDR_LDRBS 0x40
#define GPT0C1_IDR_LDRBS_BIT 6
#define GPT0C1_IDR_ETRGS_MASK 0x80
#define GPT0C1_IDR_ETRGS 0x80
#define GPT0C1_IDR_ETRGS_BIT 7
#define GPT0C1_IDR_TIOBS_MASK 0x10000
#define GPT0C1_IDR_TIOBS 0x10000
#define GPT0C1_IDR_TIOBS_BIT 16
#define GPT0C1_IDR_TIOAS_MASK 0x20000
#define GPT0C1_IDR_TIOAS 0x20000
#define GPT0C1_IDR_TIOAS_BIT 17
#define GPT0C1_IDR_TCLKS_MASK 0x40000
#define GPT0C1_IDR_TCLKS 0x40000
#define GPT0C1_IDR_TCLKS_BIT 18

#define GPT0C1_IDR_WFM (*(volatile unsigned long *)0xFFFC8178)
#define GPT0C1_IDR_WFM_OFFSET 0x178
#define GPT0C1_IDR_WFM_COVFS_MASK 0x1
#define GPT0C1_IDR_WFM_COVFS 0x1
#define GPT0C1_IDR_WFM_COVFS_BIT 0
#define GPT0C1_IDR_WFM_CPAS_MASK 0x4
#define GPT0C1_IDR_WFM_CPAS 0x4
#define GPT0C1_IDR_WFM_CPAS_BIT 2
#define GPT0C1_IDR_WFM_CPBS_MASK 0x8
#define GPT0C1_IDR_WFM_CPBS 0x8
#define GPT0C1_IDR_WFM_CPBS_BIT 3
#define GPT0C1_IDR_WFM_CPCS_MASK 0x10
#define GPT0C1_IDR_WFM_CPCS 0x10
#define GPT0C1_IDR_WFM_CPCS_BIT 4
#define GPT0C1_IDR_WFM_ETRGS_MASK 0x80
#define GPT0C1_IDR_WFM_ETRGS 0x80
#define GPT0C1_IDR_WFM_ETRGS_BIT 7
#define GPT0C1_IDR_WFM_TIOBS_MASK 0x10000
#define GPT0C1_IDR_WFM_TIOBS 0x10000
#define GPT0C1_IDR_WFM_TIOBS_BIT 16
#define GPT0C1_IDR_WFM_TIOAS_MASK 0x20000
#define GPT0C1_IDR_WFM_TIOAS 0x20000
#define GPT0C1_IDR_WFM_TIOAS_BIT 17
#define GPT0C1_IDR_WFM_TCLKS_MASK 0x40000
#define GPT0C1_IDR_WFM_TCLKS 0x40000
#define GPT0C1_IDR_WFM_TCLKS_BIT 18

#define GPT0C1_IMR (*(volatile unsigned long *)0xFFFC817C)
#define GPT0C1_IMR_OFFSET 0x17C
#define GPT0C1_IMR_COVFS_MASK 0x1
#define GPT0C1_IMR_COVFS 0x1
#define GPT0C1_IMR_COVFS_BIT 0
#define GPT0C1_IMR_LOVRS_MASK 0x2
#define GPT0C1_IMR_LOVRS 0x2
#define GPT0C1_IMR_LOVRS_BIT 1
#define GPT0C1_IMR_CPCS_MASK 0x10
#define GPT0C1_IMR_CPCS 0x10
#define GPT0C1_IMR_CPCS_BIT 4
#define GPT0C1_IMR_LDRAS_MASK 0x20
#define GPT0C1_IMR_LDRAS 0x20
#define GPT0C1_IMR_LDRAS_BIT 5
#define GPT0C1_IMR_LDRBS_MASK 0x40
#define GPT0C1_IMR_LDRBS 0x40
#define GPT0C1_IMR_LDRBS_BIT 6
#define GPT0C1_IMR_ETRGS_MASK 0x80
#define GPT0C1_IMR_ETRGS 0x80
#define GPT0C1_IMR_ETRGS_BIT 7
#define GPT0C1_IMR_TIOBS_MASK 0x10000
#define GPT0C1_IMR_TIOBS 0x10000
#define GPT0C1_IMR_TIOBS_BIT 16
#define GPT0C1_IMR_TIOAS_MASK 0x20000
#define GPT0C1_IMR_TIOAS 0x20000
#define GPT0C1_IMR_TIOAS_BIT 17
#define GPT0C1_IMR_TCLKS_MASK 0x40000
#define GPT0C1_IMR_TCLKS 0x40000
#define GPT0C1_IMR_TCLKS_BIT 18

#define GPT0C1_IMR_WFM (*(volatile unsigned long *)0xFFFC817C)
#define GPT0C1_IMR_WFM_OFFSET 0x17C
#define GPT0C1_IMR_WFM_COVFS_MASK 0x1
#define GPT0C1_IMR_WFM_COVFS 0x1
#define GPT0C1_IMR_WFM_COVFS_BIT 0
#define GPT0C1_IMR_WFM_CPAS_MASK 0x4
#define GPT0C1_IMR_WFM_CPAS 0x4
#define GPT0C1_IMR_WFM_CPAS_BIT 2
#define GPT0C1_IMR_WFM_CPBS_MASK 0x8
#define GPT0C1_IMR_WFM_CPBS 0x8
#define GPT0C1_IMR_WFM_CPBS_BIT 3
#define GPT0C1_IMR_WFM_CPCS_MASK 0x10
#define GPT0C1_IMR_WFM_CPCS 0x10
#define GPT0C1_IMR_WFM_CPCS_BIT 4
#define GPT0C1_IMR_WFM_ETRGS_MASK 0x80
#define GPT0C1_IMR_WFM_ETRGS 0x80
#define GPT0C1_IMR_WFM_ETRGS_BIT 7
#define GPT0C1_IMR_WFM_TIOBS_MASK 0x10000
#define GPT0C1_IMR_WFM_TIOBS 0x10000
#define GPT0C1_IMR_WFM_TIOBS_BIT 16
#define GPT0C1_IMR_WFM_TIOAS_MASK 0x20000
#define GPT0C1_IMR_WFM_TIOAS 0x20000
#define GPT0C1_IMR_WFM_TIOAS_BIT 17
#define GPT0C1_IMR_WFM_TCLKS_MASK 0x40000
#define GPT0C1_IMR_WFM_TCLKS 0x40000
#define GPT0C1_IMR_WFM_TCLKS_BIT 18

#define GPT0C1_CV (*(volatile unsigned long *)0xFFFC8180)
#define GPT0C1_CV_OFFSET 0x180
#define GPT0C1_CV_CV_MASK 0xFFFF
#define GPT0C1_CV_CV_BIT 0

#define GPT0C1_RA (*(volatile unsigned long *)0xFFFC8184)
#define GPT0C1_RA_OFFSET 0x184
#define GPT0C1_RA_RA_MASK 0xFFFF
#define GPT0C1_RA_RA_BIT 0

#define GPT0C1_RB (*(volatile unsigned long *)0xFFFC8188)
#define GPT0C1_RB_OFFSET 0x188
#define GPT0C1_RB_RB_MASK 0xFFFF
#define GPT0C1_RB_RB_BIT 0

#define GPT0C1_RC (*(volatile unsigned long *)0xFFFC818C)
#define GPT0C1_RC_OFFSET 0x18C
#define GPT0C1_RC_RC_MASK 0xFFFF
#define GPT0C1_RC_RC_BIT 0

#define GPT0C2_PER (*(volatile unsigned long *)0xFFFC8200)
#define GPT0C2_PER_OFFSET 0x200
#define GPT0C2_PER_TIOB_MASK 0x10000
#define GPT0C2_PER_TIOB 0x10000
#define GPT0C2_PER_TIOB_BIT 16
#define GPT0C2_PER_TIOA_MASK 0x20000
#define GPT0C2_PER_TIOA 0x20000
#define GPT0C2_PER_TIOA_BIT 17
#define GPT0C2_PER_TCLK_MASK 0x40000
#define GPT0C2_PER_TCLK 0x40000
#define GPT0C2_PER_TCLK_BIT 18

#define GPT0C2_PDR (*(volatile unsigned long *)0xFFFC8204)
#define GPT0C2_PDR_OFFSET 0x204
#define GPT0C2_PDR_TIOB_MASK 0x10000
#define GPT0C2_PDR_TIOB 0x10000
#define GPT0C2_PDR_TIOB_BIT 16
#define GPT0C2_PDR_TIOA_MASK 0x20000
#define GPT0C2_PDR_TIOA 0x20000
#define GPT0C2_PDR_TIOA_BIT 17
#define GPT0C2_PDR_TCLK_MASK 0x40000
#define GPT0C2_PDR_TCLK 0x40000
#define GPT0C2_PDR_TCLK_BIT 18

#define GPT0C2_PSR (*(volatile unsigned long *)0xFFFC8208)
#define GPT0C2_PSR_OFFSET 0x208
#define GPT0C2_PSR_TIOB_MASK 0x10000
#define GPT0C2_PSR_TIOB 0x10000
#define GPT0C2_PSR_TIOB_BIT 16
#define GPT0C2_PSR_TIOA_MASK 0x20000
#define GPT0C2_PSR_TIOA 0x20000
#define GPT0C2_PSR_TIOA_BIT 17
#define GPT0C2_PSR_TCLK_MASK 0x40000
#define GPT0C2_PSR_TCLK 0x40000
#define GPT0C2_PSR_TCLK_BIT 18

#define GPT0C2_OER (*(volatile unsigned long *)0xFFFC8210)
#define GPT0C2_OER_OFFSET 0x210
#define GPT0C2_OER_TIOB_MASK 0x10000
#define GPT0C2_OER_TIOB 0x10000
#define GPT0C2_OER_TIOB_BIT 16
#define GPT0C2_OER_TIOA_MASK 0x20000
#define GPT0C2_OER_TIOA 0x20000
#define GPT0C2_OER_TIOA_BIT 17
#define GPT0C2_OER_TCLK_MASK 0x40000
#define GPT0C2_OER_TCLK 0x40000
#define GPT0C2_OER_TCLK_BIT 18

#define GPT0C2_ODR (*(volatile unsigned long *)0xFFFC8214)
#define GPT0C2_ODR_OFFSET 0x214
#define GPT0C2_ODR_TIOB_MASK 0x10000
#define GPT0C2_ODR_TIOB 0x10000
#define GPT0C2_ODR_TIOB_BIT 16
#define GPT0C2_ODR_TIOA_MASK 0x20000
#define GPT0C2_ODR_TIOA 0x20000
#define GPT0C2_ODR_TIOA_BIT 17
#define GPT0C2_ODR_TCLK_MASK 0x40000
#define GPT0C2_ODR_TCLK 0x40000
#define GPT0C2_ODR_TCLK_BIT 18

#define GPT0C2_OSR (*(volatile unsigned long *)0xFFFC8218)
#define GPT0C2_OSR_OFFSET 0x218
#define GPT0C2_OSR_TIOB_MASK 0x10000
#define GPT0C2_OSR_TIOB 0x10000
#define GPT0C2_OSR_TIOB_BIT 16
#define GPT0C2_OSR_TIOA_MASK 0x20000
#define GPT0C2_OSR_TIOA 0x20000
#define GPT0C2_OSR_TIOA_BIT 17
#define GPT0C2_OSR_TCLK_MASK 0x40000
#define GPT0C2_OSR_TCLK 0x40000
#define GPT0C2_OSR_TCLK_BIT 18

#define GPT0C2_SODR (*(volatile unsigned long *)0xFFFC8230)
#define GPT0C2_SODR_OFFSET 0x230
#define GPT0C2_SODR_TIOB_MASK 0x10000
#define GPT0C2_SODR_TIOB 0x10000
#define GPT0C2_SODR_TIOB_BIT 16
#define GPT0C2_SODR_TIOA_MASK 0x20000
#define GPT0C2_SODR_TIOA 0x20000
#define GPT0C2_SODR_TIOA_BIT 17
#define GPT0C2_SODR_TCLK_MASK 0x40000
#define GPT0C2_SODR_TCLK 0x40000
#define GPT0C2_SODR_TCLK_BIT 18

#define GPT0C2_CODR (*(volatile unsigned long *)0xFFFC8234)
#define GPT0C2_CODR_OFFSET 0x234
#define GPT0C2_CODR_TIOB_MASK 0x10000
#define GPT0C2_CODR_TIOB 0x10000
#define GPT0C2_CODR_TIOB_BIT 16
#define GPT0C2_CODR_TIOA_MASK 0x20000
#define GPT0C2_CODR_TIOA 0x20000
#define GPT0C2_CODR_TIOA_BIT 17
#define GPT0C2_CODR_TCLK_MASK 0x40000
#define GPT0C2_CODR_TCLK 0x40000
#define GPT0C2_CODR_TCLK_BIT 18

#define GPT0C2_ODSR (*(volatile unsigned long *)0xFFFC8238)
#define GPT0C2_ODSR_OFFSET 0x238
#define GPT0C2_ODSR_TIOB_MASK 0x10000
#define GPT0C2_ODSR_TIOB 0x10000
#define GPT0C2_ODSR_TIOB_BIT 16
#define GPT0C2_ODSR_TIOA_MASK 0x20000
#define GPT0C2_ODSR_TIOA 0x20000
#define GPT0C2_ODSR_TIOA_BIT 17
#define GPT0C2_ODSR_TCLK_MASK 0x40000
#define GPT0C2_ODSR_TCLK 0x40000
#define GPT0C2_ODSR_TCLK_BIT 18

#define GPT0C2_PDSR (*(volatile unsigned long *)0xFFFC823C)
#define GPT0C2_PDSR_OFFSET 0x23C
#define GPT0C2_PDSR_TIOB_MASK 0x10000
#define GPT0C2_PDSR_TIOB 0x10000
#define GPT0C2_PDSR_TIOB_BIT 16
#define GPT0C2_PDSR_TIOA_MASK 0x20000
#define GPT0C2_PDSR_TIOA 0x20000
#define GPT0C2_PDSR_TIOA_BIT 17
#define GPT0C2_PDSR_TCLK_MASK 0x40000
#define GPT0C2_PDSR_TCLK 0x40000
#define GPT0C2_PDSR_TCLK_BIT 18

#define GPT0C2_MDER (*(volatile unsigned long *)0xFFFC8240)
#define GPT0C2_MDER_OFFSET 0x240
#define GPT0C2_MDER_TIOB_MASK 0x10000
#define GPT0C2_MDER_TIOB 0x10000
#define GPT0C2_MDER_TIOB_BIT 16
#define GPT0C2_MDER_TIOA_MASK 0x20000
#define GPT0C2_MDER_TIOA 0x20000
#define GPT0C2_MDER_TIOA_BIT 17
#define GPT0C2_MDER_TCLK_MASK 0x40000
#define GPT0C2_MDER_TCLK 0x40000
#define GPT0C2_MDER_TCLK_BIT 18

#define GPT0C2_MDDR (*(volatile unsigned long *)0xFFFC8244)
#define GPT0C2_MDDR_OFFSET 0x244
#define GPT0C2_MDDR_TIOB_MASK 0x10000
#define GPT0C2_MDDR_TIOB 0x10000
#define GPT0C2_MDDR_TIOB_BIT 16
#define GPT0C2_MDDR_TIOA_MASK 0x20000
#define GPT0C2_MDDR_TIOA 0x20000
#define GPT0C2_MDDR_TIOA_BIT 17
#define GPT0C2_MDDR_TCLK_MASK 0x40000
#define GPT0C2_MDDR_TCLK 0x40000
#define GPT0C2_MDDR_TCLK_BIT 18

#define GPT0C2_MDSR (*(volatile unsigned long *)0xFFFC8248)
#define GPT0C2_MDSR_OFFSET 0x248
#define GPT0C2_MDSR_TIOB_MASK 0x10000
#define GPT0C2_MDSR_TIOB 0x10000
#define GPT0C2_MDSR_TIOB_BIT 16
#define GPT0C2_MDSR_TIOA_MASK 0x20000
#define GPT0C2_MDSR_TIOA 0x20000
#define GPT0C2_MDSR_TIOA_BIT 17
#define GPT0C2_MDSR_TCLK_MASK 0x40000
#define GPT0C2_MDSR_TCLK 0x40000
#define GPT0C2_MDSR_TCLK_BIT 18

#define GPT0C2_ECR (*(volatile unsigned long *)0xFFFC8250)
#define GPT0C2_ECR_OFFSET 0x250
#define GPT0C2_ECR_PIO_MASK 0x1
#define GPT0C2_ECR_PIO 0x1
#define GPT0C2_ECR_PIO_BIT 0
#define GPT0C2_ECR_GPT_MASK 0x2
#define GPT0C2_ECR_GPT 0x2
#define GPT0C2_ECR_GPT_BIT 1

#define GPT0C2_DCR (*(volatile unsigned long *)0xFFFC8254)
#define GPT0C2_DCR_OFFSET 0x254
#define GPT0C2_DCR_PIO_MASK 0x1
#define GPT0C2_DCR_PIO 0x1
#define GPT0C2_DCR_PIO_BIT 0
#define GPT0C2_DCR_GPT_MASK 0x2
#define GPT0C2_DCR_GPT 0x2
#define GPT0C2_DCR_GPT_BIT 1

#define GPT0C2_PMSR (*(volatile unsigned long *)0xFFFC8258)
#define GPT0C2_PMSR_OFFSET 0x258
#define GPT0C2_PMSR_PIO_MASK 0x1
#define GPT0C2_PMSR_PIO 0x1
#define GPT0C2_PMSR_PIO_BIT 0
#define GPT0C2_PMSR_GPT_MASK 0x2
#define GPT0C2_PMSR_GPT 0x2
#define GPT0C2_PMSR_GPT_BIT 1

#define GPT0C2_CR (*(volatile unsigned long *)0xFFFC8260)
#define GPT0C2_CR_OFFSET 0x260
#define GPT0C2_CR_SWRST_MASK 0x1
#define GPT0C2_CR_SWRST 0x1
#define GPT0C2_CR_SWRST_BIT 0
#define GPT0C2_CR_CLKEN_MASK 0x2
#define GPT0C2_CR_CLKEN 0x2
#define GPT0C2_CR_CLKEN_BIT 1
#define GPT0C2_CR_CLKDIS_MASK 0x4
#define GPT0C2_CR_CLKDIS 0x4
#define GPT0C2_CR_CLKDIS_BIT 2
#define GPT0C2_CR_SWTRG_MASK 0x8
#define GPT0C2_CR_SWTRG 0x8
#define GPT0C2_CR_SWTRG_BIT 3

#define GPT0C2_MR (*(volatile unsigned long *)0xFFFC8264)
#define GPT0C2_MR_OFFSET 0x264
#define GPT0C2_MR_CLKS_MASK 0x7
#define GPT0C2_MR_CLKS_BIT 0
#define GPT0C2_MR_CLKI_MASK 0x8
#define GPT0C2_MR_CLKI 0x8
#define GPT0C2_MR_CLKI_BIT 3
#define GPT0C2_MR_BURST_MASK 0x30
#define GPT0C2_MR_BURST_BIT 4
#define GPT0C2_MR_LDBSTOP_MASK 0x40
#define GPT0C2_MR_LDBSTOP 0x40
#define GPT0C2_MR_LDBSTOP_BIT 6
#define GPT0C2_MR_LDBIS_MASK 0x80
#define GPT0C2_MR_LDBIS 0x80
#define GPT0C2_MR_LDBIS_BIT 7
#define GPT0C2_MR_ETRGEDG_MASK 0x300
#define GPT0C2_MR_ETRGEDG_BIT 8
#define GPT0C2_MR_ABETRG_MASK 0x400
#define GPT0C2_MR_ABETRG 0x400
#define GPT0C2_MR_ABETRG_BIT 10
#define GPT0C2_MR_CPCTRG_MASK 0x4000
#define GPT0C2_MR_CPCTRG 0x4000
#define GPT0C2_MR_CPCTRG_BIT 14
#define GPT0C2_MR_WAVE_MASK 0x8000
#define GPT0C2_MR_WAVE 0x8000
#define GPT0C2_MR_WAVE_BIT 15
#define GPT0C2_MR_LDRA_MASK 0x30000
#define GPT0C2_MR_LDRA_BIT 16
#define GPT0C2_MR_LDRB_MASK 0xC0000
#define GPT0C2_MR_LDRB_BIT 18

#define GPT0C2_MR_WFM (*(volatile unsigned long *)0xFFFC8264)
#define GPT0C2_MR_WFM_OFFSET 0x264
#define GPT0C2_MR_WFM_CLKS_MASK 0x7
#define GPT0C2_MR_WFM_CLKS_BIT 0
#define GPT0C2_MR_WFM_CLKI_MASK 0x8
#define GPT0C2_MR_WFM_CLKI 0x8
#define GPT0C2_MR_WFM_CLKI_BIT 3
#define GPT0C2_MR_WFM_BURST_MASK 0x30
#define GPT0C2_MR_WFM_BURST_BIT 4
#define GPT0C2_MR_WFM_CPCSTOP_MASK 0x40
#define GPT0C2_MR_WFM_CPCSTOP 0x40
#define GPT0C2_MR_WFM_CPCSTOP_BIT 6
#define GPT0C2_MR_WFM_CPCDIS_MASK 0x80
#define GPT0C2_MR_WFM_CPCDIS 0x80
#define GPT0C2_MR_WFM_CPCDIS_BIT 7
#define GPT0C2_MR_WFM_EEVTEDG_MASK 0x300
#define GPT0C2_MR_WFM_EEVTEDG_BIT 8
#define GPT0C2_MR_WFM_EEVT_MASK 0xC00
#define GPT0C2_MR_WFM_EEVT_BIT 10
#define GPT0C2_MR_WFM_ENETRG_MASK 0x1000
#define GPT0C2_MR_WFM_ENETRG 0x1000
#define GPT0C2_MR_WFM_ENETRG_BIT 12
#define GPT0C2_MR_WFM_CPCTRG_MASK 0x4000
#define GPT0C2_MR_WFM_CPCTRG 0x4000
#define GPT0C2_MR_WFM_CPCTRG_BIT 14
#define GPT0C2_MR_WFM_WAVE_MASK 0x18000
#define GPT0C2_MR_WFM_WAVE_BIT 15
#define GPT0C2_MR_WFM_ACPA_MASK 0x30000
#define GPT0C2_MR_WFM_ACPA_BIT 16
#define GPT0C2_MR_WFM_ACPC_MASK 0xC0000
#define GPT0C2_MR_WFM_ACPC_BIT 18
#define GPT0C2_MR_WFM_AEEVT_MASK 0x300000
#define GPT0C2_MR_WFM_AEEVT_BIT 20
#define GPT0C2_MR_WFM_ASWTRG_MASK 0xC00000
#define GPT0C2_MR_WFM_ASWTRG_BIT 22
#define GPT0C2_MR_WFM_BCPB_MASK 0x3000000
#define GPT0C2_MR_WFM_BCPB_BIT 24
#define GPT0C2_MR_WFM_BCPC_MASK 0xC000000
#define GPT0C2_MR_WFM_BCPC_BIT 26
#define GPT0C2_MR_WFM_BEEVT_MASK 0x30000000
#define GPT0C2_MR_WFM_BEEVT_BIT 28
#define GPT0C2_MR_WFM_BSWTRG_MASK 0xC0000000
#define GPT0C2_MR_WFM_BSWTRG_BIT 30

#define GPT0C2_SR (*(volatile unsigned long *)0xFFFC8270)
#define GPT0C2_SR_OFFSET 0x270
#define GPT0C2_SR_COVFS_MASK 0x1
#define GPT0C2_SR_COVFS 0x1
#define GPT0C2_SR_COVFS_BIT 0
#define GPT0C2_SR_LOVRS_MASK 0x2
#define GPT0C2_SR_LOVRS 0x2
#define GPT0C2_SR_LOVRS_BIT 1
#define GPT0C2_SR_CPCS_MASK 0x10
#define GPT0C2_SR_CPCS 0x10
#define GPT0C2_SR_CPCS_BIT 4
#define GPT0C2_SR_LDRAS_MASK 0x20
#define GPT0C2_SR_LDRAS 0x20
#define GPT0C2_SR_LDRAS_BIT 5
#define GPT0C2_SR_LDRBS_MASK 0x40
#define GPT0C2_SR_LDRBS 0x40
#define GPT0C2_SR_LDRBS_BIT 6
#define GPT0C2_SR_ETRGS_MASK 0x80
#define GPT0C2_SR_ETRGS 0x80
#define GPT0C2_SR_ETRGS_BIT 7
#define GPT0C2_SR_CLKSTA_MASK 0x100
#define GPT0C2_SR_CLKSTA 0x100
#define GPT0C2_SR_CLKSTA_BIT 8
#define GPT0C2_SR_MTIOA_MASK 0x200
#define GPT0C2_SR_MTIOA 0x200
#define GPT0C2_SR_MTIOA_BIT 9
#define GPT0C2_SR_MTIOB_MASK 0x400
#define GPT0C2_SR_MTIOB 0x400
#define GPT0C2_SR_MTIOB_BIT 10
#define GPT0C2_SR_TIOBS_MASK 0x10000
#define GPT0C2_SR_TIOBS 0x10000
#define GPT0C2_SR_TIOBS_BIT 16
#define GPT0C2_SR_TIOAS_MASK 0x20000
#define GPT0C2_SR_TIOAS 0x20000
#define GPT0C2_SR_TIOAS_BIT 17
#define GPT0C2_SR_TCLKS_MASK 0x40000
#define GPT0C2_SR_TCLKS 0x40000
#define GPT0C2_SR_TCLKS_BIT 18

#define GPT0C2_SR_WFM (*(volatile unsigned long *)0xFFFC8270)
#define GPT0C2_SR_WFM_OFFSET 0x270
#define GPT0C2_SR_WFM_COVFS_MASK 0x1
#define GPT0C2_SR_WFM_COVFS 0x1
#define GPT0C2_SR_WFM_COVFS_BIT 0
#define GPT0C2_SR_WFM_CPAS_MASK 0x4
#define GPT0C2_SR_WFM_CPAS 0x4
#define GPT0C2_SR_WFM_CPAS_BIT 2
#define GPT0C2_SR_WFM_CPBS_MASK 0x8
#define GPT0C2_SR_WFM_CPBS 0x8
#define GPT0C2_SR_WFM_CPBS_BIT 3
#define GPT0C2_SR_WFM_CPCS_MASK 0x10
#define GPT0C2_SR_WFM_CPCS 0x10
#define GPT0C2_SR_WFM_CPCS_BIT 4
#define GPT0C2_SR_WFM_ETRGS_MASK 0x80
#define GPT0C2_SR_WFM_ETRGS 0x80
#define GPT0C2_SR_WFM_ETRGS_BIT 7
#define GPT0C2_SR_WFM_CLKSTA_MASK 0x100
#define GPT0C2_SR_WFM_CLKSTA 0x100
#define GPT0C2_SR_WFM_CLKSTA_BIT 8
#define GPT0C2_SR_WFM_MTIOA_MASK 0x200
#define GPT0C2_SR_WFM_MTIOA 0x200
#define GPT0C2_SR_WFM_MTIOA_BIT 9
#define GPT0C2_SR_WFM_MTIOB_MASK 0x400
#define GPT0C2_SR_WFM_MTIOB 0x400
#define GPT0C2_SR_WFM_MTIOB_BIT 10
#define GPT0C2_SR_WFM_TIOBS_MASK 0x10000
#define GPT0C2_SR_WFM_TIOBS 0x10000
#define GPT0C2_SR_WFM_TIOBS_BIT 16
#define GPT0C2_SR_WFM_TIOAS_MASK 0x20000
#define GPT0C2_SR_WFM_TIOAS 0x20000
#define GPT0C2_SR_WFM_TIOAS_BIT 17
#define GPT0C2_SR_WFM_TCLKS_MASK 0x40000
#define GPT0C2_SR_WFM_TCLKS 0x40000
#define GPT0C2_SR_WFM_TCLKS_BIT 18

#define GPT0C2_IER (*(volatile unsigned long *)0xFFFC8274)
#define GPT0C2_IER_OFFSET 0x274
#define GPT0C2_IER_COVFS_MASK 0x1
#define GPT0C2_IER_COVFS 0x1
#define GPT0C2_IER_COVFS_BIT 0
#define GPT0C2_IER_LOVRS_MASK 0x2
#define GPT0C2_IER_LOVRS 0x2
#define GPT0C2_IER_LOVRS_BIT 1
#define GPT0C2_IER_CPCS_MASK 0x10
#define GPT0C2_IER_CPCS 0x10
#define GPT0C2_IER_CPCS_BIT 4
#define GPT0C2_IER_LDRAS_MASK 0x20
#define GPT0C2_IER_LDRAS 0x20
#define GPT0C2_IER_LDRAS_BIT 5
#define GPT0C2_IER_LDRBS_MASK 0x40
#define GPT0C2_IER_LDRBS 0x40
#define GPT0C2_IER_LDRBS_BIT 6
#define GPT0C2_IER_ETRGS_MASK 0x80
#define GPT0C2_IER_ETRGS 0x80
#define GPT0C2_IER_ETRGS_BIT 7
#define GPT0C2_IER_TIOBS_MASK 0x10000
#define GPT0C2_IER_TIOBS 0x10000
#define GPT0C2_IER_TIOBS_BIT 16
#define GPT0C2_IER_TIOAS_MASK 0x20000
#define GPT0C2_IER_TIOAS 0x20000
#define GPT0C2_IER_TIOAS_BIT 17
#define GPT0C2_IER_TCLKS_MASK 0x40000
#define GPT0C2_IER_TCLKS 0x40000
#define GPT0C2_IER_TCLKS_BIT 18

#define GPT0C2_IER_WFM (*(volatile unsigned long *)0xFFFC8274)
#define GPT0C2_IER_WFM_OFFSET 0x274
#define GPT0C2_IER_WFM_COVFS_MASK 0x1
#define GPT0C2_IER_WFM_COVFS 0x1
#define GPT0C2_IER_WFM_COVFS_BIT 0
#define GPT0C2_IER_WFM_CPAS_MASK 0x4
#define GPT0C2_IER_WFM_CPAS 0x4
#define GPT0C2_IER_WFM_CPAS_BIT 2
#define GPT0C2_IER_WFM_CPBS_MASK 0x8
#define GPT0C2_IER_WFM_CPBS 0x8
#define GPT0C2_IER_WFM_CPBS_BIT 3
#define GPT0C2_IER_WFM_CPCS_MASK 0x10
#define GPT0C2_IER_WFM_CPCS 0x10
#define GPT0C2_IER_WFM_CPCS_BIT 4
#define GPT0C2_IER_WFM_ETRGS_MASK 0x80
#define GPT0C2_IER_WFM_ETRGS 0x80
#define GPT0C2_IER_WFM_ETRGS_BIT 7
#define GPT0C2_IER_WFM_TIOBS_MASK 0x10000
#define GPT0C2_IER_WFM_TIOBS 0x10000
#define GPT0C2_IER_WFM_TIOBS_BIT 16
#define GPT0C2_IER_WFM_TIOAS_MASK 0x20000
#define GPT0C2_IER_WFM_TIOAS 0x20000
#define GPT0C2_IER_WFM_TIOAS_BIT 17
#define GPT0C2_IER_WFM_TCLKS_MASK 0x40000
#define GPT0C2_IER_WFM_TCLKS 0x40000
#define GPT0C2_IER_WFM_TCLKS_BIT 18

#define GPT0C2_IDR (*(volatile unsigned long *)0xFFFC8278)
#define GPT0C2_IDR_OFFSET 0x278
#define GPT0C2_IDR_COVFS_MASK 0x1
#define GPT0C2_IDR_COVFS 0x1
#define GPT0C2_IDR_COVFS_BIT 0
#define GPT0C2_IDR_LOVRS_MASK 0x2
#define GPT0C2_IDR_LOVRS 0x2
#define GPT0C2_IDR_LOVRS_BIT 1
#define GPT0C2_IDR_CPCS_MASK 0x10
#define GPT0C2_IDR_CPCS 0x10
#define GPT0C2_IDR_CPCS_BIT 4
#define GPT0C2_IDR_LDRAS_MASK 0x20
#define GPT0C2_IDR_LDRAS 0x20
#define GPT0C2_IDR_LDRAS_BIT 5
#define GPT0C2_IDR_LDRBS_MASK 0x40
#define GPT0C2_IDR_LDRBS 0x40
#define GPT0C2_IDR_LDRBS_BIT 6
#define GPT0C2_IDR_ETRGS_MASK 0x80
#define GPT0C2_IDR_ETRGS 0x80
#define GPT0C2_IDR_ETRGS_BIT 7
#define GPT0C2_IDR_TIOBS_MASK 0x10000
#define GPT0C2_IDR_TIOBS 0x10000
#define GPT0C2_IDR_TIOBS_BIT 16
#define GPT0C2_IDR_TIOAS_MASK 0x20000
#define GPT0C2_IDR_TIOAS 0x20000
#define GPT0C2_IDR_TIOAS_BIT 17
#define GPT0C2_IDR_TCLKS_MASK 0x40000
#define GPT0C2_IDR_TCLKS 0x40000
#define GPT0C2_IDR_TCLKS_BIT 18

#define GPT0C2_IDR_WFM (*(volatile unsigned long *)0xFFFC8278)
#define GPT0C2_IDR_WFM_OFFSET 0x278
#define GPT0C2_IDR_WFM_COVFS_MASK 0x1
#define GPT0C2_IDR_WFM_COVFS 0x1
#define GPT0C2_IDR_WFM_COVFS_BIT 0
#define GPT0C2_IDR_WFM_CPAS_MASK 0x4
#define GPT0C2_IDR_WFM_CPAS 0x4
#define GPT0C2_IDR_WFM_CPAS_BIT 2
#define GPT0C2_IDR_WFM_CPBS_MASK 0x8
#define GPT0C2_IDR_WFM_CPBS 0x8
#define GPT0C2_IDR_WFM_CPBS_BIT 3
#define GPT0C2_IDR_WFM_CPCS_MASK 0x10
#define GPT0C2_IDR_WFM_CPCS 0x10
#define GPT0C2_IDR_WFM_CPCS_BIT 4
#define GPT0C2_IDR_WFM_ETRGS_MASK 0x80
#define GPT0C2_IDR_WFM_ETRGS 0x80
#define GPT0C2_IDR_WFM_ETRGS_BIT 7
#define GPT0C2_IDR_WFM_TIOBS_MASK 0x10000
#define GPT0C2_IDR_WFM_TIOBS 0x10000
#define GPT0C2_IDR_WFM_TIOBS_BIT 16
#define GPT0C2_IDR_WFM_TIOAS_MASK 0x20000
#define GPT0C2_IDR_WFM_TIOAS 0x20000
#define GPT0C2_IDR_WFM_TIOAS_BIT 17
#define GPT0C2_IDR_WFM_TCLKS_MASK 0x40000
#define GPT0C2_IDR_WFM_TCLKS 0x40000
#define GPT0C2_IDR_WFM_TCLKS_BIT 18

#define GPT0C2_IMR (*(volatile unsigned long *)0xFFFC827C)
#define GPT0C2_IMR_OFFSET 0x27C
#define GPT0C2_IMR_COVFS_MASK 0x1
#define GPT0C2_IMR_COVFS 0x1
#define GPT0C2_IMR_COVFS_BIT 0
#define GPT0C2_IMR_LOVRS_MASK 0x2
#define GPT0C2_IMR_LOVRS 0x2
#define GPT0C2_IMR_LOVRS_BIT 1
#define GPT0C2_IMR_CPCS_MASK 0x10
#define GPT0C2_IMR_CPCS 0x10
#define GPT0C2_IMR_CPCS_BIT 4
#define GPT0C2_IMR_LDRAS_MASK 0x20
#define GPT0C2_IMR_LDRAS 0x20
#define GPT0C2_IMR_LDRAS_BIT 5
#define GPT0C2_IMR_LDRBS_MASK 0x40
#define GPT0C2_IMR_LDRBS 0x40
#define GPT0C2_IMR_LDRBS_BIT 6
#define GPT0C2_IMR_ETRGS_MASK 0x80
#define GPT0C2_IMR_ETRGS 0x80
#define GPT0C2_IMR_ETRGS_BIT 7
#define GPT0C2_IMR_TIOBS_MASK 0x10000
#define GPT0C2_IMR_TIOBS 0x10000
#define GPT0C2_IMR_TIOBS_BIT 16
#define GPT0C2_IMR_TIOAS_MASK 0x20000
#define GPT0C2_IMR_TIOAS 0x20000
#define GPT0C2_IMR_TIOAS_BIT 17
#define GPT0C2_IMR_TCLKS_MASK 0x40000
#define GPT0C2_IMR_TCLKS 0x40000
#define GPT0C2_IMR_TCLKS_BIT 18

#define GPT0C2_IMR_WFM (*(volatile unsigned long *)0xFFFC827C)
#define GPT0C2_IMR_WFM_OFFSET 0x27C
#define GPT0C2_IMR_WFM_COVFS_MASK 0x1
#define GPT0C2_IMR_WFM_COVFS 0x1
#define GPT0C2_IMR_WFM_COVFS_BIT 0
#define GPT0C2_IMR_WFM_CPAS_MASK 0x4
#define GPT0C2_IMR_WFM_CPAS 0x4
#define GPT0C2_IMR_WFM_CPAS_BIT 2
#define GPT0C2_IMR_WFM_CPBS_MASK 0x8
#define GPT0C2_IMR_WFM_CPBS 0x8
#define GPT0C2_IMR_WFM_CPBS_BIT 3
#define GPT0C2_IMR_WFM_CPCS_MASK 0x10
#define GPT0C2_IMR_WFM_CPCS 0x10
#define GPT0C2_IMR_WFM_CPCS_BIT 4
#define GPT0C2_IMR_WFM_ETRGS_MASK 0x80
#define GPT0C2_IMR_WFM_ETRGS 0x80
#define GPT0C2_IMR_WFM_ETRGS_BIT 7
#define GPT0C2_IMR_WFM_TIOBS_MASK 0x10000
#define GPT0C2_IMR_WFM_TIOBS 0x10000
#define GPT0C2_IMR_WFM_TIOBS_BIT 16
#define GPT0C2_IMR_WFM_TIOAS_MASK 0x20000
#define GPT0C2_IMR_WFM_TIOAS 0x20000
#define GPT0C2_IMR_WFM_TIOAS_BIT 17
#define GPT0C2_IMR_WFM_TCLKS_MASK 0x40000
#define GPT0C2_IMR_WFM_TCLKS 0x40000
#define GPT0C2_IMR_WFM_TCLKS_BIT 18

#define GPT0C2_CV (*(volatile unsigned long *)0xFFFC8280)
#define GPT0C2_CV_OFFSET 0x280
#define GPT0C2_CV_CV_MASK 0xFFFF
#define GPT0C2_CV_CV_BIT 0

#define GPT0C2_RA (*(volatile unsigned long *)0xFFFC8284)
#define GPT0C2_RA_OFFSET 0x284
#define GPT0C2_RA_RA_MASK 0xFFFF
#define GPT0C2_RA_RA_BIT 0

#define GPT0C2_RB (*(volatile unsigned long *)0xFFFC8288)
#define GPT0C2_RB_OFFSET 0x288
#define GPT0C2_RB_RB_MASK 0xFFFF
#define GPT0C2_RB_RB_BIT 0

#define GPT0C2_RC (*(volatile unsigned long *)0xFFFC828C)
#define GPT0C2_RC_OFFSET 0x28C
#define GPT0C2_RC_RC_MASK 0xFFFF
#define GPT0C2_RC_RC_BIT 0

#define GPT0_BCR (*(volatile unsigned long *)0xFFFC8300)
#define GPT0_BCR_OFFSET 0x300
#define GPT0_BCR_SWRST_MASK 0x1
#define GPT0_BCR_SWRST 0x1
#define GPT0_BCR_SWRST_BIT 0
#define GPT0_BCR_TCSYNC_MASK 0x2
#define GPT0_BCR_TCSYNC 0x2
#define GPT0_BCR_TCSYNC_BIT 1

#define GPT0_BMR (*(volatile unsigned long *)0xFFFC8304)
#define GPT0_BMR_OFFSET 0x304
#define GPT0_BMR_TC0XC0S_MASK 0x3
#define GPT0_BMR_TC0XC0S_BIT 0
#define GPT0_BMR_TC1XC1S_MASK 0xC
#define GPT0_BMR_TC1XC1S_BIT 2
#define GPT0_BMR_TC2XC2S_MASK 0x30
#define GPT0_BMR_TC2XC2S_BIT 4

#define GPT0_TSTC (*(volatile unsigned long *)0xFFFC8400)
#define GPT0_TSTC_OFFSET 0x400
#define GPT0_TSTC_LDCT0_MASK 0x1
#define GPT0_TSTC_LDCT0 0x1
#define GPT0_TSTC_LDCT0_BIT 0
#define GPT0_TSTC_LDCT1_MASK 0x2
#define GPT0_TSTC_LDCT1 0x2
#define GPT0_TSTC_LDCT1_BIT 1
#define GPT0_TSTC_LDCT2_MASK 0x4
#define GPT0_TSTC_LDCT2 0x4
#define GPT0_TSTC_LDCT2_BIT 2

#define GPT0_TSTM (*(volatile unsigned long *)0xFFFC8404)
#define GPT0_TSTM_OFFSET 0x404
#define GPT0_TSTM_OCLKEN0_MASK 0x1
#define GPT0_TSTM_OCLKEN0 0x1
#define GPT0_TSTM_OCLKEN0_BIT 0
#define GPT0_TSTM_OCLKEN1_MASK 0x2
#define GPT0_TSTM_OCLKEN1 0x2
#define GPT0_TSTM_OCLKEN1_BIT 1
#define GPT0_TSTM_OCLKEN2_MASK 0x4
#define GPT0_TSTM_OCLKEN2 0x4
#define GPT0_TSTM_OCLKEN2_BIT 2

#define PWM_BASE 0xFFFD0000

#define PWM_PER (*(volatile unsigned long *)0xFFFD0000)
#define PWM_PER_OFFSET 0x0
#define PWM_PER_PWM0_MASK 0x10000
#define PWM_PER_PWM0 0x10000
#define PWM_PER_PWM0_BIT 16
#define PWM_PER_PWM1_MASK 0x20000
#define PWM_PER_PWM1 0x20000
#define PWM_PER_PWM1_BIT 17
#define PWM_PER_PWM2_MASK 0x40000
#define PWM_PER_PWM2 0x40000
#define PWM_PER_PWM2_BIT 18
#define PWM_PER_PWM3_MASK 0x80000
#define PWM_PER_PWM3 0x80000
#define PWM_PER_PWM3_BIT 19

#define PWM_PDR (*(volatile unsigned long *)0xFFFD0004)
#define PWM_PDR_OFFSET 0x4
#define PWM_PDR_PWM0_MASK 0x10000
#define PWM_PDR_PWM0 0x10000
#define PWM_PDR_PWM0_BIT 16
#define PWM_PDR_PWM1_MASK 0x20000
#define PWM_PDR_PWM1 0x20000
#define PWM_PDR_PWM1_BIT 17
#define PWM_PDR_PWM2_MASK 0x40000
#define PWM_PDR_PWM2 0x40000
#define PWM_PDR_PWM2_BIT 18
#define PWM_PDR_PWM3_MASK 0x80000
#define PWM_PDR_PWM3 0x80000
#define PWM_PDR_PWM3_BIT 19

#define PWM_PSR (*(volatile unsigned long *)0xFFFD0008)
#define PWM_PSR_OFFSET 0x8
#define PWM_PSR_PWM0_MASK 0x10000
#define PWM_PSR_PWM0 0x10000
#define PWM_PSR_PWM0_BIT 16
#define PWM_PSR_PWM1_MASK 0x20000
#define PWM_PSR_PWM1 0x20000
#define PWM_PSR_PWM1_BIT 17
#define PWM_PSR_PWM2_MASK 0x40000
#define PWM_PSR_PWM2 0x40000
#define PWM_PSR_PWM2_BIT 18
#define PWM_PSR_PWM3_MASK 0x80000
#define PWM_PSR_PWM3 0x80000
#define PWM_PSR_PWM3_BIT 19

#define PWM_OER (*(volatile unsigned long *)0xFFFD0010)
#define PWM_OER_OFFSET 0x10
#define PWM_OER_PWM0_MASK 0x10000
#define PWM_OER_PWM0 0x10000
#define PWM_OER_PWM0_BIT 16
#define PWM_OER_PWM1_MASK 0x20000
#define PWM_OER_PWM1 0x20000
#define PWM_OER_PWM1_BIT 17
#define PWM_OER_PWM2_MASK 0x40000
#define PWM_OER_PWM2 0x40000
#define PWM_OER_PWM2_BIT 18
#define PWM_OER_PWM3_MASK 0x80000
#define PWM_OER_PWM3 0x80000
#define PWM_OER_PWM3_BIT 19

#define PWM_ODR (*(volatile unsigned long *)0xFFFD0014)
#define PWM_ODR_OFFSET 0x14
#define PWM_ODR_PWM0_MASK 0x10000
#define PWM_ODR_PWM0 0x10000
#define PWM_ODR_PWM0_BIT 16
#define PWM_ODR_PWM1_MASK 0x20000
#define PWM_ODR_PWM1 0x20000
#define PWM_ODR_PWM1_BIT 17
#define PWM_ODR_PWM2_MASK 0x40000
#define PWM_ODR_PWM2 0x40000
#define PWM_ODR_PWM2_BIT 18
#define PWM_ODR_PWM3_MASK 0x80000
#define PWM_ODR_PWM3 0x80000
#define PWM_ODR_PWM3_BIT 19

#define PWM_OSR (*(volatile unsigned long *)0xFFFD0018)
#define PWM_OSR_OFFSET 0x18
#define PWM_OSR_PWM0_MASK 0x10000
#define PWM_OSR_PWM0 0x10000
#define PWM_OSR_PWM0_BIT 16
#define PWM_OSR_PWM1_MASK 0x20000
#define PWM_OSR_PWM1 0x20000
#define PWM_OSR_PWM1_BIT 17
#define PWM_OSR_PWM2_MASK 0x40000
#define PWM_OSR_PWM2 0x40000
#define PWM_OSR_PWM2_BIT 18
#define PWM_OSR_PWM3_MASK 0x80000
#define PWM_OSR_PWM3 0x80000
#define PWM_OSR_PWM3_BIT 19

#define PWM_SODR (*(volatile unsigned long *)0xFFFD0030)
#define PWM_SODR_OFFSET 0x30
#define PWM_SODR_PWM0_MASK 0x10000
#define PWM_SODR_PWM0 0x10000
#define PWM_SODR_PWM0_BIT 16
#define PWM_SODR_PWM1_MASK 0x20000
#define PWM_SODR_PWM1 0x20000
#define PWM_SODR_PWM1_BIT 17
#define PWM_SODR_PWM2_MASK 0x40000
#define PWM_SODR_PWM2 0x40000
#define PWM_SODR_PWM2_BIT 18
#define PWM_SODR_PWM3_MASK 0x80000
#define PWM_SODR_PWM3 0x80000
#define PWM_SODR_PWM3_BIT 19

#define PWM_CODR (*(volatile unsigned long *)0xFFFD0034)
#define PWM_CODR_OFFSET 0x34
#define PWM_CODR_PWM0_MASK 0x10000
#define PWM_CODR_PWM0 0x10000
#define PWM_CODR_PWM0_BIT 16
#define PWM_CODR_PWM1_MASK 0x20000
#define PWM_CODR_PWM1 0x20000
#define PWM_CODR_PWM1_BIT 17
#define PWM_CODR_PWM2_MASK 0x40000
#define PWM_CODR_PWM2 0x40000
#define PWM_CODR_PWM2_BIT 18
#define PWM_CODR_PWM3_MASK 0x80000
#define PWM_CODR_PWM3 0x80000
#define PWM_CODR_PWM3_BIT 19

#define PWM_ODSR (*(volatile unsigned long *)0xFFFD0038)
#define PWM_ODSR_OFFSET 0x38
#define PWM_ODSR_PWM0_MASK 0x10000
#define PWM_ODSR_PWM0 0x10000
#define PWM_ODSR_PWM0_BIT 16
#define PWM_ODSR_PWM1_MASK 0x20000
#define PWM_ODSR_PWM1 0x20000
#define PWM_ODSR_PWM1_BIT 17
#define PWM_ODSR_PWM2_MASK 0x40000
#define PWM_ODSR_PWM2 0x40000
#define PWM_ODSR_PWM2_BIT 18
#define PWM_ODSR_PWM3_MASK 0x80000
#define PWM_ODSR_PWM3 0x80000
#define PWM_ODSR_PWM3_BIT 19

#define PWM_PDSR (*(volatile unsigned long *)0xFFFD003C)
#define PWM_PDSR_OFFSET 0x3C
#define PWM_PDSR_PWM0_MASK 0x10000
#define PWM_PDSR_PWM0 0x10000
#define PWM_PDSR_PWM0_BIT 16
#define PWM_PDSR_PWM1_MASK 0x20000
#define PWM_PDSR_PWM1 0x20000
#define PWM_PDSR_PWM1_BIT 17
#define PWM_PDSR_PWM2_MASK 0x40000
#define PWM_PDSR_PWM2 0x40000
#define PWM_PDSR_PWM2_BIT 18
#define PWM_PDSR_PWM3_MASK 0x80000
#define PWM_PDSR_PWM3 0x80000
#define PWM_PDSR_PWM3_BIT 19

#define PWM_MDER (*(volatile unsigned long *)0xFFFD0040)
#define PWM_MDER_OFFSET 0x40
#define PWM_MDER_PWM0_MASK 0x10000
#define PWM_MDER_PWM0 0x10000
#define PWM_MDER_PWM0_BIT 16
#define PWM_MDER_PWM1_MASK 0x20000
#define PWM_MDER_PWM1 0x20000
#define PWM_MDER_PWM1_BIT 17
#define PWM_MDER_PWM2_MASK 0x40000
#define PWM_MDER_PWM2 0x40000
#define PWM_MDER_PWM2_BIT 18
#define PWM_MDER_PWM3_MASK 0x80000
#define PWM_MDER_PWM3 0x80000
#define PWM_MDER_PWM3_BIT 19

#define PWM_MDDR (*(volatile unsigned long *)0xFFFD0044)
#define PWM_MDDR_OFFSET 0x44
#define PWM_MDDR_PWM0_MASK 0x10000
#define PWM_MDDR_PWM0 0x10000
#define PWM_MDDR_PWM0_BIT 16
#define PWM_MDDR_PWM1_MASK 0x20000
#define PWM_MDDR_PWM1 0x20000
#define PWM_MDDR_PWM1_BIT 17
#define PWM_MDDR_PWM2_MASK 0x40000
#define PWM_MDDR_PWM2 0x40000
#define PWM_MDDR_PWM2_BIT 18
#define PWM_MDDR_PWM3_MASK 0x80000
#define PWM_MDDR_PWM3 0x80000
#define PWM_MDDR_PWM3_BIT 19

#define PWM_MDSR (*(volatile unsigned long *)0xFFFD0048)
#define PWM_MDSR_OFFSET 0x48
#define PWM_MDSR_PWM0_MASK 0x10000
#define PWM_MDSR_PWM0 0x10000
#define PWM_MDSR_PWM0_BIT 16
#define PWM_MDSR_PWM1_MASK 0x20000
#define PWM_MDSR_PWM1 0x20000
#define PWM_MDSR_PWM1_BIT 17
#define PWM_MDSR_PWM2_MASK 0x40000
#define PWM_MDSR_PWM2 0x40000
#define PWM_MDSR_PWM2_BIT 18
#define PWM_MDSR_PWM3_MASK 0x80000
#define PWM_MDSR_PWM3 0x80000
#define PWM_MDSR_PWM3_BIT 19

#define PWM_ECR (*(volatile unsigned long *)0xFFFD0050)
#define PWM_ECR_OFFSET 0x50
#define PWM_ECR_PWM_MASK 0x2
#define PWM_ECR_PWM 0x2
#define PWM_ECR_PWM_BIT 1

#define PWM_DCR (*(volatile unsigned long *)0xFFFD0054)
#define PWM_DCR_OFFSET 0x54
#define PWM_DCR_PWM_MASK 0x2
#define PWM_DCR_PWM 0x2
#define PWM_DCR_PWM_BIT 1

#define PWM_PMSR (*(volatile unsigned long *)0xFFFD0058)
#define PWM_PMSR_OFFSET 0x58
#define PWM_PMSR_PWM_MASK 0x2
#define PWM_PMSR_PWM 0x2
#define PWM_PMSR_PWM_BIT 1

#define PWM_CR (*(volatile unsigned long *)0xFFFD0060)
#define PWM_CR_OFFSET 0x60
#define PWM_CR_SWRST_MASK 0x1
#define PWM_CR_SWRST 0x1
#define PWM_CR_SWRST_BIT 0
#define PWM_CR_PWMEN0_MASK 0x2
#define PWM_CR_PWMEN0 0x2
#define PWM_CR_PWMEN0_BIT 1
#define PWM_CR_PWMDIS0_MASK 0x4
#define PWM_CR_PWMDIS0 0x4
#define PWM_CR_PWMDIS0_BIT 2
#define PWM_CR_PWMEN1_MASK 0x8
#define PWM_CR_PWMEN1 0x8
#define PWM_CR_PWMEN1_BIT 3
#define PWM_CR_PWMDIS1_MASK 0x10
#define PWM_CR_PWMDIS1 0x10
#define PWM_CR_PWMDIS1_BIT 4
#define PWM_CR_PWMEN2_MASK 0x20
#define PWM_CR_PWMEN2 0x20
#define PWM_CR_PWMEN2_BIT 5
#define PWM_CR_PWMDIS2_MASK 0x40
#define PWM_CR_PWMDIS2 0x40
#define PWM_CR_PWMDIS2_BIT 6
#define PWM_CR_PWMEN3_MASK 0x80
#define PWM_CR_PWMEN3 0x80
#define PWM_CR_PWMEN3_BIT 7
#define PWM_CR_PWMDIS3_MASK 0x100
#define PWM_CR_PWMDIS3 0x100
#define PWM_CR_PWMDIS3_BIT 8

#define PWM_MR (*(volatile unsigned long *)0xFFFD0064)
#define PWM_MR_OFFSET 0x64
#define PWM_MR_PRESCAL0_MASK 0xF
#define PWM_MR_PRESCAL0_BIT 0
#define PWM_MR_PL0_MASK 0x10
#define PWM_MR_PL0 0x10
#define PWM_MR_PL0_BIT 4
#define PWM_MR_PRESCAL1_MASK 0xF00
#define PWM_MR_PRESCAL1_BIT 8
#define PWM_MR_PL1_MASK 0x1000
#define PWM_MR_PL1 0x1000
#define PWM_MR_PL1_BIT 12
#define PWM_MR_PRESCAL2_MASK 0xF0000
#define PWM_MR_PRESCAL2_BIT 16
#define PWM_MR_PL2_MASK 0x100000
#define PWM_MR_PL2 0x100000
#define PWM_MR_PL2_BIT 20
#define PWM_MR_PRESCAL3_MASK 0xF000000
#define PWM_MR_PRESCAL3_BIT 24
#define PWM_MR_PL3_MASK 0x10000000
#define PWM_MR_PL3 0x10000000
#define PWM_MR_PL3_BIT 28

#define PWM_CSR (*(volatile unsigned long *)0xFFFD006C)
#define PWM_CSR_OFFSET 0x6C
#define PWM_CSR_PSTA0_MASK 0x1
#define PWM_CSR_PSTA0 0x1
#define PWM_CSR_PSTA0_BIT 0
#define PWM_CSR_PEND0_MASK 0x2
#define PWM_CSR_PEND0 0x2
#define PWM_CSR_PEND0_BIT 1
#define PWM_CSR_PSTA1_MASK 0x4
#define PWM_CSR_PSTA1 0x4
#define PWM_CSR_PSTA1_BIT 2
#define PWM_CSR_PEND1_MASK 0x8
#define PWM_CSR_PEND1 0x8
#define PWM_CSR_PEND1_BIT 3
#define PWM_CSR_PSTA2_MASK 0x10
#define PWM_CSR_PSTA2 0x10
#define PWM_CSR_PSTA2_BIT 4
#define PWM_CSR_PEND2_MASK 0x20
#define PWM_CSR_PEND2 0x20
#define PWM_CSR_PEND2_BIT 5
#define PWM_CSR_PSTA3_MASK 0x40
#define PWM_CSR_PSTA3 0x40
#define PWM_CSR_PSTA3_BIT 6
#define PWM_CSR_PEND3_MASK 0x80
#define PWM_CSR_PEND3 0x80
#define PWM_CSR_PEND3_BIT 7

#define PWM_SR (*(volatile unsigned long *)0xFFFD0070)
#define PWM_SR_OFFSET 0x70
#define PWM_SR_PSTA0_MASK 0x1
#define PWM_SR_PSTA0 0x1
#define PWM_SR_PSTA0_BIT 0
#define PWM_SR_PEND0_MASK 0x2
#define PWM_SR_PEND0 0x2
#define PWM_SR_PEND0_BIT 1
#define PWM_SR_PSTA1_MASK 0x4
#define PWM_SR_PSTA1 0x4
#define PWM_SR_PSTA1_BIT 2
#define PWM_SR_PEND1_MASK 0x8
#define PWM_SR_PEND1 0x8
#define PWM_SR_PEND1_BIT 3
#define PWM_SR_PSTA2_MASK 0x10
#define PWM_SR_PSTA2 0x10
#define PWM_SR_PSTA2_BIT 4
#define PWM_SR_PEND2_MASK 0x20
#define PWM_SR_PEND2 0x20
#define PWM_SR_PEND2_BIT 5
#define PWM_SR_PSTA3_MASK 0x40
#define PWM_SR_PSTA3 0x40
#define PWM_SR_PSTA3_BIT 6
#define PWM_SR_PEND3_MASK 0x80
#define PWM_SR_PEND3 0x80
#define PWM_SR_PEND3_BIT 7
#define PWM_SR_PWMENS0_MASK 0x100
#define PWM_SR_PWMENS0 0x100
#define PWM_SR_PWMENS0_BIT 8
#define PWM_SR_PWMENS1_MASK 0x200
#define PWM_SR_PWMENS1 0x200
#define PWM_SR_PWMENS1_BIT 9
#define PWM_SR_PWMENS2_MASK 0x400
#define PWM_SR_PWMENS2 0x400
#define PWM_SR_PWMENS2_BIT 10
#define PWM_SR_PWMENS3_MASK 0x800
#define PWM_SR_PWMENS3 0x800
#define PWM_SR_PWMENS3_BIT 11

#define PWM_IER (*(volatile unsigned long *)0xFFFD0074)
#define PWM_IER_OFFSET 0x74
#define PWM_IER_PSTA0_MASK 0x1
#define PWM_IER_PSTA0 0x1
#define PWM_IER_PSTA0_BIT 0
#define PWM_IER_PEND0_MASK 0x2
#define PWM_IER_PEND0 0x2
#define PWM_IER_PEND0_BIT 1
#define PWM_IER_PSTA1_MASK 0x4
#define PWM_IER_PSTA1 0x4
#define PWM_IER_PSTA1_BIT 2
#define PWM_IER_PEND1_MASK 0x8
#define PWM_IER_PEND1 0x8
#define PWM_IER_PEND1_BIT 3
#define PWM_IER_PSTA2_MASK 0x10
#define PWM_IER_PSTA2 0x10
#define PWM_IER_PSTA2_BIT 4
#define PWM_IER_PEND2_MASK 0x20
#define PWM_IER_PEND2 0x20
#define PWM_IER_PEND2_BIT 5
#define PWM_IER_PSTA3_MASK 0x40
#define PWM_IER_PSTA3 0x40
#define PWM_IER_PSTA3_BIT 6
#define PWM_IER_PEND3_MASK 0x80
#define PWM_IER_PEND3 0x80
#define PWM_IER_PEND3_BIT 7

#define PWM_IDR (*(volatile unsigned long *)0xFFFD0078)
#define PWM_IDR_OFFSET 0x78
#define PWM_IDR_PSTA0_MASK 0x1
#define PWM_IDR_PSTA0 0x1
#define PWM_IDR_PSTA0_BIT 0
#define PWM_IDR_PEND0_MASK 0x2
#define PWM_IDR_PEND0 0x2
#define PWM_IDR_PEND0_BIT 1
#define PWM_IDR_PSTA1_MASK 0x4
#define PWM_IDR_PSTA1 0x4
#define PWM_IDR_PSTA1_BIT 2
#define PWM_IDR_PEND1_MASK 0x8
#define PWM_IDR_PEND1 0x8
#define PWM_IDR_PEND1_BIT 3
#define PWM_IDR_PSTA2_MASK 0x10
#define PWM_IDR_PSTA2 0x10
#define PWM_IDR_PSTA2_BIT 4
#define PWM_IDR_PEND2_MASK 0x20
#define PWM_IDR_PEND2 0x20
#define PWM_IDR_PEND2_BIT 5
#define PWM_IDR_PSTA3_MASK 0x40
#define PWM_IDR_PSTA3 0x40
#define PWM_IDR_PSTA3_BIT 6
#define PWM_IDR_PEND3_MASK 0x80
#define PWM_IDR_PEND3 0x80
#define PWM_IDR_PEND3_BIT 7

#define PWM_IMR (*(volatile unsigned long *)0xFFFD007C)
#define PWM_IMR_OFFSET 0x7C
#define PWM_IMR_PSTA0_MASK 0x1
#define PWM_IMR_PSTA0 0x1
#define PWM_IMR_PSTA0_BIT 0
#define PWM_IMR_PEND0_MASK 0x2
#define PWM_IMR_PEND0 0x2
#define PWM_IMR_PEND0_BIT 1
#define PWM_IMR_PSTA1_MASK 0x4
#define PWM_IMR_PSTA1 0x4
#define PWM_IMR_PSTA1_BIT 2
#define PWM_IMR_PEND1_MASK 0x8
#define PWM_IMR_PEND1 0x8
#define PWM_IMR_PEND1_BIT 3
#define PWM_IMR_PSTA2_MASK 0x10
#define PWM_IMR_PSTA2 0x10
#define PWM_IMR_PSTA2_BIT 4
#define PWM_IMR_PEND2_MASK 0x20
#define PWM_IMR_PEND2 0x20
#define PWM_IMR_PEND2_BIT 5
#define PWM_IMR_PSTA3_MASK 0x40
#define PWM_IMR_PSTA3 0x40
#define PWM_IMR_PSTA3_BIT 6
#define PWM_IMR_PEND3_MASK 0x80
#define PWM_IMR_PEND3 0x80
#define PWM_IMR_PEND3_BIT 7

#define PWM_DLY_0 (*(volatile unsigned long *)0xFFFD0080)
#define PWM_DLY_0_OFFSET 0x80
#define PWM_DLY_0_DELAY_MASK 0xFFFF
#define PWM_DLY_0_DELAY_BIT 0

#define PWM_PUL_0 (*(volatile unsigned long *)0xFFFD0084)
#define PWM_PUL_0_OFFSET 0x84
#define PWM_PUL_0_PULSE_MASK 0xFFFF
#define PWM_PUL_0_PULSE_BIT 0

#define PWM_DLY_1 (*(volatile unsigned long *)0xFFFD0088)
#define PWM_DLY_1_OFFSET 0x88
#define PWM_DLY_1_DELAY_MASK 0xFFFF
#define PWM_DLY_1_DELAY_BIT 0

#define PWM_PUL_1 (*(volatile unsigned long *)0xFFFD008C)
#define PWM_PUL_1_OFFSET 0x8C
#define PWM_PUL_1_PULSE_MASK 0xFFFF
#define PWM_PUL_1_PULSE_BIT 0

#define PWM_DLY_2 (*(volatile unsigned long *)0xFFFD0090)
#define PWM_DLY_2_OFFSET 0x90
#define PWM_DLY_2_DELAY_MASK 0xFFFF
#define PWM_DLY_2_DELAY_BIT 0

#define PWM_PUL_2 (*(volatile unsigned long *)0xFFFD0094)
#define PWM_PUL_2_OFFSET 0x94
#define PWM_PUL_2_PULSE_MASK 0xFFFF
#define PWM_PUL_2_PULSE_BIT 0

#define PWM_DLY_3 (*(volatile unsigned long *)0xFFFD0098)
#define PWM_DLY_3_OFFSET 0x98
#define PWM_DLY_3_DELAY_MASK 0xFFFF
#define PWM_DLY_3_DELAY_BIT 0

#define PWM_PUL_3 (*(volatile unsigned long *)0xFFFD009C)
#define PWM_PUL_3_OFFSET 0x9C
#define PWM_PUL_3_PULSE_MASK 0xFFFF
#define PWM_PUL_3_PULSE_BIT 0

#define CAN0_BASE 0xFFFD4000

#define CAN0_ECR (*(volatile unsigned long *)0xFFFD4050)
#define CAN0_ECR_OFFSET 0x50
#define CAN0_ECR_CAN_MASK 0x2
#define CAN0_ECR_CAN 0x2
#define CAN0_ECR_CAN_BIT 1

#define CAN0_DCR (*(volatile unsigned long *)0xFFFD4054)
#define CAN0_DCR_OFFSET 0x54
#define CAN0_DCR_CAN_MASK 0x2
#define CAN0_DCR_CAN 0x2
#define CAN0_DCR_CAN_BIT 1

#define CAN0_PMSR (*(volatile unsigned long *)0xFFFD4058)
#define CAN0_PMSR_OFFSET 0x58
#define CAN0_PMSR_CAN_MASK 0x2
#define CAN0_PMSR_CAN 0x2
#define CAN0_PMSR_CAN_BIT 1

#define CAN0_CR (*(volatile unsigned long *)0xFFFD4060)
#define CAN0_CR_OFFSET 0x60
#define CAN0_CR_SWRST_MASK 0x1
#define CAN0_CR_SWRST 0x1
#define CAN0_CR_SWRST_BIT 0
#define CAN0_CR_CANEN_MASK 0x2
#define CAN0_CR_CANEN 0x2
#define CAN0_CR_CANEN_BIT 1
#define CAN0_CR_CANDIS_MASK 0x4
#define CAN0_CR_CANDIS 0x4
#define CAN0_CR_CANDIS_BIT 2
#define CAN0_CR_ABEN_MASK 0x8
#define CAN0_CR_ABEN 0x8
#define CAN0_CR_ABEN_BIT 3
#define CAN0_CR_ABDIS_MASK 0x10
#define CAN0_CR_ABDIS 0x10
#define CAN0_CR_ABDIS_BIT 4

#define CAN0_MR (*(volatile unsigned long *)0xFFFD4064)
#define CAN0_MR_OFFSET 0x64
#define CAN0_MR_BD_MASK 0x3F
#define CAN0_MR_BD_BIT 0
#define CAN0_MR_PROP_MASK 0x700
#define CAN0_MR_PROP_BIT 8
#define CAN0_MR_SJW_MASK 0x3000
#define CAN0_MR_SJW_BIT 12
#define CAN0_MR_SMP_MASK 0x4000
#define CAN0_MR_SMP 0x4000
#define CAN0_MR_SMP_BIT 14
#define CAN0_MR_PHSEG1_MASK 0x70000
#define CAN0_MR_PHSEG1_BIT 16
#define CAN0_MR_PHSEG2_MASK 0x700000
#define CAN0_MR_PHSEG2_BIT 20

#define CAN0_CSR (*(volatile unsigned long *)0xFFFD406C)
#define CAN0_CSR_OFFSET 0x6C
#define CAN0_CSR_ENDINIT_MASK 0x4
#define CAN0_CSR_ENDINIT 0x4
#define CAN0_CSR_ENDINIT_BIT 2

#define CAN0_SR (*(volatile unsigned long *)0xFFFD4070)
#define CAN0_SR_OFFSET 0x70
#define CAN0_SR_CANENA_MASK 0x1
#define CAN0_SR_CANENA 0x1
#define CAN0_SR_CANENA_BIT 0
#define CAN0_SR_CANINIT_MASK 0x2
#define CAN0_SR_CANINIT 0x2
#define CAN0_SR_CANINIT_BIT 1
#define CAN0_SR_ENDINIT_MASK 0x4
#define CAN0_SR_ENDINIT 0x4
#define CAN0_SR_ENDINIT_BIT 2
#define CAN0_SR_ERPAS_MASK 0x8
#define CAN0_SR_ERPAS 0x8
#define CAN0_SR_ERPAS_BIT 3
#define CAN0_SR_BUSOFF_MASK 0x10
#define CAN0_SR_BUSOFF 0x10
#define CAN0_SR_BUSOFF_BIT 4
#define CAN0_SR_ABRQ_MASK 0x20
#define CAN0_SR_ABRQ 0x20
#define CAN0_SR_ABRQ_BIT 5
#define CAN0_SR_ISS_MASK 0x80
#define CAN0_SR_ISS 0x80
#define CAN0_SR_ISS_BIT 7
#define CAN0_SR_REC_MASK 0xFF0000
#define CAN0_SR_REC_BIT 16
#define CAN0_SR_TEC_MASK 0xFF000000
#define CAN0_SR_TEC_BIT 24

#define CAN0_IER (*(volatile unsigned long *)0xFFFD4074)
#define CAN0_IER_OFFSET 0x74
#define CAN0_IER_ENDINIT_MASK 0x4
#define CAN0_IER_ENDINIT 0x4
#define CAN0_IER_ENDINIT_BIT 2
#define CAN0_IER_ERPAS_MASK 0x8
#define CAN0_IER_ERPAS 0x8
#define CAN0_IER_ERPAS_BIT 3
#define CAN0_IER_BUSOFF_MASK 0x10
#define CAN0_IER_BUSOFF 0x10
#define CAN0_IER_BUSOFF_BIT 4

#define CAN0_IDR (*(volatile unsigned long *)0xFFFD4078)
#define CAN0_IDR_OFFSET 0x78
#define CAN0_IDR_ENDINIT_MASK 0x4
#define CAN0_IDR_ENDINIT 0x4
#define CAN0_IDR_ENDINIT_BIT 2
#define CAN0_IDR_ERPAS_MASK 0x8
#define CAN0_IDR_ERPAS 0x8
#define CAN0_IDR_ERPAS_BIT 3
#define CAN0_IDR_BUSOFF_MASK 0x10
#define CAN0_IDR_BUSOFF 0x10
#define CAN0_IDR_BUSOFF_BIT 4

#define CAN0_IMR (*(volatile unsigned long *)0xFFFD407C)
#define CAN0_IMR_OFFSET 0x7C
#define CAN0_IMR_ENDINIT_MASK 0x4
#define CAN0_IMR_ENDINIT 0x4
#define CAN0_IMR_ENDINIT_BIT 2
#define CAN0_IMR_ERPAS_MASK 0x8
#define CAN0_IMR_ERPAS 0x8
#define CAN0_IMR_ERPAS_BIT 3
#define CAN0_IMR_BUSOFF_MASK 0x10
#define CAN0_IMR_BUSOFF 0x10
#define CAN0_IMR_BUSOFF_BIT 4

#define CAN0_CISR (*(volatile unsigned long *)0xFFFD4080)
#define CAN0_CISR_OFFSET 0x80
#define CAN0_CISR_CH0_MASK 0x1
#define CAN0_CISR_CH0 0x1
#define CAN0_CISR_CH0_BIT 0
#define CAN0_CISR_CH1_MASK 0x2
#define CAN0_CISR_CH1 0x2
#define CAN0_CISR_CH1_BIT 1
#define CAN0_CISR_CH2_MASK 0x4
#define CAN0_CISR_CH2 0x4
#define CAN0_CISR_CH2_BIT 2
#define CAN0_CISR_CH3_MASK 0x8
#define CAN0_CISR_CH3 0x8
#define CAN0_CISR_CH3_BIT 3
#define CAN0_CISR_CH4_MASK 0x10
#define CAN0_CISR_CH4 0x10
#define CAN0_CISR_CH4_BIT 4
#define CAN0_CISR_CH5_MASK 0x20
#define CAN0_CISR_CH5 0x20
#define CAN0_CISR_CH5_BIT 5
#define CAN0_CISR_CH6_MASK 0x40
#define CAN0_CISR_CH6 0x40
#define CAN0_CISR_CH6_BIT 6
#define CAN0_CISR_CH7_MASK 0x80
#define CAN0_CISR_CH7 0x80
#define CAN0_CISR_CH7_BIT 7
#define CAN0_CISR_CH8_MASK 0x100
#define CAN0_CISR_CH8 0x100
#define CAN0_CISR_CH8_BIT 8
#define CAN0_CISR_CH9_MASK 0x200
#define CAN0_CISR_CH9 0x200
#define CAN0_CISR_CH9_BIT 9
#define CAN0_CISR_CH10_MASK 0x400
#define CAN0_CISR_CH10 0x400
#define CAN0_CISR_CH10_BIT 10
#define CAN0_CISR_CH11_MASK 0x800
#define CAN0_CISR_CH11 0x800
#define CAN0_CISR_CH11_BIT 11
#define CAN0_CISR_CH12_MASK 0x1000
#define CAN0_CISR_CH12 0x1000
#define CAN0_CISR_CH12_BIT 12
#define CAN0_CISR_CH13_MASK 0x2000
#define CAN0_CISR_CH13 0x2000
#define CAN0_CISR_CH13_BIT 13
#define CAN0_CISR_CH14_MASK 0x4000
#define CAN0_CISR_CH14 0x4000
#define CAN0_CISR_CH14_BIT 14
#define CAN0_CISR_CH15_MASK 0x8000
#define CAN0_CISR_CH15 0x8000
#define CAN0_CISR_CH15_BIT 15

#define CAN0_ISSR (*(volatile unsigned long *)0xFFFD4084)
#define CAN0_ISSR_OFFSET 0x84
#define CAN0_ISSR_CH0_MASK 0x1
#define CAN0_ISSR_CH0 0x1
#define CAN0_ISSR_CH0_BIT 0
#define CAN0_ISSR_CH1_MASK 0x2
#define CAN0_ISSR_CH1 0x2
#define CAN0_ISSR_CH1_BIT 1
#define CAN0_ISSR_CH2_MASK 0x4
#define CAN0_ISSR_CH2 0x4
#define CAN0_ISSR_CH2_BIT 2
#define CAN0_ISSR_CH3_MASK 0x8
#define CAN0_ISSR_CH3 0x8
#define CAN0_ISSR_CH3_BIT 3
#define CAN0_ISSR_CH4_MASK 0x10
#define CAN0_ISSR_CH4 0x10
#define CAN0_ISSR_CH4_BIT 4
#define CAN0_ISSR_CH5_MASK 0x20
#define CAN0_ISSR_CH5 0x20
#define CAN0_ISSR_CH5_BIT 5
#define CAN0_ISSR_CH6_MASK 0x40
#define CAN0_ISSR_CH6 0x40
#define CAN0_ISSR_CH6_BIT 6
#define CAN0_ISSR_CH7_MASK 0x80
#define CAN0_ISSR_CH7 0x80
#define CAN0_ISSR_CH7_BIT 7
#define CAN0_ISSR_CH8_MASK 0x100
#define CAN0_ISSR_CH8 0x100
#define CAN0_ISSR_CH8_BIT 8
#define CAN0_ISSR_CH9_MASK 0x200
#define CAN0_ISSR_CH9 0x200
#define CAN0_ISSR_CH9_BIT 9
#define CAN0_ISSR_CH10_MASK 0x400
#define CAN0_ISSR_CH10 0x400
#define CAN0_ISSR_CH10_BIT 10
#define CAN0_ISSR_CH11_MASK 0x800
#define CAN0_ISSR_CH11 0x800
#define CAN0_ISSR_CH11_BIT 11
#define CAN0_ISSR_CH12_MASK 0x1000
#define CAN0_ISSR_CH12 0x1000
#define CAN0_ISSR_CH12_BIT 12
#define CAN0_ISSR_CH13_MASK 0x2000
#define CAN0_ISSR_CH13 0x2000
#define CAN0_ISSR_CH13_BIT 13
#define CAN0_ISSR_CH14_MASK 0x4000
#define CAN0_ISSR_CH14 0x4000
#define CAN0_ISSR_CH14_BIT 14
#define CAN0_ISSR_CH15_MASK 0x8000
#define CAN0_ISSR_CH15 0x8000
#define CAN0_ISSR_CH15_BIT 15

#define CAN0_SIER (*(volatile unsigned long *)0xFFFD4088)
#define CAN0_SIER_OFFSET 0x88
#define CAN0_SIER_CH0_MASK 0x1
#define CAN0_SIER_CH0 0x1
#define CAN0_SIER_CH0_BIT 0
#define CAN0_SIER_CH1_MASK 0x2
#define CAN0_SIER_CH1 0x2
#define CAN0_SIER_CH1_BIT 1
#define CAN0_SIER_CH2_MASK 0x4
#define CAN0_SIER_CH2 0x4
#define CAN0_SIER_CH2_BIT 2
#define CAN0_SIER_CH3_MASK 0x8
#define CAN0_SIER_CH3 0x8
#define CAN0_SIER_CH3_BIT 3
#define CAN0_SIER_CH4_MASK 0x10
#define CAN0_SIER_CH4 0x10
#define CAN0_SIER_CH4_BIT 4
#define CAN0_SIER_CH5_MASK 0x20
#define CAN0_SIER_CH5 0x20
#define CAN0_SIER_CH5_BIT 5
#define CAN0_SIER_CH6_MASK 0x40
#define CAN0_SIER_CH6 0x40
#define CAN0_SIER_CH6_BIT 6
#define CAN0_SIER_CH7_MASK 0x80
#define CAN0_SIER_CH7 0x80
#define CAN0_SIER_CH7_BIT 7
#define CAN0_SIER_CH8_MASK 0x100
#define CAN0_SIER_CH8 0x100
#define CAN0_SIER_CH8_BIT 8
#define CAN0_SIER_CH9_MASK 0x200
#define CAN0_SIER_CH9 0x200
#define CAN0_SIER_CH9_BIT 9
#define CAN0_SIER_CH10_MASK 0x400
#define CAN0_SIER_CH10 0x400
#define CAN0_SIER_CH10_BIT 10
#define CAN0_SIER_CH11_MASK 0x800
#define CAN0_SIER_CH11 0x800
#define CAN0_SIER_CH11_BIT 11
#define CAN0_SIER_CH12_MASK 0x1000
#define CAN0_SIER_CH12 0x1000
#define CAN0_SIER_CH12_BIT 12
#define CAN0_SIER_CH13_MASK 0x2000
#define CAN0_SIER_CH13 0x2000
#define CAN0_SIER_CH13_BIT 13
#define CAN0_SIER_CH14_MASK 0x4000
#define CAN0_SIER_CH14 0x4000
#define CAN0_SIER_CH14_BIT 14
#define CAN0_SIER_CH15_MASK 0x8000
#define CAN0_SIER_CH15 0x8000
#define CAN0_SIER_CH15_BIT 15

#define CAN0_SIDR (*(volatile unsigned long *)0xFFFD408C)
#define CAN0_SIDR_OFFSET 0x8C
#define CAN0_SIDR_CH0_MASK 0x1
#define CAN0_SIDR_CH0 0x1
#define CAN0_SIDR_CH0_BIT 0
#define CAN0_SIDR_CH1_MASK 0x2
#define CAN0_SIDR_CH1 0x2
#define CAN0_SIDR_CH1_BIT 1
#define CAN0_SIDR_CH2_MASK 0x4
#define CAN0_SIDR_CH2 0x4
#define CAN0_SIDR_CH2_BIT 2
#define CAN0_SIDR_CH3_MASK 0x8
#define CAN0_SIDR_CH3 0x8
#define CAN0_SIDR_CH3_BIT 3
#define CAN0_SIDR_CH4_MASK 0x10
#define CAN0_SIDR_CH4 0x10
#define CAN0_SIDR_CH4_BIT 4
#define CAN0_SIDR_CH5_MASK 0x20
#define CAN0_SIDR_CH5 0x20
#define CAN0_SIDR_CH5_BIT 5
#define CAN0_SIDR_CH6_MASK 0x40
#define CAN0_SIDR_CH6 0x40
#define CAN0_SIDR_CH6_BIT 6
#define CAN0_SIDR_CH7_MASK 0x80
#define CAN0_SIDR_CH7 0x80
#define CAN0_SIDR_CH7_BIT 7
#define CAN0_SIDR_CH8_MASK 0x100
#define CAN0_SIDR_CH8 0x100
#define CAN0_SIDR_CH8_BIT 8
#define CAN0_SIDR_CH9_MASK 0x200
#define CAN0_SIDR_CH9 0x200
#define CAN0_SIDR_CH9_BIT 9
#define CAN0_SIDR_CH10_MASK 0x400
#define CAN0_SIDR_CH10 0x400
#define CAN0_SIDR_CH10_BIT 10
#define CAN0_SIDR_CH11_MASK 0x800
#define CAN0_SIDR_CH11 0x800
#define CAN0_SIDR_CH11_BIT 11
#define CAN0_SIDR_CH12_MASK 0x1000
#define CAN0_SIDR_CH12 0x1000
#define CAN0_SIDR_CH12_BIT 12
#define CAN0_SIDR_CH13_MASK 0x2000
#define CAN0_SIDR_CH13 0x2000
#define CAN0_SIDR_CH13_BIT 13
#define CAN0_SIDR_CH14_MASK 0x4000
#define CAN0_SIDR_CH14 0x4000
#define CAN0_SIDR_CH14_BIT 14
#define CAN0_SIDR_CH15_MASK 0x8000
#define CAN0_SIDR_CH15 0x8000
#define CAN0_SIDR_CH15_BIT 15

#define CAN0_SIMR (*(volatile unsigned long *)0xFFFD4090)
#define CAN0_SIMR_OFFSET 0x90
#define CAN0_SIMR_CH0_MASK 0x1
#define CAN0_SIMR_CH0 0x1
#define CAN0_SIMR_CH0_BIT 0
#define CAN0_SIMR_CH1_MASK 0x2
#define CAN0_SIMR_CH1 0x2
#define CAN0_SIMR_CH1_BIT 1
#define CAN0_SIMR_CH2_MASK 0x4
#define CAN0_SIMR_CH2 0x4
#define CAN0_SIMR_CH2_BIT 2
#define CAN0_SIMR_CH3_MASK 0x8
#define CAN0_SIMR_CH3 0x8
#define CAN0_SIMR_CH3_BIT 3
#define CAN0_SIMR_CH4_MASK 0x10
#define CAN0_SIMR_CH4 0x10
#define CAN0_SIMR_CH4_BIT 4
#define CAN0_SIMR_CH5_MASK 0x20
#define CAN0_SIMR_CH5 0x20
#define CAN0_SIMR_CH5_BIT 5
#define CAN0_SIMR_CH6_MASK 0x40
#define CAN0_SIMR_CH6 0x40
#define CAN0_SIMR_CH6_BIT 6
#define CAN0_SIMR_CH7_MASK 0x80
#define CAN0_SIMR_CH7 0x80
#define CAN0_SIMR_CH7_BIT 7
#define CAN0_SIMR_CH8_MASK 0x100
#define CAN0_SIMR_CH8 0x100
#define CAN0_SIMR_CH8_BIT 8
#define CAN0_SIMR_CH9_MASK 0x200
#define CAN0_SIMR_CH9 0x200
#define CAN0_SIMR_CH9_BIT 9
#define CAN0_SIMR_CH10_MASK 0x400
#define CAN0_SIMR_CH10 0x400
#define CAN0_SIMR_CH10_BIT 10
#define CAN0_SIMR_CH11_MASK 0x800
#define CAN0_SIMR_CH11 0x800
#define CAN0_SIMR_CH11_BIT 11
#define CAN0_SIMR_CH12_MASK 0x1000
#define CAN0_SIMR_CH12 0x1000
#define CAN0_SIMR_CH12_BIT 12
#define CAN0_SIMR_CH13_MASK 0x2000
#define CAN0_SIMR_CH13 0x2000
#define CAN0_SIMR_CH13_BIT 13
#define CAN0_SIMR_CH14_MASK 0x4000
#define CAN0_SIMR_CH14 0x4000
#define CAN0_SIMR_CH14_BIT 14
#define CAN0_SIMR_CH15_MASK 0x8000
#define CAN0_SIMR_CH15 0x8000
#define CAN0_SIMR_CH15_BIT 15

#define CAN0_DRA0 (*(volatile unsigned long *)0xFFFD4100)
#define CAN0_DRA0_OFFSET 0x100
#define CAN0_DRA0_DATA0_MASK 0xFF
#define CAN0_DRA0_DATA0_BIT 0
#define CAN0_DRA0_DATA1_MASK 0xFF00
#define CAN0_DRA0_DATA1_BIT 8
#define CAN0_DRA0_DATA2_MASK 0xFF0000
#define CAN0_DRA0_DATA2_BIT 16
#define CAN0_DRA0_DATA3_MASK 0xFF000000
#define CAN0_DRA0_DATA3_BIT 24

#define CAN0_DRB0 (*(volatile unsigned long *)0xFFFD4104)
#define CAN0_DRB0_OFFSET 0x104
#define CAN0_DRB0_DATA4_MASK 0xFF
#define CAN0_DRB0_DATA4_BIT 0
#define CAN0_DRB0_DATA5_MASK 0xFF00
#define CAN0_DRB0_DATA5_BIT 8
#define CAN0_DRB0_DATA6_MASK 0xFF0000
#define CAN0_DRB0_DATA6_BIT 16
#define CAN0_DRB0_DATA7_MASK 0xFF000000
#define CAN0_DRB0_DATA7_BIT 24

#define CAN0_MSK0 (*(volatile unsigned long *)0xFFFD4108)
#define CAN0_MSK0_OFFSET 0x108
#define CAN0_MSK0_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK0_MASK_BIT 0
#define CAN0_MSK0_MRB_MASK 0x60000000
#define CAN0_MSK0_MRB_BIT 29
#define CAN0_MSK0_MRTR_MASK 0x80000000
#define CAN0_MSK0_MRTR 0x80000000
#define CAN0_MSK0_MRTR_BIT 31

#define CAN0_IR0 (*(volatile unsigned long *)0xFFFD410C)
#define CAN0_IR0_OFFSET 0x10C
#define CAN0_IR0_ID_MASK 0x1FFFFFFF
#define CAN0_IR0_ID_BIT 0
#define CAN0_IR0_RB_MASK 0x60000000
#define CAN0_IR0_RB_BIT 29
#define CAN0_IR0_RTR_MASK 0x80000000
#define CAN0_IR0_RTR 0x80000000
#define CAN0_IR0_RTR_BIT 31

#define CAN0_CR0 (*(volatile unsigned long *)0xFFFD4110)
#define CAN0_CR0_OFFSET 0x110
#define CAN0_CR0_DLC_MASK 0xF
#define CAN0_CR0_DLC_BIT 0
#define CAN0_CR0_IDE_MASK 0x10
#define CAN0_CR0_IDE 0x10
#define CAN0_CR0_IDE_BIT 4
#define CAN0_CR0_RPLYV_MASK 0x20
#define CAN0_CR0_RPLYV 0x20
#define CAN0_CR0_RPLYV_BIT 5
#define CAN0_CR0_PCB_MASK 0x40
#define CAN0_CR0_PCB 0x40
#define CAN0_CR0_PCB_BIT 6
#define CAN0_CR0_CHANEN_MASK 0x80
#define CAN0_CR0_CHANEN 0x80
#define CAN0_CR0_CHANEN_BIT 7
#define CAN0_CR0_OVERWRITE_MASK 0x100
#define CAN0_CR0_OVERWRITE 0x100
#define CAN0_CR0_OVERWRITE_BIT 8

#define CAN0_CR0 (*(volatile unsigned long *)0xFFFD4114)
#define CAN0_CR0_OFFSET 0x114
#define CAN0_CR0_STAMP_MASK 0x0
#define CAN0_CR0_STAMP_BIT 0

#define CAN0_CSR0 (*(volatile unsigned long *)0xFFFD4118)
#define CAN0_CSR0_OFFSET 0x118
#define CAN0_CSR0_ACK_MASK 0x1
#define CAN0_CSR0_ACK 0x1
#define CAN0_CSR0_ACK_BIT 0
#define CAN0_CSR0_FRAME_MASK 0x2
#define CAN0_CSR0_FRAME 0x2
#define CAN0_CSR0_FRAME_BIT 1
#define CAN0_CSR0_CRC_MASK 0x4
#define CAN0_CSR0_CRC 0x4
#define CAN0_CSR0_CRC_BIT 2
#define CAN0_CSR0_STUFF_MASK 0x8
#define CAN0_CSR0_STUFF 0x8
#define CAN0_CSR0_STUFF_BIT 3
#define CAN0_CSR0_BUS_MASK 0x10
#define CAN0_CSR0_BUS 0x10
#define CAN0_CSR0_BUS_BIT 4
#define CAN0_CSR0_RXOK_MASK 0x20
#define CAN0_CSR0_RXOK 0x20
#define CAN0_CSR0_RXOK_BIT 5
#define CAN0_CSR0_TXOK_MASK 0x40
#define CAN0_CSR0_TXOK 0x40
#define CAN0_CSR0_TXOK_BIT 6
#define CAN0_CSR0_RFRAME_MASK 0x80
#define CAN0_CSR0_RFRAME 0x80
#define CAN0_CSR0_RFRAME_BIT 7
#define CAN0_CSR0_DLCW_MASK 0x200
#define CAN0_CSR0_DLCW 0x200
#define CAN0_CSR0_DLCW_BIT 9
#define CAN0_CSR0_FILLED_MASK 0x400
#define CAN0_CSR0_FILLED 0x400
#define CAN0_CSR0_FILLED_BIT 10
#define CAN0_CSR0_OVRUN_MASK 0x800
#define CAN0_CSR0_OVRUN 0x800
#define CAN0_CSR0_OVRUN_BIT 11

#define CAN0_SR0 (*(volatile unsigned long *)0xFFFD411C)
#define CAN0_SR0_OFFSET 0x11C
#define CAN0_SR0_ACK_MASK 0x1
#define CAN0_SR0_ACK 0x1
#define CAN0_SR0_ACK_BIT 0
#define CAN0_SR0_FRAME_MASK 0x2
#define CAN0_SR0_FRAME 0x2
#define CAN0_SR0_FRAME_BIT 1
#define CAN0_SR0_CRC_MASK 0x4
#define CAN0_SR0_CRC 0x4
#define CAN0_SR0_CRC_BIT 2
#define CAN0_SR0_STUFF_MASK 0x8
#define CAN0_SR0_STUFF 0x8
#define CAN0_SR0_STUFF_BIT 3
#define CAN0_SR0_BUS_MASK 0x10
#define CAN0_SR0_BUS 0x10
#define CAN0_SR0_BUS_BIT 4
#define CAN0_SR0_RXOK_MASK 0x20
#define CAN0_SR0_RXOK 0x20
#define CAN0_SR0_RXOK_BIT 5
#define CAN0_SR0_TXOK_MASK 0x40
#define CAN0_SR0_TXOK 0x40
#define CAN0_SR0_TXOK_BIT 6
#define CAN0_SR0_RFRAME_MASK 0x80
#define CAN0_SR0_RFRAME 0x80
#define CAN0_SR0_RFRAME_BIT 7
#define CAN0_SR0_DLCW_MASK 0x200
#define CAN0_SR0_DLCW 0x200
#define CAN0_SR0_DLCW_BIT 9
#define CAN0_SR0_FILLED_MASK 0x400
#define CAN0_SR0_FILLED 0x400
#define CAN0_SR0_FILLED_BIT 10
#define CAN0_SR0_OVRUN_MASK 0x800
#define CAN0_SR0_OVRUN 0x800
#define CAN0_SR0_OVRUN_BIT 11

#define CAN0_IER0 (*(volatile unsigned long *)0xFFFD4120)
#define CAN0_IER0_OFFSET 0x120
#define CAN0_IER0_ACK_MASK 0x1
#define CAN0_IER0_ACK 0x1
#define CAN0_IER0_ACK_BIT 0
#define CAN0_IER0_FRAME_MASK 0x2
#define CAN0_IER0_FRAME 0x2
#define CAN0_IER0_FRAME_BIT 1
#define CAN0_IER0_CRC_MASK 0x4
#define CAN0_IER0_CRC 0x4
#define CAN0_IER0_CRC_BIT 2
#define CAN0_IER0_STUFF_MASK 0x8
#define CAN0_IER0_STUFF 0x8
#define CAN0_IER0_STUFF_BIT 3
#define CAN0_IER0_BUS_MASK 0x10
#define CAN0_IER0_BUS 0x10
#define CAN0_IER0_BUS_BIT 4
#define CAN0_IER0_RXOK_MASK 0x20
#define CAN0_IER0_RXOK 0x20
#define CAN0_IER0_RXOK_BIT 5
#define CAN0_IER0_TXOK_MASK 0x40
#define CAN0_IER0_TXOK 0x40
#define CAN0_IER0_TXOK_BIT 6
#define CAN0_IER0_RFRAME_MASK 0x80
#define CAN0_IER0_RFRAME 0x80
#define CAN0_IER0_RFRAME_BIT 7

#define CAN0_IDR0 (*(volatile unsigned long *)0xFFFD4124)
#define CAN0_IDR0_OFFSET 0x124
#define CAN0_IDR0_ACK_MASK 0x1
#define CAN0_IDR0_ACK 0x1
#define CAN0_IDR0_ACK_BIT 0
#define CAN0_IDR0_FRAME_MASK 0x2
#define CAN0_IDR0_FRAME 0x2
#define CAN0_IDR0_FRAME_BIT 1
#define CAN0_IDR0_CRC_MASK 0x4
#define CAN0_IDR0_CRC 0x4
#define CAN0_IDR0_CRC_BIT 2
#define CAN0_IDR0_STUFF_MASK 0x8
#define CAN0_IDR0_STUFF 0x8
#define CAN0_IDR0_STUFF_BIT 3
#define CAN0_IDR0_BUS_MASK 0x10
#define CAN0_IDR0_BUS 0x10
#define CAN0_IDR0_BUS_BIT 4
#define CAN0_IDR0_RXOK_MASK 0x20
#define CAN0_IDR0_RXOK 0x20
#define CAN0_IDR0_RXOK_BIT 5
#define CAN0_IDR0_TXOK_MASK 0x40
#define CAN0_IDR0_TXOK 0x40
#define CAN0_IDR0_TXOK_BIT 6
#define CAN0_IDR0_RFRAME_MASK 0x80
#define CAN0_IDR0_RFRAME 0x80
#define CAN0_IDR0_RFRAME_BIT 7

#define CAN0_IMR0 (*(volatile unsigned long *)0xFFFD4128)
#define CAN0_IMR0_OFFSET 0x128
#define CAN0_IMR0_ACK_MASK 0x1
#define CAN0_IMR0_ACK 0x1
#define CAN0_IMR0_ACK_BIT 0
#define CAN0_IMR0_FRAME_MASK 0x2
#define CAN0_IMR0_FRAME 0x2
#define CAN0_IMR0_FRAME_BIT 1
#define CAN0_IMR0_CRC_MASK 0x4
#define CAN0_IMR0_CRC 0x4
#define CAN0_IMR0_CRC_BIT 2
#define CAN0_IMR0_STUFF_MASK 0x8
#define CAN0_IMR0_STUFF 0x8
#define CAN0_IMR0_STUFF_BIT 3
#define CAN0_IMR0_BUS_MASK 0x10
#define CAN0_IMR0_BUS 0x10
#define CAN0_IMR0_BUS_BIT 4
#define CAN0_IMR0_RXOK_MASK 0x20
#define CAN0_IMR0_RXOK 0x20
#define CAN0_IMR0_RXOK_BIT 5
#define CAN0_IMR0_TXOK_MASK 0x40
#define CAN0_IMR0_TXOK 0x40
#define CAN0_IMR0_TXOK_BIT 6
#define CAN0_IMR0_RFRAME_MASK 0x80
#define CAN0_IMR0_RFRAME 0x80
#define CAN0_IMR0_RFRAME_BIT 7

#define CAN0_DRA1 (*(volatile unsigned long *)0xFFFD4140)
#define CAN0_DRA1_OFFSET 0x140
#define CAN0_DRA1_DATA0_MASK 0xFF
#define CAN0_DRA1_DATA0_BIT 0
#define CAN0_DRA1_DATA1_MASK 0xFF00
#define CAN0_DRA1_DATA1_BIT 8
#define CAN0_DRA1_DATA2_MASK 0xFF0000
#define CAN0_DRA1_DATA2_BIT 16
#define CAN0_DRA1_DATA3_MASK 0xFF000000
#define CAN0_DRA1_DATA3_BIT 24

#define CAN0_DRB1 (*(volatile unsigned long *)0xFFFD4144)
#define CAN0_DRB1_OFFSET 0x144
#define CAN0_DRB1_DATA4_MASK 0xFF
#define CAN0_DRB1_DATA4_BIT 0
#define CAN0_DRB1_DATA5_MASK 0xFF00
#define CAN0_DRB1_DATA5_BIT 8
#define CAN0_DRB1_DATA6_MASK 0xFF0000
#define CAN0_DRB1_DATA6_BIT 16
#define CAN0_DRB1_DATA7_MASK 0xFF000000
#define CAN0_DRB1_DATA7_BIT 24

#define CAN0_MSK1 (*(volatile unsigned long *)0xFFFD4148)
#define CAN0_MSK1_OFFSET 0x148
#define CAN0_MSK1_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK1_MASK_BIT 0
#define CAN0_MSK1_MRB_MASK 0x60000000
#define CAN0_MSK1_MRB_BIT 29
#define CAN0_MSK1_MRTR_MASK 0x80000000
#define CAN0_MSK1_MRTR 0x80000000
#define CAN0_MSK1_MRTR_BIT 31

#define CAN0_IR1 (*(volatile unsigned long *)0xFFFD414C)
#define CAN0_IR1_OFFSET 0x14C
#define CAN0_IR1_ID_MASK 0x1FFFFFFF
#define CAN0_IR1_ID_BIT 0
#define CAN0_IR1_RB_MASK 0x60000000
#define CAN0_IR1_RB_BIT 29
#define CAN0_IR1_RTR_MASK 0x80000000
#define CAN0_IR1_RTR 0x80000000
#define CAN0_IR1_RTR_BIT 31

#define CAN0_CR1 (*(volatile unsigned long *)0xFFFD4150)
#define CAN0_CR1_OFFSET 0x150
#define CAN0_CR1_DLC_MASK 0xF
#define CAN0_CR1_DLC_BIT 0
#define CAN0_CR1_IDE_MASK 0x10
#define CAN0_CR1_IDE 0x10
#define CAN0_CR1_IDE_BIT 4
#define CAN0_CR1_RPLYV_MASK 0x20
#define CAN0_CR1_RPLYV 0x20
#define CAN0_CR1_RPLYV_BIT 5
#define CAN0_CR1_PCB_MASK 0x40
#define CAN0_CR1_PCB 0x40
#define CAN0_CR1_PCB_BIT 6
#define CAN0_CR1_CHANEN_MASK 0x80
#define CAN0_CR1_CHANEN 0x80
#define CAN0_CR1_CHANEN_BIT 7
#define CAN0_CR1_OVERWRITE_MASK 0x100
#define CAN0_CR1_OVERWRITE 0x100
#define CAN0_CR1_OVERWRITE_BIT 8

#define CAN0_CR1 (*(volatile unsigned long *)0xFFFD4154)
#define CAN0_CR1_OFFSET 0x154
#define CAN0_CR1_STAMP_MASK 0x0
#define CAN0_CR1_STAMP_BIT 0

#define CAN0_CSR1 (*(volatile unsigned long *)0xFFFD4158)
#define CAN0_CSR1_OFFSET 0x158
#define CAN0_CSR1_ACK_MASK 0x1
#define CAN0_CSR1_ACK 0x1
#define CAN0_CSR1_ACK_BIT 0
#define CAN0_CSR1_FRAME_MASK 0x2
#define CAN0_CSR1_FRAME 0x2
#define CAN0_CSR1_FRAME_BIT 1
#define CAN0_CSR1_CRC_MASK 0x4
#define CAN0_CSR1_CRC 0x4
#define CAN0_CSR1_CRC_BIT 2
#define CAN0_CSR1_STUFF_MASK 0x8
#define CAN0_CSR1_STUFF 0x8
#define CAN0_CSR1_STUFF_BIT 3
#define CAN0_CSR1_BUS_MASK 0x10
#define CAN0_CSR1_BUS 0x10
#define CAN0_CSR1_BUS_BIT 4
#define CAN0_CSR1_RXOK_MASK 0x20
#define CAN0_CSR1_RXOK 0x20
#define CAN0_CSR1_RXOK_BIT 5
#define CAN0_CSR1_TXOK_MASK 0x40
#define CAN0_CSR1_TXOK 0x40
#define CAN0_CSR1_TXOK_BIT 6
#define CAN0_CSR1_RFRAME_MASK 0x80
#define CAN0_CSR1_RFRAME 0x80
#define CAN0_CSR1_RFRAME_BIT 7
#define CAN0_CSR1_DLCW_MASK 0x200
#define CAN0_CSR1_DLCW 0x200
#define CAN0_CSR1_DLCW_BIT 9
#define CAN0_CSR1_FILLED_MASK 0x400
#define CAN0_CSR1_FILLED 0x400
#define CAN0_CSR1_FILLED_BIT 10
#define CAN0_CSR1_OVRUN_MASK 0x800
#define CAN0_CSR1_OVRUN 0x800
#define CAN0_CSR1_OVRUN_BIT 11

#define CAN0_SR1 (*(volatile unsigned long *)0xFFFD415C)
#define CAN0_SR1_OFFSET 0x15C
#define CAN0_SR1_ACK_MASK 0x1
#define CAN0_SR1_ACK 0x1
#define CAN0_SR1_ACK_BIT 0
#define CAN0_SR1_FRAME_MASK 0x2
#define CAN0_SR1_FRAME 0x2
#define CAN0_SR1_FRAME_BIT 1
#define CAN0_SR1_CRC_MASK 0x4
#define CAN0_SR1_CRC 0x4
#define CAN0_SR1_CRC_BIT 2
#define CAN0_SR1_STUFF_MASK 0x8
#define CAN0_SR1_STUFF 0x8
#define CAN0_SR1_STUFF_BIT 3
#define CAN0_SR1_BUS_MASK 0x10
#define CAN0_SR1_BUS 0x10
#define CAN0_SR1_BUS_BIT 4
#define CAN0_SR1_RXOK_MASK 0x20
#define CAN0_SR1_RXOK 0x20
#define CAN0_SR1_RXOK_BIT 5
#define CAN0_SR1_TXOK_MASK 0x40
#define CAN0_SR1_TXOK 0x40
#define CAN0_SR1_TXOK_BIT 6
#define CAN0_SR1_RFRAME_MASK 0x80
#define CAN0_SR1_RFRAME 0x80
#define CAN0_SR1_RFRAME_BIT 7
#define CAN0_SR1_DLCW_MASK 0x200
#define CAN0_SR1_DLCW 0x200
#define CAN0_SR1_DLCW_BIT 9
#define CAN0_SR1_FILLED_MASK 0x400
#define CAN0_SR1_FILLED 0x400
#define CAN0_SR1_FILLED_BIT 10
#define CAN0_SR1_OVRUN_MASK 0x800
#define CAN0_SR1_OVRUN 0x800
#define CAN0_SR1_OVRUN_BIT 11

#define CAN0_IER1 (*(volatile unsigned long *)0xFFFD4160)
#define CAN0_IER1_OFFSET 0x160
#define CAN0_IER1_ACK_MASK 0x1
#define CAN0_IER1_ACK 0x1
#define CAN0_IER1_ACK_BIT 0
#define CAN0_IER1_FRAME_MASK 0x2
#define CAN0_IER1_FRAME 0x2
#define CAN0_IER1_FRAME_BIT 1
#define CAN0_IER1_CRC_MASK 0x4
#define CAN0_IER1_CRC 0x4
#define CAN0_IER1_CRC_BIT 2
#define CAN0_IER1_STUFF_MASK 0x8
#define CAN0_IER1_STUFF 0x8
#define CAN0_IER1_STUFF_BIT 3
#define CAN0_IER1_BUS_MASK 0x10
#define CAN0_IER1_BUS 0x10
#define CAN0_IER1_BUS_BIT 4
#define CAN0_IER1_RXOK_MASK 0x20
#define CAN0_IER1_RXOK 0x20
#define CAN0_IER1_RXOK_BIT 5
#define CAN0_IER1_TXOK_MASK 0x40
#define CAN0_IER1_TXOK 0x40
#define CAN0_IER1_TXOK_BIT 6
#define CAN0_IER1_RFRAME_MASK 0x80
#define CAN0_IER1_RFRAME 0x80
#define CAN0_IER1_RFRAME_BIT 7

#define CAN0_IDR1 (*(volatile unsigned long *)0xFFFD4164)
#define CAN0_IDR1_OFFSET 0x164
#define CAN0_IDR1_ACK_MASK 0x1
#define CAN0_IDR1_ACK 0x1
#define CAN0_IDR1_ACK_BIT 0
#define CAN0_IDR1_FRAME_MASK 0x2
#define CAN0_IDR1_FRAME 0x2
#define CAN0_IDR1_FRAME_BIT 1
#define CAN0_IDR1_CRC_MASK 0x4
#define CAN0_IDR1_CRC 0x4
#define CAN0_IDR1_CRC_BIT 2
#define CAN0_IDR1_STUFF_MASK 0x8
#define CAN0_IDR1_STUFF 0x8
#define CAN0_IDR1_STUFF_BIT 3
#define CAN0_IDR1_BUS_MASK 0x10
#define CAN0_IDR1_BUS 0x10
#define CAN0_IDR1_BUS_BIT 4
#define CAN0_IDR1_RXOK_MASK 0x20
#define CAN0_IDR1_RXOK 0x20
#define CAN0_IDR1_RXOK_BIT 5
#define CAN0_IDR1_TXOK_MASK 0x40
#define CAN0_IDR1_TXOK 0x40
#define CAN0_IDR1_TXOK_BIT 6
#define CAN0_IDR1_RFRAME_MASK 0x80
#define CAN0_IDR1_RFRAME 0x80
#define CAN0_IDR1_RFRAME_BIT 7

#define CAN0_IMR1 (*(volatile unsigned long *)0xFFFD4168)
#define CAN0_IMR1_OFFSET 0x168
#define CAN0_IMR1_ACK_MASK 0x1
#define CAN0_IMR1_ACK 0x1
#define CAN0_IMR1_ACK_BIT 0
#define CAN0_IMR1_FRAME_MASK 0x2
#define CAN0_IMR1_FRAME 0x2
#define CAN0_IMR1_FRAME_BIT 1
#define CAN0_IMR1_CRC_MASK 0x4
#define CAN0_IMR1_CRC 0x4
#define CAN0_IMR1_CRC_BIT 2
#define CAN0_IMR1_STUFF_MASK 0x8
#define CAN0_IMR1_STUFF 0x8
#define CAN0_IMR1_STUFF_BIT 3
#define CAN0_IMR1_BUS_MASK 0x10
#define CAN0_IMR1_BUS 0x10
#define CAN0_IMR1_BUS_BIT 4
#define CAN0_IMR1_RXOK_MASK 0x20
#define CAN0_IMR1_RXOK 0x20
#define CAN0_IMR1_RXOK_BIT 5
#define CAN0_IMR1_TXOK_MASK 0x40
#define CAN0_IMR1_TXOK 0x40
#define CAN0_IMR1_TXOK_BIT 6
#define CAN0_IMR1_RFRAME_MASK 0x80
#define CAN0_IMR1_RFRAME 0x80
#define CAN0_IMR1_RFRAME_BIT 7

#define CAN0_DRA2 (*(volatile unsigned long *)0xFFFD4180)
#define CAN0_DRA2_OFFSET 0x180
#define CAN0_DRA2_DATA0_MASK 0xFF
#define CAN0_DRA2_DATA0_BIT 0
#define CAN0_DRA2_DATA1_MASK 0xFF00
#define CAN0_DRA2_DATA1_BIT 8
#define CAN0_DRA2_DATA2_MASK 0xFF0000
#define CAN0_DRA2_DATA2_BIT 16
#define CAN0_DRA2_DATA3_MASK 0xFF000000
#define CAN0_DRA2_DATA3_BIT 24

#define CAN0_DRB2 (*(volatile unsigned long *)0xFFFD4184)
#define CAN0_DRB2_OFFSET 0x184
#define CAN0_DRB2_DATA4_MASK 0xFF
#define CAN0_DRB2_DATA4_BIT 0
#define CAN0_DRB2_DATA5_MASK 0xFF00
#define CAN0_DRB2_DATA5_BIT 8
#define CAN0_DRB2_DATA6_MASK 0xFF0000
#define CAN0_DRB2_DATA6_BIT 16
#define CAN0_DRB2_DATA7_MASK 0xFF000000
#define CAN0_DRB2_DATA7_BIT 24

#define CAN0_MSK2 (*(volatile unsigned long *)0xFFFD4188)
#define CAN0_MSK2_OFFSET 0x188
#define CAN0_MSK2_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK2_MASK_BIT 0
#define CAN0_MSK2_MRB_MASK 0x60000000
#define CAN0_MSK2_MRB_BIT 29
#define CAN0_MSK2_MRTR_MASK 0x80000000
#define CAN0_MSK2_MRTR 0x80000000
#define CAN0_MSK2_MRTR_BIT 31

#define CAN0_IR2 (*(volatile unsigned long *)0xFFFD418C)
#define CAN0_IR2_OFFSET 0x18C
#define CAN0_IR2_ID_MASK 0x1FFFFFFF
#define CAN0_IR2_ID_BIT 0
#define CAN0_IR2_RB_MASK 0x60000000
#define CAN0_IR2_RB_BIT 29
#define CAN0_IR2_RTR_MASK 0x80000000
#define CAN0_IR2_RTR 0x80000000
#define CAN0_IR2_RTR_BIT 31

#define CAN0_CR2 (*(volatile unsigned long *)0xFFFD4190)
#define CAN0_CR2_OFFSET 0x190
#define CAN0_CR2_DLC_MASK 0xF
#define CAN0_CR2_DLC_BIT 0
#define CAN0_CR2_IDE_MASK 0x10
#define CAN0_CR2_IDE 0x10
#define CAN0_CR2_IDE_BIT 4
#define CAN0_CR2_RPLYV_MASK 0x20
#define CAN0_CR2_RPLYV 0x20
#define CAN0_CR2_RPLYV_BIT 5
#define CAN0_CR2_PCB_MASK 0x40
#define CAN0_CR2_PCB 0x40
#define CAN0_CR2_PCB_BIT 6
#define CAN0_CR2_CHANEN_MASK 0x80
#define CAN0_CR2_CHANEN 0x80
#define CAN0_CR2_CHANEN_BIT 7
#define CAN0_CR2_OVERWRITE_MASK 0x100
#define CAN0_CR2_OVERWRITE 0x100
#define CAN0_CR2_OVERWRITE_BIT 8

#define CAN0_CR2 (*(volatile unsigned long *)0xFFFD4194)
#define CAN0_CR2_OFFSET 0x194
#define CAN0_CR2_STAMP_MASK 0x0
#define CAN0_CR2_STAMP_BIT 0

#define CAN0_CSR2 (*(volatile unsigned long *)0xFFFD4198)
#define CAN0_CSR2_OFFSET 0x198
#define CAN0_CSR2_ACK_MASK 0x1
#define CAN0_CSR2_ACK 0x1
#define CAN0_CSR2_ACK_BIT 0
#define CAN0_CSR2_FRAME_MASK 0x2
#define CAN0_CSR2_FRAME 0x2
#define CAN0_CSR2_FRAME_BIT 1
#define CAN0_CSR2_CRC_MASK 0x4
#define CAN0_CSR2_CRC 0x4
#define CAN0_CSR2_CRC_BIT 2
#define CAN0_CSR2_STUFF_MASK 0x8
#define CAN0_CSR2_STUFF 0x8
#define CAN0_CSR2_STUFF_BIT 3
#define CAN0_CSR2_BUS_MASK 0x10
#define CAN0_CSR2_BUS 0x10
#define CAN0_CSR2_BUS_BIT 4
#define CAN0_CSR2_RXOK_MASK 0x20
#define CAN0_CSR2_RXOK 0x20
#define CAN0_CSR2_RXOK_BIT 5
#define CAN0_CSR2_TXOK_MASK 0x40
#define CAN0_CSR2_TXOK 0x40
#define CAN0_CSR2_TXOK_BIT 6
#define CAN0_CSR2_RFRAME_MASK 0x80
#define CAN0_CSR2_RFRAME 0x80
#define CAN0_CSR2_RFRAME_BIT 7
#define CAN0_CSR2_DLCW_MASK 0x200
#define CAN0_CSR2_DLCW 0x200
#define CAN0_CSR2_DLCW_BIT 9
#define CAN0_CSR2_FILLED_MASK 0x400
#define CAN0_CSR2_FILLED 0x400
#define CAN0_CSR2_FILLED_BIT 10
#define CAN0_CSR2_OVRUN_MASK 0x800
#define CAN0_CSR2_OVRUN 0x800
#define CAN0_CSR2_OVRUN_BIT 11

#define CAN0_SR2 (*(volatile unsigned long *)0xFFFD419C)
#define CAN0_SR2_OFFSET 0x19C
#define CAN0_SR2_ACK_MASK 0x1
#define CAN0_SR2_ACK 0x1
#define CAN0_SR2_ACK_BIT 0
#define CAN0_SR2_FRAME_MASK 0x2
#define CAN0_SR2_FRAME 0x2
#define CAN0_SR2_FRAME_BIT 1
#define CAN0_SR2_CRC_MASK 0x4
#define CAN0_SR2_CRC 0x4
#define CAN0_SR2_CRC_BIT 2
#define CAN0_SR2_STUFF_MASK 0x8
#define CAN0_SR2_STUFF 0x8
#define CAN0_SR2_STUFF_BIT 3
#define CAN0_SR2_BUS_MASK 0x10
#define CAN0_SR2_BUS 0x10
#define CAN0_SR2_BUS_BIT 4
#define CAN0_SR2_RXOK_MASK 0x20
#define CAN0_SR2_RXOK 0x20
#define CAN0_SR2_RXOK_BIT 5
#define CAN0_SR2_TXOK_MASK 0x40
#define CAN0_SR2_TXOK 0x40
#define CAN0_SR2_TXOK_BIT 6
#define CAN0_SR2_RFRAME_MASK 0x80
#define CAN0_SR2_RFRAME 0x80
#define CAN0_SR2_RFRAME_BIT 7
#define CAN0_SR2_DLCW_MASK 0x200
#define CAN0_SR2_DLCW 0x200
#define CAN0_SR2_DLCW_BIT 9
#define CAN0_SR2_FILLED_MASK 0x400
#define CAN0_SR2_FILLED 0x400
#define CAN0_SR2_FILLED_BIT 10
#define CAN0_SR2_OVRUN_MASK 0x800
#define CAN0_SR2_OVRUN 0x800
#define CAN0_SR2_OVRUN_BIT 11

#define CAN0_IER2 (*(volatile unsigned long *)0xFFFD41A0)
#define CAN0_IER2_OFFSET 0x1A0
#define CAN0_IER2_ACK_MASK 0x1
#define CAN0_IER2_ACK 0x1
#define CAN0_IER2_ACK_BIT 0
#define CAN0_IER2_FRAME_MASK 0x2
#define CAN0_IER2_FRAME 0x2
#define CAN0_IER2_FRAME_BIT 1
#define CAN0_IER2_CRC_MASK 0x4
#define CAN0_IER2_CRC 0x4
#define CAN0_IER2_CRC_BIT 2
#define CAN0_IER2_STUFF_MASK 0x8
#define CAN0_IER2_STUFF 0x8
#define CAN0_IER2_STUFF_BIT 3
#define CAN0_IER2_BUS_MASK 0x10
#define CAN0_IER2_BUS 0x10
#define CAN0_IER2_BUS_BIT 4
#define CAN0_IER2_RXOK_MASK 0x20
#define CAN0_IER2_RXOK 0x20
#define CAN0_IER2_RXOK_BIT 5
#define CAN0_IER2_TXOK_MASK 0x40
#define CAN0_IER2_TXOK 0x40
#define CAN0_IER2_TXOK_BIT 6
#define CAN0_IER2_RFRAME_MASK 0x80
#define CAN0_IER2_RFRAME 0x80
#define CAN0_IER2_RFRAME_BIT 7

#define CAN0_IDR2 (*(volatile unsigned long *)0xFFFD41A4)
#define CAN0_IDR2_OFFSET 0x1A4
#define CAN0_IDR2_ACK_MASK 0x1
#define CAN0_IDR2_ACK 0x1
#define CAN0_IDR2_ACK_BIT 0
#define CAN0_IDR2_FRAME_MASK 0x2
#define CAN0_IDR2_FRAME 0x2
#define CAN0_IDR2_FRAME_BIT 1
#define CAN0_IDR2_CRC_MASK 0x4
#define CAN0_IDR2_CRC 0x4
#define CAN0_IDR2_CRC_BIT 2
#define CAN0_IDR2_STUFF_MASK 0x8
#define CAN0_IDR2_STUFF 0x8
#define CAN0_IDR2_STUFF_BIT 3
#define CAN0_IDR2_BUS_MASK 0x10
#define CAN0_IDR2_BUS 0x10
#define CAN0_IDR2_BUS_BIT 4
#define CAN0_IDR2_RXOK_MASK 0x20
#define CAN0_IDR2_RXOK 0x20
#define CAN0_IDR2_RXOK_BIT 5
#define CAN0_IDR2_TXOK_MASK 0x40
#define CAN0_IDR2_TXOK 0x40
#define CAN0_IDR2_TXOK_BIT 6
#define CAN0_IDR2_RFRAME_MASK 0x80
#define CAN0_IDR2_RFRAME 0x80
#define CAN0_IDR2_RFRAME_BIT 7

#define CAN0_IMR2 (*(volatile unsigned long *)0xFFFD41A8)
#define CAN0_IMR2_OFFSET 0x1A8
#define CAN0_IMR2_ACK_MASK 0x1
#define CAN0_IMR2_ACK 0x1
#define CAN0_IMR2_ACK_BIT 0
#define CAN0_IMR2_FRAME_MASK 0x2
#define CAN0_IMR2_FRAME 0x2
#define CAN0_IMR2_FRAME_BIT 1
#define CAN0_IMR2_CRC_MASK 0x4
#define CAN0_IMR2_CRC 0x4
#define CAN0_IMR2_CRC_BIT 2
#define CAN0_IMR2_STUFF_MASK 0x8
#define CAN0_IMR2_STUFF 0x8
#define CAN0_IMR2_STUFF_BIT 3
#define CAN0_IMR2_BUS_MASK 0x10
#define CAN0_IMR2_BUS 0x10
#define CAN0_IMR2_BUS_BIT 4
#define CAN0_IMR2_RXOK_MASK 0x20
#define CAN0_IMR2_RXOK 0x20
#define CAN0_IMR2_RXOK_BIT 5
#define CAN0_IMR2_TXOK_MASK 0x40
#define CAN0_IMR2_TXOK 0x40
#define CAN0_IMR2_TXOK_BIT 6
#define CAN0_IMR2_RFRAME_MASK 0x80
#define CAN0_IMR2_RFRAME 0x80
#define CAN0_IMR2_RFRAME_BIT 7

#define CAN0_DRA3 (*(volatile unsigned long *)0xFFFD41C0)
#define CAN0_DRA3_OFFSET 0x1C0
#define CAN0_DRA3_DATA0_MASK 0xFF
#define CAN0_DRA3_DATA0_BIT 0
#define CAN0_DRA3_DATA1_MASK 0xFF00
#define CAN0_DRA3_DATA1_BIT 8
#define CAN0_DRA3_DATA2_MASK 0xFF0000
#define CAN0_DRA3_DATA2_BIT 16
#define CAN0_DRA3_DATA3_MASK 0xFF000000
#define CAN0_DRA3_DATA3_BIT 24

#define CAN0_DRB3 (*(volatile unsigned long *)0xFFFD41C4)
#define CAN0_DRB3_OFFSET 0x1C4
#define CAN0_DRB3_DATA4_MASK 0xFF
#define CAN0_DRB3_DATA4_BIT 0
#define CAN0_DRB3_DATA5_MASK 0xFF00
#define CAN0_DRB3_DATA5_BIT 8
#define CAN0_DRB3_DATA6_MASK 0xFF0000
#define CAN0_DRB3_DATA6_BIT 16
#define CAN0_DRB3_DATA7_MASK 0xFF000000
#define CAN0_DRB3_DATA7_BIT 24

#define CAN0_MSK3 (*(volatile unsigned long *)0xFFFD41C8)
#define CAN0_MSK3_OFFSET 0x1C8
#define CAN0_MSK3_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK3_MASK_BIT 0
#define CAN0_MSK3_MRB_MASK 0x60000000
#define CAN0_MSK3_MRB_BIT 29
#define CAN0_MSK3_MRTR_MASK 0x80000000
#define CAN0_MSK3_MRTR 0x80000000
#define CAN0_MSK3_MRTR_BIT 31

#define CAN0_IR3 (*(volatile unsigned long *)0xFFFD41CC)
#define CAN0_IR3_OFFSET 0x1CC
#define CAN0_IR3_ID_MASK 0x1FFFFFFF
#define CAN0_IR3_ID_BIT 0
#define CAN0_IR3_RB_MASK 0x60000000
#define CAN0_IR3_RB_BIT 29
#define CAN0_IR3_RTR_MASK 0x80000000
#define CAN0_IR3_RTR 0x80000000
#define CAN0_IR3_RTR_BIT 31

#define CAN0_CR3 (*(volatile unsigned long *)0xFFFD41D0)
#define CAN0_CR3_OFFSET 0x1D0
#define CAN0_CR3_DLC_MASK 0xF
#define CAN0_CR3_DLC_BIT 0
#define CAN0_CR3_IDE_MASK 0x10
#define CAN0_CR3_IDE 0x10
#define CAN0_CR3_IDE_BIT 4
#define CAN0_CR3_RPLYV_MASK 0x20
#define CAN0_CR3_RPLYV 0x20
#define CAN0_CR3_RPLYV_BIT 5
#define CAN0_CR3_PCB_MASK 0x40
#define CAN0_CR3_PCB 0x40
#define CAN0_CR3_PCB_BIT 6
#define CAN0_CR3_CHANEN_MASK 0x80
#define CAN0_CR3_CHANEN 0x80
#define CAN0_CR3_CHANEN_BIT 7
#define CAN0_CR3_OVERWRITE_MASK 0x100
#define CAN0_CR3_OVERWRITE 0x100
#define CAN0_CR3_OVERWRITE_BIT 8

#define CAN0_CR3 (*(volatile unsigned long *)0xFFFD41D4)
#define CAN0_CR3_OFFSET 0x1D4
#define CAN0_CR3_STAMP_MASK 0x0
#define CAN0_CR3_STAMP_BIT 0

#define CAN0_CSR3 (*(volatile unsigned long *)0xFFFD41D8)
#define CAN0_CSR3_OFFSET 0x1D8
#define CAN0_CSR3_ACK_MASK 0x1
#define CAN0_CSR3_ACK 0x1
#define CAN0_CSR3_ACK_BIT 0
#define CAN0_CSR3_FRAME_MASK 0x2
#define CAN0_CSR3_FRAME 0x2
#define CAN0_CSR3_FRAME_BIT 1
#define CAN0_CSR3_CRC_MASK 0x4
#define CAN0_CSR3_CRC 0x4
#define CAN0_CSR3_CRC_BIT 2
#define CAN0_CSR3_STUFF_MASK 0x8
#define CAN0_CSR3_STUFF 0x8
#define CAN0_CSR3_STUFF_BIT 3
#define CAN0_CSR3_BUS_MASK 0x10
#define CAN0_CSR3_BUS 0x10
#define CAN0_CSR3_BUS_BIT 4
#define CAN0_CSR3_RXOK_MASK 0x20
#define CAN0_CSR3_RXOK 0x20
#define CAN0_CSR3_RXOK_BIT 5
#define CAN0_CSR3_TXOK_MASK 0x40
#define CAN0_CSR3_TXOK 0x40
#define CAN0_CSR3_TXOK_BIT 6
#define CAN0_CSR3_RFRAME_MASK 0x80
#define CAN0_CSR3_RFRAME 0x80
#define CAN0_CSR3_RFRAME_BIT 7
#define CAN0_CSR3_DLCW_MASK 0x200
#define CAN0_CSR3_DLCW 0x200
#define CAN0_CSR3_DLCW_BIT 9
#define CAN0_CSR3_FILLED_MASK 0x400
#define CAN0_CSR3_FILLED 0x400
#define CAN0_CSR3_FILLED_BIT 10
#define CAN0_CSR3_OVRUN_MASK 0x800
#define CAN0_CSR3_OVRUN 0x800
#define CAN0_CSR3_OVRUN_BIT 11

#define CAN0_SR3 (*(volatile unsigned long *)0xFFFD41DC)
#define CAN0_SR3_OFFSET 0x1DC
#define CAN0_SR3_ACK_MASK 0x1
#define CAN0_SR3_ACK 0x1
#define CAN0_SR3_ACK_BIT 0
#define CAN0_SR3_FRAME_MASK 0x2
#define CAN0_SR3_FRAME 0x2
#define CAN0_SR3_FRAME_BIT 1
#define CAN0_SR3_CRC_MASK 0x4
#define CAN0_SR3_CRC 0x4
#define CAN0_SR3_CRC_BIT 2
#define CAN0_SR3_STUFF_MASK 0x8
#define CAN0_SR3_STUFF 0x8
#define CAN0_SR3_STUFF_BIT 3
#define CAN0_SR3_BUS_MASK 0x10
#define CAN0_SR3_BUS 0x10
#define CAN0_SR3_BUS_BIT 4
#define CAN0_SR3_RXOK_MASK 0x20
#define CAN0_SR3_RXOK 0x20
#define CAN0_SR3_RXOK_BIT 5
#define CAN0_SR3_TXOK_MASK 0x40
#define CAN0_SR3_TXOK 0x40
#define CAN0_SR3_TXOK_BIT 6
#define CAN0_SR3_RFRAME_MASK 0x80
#define CAN0_SR3_RFRAME 0x80
#define CAN0_SR3_RFRAME_BIT 7
#define CAN0_SR3_DLCW_MASK 0x200
#define CAN0_SR3_DLCW 0x200
#define CAN0_SR3_DLCW_BIT 9
#define CAN0_SR3_FILLED_MASK 0x400
#define CAN0_SR3_FILLED 0x400
#define CAN0_SR3_FILLED_BIT 10
#define CAN0_SR3_OVRUN_MASK 0x800
#define CAN0_SR3_OVRUN 0x800
#define CAN0_SR3_OVRUN_BIT 11

#define CAN0_IER3 (*(volatile unsigned long *)0xFFFD41E0)
#define CAN0_IER3_OFFSET 0x1E0
#define CAN0_IER3_ACK_MASK 0x1
#define CAN0_IER3_ACK 0x1
#define CAN0_IER3_ACK_BIT 0
#define CAN0_IER3_FRAME_MASK 0x2
#define CAN0_IER3_FRAME 0x2
#define CAN0_IER3_FRAME_BIT 1
#define CAN0_IER3_CRC_MASK 0x4
#define CAN0_IER3_CRC 0x4
#define CAN0_IER3_CRC_BIT 2
#define CAN0_IER3_STUFF_MASK 0x8
#define CAN0_IER3_STUFF 0x8
#define CAN0_IER3_STUFF_BIT 3
#define CAN0_IER3_BUS_MASK 0x10
#define CAN0_IER3_BUS 0x10
#define CAN0_IER3_BUS_BIT 4
#define CAN0_IER3_RXOK_MASK 0x20
#define CAN0_IER3_RXOK 0x20
#define CAN0_IER3_RXOK_BIT 5
#define CAN0_IER3_TXOK_MASK 0x40
#define CAN0_IER3_TXOK 0x40
#define CAN0_IER3_TXOK_BIT 6
#define CAN0_IER3_RFRAME_MASK 0x80
#define CAN0_IER3_RFRAME 0x80
#define CAN0_IER3_RFRAME_BIT 7

#define CAN0_IDR3 (*(volatile unsigned long *)0xFFFD41E4)
#define CAN0_IDR3_OFFSET 0x1E4
#define CAN0_IDR3_ACK_MASK 0x1
#define CAN0_IDR3_ACK 0x1
#define CAN0_IDR3_ACK_BIT 0
#define CAN0_IDR3_FRAME_MASK 0x2
#define CAN0_IDR3_FRAME 0x2
#define CAN0_IDR3_FRAME_BIT 1
#define CAN0_IDR3_CRC_MASK 0x4
#define CAN0_IDR3_CRC 0x4
#define CAN0_IDR3_CRC_BIT 2
#define CAN0_IDR3_STUFF_MASK 0x8
#define CAN0_IDR3_STUFF 0x8
#define CAN0_IDR3_STUFF_BIT 3
#define CAN0_IDR3_BUS_MASK 0x10
#define CAN0_IDR3_BUS 0x10
#define CAN0_IDR3_BUS_BIT 4
#define CAN0_IDR3_RXOK_MASK 0x20
#define CAN0_IDR3_RXOK 0x20
#define CAN0_IDR3_RXOK_BIT 5
#define CAN0_IDR3_TXOK_MASK 0x40
#define CAN0_IDR3_TXOK 0x40
#define CAN0_IDR3_TXOK_BIT 6
#define CAN0_IDR3_RFRAME_MASK 0x80
#define CAN0_IDR3_RFRAME 0x80
#define CAN0_IDR3_RFRAME_BIT 7

#define CAN0_IMR3 (*(volatile unsigned long *)0xFFFD41E8)
#define CAN0_IMR3_OFFSET 0x1E8
#define CAN0_IMR3_ACK_MASK 0x1
#define CAN0_IMR3_ACK 0x1
#define CAN0_IMR3_ACK_BIT 0
#define CAN0_IMR3_FRAME_MASK 0x2
#define CAN0_IMR3_FRAME 0x2
#define CAN0_IMR3_FRAME_BIT 1
#define CAN0_IMR3_CRC_MASK 0x4
#define CAN0_IMR3_CRC 0x4
#define CAN0_IMR3_CRC_BIT 2
#define CAN0_IMR3_STUFF_MASK 0x8
#define CAN0_IMR3_STUFF 0x8
#define CAN0_IMR3_STUFF_BIT 3
#define CAN0_IMR3_BUS_MASK 0x10
#define CAN0_IMR3_BUS 0x10
#define CAN0_IMR3_BUS_BIT 4
#define CAN0_IMR3_RXOK_MASK 0x20
#define CAN0_IMR3_RXOK 0x20
#define CAN0_IMR3_RXOK_BIT 5
#define CAN0_IMR3_TXOK_MASK 0x40
#define CAN0_IMR3_TXOK 0x40
#define CAN0_IMR3_TXOK_BIT 6
#define CAN0_IMR3_RFRAME_MASK 0x80
#define CAN0_IMR3_RFRAME 0x80
#define CAN0_IMR3_RFRAME_BIT 7

#define CAN0_DRA4 (*(volatile unsigned long *)0xFFFD4200)
#define CAN0_DRA4_OFFSET 0x200
#define CAN0_DRA4_DATA0_MASK 0xFF
#define CAN0_DRA4_DATA0_BIT 0
#define CAN0_DRA4_DATA1_MASK 0xFF00
#define CAN0_DRA4_DATA1_BIT 8
#define CAN0_DRA4_DATA2_MASK 0xFF0000
#define CAN0_DRA4_DATA2_BIT 16
#define CAN0_DRA4_DATA3_MASK 0xFF000000
#define CAN0_DRA4_DATA3_BIT 24

#define CAN0_DRB4 (*(volatile unsigned long *)0xFFFD4204)
#define CAN0_DRB4_OFFSET 0x204
#define CAN0_DRB4_DATA4_MASK 0xFF
#define CAN0_DRB4_DATA4_BIT 0
#define CAN0_DRB4_DATA5_MASK 0xFF00
#define CAN0_DRB4_DATA5_BIT 8
#define CAN0_DRB4_DATA6_MASK 0xFF0000
#define CAN0_DRB4_DATA6_BIT 16
#define CAN0_DRB4_DATA7_MASK 0xFF000000
#define CAN0_DRB4_DATA7_BIT 24

#define CAN0_MSK4 (*(volatile unsigned long *)0xFFFD4208)
#define CAN0_MSK4_OFFSET 0x208
#define CAN0_MSK4_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK4_MASK_BIT 0
#define CAN0_MSK4_MRB_MASK 0x60000000
#define CAN0_MSK4_MRB_BIT 29
#define CAN0_MSK4_MRTR_MASK 0x80000000
#define CAN0_MSK4_MRTR 0x80000000
#define CAN0_MSK4_MRTR_BIT 31

#define CAN0_IR4 (*(volatile unsigned long *)0xFFFD420C)
#define CAN0_IR4_OFFSET 0x20C
#define CAN0_IR4_ID_MASK 0x1FFFFFFF
#define CAN0_IR4_ID_BIT 0
#define CAN0_IR4_RB_MASK 0x60000000
#define CAN0_IR4_RB_BIT 29
#define CAN0_IR4_RTR_MASK 0x80000000
#define CAN0_IR4_RTR 0x80000000
#define CAN0_IR4_RTR_BIT 31

#define CAN0_CR4 (*(volatile unsigned long *)0xFFFD4210)
#define CAN0_CR4_OFFSET 0x210
#define CAN0_CR4_DLC_MASK 0xF
#define CAN0_CR4_DLC_BIT 0
#define CAN0_CR4_IDE_MASK 0x10
#define CAN0_CR4_IDE 0x10
#define CAN0_CR4_IDE_BIT 4
#define CAN0_CR4_RPLYV_MASK 0x20
#define CAN0_CR4_RPLYV 0x20
#define CAN0_CR4_RPLYV_BIT 5
#define CAN0_CR4_PCB_MASK 0x40
#define CAN0_CR4_PCB 0x40
#define CAN0_CR4_PCB_BIT 6
#define CAN0_CR4_CHANEN_MASK 0x80
#define CAN0_CR4_CHANEN 0x80
#define CAN0_CR4_CHANEN_BIT 7
#define CAN0_CR4_OVERWRITE_MASK 0x100
#define CAN0_CR4_OVERWRITE 0x100
#define CAN0_CR4_OVERWRITE_BIT 8

#define CAN0_CR4 (*(volatile unsigned long *)0xFFFD4214)
#define CAN0_CR4_OFFSET 0x214
#define CAN0_CR4_STAMP_MASK 0x0
#define CAN0_CR4_STAMP_BIT 0

#define CAN0_CSR4 (*(volatile unsigned long *)0xFFFD4218)
#define CAN0_CSR4_OFFSET 0x218
#define CAN0_CSR4_ACK_MASK 0x1
#define CAN0_CSR4_ACK 0x1
#define CAN0_CSR4_ACK_BIT 0
#define CAN0_CSR4_FRAME_MASK 0x2
#define CAN0_CSR4_FRAME 0x2
#define CAN0_CSR4_FRAME_BIT 1
#define CAN0_CSR4_CRC_MASK 0x4
#define CAN0_CSR4_CRC 0x4
#define CAN0_CSR4_CRC_BIT 2
#define CAN0_CSR4_STUFF_MASK 0x8
#define CAN0_CSR4_STUFF 0x8
#define CAN0_CSR4_STUFF_BIT 3
#define CAN0_CSR4_BUS_MASK 0x10
#define CAN0_CSR4_BUS 0x10
#define CAN0_CSR4_BUS_BIT 4
#define CAN0_CSR4_RXOK_MASK 0x20
#define CAN0_CSR4_RXOK 0x20
#define CAN0_CSR4_RXOK_BIT 5
#define CAN0_CSR4_TXOK_MASK 0x40
#define CAN0_CSR4_TXOK 0x40
#define CAN0_CSR4_TXOK_BIT 6
#define CAN0_CSR4_RFRAME_MASK 0x80
#define CAN0_CSR4_RFRAME 0x80
#define CAN0_CSR4_RFRAME_BIT 7
#define CAN0_CSR4_DLCW_MASK 0x200
#define CAN0_CSR4_DLCW 0x200
#define CAN0_CSR4_DLCW_BIT 9
#define CAN0_CSR4_FILLED_MASK 0x400
#define CAN0_CSR4_FILLED 0x400
#define CAN0_CSR4_FILLED_BIT 10
#define CAN0_CSR4_OVRUN_MASK 0x800
#define CAN0_CSR4_OVRUN 0x800
#define CAN0_CSR4_OVRUN_BIT 11

#define CAN0_SR4 (*(volatile unsigned long *)0xFFFD421C)
#define CAN0_SR4_OFFSET 0x21C
#define CAN0_SR4_ACK_MASK 0x1
#define CAN0_SR4_ACK 0x1
#define CAN0_SR4_ACK_BIT 0
#define CAN0_SR4_FRAME_MASK 0x2
#define CAN0_SR4_FRAME 0x2
#define CAN0_SR4_FRAME_BIT 1
#define CAN0_SR4_CRC_MASK 0x4
#define CAN0_SR4_CRC 0x4
#define CAN0_SR4_CRC_BIT 2
#define CAN0_SR4_STUFF_MASK 0x8
#define CAN0_SR4_STUFF 0x8
#define CAN0_SR4_STUFF_BIT 3
#define CAN0_SR4_BUS_MASK 0x10
#define CAN0_SR4_BUS 0x10
#define CAN0_SR4_BUS_BIT 4
#define CAN0_SR4_RXOK_MASK 0x20
#define CAN0_SR4_RXOK 0x20
#define CAN0_SR4_RXOK_BIT 5
#define CAN0_SR4_TXOK_MASK 0x40
#define CAN0_SR4_TXOK 0x40
#define CAN0_SR4_TXOK_BIT 6
#define CAN0_SR4_RFRAME_MASK 0x80
#define CAN0_SR4_RFRAME 0x80
#define CAN0_SR4_RFRAME_BIT 7
#define CAN0_SR4_DLCW_MASK 0x200
#define CAN0_SR4_DLCW 0x200
#define CAN0_SR4_DLCW_BIT 9
#define CAN0_SR4_FILLED_MASK 0x400
#define CAN0_SR4_FILLED 0x400
#define CAN0_SR4_FILLED_BIT 10
#define CAN0_SR4_OVRUN_MASK 0x800
#define CAN0_SR4_OVRUN 0x800
#define CAN0_SR4_OVRUN_BIT 11

#define CAN0_IER4 (*(volatile unsigned long *)0xFFFD4220)
#define CAN0_IER4_OFFSET 0x220
#define CAN0_IER4_ACK_MASK 0x1
#define CAN0_IER4_ACK 0x1
#define CAN0_IER4_ACK_BIT 0
#define CAN0_IER4_FRAME_MASK 0x2
#define CAN0_IER4_FRAME 0x2
#define CAN0_IER4_FRAME_BIT 1
#define CAN0_IER4_CRC_MASK 0x4
#define CAN0_IER4_CRC 0x4
#define CAN0_IER4_CRC_BIT 2
#define CAN0_IER4_STUFF_MASK 0x8
#define CAN0_IER4_STUFF 0x8
#define CAN0_IER4_STUFF_BIT 3
#define CAN0_IER4_BUS_MASK 0x10
#define CAN0_IER4_BUS 0x10
#define CAN0_IER4_BUS_BIT 4
#define CAN0_IER4_RXOK_MASK 0x20
#define CAN0_IER4_RXOK 0x20
#define CAN0_IER4_RXOK_BIT 5
#define CAN0_IER4_TXOK_MASK 0x40
#define CAN0_IER4_TXOK 0x40
#define CAN0_IER4_TXOK_BIT 6
#define CAN0_IER4_RFRAME_MASK 0x80
#define CAN0_IER4_RFRAME 0x80
#define CAN0_IER4_RFRAME_BIT 7

#define CAN0_IDR4 (*(volatile unsigned long *)0xFFFD4224)
#define CAN0_IDR4_OFFSET 0x224
#define CAN0_IDR4_ACK_MASK 0x1
#define CAN0_IDR4_ACK 0x1
#define CAN0_IDR4_ACK_BIT 0
#define CAN0_IDR4_FRAME_MASK 0x2
#define CAN0_IDR4_FRAME 0x2
#define CAN0_IDR4_FRAME_BIT 1
#define CAN0_IDR4_CRC_MASK 0x4
#define CAN0_IDR4_CRC 0x4
#define CAN0_IDR4_CRC_BIT 2
#define CAN0_IDR4_STUFF_MASK 0x8
#define CAN0_IDR4_STUFF 0x8
#define CAN0_IDR4_STUFF_BIT 3
#define CAN0_IDR4_BUS_MASK 0x10
#define CAN0_IDR4_BUS 0x10
#define CAN0_IDR4_BUS_BIT 4
#define CAN0_IDR4_RXOK_MASK 0x20
#define CAN0_IDR4_RXOK 0x20
#define CAN0_IDR4_RXOK_BIT 5
#define CAN0_IDR4_TXOK_MASK 0x40
#define CAN0_IDR4_TXOK 0x40
#define CAN0_IDR4_TXOK_BIT 6
#define CAN0_IDR4_RFRAME_MASK 0x80
#define CAN0_IDR4_RFRAME 0x80
#define CAN0_IDR4_RFRAME_BIT 7

#define CAN0_IMR4 (*(volatile unsigned long *)0xFFFD4228)
#define CAN0_IMR4_OFFSET 0x228
#define CAN0_IMR4_ACK_MASK 0x1
#define CAN0_IMR4_ACK 0x1
#define CAN0_IMR4_ACK_BIT 0
#define CAN0_IMR4_FRAME_MASK 0x2
#define CAN0_IMR4_FRAME 0x2
#define CAN0_IMR4_FRAME_BIT 1
#define CAN0_IMR4_CRC_MASK 0x4
#define CAN0_IMR4_CRC 0x4
#define CAN0_IMR4_CRC_BIT 2
#define CAN0_IMR4_STUFF_MASK 0x8
#define CAN0_IMR4_STUFF 0x8
#define CAN0_IMR4_STUFF_BIT 3
#define CAN0_IMR4_BUS_MASK 0x10
#define CAN0_IMR4_BUS 0x10
#define CAN0_IMR4_BUS_BIT 4
#define CAN0_IMR4_RXOK_MASK 0x20
#define CAN0_IMR4_RXOK 0x20
#define CAN0_IMR4_RXOK_BIT 5
#define CAN0_IMR4_TXOK_MASK 0x40
#define CAN0_IMR4_TXOK 0x40
#define CAN0_IMR4_TXOK_BIT 6
#define CAN0_IMR4_RFRAME_MASK 0x80
#define CAN0_IMR4_RFRAME 0x80
#define CAN0_IMR4_RFRAME_BIT 7

#define CAN0_DRA5 (*(volatile unsigned long *)0xFFFD4240)
#define CAN0_DRA5_OFFSET 0x240
#define CAN0_DRA5_DATA0_MASK 0xFF
#define CAN0_DRA5_DATA0_BIT 0
#define CAN0_DRA5_DATA1_MASK 0xFF00
#define CAN0_DRA5_DATA1_BIT 8
#define CAN0_DRA5_DATA2_MASK 0xFF0000
#define CAN0_DRA5_DATA2_BIT 16
#define CAN0_DRA5_DATA3_MASK 0xFF000000
#define CAN0_DRA5_DATA3_BIT 24

#define CAN0_DRB5 (*(volatile unsigned long *)0xFFFD4244)
#define CAN0_DRB5_OFFSET 0x244
#define CAN0_DRB5_DATA4_MASK 0xFF
#define CAN0_DRB5_DATA4_BIT 0
#define CAN0_DRB5_DATA5_MASK 0xFF00
#define CAN0_DRB5_DATA5_BIT 8
#define CAN0_DRB5_DATA6_MASK 0xFF0000
#define CAN0_DRB5_DATA6_BIT 16
#define CAN0_DRB5_DATA7_MASK 0xFF000000
#define CAN0_DRB5_DATA7_BIT 24

#define CAN0_MSK5 (*(volatile unsigned long *)0xFFFD4248)
#define CAN0_MSK5_OFFSET 0x248
#define CAN0_MSK5_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK5_MASK_BIT 0
#define CAN0_MSK5_MRB_MASK 0x60000000
#define CAN0_MSK5_MRB_BIT 29
#define CAN0_MSK5_MRTR_MASK 0x80000000
#define CAN0_MSK5_MRTR 0x80000000
#define CAN0_MSK5_MRTR_BIT 31

#define CAN0_IR5 (*(volatile unsigned long *)0xFFFD424C)
#define CAN0_IR5_OFFSET 0x24C
#define CAN0_IR5_ID_MASK 0x1FFFFFFF
#define CAN0_IR5_ID_BIT 0
#define CAN0_IR5_RB_MASK 0x60000000
#define CAN0_IR5_RB_BIT 29
#define CAN0_IR5_RTR_MASK 0x80000000
#define CAN0_IR5_RTR 0x80000000
#define CAN0_IR5_RTR_BIT 31

#define CAN0_CR5 (*(volatile unsigned long *)0xFFFD4250)
#define CAN0_CR5_OFFSET 0x250
#define CAN0_CR5_DLC_MASK 0xF
#define CAN0_CR5_DLC_BIT 0
#define CAN0_CR5_IDE_MASK 0x10
#define CAN0_CR5_IDE 0x10
#define CAN0_CR5_IDE_BIT 4
#define CAN0_CR5_RPLYV_MASK 0x20
#define CAN0_CR5_RPLYV 0x20
#define CAN0_CR5_RPLYV_BIT 5
#define CAN0_CR5_PCB_MASK 0x40
#define CAN0_CR5_PCB 0x40
#define CAN0_CR5_PCB_BIT 6
#define CAN0_CR5_CHANEN_MASK 0x80
#define CAN0_CR5_CHANEN 0x80
#define CAN0_CR5_CHANEN_BIT 7
#define CAN0_CR5_OVERWRITE_MASK 0x100
#define CAN0_CR5_OVERWRITE 0x100
#define CAN0_CR5_OVERWRITE_BIT 8

#define CAN0_CR5 (*(volatile unsigned long *)0xFFFD4254)
#define CAN0_CR5_OFFSET 0x254
#define CAN0_CR5_STAMP_MASK 0x0
#define CAN0_CR5_STAMP_BIT 0

#define CAN0_CSR5 (*(volatile unsigned long *)0xFFFD4258)
#define CAN0_CSR5_OFFSET 0x258
#define CAN0_CSR5_ACK_MASK 0x1
#define CAN0_CSR5_ACK 0x1
#define CAN0_CSR5_ACK_BIT 0
#define CAN0_CSR5_FRAME_MASK 0x2
#define CAN0_CSR5_FRAME 0x2
#define CAN0_CSR5_FRAME_BIT 1
#define CAN0_CSR5_CRC_MASK 0x4
#define CAN0_CSR5_CRC 0x4
#define CAN0_CSR5_CRC_BIT 2
#define CAN0_CSR5_STUFF_MASK 0x8
#define CAN0_CSR5_STUFF 0x8
#define CAN0_CSR5_STUFF_BIT 3
#define CAN0_CSR5_BUS_MASK 0x10
#define CAN0_CSR5_BUS 0x10
#define CAN0_CSR5_BUS_BIT 4
#define CAN0_CSR5_RXOK_MASK 0x20
#define CAN0_CSR5_RXOK 0x20
#define CAN0_CSR5_RXOK_BIT 5
#define CAN0_CSR5_TXOK_MASK 0x40
#define CAN0_CSR5_TXOK 0x40
#define CAN0_CSR5_TXOK_BIT 6
#define CAN0_CSR5_RFRAME_MASK 0x80
#define CAN0_CSR5_RFRAME 0x80
#define CAN0_CSR5_RFRAME_BIT 7
#define CAN0_CSR5_DLCW_MASK 0x200
#define CAN0_CSR5_DLCW 0x200
#define CAN0_CSR5_DLCW_BIT 9
#define CAN0_CSR5_FILLED_MASK 0x400
#define CAN0_CSR5_FILLED 0x400
#define CAN0_CSR5_FILLED_BIT 10
#define CAN0_CSR5_OVRUN_MASK 0x800
#define CAN0_CSR5_OVRUN 0x800
#define CAN0_CSR5_OVRUN_BIT 11

#define CAN0_SR5 (*(volatile unsigned long *)0xFFFD425C)
#define CAN0_SR5_OFFSET 0x25C
#define CAN0_SR5_ACK_MASK 0x1
#define CAN0_SR5_ACK 0x1
#define CAN0_SR5_ACK_BIT 0
#define CAN0_SR5_FRAME_MASK 0x2
#define CAN0_SR5_FRAME 0x2
#define CAN0_SR5_FRAME_BIT 1
#define CAN0_SR5_CRC_MASK 0x4
#define CAN0_SR5_CRC 0x4
#define CAN0_SR5_CRC_BIT 2
#define CAN0_SR5_STUFF_MASK 0x8
#define CAN0_SR5_STUFF 0x8
#define CAN0_SR5_STUFF_BIT 3
#define CAN0_SR5_BUS_MASK 0x10
#define CAN0_SR5_BUS 0x10
#define CAN0_SR5_BUS_BIT 4
#define CAN0_SR5_RXOK_MASK 0x20
#define CAN0_SR5_RXOK 0x20
#define CAN0_SR5_RXOK_BIT 5
#define CAN0_SR5_TXOK_MASK 0x40
#define CAN0_SR5_TXOK 0x40
#define CAN0_SR5_TXOK_BIT 6
#define CAN0_SR5_RFRAME_MASK 0x80
#define CAN0_SR5_RFRAME 0x80
#define CAN0_SR5_RFRAME_BIT 7
#define CAN0_SR5_DLCW_MASK 0x200
#define CAN0_SR5_DLCW 0x200
#define CAN0_SR5_DLCW_BIT 9
#define CAN0_SR5_FILLED_MASK 0x400
#define CAN0_SR5_FILLED 0x400
#define CAN0_SR5_FILLED_BIT 10
#define CAN0_SR5_OVRUN_MASK 0x800
#define CAN0_SR5_OVRUN 0x800
#define CAN0_SR5_OVRUN_BIT 11

#define CAN0_IER5 (*(volatile unsigned long *)0xFFFD4260)
#define CAN0_IER5_OFFSET 0x260
#define CAN0_IER5_ACK_MASK 0x1
#define CAN0_IER5_ACK 0x1
#define CAN0_IER5_ACK_BIT 0
#define CAN0_IER5_FRAME_MASK 0x2
#define CAN0_IER5_FRAME 0x2
#define CAN0_IER5_FRAME_BIT 1
#define CAN0_IER5_CRC_MASK 0x4
#define CAN0_IER5_CRC 0x4
#define CAN0_IER5_CRC_BIT 2
#define CAN0_IER5_STUFF_MASK 0x8
#define CAN0_IER5_STUFF 0x8
#define CAN0_IER5_STUFF_BIT 3
#define CAN0_IER5_BUS_MASK 0x10
#define CAN0_IER5_BUS 0x10
#define CAN0_IER5_BUS_BIT 4
#define CAN0_IER5_RXOK_MASK 0x20
#define CAN0_IER5_RXOK 0x20
#define CAN0_IER5_RXOK_BIT 5
#define CAN0_IER5_TXOK_MASK 0x40
#define CAN0_IER5_TXOK 0x40
#define CAN0_IER5_TXOK_BIT 6
#define CAN0_IER5_RFRAME_MASK 0x80
#define CAN0_IER5_RFRAME 0x80
#define CAN0_IER5_RFRAME_BIT 7

#define CAN0_IDR5 (*(volatile unsigned long *)0xFFFD4264)
#define CAN0_IDR5_OFFSET 0x264
#define CAN0_IDR5_ACK_MASK 0x1
#define CAN0_IDR5_ACK 0x1
#define CAN0_IDR5_ACK_BIT 0
#define CAN0_IDR5_FRAME_MASK 0x2
#define CAN0_IDR5_FRAME 0x2
#define CAN0_IDR5_FRAME_BIT 1
#define CAN0_IDR5_CRC_MASK 0x4
#define CAN0_IDR5_CRC 0x4
#define CAN0_IDR5_CRC_BIT 2
#define CAN0_IDR5_STUFF_MASK 0x8
#define CAN0_IDR5_STUFF 0x8
#define CAN0_IDR5_STUFF_BIT 3
#define CAN0_IDR5_BUS_MASK 0x10
#define CAN0_IDR5_BUS 0x10
#define CAN0_IDR5_BUS_BIT 4
#define CAN0_IDR5_RXOK_MASK 0x20
#define CAN0_IDR5_RXOK 0x20
#define CAN0_IDR5_RXOK_BIT 5
#define CAN0_IDR5_TXOK_MASK 0x40
#define CAN0_IDR5_TXOK 0x40
#define CAN0_IDR5_TXOK_BIT 6
#define CAN0_IDR5_RFRAME_MASK 0x80
#define CAN0_IDR5_RFRAME 0x80
#define CAN0_IDR5_RFRAME_BIT 7

#define CAN0_IMR5 (*(volatile unsigned long *)0xFFFD4268)
#define CAN0_IMR5_OFFSET 0x268
#define CAN0_IMR5_ACK_MASK 0x1
#define CAN0_IMR5_ACK 0x1
#define CAN0_IMR5_ACK_BIT 0
#define CAN0_IMR5_FRAME_MASK 0x2
#define CAN0_IMR5_FRAME 0x2
#define CAN0_IMR5_FRAME_BIT 1
#define CAN0_IMR5_CRC_MASK 0x4
#define CAN0_IMR5_CRC 0x4
#define CAN0_IMR5_CRC_BIT 2
#define CAN0_IMR5_STUFF_MASK 0x8
#define CAN0_IMR5_STUFF 0x8
#define CAN0_IMR5_STUFF_BIT 3
#define CAN0_IMR5_BUS_MASK 0x10
#define CAN0_IMR5_BUS 0x10
#define CAN0_IMR5_BUS_BIT 4
#define CAN0_IMR5_RXOK_MASK 0x20
#define CAN0_IMR5_RXOK 0x20
#define CAN0_IMR5_RXOK_BIT 5
#define CAN0_IMR5_TXOK_MASK 0x40
#define CAN0_IMR5_TXOK 0x40
#define CAN0_IMR5_TXOK_BIT 6
#define CAN0_IMR5_RFRAME_MASK 0x80
#define CAN0_IMR5_RFRAME 0x80
#define CAN0_IMR5_RFRAME_BIT 7

#define CAN0_DRA6 (*(volatile unsigned long *)0xFFFD4280)
#define CAN0_DRA6_OFFSET 0x280
#define CAN0_DRA6_DATA0_MASK 0xFF
#define CAN0_DRA6_DATA0_BIT 0
#define CAN0_DRA6_DATA1_MASK 0xFF00
#define CAN0_DRA6_DATA1_BIT 8
#define CAN0_DRA6_DATA2_MASK 0xFF0000
#define CAN0_DRA6_DATA2_BIT 16
#define CAN0_DRA6_DATA3_MASK 0xFF000000
#define CAN0_DRA6_DATA3_BIT 24

#define CAN0_DRB6 (*(volatile unsigned long *)0xFFFD4284)
#define CAN0_DRB6_OFFSET 0x284
#define CAN0_DRB6_DATA4_MASK 0xFF
#define CAN0_DRB6_DATA4_BIT 0
#define CAN0_DRB6_DATA5_MASK 0xFF00
#define CAN0_DRB6_DATA5_BIT 8
#define CAN0_DRB6_DATA6_MASK 0xFF0000
#define CAN0_DRB6_DATA6_BIT 16
#define CAN0_DRB6_DATA7_MASK 0xFF000000
#define CAN0_DRB6_DATA7_BIT 24

#define CAN0_MSK6 (*(volatile unsigned long *)0xFFFD4288)
#define CAN0_MSK6_OFFSET 0x288
#define CAN0_MSK6_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK6_MASK_BIT 0
#define CAN0_MSK6_MRB_MASK 0x60000000
#define CAN0_MSK6_MRB_BIT 29
#define CAN0_MSK6_MRTR_MASK 0x80000000
#define CAN0_MSK6_MRTR 0x80000000
#define CAN0_MSK6_MRTR_BIT 31

#define CAN0_IR6 (*(volatile unsigned long *)0xFFFD428C)
#define CAN0_IR6_OFFSET 0x28C
#define CAN0_IR6_ID_MASK 0x1FFFFFFF
#define CAN0_IR6_ID_BIT 0
#define CAN0_IR6_RB_MASK 0x60000000
#define CAN0_IR6_RB_BIT 29
#define CAN0_IR6_RTR_MASK 0x80000000
#define CAN0_IR6_RTR 0x80000000
#define CAN0_IR6_RTR_BIT 31

#define CAN0_CR6 (*(volatile unsigned long *)0xFFFD4290)
#define CAN0_CR6_OFFSET 0x290
#define CAN0_CR6_DLC_MASK 0xF
#define CAN0_CR6_DLC_BIT 0
#define CAN0_CR6_IDE_MASK 0x10
#define CAN0_CR6_IDE 0x10
#define CAN0_CR6_IDE_BIT 4
#define CAN0_CR6_RPLYV_MASK 0x20
#define CAN0_CR6_RPLYV 0x20
#define CAN0_CR6_RPLYV_BIT 5
#define CAN0_CR6_PCB_MASK 0x40
#define CAN0_CR6_PCB 0x40
#define CAN0_CR6_PCB_BIT 6
#define CAN0_CR6_CHANEN_MASK 0x80
#define CAN0_CR6_CHANEN 0x80
#define CAN0_CR6_CHANEN_BIT 7
#define CAN0_CR6_OVERWRITE_MASK 0x100
#define CAN0_CR6_OVERWRITE 0x100
#define CAN0_CR6_OVERWRITE_BIT 8

#define CAN0_CR6 (*(volatile unsigned long *)0xFFFD4294)
#define CAN0_CR6_OFFSET 0x294
#define CAN0_CR6_STAMP_MASK 0x0
#define CAN0_CR6_STAMP_BIT 0

#define CAN0_CSR6 (*(volatile unsigned long *)0xFFFD4298)
#define CAN0_CSR6_OFFSET 0x298
#define CAN0_CSR6_ACK_MASK 0x1
#define CAN0_CSR6_ACK 0x1
#define CAN0_CSR6_ACK_BIT 0
#define CAN0_CSR6_FRAME_MASK 0x2
#define CAN0_CSR6_FRAME 0x2
#define CAN0_CSR6_FRAME_BIT 1
#define CAN0_CSR6_CRC_MASK 0x4
#define CAN0_CSR6_CRC 0x4
#define CAN0_CSR6_CRC_BIT 2
#define CAN0_CSR6_STUFF_MASK 0x8
#define CAN0_CSR6_STUFF 0x8
#define CAN0_CSR6_STUFF_BIT 3
#define CAN0_CSR6_BUS_MASK 0x10
#define CAN0_CSR6_BUS 0x10
#define CAN0_CSR6_BUS_BIT 4
#define CAN0_CSR6_RXOK_MASK 0x20
#define CAN0_CSR6_RXOK 0x20
#define CAN0_CSR6_RXOK_BIT 5
#define CAN0_CSR6_TXOK_MASK 0x40
#define CAN0_CSR6_TXOK 0x40
#define CAN0_CSR6_TXOK_BIT 6
#define CAN0_CSR6_RFRAME_MASK 0x80
#define CAN0_CSR6_RFRAME 0x80
#define CAN0_CSR6_RFRAME_BIT 7
#define CAN0_CSR6_DLCW_MASK 0x200
#define CAN0_CSR6_DLCW 0x200
#define CAN0_CSR6_DLCW_BIT 9
#define CAN0_CSR6_FILLED_MASK 0x400
#define CAN0_CSR6_FILLED 0x400
#define CAN0_CSR6_FILLED_BIT 10
#define CAN0_CSR6_OVRUN_MASK 0x800
#define CAN0_CSR6_OVRUN 0x800
#define CAN0_CSR6_OVRUN_BIT 11

#define CAN0_SR6 (*(volatile unsigned long *)0xFFFD429C)
#define CAN0_SR6_OFFSET 0x29C
#define CAN0_SR6_ACK_MASK 0x1
#define CAN0_SR6_ACK 0x1
#define CAN0_SR6_ACK_BIT 0
#define CAN0_SR6_FRAME_MASK 0x2
#define CAN0_SR6_FRAME 0x2
#define CAN0_SR6_FRAME_BIT 1
#define CAN0_SR6_CRC_MASK 0x4
#define CAN0_SR6_CRC 0x4
#define CAN0_SR6_CRC_BIT 2
#define CAN0_SR6_STUFF_MASK 0x8
#define CAN0_SR6_STUFF 0x8
#define CAN0_SR6_STUFF_BIT 3
#define CAN0_SR6_BUS_MASK 0x10
#define CAN0_SR6_BUS 0x10
#define CAN0_SR6_BUS_BIT 4
#define CAN0_SR6_RXOK_MASK 0x20
#define CAN0_SR6_RXOK 0x20
#define CAN0_SR6_RXOK_BIT 5
#define CAN0_SR6_TXOK_MASK 0x40
#define CAN0_SR6_TXOK 0x40
#define CAN0_SR6_TXOK_BIT 6
#define CAN0_SR6_RFRAME_MASK 0x80
#define CAN0_SR6_RFRAME 0x80
#define CAN0_SR6_RFRAME_BIT 7
#define CAN0_SR6_DLCW_MASK 0x200
#define CAN0_SR6_DLCW 0x200
#define CAN0_SR6_DLCW_BIT 9
#define CAN0_SR6_FILLED_MASK 0x400
#define CAN0_SR6_FILLED 0x400
#define CAN0_SR6_FILLED_BIT 10
#define CAN0_SR6_OVRUN_MASK 0x800
#define CAN0_SR6_OVRUN 0x800
#define CAN0_SR6_OVRUN_BIT 11

#define CAN0_IER6 (*(volatile unsigned long *)0xFFFD42A0)
#define CAN0_IER6_OFFSET 0x2A0
#define CAN0_IER6_ACK_MASK 0x1
#define CAN0_IER6_ACK 0x1
#define CAN0_IER6_ACK_BIT 0
#define CAN0_IER6_FRAME_MASK 0x2
#define CAN0_IER6_FRAME 0x2
#define CAN0_IER6_FRAME_BIT 1
#define CAN0_IER6_CRC_MASK 0x4
#define CAN0_IER6_CRC 0x4
#define CAN0_IER6_CRC_BIT 2
#define CAN0_IER6_STUFF_MASK 0x8
#define CAN0_IER6_STUFF 0x8
#define CAN0_IER6_STUFF_BIT 3
#define CAN0_IER6_BUS_MASK 0x10
#define CAN0_IER6_BUS 0x10
#define CAN0_IER6_BUS_BIT 4
#define CAN0_IER6_RXOK_MASK 0x20
#define CAN0_IER6_RXOK 0x20
#define CAN0_IER6_RXOK_BIT 5
#define CAN0_IER6_TXOK_MASK 0x40
#define CAN0_IER6_TXOK 0x40
#define CAN0_IER6_TXOK_BIT 6
#define CAN0_IER6_RFRAME_MASK 0x80
#define CAN0_IER6_RFRAME 0x80
#define CAN0_IER6_RFRAME_BIT 7

#define CAN0_IDR6 (*(volatile unsigned long *)0xFFFD42A4)
#define CAN0_IDR6_OFFSET 0x2A4
#define CAN0_IDR6_ACK_MASK 0x1
#define CAN0_IDR6_ACK 0x1
#define CAN0_IDR6_ACK_BIT 0
#define CAN0_IDR6_FRAME_MASK 0x2
#define CAN0_IDR6_FRAME 0x2
#define CAN0_IDR6_FRAME_BIT 1
#define CAN0_IDR6_CRC_MASK 0x4
#define CAN0_IDR6_CRC 0x4
#define CAN0_IDR6_CRC_BIT 2
#define CAN0_IDR6_STUFF_MASK 0x8
#define CAN0_IDR6_STUFF 0x8
#define CAN0_IDR6_STUFF_BIT 3
#define CAN0_IDR6_BUS_MASK 0x10
#define CAN0_IDR6_BUS 0x10
#define CAN0_IDR6_BUS_BIT 4
#define CAN0_IDR6_RXOK_MASK 0x20
#define CAN0_IDR6_RXOK 0x20
#define CAN0_IDR6_RXOK_BIT 5
#define CAN0_IDR6_TXOK_MASK 0x40
#define CAN0_IDR6_TXOK 0x40
#define CAN0_IDR6_TXOK_BIT 6
#define CAN0_IDR6_RFRAME_MASK 0x80
#define CAN0_IDR6_RFRAME 0x80
#define CAN0_IDR6_RFRAME_BIT 7

#define CAN0_IMR6 (*(volatile unsigned long *)0xFFFD42A8)
#define CAN0_IMR6_OFFSET 0x2A8
#define CAN0_IMR6_ACK_MASK 0x1
#define CAN0_IMR6_ACK 0x1
#define CAN0_IMR6_ACK_BIT 0
#define CAN0_IMR6_FRAME_MASK 0x2
#define CAN0_IMR6_FRAME 0x2
#define CAN0_IMR6_FRAME_BIT 1
#define CAN0_IMR6_CRC_MASK 0x4
#define CAN0_IMR6_CRC 0x4
#define CAN0_IMR6_CRC_BIT 2
#define CAN0_IMR6_STUFF_MASK 0x8
#define CAN0_IMR6_STUFF 0x8
#define CAN0_IMR6_STUFF_BIT 3
#define CAN0_IMR6_BUS_MASK 0x10
#define CAN0_IMR6_BUS 0x10
#define CAN0_IMR6_BUS_BIT 4
#define CAN0_IMR6_RXOK_MASK 0x20
#define CAN0_IMR6_RXOK 0x20
#define CAN0_IMR6_RXOK_BIT 5
#define CAN0_IMR6_TXOK_MASK 0x40
#define CAN0_IMR6_TXOK 0x40
#define CAN0_IMR6_TXOK_BIT 6
#define CAN0_IMR6_RFRAME_MASK 0x80
#define CAN0_IMR6_RFRAME 0x80
#define CAN0_IMR6_RFRAME_BIT 7

#define CAN0_DRA7 (*(volatile unsigned long *)0xFFFD42C0)
#define CAN0_DRA7_OFFSET 0x2C0
#define CAN0_DRA7_DATA0_MASK 0xFF
#define CAN0_DRA7_DATA0_BIT 0
#define CAN0_DRA7_DATA1_MASK 0xFF00
#define CAN0_DRA7_DATA1_BIT 8
#define CAN0_DRA7_DATA2_MASK 0xFF0000
#define CAN0_DRA7_DATA2_BIT 16
#define CAN0_DRA7_DATA3_MASK 0xFF000000
#define CAN0_DRA7_DATA3_BIT 24

#define CAN0_DRB7 (*(volatile unsigned long *)0xFFFD42C4)
#define CAN0_DRB7_OFFSET 0x2C4
#define CAN0_DRB7_DATA4_MASK 0xFF
#define CAN0_DRB7_DATA4_BIT 0
#define CAN0_DRB7_DATA5_MASK 0xFF00
#define CAN0_DRB7_DATA5_BIT 8
#define CAN0_DRB7_DATA6_MASK 0xFF0000
#define CAN0_DRB7_DATA6_BIT 16
#define CAN0_DRB7_DATA7_MASK 0xFF000000
#define CAN0_DRB7_DATA7_BIT 24

#define CAN0_MSK7 (*(volatile unsigned long *)0xFFFD42C8)
#define CAN0_MSK7_OFFSET 0x2C8
#define CAN0_MSK7_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK7_MASK_BIT 0
#define CAN0_MSK7_MRB_MASK 0x60000000
#define CAN0_MSK7_MRB_BIT 29
#define CAN0_MSK7_MRTR_MASK 0x80000000
#define CAN0_MSK7_MRTR 0x80000000
#define CAN0_MSK7_MRTR_BIT 31

#define CAN0_IR7 (*(volatile unsigned long *)0xFFFD42CC)
#define CAN0_IR7_OFFSET 0x2CC
#define CAN0_IR7_ID_MASK 0x1FFFFFFF
#define CAN0_IR7_ID_BIT 0
#define CAN0_IR7_RB_MASK 0x60000000
#define CAN0_IR7_RB_BIT 29
#define CAN0_IR7_RTR_MASK 0x80000000
#define CAN0_IR7_RTR 0x80000000
#define CAN0_IR7_RTR_BIT 31

#define CAN0_CR7 (*(volatile unsigned long *)0xFFFD42D0)
#define CAN0_CR7_OFFSET 0x2D0
#define CAN0_CR7_DLC_MASK 0xF
#define CAN0_CR7_DLC_BIT 0
#define CAN0_CR7_IDE_MASK 0x10
#define CAN0_CR7_IDE 0x10
#define CAN0_CR7_IDE_BIT 4
#define CAN0_CR7_RPLYV_MASK 0x20
#define CAN0_CR7_RPLYV 0x20
#define CAN0_CR7_RPLYV_BIT 5
#define CAN0_CR7_PCB_MASK 0x40
#define CAN0_CR7_PCB 0x40
#define CAN0_CR7_PCB_BIT 6
#define CAN0_CR7_CHANEN_MASK 0x80
#define CAN0_CR7_CHANEN 0x80
#define CAN0_CR7_CHANEN_BIT 7
#define CAN0_CR7_OVERWRITE_MASK 0x100
#define CAN0_CR7_OVERWRITE 0x100
#define CAN0_CR7_OVERWRITE_BIT 8

#define CAN0_CR7 (*(volatile unsigned long *)0xFFFD42D4)
#define CAN0_CR7_OFFSET 0x2D4
#define CAN0_CR7_STAMP_MASK 0x0
#define CAN0_CR7_STAMP_BIT 0

#define CAN0_CSR7 (*(volatile unsigned long *)0xFFFD42D8)
#define CAN0_CSR7_OFFSET 0x2D8
#define CAN0_CSR7_ACK_MASK 0x1
#define CAN0_CSR7_ACK 0x1
#define CAN0_CSR7_ACK_BIT 0
#define CAN0_CSR7_FRAME_MASK 0x2
#define CAN0_CSR7_FRAME 0x2
#define CAN0_CSR7_FRAME_BIT 1
#define CAN0_CSR7_CRC_MASK 0x4
#define CAN0_CSR7_CRC 0x4
#define CAN0_CSR7_CRC_BIT 2
#define CAN0_CSR7_STUFF_MASK 0x8
#define CAN0_CSR7_STUFF 0x8
#define CAN0_CSR7_STUFF_BIT 3
#define CAN0_CSR7_BUS_MASK 0x10
#define CAN0_CSR7_BUS 0x10
#define CAN0_CSR7_BUS_BIT 4
#define CAN0_CSR7_RXOK_MASK 0x20
#define CAN0_CSR7_RXOK 0x20
#define CAN0_CSR7_RXOK_BIT 5
#define CAN0_CSR7_TXOK_MASK 0x40
#define CAN0_CSR7_TXOK 0x40
#define CAN0_CSR7_TXOK_BIT 6
#define CAN0_CSR7_RFRAME_MASK 0x80
#define CAN0_CSR7_RFRAME 0x80
#define CAN0_CSR7_RFRAME_BIT 7
#define CAN0_CSR7_DLCW_MASK 0x200
#define CAN0_CSR7_DLCW 0x200
#define CAN0_CSR7_DLCW_BIT 9
#define CAN0_CSR7_FILLED_MASK 0x400
#define CAN0_CSR7_FILLED 0x400
#define CAN0_CSR7_FILLED_BIT 10
#define CAN0_CSR7_OVRUN_MASK 0x800
#define CAN0_CSR7_OVRUN 0x800
#define CAN0_CSR7_OVRUN_BIT 11

#define CAN0_SR7 (*(volatile unsigned long *)0xFFFD42DC)
#define CAN0_SR7_OFFSET 0x2DC
#define CAN0_SR7_ACK_MASK 0x1
#define CAN0_SR7_ACK 0x1
#define CAN0_SR7_ACK_BIT 0
#define CAN0_SR7_FRAME_MASK 0x2
#define CAN0_SR7_FRAME 0x2
#define CAN0_SR7_FRAME_BIT 1
#define CAN0_SR7_CRC_MASK 0x4
#define CAN0_SR7_CRC 0x4
#define CAN0_SR7_CRC_BIT 2
#define CAN0_SR7_STUFF_MASK 0x8
#define CAN0_SR7_STUFF 0x8
#define CAN0_SR7_STUFF_BIT 3
#define CAN0_SR7_BUS_MASK 0x10
#define CAN0_SR7_BUS 0x10
#define CAN0_SR7_BUS_BIT 4
#define CAN0_SR7_RXOK_MASK 0x20
#define CAN0_SR7_RXOK 0x20
#define CAN0_SR7_RXOK_BIT 5
#define CAN0_SR7_TXOK_MASK 0x40
#define CAN0_SR7_TXOK 0x40
#define CAN0_SR7_TXOK_BIT 6
#define CAN0_SR7_RFRAME_MASK 0x80
#define CAN0_SR7_RFRAME 0x80
#define CAN0_SR7_RFRAME_BIT 7
#define CAN0_SR7_DLCW_MASK 0x200
#define CAN0_SR7_DLCW 0x200
#define CAN0_SR7_DLCW_BIT 9
#define CAN0_SR7_FILLED_MASK 0x400
#define CAN0_SR7_FILLED 0x400
#define CAN0_SR7_FILLED_BIT 10
#define CAN0_SR7_OVRUN_MASK 0x800
#define CAN0_SR7_OVRUN 0x800
#define CAN0_SR7_OVRUN_BIT 11

#define CAN0_IER7 (*(volatile unsigned long *)0xFFFD42E0)
#define CAN0_IER7_OFFSET 0x2E0
#define CAN0_IER7_ACK_MASK 0x1
#define CAN0_IER7_ACK 0x1
#define CAN0_IER7_ACK_BIT 0
#define CAN0_IER7_FRAME_MASK 0x2
#define CAN0_IER7_FRAME 0x2
#define CAN0_IER7_FRAME_BIT 1
#define CAN0_IER7_CRC_MASK 0x4
#define CAN0_IER7_CRC 0x4
#define CAN0_IER7_CRC_BIT 2
#define CAN0_IER7_STUFF_MASK 0x8
#define CAN0_IER7_STUFF 0x8
#define CAN0_IER7_STUFF_BIT 3
#define CAN0_IER7_BUS_MASK 0x10
#define CAN0_IER7_BUS 0x10
#define CAN0_IER7_BUS_BIT 4
#define CAN0_IER7_RXOK_MASK 0x20
#define CAN0_IER7_RXOK 0x20
#define CAN0_IER7_RXOK_BIT 5
#define CAN0_IER7_TXOK_MASK 0x40
#define CAN0_IER7_TXOK 0x40
#define CAN0_IER7_TXOK_BIT 6
#define CAN0_IER7_RFRAME_MASK 0x80
#define CAN0_IER7_RFRAME 0x80
#define CAN0_IER7_RFRAME_BIT 7

#define CAN0_IDR7 (*(volatile unsigned long *)0xFFFD42E4)
#define CAN0_IDR7_OFFSET 0x2E4
#define CAN0_IDR7_ACK_MASK 0x1
#define CAN0_IDR7_ACK 0x1
#define CAN0_IDR7_ACK_BIT 0
#define CAN0_IDR7_FRAME_MASK 0x2
#define CAN0_IDR7_FRAME 0x2
#define CAN0_IDR7_FRAME_BIT 1
#define CAN0_IDR7_CRC_MASK 0x4
#define CAN0_IDR7_CRC 0x4
#define CAN0_IDR7_CRC_BIT 2
#define CAN0_IDR7_STUFF_MASK 0x8
#define CAN0_IDR7_STUFF 0x8
#define CAN0_IDR7_STUFF_BIT 3
#define CAN0_IDR7_BUS_MASK 0x10
#define CAN0_IDR7_BUS 0x10
#define CAN0_IDR7_BUS_BIT 4
#define CAN0_IDR7_RXOK_MASK 0x20
#define CAN0_IDR7_RXOK 0x20
#define CAN0_IDR7_RXOK_BIT 5
#define CAN0_IDR7_TXOK_MASK 0x40
#define CAN0_IDR7_TXOK 0x40
#define CAN0_IDR7_TXOK_BIT 6
#define CAN0_IDR7_RFRAME_MASK 0x80
#define CAN0_IDR7_RFRAME 0x80
#define CAN0_IDR7_RFRAME_BIT 7

#define CAN0_IMR7 (*(volatile unsigned long *)0xFFFD42E8)
#define CAN0_IMR7_OFFSET 0x2E8
#define CAN0_IMR7_ACK_MASK 0x1
#define CAN0_IMR7_ACK 0x1
#define CAN0_IMR7_ACK_BIT 0
#define CAN0_IMR7_FRAME_MASK 0x2
#define CAN0_IMR7_FRAME 0x2
#define CAN0_IMR7_FRAME_BIT 1
#define CAN0_IMR7_CRC_MASK 0x4
#define CAN0_IMR7_CRC 0x4
#define CAN0_IMR7_CRC_BIT 2
#define CAN0_IMR7_STUFF_MASK 0x8
#define CAN0_IMR7_STUFF 0x8
#define CAN0_IMR7_STUFF_BIT 3
#define CAN0_IMR7_BUS_MASK 0x10
#define CAN0_IMR7_BUS 0x10
#define CAN0_IMR7_BUS_BIT 4
#define CAN0_IMR7_RXOK_MASK 0x20
#define CAN0_IMR7_RXOK 0x20
#define CAN0_IMR7_RXOK_BIT 5
#define CAN0_IMR7_TXOK_MASK 0x40
#define CAN0_IMR7_TXOK 0x40
#define CAN0_IMR7_TXOK_BIT 6
#define CAN0_IMR7_RFRAME_MASK 0x80
#define CAN0_IMR7_RFRAME 0x80
#define CAN0_IMR7_RFRAME_BIT 7

#define CAN0_DRA8 (*(volatile unsigned long *)0xFFFD4300)
#define CAN0_DRA8_OFFSET 0x300
#define CAN0_DRA8_DATA0_MASK 0xFF
#define CAN0_DRA8_DATA0_BIT 0
#define CAN0_DRA8_DATA1_MASK 0xFF00
#define CAN0_DRA8_DATA1_BIT 8
#define CAN0_DRA8_DATA2_MASK 0xFF0000
#define CAN0_DRA8_DATA2_BIT 16
#define CAN0_DRA8_DATA3_MASK 0xFF000000
#define CAN0_DRA8_DATA3_BIT 24

#define CAN0_DRB8 (*(volatile unsigned long *)0xFFFD4304)
#define CAN0_DRB8_OFFSET 0x304
#define CAN0_DRB8_DATA4_MASK 0xFF
#define CAN0_DRB8_DATA4_BIT 0
#define CAN0_DRB8_DATA5_MASK 0xFF00
#define CAN0_DRB8_DATA5_BIT 8
#define CAN0_DRB8_DATA6_MASK 0xFF0000
#define CAN0_DRB8_DATA6_BIT 16
#define CAN0_DRB8_DATA7_MASK 0xFF000000
#define CAN0_DRB8_DATA7_BIT 24

#define CAN0_MSK8 (*(volatile unsigned long *)0xFFFD4308)
#define CAN0_MSK8_OFFSET 0x308
#define CAN0_MSK8_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK8_MASK_BIT 0
#define CAN0_MSK8_MRB_MASK 0x60000000
#define CAN0_MSK8_MRB_BIT 29
#define CAN0_MSK8_MRTR_MASK 0x80000000
#define CAN0_MSK8_MRTR 0x80000000
#define CAN0_MSK8_MRTR_BIT 31

#define CAN0_IR8 (*(volatile unsigned long *)0xFFFD430C)
#define CAN0_IR8_OFFSET 0x30C
#define CAN0_IR8_ID_MASK 0x1FFFFFFF
#define CAN0_IR8_ID_BIT 0
#define CAN0_IR8_RB_MASK 0x60000000
#define CAN0_IR8_RB_BIT 29
#define CAN0_IR8_RTR_MASK 0x80000000
#define CAN0_IR8_RTR 0x80000000
#define CAN0_IR8_RTR_BIT 31

#define CAN0_CR8 (*(volatile unsigned long *)0xFFFD4310)
#define CAN0_CR8_OFFSET 0x310
#define CAN0_CR8_DLC_MASK 0xF
#define CAN0_CR8_DLC_BIT 0
#define CAN0_CR8_IDE_MASK 0x10
#define CAN0_CR8_IDE 0x10
#define CAN0_CR8_IDE_BIT 4
#define CAN0_CR8_RPLYV_MASK 0x20
#define CAN0_CR8_RPLYV 0x20
#define CAN0_CR8_RPLYV_BIT 5
#define CAN0_CR8_PCB_MASK 0x40
#define CAN0_CR8_PCB 0x40
#define CAN0_CR8_PCB_BIT 6
#define CAN0_CR8_CHANEN_MASK 0x80
#define CAN0_CR8_CHANEN 0x80
#define CAN0_CR8_CHANEN_BIT 7
#define CAN0_CR8_OVERWRITE_MASK 0x100
#define CAN0_CR8_OVERWRITE 0x100
#define CAN0_CR8_OVERWRITE_BIT 8

#define CAN0_CR8 (*(volatile unsigned long *)0xFFFD4314)
#define CAN0_CR8_OFFSET 0x314
#define CAN0_CR8_STAMP_MASK 0x0
#define CAN0_CR8_STAMP_BIT 0

#define CAN0_CSR8 (*(volatile unsigned long *)0xFFFD4318)
#define CAN0_CSR8_OFFSET 0x318
#define CAN0_CSR8_ACK_MASK 0x1
#define CAN0_CSR8_ACK 0x1
#define CAN0_CSR8_ACK_BIT 0
#define CAN0_CSR8_FRAME_MASK 0x2
#define CAN0_CSR8_FRAME 0x2
#define CAN0_CSR8_FRAME_BIT 1
#define CAN0_CSR8_CRC_MASK 0x4
#define CAN0_CSR8_CRC 0x4
#define CAN0_CSR8_CRC_BIT 2
#define CAN0_CSR8_STUFF_MASK 0x8
#define CAN0_CSR8_STUFF 0x8
#define CAN0_CSR8_STUFF_BIT 3
#define CAN0_CSR8_BUS_MASK 0x10
#define CAN0_CSR8_BUS 0x10
#define CAN0_CSR8_BUS_BIT 4
#define CAN0_CSR8_RXOK_MASK 0x20
#define CAN0_CSR8_RXOK 0x20
#define CAN0_CSR8_RXOK_BIT 5
#define CAN0_CSR8_TXOK_MASK 0x40
#define CAN0_CSR8_TXOK 0x40
#define CAN0_CSR8_TXOK_BIT 6
#define CAN0_CSR8_RFRAME_MASK 0x80
#define CAN0_CSR8_RFRAME 0x80
#define CAN0_CSR8_RFRAME_BIT 7
#define CAN0_CSR8_DLCW_MASK 0x200
#define CAN0_CSR8_DLCW 0x200
#define CAN0_CSR8_DLCW_BIT 9
#define CAN0_CSR8_FILLED_MASK 0x400
#define CAN0_CSR8_FILLED 0x400
#define CAN0_CSR8_FILLED_BIT 10
#define CAN0_CSR8_OVRUN_MASK 0x800
#define CAN0_CSR8_OVRUN 0x800
#define CAN0_CSR8_OVRUN_BIT 11

#define CAN0_SR8 (*(volatile unsigned long *)0xFFFD431C)
#define CAN0_SR8_OFFSET 0x31C
#define CAN0_SR8_ACK_MASK 0x1
#define CAN0_SR8_ACK 0x1
#define CAN0_SR8_ACK_BIT 0
#define CAN0_SR8_FRAME_MASK 0x2
#define CAN0_SR8_FRAME 0x2
#define CAN0_SR8_FRAME_BIT 1
#define CAN0_SR8_CRC_MASK 0x4
#define CAN0_SR8_CRC 0x4
#define CAN0_SR8_CRC_BIT 2
#define CAN0_SR8_STUFF_MASK 0x8
#define CAN0_SR8_STUFF 0x8
#define CAN0_SR8_STUFF_BIT 3
#define CAN0_SR8_BUS_MASK 0x10
#define CAN0_SR8_BUS 0x10
#define CAN0_SR8_BUS_BIT 4
#define CAN0_SR8_RXOK_MASK 0x20
#define CAN0_SR8_RXOK 0x20
#define CAN0_SR8_RXOK_BIT 5
#define CAN0_SR8_TXOK_MASK 0x40
#define CAN0_SR8_TXOK 0x40
#define CAN0_SR8_TXOK_BIT 6
#define CAN0_SR8_RFRAME_MASK 0x80
#define CAN0_SR8_RFRAME 0x80
#define CAN0_SR8_RFRAME_BIT 7
#define CAN0_SR8_DLCW_MASK 0x200
#define CAN0_SR8_DLCW 0x200
#define CAN0_SR8_DLCW_BIT 9
#define CAN0_SR8_FILLED_MASK 0x400
#define CAN0_SR8_FILLED 0x400
#define CAN0_SR8_FILLED_BIT 10
#define CAN0_SR8_OVRUN_MASK 0x800
#define CAN0_SR8_OVRUN 0x800
#define CAN0_SR8_OVRUN_BIT 11

#define CAN0_IER8 (*(volatile unsigned long *)0xFFFD4320)
#define CAN0_IER8_OFFSET 0x320
#define CAN0_IER8_ACK_MASK 0x1
#define CAN0_IER8_ACK 0x1
#define CAN0_IER8_ACK_BIT 0
#define CAN0_IER8_FRAME_MASK 0x2
#define CAN0_IER8_FRAME 0x2
#define CAN0_IER8_FRAME_BIT 1
#define CAN0_IER8_CRC_MASK 0x4
#define CAN0_IER8_CRC 0x4
#define CAN0_IER8_CRC_BIT 2
#define CAN0_IER8_STUFF_MASK 0x8
#define CAN0_IER8_STUFF 0x8
#define CAN0_IER8_STUFF_BIT 3
#define CAN0_IER8_BUS_MASK 0x10
#define CAN0_IER8_BUS 0x10
#define CAN0_IER8_BUS_BIT 4
#define CAN0_IER8_RXOK_MASK 0x20
#define CAN0_IER8_RXOK 0x20
#define CAN0_IER8_RXOK_BIT 5
#define CAN0_IER8_TXOK_MASK 0x40
#define CAN0_IER8_TXOK 0x40
#define CAN0_IER8_TXOK_BIT 6
#define CAN0_IER8_RFRAME_MASK 0x80
#define CAN0_IER8_RFRAME 0x80
#define CAN0_IER8_RFRAME_BIT 7

#define CAN0_IDR8 (*(volatile unsigned long *)0xFFFD4324)
#define CAN0_IDR8_OFFSET 0x324
#define CAN0_IDR8_ACK_MASK 0x1
#define CAN0_IDR8_ACK 0x1
#define CAN0_IDR8_ACK_BIT 0
#define CAN0_IDR8_FRAME_MASK 0x2
#define CAN0_IDR8_FRAME 0x2
#define CAN0_IDR8_FRAME_BIT 1
#define CAN0_IDR8_CRC_MASK 0x4
#define CAN0_IDR8_CRC 0x4
#define CAN0_IDR8_CRC_BIT 2
#define CAN0_IDR8_STUFF_MASK 0x8
#define CAN0_IDR8_STUFF 0x8
#define CAN0_IDR8_STUFF_BIT 3
#define CAN0_IDR8_BUS_MASK 0x10
#define CAN0_IDR8_BUS 0x10
#define CAN0_IDR8_BUS_BIT 4
#define CAN0_IDR8_RXOK_MASK 0x20
#define CAN0_IDR8_RXOK 0x20
#define CAN0_IDR8_RXOK_BIT 5
#define CAN0_IDR8_TXOK_MASK 0x40
#define CAN0_IDR8_TXOK 0x40
#define CAN0_IDR8_TXOK_BIT 6
#define CAN0_IDR8_RFRAME_MASK 0x80
#define CAN0_IDR8_RFRAME 0x80
#define CAN0_IDR8_RFRAME_BIT 7

#define CAN0_IMR8 (*(volatile unsigned long *)0xFFFD4328)
#define CAN0_IMR8_OFFSET 0x328
#define CAN0_IMR8_ACK_MASK 0x1
#define CAN0_IMR8_ACK 0x1
#define CAN0_IMR8_ACK_BIT 0
#define CAN0_IMR8_FRAME_MASK 0x2
#define CAN0_IMR8_FRAME 0x2
#define CAN0_IMR8_FRAME_BIT 1
#define CAN0_IMR8_CRC_MASK 0x4
#define CAN0_IMR8_CRC 0x4
#define CAN0_IMR8_CRC_BIT 2
#define CAN0_IMR8_STUFF_MASK 0x8
#define CAN0_IMR8_STUFF 0x8
#define CAN0_IMR8_STUFF_BIT 3
#define CAN0_IMR8_BUS_MASK 0x10
#define CAN0_IMR8_BUS 0x10
#define CAN0_IMR8_BUS_BIT 4
#define CAN0_IMR8_RXOK_MASK 0x20
#define CAN0_IMR8_RXOK 0x20
#define CAN0_IMR8_RXOK_BIT 5
#define CAN0_IMR8_TXOK_MASK 0x40
#define CAN0_IMR8_TXOK 0x40
#define CAN0_IMR8_TXOK_BIT 6
#define CAN0_IMR8_RFRAME_MASK 0x80
#define CAN0_IMR8_RFRAME 0x80
#define CAN0_IMR8_RFRAME_BIT 7

#define CAN0_DRA9 (*(volatile unsigned long *)0xFFFD4340)
#define CAN0_DRA9_OFFSET 0x340
#define CAN0_DRA9_DATA0_MASK 0xFF
#define CAN0_DRA9_DATA0_BIT 0
#define CAN0_DRA9_DATA1_MASK 0xFF00
#define CAN0_DRA9_DATA1_BIT 8
#define CAN0_DRA9_DATA2_MASK 0xFF0000
#define CAN0_DRA9_DATA2_BIT 16
#define CAN0_DRA9_DATA3_MASK 0xFF000000
#define CAN0_DRA9_DATA3_BIT 24

#define CAN0_DRB9 (*(volatile unsigned long *)0xFFFD4344)
#define CAN0_DRB9_OFFSET 0x344
#define CAN0_DRB9_DATA4_MASK 0xFF
#define CAN0_DRB9_DATA4_BIT 0
#define CAN0_DRB9_DATA5_MASK 0xFF00
#define CAN0_DRB9_DATA5_BIT 8
#define CAN0_DRB9_DATA6_MASK 0xFF0000
#define CAN0_DRB9_DATA6_BIT 16
#define CAN0_DRB9_DATA7_MASK 0xFF000000
#define CAN0_DRB9_DATA7_BIT 24

#define CAN0_MSK9 (*(volatile unsigned long *)0xFFFD4348)
#define CAN0_MSK9_OFFSET 0x348
#define CAN0_MSK9_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK9_MASK_BIT 0
#define CAN0_MSK9_MRB_MASK 0x60000000
#define CAN0_MSK9_MRB_BIT 29
#define CAN0_MSK9_MRTR_MASK 0x80000000
#define CAN0_MSK9_MRTR 0x80000000
#define CAN0_MSK9_MRTR_BIT 31

#define CAN0_IR9 (*(volatile unsigned long *)0xFFFD434C)
#define CAN0_IR9_OFFSET 0x34C
#define CAN0_IR9_ID_MASK 0x1FFFFFFF
#define CAN0_IR9_ID_BIT 0
#define CAN0_IR9_RB_MASK 0x60000000
#define CAN0_IR9_RB_BIT 29
#define CAN0_IR9_RTR_MASK 0x80000000
#define CAN0_IR9_RTR 0x80000000
#define CAN0_IR9_RTR_BIT 31

#define CAN0_CR9 (*(volatile unsigned long *)0xFFFD4350)
#define CAN0_CR9_OFFSET 0x350
#define CAN0_CR9_DLC_MASK 0xF
#define CAN0_CR9_DLC_BIT 0
#define CAN0_CR9_IDE_MASK 0x10
#define CAN0_CR9_IDE 0x10
#define CAN0_CR9_IDE_BIT 4
#define CAN0_CR9_RPLYV_MASK 0x20
#define CAN0_CR9_RPLYV 0x20
#define CAN0_CR9_RPLYV_BIT 5
#define CAN0_CR9_PCB_MASK 0x40
#define CAN0_CR9_PCB 0x40
#define CAN0_CR9_PCB_BIT 6
#define CAN0_CR9_CHANEN_MASK 0x80
#define CAN0_CR9_CHANEN 0x80
#define CAN0_CR9_CHANEN_BIT 7
#define CAN0_CR9_OVERWRITE_MASK 0x100
#define CAN0_CR9_OVERWRITE 0x100
#define CAN0_CR9_OVERWRITE_BIT 8

#define CAN0_CR9 (*(volatile unsigned long *)0xFFFD4354)
#define CAN0_CR9_OFFSET 0x354
#define CAN0_CR9_STAMP_MASK 0x0
#define CAN0_CR9_STAMP_BIT 0

#define CAN0_CSR9 (*(volatile unsigned long *)0xFFFD4358)
#define CAN0_CSR9_OFFSET 0x358
#define CAN0_CSR9_ACK_MASK 0x1
#define CAN0_CSR9_ACK 0x1
#define CAN0_CSR9_ACK_BIT 0
#define CAN0_CSR9_FRAME_MASK 0x2
#define CAN0_CSR9_FRAME 0x2
#define CAN0_CSR9_FRAME_BIT 1
#define CAN0_CSR9_CRC_MASK 0x4
#define CAN0_CSR9_CRC 0x4
#define CAN0_CSR9_CRC_BIT 2
#define CAN0_CSR9_STUFF_MASK 0x8
#define CAN0_CSR9_STUFF 0x8
#define CAN0_CSR9_STUFF_BIT 3
#define CAN0_CSR9_BUS_MASK 0x10
#define CAN0_CSR9_BUS 0x10
#define CAN0_CSR9_BUS_BIT 4
#define CAN0_CSR9_RXOK_MASK 0x20
#define CAN0_CSR9_RXOK 0x20
#define CAN0_CSR9_RXOK_BIT 5
#define CAN0_CSR9_TXOK_MASK 0x40
#define CAN0_CSR9_TXOK 0x40
#define CAN0_CSR9_TXOK_BIT 6
#define CAN0_CSR9_RFRAME_MASK 0x80
#define CAN0_CSR9_RFRAME 0x80
#define CAN0_CSR9_RFRAME_BIT 7
#define CAN0_CSR9_DLCW_MASK 0x200
#define CAN0_CSR9_DLCW 0x200
#define CAN0_CSR9_DLCW_BIT 9
#define CAN0_CSR9_FILLED_MASK 0x400
#define CAN0_CSR9_FILLED 0x400
#define CAN0_CSR9_FILLED_BIT 10
#define CAN0_CSR9_OVRUN_MASK 0x800
#define CAN0_CSR9_OVRUN 0x800
#define CAN0_CSR9_OVRUN_BIT 11

#define CAN0_SR9 (*(volatile unsigned long *)0xFFFD435C)
#define CAN0_SR9_OFFSET 0x35C
#define CAN0_SR9_ACK_MASK 0x1
#define CAN0_SR9_ACK 0x1
#define CAN0_SR9_ACK_BIT 0
#define CAN0_SR9_FRAME_MASK 0x2
#define CAN0_SR9_FRAME 0x2
#define CAN0_SR9_FRAME_BIT 1
#define CAN0_SR9_CRC_MASK 0x4
#define CAN0_SR9_CRC 0x4
#define CAN0_SR9_CRC_BIT 2
#define CAN0_SR9_STUFF_MASK 0x8
#define CAN0_SR9_STUFF 0x8
#define CAN0_SR9_STUFF_BIT 3
#define CAN0_SR9_BUS_MASK 0x10
#define CAN0_SR9_BUS 0x10
#define CAN0_SR9_BUS_BIT 4
#define CAN0_SR9_RXOK_MASK 0x20
#define CAN0_SR9_RXOK 0x20
#define CAN0_SR9_RXOK_BIT 5
#define CAN0_SR9_TXOK_MASK 0x40
#define CAN0_SR9_TXOK 0x40
#define CAN0_SR9_TXOK_BIT 6
#define CAN0_SR9_RFRAME_MASK 0x80
#define CAN0_SR9_RFRAME 0x80
#define CAN0_SR9_RFRAME_BIT 7
#define CAN0_SR9_DLCW_MASK 0x200
#define CAN0_SR9_DLCW 0x200
#define CAN0_SR9_DLCW_BIT 9
#define CAN0_SR9_FILLED_MASK 0x400
#define CAN0_SR9_FILLED 0x400
#define CAN0_SR9_FILLED_BIT 10
#define CAN0_SR9_OVRUN_MASK 0x800
#define CAN0_SR9_OVRUN 0x800
#define CAN0_SR9_OVRUN_BIT 11

#define CAN0_IER9 (*(volatile unsigned long *)0xFFFD4360)
#define CAN0_IER9_OFFSET 0x360
#define CAN0_IER9_ACK_MASK 0x1
#define CAN0_IER9_ACK 0x1
#define CAN0_IER9_ACK_BIT 0
#define CAN0_IER9_FRAME_MASK 0x2
#define CAN0_IER9_FRAME 0x2
#define CAN0_IER9_FRAME_BIT 1
#define CAN0_IER9_CRC_MASK 0x4
#define CAN0_IER9_CRC 0x4
#define CAN0_IER9_CRC_BIT 2
#define CAN0_IER9_STUFF_MASK 0x8
#define CAN0_IER9_STUFF 0x8
#define CAN0_IER9_STUFF_BIT 3
#define CAN0_IER9_BUS_MASK 0x10
#define CAN0_IER9_BUS 0x10
#define CAN0_IER9_BUS_BIT 4
#define CAN0_IER9_RXOK_MASK 0x20
#define CAN0_IER9_RXOK 0x20
#define CAN0_IER9_RXOK_BIT 5
#define CAN0_IER9_TXOK_MASK 0x40
#define CAN0_IER9_TXOK 0x40
#define CAN0_IER9_TXOK_BIT 6
#define CAN0_IER9_RFRAME_MASK 0x80
#define CAN0_IER9_RFRAME 0x80
#define CAN0_IER9_RFRAME_BIT 7

#define CAN0_IDR9 (*(volatile unsigned long *)0xFFFD4364)
#define CAN0_IDR9_OFFSET 0x364
#define CAN0_IDR9_ACK_MASK 0x1
#define CAN0_IDR9_ACK 0x1
#define CAN0_IDR9_ACK_BIT 0
#define CAN0_IDR9_FRAME_MASK 0x2
#define CAN0_IDR9_FRAME 0x2
#define CAN0_IDR9_FRAME_BIT 1
#define CAN0_IDR9_CRC_MASK 0x4
#define CAN0_IDR9_CRC 0x4
#define CAN0_IDR9_CRC_BIT 2
#define CAN0_IDR9_STUFF_MASK 0x8
#define CAN0_IDR9_STUFF 0x8
#define CAN0_IDR9_STUFF_BIT 3
#define CAN0_IDR9_BUS_MASK 0x10
#define CAN0_IDR9_BUS 0x10
#define CAN0_IDR9_BUS_BIT 4
#define CAN0_IDR9_RXOK_MASK 0x20
#define CAN0_IDR9_RXOK 0x20
#define CAN0_IDR9_RXOK_BIT 5
#define CAN0_IDR9_TXOK_MASK 0x40
#define CAN0_IDR9_TXOK 0x40
#define CAN0_IDR9_TXOK_BIT 6
#define CAN0_IDR9_RFRAME_MASK 0x80
#define CAN0_IDR9_RFRAME 0x80
#define CAN0_IDR9_RFRAME_BIT 7

#define CAN0_IMR9 (*(volatile unsigned long *)0xFFFD4368)
#define CAN0_IMR9_OFFSET 0x368
#define CAN0_IMR9_ACK_MASK 0x1
#define CAN0_IMR9_ACK 0x1
#define CAN0_IMR9_ACK_BIT 0
#define CAN0_IMR9_FRAME_MASK 0x2
#define CAN0_IMR9_FRAME 0x2
#define CAN0_IMR9_FRAME_BIT 1
#define CAN0_IMR9_CRC_MASK 0x4
#define CAN0_IMR9_CRC 0x4
#define CAN0_IMR9_CRC_BIT 2
#define CAN0_IMR9_STUFF_MASK 0x8
#define CAN0_IMR9_STUFF 0x8
#define CAN0_IMR9_STUFF_BIT 3
#define CAN0_IMR9_BUS_MASK 0x10
#define CAN0_IMR9_BUS 0x10
#define CAN0_IMR9_BUS_BIT 4
#define CAN0_IMR9_RXOK_MASK 0x20
#define CAN0_IMR9_RXOK 0x20
#define CAN0_IMR9_RXOK_BIT 5
#define CAN0_IMR9_TXOK_MASK 0x40
#define CAN0_IMR9_TXOK 0x40
#define CAN0_IMR9_TXOK_BIT 6
#define CAN0_IMR9_RFRAME_MASK 0x80
#define CAN0_IMR9_RFRAME 0x80
#define CAN0_IMR9_RFRAME_BIT 7

#define CAN0_DRA10 (*(volatile unsigned long *)0xFFFD4380)
#define CAN0_DRA10_OFFSET 0x380
#define CAN0_DRA10_DATA0_MASK 0xFF
#define CAN0_DRA10_DATA0_BIT 0
#define CAN0_DRA10_DATA1_MASK 0xFF00
#define CAN0_DRA10_DATA1_BIT 8
#define CAN0_DRA10_DATA2_MASK 0xFF0000
#define CAN0_DRA10_DATA2_BIT 16
#define CAN0_DRA10_DATA3_MASK 0xFF000000
#define CAN0_DRA10_DATA3_BIT 24

#define CAN0_DRB10 (*(volatile unsigned long *)0xFFFD4384)
#define CAN0_DRB10_OFFSET 0x384
#define CAN0_DRB10_DATA4_MASK 0xFF
#define CAN0_DRB10_DATA4_BIT 0
#define CAN0_DRB10_DATA5_MASK 0xFF00
#define CAN0_DRB10_DATA5_BIT 8
#define CAN0_DRB10_DATA6_MASK 0xFF0000
#define CAN0_DRB10_DATA6_BIT 16
#define CAN0_DRB10_DATA7_MASK 0xFF000000
#define CAN0_DRB10_DATA7_BIT 24

#define CAN0_MSK10 (*(volatile unsigned long *)0xFFFD4388)
#define CAN0_MSK10_OFFSET 0x388
#define CAN0_MSK10_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK10_MASK_BIT 0
#define CAN0_MSK10_MRB_MASK 0x60000000
#define CAN0_MSK10_MRB_BIT 29
#define CAN0_MSK10_MRTR_MASK 0x80000000
#define CAN0_MSK10_MRTR 0x80000000
#define CAN0_MSK10_MRTR_BIT 31

#define CAN0_IR10 (*(volatile unsigned long *)0xFFFD438C)
#define CAN0_IR10_OFFSET 0x38C
#define CAN0_IR10_ID_MASK 0x1FFFFFFF
#define CAN0_IR10_ID_BIT 0
#define CAN0_IR10_RB_MASK 0x60000000
#define CAN0_IR10_RB_BIT 29
#define CAN0_IR10_RTR_MASK 0x80000000
#define CAN0_IR10_RTR 0x80000000
#define CAN0_IR10_RTR_BIT 31

#define CAN0_CR10 (*(volatile unsigned long *)0xFFFD4390)
#define CAN0_CR10_OFFSET 0x390
#define CAN0_CR10_DLC_MASK 0xF
#define CAN0_CR10_DLC_BIT 0
#define CAN0_CR10_IDE_MASK 0x10
#define CAN0_CR10_IDE 0x10
#define CAN0_CR10_IDE_BIT 4
#define CAN0_CR10_RPLYV_MASK 0x20
#define CAN0_CR10_RPLYV 0x20
#define CAN0_CR10_RPLYV_BIT 5
#define CAN0_CR10_PCB_MASK 0x40
#define CAN0_CR10_PCB 0x40
#define CAN0_CR10_PCB_BIT 6
#define CAN0_CR10_CHANEN_MASK 0x80
#define CAN0_CR10_CHANEN 0x80
#define CAN0_CR10_CHANEN_BIT 7
#define CAN0_CR10_OVERWRITE_MASK 0x100
#define CAN0_CR10_OVERWRITE 0x100
#define CAN0_CR10_OVERWRITE_BIT 8

#define CAN0_CR10 (*(volatile unsigned long *)0xFFFD4394)
#define CAN0_CR10_OFFSET 0x394
#define CAN0_CR10_STAMP_MASK 0x0
#define CAN0_CR10_STAMP_BIT 0

#define CAN0_CSR10 (*(volatile unsigned long *)0xFFFD4398)
#define CAN0_CSR10_OFFSET 0x398
#define CAN0_CSR10_ACK_MASK 0x1
#define CAN0_CSR10_ACK 0x1
#define CAN0_CSR10_ACK_BIT 0
#define CAN0_CSR10_FRAME_MASK 0x2
#define CAN0_CSR10_FRAME 0x2
#define CAN0_CSR10_FRAME_BIT 1
#define CAN0_CSR10_CRC_MASK 0x4
#define CAN0_CSR10_CRC 0x4
#define CAN0_CSR10_CRC_BIT 2
#define CAN0_CSR10_STUFF_MASK 0x8
#define CAN0_CSR10_STUFF 0x8
#define CAN0_CSR10_STUFF_BIT 3
#define CAN0_CSR10_BUS_MASK 0x10
#define CAN0_CSR10_BUS 0x10
#define CAN0_CSR10_BUS_BIT 4
#define CAN0_CSR10_RXOK_MASK 0x20
#define CAN0_CSR10_RXOK 0x20
#define CAN0_CSR10_RXOK_BIT 5
#define CAN0_CSR10_TXOK_MASK 0x40
#define CAN0_CSR10_TXOK 0x40
#define CAN0_CSR10_TXOK_BIT 6
#define CAN0_CSR10_RFRAME_MASK 0x80
#define CAN0_CSR10_RFRAME 0x80
#define CAN0_CSR10_RFRAME_BIT 7
#define CAN0_CSR10_DLCW_MASK 0x200
#define CAN0_CSR10_DLCW 0x200
#define CAN0_CSR10_DLCW_BIT 9
#define CAN0_CSR10_FILLED_MASK 0x400
#define CAN0_CSR10_FILLED 0x400
#define CAN0_CSR10_FILLED_BIT 10
#define CAN0_CSR10_OVRUN_MASK 0x800
#define CAN0_CSR10_OVRUN 0x800
#define CAN0_CSR10_OVRUN_BIT 11

#define CAN0_SR10 (*(volatile unsigned long *)0xFFFD439C)
#define CAN0_SR10_OFFSET 0x39C
#define CAN0_SR10_ACK_MASK 0x1
#define CAN0_SR10_ACK 0x1
#define CAN0_SR10_ACK_BIT 0
#define CAN0_SR10_FRAME_MASK 0x2
#define CAN0_SR10_FRAME 0x2
#define CAN0_SR10_FRAME_BIT 1
#define CAN0_SR10_CRC_MASK 0x4
#define CAN0_SR10_CRC 0x4
#define CAN0_SR10_CRC_BIT 2
#define CAN0_SR10_STUFF_MASK 0x8
#define CAN0_SR10_STUFF 0x8
#define CAN0_SR10_STUFF_BIT 3
#define CAN0_SR10_BUS_MASK 0x10
#define CAN0_SR10_BUS 0x10
#define CAN0_SR10_BUS_BIT 4
#define CAN0_SR10_RXOK_MASK 0x20
#define CAN0_SR10_RXOK 0x20
#define CAN0_SR10_RXOK_BIT 5
#define CAN0_SR10_TXOK_MASK 0x40
#define CAN0_SR10_TXOK 0x40
#define CAN0_SR10_TXOK_BIT 6
#define CAN0_SR10_RFRAME_MASK 0x80
#define CAN0_SR10_RFRAME 0x80
#define CAN0_SR10_RFRAME_BIT 7
#define CAN0_SR10_DLCW_MASK 0x200
#define CAN0_SR10_DLCW 0x200
#define CAN0_SR10_DLCW_BIT 9
#define CAN0_SR10_FILLED_MASK 0x400
#define CAN0_SR10_FILLED 0x400
#define CAN0_SR10_FILLED_BIT 10
#define CAN0_SR10_OVRUN_MASK 0x800
#define CAN0_SR10_OVRUN 0x800
#define CAN0_SR10_OVRUN_BIT 11

#define CAN0_IER10 (*(volatile unsigned long *)0xFFFD43A0)
#define CAN0_IER10_OFFSET 0x3A0
#define CAN0_IER10_ACK_MASK 0x1
#define CAN0_IER10_ACK 0x1
#define CAN0_IER10_ACK_BIT 0
#define CAN0_IER10_FRAME_MASK 0x2
#define CAN0_IER10_FRAME 0x2
#define CAN0_IER10_FRAME_BIT 1
#define CAN0_IER10_CRC_MASK 0x4
#define CAN0_IER10_CRC 0x4
#define CAN0_IER10_CRC_BIT 2
#define CAN0_IER10_STUFF_MASK 0x8
#define CAN0_IER10_STUFF 0x8
#define CAN0_IER10_STUFF_BIT 3
#define CAN0_IER10_BUS_MASK 0x10
#define CAN0_IER10_BUS 0x10
#define CAN0_IER10_BUS_BIT 4
#define CAN0_IER10_RXOK_MASK 0x20
#define CAN0_IER10_RXOK 0x20
#define CAN0_IER10_RXOK_BIT 5
#define CAN0_IER10_TXOK_MASK 0x40
#define CAN0_IER10_TXOK 0x40
#define CAN0_IER10_TXOK_BIT 6
#define CAN0_IER10_RFRAME_MASK 0x80
#define CAN0_IER10_RFRAME 0x80
#define CAN0_IER10_RFRAME_BIT 7

#define CAN0_IDR10 (*(volatile unsigned long *)0xFFFD43A4)
#define CAN0_IDR10_OFFSET 0x3A4
#define CAN0_IDR10_ACK_MASK 0x1
#define CAN0_IDR10_ACK 0x1
#define CAN0_IDR10_ACK_BIT 0
#define CAN0_IDR10_FRAME_MASK 0x2
#define CAN0_IDR10_FRAME 0x2
#define CAN0_IDR10_FRAME_BIT 1
#define CAN0_IDR10_CRC_MASK 0x4
#define CAN0_IDR10_CRC 0x4
#define CAN0_IDR10_CRC_BIT 2
#define CAN0_IDR10_STUFF_MASK 0x8
#define CAN0_IDR10_STUFF 0x8
#define CAN0_IDR10_STUFF_BIT 3
#define CAN0_IDR10_BUS_MASK 0x10
#define CAN0_IDR10_BUS 0x10
#define CAN0_IDR10_BUS_BIT 4
#define CAN0_IDR10_RXOK_MASK 0x20
#define CAN0_IDR10_RXOK 0x20
#define CAN0_IDR10_RXOK_BIT 5
#define CAN0_IDR10_TXOK_MASK 0x40
#define CAN0_IDR10_TXOK 0x40
#define CAN0_IDR10_TXOK_BIT 6
#define CAN0_IDR10_RFRAME_MASK 0x80
#define CAN0_IDR10_RFRAME 0x80
#define CAN0_IDR10_RFRAME_BIT 7

#define CAN0_IMR10 (*(volatile unsigned long *)0xFFFD43A8)
#define CAN0_IMR10_OFFSET 0x3A8
#define CAN0_IMR10_ACK_MASK 0x1
#define CAN0_IMR10_ACK 0x1
#define CAN0_IMR10_ACK_BIT 0
#define CAN0_IMR10_FRAME_MASK 0x2
#define CAN0_IMR10_FRAME 0x2
#define CAN0_IMR10_FRAME_BIT 1
#define CAN0_IMR10_CRC_MASK 0x4
#define CAN0_IMR10_CRC 0x4
#define CAN0_IMR10_CRC_BIT 2
#define CAN0_IMR10_STUFF_MASK 0x8
#define CAN0_IMR10_STUFF 0x8
#define CAN0_IMR10_STUFF_BIT 3
#define CAN0_IMR10_BUS_MASK 0x10
#define CAN0_IMR10_BUS 0x10
#define CAN0_IMR10_BUS_BIT 4
#define CAN0_IMR10_RXOK_MASK 0x20
#define CAN0_IMR10_RXOK 0x20
#define CAN0_IMR10_RXOK_BIT 5
#define CAN0_IMR10_TXOK_MASK 0x40
#define CAN0_IMR10_TXOK 0x40
#define CAN0_IMR10_TXOK_BIT 6
#define CAN0_IMR10_RFRAME_MASK 0x80
#define CAN0_IMR10_RFRAME 0x80
#define CAN0_IMR10_RFRAME_BIT 7

#define CAN0_DRA11 (*(volatile unsigned long *)0xFFFD43C0)
#define CAN0_DRA11_OFFSET 0x3C0
#define CAN0_DRA11_DATA0_MASK 0xFF
#define CAN0_DRA11_DATA0_BIT 0
#define CAN0_DRA11_DATA1_MASK 0xFF00
#define CAN0_DRA11_DATA1_BIT 8
#define CAN0_DRA11_DATA2_MASK 0xFF0000
#define CAN0_DRA11_DATA2_BIT 16
#define CAN0_DRA11_DATA3_MASK 0xFF000000
#define CAN0_DRA11_DATA3_BIT 24

#define CAN0_DRB11 (*(volatile unsigned long *)0xFFFD43C4)
#define CAN0_DRB11_OFFSET 0x3C4
#define CAN0_DRB11_DATA4_MASK 0xFF
#define CAN0_DRB11_DATA4_BIT 0
#define CAN0_DRB11_DATA5_MASK 0xFF00
#define CAN0_DRB11_DATA5_BIT 8
#define CAN0_DRB11_DATA6_MASK 0xFF0000
#define CAN0_DRB11_DATA6_BIT 16
#define CAN0_DRB11_DATA7_MASK 0xFF000000
#define CAN0_DRB11_DATA7_BIT 24

#define CAN0_MSK11 (*(volatile unsigned long *)0xFFFD43C8)
#define CAN0_MSK11_OFFSET 0x3C8
#define CAN0_MSK11_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK11_MASK_BIT 0
#define CAN0_MSK11_MRB_MASK 0x60000000
#define CAN0_MSK11_MRB_BIT 29
#define CAN0_MSK11_MRTR_MASK 0x80000000
#define CAN0_MSK11_MRTR 0x80000000
#define CAN0_MSK11_MRTR_BIT 31

#define CAN0_IR11 (*(volatile unsigned long *)0xFFFD43CC)
#define CAN0_IR11_OFFSET 0x3CC
#define CAN0_IR11_ID_MASK 0x1FFFFFFF
#define CAN0_IR11_ID_BIT 0
#define CAN0_IR11_RB_MASK 0x60000000
#define CAN0_IR11_RB_BIT 29
#define CAN0_IR11_RTR_MASK 0x80000000
#define CAN0_IR11_RTR 0x80000000
#define CAN0_IR11_RTR_BIT 31

#define CAN0_CR11 (*(volatile unsigned long *)0xFFFD43D0)
#define CAN0_CR11_OFFSET 0x3D0
#define CAN0_CR11_DLC_MASK 0xF
#define CAN0_CR11_DLC_BIT 0
#define CAN0_CR11_IDE_MASK 0x10
#define CAN0_CR11_IDE 0x10
#define CAN0_CR11_IDE_BIT 4
#define CAN0_CR11_RPLYV_MASK 0x20
#define CAN0_CR11_RPLYV 0x20
#define CAN0_CR11_RPLYV_BIT 5
#define CAN0_CR11_PCB_MASK 0x40
#define CAN0_CR11_PCB 0x40
#define CAN0_CR11_PCB_BIT 6
#define CAN0_CR11_CHANEN_MASK 0x80
#define CAN0_CR11_CHANEN 0x80
#define CAN0_CR11_CHANEN_BIT 7
#define CAN0_CR11_OVERWRITE_MASK 0x100
#define CAN0_CR11_OVERWRITE 0x100
#define CAN0_CR11_OVERWRITE_BIT 8

#define CAN0_CR11 (*(volatile unsigned long *)0xFFFD43D4)
#define CAN0_CR11_OFFSET 0x3D4
#define CAN0_CR11_STAMP_MASK 0x0
#define CAN0_CR11_STAMP_BIT 0

#define CAN0_CSR11 (*(volatile unsigned long *)0xFFFD43D8)
#define CAN0_CSR11_OFFSET 0x3D8
#define CAN0_CSR11_ACK_MASK 0x1
#define CAN0_CSR11_ACK 0x1
#define CAN0_CSR11_ACK_BIT 0
#define CAN0_CSR11_FRAME_MASK 0x2
#define CAN0_CSR11_FRAME 0x2
#define CAN0_CSR11_FRAME_BIT 1
#define CAN0_CSR11_CRC_MASK 0x4
#define CAN0_CSR11_CRC 0x4
#define CAN0_CSR11_CRC_BIT 2
#define CAN0_CSR11_STUFF_MASK 0x8
#define CAN0_CSR11_STUFF 0x8
#define CAN0_CSR11_STUFF_BIT 3
#define CAN0_CSR11_BUS_MASK 0x10
#define CAN0_CSR11_BUS 0x10
#define CAN0_CSR11_BUS_BIT 4
#define CAN0_CSR11_RXOK_MASK 0x20
#define CAN0_CSR11_RXOK 0x20
#define CAN0_CSR11_RXOK_BIT 5
#define CAN0_CSR11_TXOK_MASK 0x40
#define CAN0_CSR11_TXOK 0x40
#define CAN0_CSR11_TXOK_BIT 6
#define CAN0_CSR11_RFRAME_MASK 0x80
#define CAN0_CSR11_RFRAME 0x80
#define CAN0_CSR11_RFRAME_BIT 7
#define CAN0_CSR11_DLCW_MASK 0x200
#define CAN0_CSR11_DLCW 0x200
#define CAN0_CSR11_DLCW_BIT 9
#define CAN0_CSR11_FILLED_MASK 0x400
#define CAN0_CSR11_FILLED 0x400
#define CAN0_CSR11_FILLED_BIT 10
#define CAN0_CSR11_OVRUN_MASK 0x800
#define CAN0_CSR11_OVRUN 0x800
#define CAN0_CSR11_OVRUN_BIT 11

#define CAN0_SR11 (*(volatile unsigned long *)0xFFFD43DC)
#define CAN0_SR11_OFFSET 0x3DC
#define CAN0_SR11_ACK_MASK 0x1
#define CAN0_SR11_ACK 0x1
#define CAN0_SR11_ACK_BIT 0
#define CAN0_SR11_FRAME_MASK 0x2
#define CAN0_SR11_FRAME 0x2
#define CAN0_SR11_FRAME_BIT 1
#define CAN0_SR11_CRC_MASK 0x4
#define CAN0_SR11_CRC 0x4
#define CAN0_SR11_CRC_BIT 2
#define CAN0_SR11_STUFF_MASK 0x8
#define CAN0_SR11_STUFF 0x8
#define CAN0_SR11_STUFF_BIT 3
#define CAN0_SR11_BUS_MASK 0x10
#define CAN0_SR11_BUS 0x10
#define CAN0_SR11_BUS_BIT 4
#define CAN0_SR11_RXOK_MASK 0x20
#define CAN0_SR11_RXOK 0x20
#define CAN0_SR11_RXOK_BIT 5
#define CAN0_SR11_TXOK_MASK 0x40
#define CAN0_SR11_TXOK 0x40
#define CAN0_SR11_TXOK_BIT 6
#define CAN0_SR11_RFRAME_MASK 0x80
#define CAN0_SR11_RFRAME 0x80
#define CAN0_SR11_RFRAME_BIT 7
#define CAN0_SR11_DLCW_MASK 0x200
#define CAN0_SR11_DLCW 0x200
#define CAN0_SR11_DLCW_BIT 9
#define CAN0_SR11_FILLED_MASK 0x400
#define CAN0_SR11_FILLED 0x400
#define CAN0_SR11_FILLED_BIT 10
#define CAN0_SR11_OVRUN_MASK 0x800
#define CAN0_SR11_OVRUN 0x800
#define CAN0_SR11_OVRUN_BIT 11

#define CAN0_IER11 (*(volatile unsigned long *)0xFFFD43E0)
#define CAN0_IER11_OFFSET 0x3E0
#define CAN0_IER11_ACK_MASK 0x1
#define CAN0_IER11_ACK 0x1
#define CAN0_IER11_ACK_BIT 0
#define CAN0_IER11_FRAME_MASK 0x2
#define CAN0_IER11_FRAME 0x2
#define CAN0_IER11_FRAME_BIT 1
#define CAN0_IER11_CRC_MASK 0x4
#define CAN0_IER11_CRC 0x4
#define CAN0_IER11_CRC_BIT 2
#define CAN0_IER11_STUFF_MASK 0x8
#define CAN0_IER11_STUFF 0x8
#define CAN0_IER11_STUFF_BIT 3
#define CAN0_IER11_BUS_MASK 0x10
#define CAN0_IER11_BUS 0x10
#define CAN0_IER11_BUS_BIT 4
#define CAN0_IER11_RXOK_MASK 0x20
#define CAN0_IER11_RXOK 0x20
#define CAN0_IER11_RXOK_BIT 5
#define CAN0_IER11_TXOK_MASK 0x40
#define CAN0_IER11_TXOK 0x40
#define CAN0_IER11_TXOK_BIT 6
#define CAN0_IER11_RFRAME_MASK 0x80
#define CAN0_IER11_RFRAME 0x80
#define CAN0_IER11_RFRAME_BIT 7

#define CAN0_IDR11 (*(volatile unsigned long *)0xFFFD43E4)
#define CAN0_IDR11_OFFSET 0x3E4
#define CAN0_IDR11_ACK_MASK 0x1
#define CAN0_IDR11_ACK 0x1
#define CAN0_IDR11_ACK_BIT 0
#define CAN0_IDR11_FRAME_MASK 0x2
#define CAN0_IDR11_FRAME 0x2
#define CAN0_IDR11_FRAME_BIT 1
#define CAN0_IDR11_CRC_MASK 0x4
#define CAN0_IDR11_CRC 0x4
#define CAN0_IDR11_CRC_BIT 2
#define CAN0_IDR11_STUFF_MASK 0x8
#define CAN0_IDR11_STUFF 0x8
#define CAN0_IDR11_STUFF_BIT 3
#define CAN0_IDR11_BUS_MASK 0x10
#define CAN0_IDR11_BUS 0x10
#define CAN0_IDR11_BUS_BIT 4
#define CAN0_IDR11_RXOK_MASK 0x20
#define CAN0_IDR11_RXOK 0x20
#define CAN0_IDR11_RXOK_BIT 5
#define CAN0_IDR11_TXOK_MASK 0x40
#define CAN0_IDR11_TXOK 0x40
#define CAN0_IDR11_TXOK_BIT 6
#define CAN0_IDR11_RFRAME_MASK 0x80
#define CAN0_IDR11_RFRAME 0x80
#define CAN0_IDR11_RFRAME_BIT 7

#define CAN0_IMR11 (*(volatile unsigned long *)0xFFFD43E8)
#define CAN0_IMR11_OFFSET 0x3E8
#define CAN0_IMR11_ACK_MASK 0x1
#define CAN0_IMR11_ACK 0x1
#define CAN0_IMR11_ACK_BIT 0
#define CAN0_IMR11_FRAME_MASK 0x2
#define CAN0_IMR11_FRAME 0x2
#define CAN0_IMR11_FRAME_BIT 1
#define CAN0_IMR11_CRC_MASK 0x4
#define CAN0_IMR11_CRC 0x4
#define CAN0_IMR11_CRC_BIT 2
#define CAN0_IMR11_STUFF_MASK 0x8
#define CAN0_IMR11_STUFF 0x8
#define CAN0_IMR11_STUFF_BIT 3
#define CAN0_IMR11_BUS_MASK 0x10
#define CAN0_IMR11_BUS 0x10
#define CAN0_IMR11_BUS_BIT 4
#define CAN0_IMR11_RXOK_MASK 0x20
#define CAN0_IMR11_RXOK 0x20
#define CAN0_IMR11_RXOK_BIT 5
#define CAN0_IMR11_TXOK_MASK 0x40
#define CAN0_IMR11_TXOK 0x40
#define CAN0_IMR11_TXOK_BIT 6
#define CAN0_IMR11_RFRAME_MASK 0x80
#define CAN0_IMR11_RFRAME 0x80
#define CAN0_IMR11_RFRAME_BIT 7

#define CAN0_DRA12 (*(volatile unsigned long *)0xFFFD4400)
#define CAN0_DRA12_OFFSET 0x400
#define CAN0_DRA12_DATA0_MASK 0xFF
#define CAN0_DRA12_DATA0_BIT 0
#define CAN0_DRA12_DATA1_MASK 0xFF00
#define CAN0_DRA12_DATA1_BIT 8
#define CAN0_DRA12_DATA2_MASK 0xFF0000
#define CAN0_DRA12_DATA2_BIT 16
#define CAN0_DRA12_DATA3_MASK 0xFF000000
#define CAN0_DRA12_DATA3_BIT 24

#define CAN0_DRB12 (*(volatile unsigned long *)0xFFFD4404)
#define CAN0_DRB12_OFFSET 0x404
#define CAN0_DRB12_DATA4_MASK 0xFF
#define CAN0_DRB12_DATA4_BIT 0
#define CAN0_DRB12_DATA5_MASK 0xFF00
#define CAN0_DRB12_DATA5_BIT 8
#define CAN0_DRB12_DATA6_MASK 0xFF0000
#define CAN0_DRB12_DATA6_BIT 16
#define CAN0_DRB12_DATA7_MASK 0xFF000000
#define CAN0_DRB12_DATA7_BIT 24

#define CAN0_MSK12 (*(volatile unsigned long *)0xFFFD4408)
#define CAN0_MSK12_OFFSET 0x408
#define CAN0_MSK12_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK12_MASK_BIT 0
#define CAN0_MSK12_MRB_MASK 0x60000000
#define CAN0_MSK12_MRB_BIT 29
#define CAN0_MSK12_MRTR_MASK 0x80000000
#define CAN0_MSK12_MRTR 0x80000000
#define CAN0_MSK12_MRTR_BIT 31

#define CAN0_IR12 (*(volatile unsigned long *)0xFFFD440C)
#define CAN0_IR12_OFFSET 0x40C
#define CAN0_IR12_ID_MASK 0x1FFFFFFF
#define CAN0_IR12_ID_BIT 0
#define CAN0_IR12_RB_MASK 0x60000000
#define CAN0_IR12_RB_BIT 29
#define CAN0_IR12_RTR_MASK 0x80000000
#define CAN0_IR12_RTR 0x80000000
#define CAN0_IR12_RTR_BIT 31

#define CAN0_CR12 (*(volatile unsigned long *)0xFFFD4410)
#define CAN0_CR12_OFFSET 0x410
#define CAN0_CR12_DLC_MASK 0xF
#define CAN0_CR12_DLC_BIT 0
#define CAN0_CR12_IDE_MASK 0x10
#define CAN0_CR12_IDE 0x10
#define CAN0_CR12_IDE_BIT 4
#define CAN0_CR12_RPLYV_MASK 0x20
#define CAN0_CR12_RPLYV 0x20
#define CAN0_CR12_RPLYV_BIT 5
#define CAN0_CR12_PCB_MASK 0x40
#define CAN0_CR12_PCB 0x40
#define CAN0_CR12_PCB_BIT 6
#define CAN0_CR12_CHANEN_MASK 0x80
#define CAN0_CR12_CHANEN 0x80
#define CAN0_CR12_CHANEN_BIT 7
#define CAN0_CR12_OVERWRITE_MASK 0x100
#define CAN0_CR12_OVERWRITE 0x100
#define CAN0_CR12_OVERWRITE_BIT 8

#define CAN0_CR12 (*(volatile unsigned long *)0xFFFD4414)
#define CAN0_CR12_OFFSET 0x414
#define CAN0_CR12_STAMP_MASK 0x0
#define CAN0_CR12_STAMP_BIT 0

#define CAN0_CSR12 (*(volatile unsigned long *)0xFFFD4418)
#define CAN0_CSR12_OFFSET 0x418
#define CAN0_CSR12_ACK_MASK 0x1
#define CAN0_CSR12_ACK 0x1
#define CAN0_CSR12_ACK_BIT 0
#define CAN0_CSR12_FRAME_MASK 0x2
#define CAN0_CSR12_FRAME 0x2
#define CAN0_CSR12_FRAME_BIT 1
#define CAN0_CSR12_CRC_MASK 0x4
#define CAN0_CSR12_CRC 0x4
#define CAN0_CSR12_CRC_BIT 2
#define CAN0_CSR12_STUFF_MASK 0x8
#define CAN0_CSR12_STUFF 0x8
#define CAN0_CSR12_STUFF_BIT 3
#define CAN0_CSR12_BUS_MASK 0x10
#define CAN0_CSR12_BUS 0x10
#define CAN0_CSR12_BUS_BIT 4
#define CAN0_CSR12_RXOK_MASK 0x20
#define CAN0_CSR12_RXOK 0x20
#define CAN0_CSR12_RXOK_BIT 5
#define CAN0_CSR12_TXOK_MASK 0x40
#define CAN0_CSR12_TXOK 0x40
#define CAN0_CSR12_TXOK_BIT 6
#define CAN0_CSR12_RFRAME_MASK 0x80
#define CAN0_CSR12_RFRAME 0x80
#define CAN0_CSR12_RFRAME_BIT 7
#define CAN0_CSR12_DLCW_MASK 0x200
#define CAN0_CSR12_DLCW 0x200
#define CAN0_CSR12_DLCW_BIT 9
#define CAN0_CSR12_FILLED_MASK 0x400
#define CAN0_CSR12_FILLED 0x400
#define CAN0_CSR12_FILLED_BIT 10
#define CAN0_CSR12_OVRUN_MASK 0x800
#define CAN0_CSR12_OVRUN 0x800
#define CAN0_CSR12_OVRUN_BIT 11

#define CAN0_SR12 (*(volatile unsigned long *)0xFFFD441C)
#define CAN0_SR12_OFFSET 0x41C
#define CAN0_SR12_ACK_MASK 0x1
#define CAN0_SR12_ACK 0x1
#define CAN0_SR12_ACK_BIT 0
#define CAN0_SR12_FRAME_MASK 0x2
#define CAN0_SR12_FRAME 0x2
#define CAN0_SR12_FRAME_BIT 1
#define CAN0_SR12_CRC_MASK 0x4
#define CAN0_SR12_CRC 0x4
#define CAN0_SR12_CRC_BIT 2
#define CAN0_SR12_STUFF_MASK 0x8
#define CAN0_SR12_STUFF 0x8
#define CAN0_SR12_STUFF_BIT 3
#define CAN0_SR12_BUS_MASK 0x10
#define CAN0_SR12_BUS 0x10
#define CAN0_SR12_BUS_BIT 4
#define CAN0_SR12_RXOK_MASK 0x20
#define CAN0_SR12_RXOK 0x20
#define CAN0_SR12_RXOK_BIT 5
#define CAN0_SR12_TXOK_MASK 0x40
#define CAN0_SR12_TXOK 0x40
#define CAN0_SR12_TXOK_BIT 6
#define CAN0_SR12_RFRAME_MASK 0x80
#define CAN0_SR12_RFRAME 0x80
#define CAN0_SR12_RFRAME_BIT 7
#define CAN0_SR12_DLCW_MASK 0x200
#define CAN0_SR12_DLCW 0x200
#define CAN0_SR12_DLCW_BIT 9
#define CAN0_SR12_FILLED_MASK 0x400
#define CAN0_SR12_FILLED 0x400
#define CAN0_SR12_FILLED_BIT 10
#define CAN0_SR12_OVRUN_MASK 0x800
#define CAN0_SR12_OVRUN 0x800
#define CAN0_SR12_OVRUN_BIT 11

#define CAN0_IER12 (*(volatile unsigned long *)0xFFFD4420)
#define CAN0_IER12_OFFSET 0x420
#define CAN0_IER12_ACK_MASK 0x1
#define CAN0_IER12_ACK 0x1
#define CAN0_IER12_ACK_BIT 0
#define CAN0_IER12_FRAME_MASK 0x2
#define CAN0_IER12_FRAME 0x2
#define CAN0_IER12_FRAME_BIT 1
#define CAN0_IER12_CRC_MASK 0x4
#define CAN0_IER12_CRC 0x4
#define CAN0_IER12_CRC_BIT 2
#define CAN0_IER12_STUFF_MASK 0x8
#define CAN0_IER12_STUFF 0x8
#define CAN0_IER12_STUFF_BIT 3
#define CAN0_IER12_BUS_MASK 0x10
#define CAN0_IER12_BUS 0x10
#define CAN0_IER12_BUS_BIT 4
#define CAN0_IER12_RXOK_MASK 0x20
#define CAN0_IER12_RXOK 0x20
#define CAN0_IER12_RXOK_BIT 5
#define CAN0_IER12_TXOK_MASK 0x40
#define CAN0_IER12_TXOK 0x40
#define CAN0_IER12_TXOK_BIT 6
#define CAN0_IER12_RFRAME_MASK 0x80
#define CAN0_IER12_RFRAME 0x80
#define CAN0_IER12_RFRAME_BIT 7

#define CAN0_IDR12 (*(volatile unsigned long *)0xFFFD4424)
#define CAN0_IDR12_OFFSET 0x424
#define CAN0_IDR12_ACK_MASK 0x1
#define CAN0_IDR12_ACK 0x1
#define CAN0_IDR12_ACK_BIT 0
#define CAN0_IDR12_FRAME_MASK 0x2
#define CAN0_IDR12_FRAME 0x2
#define CAN0_IDR12_FRAME_BIT 1
#define CAN0_IDR12_CRC_MASK 0x4
#define CAN0_IDR12_CRC 0x4
#define CAN0_IDR12_CRC_BIT 2
#define CAN0_IDR12_STUFF_MASK 0x8
#define CAN0_IDR12_STUFF 0x8
#define CAN0_IDR12_STUFF_BIT 3
#define CAN0_IDR12_BUS_MASK 0x10
#define CAN0_IDR12_BUS 0x10
#define CAN0_IDR12_BUS_BIT 4
#define CAN0_IDR12_RXOK_MASK 0x20
#define CAN0_IDR12_RXOK 0x20
#define CAN0_IDR12_RXOK_BIT 5
#define CAN0_IDR12_TXOK_MASK 0x40
#define CAN0_IDR12_TXOK 0x40
#define CAN0_IDR12_TXOK_BIT 6
#define CAN0_IDR12_RFRAME_MASK 0x80
#define CAN0_IDR12_RFRAME 0x80
#define CAN0_IDR12_RFRAME_BIT 7

#define CAN0_IMR12 (*(volatile unsigned long *)0xFFFD4428)
#define CAN0_IMR12_OFFSET 0x428
#define CAN0_IMR12_ACK_MASK 0x1
#define CAN0_IMR12_ACK 0x1
#define CAN0_IMR12_ACK_BIT 0
#define CAN0_IMR12_FRAME_MASK 0x2
#define CAN0_IMR12_FRAME 0x2
#define CAN0_IMR12_FRAME_BIT 1
#define CAN0_IMR12_CRC_MASK 0x4
#define CAN0_IMR12_CRC 0x4
#define CAN0_IMR12_CRC_BIT 2
#define CAN0_IMR12_STUFF_MASK 0x8
#define CAN0_IMR12_STUFF 0x8
#define CAN0_IMR12_STUFF_BIT 3
#define CAN0_IMR12_BUS_MASK 0x10
#define CAN0_IMR12_BUS 0x10
#define CAN0_IMR12_BUS_BIT 4
#define CAN0_IMR12_RXOK_MASK 0x20
#define CAN0_IMR12_RXOK 0x20
#define CAN0_IMR12_RXOK_BIT 5
#define CAN0_IMR12_TXOK_MASK 0x40
#define CAN0_IMR12_TXOK 0x40
#define CAN0_IMR12_TXOK_BIT 6
#define CAN0_IMR12_RFRAME_MASK 0x80
#define CAN0_IMR12_RFRAME 0x80
#define CAN0_IMR12_RFRAME_BIT 7

#define CAN0_DRA13 (*(volatile unsigned long *)0xFFFD4440)
#define CAN0_DRA13_OFFSET 0x440
#define CAN0_DRA13_DATA0_MASK 0xFF
#define CAN0_DRA13_DATA0_BIT 0
#define CAN0_DRA13_DATA1_MASK 0xFF00
#define CAN0_DRA13_DATA1_BIT 8
#define CAN0_DRA13_DATA2_MASK 0xFF0000
#define CAN0_DRA13_DATA2_BIT 16
#define CAN0_DRA13_DATA3_MASK 0xFF000000
#define CAN0_DRA13_DATA3_BIT 24

#define CAN0_DRB13 (*(volatile unsigned long *)0xFFFD4444)
#define CAN0_DRB13_OFFSET 0x444
#define CAN0_DRB13_DATA4_MASK 0xFF
#define CAN0_DRB13_DATA4_BIT 0
#define CAN0_DRB13_DATA5_MASK 0xFF00
#define CAN0_DRB13_DATA5_BIT 8
#define CAN0_DRB13_DATA6_MASK 0xFF0000
#define CAN0_DRB13_DATA6_BIT 16
#define CAN0_DRB13_DATA7_MASK 0xFF000000
#define CAN0_DRB13_DATA7_BIT 24

#define CAN0_MSK13 (*(volatile unsigned long *)0xFFFD4448)
#define CAN0_MSK13_OFFSET 0x448
#define CAN0_MSK13_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK13_MASK_BIT 0
#define CAN0_MSK13_MRB_MASK 0x60000000
#define CAN0_MSK13_MRB_BIT 29
#define CAN0_MSK13_MRTR_MASK 0x80000000
#define CAN0_MSK13_MRTR 0x80000000
#define CAN0_MSK13_MRTR_BIT 31

#define CAN0_IR13 (*(volatile unsigned long *)0xFFFD444C)
#define CAN0_IR13_OFFSET 0x44C
#define CAN0_IR13_ID_MASK 0x1FFFFFFF
#define CAN0_IR13_ID_BIT 0
#define CAN0_IR13_RB_MASK 0x60000000
#define CAN0_IR13_RB_BIT 29
#define CAN0_IR13_RTR_MASK 0x80000000
#define CAN0_IR13_RTR 0x80000000
#define CAN0_IR13_RTR_BIT 31

#define CAN0_CR13 (*(volatile unsigned long *)0xFFFD4450)
#define CAN0_CR13_OFFSET 0x450
#define CAN0_CR13_DLC_MASK 0xF
#define CAN0_CR13_DLC_BIT 0
#define CAN0_CR13_IDE_MASK 0x10
#define CAN0_CR13_IDE 0x10
#define CAN0_CR13_IDE_BIT 4
#define CAN0_CR13_RPLYV_MASK 0x20
#define CAN0_CR13_RPLYV 0x20
#define CAN0_CR13_RPLYV_BIT 5
#define CAN0_CR13_PCB_MASK 0x40
#define CAN0_CR13_PCB 0x40
#define CAN0_CR13_PCB_BIT 6
#define CAN0_CR13_CHANEN_MASK 0x80
#define CAN0_CR13_CHANEN 0x80
#define CAN0_CR13_CHANEN_BIT 7
#define CAN0_CR13_OVERWRITE_MASK 0x100
#define CAN0_CR13_OVERWRITE 0x100
#define CAN0_CR13_OVERWRITE_BIT 8

#define CAN0_CR13 (*(volatile unsigned long *)0xFFFD4454)
#define CAN0_CR13_OFFSET 0x454
#define CAN0_CR13_STAMP_MASK 0x0
#define CAN0_CR13_STAMP_BIT 0

#define CAN0_CSR13 (*(volatile unsigned long *)0xFFFD4458)
#define CAN0_CSR13_OFFSET 0x458
#define CAN0_CSR13_ACK_MASK 0x1
#define CAN0_CSR13_ACK 0x1
#define CAN0_CSR13_ACK_BIT 0
#define CAN0_CSR13_FRAME_MASK 0x2
#define CAN0_CSR13_FRAME 0x2
#define CAN0_CSR13_FRAME_BIT 1
#define CAN0_CSR13_CRC_MASK 0x4
#define CAN0_CSR13_CRC 0x4
#define CAN0_CSR13_CRC_BIT 2
#define CAN0_CSR13_STUFF_MASK 0x8
#define CAN0_CSR13_STUFF 0x8
#define CAN0_CSR13_STUFF_BIT 3
#define CAN0_CSR13_BUS_MASK 0x10
#define CAN0_CSR13_BUS 0x10
#define CAN0_CSR13_BUS_BIT 4
#define CAN0_CSR13_RXOK_MASK 0x20
#define CAN0_CSR13_RXOK 0x20
#define CAN0_CSR13_RXOK_BIT 5
#define CAN0_CSR13_TXOK_MASK 0x40
#define CAN0_CSR13_TXOK 0x40
#define CAN0_CSR13_TXOK_BIT 6
#define CAN0_CSR13_RFRAME_MASK 0x80
#define CAN0_CSR13_RFRAME 0x80
#define CAN0_CSR13_RFRAME_BIT 7
#define CAN0_CSR13_DLCW_MASK 0x200
#define CAN0_CSR13_DLCW 0x200
#define CAN0_CSR13_DLCW_BIT 9
#define CAN0_CSR13_FILLED_MASK 0x400
#define CAN0_CSR13_FILLED 0x400
#define CAN0_CSR13_FILLED_BIT 10
#define CAN0_CSR13_OVRUN_MASK 0x800
#define CAN0_CSR13_OVRUN 0x800
#define CAN0_CSR13_OVRUN_BIT 11

#define CAN0_SR13 (*(volatile unsigned long *)0xFFFD445C)
#define CAN0_SR13_OFFSET 0x45C
#define CAN0_SR13_ACK_MASK 0x1
#define CAN0_SR13_ACK 0x1
#define CAN0_SR13_ACK_BIT 0
#define CAN0_SR13_FRAME_MASK 0x2
#define CAN0_SR13_FRAME 0x2
#define CAN0_SR13_FRAME_BIT 1
#define CAN0_SR13_CRC_MASK 0x4
#define CAN0_SR13_CRC 0x4
#define CAN0_SR13_CRC_BIT 2
#define CAN0_SR13_STUFF_MASK 0x8
#define CAN0_SR13_STUFF 0x8
#define CAN0_SR13_STUFF_BIT 3
#define CAN0_SR13_BUS_MASK 0x10
#define CAN0_SR13_BUS 0x10
#define CAN0_SR13_BUS_BIT 4
#define CAN0_SR13_RXOK_MASK 0x20
#define CAN0_SR13_RXOK 0x20
#define CAN0_SR13_RXOK_BIT 5
#define CAN0_SR13_TXOK_MASK 0x40
#define CAN0_SR13_TXOK 0x40
#define CAN0_SR13_TXOK_BIT 6
#define CAN0_SR13_RFRAME_MASK 0x80
#define CAN0_SR13_RFRAME 0x80
#define CAN0_SR13_RFRAME_BIT 7
#define CAN0_SR13_DLCW_MASK 0x200
#define CAN0_SR13_DLCW 0x200
#define CAN0_SR13_DLCW_BIT 9
#define CAN0_SR13_FILLED_MASK 0x400
#define CAN0_SR13_FILLED 0x400
#define CAN0_SR13_FILLED_BIT 10
#define CAN0_SR13_OVRUN_MASK 0x800
#define CAN0_SR13_OVRUN 0x800
#define CAN0_SR13_OVRUN_BIT 11

#define CAN0_IER13 (*(volatile unsigned long *)0xFFFD4460)
#define CAN0_IER13_OFFSET 0x460
#define CAN0_IER13_ACK_MASK 0x1
#define CAN0_IER13_ACK 0x1
#define CAN0_IER13_ACK_BIT 0
#define CAN0_IER13_FRAME_MASK 0x2
#define CAN0_IER13_FRAME 0x2
#define CAN0_IER13_FRAME_BIT 1
#define CAN0_IER13_CRC_MASK 0x4
#define CAN0_IER13_CRC 0x4
#define CAN0_IER13_CRC_BIT 2
#define CAN0_IER13_STUFF_MASK 0x8
#define CAN0_IER13_STUFF 0x8
#define CAN0_IER13_STUFF_BIT 3
#define CAN0_IER13_BUS_MASK 0x10
#define CAN0_IER13_BUS 0x10
#define CAN0_IER13_BUS_BIT 4
#define CAN0_IER13_RXOK_MASK 0x20
#define CAN0_IER13_RXOK 0x20
#define CAN0_IER13_RXOK_BIT 5
#define CAN0_IER13_TXOK_MASK 0x40
#define CAN0_IER13_TXOK 0x40
#define CAN0_IER13_TXOK_BIT 6
#define CAN0_IER13_RFRAME_MASK 0x80
#define CAN0_IER13_RFRAME 0x80
#define CAN0_IER13_RFRAME_BIT 7

#define CAN0_IDR13 (*(volatile unsigned long *)0xFFFD4464)
#define CAN0_IDR13_OFFSET 0x464
#define CAN0_IDR13_ACK_MASK 0x1
#define CAN0_IDR13_ACK 0x1
#define CAN0_IDR13_ACK_BIT 0
#define CAN0_IDR13_FRAME_MASK 0x2
#define CAN0_IDR13_FRAME 0x2
#define CAN0_IDR13_FRAME_BIT 1
#define CAN0_IDR13_CRC_MASK 0x4
#define CAN0_IDR13_CRC 0x4
#define CAN0_IDR13_CRC_BIT 2
#define CAN0_IDR13_STUFF_MASK 0x8
#define CAN0_IDR13_STUFF 0x8
#define CAN0_IDR13_STUFF_BIT 3
#define CAN0_IDR13_BUS_MASK 0x10
#define CAN0_IDR13_BUS 0x10
#define CAN0_IDR13_BUS_BIT 4
#define CAN0_IDR13_RXOK_MASK 0x20
#define CAN0_IDR13_RXOK 0x20
#define CAN0_IDR13_RXOK_BIT 5
#define CAN0_IDR13_TXOK_MASK 0x40
#define CAN0_IDR13_TXOK 0x40
#define CAN0_IDR13_TXOK_BIT 6
#define CAN0_IDR13_RFRAME_MASK 0x80
#define CAN0_IDR13_RFRAME 0x80
#define CAN0_IDR13_RFRAME_BIT 7

#define CAN0_IMR13 (*(volatile unsigned long *)0xFFFD4468)
#define CAN0_IMR13_OFFSET 0x468
#define CAN0_IMR13_ACK_MASK 0x1
#define CAN0_IMR13_ACK 0x1
#define CAN0_IMR13_ACK_BIT 0
#define CAN0_IMR13_FRAME_MASK 0x2
#define CAN0_IMR13_FRAME 0x2
#define CAN0_IMR13_FRAME_BIT 1
#define CAN0_IMR13_CRC_MASK 0x4
#define CAN0_IMR13_CRC 0x4
#define CAN0_IMR13_CRC_BIT 2
#define CAN0_IMR13_STUFF_MASK 0x8
#define CAN0_IMR13_STUFF 0x8
#define CAN0_IMR13_STUFF_BIT 3
#define CAN0_IMR13_BUS_MASK 0x10
#define CAN0_IMR13_BUS 0x10
#define CAN0_IMR13_BUS_BIT 4
#define CAN0_IMR13_RXOK_MASK 0x20
#define CAN0_IMR13_RXOK 0x20
#define CAN0_IMR13_RXOK_BIT 5
#define CAN0_IMR13_TXOK_MASK 0x40
#define CAN0_IMR13_TXOK 0x40
#define CAN0_IMR13_TXOK_BIT 6
#define CAN0_IMR13_RFRAME_MASK 0x80
#define CAN0_IMR13_RFRAME 0x80
#define CAN0_IMR13_RFRAME_BIT 7

#define CAN0_DRA14 (*(volatile unsigned long *)0xFFFD4480)
#define CAN0_DRA14_OFFSET 0x480
#define CAN0_DRA14_DATA0_MASK 0xFF
#define CAN0_DRA14_DATA0_BIT 0
#define CAN0_DRA14_DATA1_MASK 0xFF00
#define CAN0_DRA14_DATA1_BIT 8
#define CAN0_DRA14_DATA2_MASK 0xFF0000
#define CAN0_DRA14_DATA2_BIT 16
#define CAN0_DRA14_DATA3_MASK 0xFF000000
#define CAN0_DRA14_DATA3_BIT 24

#define CAN0_DRB14 (*(volatile unsigned long *)0xFFFD4484)
#define CAN0_DRB14_OFFSET 0x484
#define CAN0_DRB14_DATA4_MASK 0xFF
#define CAN0_DRB14_DATA4_BIT 0
#define CAN0_DRB14_DATA5_MASK 0xFF00
#define CAN0_DRB14_DATA5_BIT 8
#define CAN0_DRB14_DATA6_MASK 0xFF0000
#define CAN0_DRB14_DATA6_BIT 16
#define CAN0_DRB14_DATA7_MASK 0xFF000000
#define CAN0_DRB14_DATA7_BIT 24

#define CAN0_MSK14 (*(volatile unsigned long *)0xFFFD4488)
#define CAN0_MSK14_OFFSET 0x488
#define CAN0_MSK14_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK14_MASK_BIT 0
#define CAN0_MSK14_MRB_MASK 0x60000000
#define CAN0_MSK14_MRB_BIT 29
#define CAN0_MSK14_MRTR_MASK 0x80000000
#define CAN0_MSK14_MRTR 0x80000000
#define CAN0_MSK14_MRTR_BIT 31

#define CAN0_IR14 (*(volatile unsigned long *)0xFFFD448C)
#define CAN0_IR14_OFFSET 0x48C
#define CAN0_IR14_ID_MASK 0x1FFFFFFF
#define CAN0_IR14_ID_BIT 0
#define CAN0_IR14_RB_MASK 0x60000000
#define CAN0_IR14_RB_BIT 29
#define CAN0_IR14_RTR_MASK 0x80000000
#define CAN0_IR14_RTR 0x80000000
#define CAN0_IR14_RTR_BIT 31

#define CAN0_CR14 (*(volatile unsigned long *)0xFFFD4490)
#define CAN0_CR14_OFFSET 0x490
#define CAN0_CR14_DLC_MASK 0xF
#define CAN0_CR14_DLC_BIT 0
#define CAN0_CR14_IDE_MASK 0x10
#define CAN0_CR14_IDE 0x10
#define CAN0_CR14_IDE_BIT 4
#define CAN0_CR14_RPLYV_MASK 0x20
#define CAN0_CR14_RPLYV 0x20
#define CAN0_CR14_RPLYV_BIT 5
#define CAN0_CR14_PCB_MASK 0x40
#define CAN0_CR14_PCB 0x40
#define CAN0_CR14_PCB_BIT 6
#define CAN0_CR14_CHANEN_MASK 0x80
#define CAN0_CR14_CHANEN 0x80
#define CAN0_CR14_CHANEN_BIT 7
#define CAN0_CR14_OVERWRITE_MASK 0x100
#define CAN0_CR14_OVERWRITE 0x100
#define CAN0_CR14_OVERWRITE_BIT 8

#define CAN0_CR14 (*(volatile unsigned long *)0xFFFD4494)
#define CAN0_CR14_OFFSET 0x494
#define CAN0_CR14_STAMP_MASK 0x0
#define CAN0_CR14_STAMP_BIT 0

#define CAN0_CSR14 (*(volatile unsigned long *)0xFFFD4498)
#define CAN0_CSR14_OFFSET 0x498
#define CAN0_CSR14_ACK_MASK 0x1
#define CAN0_CSR14_ACK 0x1
#define CAN0_CSR14_ACK_BIT 0
#define CAN0_CSR14_FRAME_MASK 0x2
#define CAN0_CSR14_FRAME 0x2
#define CAN0_CSR14_FRAME_BIT 1
#define CAN0_CSR14_CRC_MASK 0x4
#define CAN0_CSR14_CRC 0x4
#define CAN0_CSR14_CRC_BIT 2
#define CAN0_CSR14_STUFF_MASK 0x8
#define CAN0_CSR14_STUFF 0x8
#define CAN0_CSR14_STUFF_BIT 3
#define CAN0_CSR14_BUS_MASK 0x10
#define CAN0_CSR14_BUS 0x10
#define CAN0_CSR14_BUS_BIT 4
#define CAN0_CSR14_RXOK_MASK 0x20
#define CAN0_CSR14_RXOK 0x20
#define CAN0_CSR14_RXOK_BIT 5
#define CAN0_CSR14_TXOK_MASK 0x40
#define CAN0_CSR14_TXOK 0x40
#define CAN0_CSR14_TXOK_BIT 6
#define CAN0_CSR14_RFRAME_MASK 0x80
#define CAN0_CSR14_RFRAME 0x80
#define CAN0_CSR14_RFRAME_BIT 7
#define CAN0_CSR14_DLCW_MASK 0x200
#define CAN0_CSR14_DLCW 0x200
#define CAN0_CSR14_DLCW_BIT 9
#define CAN0_CSR14_FILLED_MASK 0x400
#define CAN0_CSR14_FILLED 0x400
#define CAN0_CSR14_FILLED_BIT 10
#define CAN0_CSR14_OVRUN_MASK 0x800
#define CAN0_CSR14_OVRUN 0x800
#define CAN0_CSR14_OVRUN_BIT 11

#define CAN0_SR14 (*(volatile unsigned long *)0xFFFD449C)
#define CAN0_SR14_OFFSET 0x49C
#define CAN0_SR14_ACK_MASK 0x1
#define CAN0_SR14_ACK 0x1
#define CAN0_SR14_ACK_BIT 0
#define CAN0_SR14_FRAME_MASK 0x2
#define CAN0_SR14_FRAME 0x2
#define CAN0_SR14_FRAME_BIT 1
#define CAN0_SR14_CRC_MASK 0x4
#define CAN0_SR14_CRC 0x4
#define CAN0_SR14_CRC_BIT 2
#define CAN0_SR14_STUFF_MASK 0x8
#define CAN0_SR14_STUFF 0x8
#define CAN0_SR14_STUFF_BIT 3
#define CAN0_SR14_BUS_MASK 0x10
#define CAN0_SR14_BUS 0x10
#define CAN0_SR14_BUS_BIT 4
#define CAN0_SR14_RXOK_MASK 0x20
#define CAN0_SR14_RXOK 0x20
#define CAN0_SR14_RXOK_BIT 5
#define CAN0_SR14_TXOK_MASK 0x40
#define CAN0_SR14_TXOK 0x40
#define CAN0_SR14_TXOK_BIT 6
#define CAN0_SR14_RFRAME_MASK 0x80
#define CAN0_SR14_RFRAME 0x80
#define CAN0_SR14_RFRAME_BIT 7
#define CAN0_SR14_DLCW_MASK 0x200
#define CAN0_SR14_DLCW 0x200
#define CAN0_SR14_DLCW_BIT 9
#define CAN0_SR14_FILLED_MASK 0x400
#define CAN0_SR14_FILLED 0x400
#define CAN0_SR14_FILLED_BIT 10
#define CAN0_SR14_OVRUN_MASK 0x800
#define CAN0_SR14_OVRUN 0x800
#define CAN0_SR14_OVRUN_BIT 11

#define CAN0_IER14 (*(volatile unsigned long *)0xFFFD44A0)
#define CAN0_IER14_OFFSET 0x4A0
#define CAN0_IER14_ACK_MASK 0x1
#define CAN0_IER14_ACK 0x1
#define CAN0_IER14_ACK_BIT 0
#define CAN0_IER14_FRAME_MASK 0x2
#define CAN0_IER14_FRAME 0x2
#define CAN0_IER14_FRAME_BIT 1
#define CAN0_IER14_CRC_MASK 0x4
#define CAN0_IER14_CRC 0x4
#define CAN0_IER14_CRC_BIT 2
#define CAN0_IER14_STUFF_MASK 0x8
#define CAN0_IER14_STUFF 0x8
#define CAN0_IER14_STUFF_BIT 3
#define CAN0_IER14_BUS_MASK 0x10
#define CAN0_IER14_BUS 0x10
#define CAN0_IER14_BUS_BIT 4
#define CAN0_IER14_RXOK_MASK 0x20
#define CAN0_IER14_RXOK 0x20
#define CAN0_IER14_RXOK_BIT 5
#define CAN0_IER14_TXOK_MASK 0x40
#define CAN0_IER14_TXOK 0x40
#define CAN0_IER14_TXOK_BIT 6
#define CAN0_IER14_RFRAME_MASK 0x80
#define CAN0_IER14_RFRAME 0x80
#define CAN0_IER14_RFRAME_BIT 7

#define CAN0_IDR14 (*(volatile unsigned long *)0xFFFD44A4)
#define CAN0_IDR14_OFFSET 0x4A4
#define CAN0_IDR14_ACK_MASK 0x1
#define CAN0_IDR14_ACK 0x1
#define CAN0_IDR14_ACK_BIT 0
#define CAN0_IDR14_FRAME_MASK 0x2
#define CAN0_IDR14_FRAME 0x2
#define CAN0_IDR14_FRAME_BIT 1
#define CAN0_IDR14_CRC_MASK 0x4
#define CAN0_IDR14_CRC 0x4
#define CAN0_IDR14_CRC_BIT 2
#define CAN0_IDR14_STUFF_MASK 0x8
#define CAN0_IDR14_STUFF 0x8
#define CAN0_IDR14_STUFF_BIT 3
#define CAN0_IDR14_BUS_MASK 0x10
#define CAN0_IDR14_BUS 0x10
#define CAN0_IDR14_BUS_BIT 4
#define CAN0_IDR14_RXOK_MASK 0x20
#define CAN0_IDR14_RXOK 0x20
#define CAN0_IDR14_RXOK_BIT 5
#define CAN0_IDR14_TXOK_MASK 0x40
#define CAN0_IDR14_TXOK 0x40
#define CAN0_IDR14_TXOK_BIT 6
#define CAN0_IDR14_RFRAME_MASK 0x80
#define CAN0_IDR14_RFRAME 0x80
#define CAN0_IDR14_RFRAME_BIT 7

#define CAN0_IMR14 (*(volatile unsigned long *)0xFFFD44A8)
#define CAN0_IMR14_OFFSET 0x4A8
#define CAN0_IMR14_ACK_MASK 0x1
#define CAN0_IMR14_ACK 0x1
#define CAN0_IMR14_ACK_BIT 0
#define CAN0_IMR14_FRAME_MASK 0x2
#define CAN0_IMR14_FRAME 0x2
#define CAN0_IMR14_FRAME_BIT 1
#define CAN0_IMR14_CRC_MASK 0x4
#define CAN0_IMR14_CRC 0x4
#define CAN0_IMR14_CRC_BIT 2
#define CAN0_IMR14_STUFF_MASK 0x8
#define CAN0_IMR14_STUFF 0x8
#define CAN0_IMR14_STUFF_BIT 3
#define CAN0_IMR14_BUS_MASK 0x10
#define CAN0_IMR14_BUS 0x10
#define CAN0_IMR14_BUS_BIT 4
#define CAN0_IMR14_RXOK_MASK 0x20
#define CAN0_IMR14_RXOK 0x20
#define CAN0_IMR14_RXOK_BIT 5
#define CAN0_IMR14_TXOK_MASK 0x40
#define CAN0_IMR14_TXOK 0x40
#define CAN0_IMR14_TXOK_BIT 6
#define CAN0_IMR14_RFRAME_MASK 0x80
#define CAN0_IMR14_RFRAME 0x80
#define CAN0_IMR14_RFRAME_BIT 7

#define CAN0_DRA15 (*(volatile unsigned long *)0xFFFD44C0)
#define CAN0_DRA15_OFFSET 0x4C0
#define CAN0_DRA15_DATA0_MASK 0xFF
#define CAN0_DRA15_DATA0_BIT 0
#define CAN0_DRA15_DATA1_MASK 0xFF00
#define CAN0_DRA15_DATA1_BIT 8
#define CAN0_DRA15_DATA2_MASK 0xFF0000
#define CAN0_DRA15_DATA2_BIT 16
#define CAN0_DRA15_DATA3_MASK 0xFF000000
#define CAN0_DRA15_DATA3_BIT 24

#define CAN0_DRB15 (*(volatile unsigned long *)0xFFFD44C4)
#define CAN0_DRB15_OFFSET 0x4C4
#define CAN0_DRB15_DATA4_MASK 0xFF
#define CAN0_DRB15_DATA4_BIT 0
#define CAN0_DRB15_DATA5_MASK 0xFF00
#define CAN0_DRB15_DATA5_BIT 8
#define CAN0_DRB15_DATA6_MASK 0xFF0000
#define CAN0_DRB15_DATA6_BIT 16
#define CAN0_DRB15_DATA7_MASK 0xFF000000
#define CAN0_DRB15_DATA7_BIT 24

#define CAN0_MSK15 (*(volatile unsigned long *)0xFFFD44C8)
#define CAN0_MSK15_OFFSET 0x4C8
#define CAN0_MSK15_MASK_MASK 0x1FFFFFFF
#define CAN0_MSK15_MASK_BIT 0
#define CAN0_MSK15_MRB_MASK 0x60000000
#define CAN0_MSK15_MRB_BIT 29
#define CAN0_MSK15_MRTR_MASK 0x80000000
#define CAN0_MSK15_MRTR 0x80000000
#define CAN0_MSK15_MRTR_BIT 31

#define CAN0_IR15 (*(volatile unsigned long *)0xFFFD44CC)
#define CAN0_IR15_OFFSET 0x4CC
#define CAN0_IR15_ID_MASK 0x1FFFFFFF
#define CAN0_IR15_ID_BIT 0
#define CAN0_IR15_RB_MASK 0x60000000
#define CAN0_IR15_RB_BIT 29
#define CAN0_IR15_RTR_MASK 0x80000000
#define CAN0_IR15_RTR 0x80000000
#define CAN0_IR15_RTR_BIT 31

#define CAN0_CR15 (*(volatile unsigned long *)0xFFFD44D0)
#define CAN0_CR15_OFFSET 0x4D0
#define CAN0_CR15_DLC_MASK 0xF
#define CAN0_CR15_DLC_BIT 0
#define CAN0_CR15_IDE_MASK 0x10
#define CAN0_CR15_IDE 0x10
#define CAN0_CR15_IDE_BIT 4
#define CAN0_CR15_RPLYV_MASK 0x20
#define CAN0_CR15_RPLYV 0x20
#define CAN0_CR15_RPLYV_BIT 5
#define CAN0_CR15_PCB_MASK 0x40
#define CAN0_CR15_PCB 0x40
#define CAN0_CR15_PCB_BIT 6
#define CAN0_CR15_CHANEN_MASK 0x80
#define CAN0_CR15_CHANEN 0x80
#define CAN0_CR15_CHANEN_BIT 7
#define CAN0_CR15_OVERWRITE_MASK 0x100
#define CAN0_CR15_OVERWRITE 0x100
#define CAN0_CR15_OVERWRITE_BIT 8

#define CAN0_CR15 (*(volatile unsigned long *)0xFFFD44D4)
#define CAN0_CR15_OFFSET 0x4D4
#define CAN0_CR15_STAMP_MASK 0x0
#define CAN0_CR15_STAMP_BIT 0

#define CAN0_CSR15 (*(volatile unsigned long *)0xFFFD44D8)
#define CAN0_CSR15_OFFSET 0x4D8
#define CAN0_CSR15_ACK_MASK 0x1
#define CAN0_CSR15_ACK 0x1
#define CAN0_CSR15_ACK_BIT 0
#define CAN0_CSR15_FRAME_MASK 0x2
#define CAN0_CSR15_FRAME 0x2
#define CAN0_CSR15_FRAME_BIT 1
#define CAN0_CSR15_CRC_MASK 0x4
#define CAN0_CSR15_CRC 0x4
#define CAN0_CSR15_CRC_BIT 2
#define CAN0_CSR15_STUFF_MASK 0x8
#define CAN0_CSR15_STUFF 0x8
#define CAN0_CSR15_STUFF_BIT 3
#define CAN0_CSR15_BUS_MASK 0x10
#define CAN0_CSR15_BUS 0x10
#define CAN0_CSR15_BUS_BIT 4
#define CAN0_CSR15_RXOK_MASK 0x20
#define CAN0_CSR15_RXOK 0x20
#define CAN0_CSR15_RXOK_BIT 5
#define CAN0_CSR15_TXOK_MASK 0x40
#define CAN0_CSR15_TXOK 0x40
#define CAN0_CSR15_TXOK_BIT 6
#define CAN0_CSR15_RFRAME_MASK 0x80
#define CAN0_CSR15_RFRAME 0x80
#define CAN0_CSR15_RFRAME_BIT 7
#define CAN0_CSR15_DLCW_MASK 0x200
#define CAN0_CSR15_DLCW 0x200
#define CAN0_CSR15_DLCW_BIT 9
#define CAN0_CSR15_FILLED_MASK 0x400
#define CAN0_CSR15_FILLED 0x400
#define CAN0_CSR15_FILLED_BIT 10
#define CAN0_CSR15_OVRUN_MASK 0x800
#define CAN0_CSR15_OVRUN 0x800
#define CAN0_CSR15_OVRUN_BIT 11

#define CAN0_SR15 (*(volatile unsigned long *)0xFFFD44DC)
#define CAN0_SR15_OFFSET 0x4DC
#define CAN0_SR15_ACK_MASK 0x1
#define CAN0_SR15_ACK 0x1
#define CAN0_SR15_ACK_BIT 0
#define CAN0_SR15_FRAME_MASK 0x2
#define CAN0_SR15_FRAME 0x2
#define CAN0_SR15_FRAME_BIT 1
#define CAN0_SR15_CRC_MASK 0x4
#define CAN0_SR15_CRC 0x4
#define CAN0_SR15_CRC_BIT 2
#define CAN0_SR15_STUFF_MASK 0x8
#define CAN0_SR15_STUFF 0x8
#define CAN0_SR15_STUFF_BIT 3
#define CAN0_SR15_BUS_MASK 0x10
#define CAN0_SR15_BUS 0x10
#define CAN0_SR15_BUS_BIT 4
#define CAN0_SR15_RXOK_MASK 0x20
#define CAN0_SR15_RXOK 0x20
#define CAN0_SR15_RXOK_BIT 5
#define CAN0_SR15_TXOK_MASK 0x40
#define CAN0_SR15_TXOK 0x40
#define CAN0_SR15_TXOK_BIT 6
#define CAN0_SR15_RFRAME_MASK 0x80
#define CAN0_SR15_RFRAME 0x80
#define CAN0_SR15_RFRAME_BIT 7
#define CAN0_SR15_DLCW_MASK 0x200
#define CAN0_SR15_DLCW 0x200
#define CAN0_SR15_DLCW_BIT 9
#define CAN0_SR15_FILLED_MASK 0x400
#define CAN0_SR15_FILLED 0x400
#define CAN0_SR15_FILLED_BIT 10
#define CAN0_SR15_OVRUN_MASK 0x800
#define CAN0_SR15_OVRUN 0x800
#define CAN0_SR15_OVRUN_BIT 11

#define CAN0_IER15 (*(volatile unsigned long *)0xFFFD44E0)
#define CAN0_IER15_OFFSET 0x4E0
#define CAN0_IER15_ACK_MASK 0x1
#define CAN0_IER15_ACK 0x1
#define CAN0_IER15_ACK_BIT 0
#define CAN0_IER15_FRAME_MASK 0x2
#define CAN0_IER15_FRAME 0x2
#define CAN0_IER15_FRAME_BIT 1
#define CAN0_IER15_CRC_MASK 0x4
#define CAN0_IER15_CRC 0x4
#define CAN0_IER15_CRC_BIT 2
#define CAN0_IER15_STUFF_MASK 0x8
#define CAN0_IER15_STUFF 0x8
#define CAN0_IER15_STUFF_BIT 3
#define CAN0_IER15_BUS_MASK 0x10
#define CAN0_IER15_BUS 0x10
#define CAN0_IER15_BUS_BIT 4
#define CAN0_IER15_RXOK_MASK 0x20
#define CAN0_IER15_RXOK 0x20
#define CAN0_IER15_RXOK_BIT 5
#define CAN0_IER15_TXOK_MASK 0x40
#define CAN0_IER15_TXOK 0x40
#define CAN0_IER15_TXOK_BIT 6
#define CAN0_IER15_RFRAME_MASK 0x80
#define CAN0_IER15_RFRAME 0x80
#define CAN0_IER15_RFRAME_BIT 7

#define CAN0_IDR15 (*(volatile unsigned long *)0xFFFD44E4)
#define CAN0_IDR15_OFFSET 0x4E4
#define CAN0_IDR15_ACK_MASK 0x1
#define CAN0_IDR15_ACK 0x1
#define CAN0_IDR15_ACK_BIT 0
#define CAN0_IDR15_FRAME_MASK 0x2
#define CAN0_IDR15_FRAME 0x2
#define CAN0_IDR15_FRAME_BIT 1
#define CAN0_IDR15_CRC_MASK 0x4
#define CAN0_IDR15_CRC 0x4
#define CAN0_IDR15_CRC_BIT 2
#define CAN0_IDR15_STUFF_MASK 0x8
#define CAN0_IDR15_STUFF 0x8
#define CAN0_IDR15_STUFF_BIT 3
#define CAN0_IDR15_BUS_MASK 0x10
#define CAN0_IDR15_BUS 0x10
#define CAN0_IDR15_BUS_BIT 4
#define CAN0_IDR15_RXOK_MASK 0x20
#define CAN0_IDR15_RXOK 0x20
#define CAN0_IDR15_RXOK_BIT 5
#define CAN0_IDR15_TXOK_MASK 0x40
#define CAN0_IDR15_TXOK 0x40
#define CAN0_IDR15_TXOK_BIT 6
#define CAN0_IDR15_RFRAME_MASK 0x80
#define CAN0_IDR15_RFRAME 0x80
#define CAN0_IDR15_RFRAME_BIT 7

#define CAN0_IMR15 (*(volatile unsigned long *)0xFFFD44E8)
#define CAN0_IMR15_OFFSET 0x4E8
#define CAN0_IMR15_ACK_MASK 0x1
#define CAN0_IMR15_ACK 0x1
#define CAN0_IMR15_ACK_BIT 0
#define CAN0_IMR15_FRAME_MASK 0x2
#define CAN0_IMR15_FRAME 0x2
#define CAN0_IMR15_FRAME_BIT 1
#define CAN0_IMR15_CRC_MASK 0x4
#define CAN0_IMR15_CRC 0x4
#define CAN0_IMR15_CRC_BIT 2
#define CAN0_IMR15_STUFF_MASK 0x8
#define CAN0_IMR15_STUFF 0x8
#define CAN0_IMR15_STUFF_BIT 3
#define CAN0_IMR15_BUS_MASK 0x10
#define CAN0_IMR15_BUS 0x10
#define CAN0_IMR15_BUS_BIT 4
#define CAN0_IMR15_RXOK_MASK 0x20
#define CAN0_IMR15_RXOK 0x20
#define CAN0_IMR15_RXOK_BIT 5
#define CAN0_IMR15_TXOK_MASK 0x40
#define CAN0_IMR15_TXOK 0x40
#define CAN0_IMR15_TXOK_BIT 6
#define CAN0_IMR15_RFRAME_MASK 0x80
#define CAN0_IMR15_RFRAME 0x80
#define CAN0_IMR15_RFRAME_BIT 7

#define UPIO_BASE 0xFFFD8000

#define UPIO_OER (*(volatile unsigned long *)0xFFFD8010)
#define UPIO_OER_OFFSET 0x10
#define UPIO_OER_P0_MASK 0x1
#define UPIO_OER_P0 0x1
#define UPIO_OER_P0_BIT 0
#define UPIO_OER_P1_MASK 0x2
#define UPIO_OER_P1 0x2
#define UPIO_OER_P1_BIT 1
#define UPIO_OER_P2_MASK 0x4
#define UPIO_OER_P2 0x4
#define UPIO_OER_P2_BIT 2
#define UPIO_OER_P3_MASK 0x8
#define UPIO_OER_P3 0x8
#define UPIO_OER_P3_BIT 3
#define UPIO_OER_P4_MASK 0x10
#define UPIO_OER_P4 0x10
#define UPIO_OER_P4_BIT 4
#define UPIO_OER_P5_MASK 0x20
#define UPIO_OER_P5 0x20
#define UPIO_OER_P5_BIT 5
#define UPIO_OER_P6_MASK 0x40
#define UPIO_OER_P6 0x40
#define UPIO_OER_P6_BIT 6
#define UPIO_OER_P7_MASK 0x80
#define UPIO_OER_P7 0x80
#define UPIO_OER_P7_BIT 7
#define UPIO_OER_P8_MASK 0x100
#define UPIO_OER_P8 0x100
#define UPIO_OER_P8_BIT 8
#define UPIO_OER_P9_MASK 0x200
#define UPIO_OER_P9 0x200
#define UPIO_OER_P9_BIT 9
#define UPIO_OER_P10_MASK 0x400
#define UPIO_OER_P10 0x400
#define UPIO_OER_P10_BIT 10
#define UPIO_OER_P11_MASK 0x800
#define UPIO_OER_P11 0x800
#define UPIO_OER_P11_BIT 11
#define UPIO_OER_P12_MASK 0x1000
#define UPIO_OER_P12 0x1000
#define UPIO_OER_P12_BIT 12
#define UPIO_OER_P13_MASK 0x2000
#define UPIO_OER_P13 0x2000
#define UPIO_OER_P13_BIT 13
#define UPIO_OER_P14_MASK 0x4000
#define UPIO_OER_P14 0x4000
#define UPIO_OER_P14_BIT 14
#define UPIO_OER_P15_MASK 0x8000
#define UPIO_OER_P15 0x8000
#define UPIO_OER_P15_BIT 15
#define UPIO_OER_P16_MASK 0x10000
#define UPIO_OER_P16 0x10000
#define UPIO_OER_P16_BIT 16
#define UPIO_OER_P17_MASK 0x20000
#define UPIO_OER_P17 0x20000
#define UPIO_OER_P17_BIT 17

#define UPIO_ODR (*(volatile unsigned long *)0xFFFD8014)
#define UPIO_ODR_OFFSET 0x14
#define UPIO_ODR_P0_MASK 0x1
#define UPIO_ODR_P0 0x1
#define UPIO_ODR_P0_BIT 0
#define UPIO_ODR_P1_MASK 0x2
#define UPIO_ODR_P1 0x2
#define UPIO_ODR_P1_BIT 1
#define UPIO_ODR_P2_MASK 0x4
#define UPIO_ODR_P2 0x4
#define UPIO_ODR_P2_BIT 2
#define UPIO_ODR_P3_MASK 0x8
#define UPIO_ODR_P3 0x8
#define UPIO_ODR_P3_BIT 3
#define UPIO_ODR_P4_MASK 0x10
#define UPIO_ODR_P4 0x10
#define UPIO_ODR_P4_BIT 4
#define UPIO_ODR_P5_MASK 0x20
#define UPIO_ODR_P5 0x20
#define UPIO_ODR_P5_BIT 5
#define UPIO_ODR_P6_MASK 0x40
#define UPIO_ODR_P6 0x40
#define UPIO_ODR_P6_BIT 6
#define UPIO_ODR_P7_MASK 0x80
#define UPIO_ODR_P7 0x80
#define UPIO_ODR_P7_BIT 7
#define UPIO_ODR_P8_MASK 0x100
#define UPIO_ODR_P8 0x100
#define UPIO_ODR_P8_BIT 8
#define UPIO_ODR_P9_MASK 0x200
#define UPIO_ODR_P9 0x200
#define UPIO_ODR_P9_BIT 9
#define UPIO_ODR_P10_MASK 0x400
#define UPIO_ODR_P10 0x400
#define UPIO_ODR_P10_BIT 10
#define UPIO_ODR_P11_MASK 0x800
#define UPIO_ODR_P11 0x800
#define UPIO_ODR_P11_BIT 11
#define UPIO_ODR_P12_MASK 0x1000
#define UPIO_ODR_P12 0x1000
#define UPIO_ODR_P12_BIT 12
#define UPIO_ODR_P13_MASK 0x2000
#define UPIO_ODR_P13 0x2000
#define UPIO_ODR_P13_BIT 13
#define UPIO_ODR_P14_MASK 0x4000
#define UPIO_ODR_P14 0x4000
#define UPIO_ODR_P14_BIT 14
#define UPIO_ODR_P15_MASK 0x8000
#define UPIO_ODR_P15 0x8000
#define UPIO_ODR_P15_BIT 15
#define UPIO_ODR_P16_MASK 0x10000
#define UPIO_ODR_P16 0x10000
#define UPIO_ODR_P16_BIT 16
#define UPIO_ODR_P17_MASK 0x20000
#define UPIO_ODR_P17 0x20000
#define UPIO_ODR_P17_BIT 17

#define UPIO_OSR (*(volatile unsigned long *)0xFFFD8018)
#define UPIO_OSR_OFFSET 0x18
#define UPIO_OSR_P0_MASK 0x1
#define UPIO_OSR_P0 0x1
#define UPIO_OSR_P0_BIT 0
#define UPIO_OSR_P1_MASK 0x2
#define UPIO_OSR_P1 0x2
#define UPIO_OSR_P1_BIT 1
#define UPIO_OSR_P2_MASK 0x4
#define UPIO_OSR_P2 0x4
#define UPIO_OSR_P2_BIT 2
#define UPIO_OSR_P3_MASK 0x8
#define UPIO_OSR_P3 0x8
#define UPIO_OSR_P3_BIT 3
#define UPIO_OSR_P4_MASK 0x10
#define UPIO_OSR_P4 0x10
#define UPIO_OSR_P4_BIT 4
#define UPIO_OSR_P5_MASK 0x20
#define UPIO_OSR_P5 0x20
#define UPIO_OSR_P5_BIT 5
#define UPIO_OSR_P6_MASK 0x40
#define UPIO_OSR_P6 0x40
#define UPIO_OSR_P6_BIT 6
#define UPIO_OSR_P7_MASK 0x80
#define UPIO_OSR_P7 0x80
#define UPIO_OSR_P7_BIT 7
#define UPIO_OSR_P8_MASK 0x100
#define UPIO_OSR_P8 0x100
#define UPIO_OSR_P8_BIT 8
#define UPIO_OSR_P9_MASK 0x200
#define UPIO_OSR_P9 0x200
#define UPIO_OSR_P9_BIT 9
#define UPIO_OSR_P10_MASK 0x400
#define UPIO_OSR_P10 0x400
#define UPIO_OSR_P10_BIT 10
#define UPIO_OSR_P11_MASK 0x800
#define UPIO_OSR_P11 0x800
#define UPIO_OSR_P11_BIT 11
#define UPIO_OSR_P12_MASK 0x1000
#define UPIO_OSR_P12 0x1000
#define UPIO_OSR_P12_BIT 12
#define UPIO_OSR_P13_MASK 0x2000
#define UPIO_OSR_P13 0x2000
#define UPIO_OSR_P13_BIT 13
#define UPIO_OSR_P14_MASK 0x4000
#define UPIO_OSR_P14 0x4000
#define UPIO_OSR_P14_BIT 14
#define UPIO_OSR_P15_MASK 0x8000
#define UPIO_OSR_P15 0x8000
#define UPIO_OSR_P15_BIT 15
#define UPIO_OSR_P16_MASK 0x10000
#define UPIO_OSR_P16 0x10000
#define UPIO_OSR_P16_BIT 16
#define UPIO_OSR_P17_MASK 0x20000
#define UPIO_OSR_P17 0x20000
#define UPIO_OSR_P17_BIT 17

#define UPIO_SODR (*(volatile unsigned long *)0xFFFD8030)
#define UPIO_SODR_OFFSET 0x30
#define UPIO_SODR_P0_MASK 0x1
#define UPIO_SODR_P0 0x1
#define UPIO_SODR_P0_BIT 0
#define UPIO_SODR_P1_MASK 0x2
#define UPIO_SODR_P1 0x2
#define UPIO_SODR_P1_BIT 1
#define UPIO_SODR_P2_MASK 0x4
#define UPIO_SODR_P2 0x4
#define UPIO_SODR_P2_BIT 2
#define UPIO_SODR_P3_MASK 0x8
#define UPIO_SODR_P3 0x8
#define UPIO_SODR_P3_BIT 3
#define UPIO_SODR_P4_MASK 0x10
#define UPIO_SODR_P4 0x10
#define UPIO_SODR_P4_BIT 4
#define UPIO_SODR_P5_MASK 0x20
#define UPIO_SODR_P5 0x20
#define UPIO_SODR_P5_BIT 5
#define UPIO_SODR_P6_MASK 0x40
#define UPIO_SODR_P6 0x40
#define UPIO_SODR_P6_BIT 6
#define UPIO_SODR_P7_MASK 0x80
#define UPIO_SODR_P7 0x80
#define UPIO_SODR_P7_BIT 7
#define UPIO_SODR_P8_MASK 0x100
#define UPIO_SODR_P8 0x100
#define UPIO_SODR_P8_BIT 8
#define UPIO_SODR_P9_MASK 0x200
#define UPIO_SODR_P9 0x200
#define UPIO_SODR_P9_BIT 9
#define UPIO_SODR_P10_MASK 0x400
#define UPIO_SODR_P10 0x400
#define UPIO_SODR_P10_BIT 10
#define UPIO_SODR_P11_MASK 0x800
#define UPIO_SODR_P11 0x800
#define UPIO_SODR_P11_BIT 11
#define UPIO_SODR_P12_MASK 0x1000
#define UPIO_SODR_P12 0x1000
#define UPIO_SODR_P12_BIT 12
#define UPIO_SODR_P13_MASK 0x2000
#define UPIO_SODR_P13 0x2000
#define UPIO_SODR_P13_BIT 13
#define UPIO_SODR_P14_MASK 0x4000
#define UPIO_SODR_P14 0x4000
#define UPIO_SODR_P14_BIT 14
#define UPIO_SODR_P15_MASK 0x8000
#define UPIO_SODR_P15 0x8000
#define UPIO_SODR_P15_BIT 15
#define UPIO_SODR_P16_MASK 0x10000
#define UPIO_SODR_P16 0x10000
#define UPIO_SODR_P16_BIT 16
#define UPIO_SODR_P17_MASK 0x20000
#define UPIO_SODR_P17 0x20000
#define UPIO_SODR_P17_BIT 17

#define UPIO_CODR (*(volatile unsigned long *)0xFFFD8034)
#define UPIO_CODR_OFFSET 0x34
#define UPIO_CODR_P0_MASK 0x1
#define UPIO_CODR_P0 0x1
#define UPIO_CODR_P0_BIT 0
#define UPIO_CODR_P1_MASK 0x2
#define UPIO_CODR_P1 0x2
#define UPIO_CODR_P1_BIT 1
#define UPIO_CODR_P2_MASK 0x4
#define UPIO_CODR_P2 0x4
#define UPIO_CODR_P2_BIT 2
#define UPIO_CODR_P3_MASK 0x8
#define UPIO_CODR_P3 0x8
#define UPIO_CODR_P3_BIT 3
#define UPIO_CODR_P4_MASK 0x10
#define UPIO_CODR_P4 0x10
#define UPIO_CODR_P4_BIT 4
#define UPIO_CODR_P5_MASK 0x20
#define UPIO_CODR_P5 0x20
#define UPIO_CODR_P5_BIT 5
#define UPIO_CODR_P6_MASK 0x40
#define UPIO_CODR_P6 0x40
#define UPIO_CODR_P6_BIT 6
#define UPIO_CODR_P7_MASK 0x80
#define UPIO_CODR_P7 0x80
#define UPIO_CODR_P7_BIT 7
#define UPIO_CODR_P8_MASK 0x100
#define UPIO_CODR_P8 0x100
#define UPIO_CODR_P8_BIT 8
#define UPIO_CODR_P9_MASK 0x200
#define UPIO_CODR_P9 0x200
#define UPIO_CODR_P9_BIT 9
#define UPIO_CODR_P10_MASK 0x400
#define UPIO_CODR_P10 0x400
#define UPIO_CODR_P10_BIT 10
#define UPIO_CODR_P11_MASK 0x800
#define UPIO_CODR_P11 0x800
#define UPIO_CODR_P11_BIT 11
#define UPIO_CODR_P12_MASK 0x1000
#define UPIO_CODR_P12 0x1000
#define UPIO_CODR_P12_BIT 12
#define UPIO_CODR_P13_MASK 0x2000
#define UPIO_CODR_P13 0x2000
#define UPIO_CODR_P13_BIT 13
#define UPIO_CODR_P14_MASK 0x4000
#define UPIO_CODR_P14 0x4000
#define UPIO_CODR_P14_BIT 14
#define UPIO_CODR_P15_MASK 0x8000
#define UPIO_CODR_P15 0x8000
#define UPIO_CODR_P15_BIT 15
#define UPIO_CODR_P16_MASK 0x10000
#define UPIO_CODR_P16 0x10000
#define UPIO_CODR_P16_BIT 16
#define UPIO_CODR_P17_MASK 0x20000
#define UPIO_CODR_P17 0x20000
#define UPIO_CODR_P17_BIT 17

#define UPIO_ODSR (*(volatile unsigned long *)0xFFFD8038)
#define UPIO_ODSR_OFFSET 0x38
#define UPIO_ODSR_P0_MASK 0x1
#define UPIO_ODSR_P0 0x1
#define UPIO_ODSR_P0_BIT 0
#define UPIO_ODSR_P1_MASK 0x2
#define UPIO_ODSR_P1 0x2
#define UPIO_ODSR_P1_BIT 1
#define UPIO_ODSR_P2_MASK 0x4
#define UPIO_ODSR_P2 0x4
#define UPIO_ODSR_P2_BIT 2
#define UPIO_ODSR_P3_MASK 0x8
#define UPIO_ODSR_P3 0x8
#define UPIO_ODSR_P3_BIT 3
#define UPIO_ODSR_P4_MASK 0x10
#define UPIO_ODSR_P4 0x10
#define UPIO_ODSR_P4_BIT 4
#define UPIO_ODSR_P5_MASK 0x20
#define UPIO_ODSR_P5 0x20
#define UPIO_ODSR_P5_BIT 5
#define UPIO_ODSR_P6_MASK 0x40
#define UPIO_ODSR_P6 0x40
#define UPIO_ODSR_P6_BIT 6
#define UPIO_ODSR_P7_MASK 0x80
#define UPIO_ODSR_P7 0x80
#define UPIO_ODSR_P7_BIT 7
#define UPIO_ODSR_P8_MASK 0x100
#define UPIO_ODSR_P8 0x100
#define UPIO_ODSR_P8_BIT 8
#define UPIO_ODSR_P9_MASK 0x200
#define UPIO_ODSR_P9 0x200
#define UPIO_ODSR_P9_BIT 9
#define UPIO_ODSR_P10_MASK 0x400
#define UPIO_ODSR_P10 0x400
#define UPIO_ODSR_P10_BIT 10
#define UPIO_ODSR_P11_MASK 0x800
#define UPIO_ODSR_P11 0x800
#define UPIO_ODSR_P11_BIT 11
#define UPIO_ODSR_P12_MASK 0x1000
#define UPIO_ODSR_P12 0x1000
#define UPIO_ODSR_P12_BIT 12
#define UPIO_ODSR_P13_MASK 0x2000
#define UPIO_ODSR_P13 0x2000
#define UPIO_ODSR_P13_BIT 13
#define UPIO_ODSR_P14_MASK 0x4000
#define UPIO_ODSR_P14 0x4000
#define UPIO_ODSR_P14_BIT 14
#define UPIO_ODSR_P15_MASK 0x8000
#define UPIO_ODSR_P15 0x8000
#define UPIO_ODSR_P15_BIT 15
#define UPIO_ODSR_P16_MASK 0x10000
#define UPIO_ODSR_P16 0x10000
#define UPIO_ODSR_P16_BIT 16
#define UPIO_ODSR_P17_MASK 0x20000
#define UPIO_ODSR_P17 0x20000
#define UPIO_ODSR_P17_BIT 17

#define UPIO_PDSR (*(volatile unsigned long *)0xFFFD803C)
#define UPIO_PDSR_OFFSET 0x3C
#define UPIO_PDSR_P0_MASK 0x1
#define UPIO_PDSR_P0 0x1
#define UPIO_PDSR_P0_BIT 0
#define UPIO_PDSR_P1_MASK 0x2
#define UPIO_PDSR_P1 0x2
#define UPIO_PDSR_P1_BIT 1
#define UPIO_PDSR_P2_MASK 0x4
#define UPIO_PDSR_P2 0x4
#define UPIO_PDSR_P2_BIT 2
#define UPIO_PDSR_P3_MASK 0x8
#define UPIO_PDSR_P3 0x8
#define UPIO_PDSR_P3_BIT 3
#define UPIO_PDSR_P4_MASK 0x10
#define UPIO_PDSR_P4 0x10
#define UPIO_PDSR_P4_BIT 4
#define UPIO_PDSR_P5_MASK 0x20
#define UPIO_PDSR_P5 0x20
#define UPIO_PDSR_P5_BIT 5
#define UPIO_PDSR_P6_MASK 0x40
#define UPIO_PDSR_P6 0x40
#define UPIO_PDSR_P6_BIT 6
#define UPIO_PDSR_P7_MASK 0x80
#define UPIO_PDSR_P7 0x80
#define UPIO_PDSR_P7_BIT 7
#define UPIO_PDSR_P8_MASK 0x100
#define UPIO_PDSR_P8 0x100
#define UPIO_PDSR_P8_BIT 8
#define UPIO_PDSR_P9_MASK 0x200
#define UPIO_PDSR_P9 0x200
#define UPIO_PDSR_P9_BIT 9
#define UPIO_PDSR_P10_MASK 0x400
#define UPIO_PDSR_P10 0x400
#define UPIO_PDSR_P10_BIT 10
#define UPIO_PDSR_P11_MASK 0x800
#define UPIO_PDSR_P11 0x800
#define UPIO_PDSR_P11_BIT 11
#define UPIO_PDSR_P12_MASK 0x1000
#define UPIO_PDSR_P12 0x1000
#define UPIO_PDSR_P12_BIT 12
#define UPIO_PDSR_P13_MASK 0x2000
#define UPIO_PDSR_P13 0x2000
#define UPIO_PDSR_P13_BIT 13
#define UPIO_PDSR_P14_MASK 0x4000
#define UPIO_PDSR_P14 0x4000
#define UPIO_PDSR_P14_BIT 14
#define UPIO_PDSR_P15_MASK 0x8000
#define UPIO_PDSR_P15 0x8000
#define UPIO_PDSR_P15_BIT 15
#define UPIO_PDSR_P16_MASK 0x10000
#define UPIO_PDSR_P16 0x10000
#define UPIO_PDSR_P16_BIT 16
#define UPIO_PDSR_P17_MASK 0x20000
#define UPIO_PDSR_P17 0x20000
#define UPIO_PDSR_P17_BIT 17

#define UPIO_MDER (*(volatile unsigned long *)0xFFFD8040)
#define UPIO_MDER_OFFSET 0x40
#define UPIO_MDER_P0_MASK 0x1
#define UPIO_MDER_P0 0x1
#define UPIO_MDER_P0_BIT 0
#define UPIO_MDER_P1_MASK 0x2
#define UPIO_MDER_P1 0x2
#define UPIO_MDER_P1_BIT 1
#define UPIO_MDER_P2_MASK 0x4
#define UPIO_MDER_P2 0x4
#define UPIO_MDER_P2_BIT 2
#define UPIO_MDER_P3_MASK 0x8
#define UPIO_MDER_P3 0x8
#define UPIO_MDER_P3_BIT 3
#define UPIO_MDER_P4_MASK 0x10
#define UPIO_MDER_P4 0x10
#define UPIO_MDER_P4_BIT 4
#define UPIO_MDER_P5_MASK 0x20
#define UPIO_MDER_P5 0x20
#define UPIO_MDER_P5_BIT 5
#define UPIO_MDER_P6_MASK 0x40
#define UPIO_MDER_P6 0x40
#define UPIO_MDER_P6_BIT 6
#define UPIO_MDER_P7_MASK 0x80
#define UPIO_MDER_P7 0x80
#define UPIO_MDER_P7_BIT 7
#define UPIO_MDER_P8_MASK 0x100
#define UPIO_MDER_P8 0x100
#define UPIO_MDER_P8_BIT 8
#define UPIO_MDER_P9_MASK 0x200
#define UPIO_MDER_P9 0x200
#define UPIO_MDER_P9_BIT 9
#define UPIO_MDER_P10_MASK 0x400
#define UPIO_MDER_P10 0x400
#define UPIO_MDER_P10_BIT 10
#define UPIO_MDER_P11_MASK 0x800
#define UPIO_MDER_P11 0x800
#define UPIO_MDER_P11_BIT 11
#define UPIO_MDER_P12_MASK 0x1000
#define UPIO_MDER_P12 0x1000
#define UPIO_MDER_P12_BIT 12
#define UPIO_MDER_P13_MASK 0x2000
#define UPIO_MDER_P13 0x2000
#define UPIO_MDER_P13_BIT 13
#define UPIO_MDER_P14_MASK 0x4000
#define UPIO_MDER_P14 0x4000
#define UPIO_MDER_P14_BIT 14
#define UPIO_MDER_P15_MASK 0x8000
#define UPIO_MDER_P15 0x8000
#define UPIO_MDER_P15_BIT 15
#define UPIO_MDER_P16_MASK 0x10000
#define UPIO_MDER_P16 0x10000
#define UPIO_MDER_P16_BIT 16
#define UPIO_MDER_P17_MASK 0x20000
#define UPIO_MDER_P17 0x20000
#define UPIO_MDER_P17_BIT 17

#define UPIO_MDDR (*(volatile unsigned long *)0xFFFD8044)
#define UPIO_MDDR_OFFSET 0x44
#define UPIO_MDDR_P0_MASK 0x1
#define UPIO_MDDR_P0 0x1
#define UPIO_MDDR_P0_BIT 0
#define UPIO_MDDR_P1_MASK 0x2
#define UPIO_MDDR_P1 0x2
#define UPIO_MDDR_P1_BIT 1
#define UPIO_MDDR_P2_MASK 0x4
#define UPIO_MDDR_P2 0x4
#define UPIO_MDDR_P2_BIT 2
#define UPIO_MDDR_P3_MASK 0x8
#define UPIO_MDDR_P3 0x8
#define UPIO_MDDR_P3_BIT 3
#define UPIO_MDDR_P4_MASK 0x10
#define UPIO_MDDR_P4 0x10
#define UPIO_MDDR_P4_BIT 4
#define UPIO_MDDR_P5_MASK 0x20
#define UPIO_MDDR_P5 0x20
#define UPIO_MDDR_P5_BIT 5
#define UPIO_MDDR_P6_MASK 0x40
#define UPIO_MDDR_P6 0x40
#define UPIO_MDDR_P6_BIT 6
#define UPIO_MDDR_P7_MASK 0x80
#define UPIO_MDDR_P7 0x80
#define UPIO_MDDR_P7_BIT 7
#define UPIO_MDDR_P8_MASK 0x100
#define UPIO_MDDR_P8 0x100
#define UPIO_MDDR_P8_BIT 8
#define UPIO_MDDR_P9_MASK 0x200
#define UPIO_MDDR_P9 0x200
#define UPIO_MDDR_P9_BIT 9
#define UPIO_MDDR_P10_MASK 0x400
#define UPIO_MDDR_P10 0x400
#define UPIO_MDDR_P10_BIT 10
#define UPIO_MDDR_P11_MASK 0x800
#define UPIO_MDDR_P11 0x800
#define UPIO_MDDR_P11_BIT 11
#define UPIO_MDDR_P12_MASK 0x1000
#define UPIO_MDDR_P12 0x1000
#define UPIO_MDDR_P12_BIT 12
#define UPIO_MDDR_P13_MASK 0x2000
#define UPIO_MDDR_P13 0x2000
#define UPIO_MDDR_P13_BIT 13
#define UPIO_MDDR_P14_MASK 0x4000
#define UPIO_MDDR_P14 0x4000
#define UPIO_MDDR_P14_BIT 14
#define UPIO_MDDR_P15_MASK 0x8000
#define UPIO_MDDR_P15 0x8000
#define UPIO_MDDR_P15_BIT 15
#define UPIO_MDDR_P16_MASK 0x10000
#define UPIO_MDDR_P16 0x10000
#define UPIO_MDDR_P16_BIT 16
#define UPIO_MDDR_P17_MASK 0x20000
#define UPIO_MDDR_P17 0x20000
#define UPIO_MDDR_P17_BIT 17

#define UPIO_MDSR (*(volatile unsigned long *)0xFFFD8048)
#define UPIO_MDSR_OFFSET 0x48
#define UPIO_MDSR_P0_MASK 0x1
#define UPIO_MDSR_P0 0x1
#define UPIO_MDSR_P0_BIT 0
#define UPIO_MDSR_P1_MASK 0x2
#define UPIO_MDSR_P1 0x2
#define UPIO_MDSR_P1_BIT 1
#define UPIO_MDSR_P2_MASK 0x4
#define UPIO_MDSR_P2 0x4
#define UPIO_MDSR_P2_BIT 2
#define UPIO_MDSR_P3_MASK 0x8
#define UPIO_MDSR_P3 0x8
#define UPIO_MDSR_P3_BIT 3
#define UPIO_MDSR_P4_MASK 0x10
#define UPIO_MDSR_P4 0x10
#define UPIO_MDSR_P4_BIT 4
#define UPIO_MDSR_P5_MASK 0x20
#define UPIO_MDSR_P5 0x20
#define UPIO_MDSR_P5_BIT 5
#define UPIO_MDSR_P6_MASK 0x40
#define UPIO_MDSR_P6 0x40
#define UPIO_MDSR_P6_BIT 6
#define UPIO_MDSR_P7_MASK 0x80
#define UPIO_MDSR_P7 0x80
#define UPIO_MDSR_P7_BIT 7
#define UPIO_MDSR_P8_MASK 0x100
#define UPIO_MDSR_P8 0x100
#define UPIO_MDSR_P8_BIT 8
#define UPIO_MDSR_P9_MASK 0x200
#define UPIO_MDSR_P9 0x200
#define UPIO_MDSR_P9_BIT 9
#define UPIO_MDSR_P10_MASK 0x400
#define UPIO_MDSR_P10 0x400
#define UPIO_MDSR_P10_BIT 10
#define UPIO_MDSR_P11_MASK 0x800
#define UPIO_MDSR_P11 0x800
#define UPIO_MDSR_P11_BIT 11
#define UPIO_MDSR_P12_MASK 0x1000
#define UPIO_MDSR_P12 0x1000
#define UPIO_MDSR_P12_BIT 12
#define UPIO_MDSR_P13_MASK 0x2000
#define UPIO_MDSR_P13 0x2000
#define UPIO_MDSR_P13_BIT 13
#define UPIO_MDSR_P14_MASK 0x4000
#define UPIO_MDSR_P14 0x4000
#define UPIO_MDSR_P14_BIT 14
#define UPIO_MDSR_P15_MASK 0x8000
#define UPIO_MDSR_P15 0x8000
#define UPIO_MDSR_P15_BIT 15
#define UPIO_MDSR_P16_MASK 0x10000
#define UPIO_MDSR_P16 0x10000
#define UPIO_MDSR_P16_BIT 16
#define UPIO_MDSR_P17_MASK 0x20000
#define UPIO_MDSR_P17 0x20000
#define UPIO_MDSR_P17_BIT 17

#define UPIO_ECR (*(volatile unsigned long *)0xFFFD8050)
#define UPIO_ECR_OFFSET 0x50
#define UPIO_ECR_PIO_MASK 0x1
#define UPIO_ECR_PIO 0x1
#define UPIO_ECR_PIO_BIT 0

#define UPIO_DCR (*(volatile unsigned long *)0xFFFD8054)
#define UPIO_DCR_OFFSET 0x54
#define UPIO_DCR_PIO_MASK 0x1
#define UPIO_DCR_PIO 0x1
#define UPIO_DCR_PIO_BIT 0

#define UPIO_PMSR (*(volatile unsigned long *)0xFFFD8058)
#define UPIO_PMSR_OFFSET 0x58
#define UPIO_PMSR_PIO_MASK 0x1
#define UPIO_PMSR_PIO 0x1
#define UPIO_PMSR_PIO_BIT 0

#define UPIO_CR (*(volatile unsigned long *)0xFFFD8060)
#define UPIO_CR_OFFSET 0x60
#define UPIO_CR_SWRST_MASK 0x1
#define UPIO_CR_SWRST 0x1
#define UPIO_CR_SWRST_BIT 0

#define UPIO_SR (*(volatile unsigned long *)0xFFFD8070)
#define UPIO_SR_OFFSET 0x70
#define UPIO_SR_P0_MASK 0x1
#define UPIO_SR_P0 0x1
#define UPIO_SR_P0_BIT 0
#define UPIO_SR_P1_MASK 0x2
#define UPIO_SR_P1 0x2
#define UPIO_SR_P1_BIT 1
#define UPIO_SR_P2_MASK 0x4
#define UPIO_SR_P2 0x4
#define UPIO_SR_P2_BIT 2
#define UPIO_SR_P3_MASK 0x8
#define UPIO_SR_P3 0x8
#define UPIO_SR_P3_BIT 3
#define UPIO_SR_P4_MASK 0x10
#define UPIO_SR_P4 0x10
#define UPIO_SR_P4_BIT 4
#define UPIO_SR_P5_MASK 0x20
#define UPIO_SR_P5 0x20
#define UPIO_SR_P5_BIT 5
#define UPIO_SR_P6_MASK 0x40
#define UPIO_SR_P6 0x40
#define UPIO_SR_P6_BIT 6
#define UPIO_SR_P7_MASK 0x80
#define UPIO_SR_P7 0x80
#define UPIO_SR_P7_BIT 7
#define UPIO_SR_P8_MASK 0x100
#define UPIO_SR_P8 0x100
#define UPIO_SR_P8_BIT 8
#define UPIO_SR_P9_MASK 0x200
#define UPIO_SR_P9 0x200
#define UPIO_SR_P9_BIT 9
#define UPIO_SR_P10_MASK 0x400
#define UPIO_SR_P10 0x400
#define UPIO_SR_P10_BIT 10
#define UPIO_SR_P11_MASK 0x800
#define UPIO_SR_P11 0x800
#define UPIO_SR_P11_BIT 11
#define UPIO_SR_P12_MASK 0x1000
#define UPIO_SR_P12 0x1000
#define UPIO_SR_P12_BIT 12
#define UPIO_SR_P13_MASK 0x2000
#define UPIO_SR_P13 0x2000
#define UPIO_SR_P13_BIT 13
#define UPIO_SR_P14_MASK 0x4000
#define UPIO_SR_P14 0x4000
#define UPIO_SR_P14_BIT 14
#define UPIO_SR_P15_MASK 0x8000
#define UPIO_SR_P15 0x8000
#define UPIO_SR_P15_BIT 15
#define UPIO_SR_P16_MASK 0x10000
#define UPIO_SR_P16 0x10000
#define UPIO_SR_P16_BIT 16
#define UPIO_SR_P17_MASK 0x20000
#define UPIO_SR_P17 0x20000
#define UPIO_SR_P17_BIT 17

#define UPIO_IER (*(volatile unsigned long *)0xFFFD8074)
#define UPIO_IER_OFFSET 0x74
#define UPIO_IER_P0_MASK 0x1
#define UPIO_IER_P0 0x1
#define UPIO_IER_P0_BIT 0
#define UPIO_IER_P1_MASK 0x2
#define UPIO_IER_P1 0x2
#define UPIO_IER_P1_BIT 1
#define UPIO_IER_P2_MASK 0x4
#define UPIO_IER_P2 0x4
#define UPIO_IER_P2_BIT 2
#define UPIO_IER_P3_MASK 0x8
#define UPIO_IER_P3 0x8
#define UPIO_IER_P3_BIT 3
#define UPIO_IER_P4_MASK 0x10
#define UPIO_IER_P4 0x10
#define UPIO_IER_P4_BIT 4
#define UPIO_IER_P5_MASK 0x20
#define UPIO_IER_P5 0x20
#define UPIO_IER_P5_BIT 5
#define UPIO_IER_P6_MASK 0x40
#define UPIO_IER_P6 0x40
#define UPIO_IER_P6_BIT 6
#define UPIO_IER_P7_MASK 0x80
#define UPIO_IER_P7 0x80
#define UPIO_IER_P7_BIT 7
#define UPIO_IER_P8_MASK 0x100
#define UPIO_IER_P8 0x100
#define UPIO_IER_P8_BIT 8
#define UPIO_IER_P9_MASK 0x200
#define UPIO_IER_P9 0x200
#define UPIO_IER_P9_BIT 9
#define UPIO_IER_P10_MASK 0x400
#define UPIO_IER_P10 0x400
#define UPIO_IER_P10_BIT 10
#define UPIO_IER_P11_MASK 0x800
#define UPIO_IER_P11 0x800
#define UPIO_IER_P11_BIT 11
#define UPIO_IER_P12_MASK 0x1000
#define UPIO_IER_P12 0x1000
#define UPIO_IER_P12_BIT 12
#define UPIO_IER_P13_MASK 0x2000
#define UPIO_IER_P13 0x2000
#define UPIO_IER_P13_BIT 13
#define UPIO_IER_P14_MASK 0x4000
#define UPIO_IER_P14 0x4000
#define UPIO_IER_P14_BIT 14
#define UPIO_IER_P15_MASK 0x8000
#define UPIO_IER_P15 0x8000
#define UPIO_IER_P15_BIT 15
#define UPIO_IER_P16_MASK 0x10000
#define UPIO_IER_P16 0x10000
#define UPIO_IER_P16_BIT 16
#define UPIO_IER_P17_MASK 0x20000
#define UPIO_IER_P17 0x20000
#define UPIO_IER_P17_BIT 17

#define UPIO_IDR (*(volatile unsigned long *)0xFFFD8078)
#define UPIO_IDR_OFFSET 0x78
#define UPIO_IDR_P0_MASK 0x1
#define UPIO_IDR_P0 0x1
#define UPIO_IDR_P0_BIT 0
#define UPIO_IDR_P1_MASK 0x2
#define UPIO_IDR_P1 0x2
#define UPIO_IDR_P1_BIT 1
#define UPIO_IDR_P2_MASK 0x4
#define UPIO_IDR_P2 0x4
#define UPIO_IDR_P2_BIT 2
#define UPIO_IDR_P3_MASK 0x8
#define UPIO_IDR_P3 0x8
#define UPIO_IDR_P3_BIT 3
#define UPIO_IDR_P4_MASK 0x10
#define UPIO_IDR_P4 0x10
#define UPIO_IDR_P4_BIT 4
#define UPIO_IDR_P5_MASK 0x20
#define UPIO_IDR_P5 0x20
#define UPIO_IDR_P5_BIT 5
#define UPIO_IDR_P6_MASK 0x40
#define UPIO_IDR_P6 0x40
#define UPIO_IDR_P6_BIT 6
#define UPIO_IDR_P7_MASK 0x80
#define UPIO_IDR_P7 0x80
#define UPIO_IDR_P7_BIT 7
#define UPIO_IDR_P8_MASK 0x100
#define UPIO_IDR_P8 0x100
#define UPIO_IDR_P8_BIT 8
#define UPIO_IDR_P9_MASK 0x200
#define UPIO_IDR_P9 0x200
#define UPIO_IDR_P9_BIT 9
#define UPIO_IDR_P10_MASK 0x400
#define UPIO_IDR_P10 0x400
#define UPIO_IDR_P10_BIT 10
#define UPIO_IDR_P11_MASK 0x800
#define UPIO_IDR_P11 0x800
#define UPIO_IDR_P11_BIT 11
#define UPIO_IDR_P12_MASK 0x1000
#define UPIO_IDR_P12 0x1000
#define UPIO_IDR_P12_BIT 12
#define UPIO_IDR_P13_MASK 0x2000
#define UPIO_IDR_P13 0x2000
#define UPIO_IDR_P13_BIT 13
#define UPIO_IDR_P14_MASK 0x4000
#define UPIO_IDR_P14 0x4000
#define UPIO_IDR_P14_BIT 14
#define UPIO_IDR_P15_MASK 0x8000
#define UPIO_IDR_P15 0x8000
#define UPIO_IDR_P15_BIT 15
#define UPIO_IDR_P16_MASK 0x10000
#define UPIO_IDR_P16 0x10000
#define UPIO_IDR_P16_BIT 16
#define UPIO_IDR_P17_MASK 0x20000
#define UPIO_IDR_P17 0x20000
#define UPIO_IDR_P17_BIT 17

#define UPIO_IMR (*(volatile unsigned long *)0xFFFD807C)
#define UPIO_IMR_OFFSET 0x7C
#define UPIO_IMR_P0_MASK 0x1
#define UPIO_IMR_P0 0x1
#define UPIO_IMR_P0_BIT 0
#define UPIO_IMR_P1_MASK 0x2
#define UPIO_IMR_P1 0x2
#define UPIO_IMR_P1_BIT 1
#define UPIO_IMR_P2_MASK 0x4
#define UPIO_IMR_P2 0x4
#define UPIO_IMR_P2_BIT 2
#define UPIO_IMR_P3_MASK 0x8
#define UPIO_IMR_P3 0x8
#define UPIO_IMR_P3_BIT 3
#define UPIO_IMR_P4_MASK 0x10
#define UPIO_IMR_P4 0x10
#define UPIO_IMR_P4_BIT 4
#define UPIO_IMR_P5_MASK 0x20
#define UPIO_IMR_P5 0x20
#define UPIO_IMR_P5_BIT 5
#define UPIO_IMR_P6_MASK 0x40
#define UPIO_IMR_P6 0x40
#define UPIO_IMR_P6_BIT 6
#define UPIO_IMR_P7_MASK 0x80
#define UPIO_IMR_P7 0x80
#define UPIO_IMR_P7_BIT 7
#define UPIO_IMR_P8_MASK 0x100
#define UPIO_IMR_P8 0x100
#define UPIO_IMR_P8_BIT 8
#define UPIO_IMR_P9_MASK 0x200
#define UPIO_IMR_P9 0x200
#define UPIO_IMR_P9_BIT 9
#define UPIO_IMR_P10_MASK 0x400
#define UPIO_IMR_P10 0x400
#define UPIO_IMR_P10_BIT 10
#define UPIO_IMR_P11_MASK 0x800
#define UPIO_IMR_P11 0x800
#define UPIO_IMR_P11_BIT 11
#define UPIO_IMR_P12_MASK 0x1000
#define UPIO_IMR_P12 0x1000
#define UPIO_IMR_P12_BIT 12
#define UPIO_IMR_P13_MASK 0x2000
#define UPIO_IMR_P13 0x2000
#define UPIO_IMR_P13_BIT 13
#define UPIO_IMR_P14_MASK 0x4000
#define UPIO_IMR_P14 0x4000
#define UPIO_IMR_P14_BIT 14
#define UPIO_IMR_P15_MASK 0x8000
#define UPIO_IMR_P15 0x8000
#define UPIO_IMR_P15_BIT 15
#define UPIO_IMR_P16_MASK 0x10000
#define UPIO_IMR_P16 0x10000
#define UPIO_IMR_P16_BIT 16
#define UPIO_IMR_P17_MASK 0x20000
#define UPIO_IMR_P17 0x20000
#define UPIO_IMR_P17_BIT 17

#define CAPT0_BASE 0xFFFDC000

#define CAPT0_PER (*(volatile unsigned long *)0xFFFDC000)
#define CAPT0_PER_OFFSET 0x0
#define CAPT0_PER_CAPTPIN_MASK 0x10000
#define CAPT0_PER_CAPTPIN 0x10000
#define CAPT0_PER_CAPTPIN_BIT 16

#define CAPT0_PDR (*(volatile unsigned long *)0xFFFDC004)
#define CAPT0_PDR_OFFSET 0x4
#define CAPT0_PDR_CAPTPIN_MASK 0x10000
#define CAPT0_PDR_CAPTPIN 0x10000
#define CAPT0_PDR_CAPTPIN_BIT 16

#define CAPT0_PSR (*(volatile unsigned long *)0xFFFDC008)
#define CAPT0_PSR_OFFSET 0x8
#define CAPT0_PSR_CAPTPIN_MASK 0x10000
#define CAPT0_PSR_CAPTPIN 0x10000
#define CAPT0_PSR_CAPTPIN_BIT 16

#define CAPT0_OER (*(volatile unsigned long *)0xFFFDC010)
#define CAPT0_OER_OFFSET 0x10
#define CAPT0_OER_CAPTPIN_MASK 0x10000
#define CAPT0_OER_CAPTPIN 0x10000
#define CAPT0_OER_CAPTPIN_BIT 16

#define CAPT0_ODR (*(volatile unsigned long *)0xFFFDC014)
#define CAPT0_ODR_OFFSET 0x14
#define CAPT0_ODR_CAPTPIN_MASK 0x10000
#define CAPT0_ODR_CAPTPIN 0x10000
#define CAPT0_ODR_CAPTPIN_BIT 16

#define CAPT0_OSR (*(volatile unsigned long *)0xFFFDC018)
#define CAPT0_OSR_OFFSET 0x18
#define CAPT0_OSR_CAPTPIN_MASK 0x10000
#define CAPT0_OSR_CAPTPIN 0x10000
#define CAPT0_OSR_CAPTPIN_BIT 16

#define CAPT0_SODR (*(volatile unsigned long *)0xFFFDC030)
#define CAPT0_SODR_OFFSET 0x30
#define CAPT0_SODR_CAPTPIN_MASK 0x10000
#define CAPT0_SODR_CAPTPIN 0x10000
#define CAPT0_SODR_CAPTPIN_BIT 16

#define CAPT0_CODR (*(volatile unsigned long *)0xFFFDC034)
#define CAPT0_CODR_OFFSET 0x34
#define CAPT0_CODR_CAPTPIN_MASK 0x10000
#define CAPT0_CODR_CAPTPIN 0x10000
#define CAPT0_CODR_CAPTPIN_BIT 16

#define CAPT0_ODSR (*(volatile unsigned long *)0xFFFDC038)
#define CAPT0_ODSR_OFFSET 0x38
#define CAPT0_ODSR_CAPTPIN_MASK 0x10000
#define CAPT0_ODSR_CAPTPIN 0x10000
#define CAPT0_ODSR_CAPTPIN_BIT 16

#define CAPT0_PDSR (*(volatile unsigned long *)0xFFFDC03C)
#define CAPT0_PDSR_OFFSET 0x3C
#define CAPT0_PDSR_CAPTPIN_MASK 0x10000
#define CAPT0_PDSR_CAPTPIN 0x10000
#define CAPT0_PDSR_CAPTPIN_BIT 16

#define CAPT0_MDER (*(volatile unsigned long *)0xFFFDC040)
#define CAPT0_MDER_OFFSET 0x40
#define CAPT0_MDER_CAPTPIN_MASK 0x10000
#define CAPT0_MDER_CAPTPIN 0x10000
#define CAPT0_MDER_CAPTPIN_BIT 16

#define CAPT0_MDDR (*(volatile unsigned long *)0xFFFDC044)
#define CAPT0_MDDR_OFFSET 0x44
#define CAPT0_MDDR_CAPTPIN_MASK 0x10000
#define CAPT0_MDDR_CAPTPIN 0x10000
#define CAPT0_MDDR_CAPTPIN_BIT 16

#define CAPT0_MDSR (*(volatile unsigned long *)0xFFFDC048)
#define CAPT0_MDSR_OFFSET 0x48
#define CAPT0_MDSR_CAPTPIN_MASK 0x10000
#define CAPT0_MDSR_CAPTPIN 0x10000
#define CAPT0_MDSR_CAPTPIN_BIT 16

#define CAPT0_ECR (*(volatile unsigned long *)0xFFFDC050)
#define CAPT0_ECR_OFFSET 0x50
#define CAPT0_ECR_PIO_MASK 0x1
#define CAPT0_ECR_PIO 0x1
#define CAPT0_ECR_PIO_BIT 0
#define CAPT0_ECR_CAP_MASK 0x2
#define CAPT0_ECR_CAP 0x2
#define CAPT0_ECR_CAP_BIT 1

#define CAPT0_DCR (*(volatile unsigned long *)0xFFFDC054)
#define CAPT0_DCR_OFFSET 0x54
#define CAPT0_DCR_PIO_MASK 0x1
#define CAPT0_DCR_PIO 0x1
#define CAPT0_DCR_PIO_BIT 0
#define CAPT0_DCR_CAP_MASK 0x2
#define CAPT0_DCR_CAP 0x2
#define CAPT0_DCR_CAP_BIT 1

#define CAPT0_PMSR (*(volatile unsigned long *)0xFFFDC058)
#define CAPT0_PMSR_OFFSET 0x58
#define CAPT0_PMSR_PIO_MASK 0x1
#define CAPT0_PMSR_PIO 0x1
#define CAPT0_PMSR_PIO_BIT 0
#define CAPT0_PMSR_CAP_MASK 0x2
#define CAPT0_PMSR_CAP 0x2
#define CAPT0_PMSR_CAP_BIT 1

#define CAPT0_CR (*(volatile unsigned long *)0xFFFDC060)
#define CAPT0_CR_OFFSET 0x60
#define CAPT0_CR_SWRST_MASK 0x1
#define CAPT0_CR_SWRST 0x1
#define CAPT0_CR_SWRST_BIT 0
#define CAPT0_CR_CAPEN_MASK 0x2
#define CAPT0_CR_CAPEN 0x2
#define CAPT0_CR_CAPEN_BIT 1
#define CAPT0_CR_CAPDIS_MASK 0x4
#define CAPT0_CR_CAPDIS 0x4
#define CAPT0_CR_CAPDIS_BIT 2
#define CAPT0_CR_STARTCAPT_MASK 0x8
#define CAPT0_CR_STARTCAPT 0x8
#define CAPT0_CR_STARTCAPT_BIT 3

#define CAPT0_MR (*(volatile unsigned long *)0xFFFDC064)
#define CAPT0_MR_OFFSET 0x64
#define CAPT0_MR_PRESCALAR_MASK 0xF
#define CAPT0_MR_PRESCALAR_BIT 0
#define CAPT0_MR_MEASMODE_MASK 0x30
#define CAPT0_MR_MEASMODE_BIT 4
#define CAPT0_MR_OVERMODE_MASK 0x40
#define CAPT0_MR_OVERMODE 0x40
#define CAPT0_MR_OVERMODE_BIT 6
#define CAPT0_MR_ONESHOT_MASK 0x80
#define CAPT0_MR_ONESHOT 0x80
#define CAPT0_MR_ONESHOT_BIT 7

#define CAPT0_CSR (*(volatile unsigned long *)0xFFFDC06C)
#define CAPT0_CSR_OFFSET 0x6C
#define CAPT0_CSR_PDCEND_MASK 0x1
#define CAPT0_CSR_PDCEND 0x1
#define CAPT0_CSR_PDCEND_BIT 0
#define CAPT0_CSR_OVERRUN_MASK 0x2
#define CAPT0_CSR_OVERRUN 0x2
#define CAPT0_CSR_OVERRUN_BIT 1
#define CAPT0_CSR_OVERFLOW_MASK 0x4
#define CAPT0_CSR_OVERFLOW 0x4
#define CAPT0_CSR_OVERFLOW_BIT 2
#define CAPT0_CSR_CAPTPIN_MASK 0x10000
#define CAPT0_CSR_CAPTPIN 0x10000
#define CAPT0_CSR_CAPTPIN_BIT 16

#define CAPT0_SR (*(volatile unsigned long *)0xFFFDC070)
#define CAPT0_SR_OFFSET 0x70
#define CAPT0_SR_PDCEND_MASK 0x1
#define CAPT0_SR_PDCEND 0x1
#define CAPT0_SR_PDCEND_BIT 0
#define CAPT0_SR_OVERRUN_MASK 0x2
#define CAPT0_SR_OVERRUN 0x2
#define CAPT0_SR_OVERRUN_BIT 1
#define CAPT0_SR_OVERFLOW_MASK 0x4
#define CAPT0_SR_OVERFLOW 0x4
#define CAPT0_SR_OVERFLOW_BIT 2
#define CAPT0_SR_DATACAPT_MASK 0x8
#define CAPT0_SR_DATACAPT 0x8
#define CAPT0_SR_DATACAPT_BIT 3
#define CAPT0_SR_CAPENS_MASK 0x100
#define CAPT0_SR_CAPENS 0x100
#define CAPT0_SR_CAPENS_BIT 8
#define CAPT0_SR_CAPTPIN_MASK 0x10000
#define CAPT0_SR_CAPTPIN 0x10000
#define CAPT0_SR_CAPTPIN_BIT 16

#define CAPT0_IER (*(volatile unsigned long *)0xFFFDC074)
#define CAPT0_IER_OFFSET 0x74
#define CAPT0_IER_PDCEND_MASK 0x1
#define CAPT0_IER_PDCEND 0x1
#define CAPT0_IER_PDCEND_BIT 0
#define CAPT0_IER_OVERRUN_MASK 0x2
#define CAPT0_IER_OVERRUN 0x2
#define CAPT0_IER_OVERRUN_BIT 1
#define CAPT0_IER_OVERFLOW_MASK 0x4
#define CAPT0_IER_OVERFLOW 0x4
#define CAPT0_IER_OVERFLOW_BIT 2
#define CAPT0_IER_DATACAPT_MASK 0x8
#define CAPT0_IER_DATACAPT 0x8
#define CAPT0_IER_DATACAPT_BIT 3
#define CAPT0_IER_CAPTPIN_MASK 0x10000
#define CAPT0_IER_CAPTPIN 0x10000
#define CAPT0_IER_CAPTPIN_BIT 16

#define CAPT0_IDR (*(volatile unsigned long *)0xFFFDC078)
#define CAPT0_IDR_OFFSET 0x78
#define CAPT0_IDR_PDCEND_MASK 0x1
#define CAPT0_IDR_PDCEND 0x1
#define CAPT0_IDR_PDCEND_BIT 0
#define CAPT0_IDR_OVERRUN_MASK 0x2
#define CAPT0_IDR_OVERRUN 0x2
#define CAPT0_IDR_OVERRUN_BIT 1
#define CAPT0_IDR_OVERFLOW_MASK 0x4
#define CAPT0_IDR_OVERFLOW 0x4
#define CAPT0_IDR_OVERFLOW_BIT 2
#define CAPT0_IDR_DATACAPT_MASK 0x8
#define CAPT0_IDR_DATACAPT 0x8
#define CAPT0_IDR_DATACAPT_BIT 3
#define CAPT0_IDR_CAPTPIN_MASK 0x10000
#define CAPT0_IDR_CAPTPIN 0x10000
#define CAPT0_IDR_CAPTPIN_BIT 16

#define CAPT0_IMR (*(volatile unsigned long *)0xFFFDC07C)
#define CAPT0_IMR_OFFSET 0x7C
#define CAPT0_IMR_PDCEND_MASK 0x1
#define CAPT0_IMR_PDCEND 0x1
#define CAPT0_IMR_PDCEND_BIT 0
#define CAPT0_IMR_OVERRUN_MASK 0x2
#define CAPT0_IMR_OVERRUN 0x2
#define CAPT0_IMR_OVERRUN_BIT 1
#define CAPT0_IMR_OVERFLOW_MASK 0x4
#define CAPT0_IMR_OVERFLOW 0x4
#define CAPT0_IMR_OVERFLOW_BIT 2
#define CAPT0_IMR_DATACAPT_MASK 0x8
#define CAPT0_IMR_DATACAPT 0x8
#define CAPT0_IMR_DATACAPT_BIT 3
#define CAPT0_IMR_CAPTPIN_MASK 0x10000
#define CAPT0_IMR_CAPTPIN 0x10000
#define CAPT0_IMR_CAPTPIN_BIT 16

#define CAPT0_DR (*(volatile unsigned long *)0xFFFDC080)
#define CAPT0_DR_OFFSET 0x80
#define CAPT0_DR_DURATION_MASK 0x7FFF
#define CAPT0_DR_DURATION_BIT 0
#define CAPT0_DR_LEVEL_MASK 0x8000
#define CAPT0_DR_LEVEL 0x8000
#define CAPT0_DR_LEVEL_BIT 15

#define CAPT1_BASE 0xFFFE0000

#define CAPT1_PER (*(volatile unsigned long *)0xFFFE0000)
#define CAPT1_PER_OFFSET 0x0
#define CAPT1_PER_CAPTPIN_MASK 0x10000
#define CAPT1_PER_CAPTPIN 0x10000
#define CAPT1_PER_CAPTPIN_BIT 16

#define CAPT1_PDR (*(volatile unsigned long *)0xFFFE0004)
#define CAPT1_PDR_OFFSET 0x4
#define CAPT1_PDR_CAPTPIN_MASK 0x10000
#define CAPT1_PDR_CAPTPIN 0x10000
#define CAPT1_PDR_CAPTPIN_BIT 16

#define CAPT1_PSR (*(volatile unsigned long *)0xFFFE0008)
#define CAPT1_PSR_OFFSET 0x8
#define CAPT1_PSR_CAPTPIN_MASK 0x10000
#define CAPT1_PSR_CAPTPIN 0x10000
#define CAPT1_PSR_CAPTPIN_BIT 16

#define CAPT1_OER (*(volatile unsigned long *)0xFFFE0010)
#define CAPT1_OER_OFFSET 0x10
#define CAPT1_OER_CAPTPIN_MASK 0x10000
#define CAPT1_OER_CAPTPIN 0x10000
#define CAPT1_OER_CAPTPIN_BIT 16

#define CAPT1_ODR (*(volatile unsigned long *)0xFFFE0014)
#define CAPT1_ODR_OFFSET 0x14
#define CAPT1_ODR_CAPTPIN_MASK 0x10000
#define CAPT1_ODR_CAPTPIN 0x10000
#define CAPT1_ODR_CAPTPIN_BIT 16

#define CAPT1_OSR (*(volatile unsigned long *)0xFFFE0018)
#define CAPT1_OSR_OFFSET 0x18
#define CAPT1_OSR_CAPTPIN_MASK 0x10000
#define CAPT1_OSR_CAPTPIN 0x10000
#define CAPT1_OSR_CAPTPIN_BIT 16

#define CAPT1_SODR (*(volatile unsigned long *)0xFFFE0030)
#define CAPT1_SODR_OFFSET 0x30
#define CAPT1_SODR_CAPTPIN_MASK 0x10000
#define CAPT1_SODR_CAPTPIN 0x10000
#define CAPT1_SODR_CAPTPIN_BIT 16

#define CAPT1_CODR (*(volatile unsigned long *)0xFFFE0034)
#define CAPT1_CODR_OFFSET 0x34
#define CAPT1_CODR_CAPTPIN_MASK 0x10000
#define CAPT1_CODR_CAPTPIN 0x10000
#define CAPT1_CODR_CAPTPIN_BIT 16

#define CAPT1_ODSR (*(volatile unsigned long *)0xFFFE0038)
#define CAPT1_ODSR_OFFSET 0x38
#define CAPT1_ODSR_CAPTPIN_MASK 0x10000
#define CAPT1_ODSR_CAPTPIN 0x10000
#define CAPT1_ODSR_CAPTPIN_BIT 16

#define CAPT1_PDSR (*(volatile unsigned long *)0xFFFE003C)
#define CAPT1_PDSR_OFFSET 0x3C
#define CAPT1_PDSR_CAPTPIN_MASK 0x10000
#define CAPT1_PDSR_CAPTPIN 0x10000
#define CAPT1_PDSR_CAPTPIN_BIT 16

#define CAPT1_MDER (*(volatile unsigned long *)0xFFFE0040)
#define CAPT1_MDER_OFFSET 0x40
#define CAPT1_MDER_CAPTPIN_MASK 0x10000
#define CAPT1_MDER_CAPTPIN 0x10000
#define CAPT1_MDER_CAPTPIN_BIT 16

#define CAPT1_MDDR (*(volatile unsigned long *)0xFFFE0044)
#define CAPT1_MDDR_OFFSET 0x44
#define CAPT1_MDDR_CAPTPIN_MASK 0x10000
#define CAPT1_MDDR_CAPTPIN 0x10000
#define CAPT1_MDDR_CAPTPIN_BIT 16

#define CAPT1_MDSR (*(volatile unsigned long *)0xFFFE0048)
#define CAPT1_MDSR_OFFSET 0x48
#define CAPT1_MDSR_CAPTPIN_MASK 0x10000
#define CAPT1_MDSR_CAPTPIN 0x10000
#define CAPT1_MDSR_CAPTPIN_BIT 16

#define CAPT1_ECR (*(volatile unsigned long *)0xFFFE0050)
#define CAPT1_ECR_OFFSET 0x50
#define CAPT1_ECR_PIO_MASK 0x1
#define CAPT1_ECR_PIO 0x1
#define CAPT1_ECR_PIO_BIT 0
#define CAPT1_ECR_CAP_MASK 0x2
#define CAPT1_ECR_CAP 0x2
#define CAPT1_ECR_CAP_BIT 1

#define CAPT1_DCR (*(volatile unsigned long *)0xFFFE0054)
#define CAPT1_DCR_OFFSET 0x54
#define CAPT1_DCR_PIO_MASK 0x1
#define CAPT1_DCR_PIO 0x1
#define CAPT1_DCR_PIO_BIT 0
#define CAPT1_DCR_CAP_MASK 0x2
#define CAPT1_DCR_CAP 0x2
#define CAPT1_DCR_CAP_BIT 1

#define CAPT1_PMSR (*(volatile unsigned long *)0xFFFE0058)
#define CAPT1_PMSR_OFFSET 0x58
#define CAPT1_PMSR_PIO_MASK 0x1
#define CAPT1_PMSR_PIO 0x1
#define CAPT1_PMSR_PIO_BIT 0
#define CAPT1_PMSR_CAP_MASK 0x2
#define CAPT1_PMSR_CAP 0x2
#define CAPT1_PMSR_CAP_BIT 1

#define CAPT1_CR (*(volatile unsigned long *)0xFFFE0060)
#define CAPT1_CR_OFFSET 0x60
#define CAPT1_CR_SWRST_MASK 0x1
#define CAPT1_CR_SWRST 0x1
#define CAPT1_CR_SWRST_BIT 0
#define CAPT1_CR_CAPEN_MASK 0x2
#define CAPT1_CR_CAPEN 0x2
#define CAPT1_CR_CAPEN_BIT 1
#define CAPT1_CR_CAPDIS_MASK 0x4
#define CAPT1_CR_CAPDIS 0x4
#define CAPT1_CR_CAPDIS_BIT 2
#define CAPT1_CR_STARTCAPT_MASK 0x8
#define CAPT1_CR_STARTCAPT 0x8
#define CAPT1_CR_STARTCAPT_BIT 3

#define CAPT1_MR (*(volatile unsigned long *)0xFFFE0064)
#define CAPT1_MR_OFFSET 0x64
#define CAPT1_MR_PRESCALAR_MASK 0xF
#define CAPT1_MR_PRESCALAR_BIT 0
#define CAPT1_MR_MEASMODE_MASK 0x30
#define CAPT1_MR_MEASMODE_BIT 4
#define CAPT1_MR_OVERMODE_MASK 0x40
#define CAPT1_MR_OVERMODE 0x40
#define CAPT1_MR_OVERMODE_BIT 6
#define CAPT1_MR_ONESHOT_MASK 0x80
#define CAPT1_MR_ONESHOT 0x80
#define CAPT1_MR_ONESHOT_BIT 7

#define CAPT1_CSR (*(volatile unsigned long *)0xFFFE006C)
#define CAPT1_CSR_OFFSET 0x6C
#define CAPT1_CSR_PDCEND_MASK 0x1
#define CAPT1_CSR_PDCEND 0x1
#define CAPT1_CSR_PDCEND_BIT 0
#define CAPT1_CSR_OVERRUN_MASK 0x2
#define CAPT1_CSR_OVERRUN 0x2
#define CAPT1_CSR_OVERRUN_BIT 1
#define CAPT1_CSR_OVERFLOW_MASK 0x4
#define CAPT1_CSR_OVERFLOW 0x4
#define CAPT1_CSR_OVERFLOW_BIT 2
#define CAPT1_CSR_CAPTPIN_MASK 0x10000
#define CAPT1_CSR_CAPTPIN 0x10000
#define CAPT1_CSR_CAPTPIN_BIT 16

#define CAPT1_SR (*(volatile unsigned long *)0xFFFE0070)
#define CAPT1_SR_OFFSET 0x70
#define CAPT1_SR_PDCEND_MASK 0x1
#define CAPT1_SR_PDCEND 0x1
#define CAPT1_SR_PDCEND_BIT 0
#define CAPT1_SR_OVERRUN_MASK 0x2
#define CAPT1_SR_OVERRUN 0x2
#define CAPT1_SR_OVERRUN_BIT 1
#define CAPT1_SR_OVERFLOW_MASK 0x4
#define CAPT1_SR_OVERFLOW 0x4
#define CAPT1_SR_OVERFLOW_BIT 2
#define CAPT1_SR_DATACAPT_MASK 0x8
#define CAPT1_SR_DATACAPT 0x8
#define CAPT1_SR_DATACAPT_BIT 3
#define CAPT1_SR_CAPENS_MASK 0x100
#define CAPT1_SR_CAPENS 0x100
#define CAPT1_SR_CAPENS_BIT 8
#define CAPT1_SR_CAPTPIN_MASK 0x10000
#define CAPT1_SR_CAPTPIN 0x10000
#define CAPT1_SR_CAPTPIN_BIT 16

#define CAPT1_IER (*(volatile unsigned long *)0xFFFE0074)
#define CAPT1_IER_OFFSET 0x74
#define CAPT1_IER_PDCEND_MASK 0x1
#define CAPT1_IER_PDCEND 0x1
#define CAPT1_IER_PDCEND_BIT 0
#define CAPT1_IER_OVERRUN_MASK 0x2
#define CAPT1_IER_OVERRUN 0x2
#define CAPT1_IER_OVERRUN_BIT 1
#define CAPT1_IER_OVERFLOW_MASK 0x4
#define CAPT1_IER_OVERFLOW 0x4
#define CAPT1_IER_OVERFLOW_BIT 2
#define CAPT1_IER_DATACAPT_MASK 0x8
#define CAPT1_IER_DATACAPT 0x8
#define CAPT1_IER_DATACAPT_BIT 3
#define CAPT1_IER_CAPTPIN_MASK 0x10000
#define CAPT1_IER_CAPTPIN 0x10000
#define CAPT1_IER_CAPTPIN_BIT 16

#define CAPT1_IDR (*(volatile unsigned long *)0xFFFE0078)
#define CAPT1_IDR_OFFSET 0x78
#define CAPT1_IDR_PDCEND_MASK 0x1
#define CAPT1_IDR_PDCEND 0x1
#define CAPT1_IDR_PDCEND_BIT 0
#define CAPT1_IDR_OVERRUN_MASK 0x2
#define CAPT1_IDR_OVERRUN 0x2
#define CAPT1_IDR_OVERRUN_BIT 1
#define CAPT1_IDR_OVERFLOW_MASK 0x4
#define CAPT1_IDR_OVERFLOW 0x4
#define CAPT1_IDR_OVERFLOW_BIT 2
#define CAPT1_IDR_DATACAPT_MASK 0x8
#define CAPT1_IDR_DATACAPT 0x8
#define CAPT1_IDR_DATACAPT_BIT 3
#define CAPT1_IDR_CAPTPIN_MASK 0x10000
#define CAPT1_IDR_CAPTPIN 0x10000
#define CAPT1_IDR_CAPTPIN_BIT 16

#define CAPT1_IMR (*(volatile unsigned long *)0xFFFE007C)
#define CAPT1_IMR_OFFSET 0x7C
#define CAPT1_IMR_PDCEND_MASK 0x1
#define CAPT1_IMR_PDCEND 0x1
#define CAPT1_IMR_PDCEND_BIT 0
#define CAPT1_IMR_OVERRUN_MASK 0x2
#define CAPT1_IMR_OVERRUN 0x2
#define CAPT1_IMR_OVERRUN_BIT 1
#define CAPT1_IMR_OVERFLOW_MASK 0x4
#define CAPT1_IMR_OVERFLOW 0x4
#define CAPT1_IMR_OVERFLOW_BIT 2
#define CAPT1_IMR_DATACAPT_MASK 0x8
#define CAPT1_IMR_DATACAPT 0x8
#define CAPT1_IMR_DATACAPT_BIT 3
#define CAPT1_IMR_CAPTPIN_MASK 0x10000
#define CAPT1_IMR_CAPTPIN 0x10000
#define CAPT1_IMR_CAPTPIN_BIT 16

#define CAPT1_DR (*(volatile unsigned long *)0xFFFE0080)
#define CAPT1_DR_OFFSET 0x80
#define CAPT1_DR_DURATION_MASK 0x7FFF
#define CAPT1_DR_DURATION_BIT 0
#define CAPT1_DR_LEVEL_MASK 0x8000
#define CAPT1_DR_LEVEL 0x8000
#define CAPT1_DR_LEVEL_BIT 15

#define ST0_BASE 0xFFFE4000

#define ST0_ECR (*(volatile unsigned long *)0xFFFE4050)
#define ST0_ECR_OFFSET 0x50
#define ST0_ECR_ST_MASK 0x2
#define ST0_ECR_ST 0x2
#define ST0_ECR_ST_BIT 1

#define ST0_DCR (*(volatile unsigned long *)0xFFFE4054)
#define ST0_DCR_OFFSET 0x54
#define ST0_DCR_ST_MASK 0x2
#define ST0_DCR_ST 0x2
#define ST0_DCR_ST_BIT 1

#define ST0_PMSR (*(volatile unsigned long *)0xFFFE4058)
#define ST0_PMSR_OFFSET 0x58
#define ST0_PMSR_ST_MASK 0x2
#define ST0_PMSR_ST 0x2
#define ST0_PMSR_ST_BIT 1

#define ST0_CR (*(volatile unsigned long *)0xFFFE4060)
#define ST0_CR_OFFSET 0x60
#define ST0_CR_SWRST_MASK 0x1
#define ST0_CR_SWRST 0x1
#define ST0_CR_SWRST_BIT 0
#define ST0_CR_CHEN0_MASK 0x2
#define ST0_CR_CHEN0 0x2
#define ST0_CR_CHEN0_BIT 1
#define ST0_CR_CHDIS0_MASK 0x4
#define ST0_CR_CHDIS0 0x4
#define ST0_CR_CHDIS0_BIT 2
#define ST0_CR_CHEN1_MASK 0x8
#define ST0_CR_CHEN1 0x8
#define ST0_CR_CHEN1_BIT 3
#define ST0_CR_CHDIS1_MASK 0x10
#define ST0_CR_CHDIS1 0x10
#define ST0_CR_CHDIS1_BIT 4

#define ST0_CSR (*(volatile unsigned long *)0xFFFE406C)
#define ST0_CSR_OFFSET 0x6C
#define ST0_CSR_CHEND0_MASK 0x1
#define ST0_CSR_CHEND0 0x1
#define ST0_CSR_CHEND0_BIT 0
#define ST0_CSR_CHDIS0_MASK 0x2
#define ST0_CSR_CHDIS0 0x2
#define ST0_CSR_CHDIS0_BIT 1
#define ST0_CSR_CHLD0_MASK 0x4
#define ST0_CSR_CHLD0 0x4
#define ST0_CSR_CHLD0_BIT 2
#define ST0_CSR_CHEND1_MASK 0x8
#define ST0_CSR_CHEND1 0x8
#define ST0_CSR_CHEND1_BIT 3
#define ST0_CSR_CHDIS1_MASK 0x10
#define ST0_CSR_CHDIS1 0x10
#define ST0_CSR_CHDIS1_BIT 4
#define ST0_CSR_CHLD1_MASK 0x20
#define ST0_CSR_CHLD1 0x20
#define ST0_CSR_CHLD1_BIT 5

#define ST0_SR (*(volatile unsigned long *)0xFFFE4070)
#define ST0_SR_OFFSET 0x70
#define ST0_SR_CHEND0_MASK 0x1
#define ST0_SR_CHEND0 0x1
#define ST0_SR_CHEND0_BIT 0
#define ST0_SR_CHDIS0_MASK 0x2
#define ST0_SR_CHDIS0 0x2
#define ST0_SR_CHDIS0_BIT 1
#define ST0_SR_CHLD0_MASK 0x4
#define ST0_SR_CHLD0 0x4
#define ST0_SR_CHLD0_BIT 2
#define ST0_SR_CHEND1_MASK 0x8
#define ST0_SR_CHEND1 0x8
#define ST0_SR_CHEND1_BIT 3
#define ST0_SR_CHDIS1_MASK 0x10
#define ST0_SR_CHDIS1 0x10
#define ST0_SR_CHDIS1_BIT 4
#define ST0_SR_CHLD1_MASK 0x20
#define ST0_SR_CHLD1 0x20
#define ST0_SR_CHLD1_BIT 5
#define ST0_SR_CHENS0_MASK 0x1000000
#define ST0_SR_CHENS0 0x1000000
#define ST0_SR_CHENS0_BIT 24
#define ST0_SR_CHENS1_MASK 0x2000000
#define ST0_SR_CHENS1 0x2000000
#define ST0_SR_CHENS1_BIT 25

#define ST0_IER (*(volatile unsigned long *)0xFFFE4074)
#define ST0_IER_OFFSET 0x74
#define ST0_IER_CHEND0_MASK 0x1
#define ST0_IER_CHEND0 0x1
#define ST0_IER_CHEND0_BIT 0
#define ST0_IER_CHDIS0_MASK 0x2
#define ST0_IER_CHDIS0 0x2
#define ST0_IER_CHDIS0_BIT 1
#define ST0_IER_CHLD0_MASK 0x4
#define ST0_IER_CHLD0 0x4
#define ST0_IER_CHLD0_BIT 2
#define ST0_IER_CHEND1_MASK 0x8
#define ST0_IER_CHEND1 0x8
#define ST0_IER_CHEND1_BIT 3
#define ST0_IER_CHDIS1_MASK 0x10
#define ST0_IER_CHDIS1 0x10
#define ST0_IER_CHDIS1_BIT 4
#define ST0_IER_CHLD1_MASK 0x20
#define ST0_IER_CHLD1 0x20
#define ST0_IER_CHLD1_BIT 5

#define ST0_IDR (*(volatile unsigned long *)0xFFFE4078)
#define ST0_IDR_OFFSET 0x78
#define ST0_IDR_CHEND0_MASK 0x1
#define ST0_IDR_CHEND0 0x1
#define ST0_IDR_CHEND0_BIT 0
#define ST0_IDR_CHDIS0_MASK 0x2
#define ST0_IDR_CHDIS0 0x2
#define ST0_IDR_CHDIS0_BIT 1
#define ST0_IDR_CHLD0_MASK 0x4
#define ST0_IDR_CHLD0 0x4
#define ST0_IDR_CHLD0_BIT 2
#define ST0_IDR_CHEND1_MASK 0x8
#define ST0_IDR_CHEND1 0x8
#define ST0_IDR_CHEND1_BIT 3
#define ST0_IDR_CHDIS1_MASK 0x10
#define ST0_IDR_CHDIS1 0x10
#define ST0_IDR_CHDIS1_BIT 4
#define ST0_IDR_CHLD1_MASK 0x20
#define ST0_IDR_CHLD1 0x20
#define ST0_IDR_CHLD1_BIT 5

#define ST0_IMR (*(volatile unsigned long *)0xFFFE407C)
#define ST0_IMR_OFFSET 0x7C
#define ST0_IMR_CHEND0_MASK 0x1
#define ST0_IMR_CHEND0 0x1
#define ST0_IMR_CHEND0_BIT 0
#define ST0_IMR_CHDIS0_MASK 0x2
#define ST0_IMR_CHDIS0 0x2
#define ST0_IMR_CHDIS0_BIT 1
#define ST0_IMR_CHLD0_MASK 0x4
#define ST0_IMR_CHLD0 0x4
#define ST0_IMR_CHLD0_BIT 2
#define ST0_IMR_CHEND1_MASK 0x8
#define ST0_IMR_CHEND1 0x8
#define ST0_IMR_CHEND1_BIT 3
#define ST0_IMR_CHDIS1_MASK 0x10
#define ST0_IMR_CHDIS1 0x10
#define ST0_IMR_CHDIS1_BIT 4
#define ST0_IMR_CHLD1_MASK 0x20
#define ST0_IMR_CHLD1 0x20
#define ST0_IMR_CHLD1_BIT 5

#define ST0_PR0 (*(volatile unsigned long *)0xFFFE4080)
#define ST0_PR0_OFFSET 0x80
#define ST0_PR0_PRESCALAR_MASK 0xF
#define ST0_PR0_PRESCALAR_BIT 0
#define ST0_PR0_SELECTCLK_MASK 0x10
#define ST0_PR0_SELECTCLK 0x10
#define ST0_PR0_SELECTCLK_BIT 4
#define ST0_PR0_AUTOREL_MASK 0x20
#define ST0_PR0_AUTOREL 0x20
#define ST0_PR0_AUTOREL_BIT 5
#define ST0_PR0_SYSCAL_MASK 0x7FF00
#define ST0_PR0_SYSCAL_BIT 8

#define ST0_CT0 (*(volatile unsigned long *)0xFFFE4084)
#define ST0_CT0_OFFSET 0x84
#define ST0_CT0_LOAD_MASK 0xFFFF
#define ST0_CT0_LOAD_BIT 0

#define ST0_PR1 (*(volatile unsigned long *)0xFFFE4088)
#define ST0_PR1_OFFSET 0x88
#define ST0_PR1_PRESCALAR_MASK 0xF
#define ST0_PR1_PRESCALAR_BIT 0
#define ST0_PR1_SELECTCLK_MASK 0x10
#define ST0_PR1_SELECTCLK 0x10
#define ST0_PR1_SELECTCLK_BIT 4
#define ST0_PR1_AUTOREL_MASK 0x20
#define ST0_PR1_AUTOREL 0x20
#define ST0_PR1_AUTOREL_BIT 5
#define ST0_PR1_SYSCAL_MASK 0x7FF00
#define ST0_PR1_SYSCAL_BIT 8

#define ST0_CT1 (*(volatile unsigned long *)0xFFFE408C)
#define ST0_CT1_OFFSET 0x8C
#define ST0_CT1_LOAD_MASK 0xFFFF
#define ST0_CT1_LOAD_BIT 0

#define ST0_CCV0 (*(volatile unsigned long *)0xFFFE4200)
#define ST0_CCV0_OFFSET 0x200
#define ST0_CCV0_COUNT_MASK 0xFFFF
#define ST0_CCV0_COUNT_BIT 0

#define ST0_CCV1 (*(volatile unsigned long *)0xFFFE4204)
#define ST0_CCV1_OFFSET 0x204
#define ST0_CCV1_COUNT_MASK 0xFFFF
#define ST0_CCV1_COUNT_BIT 0

#define ST1_BASE 0xFFFE8000

#define ST1_ECR (*(volatile unsigned long *)0xFFFE8050)
#define ST1_ECR_OFFSET 0x50
#define ST1_ECR_ST_MASK 0x2
#define ST1_ECR_ST 0x2
#define ST1_ECR_ST_BIT 1

#define ST1_DCR (*(volatile unsigned long *)0xFFFE8054)
#define ST1_DCR_OFFSET 0x54
#define ST1_DCR_ST_MASK 0x2
#define ST1_DCR_ST 0x2
#define ST1_DCR_ST_BIT 1

#define ST1_PMSR (*(volatile unsigned long *)0xFFFE8058)
#define ST1_PMSR_OFFSET 0x58
#define ST1_PMSR_ST_MASK 0x2
#define ST1_PMSR_ST 0x2
#define ST1_PMSR_ST_BIT 1

#define ST1_CR (*(volatile unsigned long *)0xFFFE8060)
#define ST1_CR_OFFSET 0x60
#define ST1_CR_SWRST_MASK 0x1
#define ST1_CR_SWRST 0x1
#define ST1_CR_SWRST_BIT 0
#define ST1_CR_CHEN0_MASK 0x2
#define ST1_CR_CHEN0 0x2
#define ST1_CR_CHEN0_BIT 1
#define ST1_CR_CHDIS0_MASK 0x4
#define ST1_CR_CHDIS0 0x4
#define ST1_CR_CHDIS0_BIT 2
#define ST1_CR_CHEN1_MASK 0x8
#define ST1_CR_CHEN1 0x8
#define ST1_CR_CHEN1_BIT 3
#define ST1_CR_CHDIS1_MASK 0x10
#define ST1_CR_CHDIS1 0x10
#define ST1_CR_CHDIS1_BIT 4

#define ST1_CSR (*(volatile unsigned long *)0xFFFE806C)
#define ST1_CSR_OFFSET 0x6C
#define ST1_CSR_CHEND0_MASK 0x1
#define ST1_CSR_CHEND0 0x1
#define ST1_CSR_CHEND0_BIT 0
#define ST1_CSR_CHDIS0_MASK 0x2
#define ST1_CSR_CHDIS0 0x2
#define ST1_CSR_CHDIS0_BIT 1
#define ST1_CSR_CHLD0_MASK 0x4
#define ST1_CSR_CHLD0 0x4
#define ST1_CSR_CHLD0_BIT 2
#define ST1_CSR_CHEND1_MASK 0x8
#define ST1_CSR_CHEND1 0x8
#define ST1_CSR_CHEND1_BIT 3
#define ST1_CSR_CHDIS1_MASK 0x10
#define ST1_CSR_CHDIS1 0x10
#define ST1_CSR_CHDIS1_BIT 4
#define ST1_CSR_CHLD1_MASK 0x20
#define ST1_CSR_CHLD1 0x20
#define ST1_CSR_CHLD1_BIT 5

#define ST1_SR (*(volatile unsigned long *)0xFFFE8070)
#define ST1_SR_OFFSET 0x70
#define ST1_SR_CHEND0_MASK 0x1
#define ST1_SR_CHEND0 0x1
#define ST1_SR_CHEND0_BIT 0
#define ST1_SR_CHDIS0_MASK 0x2
#define ST1_SR_CHDIS0 0x2
#define ST1_SR_CHDIS0_BIT 1
#define ST1_SR_CHLD0_MASK 0x4
#define ST1_SR_CHLD0 0x4
#define ST1_SR_CHLD0_BIT 2
#define ST1_SR_CHEND1_MASK 0x8
#define ST1_SR_CHEND1 0x8
#define ST1_SR_CHEND1_BIT 3
#define ST1_SR_CHDIS1_MASK 0x10
#define ST1_SR_CHDIS1 0x10
#define ST1_SR_CHDIS1_BIT 4
#define ST1_SR_CHLD1_MASK 0x20
#define ST1_SR_CHLD1 0x20
#define ST1_SR_CHLD1_BIT 5
#define ST1_SR_CHENS0_MASK 0x1000000
#define ST1_SR_CHENS0 0x1000000
#define ST1_SR_CHENS0_BIT 24
#define ST1_SR_CHENS1_MASK 0x2000000
#define ST1_SR_CHENS1 0x2000000
#define ST1_SR_CHENS1_BIT 25

#define ST1_IER (*(volatile unsigned long *)0xFFFE8074)
#define ST1_IER_OFFSET 0x74
#define ST1_IER_CHEND0_MASK 0x1
#define ST1_IER_CHEND0 0x1
#define ST1_IER_CHEND0_BIT 0
#define ST1_IER_CHDIS0_MASK 0x2
#define ST1_IER_CHDIS0 0x2
#define ST1_IER_CHDIS0_BIT 1
#define ST1_IER_CHLD0_MASK 0x4
#define ST1_IER_CHLD0 0x4
#define ST1_IER_CHLD0_BIT 2
#define ST1_IER_CHEND1_MASK 0x8
#define ST1_IER_CHEND1 0x8
#define ST1_IER_CHEND1_BIT 3
#define ST1_IER_CHDIS1_MASK 0x10
#define ST1_IER_CHDIS1 0x10
#define ST1_IER_CHDIS1_BIT 4
#define ST1_IER_CHLD1_MASK 0x20
#define ST1_IER_CHLD1 0x20
#define ST1_IER_CHLD1_BIT 5

#define ST1_IDR (*(volatile unsigned long *)0xFFFE8078)
#define ST1_IDR_OFFSET 0x78
#define ST1_IDR_CHEND0_MASK 0x1
#define ST1_IDR_CHEND0 0x1
#define ST1_IDR_CHEND0_BIT 0
#define ST1_IDR_CHDIS0_MASK 0x2
#define ST1_IDR_CHDIS0 0x2
#define ST1_IDR_CHDIS0_BIT 1
#define ST1_IDR_CHLD0_MASK 0x4
#define ST1_IDR_CHLD0 0x4
#define ST1_IDR_CHLD0_BIT 2
#define ST1_IDR_CHEND1_MASK 0x8
#define ST1_IDR_CHEND1 0x8
#define ST1_IDR_CHEND1_BIT 3
#define ST1_IDR_CHDIS1_MASK 0x10
#define ST1_IDR_CHDIS1 0x10
#define ST1_IDR_CHDIS1_BIT 4
#define ST1_IDR_CHLD1_MASK 0x20
#define ST1_IDR_CHLD1 0x20
#define ST1_IDR_CHLD1_BIT 5

#define ST1_IMR (*(volatile unsigned long *)0xFFFE807C)
#define ST1_IMR_OFFSET 0x7C
#define ST1_IMR_CHEND0_MASK 0x1
#define ST1_IMR_CHEND0 0x1
#define ST1_IMR_CHEND0_BIT 0
#define ST1_IMR_CHDIS0_MASK 0x2
#define ST1_IMR_CHDIS0 0x2
#define ST1_IMR_CHDIS0_BIT 1
#define ST1_IMR_CHLD0_MASK 0x4
#define ST1_IMR_CHLD0 0x4
#define ST1_IMR_CHLD0_BIT 2
#define ST1_IMR_CHEND1_MASK 0x8
#define ST1_IMR_CHEND1 0x8
#define ST1_IMR_CHEND1_BIT 3
#define ST1_IMR_CHDIS1_MASK 0x10
#define ST1_IMR_CHDIS1 0x10
#define ST1_IMR_CHDIS1_BIT 4
#define ST1_IMR_CHLD1_MASK 0x20
#define ST1_IMR_CHLD1 0x20
#define ST1_IMR_CHLD1_BIT 5

#define ST1_PR0 (*(volatile unsigned long *)0xFFFE8080)
#define ST1_PR0_OFFSET 0x80
#define ST1_PR0_PRESCALAR_MASK 0xF
#define ST1_PR0_PRESCALAR_BIT 0
#define ST1_PR0_SELECTCLK_MASK 0x10
#define ST1_PR0_SELECTCLK 0x10
#define ST1_PR0_SELECTCLK_BIT 4
#define ST1_PR0_AUTOREL_MASK 0x20
#define ST1_PR0_AUTOREL 0x20
#define ST1_PR0_AUTOREL_BIT 5
#define ST1_PR0_SYSCAL_MASK 0x7FF00
#define ST1_PR0_SYSCAL_BIT 8

#define ST1_CT0 (*(volatile unsigned long *)0xFFFE8084)
#define ST1_CT0_OFFSET 0x84
#define ST1_CT0_LOAD_MASK 0xFFFF
#define ST1_CT0_LOAD_BIT 0

#define ST1_PR1 (*(volatile unsigned long *)0xFFFE8088)
#define ST1_PR1_OFFSET 0x88
#define ST1_PR1_PRESCALAR_MASK 0xF
#define ST1_PR1_PRESCALAR_BIT 0
#define ST1_PR1_SELECTCLK_MASK 0x10
#define ST1_PR1_SELECTCLK 0x10
#define ST1_PR1_SELECTCLK_BIT 4
#define ST1_PR1_AUTOREL_MASK 0x20
#define ST1_PR1_AUTOREL 0x20
#define ST1_PR1_AUTOREL_BIT 5
#define ST1_PR1_SYSCAL_MASK 0x7FF00
#define ST1_PR1_SYSCAL_BIT 8

#define ST1_CT1 (*(volatile unsigned long *)0xFFFE808C)
#define ST1_CT1_OFFSET 0x8C
#define ST1_CT1_LOAD_MASK 0xFFFF
#define ST1_CT1_LOAD_BIT 0

#define ST1_CCV0 (*(volatile unsigned long *)0xFFFE8200)
#define ST1_CCV0_OFFSET 0x200
#define ST1_CCV0_COUNT_MASK 0xFFFF
#define ST1_CCV0_COUNT_BIT 0

#define ST1_CCV1 (*(volatile unsigned long *)0xFFFE8204)
#define ST1_CCV1_OFFSET 0x204
#define ST1_CCV1_COUNT_MASK 0xFFFF
#define ST1_CCV1_COUNT_BIT 0

#define CM_BASE 0xFFFEC000

#define CM_CE (*(volatile unsigned long *)0xFFFEC000)
#define CM_CE_OFFSET 0x0
#define CM_CE_PLLSLCT_MASK 0x4
#define CM_CE_PLLSLCT 0x4
#define CM_CE_PLLSLCT_BIT 2
#define CM_CE_LFSLCT_MASK 0x8
#define CM_CE_LFSLCT 0x8
#define CM_CE_LFSLCT_BIT 3
#define CM_CE_DIVSLCT_MASK 0x20
#define CM_CE_DIVSLCT 0x20
#define CM_CE_DIVSLCT_BIT 5
#define CM_CE_RTCSEL_MASK 0x40
#define CM_CE_RTCSEL 0x40
#define CM_CE_RTCSEL_BIT 6
#define CM_CE_RTCKEN_MASK 0x80
#define CM_CE_RTCKEN 0x80
#define CM_CE_RTCKEN_BIT 7
#define CM_CE_CLKEKEY_MASK 0xFFFF0000
#define CM_CE_CLKEKEY_BIT 16

#define CM_CD (*(volatile unsigned long *)0xFFFEC004)
#define CM_CD_OFFSET 0x4
#define CM_CD_PLLSLCT_MASK 0x4
#define CM_CD_PLLSLCT 0x4
#define CM_CD_PLLSLCT_BIT 2
#define CM_CD_LFSLCT_MASK 0x8
#define CM_CD_LFSLCT 0x8
#define CM_CD_LFSLCT_BIT 3
#define CM_CD_DIVSLCT_MASK 0x20
#define CM_CD_DIVSLCT 0x20
#define CM_CD_DIVSLCT_BIT 5
#define CM_CD_RTCSEL_MASK 0x40
#define CM_CD_RTCSEL 0x40
#define CM_CD_RTCSEL_BIT 6
#define CM_CD_RTCKEN_MASK 0x80
#define CM_CD_RTCKEN 0x80
#define CM_CD_RTCKEN_BIT 7
#define CM_CD_CLKEKEY_MASK 0xFFFF0000
#define CM_CD_CLKEKEY_BIT 16

#define CM_CS (*(volatile unsigned long *)0xFFFEC008)
#define CM_CS_OFFSET 0x8
#define CM_CS_PLLSLCT_MASK 0x4
#define CM_CS_PLLSLCT 0x4
#define CM_CS_PLLSLCT_BIT 2
#define CM_CS_LFSLCT_MASK 0x8
#define CM_CS_LFSLCT 0x8
#define CM_CS_LFSLCT_BIT 3
#define CM_CS_DIVSLCT_MASK 0x20
#define CM_CS_DIVSLCT 0x20
#define CM_CS_DIVSLCT_BIT 5
#define CM_CS_RTCSEL_MASK 0x40
#define CM_CS_RTCSEL 0x40
#define CM_CS_RTCSEL_BIT 6
#define CM_CS_RTCKEN_MASK 0x80
#define CM_CS_RTCKEN 0x80
#define CM_CS_RTCKEN_BIT 7
#define CM_CS_MCKEN_MASK 0x100
#define CM_CS_MCKEN 0x100
#define CM_CS_MCKEN_BIT 8
#define CM_CS_PLLEN_MASK 0x200
#define CM_CS_PLLEN 0x200
#define CM_CS_PLLEN_BIT 9
#define CM_CS_DIVEN_MASK 0x2000
#define CM_CS_DIVEN 0x2000
#define CM_CS_DIVEN_BIT 13
#define CM_CS_RTCSLCT_MASK 0x4000
#define CM_CS_RTCSLCT 0x4000
#define CM_CS_RTCSLCT_BIT 14

#define CM_PST (*(volatile unsigned long *)0xFFFEC00C)
#define CM_PST_OFFSET 0xC
#define CM_PST_PSTB_MASK 0x3FF
#define CM_PST_PSTB_BIT 0
#define CM_PST_PSTKEY_MASK 0xFFFF0000
#define CM_PST_PSTKEY_BIT 16

#define CM_PDIV (*(volatile unsigned long *)0xFFFEC010)
#define CM_PDIV_OFFSET 0x10
#define CM_PDIV_PMUL_MASK 0x1F
#define CM_PDIV_PMUL_BIT 0
#define CM_PDIV_PLLDIV2_MASK 0x8000
#define CM_PDIV_PLLDIV2 0x8000
#define CM_PDIV_PLLDIV2_BIT 15
#define CM_PDIV_PDIVKEY_MASK 0xFFFF0000
#define CM_PDIV_PDIVKEY_BIT 16

#define CM_OST (*(volatile unsigned long *)0xFFFEC014)
#define CM_OST_OFFSET 0x14
#define CM_OST_OSTB_MASK 0x3FF
#define CM_OST_OSTB_BIT 0
#define CM_OST_OSTKEY_MASK 0xFFFF0000
#define CM_OST_OSTKEY_BIT 16

#define CM_MDIV (*(volatile unsigned long *)0xFFFEC018)
#define CM_MDIV_OFFSET 0x18
#define CM_MDIV_MDIV_MASK 0x3F
#define CM_MDIV_MDIV_BIT 0
#define CM_MDIV_MDIVKEY_MASK 0xFFFF0000
#define CM_MDIV_MDIVKEY_BIT 16

#define PMC_BASE 0xFFFF4000

#define PMC_ECR (*(volatile unsigned long *)0xFFFF4050)
#define PMC_ECR_OFFSET 0x50
#define PMC_ECR_PDC_MASK 0x2
#define PMC_ECR_PDC 0x2
#define PMC_ECR_PDC_BIT 1

#define PMC_DCR (*(volatile unsigned long *)0xFFFF4054)
#define PMC_DCR_OFFSET 0x54
#define PMC_DCR_ARM_MASK 0x1
#define PMC_DCR_ARM 0x1
#define PMC_DCR_ARM_BIT 0
#define PMC_DCR_PDC_MASK 0x2
#define PMC_DCR_PDC 0x2
#define PMC_DCR_PDC_BIT 1

#define PMC_PMSR (*(volatile unsigned long *)0xFFFF4058)
#define PMC_PMSR_OFFSET 0x58
#define PMC_PMSR_ARM_MASK 0x1
#define PMC_PMSR_ARM 0x1
#define PMC_PMSR_ARM_BIT 0
#define PMC_PMSR_PDC_MASK 0x2
#define PMC_PMSR_PDC 0x2
#define PMC_PMSR_PDC_BIT 1

#define PDC_BASE 0xFFFF8000

#define PDC_PRA0 (*(volatile unsigned long *)0xFFFF8080)
#define PDC_PRA0_OFFSET 0x80
#define PDC_PRA0_CHPRA_MASK 0x0
#define PDC_PRA0_CHPRA_BIT 0

#define PDC_CR0 (*(volatile unsigned long *)0xFFFF8084)
#define PDC_CR0_OFFSET 0x84
#define PDC_CR0_DIR_MASK 0x1
#define PDC_CR0_DIR 0x1
#define PDC_CR0_DIR_BIT 0
#define PDC_CR0_SIZE_MASK 0x6
#define PDC_CR0_SIZE_BIT 1

#define PDC_MPR0 (*(volatile unsigned long *)0xFFFF8088)
#define PDC_MPR0_OFFSET 0x88
#define PDC_MPR0_CHPTR_MASK 0x0
#define PDC_MPR0_CHPTR_BIT 0

#define PDC_TCR0 (*(volatile unsigned long *)0xFFFF808C)
#define PDC_TCR0_OFFSET 0x8C
#define PDC_TCR0_CHCTR_MASK 0xFFFF
#define PDC_TCR0_CHCTR_BIT 0

#define PDC_PRA1 (*(volatile unsigned long *)0xFFFF8090)
#define PDC_PRA1_OFFSET 0x90
#define PDC_PRA1_CHPRA_MASK 0x0
#define PDC_PRA1_CHPRA_BIT 0

#define PDC_CR1 (*(volatile unsigned long *)0xFFFF8094)
#define PDC_CR1_OFFSET 0x94
#define PDC_CR1_DIR_MASK 0x1
#define PDC_CR1_DIR 0x1
#define PDC_CR1_DIR_BIT 0
#define PDC_CR1_SIZE_MASK 0x6
#define PDC_CR1_SIZE_BIT 1

#define PDC_MPR1 (*(volatile unsigned long *)0xFFFF8098)
#define PDC_MPR1_OFFSET 0x98
#define PDC_MPR1_CHPTR_MASK 0x0
#define PDC_MPR1_CHPTR_BIT 0

#define PDC_TCR1 (*(volatile unsigned long *)0xFFFF809C)
#define PDC_TCR1_OFFSET 0x9C
#define PDC_TCR1_CHCTR_MASK 0xFFFF
#define PDC_TCR1_CHCTR_BIT 0

#define PDC_PRA2 (*(volatile unsigned long *)0xFFFF80A0)
#define PDC_PRA2_OFFSET 0xA0
#define PDC_PRA2_CHPRA_MASK 0x0
#define PDC_PRA2_CHPRA_BIT 0

#define PDC_CR2 (*(volatile unsigned long *)0xFFFF80A4)
#define PDC_CR2_OFFSET 0xA4
#define PDC_CR2_DIR_MASK 0x1
#define PDC_CR2_DIR 0x1
#define PDC_CR2_DIR_BIT 0
#define PDC_CR2_SIZE_MASK 0x6
#define PDC_CR2_SIZE_BIT 1

#define PDC_MPR2 (*(volatile unsigned long *)0xFFFF80A8)
#define PDC_MPR2_OFFSET 0xA8
#define PDC_MPR2_CHPTR_MASK 0x0
#define PDC_MPR2_CHPTR_BIT 0

#define PDC_TCR2 (*(volatile unsigned long *)0xFFFF80AC)
#define PDC_TCR2_OFFSET 0xAC
#define PDC_TCR2_CHCTR_MASK 0xFFFF
#define PDC_TCR2_CHCTR_BIT 0

#define PDC_PRA3 (*(volatile unsigned long *)0xFFFF80B0)
#define PDC_PRA3_OFFSET 0xB0
#define PDC_PRA3_CHPRA_MASK 0x0
#define PDC_PRA3_CHPRA_BIT 0

#define PDC_CR3 (*(volatile unsigned long *)0xFFFF80B4)
#define PDC_CR3_OFFSET 0xB4
#define PDC_CR3_DIR_MASK 0x1
#define PDC_CR3_DIR 0x1
#define PDC_CR3_DIR_BIT 0
#define PDC_CR3_SIZE_MASK 0x6
#define PDC_CR3_SIZE_BIT 1

#define PDC_MPR3 (*(volatile unsigned long *)0xFFFF80B8)
#define PDC_MPR3_OFFSET 0xB8
#define PDC_MPR3_CHPTR_MASK 0x0
#define PDC_MPR3_CHPTR_BIT 0

#define PDC_TCR3 (*(volatile unsigned long *)0xFFFF80BC)
#define PDC_TCR3_OFFSET 0xBC
#define PDC_TCR3_CHCTR_MASK 0xFFFF
#define PDC_TCR3_CHCTR_BIT 0

#define PDC_PRA4 (*(volatile unsigned long *)0xFFFF80C0)
#define PDC_PRA4_OFFSET 0xC0
#define PDC_PRA4_CHPRA_MASK 0x0
#define PDC_PRA4_CHPRA_BIT 0

#define PDC_CR4 (*(volatile unsigned long *)0xFFFF80C4)
#define PDC_CR4_OFFSET 0xC4
#define PDC_CR4_DIR_MASK 0x1
#define PDC_CR4_DIR 0x1
#define PDC_CR4_DIR_BIT 0
#define PDC_CR4_SIZE_MASK 0x6
#define PDC_CR4_SIZE_BIT 1

#define PDC_MPR4 (*(volatile unsigned long *)0xFFFF80C8)
#define PDC_MPR4_OFFSET 0xC8
#define PDC_MPR4_CHPTR_MASK 0x0
#define PDC_MPR4_CHPTR_BIT 0

#define PDC_TCR4 (*(volatile unsigned long *)0xFFFF80CC)
#define PDC_TCR4_OFFSET 0xCC
#define PDC_TCR4_CHCTR_MASK 0xFFFF
#define PDC_TCR4_CHCTR_BIT 0

#define PDC_PRA5 (*(volatile unsigned long *)0xFFFF80D0)
#define PDC_PRA5_OFFSET 0xD0
#define PDC_PRA5_CHPRA_MASK 0x0
#define PDC_PRA5_CHPRA_BIT 0

#define PDC_CR5 (*(volatile unsigned long *)0xFFFF80D4)
#define PDC_CR5_OFFSET 0xD4
#define PDC_CR5_DIR_MASK 0x1
#define PDC_CR5_DIR 0x1
#define PDC_CR5_DIR_BIT 0
#define PDC_CR5_SIZE_MASK 0x6
#define PDC_CR5_SIZE_BIT 1

#define PDC_MPR5 (*(volatile unsigned long *)0xFFFF80D8)
#define PDC_MPR5_OFFSET 0xD8
#define PDC_MPR5_CHPTR_MASK 0x0
#define PDC_MPR5_CHPTR_BIT 0

#define PDC_TCR5 (*(volatile unsigned long *)0xFFFF80DC)
#define PDC_TCR5_OFFSET 0xDC
#define PDC_TCR5_CHCTR_MASK 0xFFFF
#define PDC_TCR5_CHCTR_BIT 0

#define PDC_PRA6 (*(volatile unsigned long *)0xFFFF80E0)
#define PDC_PRA6_OFFSET 0xE0
#define PDC_PRA6_CHPRA_MASK 0x0
#define PDC_PRA6_CHPRA_BIT 0

#define PDC_CR6 (*(volatile unsigned long *)0xFFFF80E4)
#define PDC_CR6_OFFSET 0xE4
#define PDC_CR6_DIR_MASK 0x1
#define PDC_CR6_DIR 0x1
#define PDC_CR6_DIR_BIT 0
#define PDC_CR6_SIZE_MASK 0x6
#define PDC_CR6_SIZE_BIT 1

#define PDC_MPR6 (*(volatile unsigned long *)0xFFFF80E8)
#define PDC_MPR6_OFFSET 0xE8
#define PDC_MPR6_CHPTR_MASK 0x0
#define PDC_MPR6_CHPTR_BIT 0

#define PDC_TCR6 (*(volatile unsigned long *)0xFFFF80EC)
#define PDC_TCR6_OFFSET 0xEC
#define PDC_TCR6_CHCTR_MASK 0xFFFF
#define PDC_TCR6_CHCTR_BIT 0

#define PDC_PRA7 (*(volatile unsigned long *)0xFFFF80F0)
#define PDC_PRA7_OFFSET 0xF0
#define PDC_PRA7_CHPRA_MASK 0x0
#define PDC_PRA7_CHPRA_BIT 0

#define PDC_CR7 (*(volatile unsigned long *)0xFFFF80F4)
#define PDC_CR7_OFFSET 0xF4
#define PDC_CR7_DIR_MASK 0x1
#define PDC_CR7_DIR 0x1
#define PDC_CR7_DIR_BIT 0
#define PDC_CR7_SIZE_MASK 0x6
#define PDC_CR7_SIZE_BIT 1

#define PDC_MPR7 (*(volatile unsigned long *)0xFFFF80F8)
#define PDC_MPR7_OFFSET 0xF8
#define PDC_MPR7_CHPTR_MASK 0x0
#define PDC_MPR7_CHPTR_BIT 0

#define PDC_TCR7 (*(volatile unsigned long *)0xFFFF80FC)
#define PDC_TCR7_OFFSET 0xFC
#define PDC_TCR7_CHCTR_MASK 0xFFFF
#define PDC_TCR7_CHCTR_BIT 0

#define PDC_PRA8 (*(volatile unsigned long *)0xFFFF8100)
#define PDC_PRA8_OFFSET 0x100
#define PDC_PRA8_CHPRA_MASK 0x0
#define PDC_PRA8_CHPRA_BIT 0

#define PDC_CR8 (*(volatile unsigned long *)0xFFFF8104)
#define PDC_CR8_OFFSET 0x104
#define PDC_CR8_DIR_MASK 0x1
#define PDC_CR8_DIR 0x1
#define PDC_CR8_DIR_BIT 0
#define PDC_CR8_SIZE_MASK 0x6
#define PDC_CR8_SIZE_BIT 1

#define PDC_MPR8 (*(volatile unsigned long *)0xFFFF8108)
#define PDC_MPR8_OFFSET 0x108
#define PDC_MPR8_CHPTR_MASK 0x0
#define PDC_MPR8_CHPTR_BIT 0

#define PDC_TCR8 (*(volatile unsigned long *)0xFFFF810C)
#define PDC_TCR8_OFFSET 0x10C
#define PDC_TCR8_CHCTR_MASK 0xFFFF
#define PDC_TCR8_CHCTR_BIT 0

#define PDC_PRA9 (*(volatile unsigned long *)0xFFFF8110)
#define PDC_PRA9_OFFSET 0x110
#define PDC_PRA9_CHPRA_MASK 0x0
#define PDC_PRA9_CHPRA_BIT 0

#define PDC_CR9 (*(volatile unsigned long *)0xFFFF8114)
#define PDC_CR9_OFFSET 0x114
#define PDC_CR9_DIR_MASK 0x1
#define PDC_CR9_DIR 0x1
#define PDC_CR9_DIR_BIT 0
#define PDC_CR9_SIZE_MASK 0x6
#define PDC_CR9_SIZE_BIT 1

#define PDC_MPR9 (*(volatile unsigned long *)0xFFFF8118)
#define PDC_MPR9_OFFSET 0x118
#define PDC_MPR9_CHPTR_MASK 0x0
#define PDC_MPR9_CHPTR_BIT 0

#define PDC_TCR9 (*(volatile unsigned long *)0xFFFF811C)
#define PDC_TCR9_OFFSET 0x11C
#define PDC_TCR9_CHCTR_MASK 0xFFFF
#define PDC_TCR9_CHCTR_BIT 0

#define PDC_PRA10 (*(volatile unsigned long *)0xFFFF8120)
#define PDC_PRA10_OFFSET 0x120
#define PDC_PRA10_CHPRA_MASK 0x0
#define PDC_PRA10_CHPRA_BIT 0

#define PDC_CR10 (*(volatile unsigned long *)0xFFFF8124)
#define PDC_CR10_OFFSET 0x124
#define PDC_CR10_DIR_MASK 0x1
#define PDC_CR10_DIR 0x1
#define PDC_CR10_DIR_BIT 0
#define PDC_CR10_SIZE_MASK 0x6
#define PDC_CR10_SIZE_BIT 1

#define PDC_MPR10 (*(volatile unsigned long *)0xFFFF8128)
#define PDC_MPR10_OFFSET 0x128
#define PDC_MPR10_CHPTR_MASK 0x0
#define PDC_MPR10_CHPTR_BIT 0

#define PDC_TCR10 (*(volatile unsigned long *)0xFFFF812C)
#define PDC_TCR10_OFFSET 0x12C
#define PDC_TCR10_CHCTR_MASK 0xFFFF
#define PDC_TCR10_CHCTR_BIT 0

#define GIC_BASE 0xFFFFF000

#define GIC_SMR0 (*(volatile unsigned long *)0xFFFFF000)
#define GIC_SMR0_OFFSET 0x0
#define GIC_SMR0_PRIOR_MASK 0x7
#define GIC_SMR0_PRIOR_BIT 0
#define GIC_SMR0_SRCTYPE_MASK 0x60
#define GIC_SMR0_SRCTYPE_BIT 5

#define GIC_SMR1 (*(volatile unsigned long *)0xFFFFF004)
#define GIC_SMR1_OFFSET 0x4
#define GIC_SMR1_PRIOR_MASK 0x7
#define GIC_SMR1_PRIOR_BIT 0
#define GIC_SMR1_SRCTYPE_MASK 0x60
#define GIC_SMR1_SRCTYPE_BIT 5

#define GIC_SMR2 (*(volatile unsigned long *)0xFFFFF008)
#define GIC_SMR2_OFFSET 0x8
#define GIC_SMR2_PRIOR_MASK 0x7
#define GIC_SMR2_PRIOR_BIT 0
#define GIC_SMR2_SRCTYPE_MASK 0x60
#define GIC_SMR2_SRCTYPE_BIT 5

#define GIC_SMR3 (*(volatile unsigned long *)0xFFFFF00C)
#define GIC_SMR3_OFFSET 0xC
#define GIC_SMR3_PRIOR_MASK 0x7
#define GIC_SMR3_PRIOR_BIT 0
#define GIC_SMR3_SRCTYPE_MASK 0x60
#define GIC_SMR3_SRCTYPE_BIT 5

#define GIC_SMR4 (*(volatile unsigned long *)0xFFFFF010)
#define GIC_SMR4_OFFSET 0x10
#define GIC_SMR4_PRIOR_MASK 0x7
#define GIC_SMR4_PRIOR_BIT 0
#define GIC_SMR4_SRCTYPE_MASK 0x60
#define GIC_SMR4_SRCTYPE_BIT 5

#define GIC_SMR5 (*(volatile unsigned long *)0xFFFFF014)
#define GIC_SMR5_OFFSET 0x14
#define GIC_SMR5_PRIOR_MASK 0x7
#define GIC_SMR5_PRIOR_BIT 0
#define GIC_SMR5_SRCTYPE_MASK 0x60
#define GIC_SMR5_SRCTYPE_BIT 5

#define GIC_SMR6 (*(volatile unsigned long *)0xFFFFF018)
#define GIC_SMR6_OFFSET 0x18
#define GIC_SMR6_PRIOR_MASK 0x7
#define GIC_SMR6_PRIOR_BIT 0
#define GIC_SMR6_SRCTYPE_MASK 0x60
#define GIC_SMR6_SRCTYPE_BIT 5

#define GIC_SMR7 (*(volatile unsigned long *)0xFFFFF01C)
#define GIC_SMR7_OFFSET 0x1C
#define GIC_SMR7_PRIOR_MASK 0x7
#define GIC_SMR7_PRIOR_BIT 0
#define GIC_SMR7_SRCTYPE_MASK 0x60
#define GIC_SMR7_SRCTYPE_BIT 5

#define GIC_SMR8 (*(volatile unsigned long *)0xFFFFF020)
#define GIC_SMR8_OFFSET 0x20
#define GIC_SMR8_PRIOR_MASK 0x7
#define GIC_SMR8_PRIOR_BIT 0
#define GIC_SMR8_SRCTYPE_MASK 0x60
#define GIC_SMR8_SRCTYPE_BIT 5

#define GIC_SMR9 (*(volatile unsigned long *)0xFFFFF024)
#define GIC_SMR9_OFFSET 0x24
#define GIC_SMR9_PRIOR_MASK 0x7
#define GIC_SMR9_PRIOR_BIT 0
#define GIC_SMR9_SRCTYPE_MASK 0x60
#define GIC_SMR9_SRCTYPE_BIT 5

#define GIC_SMR10 (*(volatile unsigned long *)0xFFFFF028)
#define GIC_SMR10_OFFSET 0x28
#define GIC_SMR10_PRIOR_MASK 0x7
#define GIC_SMR10_PRIOR_BIT 0
#define GIC_SMR10_SRCTYPE_MASK 0x60
#define GIC_SMR10_SRCTYPE_BIT 5

#define GIC_SMR11 (*(volatile unsigned long *)0xFFFFF02C)
#define GIC_SMR11_OFFSET 0x2C
#define GIC_SMR11_PRIOR_MASK 0x7
#define GIC_SMR11_PRIOR_BIT 0
#define GIC_SMR11_SRCTYPE_MASK 0x60
#define GIC_SMR11_SRCTYPE_BIT 5

#define GIC_SMR12 (*(volatile unsigned long *)0xFFFFF030)
#define GIC_SMR12_OFFSET 0x30
#define GIC_SMR12_PRIOR_MASK 0x7
#define GIC_SMR12_PRIOR_BIT 0
#define GIC_SMR12_SRCTYPE_MASK 0x60
#define GIC_SMR12_SRCTYPE_BIT 5

#define GIC_SMR13 (*(volatile unsigned long *)0xFFFFF034)
#define GIC_SMR13_OFFSET 0x34
#define GIC_SMR13_PRIOR_MASK 0x7
#define GIC_SMR13_PRIOR_BIT 0
#define GIC_SMR13_SRCTYPE_MASK 0x60
#define GIC_SMR13_SRCTYPE_BIT 5

#define GIC_SMR14 (*(volatile unsigned long *)0xFFFFF038)
#define GIC_SMR14_OFFSET 0x38
#define GIC_SMR14_PRIOR_MASK 0x7
#define GIC_SMR14_PRIOR_BIT 0
#define GIC_SMR14_SRCTYPE_MASK 0x60
#define GIC_SMR14_SRCTYPE_BIT 5

#define GIC_SMR15 (*(volatile unsigned long *)0xFFFFF03C)
#define GIC_SMR15_OFFSET 0x3C
#define GIC_SMR15_PRIOR_MASK 0x7
#define GIC_SMR15_PRIOR_BIT 0
#define GIC_SMR15_SRCTYPE_MASK 0x60
#define GIC_SMR15_SRCTYPE_BIT 5

#define GIC_SMR16 (*(volatile unsigned long *)0xFFFFF040)
#define GIC_SMR16_OFFSET 0x40
#define GIC_SMR16_PRIOR_MASK 0x7
#define GIC_SMR16_PRIOR_BIT 0
#define GIC_SMR16_SRCTYPE_MASK 0x60
#define GIC_SMR16_SRCTYPE_BIT 5

#define GIC_SMR17 (*(volatile unsigned long *)0xFFFFF044)
#define GIC_SMR17_OFFSET 0x44
#define GIC_SMR17_PRIOR_MASK 0x7
#define GIC_SMR17_PRIOR_BIT 0
#define GIC_SMR17_SRCTYPE_MASK 0x60
#define GIC_SMR17_SRCTYPE_BIT 5

#define GIC_SMR18 (*(volatile unsigned long *)0xFFFFF048)
#define GIC_SMR18_OFFSET 0x48
#define GIC_SMR18_PRIOR_MASK 0x7
#define GIC_SMR18_PRIOR_BIT 0
#define GIC_SMR18_SRCTYPE_MASK 0x60
#define GIC_SMR18_SRCTYPE_BIT 5

#define GIC_SMR19 (*(volatile unsigned long *)0xFFFFF04C)
#define GIC_SMR19_OFFSET 0x4C
#define GIC_SMR19_PRIOR_MASK 0x7
#define GIC_SMR19_PRIOR_BIT 0
#define GIC_SMR19_SRCTYPE_MASK 0x60
#define GIC_SMR19_SRCTYPE_BIT 5

#define GIC_SMR20 (*(volatile unsigned long *)0xFFFFF050)
#define GIC_SMR20_OFFSET 0x50
#define GIC_SMR20_PRIOR_MASK 0x7
#define GIC_SMR20_PRIOR_BIT 0
#define GIC_SMR20_SRCTYPE_MASK 0x60
#define GIC_SMR20_SRCTYPE_BIT 5

#define GIC_SMR21 (*(volatile unsigned long *)0xFFFFF054)
#define GIC_SMR21_OFFSET 0x54
#define GIC_SMR21_PRIOR_MASK 0x7
#define GIC_SMR21_PRIOR_BIT 0
#define GIC_SMR21_SRCTYPE_MASK 0x60
#define GIC_SMR21_SRCTYPE_BIT 5

#define GIC_SMR22 (*(volatile unsigned long *)0xFFFFF058)
#define GIC_SMR22_OFFSET 0x58
#define GIC_SMR22_PRIOR_MASK 0x7
#define GIC_SMR22_PRIOR_BIT 0
#define GIC_SMR22_SRCTYPE_MASK 0x60
#define GIC_SMR22_SRCTYPE_BIT 5

#define GIC_SMR23 (*(volatile unsigned long *)0xFFFFF05C)
#define GIC_SMR23_OFFSET 0x5C
#define GIC_SMR23_PRIOR_MASK 0x7
#define GIC_SMR23_PRIOR_BIT 0
#define GIC_SMR23_SRCTYPE_MASK 0x60
#define GIC_SMR23_SRCTYPE_BIT 5

#define GIC_SMR24 (*(volatile unsigned long *)0xFFFFF060)
#define GIC_SMR24_OFFSET 0x60
#define GIC_SMR24_PRIOR_MASK 0x7
#define GIC_SMR24_PRIOR_BIT 0
#define GIC_SMR24_SRCTYPE_MASK 0x60
#define GIC_SMR24_SRCTYPE_BIT 5

#define GIC_SMR25 (*(volatile unsigned long *)0xFFFFF064)
#define GIC_SMR25_OFFSET 0x64
#define GIC_SMR25_PRIOR_MASK 0x7
#define GIC_SMR25_PRIOR_BIT 0
#define GIC_SMR25_SRCTYPE_MASK 0x60
#define GIC_SMR25_SRCTYPE_BIT 5

#define GIC_SMR26 (*(volatile unsigned long *)0xFFFFF068)
#define GIC_SMR26_OFFSET 0x68
#define GIC_SMR26_PRIOR_MASK 0x7
#define GIC_SMR26_PRIOR_BIT 0
#define GIC_SMR26_SRCTYPE_MASK 0x60
#define GIC_SMR26_SRCTYPE_BIT 5

#define GIC_SMR27 (*(volatile unsigned long *)0xFFFFF06C)
#define GIC_SMR27_OFFSET 0x6C
#define GIC_SMR27_PRIOR_MASK 0x7
#define GIC_SMR27_PRIOR_BIT 0
#define GIC_SMR27_SRCTYPE_MASK 0x60
#define GIC_SMR27_SRCTYPE_BIT 5

#define GIC_SMR28 (*(volatile unsigned long *)0xFFFFF070)
#define GIC_SMR28_OFFSET 0x70
#define GIC_SMR28_PRIOR_MASK 0x7
#define GIC_SMR28_PRIOR_BIT 0
#define GIC_SMR28_SRCTYPE_MASK 0x60
#define GIC_SMR28_SRCTYPE_BIT 5

#define GIC_SMR29 (*(volatile unsigned long *)0xFFFFF074)
#define GIC_SMR29_OFFSET 0x74
#define GIC_SMR29_PRIOR_MASK 0x7
#define GIC_SMR29_PRIOR_BIT 0
#define GIC_SMR29_SRCTYPE_MASK 0x60
#define GIC_SMR29_SRCTYPE_BIT 5

#define GIC_SMR30 (*(volatile unsigned long *)0xFFFFF078)
#define GIC_SMR30_OFFSET 0x78
#define GIC_SMR30_PRIOR_MASK 0x7
#define GIC_SMR30_PRIOR_BIT 0
#define GIC_SMR30_SRCTYPE_MASK 0x60
#define GIC_SMR30_SRCTYPE_BIT 5

#define GIC_SMR31 (*(volatile unsigned long *)0xFFFFF07C)
#define GIC_SMR31_OFFSET 0x7C
#define GIC_SMR31_PRIOR_MASK 0x7
#define GIC_SMR31_PRIOR_BIT 0
#define GIC_SMR31_SRCTYPE_MASK 0x60
#define GIC_SMR31_SRCTYPE_BIT 5

#define GIC_SVR0 (*(volatile unsigned long *)0xFFFFF080)
#define GIC_SVR0_OFFSET 0x80

#define GIC_SVR1 (*(volatile unsigned long *)0xFFFFF084)
#define GIC_SVR1_OFFSET 0x84

#define GIC_SVR2 (*(volatile unsigned long *)0xFFFFF088)
#define GIC_SVR2_OFFSET 0x88

#define GIC_SVR3 (*(volatile unsigned long *)0xFFFFF08C)
#define GIC_SVR3_OFFSET 0x8C

#define GIC_SVR4 (*(volatile unsigned long *)0xFFFFF090)
#define GIC_SVR4_OFFSET 0x90

#define GIC_SVR5 (*(volatile unsigned long *)0xFFFFF094)
#define GIC_SVR5_OFFSET 0x94

#define GIC_SVR6 (*(volatile unsigned long *)0xFFFFF098)
#define GIC_SVR6_OFFSET 0x98

#define GIC_SVR7 (*(volatile unsigned long *)0xFFFFF09C)
#define GIC_SVR7_OFFSET 0x9C

#define GIC_SVR8 (*(volatile unsigned long *)0xFFFFF0A0)
#define GIC_SVR8_OFFSET 0xA0

#define GIC_SVR9 (*(volatile unsigned long *)0xFFFFF0A4)
#define GIC_SVR9_OFFSET 0xA4

#define GIC_SVR10 (*(volatile unsigned long *)0xFFFFF0A8)
#define GIC_SVR10_OFFSET 0xA8

#define GIC_SVR11 (*(volatile unsigned long *)0xFFFFF0AC)
#define GIC_SVR11_OFFSET 0xAC

#define GIC_SVR12 (*(volatile unsigned long *)0xFFFFF0B0)
#define GIC_SVR12_OFFSET 0xB0

#define GIC_SVR13 (*(volatile unsigned long *)0xFFFFF0B4)
#define GIC_SVR13_OFFSET 0xB4

#define GIC_SVR14 (*(volatile unsigned long *)0xFFFFF0B8)
#define GIC_SVR14_OFFSET 0xB8

#define GIC_SVR15 (*(volatile unsigned long *)0xFFFFF0BC)
#define GIC_SVR15_OFFSET 0xBC

#define GIC_SVR16 (*(volatile unsigned long *)0xFFFFF0C0)
#define GIC_SVR16_OFFSET 0xC0

#define GIC_SVR17 (*(volatile unsigned long *)0xFFFFF0C4)
#define GIC_SVR17_OFFSET 0xC4

#define GIC_SVR18 (*(volatile unsigned long *)0xFFFFF0C8)
#define GIC_SVR18_OFFSET 0xC8

#define GIC_SVR19 (*(volatile unsigned long *)0xFFFFF0CC)
#define GIC_SVR19_OFFSET 0xCC

#define GIC_SVR20 (*(volatile unsigned long *)0xFFFFF0D0)
#define GIC_SVR20_OFFSET 0xD0

#define GIC_SVR21 (*(volatile unsigned long *)0xFFFFF0D4)
#define GIC_SVR21_OFFSET 0xD4

#define GIC_SVR22 (*(volatile unsigned long *)0xFFFFF0D8)
#define GIC_SVR22_OFFSET 0xD8

#define GIC_SVR23 (*(volatile unsigned long *)0xFFFFF0DC)
#define GIC_SVR23_OFFSET 0xDC

#define GIC_SVR24 (*(volatile unsigned long *)0xFFFFF0E0)
#define GIC_SVR24_OFFSET 0xE0

#define GIC_SVR25 (*(volatile unsigned long *)0xFFFFF0E4)
#define GIC_SVR25_OFFSET 0xE4

#define GIC_SVR26 (*(volatile unsigned long *)0xFFFFF0E8)
#define GIC_SVR26_OFFSET 0xE8

#define GIC_SVR27 (*(volatile unsigned long *)0xFFFFF0EC)
#define GIC_SVR27_OFFSET 0xEC

#define GIC_SVR28 (*(volatile unsigned long *)0xFFFFF0F0)
#define GIC_SVR28_OFFSET 0xF0

#define GIC_SVR29 (*(volatile unsigned long *)0xFFFFF0F4)
#define GIC_SVR29_OFFSET 0xF4

#define GIC_SVR30 (*(volatile unsigned long *)0xFFFFF0F8)
#define GIC_SVR30_OFFSET 0xF8

#define GIC_SVR31 (*(volatile unsigned long *)0xFFFFF0FC)
#define GIC_SVR31_OFFSET 0xFC

#define GIC_IVR (*(volatile unsigned long *)0xFFFFF100)
#define GIC_IVR_OFFSET 0x100

#define GIC_FVR (*(volatile unsigned long *)0xFFFFF104)
#define GIC_FVR_OFFSET 0x104

#define GIC_ISR (*(volatile unsigned long *)0xFFFFF108)
#define GIC_ISR_OFFSET 0x108
#define GIC_ISR_IRQID_MASK 0x1F
#define GIC_ISR_IRQID_BIT 0

#define GIC_IPR (*(volatile unsigned long *)0xFFFFF10C)
#define GIC_IPR_OFFSET 0x10C
#define GIC_IPR_FIQ_MASK 0x1
#define GIC_IPR_FIQ 0x1
#define GIC_IPR_FIQ_BIT 0
#define GIC_IPR_SWIRQ0_MASK 0x2
#define GIC_IPR_SWIRQ0 0x2
#define GIC_IPR_SWIRQ0_BIT 1
#define GIC_IPR_WD_MASK 0x4
#define GIC_IPR_WD 0x4
#define GIC_IPR_WD_BIT 2
#define GIC_IPR_WT_MASK 0x8
#define GIC_IPR_WT 0x8
#define GIC_IPR_WT_BIT 3
#define GIC_IPR_USART0_MASK 0x10
#define GIC_IPR_USART0 0x10
#define GIC_IPR_USART0_BIT 4
#define GIC_IPR_USART1_MASK 0x20
#define GIC_IPR_USART1 0x20
#define GIC_IPR_USART1_BIT 5
#define GIC_IPR_USART2_MASK 0x40
#define GIC_IPR_USART2 0x40
#define GIC_IPR_USART2_BIT 6
#define GIC_IPR_SPI_MASK 0x80
#define GIC_IPR_SPI 0x80
#define GIC_IPR_SPI_BIT 7
#define GIC_IPR_SWIRQ1_MASK 0x100
#define GIC_IPR_SWIRQ1 0x100
#define GIC_IPR_SWIRQ1_BIT 8
#define GIC_IPR_SWIRQ2_MASK 0x200
#define GIC_IPR_SWIRQ2 0x200
#define GIC_IPR_SWIRQ2_BIT 9
#define GIC_IPR_ADC0_MASK 0x400
#define GIC_IPR_ADC0 0x400
#define GIC_IPR_ADC0_BIT 10
#define GIC_IPR_SWIRQ3_MASK 0x800
#define GIC_IPR_SWIRQ3 0x800
#define GIC_IPR_SWIRQ3_BIT 11
#define GIC_IPR_GPT0CH0_MASK 0x1000
#define GIC_IPR_GPT0CH0 0x1000
#define GIC_IPR_GPT0CH0_BIT 12
#define GIC_IPR_GPT0CH1_MASK 0x2000
#define GIC_IPR_GPT0CH1 0x2000
#define GIC_IPR_GPT0CH1_BIT 13
#define GIC_IPR_GPT0CH2_MASK 0x4000
#define GIC_IPR_GPT0CH2 0x4000
#define GIC_IPR_GPT0CH2_BIT 14
#define GIC_IPR_SWIRQ4_MASK 0x8000
#define GIC_IPR_SWIRQ4 0x8000
#define GIC_IPR_SWIRQ4_BIT 15
#define GIC_IPR_PWM_MASK 0x10000
#define GIC_IPR_PWM 0x10000
#define GIC_IPR_PWM_BIT 16
#define GIC_IPR_SWIRQ5_MASK 0x20000
#define GIC_IPR_SWIRQ5 0x20000
#define GIC_IPR_SWIRQ5_BIT 17
#define GIC_IPR_SWIRQ6_MASK 0x40000
#define GIC_IPR_SWIRQ6 0x40000
#define GIC_IPR_SWIRQ6_BIT 18
#define GIC_IPR_SWIRQ7_MASK 0x80000
#define GIC_IPR_SWIRQ7 0x80000
#define GIC_IPR_SWIRQ7_BIT 19
#define GIC_IPR_CAN_MASK 0x100000
#define GIC_IPR_CAN 0x100000
#define GIC_IPR_CAN_BIT 20
#define GIC_IPR_UPIO_MASK 0x200000
#define GIC_IPR_UPIO 0x200000
#define GIC_IPR_UPIO_BIT 21
#define GIC_IPR_CAPT0_MASK 0x400000
#define GIC_IPR_CAPT0 0x400000
#define GIC_IPR_CAPT0_BIT 22
#define GIC_IPR_CAPT1_MASK 0x800000
#define GIC_IPR_CAPT1 0x800000
#define GIC_IPR_CAPT1_BIT 23
#define GIC_IPR_ST0_MASK 0x1000000
#define GIC_IPR_ST0 0x1000000
#define GIC_IPR_ST0_BIT 24
#define GIC_IPR_ST1_MASK 0x2000000
#define GIC_IPR_ST1 0x2000000
#define GIC_IPR_ST1_BIT 25
#define GIC_IPR_SWIRQ8_MASK 0x4000000
#define GIC_IPR_SWIRQ8 0x4000000
#define GIC_IPR_SWIRQ8_BIT 26
#define GIC_IPR_SWIRQ9_MASK 0x8000000
#define GIC_IPR_SWIRQ9 0x8000000
#define GIC_IPR_SWIRQ9_BIT 27
#define GIC_IPR_IRQ0_MASK 0x10000000
#define GIC_IPR_IRQ0 0x10000000
#define GIC_IPR_IRQ0_BIT 28
#define GIC_IPR_SWIRQ10_MASK 0x20000000
#define GIC_IPR_SWIRQ10 0x20000000
#define GIC_IPR_SWIRQ10_BIT 29
#define GIC_IPR_SWIRQ11_MASK 0x40000000
#define GIC_IPR_SWIRQ11 0x40000000
#define GIC_IPR_SWIRQ11_BIT 30
#define GIC_IPR_SWIRQ12_MASK 0x80000000
#define GIC_IPR_SWIRQ12 0x80000000
#define GIC_IPR_SWIRQ12_BIT 31

#define GIC_IMR (*(volatile unsigned long *)0xFFFFF110)
#define GIC_IMR_OFFSET 0x110
#define GIC_IMR_FIQ_MASK 0x1
#define GIC_IMR_FIQ 0x1
#define GIC_IMR_FIQ_BIT 0
#define GIC_IMR_SWIRQ0_MASK 0x2
#define GIC_IMR_SWIRQ0 0x2
#define GIC_IMR_SWIRQ0_BIT 1
#define GIC_IMR_WD_MASK 0x4
#define GIC_IMR_WD 0x4
#define GIC_IMR_WD_BIT 2
#define GIC_IMR_WT_MASK 0x8
#define GIC_IMR_WT 0x8
#define GIC_IMR_WT_BIT 3
#define GIC_IMR_USART0_MASK 0x10
#define GIC_IMR_USART0 0x10
#define GIC_IMR_USART0_BIT 4
#define GIC_IMR_USART1_MASK 0x20
#define GIC_IMR_USART1 0x20
#define GIC_IMR_USART1_BIT 5
#define GIC_IMR_USART2_MASK 0x40
#define GIC_IMR_USART2 0x40
#define GIC_IMR_USART2_BIT 6
#define GIC_IMR_SPI_MASK 0x80
#define GIC_IMR_SPI 0x80
#define GIC_IMR_SPI_BIT 7
#define GIC_IMR_SWIRQ1_MASK 0x100
#define GIC_IMR_SWIRQ1 0x100
#define GIC_IMR_SWIRQ1_BIT 8
#define GIC_IMR_SWIRQ2_MASK 0x200
#define GIC_IMR_SWIRQ2 0x200
#define GIC_IMR_SWIRQ2_BIT 9
#define GIC_IMR_ADC0_MASK 0x400
#define GIC_IMR_ADC0 0x400
#define GIC_IMR_ADC0_BIT 10
#define GIC_IMR_SWIRQ3_MASK 0x800
#define GIC_IMR_SWIRQ3 0x800
#define GIC_IMR_SWIRQ3_BIT 11
#define GIC_IMR_GPT0CH0_MASK 0x1000
#define GIC_IMR_GPT0CH0 0x1000
#define GIC_IMR_GPT0CH0_BIT 12
#define GIC_IMR_GPT0CH1_MASK 0x2000
#define GIC_IMR_GPT0CH1 0x2000
#define GIC_IMR_GPT0CH1_BIT 13
#define GIC_IMR_GPT0CH2_MASK 0x4000
#define GIC_IMR_GPT0CH2 0x4000
#define GIC_IMR_GPT0CH2_BIT 14
#define GIC_IMR_SWIRQ4_MASK 0x8000
#define GIC_IMR_SWIRQ4 0x8000
#define GIC_IMR_SWIRQ4_BIT 15
#define GIC_IMR_PWM_MASK 0x10000
#define GIC_IMR_PWM 0x10000
#define GIC_IMR_PWM_BIT 16
#define GIC_IMR_SWIRQ5_MASK 0x20000
#define GIC_IMR_SWIRQ5 0x20000
#define GIC_IMR_SWIRQ5_BIT 17
#define GIC_IMR_SWIRQ6_MASK 0x40000
#define GIC_IMR_SWIRQ6 0x40000
#define GIC_IMR_SWIRQ6_BIT 18
#define GIC_IMR_SWIRQ7_MASK 0x80000
#define GIC_IMR_SWIRQ7 0x80000
#define GIC_IMR_SWIRQ7_BIT 19
#define GIC_IMR_CAN_MASK 0x100000
#define GIC_IMR_CAN 0x100000
#define GIC_IMR_CAN_BIT 20
#define GIC_IMR_UPIO_MASK 0x200000
#define GIC_IMR_UPIO 0x200000
#define GIC_IMR_UPIO_BIT 21
#define GIC_IMR_CAPT0_MASK 0x400000
#define GIC_IMR_CAPT0 0x400000
#define GIC_IMR_CAPT0_BIT 22
#define GIC_IMR_CAPT1_MASK 0x800000
#define GIC_IMR_CAPT1 0x800000
#define GIC_IMR_CAPT1_BIT 23
#define GIC_IMR_ST0_MASK 0x1000000
#define GIC_IMR_ST0 0x1000000
#define GIC_IMR_ST0_BIT 24
#define GIC_IMR_ST1_MASK 0x2000000
#define GIC_IMR_ST1 0x2000000
#define GIC_IMR_ST1_BIT 25
#define GIC_IMR_SWIRQ8_MASK 0x4000000
#define GIC_IMR_SWIRQ8 0x4000000
#define GIC_IMR_SWIRQ8_BIT 26
#define GIC_IMR_SWIRQ9_MASK 0x8000000
#define GIC_IMR_SWIRQ9 0x8000000
#define GIC_IMR_SWIRQ9_BIT 27
#define GIC_IMR_IRQ0_MASK 0x10000000
#define GIC_IMR_IRQ0 0x10000000
#define GIC_IMR_IRQ0_BIT 28
#define GIC_IMR_SWIRQ10_MASK 0x20000000
#define GIC_IMR_SWIRQ10 0x20000000
#define GIC_IMR_SWIRQ10_BIT 29
#define GIC_IMR_SWIRQ11_MASK 0x40000000
#define GIC_IMR_SWIRQ11 0x40000000
#define GIC_IMR_SWIRQ11_BIT 30
#define GIC_IMR_SWIRQ12_MASK 0x80000000
#define GIC_IMR_SWIRQ12 0x80000000
#define GIC_IMR_SWIRQ12_BIT 31

#define GIC_CISR (*(volatile unsigned long *)0xFFFFF114)
#define GIC_CISR_OFFSET 0x114
#define GIC_CISR_NFIQ_MASK 0x1
#define GIC_CISR_NFIQ 0x1
#define GIC_CISR_NFIQ_BIT 0
#define GIC_CISR_NIRQ_MASK 0x2
#define GIC_CISR_NIRQ 0x2
#define GIC_CISR_NIRQ_BIT 1

#define GIC_IECR (*(volatile unsigned long *)0xFFFFF120)
#define GIC_IECR_OFFSET 0x120
#define GIC_IECR_FIQ_MASK 0x1
#define GIC_IECR_FIQ 0x1
#define GIC_IECR_FIQ_BIT 0
#define GIC_IECR_SWIRQ0_MASK 0x2
#define GIC_IECR_SWIRQ0 0x2
#define GIC_IECR_SWIRQ0_BIT 1
#define GIC_IECR_WD_MASK 0x4
#define GIC_IECR_WD 0x4
#define GIC_IECR_WD_BIT 2
#define GIC_IECR_WT_MASK 0x8
#define GIC_IECR_WT 0x8
#define GIC_IECR_WT_BIT 3
#define GIC_IECR_USART0_MASK 0x10
#define GIC_IECR_USART0 0x10
#define GIC_IECR_USART0_BIT 4
#define GIC_IECR_USART1_MASK 0x20
#define GIC_IECR_USART1 0x20
#define GIC_IECR_USART1_BIT 5
#define GIC_IECR_USART2_MASK 0x40
#define GIC_IECR_USART2 0x40
#define GIC_IECR_USART2_BIT 6
#define GIC_IECR_SPI_MASK 0x80
#define GIC_IECR_SPI 0x80
#define GIC_IECR_SPI_BIT 7
#define GIC_IECR_SWIRQ1_MASK 0x100
#define GIC_IECR_SWIRQ1 0x100
#define GIC_IECR_SWIRQ1_BIT 8
#define GIC_IECR_SWIRQ2_MASK 0x200
#define GIC_IECR_SWIRQ2 0x200
#define GIC_IECR_SWIRQ2_BIT 9
#define GIC_IECR_ADC0_MASK 0x400
#define GIC_IECR_ADC0 0x400
#define GIC_IECR_ADC0_BIT 10
#define GIC_IECR_SWIRQ3_MASK 0x800
#define GIC_IECR_SWIRQ3 0x800
#define GIC_IECR_SWIRQ3_BIT 11
#define GIC_IECR_GPT0CH0_MASK 0x1000
#define GIC_IECR_GPT0CH0 0x1000
#define GIC_IECR_GPT0CH0_BIT 12
#define GIC_IECR_GPT0CH1_MASK 0x2000
#define GIC_IECR_GPT0CH1 0x2000
#define GIC_IECR_GPT0CH1_BIT 13
#define GIC_IECR_GPT0CH2_MASK 0x4000
#define GIC_IECR_GPT0CH2 0x4000
#define GIC_IECR_GPT0CH2_BIT 14
#define GIC_IECR_SWIRQ4_MASK 0x8000
#define GIC_IECR_SWIRQ4 0x8000
#define GIC_IECR_SWIRQ4_BIT 15
#define GIC_IECR_PWM_MASK 0x10000
#define GIC_IECR_PWM 0x10000
#define GIC_IECR_PWM_BIT 16
#define GIC_IECR_SWIRQ5_MASK 0x20000
#define GIC_IECR_SWIRQ5 0x20000
#define GIC_IECR_SWIRQ5_BIT 17
#define GIC_IECR_SWIRQ6_MASK 0x40000
#define GIC_IECR_SWIRQ6 0x40000
#define GIC_IECR_SWIRQ6_BIT 18
#define GIC_IECR_SWIRQ7_MASK 0x80000
#define GIC_IECR_SWIRQ7 0x80000
#define GIC_IECR_SWIRQ7_BIT 19
#define GIC_IECR_CAN_MASK 0x100000
#define GIC_IECR_CAN 0x100000
#define GIC_IECR_CAN_BIT 20
#define GIC_IECR_UPIO_MASK 0x200000
#define GIC_IECR_UPIO 0x200000
#define GIC_IECR_UPIO_BIT 21
#define GIC_IECR_CAPT0_MASK 0x400000
#define GIC_IECR_CAPT0 0x400000
#define GIC_IECR_CAPT0_BIT 22
#define GIC_IECR_CAPT1_MASK 0x800000
#define GIC_IECR_CAPT1 0x800000
#define GIC_IECR_CAPT1_BIT 23
#define GIC_IECR_ST0_MASK 0x1000000
#define GIC_IECR_ST0 0x1000000
#define GIC_IECR_ST0_BIT 24
#define GIC_IECR_ST1_MASK 0x2000000
#define GIC_IECR_ST1 0x2000000
#define GIC_IECR_ST1_BIT 25
#define GIC_IECR_SWIRQ8_MASK 0x4000000
#define GIC_IECR_SWIRQ8 0x4000000
#define GIC_IECR_SWIRQ8_BIT 26
#define GIC_IECR_SWIRQ9_MASK 0x8000000
#define GIC_IECR_SWIRQ9 0x8000000
#define GIC_IECR_SWIRQ9_BIT 27
#define GIC_IECR_IRQ0_MASK 0x10000000
#define GIC_IECR_IRQ0 0x10000000
#define GIC_IECR_IRQ0_BIT 28
#define GIC_IECR_SWIRQ10_MASK 0x20000000
#define GIC_IECR_SWIRQ10 0x20000000
#define GIC_IECR_SWIRQ10_BIT 29
#define GIC_IECR_SWIRQ11_MASK 0x40000000
#define GIC_IECR_SWIRQ11 0x40000000
#define GIC_IECR_SWIRQ11_BIT 30
#define GIC_IECR_SWIRQ12_MASK 0x80000000
#define GIC_IECR_SWIRQ12 0x80000000
#define GIC_IECR_SWIRQ12_BIT 31

#define GIC_IDCR (*(volatile unsigned long *)0xFFFFF124)
#define GIC_IDCR_OFFSET 0x124
#define GIC_IDCR_FIQ_MASK 0x1
#define GIC_IDCR_FIQ 0x1
#define GIC_IDCR_FIQ_BIT 0
#define GIC_IDCR_SWIRQ0_MASK 0x2
#define GIC_IDCR_SWIRQ0 0x2
#define GIC_IDCR_SWIRQ0_BIT 1
#define GIC_IDCR_WD_MASK 0x4
#define GIC_IDCR_WD 0x4
#define GIC_IDCR_WD_BIT 2
#define GIC_IDCR_WT_MASK 0x8
#define GIC_IDCR_WT 0x8
#define GIC_IDCR_WT_BIT 3
#define GIC_IDCR_USART0_MASK 0x10
#define GIC_IDCR_USART0 0x10
#define GIC_IDCR_USART0_BIT 4
#define GIC_IDCR_USART1_MASK 0x20
#define GIC_IDCR_USART1 0x20
#define GIC_IDCR_USART1_BIT 5
#define GIC_IDCR_USART2_MASK 0x40
#define GIC_IDCR_USART2 0x40
#define GIC_IDCR_USART2_BIT 6
#define GIC_IDCR_SPI_MASK 0x80
#define GIC_IDCR_SPI 0x80
#define GIC_IDCR_SPI_BIT 7
#define GIC_IDCR_SWIRQ1_MASK 0x100
#define GIC_IDCR_SWIRQ1 0x100
#define GIC_IDCR_SWIRQ1_BIT 8
#define GIC_IDCR_SWIRQ2_MASK 0x200
#define GIC_IDCR_SWIRQ2 0x200
#define GIC_IDCR_SWIRQ2_BIT 9
#define GIC_IDCR_ADC0_MASK 0x400
#define GIC_IDCR_ADC0 0x400
#define GIC_IDCR_ADC0_BIT 10
#define GIC_IDCR_SWIRQ3_MASK 0x800
#define GIC_IDCR_SWIRQ3 0x800
#define GIC_IDCR_SWIRQ3_BIT 11
#define GIC_IDCR_GPT0CH0_MASK 0x1000
#define GIC_IDCR_GPT0CH0 0x1000
#define GIC_IDCR_GPT0CH0_BIT 12
#define GIC_IDCR_GPT0CH1_MASK 0x2000
#define GIC_IDCR_GPT0CH1 0x2000
#define GIC_IDCR_GPT0CH1_BIT 13
#define GIC_IDCR_GPT0CH2_MASK 0x4000
#define GIC_IDCR_GPT0CH2 0x4000
#define GIC_IDCR_GPT0CH2_BIT 14
#define GIC_IDCR_SWIRQ4_MASK 0x8000
#define GIC_IDCR_SWIRQ4 0x8000
#define GIC_IDCR_SWIRQ4_BIT 15
#define GIC_IDCR_PWM_MASK 0x10000
#define GIC_IDCR_PWM 0x10000
#define GIC_IDCR_PWM_BIT 16
#define GIC_IDCR_SWIRQ5_MASK 0x20000
#define GIC_IDCR_SWIRQ5 0x20000
#define GIC_IDCR_SWIRQ5_BIT 17
#define GIC_IDCR_SWIRQ6_MASK 0x40000
#define GIC_IDCR_SWIRQ6 0x40000
#define GIC_IDCR_SWIRQ6_BIT 18
#define GIC_IDCR_SWIRQ7_MASK 0x80000
#define GIC_IDCR_SWIRQ7 0x80000
#define GIC_IDCR_SWIRQ7_BIT 19
#define GIC_IDCR_CAN_MASK 0x100000
#define GIC_IDCR_CAN 0x100000
#define GIC_IDCR_CAN_BIT 20
#define GIC_IDCR_UPIO_MASK 0x200000
#define GIC_IDCR_UPIO 0x200000
#define GIC_IDCR_UPIO_BIT 21
#define GIC_IDCR_CAPT0_MASK 0x400000
#define GIC_IDCR_CAPT0 0x400000
#define GIC_IDCR_CAPT0_BIT 22
#define GIC_IDCR_CAPT1_MASK 0x800000
#define GIC_IDCR_CAPT1 0x800000
#define GIC_IDCR_CAPT1_BIT 23
#define GIC_IDCR_ST0_MASK 0x1000000
#define GIC_IDCR_ST0 0x1000000
#define GIC_IDCR_ST0_BIT 24
#define GIC_IDCR_ST1_MASK 0x2000000
#define GIC_IDCR_ST1 0x2000000
#define GIC_IDCR_ST1_BIT 25
#define GIC_IDCR_SWIRQ8_MASK 0x4000000
#define GIC_IDCR_SWIRQ8 0x4000000
#define GIC_IDCR_SWIRQ8_BIT 26
#define GIC_IDCR_SWIRQ9_MASK 0x8000000
#define GIC_IDCR_SWIRQ9 0x8000000
#define GIC_IDCR_SWIRQ9_BIT 27
#define GIC_IDCR_IRQ0_MASK 0x10000000
#define GIC_IDCR_IRQ0 0x10000000
#define GIC_IDCR_IRQ0_BIT 28
#define GIC_IDCR_SWIRQ10_MASK 0x20000000
#define GIC_IDCR_SWIRQ10 0x20000000
#define GIC_IDCR_SWIRQ10_BIT 29
#define GIC_IDCR_SWIRQ11_MASK 0x40000000
#define GIC_IDCR_SWIRQ11 0x40000000
#define GIC_IDCR_SWIRQ11_BIT 30
#define GIC_IDCR_SWIRQ12_MASK 0x80000000
#define GIC_IDCR_SWIRQ12 0x80000000
#define GIC_IDCR_SWIRQ12_BIT 31

#define GIC_ICCR (*(volatile unsigned long *)0xFFFFF128)
#define GIC_ICCR_OFFSET 0x128
#define GIC_ICCR_FIQ_MASK 0x1
#define GIC_ICCR_FIQ 0x1
#define GIC_ICCR_FIQ_BIT 0
#define GIC_ICCR_SWIRQ0_MASK 0x2
#define GIC_ICCR_SWIRQ0 0x2
#define GIC_ICCR_SWIRQ0_BIT 1
#define GIC_ICCR_WD_MASK 0x4
#define GIC_ICCR_WD 0x4
#define GIC_ICCR_WD_BIT 2
#define GIC_ICCR_WT_MASK 0x8
#define GIC_ICCR_WT 0x8
#define GIC_ICCR_WT_BIT 3
#define GIC_ICCR_USART0_MASK 0x10
#define GIC_ICCR_USART0 0x10
#define GIC_ICCR_USART0_BIT 4
#define GIC_ICCR_USART1_MASK 0x20
#define GIC_ICCR_USART1 0x20
#define GIC_ICCR_USART1_BIT 5
#define GIC_ICCR_USART2_MASK 0x40
#define GIC_ICCR_USART2 0x40
#define GIC_ICCR_USART2_BIT 6
#define GIC_ICCR_SPI_MASK 0x80
#define GIC_ICCR_SPI 0x80
#define GIC_ICCR_SPI_BIT 7
#define GIC_ICCR_SWIRQ1_MASK 0x100
#define GIC_ICCR_SWIRQ1 0x100
#define GIC_ICCR_SWIRQ1_BIT 8
#define GIC_ICCR_SWIRQ2_MASK 0x200
#define GIC_ICCR_SWIRQ2 0x200
#define GIC_ICCR_SWIRQ2_BIT 9
#define GIC_ICCR_ADC0_MASK 0x400
#define GIC_ICCR_ADC0 0x400
#define GIC_ICCR_ADC0_BIT 10
#define GIC_ICCR_SWIRQ3_MASK 0x800
#define GIC_ICCR_SWIRQ3 0x800
#define GIC_ICCR_SWIRQ3_BIT 11
#define GIC_ICCR_GPT0CH0_MASK 0x1000
#define GIC_ICCR_GPT0CH0 0x1000
#define GIC_ICCR_GPT0CH0_BIT 12
#define GIC_ICCR_GPT0CH1_MASK 0x2000
#define GIC_ICCR_GPT0CH1 0x2000
#define GIC_ICCR_GPT0CH1_BIT 13
#define GIC_ICCR_GPT0CH2_MASK 0x4000
#define GIC_ICCR_GPT0CH2 0x4000
#define GIC_ICCR_GPT0CH2_BIT 14
#define GIC_ICCR_SWIRQ4_MASK 0x8000
#define GIC_ICCR_SWIRQ4 0x8000
#define GIC_ICCR_SWIRQ4_BIT 15
#define GIC_ICCR_PWM_MASK 0x10000
#define GIC_ICCR_PWM 0x10000
#define GIC_ICCR_PWM_BIT 16
#define GIC_ICCR_SWIRQ5_MASK 0x20000
#define GIC_ICCR_SWIRQ5 0x20000
#define GIC_ICCR_SWIRQ5_BIT 17
#define GIC_ICCR_SWIRQ6_MASK 0x40000
#define GIC_ICCR_SWIRQ6 0x40000
#define GIC_ICCR_SWIRQ6_BIT 18
#define GIC_ICCR_SWIRQ7_MASK 0x80000
#define GIC_ICCR_SWIRQ7 0x80000
#define GIC_ICCR_SWIRQ7_BIT 19
#define GIC_ICCR_CAN_MASK 0x100000
#define GIC_ICCR_CAN 0x100000
#define GIC_ICCR_CAN_BIT 20
#define GIC_ICCR_UPIO_MASK 0x200000
#define GIC_ICCR_UPIO 0x200000
#define GIC_ICCR_UPIO_BIT 21
#define GIC_ICCR_CAPT0_MASK 0x400000
#define GIC_ICCR_CAPT0 0x400000
#define GIC_ICCR_CAPT0_BIT 22
#define GIC_ICCR_CAPT1_MASK 0x800000
#define GIC_ICCR_CAPT1 0x800000
#define GIC_ICCR_CAPT1_BIT 23
#define GIC_ICCR_ST0_MASK 0x1000000
#define GIC_ICCR_ST0 0x1000000
#define GIC_ICCR_ST0_BIT 24
#define GIC_ICCR_ST1_MASK 0x2000000
#define GIC_ICCR_ST1 0x2000000
#define GIC_ICCR_ST1_BIT 25
#define GIC_ICCR_SWIRQ8_MASK 0x4000000
#define GIC_ICCR_SWIRQ8 0x4000000
#define GIC_ICCR_SWIRQ8_BIT 26
#define GIC_ICCR_SWIRQ9_MASK 0x8000000
#define GIC_ICCR_SWIRQ9 0x8000000
#define GIC_ICCR_SWIRQ9_BIT 27
#define GIC_ICCR_IRQ0_MASK 0x10000000
#define GIC_ICCR_IRQ0 0x10000000
#define GIC_ICCR_IRQ0_BIT 28
#define GIC_ICCR_SWIRQ10_MASK 0x20000000
#define GIC_ICCR_SWIRQ10 0x20000000
#define GIC_ICCR_SWIRQ10_BIT 29
#define GIC_ICCR_SWIRQ11_MASK 0x40000000
#define GIC_ICCR_SWIRQ11 0x40000000
#define GIC_ICCR_SWIRQ11_BIT 30
#define GIC_ICCR_SWIRQ12_MASK 0x80000000
#define GIC_ICCR_SWIRQ12 0x80000000
#define GIC_ICCR_SWIRQ12_BIT 31

#define GIC_ISCR (*(volatile unsigned long *)0xFFFFF12C)
#define GIC_ISCR_OFFSET 0x12C
#define GIC_ISCR_FIQ_MASK 0x1
#define GIC_ISCR_FIQ 0x1
#define GIC_ISCR_FIQ_BIT 0
#define GIC_ISCR_SWIRQ0_MASK 0x2
#define GIC_ISCR_SWIRQ0 0x2
#define GIC_ISCR_SWIRQ0_BIT 1
#define GIC_ISCR_WD_MASK 0x4
#define GIC_ISCR_WD 0x4
#define GIC_ISCR_WD_BIT 2
#define GIC_ISCR_WT_MASK 0x8
#define GIC_ISCR_WT 0x8
#define GIC_ISCR_WT_BIT 3
#define GIC_ISCR_USART0_MASK 0x10
#define GIC_ISCR_USART0 0x10
#define GIC_ISCR_USART0_BIT 4
#define GIC_ISCR_USART1_MASK 0x20
#define GIC_ISCR_USART1 0x20
#define GIC_ISCR_USART1_BIT 5
#define GIC_ISCR_USART2_MASK 0x40
#define GIC_ISCR_USART2 0x40
#define GIC_ISCR_USART2_BIT 6
#define GIC_ISCR_SPI_MASK 0x80
#define GIC_ISCR_SPI 0x80
#define GIC_ISCR_SPI_BIT 7
#define GIC_ISCR_SWIRQ1_MASK 0x100
#define GIC_ISCR_SWIRQ1 0x100
#define GIC_ISCR_SWIRQ1_BIT 8
#define GIC_ISCR_SWIRQ2_MASK 0x200
#define GIC_ISCR_SWIRQ2 0x200
#define GIC_ISCR_SWIRQ2_BIT 9
#define GIC_ISCR_ADC0_MASK 0x400
#define GIC_ISCR_ADC0 0x400
#define GIC_ISCR_ADC0_BIT 10
#define GIC_ISCR_SWIRQ3_MASK 0x800
#define GIC_ISCR_SWIRQ3 0x800
#define GIC_ISCR_SWIRQ3_BIT 11
#define GIC_ISCR_GPT0CH0_MASK 0x1000
#define GIC_ISCR_GPT0CH0 0x1000
#define GIC_ISCR_GPT0CH0_BIT 12
#define GIC_ISCR_GPT0CH1_MASK 0x2000
#define GIC_ISCR_GPT0CH1 0x2000
#define GIC_ISCR_GPT0CH1_BIT 13
#define GIC_ISCR_GPT0CH2_MASK 0x4000
#define GIC_ISCR_GPT0CH2 0x4000
#define GIC_ISCR_GPT0CH2_BIT 14
#define GIC_ISCR_SWIRQ4_MASK 0x8000
#define GIC_ISCR_SWIRQ4 0x8000
#define GIC_ISCR_SWIRQ4_BIT 15
#define GIC_ISCR_PWM_MASK 0x10000
#define GIC_ISCR_PWM 0x10000
#define GIC_ISCR_PWM_BIT 16
#define GIC_ISCR_SWIRQ5_MASK 0x20000
#define GIC_ISCR_SWIRQ5 0x20000
#define GIC_ISCR_SWIRQ5_BIT 17
#define GIC_ISCR_SWIRQ6_MASK 0x40000
#define GIC_ISCR_SWIRQ6 0x40000
#define GIC_ISCR_SWIRQ6_BIT 18
#define GIC_ISCR_SWIRQ7_MASK 0x80000
#define GIC_ISCR_SWIRQ7 0x80000
#define GIC_ISCR_SWIRQ7_BIT 19
#define GIC_ISCR_CAN_MASK 0x100000
#define GIC_ISCR_CAN 0x100000
#define GIC_ISCR_CAN_BIT 20
#define GIC_ISCR_UPIO_MASK 0x200000
#define GIC_ISCR_UPIO 0x200000
#define GIC_ISCR_UPIO_BIT 21
#define GIC_ISCR_CAPT0_MASK 0x400000
#define GIC_ISCR_CAPT0 0x400000
#define GIC_ISCR_CAPT0_BIT 22
#define GIC_ISCR_CAPT1_MASK 0x800000
#define GIC_ISCR_CAPT1 0x800000
#define GIC_ISCR_CAPT1_BIT 23
#define GIC_ISCR_ST0_MASK 0x1000000
#define GIC_ISCR_ST0 0x1000000
#define GIC_ISCR_ST0_BIT 24
#define GIC_ISCR_ST1_MASK 0x2000000
#define GIC_ISCR_ST1 0x2000000
#define GIC_ISCR_ST1_BIT 25
#define GIC_ISCR_SWIRQ8_MASK 0x4000000
#define GIC_ISCR_SWIRQ8 0x4000000
#define GIC_ISCR_SWIRQ8_BIT 26
#define GIC_ISCR_SWIRQ9_MASK 0x8000000
#define GIC_ISCR_SWIRQ9 0x8000000
#define GIC_ISCR_SWIRQ9_BIT 27
#define GIC_ISCR_IRQ0_MASK 0x10000000
#define GIC_ISCR_IRQ0 0x10000000
#define GIC_ISCR_IRQ0_BIT 28
#define GIC_ISCR_SWIRQ10_MASK 0x20000000
#define GIC_ISCR_SWIRQ10 0x20000000
#define GIC_ISCR_SWIRQ10_BIT 29
#define GIC_ISCR_SWIRQ11_MASK 0x40000000
#define GIC_ISCR_SWIRQ11 0x40000000
#define GIC_ISCR_SWIRQ11_BIT 30
#define GIC_ISCR_SWIRQ12_MASK 0x80000000
#define GIC_ISCR_SWIRQ12 0x80000000
#define GIC_ISCR_SWIRQ12_BIT 31

#define GIC_EOICR (*(volatile unsigned long *)0xFFFFF130)
#define GIC_EOICR_OFFSET 0x130

#define GIC_SPU (*(volatile unsigned long *)0xFFFFF134)
#define GIC_SPU_OFFSET 0x134


#endif
