// AT91RM9200 register and bit definitions.
//
// Copyright (c) 2006 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef AT91RM9200_h
#define AT91RM9200_h

#define TC0_BASE 0xFFFA0000

#define TC0_CCR (*(volatile unsigned long *)0xFFFA0000)
#define TC0_CCR_OFFSET 0x0
#define TC0_CCR_CLKEN_MASK 0x1
#define TC0_CCR_CLKEN 0x1
#define TC0_CCR_CLKEN_BIT 0
#define TC0_CCR_CLKDIS_MASK 0x2
#define TC0_CCR_CLKDIS 0x2
#define TC0_CCR_CLKDIS_BIT 1
#define TC0_CCR_SWTRG_MASK 0x4
#define TC0_CCR_SWTRG 0x4
#define TC0_CCR_SWTRG_BIT 2

#define TC0_CMR (*(volatile unsigned long *)0xFFFA0004)
#define TC0_CMR_OFFSET 0x4
#define TC0_CMR_TCCLKS_MASK 0x7
#define TC0_CMR_TCCLKS_BIT 0
#define TC0_CMR_CLKI_MASK 0x8
#define TC0_CMR_CLKI 0x8
#define TC0_CMR_CLKI_BIT 3
#define TC0_CMR_BURST_MASK 0x30
#define TC0_CMR_BURST_BIT 4
#define TC0_CMR_LDBSTOP_MASK 0x40
#define TC0_CMR_LDBSTOP 0x40
#define TC0_CMR_LDBSTOP_BIT 6
#define TC0_CMR_LDBDIS_MASK 0x80
#define TC0_CMR_LDBDIS 0x80
#define TC0_CMR_LDBDIS_BIT 7
#define TC0_CMR_ETRGEDG_MASK 0x300
#define TC0_CMR_ETRGEDG_BIT 8
#define TC0_CMR_ABETRG_MASK 0x400
#define TC0_CMR_ABETRG 0x400
#define TC0_CMR_ABETRG_BIT 10
#define TC0_CMR_CPCTRG_MASK 0x4000
#define TC0_CMR_CPCTRG 0x4000
#define TC0_CMR_CPCTRG_BIT 14
#define TC0_CMR_WAVE_MASK 0x8000
#define TC0_CMR_WAVE 0x8000
#define TC0_CMR_WAVE_BIT 15
#define TC0_CMR_LDRA_MASK 0x30000
#define TC0_CMR_LDRA_BIT 16
#define TC0_CMR_LDRB_MASK 0xC0000
#define TC0_CMR_LDRB_BIT 18

#define TC0_CMR_WFM (*(volatile unsigned long *)0xFFFA0004)
#define TC0_CMR_WFM_OFFSET 0x4
#define TC0_CMR_WFM_TCCLKS_MASK 0x7
#define TC0_CMR_WFM_TCCLKS_BIT 0
#define TC0_CMR_WFM_CLKI_MASK 0x8
#define TC0_CMR_WFM_CLKI 0x8
#define TC0_CMR_WFM_CLKI_BIT 3
#define TC0_CMR_WFM_BURST_MASK 0x30
#define TC0_CMR_WFM_BURST_BIT 4
#define TC0_CMR_WFM_CPCSTOP_MASK 0x40
#define TC0_CMR_WFM_CPCSTOP 0x40
#define TC0_CMR_WFM_CPCSTOP_BIT 6
#define TC0_CMR_WFM_CPCDIS_MASK 0x80
#define TC0_CMR_WFM_CPCDIS 0x80
#define TC0_CMR_WFM_CPCDIS_BIT 7
#define TC0_CMR_WFM_EEVTEDG_MASK 0x300
#define TC0_CMR_WFM_EEVTEDG_BIT 8
#define TC0_CMR_WFM_EEVT_MASK 0xC00
#define TC0_CMR_WFM_EEVT_BIT 10
#define TC0_CMR_WFM_ENETRG_MASK 0x1000
#define TC0_CMR_WFM_ENETRG 0x1000
#define TC0_CMR_WFM_ENETRG_BIT 12
#define TC0_CMR_WFM_WAVSEL_MASK 0xC000
#define TC0_CMR_WFM_WAVSEL_BIT 14
#define TC0_CMR_WFM_WAVE_MASK 0x8000
#define TC0_CMR_WFM_WAVE 0x8000
#define TC0_CMR_WFM_WAVE_BIT 15
#define TC0_CMR_WFM_ACPA_MASK 0x30000
#define TC0_CMR_WFM_ACPA_BIT 16
#define TC0_CMR_WFM_ACPC_MASK 0xC0000
#define TC0_CMR_WFM_ACPC_BIT 18
#define TC0_CMR_WFM_AEEVT_MASK 0x300000
#define TC0_CMR_WFM_AEEVT_BIT 20
#define TC0_CMR_WFM_ASWTRG_MASK 0xC00000
#define TC0_CMR_WFM_ASWTRG_BIT 22
#define TC0_CMR_WFM_BCPB_MASK 0x3000000
#define TC0_CMR_WFM_BCPB_BIT 24
#define TC0_CMR_WFM_BCPC_MASK 0xC000000
#define TC0_CMR_WFM_BCPC_BIT 26
#define TC0_CMR_WFM_BEEVT_MASK 0x30000000
#define TC0_CMR_WFM_BEEVT_BIT 28
#define TC0_CMR_WFM_BSWTRG_MASK 0xC0000000
#define TC0_CMR_WFM_BSWTRG_BIT 30

#define TC0_CV (*(volatile unsigned long *)0xFFFA0010)
#define TC0_CV_OFFSET 0x10

#define TC0_RA (*(volatile unsigned long *)0xFFFA0014)
#define TC0_RA_OFFSET 0x14

#define TC0_RB (*(volatile unsigned long *)0xFFFA0018)
#define TC0_RB_OFFSET 0x18

#define TC0_RC (*(volatile unsigned long *)0xFFFA001C)
#define TC0_RC_OFFSET 0x1C

#define TC0_SR (*(volatile unsigned long *)0xFFFA0020)
#define TC0_SR_OFFSET 0x20
#define TC0_SR_COVFS_MASK 0x1
#define TC0_SR_COVFS 0x1
#define TC0_SR_COVFS_BIT 0
#define TC0_SR_LOVRS_MASK 0x2
#define TC0_SR_LOVRS 0x2
#define TC0_SR_LOVRS_BIT 1
#define TC0_SR_CPAS_MASK 0x4
#define TC0_SR_CPAS 0x4
#define TC0_SR_CPAS_BIT 2
#define TC0_SR_CPBS_MASK 0x8
#define TC0_SR_CPBS 0x8
#define TC0_SR_CPBS_BIT 3
#define TC0_SR_CPCS_MASK 0x10
#define TC0_SR_CPCS 0x10
#define TC0_SR_CPCS_BIT 4
#define TC0_SR_LDRAS_MASK 0x20
#define TC0_SR_LDRAS 0x20
#define TC0_SR_LDRAS_BIT 5
#define TC0_SR_LDRBS_MASK 0x40
#define TC0_SR_LDRBS 0x40
#define TC0_SR_LDRBS_BIT 6
#define TC0_SR_ETRGS_MASK 0x80
#define TC0_SR_ETRGS 0x80
#define TC0_SR_ETRGS_BIT 7
#define TC0_SR_CLKSTA_MASK 0x10000
#define TC0_SR_CLKSTA 0x10000
#define TC0_SR_CLKSTA_BIT 16
#define TC0_SR_MTIOA_MASK 0x20000
#define TC0_SR_MTIOA 0x20000
#define TC0_SR_MTIOA_BIT 17
#define TC0_SR_MTIOB_MASK 0x40000
#define TC0_SR_MTIOB 0x40000
#define TC0_SR_MTIOB_BIT 18

#define TC0_IER (*(volatile unsigned long *)0xFFFA0024)
#define TC0_IER_OFFSET 0x24
#define TC0_IER_COVFS_MASK 0x1
#define TC0_IER_COVFS 0x1
#define TC0_IER_COVFS_BIT 0
#define TC0_IER_LOVRS_MASK 0x2
#define TC0_IER_LOVRS 0x2
#define TC0_IER_LOVRS_BIT 1
#define TC0_IER_CPAS_MASK 0x4
#define TC0_IER_CPAS 0x4
#define TC0_IER_CPAS_BIT 2
#define TC0_IER_CPBS_MASK 0x8
#define TC0_IER_CPBS 0x8
#define TC0_IER_CPBS_BIT 3
#define TC0_IER_CPCS_MASK 0x10
#define TC0_IER_CPCS 0x10
#define TC0_IER_CPCS_BIT 4
#define TC0_IER_LDRAS_MASK 0x20
#define TC0_IER_LDRAS 0x20
#define TC0_IER_LDRAS_BIT 5
#define TC0_IER_LDRBS_MASK 0x40
#define TC0_IER_LDRBS 0x40
#define TC0_IER_LDRBS_BIT 6
#define TC0_IER_ETRGS_MASK 0x80
#define TC0_IER_ETRGS 0x80
#define TC0_IER_ETRGS_BIT 7

#define TC0_IDR (*(volatile unsigned long *)0xFFFA0028)
#define TC0_IDR_OFFSET 0x28
#define TC0_IDR_COVFS_MASK 0x1
#define TC0_IDR_COVFS 0x1
#define TC0_IDR_COVFS_BIT 0
#define TC0_IDR_LOVRS_MASK 0x2
#define TC0_IDR_LOVRS 0x2
#define TC0_IDR_LOVRS_BIT 1
#define TC0_IDR_CPAS_MASK 0x4
#define TC0_IDR_CPAS 0x4
#define TC0_IDR_CPAS_BIT 2
#define TC0_IDR_CPBS_MASK 0x8
#define TC0_IDR_CPBS 0x8
#define TC0_IDR_CPBS_BIT 3
#define TC0_IDR_CPCS_MASK 0x10
#define TC0_IDR_CPCS 0x10
#define TC0_IDR_CPCS_BIT 4
#define TC0_IDR_LDRAS_MASK 0x20
#define TC0_IDR_LDRAS 0x20
#define TC0_IDR_LDRAS_BIT 5
#define TC0_IDR_LDRBS_MASK 0x40
#define TC0_IDR_LDRBS 0x40
#define TC0_IDR_LDRBS_BIT 6
#define TC0_IDR_ETRGS_MASK 0x80
#define TC0_IDR_ETRGS 0x80
#define TC0_IDR_ETRGS_BIT 7

#define TC0_IMR (*(volatile unsigned long *)0xFFFA002C)
#define TC0_IMR_OFFSET 0x2C
#define TC0_IMR_COVFS_MASK 0x1
#define TC0_IMR_COVFS 0x1
#define TC0_IMR_COVFS_BIT 0
#define TC0_IMR_LOVRS_MASK 0x2
#define TC0_IMR_LOVRS 0x2
#define TC0_IMR_LOVRS_BIT 1
#define TC0_IMR_CPAS_MASK 0x4
#define TC0_IMR_CPAS 0x4
#define TC0_IMR_CPAS_BIT 2
#define TC0_IMR_CPBS_MASK 0x8
#define TC0_IMR_CPBS 0x8
#define TC0_IMR_CPBS_BIT 3
#define TC0_IMR_CPCS_MASK 0x10
#define TC0_IMR_CPCS 0x10
#define TC0_IMR_CPCS_BIT 4
#define TC0_IMR_LDRAS_MASK 0x20
#define TC0_IMR_LDRAS 0x20
#define TC0_IMR_LDRAS_BIT 5
#define TC0_IMR_LDRBS_MASK 0x40
#define TC0_IMR_LDRBS 0x40
#define TC0_IMR_LDRBS_BIT 6
#define TC0_IMR_ETRGS_MASK 0x80
#define TC0_IMR_ETRGS 0x80
#define TC0_IMR_ETRGS_BIT 7

#define TC1_BASE 0xFFFA0040

#define TC1_CCR (*(volatile unsigned long *)0xFFFA0040)
#define TC1_CCR_OFFSET 0x0
#define TC1_CCR_CLKEN_MASK 0x1
#define TC1_CCR_CLKEN 0x1
#define TC1_CCR_CLKEN_BIT 0
#define TC1_CCR_CLKDIS_MASK 0x2
#define TC1_CCR_CLKDIS 0x2
#define TC1_CCR_CLKDIS_BIT 1
#define TC1_CCR_SWTRG_MASK 0x4
#define TC1_CCR_SWTRG 0x4
#define TC1_CCR_SWTRG_BIT 2

#define TC1_CMR (*(volatile unsigned long *)0xFFFA0044)
#define TC1_CMR_OFFSET 0x4
#define TC1_CMR_TCCLKS_MASK 0x7
#define TC1_CMR_TCCLKS_BIT 0
#define TC1_CMR_CLKI_MASK 0x8
#define TC1_CMR_CLKI 0x8
#define TC1_CMR_CLKI_BIT 3
#define TC1_CMR_BURST_MASK 0x30
#define TC1_CMR_BURST_BIT 4
#define TC1_CMR_LDBSTOP_MASK 0x40
#define TC1_CMR_LDBSTOP 0x40
#define TC1_CMR_LDBSTOP_BIT 6
#define TC1_CMR_LDBDIS_MASK 0x80
#define TC1_CMR_LDBDIS 0x80
#define TC1_CMR_LDBDIS_BIT 7
#define TC1_CMR_ETRGEDG_MASK 0x300
#define TC1_CMR_ETRGEDG_BIT 8
#define TC1_CMR_ABETRG_MASK 0x400
#define TC1_CMR_ABETRG 0x400
#define TC1_CMR_ABETRG_BIT 10
#define TC1_CMR_CPCTRG_MASK 0x4000
#define TC1_CMR_CPCTRG 0x4000
#define TC1_CMR_CPCTRG_BIT 14
#define TC1_CMR_WAVE_MASK 0x8000
#define TC1_CMR_WAVE 0x8000
#define TC1_CMR_WAVE_BIT 15
#define TC1_CMR_LDRA_MASK 0x30000
#define TC1_CMR_LDRA_BIT 16
#define TC1_CMR_LDRB_MASK 0xC0000
#define TC1_CMR_LDRB_BIT 18

#define TC1_CMR_WFM (*(volatile unsigned long *)0xFFFA0044)
#define TC1_CMR_WFM_OFFSET 0x4
#define TC1_CMR_WFM_TCCLKS_MASK 0x7
#define TC1_CMR_WFM_TCCLKS_BIT 0
#define TC1_CMR_WFM_CLKI_MASK 0x8
#define TC1_CMR_WFM_CLKI 0x8
#define TC1_CMR_WFM_CLKI_BIT 3
#define TC1_CMR_WFM_BURST_MASK 0x30
#define TC1_CMR_WFM_BURST_BIT 4
#define TC1_CMR_WFM_CPCSTOP_MASK 0x40
#define TC1_CMR_WFM_CPCSTOP 0x40
#define TC1_CMR_WFM_CPCSTOP_BIT 6
#define TC1_CMR_WFM_CPCDIS_MASK 0x80
#define TC1_CMR_WFM_CPCDIS 0x80
#define TC1_CMR_WFM_CPCDIS_BIT 7
#define TC1_CMR_WFM_EEVTEDG_MASK 0x300
#define TC1_CMR_WFM_EEVTEDG_BIT 8
#define TC1_CMR_WFM_EEVT_MASK 0xC00
#define TC1_CMR_WFM_EEVT_BIT 10
#define TC1_CMR_WFM_ENETRG_MASK 0x1000
#define TC1_CMR_WFM_ENETRG 0x1000
#define TC1_CMR_WFM_ENETRG_BIT 12
#define TC1_CMR_WFM_WAVSEL_MASK 0xC000
#define TC1_CMR_WFM_WAVSEL_BIT 14
#define TC1_CMR_WFM_WAVE_MASK 0x8000
#define TC1_CMR_WFM_WAVE 0x8000
#define TC1_CMR_WFM_WAVE_BIT 15
#define TC1_CMR_WFM_ACPA_MASK 0x30000
#define TC1_CMR_WFM_ACPA_BIT 16
#define TC1_CMR_WFM_ACPC_MASK 0xC0000
#define TC1_CMR_WFM_ACPC_BIT 18
#define TC1_CMR_WFM_AEEVT_MASK 0x300000
#define TC1_CMR_WFM_AEEVT_BIT 20
#define TC1_CMR_WFM_ASWTRG_MASK 0xC00000
#define TC1_CMR_WFM_ASWTRG_BIT 22
#define TC1_CMR_WFM_BCPB_MASK 0x3000000
#define TC1_CMR_WFM_BCPB_BIT 24
#define TC1_CMR_WFM_BCPC_MASK 0xC000000
#define TC1_CMR_WFM_BCPC_BIT 26
#define TC1_CMR_WFM_BEEVT_MASK 0x30000000
#define TC1_CMR_WFM_BEEVT_BIT 28
#define TC1_CMR_WFM_BSWTRG_MASK 0xC0000000
#define TC1_CMR_WFM_BSWTRG_BIT 30

#define TC1_CV (*(volatile unsigned long *)0xFFFA0050)
#define TC1_CV_OFFSET 0x10

#define TC1_RA (*(volatile unsigned long *)0xFFFA0054)
#define TC1_RA_OFFSET 0x14

#define TC1_RB (*(volatile unsigned long *)0xFFFA0058)
#define TC1_RB_OFFSET 0x18

#define TC1_RC (*(volatile unsigned long *)0xFFFA005C)
#define TC1_RC_OFFSET 0x1C

#define TC1_SR (*(volatile unsigned long *)0xFFFA0060)
#define TC1_SR_OFFSET 0x20
#define TC1_SR_COVFS_MASK 0x1
#define TC1_SR_COVFS 0x1
#define TC1_SR_COVFS_BIT 0
#define TC1_SR_LOVRS_MASK 0x2
#define TC1_SR_LOVRS 0x2
#define TC1_SR_LOVRS_BIT 1
#define TC1_SR_CPAS_MASK 0x4
#define TC1_SR_CPAS 0x4
#define TC1_SR_CPAS_BIT 2
#define TC1_SR_CPBS_MASK 0x8
#define TC1_SR_CPBS 0x8
#define TC1_SR_CPBS_BIT 3
#define TC1_SR_CPCS_MASK 0x10
#define TC1_SR_CPCS 0x10
#define TC1_SR_CPCS_BIT 4
#define TC1_SR_LDRAS_MASK 0x20
#define TC1_SR_LDRAS 0x20
#define TC1_SR_LDRAS_BIT 5
#define TC1_SR_LDRBS_MASK 0x40
#define TC1_SR_LDRBS 0x40
#define TC1_SR_LDRBS_BIT 6
#define TC1_SR_ETRGS_MASK 0x80
#define TC1_SR_ETRGS 0x80
#define TC1_SR_ETRGS_BIT 7
#define TC1_SR_CLKSTA_MASK 0x10000
#define TC1_SR_CLKSTA 0x10000
#define TC1_SR_CLKSTA_BIT 16
#define TC1_SR_MTIOA_MASK 0x20000
#define TC1_SR_MTIOA 0x20000
#define TC1_SR_MTIOA_BIT 17
#define TC1_SR_MTIOB_MASK 0x40000
#define TC1_SR_MTIOB 0x40000
#define TC1_SR_MTIOB_BIT 18

#define TC1_IER (*(volatile unsigned long *)0xFFFA0064)
#define TC1_IER_OFFSET 0x24
#define TC1_IER_COVFS_MASK 0x1
#define TC1_IER_COVFS 0x1
#define TC1_IER_COVFS_BIT 0
#define TC1_IER_LOVRS_MASK 0x2
#define TC1_IER_LOVRS 0x2
#define TC1_IER_LOVRS_BIT 1
#define TC1_IER_CPAS_MASK 0x4
#define TC1_IER_CPAS 0x4
#define TC1_IER_CPAS_BIT 2
#define TC1_IER_CPBS_MASK 0x8
#define TC1_IER_CPBS 0x8
#define TC1_IER_CPBS_BIT 3
#define TC1_IER_CPCS_MASK 0x10
#define TC1_IER_CPCS 0x10
#define TC1_IER_CPCS_BIT 4
#define TC1_IER_LDRAS_MASK 0x20
#define TC1_IER_LDRAS 0x20
#define TC1_IER_LDRAS_BIT 5
#define TC1_IER_LDRBS_MASK 0x40
#define TC1_IER_LDRBS 0x40
#define TC1_IER_LDRBS_BIT 6
#define TC1_IER_ETRGS_MASK 0x80
#define TC1_IER_ETRGS 0x80
#define TC1_IER_ETRGS_BIT 7

#define TC1_IDR (*(volatile unsigned long *)0xFFFA0068)
#define TC1_IDR_OFFSET 0x28
#define TC1_IDR_COVFS_MASK 0x1
#define TC1_IDR_COVFS 0x1
#define TC1_IDR_COVFS_BIT 0
#define TC1_IDR_LOVRS_MASK 0x2
#define TC1_IDR_LOVRS 0x2
#define TC1_IDR_LOVRS_BIT 1
#define TC1_IDR_CPAS_MASK 0x4
#define TC1_IDR_CPAS 0x4
#define TC1_IDR_CPAS_BIT 2
#define TC1_IDR_CPBS_MASK 0x8
#define TC1_IDR_CPBS 0x8
#define TC1_IDR_CPBS_BIT 3
#define TC1_IDR_CPCS_MASK 0x10
#define TC1_IDR_CPCS 0x10
#define TC1_IDR_CPCS_BIT 4
#define TC1_IDR_LDRAS_MASK 0x20
#define TC1_IDR_LDRAS 0x20
#define TC1_IDR_LDRAS_BIT 5
#define TC1_IDR_LDRBS_MASK 0x40
#define TC1_IDR_LDRBS 0x40
#define TC1_IDR_LDRBS_BIT 6
#define TC1_IDR_ETRGS_MASK 0x80
#define TC1_IDR_ETRGS 0x80
#define TC1_IDR_ETRGS_BIT 7

#define TC1_IMR (*(volatile unsigned long *)0xFFFA006C)
#define TC1_IMR_OFFSET 0x2C
#define TC1_IMR_COVFS_MASK 0x1
#define TC1_IMR_COVFS 0x1
#define TC1_IMR_COVFS_BIT 0
#define TC1_IMR_LOVRS_MASK 0x2
#define TC1_IMR_LOVRS 0x2
#define TC1_IMR_LOVRS_BIT 1
#define TC1_IMR_CPAS_MASK 0x4
#define TC1_IMR_CPAS 0x4
#define TC1_IMR_CPAS_BIT 2
#define TC1_IMR_CPBS_MASK 0x8
#define TC1_IMR_CPBS 0x8
#define TC1_IMR_CPBS_BIT 3
#define TC1_IMR_CPCS_MASK 0x10
#define TC1_IMR_CPCS 0x10
#define TC1_IMR_CPCS_BIT 4
#define TC1_IMR_LDRAS_MASK 0x20
#define TC1_IMR_LDRAS 0x20
#define TC1_IMR_LDRAS_BIT 5
#define TC1_IMR_LDRBS_MASK 0x40
#define TC1_IMR_LDRBS 0x40
#define TC1_IMR_LDRBS_BIT 6
#define TC1_IMR_ETRGS_MASK 0x80
#define TC1_IMR_ETRGS 0x80
#define TC1_IMR_ETRGS_BIT 7

#define TC2_BASE 0xFFFA0080

#define TC2_CCR (*(volatile unsigned long *)0xFFFA0080)
#define TC2_CCR_OFFSET 0x0
#define TC2_CCR_CLKEN_MASK 0x1
#define TC2_CCR_CLKEN 0x1
#define TC2_CCR_CLKEN_BIT 0
#define TC2_CCR_CLKDIS_MASK 0x2
#define TC2_CCR_CLKDIS 0x2
#define TC2_CCR_CLKDIS_BIT 1
#define TC2_CCR_SWTRG_MASK 0x4
#define TC2_CCR_SWTRG 0x4
#define TC2_CCR_SWTRG_BIT 2

#define TC2_CMR (*(volatile unsigned long *)0xFFFA0084)
#define TC2_CMR_OFFSET 0x4
#define TC2_CMR_TCCLKS_MASK 0x7
#define TC2_CMR_TCCLKS_BIT 0
#define TC2_CMR_CLKI_MASK 0x8
#define TC2_CMR_CLKI 0x8
#define TC2_CMR_CLKI_BIT 3
#define TC2_CMR_BURST_MASK 0x30
#define TC2_CMR_BURST_BIT 4
#define TC2_CMR_LDBSTOP_MASK 0x40
#define TC2_CMR_LDBSTOP 0x40
#define TC2_CMR_LDBSTOP_BIT 6
#define TC2_CMR_LDBDIS_MASK 0x80
#define TC2_CMR_LDBDIS 0x80
#define TC2_CMR_LDBDIS_BIT 7
#define TC2_CMR_ETRGEDG_MASK 0x300
#define TC2_CMR_ETRGEDG_BIT 8
#define TC2_CMR_ABETRG_MASK 0x400
#define TC2_CMR_ABETRG 0x400
#define TC2_CMR_ABETRG_BIT 10
#define TC2_CMR_CPCTRG_MASK 0x4000
#define TC2_CMR_CPCTRG 0x4000
#define TC2_CMR_CPCTRG_BIT 14
#define TC2_CMR_WAVE_MASK 0x8000
#define TC2_CMR_WAVE 0x8000
#define TC2_CMR_WAVE_BIT 15
#define TC2_CMR_LDRA_MASK 0x30000
#define TC2_CMR_LDRA_BIT 16
#define TC2_CMR_LDRB_MASK 0xC0000
#define TC2_CMR_LDRB_BIT 18

#define TC2_CMR_WFM (*(volatile unsigned long *)0xFFFA0084)
#define TC2_CMR_WFM_OFFSET 0x4
#define TC2_CMR_WFM_TCCLKS_MASK 0x7
#define TC2_CMR_WFM_TCCLKS_BIT 0
#define TC2_CMR_WFM_CLKI_MASK 0x8
#define TC2_CMR_WFM_CLKI 0x8
#define TC2_CMR_WFM_CLKI_BIT 3
#define TC2_CMR_WFM_BURST_MASK 0x30
#define TC2_CMR_WFM_BURST_BIT 4
#define TC2_CMR_WFM_CPCSTOP_MASK 0x40
#define TC2_CMR_WFM_CPCSTOP 0x40
#define TC2_CMR_WFM_CPCSTOP_BIT 6
#define TC2_CMR_WFM_CPCDIS_MASK 0x80
#define TC2_CMR_WFM_CPCDIS 0x80
#define TC2_CMR_WFM_CPCDIS_BIT 7
#define TC2_CMR_WFM_EEVTEDG_MASK 0x300
#define TC2_CMR_WFM_EEVTEDG_BIT 8
#define TC2_CMR_WFM_EEVT_MASK 0xC00
#define TC2_CMR_WFM_EEVT_BIT 10
#define TC2_CMR_WFM_ENETRG_MASK 0x1000
#define TC2_CMR_WFM_ENETRG 0x1000
#define TC2_CMR_WFM_ENETRG_BIT 12
#define TC2_CMR_WFM_WAVSEL_MASK 0xC000
#define TC2_CMR_WFM_WAVSEL_BIT 14
#define TC2_CMR_WFM_WAVE_MASK 0x8000
#define TC2_CMR_WFM_WAVE 0x8000
#define TC2_CMR_WFM_WAVE_BIT 15
#define TC2_CMR_WFM_ACPA_MASK 0x30000
#define TC2_CMR_WFM_ACPA_BIT 16
#define TC2_CMR_WFM_ACPC_MASK 0xC0000
#define TC2_CMR_WFM_ACPC_BIT 18
#define TC2_CMR_WFM_AEEVT_MASK 0x300000
#define TC2_CMR_WFM_AEEVT_BIT 20
#define TC2_CMR_WFM_ASWTRG_MASK 0xC00000
#define TC2_CMR_WFM_ASWTRG_BIT 22
#define TC2_CMR_WFM_BCPB_MASK 0x3000000
#define TC2_CMR_WFM_BCPB_BIT 24
#define TC2_CMR_WFM_BCPC_MASK 0xC000000
#define TC2_CMR_WFM_BCPC_BIT 26
#define TC2_CMR_WFM_BEEVT_MASK 0x30000000
#define TC2_CMR_WFM_BEEVT_BIT 28
#define TC2_CMR_WFM_BSWTRG_MASK 0xC0000000
#define TC2_CMR_WFM_BSWTRG_BIT 30

#define TC2_CV (*(volatile unsigned long *)0xFFFA0090)
#define TC2_CV_OFFSET 0x10

#define TC2_RA (*(volatile unsigned long *)0xFFFA0094)
#define TC2_RA_OFFSET 0x14

#define TC2_RB (*(volatile unsigned long *)0xFFFA0098)
#define TC2_RB_OFFSET 0x18

#define TC2_RC (*(volatile unsigned long *)0xFFFA009C)
#define TC2_RC_OFFSET 0x1C

#define TC2_SR (*(volatile unsigned long *)0xFFFA00A0)
#define TC2_SR_OFFSET 0x20
#define TC2_SR_COVFS_MASK 0x1
#define TC2_SR_COVFS 0x1
#define TC2_SR_COVFS_BIT 0
#define TC2_SR_LOVRS_MASK 0x2
#define TC2_SR_LOVRS 0x2
#define TC2_SR_LOVRS_BIT 1
#define TC2_SR_CPAS_MASK 0x4
#define TC2_SR_CPAS 0x4
#define TC2_SR_CPAS_BIT 2
#define TC2_SR_CPBS_MASK 0x8
#define TC2_SR_CPBS 0x8
#define TC2_SR_CPBS_BIT 3
#define TC2_SR_CPCS_MASK 0x10
#define TC2_SR_CPCS 0x10
#define TC2_SR_CPCS_BIT 4
#define TC2_SR_LDRAS_MASK 0x20
#define TC2_SR_LDRAS 0x20
#define TC2_SR_LDRAS_BIT 5
#define TC2_SR_LDRBS_MASK 0x40
#define TC2_SR_LDRBS 0x40
#define TC2_SR_LDRBS_BIT 6
#define TC2_SR_ETRGS_MASK 0x80
#define TC2_SR_ETRGS 0x80
#define TC2_SR_ETRGS_BIT 7
#define TC2_SR_CLKSTA_MASK 0x10000
#define TC2_SR_CLKSTA 0x10000
#define TC2_SR_CLKSTA_BIT 16
#define TC2_SR_MTIOA_MASK 0x20000
#define TC2_SR_MTIOA 0x20000
#define TC2_SR_MTIOA_BIT 17
#define TC2_SR_MTIOB_MASK 0x40000
#define TC2_SR_MTIOB 0x40000
#define TC2_SR_MTIOB_BIT 18

#define TC2_IER (*(volatile unsigned long *)0xFFFA00A4)
#define TC2_IER_OFFSET 0x24
#define TC2_IER_COVFS_MASK 0x1
#define TC2_IER_COVFS 0x1
#define TC2_IER_COVFS_BIT 0
#define TC2_IER_LOVRS_MASK 0x2
#define TC2_IER_LOVRS 0x2
#define TC2_IER_LOVRS_BIT 1
#define TC2_IER_CPAS_MASK 0x4
#define TC2_IER_CPAS 0x4
#define TC2_IER_CPAS_BIT 2
#define TC2_IER_CPBS_MASK 0x8
#define TC2_IER_CPBS 0x8
#define TC2_IER_CPBS_BIT 3
#define TC2_IER_CPCS_MASK 0x10
#define TC2_IER_CPCS 0x10
#define TC2_IER_CPCS_BIT 4
#define TC2_IER_LDRAS_MASK 0x20
#define TC2_IER_LDRAS 0x20
#define TC2_IER_LDRAS_BIT 5
#define TC2_IER_LDRBS_MASK 0x40
#define TC2_IER_LDRBS 0x40
#define TC2_IER_LDRBS_BIT 6
#define TC2_IER_ETRGS_MASK 0x80
#define TC2_IER_ETRGS 0x80
#define TC2_IER_ETRGS_BIT 7

#define TC2_IDR (*(volatile unsigned long *)0xFFFA00A8)
#define TC2_IDR_OFFSET 0x28
#define TC2_IDR_COVFS_MASK 0x1
#define TC2_IDR_COVFS 0x1
#define TC2_IDR_COVFS_BIT 0
#define TC2_IDR_LOVRS_MASK 0x2
#define TC2_IDR_LOVRS 0x2
#define TC2_IDR_LOVRS_BIT 1
#define TC2_IDR_CPAS_MASK 0x4
#define TC2_IDR_CPAS 0x4
#define TC2_IDR_CPAS_BIT 2
#define TC2_IDR_CPBS_MASK 0x8
#define TC2_IDR_CPBS 0x8
#define TC2_IDR_CPBS_BIT 3
#define TC2_IDR_CPCS_MASK 0x10
#define TC2_IDR_CPCS 0x10
#define TC2_IDR_CPCS_BIT 4
#define TC2_IDR_LDRAS_MASK 0x20
#define TC2_IDR_LDRAS 0x20
#define TC2_IDR_LDRAS_BIT 5
#define TC2_IDR_LDRBS_MASK 0x40
#define TC2_IDR_LDRBS 0x40
#define TC2_IDR_LDRBS_BIT 6
#define TC2_IDR_ETRGS_MASK 0x80
#define TC2_IDR_ETRGS 0x80
#define TC2_IDR_ETRGS_BIT 7

#define TC2_IMR (*(volatile unsigned long *)0xFFFA00AC)
#define TC2_IMR_OFFSET 0x2C
#define TC2_IMR_COVFS_MASK 0x1
#define TC2_IMR_COVFS 0x1
#define TC2_IMR_COVFS_BIT 0
#define TC2_IMR_LOVRS_MASK 0x2
#define TC2_IMR_LOVRS 0x2
#define TC2_IMR_LOVRS_BIT 1
#define TC2_IMR_CPAS_MASK 0x4
#define TC2_IMR_CPAS 0x4
#define TC2_IMR_CPAS_BIT 2
#define TC2_IMR_CPBS_MASK 0x8
#define TC2_IMR_CPBS 0x8
#define TC2_IMR_CPBS_BIT 3
#define TC2_IMR_CPCS_MASK 0x10
#define TC2_IMR_CPCS 0x10
#define TC2_IMR_CPCS_BIT 4
#define TC2_IMR_LDRAS_MASK 0x20
#define TC2_IMR_LDRAS 0x20
#define TC2_IMR_LDRAS_BIT 5
#define TC2_IMR_LDRBS_MASK 0x40
#define TC2_IMR_LDRBS 0x40
#define TC2_IMR_LDRBS_BIT 6
#define TC2_IMR_ETRGS_MASK 0x80
#define TC2_IMR_ETRGS 0x80
#define TC2_IMR_ETRGS_BIT 7

#define TC3_BASE 0xFFFA4000

#define TC3_CCR (*(volatile unsigned long *)0xFFFA4000)
#define TC3_CCR_OFFSET 0x0
#define TC3_CCR_CLKEN_MASK 0x1
#define TC3_CCR_CLKEN 0x1
#define TC3_CCR_CLKEN_BIT 0
#define TC3_CCR_CLKDIS_MASK 0x2
#define TC3_CCR_CLKDIS 0x2
#define TC3_CCR_CLKDIS_BIT 1
#define TC3_CCR_SWTRG_MASK 0x4
#define TC3_CCR_SWTRG 0x4
#define TC3_CCR_SWTRG_BIT 2

#define TC3_CMR (*(volatile unsigned long *)0xFFFA4004)
#define TC3_CMR_OFFSET 0x4
#define TC3_CMR_TCCLKS_MASK 0x7
#define TC3_CMR_TCCLKS_BIT 0
#define TC3_CMR_CLKI_MASK 0x8
#define TC3_CMR_CLKI 0x8
#define TC3_CMR_CLKI_BIT 3
#define TC3_CMR_BURST_MASK 0x30
#define TC3_CMR_BURST_BIT 4
#define TC3_CMR_LDBSTOP_MASK 0x40
#define TC3_CMR_LDBSTOP 0x40
#define TC3_CMR_LDBSTOP_BIT 6
#define TC3_CMR_LDBDIS_MASK 0x80
#define TC3_CMR_LDBDIS 0x80
#define TC3_CMR_LDBDIS_BIT 7
#define TC3_CMR_ETRGEDG_MASK 0x300
#define TC3_CMR_ETRGEDG_BIT 8
#define TC3_CMR_ABETRG_MASK 0x400
#define TC3_CMR_ABETRG 0x400
#define TC3_CMR_ABETRG_BIT 10
#define TC3_CMR_CPCTRG_MASK 0x4000
#define TC3_CMR_CPCTRG 0x4000
#define TC3_CMR_CPCTRG_BIT 14
#define TC3_CMR_WAVE_MASK 0x8000
#define TC3_CMR_WAVE 0x8000
#define TC3_CMR_WAVE_BIT 15
#define TC3_CMR_LDRA_MASK 0x30000
#define TC3_CMR_LDRA_BIT 16
#define TC3_CMR_LDRB_MASK 0xC0000
#define TC3_CMR_LDRB_BIT 18

#define TC3_CMR_WFM (*(volatile unsigned long *)0xFFFA4004)
#define TC3_CMR_WFM_OFFSET 0x4
#define TC3_CMR_WFM_TCCLKS_MASK 0x7
#define TC3_CMR_WFM_TCCLKS_BIT 0
#define TC3_CMR_WFM_CLKI_MASK 0x8
#define TC3_CMR_WFM_CLKI 0x8
#define TC3_CMR_WFM_CLKI_BIT 3
#define TC3_CMR_WFM_BURST_MASK 0x30
#define TC3_CMR_WFM_BURST_BIT 4
#define TC3_CMR_WFM_CPCSTOP_MASK 0x40
#define TC3_CMR_WFM_CPCSTOP 0x40
#define TC3_CMR_WFM_CPCSTOP_BIT 6
#define TC3_CMR_WFM_CPCDIS_MASK 0x80
#define TC3_CMR_WFM_CPCDIS 0x80
#define TC3_CMR_WFM_CPCDIS_BIT 7
#define TC3_CMR_WFM_EEVTEDG_MASK 0x300
#define TC3_CMR_WFM_EEVTEDG_BIT 8
#define TC3_CMR_WFM_EEVT_MASK 0xC00
#define TC3_CMR_WFM_EEVT_BIT 10
#define TC3_CMR_WFM_ENETRG_MASK 0x1000
#define TC3_CMR_WFM_ENETRG 0x1000
#define TC3_CMR_WFM_ENETRG_BIT 12
#define TC3_CMR_WFM_WAVSEL_MASK 0xC000
#define TC3_CMR_WFM_WAVSEL_BIT 14
#define TC3_CMR_WFM_WAVE_MASK 0x8000
#define TC3_CMR_WFM_WAVE 0x8000
#define TC3_CMR_WFM_WAVE_BIT 15
#define TC3_CMR_WFM_ACPA_MASK 0x30000
#define TC3_CMR_WFM_ACPA_BIT 16
#define TC3_CMR_WFM_ACPC_MASK 0xC0000
#define TC3_CMR_WFM_ACPC_BIT 18
#define TC3_CMR_WFM_AEEVT_MASK 0x300000
#define TC3_CMR_WFM_AEEVT_BIT 20
#define TC3_CMR_WFM_ASWTRG_MASK 0xC00000
#define TC3_CMR_WFM_ASWTRG_BIT 22
#define TC3_CMR_WFM_BCPB_MASK 0x3000000
#define TC3_CMR_WFM_BCPB_BIT 24
#define TC3_CMR_WFM_BCPC_MASK 0xC000000
#define TC3_CMR_WFM_BCPC_BIT 26
#define TC3_CMR_WFM_BEEVT_MASK 0x30000000
#define TC3_CMR_WFM_BEEVT_BIT 28
#define TC3_CMR_WFM_BSWTRG_MASK 0xC0000000
#define TC3_CMR_WFM_BSWTRG_BIT 30

#define TC3_CV (*(volatile unsigned long *)0xFFFA4010)
#define TC3_CV_OFFSET 0x10

#define TC3_RA (*(volatile unsigned long *)0xFFFA4014)
#define TC3_RA_OFFSET 0x14

#define TC3_RB (*(volatile unsigned long *)0xFFFA4018)
#define TC3_RB_OFFSET 0x18

#define TC3_RC (*(volatile unsigned long *)0xFFFA401C)
#define TC3_RC_OFFSET 0x1C

#define TC3_SR (*(volatile unsigned long *)0xFFFA4020)
#define TC3_SR_OFFSET 0x20
#define TC3_SR_COVFS_MASK 0x1
#define TC3_SR_COVFS 0x1
#define TC3_SR_COVFS_BIT 0
#define TC3_SR_LOVRS_MASK 0x2
#define TC3_SR_LOVRS 0x2
#define TC3_SR_LOVRS_BIT 1
#define TC3_SR_CPAS_MASK 0x4
#define TC3_SR_CPAS 0x4
#define TC3_SR_CPAS_BIT 2
#define TC3_SR_CPBS_MASK 0x8
#define TC3_SR_CPBS 0x8
#define TC3_SR_CPBS_BIT 3
#define TC3_SR_CPCS_MASK 0x10
#define TC3_SR_CPCS 0x10
#define TC3_SR_CPCS_BIT 4
#define TC3_SR_LDRAS_MASK 0x20
#define TC3_SR_LDRAS 0x20
#define TC3_SR_LDRAS_BIT 5
#define TC3_SR_LDRBS_MASK 0x40
#define TC3_SR_LDRBS 0x40
#define TC3_SR_LDRBS_BIT 6
#define TC3_SR_ETRGS_MASK 0x80
#define TC3_SR_ETRGS 0x80
#define TC3_SR_ETRGS_BIT 7
#define TC3_SR_CLKSTA_MASK 0x10000
#define TC3_SR_CLKSTA 0x10000
#define TC3_SR_CLKSTA_BIT 16
#define TC3_SR_MTIOA_MASK 0x20000
#define TC3_SR_MTIOA 0x20000
#define TC3_SR_MTIOA_BIT 17
#define TC3_SR_MTIOB_MASK 0x40000
#define TC3_SR_MTIOB 0x40000
#define TC3_SR_MTIOB_BIT 18

#define TC3_IER (*(volatile unsigned long *)0xFFFA4024)
#define TC3_IER_OFFSET 0x24
#define TC3_IER_COVFS_MASK 0x1
#define TC3_IER_COVFS 0x1
#define TC3_IER_COVFS_BIT 0
#define TC3_IER_LOVRS_MASK 0x2
#define TC3_IER_LOVRS 0x2
#define TC3_IER_LOVRS_BIT 1
#define TC3_IER_CPAS_MASK 0x4
#define TC3_IER_CPAS 0x4
#define TC3_IER_CPAS_BIT 2
#define TC3_IER_CPBS_MASK 0x8
#define TC3_IER_CPBS 0x8
#define TC3_IER_CPBS_BIT 3
#define TC3_IER_CPCS_MASK 0x10
#define TC3_IER_CPCS 0x10
#define TC3_IER_CPCS_BIT 4
#define TC3_IER_LDRAS_MASK 0x20
#define TC3_IER_LDRAS 0x20
#define TC3_IER_LDRAS_BIT 5
#define TC3_IER_LDRBS_MASK 0x40
#define TC3_IER_LDRBS 0x40
#define TC3_IER_LDRBS_BIT 6
#define TC3_IER_ETRGS_MASK 0x80
#define TC3_IER_ETRGS 0x80
#define TC3_IER_ETRGS_BIT 7

#define TC3_IDR (*(volatile unsigned long *)0xFFFA4028)
#define TC3_IDR_OFFSET 0x28
#define TC3_IDR_COVFS_MASK 0x1
#define TC3_IDR_COVFS 0x1
#define TC3_IDR_COVFS_BIT 0
#define TC3_IDR_LOVRS_MASK 0x2
#define TC3_IDR_LOVRS 0x2
#define TC3_IDR_LOVRS_BIT 1
#define TC3_IDR_CPAS_MASK 0x4
#define TC3_IDR_CPAS 0x4
#define TC3_IDR_CPAS_BIT 2
#define TC3_IDR_CPBS_MASK 0x8
#define TC3_IDR_CPBS 0x8
#define TC3_IDR_CPBS_BIT 3
#define TC3_IDR_CPCS_MASK 0x10
#define TC3_IDR_CPCS 0x10
#define TC3_IDR_CPCS_BIT 4
#define TC3_IDR_LDRAS_MASK 0x20
#define TC3_IDR_LDRAS 0x20
#define TC3_IDR_LDRAS_BIT 5
#define TC3_IDR_LDRBS_MASK 0x40
#define TC3_IDR_LDRBS 0x40
#define TC3_IDR_LDRBS_BIT 6
#define TC3_IDR_ETRGS_MASK 0x80
#define TC3_IDR_ETRGS 0x80
#define TC3_IDR_ETRGS_BIT 7

#define TC3_IMR (*(volatile unsigned long *)0xFFFA402C)
#define TC3_IMR_OFFSET 0x2C
#define TC3_IMR_COVFS_MASK 0x1
#define TC3_IMR_COVFS 0x1
#define TC3_IMR_COVFS_BIT 0
#define TC3_IMR_LOVRS_MASK 0x2
#define TC3_IMR_LOVRS 0x2
#define TC3_IMR_LOVRS_BIT 1
#define TC3_IMR_CPAS_MASK 0x4
#define TC3_IMR_CPAS 0x4
#define TC3_IMR_CPAS_BIT 2
#define TC3_IMR_CPBS_MASK 0x8
#define TC3_IMR_CPBS 0x8
#define TC3_IMR_CPBS_BIT 3
#define TC3_IMR_CPCS_MASK 0x10
#define TC3_IMR_CPCS 0x10
#define TC3_IMR_CPCS_BIT 4
#define TC3_IMR_LDRAS_MASK 0x20
#define TC3_IMR_LDRAS 0x20
#define TC3_IMR_LDRAS_BIT 5
#define TC3_IMR_LDRBS_MASK 0x40
#define TC3_IMR_LDRBS 0x40
#define TC3_IMR_LDRBS_BIT 6
#define TC3_IMR_ETRGS_MASK 0x80
#define TC3_IMR_ETRGS 0x80
#define TC3_IMR_ETRGS_BIT 7

#define TC4_BASE 0xFFFA4040

#define TC4_CCR (*(volatile unsigned long *)0xFFFA4040)
#define TC4_CCR_OFFSET 0x0
#define TC4_CCR_CLKEN_MASK 0x1
#define TC4_CCR_CLKEN 0x1
#define TC4_CCR_CLKEN_BIT 0
#define TC4_CCR_CLKDIS_MASK 0x2
#define TC4_CCR_CLKDIS 0x2
#define TC4_CCR_CLKDIS_BIT 1
#define TC4_CCR_SWTRG_MASK 0x4
#define TC4_CCR_SWTRG 0x4
#define TC4_CCR_SWTRG_BIT 2

#define TC4_CMR (*(volatile unsigned long *)0xFFFA4044)
#define TC4_CMR_OFFSET 0x4
#define TC4_CMR_TCCLKS_MASK 0x7
#define TC4_CMR_TCCLKS_BIT 0
#define TC4_CMR_CLKI_MASK 0x8
#define TC4_CMR_CLKI 0x8
#define TC4_CMR_CLKI_BIT 3
#define TC4_CMR_BURST_MASK 0x30
#define TC4_CMR_BURST_BIT 4
#define TC4_CMR_LDBSTOP_MASK 0x40
#define TC4_CMR_LDBSTOP 0x40
#define TC4_CMR_LDBSTOP_BIT 6
#define TC4_CMR_LDBDIS_MASK 0x80
#define TC4_CMR_LDBDIS 0x80
#define TC4_CMR_LDBDIS_BIT 7
#define TC4_CMR_ETRGEDG_MASK 0x300
#define TC4_CMR_ETRGEDG_BIT 8
#define TC4_CMR_ABETRG_MASK 0x400
#define TC4_CMR_ABETRG 0x400
#define TC4_CMR_ABETRG_BIT 10
#define TC4_CMR_CPCTRG_MASK 0x4000
#define TC4_CMR_CPCTRG 0x4000
#define TC4_CMR_CPCTRG_BIT 14
#define TC4_CMR_WAVE_MASK 0x8000
#define TC4_CMR_WAVE 0x8000
#define TC4_CMR_WAVE_BIT 15
#define TC4_CMR_LDRA_MASK 0x30000
#define TC4_CMR_LDRA_BIT 16
#define TC4_CMR_LDRB_MASK 0xC0000
#define TC4_CMR_LDRB_BIT 18

#define TC4_CMR_WFM (*(volatile unsigned long *)0xFFFA4044)
#define TC4_CMR_WFM_OFFSET 0x4
#define TC4_CMR_WFM_TCCLKS_MASK 0x7
#define TC4_CMR_WFM_TCCLKS_BIT 0
#define TC4_CMR_WFM_CLKI_MASK 0x8
#define TC4_CMR_WFM_CLKI 0x8
#define TC4_CMR_WFM_CLKI_BIT 3
#define TC4_CMR_WFM_BURST_MASK 0x30
#define TC4_CMR_WFM_BURST_BIT 4
#define TC4_CMR_WFM_CPCSTOP_MASK 0x40
#define TC4_CMR_WFM_CPCSTOP 0x40
#define TC4_CMR_WFM_CPCSTOP_BIT 6
#define TC4_CMR_WFM_CPCDIS_MASK 0x80
#define TC4_CMR_WFM_CPCDIS 0x80
#define TC4_CMR_WFM_CPCDIS_BIT 7
#define TC4_CMR_WFM_EEVTEDG_MASK 0x300
#define TC4_CMR_WFM_EEVTEDG_BIT 8
#define TC4_CMR_WFM_EEVT_MASK 0xC00
#define TC4_CMR_WFM_EEVT_BIT 10
#define TC4_CMR_WFM_ENETRG_MASK 0x1000
#define TC4_CMR_WFM_ENETRG 0x1000
#define TC4_CMR_WFM_ENETRG_BIT 12
#define TC4_CMR_WFM_WAVSEL_MASK 0xC000
#define TC4_CMR_WFM_WAVSEL_BIT 14
#define TC4_CMR_WFM_WAVE_MASK 0x8000
#define TC4_CMR_WFM_WAVE 0x8000
#define TC4_CMR_WFM_WAVE_BIT 15
#define TC4_CMR_WFM_ACPA_MASK 0x30000
#define TC4_CMR_WFM_ACPA_BIT 16
#define TC4_CMR_WFM_ACPC_MASK 0xC0000
#define TC4_CMR_WFM_ACPC_BIT 18
#define TC4_CMR_WFM_AEEVT_MASK 0x300000
#define TC4_CMR_WFM_AEEVT_BIT 20
#define TC4_CMR_WFM_ASWTRG_MASK 0xC00000
#define TC4_CMR_WFM_ASWTRG_BIT 22
#define TC4_CMR_WFM_BCPB_MASK 0x3000000
#define TC4_CMR_WFM_BCPB_BIT 24
#define TC4_CMR_WFM_BCPC_MASK 0xC000000
#define TC4_CMR_WFM_BCPC_BIT 26
#define TC4_CMR_WFM_BEEVT_MASK 0x30000000
#define TC4_CMR_WFM_BEEVT_BIT 28
#define TC4_CMR_WFM_BSWTRG_MASK 0xC0000000
#define TC4_CMR_WFM_BSWTRG_BIT 30

#define TC4_CV (*(volatile unsigned long *)0xFFFA4050)
#define TC4_CV_OFFSET 0x10

#define TC4_RA (*(volatile unsigned long *)0xFFFA4054)
#define TC4_RA_OFFSET 0x14

#define TC4_RB (*(volatile unsigned long *)0xFFFA4058)
#define TC4_RB_OFFSET 0x18

#define TC4_RC (*(volatile unsigned long *)0xFFFA405C)
#define TC4_RC_OFFSET 0x1C

#define TC4_SR (*(volatile unsigned long *)0xFFFA4060)
#define TC4_SR_OFFSET 0x20
#define TC4_SR_COVFS_MASK 0x1
#define TC4_SR_COVFS 0x1
#define TC4_SR_COVFS_BIT 0
#define TC4_SR_LOVRS_MASK 0x2
#define TC4_SR_LOVRS 0x2
#define TC4_SR_LOVRS_BIT 1
#define TC4_SR_CPAS_MASK 0x4
#define TC4_SR_CPAS 0x4
#define TC4_SR_CPAS_BIT 2
#define TC4_SR_CPBS_MASK 0x8
#define TC4_SR_CPBS 0x8
#define TC4_SR_CPBS_BIT 3
#define TC4_SR_CPCS_MASK 0x10
#define TC4_SR_CPCS 0x10
#define TC4_SR_CPCS_BIT 4
#define TC4_SR_LDRAS_MASK 0x20
#define TC4_SR_LDRAS 0x20
#define TC4_SR_LDRAS_BIT 5
#define TC4_SR_LDRBS_MASK 0x40
#define TC4_SR_LDRBS 0x40
#define TC4_SR_LDRBS_BIT 6
#define TC4_SR_ETRGS_MASK 0x80
#define TC4_SR_ETRGS 0x80
#define TC4_SR_ETRGS_BIT 7
#define TC4_SR_CLKSTA_MASK 0x10000
#define TC4_SR_CLKSTA 0x10000
#define TC4_SR_CLKSTA_BIT 16
#define TC4_SR_MTIOA_MASK 0x20000
#define TC4_SR_MTIOA 0x20000
#define TC4_SR_MTIOA_BIT 17
#define TC4_SR_MTIOB_MASK 0x40000
#define TC4_SR_MTIOB 0x40000
#define TC4_SR_MTIOB_BIT 18

#define TC4_IER (*(volatile unsigned long *)0xFFFA4064)
#define TC4_IER_OFFSET 0x24
#define TC4_IER_COVFS_MASK 0x1
#define TC4_IER_COVFS 0x1
#define TC4_IER_COVFS_BIT 0
#define TC4_IER_LOVRS_MASK 0x2
#define TC4_IER_LOVRS 0x2
#define TC4_IER_LOVRS_BIT 1
#define TC4_IER_CPAS_MASK 0x4
#define TC4_IER_CPAS 0x4
#define TC4_IER_CPAS_BIT 2
#define TC4_IER_CPBS_MASK 0x8
#define TC4_IER_CPBS 0x8
#define TC4_IER_CPBS_BIT 3
#define TC4_IER_CPCS_MASK 0x10
#define TC4_IER_CPCS 0x10
#define TC4_IER_CPCS_BIT 4
#define TC4_IER_LDRAS_MASK 0x20
#define TC4_IER_LDRAS 0x20
#define TC4_IER_LDRAS_BIT 5
#define TC4_IER_LDRBS_MASK 0x40
#define TC4_IER_LDRBS 0x40
#define TC4_IER_LDRBS_BIT 6
#define TC4_IER_ETRGS_MASK 0x80
#define TC4_IER_ETRGS 0x80
#define TC4_IER_ETRGS_BIT 7

#define TC4_IDR (*(volatile unsigned long *)0xFFFA4068)
#define TC4_IDR_OFFSET 0x28
#define TC4_IDR_COVFS_MASK 0x1
#define TC4_IDR_COVFS 0x1
#define TC4_IDR_COVFS_BIT 0
#define TC4_IDR_LOVRS_MASK 0x2
#define TC4_IDR_LOVRS 0x2
#define TC4_IDR_LOVRS_BIT 1
#define TC4_IDR_CPAS_MASK 0x4
#define TC4_IDR_CPAS 0x4
#define TC4_IDR_CPAS_BIT 2
#define TC4_IDR_CPBS_MASK 0x8
#define TC4_IDR_CPBS 0x8
#define TC4_IDR_CPBS_BIT 3
#define TC4_IDR_CPCS_MASK 0x10
#define TC4_IDR_CPCS 0x10
#define TC4_IDR_CPCS_BIT 4
#define TC4_IDR_LDRAS_MASK 0x20
#define TC4_IDR_LDRAS 0x20
#define TC4_IDR_LDRAS_BIT 5
#define TC4_IDR_LDRBS_MASK 0x40
#define TC4_IDR_LDRBS 0x40
#define TC4_IDR_LDRBS_BIT 6
#define TC4_IDR_ETRGS_MASK 0x80
#define TC4_IDR_ETRGS 0x80
#define TC4_IDR_ETRGS_BIT 7

#define TC4_IMR (*(volatile unsigned long *)0xFFFA406C)
#define TC4_IMR_OFFSET 0x2C
#define TC4_IMR_COVFS_MASK 0x1
#define TC4_IMR_COVFS 0x1
#define TC4_IMR_COVFS_BIT 0
#define TC4_IMR_LOVRS_MASK 0x2
#define TC4_IMR_LOVRS 0x2
#define TC4_IMR_LOVRS_BIT 1
#define TC4_IMR_CPAS_MASK 0x4
#define TC4_IMR_CPAS 0x4
#define TC4_IMR_CPAS_BIT 2
#define TC4_IMR_CPBS_MASK 0x8
#define TC4_IMR_CPBS 0x8
#define TC4_IMR_CPBS_BIT 3
#define TC4_IMR_CPCS_MASK 0x10
#define TC4_IMR_CPCS 0x10
#define TC4_IMR_CPCS_BIT 4
#define TC4_IMR_LDRAS_MASK 0x20
#define TC4_IMR_LDRAS 0x20
#define TC4_IMR_LDRAS_BIT 5
#define TC4_IMR_LDRBS_MASK 0x40
#define TC4_IMR_LDRBS 0x40
#define TC4_IMR_LDRBS_BIT 6
#define TC4_IMR_ETRGS_MASK 0x80
#define TC4_IMR_ETRGS 0x80
#define TC4_IMR_ETRGS_BIT 7

#define TC5_BASE 0xFFFA4080

#define TC5_CCR (*(volatile unsigned long *)0xFFFA4080)
#define TC5_CCR_OFFSET 0x0
#define TC5_CCR_CLKEN_MASK 0x1
#define TC5_CCR_CLKEN 0x1
#define TC5_CCR_CLKEN_BIT 0
#define TC5_CCR_CLKDIS_MASK 0x2
#define TC5_CCR_CLKDIS 0x2
#define TC5_CCR_CLKDIS_BIT 1
#define TC5_CCR_SWTRG_MASK 0x4
#define TC5_CCR_SWTRG 0x4
#define TC5_CCR_SWTRG_BIT 2

#define TC5_CMR (*(volatile unsigned long *)0xFFFA4084)
#define TC5_CMR_OFFSET 0x4
#define TC5_CMR_TCCLKS_MASK 0x7
#define TC5_CMR_TCCLKS_BIT 0
#define TC5_CMR_CLKI_MASK 0x8
#define TC5_CMR_CLKI 0x8
#define TC5_CMR_CLKI_BIT 3
#define TC5_CMR_BURST_MASK 0x30
#define TC5_CMR_BURST_BIT 4
#define TC5_CMR_LDBSTOP_MASK 0x40
#define TC5_CMR_LDBSTOP 0x40
#define TC5_CMR_LDBSTOP_BIT 6
#define TC5_CMR_LDBDIS_MASK 0x80
#define TC5_CMR_LDBDIS 0x80
#define TC5_CMR_LDBDIS_BIT 7
#define TC5_CMR_ETRGEDG_MASK 0x300
#define TC5_CMR_ETRGEDG_BIT 8
#define TC5_CMR_ABETRG_MASK 0x400
#define TC5_CMR_ABETRG 0x400
#define TC5_CMR_ABETRG_BIT 10
#define TC5_CMR_CPCTRG_MASK 0x4000
#define TC5_CMR_CPCTRG 0x4000
#define TC5_CMR_CPCTRG_BIT 14
#define TC5_CMR_WAVE_MASK 0x8000
#define TC5_CMR_WAVE 0x8000
#define TC5_CMR_WAVE_BIT 15
#define TC5_CMR_LDRA_MASK 0x30000
#define TC5_CMR_LDRA_BIT 16
#define TC5_CMR_LDRB_MASK 0xC0000
#define TC5_CMR_LDRB_BIT 18

#define TC5_CMR_WFM (*(volatile unsigned long *)0xFFFA4084)
#define TC5_CMR_WFM_OFFSET 0x4
#define TC5_CMR_WFM_TCCLKS_MASK 0x7
#define TC5_CMR_WFM_TCCLKS_BIT 0
#define TC5_CMR_WFM_CLKI_MASK 0x8
#define TC5_CMR_WFM_CLKI 0x8
#define TC5_CMR_WFM_CLKI_BIT 3
#define TC5_CMR_WFM_BURST_MASK 0x30
#define TC5_CMR_WFM_BURST_BIT 4
#define TC5_CMR_WFM_CPCSTOP_MASK 0x40
#define TC5_CMR_WFM_CPCSTOP 0x40
#define TC5_CMR_WFM_CPCSTOP_BIT 6
#define TC5_CMR_WFM_CPCDIS_MASK 0x80
#define TC5_CMR_WFM_CPCDIS 0x80
#define TC5_CMR_WFM_CPCDIS_BIT 7
#define TC5_CMR_WFM_EEVTEDG_MASK 0x300
#define TC5_CMR_WFM_EEVTEDG_BIT 8
#define TC5_CMR_WFM_EEVT_MASK 0xC00
#define TC5_CMR_WFM_EEVT_BIT 10
#define TC5_CMR_WFM_ENETRG_MASK 0x1000
#define TC5_CMR_WFM_ENETRG 0x1000
#define TC5_CMR_WFM_ENETRG_BIT 12
#define TC5_CMR_WFM_WAVSEL_MASK 0xC000
#define TC5_CMR_WFM_WAVSEL_BIT 14
#define TC5_CMR_WFM_WAVE_MASK 0x8000
#define TC5_CMR_WFM_WAVE 0x8000
#define TC5_CMR_WFM_WAVE_BIT 15
#define TC5_CMR_WFM_ACPA_MASK 0x30000
#define TC5_CMR_WFM_ACPA_BIT 16
#define TC5_CMR_WFM_ACPC_MASK 0xC0000
#define TC5_CMR_WFM_ACPC_BIT 18
#define TC5_CMR_WFM_AEEVT_MASK 0x300000
#define TC5_CMR_WFM_AEEVT_BIT 20
#define TC5_CMR_WFM_ASWTRG_MASK 0xC00000
#define TC5_CMR_WFM_ASWTRG_BIT 22
#define TC5_CMR_WFM_BCPB_MASK 0x3000000
#define TC5_CMR_WFM_BCPB_BIT 24
#define TC5_CMR_WFM_BCPC_MASK 0xC000000
#define TC5_CMR_WFM_BCPC_BIT 26
#define TC5_CMR_WFM_BEEVT_MASK 0x30000000
#define TC5_CMR_WFM_BEEVT_BIT 28
#define TC5_CMR_WFM_BSWTRG_MASK 0xC0000000
#define TC5_CMR_WFM_BSWTRG_BIT 30

#define TC5_CV (*(volatile unsigned long *)0xFFFA4090)
#define TC5_CV_OFFSET 0x10

#define TC5_RA (*(volatile unsigned long *)0xFFFA4094)
#define TC5_RA_OFFSET 0x14

#define TC5_RB (*(volatile unsigned long *)0xFFFA4098)
#define TC5_RB_OFFSET 0x18

#define TC5_RC (*(volatile unsigned long *)0xFFFA409C)
#define TC5_RC_OFFSET 0x1C

#define TC5_SR (*(volatile unsigned long *)0xFFFA40A0)
#define TC5_SR_OFFSET 0x20
#define TC5_SR_COVFS_MASK 0x1
#define TC5_SR_COVFS 0x1
#define TC5_SR_COVFS_BIT 0
#define TC5_SR_LOVRS_MASK 0x2
#define TC5_SR_LOVRS 0x2
#define TC5_SR_LOVRS_BIT 1
#define TC5_SR_CPAS_MASK 0x4
#define TC5_SR_CPAS 0x4
#define TC5_SR_CPAS_BIT 2
#define TC5_SR_CPBS_MASK 0x8
#define TC5_SR_CPBS 0x8
#define TC5_SR_CPBS_BIT 3
#define TC5_SR_CPCS_MASK 0x10
#define TC5_SR_CPCS 0x10
#define TC5_SR_CPCS_BIT 4
#define TC5_SR_LDRAS_MASK 0x20
#define TC5_SR_LDRAS 0x20
#define TC5_SR_LDRAS_BIT 5
#define TC5_SR_LDRBS_MASK 0x40
#define TC5_SR_LDRBS 0x40
#define TC5_SR_LDRBS_BIT 6
#define TC5_SR_ETRGS_MASK 0x80
#define TC5_SR_ETRGS 0x80
#define TC5_SR_ETRGS_BIT 7
#define TC5_SR_CLKSTA_MASK 0x10000
#define TC5_SR_CLKSTA 0x10000
#define TC5_SR_CLKSTA_BIT 16
#define TC5_SR_MTIOA_MASK 0x20000
#define TC5_SR_MTIOA 0x20000
#define TC5_SR_MTIOA_BIT 17
#define TC5_SR_MTIOB_MASK 0x40000
#define TC5_SR_MTIOB 0x40000
#define TC5_SR_MTIOB_BIT 18

#define TC5_IER (*(volatile unsigned long *)0xFFFA40A4)
#define TC5_IER_OFFSET 0x24
#define TC5_IER_COVFS_MASK 0x1
#define TC5_IER_COVFS 0x1
#define TC5_IER_COVFS_BIT 0
#define TC5_IER_LOVRS_MASK 0x2
#define TC5_IER_LOVRS 0x2
#define TC5_IER_LOVRS_BIT 1
#define TC5_IER_CPAS_MASK 0x4
#define TC5_IER_CPAS 0x4
#define TC5_IER_CPAS_BIT 2
#define TC5_IER_CPBS_MASK 0x8
#define TC5_IER_CPBS 0x8
#define TC5_IER_CPBS_BIT 3
#define TC5_IER_CPCS_MASK 0x10
#define TC5_IER_CPCS 0x10
#define TC5_IER_CPCS_BIT 4
#define TC5_IER_LDRAS_MASK 0x20
#define TC5_IER_LDRAS 0x20
#define TC5_IER_LDRAS_BIT 5
#define TC5_IER_LDRBS_MASK 0x40
#define TC5_IER_LDRBS 0x40
#define TC5_IER_LDRBS_BIT 6
#define TC5_IER_ETRGS_MASK 0x80
#define TC5_IER_ETRGS 0x80
#define TC5_IER_ETRGS_BIT 7

#define TC5_IDR (*(volatile unsigned long *)0xFFFA40A8)
#define TC5_IDR_OFFSET 0x28
#define TC5_IDR_COVFS_MASK 0x1
#define TC5_IDR_COVFS 0x1
#define TC5_IDR_COVFS_BIT 0
#define TC5_IDR_LOVRS_MASK 0x2
#define TC5_IDR_LOVRS 0x2
#define TC5_IDR_LOVRS_BIT 1
#define TC5_IDR_CPAS_MASK 0x4
#define TC5_IDR_CPAS 0x4
#define TC5_IDR_CPAS_BIT 2
#define TC5_IDR_CPBS_MASK 0x8
#define TC5_IDR_CPBS 0x8
#define TC5_IDR_CPBS_BIT 3
#define TC5_IDR_CPCS_MASK 0x10
#define TC5_IDR_CPCS 0x10
#define TC5_IDR_CPCS_BIT 4
#define TC5_IDR_LDRAS_MASK 0x20
#define TC5_IDR_LDRAS 0x20
#define TC5_IDR_LDRAS_BIT 5
#define TC5_IDR_LDRBS_MASK 0x40
#define TC5_IDR_LDRBS 0x40
#define TC5_IDR_LDRBS_BIT 6
#define TC5_IDR_ETRGS_MASK 0x80
#define TC5_IDR_ETRGS 0x80
#define TC5_IDR_ETRGS_BIT 7

#define TC5_IMR (*(volatile unsigned long *)0xFFFA40AC)
#define TC5_IMR_OFFSET 0x2C
#define TC5_IMR_COVFS_MASK 0x1
#define TC5_IMR_COVFS 0x1
#define TC5_IMR_COVFS_BIT 0
#define TC5_IMR_LOVRS_MASK 0x2
#define TC5_IMR_LOVRS 0x2
#define TC5_IMR_LOVRS_BIT 1
#define TC5_IMR_CPAS_MASK 0x4
#define TC5_IMR_CPAS 0x4
#define TC5_IMR_CPAS_BIT 2
#define TC5_IMR_CPBS_MASK 0x8
#define TC5_IMR_CPBS 0x8
#define TC5_IMR_CPBS_BIT 3
#define TC5_IMR_CPCS_MASK 0x10
#define TC5_IMR_CPCS 0x10
#define TC5_IMR_CPCS_BIT 4
#define TC5_IMR_LDRAS_MASK 0x20
#define TC5_IMR_LDRAS 0x20
#define TC5_IMR_LDRAS_BIT 5
#define TC5_IMR_LDRBS_MASK 0x40
#define TC5_IMR_LDRBS 0x40
#define TC5_IMR_LDRBS_BIT 6
#define TC5_IMR_ETRGS_MASK 0x80
#define TC5_IMR_ETRGS 0x80
#define TC5_IMR_ETRGS_BIT 7

#define TC012_BASE 0xFFFA0000

#define TC012_BCR (*(volatile unsigned long *)0xFFFA00C0)
#define TC012_BCR_OFFSET 0xC0

#define TC012_BMR (*(volatile unsigned long *)0xFFFA00C4)
#define TC012_BMR_OFFSET 0xC4
#define TC012_BMR_TC0XC0S_MASK 0x3
#define TC012_BMR_TC0XC0S_BIT 0
#define TC012_BMR_TC1XC1S_MASK 0xC
#define TC012_BMR_TC1XC1S_BIT 2
#define TC012_BMR_TC2XC2S_MASK 0x30
#define TC012_BMR_TC2XC2S_BIT 4

#define TC345_BASE 0xFFFA4000

#define TC345_BCR (*(volatile unsigned long *)0xFFFA40C0)
#define TC345_BCR_OFFSET 0xC0

#define TC345_BMR (*(volatile unsigned long *)0xFFFA40C4)
#define TC345_BMR_OFFSET 0xC4
#define TC345_BMR_TC0XC0S_MASK 0x3
#define TC345_BMR_TC0XC0S_BIT 0
#define TC345_BMR_TC1XC1S_MASK 0xC
#define TC345_BMR_TC1XC1S_BIT 2
#define TC345_BMR_TC2XC2S_MASK 0x30
#define TC345_BMR_TC2XC2S_BIT 4

#define UDP_BASE 0xFFFB0000

#define UDP_FRM_NUM (*(volatile unsigned long *)0xFFFB0000)
#define UDP_FRM_NUM_OFFSET 0x0
#define UDP_FRM_NUM_FRM_NUM_MASK 0x7FF
#define UDP_FRM_NUM_FRM_NUM_BIT 0
#define UDP_FRM_NUM_FRM_ERR_MASK 0x10000
#define UDP_FRM_NUM_FRM_ERR 0x10000
#define UDP_FRM_NUM_FRM_ERR_BIT 16
#define UDP_FRM_NUM_FRM_OK_MASK 0x20000
#define UDP_FRM_NUM_FRM_OK 0x20000
#define UDP_FRM_NUM_FRM_OK_BIT 17

#define UDP_GLB_STAT (*(volatile unsigned long *)0xFFFB0004)
#define UDP_GLB_STAT_OFFSET 0x4
#define UDP_GLB_STAT_FADDEN_MASK 0x1
#define UDP_GLB_STAT_FADDEN 0x1
#define UDP_GLB_STAT_FADDEN_BIT 0
#define UDP_GLB_STAT_CONFIG_MASK 0x2
#define UDP_GLB_STAT_CONFIG 0x2
#define UDP_GLB_STAT_CONFIG_BIT 1
#define UDP_GLB_STAT_ESR_MASK 0x4
#define UDP_GLB_STAT_ESR 0x4
#define UDP_GLB_STAT_ESR_BIT 2
#define UDP_GLB_STAT_RSMINPR_MASK 0x8
#define UDP_GLB_STAT_RSMINPR 0x8
#define UDP_GLB_STAT_RSMINPR_BIT 3
#define UDP_GLB_STAT_RMWUPE_MASK 0x10
#define UDP_GLB_STAT_RMWUPE 0x10
#define UDP_GLB_STAT_RMWUPE_BIT 4

#define UDP_FADDR (*(volatile unsigned long *)0xFFFB0008)
#define UDP_FADDR_OFFSET 0x8
#define UDP_FADDR_FADD_MASK 0x7F
#define UDP_FADDR_FADD_BIT 0
#define UDP_FADDR_FEN_MASK 0x100
#define UDP_FADDR_FEN 0x100
#define UDP_FADDR_FEN_BIT 8

#define UDP_IER (*(volatile unsigned long *)0xFFFB0010)
#define UDP_IER_OFFSET 0x10
#define UDP_IER_EP0INT_MASK 0x1
#define UDP_IER_EP0INT 0x1
#define UDP_IER_EP0INT_BIT 0
#define UDP_IER_EP1INT_MASK 0x2
#define UDP_IER_EP1INT 0x2
#define UDP_IER_EP1INT_BIT 1
#define UDP_IER_EP2INT_MASK 0x4
#define UDP_IER_EP2INT 0x4
#define UDP_IER_EP2INT_BIT 2
#define UDP_IER_EP3INT_MASK 0x8
#define UDP_IER_EP3INT 0x8
#define UDP_IER_EP3INT_BIT 3
#define UDP_IER_EP4INT_MASK 0x10
#define UDP_IER_EP4INT 0x10
#define UDP_IER_EP4INT_BIT 4
#define UDP_IER_EP5INT_MASK 0x20
#define UDP_IER_EP5INT 0x20
#define UDP_IER_EP5INT_BIT 5
#define UDP_IER_EP6INT_MASK 0x40
#define UDP_IER_EP6INT 0x40
#define UDP_IER_EP6INT_BIT 6
#define UDP_IER_EP7INT_MASK 0x80
#define UDP_IER_EP7INT 0x80
#define UDP_IER_EP7INT_BIT 7
#define UDP_IER_RXSUSP_MASK 0x100
#define UDP_IER_RXSUSP 0x100
#define UDP_IER_RXSUSP_BIT 8
#define UDP_IER_RXRSM_MASK 0x200
#define UDP_IER_RXRSM 0x200
#define UDP_IER_RXRSM_BIT 9
#define UDP_IER_EXTRSM_MASK 0x400
#define UDP_IER_EXTRSM 0x400
#define UDP_IER_EXTRSM_BIT 10
#define UDP_IER_SOFINT_MASK 0x800
#define UDP_IER_SOFINT 0x800
#define UDP_IER_SOFINT_BIT 11
#define UDP_IER_WAKEUP_MASK 0x2000
#define UDP_IER_WAKEUP 0x2000
#define UDP_IER_WAKEUP_BIT 13

#define UDP_IDR (*(volatile unsigned long *)0xFFFB0014)
#define UDP_IDR_OFFSET 0x14
#define UDP_IDR_EP0INT_MASK 0x1
#define UDP_IDR_EP0INT 0x1
#define UDP_IDR_EP0INT_BIT 0
#define UDP_IDR_EP1INT_MASK 0x2
#define UDP_IDR_EP1INT 0x2
#define UDP_IDR_EP1INT_BIT 1
#define UDP_IDR_EP2INT_MASK 0x4
#define UDP_IDR_EP2INT 0x4
#define UDP_IDR_EP2INT_BIT 2
#define UDP_IDR_EP3INT_MASK 0x8
#define UDP_IDR_EP3INT 0x8
#define UDP_IDR_EP3INT_BIT 3
#define UDP_IDR_EP4INT_MASK 0x10
#define UDP_IDR_EP4INT 0x10
#define UDP_IDR_EP4INT_BIT 4
#define UDP_IDR_EP5INT_MASK 0x20
#define UDP_IDR_EP5INT 0x20
#define UDP_IDR_EP5INT_BIT 5
#define UDP_IDR_EP6INT_MASK 0x40
#define UDP_IDR_EP6INT 0x40
#define UDP_IDR_EP6INT_BIT 6
#define UDP_IDR_EP7INT_MASK 0x80
#define UDP_IDR_EP7INT 0x80
#define UDP_IDR_EP7INT_BIT 7
#define UDP_IDR_RXSUSP_MASK 0x100
#define UDP_IDR_RXSUSP 0x100
#define UDP_IDR_RXSUSP_BIT 8
#define UDP_IDR_RXRSM_MASK 0x200
#define UDP_IDR_RXRSM 0x200
#define UDP_IDR_RXRSM_BIT 9
#define UDP_IDR_EXTRSM_MASK 0x400
#define UDP_IDR_EXTRSM 0x400
#define UDP_IDR_EXTRSM_BIT 10
#define UDP_IDR_SOFINT_MASK 0x800
#define UDP_IDR_SOFINT 0x800
#define UDP_IDR_SOFINT_BIT 11
#define UDP_IDR_WAKEUP_MASK 0x2000
#define UDP_IDR_WAKEUP 0x2000
#define UDP_IDR_WAKEUP_BIT 13

#define UDP_IMR (*(volatile unsigned long *)0xFFFB0018)
#define UDP_IMR_OFFSET 0x18
#define UDP_IMR_EP0INT_MASK 0x1
#define UDP_IMR_EP0INT 0x1
#define UDP_IMR_EP0INT_BIT 0
#define UDP_IMR_EP1INT_MASK 0x2
#define UDP_IMR_EP1INT 0x2
#define UDP_IMR_EP1INT_BIT 1
#define UDP_IMR_EP2INT_MASK 0x4
#define UDP_IMR_EP2INT 0x4
#define UDP_IMR_EP2INT_BIT 2
#define UDP_IMR_EP3INT_MASK 0x8
#define UDP_IMR_EP3INT 0x8
#define UDP_IMR_EP3INT_BIT 3
#define UDP_IMR_EP4INT_MASK 0x10
#define UDP_IMR_EP4INT 0x10
#define UDP_IMR_EP4INT_BIT 4
#define UDP_IMR_EP5INT_MASK 0x20
#define UDP_IMR_EP5INT 0x20
#define UDP_IMR_EP5INT_BIT 5
#define UDP_IMR_EP6INT_MASK 0x40
#define UDP_IMR_EP6INT 0x40
#define UDP_IMR_EP6INT_BIT 6
#define UDP_IMR_EP7INT_MASK 0x80
#define UDP_IMR_EP7INT 0x80
#define UDP_IMR_EP7INT_BIT 7
#define UDP_IMR_RXSUSP_MASK 0x100
#define UDP_IMR_RXSUSP 0x100
#define UDP_IMR_RXSUSP_BIT 8
#define UDP_IMR_RXRSM_MASK 0x200
#define UDP_IMR_RXRSM 0x200
#define UDP_IMR_RXRSM_BIT 9
#define UDP_IMR_EXTRSM_MASK 0x400
#define UDP_IMR_EXTRSM 0x400
#define UDP_IMR_EXTRSM_BIT 10
#define UDP_IMR_SOFINT_MASK 0x800
#define UDP_IMR_SOFINT 0x800
#define UDP_IMR_SOFINT_BIT 11
#define UDP_IMR_WAKEUP_MASK 0x2000
#define UDP_IMR_WAKEUP 0x2000
#define UDP_IMR_WAKEUP_BIT 13

#define UDP_ISR (*(volatile unsigned long *)0xFFFB001C)
#define UDP_ISR_OFFSET 0x1C
#define UDP_ISR_EP0INT_MASK 0x1
#define UDP_ISR_EP0INT 0x1
#define UDP_ISR_EP0INT_BIT 0
#define UDP_ISR_EP1INT_MASK 0x2
#define UDP_ISR_EP1INT 0x2
#define UDP_ISR_EP1INT_BIT 1
#define UDP_ISR_EP2INT_MASK 0x4
#define UDP_ISR_EP2INT 0x4
#define UDP_ISR_EP2INT_BIT 2
#define UDP_ISR_EP3INT_MASK 0x8
#define UDP_ISR_EP3INT 0x8
#define UDP_ISR_EP3INT_BIT 3
#define UDP_ISR_EP4INT_MASK 0x10
#define UDP_ISR_EP4INT 0x10
#define UDP_ISR_EP4INT_BIT 4
#define UDP_ISR_EP5INT_MASK 0x20
#define UDP_ISR_EP5INT 0x20
#define UDP_ISR_EP5INT_BIT 5
#define UDP_ISR_EP6INT_MASK 0x40
#define UDP_ISR_EP6INT 0x40
#define UDP_ISR_EP6INT_BIT 6
#define UDP_ISR_EP7INT_MASK 0x80
#define UDP_ISR_EP7INT 0x80
#define UDP_ISR_EP7INT_BIT 7
#define UDP_ISR_RXSUSP_MASK 0x100
#define UDP_ISR_RXSUSP 0x100
#define UDP_ISR_RXSUSP_BIT 8
#define UDP_ISR_RXRSM_MASK 0x200
#define UDP_ISR_RXRSM 0x200
#define UDP_ISR_RXRSM_BIT 9
#define UDP_ISR_EXTRSM_MASK 0x400
#define UDP_ISR_EXTRSM 0x400
#define UDP_ISR_EXTRSM_BIT 10
#define UDP_ISR_SOFINT_MASK 0x800
#define UDP_ISR_SOFINT 0x800
#define UDP_ISR_SOFINT_BIT 11
#define UDP_ISR_ENDBUSRES_MASK 0x1000
#define UDP_ISR_ENDBUSRES 0x1000
#define UDP_ISR_ENDBUSRES_BIT 12
#define UDP_ISR_WAKEUP_MASK 0x2000
#define UDP_ISR_WAKEUP 0x2000
#define UDP_ISR_WAKEUP_BIT 13

#define UDP_ICR (*(volatile unsigned long *)0xFFFB0020)
#define UDP_ICR_OFFSET 0x20
#define UDP_ICR_RXSUSP_MASK 0x100
#define UDP_ICR_RXSUSP 0x100
#define UDP_ICR_RXSUSP_BIT 8
#define UDP_ICR_RXRSM_MASK 0x200
#define UDP_ICR_RXRSM 0x200
#define UDP_ICR_RXRSM_BIT 9
#define UDP_ICR_EXTRSM_MASK 0x400
#define UDP_ICR_EXTRSM 0x400
#define UDP_ICR_EXTRSM_BIT 10
#define UDP_ICR_SOFINT_MASK 0x800
#define UDP_ICR_SOFINT 0x800
#define UDP_ICR_SOFINT_BIT 11
#define UDP_ICR_ENDBUSRES_MASK 0x1000
#define UDP_ICR_ENDBUSRES 0x1000
#define UDP_ICR_ENDBUSRES_BIT 12
#define UDP_ICR_WAKEUP_MASK 0x2000
#define UDP_ICR_WAKEUP 0x2000
#define UDP_ICR_WAKEUP_BIT 13

#define UDP_RST_EP (*(volatile unsigned long *)0xFFFB0028)
#define UDP_RST_EP_OFFSET 0x28
#define UDP_RST_EP_EP0INT_MASK 0x1
#define UDP_RST_EP_EP0INT 0x1
#define UDP_RST_EP_EP0INT_BIT 0
#define UDP_RST_EP_EP1INT_MASK 0x2
#define UDP_RST_EP_EP1INT 0x2
#define UDP_RST_EP_EP1INT_BIT 1
#define UDP_RST_EP_EP2INT_MASK 0x4
#define UDP_RST_EP_EP2INT 0x4
#define UDP_RST_EP_EP2INT_BIT 2
#define UDP_RST_EP_EP3INT_MASK 0x8
#define UDP_RST_EP_EP3INT 0x8
#define UDP_RST_EP_EP3INT_BIT 3
#define UDP_RST_EP_EP4INT_MASK 0x10
#define UDP_RST_EP_EP4INT 0x10
#define UDP_RST_EP_EP4INT_BIT 4
#define UDP_RST_EP_EP5INT_MASK 0x20
#define UDP_RST_EP_EP5INT 0x20
#define UDP_RST_EP_EP5INT_BIT 5
#define UDP_RST_EP_EP6INT_MASK 0x40
#define UDP_RST_EP_EP6INT 0x40
#define UDP_RST_EP_EP6INT_BIT 6
#define UDP_RST_EP_EP7INT_MASK 0x80
#define UDP_RST_EP_EP7INT 0x80
#define UDP_RST_EP_EP7INT_BIT 7

#define UDP_CSR0 (*(volatile unsigned long *)0xFFFB0030)
#define UDP_CSR0_OFFSET 0x30
#define UDP_CSR0_TXCOMP_MASK 0x1
#define UDP_CSR0_TXCOMP 0x1
#define UDP_CSR0_TXCOMP_BIT 0
#define UDP_CSR0_RX_DATA_BK0_MASK 0x2
#define UDP_CSR0_RX_DATA_BK0 0x2
#define UDP_CSR0_RX_DATA_BK0_BIT 1
#define UDP_CSR0_RXSETUP_MASK 0x4
#define UDP_CSR0_RXSETUP 0x4
#define UDP_CSR0_RXSETUP_BIT 2
#define UDP_CSR0_STALLSENTISOERROR_MASK 0x8
#define UDP_CSR0_STALLSENTISOERROR 0x8
#define UDP_CSR0_STALLSENTISOERROR_BIT 3
#define UDP_CSR0_TXPKTRDY_MASK 0x10
#define UDP_CSR0_TXPKTRDY 0x10
#define UDP_CSR0_TXPKTRDY_BIT 4
#define UDP_CSR0_FORCESTALL_MASK 0x20
#define UDP_CSR0_FORCESTALL 0x20
#define UDP_CSR0_FORCESTALL_BIT 5
#define UDP_CSR0_RX_DATA_BK1_MASK 0x40
#define UDP_CSR0_RX_DATA_BK1 0x40
#define UDP_CSR0_RX_DATA_BK1_BIT 6
#define UDP_CSR0_DIR_MASK 0x80
#define UDP_CSR0_DIR 0x80
#define UDP_CSR0_DIR_BIT 7
#define UDP_CSR0_EPTYPE_MASK 0x700
#define UDP_CSR0_EPTYPE_BIT 8
#define UDP_CSR0_DTGLE_MASK 0x800
#define UDP_CSR0_DTGLE 0x800
#define UDP_CSR0_DTGLE_BIT 11
#define UDP_CSR0_EPEDS_MASK 0x8000
#define UDP_CSR0_EPEDS 0x8000
#define UDP_CSR0_EPEDS_BIT 15
#define UDP_CSR0_RXBYTECNT_MASK 0x7FF0000
#define UDP_CSR0_RXBYTECNT_BIT 16

#define UDP_CSR1 (*(volatile unsigned long *)0xFFFB0034)
#define UDP_CSR1_OFFSET 0x34
#define UDP_CSR1_TXCOMP_MASK 0x1
#define UDP_CSR1_TXCOMP 0x1
#define UDP_CSR1_TXCOMP_BIT 0
#define UDP_CSR1_RX_DATA_BK0_MASK 0x2
#define UDP_CSR1_RX_DATA_BK0 0x2
#define UDP_CSR1_RX_DATA_BK0_BIT 1
#define UDP_CSR1_RXSETUP_MASK 0x4
#define UDP_CSR1_RXSETUP 0x4
#define UDP_CSR1_RXSETUP_BIT 2
#define UDP_CSR1_STALLSENTISOERROR_MASK 0x8
#define UDP_CSR1_STALLSENTISOERROR 0x8
#define UDP_CSR1_STALLSENTISOERROR_BIT 3
#define UDP_CSR1_TXPKTRDY_MASK 0x10
#define UDP_CSR1_TXPKTRDY 0x10
#define UDP_CSR1_TXPKTRDY_BIT 4
#define UDP_CSR1_FORCESTALL_MASK 0x20
#define UDP_CSR1_FORCESTALL 0x20
#define UDP_CSR1_FORCESTALL_BIT 5
#define UDP_CSR1_RX_DATA_BK1_MASK 0x40
#define UDP_CSR1_RX_DATA_BK1 0x40
#define UDP_CSR1_RX_DATA_BK1_BIT 6
#define UDP_CSR1_DIR_MASK 0x80
#define UDP_CSR1_DIR 0x80
#define UDP_CSR1_DIR_BIT 7
#define UDP_CSR1_EPTYPE_MASK 0x700
#define UDP_CSR1_EPTYPE_BIT 8
#define UDP_CSR1_DTGLE_MASK 0x800
#define UDP_CSR1_DTGLE 0x800
#define UDP_CSR1_DTGLE_BIT 11
#define UDP_CSR1_EPEDS_MASK 0x8000
#define UDP_CSR1_EPEDS 0x8000
#define UDP_CSR1_EPEDS_BIT 15
#define UDP_CSR1_RXBYTECNT_MASK 0x7FF0000
#define UDP_CSR1_RXBYTECNT_BIT 16

#define UDP_CSR2 (*(volatile unsigned long *)0xFFFB0038)
#define UDP_CSR2_OFFSET 0x38
#define UDP_CSR2_TXCOMP_MASK 0x1
#define UDP_CSR2_TXCOMP 0x1
#define UDP_CSR2_TXCOMP_BIT 0
#define UDP_CSR2_RX_DATA_BK0_MASK 0x2
#define UDP_CSR2_RX_DATA_BK0 0x2
#define UDP_CSR2_RX_DATA_BK0_BIT 1
#define UDP_CSR2_RXSETUP_MASK 0x4
#define UDP_CSR2_RXSETUP 0x4
#define UDP_CSR2_RXSETUP_BIT 2
#define UDP_CSR2_STALLSENTISOERROR_MASK 0x8
#define UDP_CSR2_STALLSENTISOERROR 0x8
#define UDP_CSR2_STALLSENTISOERROR_BIT 3
#define UDP_CSR2_TXPKTRDY_MASK 0x10
#define UDP_CSR2_TXPKTRDY 0x10
#define UDP_CSR2_TXPKTRDY_BIT 4
#define UDP_CSR2_FORCESTALL_MASK 0x20
#define UDP_CSR2_FORCESTALL 0x20
#define UDP_CSR2_FORCESTALL_BIT 5
#define UDP_CSR2_RX_DATA_BK1_MASK 0x40
#define UDP_CSR2_RX_DATA_BK1 0x40
#define UDP_CSR2_RX_DATA_BK1_BIT 6
#define UDP_CSR2_DIR_MASK 0x80
#define UDP_CSR2_DIR 0x80
#define UDP_CSR2_DIR_BIT 7
#define UDP_CSR2_EPTYPE_MASK 0x700
#define UDP_CSR2_EPTYPE_BIT 8
#define UDP_CSR2_DTGLE_MASK 0x800
#define UDP_CSR2_DTGLE 0x800
#define UDP_CSR2_DTGLE_BIT 11
#define UDP_CSR2_EPEDS_MASK 0x8000
#define UDP_CSR2_EPEDS 0x8000
#define UDP_CSR2_EPEDS_BIT 15
#define UDP_CSR2_RXBYTECNT_MASK 0x7FF0000
#define UDP_CSR2_RXBYTECNT_BIT 16

#define UDP_CSR3 (*(volatile unsigned long *)0xFFFB003C)
#define UDP_CSR3_OFFSET 0x3C
#define UDP_CSR3_TXCOMP_MASK 0x1
#define UDP_CSR3_TXCOMP 0x1
#define UDP_CSR3_TXCOMP_BIT 0
#define UDP_CSR3_RX_DATA_BK0_MASK 0x2
#define UDP_CSR3_RX_DATA_BK0 0x2
#define UDP_CSR3_RX_DATA_BK0_BIT 1
#define UDP_CSR3_RXSETUP_MASK 0x4
#define UDP_CSR3_RXSETUP 0x4
#define UDP_CSR3_RXSETUP_BIT 2
#define UDP_CSR3_STALLSENTISOERROR_MASK 0x8
#define UDP_CSR3_STALLSENTISOERROR 0x8
#define UDP_CSR3_STALLSENTISOERROR_BIT 3
#define UDP_CSR3_TXPKTRDY_MASK 0x10
#define UDP_CSR3_TXPKTRDY 0x10
#define UDP_CSR3_TXPKTRDY_BIT 4
#define UDP_CSR3_FORCESTALL_MASK 0x20
#define UDP_CSR3_FORCESTALL 0x20
#define UDP_CSR3_FORCESTALL_BIT 5
#define UDP_CSR3_RX_DATA_BK1_MASK 0x40
#define UDP_CSR3_RX_DATA_BK1 0x40
#define UDP_CSR3_RX_DATA_BK1_BIT 6
#define UDP_CSR3_DIR_MASK 0x80
#define UDP_CSR3_DIR 0x80
#define UDP_CSR3_DIR_BIT 7
#define UDP_CSR3_EPTYPE_MASK 0x700
#define UDP_CSR3_EPTYPE_BIT 8
#define UDP_CSR3_DTGLE_MASK 0x800
#define UDP_CSR3_DTGLE 0x800
#define UDP_CSR3_DTGLE_BIT 11
#define UDP_CSR3_EPEDS_MASK 0x8000
#define UDP_CSR3_EPEDS 0x8000
#define UDP_CSR3_EPEDS_BIT 15
#define UDP_CSR3_RXBYTECNT_MASK 0x7FF0000
#define UDP_CSR3_RXBYTECNT_BIT 16

#define UDP_CSR4 (*(volatile unsigned long *)0xFFFB0040)
#define UDP_CSR4_OFFSET 0x40
#define UDP_CSR4_TXCOMP_MASK 0x1
#define UDP_CSR4_TXCOMP 0x1
#define UDP_CSR4_TXCOMP_BIT 0
#define UDP_CSR4_RX_DATA_BK0_MASK 0x2
#define UDP_CSR4_RX_DATA_BK0 0x2
#define UDP_CSR4_RX_DATA_BK0_BIT 1
#define UDP_CSR4_RXSETUP_MASK 0x4
#define UDP_CSR4_RXSETUP 0x4
#define UDP_CSR4_RXSETUP_BIT 2
#define UDP_CSR4_STALLSENTISOERROR_MASK 0x8
#define UDP_CSR4_STALLSENTISOERROR 0x8
#define UDP_CSR4_STALLSENTISOERROR_BIT 3
#define UDP_CSR4_TXPKTRDY_MASK 0x10
#define UDP_CSR4_TXPKTRDY 0x10
#define UDP_CSR4_TXPKTRDY_BIT 4
#define UDP_CSR4_FORCESTALL_MASK 0x20
#define UDP_CSR4_FORCESTALL 0x20
#define UDP_CSR4_FORCESTALL_BIT 5
#define UDP_CSR4_RX_DATA_BK1_MASK 0x40
#define UDP_CSR4_RX_DATA_BK1 0x40
#define UDP_CSR4_RX_DATA_BK1_BIT 6
#define UDP_CSR4_DIR_MASK 0x80
#define UDP_CSR4_DIR 0x80
#define UDP_CSR4_DIR_BIT 7
#define UDP_CSR4_EPTYPE_MASK 0x700
#define UDP_CSR4_EPTYPE_BIT 8
#define UDP_CSR4_DTGLE_MASK 0x800
#define UDP_CSR4_DTGLE 0x800
#define UDP_CSR4_DTGLE_BIT 11
#define UDP_CSR4_EPEDS_MASK 0x8000
#define UDP_CSR4_EPEDS 0x8000
#define UDP_CSR4_EPEDS_BIT 15
#define UDP_CSR4_RXBYTECNT_MASK 0x7FF0000
#define UDP_CSR4_RXBYTECNT_BIT 16

#define UDP_CSR5 (*(volatile unsigned long *)0xFFFB0044)
#define UDP_CSR5_OFFSET 0x44
#define UDP_CSR5_TXCOMP_MASK 0x1
#define UDP_CSR5_TXCOMP 0x1
#define UDP_CSR5_TXCOMP_BIT 0
#define UDP_CSR5_RX_DATA_BK0_MASK 0x2
#define UDP_CSR5_RX_DATA_BK0 0x2
#define UDP_CSR5_RX_DATA_BK0_BIT 1
#define UDP_CSR5_RXSETUP_MASK 0x4
#define UDP_CSR5_RXSETUP 0x4
#define UDP_CSR5_RXSETUP_BIT 2
#define UDP_CSR5_STALLSENTISOERROR_MASK 0x8
#define UDP_CSR5_STALLSENTISOERROR 0x8
#define UDP_CSR5_STALLSENTISOERROR_BIT 3
#define UDP_CSR5_TXPKTRDY_MASK 0x10
#define UDP_CSR5_TXPKTRDY 0x10
#define UDP_CSR5_TXPKTRDY_BIT 4
#define UDP_CSR5_FORCESTALL_MASK 0x20
#define UDP_CSR5_FORCESTALL 0x20
#define UDP_CSR5_FORCESTALL_BIT 5
#define UDP_CSR5_RX_DATA_BK1_MASK 0x40
#define UDP_CSR5_RX_DATA_BK1 0x40
#define UDP_CSR5_RX_DATA_BK1_BIT 6
#define UDP_CSR5_DIR_MASK 0x80
#define UDP_CSR5_DIR 0x80
#define UDP_CSR5_DIR_BIT 7
#define UDP_CSR5_EPTYPE_MASK 0x700
#define UDP_CSR5_EPTYPE_BIT 8
#define UDP_CSR5_DTGLE_MASK 0x800
#define UDP_CSR5_DTGLE 0x800
#define UDP_CSR5_DTGLE_BIT 11
#define UDP_CSR5_EPEDS_MASK 0x8000
#define UDP_CSR5_EPEDS 0x8000
#define UDP_CSR5_EPEDS_BIT 15
#define UDP_CSR5_RXBYTECNT_MASK 0x7FF0000
#define UDP_CSR5_RXBYTECNT_BIT 16

#define UDP_CSR6 (*(volatile unsigned long *)0xFFFB0048)
#define UDP_CSR6_OFFSET 0x48
#define UDP_CSR6_TXCOMP_MASK 0x1
#define UDP_CSR6_TXCOMP 0x1
#define UDP_CSR6_TXCOMP_BIT 0
#define UDP_CSR6_RX_DATA_BK0_MASK 0x2
#define UDP_CSR6_RX_DATA_BK0 0x2
#define UDP_CSR6_RX_DATA_BK0_BIT 1
#define UDP_CSR6_RXSETUP_MASK 0x4
#define UDP_CSR6_RXSETUP 0x4
#define UDP_CSR6_RXSETUP_BIT 2
#define UDP_CSR6_STALLSENTISOERROR_MASK 0x8
#define UDP_CSR6_STALLSENTISOERROR 0x8
#define UDP_CSR6_STALLSENTISOERROR_BIT 3
#define UDP_CSR6_TXPKTRDY_MASK 0x10
#define UDP_CSR6_TXPKTRDY 0x10
#define UDP_CSR6_TXPKTRDY_BIT 4
#define UDP_CSR6_FORCESTALL_MASK 0x20
#define UDP_CSR6_FORCESTALL 0x20
#define UDP_CSR6_FORCESTALL_BIT 5
#define UDP_CSR6_RX_DATA_BK1_MASK 0x40
#define UDP_CSR6_RX_DATA_BK1 0x40
#define UDP_CSR6_RX_DATA_BK1_BIT 6
#define UDP_CSR6_DIR_MASK 0x80
#define UDP_CSR6_DIR 0x80
#define UDP_CSR6_DIR_BIT 7
#define UDP_CSR6_EPTYPE_MASK 0x700
#define UDP_CSR6_EPTYPE_BIT 8
#define UDP_CSR6_DTGLE_MASK 0x800
#define UDP_CSR6_DTGLE 0x800
#define UDP_CSR6_DTGLE_BIT 11
#define UDP_CSR6_EPEDS_MASK 0x8000
#define UDP_CSR6_EPEDS 0x8000
#define UDP_CSR6_EPEDS_BIT 15
#define UDP_CSR6_RXBYTECNT_MASK 0x7FF0000
#define UDP_CSR6_RXBYTECNT_BIT 16

#define UDP_CSR7 (*(volatile unsigned long *)0xFFFB004C)
#define UDP_CSR7_OFFSET 0x4C
#define UDP_CSR7_TXCOMP_MASK 0x1
#define UDP_CSR7_TXCOMP 0x1
#define UDP_CSR7_TXCOMP_BIT 0
#define UDP_CSR7_RX_DATA_BK0_MASK 0x2
#define UDP_CSR7_RX_DATA_BK0 0x2
#define UDP_CSR7_RX_DATA_BK0_BIT 1
#define UDP_CSR7_RXSETUP_MASK 0x4
#define UDP_CSR7_RXSETUP 0x4
#define UDP_CSR7_RXSETUP_BIT 2
#define UDP_CSR7_STALLSENTISOERROR_MASK 0x8
#define UDP_CSR7_STALLSENTISOERROR 0x8
#define UDP_CSR7_STALLSENTISOERROR_BIT 3
#define UDP_CSR7_TXPKTRDY_MASK 0x10
#define UDP_CSR7_TXPKTRDY 0x10
#define UDP_CSR7_TXPKTRDY_BIT 4
#define UDP_CSR7_FORCESTALL_MASK 0x20
#define UDP_CSR7_FORCESTALL 0x20
#define UDP_CSR7_FORCESTALL_BIT 5
#define UDP_CSR7_RX_DATA_BK1_MASK 0x40
#define UDP_CSR7_RX_DATA_BK1 0x40
#define UDP_CSR7_RX_DATA_BK1_BIT 6
#define UDP_CSR7_DIR_MASK 0x80
#define UDP_CSR7_DIR 0x80
#define UDP_CSR7_DIR_BIT 7
#define UDP_CSR7_EPTYPE_MASK 0x700
#define UDP_CSR7_EPTYPE_BIT 8
#define UDP_CSR7_DTGLE_MASK 0x800
#define UDP_CSR7_DTGLE 0x800
#define UDP_CSR7_DTGLE_BIT 11
#define UDP_CSR7_EPEDS_MASK 0x8000
#define UDP_CSR7_EPEDS 0x8000
#define UDP_CSR7_EPEDS_BIT 15
#define UDP_CSR7_RXBYTECNT_MASK 0x7FF0000
#define UDP_CSR7_RXBYTECNT_BIT 16

#define UDP_FDR0 (*(volatile unsigned long *)0xFFFB0050)
#define UDP_FDR0_OFFSET 0x50

#define UDP_FDR1 (*(volatile unsigned long *)0xFFFB0054)
#define UDP_FDR1_OFFSET 0x54

#define UDP_FDR2 (*(volatile unsigned long *)0xFFFB0058)
#define UDP_FDR2_OFFSET 0x58

#define UDP_FDR3 (*(volatile unsigned long *)0xFFFB005C)
#define UDP_FDR3_OFFSET 0x5C

#define UDP_FDR4 (*(volatile unsigned long *)0xFFFB0060)
#define UDP_FDR4_OFFSET 0x60

#define UDP_FDR5 (*(volatile unsigned long *)0xFFFB0064)
#define UDP_FDR5_OFFSET 0x64

#define UDP_FDR6 (*(volatile unsigned long *)0xFFFB0068)
#define UDP_FDR6_OFFSET 0x68

#define UDP_FDR7 (*(volatile unsigned long *)0xFFFB006C)
#define UDP_FDR7_OFFSET 0x6C

#define UDP_TXVC (*(volatile unsigned long *)0xFFFB0074)
#define UDP_TXVC_OFFSET 0x74
#define UDP_TXVC_TXVDIS_MASK 0x100
#define UDP_TXVC_TXVDIS 0x100
#define UDP_TXVC_TXVDIS_BIT 8

#define MCI_BASE 0xFFFB4000

#define MCI_CR (*(volatile unsigned long *)0xFFFB4000)
#define MCI_CR_OFFSET 0x0
#define MCI_CR_MCIEN_MASK 0x1
#define MCI_CR_MCIEN 0x1
#define MCI_CR_MCIEN_BIT 0
#define MCI_CR_MCIDIS_MASK 0x2
#define MCI_CR_MCIDIS 0x2
#define MCI_CR_MCIDIS_BIT 1
#define MCI_CR_PWSEN_MASK 0x4
#define MCI_CR_PWSEN 0x4
#define MCI_CR_PWSEN_BIT 2
#define MCI_CR_PWSDIS_MASK 0x8
#define MCI_CR_PWSDIS 0x8
#define MCI_CR_PWSDIS_BIT 3
#define MCI_CR_SWRST_MASK 0x80
#define MCI_CR_SWRST 0x80
#define MCI_CR_SWRST_BIT 7

#define MCI_MR (*(volatile unsigned long *)0xFFFB4004)
#define MCI_MR_OFFSET 0x4
#define MCI_MR_CLKDIV_MASK 0xFF
#define MCI_MR_CLKDIV_BIT 0
#define MCI_MR_PWSDIV_MASK 0x300
#define MCI_MR_PWSDIV_BIT 8
#define MCI_MR_PDCPADV_MASK 0x4000
#define MCI_MR_PDCPADV 0x4000
#define MCI_MR_PDCPADV_BIT 14
#define MCI_MR_PDCMODE_MASK 0x8000
#define MCI_MR_PDCMODE 0x8000
#define MCI_MR_PDCMODE_BIT 15
#define MCI_MR_BLKLEN_MASK 0x3FFC0000
#define MCI_MR_BLKLEN_BIT 18

#define MCI_DTOR (*(volatile unsigned long *)0xFFFB4008)
#define MCI_DTOR_OFFSET 0x8
#define MCI_DTOR_DTOCYC_MASK 0xF
#define MCI_DTOR_DTOCYC_BIT 0
#define MCI_DTOR_DTOMUL_MASK 0x70
#define MCI_DTOR_DTOMUL_BIT 4

#define MCI_SDCR (*(volatile unsigned long *)0xFFFB400C)
#define MCI_SDCR_OFFSET 0xC
#define MCI_SDCR_SDCSEL_MASK 0xF
#define MCI_SDCR_SDCSEL_BIT 0
#define MCI_SDCR_SDCBUS_MASK 0x80
#define MCI_SDCR_SDCBUS 0x80
#define MCI_SDCR_SDCBUS_BIT 7

#define MCI_ARGR (*(volatile unsigned long *)0xFFFB4010)
#define MCI_ARGR_OFFSET 0x10

#define MCI_CMDR (*(volatile unsigned long *)0xFFFB4014)
#define MCI_CMDR_OFFSET 0x14
#define MCI_CMDR_CMDNB_MASK 0x3F
#define MCI_CMDR_CMDNB_BIT 0
#define MCI_CMDR_RSPTYP_MASK 0xC0
#define MCI_CMDR_RSPTYP_BIT 6
#define MCI_CMDR_SPCMD_MASK 0x700
#define MCI_CMDR_SPCMD_BIT 8
#define MCI_CMDR_OPDCMD_MASK 0x800
#define MCI_CMDR_OPDCMD 0x800
#define MCI_CMDR_OPDCMD_BIT 11
#define MCI_CMDR_MAXLAT_MASK 0x1000
#define MCI_CMDR_MAXLAT 0x1000
#define MCI_CMDR_MAXLAT_BIT 12
#define MCI_CMDR_TRCMD_MASK 0x30000
#define MCI_CMDR_TRCMD_BIT 16
#define MCI_CMDR_TRDIR_MASK 0x40000
#define MCI_CMDR_TRDIR 0x40000
#define MCI_CMDR_TRDIR_BIT 18
#define MCI_CMDR_TRTYPE_MASK 0x80000
#define MCI_CMDR_TRTYPE 0x80000
#define MCI_CMDR_TRTYPE_BIT 19

#define MCI_RSPR0 (*(volatile unsigned long *)0xFFFB4020)
#define MCI_RSPR0_OFFSET 0x20

#define MCI_RSPR1 (*(volatile unsigned long *)0xFFFB4024)
#define MCI_RSPR1_OFFSET 0x24

#define MCI_RSPR2 (*(volatile unsigned long *)0xFFFB4028)
#define MCI_RSPR2_OFFSET 0x28

#define MCI_RSPR3 (*(volatile unsigned long *)0xFFFB402C)
#define MCI_RSPR3_OFFSET 0x2C

#define MCI_RDR (*(volatile unsigned long *)0xFFFB4030)
#define MCI_RDR_OFFSET 0x30

#define MCI_TDR (*(volatile unsigned long *)0xFFFB4034)
#define MCI_TDR_OFFSET 0x34

#define MCI_SR (*(volatile unsigned long *)0xFFFB4040)
#define MCI_SR_OFFSET 0x40
#define MCI_SR_CMDRDY_MASK 0x1
#define MCI_SR_CMDRDY 0x1
#define MCI_SR_CMDRDY_BIT 0
#define MCI_SR_RXRDY_MASK 0x2
#define MCI_SR_RXRDY 0x2
#define MCI_SR_RXRDY_BIT 1
#define MCI_SR_TXRDY_MASK 0x4
#define MCI_SR_TXRDY 0x4
#define MCI_SR_TXRDY_BIT 2
#define MCI_SR_BLKE_MASK 0x8
#define MCI_SR_BLKE 0x8
#define MCI_SR_BLKE_BIT 3
#define MCI_SR_DTIP_MASK 0x10
#define MCI_SR_DTIP 0x10
#define MCI_SR_DTIP_BIT 4
#define MCI_SR_NOTBUSY_MASK 0x20
#define MCI_SR_NOTBUSY 0x20
#define MCI_SR_NOTBUSY_BIT 5
#define MCI_SR_ENDRX_MASK 0x40
#define MCI_SR_ENDRX 0x40
#define MCI_SR_ENDRX_BIT 6
#define MCI_SR_ENDTX_MASK 0x80
#define MCI_SR_ENDTX 0x80
#define MCI_SR_ENDTX_BIT 7
#define MCI_SR_RXBUFF_MASK 0x4000
#define MCI_SR_RXBUFF 0x4000
#define MCI_SR_RXBUFF_BIT 14
#define MCI_SR_TXBUFE_MASK 0x8000
#define MCI_SR_TXBUFE 0x8000
#define MCI_SR_TXBUFE_BIT 15
#define MCI_SR_RINDE_MASK 0x10000
#define MCI_SR_RINDE 0x10000
#define MCI_SR_RINDE_BIT 16
#define MCI_SR_RDIRE_MASK 0x20000
#define MCI_SR_RDIRE 0x20000
#define MCI_SR_RDIRE_BIT 17
#define MCI_SR_RCRCE_MASK 0x40000
#define MCI_SR_RCRCE 0x40000
#define MCI_SR_RCRCE_BIT 18
#define MCI_SR_RENDE_MASK 0x80000
#define MCI_SR_RENDE 0x80000
#define MCI_SR_RENDE_BIT 19
#define MCI_SR_RTOE_MASK 0x100000
#define MCI_SR_RTOE 0x100000
#define MCI_SR_RTOE_BIT 20
#define MCI_SR_TCRCE_MASK 0x200000
#define MCI_SR_TCRCE 0x200000
#define MCI_SR_TCRCE_BIT 21
#define MCI_SR_DTOE_MASK 0x400000
#define MCI_SR_DTOE 0x400000
#define MCI_SR_DTOE_BIT 22
#define MCI_SR_OVRE_MASK 0x40000000
#define MCI_SR_OVRE 0x40000000
#define MCI_SR_OVRE_BIT 30
#define MCI_SR_UNRE_MASK 0x80000000
#define MCI_SR_UNRE 0x80000000
#define MCI_SR_UNRE_BIT 31

#define MCI_IER (*(volatile unsigned long *)0xFFFB4044)
#define MCI_IER_OFFSET 0x44
#define MCI_IER_CMDRDY_MASK 0x1
#define MCI_IER_CMDRDY 0x1
#define MCI_IER_CMDRDY_BIT 0
#define MCI_IER_RXRDY_MASK 0x2
#define MCI_IER_RXRDY 0x2
#define MCI_IER_RXRDY_BIT 1
#define MCI_IER_TXRDY_MASK 0x4
#define MCI_IER_TXRDY 0x4
#define MCI_IER_TXRDY_BIT 2
#define MCI_IER_BLKE_MASK 0x8
#define MCI_IER_BLKE 0x8
#define MCI_IER_BLKE_BIT 3
#define MCI_IER_DTIP_MASK 0x10
#define MCI_IER_DTIP 0x10
#define MCI_IER_DTIP_BIT 4
#define MCI_IER_NOTBUSY_MASK 0x20
#define MCI_IER_NOTBUSY 0x20
#define MCI_IER_NOTBUSY_BIT 5
#define MCI_IER_ENDRX_MASK 0x40
#define MCI_IER_ENDRX 0x40
#define MCI_IER_ENDRX_BIT 6
#define MCI_IER_ENDTX_MASK 0x80
#define MCI_IER_ENDTX 0x80
#define MCI_IER_ENDTX_BIT 7
#define MCI_IER_RXBUFF_MASK 0x4000
#define MCI_IER_RXBUFF 0x4000
#define MCI_IER_RXBUFF_BIT 14
#define MCI_IER_TXBUFE_MASK 0x8000
#define MCI_IER_TXBUFE 0x8000
#define MCI_IER_TXBUFE_BIT 15
#define MCI_IER_RINDE_MASK 0x10000
#define MCI_IER_RINDE 0x10000
#define MCI_IER_RINDE_BIT 16
#define MCI_IER_RDIRE_MASK 0x20000
#define MCI_IER_RDIRE 0x20000
#define MCI_IER_RDIRE_BIT 17
#define MCI_IER_RCRCE_MASK 0x40000
#define MCI_IER_RCRCE 0x40000
#define MCI_IER_RCRCE_BIT 18
#define MCI_IER_RENDE_MASK 0x80000
#define MCI_IER_RENDE 0x80000
#define MCI_IER_RENDE_BIT 19
#define MCI_IER_RTOE_MASK 0x100000
#define MCI_IER_RTOE 0x100000
#define MCI_IER_RTOE_BIT 20
#define MCI_IER_TCRCE_MASK 0x200000
#define MCI_IER_TCRCE 0x200000
#define MCI_IER_TCRCE_BIT 21
#define MCI_IER_DTOE_MASK 0x400000
#define MCI_IER_DTOE 0x400000
#define MCI_IER_DTOE_BIT 22
#define MCI_IER_OVRE_MASK 0x40000000
#define MCI_IER_OVRE 0x40000000
#define MCI_IER_OVRE_BIT 30
#define MCI_IER_UNRE_MASK 0x80000000
#define MCI_IER_UNRE 0x80000000
#define MCI_IER_UNRE_BIT 31

#define MCI_IDR (*(volatile unsigned long *)0xFFFB4048)
#define MCI_IDR_OFFSET 0x48
#define MCI_IDR_CMDRDY_MASK 0x1
#define MCI_IDR_CMDRDY 0x1
#define MCI_IDR_CMDRDY_BIT 0
#define MCI_IDR_RXRDY_MASK 0x2
#define MCI_IDR_RXRDY 0x2
#define MCI_IDR_RXRDY_BIT 1
#define MCI_IDR_TXRDY_MASK 0x4
#define MCI_IDR_TXRDY 0x4
#define MCI_IDR_TXRDY_BIT 2
#define MCI_IDR_BLKE_MASK 0x8
#define MCI_IDR_BLKE 0x8
#define MCI_IDR_BLKE_BIT 3
#define MCI_IDR_DTIP_MASK 0x10
#define MCI_IDR_DTIP 0x10
#define MCI_IDR_DTIP_BIT 4
#define MCI_IDR_NOTBUSY_MASK 0x20
#define MCI_IDR_NOTBUSY 0x20
#define MCI_IDR_NOTBUSY_BIT 5
#define MCI_IDR_ENDRX_MASK 0x40
#define MCI_IDR_ENDRX 0x40
#define MCI_IDR_ENDRX_BIT 6
#define MCI_IDR_ENDTX_MASK 0x80
#define MCI_IDR_ENDTX 0x80
#define MCI_IDR_ENDTX_BIT 7
#define MCI_IDR_RXBUFF_MASK 0x4000
#define MCI_IDR_RXBUFF 0x4000
#define MCI_IDR_RXBUFF_BIT 14
#define MCI_IDR_TXBUFE_MASK 0x8000
#define MCI_IDR_TXBUFE 0x8000
#define MCI_IDR_TXBUFE_BIT 15
#define MCI_IDR_RINDE_MASK 0x10000
#define MCI_IDR_RINDE 0x10000
#define MCI_IDR_RINDE_BIT 16
#define MCI_IDR_RDIRE_MASK 0x20000
#define MCI_IDR_RDIRE 0x20000
#define MCI_IDR_RDIRE_BIT 17
#define MCI_IDR_RCRCE_MASK 0x40000
#define MCI_IDR_RCRCE 0x40000
#define MCI_IDR_RCRCE_BIT 18
#define MCI_IDR_RENDE_MASK 0x80000
#define MCI_IDR_RENDE 0x80000
#define MCI_IDR_RENDE_BIT 19
#define MCI_IDR_RTOE_MASK 0x100000
#define MCI_IDR_RTOE 0x100000
#define MCI_IDR_RTOE_BIT 20
#define MCI_IDR_TCRCE_MASK 0x200000
#define MCI_IDR_TCRCE 0x200000
#define MCI_IDR_TCRCE_BIT 21
#define MCI_IDR_DTOE_MASK 0x400000
#define MCI_IDR_DTOE 0x400000
#define MCI_IDR_DTOE_BIT 22
#define MCI_IDR_OVRE_MASK 0x40000000
#define MCI_IDR_OVRE 0x40000000
#define MCI_IDR_OVRE_BIT 30
#define MCI_IDR_UNRE_MASK 0x80000000
#define MCI_IDR_UNRE 0x80000000
#define MCI_IDR_UNRE_BIT 31

#define MCI_IMR (*(volatile unsigned long *)0xFFFB404C)
#define MCI_IMR_OFFSET 0x4C
#define MCI_IMR_CMDRDY_MASK 0x1
#define MCI_IMR_CMDRDY 0x1
#define MCI_IMR_CMDRDY_BIT 0
#define MCI_IMR_RXRDY_MASK 0x2
#define MCI_IMR_RXRDY 0x2
#define MCI_IMR_RXRDY_BIT 1
#define MCI_IMR_TXRDY_MASK 0x4
#define MCI_IMR_TXRDY 0x4
#define MCI_IMR_TXRDY_BIT 2
#define MCI_IMR_BLKE_MASK 0x8
#define MCI_IMR_BLKE 0x8
#define MCI_IMR_BLKE_BIT 3
#define MCI_IMR_DTIP_MASK 0x10
#define MCI_IMR_DTIP 0x10
#define MCI_IMR_DTIP_BIT 4
#define MCI_IMR_NOTBUSY_MASK 0x20
#define MCI_IMR_NOTBUSY 0x20
#define MCI_IMR_NOTBUSY_BIT 5
#define MCI_IMR_ENDRX_MASK 0x40
#define MCI_IMR_ENDRX 0x40
#define MCI_IMR_ENDRX_BIT 6
#define MCI_IMR_ENDTX_MASK 0x80
#define MCI_IMR_ENDTX 0x80
#define MCI_IMR_ENDTX_BIT 7
#define MCI_IMR_RXBUFF_MASK 0x4000
#define MCI_IMR_RXBUFF 0x4000
#define MCI_IMR_RXBUFF_BIT 14
#define MCI_IMR_TXBUFE_MASK 0x8000
#define MCI_IMR_TXBUFE 0x8000
#define MCI_IMR_TXBUFE_BIT 15
#define MCI_IMR_RINDE_MASK 0x10000
#define MCI_IMR_RINDE 0x10000
#define MCI_IMR_RINDE_BIT 16
#define MCI_IMR_RDIRE_MASK 0x20000
#define MCI_IMR_RDIRE 0x20000
#define MCI_IMR_RDIRE_BIT 17
#define MCI_IMR_RCRCE_MASK 0x40000
#define MCI_IMR_RCRCE 0x40000
#define MCI_IMR_RCRCE_BIT 18
#define MCI_IMR_RENDE_MASK 0x80000
#define MCI_IMR_RENDE 0x80000
#define MCI_IMR_RENDE_BIT 19
#define MCI_IMR_RTOE_MASK 0x100000
#define MCI_IMR_RTOE 0x100000
#define MCI_IMR_RTOE_BIT 20
#define MCI_IMR_TCRCE_MASK 0x200000
#define MCI_IMR_TCRCE 0x200000
#define MCI_IMR_TCRCE_BIT 21
#define MCI_IMR_DTOE_MASK 0x400000
#define MCI_IMR_DTOE 0x400000
#define MCI_IMR_DTOE_BIT 22
#define MCI_IMR_OVRE_MASK 0x40000000
#define MCI_IMR_OVRE 0x40000000
#define MCI_IMR_OVRE_BIT 30
#define MCI_IMR_UNRE_MASK 0x80000000
#define MCI_IMR_UNRE 0x80000000
#define MCI_IMR_UNRE_BIT 31

#define MCI_RPR (*(volatile unsigned long *)0xFFFB4100)
#define MCI_RPR_OFFSET 0x100

#define MCI_RCR (*(volatile unsigned long *)0xFFFB4104)
#define MCI_RCR_OFFSET 0x104

#define MCI_TPR (*(volatile unsigned long *)0xFFFB4108)
#define MCI_TPR_OFFSET 0x108

#define MCI_TCR (*(volatile unsigned long *)0xFFFB410C)
#define MCI_TCR_OFFSET 0x10C

#define MCI_RNPR (*(volatile unsigned long *)0xFFFB4110)
#define MCI_RNPR_OFFSET 0x110

#define MCI_RNCR (*(volatile unsigned long *)0xFFFB4114)
#define MCI_RNCR_OFFSET 0x114

#define MCI_TNPR (*(volatile unsigned long *)0xFFFB4118)
#define MCI_TNPR_OFFSET 0x118

#define MCI_TNCR (*(volatile unsigned long *)0xFFFB411C)
#define MCI_TNCR_OFFSET 0x11C

#define MCI_PTCR (*(volatile unsigned long *)0xFFFB4120)
#define MCI_PTCR_OFFSET 0x120
#define MCI_PTCR_RXTEN_MASK 0x1
#define MCI_PTCR_RXTEN 0x1
#define MCI_PTCR_RXTEN_BIT 0
#define MCI_PTCR_RXTDIS_MASK 0x2
#define MCI_PTCR_RXTDIS 0x2
#define MCI_PTCR_RXTDIS_BIT 1
#define MCI_PTCR_TXTEN_MASK 0x100
#define MCI_PTCR_TXTEN 0x100
#define MCI_PTCR_TXTEN_BIT 8
#define MCI_PTCR_TXTDIS_MASK 0x200
#define MCI_PTCR_TXTDIS 0x200
#define MCI_PTCR_TXTDIS_BIT 9

#define MCI_PTSR (*(volatile unsigned long *)0xFFFB4124)
#define MCI_PTSR_OFFSET 0x124
#define MCI_PTSR_RXTEN_MASK 0x1
#define MCI_PTSR_RXTEN 0x1
#define MCI_PTSR_RXTEN_BIT 0
#define MCI_PTSR_TXTEN_MASK 0x100
#define MCI_PTSR_TXTEN 0x100
#define MCI_PTSR_TXTEN_BIT 8

#define TWI_BASE 0xFFFB8000

#define TWI_CR (*(volatile unsigned long *)0xFFFB8000)
#define TWI_CR_OFFSET 0x0
#define TWI_CR_START_MASK 0x1
#define TWI_CR_START 0x1
#define TWI_CR_START_BIT 0
#define TWI_CR_STOP_MASK 0x2
#define TWI_CR_STOP 0x2
#define TWI_CR_STOP_BIT 1
#define TWI_CR_MSEN_MASK 0x4
#define TWI_CR_MSEN 0x4
#define TWI_CR_MSEN_BIT 2
#define TWI_CR_MSDIS_MASK 0x8
#define TWI_CR_MSDIS 0x8
#define TWI_CR_MSDIS_BIT 3
#define TWI_CR_SWRST_MASK 0x80
#define TWI_CR_SWRST 0x80
#define TWI_CR_SWRST_BIT 7

#define TWI_MMR (*(volatile unsigned long *)0xFFFB8004)
#define TWI_MMR_OFFSET 0x4
#define TWI_MMR_IADRSZ_MASK 0x300
#define TWI_MMR_IADRSZ_BIT 8
#define TWI_MMR_MREAD_MASK 0x1000
#define TWI_MMR_MREAD 0x1000
#define TWI_MMR_MREAD_BIT 12
#define TWI_MMR_DADR_MASK 0x7F0000
#define TWI_MMR_DADR_BIT 16

#define TWI_IADR (*(volatile unsigned long *)0xFFFB800C)
#define TWI_IADR_OFFSET 0xC

#define TWI_CWGR (*(volatile unsigned long *)0xFFFB8010)
#define TWI_CWGR_OFFSET 0x10

#define TWI_SR (*(volatile unsigned long *)0xFFFB8020)
#define TWI_SR_OFFSET 0x20
#define TWI_SR_TXCOMP_MASK 0x1
#define TWI_SR_TXCOMP 0x1
#define TWI_SR_TXCOMP_BIT 0
#define TWI_SR_RXRDY_MASK 0x2
#define TWI_SR_RXRDY 0x2
#define TWI_SR_RXRDY_BIT 1
#define TWI_SR_TXRDY_MASK 0x4
#define TWI_SR_TXRDY 0x4
#define TWI_SR_TXRDY_BIT 2
#define TWI_SR_OVRE_MASK 0x40
#define TWI_SR_OVRE 0x40
#define TWI_SR_OVRE_BIT 6
#define TWI_SR_UNRE_MASK 0x80
#define TWI_SR_UNRE 0x80
#define TWI_SR_UNRE_BIT 7
#define TWI_SR_NACK_MASK 0x100
#define TWI_SR_NACK 0x100
#define TWI_SR_NACK_BIT 8

#define TWI_IER (*(volatile unsigned long *)0xFFFB8024)
#define TWI_IER_OFFSET 0x24
#define TWI_IER_TXCOMP_MASK 0x1
#define TWI_IER_TXCOMP 0x1
#define TWI_IER_TXCOMP_BIT 0
#define TWI_IER_RXRDY_MASK 0x2
#define TWI_IER_RXRDY 0x2
#define TWI_IER_RXRDY_BIT 1
#define TWI_IER_TXRDY_MASK 0x4
#define TWI_IER_TXRDY 0x4
#define TWI_IER_TXRDY_BIT 2
#define TWI_IER_OVRE_MASK 0x40
#define TWI_IER_OVRE 0x40
#define TWI_IER_OVRE_BIT 6
#define TWI_IER_UNRE_MASK 0x80
#define TWI_IER_UNRE 0x80
#define TWI_IER_UNRE_BIT 7
#define TWI_IER_NACK_MASK 0x100
#define TWI_IER_NACK 0x100
#define TWI_IER_NACK_BIT 8

#define TWI_IDR (*(volatile unsigned long *)0xFFFB8028)
#define TWI_IDR_OFFSET 0x28
#define TWI_IDR_TXCOMP_MASK 0x1
#define TWI_IDR_TXCOMP 0x1
#define TWI_IDR_TXCOMP_BIT 0
#define TWI_IDR_RXRDY_MASK 0x2
#define TWI_IDR_RXRDY 0x2
#define TWI_IDR_RXRDY_BIT 1
#define TWI_IDR_TXRDY_MASK 0x4
#define TWI_IDR_TXRDY 0x4
#define TWI_IDR_TXRDY_BIT 2
#define TWI_IDR_OVRE_MASK 0x40
#define TWI_IDR_OVRE 0x40
#define TWI_IDR_OVRE_BIT 6
#define TWI_IDR_UNRE_MASK 0x80
#define TWI_IDR_UNRE 0x80
#define TWI_IDR_UNRE_BIT 7
#define TWI_IDR_NACK_MASK 0x100
#define TWI_IDR_NACK 0x100
#define TWI_IDR_NACK_BIT 8

#define TWI_IMR (*(volatile unsigned long *)0xFFFB802C)
#define TWI_IMR_OFFSET 0x2C
#define TWI_IMR_TXCOMP_MASK 0x1
#define TWI_IMR_TXCOMP 0x1
#define TWI_IMR_TXCOMP_BIT 0
#define TWI_IMR_RXRDY_MASK 0x2
#define TWI_IMR_RXRDY 0x2
#define TWI_IMR_RXRDY_BIT 1
#define TWI_IMR_TXRDY_MASK 0x4
#define TWI_IMR_TXRDY 0x4
#define TWI_IMR_TXRDY_BIT 2
#define TWI_IMR_OVRE_MASK 0x40
#define TWI_IMR_OVRE 0x40
#define TWI_IMR_OVRE_BIT 6
#define TWI_IMR_UNRE_MASK 0x80
#define TWI_IMR_UNRE 0x80
#define TWI_IMR_UNRE_BIT 7
#define TWI_IMR_NACK_MASK 0x100
#define TWI_IMR_NACK 0x100
#define TWI_IMR_NACK_BIT 8

#define TWI_RHR (*(volatile unsigned long *)0xFFFB8030)
#define TWI_RHR_OFFSET 0x30
#define TWI_RHR_RXDATA_MASK 0xFF
#define TWI_RHR_RXDATA_BIT 0

#define TWI_THR (*(volatile unsigned long *)0xFFFB8034)
#define TWI_THR_OFFSET 0x34
#define TWI_THR_TXDATA_MASK 0xFF
#define TWI_THR_TXDATA_BIT 0

#define ETH_BASE 0xFFFBC000

#define ETH_CTL (*(volatile unsigned long *)0xFFFBC000)
#define ETH_CTL_OFFSET 0x0
#define ETH_CTL_LB_MASK 0x1
#define ETH_CTL_LB 0x1
#define ETH_CTL_LB_BIT 0
#define ETH_CTL_LBL_MASK 0x2
#define ETH_CTL_LBL 0x2
#define ETH_CTL_LBL_BIT 1
#define ETH_CTL_RE_MASK 0x4
#define ETH_CTL_RE 0x4
#define ETH_CTL_RE_BIT 2
#define ETH_CTL_TE_MASK 0x8
#define ETH_CTL_TE 0x8
#define ETH_CTL_TE_BIT 3
#define ETH_CTL_MPE_MASK 0x10
#define ETH_CTL_MPE 0x10
#define ETH_CTL_MPE_BIT 4
#define ETH_CTL_CSR_MASK 0x20
#define ETH_CTL_CSR 0x20
#define ETH_CTL_CSR_BIT 5
#define ETH_CTL_ISR_MASK 0x40
#define ETH_CTL_ISR 0x40
#define ETH_CTL_ISR_BIT 6
#define ETH_CTL_WES_MASK 0x80
#define ETH_CTL_WES 0x80
#define ETH_CTL_WES_BIT 7
#define ETH_CTL_BP_MASK 0x100
#define ETH_CTL_BP 0x100
#define ETH_CTL_BP_BIT 8

#define ETH_CFG (*(volatile unsigned long *)0xFFFBC004)
#define ETH_CFG_OFFSET 0x4
#define ETH_CFG_SPD_MASK 0x1
#define ETH_CFG_SPD 0x1
#define ETH_CFG_SPD_BIT 0
#define ETH_CFG_FD_MASK 0x2
#define ETH_CFG_FD 0x2
#define ETH_CFG_FD_BIT 1
#define ETH_CFG_BR_MASK 0x4
#define ETH_CFG_BR 0x4
#define ETH_CFG_BR_BIT 2
#define ETH_CFG_CAF_MASK 0x10
#define ETH_CFG_CAF 0x10
#define ETH_CFG_CAF_BIT 4
#define ETH_CFG_NBC_MASK 0x20
#define ETH_CFG_NBC 0x20
#define ETH_CFG_NBC_BIT 5
#define ETH_CFG_MTI_MASK 0x40
#define ETH_CFG_MTI 0x40
#define ETH_CFG_MTI_BIT 6
#define ETH_CFG_UNI_MASK 0x80
#define ETH_CFG_UNI 0x80
#define ETH_CFG_UNI_BIT 7
#define ETH_CFG_BIG_MASK 0x100
#define ETH_CFG_BIG 0x100
#define ETH_CFG_BIG_BIT 8
#define ETH_CFG_EAE_MASK 0x200
#define ETH_CFG_EAE 0x200
#define ETH_CFG_EAE_BIT 9
#define ETH_CFG_CLK_MASK 0xC00
#define ETH_CFG_CLK_BIT 10
#define ETH_CFG_RTY_MASK 0x1000
#define ETH_CFG_RTY 0x1000
#define ETH_CFG_RTY_BIT 12
#define ETH_CFG_RMII_MASK 0x2000
#define ETH_CFG_RMII 0x2000
#define ETH_CFG_RMII_BIT 13

#define ETH_SR (*(volatile unsigned long *)0xFFFBC008)
#define ETH_SR_OFFSET 0x8
#define ETH_SR_LINK_MASK 0x1
#define ETH_SR_LINK 0x1
#define ETH_SR_LINK_BIT 0
#define ETH_SR_MDIO_MASK 0x2
#define ETH_SR_MDIO 0x2
#define ETH_SR_MDIO_BIT 1
#define ETH_SR_IDLE_MASK 0x4
#define ETH_SR_IDLE 0x4
#define ETH_SR_IDLE_BIT 2

#define ETH_TAR (*(volatile unsigned long *)0xFFFBC00C)
#define ETH_TAR_OFFSET 0xC

#define ETH_TCR (*(volatile unsigned long *)0xFFFBC010)
#define ETH_TCR_OFFSET 0x10
#define ETH_TCR_LEN_MASK 0x7FF
#define ETH_TCR_LEN_BIT 0
#define ETH_TCR_NCRC_MASK 0x8000
#define ETH_TCR_NCRC 0x8000
#define ETH_TCR_NCRC_BIT 15

#define ETH_TSR (*(volatile unsigned long *)0xFFFBC014)
#define ETH_TSR_OFFSET 0x14
#define ETH_TSR_OVR_MASK 0x1
#define ETH_TSR_OVR 0x1
#define ETH_TSR_OVR_BIT 0
#define ETH_TSR_COL_MASK 0x2
#define ETH_TSR_COL 0x2
#define ETH_TSR_COL_BIT 1
#define ETH_TSR_RLE_MASK 0x4
#define ETH_TSR_RLE 0x4
#define ETH_TSR_RLE_BIT 2
#define ETH_TSR_IDLE_MASK 0x8
#define ETH_TSR_IDLE 0x8
#define ETH_TSR_IDLE_BIT 3
#define ETH_TSR_BNQ_MASK 0x10
#define ETH_TSR_BNQ 0x10
#define ETH_TSR_BNQ_BIT 4
#define ETH_TSR_COMP_MASK 0x20
#define ETH_TSR_COMP 0x20
#define ETH_TSR_COMP_BIT 5
#define ETH_TSR_UND_MASK 0x40
#define ETH_TSR_UND 0x40
#define ETH_TSR_UND_BIT 6

#define ETH_RBQP (*(volatile unsigned long *)0xFFFBC018)
#define ETH_RBQP_OFFSET 0x18

#define ETH_RSR (*(volatile unsigned long *)0xFFFBC020)
#define ETH_RSR_OFFSET 0x20
#define ETH_RSR_BNA_MASK 0x1
#define ETH_RSR_BNA 0x1
#define ETH_RSR_BNA_BIT 0
#define ETH_RSR_REC_MASK 0x2
#define ETH_RSR_REC 0x2
#define ETH_RSR_REC_BIT 1
#define ETH_RSR_OVR_MASK 0x4
#define ETH_RSR_OVR 0x4
#define ETH_RSR_OVR_BIT 2

#define ETH_ISR (*(volatile unsigned long *)0xFFFBC024)
#define ETH_ISR_OFFSET 0x24
#define ETH_ISR_DONE_MASK 0x1
#define ETH_ISR_DONE 0x1
#define ETH_ISR_DONE_BIT 0
#define ETH_ISR_RCOM_MASK 0x2
#define ETH_ISR_RCOM 0x2
#define ETH_ISR_RCOM_BIT 1
#define ETH_ISR_RBNA_MASK 0x4
#define ETH_ISR_RBNA 0x4
#define ETH_ISR_RBNA_BIT 2
#define ETH_ISR_TOVR_MASK 0x8
#define ETH_ISR_TOVR 0x8
#define ETH_ISR_TOVR_BIT 3
#define ETH_ISR_TUND_MASK 0x10
#define ETH_ISR_TUND 0x10
#define ETH_ISR_TUND_BIT 4
#define ETH_ISR_RTRY_MASK 0x20
#define ETH_ISR_RTRY 0x20
#define ETH_ISR_RTRY_BIT 5
#define ETH_ISR_TBRE_MASK 0x40
#define ETH_ISR_TBRE 0x40
#define ETH_ISR_TBRE_BIT 6
#define ETH_ISR_TCOM_MASK 0x80
#define ETH_ISR_TCOM 0x80
#define ETH_ISR_TCOM_BIT 7
#define ETH_ISR_TIDLE_MASK 0x100
#define ETH_ISR_TIDLE 0x100
#define ETH_ISR_TIDLE_BIT 8
#define ETH_ISR_LINK_MASK 0x200
#define ETH_ISR_LINK 0x200
#define ETH_ISR_LINK_BIT 9
#define ETH_ISR_ROVR_MASK 0x400
#define ETH_ISR_ROVR 0x400
#define ETH_ISR_ROVR_BIT 10
#define ETH_ISR_ABT_MASK 0x800
#define ETH_ISR_ABT 0x800
#define ETH_ISR_ABT_BIT 11

#define ETH_IER (*(volatile unsigned long *)0xFFFBC028)
#define ETH_IER_OFFSET 0x28
#define ETH_IER_DONE_MASK 0x1
#define ETH_IER_DONE 0x1
#define ETH_IER_DONE_BIT 0
#define ETH_IER_RCOM_MASK 0x2
#define ETH_IER_RCOM 0x2
#define ETH_IER_RCOM_BIT 1
#define ETH_IER_RBNA_MASK 0x4
#define ETH_IER_RBNA 0x4
#define ETH_IER_RBNA_BIT 2
#define ETH_IER_TOVR_MASK 0x8
#define ETH_IER_TOVR 0x8
#define ETH_IER_TOVR_BIT 3
#define ETH_IER_TUND_MASK 0x10
#define ETH_IER_TUND 0x10
#define ETH_IER_TUND_BIT 4
#define ETH_IER_RTRY_MASK 0x20
#define ETH_IER_RTRY 0x20
#define ETH_IER_RTRY_BIT 5
#define ETH_IER_TBRE_MASK 0x40
#define ETH_IER_TBRE 0x40
#define ETH_IER_TBRE_BIT 6
#define ETH_IER_TCOM_MASK 0x80
#define ETH_IER_TCOM 0x80
#define ETH_IER_TCOM_BIT 7
#define ETH_IER_TIDLE_MASK 0x100
#define ETH_IER_TIDLE 0x100
#define ETH_IER_TIDLE_BIT 8
#define ETH_IER_LINK_MASK 0x200
#define ETH_IER_LINK 0x200
#define ETH_IER_LINK_BIT 9
#define ETH_IER_ROVR_MASK 0x400
#define ETH_IER_ROVR 0x400
#define ETH_IER_ROVR_BIT 10
#define ETH_IER_ABT_MASK 0x800
#define ETH_IER_ABT 0x800
#define ETH_IER_ABT_BIT 11

#define ETH_IDR (*(volatile unsigned long *)0xFFFBC02C)
#define ETH_IDR_OFFSET 0x2C
#define ETH_IDR_DONE_MASK 0x1
#define ETH_IDR_DONE 0x1
#define ETH_IDR_DONE_BIT 0
#define ETH_IDR_RCOM_MASK 0x2
#define ETH_IDR_RCOM 0x2
#define ETH_IDR_RCOM_BIT 1
#define ETH_IDR_RBNA_MASK 0x4
#define ETH_IDR_RBNA 0x4
#define ETH_IDR_RBNA_BIT 2
#define ETH_IDR_TOVR_MASK 0x8
#define ETH_IDR_TOVR 0x8
#define ETH_IDR_TOVR_BIT 3
#define ETH_IDR_TUND_MASK 0x10
#define ETH_IDR_TUND 0x10
#define ETH_IDR_TUND_BIT 4
#define ETH_IDR_RTRY_MASK 0x20
#define ETH_IDR_RTRY 0x20
#define ETH_IDR_RTRY_BIT 5
#define ETH_IDR_TBRE_MASK 0x40
#define ETH_IDR_TBRE 0x40
#define ETH_IDR_TBRE_BIT 6
#define ETH_IDR_TCOM_MASK 0x80
#define ETH_IDR_TCOM 0x80
#define ETH_IDR_TCOM_BIT 7
#define ETH_IDR_TIDLE_MASK 0x100
#define ETH_IDR_TIDLE 0x100
#define ETH_IDR_TIDLE_BIT 8
#define ETH_IDR_LINK_MASK 0x200
#define ETH_IDR_LINK 0x200
#define ETH_IDR_LINK_BIT 9
#define ETH_IDR_ROVR_MASK 0x400
#define ETH_IDR_ROVR 0x400
#define ETH_IDR_ROVR_BIT 10
#define ETH_IDR_ABT_MASK 0x800
#define ETH_IDR_ABT 0x800
#define ETH_IDR_ABT_BIT 11

#define ETH_IMR (*(volatile unsigned long *)0xFFFBC030)
#define ETH_IMR_OFFSET 0x30
#define ETH_IMR_DONE_MASK 0x1
#define ETH_IMR_DONE 0x1
#define ETH_IMR_DONE_BIT 0
#define ETH_IMR_RCOM_MASK 0x2
#define ETH_IMR_RCOM 0x2
#define ETH_IMR_RCOM_BIT 1
#define ETH_IMR_RBNA_MASK 0x4
#define ETH_IMR_RBNA 0x4
#define ETH_IMR_RBNA_BIT 2
#define ETH_IMR_TOVR_MASK 0x8
#define ETH_IMR_TOVR 0x8
#define ETH_IMR_TOVR_BIT 3
#define ETH_IMR_TUND_MASK 0x10
#define ETH_IMR_TUND 0x10
#define ETH_IMR_TUND_BIT 4
#define ETH_IMR_RTRY_MASK 0x20
#define ETH_IMR_RTRY 0x20
#define ETH_IMR_RTRY_BIT 5
#define ETH_IMR_TBRE_MASK 0x40
#define ETH_IMR_TBRE 0x40
#define ETH_IMR_TBRE_BIT 6
#define ETH_IMR_TCOM_MASK 0x80
#define ETH_IMR_TCOM 0x80
#define ETH_IMR_TCOM_BIT 7
#define ETH_IMR_TIDLE_MASK 0x100
#define ETH_IMR_TIDLE 0x100
#define ETH_IMR_TIDLE_BIT 8
#define ETH_IMR_LINK_MASK 0x200
#define ETH_IMR_LINK 0x200
#define ETH_IMR_LINK_BIT 9
#define ETH_IMR_ROVR_MASK 0x400
#define ETH_IMR_ROVR 0x400
#define ETH_IMR_ROVR_BIT 10
#define ETH_IMR_ABT_MASK 0x800
#define ETH_IMR_ABT 0x800
#define ETH_IMR_ABT_BIT 11

#define ETH_MAN (*(volatile unsigned long *)0xFFFBC034)
#define ETH_MAN_OFFSET 0x34
#define ETH_MAN_DATA_MASK 0xFFFF
#define ETH_MAN_DATA_BIT 0
#define ETH_MAN_CODE_MASK 0x30000
#define ETH_MAN_CODE_BIT 16
#define ETH_MAN_REGA_MASK 0x7C0000
#define ETH_MAN_REGA_BIT 18
#define ETH_MAN_PHYA_MASK 0xF800000
#define ETH_MAN_PHYA_BIT 23
#define ETH_MAN_RW_MASK 0x30000000
#define ETH_MAN_RW_BIT 28
#define ETH_MAN_HIGH_MASK 0x40000000
#define ETH_MAN_HIGH 0x40000000
#define ETH_MAN_HIGH_BIT 30
#define ETH_MAN_LOW_MASK 0x80000000
#define ETH_MAN_LOW 0x80000000
#define ETH_MAN_LOW_BIT 31

#define ETH_FRA (*(volatile unsigned long *)0xFFFBC040)
#define ETH_FRA_OFFSET 0x40

#define ETH_SCOL (*(volatile unsigned long *)0xFFFBC044)
#define ETH_SCOL_OFFSET 0x44

#define ETH_MCOL (*(volatile unsigned long *)0xFFFBC048)
#define ETH_MCOL_OFFSET 0x48

#define ETH_OK (*(volatile unsigned long *)0xFFFBC04C)
#define ETH_OK_OFFSET 0x4C

#define ETH_SEQE (*(volatile unsigned long *)0xFFFBC050)
#define ETH_SEQE_OFFSET 0x50

#define ETH_ALE (*(volatile unsigned long *)0xFFFBC054)
#define ETH_ALE_OFFSET 0x54

#define ETH_DTE (*(volatile unsigned long *)0xFFFBC058)
#define ETH_DTE_OFFSET 0x58

#define ETH_LCOL (*(volatile unsigned long *)0xFFFBC05C)
#define ETH_LCOL_OFFSET 0x5C

#define ETH_ECOL (*(volatile unsigned long *)0xFFFBC060)
#define ETH_ECOL_OFFSET 0x60

#define ETH_CSE (*(volatile unsigned long *)0xFFFBC064)
#define ETH_CSE_OFFSET 0x64

#define ETH_TUE (*(volatile unsigned long *)0xFFFBC068)
#define ETH_TUE_OFFSET 0x68

#define ETH_CDE (*(volatile unsigned long *)0xFFFBC06C)
#define ETH_CDE_OFFSET 0x6C

#define ETH_ELR (*(volatile unsigned long *)0xFFFBC070)
#define ETH_ELR_OFFSET 0x70

#define ETH_RJB (*(volatile unsigned long *)0xFFFBC074)
#define ETH_RJB_OFFSET 0x74

#define ETH_USF (*(volatile unsigned long *)0xFFFBC078)
#define ETH_USF_OFFSET 0x78

#define ETH_SQEE (*(volatile unsigned long *)0xFFFBC07C)
#define ETH_SQEE_OFFSET 0x7C

#define ETH_DRFC (*(volatile unsigned long *)0xFFFBC080)
#define ETH_DRFC_OFFSET 0x80

#define ETH_HSH (*(volatile unsigned long *)0xFFFBC090)
#define ETH_HSH_OFFSET 0x90

#define ETH_HSL (*(volatile unsigned long *)0xFFFBC094)
#define ETH_HSL_OFFSET 0x94

#define ETH_SA1L (*(volatile unsigned long *)0xFFFBC098)
#define ETH_SA1L_OFFSET 0x98

#define ETH_SA1H (*(volatile unsigned long *)0xFFFBC09C)
#define ETH_SA1H_OFFSET 0x9C

#define ETH_SA2L (*(volatile unsigned long *)0xFFFBC0A0)
#define ETH_SA2L_OFFSET 0xA0

#define ETH_SA2H (*(volatile unsigned long *)0xFFFBC0A4)
#define ETH_SA2H_OFFSET 0xA4

#define ETH_SA3L (*(volatile unsigned long *)0xFFFBC0A8)
#define ETH_SA3L_OFFSET 0xA8

#define ETH_SA3H (*(volatile unsigned long *)0xFFFBC0AC)
#define ETH_SA3H_OFFSET 0xAC

#define ETH_SA4L (*(volatile unsigned long *)0xFFFBC0B0)
#define ETH_SA4L_OFFSET 0xB0

#define ETH_SA4H (*(volatile unsigned long *)0xFFFBC0B4)
#define ETH_SA4H_OFFSET 0xB4

#define USART0_BASE 0xFFFC0000

#define USART0_CR (*(volatile unsigned long *)0xFFFC0000)
#define USART0_CR_OFFSET 0x0
#define USART0_CR_RSTRX_MASK 0x4
#define USART0_CR_RSTRX 0x4
#define USART0_CR_RSTRX_BIT 2
#define USART0_CR_RSTTX_MASK 0x8
#define USART0_CR_RSTTX 0x8
#define USART0_CR_RSTTX_BIT 3
#define USART0_CR_RXEN_MASK 0x10
#define USART0_CR_RXEN 0x10
#define USART0_CR_RXEN_BIT 4
#define USART0_CR_RXDIS_MASK 0x20
#define USART0_CR_RXDIS 0x20
#define USART0_CR_RXDIS_BIT 5
#define USART0_CR_TXEN_MASK 0x40
#define USART0_CR_TXEN 0x40
#define USART0_CR_TXEN_BIT 6
#define USART0_CR_TXDIS_MASK 0x80
#define USART0_CR_TXDIS 0x80
#define USART0_CR_TXDIS_BIT 7
#define USART0_CR_RSTSTA_MASK 0x100
#define USART0_CR_RSTSTA 0x100
#define USART0_CR_RSTSTA_BIT 8
#define USART0_CR_STTBRK_MASK 0x200
#define USART0_CR_STTBRK 0x200
#define USART0_CR_STTBRK_BIT 9
#define USART0_CR_STPBRK_MASK 0x400
#define USART0_CR_STPBRK 0x400
#define USART0_CR_STPBRK_BIT 10
#define USART0_CR_STTTO_MASK 0x800
#define USART0_CR_STTTO 0x800
#define USART0_CR_STTTO_BIT 11
#define USART0_CR_SENDA_MASK 0x1000
#define USART0_CR_SENDA 0x1000
#define USART0_CR_SENDA_BIT 12
#define USART0_CR_RSTIT_MASK 0x2000
#define USART0_CR_RSTIT 0x2000
#define USART0_CR_RSTIT_BIT 13
#define USART0_CR_RSTNACK_MASK 0x4000
#define USART0_CR_RSTNACK 0x4000
#define USART0_CR_RSTNACK_BIT 14
#define USART0_CR_RETTO_MASK 0x8000
#define USART0_CR_RETTO 0x8000
#define USART0_CR_RETTO_BIT 15
#define USART0_CR_DTREN_MASK 0x10000
#define USART0_CR_DTREN 0x10000
#define USART0_CR_DTREN_BIT 16
#define USART0_CR_DTRDIS_MASK 0x20000
#define USART0_CR_DTRDIS 0x20000
#define USART0_CR_DTRDIS_BIT 17
#define USART0_CR_RTSEN_MASK 0x40000
#define USART0_CR_RTSEN 0x40000
#define USART0_CR_RTSEN_BIT 18
#define USART0_CR_RTSDIS_MASK 0x80000
#define USART0_CR_RTSDIS 0x80000
#define USART0_CR_RTSDIS_BIT 19

#define USART0_MR (*(volatile unsigned long *)0xFFFC0004)
#define USART0_MR_OFFSET 0x4
#define USART0_MR_USART_MODE_MASK 0xF
#define USART0_MR_USART_MODE_BIT 0
#define USART0_MR_USCLKS_MASK 0x30
#define USART0_MR_USCLKS_BIT 4
#define USART0_MR_CHRL_MASK 0xC0
#define USART0_MR_CHRL_BIT 6
#define USART0_MR_SYNC_MASK 0x100
#define USART0_MR_SYNC 0x100
#define USART0_MR_SYNC_BIT 8
#define USART0_MR_PAR_MASK 0xE00
#define USART0_MR_PAR_BIT 9
#define USART0_MR_NBSTOP_MASK 0x3000
#define USART0_MR_NBSTOP_BIT 12
#define USART0_MR_CHMODE_MASK 0xC000
#define USART0_MR_CHMODE_BIT 14
#define USART0_MR_MSBF_MASK 0x10000
#define USART0_MR_MSBF 0x10000
#define USART0_MR_MSBF_BIT 16
#define USART0_MR_MODE9_MASK 0x20000
#define USART0_MR_MODE9 0x20000
#define USART0_MR_MODE9_BIT 17
#define USART0_MR_CLKO_MASK 0x40000
#define USART0_MR_CLKO 0x40000
#define USART0_MR_CLKO_BIT 18
#define USART0_MR_OVER_MASK 0x80000
#define USART0_MR_OVER 0x80000
#define USART0_MR_OVER_BIT 19
#define USART0_MR_INACK_MASK 0x100000
#define USART0_MR_INACK 0x100000
#define USART0_MR_INACK_BIT 20
#define USART0_MR_DSNACK_MASK 0x200000
#define USART0_MR_DSNACK 0x200000
#define USART0_MR_DSNACK_BIT 21
#define USART0_MR_MAX_ITERATION_MASK 0x7000000
#define USART0_MR_MAX_ITERATION_BIT 24
#define USART0_MR_FILTER_MASK 0x10000000
#define USART0_MR_FILTER 0x10000000
#define USART0_MR_FILTER_BIT 28

#define USART0_IER (*(volatile unsigned long *)0xFFFC0008)
#define USART0_IER_OFFSET 0x8
#define USART0_IER_RXRDY_MASK 0x1
#define USART0_IER_RXRDY 0x1
#define USART0_IER_RXRDY_BIT 0
#define USART0_IER_TXRDY_MASK 0x2
#define USART0_IER_TXRDY 0x2
#define USART0_IER_TXRDY_BIT 1
#define USART0_IER_RXBRK_MASK 0x4
#define USART0_IER_RXBRK 0x4
#define USART0_IER_RXBRK_BIT 2
#define USART0_IER_ENDRX_MASK 0x8
#define USART0_IER_ENDRX 0x8
#define USART0_IER_ENDRX_BIT 3
#define USART0_IER_ENDTX_MASK 0x10
#define USART0_IER_ENDTX 0x10
#define USART0_IER_ENDTX_BIT 4
#define USART0_IER_OVRE_MASK 0x20
#define USART0_IER_OVRE 0x20
#define USART0_IER_OVRE_BIT 5
#define USART0_IER_FRAME_MASK 0x40
#define USART0_IER_FRAME 0x40
#define USART0_IER_FRAME_BIT 6
#define USART0_IER_PARE_MASK 0x80
#define USART0_IER_PARE 0x80
#define USART0_IER_PARE_BIT 7
#define USART0_IER_TIMEOUT_MASK 0x100
#define USART0_IER_TIMEOUT 0x100
#define USART0_IER_TIMEOUT_BIT 8
#define USART0_IER_TXEMPTY_MASK 0x200
#define USART0_IER_TXEMPTY 0x200
#define USART0_IER_TXEMPTY_BIT 9
#define USART0_IER_ITERATION_MASK 0x400
#define USART0_IER_ITERATION 0x400
#define USART0_IER_ITERATION_BIT 10
#define USART0_IER_TXBUFE_MASK 0x800
#define USART0_IER_TXBUFE 0x800
#define USART0_IER_TXBUFE_BIT 11
#define USART0_IER_RXBUFF_MASK 0x1000
#define USART0_IER_RXBUFF 0x1000
#define USART0_IER_RXBUFF_BIT 12
#define USART0_IER_NACK_MASK 0x2000
#define USART0_IER_NACK 0x2000
#define USART0_IER_NACK_BIT 13
#define USART0_IER_RIIC_MASK 0x10000
#define USART0_IER_RIIC 0x10000
#define USART0_IER_RIIC_BIT 16
#define USART0_IER_DSRIC_MASK 0x20000
#define USART0_IER_DSRIC 0x20000
#define USART0_IER_DSRIC_BIT 17
#define USART0_IER_DCDIC_MASK 0x40000
#define USART0_IER_DCDIC 0x40000
#define USART0_IER_DCDIC_BIT 18
#define USART0_IER_CTSIC_MASK 0x80000
#define USART0_IER_CTSIC 0x80000
#define USART0_IER_CTSIC_BIT 19

#define USART0_IDR (*(volatile unsigned long *)0xFFFC000C)
#define USART0_IDR_OFFSET 0xC
#define USART0_IDR_RXRDY_MASK 0x1
#define USART0_IDR_RXRDY 0x1
#define USART0_IDR_RXRDY_BIT 0
#define USART0_IDR_TXRDY_MASK 0x2
#define USART0_IDR_TXRDY 0x2
#define USART0_IDR_TXRDY_BIT 1
#define USART0_IDR_RXBRK_MASK 0x4
#define USART0_IDR_RXBRK 0x4
#define USART0_IDR_RXBRK_BIT 2
#define USART0_IDR_ENDRX_MASK 0x8
#define USART0_IDR_ENDRX 0x8
#define USART0_IDR_ENDRX_BIT 3
#define USART0_IDR_ENDTX_MASK 0x10
#define USART0_IDR_ENDTX 0x10
#define USART0_IDR_ENDTX_BIT 4
#define USART0_IDR_OVRE_MASK 0x20
#define USART0_IDR_OVRE 0x20
#define USART0_IDR_OVRE_BIT 5
#define USART0_IDR_FRAME_MASK 0x40
#define USART0_IDR_FRAME 0x40
#define USART0_IDR_FRAME_BIT 6
#define USART0_IDR_PARE_MASK 0x80
#define USART0_IDR_PARE 0x80
#define USART0_IDR_PARE_BIT 7
#define USART0_IDR_TIMEOUT_MASK 0x100
#define USART0_IDR_TIMEOUT 0x100
#define USART0_IDR_TIMEOUT_BIT 8
#define USART0_IDR_TXEMPTY_MASK 0x200
#define USART0_IDR_TXEMPTY 0x200
#define USART0_IDR_TXEMPTY_BIT 9
#define USART0_IDR_ITERATION_MASK 0x400
#define USART0_IDR_ITERATION 0x400
#define USART0_IDR_ITERATION_BIT 10
#define USART0_IDR_TXBUFE_MASK 0x800
#define USART0_IDR_TXBUFE 0x800
#define USART0_IDR_TXBUFE_BIT 11
#define USART0_IDR_RXBUFF_MASK 0x1000
#define USART0_IDR_RXBUFF 0x1000
#define USART0_IDR_RXBUFF_BIT 12
#define USART0_IDR_NACK_MASK 0x2000
#define USART0_IDR_NACK 0x2000
#define USART0_IDR_NACK_BIT 13
#define USART0_IDR_RIIC_MASK 0x10000
#define USART0_IDR_RIIC 0x10000
#define USART0_IDR_RIIC_BIT 16
#define USART0_IDR_DSRIC_MASK 0x20000
#define USART0_IDR_DSRIC 0x20000
#define USART0_IDR_DSRIC_BIT 17
#define USART0_IDR_DCDIC_MASK 0x40000
#define USART0_IDR_DCDIC 0x40000
#define USART0_IDR_DCDIC_BIT 18
#define USART0_IDR_CTSIC_MASK 0x80000
#define USART0_IDR_CTSIC 0x80000
#define USART0_IDR_CTSIC_BIT 19

#define USART0_IMR (*(volatile unsigned long *)0xFFFC0010)
#define USART0_IMR_OFFSET 0x10
#define USART0_IMR_RXRDY_MASK 0x1
#define USART0_IMR_RXRDY 0x1
#define USART0_IMR_RXRDY_BIT 0
#define USART0_IMR_TXRDY_MASK 0x2
#define USART0_IMR_TXRDY 0x2
#define USART0_IMR_TXRDY_BIT 1
#define USART0_IMR_RXBRK_MASK 0x4
#define USART0_IMR_RXBRK 0x4
#define USART0_IMR_RXBRK_BIT 2
#define USART0_IMR_ENDRX_MASK 0x8
#define USART0_IMR_ENDRX 0x8
#define USART0_IMR_ENDRX_BIT 3
#define USART0_IMR_ENDTX_MASK 0x10
#define USART0_IMR_ENDTX 0x10
#define USART0_IMR_ENDTX_BIT 4
#define USART0_IMR_OVRE_MASK 0x20
#define USART0_IMR_OVRE 0x20
#define USART0_IMR_OVRE_BIT 5
#define USART0_IMR_FRAME_MASK 0x40
#define USART0_IMR_FRAME 0x40
#define USART0_IMR_FRAME_BIT 6
#define USART0_IMR_PARE_MASK 0x80
#define USART0_IMR_PARE 0x80
#define USART0_IMR_PARE_BIT 7
#define USART0_IMR_TIMEOUT_MASK 0x100
#define USART0_IMR_TIMEOUT 0x100
#define USART0_IMR_TIMEOUT_BIT 8
#define USART0_IMR_TXEMPTY_MASK 0x200
#define USART0_IMR_TXEMPTY 0x200
#define USART0_IMR_TXEMPTY_BIT 9
#define USART0_IMR_ITERATION_MASK 0x400
#define USART0_IMR_ITERATION 0x400
#define USART0_IMR_ITERATION_BIT 10
#define USART0_IMR_TXBUFE_MASK 0x800
#define USART0_IMR_TXBUFE 0x800
#define USART0_IMR_TXBUFE_BIT 11
#define USART0_IMR_RXBUFF_MASK 0x1000
#define USART0_IMR_RXBUFF 0x1000
#define USART0_IMR_RXBUFF_BIT 12
#define USART0_IMR_NACK_MASK 0x2000
#define USART0_IMR_NACK 0x2000
#define USART0_IMR_NACK_BIT 13
#define USART0_IMR_RIIC_MASK 0x10000
#define USART0_IMR_RIIC 0x10000
#define USART0_IMR_RIIC_BIT 16
#define USART0_IMR_DSRIC_MASK 0x20000
#define USART0_IMR_DSRIC 0x20000
#define USART0_IMR_DSRIC_BIT 17
#define USART0_IMR_DCDIC_MASK 0x40000
#define USART0_IMR_DCDIC 0x40000
#define USART0_IMR_DCDIC_BIT 18
#define USART0_IMR_CTSIC_MASK 0x80000
#define USART0_IMR_CTSIC 0x80000
#define USART0_IMR_CTSIC_BIT 19

#define USART0_CSR (*(volatile unsigned long *)0xFFFC0014)
#define USART0_CSR_OFFSET 0x14
#define USART0_CSR_RXRDY_MASK 0x1
#define USART0_CSR_RXRDY 0x1
#define USART0_CSR_RXRDY_BIT 0
#define USART0_CSR_TXRDY_MASK 0x2
#define USART0_CSR_TXRDY 0x2
#define USART0_CSR_TXRDY_BIT 1
#define USART0_CSR_RXBRK_MASK 0x4
#define USART0_CSR_RXBRK 0x4
#define USART0_CSR_RXBRK_BIT 2
#define USART0_CSR_ENDRX_MASK 0x8
#define USART0_CSR_ENDRX 0x8
#define USART0_CSR_ENDRX_BIT 3
#define USART0_CSR_ENDTX_MASK 0x10
#define USART0_CSR_ENDTX 0x10
#define USART0_CSR_ENDTX_BIT 4
#define USART0_CSR_OVRE_MASK 0x20
#define USART0_CSR_OVRE 0x20
#define USART0_CSR_OVRE_BIT 5
#define USART0_CSR_FRAME_MASK 0x40
#define USART0_CSR_FRAME 0x40
#define USART0_CSR_FRAME_BIT 6
#define USART0_CSR_PARE_MASK 0x80
#define USART0_CSR_PARE 0x80
#define USART0_CSR_PARE_BIT 7
#define USART0_CSR_TIMEOUT_MASK 0x100
#define USART0_CSR_TIMEOUT 0x100
#define USART0_CSR_TIMEOUT_BIT 8
#define USART0_CSR_TXEMPTY_MASK 0x200
#define USART0_CSR_TXEMPTY 0x200
#define USART0_CSR_TXEMPTY_BIT 9
#define USART0_CSR_ITERATION_MASK 0x400
#define USART0_CSR_ITERATION 0x400
#define USART0_CSR_ITERATION_BIT 10
#define USART0_CSR_TXBUFE_MASK 0x800
#define USART0_CSR_TXBUFE 0x800
#define USART0_CSR_TXBUFE_BIT 11
#define USART0_CSR_RXBUFF_MASK 0x1000
#define USART0_CSR_RXBUFF 0x1000
#define USART0_CSR_RXBUFF_BIT 12
#define USART0_CSR_NACK_MASK 0x2000
#define USART0_CSR_NACK 0x2000
#define USART0_CSR_NACK_BIT 13
#define USART0_CSR_RIIC_MASK 0x10000
#define USART0_CSR_RIIC 0x10000
#define USART0_CSR_RIIC_BIT 16
#define USART0_CSR_DSRIC_MASK 0x20000
#define USART0_CSR_DSRIC 0x20000
#define USART0_CSR_DSRIC_BIT 17
#define USART0_CSR_DCDIC_MASK 0x40000
#define USART0_CSR_DCDIC 0x40000
#define USART0_CSR_DCDIC_BIT 18
#define USART0_CSR_CTSIC_MASK 0x80000
#define USART0_CSR_CTSIC 0x80000
#define USART0_CSR_CTSIC_BIT 19

#define USART0_RHR (*(volatile unsigned long *)0xFFFC0018)
#define USART0_RHR_OFFSET 0x18

#define USART0_THR (*(volatile unsigned long *)0xFFFC001C)
#define USART0_THR_OFFSET 0x1C

#define USART0_BRGR (*(volatile unsigned long *)0xFFFC0020)
#define USART0_BRGR_OFFSET 0x20

#define USART0_RTOR (*(volatile unsigned long *)0xFFFC0024)
#define USART0_RTOR_OFFSET 0x24

#define USART0_TTGR (*(volatile unsigned long *)0xFFFC0028)
#define USART0_TTGR_OFFSET 0x28

#define USART0_FIDI (*(volatile unsigned long *)0xFFFC0040)
#define USART0_FIDI_OFFSET 0x40

#define USART0_NER (*(volatile unsigned long *)0xFFFC0044)
#define USART0_NER_OFFSET 0x44

#define USART0_IF (*(volatile unsigned long *)0xFFFC004C)
#define USART0_IF_OFFSET 0x4C

#define USART0_RPR (*(volatile unsigned long *)0xFFFC0100)
#define USART0_RPR_OFFSET 0x100

#define USART0_RCR (*(volatile unsigned long *)0xFFFC0104)
#define USART0_RCR_OFFSET 0x104

#define USART0_TPR (*(volatile unsigned long *)0xFFFC0108)
#define USART0_TPR_OFFSET 0x108

#define USART0_TCR (*(volatile unsigned long *)0xFFFC010C)
#define USART0_TCR_OFFSET 0x10C

#define USART0_RNPR (*(volatile unsigned long *)0xFFFC0110)
#define USART0_RNPR_OFFSET 0x110

#define USART0_RNCR (*(volatile unsigned long *)0xFFFC0114)
#define USART0_RNCR_OFFSET 0x114

#define USART0_TNPR (*(volatile unsigned long *)0xFFFC0118)
#define USART0_TNPR_OFFSET 0x118

#define USART0_TNCR (*(volatile unsigned long *)0xFFFC011C)
#define USART0_TNCR_OFFSET 0x11C

#define USART0_PTCR (*(volatile unsigned long *)0xFFFC0120)
#define USART0_PTCR_OFFSET 0x120
#define USART0_PTCR_RXTEN_MASK 0x1
#define USART0_PTCR_RXTEN 0x1
#define USART0_PTCR_RXTEN_BIT 0
#define USART0_PTCR_RXTDIS_MASK 0x2
#define USART0_PTCR_RXTDIS 0x2
#define USART0_PTCR_RXTDIS_BIT 1
#define USART0_PTCR_TXTEN_MASK 0x100
#define USART0_PTCR_TXTEN 0x100
#define USART0_PTCR_TXTEN_BIT 8
#define USART0_PTCR_TXTDIS_MASK 0x200
#define USART0_PTCR_TXTDIS 0x200
#define USART0_PTCR_TXTDIS_BIT 9

#define USART0_PTSR (*(volatile unsigned long *)0xFFFC0124)
#define USART0_PTSR_OFFSET 0x124
#define USART0_PTSR_RXTEN_MASK 0x1
#define USART0_PTSR_RXTEN 0x1
#define USART0_PTSR_RXTEN_BIT 0
#define USART0_PTSR_TXTEN_MASK 0x100
#define USART0_PTSR_TXTEN 0x100
#define USART0_PTSR_TXTEN_BIT 8

#define USART1_BASE 0xFFFC4000

#define USART1_CR (*(volatile unsigned long *)0xFFFC4000)
#define USART1_CR_OFFSET 0x0
#define USART1_CR_RSTRX_MASK 0x4
#define USART1_CR_RSTRX 0x4
#define USART1_CR_RSTRX_BIT 2
#define USART1_CR_RSTTX_MASK 0x8
#define USART1_CR_RSTTX 0x8
#define USART1_CR_RSTTX_BIT 3
#define USART1_CR_RXEN_MASK 0x10
#define USART1_CR_RXEN 0x10
#define USART1_CR_RXEN_BIT 4
#define USART1_CR_RXDIS_MASK 0x20
#define USART1_CR_RXDIS 0x20
#define USART1_CR_RXDIS_BIT 5
#define USART1_CR_TXEN_MASK 0x40
#define USART1_CR_TXEN 0x40
#define USART1_CR_TXEN_BIT 6
#define USART1_CR_TXDIS_MASK 0x80
#define USART1_CR_TXDIS 0x80
#define USART1_CR_TXDIS_BIT 7
#define USART1_CR_RSTSTA_MASK 0x100
#define USART1_CR_RSTSTA 0x100
#define USART1_CR_RSTSTA_BIT 8
#define USART1_CR_STTBRK_MASK 0x200
#define USART1_CR_STTBRK 0x200
#define USART1_CR_STTBRK_BIT 9
#define USART1_CR_STPBRK_MASK 0x400
#define USART1_CR_STPBRK 0x400
#define USART1_CR_STPBRK_BIT 10
#define USART1_CR_STTTO_MASK 0x800
#define USART1_CR_STTTO 0x800
#define USART1_CR_STTTO_BIT 11
#define USART1_CR_SENDA_MASK 0x1000
#define USART1_CR_SENDA 0x1000
#define USART1_CR_SENDA_BIT 12
#define USART1_CR_RSTIT_MASK 0x2000
#define USART1_CR_RSTIT 0x2000
#define USART1_CR_RSTIT_BIT 13
#define USART1_CR_RSTNACK_MASK 0x4000
#define USART1_CR_RSTNACK 0x4000
#define USART1_CR_RSTNACK_BIT 14
#define USART1_CR_RETTO_MASK 0x8000
#define USART1_CR_RETTO 0x8000
#define USART1_CR_RETTO_BIT 15
#define USART1_CR_DTREN_MASK 0x10000
#define USART1_CR_DTREN 0x10000
#define USART1_CR_DTREN_BIT 16
#define USART1_CR_DTRDIS_MASK 0x20000
#define USART1_CR_DTRDIS 0x20000
#define USART1_CR_DTRDIS_BIT 17
#define USART1_CR_RTSEN_MASK 0x40000
#define USART1_CR_RTSEN 0x40000
#define USART1_CR_RTSEN_BIT 18
#define USART1_CR_RTSDIS_MASK 0x80000
#define USART1_CR_RTSDIS 0x80000
#define USART1_CR_RTSDIS_BIT 19

#define USART1_MR (*(volatile unsigned long *)0xFFFC4004)
#define USART1_MR_OFFSET 0x4
#define USART1_MR_USART_MODE_MASK 0xF
#define USART1_MR_USART_MODE_BIT 0
#define USART1_MR_USCLKS_MASK 0x30
#define USART1_MR_USCLKS_BIT 4
#define USART1_MR_CHRL_MASK 0xC0
#define USART1_MR_CHRL_BIT 6
#define USART1_MR_SYNC_MASK 0x100
#define USART1_MR_SYNC 0x100
#define USART1_MR_SYNC_BIT 8
#define USART1_MR_PAR_MASK 0xE00
#define USART1_MR_PAR_BIT 9
#define USART1_MR_NBSTOP_MASK 0x3000
#define USART1_MR_NBSTOP_BIT 12
#define USART1_MR_CHMODE_MASK 0xC000
#define USART1_MR_CHMODE_BIT 14
#define USART1_MR_MSBF_MASK 0x10000
#define USART1_MR_MSBF 0x10000
#define USART1_MR_MSBF_BIT 16
#define USART1_MR_MODE9_MASK 0x20000
#define USART1_MR_MODE9 0x20000
#define USART1_MR_MODE9_BIT 17
#define USART1_MR_CLKO_MASK 0x40000
#define USART1_MR_CLKO 0x40000
#define USART1_MR_CLKO_BIT 18
#define USART1_MR_OVER_MASK 0x80000
#define USART1_MR_OVER 0x80000
#define USART1_MR_OVER_BIT 19
#define USART1_MR_INACK_MASK 0x100000
#define USART1_MR_INACK 0x100000
#define USART1_MR_INACK_BIT 20
#define USART1_MR_DSNACK_MASK 0x200000
#define USART1_MR_DSNACK 0x200000
#define USART1_MR_DSNACK_BIT 21
#define USART1_MR_MAX_ITERATION_MASK 0x7000000
#define USART1_MR_MAX_ITERATION_BIT 24
#define USART1_MR_FILTER_MASK 0x10000000
#define USART1_MR_FILTER 0x10000000
#define USART1_MR_FILTER_BIT 28

#define USART1_IER (*(volatile unsigned long *)0xFFFC4008)
#define USART1_IER_OFFSET 0x8
#define USART1_IER_RXRDY_MASK 0x1
#define USART1_IER_RXRDY 0x1
#define USART1_IER_RXRDY_BIT 0
#define USART1_IER_TXRDY_MASK 0x2
#define USART1_IER_TXRDY 0x2
#define USART1_IER_TXRDY_BIT 1
#define USART1_IER_RXBRK_MASK 0x4
#define USART1_IER_RXBRK 0x4
#define USART1_IER_RXBRK_BIT 2
#define USART1_IER_ENDRX_MASK 0x8
#define USART1_IER_ENDRX 0x8
#define USART1_IER_ENDRX_BIT 3
#define USART1_IER_ENDTX_MASK 0x10
#define USART1_IER_ENDTX 0x10
#define USART1_IER_ENDTX_BIT 4
#define USART1_IER_OVRE_MASK 0x20
#define USART1_IER_OVRE 0x20
#define USART1_IER_OVRE_BIT 5
#define USART1_IER_FRAME_MASK 0x40
#define USART1_IER_FRAME 0x40
#define USART1_IER_FRAME_BIT 6
#define USART1_IER_PARE_MASK 0x80
#define USART1_IER_PARE 0x80
#define USART1_IER_PARE_BIT 7
#define USART1_IER_TIMEOUT_MASK 0x100
#define USART1_IER_TIMEOUT 0x100
#define USART1_IER_TIMEOUT_BIT 8
#define USART1_IER_TXEMPTY_MASK 0x200
#define USART1_IER_TXEMPTY 0x200
#define USART1_IER_TXEMPTY_BIT 9
#define USART1_IER_ITERATION_MASK 0x400
#define USART1_IER_ITERATION 0x400
#define USART1_IER_ITERATION_BIT 10
#define USART1_IER_TXBUFE_MASK 0x800
#define USART1_IER_TXBUFE 0x800
#define USART1_IER_TXBUFE_BIT 11
#define USART1_IER_RXBUFF_MASK 0x1000
#define USART1_IER_RXBUFF 0x1000
#define USART1_IER_RXBUFF_BIT 12
#define USART1_IER_NACK_MASK 0x2000
#define USART1_IER_NACK 0x2000
#define USART1_IER_NACK_BIT 13
#define USART1_IER_RIIC_MASK 0x10000
#define USART1_IER_RIIC 0x10000
#define USART1_IER_RIIC_BIT 16
#define USART1_IER_DSRIC_MASK 0x20000
#define USART1_IER_DSRIC 0x20000
#define USART1_IER_DSRIC_BIT 17
#define USART1_IER_DCDIC_MASK 0x40000
#define USART1_IER_DCDIC 0x40000
#define USART1_IER_DCDIC_BIT 18
#define USART1_IER_CTSIC_MASK 0x80000
#define USART1_IER_CTSIC 0x80000
#define USART1_IER_CTSIC_BIT 19

#define USART1_IDR (*(volatile unsigned long *)0xFFFC400C)
#define USART1_IDR_OFFSET 0xC
#define USART1_IDR_RXRDY_MASK 0x1
#define USART1_IDR_RXRDY 0x1
#define USART1_IDR_RXRDY_BIT 0
#define USART1_IDR_TXRDY_MASK 0x2
#define USART1_IDR_TXRDY 0x2
#define USART1_IDR_TXRDY_BIT 1
#define USART1_IDR_RXBRK_MASK 0x4
#define USART1_IDR_RXBRK 0x4
#define USART1_IDR_RXBRK_BIT 2
#define USART1_IDR_ENDRX_MASK 0x8
#define USART1_IDR_ENDRX 0x8
#define USART1_IDR_ENDRX_BIT 3
#define USART1_IDR_ENDTX_MASK 0x10
#define USART1_IDR_ENDTX 0x10
#define USART1_IDR_ENDTX_BIT 4
#define USART1_IDR_OVRE_MASK 0x20
#define USART1_IDR_OVRE 0x20
#define USART1_IDR_OVRE_BIT 5
#define USART1_IDR_FRAME_MASK 0x40
#define USART1_IDR_FRAME 0x40
#define USART1_IDR_FRAME_BIT 6
#define USART1_IDR_PARE_MASK 0x80
#define USART1_IDR_PARE 0x80
#define USART1_IDR_PARE_BIT 7
#define USART1_IDR_TIMEOUT_MASK 0x100
#define USART1_IDR_TIMEOUT 0x100
#define USART1_IDR_TIMEOUT_BIT 8
#define USART1_IDR_TXEMPTY_MASK 0x200
#define USART1_IDR_TXEMPTY 0x200
#define USART1_IDR_TXEMPTY_BIT 9
#define USART1_IDR_ITERATION_MASK 0x400
#define USART1_IDR_ITERATION 0x400
#define USART1_IDR_ITERATION_BIT 10
#define USART1_IDR_TXBUFE_MASK 0x800
#define USART1_IDR_TXBUFE 0x800
#define USART1_IDR_TXBUFE_BIT 11
#define USART1_IDR_RXBUFF_MASK 0x1000
#define USART1_IDR_RXBUFF 0x1000
#define USART1_IDR_RXBUFF_BIT 12
#define USART1_IDR_NACK_MASK 0x2000
#define USART1_IDR_NACK 0x2000
#define USART1_IDR_NACK_BIT 13
#define USART1_IDR_RIIC_MASK 0x10000
#define USART1_IDR_RIIC 0x10000
#define USART1_IDR_RIIC_BIT 16
#define USART1_IDR_DSRIC_MASK 0x20000
#define USART1_IDR_DSRIC 0x20000
#define USART1_IDR_DSRIC_BIT 17
#define USART1_IDR_DCDIC_MASK 0x40000
#define USART1_IDR_DCDIC 0x40000
#define USART1_IDR_DCDIC_BIT 18
#define USART1_IDR_CTSIC_MASK 0x80000
#define USART1_IDR_CTSIC 0x80000
#define USART1_IDR_CTSIC_BIT 19

#define USART1_IMR (*(volatile unsigned long *)0xFFFC4010)
#define USART1_IMR_OFFSET 0x10
#define USART1_IMR_RXRDY_MASK 0x1
#define USART1_IMR_RXRDY 0x1
#define USART1_IMR_RXRDY_BIT 0
#define USART1_IMR_TXRDY_MASK 0x2
#define USART1_IMR_TXRDY 0x2
#define USART1_IMR_TXRDY_BIT 1
#define USART1_IMR_RXBRK_MASK 0x4
#define USART1_IMR_RXBRK 0x4
#define USART1_IMR_RXBRK_BIT 2
#define USART1_IMR_ENDRX_MASK 0x8
#define USART1_IMR_ENDRX 0x8
#define USART1_IMR_ENDRX_BIT 3
#define USART1_IMR_ENDTX_MASK 0x10
#define USART1_IMR_ENDTX 0x10
#define USART1_IMR_ENDTX_BIT 4
#define USART1_IMR_OVRE_MASK 0x20
#define USART1_IMR_OVRE 0x20
#define USART1_IMR_OVRE_BIT 5
#define USART1_IMR_FRAME_MASK 0x40
#define USART1_IMR_FRAME 0x40
#define USART1_IMR_FRAME_BIT 6
#define USART1_IMR_PARE_MASK 0x80
#define USART1_IMR_PARE 0x80
#define USART1_IMR_PARE_BIT 7
#define USART1_IMR_TIMEOUT_MASK 0x100
#define USART1_IMR_TIMEOUT 0x100
#define USART1_IMR_TIMEOUT_BIT 8
#define USART1_IMR_TXEMPTY_MASK 0x200
#define USART1_IMR_TXEMPTY 0x200
#define USART1_IMR_TXEMPTY_BIT 9
#define USART1_IMR_ITERATION_MASK 0x400
#define USART1_IMR_ITERATION 0x400
#define USART1_IMR_ITERATION_BIT 10
#define USART1_IMR_TXBUFE_MASK 0x800
#define USART1_IMR_TXBUFE 0x800
#define USART1_IMR_TXBUFE_BIT 11
#define USART1_IMR_RXBUFF_MASK 0x1000
#define USART1_IMR_RXBUFF 0x1000
#define USART1_IMR_RXBUFF_BIT 12
#define USART1_IMR_NACK_MASK 0x2000
#define USART1_IMR_NACK 0x2000
#define USART1_IMR_NACK_BIT 13
#define USART1_IMR_RIIC_MASK 0x10000
#define USART1_IMR_RIIC 0x10000
#define USART1_IMR_RIIC_BIT 16
#define USART1_IMR_DSRIC_MASK 0x20000
#define USART1_IMR_DSRIC 0x20000
#define USART1_IMR_DSRIC_BIT 17
#define USART1_IMR_DCDIC_MASK 0x40000
#define USART1_IMR_DCDIC 0x40000
#define USART1_IMR_DCDIC_BIT 18
#define USART1_IMR_CTSIC_MASK 0x80000
#define USART1_IMR_CTSIC 0x80000
#define USART1_IMR_CTSIC_BIT 19

#define USART1_CSR (*(volatile unsigned long *)0xFFFC4014)
#define USART1_CSR_OFFSET 0x14
#define USART1_CSR_RXRDY_MASK 0x1
#define USART1_CSR_RXRDY 0x1
#define USART1_CSR_RXRDY_BIT 0
#define USART1_CSR_TXRDY_MASK 0x2
#define USART1_CSR_TXRDY 0x2
#define USART1_CSR_TXRDY_BIT 1
#define USART1_CSR_RXBRK_MASK 0x4
#define USART1_CSR_RXBRK 0x4
#define USART1_CSR_RXBRK_BIT 2
#define USART1_CSR_ENDRX_MASK 0x8
#define USART1_CSR_ENDRX 0x8
#define USART1_CSR_ENDRX_BIT 3
#define USART1_CSR_ENDTX_MASK 0x10
#define USART1_CSR_ENDTX 0x10
#define USART1_CSR_ENDTX_BIT 4
#define USART1_CSR_OVRE_MASK 0x20
#define USART1_CSR_OVRE 0x20
#define USART1_CSR_OVRE_BIT 5
#define USART1_CSR_FRAME_MASK 0x40
#define USART1_CSR_FRAME 0x40
#define USART1_CSR_FRAME_BIT 6
#define USART1_CSR_PARE_MASK 0x80
#define USART1_CSR_PARE 0x80
#define USART1_CSR_PARE_BIT 7
#define USART1_CSR_TIMEOUT_MASK 0x100
#define USART1_CSR_TIMEOUT 0x100
#define USART1_CSR_TIMEOUT_BIT 8
#define USART1_CSR_TXEMPTY_MASK 0x200
#define USART1_CSR_TXEMPTY 0x200
#define USART1_CSR_TXEMPTY_BIT 9
#define USART1_CSR_ITERATION_MASK 0x400
#define USART1_CSR_ITERATION 0x400
#define USART1_CSR_ITERATION_BIT 10
#define USART1_CSR_TXBUFE_MASK 0x800
#define USART1_CSR_TXBUFE 0x800
#define USART1_CSR_TXBUFE_BIT 11
#define USART1_CSR_RXBUFF_MASK 0x1000
#define USART1_CSR_RXBUFF 0x1000
#define USART1_CSR_RXBUFF_BIT 12
#define USART1_CSR_NACK_MASK 0x2000
#define USART1_CSR_NACK 0x2000
#define USART1_CSR_NACK_BIT 13
#define USART1_CSR_RIIC_MASK 0x10000
#define USART1_CSR_RIIC 0x10000
#define USART1_CSR_RIIC_BIT 16
#define USART1_CSR_DSRIC_MASK 0x20000
#define USART1_CSR_DSRIC 0x20000
#define USART1_CSR_DSRIC_BIT 17
#define USART1_CSR_DCDIC_MASK 0x40000
#define USART1_CSR_DCDIC 0x40000
#define USART1_CSR_DCDIC_BIT 18
#define USART1_CSR_CTSIC_MASK 0x80000
#define USART1_CSR_CTSIC 0x80000
#define USART1_CSR_CTSIC_BIT 19

#define USART1_RHR (*(volatile unsigned long *)0xFFFC4018)
#define USART1_RHR_OFFSET 0x18

#define USART1_THR (*(volatile unsigned long *)0xFFFC401C)
#define USART1_THR_OFFSET 0x1C

#define USART1_BRGR (*(volatile unsigned long *)0xFFFC4020)
#define USART1_BRGR_OFFSET 0x20

#define USART1_RTOR (*(volatile unsigned long *)0xFFFC4024)
#define USART1_RTOR_OFFSET 0x24

#define USART1_TTGR (*(volatile unsigned long *)0xFFFC4028)
#define USART1_TTGR_OFFSET 0x28

#define USART1_FIDI (*(volatile unsigned long *)0xFFFC4040)
#define USART1_FIDI_OFFSET 0x40

#define USART1_NER (*(volatile unsigned long *)0xFFFC4044)
#define USART1_NER_OFFSET 0x44

#define USART1_IF (*(volatile unsigned long *)0xFFFC404C)
#define USART1_IF_OFFSET 0x4C

#define USART1_RPR (*(volatile unsigned long *)0xFFFC4100)
#define USART1_RPR_OFFSET 0x100

#define USART1_RCR (*(volatile unsigned long *)0xFFFC4104)
#define USART1_RCR_OFFSET 0x104

#define USART1_TPR (*(volatile unsigned long *)0xFFFC4108)
#define USART1_TPR_OFFSET 0x108

#define USART1_TCR (*(volatile unsigned long *)0xFFFC410C)
#define USART1_TCR_OFFSET 0x10C

#define USART1_RNPR (*(volatile unsigned long *)0xFFFC4110)
#define USART1_RNPR_OFFSET 0x110

#define USART1_RNCR (*(volatile unsigned long *)0xFFFC4114)
#define USART1_RNCR_OFFSET 0x114

#define USART1_TNPR (*(volatile unsigned long *)0xFFFC4118)
#define USART1_TNPR_OFFSET 0x118

#define USART1_TNCR (*(volatile unsigned long *)0xFFFC411C)
#define USART1_TNCR_OFFSET 0x11C

#define USART1_PTCR (*(volatile unsigned long *)0xFFFC4120)
#define USART1_PTCR_OFFSET 0x120
#define USART1_PTCR_RXTEN_MASK 0x1
#define USART1_PTCR_RXTEN 0x1
#define USART1_PTCR_RXTEN_BIT 0
#define USART1_PTCR_RXTDIS_MASK 0x2
#define USART1_PTCR_RXTDIS 0x2
#define USART1_PTCR_RXTDIS_BIT 1
#define USART1_PTCR_TXTEN_MASK 0x100
#define USART1_PTCR_TXTEN 0x100
#define USART1_PTCR_TXTEN_BIT 8
#define USART1_PTCR_TXTDIS_MASK 0x200
#define USART1_PTCR_TXTDIS 0x200
#define USART1_PTCR_TXTDIS_BIT 9

#define USART1_PTSR (*(volatile unsigned long *)0xFFFC4124)
#define USART1_PTSR_OFFSET 0x124
#define USART1_PTSR_RXTEN_MASK 0x1
#define USART1_PTSR_RXTEN 0x1
#define USART1_PTSR_RXTEN_BIT 0
#define USART1_PTSR_TXTEN_MASK 0x100
#define USART1_PTSR_TXTEN 0x100
#define USART1_PTSR_TXTEN_BIT 8

#define USART2_BASE 0xFFFC8000

#define USART2_CR (*(volatile unsigned long *)0xFFFC8000)
#define USART2_CR_OFFSET 0x0
#define USART2_CR_RSTRX_MASK 0x4
#define USART2_CR_RSTRX 0x4
#define USART2_CR_RSTRX_BIT 2
#define USART2_CR_RSTTX_MASK 0x8
#define USART2_CR_RSTTX 0x8
#define USART2_CR_RSTTX_BIT 3
#define USART2_CR_RXEN_MASK 0x10
#define USART2_CR_RXEN 0x10
#define USART2_CR_RXEN_BIT 4
#define USART2_CR_RXDIS_MASK 0x20
#define USART2_CR_RXDIS 0x20
#define USART2_CR_RXDIS_BIT 5
#define USART2_CR_TXEN_MASK 0x40
#define USART2_CR_TXEN 0x40
#define USART2_CR_TXEN_BIT 6
#define USART2_CR_TXDIS_MASK 0x80
#define USART2_CR_TXDIS 0x80
#define USART2_CR_TXDIS_BIT 7
#define USART2_CR_RSTSTA_MASK 0x100
#define USART2_CR_RSTSTA 0x100
#define USART2_CR_RSTSTA_BIT 8
#define USART2_CR_STTBRK_MASK 0x200
#define USART2_CR_STTBRK 0x200
#define USART2_CR_STTBRK_BIT 9
#define USART2_CR_STPBRK_MASK 0x400
#define USART2_CR_STPBRK 0x400
#define USART2_CR_STPBRK_BIT 10
#define USART2_CR_STTTO_MASK 0x800
#define USART2_CR_STTTO 0x800
#define USART2_CR_STTTO_BIT 11
#define USART2_CR_SENDA_MASK 0x1000
#define USART2_CR_SENDA 0x1000
#define USART2_CR_SENDA_BIT 12
#define USART2_CR_RSTIT_MASK 0x2000
#define USART2_CR_RSTIT 0x2000
#define USART2_CR_RSTIT_BIT 13
#define USART2_CR_RSTNACK_MASK 0x4000
#define USART2_CR_RSTNACK 0x4000
#define USART2_CR_RSTNACK_BIT 14
#define USART2_CR_RETTO_MASK 0x8000
#define USART2_CR_RETTO 0x8000
#define USART2_CR_RETTO_BIT 15
#define USART2_CR_DTREN_MASK 0x10000
#define USART2_CR_DTREN 0x10000
#define USART2_CR_DTREN_BIT 16
#define USART2_CR_DTRDIS_MASK 0x20000
#define USART2_CR_DTRDIS 0x20000
#define USART2_CR_DTRDIS_BIT 17
#define USART2_CR_RTSEN_MASK 0x40000
#define USART2_CR_RTSEN 0x40000
#define USART2_CR_RTSEN_BIT 18
#define USART2_CR_RTSDIS_MASK 0x80000
#define USART2_CR_RTSDIS 0x80000
#define USART2_CR_RTSDIS_BIT 19

#define USART2_MR (*(volatile unsigned long *)0xFFFC8004)
#define USART2_MR_OFFSET 0x4
#define USART2_MR_USART_MODE_MASK 0xF
#define USART2_MR_USART_MODE_BIT 0
#define USART2_MR_USCLKS_MASK 0x30
#define USART2_MR_USCLKS_BIT 4
#define USART2_MR_CHRL_MASK 0xC0
#define USART2_MR_CHRL_BIT 6
#define USART2_MR_SYNC_MASK 0x100
#define USART2_MR_SYNC 0x100
#define USART2_MR_SYNC_BIT 8
#define USART2_MR_PAR_MASK 0xE00
#define USART2_MR_PAR_BIT 9
#define USART2_MR_NBSTOP_MASK 0x3000
#define USART2_MR_NBSTOP_BIT 12
#define USART2_MR_CHMODE_MASK 0xC000
#define USART2_MR_CHMODE_BIT 14
#define USART2_MR_MSBF_MASK 0x10000
#define USART2_MR_MSBF 0x10000
#define USART2_MR_MSBF_BIT 16
#define USART2_MR_MODE9_MASK 0x20000
#define USART2_MR_MODE9 0x20000
#define USART2_MR_MODE9_BIT 17
#define USART2_MR_CLKO_MASK 0x40000
#define USART2_MR_CLKO 0x40000
#define USART2_MR_CLKO_BIT 18
#define USART2_MR_OVER_MASK 0x80000
#define USART2_MR_OVER 0x80000
#define USART2_MR_OVER_BIT 19
#define USART2_MR_INACK_MASK 0x100000
#define USART2_MR_INACK 0x100000
#define USART2_MR_INACK_BIT 20
#define USART2_MR_DSNACK_MASK 0x200000
#define USART2_MR_DSNACK 0x200000
#define USART2_MR_DSNACK_BIT 21
#define USART2_MR_MAX_ITERATION_MASK 0x7000000
#define USART2_MR_MAX_ITERATION_BIT 24
#define USART2_MR_FILTER_MASK 0x10000000
#define USART2_MR_FILTER 0x10000000
#define USART2_MR_FILTER_BIT 28

#define USART2_IER (*(volatile unsigned long *)0xFFFC8008)
#define USART2_IER_OFFSET 0x8
#define USART2_IER_RXRDY_MASK 0x1
#define USART2_IER_RXRDY 0x1
#define USART2_IER_RXRDY_BIT 0
#define USART2_IER_TXRDY_MASK 0x2
#define USART2_IER_TXRDY 0x2
#define USART2_IER_TXRDY_BIT 1
#define USART2_IER_RXBRK_MASK 0x4
#define USART2_IER_RXBRK 0x4
#define USART2_IER_RXBRK_BIT 2
#define USART2_IER_ENDRX_MASK 0x8
#define USART2_IER_ENDRX 0x8
#define USART2_IER_ENDRX_BIT 3
#define USART2_IER_ENDTX_MASK 0x10
#define USART2_IER_ENDTX 0x10
#define USART2_IER_ENDTX_BIT 4
#define USART2_IER_OVRE_MASK 0x20
#define USART2_IER_OVRE 0x20
#define USART2_IER_OVRE_BIT 5
#define USART2_IER_FRAME_MASK 0x40
#define USART2_IER_FRAME 0x40
#define USART2_IER_FRAME_BIT 6
#define USART2_IER_PARE_MASK 0x80
#define USART2_IER_PARE 0x80
#define USART2_IER_PARE_BIT 7
#define USART2_IER_TIMEOUT_MASK 0x100
#define USART2_IER_TIMEOUT 0x100
#define USART2_IER_TIMEOUT_BIT 8
#define USART2_IER_TXEMPTY_MASK 0x200
#define USART2_IER_TXEMPTY 0x200
#define USART2_IER_TXEMPTY_BIT 9
#define USART2_IER_ITERATION_MASK 0x400
#define USART2_IER_ITERATION 0x400
#define USART2_IER_ITERATION_BIT 10
#define USART2_IER_TXBUFE_MASK 0x800
#define USART2_IER_TXBUFE 0x800
#define USART2_IER_TXBUFE_BIT 11
#define USART2_IER_RXBUFF_MASK 0x1000
#define USART2_IER_RXBUFF 0x1000
#define USART2_IER_RXBUFF_BIT 12
#define USART2_IER_NACK_MASK 0x2000
#define USART2_IER_NACK 0x2000
#define USART2_IER_NACK_BIT 13
#define USART2_IER_RIIC_MASK 0x10000
#define USART2_IER_RIIC 0x10000
#define USART2_IER_RIIC_BIT 16
#define USART2_IER_DSRIC_MASK 0x20000
#define USART2_IER_DSRIC 0x20000
#define USART2_IER_DSRIC_BIT 17
#define USART2_IER_DCDIC_MASK 0x40000
#define USART2_IER_DCDIC 0x40000
#define USART2_IER_DCDIC_BIT 18
#define USART2_IER_CTSIC_MASK 0x80000
#define USART2_IER_CTSIC 0x80000
#define USART2_IER_CTSIC_BIT 19

#define USART2_IDR (*(volatile unsigned long *)0xFFFC800C)
#define USART2_IDR_OFFSET 0xC
#define USART2_IDR_RXRDY_MASK 0x1
#define USART2_IDR_RXRDY 0x1
#define USART2_IDR_RXRDY_BIT 0
#define USART2_IDR_TXRDY_MASK 0x2
#define USART2_IDR_TXRDY 0x2
#define USART2_IDR_TXRDY_BIT 1
#define USART2_IDR_RXBRK_MASK 0x4
#define USART2_IDR_RXBRK 0x4
#define USART2_IDR_RXBRK_BIT 2
#define USART2_IDR_ENDRX_MASK 0x8
#define USART2_IDR_ENDRX 0x8
#define USART2_IDR_ENDRX_BIT 3
#define USART2_IDR_ENDTX_MASK 0x10
#define USART2_IDR_ENDTX 0x10
#define USART2_IDR_ENDTX_BIT 4
#define USART2_IDR_OVRE_MASK 0x20
#define USART2_IDR_OVRE 0x20
#define USART2_IDR_OVRE_BIT 5
#define USART2_IDR_FRAME_MASK 0x40
#define USART2_IDR_FRAME 0x40
#define USART2_IDR_FRAME_BIT 6
#define USART2_IDR_PARE_MASK 0x80
#define USART2_IDR_PARE 0x80
#define USART2_IDR_PARE_BIT 7
#define USART2_IDR_TIMEOUT_MASK 0x100
#define USART2_IDR_TIMEOUT 0x100
#define USART2_IDR_TIMEOUT_BIT 8
#define USART2_IDR_TXEMPTY_MASK 0x200
#define USART2_IDR_TXEMPTY 0x200
#define USART2_IDR_TXEMPTY_BIT 9
#define USART2_IDR_ITERATION_MASK 0x400
#define USART2_IDR_ITERATION 0x400
#define USART2_IDR_ITERATION_BIT 10
#define USART2_IDR_TXBUFE_MASK 0x800
#define USART2_IDR_TXBUFE 0x800
#define USART2_IDR_TXBUFE_BIT 11
#define USART2_IDR_RXBUFF_MASK 0x1000
#define USART2_IDR_RXBUFF 0x1000
#define USART2_IDR_RXBUFF_BIT 12
#define USART2_IDR_NACK_MASK 0x2000
#define USART2_IDR_NACK 0x2000
#define USART2_IDR_NACK_BIT 13
#define USART2_IDR_RIIC_MASK 0x10000
#define USART2_IDR_RIIC 0x10000
#define USART2_IDR_RIIC_BIT 16
#define USART2_IDR_DSRIC_MASK 0x20000
#define USART2_IDR_DSRIC 0x20000
#define USART2_IDR_DSRIC_BIT 17
#define USART2_IDR_DCDIC_MASK 0x40000
#define USART2_IDR_DCDIC 0x40000
#define USART2_IDR_DCDIC_BIT 18
#define USART2_IDR_CTSIC_MASK 0x80000
#define USART2_IDR_CTSIC 0x80000
#define USART2_IDR_CTSIC_BIT 19

#define USART2_IMR (*(volatile unsigned long *)0xFFFC8010)
#define USART2_IMR_OFFSET 0x10
#define USART2_IMR_RXRDY_MASK 0x1
#define USART2_IMR_RXRDY 0x1
#define USART2_IMR_RXRDY_BIT 0
#define USART2_IMR_TXRDY_MASK 0x2
#define USART2_IMR_TXRDY 0x2
#define USART2_IMR_TXRDY_BIT 1
#define USART2_IMR_RXBRK_MASK 0x4
#define USART2_IMR_RXBRK 0x4
#define USART2_IMR_RXBRK_BIT 2
#define USART2_IMR_ENDRX_MASK 0x8
#define USART2_IMR_ENDRX 0x8
#define USART2_IMR_ENDRX_BIT 3
#define USART2_IMR_ENDTX_MASK 0x10
#define USART2_IMR_ENDTX 0x10
#define USART2_IMR_ENDTX_BIT 4
#define USART2_IMR_OVRE_MASK 0x20
#define USART2_IMR_OVRE 0x20
#define USART2_IMR_OVRE_BIT 5
#define USART2_IMR_FRAME_MASK 0x40
#define USART2_IMR_FRAME 0x40
#define USART2_IMR_FRAME_BIT 6
#define USART2_IMR_PARE_MASK 0x80
#define USART2_IMR_PARE 0x80
#define USART2_IMR_PARE_BIT 7
#define USART2_IMR_TIMEOUT_MASK 0x100
#define USART2_IMR_TIMEOUT 0x100
#define USART2_IMR_TIMEOUT_BIT 8
#define USART2_IMR_TXEMPTY_MASK 0x200
#define USART2_IMR_TXEMPTY 0x200
#define USART2_IMR_TXEMPTY_BIT 9
#define USART2_IMR_ITERATION_MASK 0x400
#define USART2_IMR_ITERATION 0x400
#define USART2_IMR_ITERATION_BIT 10
#define USART2_IMR_TXBUFE_MASK 0x800
#define USART2_IMR_TXBUFE 0x800
#define USART2_IMR_TXBUFE_BIT 11
#define USART2_IMR_RXBUFF_MASK 0x1000
#define USART2_IMR_RXBUFF 0x1000
#define USART2_IMR_RXBUFF_BIT 12
#define USART2_IMR_NACK_MASK 0x2000
#define USART2_IMR_NACK 0x2000
#define USART2_IMR_NACK_BIT 13
#define USART2_IMR_RIIC_MASK 0x10000
#define USART2_IMR_RIIC 0x10000
#define USART2_IMR_RIIC_BIT 16
#define USART2_IMR_DSRIC_MASK 0x20000
#define USART2_IMR_DSRIC 0x20000
#define USART2_IMR_DSRIC_BIT 17
#define USART2_IMR_DCDIC_MASK 0x40000
#define USART2_IMR_DCDIC 0x40000
#define USART2_IMR_DCDIC_BIT 18
#define USART2_IMR_CTSIC_MASK 0x80000
#define USART2_IMR_CTSIC 0x80000
#define USART2_IMR_CTSIC_BIT 19

#define USART2_CSR (*(volatile unsigned long *)0xFFFC8014)
#define USART2_CSR_OFFSET 0x14
#define USART2_CSR_RXRDY_MASK 0x1
#define USART2_CSR_RXRDY 0x1
#define USART2_CSR_RXRDY_BIT 0
#define USART2_CSR_TXRDY_MASK 0x2
#define USART2_CSR_TXRDY 0x2
#define USART2_CSR_TXRDY_BIT 1
#define USART2_CSR_RXBRK_MASK 0x4
#define USART2_CSR_RXBRK 0x4
#define USART2_CSR_RXBRK_BIT 2
#define USART2_CSR_ENDRX_MASK 0x8
#define USART2_CSR_ENDRX 0x8
#define USART2_CSR_ENDRX_BIT 3
#define USART2_CSR_ENDTX_MASK 0x10
#define USART2_CSR_ENDTX 0x10
#define USART2_CSR_ENDTX_BIT 4
#define USART2_CSR_OVRE_MASK 0x20
#define USART2_CSR_OVRE 0x20
#define USART2_CSR_OVRE_BIT 5
#define USART2_CSR_FRAME_MASK 0x40
#define USART2_CSR_FRAME 0x40
#define USART2_CSR_FRAME_BIT 6
#define USART2_CSR_PARE_MASK 0x80
#define USART2_CSR_PARE 0x80
#define USART2_CSR_PARE_BIT 7
#define USART2_CSR_TIMEOUT_MASK 0x100
#define USART2_CSR_TIMEOUT 0x100
#define USART2_CSR_TIMEOUT_BIT 8
#define USART2_CSR_TXEMPTY_MASK 0x200
#define USART2_CSR_TXEMPTY 0x200
#define USART2_CSR_TXEMPTY_BIT 9
#define USART2_CSR_ITERATION_MASK 0x400
#define USART2_CSR_ITERATION 0x400
#define USART2_CSR_ITERATION_BIT 10
#define USART2_CSR_TXBUFE_MASK 0x800
#define USART2_CSR_TXBUFE 0x800
#define USART2_CSR_TXBUFE_BIT 11
#define USART2_CSR_RXBUFF_MASK 0x1000
#define USART2_CSR_RXBUFF 0x1000
#define USART2_CSR_RXBUFF_BIT 12
#define USART2_CSR_NACK_MASK 0x2000
#define USART2_CSR_NACK 0x2000
#define USART2_CSR_NACK_BIT 13
#define USART2_CSR_RIIC_MASK 0x10000
#define USART2_CSR_RIIC 0x10000
#define USART2_CSR_RIIC_BIT 16
#define USART2_CSR_DSRIC_MASK 0x20000
#define USART2_CSR_DSRIC 0x20000
#define USART2_CSR_DSRIC_BIT 17
#define USART2_CSR_DCDIC_MASK 0x40000
#define USART2_CSR_DCDIC 0x40000
#define USART2_CSR_DCDIC_BIT 18
#define USART2_CSR_CTSIC_MASK 0x80000
#define USART2_CSR_CTSIC 0x80000
#define USART2_CSR_CTSIC_BIT 19

#define USART2_RHR (*(volatile unsigned long *)0xFFFC8018)
#define USART2_RHR_OFFSET 0x18

#define USART2_THR (*(volatile unsigned long *)0xFFFC801C)
#define USART2_THR_OFFSET 0x1C

#define USART2_BRGR (*(volatile unsigned long *)0xFFFC8020)
#define USART2_BRGR_OFFSET 0x20

#define USART2_RTOR (*(volatile unsigned long *)0xFFFC8024)
#define USART2_RTOR_OFFSET 0x24

#define USART2_TTGR (*(volatile unsigned long *)0xFFFC8028)
#define USART2_TTGR_OFFSET 0x28

#define USART2_FIDI (*(volatile unsigned long *)0xFFFC8040)
#define USART2_FIDI_OFFSET 0x40

#define USART2_NER (*(volatile unsigned long *)0xFFFC8044)
#define USART2_NER_OFFSET 0x44

#define USART2_IF (*(volatile unsigned long *)0xFFFC804C)
#define USART2_IF_OFFSET 0x4C

#define USART2_RPR (*(volatile unsigned long *)0xFFFC8100)
#define USART2_RPR_OFFSET 0x100

#define USART2_RCR (*(volatile unsigned long *)0xFFFC8104)
#define USART2_RCR_OFFSET 0x104

#define USART2_TPR (*(volatile unsigned long *)0xFFFC8108)
#define USART2_TPR_OFFSET 0x108

#define USART2_TCR (*(volatile unsigned long *)0xFFFC810C)
#define USART2_TCR_OFFSET 0x10C

#define USART2_RNPR (*(volatile unsigned long *)0xFFFC8110)
#define USART2_RNPR_OFFSET 0x110

#define USART2_RNCR (*(volatile unsigned long *)0xFFFC8114)
#define USART2_RNCR_OFFSET 0x114

#define USART2_TNPR (*(volatile unsigned long *)0xFFFC8118)
#define USART2_TNPR_OFFSET 0x118

#define USART2_TNCR (*(volatile unsigned long *)0xFFFC811C)
#define USART2_TNCR_OFFSET 0x11C

#define USART2_PTCR (*(volatile unsigned long *)0xFFFC8120)
#define USART2_PTCR_OFFSET 0x120
#define USART2_PTCR_RXTEN_MASK 0x1
#define USART2_PTCR_RXTEN 0x1
#define USART2_PTCR_RXTEN_BIT 0
#define USART2_PTCR_RXTDIS_MASK 0x2
#define USART2_PTCR_RXTDIS 0x2
#define USART2_PTCR_RXTDIS_BIT 1
#define USART2_PTCR_TXTEN_MASK 0x100
#define USART2_PTCR_TXTEN 0x100
#define USART2_PTCR_TXTEN_BIT 8
#define USART2_PTCR_TXTDIS_MASK 0x200
#define USART2_PTCR_TXTDIS 0x200
#define USART2_PTCR_TXTDIS_BIT 9

#define USART2_PTSR (*(volatile unsigned long *)0xFFFC8124)
#define USART2_PTSR_OFFSET 0x124
#define USART2_PTSR_RXTEN_MASK 0x1
#define USART2_PTSR_RXTEN 0x1
#define USART2_PTSR_RXTEN_BIT 0
#define USART2_PTSR_TXTEN_MASK 0x100
#define USART2_PTSR_TXTEN 0x100
#define USART2_PTSR_TXTEN_BIT 8

#define USART3_BASE 0xFFFCC000

#define USART3_CR (*(volatile unsigned long *)0xFFFCC000)
#define USART3_CR_OFFSET 0x0
#define USART3_CR_RSTRX_MASK 0x4
#define USART3_CR_RSTRX 0x4
#define USART3_CR_RSTRX_BIT 2
#define USART3_CR_RSTTX_MASK 0x8
#define USART3_CR_RSTTX 0x8
#define USART3_CR_RSTTX_BIT 3
#define USART3_CR_RXEN_MASK 0x10
#define USART3_CR_RXEN 0x10
#define USART3_CR_RXEN_BIT 4
#define USART3_CR_RXDIS_MASK 0x20
#define USART3_CR_RXDIS 0x20
#define USART3_CR_RXDIS_BIT 5
#define USART3_CR_TXEN_MASK 0x40
#define USART3_CR_TXEN 0x40
#define USART3_CR_TXEN_BIT 6
#define USART3_CR_TXDIS_MASK 0x80
#define USART3_CR_TXDIS 0x80
#define USART3_CR_TXDIS_BIT 7
#define USART3_CR_RSTSTA_MASK 0x100
#define USART3_CR_RSTSTA 0x100
#define USART3_CR_RSTSTA_BIT 8
#define USART3_CR_STTBRK_MASK 0x200
#define USART3_CR_STTBRK 0x200
#define USART3_CR_STTBRK_BIT 9
#define USART3_CR_STPBRK_MASK 0x400
#define USART3_CR_STPBRK 0x400
#define USART3_CR_STPBRK_BIT 10
#define USART3_CR_STTTO_MASK 0x800
#define USART3_CR_STTTO 0x800
#define USART3_CR_STTTO_BIT 11
#define USART3_CR_SENDA_MASK 0x1000
#define USART3_CR_SENDA 0x1000
#define USART3_CR_SENDA_BIT 12
#define USART3_CR_RSTIT_MASK 0x2000
#define USART3_CR_RSTIT 0x2000
#define USART3_CR_RSTIT_BIT 13
#define USART3_CR_RSTNACK_MASK 0x4000
#define USART3_CR_RSTNACK 0x4000
#define USART3_CR_RSTNACK_BIT 14
#define USART3_CR_RETTO_MASK 0x8000
#define USART3_CR_RETTO 0x8000
#define USART3_CR_RETTO_BIT 15
#define USART3_CR_DTREN_MASK 0x10000
#define USART3_CR_DTREN 0x10000
#define USART3_CR_DTREN_BIT 16
#define USART3_CR_DTRDIS_MASK 0x20000
#define USART3_CR_DTRDIS 0x20000
#define USART3_CR_DTRDIS_BIT 17
#define USART3_CR_RTSEN_MASK 0x40000
#define USART3_CR_RTSEN 0x40000
#define USART3_CR_RTSEN_BIT 18
#define USART3_CR_RTSDIS_MASK 0x80000
#define USART3_CR_RTSDIS 0x80000
#define USART3_CR_RTSDIS_BIT 19

#define USART3_MR (*(volatile unsigned long *)0xFFFCC004)
#define USART3_MR_OFFSET 0x4
#define USART3_MR_USART_MODE_MASK 0xF
#define USART3_MR_USART_MODE_BIT 0
#define USART3_MR_USCLKS_MASK 0x30
#define USART3_MR_USCLKS_BIT 4
#define USART3_MR_CHRL_MASK 0xC0
#define USART3_MR_CHRL_BIT 6
#define USART3_MR_SYNC_MASK 0x100
#define USART3_MR_SYNC 0x100
#define USART3_MR_SYNC_BIT 8
#define USART3_MR_PAR_MASK 0xE00
#define USART3_MR_PAR_BIT 9
#define USART3_MR_NBSTOP_MASK 0x3000
#define USART3_MR_NBSTOP_BIT 12
#define USART3_MR_CHMODE_MASK 0xC000
#define USART3_MR_CHMODE_BIT 14
#define USART3_MR_MSBF_MASK 0x10000
#define USART3_MR_MSBF 0x10000
#define USART3_MR_MSBF_BIT 16
#define USART3_MR_MODE9_MASK 0x20000
#define USART3_MR_MODE9 0x20000
#define USART3_MR_MODE9_BIT 17
#define USART3_MR_CLKO_MASK 0x40000
#define USART3_MR_CLKO 0x40000
#define USART3_MR_CLKO_BIT 18
#define USART3_MR_OVER_MASK 0x80000
#define USART3_MR_OVER 0x80000
#define USART3_MR_OVER_BIT 19
#define USART3_MR_INACK_MASK 0x100000
#define USART3_MR_INACK 0x100000
#define USART3_MR_INACK_BIT 20
#define USART3_MR_DSNACK_MASK 0x200000
#define USART3_MR_DSNACK 0x200000
#define USART3_MR_DSNACK_BIT 21
#define USART3_MR_MAX_ITERATION_MASK 0x7000000
#define USART3_MR_MAX_ITERATION_BIT 24
#define USART3_MR_FILTER_MASK 0x10000000
#define USART3_MR_FILTER 0x10000000
#define USART3_MR_FILTER_BIT 28

#define USART3_IER (*(volatile unsigned long *)0xFFFCC008)
#define USART3_IER_OFFSET 0x8
#define USART3_IER_RXRDY_MASK 0x1
#define USART3_IER_RXRDY 0x1
#define USART3_IER_RXRDY_BIT 0
#define USART3_IER_TXRDY_MASK 0x2
#define USART3_IER_TXRDY 0x2
#define USART3_IER_TXRDY_BIT 1
#define USART3_IER_RXBRK_MASK 0x4
#define USART3_IER_RXBRK 0x4
#define USART3_IER_RXBRK_BIT 2
#define USART3_IER_ENDRX_MASK 0x8
#define USART3_IER_ENDRX 0x8
#define USART3_IER_ENDRX_BIT 3
#define USART3_IER_ENDTX_MASK 0x10
#define USART3_IER_ENDTX 0x10
#define USART3_IER_ENDTX_BIT 4
#define USART3_IER_OVRE_MASK 0x20
#define USART3_IER_OVRE 0x20
#define USART3_IER_OVRE_BIT 5
#define USART3_IER_FRAME_MASK 0x40
#define USART3_IER_FRAME 0x40
#define USART3_IER_FRAME_BIT 6
#define USART3_IER_PARE_MASK 0x80
#define USART3_IER_PARE 0x80
#define USART3_IER_PARE_BIT 7
#define USART3_IER_TIMEOUT_MASK 0x100
#define USART3_IER_TIMEOUT 0x100
#define USART3_IER_TIMEOUT_BIT 8
#define USART3_IER_TXEMPTY_MASK 0x200
#define USART3_IER_TXEMPTY 0x200
#define USART3_IER_TXEMPTY_BIT 9
#define USART3_IER_ITERATION_MASK 0x400
#define USART3_IER_ITERATION 0x400
#define USART3_IER_ITERATION_BIT 10
#define USART3_IER_TXBUFE_MASK 0x800
#define USART3_IER_TXBUFE 0x800
#define USART3_IER_TXBUFE_BIT 11
#define USART3_IER_RXBUFF_MASK 0x1000
#define USART3_IER_RXBUFF 0x1000
#define USART3_IER_RXBUFF_BIT 12
#define USART3_IER_NACK_MASK 0x2000
#define USART3_IER_NACK 0x2000
#define USART3_IER_NACK_BIT 13
#define USART3_IER_RIIC_MASK 0x10000
#define USART3_IER_RIIC 0x10000
#define USART3_IER_RIIC_BIT 16
#define USART3_IER_DSRIC_MASK 0x20000
#define USART3_IER_DSRIC 0x20000
#define USART3_IER_DSRIC_BIT 17
#define USART3_IER_DCDIC_MASK 0x40000
#define USART3_IER_DCDIC 0x40000
#define USART3_IER_DCDIC_BIT 18
#define USART3_IER_CTSIC_MASK 0x80000
#define USART3_IER_CTSIC 0x80000
#define USART3_IER_CTSIC_BIT 19

#define USART3_IDR (*(volatile unsigned long *)0xFFFCC00C)
#define USART3_IDR_OFFSET 0xC
#define USART3_IDR_RXRDY_MASK 0x1
#define USART3_IDR_RXRDY 0x1
#define USART3_IDR_RXRDY_BIT 0
#define USART3_IDR_TXRDY_MASK 0x2
#define USART3_IDR_TXRDY 0x2
#define USART3_IDR_TXRDY_BIT 1
#define USART3_IDR_RXBRK_MASK 0x4
#define USART3_IDR_RXBRK 0x4
#define USART3_IDR_RXBRK_BIT 2
#define USART3_IDR_ENDRX_MASK 0x8
#define USART3_IDR_ENDRX 0x8
#define USART3_IDR_ENDRX_BIT 3
#define USART3_IDR_ENDTX_MASK 0x10
#define USART3_IDR_ENDTX 0x10
#define USART3_IDR_ENDTX_BIT 4
#define USART3_IDR_OVRE_MASK 0x20
#define USART3_IDR_OVRE 0x20
#define USART3_IDR_OVRE_BIT 5
#define USART3_IDR_FRAME_MASK 0x40
#define USART3_IDR_FRAME 0x40
#define USART3_IDR_FRAME_BIT 6
#define USART3_IDR_PARE_MASK 0x80
#define USART3_IDR_PARE 0x80
#define USART3_IDR_PARE_BIT 7
#define USART3_IDR_TIMEOUT_MASK 0x100
#define USART3_IDR_TIMEOUT 0x100
#define USART3_IDR_TIMEOUT_BIT 8
#define USART3_IDR_TXEMPTY_MASK 0x200
#define USART3_IDR_TXEMPTY 0x200
#define USART3_IDR_TXEMPTY_BIT 9
#define USART3_IDR_ITERATION_MASK 0x400
#define USART3_IDR_ITERATION 0x400
#define USART3_IDR_ITERATION_BIT 10
#define USART3_IDR_TXBUFE_MASK 0x800
#define USART3_IDR_TXBUFE 0x800
#define USART3_IDR_TXBUFE_BIT 11
#define USART3_IDR_RXBUFF_MASK 0x1000
#define USART3_IDR_RXBUFF 0x1000
#define USART3_IDR_RXBUFF_BIT 12
#define USART3_IDR_NACK_MASK 0x2000
#define USART3_IDR_NACK 0x2000
#define USART3_IDR_NACK_BIT 13
#define USART3_IDR_RIIC_MASK 0x10000
#define USART3_IDR_RIIC 0x10000
#define USART3_IDR_RIIC_BIT 16
#define USART3_IDR_DSRIC_MASK 0x20000
#define USART3_IDR_DSRIC 0x20000
#define USART3_IDR_DSRIC_BIT 17
#define USART3_IDR_DCDIC_MASK 0x40000
#define USART3_IDR_DCDIC 0x40000
#define USART3_IDR_DCDIC_BIT 18
#define USART3_IDR_CTSIC_MASK 0x80000
#define USART3_IDR_CTSIC 0x80000
#define USART3_IDR_CTSIC_BIT 19

#define USART3_IMR (*(volatile unsigned long *)0xFFFCC010)
#define USART3_IMR_OFFSET 0x10
#define USART3_IMR_RXRDY_MASK 0x1
#define USART3_IMR_RXRDY 0x1
#define USART3_IMR_RXRDY_BIT 0
#define USART3_IMR_TXRDY_MASK 0x2
#define USART3_IMR_TXRDY 0x2
#define USART3_IMR_TXRDY_BIT 1
#define USART3_IMR_RXBRK_MASK 0x4
#define USART3_IMR_RXBRK 0x4
#define USART3_IMR_RXBRK_BIT 2
#define USART3_IMR_ENDRX_MASK 0x8
#define USART3_IMR_ENDRX 0x8
#define USART3_IMR_ENDRX_BIT 3
#define USART3_IMR_ENDTX_MASK 0x10
#define USART3_IMR_ENDTX 0x10
#define USART3_IMR_ENDTX_BIT 4
#define USART3_IMR_OVRE_MASK 0x20
#define USART3_IMR_OVRE 0x20
#define USART3_IMR_OVRE_BIT 5
#define USART3_IMR_FRAME_MASK 0x40
#define USART3_IMR_FRAME 0x40
#define USART3_IMR_FRAME_BIT 6
#define USART3_IMR_PARE_MASK 0x80
#define USART3_IMR_PARE 0x80
#define USART3_IMR_PARE_BIT 7
#define USART3_IMR_TIMEOUT_MASK 0x100
#define USART3_IMR_TIMEOUT 0x100
#define USART3_IMR_TIMEOUT_BIT 8
#define USART3_IMR_TXEMPTY_MASK 0x200
#define USART3_IMR_TXEMPTY 0x200
#define USART3_IMR_TXEMPTY_BIT 9
#define USART3_IMR_ITERATION_MASK 0x400
#define USART3_IMR_ITERATION 0x400
#define USART3_IMR_ITERATION_BIT 10
#define USART3_IMR_TXBUFE_MASK 0x800
#define USART3_IMR_TXBUFE 0x800
#define USART3_IMR_TXBUFE_BIT 11
#define USART3_IMR_RXBUFF_MASK 0x1000
#define USART3_IMR_RXBUFF 0x1000
#define USART3_IMR_RXBUFF_BIT 12
#define USART3_IMR_NACK_MASK 0x2000
#define USART3_IMR_NACK 0x2000
#define USART3_IMR_NACK_BIT 13
#define USART3_IMR_RIIC_MASK 0x10000
#define USART3_IMR_RIIC 0x10000
#define USART3_IMR_RIIC_BIT 16
#define USART3_IMR_DSRIC_MASK 0x20000
#define USART3_IMR_DSRIC 0x20000
#define USART3_IMR_DSRIC_BIT 17
#define USART3_IMR_DCDIC_MASK 0x40000
#define USART3_IMR_DCDIC 0x40000
#define USART3_IMR_DCDIC_BIT 18
#define USART3_IMR_CTSIC_MASK 0x80000
#define USART3_IMR_CTSIC 0x80000
#define USART3_IMR_CTSIC_BIT 19

#define USART3_CSR (*(volatile unsigned long *)0xFFFCC014)
#define USART3_CSR_OFFSET 0x14
#define USART3_CSR_RXRDY_MASK 0x1
#define USART3_CSR_RXRDY 0x1
#define USART3_CSR_RXRDY_BIT 0
#define USART3_CSR_TXRDY_MASK 0x2
#define USART3_CSR_TXRDY 0x2
#define USART3_CSR_TXRDY_BIT 1
#define USART3_CSR_RXBRK_MASK 0x4
#define USART3_CSR_RXBRK 0x4
#define USART3_CSR_RXBRK_BIT 2
#define USART3_CSR_ENDRX_MASK 0x8
#define USART3_CSR_ENDRX 0x8
#define USART3_CSR_ENDRX_BIT 3
#define USART3_CSR_ENDTX_MASK 0x10
#define USART3_CSR_ENDTX 0x10
#define USART3_CSR_ENDTX_BIT 4
#define USART3_CSR_OVRE_MASK 0x20
#define USART3_CSR_OVRE 0x20
#define USART3_CSR_OVRE_BIT 5
#define USART3_CSR_FRAME_MASK 0x40
#define USART3_CSR_FRAME 0x40
#define USART3_CSR_FRAME_BIT 6
#define USART3_CSR_PARE_MASK 0x80
#define USART3_CSR_PARE 0x80
#define USART3_CSR_PARE_BIT 7
#define USART3_CSR_TIMEOUT_MASK 0x100
#define USART3_CSR_TIMEOUT 0x100
#define USART3_CSR_TIMEOUT_BIT 8
#define USART3_CSR_TXEMPTY_MASK 0x200
#define USART3_CSR_TXEMPTY 0x200
#define USART3_CSR_TXEMPTY_BIT 9
#define USART3_CSR_ITERATION_MASK 0x400
#define USART3_CSR_ITERATION 0x400
#define USART3_CSR_ITERATION_BIT 10
#define USART3_CSR_TXBUFE_MASK 0x800
#define USART3_CSR_TXBUFE 0x800
#define USART3_CSR_TXBUFE_BIT 11
#define USART3_CSR_RXBUFF_MASK 0x1000
#define USART3_CSR_RXBUFF 0x1000
#define USART3_CSR_RXBUFF_BIT 12
#define USART3_CSR_NACK_MASK 0x2000
#define USART3_CSR_NACK 0x2000
#define USART3_CSR_NACK_BIT 13
#define USART3_CSR_RIIC_MASK 0x10000
#define USART3_CSR_RIIC 0x10000
#define USART3_CSR_RIIC_BIT 16
#define USART3_CSR_DSRIC_MASK 0x20000
#define USART3_CSR_DSRIC 0x20000
#define USART3_CSR_DSRIC_BIT 17
#define USART3_CSR_DCDIC_MASK 0x40000
#define USART3_CSR_DCDIC 0x40000
#define USART3_CSR_DCDIC_BIT 18
#define USART3_CSR_CTSIC_MASK 0x80000
#define USART3_CSR_CTSIC 0x80000
#define USART3_CSR_CTSIC_BIT 19

#define USART3_RHR (*(volatile unsigned long *)0xFFFCC018)
#define USART3_RHR_OFFSET 0x18

#define USART3_THR (*(volatile unsigned long *)0xFFFCC01C)
#define USART3_THR_OFFSET 0x1C

#define USART3_BRGR (*(volatile unsigned long *)0xFFFCC020)
#define USART3_BRGR_OFFSET 0x20

#define USART3_RTOR (*(volatile unsigned long *)0xFFFCC024)
#define USART3_RTOR_OFFSET 0x24

#define USART3_TTGR (*(volatile unsigned long *)0xFFFCC028)
#define USART3_TTGR_OFFSET 0x28

#define USART3_FIDI (*(volatile unsigned long *)0xFFFCC040)
#define USART3_FIDI_OFFSET 0x40

#define USART3_NER (*(volatile unsigned long *)0xFFFCC044)
#define USART3_NER_OFFSET 0x44

#define USART3_IF (*(volatile unsigned long *)0xFFFCC04C)
#define USART3_IF_OFFSET 0x4C

#define USART3_RPR (*(volatile unsigned long *)0xFFFCC100)
#define USART3_RPR_OFFSET 0x100

#define USART3_RCR (*(volatile unsigned long *)0xFFFCC104)
#define USART3_RCR_OFFSET 0x104

#define USART3_TPR (*(volatile unsigned long *)0xFFFCC108)
#define USART3_TPR_OFFSET 0x108

#define USART3_TCR (*(volatile unsigned long *)0xFFFCC10C)
#define USART3_TCR_OFFSET 0x10C

#define USART3_RNPR (*(volatile unsigned long *)0xFFFCC110)
#define USART3_RNPR_OFFSET 0x110

#define USART3_RNCR (*(volatile unsigned long *)0xFFFCC114)
#define USART3_RNCR_OFFSET 0x114

#define USART3_TNPR (*(volatile unsigned long *)0xFFFCC118)
#define USART3_TNPR_OFFSET 0x118

#define USART3_TNCR (*(volatile unsigned long *)0xFFFCC11C)
#define USART3_TNCR_OFFSET 0x11C

#define USART3_PTCR (*(volatile unsigned long *)0xFFFCC120)
#define USART3_PTCR_OFFSET 0x120
#define USART3_PTCR_RXTEN_MASK 0x1
#define USART3_PTCR_RXTEN 0x1
#define USART3_PTCR_RXTEN_BIT 0
#define USART3_PTCR_RXTDIS_MASK 0x2
#define USART3_PTCR_RXTDIS 0x2
#define USART3_PTCR_RXTDIS_BIT 1
#define USART3_PTCR_TXTEN_MASK 0x100
#define USART3_PTCR_TXTEN 0x100
#define USART3_PTCR_TXTEN_BIT 8
#define USART3_PTCR_TXTDIS_MASK 0x200
#define USART3_PTCR_TXTDIS 0x200
#define USART3_PTCR_TXTDIS_BIT 9

#define USART3_PTSR (*(volatile unsigned long *)0xFFFCC124)
#define USART3_PTSR_OFFSET 0x124
#define USART3_PTSR_RXTEN_MASK 0x1
#define USART3_PTSR_RXTEN 0x1
#define USART3_PTSR_RXTEN_BIT 0
#define USART3_PTSR_TXTEN_MASK 0x100
#define USART3_PTSR_TXTEN 0x100
#define USART3_PTSR_TXTEN_BIT 8

#define SSC0_BASE 0xFFFD0000

#define SSC0_CR (*(volatile unsigned long *)0xFFFD0000)
#define SSC0_CR_OFFSET 0x0
#define SSC0_CR_RXEN_MASK 0x1
#define SSC0_CR_RXEN 0x1
#define SSC0_CR_RXEN_BIT 0
#define SSC0_CR_RXDIS_MASK 0x2
#define SSC0_CR_RXDIS 0x2
#define SSC0_CR_RXDIS_BIT 1
#define SSC0_CR_TXEN_MASK 0x100
#define SSC0_CR_TXEN 0x100
#define SSC0_CR_TXEN_BIT 8
#define SSC0_CR_TXDIS_MASK 0x200
#define SSC0_CR_TXDIS 0x200
#define SSC0_CR_TXDIS_BIT 9
#define SSC0_CR_SWRST_MASK 0x8000
#define SSC0_CR_SWRST 0x8000
#define SSC0_CR_SWRST_BIT 15

#define SSC0_CMR (*(volatile unsigned long *)0xFFFD0004)
#define SSC0_CMR_OFFSET 0x4
#define SSC0_CMR_DIV_MASK 0xFFF
#define SSC0_CMR_DIV_BIT 0

#define SSC0_RCMR (*(volatile unsigned long *)0xFFFD0010)
#define SSC0_RCMR_OFFSET 0x10
#define SSC0_RCMR_CKS_MASK 0x3
#define SSC0_RCMR_CKS_BIT 0
#define SSC0_RCMR_CKO_MASK 0x1C
#define SSC0_RCMR_CKO_BIT 2
#define SSC0_RCMR_CKI_MASK 0x20
#define SSC0_RCMR_CKI 0x20
#define SSC0_RCMR_CKI_BIT 5
#define SSC0_RCMR_START_MASK 0xF00
#define SSC0_RCMR_START_BIT 8
#define SSC0_RCMR_STTDLY_MASK 0xFF0000
#define SSC0_RCMR_STTDLY_BIT 16
#define SSC0_RCMR_PERIOD_MASK 0xFF000000
#define SSC0_RCMR_PERIOD_BIT 24

#define SSC0_RFMR (*(volatile unsigned long *)0xFFFD0014)
#define SSC0_RFMR_OFFSET 0x14
#define SSC0_RFMR_DATLEN_MASK 0x1F
#define SSC0_RFMR_DATLEN_BIT 0
#define SSC0_RFMR_LOOP_MASK 0x20
#define SSC0_RFMR_LOOP 0x20
#define SSC0_RFMR_LOOP_BIT 5
#define SSC0_RFMR_MSBF_MASK 0x80
#define SSC0_RFMR_MSBF 0x80
#define SSC0_RFMR_MSBF_BIT 7
#define SSC0_RFMR_DATNB_MASK 0xF00
#define SSC0_RFMR_DATNB_BIT 8
#define SSC0_RFMR_FSLEN_MASK 0xF0000
#define SSC0_RFMR_FSLEN_BIT 16
#define SSC0_RFMR_FSOS_MASK 0x700000
#define SSC0_RFMR_FSOS_BIT 20
#define SSC0_RFMR_FSEDGE_MASK 0x1000000
#define SSC0_RFMR_FSEDGE 0x1000000
#define SSC0_RFMR_FSEDGE_BIT 24

#define SSC0_TCMR (*(volatile unsigned long *)0xFFFD0018)
#define SSC0_TCMR_OFFSET 0x18
#define SSC0_TCMR_CKS_MASK 0x3
#define SSC0_TCMR_CKS_BIT 0
#define SSC0_TCMR_CKO_MASK 0x1C
#define SSC0_TCMR_CKO_BIT 2
#define SSC0_TCMR_CKI_MASK 0x20
#define SSC0_TCMR_CKI 0x20
#define SSC0_TCMR_CKI_BIT 5
#define SSC0_TCMR_START_MASK 0xF00
#define SSC0_TCMR_START_BIT 8
#define SSC0_TCMR_STTDLY_MASK 0xFF0000
#define SSC0_TCMR_STTDLY_BIT 16
#define SSC0_TCMR_PERIOD_MASK 0xFF000000
#define SSC0_TCMR_PERIOD_BIT 24

#define SSC0_TFMR (*(volatile unsigned long *)0xFFFD001C)
#define SSC0_TFMR_OFFSET 0x1C
#define SSC0_TFMR_DATLEN_MASK 0x1F
#define SSC0_TFMR_DATLEN_BIT 0
#define SSC0_TFMR_DATDEF_MASK 0x20
#define SSC0_TFMR_DATDEF 0x20
#define SSC0_TFMR_DATDEF_BIT 5
#define SSC0_TFMR_MSBF_MASK 0x80
#define SSC0_TFMR_MSBF 0x80
#define SSC0_TFMR_MSBF_BIT 7
#define SSC0_TFMR_DATNB_MASK 0xF00
#define SSC0_TFMR_DATNB_BIT 8
#define SSC0_TFMR_FSLEN_MASK 0xF0000
#define SSC0_TFMR_FSLEN_BIT 16
#define SSC0_TFMR_FSOS_MASK 0x700000
#define SSC0_TFMR_FSOS_BIT 20
#define SSC0_TFMR_FSDEN_MASK 0x800000
#define SSC0_TFMR_FSDEN 0x800000
#define SSC0_TFMR_FSDEN_BIT 23
#define SSC0_TFMR_FSEDGE_MASK 0x1000000
#define SSC0_TFMR_FSEDGE 0x1000000
#define SSC0_TFMR_FSEDGE_BIT 24

#define SSC0_RHR (*(volatile unsigned long *)0xFFFD0020)
#define SSC0_RHR_OFFSET 0x20

#define SSC0_THR (*(volatile unsigned long *)0xFFFD0024)
#define SSC0_THR_OFFSET 0x24

#define SSC0_RSHR (*(volatile unsigned long *)0xFFFD0030)
#define SSC0_RSHR_OFFSET 0x30

#define SSC0_TSHR (*(volatile unsigned long *)0xFFFD0034)
#define SSC0_TSHR_OFFSET 0x34

#define SSC0_SR (*(volatile unsigned long *)0xFFFD0040)
#define SSC0_SR_OFFSET 0x40
#define SSC0_SR_TXRDY_MASK 0x1
#define SSC0_SR_TXRDY 0x1
#define SSC0_SR_TXRDY_BIT 0
#define SSC0_SR_TXEMPTY_MASK 0x2
#define SSC0_SR_TXEMPTY 0x2
#define SSC0_SR_TXEMPTY_BIT 1
#define SSC0_SR_ENDTX_MASK 0x4
#define SSC0_SR_ENDTX 0x4
#define SSC0_SR_ENDTX_BIT 2
#define SSC0_SR_TXBUFE_MASK 0x8
#define SSC0_SR_TXBUFE 0x8
#define SSC0_SR_TXBUFE_BIT 3
#define SSC0_SR_RXRDY_MASK 0x10
#define SSC0_SR_RXRDY 0x10
#define SSC0_SR_RXRDY_BIT 4
#define SSC0_SR_OVRUN_MASK 0x20
#define SSC0_SR_OVRUN 0x20
#define SSC0_SR_OVRUN_BIT 5
#define SSC0_SR_ENDRX_MASK 0x40
#define SSC0_SR_ENDRX 0x40
#define SSC0_SR_ENDRX_BIT 6
#define SSC0_SR_RXBUFF_MASK 0x80
#define SSC0_SR_RXBUFF 0x80
#define SSC0_SR_RXBUFF_BIT 7
#define SSC0_SR_TXSYN_MASK 0x400
#define SSC0_SR_TXSYN 0x400
#define SSC0_SR_TXSYN_BIT 10
#define SSC0_SR_RXSYN_MASK 0x800
#define SSC0_SR_RXSYN 0x800
#define SSC0_SR_RXSYN_BIT 11
#define SSC0_SR_TXEN_MASK 0x10000
#define SSC0_SR_TXEN 0x10000
#define SSC0_SR_TXEN_BIT 16
#define SSC0_SR_RXEN_MASK 0x20000
#define SSC0_SR_RXEN 0x20000
#define SSC0_SR_RXEN_BIT 17

#define SSC0_IER (*(volatile unsigned long *)0xFFFD0044)
#define SSC0_IER_OFFSET 0x44
#define SSC0_IER_TXRDY_MASK 0x1
#define SSC0_IER_TXRDY 0x1
#define SSC0_IER_TXRDY_BIT 0
#define SSC0_IER_TXEMPTY_MASK 0x2
#define SSC0_IER_TXEMPTY 0x2
#define SSC0_IER_TXEMPTY_BIT 1
#define SSC0_IER_ENDTX_MASK 0x4
#define SSC0_IER_ENDTX 0x4
#define SSC0_IER_ENDTX_BIT 2
#define SSC0_IER_TXBUFE_MASK 0x8
#define SSC0_IER_TXBUFE 0x8
#define SSC0_IER_TXBUFE_BIT 3
#define SSC0_IER_RXRDY_MASK 0x10
#define SSC0_IER_RXRDY 0x10
#define SSC0_IER_RXRDY_BIT 4
#define SSC0_IER_OVRUN_MASK 0x20
#define SSC0_IER_OVRUN 0x20
#define SSC0_IER_OVRUN_BIT 5
#define SSC0_IER_ENDRX_MASK 0x40
#define SSC0_IER_ENDRX 0x40
#define SSC0_IER_ENDRX_BIT 6
#define SSC0_IER_RXBUFF_MASK 0x80
#define SSC0_IER_RXBUFF 0x80
#define SSC0_IER_RXBUFF_BIT 7
#define SSC0_IER_TXSYN_MASK 0x400
#define SSC0_IER_TXSYN 0x400
#define SSC0_IER_TXSYN_BIT 10
#define SSC0_IER_RXSYN_MASK 0x800
#define SSC0_IER_RXSYN 0x800
#define SSC0_IER_RXSYN_BIT 11

#define SSC0_IDR (*(volatile unsigned long *)0xFFFD0048)
#define SSC0_IDR_OFFSET 0x48
#define SSC0_IDR_TXRDY_MASK 0x1
#define SSC0_IDR_TXRDY 0x1
#define SSC0_IDR_TXRDY_BIT 0
#define SSC0_IDR_TXEMPTY_MASK 0x2
#define SSC0_IDR_TXEMPTY 0x2
#define SSC0_IDR_TXEMPTY_BIT 1
#define SSC0_IDR_ENDTX_MASK 0x4
#define SSC0_IDR_ENDTX 0x4
#define SSC0_IDR_ENDTX_BIT 2
#define SSC0_IDR_TXBUFE_MASK 0x8
#define SSC0_IDR_TXBUFE 0x8
#define SSC0_IDR_TXBUFE_BIT 3
#define SSC0_IDR_RXRDY_MASK 0x10
#define SSC0_IDR_RXRDY 0x10
#define SSC0_IDR_RXRDY_BIT 4
#define SSC0_IDR_OVRUN_MASK 0x20
#define SSC0_IDR_OVRUN 0x20
#define SSC0_IDR_OVRUN_BIT 5
#define SSC0_IDR_ENDRX_MASK 0x40
#define SSC0_IDR_ENDRX 0x40
#define SSC0_IDR_ENDRX_BIT 6
#define SSC0_IDR_RXBUFF_MASK 0x80
#define SSC0_IDR_RXBUFF 0x80
#define SSC0_IDR_RXBUFF_BIT 7
#define SSC0_IDR_TXSYN_MASK 0x400
#define SSC0_IDR_TXSYN 0x400
#define SSC0_IDR_TXSYN_BIT 10
#define SSC0_IDR_RXSYN_MASK 0x800
#define SSC0_IDR_RXSYN 0x800
#define SSC0_IDR_RXSYN_BIT 11

#define SSC0_IMR (*(volatile unsigned long *)0xFFFD004C)
#define SSC0_IMR_OFFSET 0x4C
#define SSC0_IMR_TXRDY_MASK 0x1
#define SSC0_IMR_TXRDY 0x1
#define SSC0_IMR_TXRDY_BIT 0
#define SSC0_IMR_TXEMPTY_MASK 0x2
#define SSC0_IMR_TXEMPTY 0x2
#define SSC0_IMR_TXEMPTY_BIT 1
#define SSC0_IMR_ENDTX_MASK 0x4
#define SSC0_IMR_ENDTX 0x4
#define SSC0_IMR_ENDTX_BIT 2
#define SSC0_IMR_TXBUFE_MASK 0x8
#define SSC0_IMR_TXBUFE 0x8
#define SSC0_IMR_TXBUFE_BIT 3
#define SSC0_IMR_RXRDY_MASK 0x10
#define SSC0_IMR_RXRDY 0x10
#define SSC0_IMR_RXRDY_BIT 4
#define SSC0_IMR_OVRUN_MASK 0x20
#define SSC0_IMR_OVRUN 0x20
#define SSC0_IMR_OVRUN_BIT 5
#define SSC0_IMR_ENDRX_MASK 0x40
#define SSC0_IMR_ENDRX 0x40
#define SSC0_IMR_ENDRX_BIT 6
#define SSC0_IMR_RXBUFF_MASK 0x80
#define SSC0_IMR_RXBUFF 0x80
#define SSC0_IMR_RXBUFF_BIT 7
#define SSC0_IMR_TXSYN_MASK 0x400
#define SSC0_IMR_TXSYN 0x400
#define SSC0_IMR_TXSYN_BIT 10
#define SSC0_IMR_RXSYN_MASK 0x800
#define SSC0_IMR_RXSYN 0x800
#define SSC0_IMR_RXSYN_BIT 11

#define SSC0_RPR (*(volatile unsigned long *)0xFFFD0100)
#define SSC0_RPR_OFFSET 0x100

#define SSC0_RCR (*(volatile unsigned long *)0xFFFD0104)
#define SSC0_RCR_OFFSET 0x104

#define SSC0_TPR (*(volatile unsigned long *)0xFFFD0108)
#define SSC0_TPR_OFFSET 0x108

#define SSC0_TCR (*(volatile unsigned long *)0xFFFD010C)
#define SSC0_TCR_OFFSET 0x10C

#define SSC0_RNPR (*(volatile unsigned long *)0xFFFD0110)
#define SSC0_RNPR_OFFSET 0x110

#define SSC0_RNCR (*(volatile unsigned long *)0xFFFD0114)
#define SSC0_RNCR_OFFSET 0x114

#define SSC0_TNPR (*(volatile unsigned long *)0xFFFD0118)
#define SSC0_TNPR_OFFSET 0x118

#define SSC0_TNCR (*(volatile unsigned long *)0xFFFD011C)
#define SSC0_TNCR_OFFSET 0x11C

#define SSC0_PTCR (*(volatile unsigned long *)0xFFFD0120)
#define SSC0_PTCR_OFFSET 0x120
#define SSC0_PTCR_RXTEN_MASK 0x1
#define SSC0_PTCR_RXTEN 0x1
#define SSC0_PTCR_RXTEN_BIT 0
#define SSC0_PTCR_RXTDIS_MASK 0x2
#define SSC0_PTCR_RXTDIS 0x2
#define SSC0_PTCR_RXTDIS_BIT 1
#define SSC0_PTCR_TXTEN_MASK 0x100
#define SSC0_PTCR_TXTEN 0x100
#define SSC0_PTCR_TXTEN_BIT 8
#define SSC0_PTCR_TXTDIS_MASK 0x200
#define SSC0_PTCR_TXTDIS 0x200
#define SSC0_PTCR_TXTDIS_BIT 9

#define SSC0_PTSR (*(volatile unsigned long *)0xFFFD0124)
#define SSC0_PTSR_OFFSET 0x124
#define SSC0_PTSR_RXTEN_MASK 0x1
#define SSC0_PTSR_RXTEN 0x1
#define SSC0_PTSR_RXTEN_BIT 0
#define SSC0_PTSR_TXTEN_MASK 0x100
#define SSC0_PTSR_TXTEN 0x100
#define SSC0_PTSR_TXTEN_BIT 8

#define SSC1_BASE 0xFFFD4000

#define SSC1_CR (*(volatile unsigned long *)0xFFFD4000)
#define SSC1_CR_OFFSET 0x0
#define SSC1_CR_RXEN_MASK 0x1
#define SSC1_CR_RXEN 0x1
#define SSC1_CR_RXEN_BIT 0
#define SSC1_CR_RXDIS_MASK 0x2
#define SSC1_CR_RXDIS 0x2
#define SSC1_CR_RXDIS_BIT 1
#define SSC1_CR_TXEN_MASK 0x100
#define SSC1_CR_TXEN 0x100
#define SSC1_CR_TXEN_BIT 8
#define SSC1_CR_TXDIS_MASK 0x200
#define SSC1_CR_TXDIS 0x200
#define SSC1_CR_TXDIS_BIT 9
#define SSC1_CR_SWRST_MASK 0x8000
#define SSC1_CR_SWRST 0x8000
#define SSC1_CR_SWRST_BIT 15

#define SSC1_CMR (*(volatile unsigned long *)0xFFFD4004)
#define SSC1_CMR_OFFSET 0x4
#define SSC1_CMR_DIV_MASK 0xFFF
#define SSC1_CMR_DIV_BIT 0

#define SSC1_RCMR (*(volatile unsigned long *)0xFFFD4010)
#define SSC1_RCMR_OFFSET 0x10
#define SSC1_RCMR_CKS_MASK 0x3
#define SSC1_RCMR_CKS_BIT 0
#define SSC1_RCMR_CKO_MASK 0x1C
#define SSC1_RCMR_CKO_BIT 2
#define SSC1_RCMR_CKI_MASK 0x20
#define SSC1_RCMR_CKI 0x20
#define SSC1_RCMR_CKI_BIT 5
#define SSC1_RCMR_START_MASK 0xF00
#define SSC1_RCMR_START_BIT 8
#define SSC1_RCMR_STTDLY_MASK 0xFF0000
#define SSC1_RCMR_STTDLY_BIT 16
#define SSC1_RCMR_PERIOD_MASK 0xFF000000
#define SSC1_RCMR_PERIOD_BIT 24

#define SSC1_RFMR (*(volatile unsigned long *)0xFFFD4014)
#define SSC1_RFMR_OFFSET 0x14
#define SSC1_RFMR_DATLEN_MASK 0x1F
#define SSC1_RFMR_DATLEN_BIT 0
#define SSC1_RFMR_LOOP_MASK 0x20
#define SSC1_RFMR_LOOP 0x20
#define SSC1_RFMR_LOOP_BIT 5
#define SSC1_RFMR_MSBF_MASK 0x80
#define SSC1_RFMR_MSBF 0x80
#define SSC1_RFMR_MSBF_BIT 7
#define SSC1_RFMR_DATNB_MASK 0xF00
#define SSC1_RFMR_DATNB_BIT 8
#define SSC1_RFMR_FSLEN_MASK 0xF0000
#define SSC1_RFMR_FSLEN_BIT 16
#define SSC1_RFMR_FSOS_MASK 0x700000
#define SSC1_RFMR_FSOS_BIT 20
#define SSC1_RFMR_FSEDGE_MASK 0x1000000
#define SSC1_RFMR_FSEDGE 0x1000000
#define SSC1_RFMR_FSEDGE_BIT 24

#define SSC1_TCMR (*(volatile unsigned long *)0xFFFD4018)
#define SSC1_TCMR_OFFSET 0x18
#define SSC1_TCMR_CKS_MASK 0x3
#define SSC1_TCMR_CKS_BIT 0
#define SSC1_TCMR_CKO_MASK 0x1C
#define SSC1_TCMR_CKO_BIT 2
#define SSC1_TCMR_CKI_MASK 0x20
#define SSC1_TCMR_CKI 0x20
#define SSC1_TCMR_CKI_BIT 5
#define SSC1_TCMR_START_MASK 0xF00
#define SSC1_TCMR_START_BIT 8
#define SSC1_TCMR_STTDLY_MASK 0xFF0000
#define SSC1_TCMR_STTDLY_BIT 16
#define SSC1_TCMR_PERIOD_MASK 0xFF000000
#define SSC1_TCMR_PERIOD_BIT 24

#define SSC1_TFMR (*(volatile unsigned long *)0xFFFD401C)
#define SSC1_TFMR_OFFSET 0x1C
#define SSC1_TFMR_DATLEN_MASK 0x1F
#define SSC1_TFMR_DATLEN_BIT 0
#define SSC1_TFMR_DATDEF_MASK 0x20
#define SSC1_TFMR_DATDEF 0x20
#define SSC1_TFMR_DATDEF_BIT 5
#define SSC1_TFMR_MSBF_MASK 0x80
#define SSC1_TFMR_MSBF 0x80
#define SSC1_TFMR_MSBF_BIT 7
#define SSC1_TFMR_DATNB_MASK 0xF00
#define SSC1_TFMR_DATNB_BIT 8
#define SSC1_TFMR_FSLEN_MASK 0xF0000
#define SSC1_TFMR_FSLEN_BIT 16
#define SSC1_TFMR_FSOS_MASK 0x700000
#define SSC1_TFMR_FSOS_BIT 20
#define SSC1_TFMR_FSDEN_MASK 0x800000
#define SSC1_TFMR_FSDEN 0x800000
#define SSC1_TFMR_FSDEN_BIT 23
#define SSC1_TFMR_FSEDGE_MASK 0x1000000
#define SSC1_TFMR_FSEDGE 0x1000000
#define SSC1_TFMR_FSEDGE_BIT 24

#define SSC1_RHR (*(volatile unsigned long *)0xFFFD4020)
#define SSC1_RHR_OFFSET 0x20

#define SSC1_THR (*(volatile unsigned long *)0xFFFD4024)
#define SSC1_THR_OFFSET 0x24

#define SSC1_RSHR (*(volatile unsigned long *)0xFFFD4030)
#define SSC1_RSHR_OFFSET 0x30

#define SSC1_TSHR (*(volatile unsigned long *)0xFFFD4034)
#define SSC1_TSHR_OFFSET 0x34

#define SSC1_SR (*(volatile unsigned long *)0xFFFD4040)
#define SSC1_SR_OFFSET 0x40
#define SSC1_SR_TXRDY_MASK 0x1
#define SSC1_SR_TXRDY 0x1
#define SSC1_SR_TXRDY_BIT 0
#define SSC1_SR_TXEMPTY_MASK 0x2
#define SSC1_SR_TXEMPTY 0x2
#define SSC1_SR_TXEMPTY_BIT 1
#define SSC1_SR_ENDTX_MASK 0x4
#define SSC1_SR_ENDTX 0x4
#define SSC1_SR_ENDTX_BIT 2
#define SSC1_SR_TXBUFE_MASK 0x8
#define SSC1_SR_TXBUFE 0x8
#define SSC1_SR_TXBUFE_BIT 3
#define SSC1_SR_RXRDY_MASK 0x10
#define SSC1_SR_RXRDY 0x10
#define SSC1_SR_RXRDY_BIT 4
#define SSC1_SR_OVRUN_MASK 0x20
#define SSC1_SR_OVRUN 0x20
#define SSC1_SR_OVRUN_BIT 5
#define SSC1_SR_ENDRX_MASK 0x40
#define SSC1_SR_ENDRX 0x40
#define SSC1_SR_ENDRX_BIT 6
#define SSC1_SR_RXBUFF_MASK 0x80
#define SSC1_SR_RXBUFF 0x80
#define SSC1_SR_RXBUFF_BIT 7
#define SSC1_SR_TXSYN_MASK 0x400
#define SSC1_SR_TXSYN 0x400
#define SSC1_SR_TXSYN_BIT 10
#define SSC1_SR_RXSYN_MASK 0x800
#define SSC1_SR_RXSYN 0x800
#define SSC1_SR_RXSYN_BIT 11
#define SSC1_SR_TXEN_MASK 0x10000
#define SSC1_SR_TXEN 0x10000
#define SSC1_SR_TXEN_BIT 16
#define SSC1_SR_RXEN_MASK 0x20000
#define SSC1_SR_RXEN 0x20000
#define SSC1_SR_RXEN_BIT 17

#define SSC1_IER (*(volatile unsigned long *)0xFFFD4044)
#define SSC1_IER_OFFSET 0x44
#define SSC1_IER_TXRDY_MASK 0x1
#define SSC1_IER_TXRDY 0x1
#define SSC1_IER_TXRDY_BIT 0
#define SSC1_IER_TXEMPTY_MASK 0x2
#define SSC1_IER_TXEMPTY 0x2
#define SSC1_IER_TXEMPTY_BIT 1
#define SSC1_IER_ENDTX_MASK 0x4
#define SSC1_IER_ENDTX 0x4
#define SSC1_IER_ENDTX_BIT 2
#define SSC1_IER_TXBUFE_MASK 0x8
#define SSC1_IER_TXBUFE 0x8
#define SSC1_IER_TXBUFE_BIT 3
#define SSC1_IER_RXRDY_MASK 0x10
#define SSC1_IER_RXRDY 0x10
#define SSC1_IER_RXRDY_BIT 4
#define SSC1_IER_OVRUN_MASK 0x20
#define SSC1_IER_OVRUN 0x20
#define SSC1_IER_OVRUN_BIT 5
#define SSC1_IER_ENDRX_MASK 0x40
#define SSC1_IER_ENDRX 0x40
#define SSC1_IER_ENDRX_BIT 6
#define SSC1_IER_RXBUFF_MASK 0x80
#define SSC1_IER_RXBUFF 0x80
#define SSC1_IER_RXBUFF_BIT 7
#define SSC1_IER_TXSYN_MASK 0x400
#define SSC1_IER_TXSYN 0x400
#define SSC1_IER_TXSYN_BIT 10
#define SSC1_IER_RXSYN_MASK 0x800
#define SSC1_IER_RXSYN 0x800
#define SSC1_IER_RXSYN_BIT 11

#define SSC1_IDR (*(volatile unsigned long *)0xFFFD4048)
#define SSC1_IDR_OFFSET 0x48
#define SSC1_IDR_TXRDY_MASK 0x1
#define SSC1_IDR_TXRDY 0x1
#define SSC1_IDR_TXRDY_BIT 0
#define SSC1_IDR_TXEMPTY_MASK 0x2
#define SSC1_IDR_TXEMPTY 0x2
#define SSC1_IDR_TXEMPTY_BIT 1
#define SSC1_IDR_ENDTX_MASK 0x4
#define SSC1_IDR_ENDTX 0x4
#define SSC1_IDR_ENDTX_BIT 2
#define SSC1_IDR_TXBUFE_MASK 0x8
#define SSC1_IDR_TXBUFE 0x8
#define SSC1_IDR_TXBUFE_BIT 3
#define SSC1_IDR_RXRDY_MASK 0x10
#define SSC1_IDR_RXRDY 0x10
#define SSC1_IDR_RXRDY_BIT 4
#define SSC1_IDR_OVRUN_MASK 0x20
#define SSC1_IDR_OVRUN 0x20
#define SSC1_IDR_OVRUN_BIT 5
#define SSC1_IDR_ENDRX_MASK 0x40
#define SSC1_IDR_ENDRX 0x40
#define SSC1_IDR_ENDRX_BIT 6
#define SSC1_IDR_RXBUFF_MASK 0x80
#define SSC1_IDR_RXBUFF 0x80
#define SSC1_IDR_RXBUFF_BIT 7
#define SSC1_IDR_TXSYN_MASK 0x400
#define SSC1_IDR_TXSYN 0x400
#define SSC1_IDR_TXSYN_BIT 10
#define SSC1_IDR_RXSYN_MASK 0x800
#define SSC1_IDR_RXSYN 0x800
#define SSC1_IDR_RXSYN_BIT 11

#define SSC1_IMR (*(volatile unsigned long *)0xFFFD404C)
#define SSC1_IMR_OFFSET 0x4C
#define SSC1_IMR_TXRDY_MASK 0x1
#define SSC1_IMR_TXRDY 0x1
#define SSC1_IMR_TXRDY_BIT 0
#define SSC1_IMR_TXEMPTY_MASK 0x2
#define SSC1_IMR_TXEMPTY 0x2
#define SSC1_IMR_TXEMPTY_BIT 1
#define SSC1_IMR_ENDTX_MASK 0x4
#define SSC1_IMR_ENDTX 0x4
#define SSC1_IMR_ENDTX_BIT 2
#define SSC1_IMR_TXBUFE_MASK 0x8
#define SSC1_IMR_TXBUFE 0x8
#define SSC1_IMR_TXBUFE_BIT 3
#define SSC1_IMR_RXRDY_MASK 0x10
#define SSC1_IMR_RXRDY 0x10
#define SSC1_IMR_RXRDY_BIT 4
#define SSC1_IMR_OVRUN_MASK 0x20
#define SSC1_IMR_OVRUN 0x20
#define SSC1_IMR_OVRUN_BIT 5
#define SSC1_IMR_ENDRX_MASK 0x40
#define SSC1_IMR_ENDRX 0x40
#define SSC1_IMR_ENDRX_BIT 6
#define SSC1_IMR_RXBUFF_MASK 0x80
#define SSC1_IMR_RXBUFF 0x80
#define SSC1_IMR_RXBUFF_BIT 7
#define SSC1_IMR_TXSYN_MASK 0x400
#define SSC1_IMR_TXSYN 0x400
#define SSC1_IMR_TXSYN_BIT 10
#define SSC1_IMR_RXSYN_MASK 0x800
#define SSC1_IMR_RXSYN 0x800
#define SSC1_IMR_RXSYN_BIT 11

#define SSC1_RPR (*(volatile unsigned long *)0xFFFD4100)
#define SSC1_RPR_OFFSET 0x100

#define SSC1_RCR (*(volatile unsigned long *)0xFFFD4104)
#define SSC1_RCR_OFFSET 0x104

#define SSC1_TPR (*(volatile unsigned long *)0xFFFD4108)
#define SSC1_TPR_OFFSET 0x108

#define SSC1_TCR (*(volatile unsigned long *)0xFFFD410C)
#define SSC1_TCR_OFFSET 0x10C

#define SSC1_RNPR (*(volatile unsigned long *)0xFFFD4110)
#define SSC1_RNPR_OFFSET 0x110

#define SSC1_RNCR (*(volatile unsigned long *)0xFFFD4114)
#define SSC1_RNCR_OFFSET 0x114

#define SSC1_TNPR (*(volatile unsigned long *)0xFFFD4118)
#define SSC1_TNPR_OFFSET 0x118

#define SSC1_TNCR (*(volatile unsigned long *)0xFFFD411C)
#define SSC1_TNCR_OFFSET 0x11C

#define SSC1_PTCR (*(volatile unsigned long *)0xFFFD4120)
#define SSC1_PTCR_OFFSET 0x120
#define SSC1_PTCR_RXTEN_MASK 0x1
#define SSC1_PTCR_RXTEN 0x1
#define SSC1_PTCR_RXTEN_BIT 0
#define SSC1_PTCR_RXTDIS_MASK 0x2
#define SSC1_PTCR_RXTDIS 0x2
#define SSC1_PTCR_RXTDIS_BIT 1
#define SSC1_PTCR_TXTEN_MASK 0x100
#define SSC1_PTCR_TXTEN 0x100
#define SSC1_PTCR_TXTEN_BIT 8
#define SSC1_PTCR_TXTDIS_MASK 0x200
#define SSC1_PTCR_TXTDIS 0x200
#define SSC1_PTCR_TXTDIS_BIT 9

#define SSC1_PTSR (*(volatile unsigned long *)0xFFFD4124)
#define SSC1_PTSR_OFFSET 0x124
#define SSC1_PTSR_RXTEN_MASK 0x1
#define SSC1_PTSR_RXTEN 0x1
#define SSC1_PTSR_RXTEN_BIT 0
#define SSC1_PTSR_TXTEN_MASK 0x100
#define SSC1_PTSR_TXTEN 0x100
#define SSC1_PTSR_TXTEN_BIT 8

#define SSC2_BASE 0xFFFD8000

#define SSC2_CR (*(volatile unsigned long *)0xFFFD8000)
#define SSC2_CR_OFFSET 0x0
#define SSC2_CR_RXEN_MASK 0x1
#define SSC2_CR_RXEN 0x1
#define SSC2_CR_RXEN_BIT 0
#define SSC2_CR_RXDIS_MASK 0x2
#define SSC2_CR_RXDIS 0x2
#define SSC2_CR_RXDIS_BIT 1
#define SSC2_CR_TXEN_MASK 0x100
#define SSC2_CR_TXEN 0x100
#define SSC2_CR_TXEN_BIT 8
#define SSC2_CR_TXDIS_MASK 0x200
#define SSC2_CR_TXDIS 0x200
#define SSC2_CR_TXDIS_BIT 9
#define SSC2_CR_SWRST_MASK 0x8000
#define SSC2_CR_SWRST 0x8000
#define SSC2_CR_SWRST_BIT 15

#define SSC2_CMR (*(volatile unsigned long *)0xFFFD8004)
#define SSC2_CMR_OFFSET 0x4
#define SSC2_CMR_DIV_MASK 0xFFF
#define SSC2_CMR_DIV_BIT 0

#define SSC2_RCMR (*(volatile unsigned long *)0xFFFD8010)
#define SSC2_RCMR_OFFSET 0x10
#define SSC2_RCMR_CKS_MASK 0x3
#define SSC2_RCMR_CKS_BIT 0
#define SSC2_RCMR_CKO_MASK 0x1C
#define SSC2_RCMR_CKO_BIT 2
#define SSC2_RCMR_CKI_MASK 0x20
#define SSC2_RCMR_CKI 0x20
#define SSC2_RCMR_CKI_BIT 5
#define SSC2_RCMR_START_MASK 0xF00
#define SSC2_RCMR_START_BIT 8
#define SSC2_RCMR_STTDLY_MASK 0xFF0000
#define SSC2_RCMR_STTDLY_BIT 16
#define SSC2_RCMR_PERIOD_MASK 0xFF000000
#define SSC2_RCMR_PERIOD_BIT 24

#define SSC2_RFMR (*(volatile unsigned long *)0xFFFD8014)
#define SSC2_RFMR_OFFSET 0x14
#define SSC2_RFMR_DATLEN_MASK 0x1F
#define SSC2_RFMR_DATLEN_BIT 0
#define SSC2_RFMR_LOOP_MASK 0x20
#define SSC2_RFMR_LOOP 0x20
#define SSC2_RFMR_LOOP_BIT 5
#define SSC2_RFMR_MSBF_MASK 0x80
#define SSC2_RFMR_MSBF 0x80
#define SSC2_RFMR_MSBF_BIT 7
#define SSC2_RFMR_DATNB_MASK 0xF00
#define SSC2_RFMR_DATNB_BIT 8
#define SSC2_RFMR_FSLEN_MASK 0xF0000
#define SSC2_RFMR_FSLEN_BIT 16
#define SSC2_RFMR_FSOS_MASK 0x700000
#define SSC2_RFMR_FSOS_BIT 20
#define SSC2_RFMR_FSEDGE_MASK 0x1000000
#define SSC2_RFMR_FSEDGE 0x1000000
#define SSC2_RFMR_FSEDGE_BIT 24

#define SSC2_TCMR (*(volatile unsigned long *)0xFFFD8018)
#define SSC2_TCMR_OFFSET 0x18
#define SSC2_TCMR_CKS_MASK 0x3
#define SSC2_TCMR_CKS_BIT 0
#define SSC2_TCMR_CKO_MASK 0x1C
#define SSC2_TCMR_CKO_BIT 2
#define SSC2_TCMR_CKI_MASK 0x20
#define SSC2_TCMR_CKI 0x20
#define SSC2_TCMR_CKI_BIT 5
#define SSC2_TCMR_START_MASK 0xF00
#define SSC2_TCMR_START_BIT 8
#define SSC2_TCMR_STTDLY_MASK 0xFF0000
#define SSC2_TCMR_STTDLY_BIT 16
#define SSC2_TCMR_PERIOD_MASK 0xFF000000
#define SSC2_TCMR_PERIOD_BIT 24

#define SSC2_TFMR (*(volatile unsigned long *)0xFFFD801C)
#define SSC2_TFMR_OFFSET 0x1C
#define SSC2_TFMR_DATLEN_MASK 0x1F
#define SSC2_TFMR_DATLEN_BIT 0
#define SSC2_TFMR_DATDEF_MASK 0x20
#define SSC2_TFMR_DATDEF 0x20
#define SSC2_TFMR_DATDEF_BIT 5
#define SSC2_TFMR_MSBF_MASK 0x80
#define SSC2_TFMR_MSBF 0x80
#define SSC2_TFMR_MSBF_BIT 7
#define SSC2_TFMR_DATNB_MASK 0xF00
#define SSC2_TFMR_DATNB_BIT 8
#define SSC2_TFMR_FSLEN_MASK 0xF0000
#define SSC2_TFMR_FSLEN_BIT 16
#define SSC2_TFMR_FSOS_MASK 0x700000
#define SSC2_TFMR_FSOS_BIT 20
#define SSC2_TFMR_FSDEN_MASK 0x800000
#define SSC2_TFMR_FSDEN 0x800000
#define SSC2_TFMR_FSDEN_BIT 23
#define SSC2_TFMR_FSEDGE_MASK 0x1000000
#define SSC2_TFMR_FSEDGE 0x1000000
#define SSC2_TFMR_FSEDGE_BIT 24

#define SSC2_RHR (*(volatile unsigned long *)0xFFFD8020)
#define SSC2_RHR_OFFSET 0x20

#define SSC2_THR (*(volatile unsigned long *)0xFFFD8024)
#define SSC2_THR_OFFSET 0x24

#define SSC2_RSHR (*(volatile unsigned long *)0xFFFD8030)
#define SSC2_RSHR_OFFSET 0x30

#define SSC2_TSHR (*(volatile unsigned long *)0xFFFD8034)
#define SSC2_TSHR_OFFSET 0x34

#define SSC2_SR (*(volatile unsigned long *)0xFFFD8040)
#define SSC2_SR_OFFSET 0x40
#define SSC2_SR_TXRDY_MASK 0x1
#define SSC2_SR_TXRDY 0x1
#define SSC2_SR_TXRDY_BIT 0
#define SSC2_SR_TXEMPTY_MASK 0x2
#define SSC2_SR_TXEMPTY 0x2
#define SSC2_SR_TXEMPTY_BIT 1
#define SSC2_SR_ENDTX_MASK 0x4
#define SSC2_SR_ENDTX 0x4
#define SSC2_SR_ENDTX_BIT 2
#define SSC2_SR_TXBUFE_MASK 0x8
#define SSC2_SR_TXBUFE 0x8
#define SSC2_SR_TXBUFE_BIT 3
#define SSC2_SR_RXRDY_MASK 0x10
#define SSC2_SR_RXRDY 0x10
#define SSC2_SR_RXRDY_BIT 4
#define SSC2_SR_OVRUN_MASK 0x20
#define SSC2_SR_OVRUN 0x20
#define SSC2_SR_OVRUN_BIT 5
#define SSC2_SR_ENDRX_MASK 0x40
#define SSC2_SR_ENDRX 0x40
#define SSC2_SR_ENDRX_BIT 6
#define SSC2_SR_RXBUFF_MASK 0x80
#define SSC2_SR_RXBUFF 0x80
#define SSC2_SR_RXBUFF_BIT 7
#define SSC2_SR_TXSYN_MASK 0x400
#define SSC2_SR_TXSYN 0x400
#define SSC2_SR_TXSYN_BIT 10
#define SSC2_SR_RXSYN_MASK 0x800
#define SSC2_SR_RXSYN 0x800
#define SSC2_SR_RXSYN_BIT 11
#define SSC2_SR_TXEN_MASK 0x10000
#define SSC2_SR_TXEN 0x10000
#define SSC2_SR_TXEN_BIT 16
#define SSC2_SR_RXEN_MASK 0x20000
#define SSC2_SR_RXEN 0x20000
#define SSC2_SR_RXEN_BIT 17

#define SSC2_IER (*(volatile unsigned long *)0xFFFD8044)
#define SSC2_IER_OFFSET 0x44
#define SSC2_IER_TXRDY_MASK 0x1
#define SSC2_IER_TXRDY 0x1
#define SSC2_IER_TXRDY_BIT 0
#define SSC2_IER_TXEMPTY_MASK 0x2
#define SSC2_IER_TXEMPTY 0x2
#define SSC2_IER_TXEMPTY_BIT 1
#define SSC2_IER_ENDTX_MASK 0x4
#define SSC2_IER_ENDTX 0x4
#define SSC2_IER_ENDTX_BIT 2
#define SSC2_IER_TXBUFE_MASK 0x8
#define SSC2_IER_TXBUFE 0x8
#define SSC2_IER_TXBUFE_BIT 3
#define SSC2_IER_RXRDY_MASK 0x10
#define SSC2_IER_RXRDY 0x10
#define SSC2_IER_RXRDY_BIT 4
#define SSC2_IER_OVRUN_MASK 0x20
#define SSC2_IER_OVRUN 0x20
#define SSC2_IER_OVRUN_BIT 5
#define SSC2_IER_ENDRX_MASK 0x40
#define SSC2_IER_ENDRX 0x40
#define SSC2_IER_ENDRX_BIT 6
#define SSC2_IER_RXBUFF_MASK 0x80
#define SSC2_IER_RXBUFF 0x80
#define SSC2_IER_RXBUFF_BIT 7
#define SSC2_IER_TXSYN_MASK 0x400
#define SSC2_IER_TXSYN 0x400
#define SSC2_IER_TXSYN_BIT 10
#define SSC2_IER_RXSYN_MASK 0x800
#define SSC2_IER_RXSYN 0x800
#define SSC2_IER_RXSYN_BIT 11

#define SSC2_IDR (*(volatile unsigned long *)0xFFFD8048)
#define SSC2_IDR_OFFSET 0x48
#define SSC2_IDR_TXRDY_MASK 0x1
#define SSC2_IDR_TXRDY 0x1
#define SSC2_IDR_TXRDY_BIT 0
#define SSC2_IDR_TXEMPTY_MASK 0x2
#define SSC2_IDR_TXEMPTY 0x2
#define SSC2_IDR_TXEMPTY_BIT 1
#define SSC2_IDR_ENDTX_MASK 0x4
#define SSC2_IDR_ENDTX 0x4
#define SSC2_IDR_ENDTX_BIT 2
#define SSC2_IDR_TXBUFE_MASK 0x8
#define SSC2_IDR_TXBUFE 0x8
#define SSC2_IDR_TXBUFE_BIT 3
#define SSC2_IDR_RXRDY_MASK 0x10
#define SSC2_IDR_RXRDY 0x10
#define SSC2_IDR_RXRDY_BIT 4
#define SSC2_IDR_OVRUN_MASK 0x20
#define SSC2_IDR_OVRUN 0x20
#define SSC2_IDR_OVRUN_BIT 5
#define SSC2_IDR_ENDRX_MASK 0x40
#define SSC2_IDR_ENDRX 0x40
#define SSC2_IDR_ENDRX_BIT 6
#define SSC2_IDR_RXBUFF_MASK 0x80
#define SSC2_IDR_RXBUFF 0x80
#define SSC2_IDR_RXBUFF_BIT 7
#define SSC2_IDR_TXSYN_MASK 0x400
#define SSC2_IDR_TXSYN 0x400
#define SSC2_IDR_TXSYN_BIT 10
#define SSC2_IDR_RXSYN_MASK 0x800
#define SSC2_IDR_RXSYN 0x800
#define SSC2_IDR_RXSYN_BIT 11

#define SSC2_IMR (*(volatile unsigned long *)0xFFFD804C)
#define SSC2_IMR_OFFSET 0x4C
#define SSC2_IMR_TXRDY_MASK 0x1
#define SSC2_IMR_TXRDY 0x1
#define SSC2_IMR_TXRDY_BIT 0
#define SSC2_IMR_TXEMPTY_MASK 0x2
#define SSC2_IMR_TXEMPTY 0x2
#define SSC2_IMR_TXEMPTY_BIT 1
#define SSC2_IMR_ENDTX_MASK 0x4
#define SSC2_IMR_ENDTX 0x4
#define SSC2_IMR_ENDTX_BIT 2
#define SSC2_IMR_TXBUFE_MASK 0x8
#define SSC2_IMR_TXBUFE 0x8
#define SSC2_IMR_TXBUFE_BIT 3
#define SSC2_IMR_RXRDY_MASK 0x10
#define SSC2_IMR_RXRDY 0x10
#define SSC2_IMR_RXRDY_BIT 4
#define SSC2_IMR_OVRUN_MASK 0x20
#define SSC2_IMR_OVRUN 0x20
#define SSC2_IMR_OVRUN_BIT 5
#define SSC2_IMR_ENDRX_MASK 0x40
#define SSC2_IMR_ENDRX 0x40
#define SSC2_IMR_ENDRX_BIT 6
#define SSC2_IMR_RXBUFF_MASK 0x80
#define SSC2_IMR_RXBUFF 0x80
#define SSC2_IMR_RXBUFF_BIT 7
#define SSC2_IMR_TXSYN_MASK 0x400
#define SSC2_IMR_TXSYN 0x400
#define SSC2_IMR_TXSYN_BIT 10
#define SSC2_IMR_RXSYN_MASK 0x800
#define SSC2_IMR_RXSYN 0x800
#define SSC2_IMR_RXSYN_BIT 11

#define SSC2_RPR (*(volatile unsigned long *)0xFFFD8100)
#define SSC2_RPR_OFFSET 0x100

#define SSC2_RCR (*(volatile unsigned long *)0xFFFD8104)
#define SSC2_RCR_OFFSET 0x104

#define SSC2_TPR (*(volatile unsigned long *)0xFFFD8108)
#define SSC2_TPR_OFFSET 0x108

#define SSC2_TCR (*(volatile unsigned long *)0xFFFD810C)
#define SSC2_TCR_OFFSET 0x10C

#define SSC2_RNPR (*(volatile unsigned long *)0xFFFD8110)
#define SSC2_RNPR_OFFSET 0x110

#define SSC2_RNCR (*(volatile unsigned long *)0xFFFD8114)
#define SSC2_RNCR_OFFSET 0x114

#define SSC2_TNPR (*(volatile unsigned long *)0xFFFD8118)
#define SSC2_TNPR_OFFSET 0x118

#define SSC2_TNCR (*(volatile unsigned long *)0xFFFD811C)
#define SSC2_TNCR_OFFSET 0x11C

#define SSC2_PTCR (*(volatile unsigned long *)0xFFFD8120)
#define SSC2_PTCR_OFFSET 0x120
#define SSC2_PTCR_RXTEN_MASK 0x1
#define SSC2_PTCR_RXTEN 0x1
#define SSC2_PTCR_RXTEN_BIT 0
#define SSC2_PTCR_RXTDIS_MASK 0x2
#define SSC2_PTCR_RXTDIS 0x2
#define SSC2_PTCR_RXTDIS_BIT 1
#define SSC2_PTCR_TXTEN_MASK 0x100
#define SSC2_PTCR_TXTEN 0x100
#define SSC2_PTCR_TXTEN_BIT 8
#define SSC2_PTCR_TXTDIS_MASK 0x200
#define SSC2_PTCR_TXTDIS 0x200
#define SSC2_PTCR_TXTDIS_BIT 9

#define SSC2_PTSR (*(volatile unsigned long *)0xFFFD8124)
#define SSC2_PTSR_OFFSET 0x124
#define SSC2_PTSR_RXTEN_MASK 0x1
#define SSC2_PTSR_RXTEN 0x1
#define SSC2_PTSR_RXTEN_BIT 0
#define SSC2_PTSR_TXTEN_MASK 0x100
#define SSC2_PTSR_TXTEN 0x100
#define SSC2_PTSR_TXTEN_BIT 8

#define SPI_BASE 0xFFFE0000

#define SPI_CR (*(volatile unsigned long *)0xFFFE0000)
#define SPI_CR_OFFSET 0x0
#define SPI_CR_SPIEN_MASK 0x1
#define SPI_CR_SPIEN 0x1
#define SPI_CR_SPIEN_BIT 0
#define SPI_CR_SPIDIS_MASK 0x2
#define SPI_CR_SPIDIS 0x2
#define SPI_CR_SPIDIS_BIT 1
#define SPI_CR_SWRST_MASK 0x80
#define SPI_CR_SWRST 0x80
#define SPI_CR_SWRST_BIT 7

#define SPI_MR (*(volatile unsigned long *)0xFFFE0004)
#define SPI_MR_OFFSET 0x4
#define SPI_MR_MSTR_MASK 0x1
#define SPI_MR_MSTR 0x1
#define SPI_MR_MSTR_BIT 0
#define SPI_MR_PS_MASK 0x2
#define SPI_MR_PS 0x2
#define SPI_MR_PS_BIT 1
#define SPI_MR_PCSDEC_MASK 0x4
#define SPI_MR_PCSDEC 0x4
#define SPI_MR_PCSDEC_BIT 2
#define SPI_MR_DIV32_MASK 0x8
#define SPI_MR_DIV32 0x8
#define SPI_MR_DIV32_BIT 3
#define SPI_MR_MODFDIS_MASK 0x10
#define SPI_MR_MODFDIS 0x10
#define SPI_MR_MODFDIS_BIT 4
#define SPI_MR_LLB_MASK 0x80
#define SPI_MR_LLB 0x80
#define SPI_MR_LLB_BIT 7
#define SPI_MR_PCS_MASK 0xF0000
#define SPI_MR_PCS_BIT 16
#define SPI_MR_DLYBCS_MASK 0xFF000000
#define SPI_MR_DLYBCS_BIT 24

#define SPI_RDR (*(volatile unsigned long *)0xFFFE0008)
#define SPI_RDR_OFFSET 0x8
#define SPI_RDR_RD_MASK 0xFFFF
#define SPI_RDR_RD_BIT 0
#define SPI_RDR_PCS_MASK 0xF0000
#define SPI_RDR_PCS_BIT 16

#define SPI_TDR (*(volatile unsigned long *)0xFFFE000C)
#define SPI_TDR_OFFSET 0xC
#define SPI_TDR_TD_MASK 0xFFFF
#define SPI_TDR_TD_BIT 0
#define SPI_TDR_PCS_MASK 0xF0000
#define SPI_TDR_PCS_BIT 16

#define SPI_SR (*(volatile unsigned long *)0xFFFE0010)
#define SPI_SR_OFFSET 0x10
#define SPI_SR_RDRF_MASK 0x1
#define SPI_SR_RDRF 0x1
#define SPI_SR_RDRF_BIT 0
#define SPI_SR_TDRE_MASK 0x2
#define SPI_SR_TDRE 0x2
#define SPI_SR_TDRE_BIT 1
#define SPI_SR_MODF_MASK 0x4
#define SPI_SR_MODF 0x4
#define SPI_SR_MODF_BIT 2
#define SPI_SR_OVRES_MASK 0x8
#define SPI_SR_OVRES 0x8
#define SPI_SR_OVRES_BIT 3
#define SPI_SR_ENDRX_MASK 0x10
#define SPI_SR_ENDRX 0x10
#define SPI_SR_ENDRX_BIT 4
#define SPI_SR_ENDTX_MASK 0x20
#define SPI_SR_ENDTX 0x20
#define SPI_SR_ENDTX_BIT 5
#define SPI_SR_RXBUFF_MASK 0x40
#define SPI_SR_RXBUFF 0x40
#define SPI_SR_RXBUFF_BIT 6
#define SPI_SR_TXBUFE_MASK 0x80
#define SPI_SR_TXBUFE 0x80
#define SPI_SR_TXBUFE_BIT 7
#define SPI_SR_SPIENS_MASK 0x10000
#define SPI_SR_SPIENS 0x10000
#define SPI_SR_SPIENS_BIT 16

#define SPI_IER (*(volatile unsigned long *)0xFFFE0014)
#define SPI_IER_OFFSET 0x14
#define SPI_IER_RDRF_MASK 0x1
#define SPI_IER_RDRF 0x1
#define SPI_IER_RDRF_BIT 0
#define SPI_IER_TDRE_MASK 0x2
#define SPI_IER_TDRE 0x2
#define SPI_IER_TDRE_BIT 1
#define SPI_IER_MODF_MASK 0x4
#define SPI_IER_MODF 0x4
#define SPI_IER_MODF_BIT 2
#define SPI_IER_OVRES_MASK 0x8
#define SPI_IER_OVRES 0x8
#define SPI_IER_OVRES_BIT 3
#define SPI_IER_ENDRX_MASK 0x10
#define SPI_IER_ENDRX 0x10
#define SPI_IER_ENDRX_BIT 4
#define SPI_IER_ENDTX_MASK 0x20
#define SPI_IER_ENDTX 0x20
#define SPI_IER_ENDTX_BIT 5
#define SPI_IER_RXBUFF_MASK 0x40
#define SPI_IER_RXBUFF 0x40
#define SPI_IER_RXBUFF_BIT 6
#define SPI_IER_TXBUFE_MASK 0x80
#define SPI_IER_TXBUFE 0x80
#define SPI_IER_TXBUFE_BIT 7

#define SPI_IDR (*(volatile unsigned long *)0xFFFE0018)
#define SPI_IDR_OFFSET 0x18
#define SPI_IDR_RDRF_MASK 0x1
#define SPI_IDR_RDRF 0x1
#define SPI_IDR_RDRF_BIT 0
#define SPI_IDR_TDRE_MASK 0x2
#define SPI_IDR_TDRE 0x2
#define SPI_IDR_TDRE_BIT 1
#define SPI_IDR_MODF_MASK 0x4
#define SPI_IDR_MODF 0x4
#define SPI_IDR_MODF_BIT 2
#define SPI_IDR_OVRES_MASK 0x8
#define SPI_IDR_OVRES 0x8
#define SPI_IDR_OVRES_BIT 3
#define SPI_IDR_ENDRX_MASK 0x10
#define SPI_IDR_ENDRX 0x10
#define SPI_IDR_ENDRX_BIT 4
#define SPI_IDR_ENDTX_MASK 0x20
#define SPI_IDR_ENDTX 0x20
#define SPI_IDR_ENDTX_BIT 5
#define SPI_IDR_RXBUFF_MASK 0x40
#define SPI_IDR_RXBUFF 0x40
#define SPI_IDR_RXBUFF_BIT 6
#define SPI_IDR_TXBUFE_MASK 0x80
#define SPI_IDR_TXBUFE 0x80
#define SPI_IDR_TXBUFE_BIT 7

#define SPI_IMR (*(volatile unsigned long *)0xFFFE001C)
#define SPI_IMR_OFFSET 0x1C
#define SPI_IMR_RDRF_MASK 0x1
#define SPI_IMR_RDRF 0x1
#define SPI_IMR_RDRF_BIT 0
#define SPI_IMR_TDRE_MASK 0x2
#define SPI_IMR_TDRE 0x2
#define SPI_IMR_TDRE_BIT 1
#define SPI_IMR_MODF_MASK 0x4
#define SPI_IMR_MODF 0x4
#define SPI_IMR_MODF_BIT 2
#define SPI_IMR_OVRES_MASK 0x8
#define SPI_IMR_OVRES 0x8
#define SPI_IMR_OVRES_BIT 3
#define SPI_IMR_ENDRX_MASK 0x10
#define SPI_IMR_ENDRX 0x10
#define SPI_IMR_ENDRX_BIT 4
#define SPI_IMR_ENDTX_MASK 0x20
#define SPI_IMR_ENDTX 0x20
#define SPI_IMR_ENDTX_BIT 5
#define SPI_IMR_RXBUFF_MASK 0x40
#define SPI_IMR_RXBUFF 0x40
#define SPI_IMR_RXBUFF_BIT 6
#define SPI_IMR_TXBUFE_MASK 0x80
#define SPI_IMR_TXBUFE 0x80
#define SPI_IMR_TXBUFE_BIT 7

#define SPI_CSR0 (*(volatile unsigned long *)0xFFFE0030)
#define SPI_CSR0_OFFSET 0x30
#define SPI_CSR0_CPOL_MASK 0x1
#define SPI_CSR0_CPOL 0x1
#define SPI_CSR0_CPOL_BIT 0
#define SPI_CSR0_NCPHA_MASK 0x2
#define SPI_CSR0_NCPHA 0x2
#define SPI_CSR0_NCPHA_BIT 1
#define SPI_CSR0_BITS_MASK 0xF0
#define SPI_CSR0_BITS_BIT 4
#define SPI_CSR0_SCBR_MASK 0xFF00
#define SPI_CSR0_SCBR_BIT 8
#define SPI_CSR0_DLYBS_MASK 0xFF0000
#define SPI_CSR0_DLYBS_BIT 16
#define SPI_CSR0_DLYBCT_MASK 0xFF000000
#define SPI_CSR0_DLYBCT_BIT 24

#define SPI_CSR1 (*(volatile unsigned long *)0xFFFE0034)
#define SPI_CSR1_OFFSET 0x34
#define SPI_CSR1_CPOL_MASK 0x1
#define SPI_CSR1_CPOL 0x1
#define SPI_CSR1_CPOL_BIT 0
#define SPI_CSR1_NCPHA_MASK 0x2
#define SPI_CSR1_NCPHA 0x2
#define SPI_CSR1_NCPHA_BIT 1
#define SPI_CSR1_BITS_MASK 0xF0
#define SPI_CSR1_BITS_BIT 4
#define SPI_CSR1_SCBR_MASK 0xFF00
#define SPI_CSR1_SCBR_BIT 8
#define SPI_CSR1_DLYBS_MASK 0xFF0000
#define SPI_CSR1_DLYBS_BIT 16
#define SPI_CSR1_DLYBCT_MASK 0xFF000000
#define SPI_CSR1_DLYBCT_BIT 24

#define SPI_CSR2 (*(volatile unsigned long *)0xFFFE0038)
#define SPI_CSR2_OFFSET 0x38
#define SPI_CSR2_CPOL_MASK 0x1
#define SPI_CSR2_CPOL 0x1
#define SPI_CSR2_CPOL_BIT 0
#define SPI_CSR2_NCPHA_MASK 0x2
#define SPI_CSR2_NCPHA 0x2
#define SPI_CSR2_NCPHA_BIT 1
#define SPI_CSR2_BITS_MASK 0xF0
#define SPI_CSR2_BITS_BIT 4
#define SPI_CSR2_SCBR_MASK 0xFF00
#define SPI_CSR2_SCBR_BIT 8
#define SPI_CSR2_DLYBS_MASK 0xFF0000
#define SPI_CSR2_DLYBS_BIT 16
#define SPI_CSR2_DLYBCT_MASK 0xFF000000
#define SPI_CSR2_DLYBCT_BIT 24

#define SPI_CSR3 (*(volatile unsigned long *)0xFFFE003C)
#define SPI_CSR3_OFFSET 0x3C
#define SPI_CSR3_CPOL_MASK 0x1
#define SPI_CSR3_CPOL 0x1
#define SPI_CSR3_CPOL_BIT 0
#define SPI_CSR3_NCPHA_MASK 0x2
#define SPI_CSR3_NCPHA 0x2
#define SPI_CSR3_NCPHA_BIT 1
#define SPI_CSR3_BITS_MASK 0xF0
#define SPI_CSR3_BITS_BIT 4
#define SPI_CSR3_SCBR_MASK 0xFF00
#define SPI_CSR3_SCBR_BIT 8
#define SPI_CSR3_DLYBS_MASK 0xFF0000
#define SPI_CSR3_DLYBS_BIT 16
#define SPI_CSR3_DLYBCT_MASK 0xFF000000
#define SPI_CSR3_DLYBCT_BIT 24

#define SPI_RPR (*(volatile unsigned long *)0xFFFE0100)
#define SPI_RPR_OFFSET 0x100

#define SPI_RCR (*(volatile unsigned long *)0xFFFE0104)
#define SPI_RCR_OFFSET 0x104

#define SPI_TPR (*(volatile unsigned long *)0xFFFE0108)
#define SPI_TPR_OFFSET 0x108

#define SPI_TCR (*(volatile unsigned long *)0xFFFE010C)
#define SPI_TCR_OFFSET 0x10C

#define SPI_RNPR (*(volatile unsigned long *)0xFFFE0110)
#define SPI_RNPR_OFFSET 0x110

#define SPI_RNCR (*(volatile unsigned long *)0xFFFE0114)
#define SPI_RNCR_OFFSET 0x114

#define SPI_TNPR (*(volatile unsigned long *)0xFFFE0118)
#define SPI_TNPR_OFFSET 0x118

#define SPI_TNCR (*(volatile unsigned long *)0xFFFE011C)
#define SPI_TNCR_OFFSET 0x11C

#define SPI_PTCR (*(volatile unsigned long *)0xFFFE0120)
#define SPI_PTCR_OFFSET 0x120
#define SPI_PTCR_RXTEN_MASK 0x1
#define SPI_PTCR_RXTEN 0x1
#define SPI_PTCR_RXTEN_BIT 0
#define SPI_PTCR_RXTDIS_MASK 0x2
#define SPI_PTCR_RXTDIS 0x2
#define SPI_PTCR_RXTDIS_BIT 1
#define SPI_PTCR_TXTEN_MASK 0x100
#define SPI_PTCR_TXTEN 0x100
#define SPI_PTCR_TXTEN_BIT 8
#define SPI_PTCR_TXTDIS_MASK 0x200
#define SPI_PTCR_TXTDIS 0x200
#define SPI_PTCR_TXTDIS_BIT 9

#define SPI_PTSR (*(volatile unsigned long *)0xFFFE0124)
#define SPI_PTSR_OFFSET 0x124
#define SPI_PTSR_RXTEN_MASK 0x1
#define SPI_PTSR_RXTEN 0x1
#define SPI_PTSR_RXTEN_BIT 0
#define SPI_PTSR_TXTEN_MASK 0x100
#define SPI_PTSR_TXTEN 0x100
#define SPI_PTSR_TXTEN_BIT 8

#define AIC_BASE 0xFFFFF000

#define AIC_SMR0 (*(volatile unsigned long *)0xFFFFF000)
#define AIC_SMR0_OFFSET 0x0
#define AIC_SMR0_PRIOR_MASK 0x7
#define AIC_SMR0_PRIOR_BIT 0
#define AIC_SMR0_SRCTYPE_MASK 0x60
#define AIC_SMR0_SRCTYPE_BIT 5

#define AIC_SMR1 (*(volatile unsigned long *)0xFFFFF004)
#define AIC_SMR1_OFFSET 0x4
#define AIC_SMR1_PRIOR_MASK 0x7
#define AIC_SMR1_PRIOR_BIT 0
#define AIC_SMR1_SRCTYPE_MASK 0x60
#define AIC_SMR1_SRCTYPE_BIT 5

#define AIC_SMR2 (*(volatile unsigned long *)0xFFFFF008)
#define AIC_SMR2_OFFSET 0x8
#define AIC_SMR2_PRIOR_MASK 0x7
#define AIC_SMR2_PRIOR_BIT 0
#define AIC_SMR2_SRCTYPE_MASK 0x60
#define AIC_SMR2_SRCTYPE_BIT 5

#define AIC_SMR3 (*(volatile unsigned long *)0xFFFFF00C)
#define AIC_SMR3_OFFSET 0xC
#define AIC_SMR3_PRIOR_MASK 0x7
#define AIC_SMR3_PRIOR_BIT 0
#define AIC_SMR3_SRCTYPE_MASK 0x60
#define AIC_SMR3_SRCTYPE_BIT 5

#define AIC_SMR4 (*(volatile unsigned long *)0xFFFFF010)
#define AIC_SMR4_OFFSET 0x10
#define AIC_SMR4_PRIOR_MASK 0x7
#define AIC_SMR4_PRIOR_BIT 0
#define AIC_SMR4_SRCTYPE_MASK 0x60
#define AIC_SMR4_SRCTYPE_BIT 5

#define AIC_SMR5 (*(volatile unsigned long *)0xFFFFF014)
#define AIC_SMR5_OFFSET 0x14
#define AIC_SMR5_PRIOR_MASK 0x7
#define AIC_SMR5_PRIOR_BIT 0
#define AIC_SMR5_SRCTYPE_MASK 0x60
#define AIC_SMR5_SRCTYPE_BIT 5

#define AIC_SMR6 (*(volatile unsigned long *)0xFFFFF018)
#define AIC_SMR6_OFFSET 0x18
#define AIC_SMR6_PRIOR_MASK 0x7
#define AIC_SMR6_PRIOR_BIT 0
#define AIC_SMR6_SRCTYPE_MASK 0x60
#define AIC_SMR6_SRCTYPE_BIT 5

#define AIC_SMR7 (*(volatile unsigned long *)0xFFFFF01C)
#define AIC_SMR7_OFFSET 0x1C
#define AIC_SMR7_PRIOR_MASK 0x7
#define AIC_SMR7_PRIOR_BIT 0
#define AIC_SMR7_SRCTYPE_MASK 0x60
#define AIC_SMR7_SRCTYPE_BIT 5

#define AIC_SMR8 (*(volatile unsigned long *)0xFFFFF020)
#define AIC_SMR8_OFFSET 0x20
#define AIC_SMR8_PRIOR_MASK 0x7
#define AIC_SMR8_PRIOR_BIT 0
#define AIC_SMR8_SRCTYPE_MASK 0x60
#define AIC_SMR8_SRCTYPE_BIT 5

#define AIC_SMR9 (*(volatile unsigned long *)0xFFFFF024)
#define AIC_SMR9_OFFSET 0x24
#define AIC_SMR9_PRIOR_MASK 0x7
#define AIC_SMR9_PRIOR_BIT 0
#define AIC_SMR9_SRCTYPE_MASK 0x60
#define AIC_SMR9_SRCTYPE_BIT 5

#define AIC_SMR10 (*(volatile unsigned long *)0xFFFFF028)
#define AIC_SMR10_OFFSET 0x28
#define AIC_SMR10_PRIOR_MASK 0x7
#define AIC_SMR10_PRIOR_BIT 0
#define AIC_SMR10_SRCTYPE_MASK 0x60
#define AIC_SMR10_SRCTYPE_BIT 5

#define AIC_SMR11 (*(volatile unsigned long *)0xFFFFF02C)
#define AIC_SMR11_OFFSET 0x2C
#define AIC_SMR11_PRIOR_MASK 0x7
#define AIC_SMR11_PRIOR_BIT 0
#define AIC_SMR11_SRCTYPE_MASK 0x60
#define AIC_SMR11_SRCTYPE_BIT 5

#define AIC_SMR12 (*(volatile unsigned long *)0xFFFFF030)
#define AIC_SMR12_OFFSET 0x30
#define AIC_SMR12_PRIOR_MASK 0x7
#define AIC_SMR12_PRIOR_BIT 0
#define AIC_SMR12_SRCTYPE_MASK 0x60
#define AIC_SMR12_SRCTYPE_BIT 5

#define AIC_SMR13 (*(volatile unsigned long *)0xFFFFF034)
#define AIC_SMR13_OFFSET 0x34
#define AIC_SMR13_PRIOR_MASK 0x7
#define AIC_SMR13_PRIOR_BIT 0
#define AIC_SMR13_SRCTYPE_MASK 0x60
#define AIC_SMR13_SRCTYPE_BIT 5

#define AIC_SMR14 (*(volatile unsigned long *)0xFFFFF038)
#define AIC_SMR14_OFFSET 0x38
#define AIC_SMR14_PRIOR_MASK 0x7
#define AIC_SMR14_PRIOR_BIT 0
#define AIC_SMR14_SRCTYPE_MASK 0x60
#define AIC_SMR14_SRCTYPE_BIT 5

#define AIC_SMR15 (*(volatile unsigned long *)0xFFFFF03C)
#define AIC_SMR15_OFFSET 0x3C
#define AIC_SMR15_PRIOR_MASK 0x7
#define AIC_SMR15_PRIOR_BIT 0
#define AIC_SMR15_SRCTYPE_MASK 0x60
#define AIC_SMR15_SRCTYPE_BIT 5

#define AIC_SMR16 (*(volatile unsigned long *)0xFFFFF040)
#define AIC_SMR16_OFFSET 0x40
#define AIC_SMR16_PRIOR_MASK 0x7
#define AIC_SMR16_PRIOR_BIT 0
#define AIC_SMR16_SRCTYPE_MASK 0x60
#define AIC_SMR16_SRCTYPE_BIT 5

#define AIC_SMR17 (*(volatile unsigned long *)0xFFFFF044)
#define AIC_SMR17_OFFSET 0x44
#define AIC_SMR17_PRIOR_MASK 0x7
#define AIC_SMR17_PRIOR_BIT 0
#define AIC_SMR17_SRCTYPE_MASK 0x60
#define AIC_SMR17_SRCTYPE_BIT 5

#define AIC_SMR18 (*(volatile unsigned long *)0xFFFFF048)
#define AIC_SMR18_OFFSET 0x48
#define AIC_SMR18_PRIOR_MASK 0x7
#define AIC_SMR18_PRIOR_BIT 0
#define AIC_SMR18_SRCTYPE_MASK 0x60
#define AIC_SMR18_SRCTYPE_BIT 5

#define AIC_SMR19 (*(volatile unsigned long *)0xFFFFF04C)
#define AIC_SMR19_OFFSET 0x4C
#define AIC_SMR19_PRIOR_MASK 0x7
#define AIC_SMR19_PRIOR_BIT 0
#define AIC_SMR19_SRCTYPE_MASK 0x60
#define AIC_SMR19_SRCTYPE_BIT 5

#define AIC_SMR20 (*(volatile unsigned long *)0xFFFFF050)
#define AIC_SMR20_OFFSET 0x50
#define AIC_SMR20_PRIOR_MASK 0x7
#define AIC_SMR20_PRIOR_BIT 0
#define AIC_SMR20_SRCTYPE_MASK 0x60
#define AIC_SMR20_SRCTYPE_BIT 5

#define AIC_SMR21 (*(volatile unsigned long *)0xFFFFF054)
#define AIC_SMR21_OFFSET 0x54
#define AIC_SMR21_PRIOR_MASK 0x7
#define AIC_SMR21_PRIOR_BIT 0
#define AIC_SMR21_SRCTYPE_MASK 0x60
#define AIC_SMR21_SRCTYPE_BIT 5

#define AIC_SMR22 (*(volatile unsigned long *)0xFFFFF058)
#define AIC_SMR22_OFFSET 0x58
#define AIC_SMR22_PRIOR_MASK 0x7
#define AIC_SMR22_PRIOR_BIT 0
#define AIC_SMR22_SRCTYPE_MASK 0x60
#define AIC_SMR22_SRCTYPE_BIT 5

#define AIC_SMR23 (*(volatile unsigned long *)0xFFFFF05C)
#define AIC_SMR23_OFFSET 0x5C
#define AIC_SMR23_PRIOR_MASK 0x7
#define AIC_SMR23_PRIOR_BIT 0
#define AIC_SMR23_SRCTYPE_MASK 0x60
#define AIC_SMR23_SRCTYPE_BIT 5

#define AIC_SMR24 (*(volatile unsigned long *)0xFFFFF060)
#define AIC_SMR24_OFFSET 0x60
#define AIC_SMR24_PRIOR_MASK 0x7
#define AIC_SMR24_PRIOR_BIT 0
#define AIC_SMR24_SRCTYPE_MASK 0x60
#define AIC_SMR24_SRCTYPE_BIT 5

#define AIC_SMR25 (*(volatile unsigned long *)0xFFFFF064)
#define AIC_SMR25_OFFSET 0x64
#define AIC_SMR25_PRIOR_MASK 0x7
#define AIC_SMR25_PRIOR_BIT 0
#define AIC_SMR25_SRCTYPE_MASK 0x60
#define AIC_SMR25_SRCTYPE_BIT 5

#define AIC_SMR26 (*(volatile unsigned long *)0xFFFFF068)
#define AIC_SMR26_OFFSET 0x68
#define AIC_SMR26_PRIOR_MASK 0x7
#define AIC_SMR26_PRIOR_BIT 0
#define AIC_SMR26_SRCTYPE_MASK 0x60
#define AIC_SMR26_SRCTYPE_BIT 5

#define AIC_SMR27 (*(volatile unsigned long *)0xFFFFF06C)
#define AIC_SMR27_OFFSET 0x6C
#define AIC_SMR27_PRIOR_MASK 0x7
#define AIC_SMR27_PRIOR_BIT 0
#define AIC_SMR27_SRCTYPE_MASK 0x60
#define AIC_SMR27_SRCTYPE_BIT 5

#define AIC_SMR28 (*(volatile unsigned long *)0xFFFFF070)
#define AIC_SMR28_OFFSET 0x70
#define AIC_SMR28_PRIOR_MASK 0x7
#define AIC_SMR28_PRIOR_BIT 0
#define AIC_SMR28_SRCTYPE_MASK 0x60
#define AIC_SMR28_SRCTYPE_BIT 5

#define AIC_SMR29 (*(volatile unsigned long *)0xFFFFF074)
#define AIC_SMR29_OFFSET 0x74
#define AIC_SMR29_PRIOR_MASK 0x7
#define AIC_SMR29_PRIOR_BIT 0
#define AIC_SMR29_SRCTYPE_MASK 0x60
#define AIC_SMR29_SRCTYPE_BIT 5

#define AIC_SMR30 (*(volatile unsigned long *)0xFFFFF078)
#define AIC_SMR30_OFFSET 0x78
#define AIC_SMR30_PRIOR_MASK 0x7
#define AIC_SMR30_PRIOR_BIT 0
#define AIC_SMR30_SRCTYPE_MASK 0x60
#define AIC_SMR30_SRCTYPE_BIT 5

#define AIC_SMR31 (*(volatile unsigned long *)0xFFFFF07C)
#define AIC_SMR31_OFFSET 0x7C
#define AIC_SMR31_PRIOR_MASK 0x7
#define AIC_SMR31_PRIOR_BIT 0
#define AIC_SMR31_SRCTYPE_MASK 0x60
#define AIC_SMR31_SRCTYPE_BIT 5

#define AIC_SVR0 (*(volatile unsigned long *)0xFFFFF080)
#define AIC_SVR0_OFFSET 0x80

#define AIC_SVR1 (*(volatile unsigned long *)0xFFFFF084)
#define AIC_SVR1_OFFSET 0x84

#define AIC_SVR2 (*(volatile unsigned long *)0xFFFFF088)
#define AIC_SVR2_OFFSET 0x88

#define AIC_SVR3 (*(volatile unsigned long *)0xFFFFF08C)
#define AIC_SVR3_OFFSET 0x8C

#define AIC_SVR4 (*(volatile unsigned long *)0xFFFFF090)
#define AIC_SVR4_OFFSET 0x90

#define AIC_SVR5 (*(volatile unsigned long *)0xFFFFF094)
#define AIC_SVR5_OFFSET 0x94

#define AIC_SVR6 (*(volatile unsigned long *)0xFFFFF098)
#define AIC_SVR6_OFFSET 0x98

#define AIC_SVR7 (*(volatile unsigned long *)0xFFFFF09C)
#define AIC_SVR7_OFFSET 0x9C

#define AIC_SVR8 (*(volatile unsigned long *)0xFFFFF0A0)
#define AIC_SVR8_OFFSET 0xA0

#define AIC_SVR9 (*(volatile unsigned long *)0xFFFFF0A4)
#define AIC_SVR9_OFFSET 0xA4

#define AIC_SVR10 (*(volatile unsigned long *)0xFFFFF0A8)
#define AIC_SVR10_OFFSET 0xA8

#define AIC_SVR11 (*(volatile unsigned long *)0xFFFFF0AC)
#define AIC_SVR11_OFFSET 0xAC

#define AIC_SVR12 (*(volatile unsigned long *)0xFFFFF0B0)
#define AIC_SVR12_OFFSET 0xB0

#define AIC_SVR13 (*(volatile unsigned long *)0xFFFFF0B4)
#define AIC_SVR13_OFFSET 0xB4

#define AIC_SVR14 (*(volatile unsigned long *)0xFFFFF0B8)
#define AIC_SVR14_OFFSET 0xB8

#define AIC_SVR15 (*(volatile unsigned long *)0xFFFFF0BC)
#define AIC_SVR15_OFFSET 0xBC

#define AIC_SVR16 (*(volatile unsigned long *)0xFFFFF0C0)
#define AIC_SVR16_OFFSET 0xC0

#define AIC_SVR17 (*(volatile unsigned long *)0xFFFFF0C4)
#define AIC_SVR17_OFFSET 0xC4

#define AIC_SVR18 (*(volatile unsigned long *)0xFFFFF0C8)
#define AIC_SVR18_OFFSET 0xC8

#define AIC_SVR19 (*(volatile unsigned long *)0xFFFFF0CC)
#define AIC_SVR19_OFFSET 0xCC

#define AIC_SVR20 (*(volatile unsigned long *)0xFFFFF0D0)
#define AIC_SVR20_OFFSET 0xD0

#define AIC_SVR21 (*(volatile unsigned long *)0xFFFFF0D4)
#define AIC_SVR21_OFFSET 0xD4

#define AIC_SVR22 (*(volatile unsigned long *)0xFFFFF0D8)
#define AIC_SVR22_OFFSET 0xD8

#define AIC_SVR23 (*(volatile unsigned long *)0xFFFFF0DC)
#define AIC_SVR23_OFFSET 0xDC

#define AIC_SVR24 (*(volatile unsigned long *)0xFFFFF0E0)
#define AIC_SVR24_OFFSET 0xE0

#define AIC_SVR25 (*(volatile unsigned long *)0xFFFFF0E4)
#define AIC_SVR25_OFFSET 0xE4

#define AIC_SVR26 (*(volatile unsigned long *)0xFFFFF0E8)
#define AIC_SVR26_OFFSET 0xE8

#define AIC_SVR27 (*(volatile unsigned long *)0xFFFFF0EC)
#define AIC_SVR27_OFFSET 0xEC

#define AIC_SVR28 (*(volatile unsigned long *)0xFFFFF0F0)
#define AIC_SVR28_OFFSET 0xF0

#define AIC_SVR29 (*(volatile unsigned long *)0xFFFFF0F4)
#define AIC_SVR29_OFFSET 0xF4

#define AIC_SVR30 (*(volatile unsigned long *)0xFFFFF0F8)
#define AIC_SVR30_OFFSET 0xF8

#define AIC_SVR31 (*(volatile unsigned long *)0xFFFFF0FC)
#define AIC_SVR31_OFFSET 0xFC

#define AIC_IVR (*(volatile unsigned long *)0xFFFFF100)
#define AIC_IVR_OFFSET 0x100

#define AIC_FVR (*(volatile unsigned long *)0xFFFFF104)
#define AIC_FVR_OFFSET 0x104

#define AIC_ISR (*(volatile unsigned long *)0xFFFFF108)
#define AIC_ISR_OFFSET 0x108
#define AIC_ISR_IRQID_MASK 0x1F
#define AIC_ISR_IRQID_BIT 0

#define AIC_IPR (*(volatile unsigned long *)0xFFFFF10C)
#define AIC_IPR_OFFSET 0x10C
#define AIC_IPR_FIQ_MASK 0x1
#define AIC_IPR_FIQ 0x1
#define AIC_IPR_FIQ_BIT 0
#define AIC_IPR_SYS_MASK 0x2
#define AIC_IPR_SYS 0x2
#define AIC_IPR_SYS_BIT 1
#define AIC_IPR_PID2_MASK 0x4
#define AIC_IPR_PID2 0x4
#define AIC_IPR_PID2_BIT 2
#define AIC_IPR_PID3_MASK 0x8
#define AIC_IPR_PID3 0x8
#define AIC_IPR_PID3_BIT 3
#define AIC_IPR_PID4_MASK 0x10
#define AIC_IPR_PID4 0x10
#define AIC_IPR_PID4_BIT 4
#define AIC_IPR_PID5_MASK 0x20
#define AIC_IPR_PID5 0x20
#define AIC_IPR_PID5_BIT 5
#define AIC_IPR_PID6_MASK 0x40
#define AIC_IPR_PID6 0x40
#define AIC_IPR_PID6_BIT 6
#define AIC_IPR_PID7_MASK 0x80
#define AIC_IPR_PID7 0x80
#define AIC_IPR_PID7_BIT 7
#define AIC_IPR_PID8_MASK 0x100
#define AIC_IPR_PID8 0x100
#define AIC_IPR_PID8_BIT 8
#define AIC_IPR_PID9_MASK 0x200
#define AIC_IPR_PID9 0x200
#define AIC_IPR_PID9_BIT 9
#define AIC_IPR_PID10_MASK 0x400
#define AIC_IPR_PID10 0x400
#define AIC_IPR_PID10_BIT 10
#define AIC_IPR_PID11_MASK 0x800
#define AIC_IPR_PID11 0x800
#define AIC_IPR_PID11_BIT 11
#define AIC_IPR_PID12_MASK 0x1000
#define AIC_IPR_PID12 0x1000
#define AIC_IPR_PID12_BIT 12
#define AIC_IPR_PID13_MASK 0x2000
#define AIC_IPR_PID13 0x2000
#define AIC_IPR_PID13_BIT 13
#define AIC_IPR_PID14_MASK 0x4000
#define AIC_IPR_PID14 0x4000
#define AIC_IPR_PID14_BIT 14
#define AIC_IPR_PID15_MASK 0x8000
#define AIC_IPR_PID15 0x8000
#define AIC_IPR_PID15_BIT 15
#define AIC_IPR_PID16_MASK 0x10000
#define AIC_IPR_PID16 0x10000
#define AIC_IPR_PID16_BIT 16
#define AIC_IPR_PID17_MASK 0x20000
#define AIC_IPR_PID17 0x20000
#define AIC_IPR_PID17_BIT 17
#define AIC_IPR_PID18_MASK 0x40000
#define AIC_IPR_PID18 0x40000
#define AIC_IPR_PID18_BIT 18
#define AIC_IPR_PID19_MASK 0x80000
#define AIC_IPR_PID19 0x80000
#define AIC_IPR_PID19_BIT 19
#define AIC_IPR_PID20_MASK 0x100000
#define AIC_IPR_PID20 0x100000
#define AIC_IPR_PID20_BIT 20
#define AIC_IPR_PID21_MASK 0x200000
#define AIC_IPR_PID21 0x200000
#define AIC_IPR_PID21_BIT 21
#define AIC_IPR_PID22_MASK 0x400000
#define AIC_IPR_PID22 0x400000
#define AIC_IPR_PID22_BIT 22
#define AIC_IPR_PID23_MASK 0x800000
#define AIC_IPR_PID23 0x800000
#define AIC_IPR_PID23_BIT 23
#define AIC_IPR_PID24_MASK 0x1000000
#define AIC_IPR_PID24 0x1000000
#define AIC_IPR_PID24_BIT 24
#define AIC_IPR_PID25_MASK 0x2000000
#define AIC_IPR_PID25 0x2000000
#define AIC_IPR_PID25_BIT 25
#define AIC_IPR_PID26_MASK 0x4000000
#define AIC_IPR_PID26 0x4000000
#define AIC_IPR_PID26_BIT 26
#define AIC_IPR_PID27_MASK 0x8000000
#define AIC_IPR_PID27 0x8000000
#define AIC_IPR_PID27_BIT 27
#define AIC_IPR_PID28_MASK 0x10000000
#define AIC_IPR_PID28 0x10000000
#define AIC_IPR_PID28_BIT 28
#define AIC_IPR_PID29_MASK 0x20000000
#define AIC_IPR_PID29 0x20000000
#define AIC_IPR_PID29_BIT 29
#define AIC_IPR_PID30_MASK 0x40000000
#define AIC_IPR_PID30 0x40000000
#define AIC_IPR_PID30_BIT 30
#define AIC_IPR_PID31_MASK 0x80000000
#define AIC_IPR_PID31 0x80000000
#define AIC_IPR_PID31_BIT 31

#define AIC_IMR (*(volatile unsigned long *)0xFFFFF110)
#define AIC_IMR_OFFSET 0x110
#define AIC_IMR_FIQ_MASK 0x1
#define AIC_IMR_FIQ 0x1
#define AIC_IMR_FIQ_BIT 0
#define AIC_IMR_SYS_MASK 0x2
#define AIC_IMR_SYS 0x2
#define AIC_IMR_SYS_BIT 1
#define AIC_IMR_PID0_MASK 0x1
#define AIC_IMR_PID0 0x1
#define AIC_IMR_PID0_BIT 0
#define AIC_IMR_PID1_MASK 0x2
#define AIC_IMR_PID1 0x2
#define AIC_IMR_PID1_BIT 1
#define AIC_IMR_PID2_MASK 0x4
#define AIC_IMR_PID2 0x4
#define AIC_IMR_PID2_BIT 2
#define AIC_IMR_PID3_MASK 0x8
#define AIC_IMR_PID3 0x8
#define AIC_IMR_PID3_BIT 3
#define AIC_IMR_PID4_MASK 0x10
#define AIC_IMR_PID4 0x10
#define AIC_IMR_PID4_BIT 4
#define AIC_IMR_PID5_MASK 0x20
#define AIC_IMR_PID5 0x20
#define AIC_IMR_PID5_BIT 5
#define AIC_IMR_PID6_MASK 0x40
#define AIC_IMR_PID6 0x40
#define AIC_IMR_PID6_BIT 6
#define AIC_IMR_PID7_MASK 0x80
#define AIC_IMR_PID7 0x80
#define AIC_IMR_PID7_BIT 7
#define AIC_IMR_PID8_MASK 0x100
#define AIC_IMR_PID8 0x100
#define AIC_IMR_PID8_BIT 8
#define AIC_IMR_PID9_MASK 0x200
#define AIC_IMR_PID9 0x200
#define AIC_IMR_PID9_BIT 9
#define AIC_IMR_PID10_MASK 0x400
#define AIC_IMR_PID10 0x400
#define AIC_IMR_PID10_BIT 10
#define AIC_IMR_PID11_MASK 0x800
#define AIC_IMR_PID11 0x800
#define AIC_IMR_PID11_BIT 11
#define AIC_IMR_PID12_MASK 0x1000
#define AIC_IMR_PID12 0x1000
#define AIC_IMR_PID12_BIT 12
#define AIC_IMR_PID13_MASK 0x2000
#define AIC_IMR_PID13 0x2000
#define AIC_IMR_PID13_BIT 13
#define AIC_IMR_PID14_MASK 0x4000
#define AIC_IMR_PID14 0x4000
#define AIC_IMR_PID14_BIT 14
#define AIC_IMR_PID15_MASK 0x8000
#define AIC_IMR_PID15 0x8000
#define AIC_IMR_PID15_BIT 15
#define AIC_IMR_PID16_MASK 0x10000
#define AIC_IMR_PID16 0x10000
#define AIC_IMR_PID16_BIT 16
#define AIC_IMR_PID17_MASK 0x20000
#define AIC_IMR_PID17 0x20000
#define AIC_IMR_PID17_BIT 17
#define AIC_IMR_PID18_MASK 0x40000
#define AIC_IMR_PID18 0x40000
#define AIC_IMR_PID18_BIT 18
#define AIC_IMR_PID19_MASK 0x80000
#define AIC_IMR_PID19 0x80000
#define AIC_IMR_PID19_BIT 19
#define AIC_IMR_PID20_MASK 0x100000
#define AIC_IMR_PID20 0x100000
#define AIC_IMR_PID20_BIT 20
#define AIC_IMR_PID21_MASK 0x200000
#define AIC_IMR_PID21 0x200000
#define AIC_IMR_PID21_BIT 21
#define AIC_IMR_PID22_MASK 0x400000
#define AIC_IMR_PID22 0x400000
#define AIC_IMR_PID22_BIT 22
#define AIC_IMR_PID23_MASK 0x800000
#define AIC_IMR_PID23 0x800000
#define AIC_IMR_PID23_BIT 23
#define AIC_IMR_PID24_MASK 0x1000000
#define AIC_IMR_PID24 0x1000000
#define AIC_IMR_PID24_BIT 24
#define AIC_IMR_PID25_MASK 0x2000000
#define AIC_IMR_PID25 0x2000000
#define AIC_IMR_PID25_BIT 25
#define AIC_IMR_PID26_MASK 0x4000000
#define AIC_IMR_PID26 0x4000000
#define AIC_IMR_PID26_BIT 26
#define AIC_IMR_PID27_MASK 0x8000000
#define AIC_IMR_PID27 0x8000000
#define AIC_IMR_PID27_BIT 27
#define AIC_IMR_PID28_MASK 0x10000000
#define AIC_IMR_PID28 0x10000000
#define AIC_IMR_PID28_BIT 28
#define AIC_IMR_PID29_MASK 0x20000000
#define AIC_IMR_PID29 0x20000000
#define AIC_IMR_PID29_BIT 29
#define AIC_IMR_PID30_MASK 0x40000000
#define AIC_IMR_PID30 0x40000000
#define AIC_IMR_PID30_BIT 30
#define AIC_IMR_PID31_MASK 0x80000000
#define AIC_IMR_PID31 0x80000000
#define AIC_IMR_PID31_BIT 31

#define AIC_CISR (*(volatile unsigned long *)0xFFFFF114)
#define AIC_CISR_OFFSET 0x114
#define AIC_CISR_NFIQ_MASK 0x1
#define AIC_CISR_NFIQ 0x1
#define AIC_CISR_NFIQ_BIT 0
#define AIC_CISR_NIRQ_MASK 0x2
#define AIC_CISR_NIRQ 0x2
#define AIC_CISR_NIRQ_BIT 1

#define AIC_IECR (*(volatile unsigned long *)0xFFFFF120)
#define AIC_IECR_OFFSET 0x120
#define AIC_IECR_FIQ_MASK 0x1
#define AIC_IECR_FIQ 0x1
#define AIC_IECR_FIQ_BIT 0
#define AIC_IECR_SYS_MASK 0x2
#define AIC_IECR_SYS 0x2
#define AIC_IECR_SYS_BIT 1
#define AIC_IECR_PID2_MASK 0x4
#define AIC_IECR_PID2 0x4
#define AIC_IECR_PID2_BIT 2
#define AIC_IECR_PID3_MASK 0x8
#define AIC_IECR_PID3 0x8
#define AIC_IECR_PID3_BIT 3
#define AIC_IECR_PID4_MASK 0x10
#define AIC_IECR_PID4 0x10
#define AIC_IECR_PID4_BIT 4
#define AIC_IECR_PID5_MASK 0x20
#define AIC_IECR_PID5 0x20
#define AIC_IECR_PID5_BIT 5
#define AIC_IECR_PID6_MASK 0x40
#define AIC_IECR_PID6 0x40
#define AIC_IECR_PID6_BIT 6
#define AIC_IECR_PID7_MASK 0x80
#define AIC_IECR_PID7 0x80
#define AIC_IECR_PID7_BIT 7
#define AIC_IECR_PID8_MASK 0x100
#define AIC_IECR_PID8 0x100
#define AIC_IECR_PID8_BIT 8
#define AIC_IECR_PID9_MASK 0x200
#define AIC_IECR_PID9 0x200
#define AIC_IECR_PID9_BIT 9
#define AIC_IECR_PID10_MASK 0x400
#define AIC_IECR_PID10 0x400
#define AIC_IECR_PID10_BIT 10
#define AIC_IECR_PID11_MASK 0x800
#define AIC_IECR_PID11 0x800
#define AIC_IECR_PID11_BIT 11
#define AIC_IECR_PID12_MASK 0x1000
#define AIC_IECR_PID12 0x1000
#define AIC_IECR_PID12_BIT 12
#define AIC_IECR_PID13_MASK 0x2000
#define AIC_IECR_PID13 0x2000
#define AIC_IECR_PID13_BIT 13
#define AIC_IECR_PID14_MASK 0x4000
#define AIC_IECR_PID14 0x4000
#define AIC_IECR_PID14_BIT 14
#define AIC_IECR_PID15_MASK 0x8000
#define AIC_IECR_PID15 0x8000
#define AIC_IECR_PID15_BIT 15
#define AIC_IECR_PID16_MASK 0x10000
#define AIC_IECR_PID16 0x10000
#define AIC_IECR_PID16_BIT 16
#define AIC_IECR_PID17_MASK 0x20000
#define AIC_IECR_PID17 0x20000
#define AIC_IECR_PID17_BIT 17
#define AIC_IECR_PID18_MASK 0x40000
#define AIC_IECR_PID18 0x40000
#define AIC_IECR_PID18_BIT 18
#define AIC_IECR_PID19_MASK 0x80000
#define AIC_IECR_PID19 0x80000
#define AIC_IECR_PID19_BIT 19
#define AIC_IECR_PID20_MASK 0x100000
#define AIC_IECR_PID20 0x100000
#define AIC_IECR_PID20_BIT 20
#define AIC_IECR_PID21_MASK 0x200000
#define AIC_IECR_PID21 0x200000
#define AIC_IECR_PID21_BIT 21
#define AIC_IECR_PID22_MASK 0x400000
#define AIC_IECR_PID22 0x400000
#define AIC_IECR_PID22_BIT 22
#define AIC_IECR_PID23_MASK 0x800000
#define AIC_IECR_PID23 0x800000
#define AIC_IECR_PID23_BIT 23
#define AIC_IECR_PID24_MASK 0x1000000
#define AIC_IECR_PID24 0x1000000
#define AIC_IECR_PID24_BIT 24
#define AIC_IECR_PID25_MASK 0x2000000
#define AIC_IECR_PID25 0x2000000
#define AIC_IECR_PID25_BIT 25
#define AIC_IECR_PID26_MASK 0x4000000
#define AIC_IECR_PID26 0x4000000
#define AIC_IECR_PID26_BIT 26
#define AIC_IECR_PID27_MASK 0x8000000
#define AIC_IECR_PID27 0x8000000
#define AIC_IECR_PID27_BIT 27
#define AIC_IECR_PID28_MASK 0x10000000
#define AIC_IECR_PID28 0x10000000
#define AIC_IECR_PID28_BIT 28
#define AIC_IECR_PID29_MASK 0x20000000
#define AIC_IECR_PID29 0x20000000
#define AIC_IECR_PID29_BIT 29
#define AIC_IECR_PID30_MASK 0x40000000
#define AIC_IECR_PID30 0x40000000
#define AIC_IECR_PID30_BIT 30
#define AIC_IECR_PID31_MASK 0x80000000
#define AIC_IECR_PID31 0x80000000
#define AIC_IECR_PID31_BIT 31

#define AIC_IDCR (*(volatile unsigned long *)0xFFFFF124)
#define AIC_IDCR_OFFSET 0x124
#define AIC_IDCR_FIQ_MASK 0x1
#define AIC_IDCR_FIQ 0x1
#define AIC_IDCR_FIQ_BIT 0
#define AIC_IDCR_SYS_MASK 0x2
#define AIC_IDCR_SYS 0x2
#define AIC_IDCR_SYS_BIT 1
#define AIC_IDCR_PID2_MASK 0x4
#define AIC_IDCR_PID2 0x4
#define AIC_IDCR_PID2_BIT 2
#define AIC_IDCR_PID3_MASK 0x8
#define AIC_IDCR_PID3 0x8
#define AIC_IDCR_PID3_BIT 3
#define AIC_IDCR_PID4_MASK 0x10
#define AIC_IDCR_PID4 0x10
#define AIC_IDCR_PID4_BIT 4
#define AIC_IDCR_PID5_MASK 0x20
#define AIC_IDCR_PID5 0x20
#define AIC_IDCR_PID5_BIT 5
#define AIC_IDCR_PID6_MASK 0x40
#define AIC_IDCR_PID6 0x40
#define AIC_IDCR_PID6_BIT 6
#define AIC_IDCR_PID7_MASK 0x80
#define AIC_IDCR_PID7 0x80
#define AIC_IDCR_PID7_BIT 7
#define AIC_IDCR_PID8_MASK 0x100
#define AIC_IDCR_PID8 0x100
#define AIC_IDCR_PID8_BIT 8
#define AIC_IDCR_PID9_MASK 0x200
#define AIC_IDCR_PID9 0x200
#define AIC_IDCR_PID9_BIT 9
#define AIC_IDCR_PID10_MASK 0x400
#define AIC_IDCR_PID10 0x400
#define AIC_IDCR_PID10_BIT 10
#define AIC_IDCR_PID11_MASK 0x800
#define AIC_IDCR_PID11 0x800
#define AIC_IDCR_PID11_BIT 11
#define AIC_IDCR_PID12_MASK 0x1000
#define AIC_IDCR_PID12 0x1000
#define AIC_IDCR_PID12_BIT 12
#define AIC_IDCR_PID13_MASK 0x2000
#define AIC_IDCR_PID13 0x2000
#define AIC_IDCR_PID13_BIT 13
#define AIC_IDCR_PID14_MASK 0x4000
#define AIC_IDCR_PID14 0x4000
#define AIC_IDCR_PID14_BIT 14
#define AIC_IDCR_PID15_MASK 0x8000
#define AIC_IDCR_PID15 0x8000
#define AIC_IDCR_PID15_BIT 15
#define AIC_IDCR_PID16_MASK 0x10000
#define AIC_IDCR_PID16 0x10000
#define AIC_IDCR_PID16_BIT 16
#define AIC_IDCR_PID17_MASK 0x20000
#define AIC_IDCR_PID17 0x20000
#define AIC_IDCR_PID17_BIT 17
#define AIC_IDCR_PID18_MASK 0x40000
#define AIC_IDCR_PID18 0x40000
#define AIC_IDCR_PID18_BIT 18
#define AIC_IDCR_PID19_MASK 0x80000
#define AIC_IDCR_PID19 0x80000
#define AIC_IDCR_PID19_BIT 19
#define AIC_IDCR_PID20_MASK 0x100000
#define AIC_IDCR_PID20 0x100000
#define AIC_IDCR_PID20_BIT 20
#define AIC_IDCR_PID21_MASK 0x200000
#define AIC_IDCR_PID21 0x200000
#define AIC_IDCR_PID21_BIT 21
#define AIC_IDCR_PID22_MASK 0x400000
#define AIC_IDCR_PID22 0x400000
#define AIC_IDCR_PID22_BIT 22
#define AIC_IDCR_PID23_MASK 0x800000
#define AIC_IDCR_PID23 0x800000
#define AIC_IDCR_PID23_BIT 23
#define AIC_IDCR_PID24_MASK 0x1000000
#define AIC_IDCR_PID24 0x1000000
#define AIC_IDCR_PID24_BIT 24
#define AIC_IDCR_PID25_MASK 0x2000000
#define AIC_IDCR_PID25 0x2000000
#define AIC_IDCR_PID25_BIT 25
#define AIC_IDCR_PID26_MASK 0x4000000
#define AIC_IDCR_PID26 0x4000000
#define AIC_IDCR_PID26_BIT 26
#define AIC_IDCR_PID27_MASK 0x8000000
#define AIC_IDCR_PID27 0x8000000
#define AIC_IDCR_PID27_BIT 27
#define AIC_IDCR_PID28_MASK 0x10000000
#define AIC_IDCR_PID28 0x10000000
#define AIC_IDCR_PID28_BIT 28
#define AIC_IDCR_PID29_MASK 0x20000000
#define AIC_IDCR_PID29 0x20000000
#define AIC_IDCR_PID29_BIT 29
#define AIC_IDCR_PID30_MASK 0x40000000
#define AIC_IDCR_PID30 0x40000000
#define AIC_IDCR_PID30_BIT 30
#define AIC_IDCR_PID31_MASK 0x80000000
#define AIC_IDCR_PID31 0x80000000
#define AIC_IDCR_PID31_BIT 31

#define AIC_ICCR (*(volatile unsigned long *)0xFFFFF128)
#define AIC_ICCR_OFFSET 0x128
#define AIC_ICCR_FIQ_MASK 0x1
#define AIC_ICCR_FIQ 0x1
#define AIC_ICCR_FIQ_BIT 0
#define AIC_ICCR_SYS_MASK 0x2
#define AIC_ICCR_SYS 0x2
#define AIC_ICCR_SYS_BIT 1
#define AIC_ICCR_PID2_MASK 0x4
#define AIC_ICCR_PID2 0x4
#define AIC_ICCR_PID2_BIT 2
#define AIC_ICCR_PID3_MASK 0x8
#define AIC_ICCR_PID3 0x8
#define AIC_ICCR_PID3_BIT 3
#define AIC_ICCR_PID4_MASK 0x10
#define AIC_ICCR_PID4 0x10
#define AIC_ICCR_PID4_BIT 4
#define AIC_ICCR_PID5_MASK 0x20
#define AIC_ICCR_PID5 0x20
#define AIC_ICCR_PID5_BIT 5
#define AIC_ICCR_PID6_MASK 0x40
#define AIC_ICCR_PID6 0x40
#define AIC_ICCR_PID6_BIT 6
#define AIC_ICCR_PID7_MASK 0x80
#define AIC_ICCR_PID7 0x80
#define AIC_ICCR_PID7_BIT 7
#define AIC_ICCR_PID8_MASK 0x100
#define AIC_ICCR_PID8 0x100
#define AIC_ICCR_PID8_BIT 8
#define AIC_ICCR_PID9_MASK 0x200
#define AIC_ICCR_PID9 0x200
#define AIC_ICCR_PID9_BIT 9
#define AIC_ICCR_PID10_MASK 0x400
#define AIC_ICCR_PID10 0x400
#define AIC_ICCR_PID10_BIT 10
#define AIC_ICCR_PID11_MASK 0x800
#define AIC_ICCR_PID11 0x800
#define AIC_ICCR_PID11_BIT 11
#define AIC_ICCR_PID12_MASK 0x1000
#define AIC_ICCR_PID12 0x1000
#define AIC_ICCR_PID12_BIT 12
#define AIC_ICCR_PID13_MASK 0x2000
#define AIC_ICCR_PID13 0x2000
#define AIC_ICCR_PID13_BIT 13
#define AIC_ICCR_PID14_MASK 0x4000
#define AIC_ICCR_PID14 0x4000
#define AIC_ICCR_PID14_BIT 14
#define AIC_ICCR_PID15_MASK 0x8000
#define AIC_ICCR_PID15 0x8000
#define AIC_ICCR_PID15_BIT 15
#define AIC_ICCR_PID16_MASK 0x10000
#define AIC_ICCR_PID16 0x10000
#define AIC_ICCR_PID16_BIT 16
#define AIC_ICCR_PID17_MASK 0x20000
#define AIC_ICCR_PID17 0x20000
#define AIC_ICCR_PID17_BIT 17
#define AIC_ICCR_PID18_MASK 0x40000
#define AIC_ICCR_PID18 0x40000
#define AIC_ICCR_PID18_BIT 18
#define AIC_ICCR_PID19_MASK 0x80000
#define AIC_ICCR_PID19 0x80000
#define AIC_ICCR_PID19_BIT 19
#define AIC_ICCR_PID20_MASK 0x100000
#define AIC_ICCR_PID20 0x100000
#define AIC_ICCR_PID20_BIT 20
#define AIC_ICCR_PID21_MASK 0x200000
#define AIC_ICCR_PID21 0x200000
#define AIC_ICCR_PID21_BIT 21
#define AIC_ICCR_PID22_MASK 0x400000
#define AIC_ICCR_PID22 0x400000
#define AIC_ICCR_PID22_BIT 22
#define AIC_ICCR_PID23_MASK 0x800000
#define AIC_ICCR_PID23 0x800000
#define AIC_ICCR_PID23_BIT 23
#define AIC_ICCR_PID24_MASK 0x1000000
#define AIC_ICCR_PID24 0x1000000
#define AIC_ICCR_PID24_BIT 24
#define AIC_ICCR_PID25_MASK 0x2000000
#define AIC_ICCR_PID25 0x2000000
#define AIC_ICCR_PID25_BIT 25
#define AIC_ICCR_PID26_MASK 0x4000000
#define AIC_ICCR_PID26 0x4000000
#define AIC_ICCR_PID26_BIT 26
#define AIC_ICCR_PID27_MASK 0x8000000
#define AIC_ICCR_PID27 0x8000000
#define AIC_ICCR_PID27_BIT 27
#define AIC_ICCR_PID28_MASK 0x10000000
#define AIC_ICCR_PID28 0x10000000
#define AIC_ICCR_PID28_BIT 28
#define AIC_ICCR_PID29_MASK 0x20000000
#define AIC_ICCR_PID29 0x20000000
#define AIC_ICCR_PID29_BIT 29
#define AIC_ICCR_PID30_MASK 0x40000000
#define AIC_ICCR_PID30 0x40000000
#define AIC_ICCR_PID30_BIT 30
#define AIC_ICCR_PID31_MASK 0x80000000
#define AIC_ICCR_PID31 0x80000000
#define AIC_ICCR_PID31_BIT 31

#define AIC_ISCR (*(volatile unsigned long *)0xFFFFF12C)
#define AIC_ISCR_OFFSET 0x12C
#define AIC_ISCR_FIQ_MASK 0x1
#define AIC_ISCR_FIQ 0x1
#define AIC_ISCR_FIQ_BIT 0
#define AIC_ISCR_SYS_MASK 0x2
#define AIC_ISCR_SYS 0x2
#define AIC_ISCR_SYS_BIT 1
#define AIC_ISCR_PID2_MASK 0x4
#define AIC_ISCR_PID2 0x4
#define AIC_ISCR_PID2_BIT 2
#define AIC_ISCR_PID3_MASK 0x8
#define AIC_ISCR_PID3 0x8
#define AIC_ISCR_PID3_BIT 3
#define AIC_ISCR_PID4_MASK 0x10
#define AIC_ISCR_PID4 0x10
#define AIC_ISCR_PID4_BIT 4
#define AIC_ISCR_PID5_MASK 0x20
#define AIC_ISCR_PID5 0x20
#define AIC_ISCR_PID5_BIT 5
#define AIC_ISCR_PID6_MASK 0x40
#define AIC_ISCR_PID6 0x40
#define AIC_ISCR_PID6_BIT 6
#define AIC_ISCR_PID7_MASK 0x80
#define AIC_ISCR_PID7 0x80
#define AIC_ISCR_PID7_BIT 7
#define AIC_ISCR_PID8_MASK 0x100
#define AIC_ISCR_PID8 0x100
#define AIC_ISCR_PID8_BIT 8
#define AIC_ISCR_PID9_MASK 0x200
#define AIC_ISCR_PID9 0x200
#define AIC_ISCR_PID9_BIT 9
#define AIC_ISCR_PID10_MASK 0x400
#define AIC_ISCR_PID10 0x400
#define AIC_ISCR_PID10_BIT 10
#define AIC_ISCR_PID11_MASK 0x800
#define AIC_ISCR_PID11 0x800
#define AIC_ISCR_PID11_BIT 11
#define AIC_ISCR_PID12_MASK 0x1000
#define AIC_ISCR_PID12 0x1000
#define AIC_ISCR_PID12_BIT 12
#define AIC_ISCR_PID13_MASK 0x2000
#define AIC_ISCR_PID13 0x2000
#define AIC_ISCR_PID13_BIT 13
#define AIC_ISCR_PID14_MASK 0x4000
#define AIC_ISCR_PID14 0x4000
#define AIC_ISCR_PID14_BIT 14
#define AIC_ISCR_PID15_MASK 0x8000
#define AIC_ISCR_PID15 0x8000
#define AIC_ISCR_PID15_BIT 15
#define AIC_ISCR_PID16_MASK 0x10000
#define AIC_ISCR_PID16 0x10000
#define AIC_ISCR_PID16_BIT 16
#define AIC_ISCR_PID17_MASK 0x20000
#define AIC_ISCR_PID17 0x20000
#define AIC_ISCR_PID17_BIT 17
#define AIC_ISCR_PID18_MASK 0x40000
#define AIC_ISCR_PID18 0x40000
#define AIC_ISCR_PID18_BIT 18
#define AIC_ISCR_PID19_MASK 0x80000
#define AIC_ISCR_PID19 0x80000
#define AIC_ISCR_PID19_BIT 19
#define AIC_ISCR_PID20_MASK 0x100000
#define AIC_ISCR_PID20 0x100000
#define AIC_ISCR_PID20_BIT 20
#define AIC_ISCR_PID21_MASK 0x200000
#define AIC_ISCR_PID21 0x200000
#define AIC_ISCR_PID21_BIT 21
#define AIC_ISCR_PID22_MASK 0x400000
#define AIC_ISCR_PID22 0x400000
#define AIC_ISCR_PID22_BIT 22
#define AIC_ISCR_PID23_MASK 0x800000
#define AIC_ISCR_PID23 0x800000
#define AIC_ISCR_PID23_BIT 23
#define AIC_ISCR_PID24_MASK 0x1000000
#define AIC_ISCR_PID24 0x1000000
#define AIC_ISCR_PID24_BIT 24
#define AIC_ISCR_PID25_MASK 0x2000000
#define AIC_ISCR_PID25 0x2000000
#define AIC_ISCR_PID25_BIT 25
#define AIC_ISCR_PID26_MASK 0x4000000
#define AIC_ISCR_PID26 0x4000000
#define AIC_ISCR_PID26_BIT 26
#define AIC_ISCR_PID27_MASK 0x8000000
#define AIC_ISCR_PID27 0x8000000
#define AIC_ISCR_PID27_BIT 27
#define AIC_ISCR_PID28_MASK 0x10000000
#define AIC_ISCR_PID28 0x10000000
#define AIC_ISCR_PID28_BIT 28
#define AIC_ISCR_PID29_MASK 0x20000000
#define AIC_ISCR_PID29 0x20000000
#define AIC_ISCR_PID29_BIT 29
#define AIC_ISCR_PID30_MASK 0x40000000
#define AIC_ISCR_PID30 0x40000000
#define AIC_ISCR_PID30_BIT 30
#define AIC_ISCR_PID31_MASK 0x80000000
#define AIC_ISCR_PID31 0x80000000
#define AIC_ISCR_PID31_BIT 31

#define AIC_EOICR (*(volatile unsigned long *)0xFFFFF130)
#define AIC_EOICR_OFFSET 0x130

#define AIC_SPU (*(volatile unsigned long *)0xFFFFF134)
#define AIC_SPU_OFFSET 0x134

#define AIC_DCR (*(volatile unsigned long *)0xFFFFF138)
#define AIC_DCR_OFFSET 0x138

#define DBGU_BASE 0xFFFFF200

#define DBGU_CR (*(volatile unsigned long *)0xFFFFF200)
#define DBGU_CR_OFFSET 0x0
#define DBGU_CR_RSTRX_MASK 0x4
#define DBGU_CR_RSTRX 0x4
#define DBGU_CR_RSTRX_BIT 2
#define DBGU_CR_RSTTX_MASK 0x8
#define DBGU_CR_RSTTX 0x8
#define DBGU_CR_RSTTX_BIT 3
#define DBGU_CR_RXEN_MASK 0x10
#define DBGU_CR_RXEN 0x10
#define DBGU_CR_RXEN_BIT 4
#define DBGU_CR_RXDIS_MASK 0x20
#define DBGU_CR_RXDIS 0x20
#define DBGU_CR_RXDIS_BIT 5
#define DBGU_CR_TXEN_MASK 0x40
#define DBGU_CR_TXEN 0x40
#define DBGU_CR_TXEN_BIT 6
#define DBGU_CR_TXDIS_MASK 0x80
#define DBGU_CR_TXDIS 0x80
#define DBGU_CR_TXDIS_BIT 7
#define DBGU_CR_RSTSTA_MASK 0x100
#define DBGU_CR_RSTSTA 0x100
#define DBGU_CR_RSTSTA_BIT 8

#define DBGU_MR (*(volatile unsigned long *)0xFFFFF204)
#define DBGU_MR_OFFSET 0x4
#define DBGU_MR_PAR_MASK 0xE00
#define DBGU_MR_PAR_BIT 9
#define DBGU_MR_CHMODE_MASK 0xC000
#define DBGU_MR_CHMODE_BIT 14

#define DBGU_IER (*(volatile unsigned long *)0xFFFFF208)
#define DBGU_IER_OFFSET 0x8
#define DBGU_IER_RXRDY_MASK 0x1
#define DBGU_IER_RXRDY 0x1
#define DBGU_IER_RXRDY_BIT 0
#define DBGU_IER_TXRDY_MASK 0x2
#define DBGU_IER_TXRDY 0x2
#define DBGU_IER_TXRDY_BIT 1
#define DBGU_IER_ENDRX_MASK 0x8
#define DBGU_IER_ENDRX 0x8
#define DBGU_IER_ENDRX_BIT 3
#define DBGU_IER_ENDTX_MASK 0x10
#define DBGU_IER_ENDTX 0x10
#define DBGU_IER_ENDTX_BIT 4
#define DBGU_IER_OVRE_MASK 0x20
#define DBGU_IER_OVRE 0x20
#define DBGU_IER_OVRE_BIT 5
#define DBGU_IER_FRAME_MASK 0x40
#define DBGU_IER_FRAME 0x40
#define DBGU_IER_FRAME_BIT 6
#define DBGU_IER_PARE_MASK 0x80
#define DBGU_IER_PARE 0x80
#define DBGU_IER_PARE_BIT 7
#define DBGU_IER_TXEMPTY_MASK 0x200
#define DBGU_IER_TXEMPTY 0x200
#define DBGU_IER_TXEMPTY_BIT 9
#define DBGU_IER_TXBUFE_MASK 0x800
#define DBGU_IER_TXBUFE 0x800
#define DBGU_IER_TXBUFE_BIT 11
#define DBGU_IER_RXBUFF_MASK 0x1000
#define DBGU_IER_RXBUFF 0x1000
#define DBGU_IER_RXBUFF_BIT 12
#define DBGU_IER_COMMTX_MASK 0x40000000
#define DBGU_IER_COMMTX 0x40000000
#define DBGU_IER_COMMTX_BIT 30
#define DBGU_IER_COMMRX_MASK 0x80000000
#define DBGU_IER_COMMRX 0x80000000
#define DBGU_IER_COMMRX_BIT 31

#define DBGU_IDR (*(volatile unsigned long *)0xFFFFF20C)
#define DBGU_IDR_OFFSET 0xC
#define DBGU_IDR_RXRDY_MASK 0x1
#define DBGU_IDR_RXRDY 0x1
#define DBGU_IDR_RXRDY_BIT 0
#define DBGU_IDR_TXRDY_MASK 0x2
#define DBGU_IDR_TXRDY 0x2
#define DBGU_IDR_TXRDY_BIT 1
#define DBGU_IDR_ENDRX_MASK 0x8
#define DBGU_IDR_ENDRX 0x8
#define DBGU_IDR_ENDRX_BIT 3
#define DBGU_IDR_ENDTX_MASK 0x10
#define DBGU_IDR_ENDTX 0x10
#define DBGU_IDR_ENDTX_BIT 4
#define DBGU_IDR_OVRE_MASK 0x20
#define DBGU_IDR_OVRE 0x20
#define DBGU_IDR_OVRE_BIT 5
#define DBGU_IDR_FRAME_MASK 0x40
#define DBGU_IDR_FRAME 0x40
#define DBGU_IDR_FRAME_BIT 6
#define DBGU_IDR_PARE_MASK 0x80
#define DBGU_IDR_PARE 0x80
#define DBGU_IDR_PARE_BIT 7
#define DBGU_IDR_TXEMPTY_MASK 0x200
#define DBGU_IDR_TXEMPTY 0x200
#define DBGU_IDR_TXEMPTY_BIT 9
#define DBGU_IDR_TXBUFE_MASK 0x800
#define DBGU_IDR_TXBUFE 0x800
#define DBGU_IDR_TXBUFE_BIT 11
#define DBGU_IDR_RXBUFF_MASK 0x1000
#define DBGU_IDR_RXBUFF 0x1000
#define DBGU_IDR_RXBUFF_BIT 12
#define DBGU_IDR_COMMTX_MASK 0x40000000
#define DBGU_IDR_COMMTX 0x40000000
#define DBGU_IDR_COMMTX_BIT 30
#define DBGU_IDR_COMMRX_MASK 0x80000000
#define DBGU_IDR_COMMRX 0x80000000
#define DBGU_IDR_COMMRX_BIT 31

#define DBGU_IMR (*(volatile unsigned long *)0xFFFFF210)
#define DBGU_IMR_OFFSET 0x10
#define DBGU_IMR_RXRDY_MASK 0x1
#define DBGU_IMR_RXRDY 0x1
#define DBGU_IMR_RXRDY_BIT 0
#define DBGU_IMR_TXRDY_MASK 0x2
#define DBGU_IMR_TXRDY 0x2
#define DBGU_IMR_TXRDY_BIT 1
#define DBGU_IMR_ENDRX_MASK 0x8
#define DBGU_IMR_ENDRX 0x8
#define DBGU_IMR_ENDRX_BIT 3
#define DBGU_IMR_ENDTX_MASK 0x10
#define DBGU_IMR_ENDTX 0x10
#define DBGU_IMR_ENDTX_BIT 4
#define DBGU_IMR_OVRE_MASK 0x20
#define DBGU_IMR_OVRE 0x20
#define DBGU_IMR_OVRE_BIT 5
#define DBGU_IMR_FRAME_MASK 0x40
#define DBGU_IMR_FRAME 0x40
#define DBGU_IMR_FRAME_BIT 6
#define DBGU_IMR_PARE_MASK 0x80
#define DBGU_IMR_PARE 0x80
#define DBGU_IMR_PARE_BIT 7
#define DBGU_IMR_TXEMPTY_MASK 0x200
#define DBGU_IMR_TXEMPTY 0x200
#define DBGU_IMR_TXEMPTY_BIT 9
#define DBGU_IMR_TXBUFE_MASK 0x800
#define DBGU_IMR_TXBUFE 0x800
#define DBGU_IMR_TXBUFE_BIT 11
#define DBGU_IMR_RXBUFF_MASK 0x1000
#define DBGU_IMR_RXBUFF 0x1000
#define DBGU_IMR_RXBUFF_BIT 12
#define DBGU_IMR_COMMTX_MASK 0x40000000
#define DBGU_IMR_COMMTX 0x40000000
#define DBGU_IMR_COMMTX_BIT 30
#define DBGU_IMR_COMMRX_MASK 0x80000000
#define DBGU_IMR_COMMRX 0x80000000
#define DBGU_IMR_COMMRX_BIT 31

#define DBGU_SR (*(volatile unsigned long *)0xFFFFF214)
#define DBGU_SR_OFFSET 0x14
#define DBGU_SR_RXRDY_MASK 0x1
#define DBGU_SR_RXRDY 0x1
#define DBGU_SR_RXRDY_BIT 0
#define DBGU_SR_TXRDY_MASK 0x2
#define DBGU_SR_TXRDY 0x2
#define DBGU_SR_TXRDY_BIT 1
#define DBGU_SR_ENDRX_MASK 0x8
#define DBGU_SR_ENDRX 0x8
#define DBGU_SR_ENDRX_BIT 3
#define DBGU_SR_ENDTX_MASK 0x10
#define DBGU_SR_ENDTX 0x10
#define DBGU_SR_ENDTX_BIT 4
#define DBGU_SR_OVRE_MASK 0x20
#define DBGU_SR_OVRE 0x20
#define DBGU_SR_OVRE_BIT 5
#define DBGU_SR_FRAME_MASK 0x40
#define DBGU_SR_FRAME 0x40
#define DBGU_SR_FRAME_BIT 6
#define DBGU_SR_PARE_MASK 0x80
#define DBGU_SR_PARE 0x80
#define DBGU_SR_PARE_BIT 7
#define DBGU_SR_TXEMPTY_MASK 0x200
#define DBGU_SR_TXEMPTY 0x200
#define DBGU_SR_TXEMPTY_BIT 9
#define DBGU_SR_TXBUFE_MASK 0x800
#define DBGU_SR_TXBUFE 0x800
#define DBGU_SR_TXBUFE_BIT 11
#define DBGU_SR_RXBUFF_MASK 0x1000
#define DBGU_SR_RXBUFF 0x1000
#define DBGU_SR_RXBUFF_BIT 12
#define DBGU_SR_COMMTX_MASK 0x40000000
#define DBGU_SR_COMMTX 0x40000000
#define DBGU_SR_COMMTX_BIT 30
#define DBGU_SR_COMMRX_MASK 0x80000000
#define DBGU_SR_COMMRX 0x80000000
#define DBGU_SR_COMMRX_BIT 31

#define DBGU_RHR (*(volatile unsigned long *)0xFFFFF218)
#define DBGU_RHR_OFFSET 0x18

#define DBGU_THR (*(volatile unsigned long *)0xFFFFF21C)
#define DBGU_THR_OFFSET 0x1C

#define DBGU_BRGR (*(volatile unsigned long *)0xFFFFF220)
#define DBGU_BRGR_OFFSET 0x20

#define DBGU_CIDR (*(volatile unsigned long *)0xFFFFF240)
#define DBGU_CIDR_OFFSET 0x40
#define DBGU_CIDR_VERSION_MASK 0x1F
#define DBGU_CIDR_VERSION_BIT 0
#define DBGU_CIDR_EPROC_MASK 0xE0
#define DBGU_CIDR_EPROC_BIT 5
#define DBGU_CIDR_NVPSIZ_MASK 0xF00
#define DBGU_CIDR_NVPSIZ_BIT 8
#define DBGU_CIDR_SRAMSIZ_MASK 0xF0000
#define DBGU_CIDR_SRAMSIZ_BIT 16
#define DBGU_CIDR_ARCH_MASK 0xFF00000
#define DBGU_CIDR_ARCH_BIT 20
#define DBGU_CIDR_NVPTYP_MASK 0x70000000
#define DBGU_CIDR_NVPTYP_BIT 28
#define DBGU_CIDR_EXT_MASK 0x80000000
#define DBGU_CIDR_EXT 0x80000000
#define DBGU_CIDR_EXT_BIT 31

#define DBGU_EXID (*(volatile unsigned long *)0xFFFFF244)
#define DBGU_EXID_OFFSET 0x44

#define DBGU_RPR (*(volatile unsigned long *)0xFFFFF300)
#define DBGU_RPR_OFFSET 0x100

#define DBGU_RCR (*(volatile unsigned long *)0xFFFFF304)
#define DBGU_RCR_OFFSET 0x104

#define DBGU_TPR (*(volatile unsigned long *)0xFFFFF308)
#define DBGU_TPR_OFFSET 0x108

#define DBGU_TCR (*(volatile unsigned long *)0xFFFFF30C)
#define DBGU_TCR_OFFSET 0x10C

#define DBGU_RNPR (*(volatile unsigned long *)0xFFFFF310)
#define DBGU_RNPR_OFFSET 0x110

#define DBGU_RNCR (*(volatile unsigned long *)0xFFFFF314)
#define DBGU_RNCR_OFFSET 0x114

#define DBGU_TNPR (*(volatile unsigned long *)0xFFFFF318)
#define DBGU_TNPR_OFFSET 0x118

#define DBGU_TNCR (*(volatile unsigned long *)0xFFFFF31C)
#define DBGU_TNCR_OFFSET 0x11C

#define DBGU_PTCR (*(volatile unsigned long *)0xFFFFF320)
#define DBGU_PTCR_OFFSET 0x120
#define DBGU_PTCR_RXTEN_MASK 0x1
#define DBGU_PTCR_RXTEN 0x1
#define DBGU_PTCR_RXTEN_BIT 0
#define DBGU_PTCR_RXTDIS_MASK 0x2
#define DBGU_PTCR_RXTDIS 0x2
#define DBGU_PTCR_RXTDIS_BIT 1
#define DBGU_PTCR_TXTEN_MASK 0x100
#define DBGU_PTCR_TXTEN 0x100
#define DBGU_PTCR_TXTEN_BIT 8
#define DBGU_PTCR_TXTDIS_MASK 0x200
#define DBGU_PTCR_TXTDIS 0x200
#define DBGU_PTCR_TXTDIS_BIT 9

#define DBGU_PTSR (*(volatile unsigned long *)0xFFFFF324)
#define DBGU_PTSR_OFFSET 0x124
#define DBGU_PTSR_RXTEN_MASK 0x1
#define DBGU_PTSR_RXTEN 0x1
#define DBGU_PTSR_RXTEN_BIT 0
#define DBGU_PTSR_TXTEN_MASK 0x100
#define DBGU_PTSR_TXTEN 0x100
#define DBGU_PTSR_TXTEN_BIT 8

#define PIOA_BASE 0xFFFFF400

#define PIOA_PER (*(volatile unsigned long *)0xFFFFF400)
#define PIOA_PER_OFFSET 0x0
#define PIOA_PER_P0_MASK 0x1
#define PIOA_PER_P0 0x1
#define PIOA_PER_P0_BIT 0
#define PIOA_PER_P1_MASK 0x2
#define PIOA_PER_P1 0x2
#define PIOA_PER_P1_BIT 1
#define PIOA_PER_P2_MASK 0x4
#define PIOA_PER_P2 0x4
#define PIOA_PER_P2_BIT 2
#define PIOA_PER_P3_MASK 0x8
#define PIOA_PER_P3 0x8
#define PIOA_PER_P3_BIT 3
#define PIOA_PER_P4_MASK 0x10
#define PIOA_PER_P4 0x10
#define PIOA_PER_P4_BIT 4
#define PIOA_PER_P5_MASK 0x20
#define PIOA_PER_P5 0x20
#define PIOA_PER_P5_BIT 5
#define PIOA_PER_P6_MASK 0x40
#define PIOA_PER_P6 0x40
#define PIOA_PER_P6_BIT 6
#define PIOA_PER_P7_MASK 0x80
#define PIOA_PER_P7 0x80
#define PIOA_PER_P7_BIT 7
#define PIOA_PER_P8_MASK 0x100
#define PIOA_PER_P8 0x100
#define PIOA_PER_P8_BIT 8
#define PIOA_PER_P9_MASK 0x200
#define PIOA_PER_P9 0x200
#define PIOA_PER_P9_BIT 9
#define PIOA_PER_P10_MASK 0x400
#define PIOA_PER_P10 0x400
#define PIOA_PER_P10_BIT 10
#define PIOA_PER_P11_MASK 0x800
#define PIOA_PER_P11 0x800
#define PIOA_PER_P11_BIT 11
#define PIOA_PER_P12_MASK 0x1000
#define PIOA_PER_P12 0x1000
#define PIOA_PER_P12_BIT 12
#define PIOA_PER_P13_MASK 0x2000
#define PIOA_PER_P13 0x2000
#define PIOA_PER_P13_BIT 13
#define PIOA_PER_P14_MASK 0x4000
#define PIOA_PER_P14 0x4000
#define PIOA_PER_P14_BIT 14
#define PIOA_PER_P15_MASK 0x8000
#define PIOA_PER_P15 0x8000
#define PIOA_PER_P15_BIT 15
#define PIOA_PER_P16_MASK 0x10000
#define PIOA_PER_P16 0x10000
#define PIOA_PER_P16_BIT 16
#define PIOA_PER_P17_MASK 0x20000
#define PIOA_PER_P17 0x20000
#define PIOA_PER_P17_BIT 17
#define PIOA_PER_P18_MASK 0x40000
#define PIOA_PER_P18 0x40000
#define PIOA_PER_P18_BIT 18
#define PIOA_PER_P19_MASK 0x80000
#define PIOA_PER_P19 0x80000
#define PIOA_PER_P19_BIT 19
#define PIOA_PER_P20_MASK 0x100000
#define PIOA_PER_P20 0x100000
#define PIOA_PER_P20_BIT 20
#define PIOA_PER_P21_MASK 0x200000
#define PIOA_PER_P21 0x200000
#define PIOA_PER_P21_BIT 21
#define PIOA_PER_P22_MASK 0x400000
#define PIOA_PER_P22 0x400000
#define PIOA_PER_P22_BIT 22
#define PIOA_PER_P23_MASK 0x800000
#define PIOA_PER_P23 0x800000
#define PIOA_PER_P23_BIT 23
#define PIOA_PER_P24_MASK 0x1000000
#define PIOA_PER_P24 0x1000000
#define PIOA_PER_P24_BIT 24
#define PIOA_PER_P25_MASK 0x2000000
#define PIOA_PER_P25 0x2000000
#define PIOA_PER_P25_BIT 25
#define PIOA_PER_P26_MASK 0x4000000
#define PIOA_PER_P26 0x4000000
#define PIOA_PER_P26_BIT 26
#define PIOA_PER_P27_MASK 0x8000000
#define PIOA_PER_P27 0x8000000
#define PIOA_PER_P27_BIT 27
#define PIOA_PER_P28_MASK 0x10000000
#define PIOA_PER_P28 0x10000000
#define PIOA_PER_P28_BIT 28
#define PIOA_PER_P29_MASK 0x20000000
#define PIOA_PER_P29 0x20000000
#define PIOA_PER_P29_BIT 29
#define PIOA_PER_P30_MASK 0x40000000
#define PIOA_PER_P30 0x40000000
#define PIOA_PER_P30_BIT 30
#define PIOA_PER_P31_MASK 0x80000000
#define PIOA_PER_P31 0x80000000
#define PIOA_PER_P31_BIT 31

#define PIOA_PDR (*(volatile unsigned long *)0xFFFFF404)
#define PIOA_PDR_OFFSET 0x4
#define PIOA_PDR_P0_MASK 0x1
#define PIOA_PDR_P0 0x1
#define PIOA_PDR_P0_BIT 0
#define PIOA_PDR_P1_MASK 0x2
#define PIOA_PDR_P1 0x2
#define PIOA_PDR_P1_BIT 1
#define PIOA_PDR_P2_MASK 0x4
#define PIOA_PDR_P2 0x4
#define PIOA_PDR_P2_BIT 2
#define PIOA_PDR_P3_MASK 0x8
#define PIOA_PDR_P3 0x8
#define PIOA_PDR_P3_BIT 3
#define PIOA_PDR_P4_MASK 0x10
#define PIOA_PDR_P4 0x10
#define PIOA_PDR_P4_BIT 4
#define PIOA_PDR_P5_MASK 0x20
#define PIOA_PDR_P5 0x20
#define PIOA_PDR_P5_BIT 5
#define PIOA_PDR_P6_MASK 0x40
#define PIOA_PDR_P6 0x40
#define PIOA_PDR_P6_BIT 6
#define PIOA_PDR_P7_MASK 0x80
#define PIOA_PDR_P7 0x80
#define PIOA_PDR_P7_BIT 7
#define PIOA_PDR_P8_MASK 0x100
#define PIOA_PDR_P8 0x100
#define PIOA_PDR_P8_BIT 8
#define PIOA_PDR_P9_MASK 0x200
#define PIOA_PDR_P9 0x200
#define PIOA_PDR_P9_BIT 9
#define PIOA_PDR_P10_MASK 0x400
#define PIOA_PDR_P10 0x400
#define PIOA_PDR_P10_BIT 10
#define PIOA_PDR_P11_MASK 0x800
#define PIOA_PDR_P11 0x800
#define PIOA_PDR_P11_BIT 11
#define PIOA_PDR_P12_MASK 0x1000
#define PIOA_PDR_P12 0x1000
#define PIOA_PDR_P12_BIT 12
#define PIOA_PDR_P13_MASK 0x2000
#define PIOA_PDR_P13 0x2000
#define PIOA_PDR_P13_BIT 13
#define PIOA_PDR_P14_MASK 0x4000
#define PIOA_PDR_P14 0x4000
#define PIOA_PDR_P14_BIT 14
#define PIOA_PDR_P15_MASK 0x8000
#define PIOA_PDR_P15 0x8000
#define PIOA_PDR_P15_BIT 15
#define PIOA_PDR_P16_MASK 0x10000
#define PIOA_PDR_P16 0x10000
#define PIOA_PDR_P16_BIT 16
#define PIOA_PDR_P17_MASK 0x20000
#define PIOA_PDR_P17 0x20000
#define PIOA_PDR_P17_BIT 17
#define PIOA_PDR_P18_MASK 0x40000
#define PIOA_PDR_P18 0x40000
#define PIOA_PDR_P18_BIT 18
#define PIOA_PDR_P19_MASK 0x80000
#define PIOA_PDR_P19 0x80000
#define PIOA_PDR_P19_BIT 19
#define PIOA_PDR_P20_MASK 0x100000
#define PIOA_PDR_P20 0x100000
#define PIOA_PDR_P20_BIT 20
#define PIOA_PDR_P21_MASK 0x200000
#define PIOA_PDR_P21 0x200000
#define PIOA_PDR_P21_BIT 21
#define PIOA_PDR_P22_MASK 0x400000
#define PIOA_PDR_P22 0x400000
#define PIOA_PDR_P22_BIT 22
#define PIOA_PDR_P23_MASK 0x800000
#define PIOA_PDR_P23 0x800000
#define PIOA_PDR_P23_BIT 23
#define PIOA_PDR_P24_MASK 0x1000000
#define PIOA_PDR_P24 0x1000000
#define PIOA_PDR_P24_BIT 24
#define PIOA_PDR_P25_MASK 0x2000000
#define PIOA_PDR_P25 0x2000000
#define PIOA_PDR_P25_BIT 25
#define PIOA_PDR_P26_MASK 0x4000000
#define PIOA_PDR_P26 0x4000000
#define PIOA_PDR_P26_BIT 26
#define PIOA_PDR_P27_MASK 0x8000000
#define PIOA_PDR_P27 0x8000000
#define PIOA_PDR_P27_BIT 27
#define PIOA_PDR_P28_MASK 0x10000000
#define PIOA_PDR_P28 0x10000000
#define PIOA_PDR_P28_BIT 28
#define PIOA_PDR_P29_MASK 0x20000000
#define PIOA_PDR_P29 0x20000000
#define PIOA_PDR_P29_BIT 29
#define PIOA_PDR_P30_MASK 0x40000000
#define PIOA_PDR_P30 0x40000000
#define PIOA_PDR_P30_BIT 30
#define PIOA_PDR_P31_MASK 0x80000000
#define PIOA_PDR_P31 0x80000000
#define PIOA_PDR_P31_BIT 31

#define PIOA_PSR (*(volatile unsigned long *)0xFFFFF408)
#define PIOA_PSR_OFFSET 0x8
#define PIOA_PSR_P0_MASK 0x1
#define PIOA_PSR_P0 0x1
#define PIOA_PSR_P0_BIT 0
#define PIOA_PSR_P1_MASK 0x2
#define PIOA_PSR_P1 0x2
#define PIOA_PSR_P1_BIT 1
#define PIOA_PSR_P2_MASK 0x4
#define PIOA_PSR_P2 0x4
#define PIOA_PSR_P2_BIT 2
#define PIOA_PSR_P3_MASK 0x8
#define PIOA_PSR_P3 0x8
#define PIOA_PSR_P3_BIT 3
#define PIOA_PSR_P4_MASK 0x10
#define PIOA_PSR_P4 0x10
#define PIOA_PSR_P4_BIT 4
#define PIOA_PSR_P5_MASK 0x20
#define PIOA_PSR_P5 0x20
#define PIOA_PSR_P5_BIT 5
#define PIOA_PSR_P6_MASK 0x40
#define PIOA_PSR_P6 0x40
#define PIOA_PSR_P6_BIT 6
#define PIOA_PSR_P7_MASK 0x80
#define PIOA_PSR_P7 0x80
#define PIOA_PSR_P7_BIT 7
#define PIOA_PSR_P8_MASK 0x100
#define PIOA_PSR_P8 0x100
#define PIOA_PSR_P8_BIT 8
#define PIOA_PSR_P9_MASK 0x200
#define PIOA_PSR_P9 0x200
#define PIOA_PSR_P9_BIT 9
#define PIOA_PSR_P10_MASK 0x400
#define PIOA_PSR_P10 0x400
#define PIOA_PSR_P10_BIT 10
#define PIOA_PSR_P11_MASK 0x800
#define PIOA_PSR_P11 0x800
#define PIOA_PSR_P11_BIT 11
#define PIOA_PSR_P12_MASK 0x1000
#define PIOA_PSR_P12 0x1000
#define PIOA_PSR_P12_BIT 12
#define PIOA_PSR_P13_MASK 0x2000
#define PIOA_PSR_P13 0x2000
#define PIOA_PSR_P13_BIT 13
#define PIOA_PSR_P14_MASK 0x4000
#define PIOA_PSR_P14 0x4000
#define PIOA_PSR_P14_BIT 14
#define PIOA_PSR_P15_MASK 0x8000
#define PIOA_PSR_P15 0x8000
#define PIOA_PSR_P15_BIT 15
#define PIOA_PSR_P16_MASK 0x10000
#define PIOA_PSR_P16 0x10000
#define PIOA_PSR_P16_BIT 16
#define PIOA_PSR_P17_MASK 0x20000
#define PIOA_PSR_P17 0x20000
#define PIOA_PSR_P17_BIT 17
#define PIOA_PSR_P18_MASK 0x40000
#define PIOA_PSR_P18 0x40000
#define PIOA_PSR_P18_BIT 18
#define PIOA_PSR_P19_MASK 0x80000
#define PIOA_PSR_P19 0x80000
#define PIOA_PSR_P19_BIT 19
#define PIOA_PSR_P20_MASK 0x100000
#define PIOA_PSR_P20 0x100000
#define PIOA_PSR_P20_BIT 20
#define PIOA_PSR_P21_MASK 0x200000
#define PIOA_PSR_P21 0x200000
#define PIOA_PSR_P21_BIT 21
#define PIOA_PSR_P22_MASK 0x400000
#define PIOA_PSR_P22 0x400000
#define PIOA_PSR_P22_BIT 22
#define PIOA_PSR_P23_MASK 0x800000
#define PIOA_PSR_P23 0x800000
#define PIOA_PSR_P23_BIT 23
#define PIOA_PSR_P24_MASK 0x1000000
#define PIOA_PSR_P24 0x1000000
#define PIOA_PSR_P24_BIT 24
#define PIOA_PSR_P25_MASK 0x2000000
#define PIOA_PSR_P25 0x2000000
#define PIOA_PSR_P25_BIT 25
#define PIOA_PSR_P26_MASK 0x4000000
#define PIOA_PSR_P26 0x4000000
#define PIOA_PSR_P26_BIT 26
#define PIOA_PSR_P27_MASK 0x8000000
#define PIOA_PSR_P27 0x8000000
#define PIOA_PSR_P27_BIT 27
#define PIOA_PSR_P28_MASK 0x10000000
#define PIOA_PSR_P28 0x10000000
#define PIOA_PSR_P28_BIT 28
#define PIOA_PSR_P29_MASK 0x20000000
#define PIOA_PSR_P29 0x20000000
#define PIOA_PSR_P29_BIT 29
#define PIOA_PSR_P30_MASK 0x40000000
#define PIOA_PSR_P30 0x40000000
#define PIOA_PSR_P30_BIT 30
#define PIOA_PSR_P31_MASK 0x80000000
#define PIOA_PSR_P31 0x80000000
#define PIOA_PSR_P31_BIT 31

#define PIOA_OER (*(volatile unsigned long *)0xFFFFF410)
#define PIOA_OER_OFFSET 0x10
#define PIOA_OER_P0_MASK 0x1
#define PIOA_OER_P0 0x1
#define PIOA_OER_P0_BIT 0
#define PIOA_OER_P1_MASK 0x2
#define PIOA_OER_P1 0x2
#define PIOA_OER_P1_BIT 1
#define PIOA_OER_P2_MASK 0x4
#define PIOA_OER_P2 0x4
#define PIOA_OER_P2_BIT 2
#define PIOA_OER_P3_MASK 0x8
#define PIOA_OER_P3 0x8
#define PIOA_OER_P3_BIT 3
#define PIOA_OER_P4_MASK 0x10
#define PIOA_OER_P4 0x10
#define PIOA_OER_P4_BIT 4
#define PIOA_OER_P5_MASK 0x20
#define PIOA_OER_P5 0x20
#define PIOA_OER_P5_BIT 5
#define PIOA_OER_P6_MASK 0x40
#define PIOA_OER_P6 0x40
#define PIOA_OER_P6_BIT 6
#define PIOA_OER_P7_MASK 0x80
#define PIOA_OER_P7 0x80
#define PIOA_OER_P7_BIT 7
#define PIOA_OER_P8_MASK 0x100
#define PIOA_OER_P8 0x100
#define PIOA_OER_P8_BIT 8
#define PIOA_OER_P9_MASK 0x200
#define PIOA_OER_P9 0x200
#define PIOA_OER_P9_BIT 9
#define PIOA_OER_P10_MASK 0x400
#define PIOA_OER_P10 0x400
#define PIOA_OER_P10_BIT 10
#define PIOA_OER_P11_MASK 0x800
#define PIOA_OER_P11 0x800
#define PIOA_OER_P11_BIT 11
#define PIOA_OER_P12_MASK 0x1000
#define PIOA_OER_P12 0x1000
#define PIOA_OER_P12_BIT 12
#define PIOA_OER_P13_MASK 0x2000
#define PIOA_OER_P13 0x2000
#define PIOA_OER_P13_BIT 13
#define PIOA_OER_P14_MASK 0x4000
#define PIOA_OER_P14 0x4000
#define PIOA_OER_P14_BIT 14
#define PIOA_OER_P15_MASK 0x8000
#define PIOA_OER_P15 0x8000
#define PIOA_OER_P15_BIT 15
#define PIOA_OER_P16_MASK 0x10000
#define PIOA_OER_P16 0x10000
#define PIOA_OER_P16_BIT 16
#define PIOA_OER_P17_MASK 0x20000
#define PIOA_OER_P17 0x20000
#define PIOA_OER_P17_BIT 17
#define PIOA_OER_P18_MASK 0x40000
#define PIOA_OER_P18 0x40000
#define PIOA_OER_P18_BIT 18
#define PIOA_OER_P19_MASK 0x80000
#define PIOA_OER_P19 0x80000
#define PIOA_OER_P19_BIT 19
#define PIOA_OER_P20_MASK 0x100000
#define PIOA_OER_P20 0x100000
#define PIOA_OER_P20_BIT 20
#define PIOA_OER_P21_MASK 0x200000
#define PIOA_OER_P21 0x200000
#define PIOA_OER_P21_BIT 21
#define PIOA_OER_P22_MASK 0x400000
#define PIOA_OER_P22 0x400000
#define PIOA_OER_P22_BIT 22
#define PIOA_OER_P23_MASK 0x800000
#define PIOA_OER_P23 0x800000
#define PIOA_OER_P23_BIT 23
#define PIOA_OER_P24_MASK 0x1000000
#define PIOA_OER_P24 0x1000000
#define PIOA_OER_P24_BIT 24
#define PIOA_OER_P25_MASK 0x2000000
#define PIOA_OER_P25 0x2000000
#define PIOA_OER_P25_BIT 25
#define PIOA_OER_P26_MASK 0x4000000
#define PIOA_OER_P26 0x4000000
#define PIOA_OER_P26_BIT 26
#define PIOA_OER_P27_MASK 0x8000000
#define PIOA_OER_P27 0x8000000
#define PIOA_OER_P27_BIT 27
#define PIOA_OER_P28_MASK 0x10000000
#define PIOA_OER_P28 0x10000000
#define PIOA_OER_P28_BIT 28
#define PIOA_OER_P29_MASK 0x20000000
#define PIOA_OER_P29 0x20000000
#define PIOA_OER_P29_BIT 29
#define PIOA_OER_P30_MASK 0x40000000
#define PIOA_OER_P30 0x40000000
#define PIOA_OER_P30_BIT 30
#define PIOA_OER_P31_MASK 0x80000000
#define PIOA_OER_P31 0x80000000
#define PIOA_OER_P31_BIT 31

#define PIOA_ODR (*(volatile unsigned long *)0xFFFFF414)
#define PIOA_ODR_OFFSET 0x14
#define PIOA_ODR_P0_MASK 0x1
#define PIOA_ODR_P0 0x1
#define PIOA_ODR_P0_BIT 0
#define PIOA_ODR_P1_MASK 0x2
#define PIOA_ODR_P1 0x2
#define PIOA_ODR_P1_BIT 1
#define PIOA_ODR_P2_MASK 0x4
#define PIOA_ODR_P2 0x4
#define PIOA_ODR_P2_BIT 2
#define PIOA_ODR_P3_MASK 0x8
#define PIOA_ODR_P3 0x8
#define PIOA_ODR_P3_BIT 3
#define PIOA_ODR_P4_MASK 0x10
#define PIOA_ODR_P4 0x10
#define PIOA_ODR_P4_BIT 4
#define PIOA_ODR_P5_MASK 0x20
#define PIOA_ODR_P5 0x20
#define PIOA_ODR_P5_BIT 5
#define PIOA_ODR_P6_MASK 0x40
#define PIOA_ODR_P6 0x40
#define PIOA_ODR_P6_BIT 6
#define PIOA_ODR_P7_MASK 0x80
#define PIOA_ODR_P7 0x80
#define PIOA_ODR_P7_BIT 7
#define PIOA_ODR_P8_MASK 0x100
#define PIOA_ODR_P8 0x100
#define PIOA_ODR_P8_BIT 8
#define PIOA_ODR_P9_MASK 0x200
#define PIOA_ODR_P9 0x200
#define PIOA_ODR_P9_BIT 9
#define PIOA_ODR_P10_MASK 0x400
#define PIOA_ODR_P10 0x400
#define PIOA_ODR_P10_BIT 10
#define PIOA_ODR_P11_MASK 0x800
#define PIOA_ODR_P11 0x800
#define PIOA_ODR_P11_BIT 11
#define PIOA_ODR_P12_MASK 0x1000
#define PIOA_ODR_P12 0x1000
#define PIOA_ODR_P12_BIT 12
#define PIOA_ODR_P13_MASK 0x2000
#define PIOA_ODR_P13 0x2000
#define PIOA_ODR_P13_BIT 13
#define PIOA_ODR_P14_MASK 0x4000
#define PIOA_ODR_P14 0x4000
#define PIOA_ODR_P14_BIT 14
#define PIOA_ODR_P15_MASK 0x8000
#define PIOA_ODR_P15 0x8000
#define PIOA_ODR_P15_BIT 15
#define PIOA_ODR_P16_MASK 0x10000
#define PIOA_ODR_P16 0x10000
#define PIOA_ODR_P16_BIT 16
#define PIOA_ODR_P17_MASK 0x20000
#define PIOA_ODR_P17 0x20000
#define PIOA_ODR_P17_BIT 17
#define PIOA_ODR_P18_MASK 0x40000
#define PIOA_ODR_P18 0x40000
#define PIOA_ODR_P18_BIT 18
#define PIOA_ODR_P19_MASK 0x80000
#define PIOA_ODR_P19 0x80000
#define PIOA_ODR_P19_BIT 19
#define PIOA_ODR_P20_MASK 0x100000
#define PIOA_ODR_P20 0x100000
#define PIOA_ODR_P20_BIT 20
#define PIOA_ODR_P21_MASK 0x200000
#define PIOA_ODR_P21 0x200000
#define PIOA_ODR_P21_BIT 21
#define PIOA_ODR_P22_MASK 0x400000
#define PIOA_ODR_P22 0x400000
#define PIOA_ODR_P22_BIT 22
#define PIOA_ODR_P23_MASK 0x800000
#define PIOA_ODR_P23 0x800000
#define PIOA_ODR_P23_BIT 23
#define PIOA_ODR_P24_MASK 0x1000000
#define PIOA_ODR_P24 0x1000000
#define PIOA_ODR_P24_BIT 24
#define PIOA_ODR_P25_MASK 0x2000000
#define PIOA_ODR_P25 0x2000000
#define PIOA_ODR_P25_BIT 25
#define PIOA_ODR_P26_MASK 0x4000000
#define PIOA_ODR_P26 0x4000000
#define PIOA_ODR_P26_BIT 26
#define PIOA_ODR_P27_MASK 0x8000000
#define PIOA_ODR_P27 0x8000000
#define PIOA_ODR_P27_BIT 27
#define PIOA_ODR_P28_MASK 0x10000000
#define PIOA_ODR_P28 0x10000000
#define PIOA_ODR_P28_BIT 28
#define PIOA_ODR_P29_MASK 0x20000000
#define PIOA_ODR_P29 0x20000000
#define PIOA_ODR_P29_BIT 29
#define PIOA_ODR_P30_MASK 0x40000000
#define PIOA_ODR_P30 0x40000000
#define PIOA_ODR_P30_BIT 30
#define PIOA_ODR_P31_MASK 0x80000000
#define PIOA_ODR_P31 0x80000000
#define PIOA_ODR_P31_BIT 31

#define PIOA_OSR (*(volatile unsigned long *)0xFFFFF418)
#define PIOA_OSR_OFFSET 0x18
#define PIOA_OSR_P0_MASK 0x1
#define PIOA_OSR_P0 0x1
#define PIOA_OSR_P0_BIT 0
#define PIOA_OSR_P1_MASK 0x2
#define PIOA_OSR_P1 0x2
#define PIOA_OSR_P1_BIT 1
#define PIOA_OSR_P2_MASK 0x4
#define PIOA_OSR_P2 0x4
#define PIOA_OSR_P2_BIT 2
#define PIOA_OSR_P3_MASK 0x8
#define PIOA_OSR_P3 0x8
#define PIOA_OSR_P3_BIT 3
#define PIOA_OSR_P4_MASK 0x10
#define PIOA_OSR_P4 0x10
#define PIOA_OSR_P4_BIT 4
#define PIOA_OSR_P5_MASK 0x20
#define PIOA_OSR_P5 0x20
#define PIOA_OSR_P5_BIT 5
#define PIOA_OSR_P6_MASK 0x40
#define PIOA_OSR_P6 0x40
#define PIOA_OSR_P6_BIT 6
#define PIOA_OSR_P7_MASK 0x80
#define PIOA_OSR_P7 0x80
#define PIOA_OSR_P7_BIT 7
#define PIOA_OSR_P8_MASK 0x100
#define PIOA_OSR_P8 0x100
#define PIOA_OSR_P8_BIT 8
#define PIOA_OSR_P9_MASK 0x200
#define PIOA_OSR_P9 0x200
#define PIOA_OSR_P9_BIT 9
#define PIOA_OSR_P10_MASK 0x400
#define PIOA_OSR_P10 0x400
#define PIOA_OSR_P10_BIT 10
#define PIOA_OSR_P11_MASK 0x800
#define PIOA_OSR_P11 0x800
#define PIOA_OSR_P11_BIT 11
#define PIOA_OSR_P12_MASK 0x1000
#define PIOA_OSR_P12 0x1000
#define PIOA_OSR_P12_BIT 12
#define PIOA_OSR_P13_MASK 0x2000
#define PIOA_OSR_P13 0x2000
#define PIOA_OSR_P13_BIT 13
#define PIOA_OSR_P14_MASK 0x4000
#define PIOA_OSR_P14 0x4000
#define PIOA_OSR_P14_BIT 14
#define PIOA_OSR_P15_MASK 0x8000
#define PIOA_OSR_P15 0x8000
#define PIOA_OSR_P15_BIT 15
#define PIOA_OSR_P16_MASK 0x10000
#define PIOA_OSR_P16 0x10000
#define PIOA_OSR_P16_BIT 16
#define PIOA_OSR_P17_MASK 0x20000
#define PIOA_OSR_P17 0x20000
#define PIOA_OSR_P17_BIT 17
#define PIOA_OSR_P18_MASK 0x40000
#define PIOA_OSR_P18 0x40000
#define PIOA_OSR_P18_BIT 18
#define PIOA_OSR_P19_MASK 0x80000
#define PIOA_OSR_P19 0x80000
#define PIOA_OSR_P19_BIT 19
#define PIOA_OSR_P20_MASK 0x100000
#define PIOA_OSR_P20 0x100000
#define PIOA_OSR_P20_BIT 20
#define PIOA_OSR_P21_MASK 0x200000
#define PIOA_OSR_P21 0x200000
#define PIOA_OSR_P21_BIT 21
#define PIOA_OSR_P22_MASK 0x400000
#define PIOA_OSR_P22 0x400000
#define PIOA_OSR_P22_BIT 22
#define PIOA_OSR_P23_MASK 0x800000
#define PIOA_OSR_P23 0x800000
#define PIOA_OSR_P23_BIT 23
#define PIOA_OSR_P24_MASK 0x1000000
#define PIOA_OSR_P24 0x1000000
#define PIOA_OSR_P24_BIT 24
#define PIOA_OSR_P25_MASK 0x2000000
#define PIOA_OSR_P25 0x2000000
#define PIOA_OSR_P25_BIT 25
#define PIOA_OSR_P26_MASK 0x4000000
#define PIOA_OSR_P26 0x4000000
#define PIOA_OSR_P26_BIT 26
#define PIOA_OSR_P27_MASK 0x8000000
#define PIOA_OSR_P27 0x8000000
#define PIOA_OSR_P27_BIT 27
#define PIOA_OSR_P28_MASK 0x10000000
#define PIOA_OSR_P28 0x10000000
#define PIOA_OSR_P28_BIT 28
#define PIOA_OSR_P29_MASK 0x20000000
#define PIOA_OSR_P29 0x20000000
#define PIOA_OSR_P29_BIT 29
#define PIOA_OSR_P30_MASK 0x40000000
#define PIOA_OSR_P30 0x40000000
#define PIOA_OSR_P30_BIT 30
#define PIOA_OSR_P31_MASK 0x80000000
#define PIOA_OSR_P31 0x80000000
#define PIOA_OSR_P31_BIT 31

#define PIOA_IFER (*(volatile unsigned long *)0xFFFFF420)
#define PIOA_IFER_OFFSET 0x20
#define PIOA_IFER_P0_MASK 0x1
#define PIOA_IFER_P0 0x1
#define PIOA_IFER_P0_BIT 0
#define PIOA_IFER_P1_MASK 0x2
#define PIOA_IFER_P1 0x2
#define PIOA_IFER_P1_BIT 1
#define PIOA_IFER_P2_MASK 0x4
#define PIOA_IFER_P2 0x4
#define PIOA_IFER_P2_BIT 2
#define PIOA_IFER_P3_MASK 0x8
#define PIOA_IFER_P3 0x8
#define PIOA_IFER_P3_BIT 3
#define PIOA_IFER_P4_MASK 0x10
#define PIOA_IFER_P4 0x10
#define PIOA_IFER_P4_BIT 4
#define PIOA_IFER_P5_MASK 0x20
#define PIOA_IFER_P5 0x20
#define PIOA_IFER_P5_BIT 5
#define PIOA_IFER_P6_MASK 0x40
#define PIOA_IFER_P6 0x40
#define PIOA_IFER_P6_BIT 6
#define PIOA_IFER_P7_MASK 0x80
#define PIOA_IFER_P7 0x80
#define PIOA_IFER_P7_BIT 7
#define PIOA_IFER_P8_MASK 0x100
#define PIOA_IFER_P8 0x100
#define PIOA_IFER_P8_BIT 8
#define PIOA_IFER_P9_MASK 0x200
#define PIOA_IFER_P9 0x200
#define PIOA_IFER_P9_BIT 9
#define PIOA_IFER_P10_MASK 0x400
#define PIOA_IFER_P10 0x400
#define PIOA_IFER_P10_BIT 10
#define PIOA_IFER_P11_MASK 0x800
#define PIOA_IFER_P11 0x800
#define PIOA_IFER_P11_BIT 11
#define PIOA_IFER_P12_MASK 0x1000
#define PIOA_IFER_P12 0x1000
#define PIOA_IFER_P12_BIT 12
#define PIOA_IFER_P13_MASK 0x2000
#define PIOA_IFER_P13 0x2000
#define PIOA_IFER_P13_BIT 13
#define PIOA_IFER_P14_MASK 0x4000
#define PIOA_IFER_P14 0x4000
#define PIOA_IFER_P14_BIT 14
#define PIOA_IFER_P15_MASK 0x8000
#define PIOA_IFER_P15 0x8000
#define PIOA_IFER_P15_BIT 15
#define PIOA_IFER_P16_MASK 0x10000
#define PIOA_IFER_P16 0x10000
#define PIOA_IFER_P16_BIT 16
#define PIOA_IFER_P17_MASK 0x20000
#define PIOA_IFER_P17 0x20000
#define PIOA_IFER_P17_BIT 17
#define PIOA_IFER_P18_MASK 0x40000
#define PIOA_IFER_P18 0x40000
#define PIOA_IFER_P18_BIT 18
#define PIOA_IFER_P19_MASK 0x80000
#define PIOA_IFER_P19 0x80000
#define PIOA_IFER_P19_BIT 19
#define PIOA_IFER_P20_MASK 0x100000
#define PIOA_IFER_P20 0x100000
#define PIOA_IFER_P20_BIT 20
#define PIOA_IFER_P21_MASK 0x200000
#define PIOA_IFER_P21 0x200000
#define PIOA_IFER_P21_BIT 21
#define PIOA_IFER_P22_MASK 0x400000
#define PIOA_IFER_P22 0x400000
#define PIOA_IFER_P22_BIT 22
#define PIOA_IFER_P23_MASK 0x800000
#define PIOA_IFER_P23 0x800000
#define PIOA_IFER_P23_BIT 23
#define PIOA_IFER_P24_MASK 0x1000000
#define PIOA_IFER_P24 0x1000000
#define PIOA_IFER_P24_BIT 24
#define PIOA_IFER_P25_MASK 0x2000000
#define PIOA_IFER_P25 0x2000000
#define PIOA_IFER_P25_BIT 25
#define PIOA_IFER_P26_MASK 0x4000000
#define PIOA_IFER_P26 0x4000000
#define PIOA_IFER_P26_BIT 26
#define PIOA_IFER_P27_MASK 0x8000000
#define PIOA_IFER_P27 0x8000000
#define PIOA_IFER_P27_BIT 27
#define PIOA_IFER_P28_MASK 0x10000000
#define PIOA_IFER_P28 0x10000000
#define PIOA_IFER_P28_BIT 28
#define PIOA_IFER_P29_MASK 0x20000000
#define PIOA_IFER_P29 0x20000000
#define PIOA_IFER_P29_BIT 29
#define PIOA_IFER_P30_MASK 0x40000000
#define PIOA_IFER_P30 0x40000000
#define PIOA_IFER_P30_BIT 30
#define PIOA_IFER_P31_MASK 0x80000000
#define PIOA_IFER_P31 0x80000000
#define PIOA_IFER_P31_BIT 31

#define PIOA_IFDR (*(volatile unsigned long *)0xFFFFF424)
#define PIOA_IFDR_OFFSET 0x24
#define PIOA_IFDR_P0_MASK 0x1
#define PIOA_IFDR_P0 0x1
#define PIOA_IFDR_P0_BIT 0
#define PIOA_IFDR_P1_MASK 0x2
#define PIOA_IFDR_P1 0x2
#define PIOA_IFDR_P1_BIT 1
#define PIOA_IFDR_P2_MASK 0x4
#define PIOA_IFDR_P2 0x4
#define PIOA_IFDR_P2_BIT 2
#define PIOA_IFDR_P3_MASK 0x8
#define PIOA_IFDR_P3 0x8
#define PIOA_IFDR_P3_BIT 3
#define PIOA_IFDR_P4_MASK 0x10
#define PIOA_IFDR_P4 0x10
#define PIOA_IFDR_P4_BIT 4
#define PIOA_IFDR_P5_MASK 0x20
#define PIOA_IFDR_P5 0x20
#define PIOA_IFDR_P5_BIT 5
#define PIOA_IFDR_P6_MASK 0x40
#define PIOA_IFDR_P6 0x40
#define PIOA_IFDR_P6_BIT 6
#define PIOA_IFDR_P7_MASK 0x80
#define PIOA_IFDR_P7 0x80
#define PIOA_IFDR_P7_BIT 7
#define PIOA_IFDR_P8_MASK 0x100
#define PIOA_IFDR_P8 0x100
#define PIOA_IFDR_P8_BIT 8
#define PIOA_IFDR_P9_MASK 0x200
#define PIOA_IFDR_P9 0x200
#define PIOA_IFDR_P9_BIT 9
#define PIOA_IFDR_P10_MASK 0x400
#define PIOA_IFDR_P10 0x400
#define PIOA_IFDR_P10_BIT 10
#define PIOA_IFDR_P11_MASK 0x800
#define PIOA_IFDR_P11 0x800
#define PIOA_IFDR_P11_BIT 11
#define PIOA_IFDR_P12_MASK 0x1000
#define PIOA_IFDR_P12 0x1000
#define PIOA_IFDR_P12_BIT 12
#define PIOA_IFDR_P13_MASK 0x2000
#define PIOA_IFDR_P13 0x2000
#define PIOA_IFDR_P13_BIT 13
#define PIOA_IFDR_P14_MASK 0x4000
#define PIOA_IFDR_P14 0x4000
#define PIOA_IFDR_P14_BIT 14
#define PIOA_IFDR_P15_MASK 0x8000
#define PIOA_IFDR_P15 0x8000
#define PIOA_IFDR_P15_BIT 15
#define PIOA_IFDR_P16_MASK 0x10000
#define PIOA_IFDR_P16 0x10000
#define PIOA_IFDR_P16_BIT 16
#define PIOA_IFDR_P17_MASK 0x20000
#define PIOA_IFDR_P17 0x20000
#define PIOA_IFDR_P17_BIT 17
#define PIOA_IFDR_P18_MASK 0x40000
#define PIOA_IFDR_P18 0x40000
#define PIOA_IFDR_P18_BIT 18
#define PIOA_IFDR_P19_MASK 0x80000
#define PIOA_IFDR_P19 0x80000
#define PIOA_IFDR_P19_BIT 19
#define PIOA_IFDR_P20_MASK 0x100000
#define PIOA_IFDR_P20 0x100000
#define PIOA_IFDR_P20_BIT 20
#define PIOA_IFDR_P21_MASK 0x200000
#define PIOA_IFDR_P21 0x200000
#define PIOA_IFDR_P21_BIT 21
#define PIOA_IFDR_P22_MASK 0x400000
#define PIOA_IFDR_P22 0x400000
#define PIOA_IFDR_P22_BIT 22
#define PIOA_IFDR_P23_MASK 0x800000
#define PIOA_IFDR_P23 0x800000
#define PIOA_IFDR_P23_BIT 23
#define PIOA_IFDR_P24_MASK 0x1000000
#define PIOA_IFDR_P24 0x1000000
#define PIOA_IFDR_P24_BIT 24
#define PIOA_IFDR_P25_MASK 0x2000000
#define PIOA_IFDR_P25 0x2000000
#define PIOA_IFDR_P25_BIT 25
#define PIOA_IFDR_P26_MASK 0x4000000
#define PIOA_IFDR_P26 0x4000000
#define PIOA_IFDR_P26_BIT 26
#define PIOA_IFDR_P27_MASK 0x8000000
#define PIOA_IFDR_P27 0x8000000
#define PIOA_IFDR_P27_BIT 27
#define PIOA_IFDR_P28_MASK 0x10000000
#define PIOA_IFDR_P28 0x10000000
#define PIOA_IFDR_P28_BIT 28
#define PIOA_IFDR_P29_MASK 0x20000000
#define PIOA_IFDR_P29 0x20000000
#define PIOA_IFDR_P29_BIT 29
#define PIOA_IFDR_P30_MASK 0x40000000
#define PIOA_IFDR_P30 0x40000000
#define PIOA_IFDR_P30_BIT 30
#define PIOA_IFDR_P31_MASK 0x80000000
#define PIOA_IFDR_P31 0x80000000
#define PIOA_IFDR_P31_BIT 31

#define PIOA_IFSR (*(volatile unsigned long *)0xFFFFF428)
#define PIOA_IFSR_OFFSET 0x28
#define PIOA_IFSR_P0_MASK 0x1
#define PIOA_IFSR_P0 0x1
#define PIOA_IFSR_P0_BIT 0
#define PIOA_IFSR_P1_MASK 0x2
#define PIOA_IFSR_P1 0x2
#define PIOA_IFSR_P1_BIT 1
#define PIOA_IFSR_P2_MASK 0x4
#define PIOA_IFSR_P2 0x4
#define PIOA_IFSR_P2_BIT 2
#define PIOA_IFSR_P3_MASK 0x8
#define PIOA_IFSR_P3 0x8
#define PIOA_IFSR_P3_BIT 3
#define PIOA_IFSR_P4_MASK 0x10
#define PIOA_IFSR_P4 0x10
#define PIOA_IFSR_P4_BIT 4
#define PIOA_IFSR_P5_MASK 0x20
#define PIOA_IFSR_P5 0x20
#define PIOA_IFSR_P5_BIT 5
#define PIOA_IFSR_P6_MASK 0x40
#define PIOA_IFSR_P6 0x40
#define PIOA_IFSR_P6_BIT 6
#define PIOA_IFSR_P7_MASK 0x80
#define PIOA_IFSR_P7 0x80
#define PIOA_IFSR_P7_BIT 7
#define PIOA_IFSR_P8_MASK 0x100
#define PIOA_IFSR_P8 0x100
#define PIOA_IFSR_P8_BIT 8
#define PIOA_IFSR_P9_MASK 0x200
#define PIOA_IFSR_P9 0x200
#define PIOA_IFSR_P9_BIT 9
#define PIOA_IFSR_P10_MASK 0x400
#define PIOA_IFSR_P10 0x400
#define PIOA_IFSR_P10_BIT 10
#define PIOA_IFSR_P11_MASK 0x800
#define PIOA_IFSR_P11 0x800
#define PIOA_IFSR_P11_BIT 11
#define PIOA_IFSR_P12_MASK 0x1000
#define PIOA_IFSR_P12 0x1000
#define PIOA_IFSR_P12_BIT 12
#define PIOA_IFSR_P13_MASK 0x2000
#define PIOA_IFSR_P13 0x2000
#define PIOA_IFSR_P13_BIT 13
#define PIOA_IFSR_P14_MASK 0x4000
#define PIOA_IFSR_P14 0x4000
#define PIOA_IFSR_P14_BIT 14
#define PIOA_IFSR_P15_MASK 0x8000
#define PIOA_IFSR_P15 0x8000
#define PIOA_IFSR_P15_BIT 15
#define PIOA_IFSR_P16_MASK 0x10000
#define PIOA_IFSR_P16 0x10000
#define PIOA_IFSR_P16_BIT 16
#define PIOA_IFSR_P17_MASK 0x20000
#define PIOA_IFSR_P17 0x20000
#define PIOA_IFSR_P17_BIT 17
#define PIOA_IFSR_P18_MASK 0x40000
#define PIOA_IFSR_P18 0x40000
#define PIOA_IFSR_P18_BIT 18
#define PIOA_IFSR_P19_MASK 0x80000
#define PIOA_IFSR_P19 0x80000
#define PIOA_IFSR_P19_BIT 19
#define PIOA_IFSR_P20_MASK 0x100000
#define PIOA_IFSR_P20 0x100000
#define PIOA_IFSR_P20_BIT 20
#define PIOA_IFSR_P21_MASK 0x200000
#define PIOA_IFSR_P21 0x200000
#define PIOA_IFSR_P21_BIT 21
#define PIOA_IFSR_P22_MASK 0x400000
#define PIOA_IFSR_P22 0x400000
#define PIOA_IFSR_P22_BIT 22
#define PIOA_IFSR_P23_MASK 0x800000
#define PIOA_IFSR_P23 0x800000
#define PIOA_IFSR_P23_BIT 23
#define PIOA_IFSR_P24_MASK 0x1000000
#define PIOA_IFSR_P24 0x1000000
#define PIOA_IFSR_P24_BIT 24
#define PIOA_IFSR_P25_MASK 0x2000000
#define PIOA_IFSR_P25 0x2000000
#define PIOA_IFSR_P25_BIT 25
#define PIOA_IFSR_P26_MASK 0x4000000
#define PIOA_IFSR_P26 0x4000000
#define PIOA_IFSR_P26_BIT 26
#define PIOA_IFSR_P27_MASK 0x8000000
#define PIOA_IFSR_P27 0x8000000
#define PIOA_IFSR_P27_BIT 27
#define PIOA_IFSR_P28_MASK 0x10000000
#define PIOA_IFSR_P28 0x10000000
#define PIOA_IFSR_P28_BIT 28
#define PIOA_IFSR_P29_MASK 0x20000000
#define PIOA_IFSR_P29 0x20000000
#define PIOA_IFSR_P29_BIT 29
#define PIOA_IFSR_P30_MASK 0x40000000
#define PIOA_IFSR_P30 0x40000000
#define PIOA_IFSR_P30_BIT 30
#define PIOA_IFSR_P31_MASK 0x80000000
#define PIOA_IFSR_P31 0x80000000
#define PIOA_IFSR_P31_BIT 31

#define PIOA_SODR (*(volatile unsigned long *)0xFFFFF430)
#define PIOA_SODR_OFFSET 0x30
#define PIOA_SODR_P0_MASK 0x1
#define PIOA_SODR_P0 0x1
#define PIOA_SODR_P0_BIT 0
#define PIOA_SODR_P1_MASK 0x2
#define PIOA_SODR_P1 0x2
#define PIOA_SODR_P1_BIT 1
#define PIOA_SODR_P2_MASK 0x4
#define PIOA_SODR_P2 0x4
#define PIOA_SODR_P2_BIT 2
#define PIOA_SODR_P3_MASK 0x8
#define PIOA_SODR_P3 0x8
#define PIOA_SODR_P3_BIT 3
#define PIOA_SODR_P4_MASK 0x10
#define PIOA_SODR_P4 0x10
#define PIOA_SODR_P4_BIT 4
#define PIOA_SODR_P5_MASK 0x20
#define PIOA_SODR_P5 0x20
#define PIOA_SODR_P5_BIT 5
#define PIOA_SODR_P6_MASK 0x40
#define PIOA_SODR_P6 0x40
#define PIOA_SODR_P6_BIT 6
#define PIOA_SODR_P7_MASK 0x80
#define PIOA_SODR_P7 0x80
#define PIOA_SODR_P7_BIT 7
#define PIOA_SODR_P8_MASK 0x100
#define PIOA_SODR_P8 0x100
#define PIOA_SODR_P8_BIT 8
#define PIOA_SODR_P9_MASK 0x200
#define PIOA_SODR_P9 0x200
#define PIOA_SODR_P9_BIT 9
#define PIOA_SODR_P10_MASK 0x400
#define PIOA_SODR_P10 0x400
#define PIOA_SODR_P10_BIT 10
#define PIOA_SODR_P11_MASK 0x800
#define PIOA_SODR_P11 0x800
#define PIOA_SODR_P11_BIT 11
#define PIOA_SODR_P12_MASK 0x1000
#define PIOA_SODR_P12 0x1000
#define PIOA_SODR_P12_BIT 12
#define PIOA_SODR_P13_MASK 0x2000
#define PIOA_SODR_P13 0x2000
#define PIOA_SODR_P13_BIT 13
#define PIOA_SODR_P14_MASK 0x4000
#define PIOA_SODR_P14 0x4000
#define PIOA_SODR_P14_BIT 14
#define PIOA_SODR_P15_MASK 0x8000
#define PIOA_SODR_P15 0x8000
#define PIOA_SODR_P15_BIT 15
#define PIOA_SODR_P16_MASK 0x10000
#define PIOA_SODR_P16 0x10000
#define PIOA_SODR_P16_BIT 16
#define PIOA_SODR_P17_MASK 0x20000
#define PIOA_SODR_P17 0x20000
#define PIOA_SODR_P17_BIT 17
#define PIOA_SODR_P18_MASK 0x40000
#define PIOA_SODR_P18 0x40000
#define PIOA_SODR_P18_BIT 18
#define PIOA_SODR_P19_MASK 0x80000
#define PIOA_SODR_P19 0x80000
#define PIOA_SODR_P19_BIT 19
#define PIOA_SODR_P20_MASK 0x100000
#define PIOA_SODR_P20 0x100000
#define PIOA_SODR_P20_BIT 20
#define PIOA_SODR_P21_MASK 0x200000
#define PIOA_SODR_P21 0x200000
#define PIOA_SODR_P21_BIT 21
#define PIOA_SODR_P22_MASK 0x400000
#define PIOA_SODR_P22 0x400000
#define PIOA_SODR_P22_BIT 22
#define PIOA_SODR_P23_MASK 0x800000
#define PIOA_SODR_P23 0x800000
#define PIOA_SODR_P23_BIT 23
#define PIOA_SODR_P24_MASK 0x1000000
#define PIOA_SODR_P24 0x1000000
#define PIOA_SODR_P24_BIT 24
#define PIOA_SODR_P25_MASK 0x2000000
#define PIOA_SODR_P25 0x2000000
#define PIOA_SODR_P25_BIT 25
#define PIOA_SODR_P26_MASK 0x4000000
#define PIOA_SODR_P26 0x4000000
#define PIOA_SODR_P26_BIT 26
#define PIOA_SODR_P27_MASK 0x8000000
#define PIOA_SODR_P27 0x8000000
#define PIOA_SODR_P27_BIT 27
#define PIOA_SODR_P28_MASK 0x10000000
#define PIOA_SODR_P28 0x10000000
#define PIOA_SODR_P28_BIT 28
#define PIOA_SODR_P29_MASK 0x20000000
#define PIOA_SODR_P29 0x20000000
#define PIOA_SODR_P29_BIT 29
#define PIOA_SODR_P30_MASK 0x40000000
#define PIOA_SODR_P30 0x40000000
#define PIOA_SODR_P30_BIT 30
#define PIOA_SODR_P31_MASK 0x80000000
#define PIOA_SODR_P31 0x80000000
#define PIOA_SODR_P31_BIT 31

#define PIOA_CODR (*(volatile unsigned long *)0xFFFFF434)
#define PIOA_CODR_OFFSET 0x34
#define PIOA_CODR_P0_MASK 0x1
#define PIOA_CODR_P0 0x1
#define PIOA_CODR_P0_BIT 0
#define PIOA_CODR_P1_MASK 0x2
#define PIOA_CODR_P1 0x2
#define PIOA_CODR_P1_BIT 1
#define PIOA_CODR_P2_MASK 0x4
#define PIOA_CODR_P2 0x4
#define PIOA_CODR_P2_BIT 2
#define PIOA_CODR_P3_MASK 0x8
#define PIOA_CODR_P3 0x8
#define PIOA_CODR_P3_BIT 3
#define PIOA_CODR_P4_MASK 0x10
#define PIOA_CODR_P4 0x10
#define PIOA_CODR_P4_BIT 4
#define PIOA_CODR_P5_MASK 0x20
#define PIOA_CODR_P5 0x20
#define PIOA_CODR_P5_BIT 5
#define PIOA_CODR_P6_MASK 0x40
#define PIOA_CODR_P6 0x40
#define PIOA_CODR_P6_BIT 6
#define PIOA_CODR_P7_MASK 0x80
#define PIOA_CODR_P7 0x80
#define PIOA_CODR_P7_BIT 7
#define PIOA_CODR_P8_MASK 0x100
#define PIOA_CODR_P8 0x100
#define PIOA_CODR_P8_BIT 8
#define PIOA_CODR_P9_MASK 0x200
#define PIOA_CODR_P9 0x200
#define PIOA_CODR_P9_BIT 9
#define PIOA_CODR_P10_MASK 0x400
#define PIOA_CODR_P10 0x400
#define PIOA_CODR_P10_BIT 10
#define PIOA_CODR_P11_MASK 0x800
#define PIOA_CODR_P11 0x800
#define PIOA_CODR_P11_BIT 11
#define PIOA_CODR_P12_MASK 0x1000
#define PIOA_CODR_P12 0x1000
#define PIOA_CODR_P12_BIT 12
#define PIOA_CODR_P13_MASK 0x2000
#define PIOA_CODR_P13 0x2000
#define PIOA_CODR_P13_BIT 13
#define PIOA_CODR_P14_MASK 0x4000
#define PIOA_CODR_P14 0x4000
#define PIOA_CODR_P14_BIT 14
#define PIOA_CODR_P15_MASK 0x8000
#define PIOA_CODR_P15 0x8000
#define PIOA_CODR_P15_BIT 15
#define PIOA_CODR_P16_MASK 0x10000
#define PIOA_CODR_P16 0x10000
#define PIOA_CODR_P16_BIT 16
#define PIOA_CODR_P17_MASK 0x20000
#define PIOA_CODR_P17 0x20000
#define PIOA_CODR_P17_BIT 17
#define PIOA_CODR_P18_MASK 0x40000
#define PIOA_CODR_P18 0x40000
#define PIOA_CODR_P18_BIT 18
#define PIOA_CODR_P19_MASK 0x80000
#define PIOA_CODR_P19 0x80000
#define PIOA_CODR_P19_BIT 19
#define PIOA_CODR_P20_MASK 0x100000
#define PIOA_CODR_P20 0x100000
#define PIOA_CODR_P20_BIT 20
#define PIOA_CODR_P21_MASK 0x200000
#define PIOA_CODR_P21 0x200000
#define PIOA_CODR_P21_BIT 21
#define PIOA_CODR_P22_MASK 0x400000
#define PIOA_CODR_P22 0x400000
#define PIOA_CODR_P22_BIT 22
#define PIOA_CODR_P23_MASK 0x800000
#define PIOA_CODR_P23 0x800000
#define PIOA_CODR_P23_BIT 23
#define PIOA_CODR_P24_MASK 0x1000000
#define PIOA_CODR_P24 0x1000000
#define PIOA_CODR_P24_BIT 24
#define PIOA_CODR_P25_MASK 0x2000000
#define PIOA_CODR_P25 0x2000000
#define PIOA_CODR_P25_BIT 25
#define PIOA_CODR_P26_MASK 0x4000000
#define PIOA_CODR_P26 0x4000000
#define PIOA_CODR_P26_BIT 26
#define PIOA_CODR_P27_MASK 0x8000000
#define PIOA_CODR_P27 0x8000000
#define PIOA_CODR_P27_BIT 27
#define PIOA_CODR_P28_MASK 0x10000000
#define PIOA_CODR_P28 0x10000000
#define PIOA_CODR_P28_BIT 28
#define PIOA_CODR_P29_MASK 0x20000000
#define PIOA_CODR_P29 0x20000000
#define PIOA_CODR_P29_BIT 29
#define PIOA_CODR_P30_MASK 0x40000000
#define PIOA_CODR_P30 0x40000000
#define PIOA_CODR_P30_BIT 30
#define PIOA_CODR_P31_MASK 0x80000000
#define PIOA_CODR_P31 0x80000000
#define PIOA_CODR_P31_BIT 31

#define PIOA_ODSR (*(volatile unsigned long *)0xFFFFF438)
#define PIOA_ODSR_OFFSET 0x38
#define PIOA_ODSR_P0_MASK 0x1
#define PIOA_ODSR_P0 0x1
#define PIOA_ODSR_P0_BIT 0
#define PIOA_ODSR_P1_MASK 0x2
#define PIOA_ODSR_P1 0x2
#define PIOA_ODSR_P1_BIT 1
#define PIOA_ODSR_P2_MASK 0x4
#define PIOA_ODSR_P2 0x4
#define PIOA_ODSR_P2_BIT 2
#define PIOA_ODSR_P3_MASK 0x8
#define PIOA_ODSR_P3 0x8
#define PIOA_ODSR_P3_BIT 3
#define PIOA_ODSR_P4_MASK 0x10
#define PIOA_ODSR_P4 0x10
#define PIOA_ODSR_P4_BIT 4
#define PIOA_ODSR_P5_MASK 0x20
#define PIOA_ODSR_P5 0x20
#define PIOA_ODSR_P5_BIT 5
#define PIOA_ODSR_P6_MASK 0x40
#define PIOA_ODSR_P6 0x40
#define PIOA_ODSR_P6_BIT 6
#define PIOA_ODSR_P7_MASK 0x80
#define PIOA_ODSR_P7 0x80
#define PIOA_ODSR_P7_BIT 7
#define PIOA_ODSR_P8_MASK 0x100
#define PIOA_ODSR_P8 0x100
#define PIOA_ODSR_P8_BIT 8
#define PIOA_ODSR_P9_MASK 0x200
#define PIOA_ODSR_P9 0x200
#define PIOA_ODSR_P9_BIT 9
#define PIOA_ODSR_P10_MASK 0x400
#define PIOA_ODSR_P10 0x400
#define PIOA_ODSR_P10_BIT 10
#define PIOA_ODSR_P11_MASK 0x800
#define PIOA_ODSR_P11 0x800
#define PIOA_ODSR_P11_BIT 11
#define PIOA_ODSR_P12_MASK 0x1000
#define PIOA_ODSR_P12 0x1000
#define PIOA_ODSR_P12_BIT 12
#define PIOA_ODSR_P13_MASK 0x2000
#define PIOA_ODSR_P13 0x2000
#define PIOA_ODSR_P13_BIT 13
#define PIOA_ODSR_P14_MASK 0x4000
#define PIOA_ODSR_P14 0x4000
#define PIOA_ODSR_P14_BIT 14
#define PIOA_ODSR_P15_MASK 0x8000
#define PIOA_ODSR_P15 0x8000
#define PIOA_ODSR_P15_BIT 15
#define PIOA_ODSR_P16_MASK 0x10000
#define PIOA_ODSR_P16 0x10000
#define PIOA_ODSR_P16_BIT 16
#define PIOA_ODSR_P17_MASK 0x20000
#define PIOA_ODSR_P17 0x20000
#define PIOA_ODSR_P17_BIT 17
#define PIOA_ODSR_P18_MASK 0x40000
#define PIOA_ODSR_P18 0x40000
#define PIOA_ODSR_P18_BIT 18
#define PIOA_ODSR_P19_MASK 0x80000
#define PIOA_ODSR_P19 0x80000
#define PIOA_ODSR_P19_BIT 19
#define PIOA_ODSR_P20_MASK 0x100000
#define PIOA_ODSR_P20 0x100000
#define PIOA_ODSR_P20_BIT 20
#define PIOA_ODSR_P21_MASK 0x200000
#define PIOA_ODSR_P21 0x200000
#define PIOA_ODSR_P21_BIT 21
#define PIOA_ODSR_P22_MASK 0x400000
#define PIOA_ODSR_P22 0x400000
#define PIOA_ODSR_P22_BIT 22
#define PIOA_ODSR_P23_MASK 0x800000
#define PIOA_ODSR_P23 0x800000
#define PIOA_ODSR_P23_BIT 23
#define PIOA_ODSR_P24_MASK 0x1000000
#define PIOA_ODSR_P24 0x1000000
#define PIOA_ODSR_P24_BIT 24
#define PIOA_ODSR_P25_MASK 0x2000000
#define PIOA_ODSR_P25 0x2000000
#define PIOA_ODSR_P25_BIT 25
#define PIOA_ODSR_P26_MASK 0x4000000
#define PIOA_ODSR_P26 0x4000000
#define PIOA_ODSR_P26_BIT 26
#define PIOA_ODSR_P27_MASK 0x8000000
#define PIOA_ODSR_P27 0x8000000
#define PIOA_ODSR_P27_BIT 27
#define PIOA_ODSR_P28_MASK 0x10000000
#define PIOA_ODSR_P28 0x10000000
#define PIOA_ODSR_P28_BIT 28
#define PIOA_ODSR_P29_MASK 0x20000000
#define PIOA_ODSR_P29 0x20000000
#define PIOA_ODSR_P29_BIT 29
#define PIOA_ODSR_P30_MASK 0x40000000
#define PIOA_ODSR_P30 0x40000000
#define PIOA_ODSR_P30_BIT 30
#define PIOA_ODSR_P31_MASK 0x80000000
#define PIOA_ODSR_P31 0x80000000
#define PIOA_ODSR_P31_BIT 31

#define PIOA_PDSR (*(volatile unsigned long *)0xFFFFF43C)
#define PIOA_PDSR_OFFSET 0x3C
#define PIOA_PDSR_P0_MASK 0x1
#define PIOA_PDSR_P0 0x1
#define PIOA_PDSR_P0_BIT 0
#define PIOA_PDSR_P1_MASK 0x2
#define PIOA_PDSR_P1 0x2
#define PIOA_PDSR_P1_BIT 1
#define PIOA_PDSR_P2_MASK 0x4
#define PIOA_PDSR_P2 0x4
#define PIOA_PDSR_P2_BIT 2
#define PIOA_PDSR_P3_MASK 0x8
#define PIOA_PDSR_P3 0x8
#define PIOA_PDSR_P3_BIT 3
#define PIOA_PDSR_P4_MASK 0x10
#define PIOA_PDSR_P4 0x10
#define PIOA_PDSR_P4_BIT 4
#define PIOA_PDSR_P5_MASK 0x20
#define PIOA_PDSR_P5 0x20
#define PIOA_PDSR_P5_BIT 5
#define PIOA_PDSR_P6_MASK 0x40
#define PIOA_PDSR_P6 0x40
#define PIOA_PDSR_P6_BIT 6
#define PIOA_PDSR_P7_MASK 0x80
#define PIOA_PDSR_P7 0x80
#define PIOA_PDSR_P7_BIT 7
#define PIOA_PDSR_P8_MASK 0x100
#define PIOA_PDSR_P8 0x100
#define PIOA_PDSR_P8_BIT 8
#define PIOA_PDSR_P9_MASK 0x200
#define PIOA_PDSR_P9 0x200
#define PIOA_PDSR_P9_BIT 9
#define PIOA_PDSR_P10_MASK 0x400
#define PIOA_PDSR_P10 0x400
#define PIOA_PDSR_P10_BIT 10
#define PIOA_PDSR_P11_MASK 0x800
#define PIOA_PDSR_P11 0x800
#define PIOA_PDSR_P11_BIT 11
#define PIOA_PDSR_P12_MASK 0x1000
#define PIOA_PDSR_P12 0x1000
#define PIOA_PDSR_P12_BIT 12
#define PIOA_PDSR_P13_MASK 0x2000
#define PIOA_PDSR_P13 0x2000
#define PIOA_PDSR_P13_BIT 13
#define PIOA_PDSR_P14_MASK 0x4000
#define PIOA_PDSR_P14 0x4000
#define PIOA_PDSR_P14_BIT 14
#define PIOA_PDSR_P15_MASK 0x8000
#define PIOA_PDSR_P15 0x8000
#define PIOA_PDSR_P15_BIT 15
#define PIOA_PDSR_P16_MASK 0x10000
#define PIOA_PDSR_P16 0x10000
#define PIOA_PDSR_P16_BIT 16
#define PIOA_PDSR_P17_MASK 0x20000
#define PIOA_PDSR_P17 0x20000
#define PIOA_PDSR_P17_BIT 17
#define PIOA_PDSR_P18_MASK 0x40000
#define PIOA_PDSR_P18 0x40000
#define PIOA_PDSR_P18_BIT 18
#define PIOA_PDSR_P19_MASK 0x80000
#define PIOA_PDSR_P19 0x80000
#define PIOA_PDSR_P19_BIT 19
#define PIOA_PDSR_P20_MASK 0x100000
#define PIOA_PDSR_P20 0x100000
#define PIOA_PDSR_P20_BIT 20
#define PIOA_PDSR_P21_MASK 0x200000
#define PIOA_PDSR_P21 0x200000
#define PIOA_PDSR_P21_BIT 21
#define PIOA_PDSR_P22_MASK 0x400000
#define PIOA_PDSR_P22 0x400000
#define PIOA_PDSR_P22_BIT 22
#define PIOA_PDSR_P23_MASK 0x800000
#define PIOA_PDSR_P23 0x800000
#define PIOA_PDSR_P23_BIT 23
#define PIOA_PDSR_P24_MASK 0x1000000
#define PIOA_PDSR_P24 0x1000000
#define PIOA_PDSR_P24_BIT 24
#define PIOA_PDSR_P25_MASK 0x2000000
#define PIOA_PDSR_P25 0x2000000
#define PIOA_PDSR_P25_BIT 25
#define PIOA_PDSR_P26_MASK 0x4000000
#define PIOA_PDSR_P26 0x4000000
#define PIOA_PDSR_P26_BIT 26
#define PIOA_PDSR_P27_MASK 0x8000000
#define PIOA_PDSR_P27 0x8000000
#define PIOA_PDSR_P27_BIT 27
#define PIOA_PDSR_P28_MASK 0x10000000
#define PIOA_PDSR_P28 0x10000000
#define PIOA_PDSR_P28_BIT 28
#define PIOA_PDSR_P29_MASK 0x20000000
#define PIOA_PDSR_P29 0x20000000
#define PIOA_PDSR_P29_BIT 29
#define PIOA_PDSR_P30_MASK 0x40000000
#define PIOA_PDSR_P30 0x40000000
#define PIOA_PDSR_P30_BIT 30
#define PIOA_PDSR_P31_MASK 0x80000000
#define PIOA_PDSR_P31 0x80000000
#define PIOA_PDSR_P31_BIT 31

#define PIOA_IER (*(volatile unsigned long *)0xFFFFF440)
#define PIOA_IER_OFFSET 0x40
#define PIOA_IER_P0_MASK 0x1
#define PIOA_IER_P0 0x1
#define PIOA_IER_P0_BIT 0
#define PIOA_IER_P1_MASK 0x2
#define PIOA_IER_P1 0x2
#define PIOA_IER_P1_BIT 1
#define PIOA_IER_P2_MASK 0x4
#define PIOA_IER_P2 0x4
#define PIOA_IER_P2_BIT 2
#define PIOA_IER_P3_MASK 0x8
#define PIOA_IER_P3 0x8
#define PIOA_IER_P3_BIT 3
#define PIOA_IER_P4_MASK 0x10
#define PIOA_IER_P4 0x10
#define PIOA_IER_P4_BIT 4
#define PIOA_IER_P5_MASK 0x20
#define PIOA_IER_P5 0x20
#define PIOA_IER_P5_BIT 5
#define PIOA_IER_P6_MASK 0x40
#define PIOA_IER_P6 0x40
#define PIOA_IER_P6_BIT 6
#define PIOA_IER_P7_MASK 0x80
#define PIOA_IER_P7 0x80
#define PIOA_IER_P7_BIT 7
#define PIOA_IER_P8_MASK 0x100
#define PIOA_IER_P8 0x100
#define PIOA_IER_P8_BIT 8
#define PIOA_IER_P9_MASK 0x200
#define PIOA_IER_P9 0x200
#define PIOA_IER_P9_BIT 9
#define PIOA_IER_P10_MASK 0x400
#define PIOA_IER_P10 0x400
#define PIOA_IER_P10_BIT 10
#define PIOA_IER_P11_MASK 0x800
#define PIOA_IER_P11 0x800
#define PIOA_IER_P11_BIT 11
#define PIOA_IER_P12_MASK 0x1000
#define PIOA_IER_P12 0x1000
#define PIOA_IER_P12_BIT 12
#define PIOA_IER_P13_MASK 0x2000
#define PIOA_IER_P13 0x2000
#define PIOA_IER_P13_BIT 13
#define PIOA_IER_P14_MASK 0x4000
#define PIOA_IER_P14 0x4000
#define PIOA_IER_P14_BIT 14
#define PIOA_IER_P15_MASK 0x8000
#define PIOA_IER_P15 0x8000
#define PIOA_IER_P15_BIT 15
#define PIOA_IER_P16_MASK 0x10000
#define PIOA_IER_P16 0x10000
#define PIOA_IER_P16_BIT 16
#define PIOA_IER_P17_MASK 0x20000
#define PIOA_IER_P17 0x20000
#define PIOA_IER_P17_BIT 17
#define PIOA_IER_P18_MASK 0x40000
#define PIOA_IER_P18 0x40000
#define PIOA_IER_P18_BIT 18
#define PIOA_IER_P19_MASK 0x80000
#define PIOA_IER_P19 0x80000
#define PIOA_IER_P19_BIT 19
#define PIOA_IER_P20_MASK 0x100000
#define PIOA_IER_P20 0x100000
#define PIOA_IER_P20_BIT 20
#define PIOA_IER_P21_MASK 0x200000
#define PIOA_IER_P21 0x200000
#define PIOA_IER_P21_BIT 21
#define PIOA_IER_P22_MASK 0x400000
#define PIOA_IER_P22 0x400000
#define PIOA_IER_P22_BIT 22
#define PIOA_IER_P23_MASK 0x800000
#define PIOA_IER_P23 0x800000
#define PIOA_IER_P23_BIT 23
#define PIOA_IER_P24_MASK 0x1000000
#define PIOA_IER_P24 0x1000000
#define PIOA_IER_P24_BIT 24
#define PIOA_IER_P25_MASK 0x2000000
#define PIOA_IER_P25 0x2000000
#define PIOA_IER_P25_BIT 25
#define PIOA_IER_P26_MASK 0x4000000
#define PIOA_IER_P26 0x4000000
#define PIOA_IER_P26_BIT 26
#define PIOA_IER_P27_MASK 0x8000000
#define PIOA_IER_P27 0x8000000
#define PIOA_IER_P27_BIT 27
#define PIOA_IER_P28_MASK 0x10000000
#define PIOA_IER_P28 0x10000000
#define PIOA_IER_P28_BIT 28
#define PIOA_IER_P29_MASK 0x20000000
#define PIOA_IER_P29 0x20000000
#define PIOA_IER_P29_BIT 29
#define PIOA_IER_P30_MASK 0x40000000
#define PIOA_IER_P30 0x40000000
#define PIOA_IER_P30_BIT 30
#define PIOA_IER_P31_MASK 0x80000000
#define PIOA_IER_P31 0x80000000
#define PIOA_IER_P31_BIT 31

#define PIOA_IDR (*(volatile unsigned long *)0xFFFFF444)
#define PIOA_IDR_OFFSET 0x44
#define PIOA_IDR_P0_MASK 0x1
#define PIOA_IDR_P0 0x1
#define PIOA_IDR_P0_BIT 0
#define PIOA_IDR_P1_MASK 0x2
#define PIOA_IDR_P1 0x2
#define PIOA_IDR_P1_BIT 1
#define PIOA_IDR_P2_MASK 0x4
#define PIOA_IDR_P2 0x4
#define PIOA_IDR_P2_BIT 2
#define PIOA_IDR_P3_MASK 0x8
#define PIOA_IDR_P3 0x8
#define PIOA_IDR_P3_BIT 3
#define PIOA_IDR_P4_MASK 0x10
#define PIOA_IDR_P4 0x10
#define PIOA_IDR_P4_BIT 4
#define PIOA_IDR_P5_MASK 0x20
#define PIOA_IDR_P5 0x20
#define PIOA_IDR_P5_BIT 5
#define PIOA_IDR_P6_MASK 0x40
#define PIOA_IDR_P6 0x40
#define PIOA_IDR_P6_BIT 6
#define PIOA_IDR_P7_MASK 0x80
#define PIOA_IDR_P7 0x80
#define PIOA_IDR_P7_BIT 7
#define PIOA_IDR_P8_MASK 0x100
#define PIOA_IDR_P8 0x100
#define PIOA_IDR_P8_BIT 8
#define PIOA_IDR_P9_MASK 0x200
#define PIOA_IDR_P9 0x200
#define PIOA_IDR_P9_BIT 9
#define PIOA_IDR_P10_MASK 0x400
#define PIOA_IDR_P10 0x400
#define PIOA_IDR_P10_BIT 10
#define PIOA_IDR_P11_MASK 0x800
#define PIOA_IDR_P11 0x800
#define PIOA_IDR_P11_BIT 11
#define PIOA_IDR_P12_MASK 0x1000
#define PIOA_IDR_P12 0x1000
#define PIOA_IDR_P12_BIT 12
#define PIOA_IDR_P13_MASK 0x2000
#define PIOA_IDR_P13 0x2000
#define PIOA_IDR_P13_BIT 13
#define PIOA_IDR_P14_MASK 0x4000
#define PIOA_IDR_P14 0x4000
#define PIOA_IDR_P14_BIT 14
#define PIOA_IDR_P15_MASK 0x8000
#define PIOA_IDR_P15 0x8000
#define PIOA_IDR_P15_BIT 15
#define PIOA_IDR_P16_MASK 0x10000
#define PIOA_IDR_P16 0x10000
#define PIOA_IDR_P16_BIT 16
#define PIOA_IDR_P17_MASK 0x20000
#define PIOA_IDR_P17 0x20000
#define PIOA_IDR_P17_BIT 17
#define PIOA_IDR_P18_MASK 0x40000
#define PIOA_IDR_P18 0x40000
#define PIOA_IDR_P18_BIT 18
#define PIOA_IDR_P19_MASK 0x80000
#define PIOA_IDR_P19 0x80000
#define PIOA_IDR_P19_BIT 19
#define PIOA_IDR_P20_MASK 0x100000
#define PIOA_IDR_P20 0x100000
#define PIOA_IDR_P20_BIT 20
#define PIOA_IDR_P21_MASK 0x200000
#define PIOA_IDR_P21 0x200000
#define PIOA_IDR_P21_BIT 21
#define PIOA_IDR_P22_MASK 0x400000
#define PIOA_IDR_P22 0x400000
#define PIOA_IDR_P22_BIT 22
#define PIOA_IDR_P23_MASK 0x800000
#define PIOA_IDR_P23 0x800000
#define PIOA_IDR_P23_BIT 23
#define PIOA_IDR_P24_MASK 0x1000000
#define PIOA_IDR_P24 0x1000000
#define PIOA_IDR_P24_BIT 24
#define PIOA_IDR_P25_MASK 0x2000000
#define PIOA_IDR_P25 0x2000000
#define PIOA_IDR_P25_BIT 25
#define PIOA_IDR_P26_MASK 0x4000000
#define PIOA_IDR_P26 0x4000000
#define PIOA_IDR_P26_BIT 26
#define PIOA_IDR_P27_MASK 0x8000000
#define PIOA_IDR_P27 0x8000000
#define PIOA_IDR_P27_BIT 27
#define PIOA_IDR_P28_MASK 0x10000000
#define PIOA_IDR_P28 0x10000000
#define PIOA_IDR_P28_BIT 28
#define PIOA_IDR_P29_MASK 0x20000000
#define PIOA_IDR_P29 0x20000000
#define PIOA_IDR_P29_BIT 29
#define PIOA_IDR_P30_MASK 0x40000000
#define PIOA_IDR_P30 0x40000000
#define PIOA_IDR_P30_BIT 30
#define PIOA_IDR_P31_MASK 0x80000000
#define PIOA_IDR_P31 0x80000000
#define PIOA_IDR_P31_BIT 31

#define PIOA_IMR (*(volatile unsigned long *)0xFFFFF448)
#define PIOA_IMR_OFFSET 0x48
#define PIOA_IMR_P0_MASK 0x1
#define PIOA_IMR_P0 0x1
#define PIOA_IMR_P0_BIT 0
#define PIOA_IMR_P1_MASK 0x2
#define PIOA_IMR_P1 0x2
#define PIOA_IMR_P1_BIT 1
#define PIOA_IMR_P2_MASK 0x4
#define PIOA_IMR_P2 0x4
#define PIOA_IMR_P2_BIT 2
#define PIOA_IMR_P3_MASK 0x8
#define PIOA_IMR_P3 0x8
#define PIOA_IMR_P3_BIT 3
#define PIOA_IMR_P4_MASK 0x10
#define PIOA_IMR_P4 0x10
#define PIOA_IMR_P4_BIT 4
#define PIOA_IMR_P5_MASK 0x20
#define PIOA_IMR_P5 0x20
#define PIOA_IMR_P5_BIT 5
#define PIOA_IMR_P6_MASK 0x40
#define PIOA_IMR_P6 0x40
#define PIOA_IMR_P6_BIT 6
#define PIOA_IMR_P7_MASK 0x80
#define PIOA_IMR_P7 0x80
#define PIOA_IMR_P7_BIT 7
#define PIOA_IMR_P8_MASK 0x100
#define PIOA_IMR_P8 0x100
#define PIOA_IMR_P8_BIT 8
#define PIOA_IMR_P9_MASK 0x200
#define PIOA_IMR_P9 0x200
#define PIOA_IMR_P9_BIT 9
#define PIOA_IMR_P10_MASK 0x400
#define PIOA_IMR_P10 0x400
#define PIOA_IMR_P10_BIT 10
#define PIOA_IMR_P11_MASK 0x800
#define PIOA_IMR_P11 0x800
#define PIOA_IMR_P11_BIT 11
#define PIOA_IMR_P12_MASK 0x1000
#define PIOA_IMR_P12 0x1000
#define PIOA_IMR_P12_BIT 12
#define PIOA_IMR_P13_MASK 0x2000
#define PIOA_IMR_P13 0x2000
#define PIOA_IMR_P13_BIT 13
#define PIOA_IMR_P14_MASK 0x4000
#define PIOA_IMR_P14 0x4000
#define PIOA_IMR_P14_BIT 14
#define PIOA_IMR_P15_MASK 0x8000
#define PIOA_IMR_P15 0x8000
#define PIOA_IMR_P15_BIT 15
#define PIOA_IMR_P16_MASK 0x10000
#define PIOA_IMR_P16 0x10000
#define PIOA_IMR_P16_BIT 16
#define PIOA_IMR_P17_MASK 0x20000
#define PIOA_IMR_P17 0x20000
#define PIOA_IMR_P17_BIT 17
#define PIOA_IMR_P18_MASK 0x40000
#define PIOA_IMR_P18 0x40000
#define PIOA_IMR_P18_BIT 18
#define PIOA_IMR_P19_MASK 0x80000
#define PIOA_IMR_P19 0x80000
#define PIOA_IMR_P19_BIT 19
#define PIOA_IMR_P20_MASK 0x100000
#define PIOA_IMR_P20 0x100000
#define PIOA_IMR_P20_BIT 20
#define PIOA_IMR_P21_MASK 0x200000
#define PIOA_IMR_P21 0x200000
#define PIOA_IMR_P21_BIT 21
#define PIOA_IMR_P22_MASK 0x400000
#define PIOA_IMR_P22 0x400000
#define PIOA_IMR_P22_BIT 22
#define PIOA_IMR_P23_MASK 0x800000
#define PIOA_IMR_P23 0x800000
#define PIOA_IMR_P23_BIT 23
#define PIOA_IMR_P24_MASK 0x1000000
#define PIOA_IMR_P24 0x1000000
#define PIOA_IMR_P24_BIT 24
#define PIOA_IMR_P25_MASK 0x2000000
#define PIOA_IMR_P25 0x2000000
#define PIOA_IMR_P25_BIT 25
#define PIOA_IMR_P26_MASK 0x4000000
#define PIOA_IMR_P26 0x4000000
#define PIOA_IMR_P26_BIT 26
#define PIOA_IMR_P27_MASK 0x8000000
#define PIOA_IMR_P27 0x8000000
#define PIOA_IMR_P27_BIT 27
#define PIOA_IMR_P28_MASK 0x10000000
#define PIOA_IMR_P28 0x10000000
#define PIOA_IMR_P28_BIT 28
#define PIOA_IMR_P29_MASK 0x20000000
#define PIOA_IMR_P29 0x20000000
#define PIOA_IMR_P29_BIT 29
#define PIOA_IMR_P30_MASK 0x40000000
#define PIOA_IMR_P30 0x40000000
#define PIOA_IMR_P30_BIT 30
#define PIOA_IMR_P31_MASK 0x80000000
#define PIOA_IMR_P31 0x80000000
#define PIOA_IMR_P31_BIT 31

#define PIOA_ISR (*(volatile unsigned long *)0xFFFFF44C)
#define PIOA_ISR_OFFSET 0x4C
#define PIOA_ISR_P0_MASK 0x1
#define PIOA_ISR_P0 0x1
#define PIOA_ISR_P0_BIT 0
#define PIOA_ISR_P1_MASK 0x2
#define PIOA_ISR_P1 0x2
#define PIOA_ISR_P1_BIT 1
#define PIOA_ISR_P2_MASK 0x4
#define PIOA_ISR_P2 0x4
#define PIOA_ISR_P2_BIT 2
#define PIOA_ISR_P3_MASK 0x8
#define PIOA_ISR_P3 0x8
#define PIOA_ISR_P3_BIT 3
#define PIOA_ISR_P4_MASK 0x10
#define PIOA_ISR_P4 0x10
#define PIOA_ISR_P4_BIT 4
#define PIOA_ISR_P5_MASK 0x20
#define PIOA_ISR_P5 0x20
#define PIOA_ISR_P5_BIT 5
#define PIOA_ISR_P6_MASK 0x40
#define PIOA_ISR_P6 0x40
#define PIOA_ISR_P6_BIT 6
#define PIOA_ISR_P7_MASK 0x80
#define PIOA_ISR_P7 0x80
#define PIOA_ISR_P7_BIT 7
#define PIOA_ISR_P8_MASK 0x100
#define PIOA_ISR_P8 0x100
#define PIOA_ISR_P8_BIT 8
#define PIOA_ISR_P9_MASK 0x200
#define PIOA_ISR_P9 0x200
#define PIOA_ISR_P9_BIT 9
#define PIOA_ISR_P10_MASK 0x400
#define PIOA_ISR_P10 0x400
#define PIOA_ISR_P10_BIT 10
#define PIOA_ISR_P11_MASK 0x800
#define PIOA_ISR_P11 0x800
#define PIOA_ISR_P11_BIT 11
#define PIOA_ISR_P12_MASK 0x1000
#define PIOA_ISR_P12 0x1000
#define PIOA_ISR_P12_BIT 12
#define PIOA_ISR_P13_MASK 0x2000
#define PIOA_ISR_P13 0x2000
#define PIOA_ISR_P13_BIT 13
#define PIOA_ISR_P14_MASK 0x4000
#define PIOA_ISR_P14 0x4000
#define PIOA_ISR_P14_BIT 14
#define PIOA_ISR_P15_MASK 0x8000
#define PIOA_ISR_P15 0x8000
#define PIOA_ISR_P15_BIT 15
#define PIOA_ISR_P16_MASK 0x10000
#define PIOA_ISR_P16 0x10000
#define PIOA_ISR_P16_BIT 16
#define PIOA_ISR_P17_MASK 0x20000
#define PIOA_ISR_P17 0x20000
#define PIOA_ISR_P17_BIT 17
#define PIOA_ISR_P18_MASK 0x40000
#define PIOA_ISR_P18 0x40000
#define PIOA_ISR_P18_BIT 18
#define PIOA_ISR_P19_MASK 0x80000
#define PIOA_ISR_P19 0x80000
#define PIOA_ISR_P19_BIT 19
#define PIOA_ISR_P20_MASK 0x100000
#define PIOA_ISR_P20 0x100000
#define PIOA_ISR_P20_BIT 20
#define PIOA_ISR_P21_MASK 0x200000
#define PIOA_ISR_P21 0x200000
#define PIOA_ISR_P21_BIT 21
#define PIOA_ISR_P22_MASK 0x400000
#define PIOA_ISR_P22 0x400000
#define PIOA_ISR_P22_BIT 22
#define PIOA_ISR_P23_MASK 0x800000
#define PIOA_ISR_P23 0x800000
#define PIOA_ISR_P23_BIT 23
#define PIOA_ISR_P24_MASK 0x1000000
#define PIOA_ISR_P24 0x1000000
#define PIOA_ISR_P24_BIT 24
#define PIOA_ISR_P25_MASK 0x2000000
#define PIOA_ISR_P25 0x2000000
#define PIOA_ISR_P25_BIT 25
#define PIOA_ISR_P26_MASK 0x4000000
#define PIOA_ISR_P26 0x4000000
#define PIOA_ISR_P26_BIT 26
#define PIOA_ISR_P27_MASK 0x8000000
#define PIOA_ISR_P27 0x8000000
#define PIOA_ISR_P27_BIT 27
#define PIOA_ISR_P28_MASK 0x10000000
#define PIOA_ISR_P28 0x10000000
#define PIOA_ISR_P28_BIT 28
#define PIOA_ISR_P29_MASK 0x20000000
#define PIOA_ISR_P29 0x20000000
#define PIOA_ISR_P29_BIT 29
#define PIOA_ISR_P30_MASK 0x40000000
#define PIOA_ISR_P30 0x40000000
#define PIOA_ISR_P30_BIT 30
#define PIOA_ISR_P31_MASK 0x80000000
#define PIOA_ISR_P31 0x80000000
#define PIOA_ISR_P31_BIT 31

#define PIOA_MDER (*(volatile unsigned long *)0xFFFFF450)
#define PIOA_MDER_OFFSET 0x50
#define PIOA_MDER_P0_MASK 0x1
#define PIOA_MDER_P0 0x1
#define PIOA_MDER_P0_BIT 0
#define PIOA_MDER_P1_MASK 0x2
#define PIOA_MDER_P1 0x2
#define PIOA_MDER_P1_BIT 1
#define PIOA_MDER_P2_MASK 0x4
#define PIOA_MDER_P2 0x4
#define PIOA_MDER_P2_BIT 2
#define PIOA_MDER_P3_MASK 0x8
#define PIOA_MDER_P3 0x8
#define PIOA_MDER_P3_BIT 3
#define PIOA_MDER_P4_MASK 0x10
#define PIOA_MDER_P4 0x10
#define PIOA_MDER_P4_BIT 4
#define PIOA_MDER_P5_MASK 0x20
#define PIOA_MDER_P5 0x20
#define PIOA_MDER_P5_BIT 5
#define PIOA_MDER_P6_MASK 0x40
#define PIOA_MDER_P6 0x40
#define PIOA_MDER_P6_BIT 6
#define PIOA_MDER_P7_MASK 0x80
#define PIOA_MDER_P7 0x80
#define PIOA_MDER_P7_BIT 7
#define PIOA_MDER_P8_MASK 0x100
#define PIOA_MDER_P8 0x100
#define PIOA_MDER_P8_BIT 8
#define PIOA_MDER_P9_MASK 0x200
#define PIOA_MDER_P9 0x200
#define PIOA_MDER_P9_BIT 9
#define PIOA_MDER_P10_MASK 0x400
#define PIOA_MDER_P10 0x400
#define PIOA_MDER_P10_BIT 10
#define PIOA_MDER_P11_MASK 0x800
#define PIOA_MDER_P11 0x800
#define PIOA_MDER_P11_BIT 11
#define PIOA_MDER_P12_MASK 0x1000
#define PIOA_MDER_P12 0x1000
#define PIOA_MDER_P12_BIT 12
#define PIOA_MDER_P13_MASK 0x2000
#define PIOA_MDER_P13 0x2000
#define PIOA_MDER_P13_BIT 13
#define PIOA_MDER_P14_MASK 0x4000
#define PIOA_MDER_P14 0x4000
#define PIOA_MDER_P14_BIT 14
#define PIOA_MDER_P15_MASK 0x8000
#define PIOA_MDER_P15 0x8000
#define PIOA_MDER_P15_BIT 15
#define PIOA_MDER_P16_MASK 0x10000
#define PIOA_MDER_P16 0x10000
#define PIOA_MDER_P16_BIT 16
#define PIOA_MDER_P17_MASK 0x20000
#define PIOA_MDER_P17 0x20000
#define PIOA_MDER_P17_BIT 17
#define PIOA_MDER_P18_MASK 0x40000
#define PIOA_MDER_P18 0x40000
#define PIOA_MDER_P18_BIT 18
#define PIOA_MDER_P19_MASK 0x80000
#define PIOA_MDER_P19 0x80000
#define PIOA_MDER_P19_BIT 19
#define PIOA_MDER_P20_MASK 0x100000
#define PIOA_MDER_P20 0x100000
#define PIOA_MDER_P20_BIT 20
#define PIOA_MDER_P21_MASK 0x200000
#define PIOA_MDER_P21 0x200000
#define PIOA_MDER_P21_BIT 21
#define PIOA_MDER_P22_MASK 0x400000
#define PIOA_MDER_P22 0x400000
#define PIOA_MDER_P22_BIT 22
#define PIOA_MDER_P23_MASK 0x800000
#define PIOA_MDER_P23 0x800000
#define PIOA_MDER_P23_BIT 23
#define PIOA_MDER_P24_MASK 0x1000000
#define PIOA_MDER_P24 0x1000000
#define PIOA_MDER_P24_BIT 24
#define PIOA_MDER_P25_MASK 0x2000000
#define PIOA_MDER_P25 0x2000000
#define PIOA_MDER_P25_BIT 25
#define PIOA_MDER_P26_MASK 0x4000000
#define PIOA_MDER_P26 0x4000000
#define PIOA_MDER_P26_BIT 26
#define PIOA_MDER_P27_MASK 0x8000000
#define PIOA_MDER_P27 0x8000000
#define PIOA_MDER_P27_BIT 27
#define PIOA_MDER_P28_MASK 0x10000000
#define PIOA_MDER_P28 0x10000000
#define PIOA_MDER_P28_BIT 28
#define PIOA_MDER_P29_MASK 0x20000000
#define PIOA_MDER_P29 0x20000000
#define PIOA_MDER_P29_BIT 29
#define PIOA_MDER_P30_MASK 0x40000000
#define PIOA_MDER_P30 0x40000000
#define PIOA_MDER_P30_BIT 30
#define PIOA_MDER_P31_MASK 0x80000000
#define PIOA_MDER_P31 0x80000000
#define PIOA_MDER_P31_BIT 31

#define PIOA_MDDR (*(volatile unsigned long *)0xFFFFF454)
#define PIOA_MDDR_OFFSET 0x54
#define PIOA_MDDR_P0_MASK 0x1
#define PIOA_MDDR_P0 0x1
#define PIOA_MDDR_P0_BIT 0
#define PIOA_MDDR_P1_MASK 0x2
#define PIOA_MDDR_P1 0x2
#define PIOA_MDDR_P1_BIT 1
#define PIOA_MDDR_P2_MASK 0x4
#define PIOA_MDDR_P2 0x4
#define PIOA_MDDR_P2_BIT 2
#define PIOA_MDDR_P3_MASK 0x8
#define PIOA_MDDR_P3 0x8
#define PIOA_MDDR_P3_BIT 3
#define PIOA_MDDR_P4_MASK 0x10
#define PIOA_MDDR_P4 0x10
#define PIOA_MDDR_P4_BIT 4
#define PIOA_MDDR_P5_MASK 0x20
#define PIOA_MDDR_P5 0x20
#define PIOA_MDDR_P5_BIT 5
#define PIOA_MDDR_P6_MASK 0x40
#define PIOA_MDDR_P6 0x40
#define PIOA_MDDR_P6_BIT 6
#define PIOA_MDDR_P7_MASK 0x80
#define PIOA_MDDR_P7 0x80
#define PIOA_MDDR_P7_BIT 7
#define PIOA_MDDR_P8_MASK 0x100
#define PIOA_MDDR_P8 0x100
#define PIOA_MDDR_P8_BIT 8
#define PIOA_MDDR_P9_MASK 0x200
#define PIOA_MDDR_P9 0x200
#define PIOA_MDDR_P9_BIT 9
#define PIOA_MDDR_P10_MASK 0x400
#define PIOA_MDDR_P10 0x400
#define PIOA_MDDR_P10_BIT 10
#define PIOA_MDDR_P11_MASK 0x800
#define PIOA_MDDR_P11 0x800
#define PIOA_MDDR_P11_BIT 11
#define PIOA_MDDR_P12_MASK 0x1000
#define PIOA_MDDR_P12 0x1000
#define PIOA_MDDR_P12_BIT 12
#define PIOA_MDDR_P13_MASK 0x2000
#define PIOA_MDDR_P13 0x2000
#define PIOA_MDDR_P13_BIT 13
#define PIOA_MDDR_P14_MASK 0x4000
#define PIOA_MDDR_P14 0x4000
#define PIOA_MDDR_P14_BIT 14
#define PIOA_MDDR_P15_MASK 0x8000
#define PIOA_MDDR_P15 0x8000
#define PIOA_MDDR_P15_BIT 15
#define PIOA_MDDR_P16_MASK 0x10000
#define PIOA_MDDR_P16 0x10000
#define PIOA_MDDR_P16_BIT 16
#define PIOA_MDDR_P17_MASK 0x20000
#define PIOA_MDDR_P17 0x20000
#define PIOA_MDDR_P17_BIT 17
#define PIOA_MDDR_P18_MASK 0x40000
#define PIOA_MDDR_P18 0x40000
#define PIOA_MDDR_P18_BIT 18
#define PIOA_MDDR_P19_MASK 0x80000
#define PIOA_MDDR_P19 0x80000
#define PIOA_MDDR_P19_BIT 19
#define PIOA_MDDR_P20_MASK 0x100000
#define PIOA_MDDR_P20 0x100000
#define PIOA_MDDR_P20_BIT 20
#define PIOA_MDDR_P21_MASK 0x200000
#define PIOA_MDDR_P21 0x200000
#define PIOA_MDDR_P21_BIT 21
#define PIOA_MDDR_P22_MASK 0x400000
#define PIOA_MDDR_P22 0x400000
#define PIOA_MDDR_P22_BIT 22
#define PIOA_MDDR_P23_MASK 0x800000
#define PIOA_MDDR_P23 0x800000
#define PIOA_MDDR_P23_BIT 23
#define PIOA_MDDR_P24_MASK 0x1000000
#define PIOA_MDDR_P24 0x1000000
#define PIOA_MDDR_P24_BIT 24
#define PIOA_MDDR_P25_MASK 0x2000000
#define PIOA_MDDR_P25 0x2000000
#define PIOA_MDDR_P25_BIT 25
#define PIOA_MDDR_P26_MASK 0x4000000
#define PIOA_MDDR_P26 0x4000000
#define PIOA_MDDR_P26_BIT 26
#define PIOA_MDDR_P27_MASK 0x8000000
#define PIOA_MDDR_P27 0x8000000
#define PIOA_MDDR_P27_BIT 27
#define PIOA_MDDR_P28_MASK 0x10000000
#define PIOA_MDDR_P28 0x10000000
#define PIOA_MDDR_P28_BIT 28
#define PIOA_MDDR_P29_MASK 0x20000000
#define PIOA_MDDR_P29 0x20000000
#define PIOA_MDDR_P29_BIT 29
#define PIOA_MDDR_P30_MASK 0x40000000
#define PIOA_MDDR_P30 0x40000000
#define PIOA_MDDR_P30_BIT 30
#define PIOA_MDDR_P31_MASK 0x80000000
#define PIOA_MDDR_P31 0x80000000
#define PIOA_MDDR_P31_BIT 31

#define PIOA_MDSR (*(volatile unsigned long *)0xFFFFF458)
#define PIOA_MDSR_OFFSET 0x58
#define PIOA_MDSR_P0_MASK 0x1
#define PIOA_MDSR_P0 0x1
#define PIOA_MDSR_P0_BIT 0
#define PIOA_MDSR_P1_MASK 0x2
#define PIOA_MDSR_P1 0x2
#define PIOA_MDSR_P1_BIT 1
#define PIOA_MDSR_P2_MASK 0x4
#define PIOA_MDSR_P2 0x4
#define PIOA_MDSR_P2_BIT 2
#define PIOA_MDSR_P3_MASK 0x8
#define PIOA_MDSR_P3 0x8
#define PIOA_MDSR_P3_BIT 3
#define PIOA_MDSR_P4_MASK 0x10
#define PIOA_MDSR_P4 0x10
#define PIOA_MDSR_P4_BIT 4
#define PIOA_MDSR_P5_MASK 0x20
#define PIOA_MDSR_P5 0x20
#define PIOA_MDSR_P5_BIT 5
#define PIOA_MDSR_P6_MASK 0x40
#define PIOA_MDSR_P6 0x40
#define PIOA_MDSR_P6_BIT 6
#define PIOA_MDSR_P7_MASK 0x80
#define PIOA_MDSR_P7 0x80
#define PIOA_MDSR_P7_BIT 7
#define PIOA_MDSR_P8_MASK 0x100
#define PIOA_MDSR_P8 0x100
#define PIOA_MDSR_P8_BIT 8
#define PIOA_MDSR_P9_MASK 0x200
#define PIOA_MDSR_P9 0x200
#define PIOA_MDSR_P9_BIT 9
#define PIOA_MDSR_P10_MASK 0x400
#define PIOA_MDSR_P10 0x400
#define PIOA_MDSR_P10_BIT 10
#define PIOA_MDSR_P11_MASK 0x800
#define PIOA_MDSR_P11 0x800
#define PIOA_MDSR_P11_BIT 11
#define PIOA_MDSR_P12_MASK 0x1000
#define PIOA_MDSR_P12 0x1000
#define PIOA_MDSR_P12_BIT 12
#define PIOA_MDSR_P13_MASK 0x2000
#define PIOA_MDSR_P13 0x2000
#define PIOA_MDSR_P13_BIT 13
#define PIOA_MDSR_P14_MASK 0x4000
#define PIOA_MDSR_P14 0x4000
#define PIOA_MDSR_P14_BIT 14
#define PIOA_MDSR_P15_MASK 0x8000
#define PIOA_MDSR_P15 0x8000
#define PIOA_MDSR_P15_BIT 15
#define PIOA_MDSR_P16_MASK 0x10000
#define PIOA_MDSR_P16 0x10000
#define PIOA_MDSR_P16_BIT 16
#define PIOA_MDSR_P17_MASK 0x20000
#define PIOA_MDSR_P17 0x20000
#define PIOA_MDSR_P17_BIT 17
#define PIOA_MDSR_P18_MASK 0x40000
#define PIOA_MDSR_P18 0x40000
#define PIOA_MDSR_P18_BIT 18
#define PIOA_MDSR_P19_MASK 0x80000
#define PIOA_MDSR_P19 0x80000
#define PIOA_MDSR_P19_BIT 19
#define PIOA_MDSR_P20_MASK 0x100000
#define PIOA_MDSR_P20 0x100000
#define PIOA_MDSR_P20_BIT 20
#define PIOA_MDSR_P21_MASK 0x200000
#define PIOA_MDSR_P21 0x200000
#define PIOA_MDSR_P21_BIT 21
#define PIOA_MDSR_P22_MASK 0x400000
#define PIOA_MDSR_P22 0x400000
#define PIOA_MDSR_P22_BIT 22
#define PIOA_MDSR_P23_MASK 0x800000
#define PIOA_MDSR_P23 0x800000
#define PIOA_MDSR_P23_BIT 23
#define PIOA_MDSR_P24_MASK 0x1000000
#define PIOA_MDSR_P24 0x1000000
#define PIOA_MDSR_P24_BIT 24
#define PIOA_MDSR_P25_MASK 0x2000000
#define PIOA_MDSR_P25 0x2000000
#define PIOA_MDSR_P25_BIT 25
#define PIOA_MDSR_P26_MASK 0x4000000
#define PIOA_MDSR_P26 0x4000000
#define PIOA_MDSR_P26_BIT 26
#define PIOA_MDSR_P27_MASK 0x8000000
#define PIOA_MDSR_P27 0x8000000
#define PIOA_MDSR_P27_BIT 27
#define PIOA_MDSR_P28_MASK 0x10000000
#define PIOA_MDSR_P28 0x10000000
#define PIOA_MDSR_P28_BIT 28
#define PIOA_MDSR_P29_MASK 0x20000000
#define PIOA_MDSR_P29 0x20000000
#define PIOA_MDSR_P29_BIT 29
#define PIOA_MDSR_P30_MASK 0x40000000
#define PIOA_MDSR_P30 0x40000000
#define PIOA_MDSR_P30_BIT 30
#define PIOA_MDSR_P31_MASK 0x80000000
#define PIOA_MDSR_P31 0x80000000
#define PIOA_MDSR_P31_BIT 31

#define PIOA_PUDR (*(volatile unsigned long *)0xFFFFF460)
#define PIOA_PUDR_OFFSET 0x60
#define PIOA_PUDR_P0_MASK 0x1
#define PIOA_PUDR_P0 0x1
#define PIOA_PUDR_P0_BIT 0
#define PIOA_PUDR_P1_MASK 0x2
#define PIOA_PUDR_P1 0x2
#define PIOA_PUDR_P1_BIT 1
#define PIOA_PUDR_P2_MASK 0x4
#define PIOA_PUDR_P2 0x4
#define PIOA_PUDR_P2_BIT 2
#define PIOA_PUDR_P3_MASK 0x8
#define PIOA_PUDR_P3 0x8
#define PIOA_PUDR_P3_BIT 3
#define PIOA_PUDR_P4_MASK 0x10
#define PIOA_PUDR_P4 0x10
#define PIOA_PUDR_P4_BIT 4
#define PIOA_PUDR_P5_MASK 0x20
#define PIOA_PUDR_P5 0x20
#define PIOA_PUDR_P5_BIT 5
#define PIOA_PUDR_P6_MASK 0x40
#define PIOA_PUDR_P6 0x40
#define PIOA_PUDR_P6_BIT 6
#define PIOA_PUDR_P7_MASK 0x80
#define PIOA_PUDR_P7 0x80
#define PIOA_PUDR_P7_BIT 7
#define PIOA_PUDR_P8_MASK 0x100
#define PIOA_PUDR_P8 0x100
#define PIOA_PUDR_P8_BIT 8
#define PIOA_PUDR_P9_MASK 0x200
#define PIOA_PUDR_P9 0x200
#define PIOA_PUDR_P9_BIT 9
#define PIOA_PUDR_P10_MASK 0x400
#define PIOA_PUDR_P10 0x400
#define PIOA_PUDR_P10_BIT 10
#define PIOA_PUDR_P11_MASK 0x800
#define PIOA_PUDR_P11 0x800
#define PIOA_PUDR_P11_BIT 11
#define PIOA_PUDR_P12_MASK 0x1000
#define PIOA_PUDR_P12 0x1000
#define PIOA_PUDR_P12_BIT 12
#define PIOA_PUDR_P13_MASK 0x2000
#define PIOA_PUDR_P13 0x2000
#define PIOA_PUDR_P13_BIT 13
#define PIOA_PUDR_P14_MASK 0x4000
#define PIOA_PUDR_P14 0x4000
#define PIOA_PUDR_P14_BIT 14
#define PIOA_PUDR_P15_MASK 0x8000
#define PIOA_PUDR_P15 0x8000
#define PIOA_PUDR_P15_BIT 15
#define PIOA_PUDR_P16_MASK 0x10000
#define PIOA_PUDR_P16 0x10000
#define PIOA_PUDR_P16_BIT 16
#define PIOA_PUDR_P17_MASK 0x20000
#define PIOA_PUDR_P17 0x20000
#define PIOA_PUDR_P17_BIT 17
#define PIOA_PUDR_P18_MASK 0x40000
#define PIOA_PUDR_P18 0x40000
#define PIOA_PUDR_P18_BIT 18
#define PIOA_PUDR_P19_MASK 0x80000
#define PIOA_PUDR_P19 0x80000
#define PIOA_PUDR_P19_BIT 19
#define PIOA_PUDR_P20_MASK 0x100000
#define PIOA_PUDR_P20 0x100000
#define PIOA_PUDR_P20_BIT 20
#define PIOA_PUDR_P21_MASK 0x200000
#define PIOA_PUDR_P21 0x200000
#define PIOA_PUDR_P21_BIT 21
#define PIOA_PUDR_P22_MASK 0x400000
#define PIOA_PUDR_P22 0x400000
#define PIOA_PUDR_P22_BIT 22
#define PIOA_PUDR_P23_MASK 0x800000
#define PIOA_PUDR_P23 0x800000
#define PIOA_PUDR_P23_BIT 23
#define PIOA_PUDR_P24_MASK 0x1000000
#define PIOA_PUDR_P24 0x1000000
#define PIOA_PUDR_P24_BIT 24
#define PIOA_PUDR_P25_MASK 0x2000000
#define PIOA_PUDR_P25 0x2000000
#define PIOA_PUDR_P25_BIT 25
#define PIOA_PUDR_P26_MASK 0x4000000
#define PIOA_PUDR_P26 0x4000000
#define PIOA_PUDR_P26_BIT 26
#define PIOA_PUDR_P27_MASK 0x8000000
#define PIOA_PUDR_P27 0x8000000
#define PIOA_PUDR_P27_BIT 27
#define PIOA_PUDR_P28_MASK 0x10000000
#define PIOA_PUDR_P28 0x10000000
#define PIOA_PUDR_P28_BIT 28
#define PIOA_PUDR_P29_MASK 0x20000000
#define PIOA_PUDR_P29 0x20000000
#define PIOA_PUDR_P29_BIT 29
#define PIOA_PUDR_P30_MASK 0x40000000
#define PIOA_PUDR_P30 0x40000000
#define PIOA_PUDR_P30_BIT 30
#define PIOA_PUDR_P31_MASK 0x80000000
#define PIOA_PUDR_P31 0x80000000
#define PIOA_PUDR_P31_BIT 31

#define PIOA_PUER (*(volatile unsigned long *)0xFFFFF464)
#define PIOA_PUER_OFFSET 0x64
#define PIOA_PUER_P0_MASK 0x1
#define PIOA_PUER_P0 0x1
#define PIOA_PUER_P0_BIT 0
#define PIOA_PUER_P1_MASK 0x2
#define PIOA_PUER_P1 0x2
#define PIOA_PUER_P1_BIT 1
#define PIOA_PUER_P2_MASK 0x4
#define PIOA_PUER_P2 0x4
#define PIOA_PUER_P2_BIT 2
#define PIOA_PUER_P3_MASK 0x8
#define PIOA_PUER_P3 0x8
#define PIOA_PUER_P3_BIT 3
#define PIOA_PUER_P4_MASK 0x10
#define PIOA_PUER_P4 0x10
#define PIOA_PUER_P4_BIT 4
#define PIOA_PUER_P5_MASK 0x20
#define PIOA_PUER_P5 0x20
#define PIOA_PUER_P5_BIT 5
#define PIOA_PUER_P6_MASK 0x40
#define PIOA_PUER_P6 0x40
#define PIOA_PUER_P6_BIT 6
#define PIOA_PUER_P7_MASK 0x80
#define PIOA_PUER_P7 0x80
#define PIOA_PUER_P7_BIT 7
#define PIOA_PUER_P8_MASK 0x100
#define PIOA_PUER_P8 0x100
#define PIOA_PUER_P8_BIT 8
#define PIOA_PUER_P9_MASK 0x200
#define PIOA_PUER_P9 0x200
#define PIOA_PUER_P9_BIT 9
#define PIOA_PUER_P10_MASK 0x400
#define PIOA_PUER_P10 0x400
#define PIOA_PUER_P10_BIT 10
#define PIOA_PUER_P11_MASK 0x800
#define PIOA_PUER_P11 0x800
#define PIOA_PUER_P11_BIT 11
#define PIOA_PUER_P12_MASK 0x1000
#define PIOA_PUER_P12 0x1000
#define PIOA_PUER_P12_BIT 12
#define PIOA_PUER_P13_MASK 0x2000
#define PIOA_PUER_P13 0x2000
#define PIOA_PUER_P13_BIT 13
#define PIOA_PUER_P14_MASK 0x4000
#define PIOA_PUER_P14 0x4000
#define PIOA_PUER_P14_BIT 14
#define PIOA_PUER_P15_MASK 0x8000
#define PIOA_PUER_P15 0x8000
#define PIOA_PUER_P15_BIT 15
#define PIOA_PUER_P16_MASK 0x10000
#define PIOA_PUER_P16 0x10000
#define PIOA_PUER_P16_BIT 16
#define PIOA_PUER_P17_MASK 0x20000
#define PIOA_PUER_P17 0x20000
#define PIOA_PUER_P17_BIT 17
#define PIOA_PUER_P18_MASK 0x40000
#define PIOA_PUER_P18 0x40000
#define PIOA_PUER_P18_BIT 18
#define PIOA_PUER_P19_MASK 0x80000
#define PIOA_PUER_P19 0x80000
#define PIOA_PUER_P19_BIT 19
#define PIOA_PUER_P20_MASK 0x100000
#define PIOA_PUER_P20 0x100000
#define PIOA_PUER_P20_BIT 20
#define PIOA_PUER_P21_MASK 0x200000
#define PIOA_PUER_P21 0x200000
#define PIOA_PUER_P21_BIT 21
#define PIOA_PUER_P22_MASK 0x400000
#define PIOA_PUER_P22 0x400000
#define PIOA_PUER_P22_BIT 22
#define PIOA_PUER_P23_MASK 0x800000
#define PIOA_PUER_P23 0x800000
#define PIOA_PUER_P23_BIT 23
#define PIOA_PUER_P24_MASK 0x1000000
#define PIOA_PUER_P24 0x1000000
#define PIOA_PUER_P24_BIT 24
#define PIOA_PUER_P25_MASK 0x2000000
#define PIOA_PUER_P25 0x2000000
#define PIOA_PUER_P25_BIT 25
#define PIOA_PUER_P26_MASK 0x4000000
#define PIOA_PUER_P26 0x4000000
#define PIOA_PUER_P26_BIT 26
#define PIOA_PUER_P27_MASK 0x8000000
#define PIOA_PUER_P27 0x8000000
#define PIOA_PUER_P27_BIT 27
#define PIOA_PUER_P28_MASK 0x10000000
#define PIOA_PUER_P28 0x10000000
#define PIOA_PUER_P28_BIT 28
#define PIOA_PUER_P29_MASK 0x20000000
#define PIOA_PUER_P29 0x20000000
#define PIOA_PUER_P29_BIT 29
#define PIOA_PUER_P30_MASK 0x40000000
#define PIOA_PUER_P30 0x40000000
#define PIOA_PUER_P30_BIT 30
#define PIOA_PUER_P31_MASK 0x80000000
#define PIOA_PUER_P31 0x80000000
#define PIOA_PUER_P31_BIT 31

#define PIOA_PUSR (*(volatile unsigned long *)0xFFFFF468)
#define PIOA_PUSR_OFFSET 0x68
#define PIOA_PUSR_P0_MASK 0x1
#define PIOA_PUSR_P0 0x1
#define PIOA_PUSR_P0_BIT 0
#define PIOA_PUSR_P1_MASK 0x2
#define PIOA_PUSR_P1 0x2
#define PIOA_PUSR_P1_BIT 1
#define PIOA_PUSR_P2_MASK 0x4
#define PIOA_PUSR_P2 0x4
#define PIOA_PUSR_P2_BIT 2
#define PIOA_PUSR_P3_MASK 0x8
#define PIOA_PUSR_P3 0x8
#define PIOA_PUSR_P3_BIT 3
#define PIOA_PUSR_P4_MASK 0x10
#define PIOA_PUSR_P4 0x10
#define PIOA_PUSR_P4_BIT 4
#define PIOA_PUSR_P5_MASK 0x20
#define PIOA_PUSR_P5 0x20
#define PIOA_PUSR_P5_BIT 5
#define PIOA_PUSR_P6_MASK 0x40
#define PIOA_PUSR_P6 0x40
#define PIOA_PUSR_P6_BIT 6
#define PIOA_PUSR_P7_MASK 0x80
#define PIOA_PUSR_P7 0x80
#define PIOA_PUSR_P7_BIT 7
#define PIOA_PUSR_P8_MASK 0x100
#define PIOA_PUSR_P8 0x100
#define PIOA_PUSR_P8_BIT 8
#define PIOA_PUSR_P9_MASK 0x200
#define PIOA_PUSR_P9 0x200
#define PIOA_PUSR_P9_BIT 9
#define PIOA_PUSR_P10_MASK 0x400
#define PIOA_PUSR_P10 0x400
#define PIOA_PUSR_P10_BIT 10
#define PIOA_PUSR_P11_MASK 0x800
#define PIOA_PUSR_P11 0x800
#define PIOA_PUSR_P11_BIT 11
#define PIOA_PUSR_P12_MASK 0x1000
#define PIOA_PUSR_P12 0x1000
#define PIOA_PUSR_P12_BIT 12
#define PIOA_PUSR_P13_MASK 0x2000
#define PIOA_PUSR_P13 0x2000
#define PIOA_PUSR_P13_BIT 13
#define PIOA_PUSR_P14_MASK 0x4000
#define PIOA_PUSR_P14 0x4000
#define PIOA_PUSR_P14_BIT 14
#define PIOA_PUSR_P15_MASK 0x8000
#define PIOA_PUSR_P15 0x8000
#define PIOA_PUSR_P15_BIT 15
#define PIOA_PUSR_P16_MASK 0x10000
#define PIOA_PUSR_P16 0x10000
#define PIOA_PUSR_P16_BIT 16
#define PIOA_PUSR_P17_MASK 0x20000
#define PIOA_PUSR_P17 0x20000
#define PIOA_PUSR_P17_BIT 17
#define PIOA_PUSR_P18_MASK 0x40000
#define PIOA_PUSR_P18 0x40000
#define PIOA_PUSR_P18_BIT 18
#define PIOA_PUSR_P19_MASK 0x80000
#define PIOA_PUSR_P19 0x80000
#define PIOA_PUSR_P19_BIT 19
#define PIOA_PUSR_P20_MASK 0x100000
#define PIOA_PUSR_P20 0x100000
#define PIOA_PUSR_P20_BIT 20
#define PIOA_PUSR_P21_MASK 0x200000
#define PIOA_PUSR_P21 0x200000
#define PIOA_PUSR_P21_BIT 21
#define PIOA_PUSR_P22_MASK 0x400000
#define PIOA_PUSR_P22 0x400000
#define PIOA_PUSR_P22_BIT 22
#define PIOA_PUSR_P23_MASK 0x800000
#define PIOA_PUSR_P23 0x800000
#define PIOA_PUSR_P23_BIT 23
#define PIOA_PUSR_P24_MASK 0x1000000
#define PIOA_PUSR_P24 0x1000000
#define PIOA_PUSR_P24_BIT 24
#define PIOA_PUSR_P25_MASK 0x2000000
#define PIOA_PUSR_P25 0x2000000
#define PIOA_PUSR_P25_BIT 25
#define PIOA_PUSR_P26_MASK 0x4000000
#define PIOA_PUSR_P26 0x4000000
#define PIOA_PUSR_P26_BIT 26
#define PIOA_PUSR_P27_MASK 0x8000000
#define PIOA_PUSR_P27 0x8000000
#define PIOA_PUSR_P27_BIT 27
#define PIOA_PUSR_P28_MASK 0x10000000
#define PIOA_PUSR_P28 0x10000000
#define PIOA_PUSR_P28_BIT 28
#define PIOA_PUSR_P29_MASK 0x20000000
#define PIOA_PUSR_P29 0x20000000
#define PIOA_PUSR_P29_BIT 29
#define PIOA_PUSR_P30_MASK 0x40000000
#define PIOA_PUSR_P30 0x40000000
#define PIOA_PUSR_P30_BIT 30
#define PIOA_PUSR_P31_MASK 0x80000000
#define PIOA_PUSR_P31 0x80000000
#define PIOA_PUSR_P31_BIT 31

#define PIOA_ASR (*(volatile unsigned long *)0xFFFFF470)
#define PIOA_ASR_OFFSET 0x70
#define PIOA_ASR_P0_MASK 0x1
#define PIOA_ASR_P0 0x1
#define PIOA_ASR_P0_BIT 0
#define PIOA_ASR_P1_MASK 0x2
#define PIOA_ASR_P1 0x2
#define PIOA_ASR_P1_BIT 1
#define PIOA_ASR_P2_MASK 0x4
#define PIOA_ASR_P2 0x4
#define PIOA_ASR_P2_BIT 2
#define PIOA_ASR_P3_MASK 0x8
#define PIOA_ASR_P3 0x8
#define PIOA_ASR_P3_BIT 3
#define PIOA_ASR_P4_MASK 0x10
#define PIOA_ASR_P4 0x10
#define PIOA_ASR_P4_BIT 4
#define PIOA_ASR_P5_MASK 0x20
#define PIOA_ASR_P5 0x20
#define PIOA_ASR_P5_BIT 5
#define PIOA_ASR_P6_MASK 0x40
#define PIOA_ASR_P6 0x40
#define PIOA_ASR_P6_BIT 6
#define PIOA_ASR_P7_MASK 0x80
#define PIOA_ASR_P7 0x80
#define PIOA_ASR_P7_BIT 7
#define PIOA_ASR_P8_MASK 0x100
#define PIOA_ASR_P8 0x100
#define PIOA_ASR_P8_BIT 8
#define PIOA_ASR_P9_MASK 0x200
#define PIOA_ASR_P9 0x200
#define PIOA_ASR_P9_BIT 9
#define PIOA_ASR_P10_MASK 0x400
#define PIOA_ASR_P10 0x400
#define PIOA_ASR_P10_BIT 10
#define PIOA_ASR_P11_MASK 0x800
#define PIOA_ASR_P11 0x800
#define PIOA_ASR_P11_BIT 11
#define PIOA_ASR_P12_MASK 0x1000
#define PIOA_ASR_P12 0x1000
#define PIOA_ASR_P12_BIT 12
#define PIOA_ASR_P13_MASK 0x2000
#define PIOA_ASR_P13 0x2000
#define PIOA_ASR_P13_BIT 13
#define PIOA_ASR_P14_MASK 0x4000
#define PIOA_ASR_P14 0x4000
#define PIOA_ASR_P14_BIT 14
#define PIOA_ASR_P15_MASK 0x8000
#define PIOA_ASR_P15 0x8000
#define PIOA_ASR_P15_BIT 15
#define PIOA_ASR_P16_MASK 0x10000
#define PIOA_ASR_P16 0x10000
#define PIOA_ASR_P16_BIT 16
#define PIOA_ASR_P17_MASK 0x20000
#define PIOA_ASR_P17 0x20000
#define PIOA_ASR_P17_BIT 17
#define PIOA_ASR_P18_MASK 0x40000
#define PIOA_ASR_P18 0x40000
#define PIOA_ASR_P18_BIT 18
#define PIOA_ASR_P19_MASK 0x80000
#define PIOA_ASR_P19 0x80000
#define PIOA_ASR_P19_BIT 19
#define PIOA_ASR_P20_MASK 0x100000
#define PIOA_ASR_P20 0x100000
#define PIOA_ASR_P20_BIT 20
#define PIOA_ASR_P21_MASK 0x200000
#define PIOA_ASR_P21 0x200000
#define PIOA_ASR_P21_BIT 21
#define PIOA_ASR_P22_MASK 0x400000
#define PIOA_ASR_P22 0x400000
#define PIOA_ASR_P22_BIT 22
#define PIOA_ASR_P23_MASK 0x800000
#define PIOA_ASR_P23 0x800000
#define PIOA_ASR_P23_BIT 23
#define PIOA_ASR_P24_MASK 0x1000000
#define PIOA_ASR_P24 0x1000000
#define PIOA_ASR_P24_BIT 24
#define PIOA_ASR_P25_MASK 0x2000000
#define PIOA_ASR_P25 0x2000000
#define PIOA_ASR_P25_BIT 25
#define PIOA_ASR_P26_MASK 0x4000000
#define PIOA_ASR_P26 0x4000000
#define PIOA_ASR_P26_BIT 26
#define PIOA_ASR_P27_MASK 0x8000000
#define PIOA_ASR_P27 0x8000000
#define PIOA_ASR_P27_BIT 27
#define PIOA_ASR_P28_MASK 0x10000000
#define PIOA_ASR_P28 0x10000000
#define PIOA_ASR_P28_BIT 28
#define PIOA_ASR_P29_MASK 0x20000000
#define PIOA_ASR_P29 0x20000000
#define PIOA_ASR_P29_BIT 29
#define PIOA_ASR_P30_MASK 0x40000000
#define PIOA_ASR_P30 0x40000000
#define PIOA_ASR_P30_BIT 30
#define PIOA_ASR_P31_MASK 0x80000000
#define PIOA_ASR_P31 0x80000000
#define PIOA_ASR_P31_BIT 31

#define PIOA_BSR (*(volatile unsigned long *)0xFFFFF474)
#define PIOA_BSR_OFFSET 0x74
#define PIOA_BSR_P0_MASK 0x1
#define PIOA_BSR_P0 0x1
#define PIOA_BSR_P0_BIT 0
#define PIOA_BSR_P1_MASK 0x2
#define PIOA_BSR_P1 0x2
#define PIOA_BSR_P1_BIT 1
#define PIOA_BSR_P2_MASK 0x4
#define PIOA_BSR_P2 0x4
#define PIOA_BSR_P2_BIT 2
#define PIOA_BSR_P3_MASK 0x8
#define PIOA_BSR_P3 0x8
#define PIOA_BSR_P3_BIT 3
#define PIOA_BSR_P4_MASK 0x10
#define PIOA_BSR_P4 0x10
#define PIOA_BSR_P4_BIT 4
#define PIOA_BSR_P5_MASK 0x20
#define PIOA_BSR_P5 0x20
#define PIOA_BSR_P5_BIT 5
#define PIOA_BSR_P6_MASK 0x40
#define PIOA_BSR_P6 0x40
#define PIOA_BSR_P6_BIT 6
#define PIOA_BSR_P7_MASK 0x80
#define PIOA_BSR_P7 0x80
#define PIOA_BSR_P7_BIT 7
#define PIOA_BSR_P8_MASK 0x100
#define PIOA_BSR_P8 0x100
#define PIOA_BSR_P8_BIT 8
#define PIOA_BSR_P9_MASK 0x200
#define PIOA_BSR_P9 0x200
#define PIOA_BSR_P9_BIT 9
#define PIOA_BSR_P10_MASK 0x400
#define PIOA_BSR_P10 0x400
#define PIOA_BSR_P10_BIT 10
#define PIOA_BSR_P11_MASK 0x800
#define PIOA_BSR_P11 0x800
#define PIOA_BSR_P11_BIT 11
#define PIOA_BSR_P12_MASK 0x1000
#define PIOA_BSR_P12 0x1000
#define PIOA_BSR_P12_BIT 12
#define PIOA_BSR_P13_MASK 0x2000
#define PIOA_BSR_P13 0x2000
#define PIOA_BSR_P13_BIT 13
#define PIOA_BSR_P14_MASK 0x4000
#define PIOA_BSR_P14 0x4000
#define PIOA_BSR_P14_BIT 14
#define PIOA_BSR_P15_MASK 0x8000
#define PIOA_BSR_P15 0x8000
#define PIOA_BSR_P15_BIT 15
#define PIOA_BSR_P16_MASK 0x10000
#define PIOA_BSR_P16 0x10000
#define PIOA_BSR_P16_BIT 16
#define PIOA_BSR_P17_MASK 0x20000
#define PIOA_BSR_P17 0x20000
#define PIOA_BSR_P17_BIT 17
#define PIOA_BSR_P18_MASK 0x40000
#define PIOA_BSR_P18 0x40000
#define PIOA_BSR_P18_BIT 18
#define PIOA_BSR_P19_MASK 0x80000
#define PIOA_BSR_P19 0x80000
#define PIOA_BSR_P19_BIT 19
#define PIOA_BSR_P20_MASK 0x100000
#define PIOA_BSR_P20 0x100000
#define PIOA_BSR_P20_BIT 20
#define PIOA_BSR_P21_MASK 0x200000
#define PIOA_BSR_P21 0x200000
#define PIOA_BSR_P21_BIT 21
#define PIOA_BSR_P22_MASK 0x400000
#define PIOA_BSR_P22 0x400000
#define PIOA_BSR_P22_BIT 22
#define PIOA_BSR_P23_MASK 0x800000
#define PIOA_BSR_P23 0x800000
#define PIOA_BSR_P23_BIT 23
#define PIOA_BSR_P24_MASK 0x1000000
#define PIOA_BSR_P24 0x1000000
#define PIOA_BSR_P24_BIT 24
#define PIOA_BSR_P25_MASK 0x2000000
#define PIOA_BSR_P25 0x2000000
#define PIOA_BSR_P25_BIT 25
#define PIOA_BSR_P26_MASK 0x4000000
#define PIOA_BSR_P26 0x4000000
#define PIOA_BSR_P26_BIT 26
#define PIOA_BSR_P27_MASK 0x8000000
#define PIOA_BSR_P27 0x8000000
#define PIOA_BSR_P27_BIT 27
#define PIOA_BSR_P28_MASK 0x10000000
#define PIOA_BSR_P28 0x10000000
#define PIOA_BSR_P28_BIT 28
#define PIOA_BSR_P29_MASK 0x20000000
#define PIOA_BSR_P29 0x20000000
#define PIOA_BSR_P29_BIT 29
#define PIOA_BSR_P30_MASK 0x40000000
#define PIOA_BSR_P30 0x40000000
#define PIOA_BSR_P30_BIT 30
#define PIOA_BSR_P31_MASK 0x80000000
#define PIOA_BSR_P31 0x80000000
#define PIOA_BSR_P31_BIT 31

#define PIOA_ABSR (*(volatile unsigned long *)0xFFFFF478)
#define PIOA_ABSR_OFFSET 0x78
#define PIOA_ABSR_P0_MASK 0x1
#define PIOA_ABSR_P0 0x1
#define PIOA_ABSR_P0_BIT 0
#define PIOA_ABSR_P1_MASK 0x2
#define PIOA_ABSR_P1 0x2
#define PIOA_ABSR_P1_BIT 1
#define PIOA_ABSR_P2_MASK 0x4
#define PIOA_ABSR_P2 0x4
#define PIOA_ABSR_P2_BIT 2
#define PIOA_ABSR_P3_MASK 0x8
#define PIOA_ABSR_P3 0x8
#define PIOA_ABSR_P3_BIT 3
#define PIOA_ABSR_P4_MASK 0x10
#define PIOA_ABSR_P4 0x10
#define PIOA_ABSR_P4_BIT 4
#define PIOA_ABSR_P5_MASK 0x20
#define PIOA_ABSR_P5 0x20
#define PIOA_ABSR_P5_BIT 5
#define PIOA_ABSR_P6_MASK 0x40
#define PIOA_ABSR_P6 0x40
#define PIOA_ABSR_P6_BIT 6
#define PIOA_ABSR_P7_MASK 0x80
#define PIOA_ABSR_P7 0x80
#define PIOA_ABSR_P7_BIT 7
#define PIOA_ABSR_P8_MASK 0x100
#define PIOA_ABSR_P8 0x100
#define PIOA_ABSR_P8_BIT 8
#define PIOA_ABSR_P9_MASK 0x200
#define PIOA_ABSR_P9 0x200
#define PIOA_ABSR_P9_BIT 9
#define PIOA_ABSR_P10_MASK 0x400
#define PIOA_ABSR_P10 0x400
#define PIOA_ABSR_P10_BIT 10
#define PIOA_ABSR_P11_MASK 0x800
#define PIOA_ABSR_P11 0x800
#define PIOA_ABSR_P11_BIT 11
#define PIOA_ABSR_P12_MASK 0x1000
#define PIOA_ABSR_P12 0x1000
#define PIOA_ABSR_P12_BIT 12
#define PIOA_ABSR_P13_MASK 0x2000
#define PIOA_ABSR_P13 0x2000
#define PIOA_ABSR_P13_BIT 13
#define PIOA_ABSR_P14_MASK 0x4000
#define PIOA_ABSR_P14 0x4000
#define PIOA_ABSR_P14_BIT 14
#define PIOA_ABSR_P15_MASK 0x8000
#define PIOA_ABSR_P15 0x8000
#define PIOA_ABSR_P15_BIT 15
#define PIOA_ABSR_P16_MASK 0x10000
#define PIOA_ABSR_P16 0x10000
#define PIOA_ABSR_P16_BIT 16
#define PIOA_ABSR_P17_MASK 0x20000
#define PIOA_ABSR_P17 0x20000
#define PIOA_ABSR_P17_BIT 17
#define PIOA_ABSR_P18_MASK 0x40000
#define PIOA_ABSR_P18 0x40000
#define PIOA_ABSR_P18_BIT 18
#define PIOA_ABSR_P19_MASK 0x80000
#define PIOA_ABSR_P19 0x80000
#define PIOA_ABSR_P19_BIT 19
#define PIOA_ABSR_P20_MASK 0x100000
#define PIOA_ABSR_P20 0x100000
#define PIOA_ABSR_P20_BIT 20
#define PIOA_ABSR_P21_MASK 0x200000
#define PIOA_ABSR_P21 0x200000
#define PIOA_ABSR_P21_BIT 21
#define PIOA_ABSR_P22_MASK 0x400000
#define PIOA_ABSR_P22 0x400000
#define PIOA_ABSR_P22_BIT 22
#define PIOA_ABSR_P23_MASK 0x800000
#define PIOA_ABSR_P23 0x800000
#define PIOA_ABSR_P23_BIT 23
#define PIOA_ABSR_P24_MASK 0x1000000
#define PIOA_ABSR_P24 0x1000000
#define PIOA_ABSR_P24_BIT 24
#define PIOA_ABSR_P25_MASK 0x2000000
#define PIOA_ABSR_P25 0x2000000
#define PIOA_ABSR_P25_BIT 25
#define PIOA_ABSR_P26_MASK 0x4000000
#define PIOA_ABSR_P26 0x4000000
#define PIOA_ABSR_P26_BIT 26
#define PIOA_ABSR_P27_MASK 0x8000000
#define PIOA_ABSR_P27 0x8000000
#define PIOA_ABSR_P27_BIT 27
#define PIOA_ABSR_P28_MASK 0x10000000
#define PIOA_ABSR_P28 0x10000000
#define PIOA_ABSR_P28_BIT 28
#define PIOA_ABSR_P29_MASK 0x20000000
#define PIOA_ABSR_P29 0x20000000
#define PIOA_ABSR_P29_BIT 29
#define PIOA_ABSR_P30_MASK 0x40000000
#define PIOA_ABSR_P30 0x40000000
#define PIOA_ABSR_P30_BIT 30
#define PIOA_ABSR_P31_MASK 0x80000000
#define PIOA_ABSR_P31 0x80000000
#define PIOA_ABSR_P31_BIT 31

#define PIOA_OWER (*(volatile unsigned long *)0xFFFFF4A0)
#define PIOA_OWER_OFFSET 0xA0
#define PIOA_OWER_P0_MASK 0x1
#define PIOA_OWER_P0 0x1
#define PIOA_OWER_P0_BIT 0
#define PIOA_OWER_P1_MASK 0x2
#define PIOA_OWER_P1 0x2
#define PIOA_OWER_P1_BIT 1
#define PIOA_OWER_P2_MASK 0x4
#define PIOA_OWER_P2 0x4
#define PIOA_OWER_P2_BIT 2
#define PIOA_OWER_P3_MASK 0x8
#define PIOA_OWER_P3 0x8
#define PIOA_OWER_P3_BIT 3
#define PIOA_OWER_P4_MASK 0x10
#define PIOA_OWER_P4 0x10
#define PIOA_OWER_P4_BIT 4
#define PIOA_OWER_P5_MASK 0x20
#define PIOA_OWER_P5 0x20
#define PIOA_OWER_P5_BIT 5
#define PIOA_OWER_P6_MASK 0x40
#define PIOA_OWER_P6 0x40
#define PIOA_OWER_P6_BIT 6
#define PIOA_OWER_P7_MASK 0x80
#define PIOA_OWER_P7 0x80
#define PIOA_OWER_P7_BIT 7
#define PIOA_OWER_P8_MASK 0x100
#define PIOA_OWER_P8 0x100
#define PIOA_OWER_P8_BIT 8
#define PIOA_OWER_P9_MASK 0x200
#define PIOA_OWER_P9 0x200
#define PIOA_OWER_P9_BIT 9
#define PIOA_OWER_P10_MASK 0x400
#define PIOA_OWER_P10 0x400
#define PIOA_OWER_P10_BIT 10
#define PIOA_OWER_P11_MASK 0x800
#define PIOA_OWER_P11 0x800
#define PIOA_OWER_P11_BIT 11
#define PIOA_OWER_P12_MASK 0x1000
#define PIOA_OWER_P12 0x1000
#define PIOA_OWER_P12_BIT 12
#define PIOA_OWER_P13_MASK 0x2000
#define PIOA_OWER_P13 0x2000
#define PIOA_OWER_P13_BIT 13
#define PIOA_OWER_P14_MASK 0x4000
#define PIOA_OWER_P14 0x4000
#define PIOA_OWER_P14_BIT 14
#define PIOA_OWER_P15_MASK 0x8000
#define PIOA_OWER_P15 0x8000
#define PIOA_OWER_P15_BIT 15
#define PIOA_OWER_P16_MASK 0x10000
#define PIOA_OWER_P16 0x10000
#define PIOA_OWER_P16_BIT 16
#define PIOA_OWER_P17_MASK 0x20000
#define PIOA_OWER_P17 0x20000
#define PIOA_OWER_P17_BIT 17
#define PIOA_OWER_P18_MASK 0x40000
#define PIOA_OWER_P18 0x40000
#define PIOA_OWER_P18_BIT 18
#define PIOA_OWER_P19_MASK 0x80000
#define PIOA_OWER_P19 0x80000
#define PIOA_OWER_P19_BIT 19
#define PIOA_OWER_P20_MASK 0x100000
#define PIOA_OWER_P20 0x100000
#define PIOA_OWER_P20_BIT 20
#define PIOA_OWER_P21_MASK 0x200000
#define PIOA_OWER_P21 0x200000
#define PIOA_OWER_P21_BIT 21
#define PIOA_OWER_P22_MASK 0x400000
#define PIOA_OWER_P22 0x400000
#define PIOA_OWER_P22_BIT 22
#define PIOA_OWER_P23_MASK 0x800000
#define PIOA_OWER_P23 0x800000
#define PIOA_OWER_P23_BIT 23
#define PIOA_OWER_P24_MASK 0x1000000
#define PIOA_OWER_P24 0x1000000
#define PIOA_OWER_P24_BIT 24
#define PIOA_OWER_P25_MASK 0x2000000
#define PIOA_OWER_P25 0x2000000
#define PIOA_OWER_P25_BIT 25
#define PIOA_OWER_P26_MASK 0x4000000
#define PIOA_OWER_P26 0x4000000
#define PIOA_OWER_P26_BIT 26
#define PIOA_OWER_P27_MASK 0x8000000
#define PIOA_OWER_P27 0x8000000
#define PIOA_OWER_P27_BIT 27
#define PIOA_OWER_P28_MASK 0x10000000
#define PIOA_OWER_P28 0x10000000
#define PIOA_OWER_P28_BIT 28
#define PIOA_OWER_P29_MASK 0x20000000
#define PIOA_OWER_P29 0x20000000
#define PIOA_OWER_P29_BIT 29
#define PIOA_OWER_P30_MASK 0x40000000
#define PIOA_OWER_P30 0x40000000
#define PIOA_OWER_P30_BIT 30
#define PIOA_OWER_P31_MASK 0x80000000
#define PIOA_OWER_P31 0x80000000
#define PIOA_OWER_P31_BIT 31

#define PIOA_OWDR (*(volatile unsigned long *)0xFFFFF4A4)
#define PIOA_OWDR_OFFSET 0xA4
#define PIOA_OWDR_P0_MASK 0x1
#define PIOA_OWDR_P0 0x1
#define PIOA_OWDR_P0_BIT 0
#define PIOA_OWDR_P1_MASK 0x2
#define PIOA_OWDR_P1 0x2
#define PIOA_OWDR_P1_BIT 1
#define PIOA_OWDR_P2_MASK 0x4
#define PIOA_OWDR_P2 0x4
#define PIOA_OWDR_P2_BIT 2
#define PIOA_OWDR_P3_MASK 0x8
#define PIOA_OWDR_P3 0x8
#define PIOA_OWDR_P3_BIT 3
#define PIOA_OWDR_P4_MASK 0x10
#define PIOA_OWDR_P4 0x10
#define PIOA_OWDR_P4_BIT 4
#define PIOA_OWDR_P5_MASK 0x20
#define PIOA_OWDR_P5 0x20
#define PIOA_OWDR_P5_BIT 5
#define PIOA_OWDR_P6_MASK 0x40
#define PIOA_OWDR_P6 0x40
#define PIOA_OWDR_P6_BIT 6
#define PIOA_OWDR_P7_MASK 0x80
#define PIOA_OWDR_P7 0x80
#define PIOA_OWDR_P7_BIT 7
#define PIOA_OWDR_P8_MASK 0x100
#define PIOA_OWDR_P8 0x100
#define PIOA_OWDR_P8_BIT 8
#define PIOA_OWDR_P9_MASK 0x200
#define PIOA_OWDR_P9 0x200
#define PIOA_OWDR_P9_BIT 9
#define PIOA_OWDR_P10_MASK 0x400
#define PIOA_OWDR_P10 0x400
#define PIOA_OWDR_P10_BIT 10
#define PIOA_OWDR_P11_MASK 0x800
#define PIOA_OWDR_P11 0x800
#define PIOA_OWDR_P11_BIT 11
#define PIOA_OWDR_P12_MASK 0x1000
#define PIOA_OWDR_P12 0x1000
#define PIOA_OWDR_P12_BIT 12
#define PIOA_OWDR_P13_MASK 0x2000
#define PIOA_OWDR_P13 0x2000
#define PIOA_OWDR_P13_BIT 13
#define PIOA_OWDR_P14_MASK 0x4000
#define PIOA_OWDR_P14 0x4000
#define PIOA_OWDR_P14_BIT 14
#define PIOA_OWDR_P15_MASK 0x8000
#define PIOA_OWDR_P15 0x8000
#define PIOA_OWDR_P15_BIT 15
#define PIOA_OWDR_P16_MASK 0x10000
#define PIOA_OWDR_P16 0x10000
#define PIOA_OWDR_P16_BIT 16
#define PIOA_OWDR_P17_MASK 0x20000
#define PIOA_OWDR_P17 0x20000
#define PIOA_OWDR_P17_BIT 17
#define PIOA_OWDR_P18_MASK 0x40000
#define PIOA_OWDR_P18 0x40000
#define PIOA_OWDR_P18_BIT 18
#define PIOA_OWDR_P19_MASK 0x80000
#define PIOA_OWDR_P19 0x80000
#define PIOA_OWDR_P19_BIT 19
#define PIOA_OWDR_P20_MASK 0x100000
#define PIOA_OWDR_P20 0x100000
#define PIOA_OWDR_P20_BIT 20
#define PIOA_OWDR_P21_MASK 0x200000
#define PIOA_OWDR_P21 0x200000
#define PIOA_OWDR_P21_BIT 21
#define PIOA_OWDR_P22_MASK 0x400000
#define PIOA_OWDR_P22 0x400000
#define PIOA_OWDR_P22_BIT 22
#define PIOA_OWDR_P23_MASK 0x800000
#define PIOA_OWDR_P23 0x800000
#define PIOA_OWDR_P23_BIT 23
#define PIOA_OWDR_P24_MASK 0x1000000
#define PIOA_OWDR_P24 0x1000000
#define PIOA_OWDR_P24_BIT 24
#define PIOA_OWDR_P25_MASK 0x2000000
#define PIOA_OWDR_P25 0x2000000
#define PIOA_OWDR_P25_BIT 25
#define PIOA_OWDR_P26_MASK 0x4000000
#define PIOA_OWDR_P26 0x4000000
#define PIOA_OWDR_P26_BIT 26
#define PIOA_OWDR_P27_MASK 0x8000000
#define PIOA_OWDR_P27 0x8000000
#define PIOA_OWDR_P27_BIT 27
#define PIOA_OWDR_P28_MASK 0x10000000
#define PIOA_OWDR_P28 0x10000000
#define PIOA_OWDR_P28_BIT 28
#define PIOA_OWDR_P29_MASK 0x20000000
#define PIOA_OWDR_P29 0x20000000
#define PIOA_OWDR_P29_BIT 29
#define PIOA_OWDR_P30_MASK 0x40000000
#define PIOA_OWDR_P30 0x40000000
#define PIOA_OWDR_P30_BIT 30
#define PIOA_OWDR_P31_MASK 0x80000000
#define PIOA_OWDR_P31 0x80000000
#define PIOA_OWDR_P31_BIT 31

#define PIOA_OWSR (*(volatile unsigned long *)0xFFFFF4A8)
#define PIOA_OWSR_OFFSET 0xA8
#define PIOA_OWSR_P0_MASK 0x1
#define PIOA_OWSR_P0 0x1
#define PIOA_OWSR_P0_BIT 0
#define PIOA_OWSR_P1_MASK 0x2
#define PIOA_OWSR_P1 0x2
#define PIOA_OWSR_P1_BIT 1
#define PIOA_OWSR_P2_MASK 0x4
#define PIOA_OWSR_P2 0x4
#define PIOA_OWSR_P2_BIT 2
#define PIOA_OWSR_P3_MASK 0x8
#define PIOA_OWSR_P3 0x8
#define PIOA_OWSR_P3_BIT 3
#define PIOA_OWSR_P4_MASK 0x10
#define PIOA_OWSR_P4 0x10
#define PIOA_OWSR_P4_BIT 4
#define PIOA_OWSR_P5_MASK 0x20
#define PIOA_OWSR_P5 0x20
#define PIOA_OWSR_P5_BIT 5
#define PIOA_OWSR_P6_MASK 0x40
#define PIOA_OWSR_P6 0x40
#define PIOA_OWSR_P6_BIT 6
#define PIOA_OWSR_P7_MASK 0x80
#define PIOA_OWSR_P7 0x80
#define PIOA_OWSR_P7_BIT 7
#define PIOA_OWSR_P8_MASK 0x100
#define PIOA_OWSR_P8 0x100
#define PIOA_OWSR_P8_BIT 8
#define PIOA_OWSR_P9_MASK 0x200
#define PIOA_OWSR_P9 0x200
#define PIOA_OWSR_P9_BIT 9
#define PIOA_OWSR_P10_MASK 0x400
#define PIOA_OWSR_P10 0x400
#define PIOA_OWSR_P10_BIT 10
#define PIOA_OWSR_P11_MASK 0x800
#define PIOA_OWSR_P11 0x800
#define PIOA_OWSR_P11_BIT 11
#define PIOA_OWSR_P12_MASK 0x1000
#define PIOA_OWSR_P12 0x1000
#define PIOA_OWSR_P12_BIT 12
#define PIOA_OWSR_P13_MASK 0x2000
#define PIOA_OWSR_P13 0x2000
#define PIOA_OWSR_P13_BIT 13
#define PIOA_OWSR_P14_MASK 0x4000
#define PIOA_OWSR_P14 0x4000
#define PIOA_OWSR_P14_BIT 14
#define PIOA_OWSR_P15_MASK 0x8000
#define PIOA_OWSR_P15 0x8000
#define PIOA_OWSR_P15_BIT 15
#define PIOA_OWSR_P16_MASK 0x10000
#define PIOA_OWSR_P16 0x10000
#define PIOA_OWSR_P16_BIT 16
#define PIOA_OWSR_P17_MASK 0x20000
#define PIOA_OWSR_P17 0x20000
#define PIOA_OWSR_P17_BIT 17
#define PIOA_OWSR_P18_MASK 0x40000
#define PIOA_OWSR_P18 0x40000
#define PIOA_OWSR_P18_BIT 18
#define PIOA_OWSR_P19_MASK 0x80000
#define PIOA_OWSR_P19 0x80000
#define PIOA_OWSR_P19_BIT 19
#define PIOA_OWSR_P20_MASK 0x100000
#define PIOA_OWSR_P20 0x100000
#define PIOA_OWSR_P20_BIT 20
#define PIOA_OWSR_P21_MASK 0x200000
#define PIOA_OWSR_P21 0x200000
#define PIOA_OWSR_P21_BIT 21
#define PIOA_OWSR_P22_MASK 0x400000
#define PIOA_OWSR_P22 0x400000
#define PIOA_OWSR_P22_BIT 22
#define PIOA_OWSR_P23_MASK 0x800000
#define PIOA_OWSR_P23 0x800000
#define PIOA_OWSR_P23_BIT 23
#define PIOA_OWSR_P24_MASK 0x1000000
#define PIOA_OWSR_P24 0x1000000
#define PIOA_OWSR_P24_BIT 24
#define PIOA_OWSR_P25_MASK 0x2000000
#define PIOA_OWSR_P25 0x2000000
#define PIOA_OWSR_P25_BIT 25
#define PIOA_OWSR_P26_MASK 0x4000000
#define PIOA_OWSR_P26 0x4000000
#define PIOA_OWSR_P26_BIT 26
#define PIOA_OWSR_P27_MASK 0x8000000
#define PIOA_OWSR_P27 0x8000000
#define PIOA_OWSR_P27_BIT 27
#define PIOA_OWSR_P28_MASK 0x10000000
#define PIOA_OWSR_P28 0x10000000
#define PIOA_OWSR_P28_BIT 28
#define PIOA_OWSR_P29_MASK 0x20000000
#define PIOA_OWSR_P29 0x20000000
#define PIOA_OWSR_P29_BIT 29
#define PIOA_OWSR_P30_MASK 0x40000000
#define PIOA_OWSR_P30 0x40000000
#define PIOA_OWSR_P30_BIT 30
#define PIOA_OWSR_P31_MASK 0x80000000
#define PIOA_OWSR_P31 0x80000000
#define PIOA_OWSR_P31_BIT 31

#define PIOB_BASE 0xFFFFF600

#define PIOB_PER (*(volatile unsigned long *)0xFFFFF600)
#define PIOB_PER_OFFSET 0x0
#define PIOB_PER_P0_MASK 0x1
#define PIOB_PER_P0 0x1
#define PIOB_PER_P0_BIT 0
#define PIOB_PER_P1_MASK 0x2
#define PIOB_PER_P1 0x2
#define PIOB_PER_P1_BIT 1
#define PIOB_PER_P2_MASK 0x4
#define PIOB_PER_P2 0x4
#define PIOB_PER_P2_BIT 2
#define PIOB_PER_P3_MASK 0x8
#define PIOB_PER_P3 0x8
#define PIOB_PER_P3_BIT 3
#define PIOB_PER_P4_MASK 0x10
#define PIOB_PER_P4 0x10
#define PIOB_PER_P4_BIT 4
#define PIOB_PER_P5_MASK 0x20
#define PIOB_PER_P5 0x20
#define PIOB_PER_P5_BIT 5
#define PIOB_PER_P6_MASK 0x40
#define PIOB_PER_P6 0x40
#define PIOB_PER_P6_BIT 6
#define PIOB_PER_P7_MASK 0x80
#define PIOB_PER_P7 0x80
#define PIOB_PER_P7_BIT 7
#define PIOB_PER_P8_MASK 0x100
#define PIOB_PER_P8 0x100
#define PIOB_PER_P8_BIT 8
#define PIOB_PER_P9_MASK 0x200
#define PIOB_PER_P9 0x200
#define PIOB_PER_P9_BIT 9
#define PIOB_PER_P10_MASK 0x400
#define PIOB_PER_P10 0x400
#define PIOB_PER_P10_BIT 10
#define PIOB_PER_P11_MASK 0x800
#define PIOB_PER_P11 0x800
#define PIOB_PER_P11_BIT 11
#define PIOB_PER_P12_MASK 0x1000
#define PIOB_PER_P12 0x1000
#define PIOB_PER_P12_BIT 12
#define PIOB_PER_P13_MASK 0x2000
#define PIOB_PER_P13 0x2000
#define PIOB_PER_P13_BIT 13
#define PIOB_PER_P14_MASK 0x4000
#define PIOB_PER_P14 0x4000
#define PIOB_PER_P14_BIT 14
#define PIOB_PER_P15_MASK 0x8000
#define PIOB_PER_P15 0x8000
#define PIOB_PER_P15_BIT 15
#define PIOB_PER_P16_MASK 0x10000
#define PIOB_PER_P16 0x10000
#define PIOB_PER_P16_BIT 16
#define PIOB_PER_P17_MASK 0x20000
#define PIOB_PER_P17 0x20000
#define PIOB_PER_P17_BIT 17
#define PIOB_PER_P18_MASK 0x40000
#define PIOB_PER_P18 0x40000
#define PIOB_PER_P18_BIT 18
#define PIOB_PER_P19_MASK 0x80000
#define PIOB_PER_P19 0x80000
#define PIOB_PER_P19_BIT 19
#define PIOB_PER_P20_MASK 0x100000
#define PIOB_PER_P20 0x100000
#define PIOB_PER_P20_BIT 20
#define PIOB_PER_P21_MASK 0x200000
#define PIOB_PER_P21 0x200000
#define PIOB_PER_P21_BIT 21
#define PIOB_PER_P22_MASK 0x400000
#define PIOB_PER_P22 0x400000
#define PIOB_PER_P22_BIT 22
#define PIOB_PER_P23_MASK 0x800000
#define PIOB_PER_P23 0x800000
#define PIOB_PER_P23_BIT 23
#define PIOB_PER_P24_MASK 0x1000000
#define PIOB_PER_P24 0x1000000
#define PIOB_PER_P24_BIT 24
#define PIOB_PER_P25_MASK 0x2000000
#define PIOB_PER_P25 0x2000000
#define PIOB_PER_P25_BIT 25
#define PIOB_PER_P26_MASK 0x4000000
#define PIOB_PER_P26 0x4000000
#define PIOB_PER_P26_BIT 26
#define PIOB_PER_P27_MASK 0x8000000
#define PIOB_PER_P27 0x8000000
#define PIOB_PER_P27_BIT 27
#define PIOB_PER_P28_MASK 0x10000000
#define PIOB_PER_P28 0x10000000
#define PIOB_PER_P28_BIT 28
#define PIOB_PER_P29_MASK 0x20000000
#define PIOB_PER_P29 0x20000000
#define PIOB_PER_P29_BIT 29
#define PIOB_PER_P30_MASK 0x40000000
#define PIOB_PER_P30 0x40000000
#define PIOB_PER_P30_BIT 30
#define PIOB_PER_P31_MASK 0x80000000
#define PIOB_PER_P31 0x80000000
#define PIOB_PER_P31_BIT 31

#define PIOB_PDR (*(volatile unsigned long *)0xFFFFF604)
#define PIOB_PDR_OFFSET 0x4
#define PIOB_PDR_P0_MASK 0x1
#define PIOB_PDR_P0 0x1
#define PIOB_PDR_P0_BIT 0
#define PIOB_PDR_P1_MASK 0x2
#define PIOB_PDR_P1 0x2
#define PIOB_PDR_P1_BIT 1
#define PIOB_PDR_P2_MASK 0x4
#define PIOB_PDR_P2 0x4
#define PIOB_PDR_P2_BIT 2
#define PIOB_PDR_P3_MASK 0x8
#define PIOB_PDR_P3 0x8
#define PIOB_PDR_P3_BIT 3
#define PIOB_PDR_P4_MASK 0x10
#define PIOB_PDR_P4 0x10
#define PIOB_PDR_P4_BIT 4
#define PIOB_PDR_P5_MASK 0x20
#define PIOB_PDR_P5 0x20
#define PIOB_PDR_P5_BIT 5
#define PIOB_PDR_P6_MASK 0x40
#define PIOB_PDR_P6 0x40
#define PIOB_PDR_P6_BIT 6
#define PIOB_PDR_P7_MASK 0x80
#define PIOB_PDR_P7 0x80
#define PIOB_PDR_P7_BIT 7
#define PIOB_PDR_P8_MASK 0x100
#define PIOB_PDR_P8 0x100
#define PIOB_PDR_P8_BIT 8
#define PIOB_PDR_P9_MASK 0x200
#define PIOB_PDR_P9 0x200
#define PIOB_PDR_P9_BIT 9
#define PIOB_PDR_P10_MASK 0x400
#define PIOB_PDR_P10 0x400
#define PIOB_PDR_P10_BIT 10
#define PIOB_PDR_P11_MASK 0x800
#define PIOB_PDR_P11 0x800
#define PIOB_PDR_P11_BIT 11
#define PIOB_PDR_P12_MASK 0x1000
#define PIOB_PDR_P12 0x1000
#define PIOB_PDR_P12_BIT 12
#define PIOB_PDR_P13_MASK 0x2000
#define PIOB_PDR_P13 0x2000
#define PIOB_PDR_P13_BIT 13
#define PIOB_PDR_P14_MASK 0x4000
#define PIOB_PDR_P14 0x4000
#define PIOB_PDR_P14_BIT 14
#define PIOB_PDR_P15_MASK 0x8000
#define PIOB_PDR_P15 0x8000
#define PIOB_PDR_P15_BIT 15
#define PIOB_PDR_P16_MASK 0x10000
#define PIOB_PDR_P16 0x10000
#define PIOB_PDR_P16_BIT 16
#define PIOB_PDR_P17_MASK 0x20000
#define PIOB_PDR_P17 0x20000
#define PIOB_PDR_P17_BIT 17
#define PIOB_PDR_P18_MASK 0x40000
#define PIOB_PDR_P18 0x40000
#define PIOB_PDR_P18_BIT 18
#define PIOB_PDR_P19_MASK 0x80000
#define PIOB_PDR_P19 0x80000
#define PIOB_PDR_P19_BIT 19
#define PIOB_PDR_P20_MASK 0x100000
#define PIOB_PDR_P20 0x100000
#define PIOB_PDR_P20_BIT 20
#define PIOB_PDR_P21_MASK 0x200000
#define PIOB_PDR_P21 0x200000
#define PIOB_PDR_P21_BIT 21
#define PIOB_PDR_P22_MASK 0x400000
#define PIOB_PDR_P22 0x400000
#define PIOB_PDR_P22_BIT 22
#define PIOB_PDR_P23_MASK 0x800000
#define PIOB_PDR_P23 0x800000
#define PIOB_PDR_P23_BIT 23
#define PIOB_PDR_P24_MASK 0x1000000
#define PIOB_PDR_P24 0x1000000
#define PIOB_PDR_P24_BIT 24
#define PIOB_PDR_P25_MASK 0x2000000
#define PIOB_PDR_P25 0x2000000
#define PIOB_PDR_P25_BIT 25
#define PIOB_PDR_P26_MASK 0x4000000
#define PIOB_PDR_P26 0x4000000
#define PIOB_PDR_P26_BIT 26
#define PIOB_PDR_P27_MASK 0x8000000
#define PIOB_PDR_P27 0x8000000
#define PIOB_PDR_P27_BIT 27
#define PIOB_PDR_P28_MASK 0x10000000
#define PIOB_PDR_P28 0x10000000
#define PIOB_PDR_P28_BIT 28
#define PIOB_PDR_P29_MASK 0x20000000
#define PIOB_PDR_P29 0x20000000
#define PIOB_PDR_P29_BIT 29
#define PIOB_PDR_P30_MASK 0x40000000
#define PIOB_PDR_P30 0x40000000
#define PIOB_PDR_P30_BIT 30
#define PIOB_PDR_P31_MASK 0x80000000
#define PIOB_PDR_P31 0x80000000
#define PIOB_PDR_P31_BIT 31

#define PIOB_PSR (*(volatile unsigned long *)0xFFFFF608)
#define PIOB_PSR_OFFSET 0x8
#define PIOB_PSR_P0_MASK 0x1
#define PIOB_PSR_P0 0x1
#define PIOB_PSR_P0_BIT 0
#define PIOB_PSR_P1_MASK 0x2
#define PIOB_PSR_P1 0x2
#define PIOB_PSR_P1_BIT 1
#define PIOB_PSR_P2_MASK 0x4
#define PIOB_PSR_P2 0x4
#define PIOB_PSR_P2_BIT 2
#define PIOB_PSR_P3_MASK 0x8
#define PIOB_PSR_P3 0x8
#define PIOB_PSR_P3_BIT 3
#define PIOB_PSR_P4_MASK 0x10
#define PIOB_PSR_P4 0x10
#define PIOB_PSR_P4_BIT 4
#define PIOB_PSR_P5_MASK 0x20
#define PIOB_PSR_P5 0x20
#define PIOB_PSR_P5_BIT 5
#define PIOB_PSR_P6_MASK 0x40
#define PIOB_PSR_P6 0x40
#define PIOB_PSR_P6_BIT 6
#define PIOB_PSR_P7_MASK 0x80
#define PIOB_PSR_P7 0x80
#define PIOB_PSR_P7_BIT 7
#define PIOB_PSR_P8_MASK 0x100
#define PIOB_PSR_P8 0x100
#define PIOB_PSR_P8_BIT 8
#define PIOB_PSR_P9_MASK 0x200
#define PIOB_PSR_P9 0x200
#define PIOB_PSR_P9_BIT 9
#define PIOB_PSR_P10_MASK 0x400
#define PIOB_PSR_P10 0x400
#define PIOB_PSR_P10_BIT 10
#define PIOB_PSR_P11_MASK 0x800
#define PIOB_PSR_P11 0x800
#define PIOB_PSR_P11_BIT 11
#define PIOB_PSR_P12_MASK 0x1000
#define PIOB_PSR_P12 0x1000
#define PIOB_PSR_P12_BIT 12
#define PIOB_PSR_P13_MASK 0x2000
#define PIOB_PSR_P13 0x2000
#define PIOB_PSR_P13_BIT 13
#define PIOB_PSR_P14_MASK 0x4000
#define PIOB_PSR_P14 0x4000
#define PIOB_PSR_P14_BIT 14
#define PIOB_PSR_P15_MASK 0x8000
#define PIOB_PSR_P15 0x8000
#define PIOB_PSR_P15_BIT 15
#define PIOB_PSR_P16_MASK 0x10000
#define PIOB_PSR_P16 0x10000
#define PIOB_PSR_P16_BIT 16
#define PIOB_PSR_P17_MASK 0x20000
#define PIOB_PSR_P17 0x20000
#define PIOB_PSR_P17_BIT 17
#define PIOB_PSR_P18_MASK 0x40000
#define PIOB_PSR_P18 0x40000
#define PIOB_PSR_P18_BIT 18
#define PIOB_PSR_P19_MASK 0x80000
#define PIOB_PSR_P19 0x80000
#define PIOB_PSR_P19_BIT 19
#define PIOB_PSR_P20_MASK 0x100000
#define PIOB_PSR_P20 0x100000
#define PIOB_PSR_P20_BIT 20
#define PIOB_PSR_P21_MASK 0x200000
#define PIOB_PSR_P21 0x200000
#define PIOB_PSR_P21_BIT 21
#define PIOB_PSR_P22_MASK 0x400000
#define PIOB_PSR_P22 0x400000
#define PIOB_PSR_P22_BIT 22
#define PIOB_PSR_P23_MASK 0x800000
#define PIOB_PSR_P23 0x800000
#define PIOB_PSR_P23_BIT 23
#define PIOB_PSR_P24_MASK 0x1000000
#define PIOB_PSR_P24 0x1000000
#define PIOB_PSR_P24_BIT 24
#define PIOB_PSR_P25_MASK 0x2000000
#define PIOB_PSR_P25 0x2000000
#define PIOB_PSR_P25_BIT 25
#define PIOB_PSR_P26_MASK 0x4000000
#define PIOB_PSR_P26 0x4000000
#define PIOB_PSR_P26_BIT 26
#define PIOB_PSR_P27_MASK 0x8000000
#define PIOB_PSR_P27 0x8000000
#define PIOB_PSR_P27_BIT 27
#define PIOB_PSR_P28_MASK 0x10000000
#define PIOB_PSR_P28 0x10000000
#define PIOB_PSR_P28_BIT 28
#define PIOB_PSR_P29_MASK 0x20000000
#define PIOB_PSR_P29 0x20000000
#define PIOB_PSR_P29_BIT 29
#define PIOB_PSR_P30_MASK 0x40000000
#define PIOB_PSR_P30 0x40000000
#define PIOB_PSR_P30_BIT 30
#define PIOB_PSR_P31_MASK 0x80000000
#define PIOB_PSR_P31 0x80000000
#define PIOB_PSR_P31_BIT 31

#define PIOB_OER (*(volatile unsigned long *)0xFFFFF610)
#define PIOB_OER_OFFSET 0x10
#define PIOB_OER_P0_MASK 0x1
#define PIOB_OER_P0 0x1
#define PIOB_OER_P0_BIT 0
#define PIOB_OER_P1_MASK 0x2
#define PIOB_OER_P1 0x2
#define PIOB_OER_P1_BIT 1
#define PIOB_OER_P2_MASK 0x4
#define PIOB_OER_P2 0x4
#define PIOB_OER_P2_BIT 2
#define PIOB_OER_P3_MASK 0x8
#define PIOB_OER_P3 0x8
#define PIOB_OER_P3_BIT 3
#define PIOB_OER_P4_MASK 0x10
#define PIOB_OER_P4 0x10
#define PIOB_OER_P4_BIT 4
#define PIOB_OER_P5_MASK 0x20
#define PIOB_OER_P5 0x20
#define PIOB_OER_P5_BIT 5
#define PIOB_OER_P6_MASK 0x40
#define PIOB_OER_P6 0x40
#define PIOB_OER_P6_BIT 6
#define PIOB_OER_P7_MASK 0x80
#define PIOB_OER_P7 0x80
#define PIOB_OER_P7_BIT 7
#define PIOB_OER_P8_MASK 0x100
#define PIOB_OER_P8 0x100
#define PIOB_OER_P8_BIT 8
#define PIOB_OER_P9_MASK 0x200
#define PIOB_OER_P9 0x200
#define PIOB_OER_P9_BIT 9
#define PIOB_OER_P10_MASK 0x400
#define PIOB_OER_P10 0x400
#define PIOB_OER_P10_BIT 10
#define PIOB_OER_P11_MASK 0x800
#define PIOB_OER_P11 0x800
#define PIOB_OER_P11_BIT 11
#define PIOB_OER_P12_MASK 0x1000
#define PIOB_OER_P12 0x1000
#define PIOB_OER_P12_BIT 12
#define PIOB_OER_P13_MASK 0x2000
#define PIOB_OER_P13 0x2000
#define PIOB_OER_P13_BIT 13
#define PIOB_OER_P14_MASK 0x4000
#define PIOB_OER_P14 0x4000
#define PIOB_OER_P14_BIT 14
#define PIOB_OER_P15_MASK 0x8000
#define PIOB_OER_P15 0x8000
#define PIOB_OER_P15_BIT 15
#define PIOB_OER_P16_MASK 0x10000
#define PIOB_OER_P16 0x10000
#define PIOB_OER_P16_BIT 16
#define PIOB_OER_P17_MASK 0x20000
#define PIOB_OER_P17 0x20000
#define PIOB_OER_P17_BIT 17
#define PIOB_OER_P18_MASK 0x40000
#define PIOB_OER_P18 0x40000
#define PIOB_OER_P18_BIT 18
#define PIOB_OER_P19_MASK 0x80000
#define PIOB_OER_P19 0x80000
#define PIOB_OER_P19_BIT 19
#define PIOB_OER_P20_MASK 0x100000
#define PIOB_OER_P20 0x100000
#define PIOB_OER_P20_BIT 20
#define PIOB_OER_P21_MASK 0x200000
#define PIOB_OER_P21 0x200000
#define PIOB_OER_P21_BIT 21
#define PIOB_OER_P22_MASK 0x400000
#define PIOB_OER_P22 0x400000
#define PIOB_OER_P22_BIT 22
#define PIOB_OER_P23_MASK 0x800000
#define PIOB_OER_P23 0x800000
#define PIOB_OER_P23_BIT 23
#define PIOB_OER_P24_MASK 0x1000000
#define PIOB_OER_P24 0x1000000
#define PIOB_OER_P24_BIT 24
#define PIOB_OER_P25_MASK 0x2000000
#define PIOB_OER_P25 0x2000000
#define PIOB_OER_P25_BIT 25
#define PIOB_OER_P26_MASK 0x4000000
#define PIOB_OER_P26 0x4000000
#define PIOB_OER_P26_BIT 26
#define PIOB_OER_P27_MASK 0x8000000
#define PIOB_OER_P27 0x8000000
#define PIOB_OER_P27_BIT 27
#define PIOB_OER_P28_MASK 0x10000000
#define PIOB_OER_P28 0x10000000
#define PIOB_OER_P28_BIT 28
#define PIOB_OER_P29_MASK 0x20000000
#define PIOB_OER_P29 0x20000000
#define PIOB_OER_P29_BIT 29
#define PIOB_OER_P30_MASK 0x40000000
#define PIOB_OER_P30 0x40000000
#define PIOB_OER_P30_BIT 30
#define PIOB_OER_P31_MASK 0x80000000
#define PIOB_OER_P31 0x80000000
#define PIOB_OER_P31_BIT 31

#define PIOB_ODR (*(volatile unsigned long *)0xFFFFF614)
#define PIOB_ODR_OFFSET 0x14
#define PIOB_ODR_P0_MASK 0x1
#define PIOB_ODR_P0 0x1
#define PIOB_ODR_P0_BIT 0
#define PIOB_ODR_P1_MASK 0x2
#define PIOB_ODR_P1 0x2
#define PIOB_ODR_P1_BIT 1
#define PIOB_ODR_P2_MASK 0x4
#define PIOB_ODR_P2 0x4
#define PIOB_ODR_P2_BIT 2
#define PIOB_ODR_P3_MASK 0x8
#define PIOB_ODR_P3 0x8
#define PIOB_ODR_P3_BIT 3
#define PIOB_ODR_P4_MASK 0x10
#define PIOB_ODR_P4 0x10
#define PIOB_ODR_P4_BIT 4
#define PIOB_ODR_P5_MASK 0x20
#define PIOB_ODR_P5 0x20
#define PIOB_ODR_P5_BIT 5
#define PIOB_ODR_P6_MASK 0x40
#define PIOB_ODR_P6 0x40
#define PIOB_ODR_P6_BIT 6
#define PIOB_ODR_P7_MASK 0x80
#define PIOB_ODR_P7 0x80
#define PIOB_ODR_P7_BIT 7
#define PIOB_ODR_P8_MASK 0x100
#define PIOB_ODR_P8 0x100
#define PIOB_ODR_P8_BIT 8
#define PIOB_ODR_P9_MASK 0x200
#define PIOB_ODR_P9 0x200
#define PIOB_ODR_P9_BIT 9
#define PIOB_ODR_P10_MASK 0x400
#define PIOB_ODR_P10 0x400
#define PIOB_ODR_P10_BIT 10
#define PIOB_ODR_P11_MASK 0x800
#define PIOB_ODR_P11 0x800
#define PIOB_ODR_P11_BIT 11
#define PIOB_ODR_P12_MASK 0x1000
#define PIOB_ODR_P12 0x1000
#define PIOB_ODR_P12_BIT 12
#define PIOB_ODR_P13_MASK 0x2000
#define PIOB_ODR_P13 0x2000
#define PIOB_ODR_P13_BIT 13
#define PIOB_ODR_P14_MASK 0x4000
#define PIOB_ODR_P14 0x4000
#define PIOB_ODR_P14_BIT 14
#define PIOB_ODR_P15_MASK 0x8000
#define PIOB_ODR_P15 0x8000
#define PIOB_ODR_P15_BIT 15
#define PIOB_ODR_P16_MASK 0x10000
#define PIOB_ODR_P16 0x10000
#define PIOB_ODR_P16_BIT 16
#define PIOB_ODR_P17_MASK 0x20000
#define PIOB_ODR_P17 0x20000
#define PIOB_ODR_P17_BIT 17
#define PIOB_ODR_P18_MASK 0x40000
#define PIOB_ODR_P18 0x40000
#define PIOB_ODR_P18_BIT 18
#define PIOB_ODR_P19_MASK 0x80000
#define PIOB_ODR_P19 0x80000
#define PIOB_ODR_P19_BIT 19
#define PIOB_ODR_P20_MASK 0x100000
#define PIOB_ODR_P20 0x100000
#define PIOB_ODR_P20_BIT 20
#define PIOB_ODR_P21_MASK 0x200000
#define PIOB_ODR_P21 0x200000
#define PIOB_ODR_P21_BIT 21
#define PIOB_ODR_P22_MASK 0x400000
#define PIOB_ODR_P22 0x400000
#define PIOB_ODR_P22_BIT 22
#define PIOB_ODR_P23_MASK 0x800000
#define PIOB_ODR_P23 0x800000
#define PIOB_ODR_P23_BIT 23
#define PIOB_ODR_P24_MASK 0x1000000
#define PIOB_ODR_P24 0x1000000
#define PIOB_ODR_P24_BIT 24
#define PIOB_ODR_P25_MASK 0x2000000
#define PIOB_ODR_P25 0x2000000
#define PIOB_ODR_P25_BIT 25
#define PIOB_ODR_P26_MASK 0x4000000
#define PIOB_ODR_P26 0x4000000
#define PIOB_ODR_P26_BIT 26
#define PIOB_ODR_P27_MASK 0x8000000
#define PIOB_ODR_P27 0x8000000
#define PIOB_ODR_P27_BIT 27
#define PIOB_ODR_P28_MASK 0x10000000
#define PIOB_ODR_P28 0x10000000
#define PIOB_ODR_P28_BIT 28
#define PIOB_ODR_P29_MASK 0x20000000
#define PIOB_ODR_P29 0x20000000
#define PIOB_ODR_P29_BIT 29
#define PIOB_ODR_P30_MASK 0x40000000
#define PIOB_ODR_P30 0x40000000
#define PIOB_ODR_P30_BIT 30
#define PIOB_ODR_P31_MASK 0x80000000
#define PIOB_ODR_P31 0x80000000
#define PIOB_ODR_P31_BIT 31

#define PIOB_OSR (*(volatile unsigned long *)0xFFFFF618)
#define PIOB_OSR_OFFSET 0x18
#define PIOB_OSR_P0_MASK 0x1
#define PIOB_OSR_P0 0x1
#define PIOB_OSR_P0_BIT 0
#define PIOB_OSR_P1_MASK 0x2
#define PIOB_OSR_P1 0x2
#define PIOB_OSR_P1_BIT 1
#define PIOB_OSR_P2_MASK 0x4
#define PIOB_OSR_P2 0x4
#define PIOB_OSR_P2_BIT 2
#define PIOB_OSR_P3_MASK 0x8
#define PIOB_OSR_P3 0x8
#define PIOB_OSR_P3_BIT 3
#define PIOB_OSR_P4_MASK 0x10
#define PIOB_OSR_P4 0x10
#define PIOB_OSR_P4_BIT 4
#define PIOB_OSR_P5_MASK 0x20
#define PIOB_OSR_P5 0x20
#define PIOB_OSR_P5_BIT 5
#define PIOB_OSR_P6_MASK 0x40
#define PIOB_OSR_P6 0x40
#define PIOB_OSR_P6_BIT 6
#define PIOB_OSR_P7_MASK 0x80
#define PIOB_OSR_P7 0x80
#define PIOB_OSR_P7_BIT 7
#define PIOB_OSR_P8_MASK 0x100
#define PIOB_OSR_P8 0x100
#define PIOB_OSR_P8_BIT 8
#define PIOB_OSR_P9_MASK 0x200
#define PIOB_OSR_P9 0x200
#define PIOB_OSR_P9_BIT 9
#define PIOB_OSR_P10_MASK 0x400
#define PIOB_OSR_P10 0x400
#define PIOB_OSR_P10_BIT 10
#define PIOB_OSR_P11_MASK 0x800
#define PIOB_OSR_P11 0x800
#define PIOB_OSR_P11_BIT 11
#define PIOB_OSR_P12_MASK 0x1000
#define PIOB_OSR_P12 0x1000
#define PIOB_OSR_P12_BIT 12
#define PIOB_OSR_P13_MASK 0x2000
#define PIOB_OSR_P13 0x2000
#define PIOB_OSR_P13_BIT 13
#define PIOB_OSR_P14_MASK 0x4000
#define PIOB_OSR_P14 0x4000
#define PIOB_OSR_P14_BIT 14
#define PIOB_OSR_P15_MASK 0x8000
#define PIOB_OSR_P15 0x8000
#define PIOB_OSR_P15_BIT 15
#define PIOB_OSR_P16_MASK 0x10000
#define PIOB_OSR_P16 0x10000
#define PIOB_OSR_P16_BIT 16
#define PIOB_OSR_P17_MASK 0x20000
#define PIOB_OSR_P17 0x20000
#define PIOB_OSR_P17_BIT 17
#define PIOB_OSR_P18_MASK 0x40000
#define PIOB_OSR_P18 0x40000
#define PIOB_OSR_P18_BIT 18
#define PIOB_OSR_P19_MASK 0x80000
#define PIOB_OSR_P19 0x80000
#define PIOB_OSR_P19_BIT 19
#define PIOB_OSR_P20_MASK 0x100000
#define PIOB_OSR_P20 0x100000
#define PIOB_OSR_P20_BIT 20
#define PIOB_OSR_P21_MASK 0x200000
#define PIOB_OSR_P21 0x200000
#define PIOB_OSR_P21_BIT 21
#define PIOB_OSR_P22_MASK 0x400000
#define PIOB_OSR_P22 0x400000
#define PIOB_OSR_P22_BIT 22
#define PIOB_OSR_P23_MASK 0x800000
#define PIOB_OSR_P23 0x800000
#define PIOB_OSR_P23_BIT 23
#define PIOB_OSR_P24_MASK 0x1000000
#define PIOB_OSR_P24 0x1000000
#define PIOB_OSR_P24_BIT 24
#define PIOB_OSR_P25_MASK 0x2000000
#define PIOB_OSR_P25 0x2000000
#define PIOB_OSR_P25_BIT 25
#define PIOB_OSR_P26_MASK 0x4000000
#define PIOB_OSR_P26 0x4000000
#define PIOB_OSR_P26_BIT 26
#define PIOB_OSR_P27_MASK 0x8000000
#define PIOB_OSR_P27 0x8000000
#define PIOB_OSR_P27_BIT 27
#define PIOB_OSR_P28_MASK 0x10000000
#define PIOB_OSR_P28 0x10000000
#define PIOB_OSR_P28_BIT 28
#define PIOB_OSR_P29_MASK 0x20000000
#define PIOB_OSR_P29 0x20000000
#define PIOB_OSR_P29_BIT 29
#define PIOB_OSR_P30_MASK 0x40000000
#define PIOB_OSR_P30 0x40000000
#define PIOB_OSR_P30_BIT 30
#define PIOB_OSR_P31_MASK 0x80000000
#define PIOB_OSR_P31 0x80000000
#define PIOB_OSR_P31_BIT 31

#define PIOB_IFER (*(volatile unsigned long *)0xFFFFF620)
#define PIOB_IFER_OFFSET 0x20
#define PIOB_IFER_P0_MASK 0x1
#define PIOB_IFER_P0 0x1
#define PIOB_IFER_P0_BIT 0
#define PIOB_IFER_P1_MASK 0x2
#define PIOB_IFER_P1 0x2
#define PIOB_IFER_P1_BIT 1
#define PIOB_IFER_P2_MASK 0x4
#define PIOB_IFER_P2 0x4
#define PIOB_IFER_P2_BIT 2
#define PIOB_IFER_P3_MASK 0x8
#define PIOB_IFER_P3 0x8
#define PIOB_IFER_P3_BIT 3
#define PIOB_IFER_P4_MASK 0x10
#define PIOB_IFER_P4 0x10
#define PIOB_IFER_P4_BIT 4
#define PIOB_IFER_P5_MASK 0x20
#define PIOB_IFER_P5 0x20
#define PIOB_IFER_P5_BIT 5
#define PIOB_IFER_P6_MASK 0x40
#define PIOB_IFER_P6 0x40
#define PIOB_IFER_P6_BIT 6
#define PIOB_IFER_P7_MASK 0x80
#define PIOB_IFER_P7 0x80
#define PIOB_IFER_P7_BIT 7
#define PIOB_IFER_P8_MASK 0x100
#define PIOB_IFER_P8 0x100
#define PIOB_IFER_P8_BIT 8
#define PIOB_IFER_P9_MASK 0x200
#define PIOB_IFER_P9 0x200
#define PIOB_IFER_P9_BIT 9
#define PIOB_IFER_P10_MASK 0x400
#define PIOB_IFER_P10 0x400
#define PIOB_IFER_P10_BIT 10
#define PIOB_IFER_P11_MASK 0x800
#define PIOB_IFER_P11 0x800
#define PIOB_IFER_P11_BIT 11
#define PIOB_IFER_P12_MASK 0x1000
#define PIOB_IFER_P12 0x1000
#define PIOB_IFER_P12_BIT 12
#define PIOB_IFER_P13_MASK 0x2000
#define PIOB_IFER_P13 0x2000
#define PIOB_IFER_P13_BIT 13
#define PIOB_IFER_P14_MASK 0x4000
#define PIOB_IFER_P14 0x4000
#define PIOB_IFER_P14_BIT 14
#define PIOB_IFER_P15_MASK 0x8000
#define PIOB_IFER_P15 0x8000
#define PIOB_IFER_P15_BIT 15
#define PIOB_IFER_P16_MASK 0x10000
#define PIOB_IFER_P16 0x10000
#define PIOB_IFER_P16_BIT 16
#define PIOB_IFER_P17_MASK 0x20000
#define PIOB_IFER_P17 0x20000
#define PIOB_IFER_P17_BIT 17
#define PIOB_IFER_P18_MASK 0x40000
#define PIOB_IFER_P18 0x40000
#define PIOB_IFER_P18_BIT 18
#define PIOB_IFER_P19_MASK 0x80000
#define PIOB_IFER_P19 0x80000
#define PIOB_IFER_P19_BIT 19
#define PIOB_IFER_P20_MASK 0x100000
#define PIOB_IFER_P20 0x100000
#define PIOB_IFER_P20_BIT 20
#define PIOB_IFER_P21_MASK 0x200000
#define PIOB_IFER_P21 0x200000
#define PIOB_IFER_P21_BIT 21
#define PIOB_IFER_P22_MASK 0x400000
#define PIOB_IFER_P22 0x400000
#define PIOB_IFER_P22_BIT 22
#define PIOB_IFER_P23_MASK 0x800000
#define PIOB_IFER_P23 0x800000
#define PIOB_IFER_P23_BIT 23
#define PIOB_IFER_P24_MASK 0x1000000
#define PIOB_IFER_P24 0x1000000
#define PIOB_IFER_P24_BIT 24
#define PIOB_IFER_P25_MASK 0x2000000
#define PIOB_IFER_P25 0x2000000
#define PIOB_IFER_P25_BIT 25
#define PIOB_IFER_P26_MASK 0x4000000
#define PIOB_IFER_P26 0x4000000
#define PIOB_IFER_P26_BIT 26
#define PIOB_IFER_P27_MASK 0x8000000
#define PIOB_IFER_P27 0x8000000
#define PIOB_IFER_P27_BIT 27
#define PIOB_IFER_P28_MASK 0x10000000
#define PIOB_IFER_P28 0x10000000
#define PIOB_IFER_P28_BIT 28
#define PIOB_IFER_P29_MASK 0x20000000
#define PIOB_IFER_P29 0x20000000
#define PIOB_IFER_P29_BIT 29
#define PIOB_IFER_P30_MASK 0x40000000
#define PIOB_IFER_P30 0x40000000
#define PIOB_IFER_P30_BIT 30
#define PIOB_IFER_P31_MASK 0x80000000
#define PIOB_IFER_P31 0x80000000
#define PIOB_IFER_P31_BIT 31

#define PIOB_IFDR (*(volatile unsigned long *)0xFFFFF624)
#define PIOB_IFDR_OFFSET 0x24
#define PIOB_IFDR_P0_MASK 0x1
#define PIOB_IFDR_P0 0x1
#define PIOB_IFDR_P0_BIT 0
#define PIOB_IFDR_P1_MASK 0x2
#define PIOB_IFDR_P1 0x2
#define PIOB_IFDR_P1_BIT 1
#define PIOB_IFDR_P2_MASK 0x4
#define PIOB_IFDR_P2 0x4
#define PIOB_IFDR_P2_BIT 2
#define PIOB_IFDR_P3_MASK 0x8
#define PIOB_IFDR_P3 0x8
#define PIOB_IFDR_P3_BIT 3
#define PIOB_IFDR_P4_MASK 0x10
#define PIOB_IFDR_P4 0x10
#define PIOB_IFDR_P4_BIT 4
#define PIOB_IFDR_P5_MASK 0x20
#define PIOB_IFDR_P5 0x20
#define PIOB_IFDR_P5_BIT 5
#define PIOB_IFDR_P6_MASK 0x40
#define PIOB_IFDR_P6 0x40
#define PIOB_IFDR_P6_BIT 6
#define PIOB_IFDR_P7_MASK 0x80
#define PIOB_IFDR_P7 0x80
#define PIOB_IFDR_P7_BIT 7
#define PIOB_IFDR_P8_MASK 0x100
#define PIOB_IFDR_P8 0x100
#define PIOB_IFDR_P8_BIT 8
#define PIOB_IFDR_P9_MASK 0x200
#define PIOB_IFDR_P9 0x200
#define PIOB_IFDR_P9_BIT 9
#define PIOB_IFDR_P10_MASK 0x400
#define PIOB_IFDR_P10 0x400
#define PIOB_IFDR_P10_BIT 10
#define PIOB_IFDR_P11_MASK 0x800
#define PIOB_IFDR_P11 0x800
#define PIOB_IFDR_P11_BIT 11
#define PIOB_IFDR_P12_MASK 0x1000
#define PIOB_IFDR_P12 0x1000
#define PIOB_IFDR_P12_BIT 12
#define PIOB_IFDR_P13_MASK 0x2000
#define PIOB_IFDR_P13 0x2000
#define PIOB_IFDR_P13_BIT 13
#define PIOB_IFDR_P14_MASK 0x4000
#define PIOB_IFDR_P14 0x4000
#define PIOB_IFDR_P14_BIT 14
#define PIOB_IFDR_P15_MASK 0x8000
#define PIOB_IFDR_P15 0x8000
#define PIOB_IFDR_P15_BIT 15
#define PIOB_IFDR_P16_MASK 0x10000
#define PIOB_IFDR_P16 0x10000
#define PIOB_IFDR_P16_BIT 16
#define PIOB_IFDR_P17_MASK 0x20000
#define PIOB_IFDR_P17 0x20000
#define PIOB_IFDR_P17_BIT 17
#define PIOB_IFDR_P18_MASK 0x40000
#define PIOB_IFDR_P18 0x40000
#define PIOB_IFDR_P18_BIT 18
#define PIOB_IFDR_P19_MASK 0x80000
#define PIOB_IFDR_P19 0x80000
#define PIOB_IFDR_P19_BIT 19
#define PIOB_IFDR_P20_MASK 0x100000
#define PIOB_IFDR_P20 0x100000
#define PIOB_IFDR_P20_BIT 20
#define PIOB_IFDR_P21_MASK 0x200000
#define PIOB_IFDR_P21 0x200000
#define PIOB_IFDR_P21_BIT 21
#define PIOB_IFDR_P22_MASK 0x400000
#define PIOB_IFDR_P22 0x400000
#define PIOB_IFDR_P22_BIT 22
#define PIOB_IFDR_P23_MASK 0x800000
#define PIOB_IFDR_P23 0x800000
#define PIOB_IFDR_P23_BIT 23
#define PIOB_IFDR_P24_MASK 0x1000000
#define PIOB_IFDR_P24 0x1000000
#define PIOB_IFDR_P24_BIT 24
#define PIOB_IFDR_P25_MASK 0x2000000
#define PIOB_IFDR_P25 0x2000000
#define PIOB_IFDR_P25_BIT 25
#define PIOB_IFDR_P26_MASK 0x4000000
#define PIOB_IFDR_P26 0x4000000
#define PIOB_IFDR_P26_BIT 26
#define PIOB_IFDR_P27_MASK 0x8000000
#define PIOB_IFDR_P27 0x8000000
#define PIOB_IFDR_P27_BIT 27
#define PIOB_IFDR_P28_MASK 0x10000000
#define PIOB_IFDR_P28 0x10000000
#define PIOB_IFDR_P28_BIT 28
#define PIOB_IFDR_P29_MASK 0x20000000
#define PIOB_IFDR_P29 0x20000000
#define PIOB_IFDR_P29_BIT 29
#define PIOB_IFDR_P30_MASK 0x40000000
#define PIOB_IFDR_P30 0x40000000
#define PIOB_IFDR_P30_BIT 30
#define PIOB_IFDR_P31_MASK 0x80000000
#define PIOB_IFDR_P31 0x80000000
#define PIOB_IFDR_P31_BIT 31

#define PIOB_IFSR (*(volatile unsigned long *)0xFFFFF628)
#define PIOB_IFSR_OFFSET 0x28
#define PIOB_IFSR_P0_MASK 0x1
#define PIOB_IFSR_P0 0x1
#define PIOB_IFSR_P0_BIT 0
#define PIOB_IFSR_P1_MASK 0x2
#define PIOB_IFSR_P1 0x2
#define PIOB_IFSR_P1_BIT 1
#define PIOB_IFSR_P2_MASK 0x4
#define PIOB_IFSR_P2 0x4
#define PIOB_IFSR_P2_BIT 2
#define PIOB_IFSR_P3_MASK 0x8
#define PIOB_IFSR_P3 0x8
#define PIOB_IFSR_P3_BIT 3
#define PIOB_IFSR_P4_MASK 0x10
#define PIOB_IFSR_P4 0x10
#define PIOB_IFSR_P4_BIT 4
#define PIOB_IFSR_P5_MASK 0x20
#define PIOB_IFSR_P5 0x20
#define PIOB_IFSR_P5_BIT 5
#define PIOB_IFSR_P6_MASK 0x40
#define PIOB_IFSR_P6 0x40
#define PIOB_IFSR_P6_BIT 6
#define PIOB_IFSR_P7_MASK 0x80
#define PIOB_IFSR_P7 0x80
#define PIOB_IFSR_P7_BIT 7
#define PIOB_IFSR_P8_MASK 0x100
#define PIOB_IFSR_P8 0x100
#define PIOB_IFSR_P8_BIT 8
#define PIOB_IFSR_P9_MASK 0x200
#define PIOB_IFSR_P9 0x200
#define PIOB_IFSR_P9_BIT 9
#define PIOB_IFSR_P10_MASK 0x400
#define PIOB_IFSR_P10 0x400
#define PIOB_IFSR_P10_BIT 10
#define PIOB_IFSR_P11_MASK 0x800
#define PIOB_IFSR_P11 0x800
#define PIOB_IFSR_P11_BIT 11
#define PIOB_IFSR_P12_MASK 0x1000
#define PIOB_IFSR_P12 0x1000
#define PIOB_IFSR_P12_BIT 12
#define PIOB_IFSR_P13_MASK 0x2000
#define PIOB_IFSR_P13 0x2000
#define PIOB_IFSR_P13_BIT 13
#define PIOB_IFSR_P14_MASK 0x4000
#define PIOB_IFSR_P14 0x4000
#define PIOB_IFSR_P14_BIT 14
#define PIOB_IFSR_P15_MASK 0x8000
#define PIOB_IFSR_P15 0x8000
#define PIOB_IFSR_P15_BIT 15
#define PIOB_IFSR_P16_MASK 0x10000
#define PIOB_IFSR_P16 0x10000
#define PIOB_IFSR_P16_BIT 16
#define PIOB_IFSR_P17_MASK 0x20000
#define PIOB_IFSR_P17 0x20000
#define PIOB_IFSR_P17_BIT 17
#define PIOB_IFSR_P18_MASK 0x40000
#define PIOB_IFSR_P18 0x40000
#define PIOB_IFSR_P18_BIT 18
#define PIOB_IFSR_P19_MASK 0x80000
#define PIOB_IFSR_P19 0x80000
#define PIOB_IFSR_P19_BIT 19
#define PIOB_IFSR_P20_MASK 0x100000
#define PIOB_IFSR_P20 0x100000
#define PIOB_IFSR_P20_BIT 20
#define PIOB_IFSR_P21_MASK 0x200000
#define PIOB_IFSR_P21 0x200000
#define PIOB_IFSR_P21_BIT 21
#define PIOB_IFSR_P22_MASK 0x400000
#define PIOB_IFSR_P22 0x400000
#define PIOB_IFSR_P22_BIT 22
#define PIOB_IFSR_P23_MASK 0x800000
#define PIOB_IFSR_P23 0x800000
#define PIOB_IFSR_P23_BIT 23
#define PIOB_IFSR_P24_MASK 0x1000000
#define PIOB_IFSR_P24 0x1000000
#define PIOB_IFSR_P24_BIT 24
#define PIOB_IFSR_P25_MASK 0x2000000
#define PIOB_IFSR_P25 0x2000000
#define PIOB_IFSR_P25_BIT 25
#define PIOB_IFSR_P26_MASK 0x4000000
#define PIOB_IFSR_P26 0x4000000
#define PIOB_IFSR_P26_BIT 26
#define PIOB_IFSR_P27_MASK 0x8000000
#define PIOB_IFSR_P27 0x8000000
#define PIOB_IFSR_P27_BIT 27
#define PIOB_IFSR_P28_MASK 0x10000000
#define PIOB_IFSR_P28 0x10000000
#define PIOB_IFSR_P28_BIT 28
#define PIOB_IFSR_P29_MASK 0x20000000
#define PIOB_IFSR_P29 0x20000000
#define PIOB_IFSR_P29_BIT 29
#define PIOB_IFSR_P30_MASK 0x40000000
#define PIOB_IFSR_P30 0x40000000
#define PIOB_IFSR_P30_BIT 30
#define PIOB_IFSR_P31_MASK 0x80000000
#define PIOB_IFSR_P31 0x80000000
#define PIOB_IFSR_P31_BIT 31

#define PIOB_SODR (*(volatile unsigned long *)0xFFFFF630)
#define PIOB_SODR_OFFSET 0x30
#define PIOB_SODR_P0_MASK 0x1
#define PIOB_SODR_P0 0x1
#define PIOB_SODR_P0_BIT 0
#define PIOB_SODR_P1_MASK 0x2
#define PIOB_SODR_P1 0x2
#define PIOB_SODR_P1_BIT 1
#define PIOB_SODR_P2_MASK 0x4
#define PIOB_SODR_P2 0x4
#define PIOB_SODR_P2_BIT 2
#define PIOB_SODR_P3_MASK 0x8
#define PIOB_SODR_P3 0x8
#define PIOB_SODR_P3_BIT 3
#define PIOB_SODR_P4_MASK 0x10
#define PIOB_SODR_P4 0x10
#define PIOB_SODR_P4_BIT 4
#define PIOB_SODR_P5_MASK 0x20
#define PIOB_SODR_P5 0x20
#define PIOB_SODR_P5_BIT 5
#define PIOB_SODR_P6_MASK 0x40
#define PIOB_SODR_P6 0x40
#define PIOB_SODR_P6_BIT 6
#define PIOB_SODR_P7_MASK 0x80
#define PIOB_SODR_P7 0x80
#define PIOB_SODR_P7_BIT 7
#define PIOB_SODR_P8_MASK 0x100
#define PIOB_SODR_P8 0x100
#define PIOB_SODR_P8_BIT 8
#define PIOB_SODR_P9_MASK 0x200
#define PIOB_SODR_P9 0x200
#define PIOB_SODR_P9_BIT 9
#define PIOB_SODR_P10_MASK 0x400
#define PIOB_SODR_P10 0x400
#define PIOB_SODR_P10_BIT 10
#define PIOB_SODR_P11_MASK 0x800
#define PIOB_SODR_P11 0x800
#define PIOB_SODR_P11_BIT 11
#define PIOB_SODR_P12_MASK 0x1000
#define PIOB_SODR_P12 0x1000
#define PIOB_SODR_P12_BIT 12
#define PIOB_SODR_P13_MASK 0x2000
#define PIOB_SODR_P13 0x2000
#define PIOB_SODR_P13_BIT 13
#define PIOB_SODR_P14_MASK 0x4000
#define PIOB_SODR_P14 0x4000
#define PIOB_SODR_P14_BIT 14
#define PIOB_SODR_P15_MASK 0x8000
#define PIOB_SODR_P15 0x8000
#define PIOB_SODR_P15_BIT 15
#define PIOB_SODR_P16_MASK 0x10000
#define PIOB_SODR_P16 0x10000
#define PIOB_SODR_P16_BIT 16
#define PIOB_SODR_P17_MASK 0x20000
#define PIOB_SODR_P17 0x20000
#define PIOB_SODR_P17_BIT 17
#define PIOB_SODR_P18_MASK 0x40000
#define PIOB_SODR_P18 0x40000
#define PIOB_SODR_P18_BIT 18
#define PIOB_SODR_P19_MASK 0x80000
#define PIOB_SODR_P19 0x80000
#define PIOB_SODR_P19_BIT 19
#define PIOB_SODR_P20_MASK 0x100000
#define PIOB_SODR_P20 0x100000
#define PIOB_SODR_P20_BIT 20
#define PIOB_SODR_P21_MASK 0x200000
#define PIOB_SODR_P21 0x200000
#define PIOB_SODR_P21_BIT 21
#define PIOB_SODR_P22_MASK 0x400000
#define PIOB_SODR_P22 0x400000
#define PIOB_SODR_P22_BIT 22
#define PIOB_SODR_P23_MASK 0x800000
#define PIOB_SODR_P23 0x800000
#define PIOB_SODR_P23_BIT 23
#define PIOB_SODR_P24_MASK 0x1000000
#define PIOB_SODR_P24 0x1000000
#define PIOB_SODR_P24_BIT 24
#define PIOB_SODR_P25_MASK 0x2000000
#define PIOB_SODR_P25 0x2000000
#define PIOB_SODR_P25_BIT 25
#define PIOB_SODR_P26_MASK 0x4000000
#define PIOB_SODR_P26 0x4000000
#define PIOB_SODR_P26_BIT 26
#define PIOB_SODR_P27_MASK 0x8000000
#define PIOB_SODR_P27 0x8000000
#define PIOB_SODR_P27_BIT 27
#define PIOB_SODR_P28_MASK 0x10000000
#define PIOB_SODR_P28 0x10000000
#define PIOB_SODR_P28_BIT 28
#define PIOB_SODR_P29_MASK 0x20000000
#define PIOB_SODR_P29 0x20000000
#define PIOB_SODR_P29_BIT 29
#define PIOB_SODR_P30_MASK 0x40000000
#define PIOB_SODR_P30 0x40000000
#define PIOB_SODR_P30_BIT 30
#define PIOB_SODR_P31_MASK 0x80000000
#define PIOB_SODR_P31 0x80000000
#define PIOB_SODR_P31_BIT 31

#define PIOB_CODR (*(volatile unsigned long *)0xFFFFF634)
#define PIOB_CODR_OFFSET 0x34
#define PIOB_CODR_P0_MASK 0x1
#define PIOB_CODR_P0 0x1
#define PIOB_CODR_P0_BIT 0
#define PIOB_CODR_P1_MASK 0x2
#define PIOB_CODR_P1 0x2
#define PIOB_CODR_P1_BIT 1
#define PIOB_CODR_P2_MASK 0x4
#define PIOB_CODR_P2 0x4
#define PIOB_CODR_P2_BIT 2
#define PIOB_CODR_P3_MASK 0x8
#define PIOB_CODR_P3 0x8
#define PIOB_CODR_P3_BIT 3
#define PIOB_CODR_P4_MASK 0x10
#define PIOB_CODR_P4 0x10
#define PIOB_CODR_P4_BIT 4
#define PIOB_CODR_P5_MASK 0x20
#define PIOB_CODR_P5 0x20
#define PIOB_CODR_P5_BIT 5
#define PIOB_CODR_P6_MASK 0x40
#define PIOB_CODR_P6 0x40
#define PIOB_CODR_P6_BIT 6
#define PIOB_CODR_P7_MASK 0x80
#define PIOB_CODR_P7 0x80
#define PIOB_CODR_P7_BIT 7
#define PIOB_CODR_P8_MASK 0x100
#define PIOB_CODR_P8 0x100
#define PIOB_CODR_P8_BIT 8
#define PIOB_CODR_P9_MASK 0x200
#define PIOB_CODR_P9 0x200
#define PIOB_CODR_P9_BIT 9
#define PIOB_CODR_P10_MASK 0x400
#define PIOB_CODR_P10 0x400
#define PIOB_CODR_P10_BIT 10
#define PIOB_CODR_P11_MASK 0x800
#define PIOB_CODR_P11 0x800
#define PIOB_CODR_P11_BIT 11
#define PIOB_CODR_P12_MASK 0x1000
#define PIOB_CODR_P12 0x1000
#define PIOB_CODR_P12_BIT 12
#define PIOB_CODR_P13_MASK 0x2000
#define PIOB_CODR_P13 0x2000
#define PIOB_CODR_P13_BIT 13
#define PIOB_CODR_P14_MASK 0x4000
#define PIOB_CODR_P14 0x4000
#define PIOB_CODR_P14_BIT 14
#define PIOB_CODR_P15_MASK 0x8000
#define PIOB_CODR_P15 0x8000
#define PIOB_CODR_P15_BIT 15
#define PIOB_CODR_P16_MASK 0x10000
#define PIOB_CODR_P16 0x10000
#define PIOB_CODR_P16_BIT 16
#define PIOB_CODR_P17_MASK 0x20000
#define PIOB_CODR_P17 0x20000
#define PIOB_CODR_P17_BIT 17
#define PIOB_CODR_P18_MASK 0x40000
#define PIOB_CODR_P18 0x40000
#define PIOB_CODR_P18_BIT 18
#define PIOB_CODR_P19_MASK 0x80000
#define PIOB_CODR_P19 0x80000
#define PIOB_CODR_P19_BIT 19
#define PIOB_CODR_P20_MASK 0x100000
#define PIOB_CODR_P20 0x100000
#define PIOB_CODR_P20_BIT 20
#define PIOB_CODR_P21_MASK 0x200000
#define PIOB_CODR_P21 0x200000
#define PIOB_CODR_P21_BIT 21
#define PIOB_CODR_P22_MASK 0x400000
#define PIOB_CODR_P22 0x400000
#define PIOB_CODR_P22_BIT 22
#define PIOB_CODR_P23_MASK 0x800000
#define PIOB_CODR_P23 0x800000
#define PIOB_CODR_P23_BIT 23
#define PIOB_CODR_P24_MASK 0x1000000
#define PIOB_CODR_P24 0x1000000
#define PIOB_CODR_P24_BIT 24
#define PIOB_CODR_P25_MASK 0x2000000
#define PIOB_CODR_P25 0x2000000
#define PIOB_CODR_P25_BIT 25
#define PIOB_CODR_P26_MASK 0x4000000
#define PIOB_CODR_P26 0x4000000
#define PIOB_CODR_P26_BIT 26
#define PIOB_CODR_P27_MASK 0x8000000
#define PIOB_CODR_P27 0x8000000
#define PIOB_CODR_P27_BIT 27
#define PIOB_CODR_P28_MASK 0x10000000
#define PIOB_CODR_P28 0x10000000
#define PIOB_CODR_P28_BIT 28
#define PIOB_CODR_P29_MASK 0x20000000
#define PIOB_CODR_P29 0x20000000
#define PIOB_CODR_P29_BIT 29
#define PIOB_CODR_P30_MASK 0x40000000
#define PIOB_CODR_P30 0x40000000
#define PIOB_CODR_P30_BIT 30
#define PIOB_CODR_P31_MASK 0x80000000
#define PIOB_CODR_P31 0x80000000
#define PIOB_CODR_P31_BIT 31

#define PIOB_ODSR (*(volatile unsigned long *)0xFFFFF638)
#define PIOB_ODSR_OFFSET 0x38
#define PIOB_ODSR_P0_MASK 0x1
#define PIOB_ODSR_P0 0x1
#define PIOB_ODSR_P0_BIT 0
#define PIOB_ODSR_P1_MASK 0x2
#define PIOB_ODSR_P1 0x2
#define PIOB_ODSR_P1_BIT 1
#define PIOB_ODSR_P2_MASK 0x4
#define PIOB_ODSR_P2 0x4
#define PIOB_ODSR_P2_BIT 2
#define PIOB_ODSR_P3_MASK 0x8
#define PIOB_ODSR_P3 0x8
#define PIOB_ODSR_P3_BIT 3
#define PIOB_ODSR_P4_MASK 0x10
#define PIOB_ODSR_P4 0x10
#define PIOB_ODSR_P4_BIT 4
#define PIOB_ODSR_P5_MASK 0x20
#define PIOB_ODSR_P5 0x20
#define PIOB_ODSR_P5_BIT 5
#define PIOB_ODSR_P6_MASK 0x40
#define PIOB_ODSR_P6 0x40
#define PIOB_ODSR_P6_BIT 6
#define PIOB_ODSR_P7_MASK 0x80
#define PIOB_ODSR_P7 0x80
#define PIOB_ODSR_P7_BIT 7
#define PIOB_ODSR_P8_MASK 0x100
#define PIOB_ODSR_P8 0x100
#define PIOB_ODSR_P8_BIT 8
#define PIOB_ODSR_P9_MASK 0x200
#define PIOB_ODSR_P9 0x200
#define PIOB_ODSR_P9_BIT 9
#define PIOB_ODSR_P10_MASK 0x400
#define PIOB_ODSR_P10 0x400
#define PIOB_ODSR_P10_BIT 10
#define PIOB_ODSR_P11_MASK 0x800
#define PIOB_ODSR_P11 0x800
#define PIOB_ODSR_P11_BIT 11
#define PIOB_ODSR_P12_MASK 0x1000
#define PIOB_ODSR_P12 0x1000
#define PIOB_ODSR_P12_BIT 12
#define PIOB_ODSR_P13_MASK 0x2000
#define PIOB_ODSR_P13 0x2000
#define PIOB_ODSR_P13_BIT 13
#define PIOB_ODSR_P14_MASK 0x4000
#define PIOB_ODSR_P14 0x4000
#define PIOB_ODSR_P14_BIT 14
#define PIOB_ODSR_P15_MASK 0x8000
#define PIOB_ODSR_P15 0x8000
#define PIOB_ODSR_P15_BIT 15
#define PIOB_ODSR_P16_MASK 0x10000
#define PIOB_ODSR_P16 0x10000
#define PIOB_ODSR_P16_BIT 16
#define PIOB_ODSR_P17_MASK 0x20000
#define PIOB_ODSR_P17 0x20000
#define PIOB_ODSR_P17_BIT 17
#define PIOB_ODSR_P18_MASK 0x40000
#define PIOB_ODSR_P18 0x40000
#define PIOB_ODSR_P18_BIT 18
#define PIOB_ODSR_P19_MASK 0x80000
#define PIOB_ODSR_P19 0x80000
#define PIOB_ODSR_P19_BIT 19
#define PIOB_ODSR_P20_MASK 0x100000
#define PIOB_ODSR_P20 0x100000
#define PIOB_ODSR_P20_BIT 20
#define PIOB_ODSR_P21_MASK 0x200000
#define PIOB_ODSR_P21 0x200000
#define PIOB_ODSR_P21_BIT 21
#define PIOB_ODSR_P22_MASK 0x400000
#define PIOB_ODSR_P22 0x400000
#define PIOB_ODSR_P22_BIT 22
#define PIOB_ODSR_P23_MASK 0x800000
#define PIOB_ODSR_P23 0x800000
#define PIOB_ODSR_P23_BIT 23
#define PIOB_ODSR_P24_MASK 0x1000000
#define PIOB_ODSR_P24 0x1000000
#define PIOB_ODSR_P24_BIT 24
#define PIOB_ODSR_P25_MASK 0x2000000
#define PIOB_ODSR_P25 0x2000000
#define PIOB_ODSR_P25_BIT 25
#define PIOB_ODSR_P26_MASK 0x4000000
#define PIOB_ODSR_P26 0x4000000
#define PIOB_ODSR_P26_BIT 26
#define PIOB_ODSR_P27_MASK 0x8000000
#define PIOB_ODSR_P27 0x8000000
#define PIOB_ODSR_P27_BIT 27
#define PIOB_ODSR_P28_MASK 0x10000000
#define PIOB_ODSR_P28 0x10000000
#define PIOB_ODSR_P28_BIT 28
#define PIOB_ODSR_P29_MASK 0x20000000
#define PIOB_ODSR_P29 0x20000000
#define PIOB_ODSR_P29_BIT 29
#define PIOB_ODSR_P30_MASK 0x40000000
#define PIOB_ODSR_P30 0x40000000
#define PIOB_ODSR_P30_BIT 30
#define PIOB_ODSR_P31_MASK 0x80000000
#define PIOB_ODSR_P31 0x80000000
#define PIOB_ODSR_P31_BIT 31

#define PIOB_PDSR (*(volatile unsigned long *)0xFFFFF63C)
#define PIOB_PDSR_OFFSET 0x3C
#define PIOB_PDSR_P0_MASK 0x1
#define PIOB_PDSR_P0 0x1
#define PIOB_PDSR_P0_BIT 0
#define PIOB_PDSR_P1_MASK 0x2
#define PIOB_PDSR_P1 0x2
#define PIOB_PDSR_P1_BIT 1
#define PIOB_PDSR_P2_MASK 0x4
#define PIOB_PDSR_P2 0x4
#define PIOB_PDSR_P2_BIT 2
#define PIOB_PDSR_P3_MASK 0x8
#define PIOB_PDSR_P3 0x8
#define PIOB_PDSR_P3_BIT 3
#define PIOB_PDSR_P4_MASK 0x10
#define PIOB_PDSR_P4 0x10
#define PIOB_PDSR_P4_BIT 4
#define PIOB_PDSR_P5_MASK 0x20
#define PIOB_PDSR_P5 0x20
#define PIOB_PDSR_P5_BIT 5
#define PIOB_PDSR_P6_MASK 0x40
#define PIOB_PDSR_P6 0x40
#define PIOB_PDSR_P6_BIT 6
#define PIOB_PDSR_P7_MASK 0x80
#define PIOB_PDSR_P7 0x80
#define PIOB_PDSR_P7_BIT 7
#define PIOB_PDSR_P8_MASK 0x100
#define PIOB_PDSR_P8 0x100
#define PIOB_PDSR_P8_BIT 8
#define PIOB_PDSR_P9_MASK 0x200
#define PIOB_PDSR_P9 0x200
#define PIOB_PDSR_P9_BIT 9
#define PIOB_PDSR_P10_MASK 0x400
#define PIOB_PDSR_P10 0x400
#define PIOB_PDSR_P10_BIT 10
#define PIOB_PDSR_P11_MASK 0x800
#define PIOB_PDSR_P11 0x800
#define PIOB_PDSR_P11_BIT 11
#define PIOB_PDSR_P12_MASK 0x1000
#define PIOB_PDSR_P12 0x1000
#define PIOB_PDSR_P12_BIT 12
#define PIOB_PDSR_P13_MASK 0x2000
#define PIOB_PDSR_P13 0x2000
#define PIOB_PDSR_P13_BIT 13
#define PIOB_PDSR_P14_MASK 0x4000
#define PIOB_PDSR_P14 0x4000
#define PIOB_PDSR_P14_BIT 14
#define PIOB_PDSR_P15_MASK 0x8000
#define PIOB_PDSR_P15 0x8000
#define PIOB_PDSR_P15_BIT 15
#define PIOB_PDSR_P16_MASK 0x10000
#define PIOB_PDSR_P16 0x10000
#define PIOB_PDSR_P16_BIT 16
#define PIOB_PDSR_P17_MASK 0x20000
#define PIOB_PDSR_P17 0x20000
#define PIOB_PDSR_P17_BIT 17
#define PIOB_PDSR_P18_MASK 0x40000
#define PIOB_PDSR_P18 0x40000
#define PIOB_PDSR_P18_BIT 18
#define PIOB_PDSR_P19_MASK 0x80000
#define PIOB_PDSR_P19 0x80000
#define PIOB_PDSR_P19_BIT 19
#define PIOB_PDSR_P20_MASK 0x100000
#define PIOB_PDSR_P20 0x100000
#define PIOB_PDSR_P20_BIT 20
#define PIOB_PDSR_P21_MASK 0x200000
#define PIOB_PDSR_P21 0x200000
#define PIOB_PDSR_P21_BIT 21
#define PIOB_PDSR_P22_MASK 0x400000
#define PIOB_PDSR_P22 0x400000
#define PIOB_PDSR_P22_BIT 22
#define PIOB_PDSR_P23_MASK 0x800000
#define PIOB_PDSR_P23 0x800000
#define PIOB_PDSR_P23_BIT 23
#define PIOB_PDSR_P24_MASK 0x1000000
#define PIOB_PDSR_P24 0x1000000
#define PIOB_PDSR_P24_BIT 24
#define PIOB_PDSR_P25_MASK 0x2000000
#define PIOB_PDSR_P25 0x2000000
#define PIOB_PDSR_P25_BIT 25
#define PIOB_PDSR_P26_MASK 0x4000000
#define PIOB_PDSR_P26 0x4000000
#define PIOB_PDSR_P26_BIT 26
#define PIOB_PDSR_P27_MASK 0x8000000
#define PIOB_PDSR_P27 0x8000000
#define PIOB_PDSR_P27_BIT 27
#define PIOB_PDSR_P28_MASK 0x10000000
#define PIOB_PDSR_P28 0x10000000
#define PIOB_PDSR_P28_BIT 28
#define PIOB_PDSR_P29_MASK 0x20000000
#define PIOB_PDSR_P29 0x20000000
#define PIOB_PDSR_P29_BIT 29
#define PIOB_PDSR_P30_MASK 0x40000000
#define PIOB_PDSR_P30 0x40000000
#define PIOB_PDSR_P30_BIT 30
#define PIOB_PDSR_P31_MASK 0x80000000
#define PIOB_PDSR_P31 0x80000000
#define PIOB_PDSR_P31_BIT 31

#define PIOB_IER (*(volatile unsigned long *)0xFFFFF640)
#define PIOB_IER_OFFSET 0x40
#define PIOB_IER_P0_MASK 0x1
#define PIOB_IER_P0 0x1
#define PIOB_IER_P0_BIT 0
#define PIOB_IER_P1_MASK 0x2
#define PIOB_IER_P1 0x2
#define PIOB_IER_P1_BIT 1
#define PIOB_IER_P2_MASK 0x4
#define PIOB_IER_P2 0x4
#define PIOB_IER_P2_BIT 2
#define PIOB_IER_P3_MASK 0x8
#define PIOB_IER_P3 0x8
#define PIOB_IER_P3_BIT 3
#define PIOB_IER_P4_MASK 0x10
#define PIOB_IER_P4 0x10
#define PIOB_IER_P4_BIT 4
#define PIOB_IER_P5_MASK 0x20
#define PIOB_IER_P5 0x20
#define PIOB_IER_P5_BIT 5
#define PIOB_IER_P6_MASK 0x40
#define PIOB_IER_P6 0x40
#define PIOB_IER_P6_BIT 6
#define PIOB_IER_P7_MASK 0x80
#define PIOB_IER_P7 0x80
#define PIOB_IER_P7_BIT 7
#define PIOB_IER_P8_MASK 0x100
#define PIOB_IER_P8 0x100
#define PIOB_IER_P8_BIT 8
#define PIOB_IER_P9_MASK 0x200
#define PIOB_IER_P9 0x200
#define PIOB_IER_P9_BIT 9
#define PIOB_IER_P10_MASK 0x400
#define PIOB_IER_P10 0x400
#define PIOB_IER_P10_BIT 10
#define PIOB_IER_P11_MASK 0x800
#define PIOB_IER_P11 0x800
#define PIOB_IER_P11_BIT 11
#define PIOB_IER_P12_MASK 0x1000
#define PIOB_IER_P12 0x1000
#define PIOB_IER_P12_BIT 12
#define PIOB_IER_P13_MASK 0x2000
#define PIOB_IER_P13 0x2000
#define PIOB_IER_P13_BIT 13
#define PIOB_IER_P14_MASK 0x4000
#define PIOB_IER_P14 0x4000
#define PIOB_IER_P14_BIT 14
#define PIOB_IER_P15_MASK 0x8000
#define PIOB_IER_P15 0x8000
#define PIOB_IER_P15_BIT 15
#define PIOB_IER_P16_MASK 0x10000
#define PIOB_IER_P16 0x10000
#define PIOB_IER_P16_BIT 16
#define PIOB_IER_P17_MASK 0x20000
#define PIOB_IER_P17 0x20000
#define PIOB_IER_P17_BIT 17
#define PIOB_IER_P18_MASK 0x40000
#define PIOB_IER_P18 0x40000
#define PIOB_IER_P18_BIT 18
#define PIOB_IER_P19_MASK 0x80000
#define PIOB_IER_P19 0x80000
#define PIOB_IER_P19_BIT 19
#define PIOB_IER_P20_MASK 0x100000
#define PIOB_IER_P20 0x100000
#define PIOB_IER_P20_BIT 20
#define PIOB_IER_P21_MASK 0x200000
#define PIOB_IER_P21 0x200000
#define PIOB_IER_P21_BIT 21
#define PIOB_IER_P22_MASK 0x400000
#define PIOB_IER_P22 0x400000
#define PIOB_IER_P22_BIT 22
#define PIOB_IER_P23_MASK 0x800000
#define PIOB_IER_P23 0x800000
#define PIOB_IER_P23_BIT 23
#define PIOB_IER_P24_MASK 0x1000000
#define PIOB_IER_P24 0x1000000
#define PIOB_IER_P24_BIT 24
#define PIOB_IER_P25_MASK 0x2000000
#define PIOB_IER_P25 0x2000000
#define PIOB_IER_P25_BIT 25
#define PIOB_IER_P26_MASK 0x4000000
#define PIOB_IER_P26 0x4000000
#define PIOB_IER_P26_BIT 26
#define PIOB_IER_P27_MASK 0x8000000
#define PIOB_IER_P27 0x8000000
#define PIOB_IER_P27_BIT 27
#define PIOB_IER_P28_MASK 0x10000000
#define PIOB_IER_P28 0x10000000
#define PIOB_IER_P28_BIT 28
#define PIOB_IER_P29_MASK 0x20000000
#define PIOB_IER_P29 0x20000000
#define PIOB_IER_P29_BIT 29
#define PIOB_IER_P30_MASK 0x40000000
#define PIOB_IER_P30 0x40000000
#define PIOB_IER_P30_BIT 30
#define PIOB_IER_P31_MASK 0x80000000
#define PIOB_IER_P31 0x80000000
#define PIOB_IER_P31_BIT 31

#define PIOB_IDR (*(volatile unsigned long *)0xFFFFF644)
#define PIOB_IDR_OFFSET 0x44
#define PIOB_IDR_P0_MASK 0x1
#define PIOB_IDR_P0 0x1
#define PIOB_IDR_P0_BIT 0
#define PIOB_IDR_P1_MASK 0x2
#define PIOB_IDR_P1 0x2
#define PIOB_IDR_P1_BIT 1
#define PIOB_IDR_P2_MASK 0x4
#define PIOB_IDR_P2 0x4
#define PIOB_IDR_P2_BIT 2
#define PIOB_IDR_P3_MASK 0x8
#define PIOB_IDR_P3 0x8
#define PIOB_IDR_P3_BIT 3
#define PIOB_IDR_P4_MASK 0x10
#define PIOB_IDR_P4 0x10
#define PIOB_IDR_P4_BIT 4
#define PIOB_IDR_P5_MASK 0x20
#define PIOB_IDR_P5 0x20
#define PIOB_IDR_P5_BIT 5
#define PIOB_IDR_P6_MASK 0x40
#define PIOB_IDR_P6 0x40
#define PIOB_IDR_P6_BIT 6
#define PIOB_IDR_P7_MASK 0x80
#define PIOB_IDR_P7 0x80
#define PIOB_IDR_P7_BIT 7
#define PIOB_IDR_P8_MASK 0x100
#define PIOB_IDR_P8 0x100
#define PIOB_IDR_P8_BIT 8
#define PIOB_IDR_P9_MASK 0x200
#define PIOB_IDR_P9 0x200
#define PIOB_IDR_P9_BIT 9
#define PIOB_IDR_P10_MASK 0x400
#define PIOB_IDR_P10 0x400
#define PIOB_IDR_P10_BIT 10
#define PIOB_IDR_P11_MASK 0x800
#define PIOB_IDR_P11 0x800
#define PIOB_IDR_P11_BIT 11
#define PIOB_IDR_P12_MASK 0x1000
#define PIOB_IDR_P12 0x1000
#define PIOB_IDR_P12_BIT 12
#define PIOB_IDR_P13_MASK 0x2000
#define PIOB_IDR_P13 0x2000
#define PIOB_IDR_P13_BIT 13
#define PIOB_IDR_P14_MASK 0x4000
#define PIOB_IDR_P14 0x4000
#define PIOB_IDR_P14_BIT 14
#define PIOB_IDR_P15_MASK 0x8000
#define PIOB_IDR_P15 0x8000
#define PIOB_IDR_P15_BIT 15
#define PIOB_IDR_P16_MASK 0x10000
#define PIOB_IDR_P16 0x10000
#define PIOB_IDR_P16_BIT 16
#define PIOB_IDR_P17_MASK 0x20000
#define PIOB_IDR_P17 0x20000
#define PIOB_IDR_P17_BIT 17
#define PIOB_IDR_P18_MASK 0x40000
#define PIOB_IDR_P18 0x40000
#define PIOB_IDR_P18_BIT 18
#define PIOB_IDR_P19_MASK 0x80000
#define PIOB_IDR_P19 0x80000
#define PIOB_IDR_P19_BIT 19
#define PIOB_IDR_P20_MASK 0x100000
#define PIOB_IDR_P20 0x100000
#define PIOB_IDR_P20_BIT 20
#define PIOB_IDR_P21_MASK 0x200000
#define PIOB_IDR_P21 0x200000
#define PIOB_IDR_P21_BIT 21
#define PIOB_IDR_P22_MASK 0x400000
#define PIOB_IDR_P22 0x400000
#define PIOB_IDR_P22_BIT 22
#define PIOB_IDR_P23_MASK 0x800000
#define PIOB_IDR_P23 0x800000
#define PIOB_IDR_P23_BIT 23
#define PIOB_IDR_P24_MASK 0x1000000
#define PIOB_IDR_P24 0x1000000
#define PIOB_IDR_P24_BIT 24
#define PIOB_IDR_P25_MASK 0x2000000
#define PIOB_IDR_P25 0x2000000
#define PIOB_IDR_P25_BIT 25
#define PIOB_IDR_P26_MASK 0x4000000
#define PIOB_IDR_P26 0x4000000
#define PIOB_IDR_P26_BIT 26
#define PIOB_IDR_P27_MASK 0x8000000
#define PIOB_IDR_P27 0x8000000
#define PIOB_IDR_P27_BIT 27
#define PIOB_IDR_P28_MASK 0x10000000
#define PIOB_IDR_P28 0x10000000
#define PIOB_IDR_P28_BIT 28
#define PIOB_IDR_P29_MASK 0x20000000
#define PIOB_IDR_P29 0x20000000
#define PIOB_IDR_P29_BIT 29
#define PIOB_IDR_P30_MASK 0x40000000
#define PIOB_IDR_P30 0x40000000
#define PIOB_IDR_P30_BIT 30
#define PIOB_IDR_P31_MASK 0x80000000
#define PIOB_IDR_P31 0x80000000
#define PIOB_IDR_P31_BIT 31

#define PIOB_IMR (*(volatile unsigned long *)0xFFFFF648)
#define PIOB_IMR_OFFSET 0x48
#define PIOB_IMR_P0_MASK 0x1
#define PIOB_IMR_P0 0x1
#define PIOB_IMR_P0_BIT 0
#define PIOB_IMR_P1_MASK 0x2
#define PIOB_IMR_P1 0x2
#define PIOB_IMR_P1_BIT 1
#define PIOB_IMR_P2_MASK 0x4
#define PIOB_IMR_P2 0x4
#define PIOB_IMR_P2_BIT 2
#define PIOB_IMR_P3_MASK 0x8
#define PIOB_IMR_P3 0x8
#define PIOB_IMR_P3_BIT 3
#define PIOB_IMR_P4_MASK 0x10
#define PIOB_IMR_P4 0x10
#define PIOB_IMR_P4_BIT 4
#define PIOB_IMR_P5_MASK 0x20
#define PIOB_IMR_P5 0x20
#define PIOB_IMR_P5_BIT 5
#define PIOB_IMR_P6_MASK 0x40
#define PIOB_IMR_P6 0x40
#define PIOB_IMR_P6_BIT 6
#define PIOB_IMR_P7_MASK 0x80
#define PIOB_IMR_P7 0x80
#define PIOB_IMR_P7_BIT 7
#define PIOB_IMR_P8_MASK 0x100
#define PIOB_IMR_P8 0x100
#define PIOB_IMR_P8_BIT 8
#define PIOB_IMR_P9_MASK 0x200
#define PIOB_IMR_P9 0x200
#define PIOB_IMR_P9_BIT 9
#define PIOB_IMR_P10_MASK 0x400
#define PIOB_IMR_P10 0x400
#define PIOB_IMR_P10_BIT 10
#define PIOB_IMR_P11_MASK 0x800
#define PIOB_IMR_P11 0x800
#define PIOB_IMR_P11_BIT 11
#define PIOB_IMR_P12_MASK 0x1000
#define PIOB_IMR_P12 0x1000
#define PIOB_IMR_P12_BIT 12
#define PIOB_IMR_P13_MASK 0x2000
#define PIOB_IMR_P13 0x2000
#define PIOB_IMR_P13_BIT 13
#define PIOB_IMR_P14_MASK 0x4000
#define PIOB_IMR_P14 0x4000
#define PIOB_IMR_P14_BIT 14
#define PIOB_IMR_P15_MASK 0x8000
#define PIOB_IMR_P15 0x8000
#define PIOB_IMR_P15_BIT 15
#define PIOB_IMR_P16_MASK 0x10000
#define PIOB_IMR_P16 0x10000
#define PIOB_IMR_P16_BIT 16
#define PIOB_IMR_P17_MASK 0x20000
#define PIOB_IMR_P17 0x20000
#define PIOB_IMR_P17_BIT 17
#define PIOB_IMR_P18_MASK 0x40000
#define PIOB_IMR_P18 0x40000
#define PIOB_IMR_P18_BIT 18
#define PIOB_IMR_P19_MASK 0x80000
#define PIOB_IMR_P19 0x80000
#define PIOB_IMR_P19_BIT 19
#define PIOB_IMR_P20_MASK 0x100000
#define PIOB_IMR_P20 0x100000
#define PIOB_IMR_P20_BIT 20
#define PIOB_IMR_P21_MASK 0x200000
#define PIOB_IMR_P21 0x200000
#define PIOB_IMR_P21_BIT 21
#define PIOB_IMR_P22_MASK 0x400000
#define PIOB_IMR_P22 0x400000
#define PIOB_IMR_P22_BIT 22
#define PIOB_IMR_P23_MASK 0x800000
#define PIOB_IMR_P23 0x800000
#define PIOB_IMR_P23_BIT 23
#define PIOB_IMR_P24_MASK 0x1000000
#define PIOB_IMR_P24 0x1000000
#define PIOB_IMR_P24_BIT 24
#define PIOB_IMR_P25_MASK 0x2000000
#define PIOB_IMR_P25 0x2000000
#define PIOB_IMR_P25_BIT 25
#define PIOB_IMR_P26_MASK 0x4000000
#define PIOB_IMR_P26 0x4000000
#define PIOB_IMR_P26_BIT 26
#define PIOB_IMR_P27_MASK 0x8000000
#define PIOB_IMR_P27 0x8000000
#define PIOB_IMR_P27_BIT 27
#define PIOB_IMR_P28_MASK 0x10000000
#define PIOB_IMR_P28 0x10000000
#define PIOB_IMR_P28_BIT 28
#define PIOB_IMR_P29_MASK 0x20000000
#define PIOB_IMR_P29 0x20000000
#define PIOB_IMR_P29_BIT 29
#define PIOB_IMR_P30_MASK 0x40000000
#define PIOB_IMR_P30 0x40000000
#define PIOB_IMR_P30_BIT 30
#define PIOB_IMR_P31_MASK 0x80000000
#define PIOB_IMR_P31 0x80000000
#define PIOB_IMR_P31_BIT 31

#define PIOB_ISR (*(volatile unsigned long *)0xFFFFF64C)
#define PIOB_ISR_OFFSET 0x4C
#define PIOB_ISR_P0_MASK 0x1
#define PIOB_ISR_P0 0x1
#define PIOB_ISR_P0_BIT 0
#define PIOB_ISR_P1_MASK 0x2
#define PIOB_ISR_P1 0x2
#define PIOB_ISR_P1_BIT 1
#define PIOB_ISR_P2_MASK 0x4
#define PIOB_ISR_P2 0x4
#define PIOB_ISR_P2_BIT 2
#define PIOB_ISR_P3_MASK 0x8
#define PIOB_ISR_P3 0x8
#define PIOB_ISR_P3_BIT 3
#define PIOB_ISR_P4_MASK 0x10
#define PIOB_ISR_P4 0x10
#define PIOB_ISR_P4_BIT 4
#define PIOB_ISR_P5_MASK 0x20
#define PIOB_ISR_P5 0x20
#define PIOB_ISR_P5_BIT 5
#define PIOB_ISR_P6_MASK 0x40
#define PIOB_ISR_P6 0x40
#define PIOB_ISR_P6_BIT 6
#define PIOB_ISR_P7_MASK 0x80
#define PIOB_ISR_P7 0x80
#define PIOB_ISR_P7_BIT 7
#define PIOB_ISR_P8_MASK 0x100
#define PIOB_ISR_P8 0x100
#define PIOB_ISR_P8_BIT 8
#define PIOB_ISR_P9_MASK 0x200
#define PIOB_ISR_P9 0x200
#define PIOB_ISR_P9_BIT 9
#define PIOB_ISR_P10_MASK 0x400
#define PIOB_ISR_P10 0x400
#define PIOB_ISR_P10_BIT 10
#define PIOB_ISR_P11_MASK 0x800
#define PIOB_ISR_P11 0x800
#define PIOB_ISR_P11_BIT 11
#define PIOB_ISR_P12_MASK 0x1000
#define PIOB_ISR_P12 0x1000
#define PIOB_ISR_P12_BIT 12
#define PIOB_ISR_P13_MASK 0x2000
#define PIOB_ISR_P13 0x2000
#define PIOB_ISR_P13_BIT 13
#define PIOB_ISR_P14_MASK 0x4000
#define PIOB_ISR_P14 0x4000
#define PIOB_ISR_P14_BIT 14
#define PIOB_ISR_P15_MASK 0x8000
#define PIOB_ISR_P15 0x8000
#define PIOB_ISR_P15_BIT 15
#define PIOB_ISR_P16_MASK 0x10000
#define PIOB_ISR_P16 0x10000
#define PIOB_ISR_P16_BIT 16
#define PIOB_ISR_P17_MASK 0x20000
#define PIOB_ISR_P17 0x20000
#define PIOB_ISR_P17_BIT 17
#define PIOB_ISR_P18_MASK 0x40000
#define PIOB_ISR_P18 0x40000
#define PIOB_ISR_P18_BIT 18
#define PIOB_ISR_P19_MASK 0x80000
#define PIOB_ISR_P19 0x80000
#define PIOB_ISR_P19_BIT 19
#define PIOB_ISR_P20_MASK 0x100000
#define PIOB_ISR_P20 0x100000
#define PIOB_ISR_P20_BIT 20
#define PIOB_ISR_P21_MASK 0x200000
#define PIOB_ISR_P21 0x200000
#define PIOB_ISR_P21_BIT 21
#define PIOB_ISR_P22_MASK 0x400000
#define PIOB_ISR_P22 0x400000
#define PIOB_ISR_P22_BIT 22
#define PIOB_ISR_P23_MASK 0x800000
#define PIOB_ISR_P23 0x800000
#define PIOB_ISR_P23_BIT 23
#define PIOB_ISR_P24_MASK 0x1000000
#define PIOB_ISR_P24 0x1000000
#define PIOB_ISR_P24_BIT 24
#define PIOB_ISR_P25_MASK 0x2000000
#define PIOB_ISR_P25 0x2000000
#define PIOB_ISR_P25_BIT 25
#define PIOB_ISR_P26_MASK 0x4000000
#define PIOB_ISR_P26 0x4000000
#define PIOB_ISR_P26_BIT 26
#define PIOB_ISR_P27_MASK 0x8000000
#define PIOB_ISR_P27 0x8000000
#define PIOB_ISR_P27_BIT 27
#define PIOB_ISR_P28_MASK 0x10000000
#define PIOB_ISR_P28 0x10000000
#define PIOB_ISR_P28_BIT 28
#define PIOB_ISR_P29_MASK 0x20000000
#define PIOB_ISR_P29 0x20000000
#define PIOB_ISR_P29_BIT 29
#define PIOB_ISR_P30_MASK 0x40000000
#define PIOB_ISR_P30 0x40000000
#define PIOB_ISR_P30_BIT 30
#define PIOB_ISR_P31_MASK 0x80000000
#define PIOB_ISR_P31 0x80000000
#define PIOB_ISR_P31_BIT 31

#define PIOB_MDER (*(volatile unsigned long *)0xFFFFF650)
#define PIOB_MDER_OFFSET 0x50
#define PIOB_MDER_P0_MASK 0x1
#define PIOB_MDER_P0 0x1
#define PIOB_MDER_P0_BIT 0
#define PIOB_MDER_P1_MASK 0x2
#define PIOB_MDER_P1 0x2
#define PIOB_MDER_P1_BIT 1
#define PIOB_MDER_P2_MASK 0x4
#define PIOB_MDER_P2 0x4
#define PIOB_MDER_P2_BIT 2
#define PIOB_MDER_P3_MASK 0x8
#define PIOB_MDER_P3 0x8
#define PIOB_MDER_P3_BIT 3
#define PIOB_MDER_P4_MASK 0x10
#define PIOB_MDER_P4 0x10
#define PIOB_MDER_P4_BIT 4
#define PIOB_MDER_P5_MASK 0x20
#define PIOB_MDER_P5 0x20
#define PIOB_MDER_P5_BIT 5
#define PIOB_MDER_P6_MASK 0x40
#define PIOB_MDER_P6 0x40
#define PIOB_MDER_P6_BIT 6
#define PIOB_MDER_P7_MASK 0x80
#define PIOB_MDER_P7 0x80
#define PIOB_MDER_P7_BIT 7
#define PIOB_MDER_P8_MASK 0x100
#define PIOB_MDER_P8 0x100
#define PIOB_MDER_P8_BIT 8
#define PIOB_MDER_P9_MASK 0x200
#define PIOB_MDER_P9 0x200
#define PIOB_MDER_P9_BIT 9
#define PIOB_MDER_P10_MASK 0x400
#define PIOB_MDER_P10 0x400
#define PIOB_MDER_P10_BIT 10
#define PIOB_MDER_P11_MASK 0x800
#define PIOB_MDER_P11 0x800
#define PIOB_MDER_P11_BIT 11
#define PIOB_MDER_P12_MASK 0x1000
#define PIOB_MDER_P12 0x1000
#define PIOB_MDER_P12_BIT 12
#define PIOB_MDER_P13_MASK 0x2000
#define PIOB_MDER_P13 0x2000
#define PIOB_MDER_P13_BIT 13
#define PIOB_MDER_P14_MASK 0x4000
#define PIOB_MDER_P14 0x4000
#define PIOB_MDER_P14_BIT 14
#define PIOB_MDER_P15_MASK 0x8000
#define PIOB_MDER_P15 0x8000
#define PIOB_MDER_P15_BIT 15
#define PIOB_MDER_P16_MASK 0x10000
#define PIOB_MDER_P16 0x10000
#define PIOB_MDER_P16_BIT 16
#define PIOB_MDER_P17_MASK 0x20000
#define PIOB_MDER_P17 0x20000
#define PIOB_MDER_P17_BIT 17
#define PIOB_MDER_P18_MASK 0x40000
#define PIOB_MDER_P18 0x40000
#define PIOB_MDER_P18_BIT 18
#define PIOB_MDER_P19_MASK 0x80000
#define PIOB_MDER_P19 0x80000
#define PIOB_MDER_P19_BIT 19
#define PIOB_MDER_P20_MASK 0x100000
#define PIOB_MDER_P20 0x100000
#define PIOB_MDER_P20_BIT 20
#define PIOB_MDER_P21_MASK 0x200000
#define PIOB_MDER_P21 0x200000
#define PIOB_MDER_P21_BIT 21
#define PIOB_MDER_P22_MASK 0x400000
#define PIOB_MDER_P22 0x400000
#define PIOB_MDER_P22_BIT 22
#define PIOB_MDER_P23_MASK 0x800000
#define PIOB_MDER_P23 0x800000
#define PIOB_MDER_P23_BIT 23
#define PIOB_MDER_P24_MASK 0x1000000
#define PIOB_MDER_P24 0x1000000
#define PIOB_MDER_P24_BIT 24
#define PIOB_MDER_P25_MASK 0x2000000
#define PIOB_MDER_P25 0x2000000
#define PIOB_MDER_P25_BIT 25
#define PIOB_MDER_P26_MASK 0x4000000
#define PIOB_MDER_P26 0x4000000
#define PIOB_MDER_P26_BIT 26
#define PIOB_MDER_P27_MASK 0x8000000
#define PIOB_MDER_P27 0x8000000
#define PIOB_MDER_P27_BIT 27
#define PIOB_MDER_P28_MASK 0x10000000
#define PIOB_MDER_P28 0x10000000
#define PIOB_MDER_P28_BIT 28
#define PIOB_MDER_P29_MASK 0x20000000
#define PIOB_MDER_P29 0x20000000
#define PIOB_MDER_P29_BIT 29
#define PIOB_MDER_P30_MASK 0x40000000
#define PIOB_MDER_P30 0x40000000
#define PIOB_MDER_P30_BIT 30
#define PIOB_MDER_P31_MASK 0x80000000
#define PIOB_MDER_P31 0x80000000
#define PIOB_MDER_P31_BIT 31

#define PIOB_MDDR (*(volatile unsigned long *)0xFFFFF654)
#define PIOB_MDDR_OFFSET 0x54
#define PIOB_MDDR_P0_MASK 0x1
#define PIOB_MDDR_P0 0x1
#define PIOB_MDDR_P0_BIT 0
#define PIOB_MDDR_P1_MASK 0x2
#define PIOB_MDDR_P1 0x2
#define PIOB_MDDR_P1_BIT 1
#define PIOB_MDDR_P2_MASK 0x4
#define PIOB_MDDR_P2 0x4
#define PIOB_MDDR_P2_BIT 2
#define PIOB_MDDR_P3_MASK 0x8
#define PIOB_MDDR_P3 0x8
#define PIOB_MDDR_P3_BIT 3
#define PIOB_MDDR_P4_MASK 0x10
#define PIOB_MDDR_P4 0x10
#define PIOB_MDDR_P4_BIT 4
#define PIOB_MDDR_P5_MASK 0x20
#define PIOB_MDDR_P5 0x20
#define PIOB_MDDR_P5_BIT 5
#define PIOB_MDDR_P6_MASK 0x40
#define PIOB_MDDR_P6 0x40
#define PIOB_MDDR_P6_BIT 6
#define PIOB_MDDR_P7_MASK 0x80
#define PIOB_MDDR_P7 0x80
#define PIOB_MDDR_P7_BIT 7
#define PIOB_MDDR_P8_MASK 0x100
#define PIOB_MDDR_P8 0x100
#define PIOB_MDDR_P8_BIT 8
#define PIOB_MDDR_P9_MASK 0x200
#define PIOB_MDDR_P9 0x200
#define PIOB_MDDR_P9_BIT 9
#define PIOB_MDDR_P10_MASK 0x400
#define PIOB_MDDR_P10 0x400
#define PIOB_MDDR_P10_BIT 10
#define PIOB_MDDR_P11_MASK 0x800
#define PIOB_MDDR_P11 0x800
#define PIOB_MDDR_P11_BIT 11
#define PIOB_MDDR_P12_MASK 0x1000
#define PIOB_MDDR_P12 0x1000
#define PIOB_MDDR_P12_BIT 12
#define PIOB_MDDR_P13_MASK 0x2000
#define PIOB_MDDR_P13 0x2000
#define PIOB_MDDR_P13_BIT 13
#define PIOB_MDDR_P14_MASK 0x4000
#define PIOB_MDDR_P14 0x4000
#define PIOB_MDDR_P14_BIT 14
#define PIOB_MDDR_P15_MASK 0x8000
#define PIOB_MDDR_P15 0x8000
#define PIOB_MDDR_P15_BIT 15
#define PIOB_MDDR_P16_MASK 0x10000
#define PIOB_MDDR_P16 0x10000
#define PIOB_MDDR_P16_BIT 16
#define PIOB_MDDR_P17_MASK 0x20000
#define PIOB_MDDR_P17 0x20000
#define PIOB_MDDR_P17_BIT 17
#define PIOB_MDDR_P18_MASK 0x40000
#define PIOB_MDDR_P18 0x40000
#define PIOB_MDDR_P18_BIT 18
#define PIOB_MDDR_P19_MASK 0x80000
#define PIOB_MDDR_P19 0x80000
#define PIOB_MDDR_P19_BIT 19
#define PIOB_MDDR_P20_MASK 0x100000
#define PIOB_MDDR_P20 0x100000
#define PIOB_MDDR_P20_BIT 20
#define PIOB_MDDR_P21_MASK 0x200000
#define PIOB_MDDR_P21 0x200000
#define PIOB_MDDR_P21_BIT 21
#define PIOB_MDDR_P22_MASK 0x400000
#define PIOB_MDDR_P22 0x400000
#define PIOB_MDDR_P22_BIT 22
#define PIOB_MDDR_P23_MASK 0x800000
#define PIOB_MDDR_P23 0x800000
#define PIOB_MDDR_P23_BIT 23
#define PIOB_MDDR_P24_MASK 0x1000000
#define PIOB_MDDR_P24 0x1000000
#define PIOB_MDDR_P24_BIT 24
#define PIOB_MDDR_P25_MASK 0x2000000
#define PIOB_MDDR_P25 0x2000000
#define PIOB_MDDR_P25_BIT 25
#define PIOB_MDDR_P26_MASK 0x4000000
#define PIOB_MDDR_P26 0x4000000
#define PIOB_MDDR_P26_BIT 26
#define PIOB_MDDR_P27_MASK 0x8000000
#define PIOB_MDDR_P27 0x8000000
#define PIOB_MDDR_P27_BIT 27
#define PIOB_MDDR_P28_MASK 0x10000000
#define PIOB_MDDR_P28 0x10000000
#define PIOB_MDDR_P28_BIT 28
#define PIOB_MDDR_P29_MASK 0x20000000
#define PIOB_MDDR_P29 0x20000000
#define PIOB_MDDR_P29_BIT 29
#define PIOB_MDDR_P30_MASK 0x40000000
#define PIOB_MDDR_P30 0x40000000
#define PIOB_MDDR_P30_BIT 30
#define PIOB_MDDR_P31_MASK 0x80000000
#define PIOB_MDDR_P31 0x80000000
#define PIOB_MDDR_P31_BIT 31

#define PIOB_MDSR (*(volatile unsigned long *)0xFFFFF658)
#define PIOB_MDSR_OFFSET 0x58
#define PIOB_MDSR_P0_MASK 0x1
#define PIOB_MDSR_P0 0x1
#define PIOB_MDSR_P0_BIT 0
#define PIOB_MDSR_P1_MASK 0x2
#define PIOB_MDSR_P1 0x2
#define PIOB_MDSR_P1_BIT 1
#define PIOB_MDSR_P2_MASK 0x4
#define PIOB_MDSR_P2 0x4
#define PIOB_MDSR_P2_BIT 2
#define PIOB_MDSR_P3_MASK 0x8
#define PIOB_MDSR_P3 0x8
#define PIOB_MDSR_P3_BIT 3
#define PIOB_MDSR_P4_MASK 0x10
#define PIOB_MDSR_P4 0x10
#define PIOB_MDSR_P4_BIT 4
#define PIOB_MDSR_P5_MASK 0x20
#define PIOB_MDSR_P5 0x20
#define PIOB_MDSR_P5_BIT 5
#define PIOB_MDSR_P6_MASK 0x40
#define PIOB_MDSR_P6 0x40
#define PIOB_MDSR_P6_BIT 6
#define PIOB_MDSR_P7_MASK 0x80
#define PIOB_MDSR_P7 0x80
#define PIOB_MDSR_P7_BIT 7
#define PIOB_MDSR_P8_MASK 0x100
#define PIOB_MDSR_P8 0x100
#define PIOB_MDSR_P8_BIT 8
#define PIOB_MDSR_P9_MASK 0x200
#define PIOB_MDSR_P9 0x200
#define PIOB_MDSR_P9_BIT 9
#define PIOB_MDSR_P10_MASK 0x400
#define PIOB_MDSR_P10 0x400
#define PIOB_MDSR_P10_BIT 10
#define PIOB_MDSR_P11_MASK 0x800
#define PIOB_MDSR_P11 0x800
#define PIOB_MDSR_P11_BIT 11
#define PIOB_MDSR_P12_MASK 0x1000
#define PIOB_MDSR_P12 0x1000
#define PIOB_MDSR_P12_BIT 12
#define PIOB_MDSR_P13_MASK 0x2000
#define PIOB_MDSR_P13 0x2000
#define PIOB_MDSR_P13_BIT 13
#define PIOB_MDSR_P14_MASK 0x4000
#define PIOB_MDSR_P14 0x4000
#define PIOB_MDSR_P14_BIT 14
#define PIOB_MDSR_P15_MASK 0x8000
#define PIOB_MDSR_P15 0x8000
#define PIOB_MDSR_P15_BIT 15
#define PIOB_MDSR_P16_MASK 0x10000
#define PIOB_MDSR_P16 0x10000
#define PIOB_MDSR_P16_BIT 16
#define PIOB_MDSR_P17_MASK 0x20000
#define PIOB_MDSR_P17 0x20000
#define PIOB_MDSR_P17_BIT 17
#define PIOB_MDSR_P18_MASK 0x40000
#define PIOB_MDSR_P18 0x40000
#define PIOB_MDSR_P18_BIT 18
#define PIOB_MDSR_P19_MASK 0x80000
#define PIOB_MDSR_P19 0x80000
#define PIOB_MDSR_P19_BIT 19
#define PIOB_MDSR_P20_MASK 0x100000
#define PIOB_MDSR_P20 0x100000
#define PIOB_MDSR_P20_BIT 20
#define PIOB_MDSR_P21_MASK 0x200000
#define PIOB_MDSR_P21 0x200000
#define PIOB_MDSR_P21_BIT 21
#define PIOB_MDSR_P22_MASK 0x400000
#define PIOB_MDSR_P22 0x400000
#define PIOB_MDSR_P22_BIT 22
#define PIOB_MDSR_P23_MASK 0x800000
#define PIOB_MDSR_P23 0x800000
#define PIOB_MDSR_P23_BIT 23
#define PIOB_MDSR_P24_MASK 0x1000000
#define PIOB_MDSR_P24 0x1000000
#define PIOB_MDSR_P24_BIT 24
#define PIOB_MDSR_P25_MASK 0x2000000
#define PIOB_MDSR_P25 0x2000000
#define PIOB_MDSR_P25_BIT 25
#define PIOB_MDSR_P26_MASK 0x4000000
#define PIOB_MDSR_P26 0x4000000
#define PIOB_MDSR_P26_BIT 26
#define PIOB_MDSR_P27_MASK 0x8000000
#define PIOB_MDSR_P27 0x8000000
#define PIOB_MDSR_P27_BIT 27
#define PIOB_MDSR_P28_MASK 0x10000000
#define PIOB_MDSR_P28 0x10000000
#define PIOB_MDSR_P28_BIT 28
#define PIOB_MDSR_P29_MASK 0x20000000
#define PIOB_MDSR_P29 0x20000000
#define PIOB_MDSR_P29_BIT 29
#define PIOB_MDSR_P30_MASK 0x40000000
#define PIOB_MDSR_P30 0x40000000
#define PIOB_MDSR_P30_BIT 30
#define PIOB_MDSR_P31_MASK 0x80000000
#define PIOB_MDSR_P31 0x80000000
#define PIOB_MDSR_P31_BIT 31

#define PIOB_PUDR (*(volatile unsigned long *)0xFFFFF660)
#define PIOB_PUDR_OFFSET 0x60
#define PIOB_PUDR_P0_MASK 0x1
#define PIOB_PUDR_P0 0x1
#define PIOB_PUDR_P0_BIT 0
#define PIOB_PUDR_P1_MASK 0x2
#define PIOB_PUDR_P1 0x2
#define PIOB_PUDR_P1_BIT 1
#define PIOB_PUDR_P2_MASK 0x4
#define PIOB_PUDR_P2 0x4
#define PIOB_PUDR_P2_BIT 2
#define PIOB_PUDR_P3_MASK 0x8
#define PIOB_PUDR_P3 0x8
#define PIOB_PUDR_P3_BIT 3
#define PIOB_PUDR_P4_MASK 0x10
#define PIOB_PUDR_P4 0x10
#define PIOB_PUDR_P4_BIT 4
#define PIOB_PUDR_P5_MASK 0x20
#define PIOB_PUDR_P5 0x20
#define PIOB_PUDR_P5_BIT 5
#define PIOB_PUDR_P6_MASK 0x40
#define PIOB_PUDR_P6 0x40
#define PIOB_PUDR_P6_BIT 6
#define PIOB_PUDR_P7_MASK 0x80
#define PIOB_PUDR_P7 0x80
#define PIOB_PUDR_P7_BIT 7
#define PIOB_PUDR_P8_MASK 0x100
#define PIOB_PUDR_P8 0x100
#define PIOB_PUDR_P8_BIT 8
#define PIOB_PUDR_P9_MASK 0x200
#define PIOB_PUDR_P9 0x200
#define PIOB_PUDR_P9_BIT 9
#define PIOB_PUDR_P10_MASK 0x400
#define PIOB_PUDR_P10 0x400
#define PIOB_PUDR_P10_BIT 10
#define PIOB_PUDR_P11_MASK 0x800
#define PIOB_PUDR_P11 0x800
#define PIOB_PUDR_P11_BIT 11
#define PIOB_PUDR_P12_MASK 0x1000
#define PIOB_PUDR_P12 0x1000
#define PIOB_PUDR_P12_BIT 12
#define PIOB_PUDR_P13_MASK 0x2000
#define PIOB_PUDR_P13 0x2000
#define PIOB_PUDR_P13_BIT 13
#define PIOB_PUDR_P14_MASK 0x4000
#define PIOB_PUDR_P14 0x4000
#define PIOB_PUDR_P14_BIT 14
#define PIOB_PUDR_P15_MASK 0x8000
#define PIOB_PUDR_P15 0x8000
#define PIOB_PUDR_P15_BIT 15
#define PIOB_PUDR_P16_MASK 0x10000
#define PIOB_PUDR_P16 0x10000
#define PIOB_PUDR_P16_BIT 16
#define PIOB_PUDR_P17_MASK 0x20000
#define PIOB_PUDR_P17 0x20000
#define PIOB_PUDR_P17_BIT 17
#define PIOB_PUDR_P18_MASK 0x40000
#define PIOB_PUDR_P18 0x40000
#define PIOB_PUDR_P18_BIT 18
#define PIOB_PUDR_P19_MASK 0x80000
#define PIOB_PUDR_P19 0x80000
#define PIOB_PUDR_P19_BIT 19
#define PIOB_PUDR_P20_MASK 0x100000
#define PIOB_PUDR_P20 0x100000
#define PIOB_PUDR_P20_BIT 20
#define PIOB_PUDR_P21_MASK 0x200000
#define PIOB_PUDR_P21 0x200000
#define PIOB_PUDR_P21_BIT 21
#define PIOB_PUDR_P22_MASK 0x400000
#define PIOB_PUDR_P22 0x400000
#define PIOB_PUDR_P22_BIT 22
#define PIOB_PUDR_P23_MASK 0x800000
#define PIOB_PUDR_P23 0x800000
#define PIOB_PUDR_P23_BIT 23
#define PIOB_PUDR_P24_MASK 0x1000000
#define PIOB_PUDR_P24 0x1000000
#define PIOB_PUDR_P24_BIT 24
#define PIOB_PUDR_P25_MASK 0x2000000
#define PIOB_PUDR_P25 0x2000000
#define PIOB_PUDR_P25_BIT 25
#define PIOB_PUDR_P26_MASK 0x4000000
#define PIOB_PUDR_P26 0x4000000
#define PIOB_PUDR_P26_BIT 26
#define PIOB_PUDR_P27_MASK 0x8000000
#define PIOB_PUDR_P27 0x8000000
#define PIOB_PUDR_P27_BIT 27
#define PIOB_PUDR_P28_MASK 0x10000000
#define PIOB_PUDR_P28 0x10000000
#define PIOB_PUDR_P28_BIT 28
#define PIOB_PUDR_P29_MASK 0x20000000
#define PIOB_PUDR_P29 0x20000000
#define PIOB_PUDR_P29_BIT 29
#define PIOB_PUDR_P30_MASK 0x40000000
#define PIOB_PUDR_P30 0x40000000
#define PIOB_PUDR_P30_BIT 30
#define PIOB_PUDR_P31_MASK 0x80000000
#define PIOB_PUDR_P31 0x80000000
#define PIOB_PUDR_P31_BIT 31

#define PIOB_PUER (*(volatile unsigned long *)0xFFFFF664)
#define PIOB_PUER_OFFSET 0x64
#define PIOB_PUER_P0_MASK 0x1
#define PIOB_PUER_P0 0x1
#define PIOB_PUER_P0_BIT 0
#define PIOB_PUER_P1_MASK 0x2
#define PIOB_PUER_P1 0x2
#define PIOB_PUER_P1_BIT 1
#define PIOB_PUER_P2_MASK 0x4
#define PIOB_PUER_P2 0x4
#define PIOB_PUER_P2_BIT 2
#define PIOB_PUER_P3_MASK 0x8
#define PIOB_PUER_P3 0x8
#define PIOB_PUER_P3_BIT 3
#define PIOB_PUER_P4_MASK 0x10
#define PIOB_PUER_P4 0x10
#define PIOB_PUER_P4_BIT 4
#define PIOB_PUER_P5_MASK 0x20
#define PIOB_PUER_P5 0x20
#define PIOB_PUER_P5_BIT 5
#define PIOB_PUER_P6_MASK 0x40
#define PIOB_PUER_P6 0x40
#define PIOB_PUER_P6_BIT 6
#define PIOB_PUER_P7_MASK 0x80
#define PIOB_PUER_P7 0x80
#define PIOB_PUER_P7_BIT 7
#define PIOB_PUER_P8_MASK 0x100
#define PIOB_PUER_P8 0x100
#define PIOB_PUER_P8_BIT 8
#define PIOB_PUER_P9_MASK 0x200
#define PIOB_PUER_P9 0x200
#define PIOB_PUER_P9_BIT 9
#define PIOB_PUER_P10_MASK 0x400
#define PIOB_PUER_P10 0x400
#define PIOB_PUER_P10_BIT 10
#define PIOB_PUER_P11_MASK 0x800
#define PIOB_PUER_P11 0x800
#define PIOB_PUER_P11_BIT 11
#define PIOB_PUER_P12_MASK 0x1000
#define PIOB_PUER_P12 0x1000
#define PIOB_PUER_P12_BIT 12
#define PIOB_PUER_P13_MASK 0x2000
#define PIOB_PUER_P13 0x2000
#define PIOB_PUER_P13_BIT 13
#define PIOB_PUER_P14_MASK 0x4000
#define PIOB_PUER_P14 0x4000
#define PIOB_PUER_P14_BIT 14
#define PIOB_PUER_P15_MASK 0x8000
#define PIOB_PUER_P15 0x8000
#define PIOB_PUER_P15_BIT 15
#define PIOB_PUER_P16_MASK 0x10000
#define PIOB_PUER_P16 0x10000
#define PIOB_PUER_P16_BIT 16
#define PIOB_PUER_P17_MASK 0x20000
#define PIOB_PUER_P17 0x20000
#define PIOB_PUER_P17_BIT 17
#define PIOB_PUER_P18_MASK 0x40000
#define PIOB_PUER_P18 0x40000
#define PIOB_PUER_P18_BIT 18
#define PIOB_PUER_P19_MASK 0x80000
#define PIOB_PUER_P19 0x80000
#define PIOB_PUER_P19_BIT 19
#define PIOB_PUER_P20_MASK 0x100000
#define PIOB_PUER_P20 0x100000
#define PIOB_PUER_P20_BIT 20
#define PIOB_PUER_P21_MASK 0x200000
#define PIOB_PUER_P21 0x200000
#define PIOB_PUER_P21_BIT 21
#define PIOB_PUER_P22_MASK 0x400000
#define PIOB_PUER_P22 0x400000
#define PIOB_PUER_P22_BIT 22
#define PIOB_PUER_P23_MASK 0x800000
#define PIOB_PUER_P23 0x800000
#define PIOB_PUER_P23_BIT 23
#define PIOB_PUER_P24_MASK 0x1000000
#define PIOB_PUER_P24 0x1000000
#define PIOB_PUER_P24_BIT 24
#define PIOB_PUER_P25_MASK 0x2000000
#define PIOB_PUER_P25 0x2000000
#define PIOB_PUER_P25_BIT 25
#define PIOB_PUER_P26_MASK 0x4000000
#define PIOB_PUER_P26 0x4000000
#define PIOB_PUER_P26_BIT 26
#define PIOB_PUER_P27_MASK 0x8000000
#define PIOB_PUER_P27 0x8000000
#define PIOB_PUER_P27_BIT 27
#define PIOB_PUER_P28_MASK 0x10000000
#define PIOB_PUER_P28 0x10000000
#define PIOB_PUER_P28_BIT 28
#define PIOB_PUER_P29_MASK 0x20000000
#define PIOB_PUER_P29 0x20000000
#define PIOB_PUER_P29_BIT 29
#define PIOB_PUER_P30_MASK 0x40000000
#define PIOB_PUER_P30 0x40000000
#define PIOB_PUER_P30_BIT 30
#define PIOB_PUER_P31_MASK 0x80000000
#define PIOB_PUER_P31 0x80000000
#define PIOB_PUER_P31_BIT 31

#define PIOB_PUSR (*(volatile unsigned long *)0xFFFFF668)
#define PIOB_PUSR_OFFSET 0x68
#define PIOB_PUSR_P0_MASK 0x1
#define PIOB_PUSR_P0 0x1
#define PIOB_PUSR_P0_BIT 0
#define PIOB_PUSR_P1_MASK 0x2
#define PIOB_PUSR_P1 0x2
#define PIOB_PUSR_P1_BIT 1
#define PIOB_PUSR_P2_MASK 0x4
#define PIOB_PUSR_P2 0x4
#define PIOB_PUSR_P2_BIT 2
#define PIOB_PUSR_P3_MASK 0x8
#define PIOB_PUSR_P3 0x8
#define PIOB_PUSR_P3_BIT 3
#define PIOB_PUSR_P4_MASK 0x10
#define PIOB_PUSR_P4 0x10
#define PIOB_PUSR_P4_BIT 4
#define PIOB_PUSR_P5_MASK 0x20
#define PIOB_PUSR_P5 0x20
#define PIOB_PUSR_P5_BIT 5
#define PIOB_PUSR_P6_MASK 0x40
#define PIOB_PUSR_P6 0x40
#define PIOB_PUSR_P6_BIT 6
#define PIOB_PUSR_P7_MASK 0x80
#define PIOB_PUSR_P7 0x80
#define PIOB_PUSR_P7_BIT 7
#define PIOB_PUSR_P8_MASK 0x100
#define PIOB_PUSR_P8 0x100
#define PIOB_PUSR_P8_BIT 8
#define PIOB_PUSR_P9_MASK 0x200
#define PIOB_PUSR_P9 0x200
#define PIOB_PUSR_P9_BIT 9
#define PIOB_PUSR_P10_MASK 0x400
#define PIOB_PUSR_P10 0x400
#define PIOB_PUSR_P10_BIT 10
#define PIOB_PUSR_P11_MASK 0x800
#define PIOB_PUSR_P11 0x800
#define PIOB_PUSR_P11_BIT 11
#define PIOB_PUSR_P12_MASK 0x1000
#define PIOB_PUSR_P12 0x1000
#define PIOB_PUSR_P12_BIT 12
#define PIOB_PUSR_P13_MASK 0x2000
#define PIOB_PUSR_P13 0x2000
#define PIOB_PUSR_P13_BIT 13
#define PIOB_PUSR_P14_MASK 0x4000
#define PIOB_PUSR_P14 0x4000
#define PIOB_PUSR_P14_BIT 14
#define PIOB_PUSR_P15_MASK 0x8000
#define PIOB_PUSR_P15 0x8000
#define PIOB_PUSR_P15_BIT 15
#define PIOB_PUSR_P16_MASK 0x10000
#define PIOB_PUSR_P16 0x10000
#define PIOB_PUSR_P16_BIT 16
#define PIOB_PUSR_P17_MASK 0x20000
#define PIOB_PUSR_P17 0x20000
#define PIOB_PUSR_P17_BIT 17
#define PIOB_PUSR_P18_MASK 0x40000
#define PIOB_PUSR_P18 0x40000
#define PIOB_PUSR_P18_BIT 18
#define PIOB_PUSR_P19_MASK 0x80000
#define PIOB_PUSR_P19 0x80000
#define PIOB_PUSR_P19_BIT 19
#define PIOB_PUSR_P20_MASK 0x100000
#define PIOB_PUSR_P20 0x100000
#define PIOB_PUSR_P20_BIT 20
#define PIOB_PUSR_P21_MASK 0x200000
#define PIOB_PUSR_P21 0x200000
#define PIOB_PUSR_P21_BIT 21
#define PIOB_PUSR_P22_MASK 0x400000
#define PIOB_PUSR_P22 0x400000
#define PIOB_PUSR_P22_BIT 22
#define PIOB_PUSR_P23_MASK 0x800000
#define PIOB_PUSR_P23 0x800000
#define PIOB_PUSR_P23_BIT 23
#define PIOB_PUSR_P24_MASK 0x1000000
#define PIOB_PUSR_P24 0x1000000
#define PIOB_PUSR_P24_BIT 24
#define PIOB_PUSR_P25_MASK 0x2000000
#define PIOB_PUSR_P25 0x2000000
#define PIOB_PUSR_P25_BIT 25
#define PIOB_PUSR_P26_MASK 0x4000000
#define PIOB_PUSR_P26 0x4000000
#define PIOB_PUSR_P26_BIT 26
#define PIOB_PUSR_P27_MASK 0x8000000
#define PIOB_PUSR_P27 0x8000000
#define PIOB_PUSR_P27_BIT 27
#define PIOB_PUSR_P28_MASK 0x10000000
#define PIOB_PUSR_P28 0x10000000
#define PIOB_PUSR_P28_BIT 28
#define PIOB_PUSR_P29_MASK 0x20000000
#define PIOB_PUSR_P29 0x20000000
#define PIOB_PUSR_P29_BIT 29
#define PIOB_PUSR_P30_MASK 0x40000000
#define PIOB_PUSR_P30 0x40000000
#define PIOB_PUSR_P30_BIT 30
#define PIOB_PUSR_P31_MASK 0x80000000
#define PIOB_PUSR_P31 0x80000000
#define PIOB_PUSR_P31_BIT 31

#define PIOB_ASR (*(volatile unsigned long *)0xFFFFF670)
#define PIOB_ASR_OFFSET 0x70
#define PIOB_ASR_P0_MASK 0x1
#define PIOB_ASR_P0 0x1
#define PIOB_ASR_P0_BIT 0
#define PIOB_ASR_P1_MASK 0x2
#define PIOB_ASR_P1 0x2
#define PIOB_ASR_P1_BIT 1
#define PIOB_ASR_P2_MASK 0x4
#define PIOB_ASR_P2 0x4
#define PIOB_ASR_P2_BIT 2
#define PIOB_ASR_P3_MASK 0x8
#define PIOB_ASR_P3 0x8
#define PIOB_ASR_P3_BIT 3
#define PIOB_ASR_P4_MASK 0x10
#define PIOB_ASR_P4 0x10
#define PIOB_ASR_P4_BIT 4
#define PIOB_ASR_P5_MASK 0x20
#define PIOB_ASR_P5 0x20
#define PIOB_ASR_P5_BIT 5
#define PIOB_ASR_P6_MASK 0x40
#define PIOB_ASR_P6 0x40
#define PIOB_ASR_P6_BIT 6
#define PIOB_ASR_P7_MASK 0x80
#define PIOB_ASR_P7 0x80
#define PIOB_ASR_P7_BIT 7
#define PIOB_ASR_P8_MASK 0x100
#define PIOB_ASR_P8 0x100
#define PIOB_ASR_P8_BIT 8
#define PIOB_ASR_P9_MASK 0x200
#define PIOB_ASR_P9 0x200
#define PIOB_ASR_P9_BIT 9
#define PIOB_ASR_P10_MASK 0x400
#define PIOB_ASR_P10 0x400
#define PIOB_ASR_P10_BIT 10
#define PIOB_ASR_P11_MASK 0x800
#define PIOB_ASR_P11 0x800
#define PIOB_ASR_P11_BIT 11
#define PIOB_ASR_P12_MASK 0x1000
#define PIOB_ASR_P12 0x1000
#define PIOB_ASR_P12_BIT 12
#define PIOB_ASR_P13_MASK 0x2000
#define PIOB_ASR_P13 0x2000
#define PIOB_ASR_P13_BIT 13
#define PIOB_ASR_P14_MASK 0x4000
#define PIOB_ASR_P14 0x4000
#define PIOB_ASR_P14_BIT 14
#define PIOB_ASR_P15_MASK 0x8000
#define PIOB_ASR_P15 0x8000
#define PIOB_ASR_P15_BIT 15
#define PIOB_ASR_P16_MASK 0x10000
#define PIOB_ASR_P16 0x10000
#define PIOB_ASR_P16_BIT 16
#define PIOB_ASR_P17_MASK 0x20000
#define PIOB_ASR_P17 0x20000
#define PIOB_ASR_P17_BIT 17
#define PIOB_ASR_P18_MASK 0x40000
#define PIOB_ASR_P18 0x40000
#define PIOB_ASR_P18_BIT 18
#define PIOB_ASR_P19_MASK 0x80000
#define PIOB_ASR_P19 0x80000
#define PIOB_ASR_P19_BIT 19
#define PIOB_ASR_P20_MASK 0x100000
#define PIOB_ASR_P20 0x100000
#define PIOB_ASR_P20_BIT 20
#define PIOB_ASR_P21_MASK 0x200000
#define PIOB_ASR_P21 0x200000
#define PIOB_ASR_P21_BIT 21
#define PIOB_ASR_P22_MASK 0x400000
#define PIOB_ASR_P22 0x400000
#define PIOB_ASR_P22_BIT 22
#define PIOB_ASR_P23_MASK 0x800000
#define PIOB_ASR_P23 0x800000
#define PIOB_ASR_P23_BIT 23
#define PIOB_ASR_P24_MASK 0x1000000
#define PIOB_ASR_P24 0x1000000
#define PIOB_ASR_P24_BIT 24
#define PIOB_ASR_P25_MASK 0x2000000
#define PIOB_ASR_P25 0x2000000
#define PIOB_ASR_P25_BIT 25
#define PIOB_ASR_P26_MASK 0x4000000
#define PIOB_ASR_P26 0x4000000
#define PIOB_ASR_P26_BIT 26
#define PIOB_ASR_P27_MASK 0x8000000
#define PIOB_ASR_P27 0x8000000
#define PIOB_ASR_P27_BIT 27
#define PIOB_ASR_P28_MASK 0x10000000
#define PIOB_ASR_P28 0x10000000
#define PIOB_ASR_P28_BIT 28
#define PIOB_ASR_P29_MASK 0x20000000
#define PIOB_ASR_P29 0x20000000
#define PIOB_ASR_P29_BIT 29
#define PIOB_ASR_P30_MASK 0x40000000
#define PIOB_ASR_P30 0x40000000
#define PIOB_ASR_P30_BIT 30
#define PIOB_ASR_P31_MASK 0x80000000
#define PIOB_ASR_P31 0x80000000
#define PIOB_ASR_P31_BIT 31

#define PIOB_BSR (*(volatile unsigned long *)0xFFFFF674)
#define PIOB_BSR_OFFSET 0x74
#define PIOB_BSR_P0_MASK 0x1
#define PIOB_BSR_P0 0x1
#define PIOB_BSR_P0_BIT 0
#define PIOB_BSR_P1_MASK 0x2
#define PIOB_BSR_P1 0x2
#define PIOB_BSR_P1_BIT 1
#define PIOB_BSR_P2_MASK 0x4
#define PIOB_BSR_P2 0x4
#define PIOB_BSR_P2_BIT 2
#define PIOB_BSR_P3_MASK 0x8
#define PIOB_BSR_P3 0x8
#define PIOB_BSR_P3_BIT 3
#define PIOB_BSR_P4_MASK 0x10
#define PIOB_BSR_P4 0x10
#define PIOB_BSR_P4_BIT 4
#define PIOB_BSR_P5_MASK 0x20
#define PIOB_BSR_P5 0x20
#define PIOB_BSR_P5_BIT 5
#define PIOB_BSR_P6_MASK 0x40
#define PIOB_BSR_P6 0x40
#define PIOB_BSR_P6_BIT 6
#define PIOB_BSR_P7_MASK 0x80
#define PIOB_BSR_P7 0x80
#define PIOB_BSR_P7_BIT 7
#define PIOB_BSR_P8_MASK 0x100
#define PIOB_BSR_P8 0x100
#define PIOB_BSR_P8_BIT 8
#define PIOB_BSR_P9_MASK 0x200
#define PIOB_BSR_P9 0x200
#define PIOB_BSR_P9_BIT 9
#define PIOB_BSR_P10_MASK 0x400
#define PIOB_BSR_P10 0x400
#define PIOB_BSR_P10_BIT 10
#define PIOB_BSR_P11_MASK 0x800
#define PIOB_BSR_P11 0x800
#define PIOB_BSR_P11_BIT 11
#define PIOB_BSR_P12_MASK 0x1000
#define PIOB_BSR_P12 0x1000
#define PIOB_BSR_P12_BIT 12
#define PIOB_BSR_P13_MASK 0x2000
#define PIOB_BSR_P13 0x2000
#define PIOB_BSR_P13_BIT 13
#define PIOB_BSR_P14_MASK 0x4000
#define PIOB_BSR_P14 0x4000
#define PIOB_BSR_P14_BIT 14
#define PIOB_BSR_P15_MASK 0x8000
#define PIOB_BSR_P15 0x8000
#define PIOB_BSR_P15_BIT 15
#define PIOB_BSR_P16_MASK 0x10000
#define PIOB_BSR_P16 0x10000
#define PIOB_BSR_P16_BIT 16
#define PIOB_BSR_P17_MASK 0x20000
#define PIOB_BSR_P17 0x20000
#define PIOB_BSR_P17_BIT 17
#define PIOB_BSR_P18_MASK 0x40000
#define PIOB_BSR_P18 0x40000
#define PIOB_BSR_P18_BIT 18
#define PIOB_BSR_P19_MASK 0x80000
#define PIOB_BSR_P19 0x80000
#define PIOB_BSR_P19_BIT 19
#define PIOB_BSR_P20_MASK 0x100000
#define PIOB_BSR_P20 0x100000
#define PIOB_BSR_P20_BIT 20
#define PIOB_BSR_P21_MASK 0x200000
#define PIOB_BSR_P21 0x200000
#define PIOB_BSR_P21_BIT 21
#define PIOB_BSR_P22_MASK 0x400000
#define PIOB_BSR_P22 0x400000
#define PIOB_BSR_P22_BIT 22
#define PIOB_BSR_P23_MASK 0x800000
#define PIOB_BSR_P23 0x800000
#define PIOB_BSR_P23_BIT 23
#define PIOB_BSR_P24_MASK 0x1000000
#define PIOB_BSR_P24 0x1000000
#define PIOB_BSR_P24_BIT 24
#define PIOB_BSR_P25_MASK 0x2000000
#define PIOB_BSR_P25 0x2000000
#define PIOB_BSR_P25_BIT 25
#define PIOB_BSR_P26_MASK 0x4000000
#define PIOB_BSR_P26 0x4000000
#define PIOB_BSR_P26_BIT 26
#define PIOB_BSR_P27_MASK 0x8000000
#define PIOB_BSR_P27 0x8000000
#define PIOB_BSR_P27_BIT 27
#define PIOB_BSR_P28_MASK 0x10000000
#define PIOB_BSR_P28 0x10000000
#define PIOB_BSR_P28_BIT 28
#define PIOB_BSR_P29_MASK 0x20000000
#define PIOB_BSR_P29 0x20000000
#define PIOB_BSR_P29_BIT 29
#define PIOB_BSR_P30_MASK 0x40000000
#define PIOB_BSR_P30 0x40000000
#define PIOB_BSR_P30_BIT 30
#define PIOB_BSR_P31_MASK 0x80000000
#define PIOB_BSR_P31 0x80000000
#define PIOB_BSR_P31_BIT 31

#define PIOB_ABSR (*(volatile unsigned long *)0xFFFFF678)
#define PIOB_ABSR_OFFSET 0x78
#define PIOB_ABSR_P0_MASK 0x1
#define PIOB_ABSR_P0 0x1
#define PIOB_ABSR_P0_BIT 0
#define PIOB_ABSR_P1_MASK 0x2
#define PIOB_ABSR_P1 0x2
#define PIOB_ABSR_P1_BIT 1
#define PIOB_ABSR_P2_MASK 0x4
#define PIOB_ABSR_P2 0x4
#define PIOB_ABSR_P2_BIT 2
#define PIOB_ABSR_P3_MASK 0x8
#define PIOB_ABSR_P3 0x8
#define PIOB_ABSR_P3_BIT 3
#define PIOB_ABSR_P4_MASK 0x10
#define PIOB_ABSR_P4 0x10
#define PIOB_ABSR_P4_BIT 4
#define PIOB_ABSR_P5_MASK 0x20
#define PIOB_ABSR_P5 0x20
#define PIOB_ABSR_P5_BIT 5
#define PIOB_ABSR_P6_MASK 0x40
#define PIOB_ABSR_P6 0x40
#define PIOB_ABSR_P6_BIT 6
#define PIOB_ABSR_P7_MASK 0x80
#define PIOB_ABSR_P7 0x80
#define PIOB_ABSR_P7_BIT 7
#define PIOB_ABSR_P8_MASK 0x100
#define PIOB_ABSR_P8 0x100
#define PIOB_ABSR_P8_BIT 8
#define PIOB_ABSR_P9_MASK 0x200
#define PIOB_ABSR_P9 0x200
#define PIOB_ABSR_P9_BIT 9
#define PIOB_ABSR_P10_MASK 0x400
#define PIOB_ABSR_P10 0x400
#define PIOB_ABSR_P10_BIT 10
#define PIOB_ABSR_P11_MASK 0x800
#define PIOB_ABSR_P11 0x800
#define PIOB_ABSR_P11_BIT 11
#define PIOB_ABSR_P12_MASK 0x1000
#define PIOB_ABSR_P12 0x1000
#define PIOB_ABSR_P12_BIT 12
#define PIOB_ABSR_P13_MASK 0x2000
#define PIOB_ABSR_P13 0x2000
#define PIOB_ABSR_P13_BIT 13
#define PIOB_ABSR_P14_MASK 0x4000
#define PIOB_ABSR_P14 0x4000
#define PIOB_ABSR_P14_BIT 14
#define PIOB_ABSR_P15_MASK 0x8000
#define PIOB_ABSR_P15 0x8000
#define PIOB_ABSR_P15_BIT 15
#define PIOB_ABSR_P16_MASK 0x10000
#define PIOB_ABSR_P16 0x10000
#define PIOB_ABSR_P16_BIT 16
#define PIOB_ABSR_P17_MASK 0x20000
#define PIOB_ABSR_P17 0x20000
#define PIOB_ABSR_P17_BIT 17
#define PIOB_ABSR_P18_MASK 0x40000
#define PIOB_ABSR_P18 0x40000
#define PIOB_ABSR_P18_BIT 18
#define PIOB_ABSR_P19_MASK 0x80000
#define PIOB_ABSR_P19 0x80000
#define PIOB_ABSR_P19_BIT 19
#define PIOB_ABSR_P20_MASK 0x100000
#define PIOB_ABSR_P20 0x100000
#define PIOB_ABSR_P20_BIT 20
#define PIOB_ABSR_P21_MASK 0x200000
#define PIOB_ABSR_P21 0x200000
#define PIOB_ABSR_P21_BIT 21
#define PIOB_ABSR_P22_MASK 0x400000
#define PIOB_ABSR_P22 0x400000
#define PIOB_ABSR_P22_BIT 22
#define PIOB_ABSR_P23_MASK 0x800000
#define PIOB_ABSR_P23 0x800000
#define PIOB_ABSR_P23_BIT 23
#define PIOB_ABSR_P24_MASK 0x1000000
#define PIOB_ABSR_P24 0x1000000
#define PIOB_ABSR_P24_BIT 24
#define PIOB_ABSR_P25_MASK 0x2000000
#define PIOB_ABSR_P25 0x2000000
#define PIOB_ABSR_P25_BIT 25
#define PIOB_ABSR_P26_MASK 0x4000000
#define PIOB_ABSR_P26 0x4000000
#define PIOB_ABSR_P26_BIT 26
#define PIOB_ABSR_P27_MASK 0x8000000
#define PIOB_ABSR_P27 0x8000000
#define PIOB_ABSR_P27_BIT 27
#define PIOB_ABSR_P28_MASK 0x10000000
#define PIOB_ABSR_P28 0x10000000
#define PIOB_ABSR_P28_BIT 28
#define PIOB_ABSR_P29_MASK 0x20000000
#define PIOB_ABSR_P29 0x20000000
#define PIOB_ABSR_P29_BIT 29
#define PIOB_ABSR_P30_MASK 0x40000000
#define PIOB_ABSR_P30 0x40000000
#define PIOB_ABSR_P30_BIT 30
#define PIOB_ABSR_P31_MASK 0x80000000
#define PIOB_ABSR_P31 0x80000000
#define PIOB_ABSR_P31_BIT 31

#define PIOB_OWER (*(volatile unsigned long *)0xFFFFF6A0)
#define PIOB_OWER_OFFSET 0xA0
#define PIOB_OWER_P0_MASK 0x1
#define PIOB_OWER_P0 0x1
#define PIOB_OWER_P0_BIT 0
#define PIOB_OWER_P1_MASK 0x2
#define PIOB_OWER_P1 0x2
#define PIOB_OWER_P1_BIT 1
#define PIOB_OWER_P2_MASK 0x4
#define PIOB_OWER_P2 0x4
#define PIOB_OWER_P2_BIT 2
#define PIOB_OWER_P3_MASK 0x8
#define PIOB_OWER_P3 0x8
#define PIOB_OWER_P3_BIT 3
#define PIOB_OWER_P4_MASK 0x10
#define PIOB_OWER_P4 0x10
#define PIOB_OWER_P4_BIT 4
#define PIOB_OWER_P5_MASK 0x20
#define PIOB_OWER_P5 0x20
#define PIOB_OWER_P5_BIT 5
#define PIOB_OWER_P6_MASK 0x40
#define PIOB_OWER_P6 0x40
#define PIOB_OWER_P6_BIT 6
#define PIOB_OWER_P7_MASK 0x80
#define PIOB_OWER_P7 0x80
#define PIOB_OWER_P7_BIT 7
#define PIOB_OWER_P8_MASK 0x100
#define PIOB_OWER_P8 0x100
#define PIOB_OWER_P8_BIT 8
#define PIOB_OWER_P9_MASK 0x200
#define PIOB_OWER_P9 0x200
#define PIOB_OWER_P9_BIT 9
#define PIOB_OWER_P10_MASK 0x400
#define PIOB_OWER_P10 0x400
#define PIOB_OWER_P10_BIT 10
#define PIOB_OWER_P11_MASK 0x800
#define PIOB_OWER_P11 0x800
#define PIOB_OWER_P11_BIT 11
#define PIOB_OWER_P12_MASK 0x1000
#define PIOB_OWER_P12 0x1000
#define PIOB_OWER_P12_BIT 12
#define PIOB_OWER_P13_MASK 0x2000
#define PIOB_OWER_P13 0x2000
#define PIOB_OWER_P13_BIT 13
#define PIOB_OWER_P14_MASK 0x4000
#define PIOB_OWER_P14 0x4000
#define PIOB_OWER_P14_BIT 14
#define PIOB_OWER_P15_MASK 0x8000
#define PIOB_OWER_P15 0x8000
#define PIOB_OWER_P15_BIT 15
#define PIOB_OWER_P16_MASK 0x10000
#define PIOB_OWER_P16 0x10000
#define PIOB_OWER_P16_BIT 16
#define PIOB_OWER_P17_MASK 0x20000
#define PIOB_OWER_P17 0x20000
#define PIOB_OWER_P17_BIT 17
#define PIOB_OWER_P18_MASK 0x40000
#define PIOB_OWER_P18 0x40000
#define PIOB_OWER_P18_BIT 18
#define PIOB_OWER_P19_MASK 0x80000
#define PIOB_OWER_P19 0x80000
#define PIOB_OWER_P19_BIT 19
#define PIOB_OWER_P20_MASK 0x100000
#define PIOB_OWER_P20 0x100000
#define PIOB_OWER_P20_BIT 20
#define PIOB_OWER_P21_MASK 0x200000
#define PIOB_OWER_P21 0x200000
#define PIOB_OWER_P21_BIT 21
#define PIOB_OWER_P22_MASK 0x400000
#define PIOB_OWER_P22 0x400000
#define PIOB_OWER_P22_BIT 22
#define PIOB_OWER_P23_MASK 0x800000
#define PIOB_OWER_P23 0x800000
#define PIOB_OWER_P23_BIT 23
#define PIOB_OWER_P24_MASK 0x1000000
#define PIOB_OWER_P24 0x1000000
#define PIOB_OWER_P24_BIT 24
#define PIOB_OWER_P25_MASK 0x2000000
#define PIOB_OWER_P25 0x2000000
#define PIOB_OWER_P25_BIT 25
#define PIOB_OWER_P26_MASK 0x4000000
#define PIOB_OWER_P26 0x4000000
#define PIOB_OWER_P26_BIT 26
#define PIOB_OWER_P27_MASK 0x8000000
#define PIOB_OWER_P27 0x8000000
#define PIOB_OWER_P27_BIT 27
#define PIOB_OWER_P28_MASK 0x10000000
#define PIOB_OWER_P28 0x10000000
#define PIOB_OWER_P28_BIT 28
#define PIOB_OWER_P29_MASK 0x20000000
#define PIOB_OWER_P29 0x20000000
#define PIOB_OWER_P29_BIT 29
#define PIOB_OWER_P30_MASK 0x40000000
#define PIOB_OWER_P30 0x40000000
#define PIOB_OWER_P30_BIT 30
#define PIOB_OWER_P31_MASK 0x80000000
#define PIOB_OWER_P31 0x80000000
#define PIOB_OWER_P31_BIT 31

#define PIOB_OWDR (*(volatile unsigned long *)0xFFFFF6A4)
#define PIOB_OWDR_OFFSET 0xA4
#define PIOB_OWDR_P0_MASK 0x1
#define PIOB_OWDR_P0 0x1
#define PIOB_OWDR_P0_BIT 0
#define PIOB_OWDR_P1_MASK 0x2
#define PIOB_OWDR_P1 0x2
#define PIOB_OWDR_P1_BIT 1
#define PIOB_OWDR_P2_MASK 0x4
#define PIOB_OWDR_P2 0x4
#define PIOB_OWDR_P2_BIT 2
#define PIOB_OWDR_P3_MASK 0x8
#define PIOB_OWDR_P3 0x8
#define PIOB_OWDR_P3_BIT 3
#define PIOB_OWDR_P4_MASK 0x10
#define PIOB_OWDR_P4 0x10
#define PIOB_OWDR_P4_BIT 4
#define PIOB_OWDR_P5_MASK 0x20
#define PIOB_OWDR_P5 0x20
#define PIOB_OWDR_P5_BIT 5
#define PIOB_OWDR_P6_MASK 0x40
#define PIOB_OWDR_P6 0x40
#define PIOB_OWDR_P6_BIT 6
#define PIOB_OWDR_P7_MASK 0x80
#define PIOB_OWDR_P7 0x80
#define PIOB_OWDR_P7_BIT 7
#define PIOB_OWDR_P8_MASK 0x100
#define PIOB_OWDR_P8 0x100
#define PIOB_OWDR_P8_BIT 8
#define PIOB_OWDR_P9_MASK 0x200
#define PIOB_OWDR_P9 0x200
#define PIOB_OWDR_P9_BIT 9
#define PIOB_OWDR_P10_MASK 0x400
#define PIOB_OWDR_P10 0x400
#define PIOB_OWDR_P10_BIT 10
#define PIOB_OWDR_P11_MASK 0x800
#define PIOB_OWDR_P11 0x800
#define PIOB_OWDR_P11_BIT 11
#define PIOB_OWDR_P12_MASK 0x1000
#define PIOB_OWDR_P12 0x1000
#define PIOB_OWDR_P12_BIT 12
#define PIOB_OWDR_P13_MASK 0x2000
#define PIOB_OWDR_P13 0x2000
#define PIOB_OWDR_P13_BIT 13
#define PIOB_OWDR_P14_MASK 0x4000
#define PIOB_OWDR_P14 0x4000
#define PIOB_OWDR_P14_BIT 14
#define PIOB_OWDR_P15_MASK 0x8000
#define PIOB_OWDR_P15 0x8000
#define PIOB_OWDR_P15_BIT 15
#define PIOB_OWDR_P16_MASK 0x10000
#define PIOB_OWDR_P16 0x10000
#define PIOB_OWDR_P16_BIT 16
#define PIOB_OWDR_P17_MASK 0x20000
#define PIOB_OWDR_P17 0x20000
#define PIOB_OWDR_P17_BIT 17
#define PIOB_OWDR_P18_MASK 0x40000
#define PIOB_OWDR_P18 0x40000
#define PIOB_OWDR_P18_BIT 18
#define PIOB_OWDR_P19_MASK 0x80000
#define PIOB_OWDR_P19 0x80000
#define PIOB_OWDR_P19_BIT 19
#define PIOB_OWDR_P20_MASK 0x100000
#define PIOB_OWDR_P20 0x100000
#define PIOB_OWDR_P20_BIT 20
#define PIOB_OWDR_P21_MASK 0x200000
#define PIOB_OWDR_P21 0x200000
#define PIOB_OWDR_P21_BIT 21
#define PIOB_OWDR_P22_MASK 0x400000
#define PIOB_OWDR_P22 0x400000
#define PIOB_OWDR_P22_BIT 22
#define PIOB_OWDR_P23_MASK 0x800000
#define PIOB_OWDR_P23 0x800000
#define PIOB_OWDR_P23_BIT 23
#define PIOB_OWDR_P24_MASK 0x1000000
#define PIOB_OWDR_P24 0x1000000
#define PIOB_OWDR_P24_BIT 24
#define PIOB_OWDR_P25_MASK 0x2000000
#define PIOB_OWDR_P25 0x2000000
#define PIOB_OWDR_P25_BIT 25
#define PIOB_OWDR_P26_MASK 0x4000000
#define PIOB_OWDR_P26 0x4000000
#define PIOB_OWDR_P26_BIT 26
#define PIOB_OWDR_P27_MASK 0x8000000
#define PIOB_OWDR_P27 0x8000000
#define PIOB_OWDR_P27_BIT 27
#define PIOB_OWDR_P28_MASK 0x10000000
#define PIOB_OWDR_P28 0x10000000
#define PIOB_OWDR_P28_BIT 28
#define PIOB_OWDR_P29_MASK 0x20000000
#define PIOB_OWDR_P29 0x20000000
#define PIOB_OWDR_P29_BIT 29
#define PIOB_OWDR_P30_MASK 0x40000000
#define PIOB_OWDR_P30 0x40000000
#define PIOB_OWDR_P30_BIT 30
#define PIOB_OWDR_P31_MASK 0x80000000
#define PIOB_OWDR_P31 0x80000000
#define PIOB_OWDR_P31_BIT 31

#define PIOB_OWSR (*(volatile unsigned long *)0xFFFFF6A8)
#define PIOB_OWSR_OFFSET 0xA8
#define PIOB_OWSR_P0_MASK 0x1
#define PIOB_OWSR_P0 0x1
#define PIOB_OWSR_P0_BIT 0
#define PIOB_OWSR_P1_MASK 0x2
#define PIOB_OWSR_P1 0x2
#define PIOB_OWSR_P1_BIT 1
#define PIOB_OWSR_P2_MASK 0x4
#define PIOB_OWSR_P2 0x4
#define PIOB_OWSR_P2_BIT 2
#define PIOB_OWSR_P3_MASK 0x8
#define PIOB_OWSR_P3 0x8
#define PIOB_OWSR_P3_BIT 3
#define PIOB_OWSR_P4_MASK 0x10
#define PIOB_OWSR_P4 0x10
#define PIOB_OWSR_P4_BIT 4
#define PIOB_OWSR_P5_MASK 0x20
#define PIOB_OWSR_P5 0x20
#define PIOB_OWSR_P5_BIT 5
#define PIOB_OWSR_P6_MASK 0x40
#define PIOB_OWSR_P6 0x40
#define PIOB_OWSR_P6_BIT 6
#define PIOB_OWSR_P7_MASK 0x80
#define PIOB_OWSR_P7 0x80
#define PIOB_OWSR_P7_BIT 7
#define PIOB_OWSR_P8_MASK 0x100
#define PIOB_OWSR_P8 0x100
#define PIOB_OWSR_P8_BIT 8
#define PIOB_OWSR_P9_MASK 0x200
#define PIOB_OWSR_P9 0x200
#define PIOB_OWSR_P9_BIT 9
#define PIOB_OWSR_P10_MASK 0x400
#define PIOB_OWSR_P10 0x400
#define PIOB_OWSR_P10_BIT 10
#define PIOB_OWSR_P11_MASK 0x800
#define PIOB_OWSR_P11 0x800
#define PIOB_OWSR_P11_BIT 11
#define PIOB_OWSR_P12_MASK 0x1000
#define PIOB_OWSR_P12 0x1000
#define PIOB_OWSR_P12_BIT 12
#define PIOB_OWSR_P13_MASK 0x2000
#define PIOB_OWSR_P13 0x2000
#define PIOB_OWSR_P13_BIT 13
#define PIOB_OWSR_P14_MASK 0x4000
#define PIOB_OWSR_P14 0x4000
#define PIOB_OWSR_P14_BIT 14
#define PIOB_OWSR_P15_MASK 0x8000
#define PIOB_OWSR_P15 0x8000
#define PIOB_OWSR_P15_BIT 15
#define PIOB_OWSR_P16_MASK 0x10000
#define PIOB_OWSR_P16 0x10000
#define PIOB_OWSR_P16_BIT 16
#define PIOB_OWSR_P17_MASK 0x20000
#define PIOB_OWSR_P17 0x20000
#define PIOB_OWSR_P17_BIT 17
#define PIOB_OWSR_P18_MASK 0x40000
#define PIOB_OWSR_P18 0x40000
#define PIOB_OWSR_P18_BIT 18
#define PIOB_OWSR_P19_MASK 0x80000
#define PIOB_OWSR_P19 0x80000
#define PIOB_OWSR_P19_BIT 19
#define PIOB_OWSR_P20_MASK 0x100000
#define PIOB_OWSR_P20 0x100000
#define PIOB_OWSR_P20_BIT 20
#define PIOB_OWSR_P21_MASK 0x200000
#define PIOB_OWSR_P21 0x200000
#define PIOB_OWSR_P21_BIT 21
#define PIOB_OWSR_P22_MASK 0x400000
#define PIOB_OWSR_P22 0x400000
#define PIOB_OWSR_P22_BIT 22
#define PIOB_OWSR_P23_MASK 0x800000
#define PIOB_OWSR_P23 0x800000
#define PIOB_OWSR_P23_BIT 23
#define PIOB_OWSR_P24_MASK 0x1000000
#define PIOB_OWSR_P24 0x1000000
#define PIOB_OWSR_P24_BIT 24
#define PIOB_OWSR_P25_MASK 0x2000000
#define PIOB_OWSR_P25 0x2000000
#define PIOB_OWSR_P25_BIT 25
#define PIOB_OWSR_P26_MASK 0x4000000
#define PIOB_OWSR_P26 0x4000000
#define PIOB_OWSR_P26_BIT 26
#define PIOB_OWSR_P27_MASK 0x8000000
#define PIOB_OWSR_P27 0x8000000
#define PIOB_OWSR_P27_BIT 27
#define PIOB_OWSR_P28_MASK 0x10000000
#define PIOB_OWSR_P28 0x10000000
#define PIOB_OWSR_P28_BIT 28
#define PIOB_OWSR_P29_MASK 0x20000000
#define PIOB_OWSR_P29 0x20000000
#define PIOB_OWSR_P29_BIT 29
#define PIOB_OWSR_P30_MASK 0x40000000
#define PIOB_OWSR_P30 0x40000000
#define PIOB_OWSR_P30_BIT 30
#define PIOB_OWSR_P31_MASK 0x80000000
#define PIOB_OWSR_P31 0x80000000
#define PIOB_OWSR_P31_BIT 31

#define PIOC_BASE 0xFFFFF800

#define PIOC_PER (*(volatile unsigned long *)0xFFFFF800)
#define PIOC_PER_OFFSET 0x0
#define PIOC_PER_P0_MASK 0x1
#define PIOC_PER_P0 0x1
#define PIOC_PER_P0_BIT 0
#define PIOC_PER_P1_MASK 0x2
#define PIOC_PER_P1 0x2
#define PIOC_PER_P1_BIT 1
#define PIOC_PER_P2_MASK 0x4
#define PIOC_PER_P2 0x4
#define PIOC_PER_P2_BIT 2
#define PIOC_PER_P3_MASK 0x8
#define PIOC_PER_P3 0x8
#define PIOC_PER_P3_BIT 3
#define PIOC_PER_P4_MASK 0x10
#define PIOC_PER_P4 0x10
#define PIOC_PER_P4_BIT 4
#define PIOC_PER_P5_MASK 0x20
#define PIOC_PER_P5 0x20
#define PIOC_PER_P5_BIT 5
#define PIOC_PER_P6_MASK 0x40
#define PIOC_PER_P6 0x40
#define PIOC_PER_P6_BIT 6
#define PIOC_PER_P7_MASK 0x80
#define PIOC_PER_P7 0x80
#define PIOC_PER_P7_BIT 7
#define PIOC_PER_P8_MASK 0x100
#define PIOC_PER_P8 0x100
#define PIOC_PER_P8_BIT 8
#define PIOC_PER_P9_MASK 0x200
#define PIOC_PER_P9 0x200
#define PIOC_PER_P9_BIT 9
#define PIOC_PER_P10_MASK 0x400
#define PIOC_PER_P10 0x400
#define PIOC_PER_P10_BIT 10
#define PIOC_PER_P11_MASK 0x800
#define PIOC_PER_P11 0x800
#define PIOC_PER_P11_BIT 11
#define PIOC_PER_P12_MASK 0x1000
#define PIOC_PER_P12 0x1000
#define PIOC_PER_P12_BIT 12
#define PIOC_PER_P13_MASK 0x2000
#define PIOC_PER_P13 0x2000
#define PIOC_PER_P13_BIT 13
#define PIOC_PER_P14_MASK 0x4000
#define PIOC_PER_P14 0x4000
#define PIOC_PER_P14_BIT 14
#define PIOC_PER_P15_MASK 0x8000
#define PIOC_PER_P15 0x8000
#define PIOC_PER_P15_BIT 15
#define PIOC_PER_P16_MASK 0x10000
#define PIOC_PER_P16 0x10000
#define PIOC_PER_P16_BIT 16
#define PIOC_PER_P17_MASK 0x20000
#define PIOC_PER_P17 0x20000
#define PIOC_PER_P17_BIT 17
#define PIOC_PER_P18_MASK 0x40000
#define PIOC_PER_P18 0x40000
#define PIOC_PER_P18_BIT 18
#define PIOC_PER_P19_MASK 0x80000
#define PIOC_PER_P19 0x80000
#define PIOC_PER_P19_BIT 19
#define PIOC_PER_P20_MASK 0x100000
#define PIOC_PER_P20 0x100000
#define PIOC_PER_P20_BIT 20
#define PIOC_PER_P21_MASK 0x200000
#define PIOC_PER_P21 0x200000
#define PIOC_PER_P21_BIT 21
#define PIOC_PER_P22_MASK 0x400000
#define PIOC_PER_P22 0x400000
#define PIOC_PER_P22_BIT 22
#define PIOC_PER_P23_MASK 0x800000
#define PIOC_PER_P23 0x800000
#define PIOC_PER_P23_BIT 23
#define PIOC_PER_P24_MASK 0x1000000
#define PIOC_PER_P24 0x1000000
#define PIOC_PER_P24_BIT 24
#define PIOC_PER_P25_MASK 0x2000000
#define PIOC_PER_P25 0x2000000
#define PIOC_PER_P25_BIT 25
#define PIOC_PER_P26_MASK 0x4000000
#define PIOC_PER_P26 0x4000000
#define PIOC_PER_P26_BIT 26
#define PIOC_PER_P27_MASK 0x8000000
#define PIOC_PER_P27 0x8000000
#define PIOC_PER_P27_BIT 27
#define PIOC_PER_P28_MASK 0x10000000
#define PIOC_PER_P28 0x10000000
#define PIOC_PER_P28_BIT 28
#define PIOC_PER_P29_MASK 0x20000000
#define PIOC_PER_P29 0x20000000
#define PIOC_PER_P29_BIT 29
#define PIOC_PER_P30_MASK 0x40000000
#define PIOC_PER_P30 0x40000000
#define PIOC_PER_P30_BIT 30
#define PIOC_PER_P31_MASK 0x80000000
#define PIOC_PER_P31 0x80000000
#define PIOC_PER_P31_BIT 31

#define PIOC_PDR (*(volatile unsigned long *)0xFFFFF804)
#define PIOC_PDR_OFFSET 0x4
#define PIOC_PDR_P0_MASK 0x1
#define PIOC_PDR_P0 0x1
#define PIOC_PDR_P0_BIT 0
#define PIOC_PDR_P1_MASK 0x2
#define PIOC_PDR_P1 0x2
#define PIOC_PDR_P1_BIT 1
#define PIOC_PDR_P2_MASK 0x4
#define PIOC_PDR_P2 0x4
#define PIOC_PDR_P2_BIT 2
#define PIOC_PDR_P3_MASK 0x8
#define PIOC_PDR_P3 0x8
#define PIOC_PDR_P3_BIT 3
#define PIOC_PDR_P4_MASK 0x10
#define PIOC_PDR_P4 0x10
#define PIOC_PDR_P4_BIT 4
#define PIOC_PDR_P5_MASK 0x20
#define PIOC_PDR_P5 0x20
#define PIOC_PDR_P5_BIT 5
#define PIOC_PDR_P6_MASK 0x40
#define PIOC_PDR_P6 0x40
#define PIOC_PDR_P6_BIT 6
#define PIOC_PDR_P7_MASK 0x80
#define PIOC_PDR_P7 0x80
#define PIOC_PDR_P7_BIT 7
#define PIOC_PDR_P8_MASK 0x100
#define PIOC_PDR_P8 0x100
#define PIOC_PDR_P8_BIT 8
#define PIOC_PDR_P9_MASK 0x200
#define PIOC_PDR_P9 0x200
#define PIOC_PDR_P9_BIT 9
#define PIOC_PDR_P10_MASK 0x400
#define PIOC_PDR_P10 0x400
#define PIOC_PDR_P10_BIT 10
#define PIOC_PDR_P11_MASK 0x800
#define PIOC_PDR_P11 0x800
#define PIOC_PDR_P11_BIT 11
#define PIOC_PDR_P12_MASK 0x1000
#define PIOC_PDR_P12 0x1000
#define PIOC_PDR_P12_BIT 12
#define PIOC_PDR_P13_MASK 0x2000
#define PIOC_PDR_P13 0x2000
#define PIOC_PDR_P13_BIT 13
#define PIOC_PDR_P14_MASK 0x4000
#define PIOC_PDR_P14 0x4000
#define PIOC_PDR_P14_BIT 14
#define PIOC_PDR_P15_MASK 0x8000
#define PIOC_PDR_P15 0x8000
#define PIOC_PDR_P15_BIT 15
#define PIOC_PDR_P16_MASK 0x10000
#define PIOC_PDR_P16 0x10000
#define PIOC_PDR_P16_BIT 16
#define PIOC_PDR_P17_MASK 0x20000
#define PIOC_PDR_P17 0x20000
#define PIOC_PDR_P17_BIT 17
#define PIOC_PDR_P18_MASK 0x40000
#define PIOC_PDR_P18 0x40000
#define PIOC_PDR_P18_BIT 18
#define PIOC_PDR_P19_MASK 0x80000
#define PIOC_PDR_P19 0x80000
#define PIOC_PDR_P19_BIT 19
#define PIOC_PDR_P20_MASK 0x100000
#define PIOC_PDR_P20 0x100000
#define PIOC_PDR_P20_BIT 20
#define PIOC_PDR_P21_MASK 0x200000
#define PIOC_PDR_P21 0x200000
#define PIOC_PDR_P21_BIT 21
#define PIOC_PDR_P22_MASK 0x400000
#define PIOC_PDR_P22 0x400000
#define PIOC_PDR_P22_BIT 22
#define PIOC_PDR_P23_MASK 0x800000
#define PIOC_PDR_P23 0x800000
#define PIOC_PDR_P23_BIT 23
#define PIOC_PDR_P24_MASK 0x1000000
#define PIOC_PDR_P24 0x1000000
#define PIOC_PDR_P24_BIT 24
#define PIOC_PDR_P25_MASK 0x2000000
#define PIOC_PDR_P25 0x2000000
#define PIOC_PDR_P25_BIT 25
#define PIOC_PDR_P26_MASK 0x4000000
#define PIOC_PDR_P26 0x4000000
#define PIOC_PDR_P26_BIT 26
#define PIOC_PDR_P27_MASK 0x8000000
#define PIOC_PDR_P27 0x8000000
#define PIOC_PDR_P27_BIT 27
#define PIOC_PDR_P28_MASK 0x10000000
#define PIOC_PDR_P28 0x10000000
#define PIOC_PDR_P28_BIT 28
#define PIOC_PDR_P29_MASK 0x20000000
#define PIOC_PDR_P29 0x20000000
#define PIOC_PDR_P29_BIT 29
#define PIOC_PDR_P30_MASK 0x40000000
#define PIOC_PDR_P30 0x40000000
#define PIOC_PDR_P30_BIT 30
#define PIOC_PDR_P31_MASK 0x80000000
#define PIOC_PDR_P31 0x80000000
#define PIOC_PDR_P31_BIT 31

#define PIOC_PSR (*(volatile unsigned long *)0xFFFFF808)
#define PIOC_PSR_OFFSET 0x8
#define PIOC_PSR_P0_MASK 0x1
#define PIOC_PSR_P0 0x1
#define PIOC_PSR_P0_BIT 0
#define PIOC_PSR_P1_MASK 0x2
#define PIOC_PSR_P1 0x2
#define PIOC_PSR_P1_BIT 1
#define PIOC_PSR_P2_MASK 0x4
#define PIOC_PSR_P2 0x4
#define PIOC_PSR_P2_BIT 2
#define PIOC_PSR_P3_MASK 0x8
#define PIOC_PSR_P3 0x8
#define PIOC_PSR_P3_BIT 3
#define PIOC_PSR_P4_MASK 0x10
#define PIOC_PSR_P4 0x10
#define PIOC_PSR_P4_BIT 4
#define PIOC_PSR_P5_MASK 0x20
#define PIOC_PSR_P5 0x20
#define PIOC_PSR_P5_BIT 5
#define PIOC_PSR_P6_MASK 0x40
#define PIOC_PSR_P6 0x40
#define PIOC_PSR_P6_BIT 6
#define PIOC_PSR_P7_MASK 0x80
#define PIOC_PSR_P7 0x80
#define PIOC_PSR_P7_BIT 7
#define PIOC_PSR_P8_MASK 0x100
#define PIOC_PSR_P8 0x100
#define PIOC_PSR_P8_BIT 8
#define PIOC_PSR_P9_MASK 0x200
#define PIOC_PSR_P9 0x200
#define PIOC_PSR_P9_BIT 9
#define PIOC_PSR_P10_MASK 0x400
#define PIOC_PSR_P10 0x400
#define PIOC_PSR_P10_BIT 10
#define PIOC_PSR_P11_MASK 0x800
#define PIOC_PSR_P11 0x800
#define PIOC_PSR_P11_BIT 11
#define PIOC_PSR_P12_MASK 0x1000
#define PIOC_PSR_P12 0x1000
#define PIOC_PSR_P12_BIT 12
#define PIOC_PSR_P13_MASK 0x2000
#define PIOC_PSR_P13 0x2000
#define PIOC_PSR_P13_BIT 13
#define PIOC_PSR_P14_MASK 0x4000
#define PIOC_PSR_P14 0x4000
#define PIOC_PSR_P14_BIT 14
#define PIOC_PSR_P15_MASK 0x8000
#define PIOC_PSR_P15 0x8000
#define PIOC_PSR_P15_BIT 15
#define PIOC_PSR_P16_MASK 0x10000
#define PIOC_PSR_P16 0x10000
#define PIOC_PSR_P16_BIT 16
#define PIOC_PSR_P17_MASK 0x20000
#define PIOC_PSR_P17 0x20000
#define PIOC_PSR_P17_BIT 17
#define PIOC_PSR_P18_MASK 0x40000
#define PIOC_PSR_P18 0x40000
#define PIOC_PSR_P18_BIT 18
#define PIOC_PSR_P19_MASK 0x80000
#define PIOC_PSR_P19 0x80000
#define PIOC_PSR_P19_BIT 19
#define PIOC_PSR_P20_MASK 0x100000
#define PIOC_PSR_P20 0x100000
#define PIOC_PSR_P20_BIT 20
#define PIOC_PSR_P21_MASK 0x200000
#define PIOC_PSR_P21 0x200000
#define PIOC_PSR_P21_BIT 21
#define PIOC_PSR_P22_MASK 0x400000
#define PIOC_PSR_P22 0x400000
#define PIOC_PSR_P22_BIT 22
#define PIOC_PSR_P23_MASK 0x800000
#define PIOC_PSR_P23 0x800000
#define PIOC_PSR_P23_BIT 23
#define PIOC_PSR_P24_MASK 0x1000000
#define PIOC_PSR_P24 0x1000000
#define PIOC_PSR_P24_BIT 24
#define PIOC_PSR_P25_MASK 0x2000000
#define PIOC_PSR_P25 0x2000000
#define PIOC_PSR_P25_BIT 25
#define PIOC_PSR_P26_MASK 0x4000000
#define PIOC_PSR_P26 0x4000000
#define PIOC_PSR_P26_BIT 26
#define PIOC_PSR_P27_MASK 0x8000000
#define PIOC_PSR_P27 0x8000000
#define PIOC_PSR_P27_BIT 27
#define PIOC_PSR_P28_MASK 0x10000000
#define PIOC_PSR_P28 0x10000000
#define PIOC_PSR_P28_BIT 28
#define PIOC_PSR_P29_MASK 0x20000000
#define PIOC_PSR_P29 0x20000000
#define PIOC_PSR_P29_BIT 29
#define PIOC_PSR_P30_MASK 0x40000000
#define PIOC_PSR_P30 0x40000000
#define PIOC_PSR_P30_BIT 30
#define PIOC_PSR_P31_MASK 0x80000000
#define PIOC_PSR_P31 0x80000000
#define PIOC_PSR_P31_BIT 31

#define PIOC_OER (*(volatile unsigned long *)0xFFFFF810)
#define PIOC_OER_OFFSET 0x10
#define PIOC_OER_P0_MASK 0x1
#define PIOC_OER_P0 0x1
#define PIOC_OER_P0_BIT 0
#define PIOC_OER_P1_MASK 0x2
#define PIOC_OER_P1 0x2
#define PIOC_OER_P1_BIT 1
#define PIOC_OER_P2_MASK 0x4
#define PIOC_OER_P2 0x4
#define PIOC_OER_P2_BIT 2
#define PIOC_OER_P3_MASK 0x8
#define PIOC_OER_P3 0x8
#define PIOC_OER_P3_BIT 3
#define PIOC_OER_P4_MASK 0x10
#define PIOC_OER_P4 0x10
#define PIOC_OER_P4_BIT 4
#define PIOC_OER_P5_MASK 0x20
#define PIOC_OER_P5 0x20
#define PIOC_OER_P5_BIT 5
#define PIOC_OER_P6_MASK 0x40
#define PIOC_OER_P6 0x40
#define PIOC_OER_P6_BIT 6
#define PIOC_OER_P7_MASK 0x80
#define PIOC_OER_P7 0x80
#define PIOC_OER_P7_BIT 7
#define PIOC_OER_P8_MASK 0x100
#define PIOC_OER_P8 0x100
#define PIOC_OER_P8_BIT 8
#define PIOC_OER_P9_MASK 0x200
#define PIOC_OER_P9 0x200
#define PIOC_OER_P9_BIT 9
#define PIOC_OER_P10_MASK 0x400
#define PIOC_OER_P10 0x400
#define PIOC_OER_P10_BIT 10
#define PIOC_OER_P11_MASK 0x800
#define PIOC_OER_P11 0x800
#define PIOC_OER_P11_BIT 11
#define PIOC_OER_P12_MASK 0x1000
#define PIOC_OER_P12 0x1000
#define PIOC_OER_P12_BIT 12
#define PIOC_OER_P13_MASK 0x2000
#define PIOC_OER_P13 0x2000
#define PIOC_OER_P13_BIT 13
#define PIOC_OER_P14_MASK 0x4000
#define PIOC_OER_P14 0x4000
#define PIOC_OER_P14_BIT 14
#define PIOC_OER_P15_MASK 0x8000
#define PIOC_OER_P15 0x8000
#define PIOC_OER_P15_BIT 15
#define PIOC_OER_P16_MASK 0x10000
#define PIOC_OER_P16 0x10000
#define PIOC_OER_P16_BIT 16
#define PIOC_OER_P17_MASK 0x20000
#define PIOC_OER_P17 0x20000
#define PIOC_OER_P17_BIT 17
#define PIOC_OER_P18_MASK 0x40000
#define PIOC_OER_P18 0x40000
#define PIOC_OER_P18_BIT 18
#define PIOC_OER_P19_MASK 0x80000
#define PIOC_OER_P19 0x80000
#define PIOC_OER_P19_BIT 19
#define PIOC_OER_P20_MASK 0x100000
#define PIOC_OER_P20 0x100000
#define PIOC_OER_P20_BIT 20
#define PIOC_OER_P21_MASK 0x200000
#define PIOC_OER_P21 0x200000
#define PIOC_OER_P21_BIT 21
#define PIOC_OER_P22_MASK 0x400000
#define PIOC_OER_P22 0x400000
#define PIOC_OER_P22_BIT 22
#define PIOC_OER_P23_MASK 0x800000
#define PIOC_OER_P23 0x800000
#define PIOC_OER_P23_BIT 23
#define PIOC_OER_P24_MASK 0x1000000
#define PIOC_OER_P24 0x1000000
#define PIOC_OER_P24_BIT 24
#define PIOC_OER_P25_MASK 0x2000000
#define PIOC_OER_P25 0x2000000
#define PIOC_OER_P25_BIT 25
#define PIOC_OER_P26_MASK 0x4000000
#define PIOC_OER_P26 0x4000000
#define PIOC_OER_P26_BIT 26
#define PIOC_OER_P27_MASK 0x8000000
#define PIOC_OER_P27 0x8000000
#define PIOC_OER_P27_BIT 27
#define PIOC_OER_P28_MASK 0x10000000
#define PIOC_OER_P28 0x10000000
#define PIOC_OER_P28_BIT 28
#define PIOC_OER_P29_MASK 0x20000000
#define PIOC_OER_P29 0x20000000
#define PIOC_OER_P29_BIT 29
#define PIOC_OER_P30_MASK 0x40000000
#define PIOC_OER_P30 0x40000000
#define PIOC_OER_P30_BIT 30
#define PIOC_OER_P31_MASK 0x80000000
#define PIOC_OER_P31 0x80000000
#define PIOC_OER_P31_BIT 31

#define PIOC_ODR (*(volatile unsigned long *)0xFFFFF814)
#define PIOC_ODR_OFFSET 0x14
#define PIOC_ODR_P0_MASK 0x1
#define PIOC_ODR_P0 0x1
#define PIOC_ODR_P0_BIT 0
#define PIOC_ODR_P1_MASK 0x2
#define PIOC_ODR_P1 0x2
#define PIOC_ODR_P1_BIT 1
#define PIOC_ODR_P2_MASK 0x4
#define PIOC_ODR_P2 0x4
#define PIOC_ODR_P2_BIT 2
#define PIOC_ODR_P3_MASK 0x8
#define PIOC_ODR_P3 0x8
#define PIOC_ODR_P3_BIT 3
#define PIOC_ODR_P4_MASK 0x10
#define PIOC_ODR_P4 0x10
#define PIOC_ODR_P4_BIT 4
#define PIOC_ODR_P5_MASK 0x20
#define PIOC_ODR_P5 0x20
#define PIOC_ODR_P5_BIT 5
#define PIOC_ODR_P6_MASK 0x40
#define PIOC_ODR_P6 0x40
#define PIOC_ODR_P6_BIT 6
#define PIOC_ODR_P7_MASK 0x80
#define PIOC_ODR_P7 0x80
#define PIOC_ODR_P7_BIT 7
#define PIOC_ODR_P8_MASK 0x100
#define PIOC_ODR_P8 0x100
#define PIOC_ODR_P8_BIT 8
#define PIOC_ODR_P9_MASK 0x200
#define PIOC_ODR_P9 0x200
#define PIOC_ODR_P9_BIT 9
#define PIOC_ODR_P10_MASK 0x400
#define PIOC_ODR_P10 0x400
#define PIOC_ODR_P10_BIT 10
#define PIOC_ODR_P11_MASK 0x800
#define PIOC_ODR_P11 0x800
#define PIOC_ODR_P11_BIT 11
#define PIOC_ODR_P12_MASK 0x1000
#define PIOC_ODR_P12 0x1000
#define PIOC_ODR_P12_BIT 12
#define PIOC_ODR_P13_MASK 0x2000
#define PIOC_ODR_P13 0x2000
#define PIOC_ODR_P13_BIT 13
#define PIOC_ODR_P14_MASK 0x4000
#define PIOC_ODR_P14 0x4000
#define PIOC_ODR_P14_BIT 14
#define PIOC_ODR_P15_MASK 0x8000
#define PIOC_ODR_P15 0x8000
#define PIOC_ODR_P15_BIT 15
#define PIOC_ODR_P16_MASK 0x10000
#define PIOC_ODR_P16 0x10000
#define PIOC_ODR_P16_BIT 16
#define PIOC_ODR_P17_MASK 0x20000
#define PIOC_ODR_P17 0x20000
#define PIOC_ODR_P17_BIT 17
#define PIOC_ODR_P18_MASK 0x40000
#define PIOC_ODR_P18 0x40000
#define PIOC_ODR_P18_BIT 18
#define PIOC_ODR_P19_MASK 0x80000
#define PIOC_ODR_P19 0x80000
#define PIOC_ODR_P19_BIT 19
#define PIOC_ODR_P20_MASK 0x100000
#define PIOC_ODR_P20 0x100000
#define PIOC_ODR_P20_BIT 20
#define PIOC_ODR_P21_MASK 0x200000
#define PIOC_ODR_P21 0x200000
#define PIOC_ODR_P21_BIT 21
#define PIOC_ODR_P22_MASK 0x400000
#define PIOC_ODR_P22 0x400000
#define PIOC_ODR_P22_BIT 22
#define PIOC_ODR_P23_MASK 0x800000
#define PIOC_ODR_P23 0x800000
#define PIOC_ODR_P23_BIT 23
#define PIOC_ODR_P24_MASK 0x1000000
#define PIOC_ODR_P24 0x1000000
#define PIOC_ODR_P24_BIT 24
#define PIOC_ODR_P25_MASK 0x2000000
#define PIOC_ODR_P25 0x2000000
#define PIOC_ODR_P25_BIT 25
#define PIOC_ODR_P26_MASK 0x4000000
#define PIOC_ODR_P26 0x4000000
#define PIOC_ODR_P26_BIT 26
#define PIOC_ODR_P27_MASK 0x8000000
#define PIOC_ODR_P27 0x8000000
#define PIOC_ODR_P27_BIT 27
#define PIOC_ODR_P28_MASK 0x10000000
#define PIOC_ODR_P28 0x10000000
#define PIOC_ODR_P28_BIT 28
#define PIOC_ODR_P29_MASK 0x20000000
#define PIOC_ODR_P29 0x20000000
#define PIOC_ODR_P29_BIT 29
#define PIOC_ODR_P30_MASK 0x40000000
#define PIOC_ODR_P30 0x40000000
#define PIOC_ODR_P30_BIT 30
#define PIOC_ODR_P31_MASK 0x80000000
#define PIOC_ODR_P31 0x80000000
#define PIOC_ODR_P31_BIT 31

#define PIOC_OSR (*(volatile unsigned long *)0xFFFFF818)
#define PIOC_OSR_OFFSET 0x18
#define PIOC_OSR_P0_MASK 0x1
#define PIOC_OSR_P0 0x1
#define PIOC_OSR_P0_BIT 0
#define PIOC_OSR_P1_MASK 0x2
#define PIOC_OSR_P1 0x2
#define PIOC_OSR_P1_BIT 1
#define PIOC_OSR_P2_MASK 0x4
#define PIOC_OSR_P2 0x4
#define PIOC_OSR_P2_BIT 2
#define PIOC_OSR_P3_MASK 0x8
#define PIOC_OSR_P3 0x8
#define PIOC_OSR_P3_BIT 3
#define PIOC_OSR_P4_MASK 0x10
#define PIOC_OSR_P4 0x10
#define PIOC_OSR_P4_BIT 4
#define PIOC_OSR_P5_MASK 0x20
#define PIOC_OSR_P5 0x20
#define PIOC_OSR_P5_BIT 5
#define PIOC_OSR_P6_MASK 0x40
#define PIOC_OSR_P6 0x40
#define PIOC_OSR_P6_BIT 6
#define PIOC_OSR_P7_MASK 0x80
#define PIOC_OSR_P7 0x80
#define PIOC_OSR_P7_BIT 7
#define PIOC_OSR_P8_MASK 0x100
#define PIOC_OSR_P8 0x100
#define PIOC_OSR_P8_BIT 8
#define PIOC_OSR_P9_MASK 0x200
#define PIOC_OSR_P9 0x200
#define PIOC_OSR_P9_BIT 9
#define PIOC_OSR_P10_MASK 0x400
#define PIOC_OSR_P10 0x400
#define PIOC_OSR_P10_BIT 10
#define PIOC_OSR_P11_MASK 0x800
#define PIOC_OSR_P11 0x800
#define PIOC_OSR_P11_BIT 11
#define PIOC_OSR_P12_MASK 0x1000
#define PIOC_OSR_P12 0x1000
#define PIOC_OSR_P12_BIT 12
#define PIOC_OSR_P13_MASK 0x2000
#define PIOC_OSR_P13 0x2000
#define PIOC_OSR_P13_BIT 13
#define PIOC_OSR_P14_MASK 0x4000
#define PIOC_OSR_P14 0x4000
#define PIOC_OSR_P14_BIT 14
#define PIOC_OSR_P15_MASK 0x8000
#define PIOC_OSR_P15 0x8000
#define PIOC_OSR_P15_BIT 15
#define PIOC_OSR_P16_MASK 0x10000
#define PIOC_OSR_P16 0x10000
#define PIOC_OSR_P16_BIT 16
#define PIOC_OSR_P17_MASK 0x20000
#define PIOC_OSR_P17 0x20000
#define PIOC_OSR_P17_BIT 17
#define PIOC_OSR_P18_MASK 0x40000
#define PIOC_OSR_P18 0x40000
#define PIOC_OSR_P18_BIT 18
#define PIOC_OSR_P19_MASK 0x80000
#define PIOC_OSR_P19 0x80000
#define PIOC_OSR_P19_BIT 19
#define PIOC_OSR_P20_MASK 0x100000
#define PIOC_OSR_P20 0x100000
#define PIOC_OSR_P20_BIT 20
#define PIOC_OSR_P21_MASK 0x200000
#define PIOC_OSR_P21 0x200000
#define PIOC_OSR_P21_BIT 21
#define PIOC_OSR_P22_MASK 0x400000
#define PIOC_OSR_P22 0x400000
#define PIOC_OSR_P22_BIT 22
#define PIOC_OSR_P23_MASK 0x800000
#define PIOC_OSR_P23 0x800000
#define PIOC_OSR_P23_BIT 23
#define PIOC_OSR_P24_MASK 0x1000000
#define PIOC_OSR_P24 0x1000000
#define PIOC_OSR_P24_BIT 24
#define PIOC_OSR_P25_MASK 0x2000000
#define PIOC_OSR_P25 0x2000000
#define PIOC_OSR_P25_BIT 25
#define PIOC_OSR_P26_MASK 0x4000000
#define PIOC_OSR_P26 0x4000000
#define PIOC_OSR_P26_BIT 26
#define PIOC_OSR_P27_MASK 0x8000000
#define PIOC_OSR_P27 0x8000000
#define PIOC_OSR_P27_BIT 27
#define PIOC_OSR_P28_MASK 0x10000000
#define PIOC_OSR_P28 0x10000000
#define PIOC_OSR_P28_BIT 28
#define PIOC_OSR_P29_MASK 0x20000000
#define PIOC_OSR_P29 0x20000000
#define PIOC_OSR_P29_BIT 29
#define PIOC_OSR_P30_MASK 0x40000000
#define PIOC_OSR_P30 0x40000000
#define PIOC_OSR_P30_BIT 30
#define PIOC_OSR_P31_MASK 0x80000000
#define PIOC_OSR_P31 0x80000000
#define PIOC_OSR_P31_BIT 31

#define PIOC_IFER (*(volatile unsigned long *)0xFFFFF820)
#define PIOC_IFER_OFFSET 0x20
#define PIOC_IFER_P0_MASK 0x1
#define PIOC_IFER_P0 0x1
#define PIOC_IFER_P0_BIT 0
#define PIOC_IFER_P1_MASK 0x2
#define PIOC_IFER_P1 0x2
#define PIOC_IFER_P1_BIT 1
#define PIOC_IFER_P2_MASK 0x4
#define PIOC_IFER_P2 0x4
#define PIOC_IFER_P2_BIT 2
#define PIOC_IFER_P3_MASK 0x8
#define PIOC_IFER_P3 0x8
#define PIOC_IFER_P3_BIT 3
#define PIOC_IFER_P4_MASK 0x10
#define PIOC_IFER_P4 0x10
#define PIOC_IFER_P4_BIT 4
#define PIOC_IFER_P5_MASK 0x20
#define PIOC_IFER_P5 0x20
#define PIOC_IFER_P5_BIT 5
#define PIOC_IFER_P6_MASK 0x40
#define PIOC_IFER_P6 0x40
#define PIOC_IFER_P6_BIT 6
#define PIOC_IFER_P7_MASK 0x80
#define PIOC_IFER_P7 0x80
#define PIOC_IFER_P7_BIT 7
#define PIOC_IFER_P8_MASK 0x100
#define PIOC_IFER_P8 0x100
#define PIOC_IFER_P8_BIT 8
#define PIOC_IFER_P9_MASK 0x200
#define PIOC_IFER_P9 0x200
#define PIOC_IFER_P9_BIT 9
#define PIOC_IFER_P10_MASK 0x400
#define PIOC_IFER_P10 0x400
#define PIOC_IFER_P10_BIT 10
#define PIOC_IFER_P11_MASK 0x800
#define PIOC_IFER_P11 0x800
#define PIOC_IFER_P11_BIT 11
#define PIOC_IFER_P12_MASK 0x1000
#define PIOC_IFER_P12 0x1000
#define PIOC_IFER_P12_BIT 12
#define PIOC_IFER_P13_MASK 0x2000
#define PIOC_IFER_P13 0x2000
#define PIOC_IFER_P13_BIT 13
#define PIOC_IFER_P14_MASK 0x4000
#define PIOC_IFER_P14 0x4000
#define PIOC_IFER_P14_BIT 14
#define PIOC_IFER_P15_MASK 0x8000
#define PIOC_IFER_P15 0x8000
#define PIOC_IFER_P15_BIT 15
#define PIOC_IFER_P16_MASK 0x10000
#define PIOC_IFER_P16 0x10000
#define PIOC_IFER_P16_BIT 16
#define PIOC_IFER_P17_MASK 0x20000
#define PIOC_IFER_P17 0x20000
#define PIOC_IFER_P17_BIT 17
#define PIOC_IFER_P18_MASK 0x40000
#define PIOC_IFER_P18 0x40000
#define PIOC_IFER_P18_BIT 18
#define PIOC_IFER_P19_MASK 0x80000
#define PIOC_IFER_P19 0x80000
#define PIOC_IFER_P19_BIT 19
#define PIOC_IFER_P20_MASK 0x100000
#define PIOC_IFER_P20 0x100000
#define PIOC_IFER_P20_BIT 20
#define PIOC_IFER_P21_MASK 0x200000
#define PIOC_IFER_P21 0x200000
#define PIOC_IFER_P21_BIT 21
#define PIOC_IFER_P22_MASK 0x400000
#define PIOC_IFER_P22 0x400000
#define PIOC_IFER_P22_BIT 22
#define PIOC_IFER_P23_MASK 0x800000
#define PIOC_IFER_P23 0x800000
#define PIOC_IFER_P23_BIT 23
#define PIOC_IFER_P24_MASK 0x1000000
#define PIOC_IFER_P24 0x1000000
#define PIOC_IFER_P24_BIT 24
#define PIOC_IFER_P25_MASK 0x2000000
#define PIOC_IFER_P25 0x2000000
#define PIOC_IFER_P25_BIT 25
#define PIOC_IFER_P26_MASK 0x4000000
#define PIOC_IFER_P26 0x4000000
#define PIOC_IFER_P26_BIT 26
#define PIOC_IFER_P27_MASK 0x8000000
#define PIOC_IFER_P27 0x8000000
#define PIOC_IFER_P27_BIT 27
#define PIOC_IFER_P28_MASK 0x10000000
#define PIOC_IFER_P28 0x10000000
#define PIOC_IFER_P28_BIT 28
#define PIOC_IFER_P29_MASK 0x20000000
#define PIOC_IFER_P29 0x20000000
#define PIOC_IFER_P29_BIT 29
#define PIOC_IFER_P30_MASK 0x40000000
#define PIOC_IFER_P30 0x40000000
#define PIOC_IFER_P30_BIT 30
#define PIOC_IFER_P31_MASK 0x80000000
#define PIOC_IFER_P31 0x80000000
#define PIOC_IFER_P31_BIT 31

#define PIOC_IFDR (*(volatile unsigned long *)0xFFFFF824)
#define PIOC_IFDR_OFFSET 0x24
#define PIOC_IFDR_P0_MASK 0x1
#define PIOC_IFDR_P0 0x1
#define PIOC_IFDR_P0_BIT 0
#define PIOC_IFDR_P1_MASK 0x2
#define PIOC_IFDR_P1 0x2
#define PIOC_IFDR_P1_BIT 1
#define PIOC_IFDR_P2_MASK 0x4
#define PIOC_IFDR_P2 0x4
#define PIOC_IFDR_P2_BIT 2
#define PIOC_IFDR_P3_MASK 0x8
#define PIOC_IFDR_P3 0x8
#define PIOC_IFDR_P3_BIT 3
#define PIOC_IFDR_P4_MASK 0x10
#define PIOC_IFDR_P4 0x10
#define PIOC_IFDR_P4_BIT 4
#define PIOC_IFDR_P5_MASK 0x20
#define PIOC_IFDR_P5 0x20
#define PIOC_IFDR_P5_BIT 5
#define PIOC_IFDR_P6_MASK 0x40
#define PIOC_IFDR_P6 0x40
#define PIOC_IFDR_P6_BIT 6
#define PIOC_IFDR_P7_MASK 0x80
#define PIOC_IFDR_P7 0x80
#define PIOC_IFDR_P7_BIT 7
#define PIOC_IFDR_P8_MASK 0x100
#define PIOC_IFDR_P8 0x100
#define PIOC_IFDR_P8_BIT 8
#define PIOC_IFDR_P9_MASK 0x200
#define PIOC_IFDR_P9 0x200
#define PIOC_IFDR_P9_BIT 9
#define PIOC_IFDR_P10_MASK 0x400
#define PIOC_IFDR_P10 0x400
#define PIOC_IFDR_P10_BIT 10
#define PIOC_IFDR_P11_MASK 0x800
#define PIOC_IFDR_P11 0x800
#define PIOC_IFDR_P11_BIT 11
#define PIOC_IFDR_P12_MASK 0x1000
#define PIOC_IFDR_P12 0x1000
#define PIOC_IFDR_P12_BIT 12
#define PIOC_IFDR_P13_MASK 0x2000
#define PIOC_IFDR_P13 0x2000
#define PIOC_IFDR_P13_BIT 13
#define PIOC_IFDR_P14_MASK 0x4000
#define PIOC_IFDR_P14 0x4000
#define PIOC_IFDR_P14_BIT 14
#define PIOC_IFDR_P15_MASK 0x8000
#define PIOC_IFDR_P15 0x8000
#define PIOC_IFDR_P15_BIT 15
#define PIOC_IFDR_P16_MASK 0x10000
#define PIOC_IFDR_P16 0x10000
#define PIOC_IFDR_P16_BIT 16
#define PIOC_IFDR_P17_MASK 0x20000
#define PIOC_IFDR_P17 0x20000
#define PIOC_IFDR_P17_BIT 17
#define PIOC_IFDR_P18_MASK 0x40000
#define PIOC_IFDR_P18 0x40000
#define PIOC_IFDR_P18_BIT 18
#define PIOC_IFDR_P19_MASK 0x80000
#define PIOC_IFDR_P19 0x80000
#define PIOC_IFDR_P19_BIT 19
#define PIOC_IFDR_P20_MASK 0x100000
#define PIOC_IFDR_P20 0x100000
#define PIOC_IFDR_P20_BIT 20
#define PIOC_IFDR_P21_MASK 0x200000
#define PIOC_IFDR_P21 0x200000
#define PIOC_IFDR_P21_BIT 21
#define PIOC_IFDR_P22_MASK 0x400000
#define PIOC_IFDR_P22 0x400000
#define PIOC_IFDR_P22_BIT 22
#define PIOC_IFDR_P23_MASK 0x800000
#define PIOC_IFDR_P23 0x800000
#define PIOC_IFDR_P23_BIT 23
#define PIOC_IFDR_P24_MASK 0x1000000
#define PIOC_IFDR_P24 0x1000000
#define PIOC_IFDR_P24_BIT 24
#define PIOC_IFDR_P25_MASK 0x2000000
#define PIOC_IFDR_P25 0x2000000
#define PIOC_IFDR_P25_BIT 25
#define PIOC_IFDR_P26_MASK 0x4000000
#define PIOC_IFDR_P26 0x4000000
#define PIOC_IFDR_P26_BIT 26
#define PIOC_IFDR_P27_MASK 0x8000000
#define PIOC_IFDR_P27 0x8000000
#define PIOC_IFDR_P27_BIT 27
#define PIOC_IFDR_P28_MASK 0x10000000
#define PIOC_IFDR_P28 0x10000000
#define PIOC_IFDR_P28_BIT 28
#define PIOC_IFDR_P29_MASK 0x20000000
#define PIOC_IFDR_P29 0x20000000
#define PIOC_IFDR_P29_BIT 29
#define PIOC_IFDR_P30_MASK 0x40000000
#define PIOC_IFDR_P30 0x40000000
#define PIOC_IFDR_P30_BIT 30
#define PIOC_IFDR_P31_MASK 0x80000000
#define PIOC_IFDR_P31 0x80000000
#define PIOC_IFDR_P31_BIT 31

#define PIOC_IFSR (*(volatile unsigned long *)0xFFFFF828)
#define PIOC_IFSR_OFFSET 0x28
#define PIOC_IFSR_P0_MASK 0x1
#define PIOC_IFSR_P0 0x1
#define PIOC_IFSR_P0_BIT 0
#define PIOC_IFSR_P1_MASK 0x2
#define PIOC_IFSR_P1 0x2
#define PIOC_IFSR_P1_BIT 1
#define PIOC_IFSR_P2_MASK 0x4
#define PIOC_IFSR_P2 0x4
#define PIOC_IFSR_P2_BIT 2
#define PIOC_IFSR_P3_MASK 0x8
#define PIOC_IFSR_P3 0x8
#define PIOC_IFSR_P3_BIT 3
#define PIOC_IFSR_P4_MASK 0x10
#define PIOC_IFSR_P4 0x10
#define PIOC_IFSR_P4_BIT 4
#define PIOC_IFSR_P5_MASK 0x20
#define PIOC_IFSR_P5 0x20
#define PIOC_IFSR_P5_BIT 5
#define PIOC_IFSR_P6_MASK 0x40
#define PIOC_IFSR_P6 0x40
#define PIOC_IFSR_P6_BIT 6
#define PIOC_IFSR_P7_MASK 0x80
#define PIOC_IFSR_P7 0x80
#define PIOC_IFSR_P7_BIT 7
#define PIOC_IFSR_P8_MASK 0x100
#define PIOC_IFSR_P8 0x100
#define PIOC_IFSR_P8_BIT 8
#define PIOC_IFSR_P9_MASK 0x200
#define PIOC_IFSR_P9 0x200
#define PIOC_IFSR_P9_BIT 9
#define PIOC_IFSR_P10_MASK 0x400
#define PIOC_IFSR_P10 0x400
#define PIOC_IFSR_P10_BIT 10
#define PIOC_IFSR_P11_MASK 0x800
#define PIOC_IFSR_P11 0x800
#define PIOC_IFSR_P11_BIT 11
#define PIOC_IFSR_P12_MASK 0x1000
#define PIOC_IFSR_P12 0x1000
#define PIOC_IFSR_P12_BIT 12
#define PIOC_IFSR_P13_MASK 0x2000
#define PIOC_IFSR_P13 0x2000
#define PIOC_IFSR_P13_BIT 13
#define PIOC_IFSR_P14_MASK 0x4000
#define PIOC_IFSR_P14 0x4000
#define PIOC_IFSR_P14_BIT 14
#define PIOC_IFSR_P15_MASK 0x8000
#define PIOC_IFSR_P15 0x8000
#define PIOC_IFSR_P15_BIT 15
#define PIOC_IFSR_P16_MASK 0x10000
#define PIOC_IFSR_P16 0x10000
#define PIOC_IFSR_P16_BIT 16
#define PIOC_IFSR_P17_MASK 0x20000
#define PIOC_IFSR_P17 0x20000
#define PIOC_IFSR_P17_BIT 17
#define PIOC_IFSR_P18_MASK 0x40000
#define PIOC_IFSR_P18 0x40000
#define PIOC_IFSR_P18_BIT 18
#define PIOC_IFSR_P19_MASK 0x80000
#define PIOC_IFSR_P19 0x80000
#define PIOC_IFSR_P19_BIT 19
#define PIOC_IFSR_P20_MASK 0x100000
#define PIOC_IFSR_P20 0x100000
#define PIOC_IFSR_P20_BIT 20
#define PIOC_IFSR_P21_MASK 0x200000
#define PIOC_IFSR_P21 0x200000
#define PIOC_IFSR_P21_BIT 21
#define PIOC_IFSR_P22_MASK 0x400000
#define PIOC_IFSR_P22 0x400000
#define PIOC_IFSR_P22_BIT 22
#define PIOC_IFSR_P23_MASK 0x800000
#define PIOC_IFSR_P23 0x800000
#define PIOC_IFSR_P23_BIT 23
#define PIOC_IFSR_P24_MASK 0x1000000
#define PIOC_IFSR_P24 0x1000000
#define PIOC_IFSR_P24_BIT 24
#define PIOC_IFSR_P25_MASK 0x2000000
#define PIOC_IFSR_P25 0x2000000
#define PIOC_IFSR_P25_BIT 25
#define PIOC_IFSR_P26_MASK 0x4000000
#define PIOC_IFSR_P26 0x4000000
#define PIOC_IFSR_P26_BIT 26
#define PIOC_IFSR_P27_MASK 0x8000000
#define PIOC_IFSR_P27 0x8000000
#define PIOC_IFSR_P27_BIT 27
#define PIOC_IFSR_P28_MASK 0x10000000
#define PIOC_IFSR_P28 0x10000000
#define PIOC_IFSR_P28_BIT 28
#define PIOC_IFSR_P29_MASK 0x20000000
#define PIOC_IFSR_P29 0x20000000
#define PIOC_IFSR_P29_BIT 29
#define PIOC_IFSR_P30_MASK 0x40000000
#define PIOC_IFSR_P30 0x40000000
#define PIOC_IFSR_P30_BIT 30
#define PIOC_IFSR_P31_MASK 0x80000000
#define PIOC_IFSR_P31 0x80000000
#define PIOC_IFSR_P31_BIT 31

#define PIOC_SODR (*(volatile unsigned long *)0xFFFFF830)
#define PIOC_SODR_OFFSET 0x30
#define PIOC_SODR_P0_MASK 0x1
#define PIOC_SODR_P0 0x1
#define PIOC_SODR_P0_BIT 0
#define PIOC_SODR_P1_MASK 0x2
#define PIOC_SODR_P1 0x2
#define PIOC_SODR_P1_BIT 1
#define PIOC_SODR_P2_MASK 0x4
#define PIOC_SODR_P2 0x4
#define PIOC_SODR_P2_BIT 2
#define PIOC_SODR_P3_MASK 0x8
#define PIOC_SODR_P3 0x8
#define PIOC_SODR_P3_BIT 3
#define PIOC_SODR_P4_MASK 0x10
#define PIOC_SODR_P4 0x10
#define PIOC_SODR_P4_BIT 4
#define PIOC_SODR_P5_MASK 0x20
#define PIOC_SODR_P5 0x20
#define PIOC_SODR_P5_BIT 5
#define PIOC_SODR_P6_MASK 0x40
#define PIOC_SODR_P6 0x40
#define PIOC_SODR_P6_BIT 6
#define PIOC_SODR_P7_MASK 0x80
#define PIOC_SODR_P7 0x80
#define PIOC_SODR_P7_BIT 7
#define PIOC_SODR_P8_MASK 0x100
#define PIOC_SODR_P8 0x100
#define PIOC_SODR_P8_BIT 8
#define PIOC_SODR_P9_MASK 0x200
#define PIOC_SODR_P9 0x200
#define PIOC_SODR_P9_BIT 9
#define PIOC_SODR_P10_MASK 0x400
#define PIOC_SODR_P10 0x400
#define PIOC_SODR_P10_BIT 10
#define PIOC_SODR_P11_MASK 0x800
#define PIOC_SODR_P11 0x800
#define PIOC_SODR_P11_BIT 11
#define PIOC_SODR_P12_MASK 0x1000
#define PIOC_SODR_P12 0x1000
#define PIOC_SODR_P12_BIT 12
#define PIOC_SODR_P13_MASK 0x2000
#define PIOC_SODR_P13 0x2000
#define PIOC_SODR_P13_BIT 13
#define PIOC_SODR_P14_MASK 0x4000
#define PIOC_SODR_P14 0x4000
#define PIOC_SODR_P14_BIT 14
#define PIOC_SODR_P15_MASK 0x8000
#define PIOC_SODR_P15 0x8000
#define PIOC_SODR_P15_BIT 15
#define PIOC_SODR_P16_MASK 0x10000
#define PIOC_SODR_P16 0x10000
#define PIOC_SODR_P16_BIT 16
#define PIOC_SODR_P17_MASK 0x20000
#define PIOC_SODR_P17 0x20000
#define PIOC_SODR_P17_BIT 17
#define PIOC_SODR_P18_MASK 0x40000
#define PIOC_SODR_P18 0x40000
#define PIOC_SODR_P18_BIT 18
#define PIOC_SODR_P19_MASK 0x80000
#define PIOC_SODR_P19 0x80000
#define PIOC_SODR_P19_BIT 19
#define PIOC_SODR_P20_MASK 0x100000
#define PIOC_SODR_P20 0x100000
#define PIOC_SODR_P20_BIT 20
#define PIOC_SODR_P21_MASK 0x200000
#define PIOC_SODR_P21 0x200000
#define PIOC_SODR_P21_BIT 21
#define PIOC_SODR_P22_MASK 0x400000
#define PIOC_SODR_P22 0x400000
#define PIOC_SODR_P22_BIT 22
#define PIOC_SODR_P23_MASK 0x800000
#define PIOC_SODR_P23 0x800000
#define PIOC_SODR_P23_BIT 23
#define PIOC_SODR_P24_MASK 0x1000000
#define PIOC_SODR_P24 0x1000000
#define PIOC_SODR_P24_BIT 24
#define PIOC_SODR_P25_MASK 0x2000000
#define PIOC_SODR_P25 0x2000000
#define PIOC_SODR_P25_BIT 25
#define PIOC_SODR_P26_MASK 0x4000000
#define PIOC_SODR_P26 0x4000000
#define PIOC_SODR_P26_BIT 26
#define PIOC_SODR_P27_MASK 0x8000000
#define PIOC_SODR_P27 0x8000000
#define PIOC_SODR_P27_BIT 27
#define PIOC_SODR_P28_MASK 0x10000000
#define PIOC_SODR_P28 0x10000000
#define PIOC_SODR_P28_BIT 28
#define PIOC_SODR_P29_MASK 0x20000000
#define PIOC_SODR_P29 0x20000000
#define PIOC_SODR_P29_BIT 29
#define PIOC_SODR_P30_MASK 0x40000000
#define PIOC_SODR_P30 0x40000000
#define PIOC_SODR_P30_BIT 30
#define PIOC_SODR_P31_MASK 0x80000000
#define PIOC_SODR_P31 0x80000000
#define PIOC_SODR_P31_BIT 31

#define PIOC_CODR (*(volatile unsigned long *)0xFFFFF834)
#define PIOC_CODR_OFFSET 0x34
#define PIOC_CODR_P0_MASK 0x1
#define PIOC_CODR_P0 0x1
#define PIOC_CODR_P0_BIT 0
#define PIOC_CODR_P1_MASK 0x2
#define PIOC_CODR_P1 0x2
#define PIOC_CODR_P1_BIT 1
#define PIOC_CODR_P2_MASK 0x4
#define PIOC_CODR_P2 0x4
#define PIOC_CODR_P2_BIT 2
#define PIOC_CODR_P3_MASK 0x8
#define PIOC_CODR_P3 0x8
#define PIOC_CODR_P3_BIT 3
#define PIOC_CODR_P4_MASK 0x10
#define PIOC_CODR_P4 0x10
#define PIOC_CODR_P4_BIT 4
#define PIOC_CODR_P5_MASK 0x20
#define PIOC_CODR_P5 0x20
#define PIOC_CODR_P5_BIT 5
#define PIOC_CODR_P6_MASK 0x40
#define PIOC_CODR_P6 0x40
#define PIOC_CODR_P6_BIT 6
#define PIOC_CODR_P7_MASK 0x80
#define PIOC_CODR_P7 0x80
#define PIOC_CODR_P7_BIT 7
#define PIOC_CODR_P8_MASK 0x100
#define PIOC_CODR_P8 0x100
#define PIOC_CODR_P8_BIT 8
#define PIOC_CODR_P9_MASK 0x200
#define PIOC_CODR_P9 0x200
#define PIOC_CODR_P9_BIT 9
#define PIOC_CODR_P10_MASK 0x400
#define PIOC_CODR_P10 0x400
#define PIOC_CODR_P10_BIT 10
#define PIOC_CODR_P11_MASK 0x800
#define PIOC_CODR_P11 0x800
#define PIOC_CODR_P11_BIT 11
#define PIOC_CODR_P12_MASK 0x1000
#define PIOC_CODR_P12 0x1000
#define PIOC_CODR_P12_BIT 12
#define PIOC_CODR_P13_MASK 0x2000
#define PIOC_CODR_P13 0x2000
#define PIOC_CODR_P13_BIT 13
#define PIOC_CODR_P14_MASK 0x4000
#define PIOC_CODR_P14 0x4000
#define PIOC_CODR_P14_BIT 14
#define PIOC_CODR_P15_MASK 0x8000
#define PIOC_CODR_P15 0x8000
#define PIOC_CODR_P15_BIT 15
#define PIOC_CODR_P16_MASK 0x10000
#define PIOC_CODR_P16 0x10000
#define PIOC_CODR_P16_BIT 16
#define PIOC_CODR_P17_MASK 0x20000
#define PIOC_CODR_P17 0x20000
#define PIOC_CODR_P17_BIT 17
#define PIOC_CODR_P18_MASK 0x40000
#define PIOC_CODR_P18 0x40000
#define PIOC_CODR_P18_BIT 18
#define PIOC_CODR_P19_MASK 0x80000
#define PIOC_CODR_P19 0x80000
#define PIOC_CODR_P19_BIT 19
#define PIOC_CODR_P20_MASK 0x100000
#define PIOC_CODR_P20 0x100000
#define PIOC_CODR_P20_BIT 20
#define PIOC_CODR_P21_MASK 0x200000
#define PIOC_CODR_P21 0x200000
#define PIOC_CODR_P21_BIT 21
#define PIOC_CODR_P22_MASK 0x400000
#define PIOC_CODR_P22 0x400000
#define PIOC_CODR_P22_BIT 22
#define PIOC_CODR_P23_MASK 0x800000
#define PIOC_CODR_P23 0x800000
#define PIOC_CODR_P23_BIT 23
#define PIOC_CODR_P24_MASK 0x1000000
#define PIOC_CODR_P24 0x1000000
#define PIOC_CODR_P24_BIT 24
#define PIOC_CODR_P25_MASK 0x2000000
#define PIOC_CODR_P25 0x2000000
#define PIOC_CODR_P25_BIT 25
#define PIOC_CODR_P26_MASK 0x4000000
#define PIOC_CODR_P26 0x4000000
#define PIOC_CODR_P26_BIT 26
#define PIOC_CODR_P27_MASK 0x8000000
#define PIOC_CODR_P27 0x8000000
#define PIOC_CODR_P27_BIT 27
#define PIOC_CODR_P28_MASK 0x10000000
#define PIOC_CODR_P28 0x10000000
#define PIOC_CODR_P28_BIT 28
#define PIOC_CODR_P29_MASK 0x20000000
#define PIOC_CODR_P29 0x20000000
#define PIOC_CODR_P29_BIT 29
#define PIOC_CODR_P30_MASK 0x40000000
#define PIOC_CODR_P30 0x40000000
#define PIOC_CODR_P30_BIT 30
#define PIOC_CODR_P31_MASK 0x80000000
#define PIOC_CODR_P31 0x80000000
#define PIOC_CODR_P31_BIT 31

#define PIOC_ODSR (*(volatile unsigned long *)0xFFFFF838)
#define PIOC_ODSR_OFFSET 0x38
#define PIOC_ODSR_P0_MASK 0x1
#define PIOC_ODSR_P0 0x1
#define PIOC_ODSR_P0_BIT 0
#define PIOC_ODSR_P1_MASK 0x2
#define PIOC_ODSR_P1 0x2
#define PIOC_ODSR_P1_BIT 1
#define PIOC_ODSR_P2_MASK 0x4
#define PIOC_ODSR_P2 0x4
#define PIOC_ODSR_P2_BIT 2
#define PIOC_ODSR_P3_MASK 0x8
#define PIOC_ODSR_P3 0x8
#define PIOC_ODSR_P3_BIT 3
#define PIOC_ODSR_P4_MASK 0x10
#define PIOC_ODSR_P4 0x10
#define PIOC_ODSR_P4_BIT 4
#define PIOC_ODSR_P5_MASK 0x20
#define PIOC_ODSR_P5 0x20
#define PIOC_ODSR_P5_BIT 5
#define PIOC_ODSR_P6_MASK 0x40
#define PIOC_ODSR_P6 0x40
#define PIOC_ODSR_P6_BIT 6
#define PIOC_ODSR_P7_MASK 0x80
#define PIOC_ODSR_P7 0x80
#define PIOC_ODSR_P7_BIT 7
#define PIOC_ODSR_P8_MASK 0x100
#define PIOC_ODSR_P8 0x100
#define PIOC_ODSR_P8_BIT 8
#define PIOC_ODSR_P9_MASK 0x200
#define PIOC_ODSR_P9 0x200
#define PIOC_ODSR_P9_BIT 9
#define PIOC_ODSR_P10_MASK 0x400
#define PIOC_ODSR_P10 0x400
#define PIOC_ODSR_P10_BIT 10
#define PIOC_ODSR_P11_MASK 0x800
#define PIOC_ODSR_P11 0x800
#define PIOC_ODSR_P11_BIT 11
#define PIOC_ODSR_P12_MASK 0x1000
#define PIOC_ODSR_P12 0x1000
#define PIOC_ODSR_P12_BIT 12
#define PIOC_ODSR_P13_MASK 0x2000
#define PIOC_ODSR_P13 0x2000
#define PIOC_ODSR_P13_BIT 13
#define PIOC_ODSR_P14_MASK 0x4000
#define PIOC_ODSR_P14 0x4000
#define PIOC_ODSR_P14_BIT 14
#define PIOC_ODSR_P15_MASK 0x8000
#define PIOC_ODSR_P15 0x8000
#define PIOC_ODSR_P15_BIT 15
#define PIOC_ODSR_P16_MASK 0x10000
#define PIOC_ODSR_P16 0x10000
#define PIOC_ODSR_P16_BIT 16
#define PIOC_ODSR_P17_MASK 0x20000
#define PIOC_ODSR_P17 0x20000
#define PIOC_ODSR_P17_BIT 17
#define PIOC_ODSR_P18_MASK 0x40000
#define PIOC_ODSR_P18 0x40000
#define PIOC_ODSR_P18_BIT 18
#define PIOC_ODSR_P19_MASK 0x80000
#define PIOC_ODSR_P19 0x80000
#define PIOC_ODSR_P19_BIT 19
#define PIOC_ODSR_P20_MASK 0x100000
#define PIOC_ODSR_P20 0x100000
#define PIOC_ODSR_P20_BIT 20
#define PIOC_ODSR_P21_MASK 0x200000
#define PIOC_ODSR_P21 0x200000
#define PIOC_ODSR_P21_BIT 21
#define PIOC_ODSR_P22_MASK 0x400000
#define PIOC_ODSR_P22 0x400000
#define PIOC_ODSR_P22_BIT 22
#define PIOC_ODSR_P23_MASK 0x800000
#define PIOC_ODSR_P23 0x800000
#define PIOC_ODSR_P23_BIT 23
#define PIOC_ODSR_P24_MASK 0x1000000
#define PIOC_ODSR_P24 0x1000000
#define PIOC_ODSR_P24_BIT 24
#define PIOC_ODSR_P25_MASK 0x2000000
#define PIOC_ODSR_P25 0x2000000
#define PIOC_ODSR_P25_BIT 25
#define PIOC_ODSR_P26_MASK 0x4000000
#define PIOC_ODSR_P26 0x4000000
#define PIOC_ODSR_P26_BIT 26
#define PIOC_ODSR_P27_MASK 0x8000000
#define PIOC_ODSR_P27 0x8000000
#define PIOC_ODSR_P27_BIT 27
#define PIOC_ODSR_P28_MASK 0x10000000
#define PIOC_ODSR_P28 0x10000000
#define PIOC_ODSR_P28_BIT 28
#define PIOC_ODSR_P29_MASK 0x20000000
#define PIOC_ODSR_P29 0x20000000
#define PIOC_ODSR_P29_BIT 29
#define PIOC_ODSR_P30_MASK 0x40000000
#define PIOC_ODSR_P30 0x40000000
#define PIOC_ODSR_P30_BIT 30
#define PIOC_ODSR_P31_MASK 0x80000000
#define PIOC_ODSR_P31 0x80000000
#define PIOC_ODSR_P31_BIT 31

#define PIOC_PDSR (*(volatile unsigned long *)0xFFFFF83C)
#define PIOC_PDSR_OFFSET 0x3C
#define PIOC_PDSR_P0_MASK 0x1
#define PIOC_PDSR_P0 0x1
#define PIOC_PDSR_P0_BIT 0
#define PIOC_PDSR_P1_MASK 0x2
#define PIOC_PDSR_P1 0x2
#define PIOC_PDSR_P1_BIT 1
#define PIOC_PDSR_P2_MASK 0x4
#define PIOC_PDSR_P2 0x4
#define PIOC_PDSR_P2_BIT 2
#define PIOC_PDSR_P3_MASK 0x8
#define PIOC_PDSR_P3 0x8
#define PIOC_PDSR_P3_BIT 3
#define PIOC_PDSR_P4_MASK 0x10
#define PIOC_PDSR_P4 0x10
#define PIOC_PDSR_P4_BIT 4
#define PIOC_PDSR_P5_MASK 0x20
#define PIOC_PDSR_P5 0x20
#define PIOC_PDSR_P5_BIT 5
#define PIOC_PDSR_P6_MASK 0x40
#define PIOC_PDSR_P6 0x40
#define PIOC_PDSR_P6_BIT 6
#define PIOC_PDSR_P7_MASK 0x80
#define PIOC_PDSR_P7 0x80
#define PIOC_PDSR_P7_BIT 7
#define PIOC_PDSR_P8_MASK 0x100
#define PIOC_PDSR_P8 0x100
#define PIOC_PDSR_P8_BIT 8
#define PIOC_PDSR_P9_MASK 0x200
#define PIOC_PDSR_P9 0x200
#define PIOC_PDSR_P9_BIT 9
#define PIOC_PDSR_P10_MASK 0x400
#define PIOC_PDSR_P10 0x400
#define PIOC_PDSR_P10_BIT 10
#define PIOC_PDSR_P11_MASK 0x800
#define PIOC_PDSR_P11 0x800
#define PIOC_PDSR_P11_BIT 11
#define PIOC_PDSR_P12_MASK 0x1000
#define PIOC_PDSR_P12 0x1000
#define PIOC_PDSR_P12_BIT 12
#define PIOC_PDSR_P13_MASK 0x2000
#define PIOC_PDSR_P13 0x2000
#define PIOC_PDSR_P13_BIT 13
#define PIOC_PDSR_P14_MASK 0x4000
#define PIOC_PDSR_P14 0x4000
#define PIOC_PDSR_P14_BIT 14
#define PIOC_PDSR_P15_MASK 0x8000
#define PIOC_PDSR_P15 0x8000
#define PIOC_PDSR_P15_BIT 15
#define PIOC_PDSR_P16_MASK 0x10000
#define PIOC_PDSR_P16 0x10000
#define PIOC_PDSR_P16_BIT 16
#define PIOC_PDSR_P17_MASK 0x20000
#define PIOC_PDSR_P17 0x20000
#define PIOC_PDSR_P17_BIT 17
#define PIOC_PDSR_P18_MASK 0x40000
#define PIOC_PDSR_P18 0x40000
#define PIOC_PDSR_P18_BIT 18
#define PIOC_PDSR_P19_MASK 0x80000
#define PIOC_PDSR_P19 0x80000
#define PIOC_PDSR_P19_BIT 19
#define PIOC_PDSR_P20_MASK 0x100000
#define PIOC_PDSR_P20 0x100000
#define PIOC_PDSR_P20_BIT 20
#define PIOC_PDSR_P21_MASK 0x200000
#define PIOC_PDSR_P21 0x200000
#define PIOC_PDSR_P21_BIT 21
#define PIOC_PDSR_P22_MASK 0x400000
#define PIOC_PDSR_P22 0x400000
#define PIOC_PDSR_P22_BIT 22
#define PIOC_PDSR_P23_MASK 0x800000
#define PIOC_PDSR_P23 0x800000
#define PIOC_PDSR_P23_BIT 23
#define PIOC_PDSR_P24_MASK 0x1000000
#define PIOC_PDSR_P24 0x1000000
#define PIOC_PDSR_P24_BIT 24
#define PIOC_PDSR_P25_MASK 0x2000000
#define PIOC_PDSR_P25 0x2000000
#define PIOC_PDSR_P25_BIT 25
#define PIOC_PDSR_P26_MASK 0x4000000
#define PIOC_PDSR_P26 0x4000000
#define PIOC_PDSR_P26_BIT 26
#define PIOC_PDSR_P27_MASK 0x8000000
#define PIOC_PDSR_P27 0x8000000
#define PIOC_PDSR_P27_BIT 27
#define PIOC_PDSR_P28_MASK 0x10000000
#define PIOC_PDSR_P28 0x10000000
#define PIOC_PDSR_P28_BIT 28
#define PIOC_PDSR_P29_MASK 0x20000000
#define PIOC_PDSR_P29 0x20000000
#define PIOC_PDSR_P29_BIT 29
#define PIOC_PDSR_P30_MASK 0x40000000
#define PIOC_PDSR_P30 0x40000000
#define PIOC_PDSR_P30_BIT 30
#define PIOC_PDSR_P31_MASK 0x80000000
#define PIOC_PDSR_P31 0x80000000
#define PIOC_PDSR_P31_BIT 31

#define PIOC_IER (*(volatile unsigned long *)0xFFFFF840)
#define PIOC_IER_OFFSET 0x40
#define PIOC_IER_P0_MASK 0x1
#define PIOC_IER_P0 0x1
#define PIOC_IER_P0_BIT 0
#define PIOC_IER_P1_MASK 0x2
#define PIOC_IER_P1 0x2
#define PIOC_IER_P1_BIT 1
#define PIOC_IER_P2_MASK 0x4
#define PIOC_IER_P2 0x4
#define PIOC_IER_P2_BIT 2
#define PIOC_IER_P3_MASK 0x8
#define PIOC_IER_P3 0x8
#define PIOC_IER_P3_BIT 3
#define PIOC_IER_P4_MASK 0x10
#define PIOC_IER_P4 0x10
#define PIOC_IER_P4_BIT 4
#define PIOC_IER_P5_MASK 0x20
#define PIOC_IER_P5 0x20
#define PIOC_IER_P5_BIT 5
#define PIOC_IER_P6_MASK 0x40
#define PIOC_IER_P6 0x40
#define PIOC_IER_P6_BIT 6
#define PIOC_IER_P7_MASK 0x80
#define PIOC_IER_P7 0x80
#define PIOC_IER_P7_BIT 7
#define PIOC_IER_P8_MASK 0x100
#define PIOC_IER_P8 0x100
#define PIOC_IER_P8_BIT 8
#define PIOC_IER_P9_MASK 0x200
#define PIOC_IER_P9 0x200
#define PIOC_IER_P9_BIT 9
#define PIOC_IER_P10_MASK 0x400
#define PIOC_IER_P10 0x400
#define PIOC_IER_P10_BIT 10
#define PIOC_IER_P11_MASK 0x800
#define PIOC_IER_P11 0x800
#define PIOC_IER_P11_BIT 11
#define PIOC_IER_P12_MASK 0x1000
#define PIOC_IER_P12 0x1000
#define PIOC_IER_P12_BIT 12
#define PIOC_IER_P13_MASK 0x2000
#define PIOC_IER_P13 0x2000
#define PIOC_IER_P13_BIT 13
#define PIOC_IER_P14_MASK 0x4000
#define PIOC_IER_P14 0x4000
#define PIOC_IER_P14_BIT 14
#define PIOC_IER_P15_MASK 0x8000
#define PIOC_IER_P15 0x8000
#define PIOC_IER_P15_BIT 15
#define PIOC_IER_P16_MASK 0x10000
#define PIOC_IER_P16 0x10000
#define PIOC_IER_P16_BIT 16
#define PIOC_IER_P17_MASK 0x20000
#define PIOC_IER_P17 0x20000
#define PIOC_IER_P17_BIT 17
#define PIOC_IER_P18_MASK 0x40000
#define PIOC_IER_P18 0x40000
#define PIOC_IER_P18_BIT 18
#define PIOC_IER_P19_MASK 0x80000
#define PIOC_IER_P19 0x80000
#define PIOC_IER_P19_BIT 19
#define PIOC_IER_P20_MASK 0x100000
#define PIOC_IER_P20 0x100000
#define PIOC_IER_P20_BIT 20
#define PIOC_IER_P21_MASK 0x200000
#define PIOC_IER_P21 0x200000
#define PIOC_IER_P21_BIT 21
#define PIOC_IER_P22_MASK 0x400000
#define PIOC_IER_P22 0x400000
#define PIOC_IER_P22_BIT 22
#define PIOC_IER_P23_MASK 0x800000
#define PIOC_IER_P23 0x800000
#define PIOC_IER_P23_BIT 23
#define PIOC_IER_P24_MASK 0x1000000
#define PIOC_IER_P24 0x1000000
#define PIOC_IER_P24_BIT 24
#define PIOC_IER_P25_MASK 0x2000000
#define PIOC_IER_P25 0x2000000
#define PIOC_IER_P25_BIT 25
#define PIOC_IER_P26_MASK 0x4000000
#define PIOC_IER_P26 0x4000000
#define PIOC_IER_P26_BIT 26
#define PIOC_IER_P27_MASK 0x8000000
#define PIOC_IER_P27 0x8000000
#define PIOC_IER_P27_BIT 27
#define PIOC_IER_P28_MASK 0x10000000
#define PIOC_IER_P28 0x10000000
#define PIOC_IER_P28_BIT 28
#define PIOC_IER_P29_MASK 0x20000000
#define PIOC_IER_P29 0x20000000
#define PIOC_IER_P29_BIT 29
#define PIOC_IER_P30_MASK 0x40000000
#define PIOC_IER_P30 0x40000000
#define PIOC_IER_P30_BIT 30
#define PIOC_IER_P31_MASK 0x80000000
#define PIOC_IER_P31 0x80000000
#define PIOC_IER_P31_BIT 31

#define PIOC_IDR (*(volatile unsigned long *)0xFFFFF844)
#define PIOC_IDR_OFFSET 0x44
#define PIOC_IDR_P0_MASK 0x1
#define PIOC_IDR_P0 0x1
#define PIOC_IDR_P0_BIT 0
#define PIOC_IDR_P1_MASK 0x2
#define PIOC_IDR_P1 0x2
#define PIOC_IDR_P1_BIT 1
#define PIOC_IDR_P2_MASK 0x4
#define PIOC_IDR_P2 0x4
#define PIOC_IDR_P2_BIT 2
#define PIOC_IDR_P3_MASK 0x8
#define PIOC_IDR_P3 0x8
#define PIOC_IDR_P3_BIT 3
#define PIOC_IDR_P4_MASK 0x10
#define PIOC_IDR_P4 0x10
#define PIOC_IDR_P4_BIT 4
#define PIOC_IDR_P5_MASK 0x20
#define PIOC_IDR_P5 0x20
#define PIOC_IDR_P5_BIT 5
#define PIOC_IDR_P6_MASK 0x40
#define PIOC_IDR_P6 0x40
#define PIOC_IDR_P6_BIT 6
#define PIOC_IDR_P7_MASK 0x80
#define PIOC_IDR_P7 0x80
#define PIOC_IDR_P7_BIT 7
#define PIOC_IDR_P8_MASK 0x100
#define PIOC_IDR_P8 0x100
#define PIOC_IDR_P8_BIT 8
#define PIOC_IDR_P9_MASK 0x200
#define PIOC_IDR_P9 0x200
#define PIOC_IDR_P9_BIT 9
#define PIOC_IDR_P10_MASK 0x400
#define PIOC_IDR_P10 0x400
#define PIOC_IDR_P10_BIT 10
#define PIOC_IDR_P11_MASK 0x800
#define PIOC_IDR_P11 0x800
#define PIOC_IDR_P11_BIT 11
#define PIOC_IDR_P12_MASK 0x1000
#define PIOC_IDR_P12 0x1000
#define PIOC_IDR_P12_BIT 12
#define PIOC_IDR_P13_MASK 0x2000
#define PIOC_IDR_P13 0x2000
#define PIOC_IDR_P13_BIT 13
#define PIOC_IDR_P14_MASK 0x4000
#define PIOC_IDR_P14 0x4000
#define PIOC_IDR_P14_BIT 14
#define PIOC_IDR_P15_MASK 0x8000
#define PIOC_IDR_P15 0x8000
#define PIOC_IDR_P15_BIT 15
#define PIOC_IDR_P16_MASK 0x10000
#define PIOC_IDR_P16 0x10000
#define PIOC_IDR_P16_BIT 16
#define PIOC_IDR_P17_MASK 0x20000
#define PIOC_IDR_P17 0x20000
#define PIOC_IDR_P17_BIT 17
#define PIOC_IDR_P18_MASK 0x40000
#define PIOC_IDR_P18 0x40000
#define PIOC_IDR_P18_BIT 18
#define PIOC_IDR_P19_MASK 0x80000
#define PIOC_IDR_P19 0x80000
#define PIOC_IDR_P19_BIT 19
#define PIOC_IDR_P20_MASK 0x100000
#define PIOC_IDR_P20 0x100000
#define PIOC_IDR_P20_BIT 20
#define PIOC_IDR_P21_MASK 0x200000
#define PIOC_IDR_P21 0x200000
#define PIOC_IDR_P21_BIT 21
#define PIOC_IDR_P22_MASK 0x400000
#define PIOC_IDR_P22 0x400000
#define PIOC_IDR_P22_BIT 22
#define PIOC_IDR_P23_MASK 0x800000
#define PIOC_IDR_P23 0x800000
#define PIOC_IDR_P23_BIT 23
#define PIOC_IDR_P24_MASK 0x1000000
#define PIOC_IDR_P24 0x1000000
#define PIOC_IDR_P24_BIT 24
#define PIOC_IDR_P25_MASK 0x2000000
#define PIOC_IDR_P25 0x2000000
#define PIOC_IDR_P25_BIT 25
#define PIOC_IDR_P26_MASK 0x4000000
#define PIOC_IDR_P26 0x4000000
#define PIOC_IDR_P26_BIT 26
#define PIOC_IDR_P27_MASK 0x8000000
#define PIOC_IDR_P27 0x8000000
#define PIOC_IDR_P27_BIT 27
#define PIOC_IDR_P28_MASK 0x10000000
#define PIOC_IDR_P28 0x10000000
#define PIOC_IDR_P28_BIT 28
#define PIOC_IDR_P29_MASK 0x20000000
#define PIOC_IDR_P29 0x20000000
#define PIOC_IDR_P29_BIT 29
#define PIOC_IDR_P30_MASK 0x40000000
#define PIOC_IDR_P30 0x40000000
#define PIOC_IDR_P30_BIT 30
#define PIOC_IDR_P31_MASK 0x80000000
#define PIOC_IDR_P31 0x80000000
#define PIOC_IDR_P31_BIT 31

#define PIOC_IMR (*(volatile unsigned long *)0xFFFFF848)
#define PIOC_IMR_OFFSET 0x48
#define PIOC_IMR_P0_MASK 0x1
#define PIOC_IMR_P0 0x1
#define PIOC_IMR_P0_BIT 0
#define PIOC_IMR_P1_MASK 0x2
#define PIOC_IMR_P1 0x2
#define PIOC_IMR_P1_BIT 1
#define PIOC_IMR_P2_MASK 0x4
#define PIOC_IMR_P2 0x4
#define PIOC_IMR_P2_BIT 2
#define PIOC_IMR_P3_MASK 0x8
#define PIOC_IMR_P3 0x8
#define PIOC_IMR_P3_BIT 3
#define PIOC_IMR_P4_MASK 0x10
#define PIOC_IMR_P4 0x10
#define PIOC_IMR_P4_BIT 4
#define PIOC_IMR_P5_MASK 0x20
#define PIOC_IMR_P5 0x20
#define PIOC_IMR_P5_BIT 5
#define PIOC_IMR_P6_MASK 0x40
#define PIOC_IMR_P6 0x40
#define PIOC_IMR_P6_BIT 6
#define PIOC_IMR_P7_MASK 0x80
#define PIOC_IMR_P7 0x80
#define PIOC_IMR_P7_BIT 7
#define PIOC_IMR_P8_MASK 0x100
#define PIOC_IMR_P8 0x100
#define PIOC_IMR_P8_BIT 8
#define PIOC_IMR_P9_MASK 0x200
#define PIOC_IMR_P9 0x200
#define PIOC_IMR_P9_BIT 9
#define PIOC_IMR_P10_MASK 0x400
#define PIOC_IMR_P10 0x400
#define PIOC_IMR_P10_BIT 10
#define PIOC_IMR_P11_MASK 0x800
#define PIOC_IMR_P11 0x800
#define PIOC_IMR_P11_BIT 11
#define PIOC_IMR_P12_MASK 0x1000
#define PIOC_IMR_P12 0x1000
#define PIOC_IMR_P12_BIT 12
#define PIOC_IMR_P13_MASK 0x2000
#define PIOC_IMR_P13 0x2000
#define PIOC_IMR_P13_BIT 13
#define PIOC_IMR_P14_MASK 0x4000
#define PIOC_IMR_P14 0x4000
#define PIOC_IMR_P14_BIT 14
#define PIOC_IMR_P15_MASK 0x8000
#define PIOC_IMR_P15 0x8000
#define PIOC_IMR_P15_BIT 15
#define PIOC_IMR_P16_MASK 0x10000
#define PIOC_IMR_P16 0x10000
#define PIOC_IMR_P16_BIT 16
#define PIOC_IMR_P17_MASK 0x20000
#define PIOC_IMR_P17 0x20000
#define PIOC_IMR_P17_BIT 17
#define PIOC_IMR_P18_MASK 0x40000
#define PIOC_IMR_P18 0x40000
#define PIOC_IMR_P18_BIT 18
#define PIOC_IMR_P19_MASK 0x80000
#define PIOC_IMR_P19 0x80000
#define PIOC_IMR_P19_BIT 19
#define PIOC_IMR_P20_MASK 0x100000
#define PIOC_IMR_P20 0x100000
#define PIOC_IMR_P20_BIT 20
#define PIOC_IMR_P21_MASK 0x200000
#define PIOC_IMR_P21 0x200000
#define PIOC_IMR_P21_BIT 21
#define PIOC_IMR_P22_MASK 0x400000
#define PIOC_IMR_P22 0x400000
#define PIOC_IMR_P22_BIT 22
#define PIOC_IMR_P23_MASK 0x800000
#define PIOC_IMR_P23 0x800000
#define PIOC_IMR_P23_BIT 23
#define PIOC_IMR_P24_MASK 0x1000000
#define PIOC_IMR_P24 0x1000000
#define PIOC_IMR_P24_BIT 24
#define PIOC_IMR_P25_MASK 0x2000000
#define PIOC_IMR_P25 0x2000000
#define PIOC_IMR_P25_BIT 25
#define PIOC_IMR_P26_MASK 0x4000000
#define PIOC_IMR_P26 0x4000000
#define PIOC_IMR_P26_BIT 26
#define PIOC_IMR_P27_MASK 0x8000000
#define PIOC_IMR_P27 0x8000000
#define PIOC_IMR_P27_BIT 27
#define PIOC_IMR_P28_MASK 0x10000000
#define PIOC_IMR_P28 0x10000000
#define PIOC_IMR_P28_BIT 28
#define PIOC_IMR_P29_MASK 0x20000000
#define PIOC_IMR_P29 0x20000000
#define PIOC_IMR_P29_BIT 29
#define PIOC_IMR_P30_MASK 0x40000000
#define PIOC_IMR_P30 0x40000000
#define PIOC_IMR_P30_BIT 30
#define PIOC_IMR_P31_MASK 0x80000000
#define PIOC_IMR_P31 0x80000000
#define PIOC_IMR_P31_BIT 31

#define PIOC_ISR (*(volatile unsigned long *)0xFFFFF84C)
#define PIOC_ISR_OFFSET 0x4C
#define PIOC_ISR_P0_MASK 0x1
#define PIOC_ISR_P0 0x1
#define PIOC_ISR_P0_BIT 0
#define PIOC_ISR_P1_MASK 0x2
#define PIOC_ISR_P1 0x2
#define PIOC_ISR_P1_BIT 1
#define PIOC_ISR_P2_MASK 0x4
#define PIOC_ISR_P2 0x4
#define PIOC_ISR_P2_BIT 2
#define PIOC_ISR_P3_MASK 0x8
#define PIOC_ISR_P3 0x8
#define PIOC_ISR_P3_BIT 3
#define PIOC_ISR_P4_MASK 0x10
#define PIOC_ISR_P4 0x10
#define PIOC_ISR_P4_BIT 4
#define PIOC_ISR_P5_MASK 0x20
#define PIOC_ISR_P5 0x20
#define PIOC_ISR_P5_BIT 5
#define PIOC_ISR_P6_MASK 0x40
#define PIOC_ISR_P6 0x40
#define PIOC_ISR_P6_BIT 6
#define PIOC_ISR_P7_MASK 0x80
#define PIOC_ISR_P7 0x80
#define PIOC_ISR_P7_BIT 7
#define PIOC_ISR_P8_MASK 0x100
#define PIOC_ISR_P8 0x100
#define PIOC_ISR_P8_BIT 8
#define PIOC_ISR_P9_MASK 0x200
#define PIOC_ISR_P9 0x200
#define PIOC_ISR_P9_BIT 9
#define PIOC_ISR_P10_MASK 0x400
#define PIOC_ISR_P10 0x400
#define PIOC_ISR_P10_BIT 10
#define PIOC_ISR_P11_MASK 0x800
#define PIOC_ISR_P11 0x800
#define PIOC_ISR_P11_BIT 11
#define PIOC_ISR_P12_MASK 0x1000
#define PIOC_ISR_P12 0x1000
#define PIOC_ISR_P12_BIT 12
#define PIOC_ISR_P13_MASK 0x2000
#define PIOC_ISR_P13 0x2000
#define PIOC_ISR_P13_BIT 13
#define PIOC_ISR_P14_MASK 0x4000
#define PIOC_ISR_P14 0x4000
#define PIOC_ISR_P14_BIT 14
#define PIOC_ISR_P15_MASK 0x8000
#define PIOC_ISR_P15 0x8000
#define PIOC_ISR_P15_BIT 15
#define PIOC_ISR_P16_MASK 0x10000
#define PIOC_ISR_P16 0x10000
#define PIOC_ISR_P16_BIT 16
#define PIOC_ISR_P17_MASK 0x20000
#define PIOC_ISR_P17 0x20000
#define PIOC_ISR_P17_BIT 17
#define PIOC_ISR_P18_MASK 0x40000
#define PIOC_ISR_P18 0x40000
#define PIOC_ISR_P18_BIT 18
#define PIOC_ISR_P19_MASK 0x80000
#define PIOC_ISR_P19 0x80000
#define PIOC_ISR_P19_BIT 19
#define PIOC_ISR_P20_MASK 0x100000
#define PIOC_ISR_P20 0x100000
#define PIOC_ISR_P20_BIT 20
#define PIOC_ISR_P21_MASK 0x200000
#define PIOC_ISR_P21 0x200000
#define PIOC_ISR_P21_BIT 21
#define PIOC_ISR_P22_MASK 0x400000
#define PIOC_ISR_P22 0x400000
#define PIOC_ISR_P22_BIT 22
#define PIOC_ISR_P23_MASK 0x800000
#define PIOC_ISR_P23 0x800000
#define PIOC_ISR_P23_BIT 23
#define PIOC_ISR_P24_MASK 0x1000000
#define PIOC_ISR_P24 0x1000000
#define PIOC_ISR_P24_BIT 24
#define PIOC_ISR_P25_MASK 0x2000000
#define PIOC_ISR_P25 0x2000000
#define PIOC_ISR_P25_BIT 25
#define PIOC_ISR_P26_MASK 0x4000000
#define PIOC_ISR_P26 0x4000000
#define PIOC_ISR_P26_BIT 26
#define PIOC_ISR_P27_MASK 0x8000000
#define PIOC_ISR_P27 0x8000000
#define PIOC_ISR_P27_BIT 27
#define PIOC_ISR_P28_MASK 0x10000000
#define PIOC_ISR_P28 0x10000000
#define PIOC_ISR_P28_BIT 28
#define PIOC_ISR_P29_MASK 0x20000000
#define PIOC_ISR_P29 0x20000000
#define PIOC_ISR_P29_BIT 29
#define PIOC_ISR_P30_MASK 0x40000000
#define PIOC_ISR_P30 0x40000000
#define PIOC_ISR_P30_BIT 30
#define PIOC_ISR_P31_MASK 0x80000000
#define PIOC_ISR_P31 0x80000000
#define PIOC_ISR_P31_BIT 31

#define PIOC_MDER (*(volatile unsigned long *)0xFFFFF850)
#define PIOC_MDER_OFFSET 0x50
#define PIOC_MDER_P0_MASK 0x1
#define PIOC_MDER_P0 0x1
#define PIOC_MDER_P0_BIT 0
#define PIOC_MDER_P1_MASK 0x2
#define PIOC_MDER_P1 0x2
#define PIOC_MDER_P1_BIT 1
#define PIOC_MDER_P2_MASK 0x4
#define PIOC_MDER_P2 0x4
#define PIOC_MDER_P2_BIT 2
#define PIOC_MDER_P3_MASK 0x8
#define PIOC_MDER_P3 0x8
#define PIOC_MDER_P3_BIT 3
#define PIOC_MDER_P4_MASK 0x10
#define PIOC_MDER_P4 0x10
#define PIOC_MDER_P4_BIT 4
#define PIOC_MDER_P5_MASK 0x20
#define PIOC_MDER_P5 0x20
#define PIOC_MDER_P5_BIT 5
#define PIOC_MDER_P6_MASK 0x40
#define PIOC_MDER_P6 0x40
#define PIOC_MDER_P6_BIT 6
#define PIOC_MDER_P7_MASK 0x80
#define PIOC_MDER_P7 0x80
#define PIOC_MDER_P7_BIT 7
#define PIOC_MDER_P8_MASK 0x100
#define PIOC_MDER_P8 0x100
#define PIOC_MDER_P8_BIT 8
#define PIOC_MDER_P9_MASK 0x200
#define PIOC_MDER_P9 0x200
#define PIOC_MDER_P9_BIT 9
#define PIOC_MDER_P10_MASK 0x400
#define PIOC_MDER_P10 0x400
#define PIOC_MDER_P10_BIT 10
#define PIOC_MDER_P11_MASK 0x800
#define PIOC_MDER_P11 0x800
#define PIOC_MDER_P11_BIT 11
#define PIOC_MDER_P12_MASK 0x1000
#define PIOC_MDER_P12 0x1000
#define PIOC_MDER_P12_BIT 12
#define PIOC_MDER_P13_MASK 0x2000
#define PIOC_MDER_P13 0x2000
#define PIOC_MDER_P13_BIT 13
#define PIOC_MDER_P14_MASK 0x4000
#define PIOC_MDER_P14 0x4000
#define PIOC_MDER_P14_BIT 14
#define PIOC_MDER_P15_MASK 0x8000
#define PIOC_MDER_P15 0x8000
#define PIOC_MDER_P15_BIT 15
#define PIOC_MDER_P16_MASK 0x10000
#define PIOC_MDER_P16 0x10000
#define PIOC_MDER_P16_BIT 16
#define PIOC_MDER_P17_MASK 0x20000
#define PIOC_MDER_P17 0x20000
#define PIOC_MDER_P17_BIT 17
#define PIOC_MDER_P18_MASK 0x40000
#define PIOC_MDER_P18 0x40000
#define PIOC_MDER_P18_BIT 18
#define PIOC_MDER_P19_MASK 0x80000
#define PIOC_MDER_P19 0x80000
#define PIOC_MDER_P19_BIT 19
#define PIOC_MDER_P20_MASK 0x100000
#define PIOC_MDER_P20 0x100000
#define PIOC_MDER_P20_BIT 20
#define PIOC_MDER_P21_MASK 0x200000
#define PIOC_MDER_P21 0x200000
#define PIOC_MDER_P21_BIT 21
#define PIOC_MDER_P22_MASK 0x400000
#define PIOC_MDER_P22 0x400000
#define PIOC_MDER_P22_BIT 22
#define PIOC_MDER_P23_MASK 0x800000
#define PIOC_MDER_P23 0x800000
#define PIOC_MDER_P23_BIT 23
#define PIOC_MDER_P24_MASK 0x1000000
#define PIOC_MDER_P24 0x1000000
#define PIOC_MDER_P24_BIT 24
#define PIOC_MDER_P25_MASK 0x2000000
#define PIOC_MDER_P25 0x2000000
#define PIOC_MDER_P25_BIT 25
#define PIOC_MDER_P26_MASK 0x4000000
#define PIOC_MDER_P26 0x4000000
#define PIOC_MDER_P26_BIT 26
#define PIOC_MDER_P27_MASK 0x8000000
#define PIOC_MDER_P27 0x8000000
#define PIOC_MDER_P27_BIT 27
#define PIOC_MDER_P28_MASK 0x10000000
#define PIOC_MDER_P28 0x10000000
#define PIOC_MDER_P28_BIT 28
#define PIOC_MDER_P29_MASK 0x20000000
#define PIOC_MDER_P29 0x20000000
#define PIOC_MDER_P29_BIT 29
#define PIOC_MDER_P30_MASK 0x40000000
#define PIOC_MDER_P30 0x40000000
#define PIOC_MDER_P30_BIT 30
#define PIOC_MDER_P31_MASK 0x80000000
#define PIOC_MDER_P31 0x80000000
#define PIOC_MDER_P31_BIT 31

#define PIOC_MDDR (*(volatile unsigned long *)0xFFFFF854)
#define PIOC_MDDR_OFFSET 0x54
#define PIOC_MDDR_P0_MASK 0x1
#define PIOC_MDDR_P0 0x1
#define PIOC_MDDR_P0_BIT 0
#define PIOC_MDDR_P1_MASK 0x2
#define PIOC_MDDR_P1 0x2
#define PIOC_MDDR_P1_BIT 1
#define PIOC_MDDR_P2_MASK 0x4
#define PIOC_MDDR_P2 0x4
#define PIOC_MDDR_P2_BIT 2
#define PIOC_MDDR_P3_MASK 0x8
#define PIOC_MDDR_P3 0x8
#define PIOC_MDDR_P3_BIT 3
#define PIOC_MDDR_P4_MASK 0x10
#define PIOC_MDDR_P4 0x10
#define PIOC_MDDR_P4_BIT 4
#define PIOC_MDDR_P5_MASK 0x20
#define PIOC_MDDR_P5 0x20
#define PIOC_MDDR_P5_BIT 5
#define PIOC_MDDR_P6_MASK 0x40
#define PIOC_MDDR_P6 0x40
#define PIOC_MDDR_P6_BIT 6
#define PIOC_MDDR_P7_MASK 0x80
#define PIOC_MDDR_P7 0x80
#define PIOC_MDDR_P7_BIT 7
#define PIOC_MDDR_P8_MASK 0x100
#define PIOC_MDDR_P8 0x100
#define PIOC_MDDR_P8_BIT 8
#define PIOC_MDDR_P9_MASK 0x200
#define PIOC_MDDR_P9 0x200
#define PIOC_MDDR_P9_BIT 9
#define PIOC_MDDR_P10_MASK 0x400
#define PIOC_MDDR_P10 0x400
#define PIOC_MDDR_P10_BIT 10
#define PIOC_MDDR_P11_MASK 0x800
#define PIOC_MDDR_P11 0x800
#define PIOC_MDDR_P11_BIT 11
#define PIOC_MDDR_P12_MASK 0x1000
#define PIOC_MDDR_P12 0x1000
#define PIOC_MDDR_P12_BIT 12
#define PIOC_MDDR_P13_MASK 0x2000
#define PIOC_MDDR_P13 0x2000
#define PIOC_MDDR_P13_BIT 13
#define PIOC_MDDR_P14_MASK 0x4000
#define PIOC_MDDR_P14 0x4000
#define PIOC_MDDR_P14_BIT 14
#define PIOC_MDDR_P15_MASK 0x8000
#define PIOC_MDDR_P15 0x8000
#define PIOC_MDDR_P15_BIT 15
#define PIOC_MDDR_P16_MASK 0x10000
#define PIOC_MDDR_P16 0x10000
#define PIOC_MDDR_P16_BIT 16
#define PIOC_MDDR_P17_MASK 0x20000
#define PIOC_MDDR_P17 0x20000
#define PIOC_MDDR_P17_BIT 17
#define PIOC_MDDR_P18_MASK 0x40000
#define PIOC_MDDR_P18 0x40000
#define PIOC_MDDR_P18_BIT 18
#define PIOC_MDDR_P19_MASK 0x80000
#define PIOC_MDDR_P19 0x80000
#define PIOC_MDDR_P19_BIT 19
#define PIOC_MDDR_P20_MASK 0x100000
#define PIOC_MDDR_P20 0x100000
#define PIOC_MDDR_P20_BIT 20
#define PIOC_MDDR_P21_MASK 0x200000
#define PIOC_MDDR_P21 0x200000
#define PIOC_MDDR_P21_BIT 21
#define PIOC_MDDR_P22_MASK 0x400000
#define PIOC_MDDR_P22 0x400000
#define PIOC_MDDR_P22_BIT 22
#define PIOC_MDDR_P23_MASK 0x800000
#define PIOC_MDDR_P23 0x800000
#define PIOC_MDDR_P23_BIT 23
#define PIOC_MDDR_P24_MASK 0x1000000
#define PIOC_MDDR_P24 0x1000000
#define PIOC_MDDR_P24_BIT 24
#define PIOC_MDDR_P25_MASK 0x2000000
#define PIOC_MDDR_P25 0x2000000
#define PIOC_MDDR_P25_BIT 25
#define PIOC_MDDR_P26_MASK 0x4000000
#define PIOC_MDDR_P26 0x4000000
#define PIOC_MDDR_P26_BIT 26
#define PIOC_MDDR_P27_MASK 0x8000000
#define PIOC_MDDR_P27 0x8000000
#define PIOC_MDDR_P27_BIT 27
#define PIOC_MDDR_P28_MASK 0x10000000
#define PIOC_MDDR_P28 0x10000000
#define PIOC_MDDR_P28_BIT 28
#define PIOC_MDDR_P29_MASK 0x20000000
#define PIOC_MDDR_P29 0x20000000
#define PIOC_MDDR_P29_BIT 29
#define PIOC_MDDR_P30_MASK 0x40000000
#define PIOC_MDDR_P30 0x40000000
#define PIOC_MDDR_P30_BIT 30
#define PIOC_MDDR_P31_MASK 0x80000000
#define PIOC_MDDR_P31 0x80000000
#define PIOC_MDDR_P31_BIT 31

#define PIOC_MDSR (*(volatile unsigned long *)0xFFFFF858)
#define PIOC_MDSR_OFFSET 0x58
#define PIOC_MDSR_P0_MASK 0x1
#define PIOC_MDSR_P0 0x1
#define PIOC_MDSR_P0_BIT 0
#define PIOC_MDSR_P1_MASK 0x2
#define PIOC_MDSR_P1 0x2
#define PIOC_MDSR_P1_BIT 1
#define PIOC_MDSR_P2_MASK 0x4
#define PIOC_MDSR_P2 0x4
#define PIOC_MDSR_P2_BIT 2
#define PIOC_MDSR_P3_MASK 0x8
#define PIOC_MDSR_P3 0x8
#define PIOC_MDSR_P3_BIT 3
#define PIOC_MDSR_P4_MASK 0x10
#define PIOC_MDSR_P4 0x10
#define PIOC_MDSR_P4_BIT 4
#define PIOC_MDSR_P5_MASK 0x20
#define PIOC_MDSR_P5 0x20
#define PIOC_MDSR_P5_BIT 5
#define PIOC_MDSR_P6_MASK 0x40
#define PIOC_MDSR_P6 0x40
#define PIOC_MDSR_P6_BIT 6
#define PIOC_MDSR_P7_MASK 0x80
#define PIOC_MDSR_P7 0x80
#define PIOC_MDSR_P7_BIT 7
#define PIOC_MDSR_P8_MASK 0x100
#define PIOC_MDSR_P8 0x100
#define PIOC_MDSR_P8_BIT 8
#define PIOC_MDSR_P9_MASK 0x200
#define PIOC_MDSR_P9 0x200
#define PIOC_MDSR_P9_BIT 9
#define PIOC_MDSR_P10_MASK 0x400
#define PIOC_MDSR_P10 0x400
#define PIOC_MDSR_P10_BIT 10
#define PIOC_MDSR_P11_MASK 0x800
#define PIOC_MDSR_P11 0x800
#define PIOC_MDSR_P11_BIT 11
#define PIOC_MDSR_P12_MASK 0x1000
#define PIOC_MDSR_P12 0x1000
#define PIOC_MDSR_P12_BIT 12
#define PIOC_MDSR_P13_MASK 0x2000
#define PIOC_MDSR_P13 0x2000
#define PIOC_MDSR_P13_BIT 13
#define PIOC_MDSR_P14_MASK 0x4000
#define PIOC_MDSR_P14 0x4000
#define PIOC_MDSR_P14_BIT 14
#define PIOC_MDSR_P15_MASK 0x8000
#define PIOC_MDSR_P15 0x8000
#define PIOC_MDSR_P15_BIT 15
#define PIOC_MDSR_P16_MASK 0x10000
#define PIOC_MDSR_P16 0x10000
#define PIOC_MDSR_P16_BIT 16
#define PIOC_MDSR_P17_MASK 0x20000
#define PIOC_MDSR_P17 0x20000
#define PIOC_MDSR_P17_BIT 17
#define PIOC_MDSR_P18_MASK 0x40000
#define PIOC_MDSR_P18 0x40000
#define PIOC_MDSR_P18_BIT 18
#define PIOC_MDSR_P19_MASK 0x80000
#define PIOC_MDSR_P19 0x80000
#define PIOC_MDSR_P19_BIT 19
#define PIOC_MDSR_P20_MASK 0x100000
#define PIOC_MDSR_P20 0x100000
#define PIOC_MDSR_P20_BIT 20
#define PIOC_MDSR_P21_MASK 0x200000
#define PIOC_MDSR_P21 0x200000
#define PIOC_MDSR_P21_BIT 21
#define PIOC_MDSR_P22_MASK 0x400000
#define PIOC_MDSR_P22 0x400000
#define PIOC_MDSR_P22_BIT 22
#define PIOC_MDSR_P23_MASK 0x800000
#define PIOC_MDSR_P23 0x800000
#define PIOC_MDSR_P23_BIT 23
#define PIOC_MDSR_P24_MASK 0x1000000
#define PIOC_MDSR_P24 0x1000000
#define PIOC_MDSR_P24_BIT 24
#define PIOC_MDSR_P25_MASK 0x2000000
#define PIOC_MDSR_P25 0x2000000
#define PIOC_MDSR_P25_BIT 25
#define PIOC_MDSR_P26_MASK 0x4000000
#define PIOC_MDSR_P26 0x4000000
#define PIOC_MDSR_P26_BIT 26
#define PIOC_MDSR_P27_MASK 0x8000000
#define PIOC_MDSR_P27 0x8000000
#define PIOC_MDSR_P27_BIT 27
#define PIOC_MDSR_P28_MASK 0x10000000
#define PIOC_MDSR_P28 0x10000000
#define PIOC_MDSR_P28_BIT 28
#define PIOC_MDSR_P29_MASK 0x20000000
#define PIOC_MDSR_P29 0x20000000
#define PIOC_MDSR_P29_BIT 29
#define PIOC_MDSR_P30_MASK 0x40000000
#define PIOC_MDSR_P30 0x40000000
#define PIOC_MDSR_P30_BIT 30
#define PIOC_MDSR_P31_MASK 0x80000000
#define PIOC_MDSR_P31 0x80000000
#define PIOC_MDSR_P31_BIT 31

#define PIOC_PUDR (*(volatile unsigned long *)0xFFFFF860)
#define PIOC_PUDR_OFFSET 0x60
#define PIOC_PUDR_P0_MASK 0x1
#define PIOC_PUDR_P0 0x1
#define PIOC_PUDR_P0_BIT 0
#define PIOC_PUDR_P1_MASK 0x2
#define PIOC_PUDR_P1 0x2
#define PIOC_PUDR_P1_BIT 1
#define PIOC_PUDR_P2_MASK 0x4
#define PIOC_PUDR_P2 0x4
#define PIOC_PUDR_P2_BIT 2
#define PIOC_PUDR_P3_MASK 0x8
#define PIOC_PUDR_P3 0x8
#define PIOC_PUDR_P3_BIT 3
#define PIOC_PUDR_P4_MASK 0x10
#define PIOC_PUDR_P4 0x10
#define PIOC_PUDR_P4_BIT 4
#define PIOC_PUDR_P5_MASK 0x20
#define PIOC_PUDR_P5 0x20
#define PIOC_PUDR_P5_BIT 5
#define PIOC_PUDR_P6_MASK 0x40
#define PIOC_PUDR_P6 0x40
#define PIOC_PUDR_P6_BIT 6
#define PIOC_PUDR_P7_MASK 0x80
#define PIOC_PUDR_P7 0x80
#define PIOC_PUDR_P7_BIT 7
#define PIOC_PUDR_P8_MASK 0x100
#define PIOC_PUDR_P8 0x100
#define PIOC_PUDR_P8_BIT 8
#define PIOC_PUDR_P9_MASK 0x200
#define PIOC_PUDR_P9 0x200
#define PIOC_PUDR_P9_BIT 9
#define PIOC_PUDR_P10_MASK 0x400
#define PIOC_PUDR_P10 0x400
#define PIOC_PUDR_P10_BIT 10
#define PIOC_PUDR_P11_MASK 0x800
#define PIOC_PUDR_P11 0x800
#define PIOC_PUDR_P11_BIT 11
#define PIOC_PUDR_P12_MASK 0x1000
#define PIOC_PUDR_P12 0x1000
#define PIOC_PUDR_P12_BIT 12
#define PIOC_PUDR_P13_MASK 0x2000
#define PIOC_PUDR_P13 0x2000
#define PIOC_PUDR_P13_BIT 13
#define PIOC_PUDR_P14_MASK 0x4000
#define PIOC_PUDR_P14 0x4000
#define PIOC_PUDR_P14_BIT 14
#define PIOC_PUDR_P15_MASK 0x8000
#define PIOC_PUDR_P15 0x8000
#define PIOC_PUDR_P15_BIT 15
#define PIOC_PUDR_P16_MASK 0x10000
#define PIOC_PUDR_P16 0x10000
#define PIOC_PUDR_P16_BIT 16
#define PIOC_PUDR_P17_MASK 0x20000
#define PIOC_PUDR_P17 0x20000
#define PIOC_PUDR_P17_BIT 17
#define PIOC_PUDR_P18_MASK 0x40000
#define PIOC_PUDR_P18 0x40000
#define PIOC_PUDR_P18_BIT 18
#define PIOC_PUDR_P19_MASK 0x80000
#define PIOC_PUDR_P19 0x80000
#define PIOC_PUDR_P19_BIT 19
#define PIOC_PUDR_P20_MASK 0x100000
#define PIOC_PUDR_P20 0x100000
#define PIOC_PUDR_P20_BIT 20
#define PIOC_PUDR_P21_MASK 0x200000
#define PIOC_PUDR_P21 0x200000
#define PIOC_PUDR_P21_BIT 21
#define PIOC_PUDR_P22_MASK 0x400000
#define PIOC_PUDR_P22 0x400000
#define PIOC_PUDR_P22_BIT 22
#define PIOC_PUDR_P23_MASK 0x800000
#define PIOC_PUDR_P23 0x800000
#define PIOC_PUDR_P23_BIT 23
#define PIOC_PUDR_P24_MASK 0x1000000
#define PIOC_PUDR_P24 0x1000000
#define PIOC_PUDR_P24_BIT 24
#define PIOC_PUDR_P25_MASK 0x2000000
#define PIOC_PUDR_P25 0x2000000
#define PIOC_PUDR_P25_BIT 25
#define PIOC_PUDR_P26_MASK 0x4000000
#define PIOC_PUDR_P26 0x4000000
#define PIOC_PUDR_P26_BIT 26
#define PIOC_PUDR_P27_MASK 0x8000000
#define PIOC_PUDR_P27 0x8000000
#define PIOC_PUDR_P27_BIT 27
#define PIOC_PUDR_P28_MASK 0x10000000
#define PIOC_PUDR_P28 0x10000000
#define PIOC_PUDR_P28_BIT 28
#define PIOC_PUDR_P29_MASK 0x20000000
#define PIOC_PUDR_P29 0x20000000
#define PIOC_PUDR_P29_BIT 29
#define PIOC_PUDR_P30_MASK 0x40000000
#define PIOC_PUDR_P30 0x40000000
#define PIOC_PUDR_P30_BIT 30
#define PIOC_PUDR_P31_MASK 0x80000000
#define PIOC_PUDR_P31 0x80000000
#define PIOC_PUDR_P31_BIT 31

#define PIOC_PUER (*(volatile unsigned long *)0xFFFFF864)
#define PIOC_PUER_OFFSET 0x64
#define PIOC_PUER_P0_MASK 0x1
#define PIOC_PUER_P0 0x1
#define PIOC_PUER_P0_BIT 0
#define PIOC_PUER_P1_MASK 0x2
#define PIOC_PUER_P1 0x2
#define PIOC_PUER_P1_BIT 1
#define PIOC_PUER_P2_MASK 0x4
#define PIOC_PUER_P2 0x4
#define PIOC_PUER_P2_BIT 2
#define PIOC_PUER_P3_MASK 0x8
#define PIOC_PUER_P3 0x8
#define PIOC_PUER_P3_BIT 3
#define PIOC_PUER_P4_MASK 0x10
#define PIOC_PUER_P4 0x10
#define PIOC_PUER_P4_BIT 4
#define PIOC_PUER_P5_MASK 0x20
#define PIOC_PUER_P5 0x20
#define PIOC_PUER_P5_BIT 5
#define PIOC_PUER_P6_MASK 0x40
#define PIOC_PUER_P6 0x40
#define PIOC_PUER_P6_BIT 6
#define PIOC_PUER_P7_MASK 0x80
#define PIOC_PUER_P7 0x80
#define PIOC_PUER_P7_BIT 7
#define PIOC_PUER_P8_MASK 0x100
#define PIOC_PUER_P8 0x100
#define PIOC_PUER_P8_BIT 8
#define PIOC_PUER_P9_MASK 0x200
#define PIOC_PUER_P9 0x200
#define PIOC_PUER_P9_BIT 9
#define PIOC_PUER_P10_MASK 0x400
#define PIOC_PUER_P10 0x400
#define PIOC_PUER_P10_BIT 10
#define PIOC_PUER_P11_MASK 0x800
#define PIOC_PUER_P11 0x800
#define PIOC_PUER_P11_BIT 11
#define PIOC_PUER_P12_MASK 0x1000
#define PIOC_PUER_P12 0x1000
#define PIOC_PUER_P12_BIT 12
#define PIOC_PUER_P13_MASK 0x2000
#define PIOC_PUER_P13 0x2000
#define PIOC_PUER_P13_BIT 13
#define PIOC_PUER_P14_MASK 0x4000
#define PIOC_PUER_P14 0x4000
#define PIOC_PUER_P14_BIT 14
#define PIOC_PUER_P15_MASK 0x8000
#define PIOC_PUER_P15 0x8000
#define PIOC_PUER_P15_BIT 15
#define PIOC_PUER_P16_MASK 0x10000
#define PIOC_PUER_P16 0x10000
#define PIOC_PUER_P16_BIT 16
#define PIOC_PUER_P17_MASK 0x20000
#define PIOC_PUER_P17 0x20000
#define PIOC_PUER_P17_BIT 17
#define PIOC_PUER_P18_MASK 0x40000
#define PIOC_PUER_P18 0x40000
#define PIOC_PUER_P18_BIT 18
#define PIOC_PUER_P19_MASK 0x80000
#define PIOC_PUER_P19 0x80000
#define PIOC_PUER_P19_BIT 19
#define PIOC_PUER_P20_MASK 0x100000
#define PIOC_PUER_P20 0x100000
#define PIOC_PUER_P20_BIT 20
#define PIOC_PUER_P21_MASK 0x200000
#define PIOC_PUER_P21 0x200000
#define PIOC_PUER_P21_BIT 21
#define PIOC_PUER_P22_MASK 0x400000
#define PIOC_PUER_P22 0x400000
#define PIOC_PUER_P22_BIT 22
#define PIOC_PUER_P23_MASK 0x800000
#define PIOC_PUER_P23 0x800000
#define PIOC_PUER_P23_BIT 23
#define PIOC_PUER_P24_MASK 0x1000000
#define PIOC_PUER_P24 0x1000000
#define PIOC_PUER_P24_BIT 24
#define PIOC_PUER_P25_MASK 0x2000000
#define PIOC_PUER_P25 0x2000000
#define PIOC_PUER_P25_BIT 25
#define PIOC_PUER_P26_MASK 0x4000000
#define PIOC_PUER_P26 0x4000000
#define PIOC_PUER_P26_BIT 26
#define PIOC_PUER_P27_MASK 0x8000000
#define PIOC_PUER_P27 0x8000000
#define PIOC_PUER_P27_BIT 27
#define PIOC_PUER_P28_MASK 0x10000000
#define PIOC_PUER_P28 0x10000000
#define PIOC_PUER_P28_BIT 28
#define PIOC_PUER_P29_MASK 0x20000000
#define PIOC_PUER_P29 0x20000000
#define PIOC_PUER_P29_BIT 29
#define PIOC_PUER_P30_MASK 0x40000000
#define PIOC_PUER_P30 0x40000000
#define PIOC_PUER_P30_BIT 30
#define PIOC_PUER_P31_MASK 0x80000000
#define PIOC_PUER_P31 0x80000000
#define PIOC_PUER_P31_BIT 31

#define PIOC_PUSR (*(volatile unsigned long *)0xFFFFF868)
#define PIOC_PUSR_OFFSET 0x68
#define PIOC_PUSR_P0_MASK 0x1
#define PIOC_PUSR_P0 0x1
#define PIOC_PUSR_P0_BIT 0
#define PIOC_PUSR_P1_MASK 0x2
#define PIOC_PUSR_P1 0x2
#define PIOC_PUSR_P1_BIT 1
#define PIOC_PUSR_P2_MASK 0x4
#define PIOC_PUSR_P2 0x4
#define PIOC_PUSR_P2_BIT 2
#define PIOC_PUSR_P3_MASK 0x8
#define PIOC_PUSR_P3 0x8
#define PIOC_PUSR_P3_BIT 3
#define PIOC_PUSR_P4_MASK 0x10
#define PIOC_PUSR_P4 0x10
#define PIOC_PUSR_P4_BIT 4
#define PIOC_PUSR_P5_MASK 0x20
#define PIOC_PUSR_P5 0x20
#define PIOC_PUSR_P5_BIT 5
#define PIOC_PUSR_P6_MASK 0x40
#define PIOC_PUSR_P6 0x40
#define PIOC_PUSR_P6_BIT 6
#define PIOC_PUSR_P7_MASK 0x80
#define PIOC_PUSR_P7 0x80
#define PIOC_PUSR_P7_BIT 7
#define PIOC_PUSR_P8_MASK 0x100
#define PIOC_PUSR_P8 0x100
#define PIOC_PUSR_P8_BIT 8
#define PIOC_PUSR_P9_MASK 0x200
#define PIOC_PUSR_P9 0x200
#define PIOC_PUSR_P9_BIT 9
#define PIOC_PUSR_P10_MASK 0x400
#define PIOC_PUSR_P10 0x400
#define PIOC_PUSR_P10_BIT 10
#define PIOC_PUSR_P11_MASK 0x800
#define PIOC_PUSR_P11 0x800
#define PIOC_PUSR_P11_BIT 11
#define PIOC_PUSR_P12_MASK 0x1000
#define PIOC_PUSR_P12 0x1000
#define PIOC_PUSR_P12_BIT 12
#define PIOC_PUSR_P13_MASK 0x2000
#define PIOC_PUSR_P13 0x2000
#define PIOC_PUSR_P13_BIT 13
#define PIOC_PUSR_P14_MASK 0x4000
#define PIOC_PUSR_P14 0x4000
#define PIOC_PUSR_P14_BIT 14
#define PIOC_PUSR_P15_MASK 0x8000
#define PIOC_PUSR_P15 0x8000
#define PIOC_PUSR_P15_BIT 15
#define PIOC_PUSR_P16_MASK 0x10000
#define PIOC_PUSR_P16 0x10000
#define PIOC_PUSR_P16_BIT 16
#define PIOC_PUSR_P17_MASK 0x20000
#define PIOC_PUSR_P17 0x20000
#define PIOC_PUSR_P17_BIT 17
#define PIOC_PUSR_P18_MASK 0x40000
#define PIOC_PUSR_P18 0x40000
#define PIOC_PUSR_P18_BIT 18
#define PIOC_PUSR_P19_MASK 0x80000
#define PIOC_PUSR_P19 0x80000
#define PIOC_PUSR_P19_BIT 19
#define PIOC_PUSR_P20_MASK 0x100000
#define PIOC_PUSR_P20 0x100000
#define PIOC_PUSR_P20_BIT 20
#define PIOC_PUSR_P21_MASK 0x200000
#define PIOC_PUSR_P21 0x200000
#define PIOC_PUSR_P21_BIT 21
#define PIOC_PUSR_P22_MASK 0x400000
#define PIOC_PUSR_P22 0x400000
#define PIOC_PUSR_P22_BIT 22
#define PIOC_PUSR_P23_MASK 0x800000
#define PIOC_PUSR_P23 0x800000
#define PIOC_PUSR_P23_BIT 23
#define PIOC_PUSR_P24_MASK 0x1000000
#define PIOC_PUSR_P24 0x1000000
#define PIOC_PUSR_P24_BIT 24
#define PIOC_PUSR_P25_MASK 0x2000000
#define PIOC_PUSR_P25 0x2000000
#define PIOC_PUSR_P25_BIT 25
#define PIOC_PUSR_P26_MASK 0x4000000
#define PIOC_PUSR_P26 0x4000000
#define PIOC_PUSR_P26_BIT 26
#define PIOC_PUSR_P27_MASK 0x8000000
#define PIOC_PUSR_P27 0x8000000
#define PIOC_PUSR_P27_BIT 27
#define PIOC_PUSR_P28_MASK 0x10000000
#define PIOC_PUSR_P28 0x10000000
#define PIOC_PUSR_P28_BIT 28
#define PIOC_PUSR_P29_MASK 0x20000000
#define PIOC_PUSR_P29 0x20000000
#define PIOC_PUSR_P29_BIT 29
#define PIOC_PUSR_P30_MASK 0x40000000
#define PIOC_PUSR_P30 0x40000000
#define PIOC_PUSR_P30_BIT 30
#define PIOC_PUSR_P31_MASK 0x80000000
#define PIOC_PUSR_P31 0x80000000
#define PIOC_PUSR_P31_BIT 31

#define PIOC_ASR (*(volatile unsigned long *)0xFFFFF870)
#define PIOC_ASR_OFFSET 0x70
#define PIOC_ASR_P0_MASK 0x1
#define PIOC_ASR_P0 0x1
#define PIOC_ASR_P0_BIT 0
#define PIOC_ASR_P1_MASK 0x2
#define PIOC_ASR_P1 0x2
#define PIOC_ASR_P1_BIT 1
#define PIOC_ASR_P2_MASK 0x4
#define PIOC_ASR_P2 0x4
#define PIOC_ASR_P2_BIT 2
#define PIOC_ASR_P3_MASK 0x8
#define PIOC_ASR_P3 0x8
#define PIOC_ASR_P3_BIT 3
#define PIOC_ASR_P4_MASK 0x10
#define PIOC_ASR_P4 0x10
#define PIOC_ASR_P4_BIT 4
#define PIOC_ASR_P5_MASK 0x20
#define PIOC_ASR_P5 0x20
#define PIOC_ASR_P5_BIT 5
#define PIOC_ASR_P6_MASK 0x40
#define PIOC_ASR_P6 0x40
#define PIOC_ASR_P6_BIT 6
#define PIOC_ASR_P7_MASK 0x80
#define PIOC_ASR_P7 0x80
#define PIOC_ASR_P7_BIT 7
#define PIOC_ASR_P8_MASK 0x100
#define PIOC_ASR_P8 0x100
#define PIOC_ASR_P8_BIT 8
#define PIOC_ASR_P9_MASK 0x200
#define PIOC_ASR_P9 0x200
#define PIOC_ASR_P9_BIT 9
#define PIOC_ASR_P10_MASK 0x400
#define PIOC_ASR_P10 0x400
#define PIOC_ASR_P10_BIT 10
#define PIOC_ASR_P11_MASK 0x800
#define PIOC_ASR_P11 0x800
#define PIOC_ASR_P11_BIT 11
#define PIOC_ASR_P12_MASK 0x1000
#define PIOC_ASR_P12 0x1000
#define PIOC_ASR_P12_BIT 12
#define PIOC_ASR_P13_MASK 0x2000
#define PIOC_ASR_P13 0x2000
#define PIOC_ASR_P13_BIT 13
#define PIOC_ASR_P14_MASK 0x4000
#define PIOC_ASR_P14 0x4000
#define PIOC_ASR_P14_BIT 14
#define PIOC_ASR_P15_MASK 0x8000
#define PIOC_ASR_P15 0x8000
#define PIOC_ASR_P15_BIT 15
#define PIOC_ASR_P16_MASK 0x10000
#define PIOC_ASR_P16 0x10000
#define PIOC_ASR_P16_BIT 16
#define PIOC_ASR_P17_MASK 0x20000
#define PIOC_ASR_P17 0x20000
#define PIOC_ASR_P17_BIT 17
#define PIOC_ASR_P18_MASK 0x40000
#define PIOC_ASR_P18 0x40000
#define PIOC_ASR_P18_BIT 18
#define PIOC_ASR_P19_MASK 0x80000
#define PIOC_ASR_P19 0x80000
#define PIOC_ASR_P19_BIT 19
#define PIOC_ASR_P20_MASK 0x100000
#define PIOC_ASR_P20 0x100000
#define PIOC_ASR_P20_BIT 20
#define PIOC_ASR_P21_MASK 0x200000
#define PIOC_ASR_P21 0x200000
#define PIOC_ASR_P21_BIT 21
#define PIOC_ASR_P22_MASK 0x400000
#define PIOC_ASR_P22 0x400000
#define PIOC_ASR_P22_BIT 22
#define PIOC_ASR_P23_MASK 0x800000
#define PIOC_ASR_P23 0x800000
#define PIOC_ASR_P23_BIT 23
#define PIOC_ASR_P24_MASK 0x1000000
#define PIOC_ASR_P24 0x1000000
#define PIOC_ASR_P24_BIT 24
#define PIOC_ASR_P25_MASK 0x2000000
#define PIOC_ASR_P25 0x2000000
#define PIOC_ASR_P25_BIT 25
#define PIOC_ASR_P26_MASK 0x4000000
#define PIOC_ASR_P26 0x4000000
#define PIOC_ASR_P26_BIT 26
#define PIOC_ASR_P27_MASK 0x8000000
#define PIOC_ASR_P27 0x8000000
#define PIOC_ASR_P27_BIT 27
#define PIOC_ASR_P28_MASK 0x10000000
#define PIOC_ASR_P28 0x10000000
#define PIOC_ASR_P28_BIT 28
#define PIOC_ASR_P29_MASK 0x20000000
#define PIOC_ASR_P29 0x20000000
#define PIOC_ASR_P29_BIT 29
#define PIOC_ASR_P30_MASK 0x40000000
#define PIOC_ASR_P30 0x40000000
#define PIOC_ASR_P30_BIT 30
#define PIOC_ASR_P31_MASK 0x80000000
#define PIOC_ASR_P31 0x80000000
#define PIOC_ASR_P31_BIT 31

#define PIOC_BSR (*(volatile unsigned long *)0xFFFFF874)
#define PIOC_BSR_OFFSET 0x74
#define PIOC_BSR_P0_MASK 0x1
#define PIOC_BSR_P0 0x1
#define PIOC_BSR_P0_BIT 0
#define PIOC_BSR_P1_MASK 0x2
#define PIOC_BSR_P1 0x2
#define PIOC_BSR_P1_BIT 1
#define PIOC_BSR_P2_MASK 0x4
#define PIOC_BSR_P2 0x4
#define PIOC_BSR_P2_BIT 2
#define PIOC_BSR_P3_MASK 0x8
#define PIOC_BSR_P3 0x8
#define PIOC_BSR_P3_BIT 3
#define PIOC_BSR_P4_MASK 0x10
#define PIOC_BSR_P4 0x10
#define PIOC_BSR_P4_BIT 4
#define PIOC_BSR_P5_MASK 0x20
#define PIOC_BSR_P5 0x20
#define PIOC_BSR_P5_BIT 5
#define PIOC_BSR_P6_MASK 0x40
#define PIOC_BSR_P6 0x40
#define PIOC_BSR_P6_BIT 6
#define PIOC_BSR_P7_MASK 0x80
#define PIOC_BSR_P7 0x80
#define PIOC_BSR_P7_BIT 7
#define PIOC_BSR_P8_MASK 0x100
#define PIOC_BSR_P8 0x100
#define PIOC_BSR_P8_BIT 8
#define PIOC_BSR_P9_MASK 0x200
#define PIOC_BSR_P9 0x200
#define PIOC_BSR_P9_BIT 9
#define PIOC_BSR_P10_MASK 0x400
#define PIOC_BSR_P10 0x400
#define PIOC_BSR_P10_BIT 10
#define PIOC_BSR_P11_MASK 0x800
#define PIOC_BSR_P11 0x800
#define PIOC_BSR_P11_BIT 11
#define PIOC_BSR_P12_MASK 0x1000
#define PIOC_BSR_P12 0x1000
#define PIOC_BSR_P12_BIT 12
#define PIOC_BSR_P13_MASK 0x2000
#define PIOC_BSR_P13 0x2000
#define PIOC_BSR_P13_BIT 13
#define PIOC_BSR_P14_MASK 0x4000
#define PIOC_BSR_P14 0x4000
#define PIOC_BSR_P14_BIT 14
#define PIOC_BSR_P15_MASK 0x8000
#define PIOC_BSR_P15 0x8000
#define PIOC_BSR_P15_BIT 15
#define PIOC_BSR_P16_MASK 0x10000
#define PIOC_BSR_P16 0x10000
#define PIOC_BSR_P16_BIT 16
#define PIOC_BSR_P17_MASK 0x20000
#define PIOC_BSR_P17 0x20000
#define PIOC_BSR_P17_BIT 17
#define PIOC_BSR_P18_MASK 0x40000
#define PIOC_BSR_P18 0x40000
#define PIOC_BSR_P18_BIT 18
#define PIOC_BSR_P19_MASK 0x80000
#define PIOC_BSR_P19 0x80000
#define PIOC_BSR_P19_BIT 19
#define PIOC_BSR_P20_MASK 0x100000
#define PIOC_BSR_P20 0x100000
#define PIOC_BSR_P20_BIT 20
#define PIOC_BSR_P21_MASK 0x200000
#define PIOC_BSR_P21 0x200000
#define PIOC_BSR_P21_BIT 21
#define PIOC_BSR_P22_MASK 0x400000
#define PIOC_BSR_P22 0x400000
#define PIOC_BSR_P22_BIT 22
#define PIOC_BSR_P23_MASK 0x800000
#define PIOC_BSR_P23 0x800000
#define PIOC_BSR_P23_BIT 23
#define PIOC_BSR_P24_MASK 0x1000000
#define PIOC_BSR_P24 0x1000000
#define PIOC_BSR_P24_BIT 24
#define PIOC_BSR_P25_MASK 0x2000000
#define PIOC_BSR_P25 0x2000000
#define PIOC_BSR_P25_BIT 25
#define PIOC_BSR_P26_MASK 0x4000000
#define PIOC_BSR_P26 0x4000000
#define PIOC_BSR_P26_BIT 26
#define PIOC_BSR_P27_MASK 0x8000000
#define PIOC_BSR_P27 0x8000000
#define PIOC_BSR_P27_BIT 27
#define PIOC_BSR_P28_MASK 0x10000000
#define PIOC_BSR_P28 0x10000000
#define PIOC_BSR_P28_BIT 28
#define PIOC_BSR_P29_MASK 0x20000000
#define PIOC_BSR_P29 0x20000000
#define PIOC_BSR_P29_BIT 29
#define PIOC_BSR_P30_MASK 0x40000000
#define PIOC_BSR_P30 0x40000000
#define PIOC_BSR_P30_BIT 30
#define PIOC_BSR_P31_MASK 0x80000000
#define PIOC_BSR_P31 0x80000000
#define PIOC_BSR_P31_BIT 31

#define PIOC_ABSR (*(volatile unsigned long *)0xFFFFF878)
#define PIOC_ABSR_OFFSET 0x78
#define PIOC_ABSR_P0_MASK 0x1
#define PIOC_ABSR_P0 0x1
#define PIOC_ABSR_P0_BIT 0
#define PIOC_ABSR_P1_MASK 0x2
#define PIOC_ABSR_P1 0x2
#define PIOC_ABSR_P1_BIT 1
#define PIOC_ABSR_P2_MASK 0x4
#define PIOC_ABSR_P2 0x4
#define PIOC_ABSR_P2_BIT 2
#define PIOC_ABSR_P3_MASK 0x8
#define PIOC_ABSR_P3 0x8
#define PIOC_ABSR_P3_BIT 3
#define PIOC_ABSR_P4_MASK 0x10
#define PIOC_ABSR_P4 0x10
#define PIOC_ABSR_P4_BIT 4
#define PIOC_ABSR_P5_MASK 0x20
#define PIOC_ABSR_P5 0x20
#define PIOC_ABSR_P5_BIT 5
#define PIOC_ABSR_P6_MASK 0x40
#define PIOC_ABSR_P6 0x40
#define PIOC_ABSR_P6_BIT 6
#define PIOC_ABSR_P7_MASK 0x80
#define PIOC_ABSR_P7 0x80
#define PIOC_ABSR_P7_BIT 7
#define PIOC_ABSR_P8_MASK 0x100
#define PIOC_ABSR_P8 0x100
#define PIOC_ABSR_P8_BIT 8
#define PIOC_ABSR_P9_MASK 0x200
#define PIOC_ABSR_P9 0x200
#define PIOC_ABSR_P9_BIT 9
#define PIOC_ABSR_P10_MASK 0x400
#define PIOC_ABSR_P10 0x400
#define PIOC_ABSR_P10_BIT 10
#define PIOC_ABSR_P11_MASK 0x800
#define PIOC_ABSR_P11 0x800
#define PIOC_ABSR_P11_BIT 11
#define PIOC_ABSR_P12_MASK 0x1000
#define PIOC_ABSR_P12 0x1000
#define PIOC_ABSR_P12_BIT 12
#define PIOC_ABSR_P13_MASK 0x2000
#define PIOC_ABSR_P13 0x2000
#define PIOC_ABSR_P13_BIT 13
#define PIOC_ABSR_P14_MASK 0x4000
#define PIOC_ABSR_P14 0x4000
#define PIOC_ABSR_P14_BIT 14
#define PIOC_ABSR_P15_MASK 0x8000
#define PIOC_ABSR_P15 0x8000
#define PIOC_ABSR_P15_BIT 15
#define PIOC_ABSR_P16_MASK 0x10000
#define PIOC_ABSR_P16 0x10000
#define PIOC_ABSR_P16_BIT 16
#define PIOC_ABSR_P17_MASK 0x20000
#define PIOC_ABSR_P17 0x20000
#define PIOC_ABSR_P17_BIT 17
#define PIOC_ABSR_P18_MASK 0x40000
#define PIOC_ABSR_P18 0x40000
#define PIOC_ABSR_P18_BIT 18
#define PIOC_ABSR_P19_MASK 0x80000
#define PIOC_ABSR_P19 0x80000
#define PIOC_ABSR_P19_BIT 19
#define PIOC_ABSR_P20_MASK 0x100000
#define PIOC_ABSR_P20 0x100000
#define PIOC_ABSR_P20_BIT 20
#define PIOC_ABSR_P21_MASK 0x200000
#define PIOC_ABSR_P21 0x200000
#define PIOC_ABSR_P21_BIT 21
#define PIOC_ABSR_P22_MASK 0x400000
#define PIOC_ABSR_P22 0x400000
#define PIOC_ABSR_P22_BIT 22
#define PIOC_ABSR_P23_MASK 0x800000
#define PIOC_ABSR_P23 0x800000
#define PIOC_ABSR_P23_BIT 23
#define PIOC_ABSR_P24_MASK 0x1000000
#define PIOC_ABSR_P24 0x1000000
#define PIOC_ABSR_P24_BIT 24
#define PIOC_ABSR_P25_MASK 0x2000000
#define PIOC_ABSR_P25 0x2000000
#define PIOC_ABSR_P25_BIT 25
#define PIOC_ABSR_P26_MASK 0x4000000
#define PIOC_ABSR_P26 0x4000000
#define PIOC_ABSR_P26_BIT 26
#define PIOC_ABSR_P27_MASK 0x8000000
#define PIOC_ABSR_P27 0x8000000
#define PIOC_ABSR_P27_BIT 27
#define PIOC_ABSR_P28_MASK 0x10000000
#define PIOC_ABSR_P28 0x10000000
#define PIOC_ABSR_P28_BIT 28
#define PIOC_ABSR_P29_MASK 0x20000000
#define PIOC_ABSR_P29 0x20000000
#define PIOC_ABSR_P29_BIT 29
#define PIOC_ABSR_P30_MASK 0x40000000
#define PIOC_ABSR_P30 0x40000000
#define PIOC_ABSR_P30_BIT 30
#define PIOC_ABSR_P31_MASK 0x80000000
#define PIOC_ABSR_P31 0x80000000
#define PIOC_ABSR_P31_BIT 31

#define PIOC_OWER (*(volatile unsigned long *)0xFFFFF8A0)
#define PIOC_OWER_OFFSET 0xA0
#define PIOC_OWER_P0_MASK 0x1
#define PIOC_OWER_P0 0x1
#define PIOC_OWER_P0_BIT 0
#define PIOC_OWER_P1_MASK 0x2
#define PIOC_OWER_P1 0x2
#define PIOC_OWER_P1_BIT 1
#define PIOC_OWER_P2_MASK 0x4
#define PIOC_OWER_P2 0x4
#define PIOC_OWER_P2_BIT 2
#define PIOC_OWER_P3_MASK 0x8
#define PIOC_OWER_P3 0x8
#define PIOC_OWER_P3_BIT 3
#define PIOC_OWER_P4_MASK 0x10
#define PIOC_OWER_P4 0x10
#define PIOC_OWER_P4_BIT 4
#define PIOC_OWER_P5_MASK 0x20
#define PIOC_OWER_P5 0x20
#define PIOC_OWER_P5_BIT 5
#define PIOC_OWER_P6_MASK 0x40
#define PIOC_OWER_P6 0x40
#define PIOC_OWER_P6_BIT 6
#define PIOC_OWER_P7_MASK 0x80
#define PIOC_OWER_P7 0x80
#define PIOC_OWER_P7_BIT 7
#define PIOC_OWER_P8_MASK 0x100
#define PIOC_OWER_P8 0x100
#define PIOC_OWER_P8_BIT 8
#define PIOC_OWER_P9_MASK 0x200
#define PIOC_OWER_P9 0x200
#define PIOC_OWER_P9_BIT 9
#define PIOC_OWER_P10_MASK 0x400
#define PIOC_OWER_P10 0x400
#define PIOC_OWER_P10_BIT 10
#define PIOC_OWER_P11_MASK 0x800
#define PIOC_OWER_P11 0x800
#define PIOC_OWER_P11_BIT 11
#define PIOC_OWER_P12_MASK 0x1000
#define PIOC_OWER_P12 0x1000
#define PIOC_OWER_P12_BIT 12
#define PIOC_OWER_P13_MASK 0x2000
#define PIOC_OWER_P13 0x2000
#define PIOC_OWER_P13_BIT 13
#define PIOC_OWER_P14_MASK 0x4000
#define PIOC_OWER_P14 0x4000
#define PIOC_OWER_P14_BIT 14
#define PIOC_OWER_P15_MASK 0x8000
#define PIOC_OWER_P15 0x8000
#define PIOC_OWER_P15_BIT 15
#define PIOC_OWER_P16_MASK 0x10000
#define PIOC_OWER_P16 0x10000
#define PIOC_OWER_P16_BIT 16
#define PIOC_OWER_P17_MASK 0x20000
#define PIOC_OWER_P17 0x20000
#define PIOC_OWER_P17_BIT 17
#define PIOC_OWER_P18_MASK 0x40000
#define PIOC_OWER_P18 0x40000
#define PIOC_OWER_P18_BIT 18
#define PIOC_OWER_P19_MASK 0x80000
#define PIOC_OWER_P19 0x80000
#define PIOC_OWER_P19_BIT 19
#define PIOC_OWER_P20_MASK 0x100000
#define PIOC_OWER_P20 0x100000
#define PIOC_OWER_P20_BIT 20
#define PIOC_OWER_P21_MASK 0x200000
#define PIOC_OWER_P21 0x200000
#define PIOC_OWER_P21_BIT 21
#define PIOC_OWER_P22_MASK 0x400000
#define PIOC_OWER_P22 0x400000
#define PIOC_OWER_P22_BIT 22
#define PIOC_OWER_P23_MASK 0x800000
#define PIOC_OWER_P23 0x800000
#define PIOC_OWER_P23_BIT 23
#define PIOC_OWER_P24_MASK 0x1000000
#define PIOC_OWER_P24 0x1000000
#define PIOC_OWER_P24_BIT 24
#define PIOC_OWER_P25_MASK 0x2000000
#define PIOC_OWER_P25 0x2000000
#define PIOC_OWER_P25_BIT 25
#define PIOC_OWER_P26_MASK 0x4000000
#define PIOC_OWER_P26 0x4000000
#define PIOC_OWER_P26_BIT 26
#define PIOC_OWER_P27_MASK 0x8000000
#define PIOC_OWER_P27 0x8000000
#define PIOC_OWER_P27_BIT 27
#define PIOC_OWER_P28_MASK 0x10000000
#define PIOC_OWER_P28 0x10000000
#define PIOC_OWER_P28_BIT 28
#define PIOC_OWER_P29_MASK 0x20000000
#define PIOC_OWER_P29 0x20000000
#define PIOC_OWER_P29_BIT 29
#define PIOC_OWER_P30_MASK 0x40000000
#define PIOC_OWER_P30 0x40000000
#define PIOC_OWER_P30_BIT 30
#define PIOC_OWER_P31_MASK 0x80000000
#define PIOC_OWER_P31 0x80000000
#define PIOC_OWER_P31_BIT 31

#define PIOC_OWDR (*(volatile unsigned long *)0xFFFFF8A4)
#define PIOC_OWDR_OFFSET 0xA4
#define PIOC_OWDR_P0_MASK 0x1
#define PIOC_OWDR_P0 0x1
#define PIOC_OWDR_P0_BIT 0
#define PIOC_OWDR_P1_MASK 0x2
#define PIOC_OWDR_P1 0x2
#define PIOC_OWDR_P1_BIT 1
#define PIOC_OWDR_P2_MASK 0x4
#define PIOC_OWDR_P2 0x4
#define PIOC_OWDR_P2_BIT 2
#define PIOC_OWDR_P3_MASK 0x8
#define PIOC_OWDR_P3 0x8
#define PIOC_OWDR_P3_BIT 3
#define PIOC_OWDR_P4_MASK 0x10
#define PIOC_OWDR_P4 0x10
#define PIOC_OWDR_P4_BIT 4
#define PIOC_OWDR_P5_MASK 0x20
#define PIOC_OWDR_P5 0x20
#define PIOC_OWDR_P5_BIT 5
#define PIOC_OWDR_P6_MASK 0x40
#define PIOC_OWDR_P6 0x40
#define PIOC_OWDR_P6_BIT 6
#define PIOC_OWDR_P7_MASK 0x80
#define PIOC_OWDR_P7 0x80
#define PIOC_OWDR_P7_BIT 7
#define PIOC_OWDR_P8_MASK 0x100
#define PIOC_OWDR_P8 0x100
#define PIOC_OWDR_P8_BIT 8
#define PIOC_OWDR_P9_MASK 0x200
#define PIOC_OWDR_P9 0x200
#define PIOC_OWDR_P9_BIT 9
#define PIOC_OWDR_P10_MASK 0x400
#define PIOC_OWDR_P10 0x400
#define PIOC_OWDR_P10_BIT 10
#define PIOC_OWDR_P11_MASK 0x800
#define PIOC_OWDR_P11 0x800
#define PIOC_OWDR_P11_BIT 11
#define PIOC_OWDR_P12_MASK 0x1000
#define PIOC_OWDR_P12 0x1000
#define PIOC_OWDR_P12_BIT 12
#define PIOC_OWDR_P13_MASK 0x2000
#define PIOC_OWDR_P13 0x2000
#define PIOC_OWDR_P13_BIT 13
#define PIOC_OWDR_P14_MASK 0x4000
#define PIOC_OWDR_P14 0x4000
#define PIOC_OWDR_P14_BIT 14
#define PIOC_OWDR_P15_MASK 0x8000
#define PIOC_OWDR_P15 0x8000
#define PIOC_OWDR_P15_BIT 15
#define PIOC_OWDR_P16_MASK 0x10000
#define PIOC_OWDR_P16 0x10000
#define PIOC_OWDR_P16_BIT 16
#define PIOC_OWDR_P17_MASK 0x20000
#define PIOC_OWDR_P17 0x20000
#define PIOC_OWDR_P17_BIT 17
#define PIOC_OWDR_P18_MASK 0x40000
#define PIOC_OWDR_P18 0x40000
#define PIOC_OWDR_P18_BIT 18
#define PIOC_OWDR_P19_MASK 0x80000
#define PIOC_OWDR_P19 0x80000
#define PIOC_OWDR_P19_BIT 19
#define PIOC_OWDR_P20_MASK 0x100000
#define PIOC_OWDR_P20 0x100000
#define PIOC_OWDR_P20_BIT 20
#define PIOC_OWDR_P21_MASK 0x200000
#define PIOC_OWDR_P21 0x200000
#define PIOC_OWDR_P21_BIT 21
#define PIOC_OWDR_P22_MASK 0x400000
#define PIOC_OWDR_P22 0x400000
#define PIOC_OWDR_P22_BIT 22
#define PIOC_OWDR_P23_MASK 0x800000
#define PIOC_OWDR_P23 0x800000
#define PIOC_OWDR_P23_BIT 23
#define PIOC_OWDR_P24_MASK 0x1000000
#define PIOC_OWDR_P24 0x1000000
#define PIOC_OWDR_P24_BIT 24
#define PIOC_OWDR_P25_MASK 0x2000000
#define PIOC_OWDR_P25 0x2000000
#define PIOC_OWDR_P25_BIT 25
#define PIOC_OWDR_P26_MASK 0x4000000
#define PIOC_OWDR_P26 0x4000000
#define PIOC_OWDR_P26_BIT 26
#define PIOC_OWDR_P27_MASK 0x8000000
#define PIOC_OWDR_P27 0x8000000
#define PIOC_OWDR_P27_BIT 27
#define PIOC_OWDR_P28_MASK 0x10000000
#define PIOC_OWDR_P28 0x10000000
#define PIOC_OWDR_P28_BIT 28
#define PIOC_OWDR_P29_MASK 0x20000000
#define PIOC_OWDR_P29 0x20000000
#define PIOC_OWDR_P29_BIT 29
#define PIOC_OWDR_P30_MASK 0x40000000
#define PIOC_OWDR_P30 0x40000000
#define PIOC_OWDR_P30_BIT 30
#define PIOC_OWDR_P31_MASK 0x80000000
#define PIOC_OWDR_P31 0x80000000
#define PIOC_OWDR_P31_BIT 31

#define PIOC_OWSR (*(volatile unsigned long *)0xFFFFF8A8)
#define PIOC_OWSR_OFFSET 0xA8
#define PIOC_OWSR_P0_MASK 0x1
#define PIOC_OWSR_P0 0x1
#define PIOC_OWSR_P0_BIT 0
#define PIOC_OWSR_P1_MASK 0x2
#define PIOC_OWSR_P1 0x2
#define PIOC_OWSR_P1_BIT 1
#define PIOC_OWSR_P2_MASK 0x4
#define PIOC_OWSR_P2 0x4
#define PIOC_OWSR_P2_BIT 2
#define PIOC_OWSR_P3_MASK 0x8
#define PIOC_OWSR_P3 0x8
#define PIOC_OWSR_P3_BIT 3
#define PIOC_OWSR_P4_MASK 0x10
#define PIOC_OWSR_P4 0x10
#define PIOC_OWSR_P4_BIT 4
#define PIOC_OWSR_P5_MASK 0x20
#define PIOC_OWSR_P5 0x20
#define PIOC_OWSR_P5_BIT 5
#define PIOC_OWSR_P6_MASK 0x40
#define PIOC_OWSR_P6 0x40
#define PIOC_OWSR_P6_BIT 6
#define PIOC_OWSR_P7_MASK 0x80
#define PIOC_OWSR_P7 0x80
#define PIOC_OWSR_P7_BIT 7
#define PIOC_OWSR_P8_MASK 0x100
#define PIOC_OWSR_P8 0x100
#define PIOC_OWSR_P8_BIT 8
#define PIOC_OWSR_P9_MASK 0x200
#define PIOC_OWSR_P9 0x200
#define PIOC_OWSR_P9_BIT 9
#define PIOC_OWSR_P10_MASK 0x400
#define PIOC_OWSR_P10 0x400
#define PIOC_OWSR_P10_BIT 10
#define PIOC_OWSR_P11_MASK 0x800
#define PIOC_OWSR_P11 0x800
#define PIOC_OWSR_P11_BIT 11
#define PIOC_OWSR_P12_MASK 0x1000
#define PIOC_OWSR_P12 0x1000
#define PIOC_OWSR_P12_BIT 12
#define PIOC_OWSR_P13_MASK 0x2000
#define PIOC_OWSR_P13 0x2000
#define PIOC_OWSR_P13_BIT 13
#define PIOC_OWSR_P14_MASK 0x4000
#define PIOC_OWSR_P14 0x4000
#define PIOC_OWSR_P14_BIT 14
#define PIOC_OWSR_P15_MASK 0x8000
#define PIOC_OWSR_P15 0x8000
#define PIOC_OWSR_P15_BIT 15
#define PIOC_OWSR_P16_MASK 0x10000
#define PIOC_OWSR_P16 0x10000
#define PIOC_OWSR_P16_BIT 16
#define PIOC_OWSR_P17_MASK 0x20000
#define PIOC_OWSR_P17 0x20000
#define PIOC_OWSR_P17_BIT 17
#define PIOC_OWSR_P18_MASK 0x40000
#define PIOC_OWSR_P18 0x40000
#define PIOC_OWSR_P18_BIT 18
#define PIOC_OWSR_P19_MASK 0x80000
#define PIOC_OWSR_P19 0x80000
#define PIOC_OWSR_P19_BIT 19
#define PIOC_OWSR_P20_MASK 0x100000
#define PIOC_OWSR_P20 0x100000
#define PIOC_OWSR_P20_BIT 20
#define PIOC_OWSR_P21_MASK 0x200000
#define PIOC_OWSR_P21 0x200000
#define PIOC_OWSR_P21_BIT 21
#define PIOC_OWSR_P22_MASK 0x400000
#define PIOC_OWSR_P22 0x400000
#define PIOC_OWSR_P22_BIT 22
#define PIOC_OWSR_P23_MASK 0x800000
#define PIOC_OWSR_P23 0x800000
#define PIOC_OWSR_P23_BIT 23
#define PIOC_OWSR_P24_MASK 0x1000000
#define PIOC_OWSR_P24 0x1000000
#define PIOC_OWSR_P24_BIT 24
#define PIOC_OWSR_P25_MASK 0x2000000
#define PIOC_OWSR_P25 0x2000000
#define PIOC_OWSR_P25_BIT 25
#define PIOC_OWSR_P26_MASK 0x4000000
#define PIOC_OWSR_P26 0x4000000
#define PIOC_OWSR_P26_BIT 26
#define PIOC_OWSR_P27_MASK 0x8000000
#define PIOC_OWSR_P27 0x8000000
#define PIOC_OWSR_P27_BIT 27
#define PIOC_OWSR_P28_MASK 0x10000000
#define PIOC_OWSR_P28 0x10000000
#define PIOC_OWSR_P28_BIT 28
#define PIOC_OWSR_P29_MASK 0x20000000
#define PIOC_OWSR_P29 0x20000000
#define PIOC_OWSR_P29_BIT 29
#define PIOC_OWSR_P30_MASK 0x40000000
#define PIOC_OWSR_P30 0x40000000
#define PIOC_OWSR_P30_BIT 30
#define PIOC_OWSR_P31_MASK 0x80000000
#define PIOC_OWSR_P31 0x80000000
#define PIOC_OWSR_P31_BIT 31

#define PIOD_BASE 0xFFFFFA00

#define PIOD_PER (*(volatile unsigned long *)0xFFFFFA00)
#define PIOD_PER_OFFSET 0x0
#define PIOD_PER_P0_MASK 0x1
#define PIOD_PER_P0 0x1
#define PIOD_PER_P0_BIT 0
#define PIOD_PER_P1_MASK 0x2
#define PIOD_PER_P1 0x2
#define PIOD_PER_P1_BIT 1
#define PIOD_PER_P2_MASK 0x4
#define PIOD_PER_P2 0x4
#define PIOD_PER_P2_BIT 2
#define PIOD_PER_P3_MASK 0x8
#define PIOD_PER_P3 0x8
#define PIOD_PER_P3_BIT 3
#define PIOD_PER_P4_MASK 0x10
#define PIOD_PER_P4 0x10
#define PIOD_PER_P4_BIT 4
#define PIOD_PER_P5_MASK 0x20
#define PIOD_PER_P5 0x20
#define PIOD_PER_P5_BIT 5
#define PIOD_PER_P6_MASK 0x40
#define PIOD_PER_P6 0x40
#define PIOD_PER_P6_BIT 6
#define PIOD_PER_P7_MASK 0x80
#define PIOD_PER_P7 0x80
#define PIOD_PER_P7_BIT 7
#define PIOD_PER_P8_MASK 0x100
#define PIOD_PER_P8 0x100
#define PIOD_PER_P8_BIT 8
#define PIOD_PER_P9_MASK 0x200
#define PIOD_PER_P9 0x200
#define PIOD_PER_P9_BIT 9
#define PIOD_PER_P10_MASK 0x400
#define PIOD_PER_P10 0x400
#define PIOD_PER_P10_BIT 10
#define PIOD_PER_P11_MASK 0x800
#define PIOD_PER_P11 0x800
#define PIOD_PER_P11_BIT 11
#define PIOD_PER_P12_MASK 0x1000
#define PIOD_PER_P12 0x1000
#define PIOD_PER_P12_BIT 12
#define PIOD_PER_P13_MASK 0x2000
#define PIOD_PER_P13 0x2000
#define PIOD_PER_P13_BIT 13
#define PIOD_PER_P14_MASK 0x4000
#define PIOD_PER_P14 0x4000
#define PIOD_PER_P14_BIT 14
#define PIOD_PER_P15_MASK 0x8000
#define PIOD_PER_P15 0x8000
#define PIOD_PER_P15_BIT 15
#define PIOD_PER_P16_MASK 0x10000
#define PIOD_PER_P16 0x10000
#define PIOD_PER_P16_BIT 16
#define PIOD_PER_P17_MASK 0x20000
#define PIOD_PER_P17 0x20000
#define PIOD_PER_P17_BIT 17
#define PIOD_PER_P18_MASK 0x40000
#define PIOD_PER_P18 0x40000
#define PIOD_PER_P18_BIT 18
#define PIOD_PER_P19_MASK 0x80000
#define PIOD_PER_P19 0x80000
#define PIOD_PER_P19_BIT 19
#define PIOD_PER_P20_MASK 0x100000
#define PIOD_PER_P20 0x100000
#define PIOD_PER_P20_BIT 20
#define PIOD_PER_P21_MASK 0x200000
#define PIOD_PER_P21 0x200000
#define PIOD_PER_P21_BIT 21
#define PIOD_PER_P22_MASK 0x400000
#define PIOD_PER_P22 0x400000
#define PIOD_PER_P22_BIT 22
#define PIOD_PER_P23_MASK 0x800000
#define PIOD_PER_P23 0x800000
#define PIOD_PER_P23_BIT 23
#define PIOD_PER_P24_MASK 0x1000000
#define PIOD_PER_P24 0x1000000
#define PIOD_PER_P24_BIT 24
#define PIOD_PER_P25_MASK 0x2000000
#define PIOD_PER_P25 0x2000000
#define PIOD_PER_P25_BIT 25
#define PIOD_PER_P26_MASK 0x4000000
#define PIOD_PER_P26 0x4000000
#define PIOD_PER_P26_BIT 26
#define PIOD_PER_P27_MASK 0x8000000
#define PIOD_PER_P27 0x8000000
#define PIOD_PER_P27_BIT 27
#define PIOD_PER_P28_MASK 0x10000000
#define PIOD_PER_P28 0x10000000
#define PIOD_PER_P28_BIT 28
#define PIOD_PER_P29_MASK 0x20000000
#define PIOD_PER_P29 0x20000000
#define PIOD_PER_P29_BIT 29
#define PIOD_PER_P30_MASK 0x40000000
#define PIOD_PER_P30 0x40000000
#define PIOD_PER_P30_BIT 30
#define PIOD_PER_P31_MASK 0x80000000
#define PIOD_PER_P31 0x80000000
#define PIOD_PER_P31_BIT 31

#define PIOD_PDR (*(volatile unsigned long *)0xFFFFFA04)
#define PIOD_PDR_OFFSET 0x4
#define PIOD_PDR_P0_MASK 0x1
#define PIOD_PDR_P0 0x1
#define PIOD_PDR_P0_BIT 0
#define PIOD_PDR_P1_MASK 0x2
#define PIOD_PDR_P1 0x2
#define PIOD_PDR_P1_BIT 1
#define PIOD_PDR_P2_MASK 0x4
#define PIOD_PDR_P2 0x4
#define PIOD_PDR_P2_BIT 2
#define PIOD_PDR_P3_MASK 0x8
#define PIOD_PDR_P3 0x8
#define PIOD_PDR_P3_BIT 3
#define PIOD_PDR_P4_MASK 0x10
#define PIOD_PDR_P4 0x10
#define PIOD_PDR_P4_BIT 4
#define PIOD_PDR_P5_MASK 0x20
#define PIOD_PDR_P5 0x20
#define PIOD_PDR_P5_BIT 5
#define PIOD_PDR_P6_MASK 0x40
#define PIOD_PDR_P6 0x40
#define PIOD_PDR_P6_BIT 6
#define PIOD_PDR_P7_MASK 0x80
#define PIOD_PDR_P7 0x80
#define PIOD_PDR_P7_BIT 7
#define PIOD_PDR_P8_MASK 0x100
#define PIOD_PDR_P8 0x100
#define PIOD_PDR_P8_BIT 8
#define PIOD_PDR_P9_MASK 0x200
#define PIOD_PDR_P9 0x200
#define PIOD_PDR_P9_BIT 9
#define PIOD_PDR_P10_MASK 0x400
#define PIOD_PDR_P10 0x400
#define PIOD_PDR_P10_BIT 10
#define PIOD_PDR_P11_MASK 0x800
#define PIOD_PDR_P11 0x800
#define PIOD_PDR_P11_BIT 11
#define PIOD_PDR_P12_MASK 0x1000
#define PIOD_PDR_P12 0x1000
#define PIOD_PDR_P12_BIT 12
#define PIOD_PDR_P13_MASK 0x2000
#define PIOD_PDR_P13 0x2000
#define PIOD_PDR_P13_BIT 13
#define PIOD_PDR_P14_MASK 0x4000
#define PIOD_PDR_P14 0x4000
#define PIOD_PDR_P14_BIT 14
#define PIOD_PDR_P15_MASK 0x8000
#define PIOD_PDR_P15 0x8000
#define PIOD_PDR_P15_BIT 15
#define PIOD_PDR_P16_MASK 0x10000
#define PIOD_PDR_P16 0x10000
#define PIOD_PDR_P16_BIT 16
#define PIOD_PDR_P17_MASK 0x20000
#define PIOD_PDR_P17 0x20000
#define PIOD_PDR_P17_BIT 17
#define PIOD_PDR_P18_MASK 0x40000
#define PIOD_PDR_P18 0x40000
#define PIOD_PDR_P18_BIT 18
#define PIOD_PDR_P19_MASK 0x80000
#define PIOD_PDR_P19 0x80000
#define PIOD_PDR_P19_BIT 19
#define PIOD_PDR_P20_MASK 0x100000
#define PIOD_PDR_P20 0x100000
#define PIOD_PDR_P20_BIT 20
#define PIOD_PDR_P21_MASK 0x200000
#define PIOD_PDR_P21 0x200000
#define PIOD_PDR_P21_BIT 21
#define PIOD_PDR_P22_MASK 0x400000
#define PIOD_PDR_P22 0x400000
#define PIOD_PDR_P22_BIT 22
#define PIOD_PDR_P23_MASK 0x800000
#define PIOD_PDR_P23 0x800000
#define PIOD_PDR_P23_BIT 23
#define PIOD_PDR_P24_MASK 0x1000000
#define PIOD_PDR_P24 0x1000000
#define PIOD_PDR_P24_BIT 24
#define PIOD_PDR_P25_MASK 0x2000000
#define PIOD_PDR_P25 0x2000000
#define PIOD_PDR_P25_BIT 25
#define PIOD_PDR_P26_MASK 0x4000000
#define PIOD_PDR_P26 0x4000000
#define PIOD_PDR_P26_BIT 26
#define PIOD_PDR_P27_MASK 0x8000000
#define PIOD_PDR_P27 0x8000000
#define PIOD_PDR_P27_BIT 27
#define PIOD_PDR_P28_MASK 0x10000000
#define PIOD_PDR_P28 0x10000000
#define PIOD_PDR_P28_BIT 28
#define PIOD_PDR_P29_MASK 0x20000000
#define PIOD_PDR_P29 0x20000000
#define PIOD_PDR_P29_BIT 29
#define PIOD_PDR_P30_MASK 0x40000000
#define PIOD_PDR_P30 0x40000000
#define PIOD_PDR_P30_BIT 30
#define PIOD_PDR_P31_MASK 0x80000000
#define PIOD_PDR_P31 0x80000000
#define PIOD_PDR_P31_BIT 31

#define PIOD_PSR (*(volatile unsigned long *)0xFFFFFA08)
#define PIOD_PSR_OFFSET 0x8
#define PIOD_PSR_P0_MASK 0x1
#define PIOD_PSR_P0 0x1
#define PIOD_PSR_P0_BIT 0
#define PIOD_PSR_P1_MASK 0x2
#define PIOD_PSR_P1 0x2
#define PIOD_PSR_P1_BIT 1
#define PIOD_PSR_P2_MASK 0x4
#define PIOD_PSR_P2 0x4
#define PIOD_PSR_P2_BIT 2
#define PIOD_PSR_P3_MASK 0x8
#define PIOD_PSR_P3 0x8
#define PIOD_PSR_P3_BIT 3
#define PIOD_PSR_P4_MASK 0x10
#define PIOD_PSR_P4 0x10
#define PIOD_PSR_P4_BIT 4
#define PIOD_PSR_P5_MASK 0x20
#define PIOD_PSR_P5 0x20
#define PIOD_PSR_P5_BIT 5
#define PIOD_PSR_P6_MASK 0x40
#define PIOD_PSR_P6 0x40
#define PIOD_PSR_P6_BIT 6
#define PIOD_PSR_P7_MASK 0x80
#define PIOD_PSR_P7 0x80
#define PIOD_PSR_P7_BIT 7
#define PIOD_PSR_P8_MASK 0x100
#define PIOD_PSR_P8 0x100
#define PIOD_PSR_P8_BIT 8
#define PIOD_PSR_P9_MASK 0x200
#define PIOD_PSR_P9 0x200
#define PIOD_PSR_P9_BIT 9
#define PIOD_PSR_P10_MASK 0x400
#define PIOD_PSR_P10 0x400
#define PIOD_PSR_P10_BIT 10
#define PIOD_PSR_P11_MASK 0x800
#define PIOD_PSR_P11 0x800
#define PIOD_PSR_P11_BIT 11
#define PIOD_PSR_P12_MASK 0x1000
#define PIOD_PSR_P12 0x1000
#define PIOD_PSR_P12_BIT 12
#define PIOD_PSR_P13_MASK 0x2000
#define PIOD_PSR_P13 0x2000
#define PIOD_PSR_P13_BIT 13
#define PIOD_PSR_P14_MASK 0x4000
#define PIOD_PSR_P14 0x4000
#define PIOD_PSR_P14_BIT 14
#define PIOD_PSR_P15_MASK 0x8000
#define PIOD_PSR_P15 0x8000
#define PIOD_PSR_P15_BIT 15
#define PIOD_PSR_P16_MASK 0x10000
#define PIOD_PSR_P16 0x10000
#define PIOD_PSR_P16_BIT 16
#define PIOD_PSR_P17_MASK 0x20000
#define PIOD_PSR_P17 0x20000
#define PIOD_PSR_P17_BIT 17
#define PIOD_PSR_P18_MASK 0x40000
#define PIOD_PSR_P18 0x40000
#define PIOD_PSR_P18_BIT 18
#define PIOD_PSR_P19_MASK 0x80000
#define PIOD_PSR_P19 0x80000
#define PIOD_PSR_P19_BIT 19
#define PIOD_PSR_P20_MASK 0x100000
#define PIOD_PSR_P20 0x100000
#define PIOD_PSR_P20_BIT 20
#define PIOD_PSR_P21_MASK 0x200000
#define PIOD_PSR_P21 0x200000
#define PIOD_PSR_P21_BIT 21
#define PIOD_PSR_P22_MASK 0x400000
#define PIOD_PSR_P22 0x400000
#define PIOD_PSR_P22_BIT 22
#define PIOD_PSR_P23_MASK 0x800000
#define PIOD_PSR_P23 0x800000
#define PIOD_PSR_P23_BIT 23
#define PIOD_PSR_P24_MASK 0x1000000
#define PIOD_PSR_P24 0x1000000
#define PIOD_PSR_P24_BIT 24
#define PIOD_PSR_P25_MASK 0x2000000
#define PIOD_PSR_P25 0x2000000
#define PIOD_PSR_P25_BIT 25
#define PIOD_PSR_P26_MASK 0x4000000
#define PIOD_PSR_P26 0x4000000
#define PIOD_PSR_P26_BIT 26
#define PIOD_PSR_P27_MASK 0x8000000
#define PIOD_PSR_P27 0x8000000
#define PIOD_PSR_P27_BIT 27
#define PIOD_PSR_P28_MASK 0x10000000
#define PIOD_PSR_P28 0x10000000
#define PIOD_PSR_P28_BIT 28
#define PIOD_PSR_P29_MASK 0x20000000
#define PIOD_PSR_P29 0x20000000
#define PIOD_PSR_P29_BIT 29
#define PIOD_PSR_P30_MASK 0x40000000
#define PIOD_PSR_P30 0x40000000
#define PIOD_PSR_P30_BIT 30
#define PIOD_PSR_P31_MASK 0x80000000
#define PIOD_PSR_P31 0x80000000
#define PIOD_PSR_P31_BIT 31

#define PIOD_OER (*(volatile unsigned long *)0xFFFFFA10)
#define PIOD_OER_OFFSET 0x10
#define PIOD_OER_P0_MASK 0x1
#define PIOD_OER_P0 0x1
#define PIOD_OER_P0_BIT 0
#define PIOD_OER_P1_MASK 0x2
#define PIOD_OER_P1 0x2
#define PIOD_OER_P1_BIT 1
#define PIOD_OER_P2_MASK 0x4
#define PIOD_OER_P2 0x4
#define PIOD_OER_P2_BIT 2
#define PIOD_OER_P3_MASK 0x8
#define PIOD_OER_P3 0x8
#define PIOD_OER_P3_BIT 3
#define PIOD_OER_P4_MASK 0x10
#define PIOD_OER_P4 0x10
#define PIOD_OER_P4_BIT 4
#define PIOD_OER_P5_MASK 0x20
#define PIOD_OER_P5 0x20
#define PIOD_OER_P5_BIT 5
#define PIOD_OER_P6_MASK 0x40
#define PIOD_OER_P6 0x40
#define PIOD_OER_P6_BIT 6
#define PIOD_OER_P7_MASK 0x80
#define PIOD_OER_P7 0x80
#define PIOD_OER_P7_BIT 7
#define PIOD_OER_P8_MASK 0x100
#define PIOD_OER_P8 0x100
#define PIOD_OER_P8_BIT 8
#define PIOD_OER_P9_MASK 0x200
#define PIOD_OER_P9 0x200
#define PIOD_OER_P9_BIT 9
#define PIOD_OER_P10_MASK 0x400
#define PIOD_OER_P10 0x400
#define PIOD_OER_P10_BIT 10
#define PIOD_OER_P11_MASK 0x800
#define PIOD_OER_P11 0x800
#define PIOD_OER_P11_BIT 11
#define PIOD_OER_P12_MASK 0x1000
#define PIOD_OER_P12 0x1000
#define PIOD_OER_P12_BIT 12
#define PIOD_OER_P13_MASK 0x2000
#define PIOD_OER_P13 0x2000
#define PIOD_OER_P13_BIT 13
#define PIOD_OER_P14_MASK 0x4000
#define PIOD_OER_P14 0x4000
#define PIOD_OER_P14_BIT 14
#define PIOD_OER_P15_MASK 0x8000
#define PIOD_OER_P15 0x8000
#define PIOD_OER_P15_BIT 15
#define PIOD_OER_P16_MASK 0x10000
#define PIOD_OER_P16 0x10000
#define PIOD_OER_P16_BIT 16
#define PIOD_OER_P17_MASK 0x20000
#define PIOD_OER_P17 0x20000
#define PIOD_OER_P17_BIT 17
#define PIOD_OER_P18_MASK 0x40000
#define PIOD_OER_P18 0x40000
#define PIOD_OER_P18_BIT 18
#define PIOD_OER_P19_MASK 0x80000
#define PIOD_OER_P19 0x80000
#define PIOD_OER_P19_BIT 19
#define PIOD_OER_P20_MASK 0x100000
#define PIOD_OER_P20 0x100000
#define PIOD_OER_P20_BIT 20
#define PIOD_OER_P21_MASK 0x200000
#define PIOD_OER_P21 0x200000
#define PIOD_OER_P21_BIT 21
#define PIOD_OER_P22_MASK 0x400000
#define PIOD_OER_P22 0x400000
#define PIOD_OER_P22_BIT 22
#define PIOD_OER_P23_MASK 0x800000
#define PIOD_OER_P23 0x800000
#define PIOD_OER_P23_BIT 23
#define PIOD_OER_P24_MASK 0x1000000
#define PIOD_OER_P24 0x1000000
#define PIOD_OER_P24_BIT 24
#define PIOD_OER_P25_MASK 0x2000000
#define PIOD_OER_P25 0x2000000
#define PIOD_OER_P25_BIT 25
#define PIOD_OER_P26_MASK 0x4000000
#define PIOD_OER_P26 0x4000000
#define PIOD_OER_P26_BIT 26
#define PIOD_OER_P27_MASK 0x8000000
#define PIOD_OER_P27 0x8000000
#define PIOD_OER_P27_BIT 27
#define PIOD_OER_P28_MASK 0x10000000
#define PIOD_OER_P28 0x10000000
#define PIOD_OER_P28_BIT 28
#define PIOD_OER_P29_MASK 0x20000000
#define PIOD_OER_P29 0x20000000
#define PIOD_OER_P29_BIT 29
#define PIOD_OER_P30_MASK 0x40000000
#define PIOD_OER_P30 0x40000000
#define PIOD_OER_P30_BIT 30
#define PIOD_OER_P31_MASK 0x80000000
#define PIOD_OER_P31 0x80000000
#define PIOD_OER_P31_BIT 31

#define PIOD_ODR (*(volatile unsigned long *)0xFFFFFA14)
#define PIOD_ODR_OFFSET 0x14
#define PIOD_ODR_P0_MASK 0x1
#define PIOD_ODR_P0 0x1
#define PIOD_ODR_P0_BIT 0
#define PIOD_ODR_P1_MASK 0x2
#define PIOD_ODR_P1 0x2
#define PIOD_ODR_P1_BIT 1
#define PIOD_ODR_P2_MASK 0x4
#define PIOD_ODR_P2 0x4
#define PIOD_ODR_P2_BIT 2
#define PIOD_ODR_P3_MASK 0x8
#define PIOD_ODR_P3 0x8
#define PIOD_ODR_P3_BIT 3
#define PIOD_ODR_P4_MASK 0x10
#define PIOD_ODR_P4 0x10
#define PIOD_ODR_P4_BIT 4
#define PIOD_ODR_P5_MASK 0x20
#define PIOD_ODR_P5 0x20
#define PIOD_ODR_P5_BIT 5
#define PIOD_ODR_P6_MASK 0x40
#define PIOD_ODR_P6 0x40
#define PIOD_ODR_P6_BIT 6
#define PIOD_ODR_P7_MASK 0x80
#define PIOD_ODR_P7 0x80
#define PIOD_ODR_P7_BIT 7
#define PIOD_ODR_P8_MASK 0x100
#define PIOD_ODR_P8 0x100
#define PIOD_ODR_P8_BIT 8
#define PIOD_ODR_P9_MASK 0x200
#define PIOD_ODR_P9 0x200
#define PIOD_ODR_P9_BIT 9
#define PIOD_ODR_P10_MASK 0x400
#define PIOD_ODR_P10 0x400
#define PIOD_ODR_P10_BIT 10
#define PIOD_ODR_P11_MASK 0x800
#define PIOD_ODR_P11 0x800
#define PIOD_ODR_P11_BIT 11
#define PIOD_ODR_P12_MASK 0x1000
#define PIOD_ODR_P12 0x1000
#define PIOD_ODR_P12_BIT 12
#define PIOD_ODR_P13_MASK 0x2000
#define PIOD_ODR_P13 0x2000
#define PIOD_ODR_P13_BIT 13
#define PIOD_ODR_P14_MASK 0x4000
#define PIOD_ODR_P14 0x4000
#define PIOD_ODR_P14_BIT 14
#define PIOD_ODR_P15_MASK 0x8000
#define PIOD_ODR_P15 0x8000
#define PIOD_ODR_P15_BIT 15
#define PIOD_ODR_P16_MASK 0x10000
#define PIOD_ODR_P16 0x10000
#define PIOD_ODR_P16_BIT 16
#define PIOD_ODR_P17_MASK 0x20000
#define PIOD_ODR_P17 0x20000
#define PIOD_ODR_P17_BIT 17
#define PIOD_ODR_P18_MASK 0x40000
#define PIOD_ODR_P18 0x40000
#define PIOD_ODR_P18_BIT 18
#define PIOD_ODR_P19_MASK 0x80000
#define PIOD_ODR_P19 0x80000
#define PIOD_ODR_P19_BIT 19
#define PIOD_ODR_P20_MASK 0x100000
#define PIOD_ODR_P20 0x100000
#define PIOD_ODR_P20_BIT 20
#define PIOD_ODR_P21_MASK 0x200000
#define PIOD_ODR_P21 0x200000
#define PIOD_ODR_P21_BIT 21
#define PIOD_ODR_P22_MASK 0x400000
#define PIOD_ODR_P22 0x400000
#define PIOD_ODR_P22_BIT 22
#define PIOD_ODR_P23_MASK 0x800000
#define PIOD_ODR_P23 0x800000
#define PIOD_ODR_P23_BIT 23
#define PIOD_ODR_P24_MASK 0x1000000
#define PIOD_ODR_P24 0x1000000
#define PIOD_ODR_P24_BIT 24
#define PIOD_ODR_P25_MASK 0x2000000
#define PIOD_ODR_P25 0x2000000
#define PIOD_ODR_P25_BIT 25
#define PIOD_ODR_P26_MASK 0x4000000
#define PIOD_ODR_P26 0x4000000
#define PIOD_ODR_P26_BIT 26
#define PIOD_ODR_P27_MASK 0x8000000
#define PIOD_ODR_P27 0x8000000
#define PIOD_ODR_P27_BIT 27
#define PIOD_ODR_P28_MASK 0x10000000
#define PIOD_ODR_P28 0x10000000
#define PIOD_ODR_P28_BIT 28
#define PIOD_ODR_P29_MASK 0x20000000
#define PIOD_ODR_P29 0x20000000
#define PIOD_ODR_P29_BIT 29
#define PIOD_ODR_P30_MASK 0x40000000
#define PIOD_ODR_P30 0x40000000
#define PIOD_ODR_P30_BIT 30
#define PIOD_ODR_P31_MASK 0x80000000
#define PIOD_ODR_P31 0x80000000
#define PIOD_ODR_P31_BIT 31

#define PIOD_OSR (*(volatile unsigned long *)0xFFFFFA18)
#define PIOD_OSR_OFFSET 0x18
#define PIOD_OSR_P0_MASK 0x1
#define PIOD_OSR_P0 0x1
#define PIOD_OSR_P0_BIT 0
#define PIOD_OSR_P1_MASK 0x2
#define PIOD_OSR_P1 0x2
#define PIOD_OSR_P1_BIT 1
#define PIOD_OSR_P2_MASK 0x4
#define PIOD_OSR_P2 0x4
#define PIOD_OSR_P2_BIT 2
#define PIOD_OSR_P3_MASK 0x8
#define PIOD_OSR_P3 0x8
#define PIOD_OSR_P3_BIT 3
#define PIOD_OSR_P4_MASK 0x10
#define PIOD_OSR_P4 0x10
#define PIOD_OSR_P4_BIT 4
#define PIOD_OSR_P5_MASK 0x20
#define PIOD_OSR_P5 0x20
#define PIOD_OSR_P5_BIT 5
#define PIOD_OSR_P6_MASK 0x40
#define PIOD_OSR_P6 0x40
#define PIOD_OSR_P6_BIT 6
#define PIOD_OSR_P7_MASK 0x80
#define PIOD_OSR_P7 0x80
#define PIOD_OSR_P7_BIT 7
#define PIOD_OSR_P8_MASK 0x100
#define PIOD_OSR_P8 0x100
#define PIOD_OSR_P8_BIT 8
#define PIOD_OSR_P9_MASK 0x200
#define PIOD_OSR_P9 0x200
#define PIOD_OSR_P9_BIT 9
#define PIOD_OSR_P10_MASK 0x400
#define PIOD_OSR_P10 0x400
#define PIOD_OSR_P10_BIT 10
#define PIOD_OSR_P11_MASK 0x800
#define PIOD_OSR_P11 0x800
#define PIOD_OSR_P11_BIT 11
#define PIOD_OSR_P12_MASK 0x1000
#define PIOD_OSR_P12 0x1000
#define PIOD_OSR_P12_BIT 12
#define PIOD_OSR_P13_MASK 0x2000
#define PIOD_OSR_P13 0x2000
#define PIOD_OSR_P13_BIT 13
#define PIOD_OSR_P14_MASK 0x4000
#define PIOD_OSR_P14 0x4000
#define PIOD_OSR_P14_BIT 14
#define PIOD_OSR_P15_MASK 0x8000
#define PIOD_OSR_P15 0x8000
#define PIOD_OSR_P15_BIT 15
#define PIOD_OSR_P16_MASK 0x10000
#define PIOD_OSR_P16 0x10000
#define PIOD_OSR_P16_BIT 16
#define PIOD_OSR_P17_MASK 0x20000
#define PIOD_OSR_P17 0x20000
#define PIOD_OSR_P17_BIT 17
#define PIOD_OSR_P18_MASK 0x40000
#define PIOD_OSR_P18 0x40000
#define PIOD_OSR_P18_BIT 18
#define PIOD_OSR_P19_MASK 0x80000
#define PIOD_OSR_P19 0x80000
#define PIOD_OSR_P19_BIT 19
#define PIOD_OSR_P20_MASK 0x100000
#define PIOD_OSR_P20 0x100000
#define PIOD_OSR_P20_BIT 20
#define PIOD_OSR_P21_MASK 0x200000
#define PIOD_OSR_P21 0x200000
#define PIOD_OSR_P21_BIT 21
#define PIOD_OSR_P22_MASK 0x400000
#define PIOD_OSR_P22 0x400000
#define PIOD_OSR_P22_BIT 22
#define PIOD_OSR_P23_MASK 0x800000
#define PIOD_OSR_P23 0x800000
#define PIOD_OSR_P23_BIT 23
#define PIOD_OSR_P24_MASK 0x1000000
#define PIOD_OSR_P24 0x1000000
#define PIOD_OSR_P24_BIT 24
#define PIOD_OSR_P25_MASK 0x2000000
#define PIOD_OSR_P25 0x2000000
#define PIOD_OSR_P25_BIT 25
#define PIOD_OSR_P26_MASK 0x4000000
#define PIOD_OSR_P26 0x4000000
#define PIOD_OSR_P26_BIT 26
#define PIOD_OSR_P27_MASK 0x8000000
#define PIOD_OSR_P27 0x8000000
#define PIOD_OSR_P27_BIT 27
#define PIOD_OSR_P28_MASK 0x10000000
#define PIOD_OSR_P28 0x10000000
#define PIOD_OSR_P28_BIT 28
#define PIOD_OSR_P29_MASK 0x20000000
#define PIOD_OSR_P29 0x20000000
#define PIOD_OSR_P29_BIT 29
#define PIOD_OSR_P30_MASK 0x40000000
#define PIOD_OSR_P30 0x40000000
#define PIOD_OSR_P30_BIT 30
#define PIOD_OSR_P31_MASK 0x80000000
#define PIOD_OSR_P31 0x80000000
#define PIOD_OSR_P31_BIT 31

#define PIOD_IFER (*(volatile unsigned long *)0xFFFFFA20)
#define PIOD_IFER_OFFSET 0x20
#define PIOD_IFER_P0_MASK 0x1
#define PIOD_IFER_P0 0x1
#define PIOD_IFER_P0_BIT 0
#define PIOD_IFER_P1_MASK 0x2
#define PIOD_IFER_P1 0x2
#define PIOD_IFER_P1_BIT 1
#define PIOD_IFER_P2_MASK 0x4
#define PIOD_IFER_P2 0x4
#define PIOD_IFER_P2_BIT 2
#define PIOD_IFER_P3_MASK 0x8
#define PIOD_IFER_P3 0x8
#define PIOD_IFER_P3_BIT 3
#define PIOD_IFER_P4_MASK 0x10
#define PIOD_IFER_P4 0x10
#define PIOD_IFER_P4_BIT 4
#define PIOD_IFER_P5_MASK 0x20
#define PIOD_IFER_P5 0x20
#define PIOD_IFER_P5_BIT 5
#define PIOD_IFER_P6_MASK 0x40
#define PIOD_IFER_P6 0x40
#define PIOD_IFER_P6_BIT 6
#define PIOD_IFER_P7_MASK 0x80
#define PIOD_IFER_P7 0x80
#define PIOD_IFER_P7_BIT 7
#define PIOD_IFER_P8_MASK 0x100
#define PIOD_IFER_P8 0x100
#define PIOD_IFER_P8_BIT 8
#define PIOD_IFER_P9_MASK 0x200
#define PIOD_IFER_P9 0x200
#define PIOD_IFER_P9_BIT 9
#define PIOD_IFER_P10_MASK 0x400
#define PIOD_IFER_P10 0x400
#define PIOD_IFER_P10_BIT 10
#define PIOD_IFER_P11_MASK 0x800
#define PIOD_IFER_P11 0x800
#define PIOD_IFER_P11_BIT 11
#define PIOD_IFER_P12_MASK 0x1000
#define PIOD_IFER_P12 0x1000
#define PIOD_IFER_P12_BIT 12
#define PIOD_IFER_P13_MASK 0x2000
#define PIOD_IFER_P13 0x2000
#define PIOD_IFER_P13_BIT 13
#define PIOD_IFER_P14_MASK 0x4000
#define PIOD_IFER_P14 0x4000
#define PIOD_IFER_P14_BIT 14
#define PIOD_IFER_P15_MASK 0x8000
#define PIOD_IFER_P15 0x8000
#define PIOD_IFER_P15_BIT 15
#define PIOD_IFER_P16_MASK 0x10000
#define PIOD_IFER_P16 0x10000
#define PIOD_IFER_P16_BIT 16
#define PIOD_IFER_P17_MASK 0x20000
#define PIOD_IFER_P17 0x20000
#define PIOD_IFER_P17_BIT 17
#define PIOD_IFER_P18_MASK 0x40000
#define PIOD_IFER_P18 0x40000
#define PIOD_IFER_P18_BIT 18
#define PIOD_IFER_P19_MASK 0x80000
#define PIOD_IFER_P19 0x80000
#define PIOD_IFER_P19_BIT 19
#define PIOD_IFER_P20_MASK 0x100000
#define PIOD_IFER_P20 0x100000
#define PIOD_IFER_P20_BIT 20
#define PIOD_IFER_P21_MASK 0x200000
#define PIOD_IFER_P21 0x200000
#define PIOD_IFER_P21_BIT 21
#define PIOD_IFER_P22_MASK 0x400000
#define PIOD_IFER_P22 0x400000
#define PIOD_IFER_P22_BIT 22
#define PIOD_IFER_P23_MASK 0x800000
#define PIOD_IFER_P23 0x800000
#define PIOD_IFER_P23_BIT 23
#define PIOD_IFER_P24_MASK 0x1000000
#define PIOD_IFER_P24 0x1000000
#define PIOD_IFER_P24_BIT 24
#define PIOD_IFER_P25_MASK 0x2000000
#define PIOD_IFER_P25 0x2000000
#define PIOD_IFER_P25_BIT 25
#define PIOD_IFER_P26_MASK 0x4000000
#define PIOD_IFER_P26 0x4000000
#define PIOD_IFER_P26_BIT 26
#define PIOD_IFER_P27_MASK 0x8000000
#define PIOD_IFER_P27 0x8000000
#define PIOD_IFER_P27_BIT 27
#define PIOD_IFER_P28_MASK 0x10000000
#define PIOD_IFER_P28 0x10000000
#define PIOD_IFER_P28_BIT 28
#define PIOD_IFER_P29_MASK 0x20000000
#define PIOD_IFER_P29 0x20000000
#define PIOD_IFER_P29_BIT 29
#define PIOD_IFER_P30_MASK 0x40000000
#define PIOD_IFER_P30 0x40000000
#define PIOD_IFER_P30_BIT 30
#define PIOD_IFER_P31_MASK 0x80000000
#define PIOD_IFER_P31 0x80000000
#define PIOD_IFER_P31_BIT 31

#define PIOD_IFDR (*(volatile unsigned long *)0xFFFFFA24)
#define PIOD_IFDR_OFFSET 0x24
#define PIOD_IFDR_P0_MASK 0x1
#define PIOD_IFDR_P0 0x1
#define PIOD_IFDR_P0_BIT 0
#define PIOD_IFDR_P1_MASK 0x2
#define PIOD_IFDR_P1 0x2
#define PIOD_IFDR_P1_BIT 1
#define PIOD_IFDR_P2_MASK 0x4
#define PIOD_IFDR_P2 0x4
#define PIOD_IFDR_P2_BIT 2
#define PIOD_IFDR_P3_MASK 0x8
#define PIOD_IFDR_P3 0x8
#define PIOD_IFDR_P3_BIT 3
#define PIOD_IFDR_P4_MASK 0x10
#define PIOD_IFDR_P4 0x10
#define PIOD_IFDR_P4_BIT 4
#define PIOD_IFDR_P5_MASK 0x20
#define PIOD_IFDR_P5 0x20
#define PIOD_IFDR_P5_BIT 5
#define PIOD_IFDR_P6_MASK 0x40
#define PIOD_IFDR_P6 0x40
#define PIOD_IFDR_P6_BIT 6
#define PIOD_IFDR_P7_MASK 0x80
#define PIOD_IFDR_P7 0x80
#define PIOD_IFDR_P7_BIT 7
#define PIOD_IFDR_P8_MASK 0x100
#define PIOD_IFDR_P8 0x100
#define PIOD_IFDR_P8_BIT 8
#define PIOD_IFDR_P9_MASK 0x200
#define PIOD_IFDR_P9 0x200
#define PIOD_IFDR_P9_BIT 9
#define PIOD_IFDR_P10_MASK 0x400
#define PIOD_IFDR_P10 0x400
#define PIOD_IFDR_P10_BIT 10
#define PIOD_IFDR_P11_MASK 0x800
#define PIOD_IFDR_P11 0x800
#define PIOD_IFDR_P11_BIT 11
#define PIOD_IFDR_P12_MASK 0x1000
#define PIOD_IFDR_P12 0x1000
#define PIOD_IFDR_P12_BIT 12
#define PIOD_IFDR_P13_MASK 0x2000
#define PIOD_IFDR_P13 0x2000
#define PIOD_IFDR_P13_BIT 13
#define PIOD_IFDR_P14_MASK 0x4000
#define PIOD_IFDR_P14 0x4000
#define PIOD_IFDR_P14_BIT 14
#define PIOD_IFDR_P15_MASK 0x8000
#define PIOD_IFDR_P15 0x8000
#define PIOD_IFDR_P15_BIT 15
#define PIOD_IFDR_P16_MASK 0x10000
#define PIOD_IFDR_P16 0x10000
#define PIOD_IFDR_P16_BIT 16
#define PIOD_IFDR_P17_MASK 0x20000
#define PIOD_IFDR_P17 0x20000
#define PIOD_IFDR_P17_BIT 17
#define PIOD_IFDR_P18_MASK 0x40000
#define PIOD_IFDR_P18 0x40000
#define PIOD_IFDR_P18_BIT 18
#define PIOD_IFDR_P19_MASK 0x80000
#define PIOD_IFDR_P19 0x80000
#define PIOD_IFDR_P19_BIT 19
#define PIOD_IFDR_P20_MASK 0x100000
#define PIOD_IFDR_P20 0x100000
#define PIOD_IFDR_P20_BIT 20
#define PIOD_IFDR_P21_MASK 0x200000
#define PIOD_IFDR_P21 0x200000
#define PIOD_IFDR_P21_BIT 21
#define PIOD_IFDR_P22_MASK 0x400000
#define PIOD_IFDR_P22 0x400000
#define PIOD_IFDR_P22_BIT 22
#define PIOD_IFDR_P23_MASK 0x800000
#define PIOD_IFDR_P23 0x800000
#define PIOD_IFDR_P23_BIT 23
#define PIOD_IFDR_P24_MASK 0x1000000
#define PIOD_IFDR_P24 0x1000000
#define PIOD_IFDR_P24_BIT 24
#define PIOD_IFDR_P25_MASK 0x2000000
#define PIOD_IFDR_P25 0x2000000
#define PIOD_IFDR_P25_BIT 25
#define PIOD_IFDR_P26_MASK 0x4000000
#define PIOD_IFDR_P26 0x4000000
#define PIOD_IFDR_P26_BIT 26
#define PIOD_IFDR_P27_MASK 0x8000000
#define PIOD_IFDR_P27 0x8000000
#define PIOD_IFDR_P27_BIT 27
#define PIOD_IFDR_P28_MASK 0x10000000
#define PIOD_IFDR_P28 0x10000000
#define PIOD_IFDR_P28_BIT 28
#define PIOD_IFDR_P29_MASK 0x20000000
#define PIOD_IFDR_P29 0x20000000
#define PIOD_IFDR_P29_BIT 29
#define PIOD_IFDR_P30_MASK 0x40000000
#define PIOD_IFDR_P30 0x40000000
#define PIOD_IFDR_P30_BIT 30
#define PIOD_IFDR_P31_MASK 0x80000000
#define PIOD_IFDR_P31 0x80000000
#define PIOD_IFDR_P31_BIT 31

#define PIOD_IFSR (*(volatile unsigned long *)0xFFFFFA28)
#define PIOD_IFSR_OFFSET 0x28
#define PIOD_IFSR_P0_MASK 0x1
#define PIOD_IFSR_P0 0x1
#define PIOD_IFSR_P0_BIT 0
#define PIOD_IFSR_P1_MASK 0x2
#define PIOD_IFSR_P1 0x2
#define PIOD_IFSR_P1_BIT 1
#define PIOD_IFSR_P2_MASK 0x4
#define PIOD_IFSR_P2 0x4
#define PIOD_IFSR_P2_BIT 2
#define PIOD_IFSR_P3_MASK 0x8
#define PIOD_IFSR_P3 0x8
#define PIOD_IFSR_P3_BIT 3
#define PIOD_IFSR_P4_MASK 0x10
#define PIOD_IFSR_P4 0x10
#define PIOD_IFSR_P4_BIT 4
#define PIOD_IFSR_P5_MASK 0x20
#define PIOD_IFSR_P5 0x20
#define PIOD_IFSR_P5_BIT 5
#define PIOD_IFSR_P6_MASK 0x40
#define PIOD_IFSR_P6 0x40
#define PIOD_IFSR_P6_BIT 6
#define PIOD_IFSR_P7_MASK 0x80
#define PIOD_IFSR_P7 0x80
#define PIOD_IFSR_P7_BIT 7
#define PIOD_IFSR_P8_MASK 0x100
#define PIOD_IFSR_P8 0x100
#define PIOD_IFSR_P8_BIT 8
#define PIOD_IFSR_P9_MASK 0x200
#define PIOD_IFSR_P9 0x200
#define PIOD_IFSR_P9_BIT 9
#define PIOD_IFSR_P10_MASK 0x400
#define PIOD_IFSR_P10 0x400
#define PIOD_IFSR_P10_BIT 10
#define PIOD_IFSR_P11_MASK 0x800
#define PIOD_IFSR_P11 0x800
#define PIOD_IFSR_P11_BIT 11
#define PIOD_IFSR_P12_MASK 0x1000
#define PIOD_IFSR_P12 0x1000
#define PIOD_IFSR_P12_BIT 12
#define PIOD_IFSR_P13_MASK 0x2000
#define PIOD_IFSR_P13 0x2000
#define PIOD_IFSR_P13_BIT 13
#define PIOD_IFSR_P14_MASK 0x4000
#define PIOD_IFSR_P14 0x4000
#define PIOD_IFSR_P14_BIT 14
#define PIOD_IFSR_P15_MASK 0x8000
#define PIOD_IFSR_P15 0x8000
#define PIOD_IFSR_P15_BIT 15
#define PIOD_IFSR_P16_MASK 0x10000
#define PIOD_IFSR_P16 0x10000
#define PIOD_IFSR_P16_BIT 16
#define PIOD_IFSR_P17_MASK 0x20000
#define PIOD_IFSR_P17 0x20000
#define PIOD_IFSR_P17_BIT 17
#define PIOD_IFSR_P18_MASK 0x40000
#define PIOD_IFSR_P18 0x40000
#define PIOD_IFSR_P18_BIT 18
#define PIOD_IFSR_P19_MASK 0x80000
#define PIOD_IFSR_P19 0x80000
#define PIOD_IFSR_P19_BIT 19
#define PIOD_IFSR_P20_MASK 0x100000
#define PIOD_IFSR_P20 0x100000
#define PIOD_IFSR_P20_BIT 20
#define PIOD_IFSR_P21_MASK 0x200000
#define PIOD_IFSR_P21 0x200000
#define PIOD_IFSR_P21_BIT 21
#define PIOD_IFSR_P22_MASK 0x400000
#define PIOD_IFSR_P22 0x400000
#define PIOD_IFSR_P22_BIT 22
#define PIOD_IFSR_P23_MASK 0x800000
#define PIOD_IFSR_P23 0x800000
#define PIOD_IFSR_P23_BIT 23
#define PIOD_IFSR_P24_MASK 0x1000000
#define PIOD_IFSR_P24 0x1000000
#define PIOD_IFSR_P24_BIT 24
#define PIOD_IFSR_P25_MASK 0x2000000
#define PIOD_IFSR_P25 0x2000000
#define PIOD_IFSR_P25_BIT 25
#define PIOD_IFSR_P26_MASK 0x4000000
#define PIOD_IFSR_P26 0x4000000
#define PIOD_IFSR_P26_BIT 26
#define PIOD_IFSR_P27_MASK 0x8000000
#define PIOD_IFSR_P27 0x8000000
#define PIOD_IFSR_P27_BIT 27
#define PIOD_IFSR_P28_MASK 0x10000000
#define PIOD_IFSR_P28 0x10000000
#define PIOD_IFSR_P28_BIT 28
#define PIOD_IFSR_P29_MASK 0x20000000
#define PIOD_IFSR_P29 0x20000000
#define PIOD_IFSR_P29_BIT 29
#define PIOD_IFSR_P30_MASK 0x40000000
#define PIOD_IFSR_P30 0x40000000
#define PIOD_IFSR_P30_BIT 30
#define PIOD_IFSR_P31_MASK 0x80000000
#define PIOD_IFSR_P31 0x80000000
#define PIOD_IFSR_P31_BIT 31

#define PIOD_SODR (*(volatile unsigned long *)0xFFFFFA30)
#define PIOD_SODR_OFFSET 0x30
#define PIOD_SODR_P0_MASK 0x1
#define PIOD_SODR_P0 0x1
#define PIOD_SODR_P0_BIT 0
#define PIOD_SODR_P1_MASK 0x2
#define PIOD_SODR_P1 0x2
#define PIOD_SODR_P1_BIT 1
#define PIOD_SODR_P2_MASK 0x4
#define PIOD_SODR_P2 0x4
#define PIOD_SODR_P2_BIT 2
#define PIOD_SODR_P3_MASK 0x8
#define PIOD_SODR_P3 0x8
#define PIOD_SODR_P3_BIT 3
#define PIOD_SODR_P4_MASK 0x10
#define PIOD_SODR_P4 0x10
#define PIOD_SODR_P4_BIT 4
#define PIOD_SODR_P5_MASK 0x20
#define PIOD_SODR_P5 0x20
#define PIOD_SODR_P5_BIT 5
#define PIOD_SODR_P6_MASK 0x40
#define PIOD_SODR_P6 0x40
#define PIOD_SODR_P6_BIT 6
#define PIOD_SODR_P7_MASK 0x80
#define PIOD_SODR_P7 0x80
#define PIOD_SODR_P7_BIT 7
#define PIOD_SODR_P8_MASK 0x100
#define PIOD_SODR_P8 0x100
#define PIOD_SODR_P8_BIT 8
#define PIOD_SODR_P9_MASK 0x200
#define PIOD_SODR_P9 0x200
#define PIOD_SODR_P9_BIT 9
#define PIOD_SODR_P10_MASK 0x400
#define PIOD_SODR_P10 0x400
#define PIOD_SODR_P10_BIT 10
#define PIOD_SODR_P11_MASK 0x800
#define PIOD_SODR_P11 0x800
#define PIOD_SODR_P11_BIT 11
#define PIOD_SODR_P12_MASK 0x1000
#define PIOD_SODR_P12 0x1000
#define PIOD_SODR_P12_BIT 12
#define PIOD_SODR_P13_MASK 0x2000
#define PIOD_SODR_P13 0x2000
#define PIOD_SODR_P13_BIT 13
#define PIOD_SODR_P14_MASK 0x4000
#define PIOD_SODR_P14 0x4000
#define PIOD_SODR_P14_BIT 14
#define PIOD_SODR_P15_MASK 0x8000
#define PIOD_SODR_P15 0x8000
#define PIOD_SODR_P15_BIT 15
#define PIOD_SODR_P16_MASK 0x10000
#define PIOD_SODR_P16 0x10000
#define PIOD_SODR_P16_BIT 16
#define PIOD_SODR_P17_MASK 0x20000
#define PIOD_SODR_P17 0x20000
#define PIOD_SODR_P17_BIT 17
#define PIOD_SODR_P18_MASK 0x40000
#define PIOD_SODR_P18 0x40000
#define PIOD_SODR_P18_BIT 18
#define PIOD_SODR_P19_MASK 0x80000
#define PIOD_SODR_P19 0x80000
#define PIOD_SODR_P19_BIT 19
#define PIOD_SODR_P20_MASK 0x100000
#define PIOD_SODR_P20 0x100000
#define PIOD_SODR_P20_BIT 20
#define PIOD_SODR_P21_MASK 0x200000
#define PIOD_SODR_P21 0x200000
#define PIOD_SODR_P21_BIT 21
#define PIOD_SODR_P22_MASK 0x400000
#define PIOD_SODR_P22 0x400000
#define PIOD_SODR_P22_BIT 22
#define PIOD_SODR_P23_MASK 0x800000
#define PIOD_SODR_P23 0x800000
#define PIOD_SODR_P23_BIT 23
#define PIOD_SODR_P24_MASK 0x1000000
#define PIOD_SODR_P24 0x1000000
#define PIOD_SODR_P24_BIT 24
#define PIOD_SODR_P25_MASK 0x2000000
#define PIOD_SODR_P25 0x2000000
#define PIOD_SODR_P25_BIT 25
#define PIOD_SODR_P26_MASK 0x4000000
#define PIOD_SODR_P26 0x4000000
#define PIOD_SODR_P26_BIT 26
#define PIOD_SODR_P27_MASK 0x8000000
#define PIOD_SODR_P27 0x8000000
#define PIOD_SODR_P27_BIT 27
#define PIOD_SODR_P28_MASK 0x10000000
#define PIOD_SODR_P28 0x10000000
#define PIOD_SODR_P28_BIT 28
#define PIOD_SODR_P29_MASK 0x20000000
#define PIOD_SODR_P29 0x20000000
#define PIOD_SODR_P29_BIT 29
#define PIOD_SODR_P30_MASK 0x40000000
#define PIOD_SODR_P30 0x40000000
#define PIOD_SODR_P30_BIT 30
#define PIOD_SODR_P31_MASK 0x80000000
#define PIOD_SODR_P31 0x80000000
#define PIOD_SODR_P31_BIT 31

#define PIOD_CODR (*(volatile unsigned long *)0xFFFFFA34)
#define PIOD_CODR_OFFSET 0x34
#define PIOD_CODR_P0_MASK 0x1
#define PIOD_CODR_P0 0x1
#define PIOD_CODR_P0_BIT 0
#define PIOD_CODR_P1_MASK 0x2
#define PIOD_CODR_P1 0x2
#define PIOD_CODR_P1_BIT 1
#define PIOD_CODR_P2_MASK 0x4
#define PIOD_CODR_P2 0x4
#define PIOD_CODR_P2_BIT 2
#define PIOD_CODR_P3_MASK 0x8
#define PIOD_CODR_P3 0x8
#define PIOD_CODR_P3_BIT 3
#define PIOD_CODR_P4_MASK 0x10
#define PIOD_CODR_P4 0x10
#define PIOD_CODR_P4_BIT 4
#define PIOD_CODR_P5_MASK 0x20
#define PIOD_CODR_P5 0x20
#define PIOD_CODR_P5_BIT 5
#define PIOD_CODR_P6_MASK 0x40
#define PIOD_CODR_P6 0x40
#define PIOD_CODR_P6_BIT 6
#define PIOD_CODR_P7_MASK 0x80
#define PIOD_CODR_P7 0x80
#define PIOD_CODR_P7_BIT 7
#define PIOD_CODR_P8_MASK 0x100
#define PIOD_CODR_P8 0x100
#define PIOD_CODR_P8_BIT 8
#define PIOD_CODR_P9_MASK 0x200
#define PIOD_CODR_P9 0x200
#define PIOD_CODR_P9_BIT 9
#define PIOD_CODR_P10_MASK 0x400
#define PIOD_CODR_P10 0x400
#define PIOD_CODR_P10_BIT 10
#define PIOD_CODR_P11_MASK 0x800
#define PIOD_CODR_P11 0x800
#define PIOD_CODR_P11_BIT 11
#define PIOD_CODR_P12_MASK 0x1000
#define PIOD_CODR_P12 0x1000
#define PIOD_CODR_P12_BIT 12
#define PIOD_CODR_P13_MASK 0x2000
#define PIOD_CODR_P13 0x2000
#define PIOD_CODR_P13_BIT 13
#define PIOD_CODR_P14_MASK 0x4000
#define PIOD_CODR_P14 0x4000
#define PIOD_CODR_P14_BIT 14
#define PIOD_CODR_P15_MASK 0x8000
#define PIOD_CODR_P15 0x8000
#define PIOD_CODR_P15_BIT 15
#define PIOD_CODR_P16_MASK 0x10000
#define PIOD_CODR_P16 0x10000
#define PIOD_CODR_P16_BIT 16
#define PIOD_CODR_P17_MASK 0x20000
#define PIOD_CODR_P17 0x20000
#define PIOD_CODR_P17_BIT 17
#define PIOD_CODR_P18_MASK 0x40000
#define PIOD_CODR_P18 0x40000
#define PIOD_CODR_P18_BIT 18
#define PIOD_CODR_P19_MASK 0x80000
#define PIOD_CODR_P19 0x80000
#define PIOD_CODR_P19_BIT 19
#define PIOD_CODR_P20_MASK 0x100000
#define PIOD_CODR_P20 0x100000
#define PIOD_CODR_P20_BIT 20
#define PIOD_CODR_P21_MASK 0x200000
#define PIOD_CODR_P21 0x200000
#define PIOD_CODR_P21_BIT 21
#define PIOD_CODR_P22_MASK 0x400000
#define PIOD_CODR_P22 0x400000
#define PIOD_CODR_P22_BIT 22
#define PIOD_CODR_P23_MASK 0x800000
#define PIOD_CODR_P23 0x800000
#define PIOD_CODR_P23_BIT 23
#define PIOD_CODR_P24_MASK 0x1000000
#define PIOD_CODR_P24 0x1000000
#define PIOD_CODR_P24_BIT 24
#define PIOD_CODR_P25_MASK 0x2000000
#define PIOD_CODR_P25 0x2000000
#define PIOD_CODR_P25_BIT 25
#define PIOD_CODR_P26_MASK 0x4000000
#define PIOD_CODR_P26 0x4000000
#define PIOD_CODR_P26_BIT 26
#define PIOD_CODR_P27_MASK 0x8000000
#define PIOD_CODR_P27 0x8000000
#define PIOD_CODR_P27_BIT 27
#define PIOD_CODR_P28_MASK 0x10000000
#define PIOD_CODR_P28 0x10000000
#define PIOD_CODR_P28_BIT 28
#define PIOD_CODR_P29_MASK 0x20000000
#define PIOD_CODR_P29 0x20000000
#define PIOD_CODR_P29_BIT 29
#define PIOD_CODR_P30_MASK 0x40000000
#define PIOD_CODR_P30 0x40000000
#define PIOD_CODR_P30_BIT 30
#define PIOD_CODR_P31_MASK 0x80000000
#define PIOD_CODR_P31 0x80000000
#define PIOD_CODR_P31_BIT 31

#define PIOD_ODSR (*(volatile unsigned long *)0xFFFFFA38)
#define PIOD_ODSR_OFFSET 0x38
#define PIOD_ODSR_P0_MASK 0x1
#define PIOD_ODSR_P0 0x1
#define PIOD_ODSR_P0_BIT 0
#define PIOD_ODSR_P1_MASK 0x2
#define PIOD_ODSR_P1 0x2
#define PIOD_ODSR_P1_BIT 1
#define PIOD_ODSR_P2_MASK 0x4
#define PIOD_ODSR_P2 0x4
#define PIOD_ODSR_P2_BIT 2
#define PIOD_ODSR_P3_MASK 0x8
#define PIOD_ODSR_P3 0x8
#define PIOD_ODSR_P3_BIT 3
#define PIOD_ODSR_P4_MASK 0x10
#define PIOD_ODSR_P4 0x10
#define PIOD_ODSR_P4_BIT 4
#define PIOD_ODSR_P5_MASK 0x20
#define PIOD_ODSR_P5 0x20
#define PIOD_ODSR_P5_BIT 5
#define PIOD_ODSR_P6_MASK 0x40
#define PIOD_ODSR_P6 0x40
#define PIOD_ODSR_P6_BIT 6
#define PIOD_ODSR_P7_MASK 0x80
#define PIOD_ODSR_P7 0x80
#define PIOD_ODSR_P7_BIT 7
#define PIOD_ODSR_P8_MASK 0x100
#define PIOD_ODSR_P8 0x100
#define PIOD_ODSR_P8_BIT 8
#define PIOD_ODSR_P9_MASK 0x200
#define PIOD_ODSR_P9 0x200
#define PIOD_ODSR_P9_BIT 9
#define PIOD_ODSR_P10_MASK 0x400
#define PIOD_ODSR_P10 0x400
#define PIOD_ODSR_P10_BIT 10
#define PIOD_ODSR_P11_MASK 0x800
#define PIOD_ODSR_P11 0x800
#define PIOD_ODSR_P11_BIT 11
#define PIOD_ODSR_P12_MASK 0x1000
#define PIOD_ODSR_P12 0x1000
#define PIOD_ODSR_P12_BIT 12
#define PIOD_ODSR_P13_MASK 0x2000
#define PIOD_ODSR_P13 0x2000
#define PIOD_ODSR_P13_BIT 13
#define PIOD_ODSR_P14_MASK 0x4000
#define PIOD_ODSR_P14 0x4000
#define PIOD_ODSR_P14_BIT 14
#define PIOD_ODSR_P15_MASK 0x8000
#define PIOD_ODSR_P15 0x8000
#define PIOD_ODSR_P15_BIT 15
#define PIOD_ODSR_P16_MASK 0x10000
#define PIOD_ODSR_P16 0x10000
#define PIOD_ODSR_P16_BIT 16
#define PIOD_ODSR_P17_MASK 0x20000
#define PIOD_ODSR_P17 0x20000
#define PIOD_ODSR_P17_BIT 17
#define PIOD_ODSR_P18_MASK 0x40000
#define PIOD_ODSR_P18 0x40000
#define PIOD_ODSR_P18_BIT 18
#define PIOD_ODSR_P19_MASK 0x80000
#define PIOD_ODSR_P19 0x80000
#define PIOD_ODSR_P19_BIT 19
#define PIOD_ODSR_P20_MASK 0x100000
#define PIOD_ODSR_P20 0x100000
#define PIOD_ODSR_P20_BIT 20
#define PIOD_ODSR_P21_MASK 0x200000
#define PIOD_ODSR_P21 0x200000
#define PIOD_ODSR_P21_BIT 21
#define PIOD_ODSR_P22_MASK 0x400000
#define PIOD_ODSR_P22 0x400000
#define PIOD_ODSR_P22_BIT 22
#define PIOD_ODSR_P23_MASK 0x800000
#define PIOD_ODSR_P23 0x800000
#define PIOD_ODSR_P23_BIT 23
#define PIOD_ODSR_P24_MASK 0x1000000
#define PIOD_ODSR_P24 0x1000000
#define PIOD_ODSR_P24_BIT 24
#define PIOD_ODSR_P25_MASK 0x2000000
#define PIOD_ODSR_P25 0x2000000
#define PIOD_ODSR_P25_BIT 25
#define PIOD_ODSR_P26_MASK 0x4000000
#define PIOD_ODSR_P26 0x4000000
#define PIOD_ODSR_P26_BIT 26
#define PIOD_ODSR_P27_MASK 0x8000000
#define PIOD_ODSR_P27 0x8000000
#define PIOD_ODSR_P27_BIT 27
#define PIOD_ODSR_P28_MASK 0x10000000
#define PIOD_ODSR_P28 0x10000000
#define PIOD_ODSR_P28_BIT 28
#define PIOD_ODSR_P29_MASK 0x20000000
#define PIOD_ODSR_P29 0x20000000
#define PIOD_ODSR_P29_BIT 29
#define PIOD_ODSR_P30_MASK 0x40000000
#define PIOD_ODSR_P30 0x40000000
#define PIOD_ODSR_P30_BIT 30
#define PIOD_ODSR_P31_MASK 0x80000000
#define PIOD_ODSR_P31 0x80000000
#define PIOD_ODSR_P31_BIT 31

#define PIOD_PDSR (*(volatile unsigned long *)0xFFFFFA3C)
#define PIOD_PDSR_OFFSET 0x3C
#define PIOD_PDSR_P0_MASK 0x1
#define PIOD_PDSR_P0 0x1
#define PIOD_PDSR_P0_BIT 0
#define PIOD_PDSR_P1_MASK 0x2
#define PIOD_PDSR_P1 0x2
#define PIOD_PDSR_P1_BIT 1
#define PIOD_PDSR_P2_MASK 0x4
#define PIOD_PDSR_P2 0x4
#define PIOD_PDSR_P2_BIT 2
#define PIOD_PDSR_P3_MASK 0x8
#define PIOD_PDSR_P3 0x8
#define PIOD_PDSR_P3_BIT 3
#define PIOD_PDSR_P4_MASK 0x10
#define PIOD_PDSR_P4 0x10
#define PIOD_PDSR_P4_BIT 4
#define PIOD_PDSR_P5_MASK 0x20
#define PIOD_PDSR_P5 0x20
#define PIOD_PDSR_P5_BIT 5
#define PIOD_PDSR_P6_MASK 0x40
#define PIOD_PDSR_P6 0x40
#define PIOD_PDSR_P6_BIT 6
#define PIOD_PDSR_P7_MASK 0x80
#define PIOD_PDSR_P7 0x80
#define PIOD_PDSR_P7_BIT 7
#define PIOD_PDSR_P8_MASK 0x100
#define PIOD_PDSR_P8 0x100
#define PIOD_PDSR_P8_BIT 8
#define PIOD_PDSR_P9_MASK 0x200
#define PIOD_PDSR_P9 0x200
#define PIOD_PDSR_P9_BIT 9
#define PIOD_PDSR_P10_MASK 0x400
#define PIOD_PDSR_P10 0x400
#define PIOD_PDSR_P10_BIT 10
#define PIOD_PDSR_P11_MASK 0x800
#define PIOD_PDSR_P11 0x800
#define PIOD_PDSR_P11_BIT 11
#define PIOD_PDSR_P12_MASK 0x1000
#define PIOD_PDSR_P12 0x1000
#define PIOD_PDSR_P12_BIT 12
#define PIOD_PDSR_P13_MASK 0x2000
#define PIOD_PDSR_P13 0x2000
#define PIOD_PDSR_P13_BIT 13
#define PIOD_PDSR_P14_MASK 0x4000
#define PIOD_PDSR_P14 0x4000
#define PIOD_PDSR_P14_BIT 14
#define PIOD_PDSR_P15_MASK 0x8000
#define PIOD_PDSR_P15 0x8000
#define PIOD_PDSR_P15_BIT 15
#define PIOD_PDSR_P16_MASK 0x10000
#define PIOD_PDSR_P16 0x10000
#define PIOD_PDSR_P16_BIT 16
#define PIOD_PDSR_P17_MASK 0x20000
#define PIOD_PDSR_P17 0x20000
#define PIOD_PDSR_P17_BIT 17
#define PIOD_PDSR_P18_MASK 0x40000
#define PIOD_PDSR_P18 0x40000
#define PIOD_PDSR_P18_BIT 18
#define PIOD_PDSR_P19_MASK 0x80000
#define PIOD_PDSR_P19 0x80000
#define PIOD_PDSR_P19_BIT 19
#define PIOD_PDSR_P20_MASK 0x100000
#define PIOD_PDSR_P20 0x100000
#define PIOD_PDSR_P20_BIT 20
#define PIOD_PDSR_P21_MASK 0x200000
#define PIOD_PDSR_P21 0x200000
#define PIOD_PDSR_P21_BIT 21
#define PIOD_PDSR_P22_MASK 0x400000
#define PIOD_PDSR_P22 0x400000
#define PIOD_PDSR_P22_BIT 22
#define PIOD_PDSR_P23_MASK 0x800000
#define PIOD_PDSR_P23 0x800000
#define PIOD_PDSR_P23_BIT 23
#define PIOD_PDSR_P24_MASK 0x1000000
#define PIOD_PDSR_P24 0x1000000
#define PIOD_PDSR_P24_BIT 24
#define PIOD_PDSR_P25_MASK 0x2000000
#define PIOD_PDSR_P25 0x2000000
#define PIOD_PDSR_P25_BIT 25
#define PIOD_PDSR_P26_MASK 0x4000000
#define PIOD_PDSR_P26 0x4000000
#define PIOD_PDSR_P26_BIT 26
#define PIOD_PDSR_P27_MASK 0x8000000
#define PIOD_PDSR_P27 0x8000000
#define PIOD_PDSR_P27_BIT 27
#define PIOD_PDSR_P28_MASK 0x10000000
#define PIOD_PDSR_P28 0x10000000
#define PIOD_PDSR_P28_BIT 28
#define PIOD_PDSR_P29_MASK 0x20000000
#define PIOD_PDSR_P29 0x20000000
#define PIOD_PDSR_P29_BIT 29
#define PIOD_PDSR_P30_MASK 0x40000000
#define PIOD_PDSR_P30 0x40000000
#define PIOD_PDSR_P30_BIT 30
#define PIOD_PDSR_P31_MASK 0x80000000
#define PIOD_PDSR_P31 0x80000000
#define PIOD_PDSR_P31_BIT 31

#define PIOD_IER (*(volatile unsigned long *)0xFFFFFA40)
#define PIOD_IER_OFFSET 0x40
#define PIOD_IER_P0_MASK 0x1
#define PIOD_IER_P0 0x1
#define PIOD_IER_P0_BIT 0
#define PIOD_IER_P1_MASK 0x2
#define PIOD_IER_P1 0x2
#define PIOD_IER_P1_BIT 1
#define PIOD_IER_P2_MASK 0x4
#define PIOD_IER_P2 0x4
#define PIOD_IER_P2_BIT 2
#define PIOD_IER_P3_MASK 0x8
#define PIOD_IER_P3 0x8
#define PIOD_IER_P3_BIT 3
#define PIOD_IER_P4_MASK 0x10
#define PIOD_IER_P4 0x10
#define PIOD_IER_P4_BIT 4
#define PIOD_IER_P5_MASK 0x20
#define PIOD_IER_P5 0x20
#define PIOD_IER_P5_BIT 5
#define PIOD_IER_P6_MASK 0x40
#define PIOD_IER_P6 0x40
#define PIOD_IER_P6_BIT 6
#define PIOD_IER_P7_MASK 0x80
#define PIOD_IER_P7 0x80
#define PIOD_IER_P7_BIT 7
#define PIOD_IER_P8_MASK 0x100
#define PIOD_IER_P8 0x100
#define PIOD_IER_P8_BIT 8
#define PIOD_IER_P9_MASK 0x200
#define PIOD_IER_P9 0x200
#define PIOD_IER_P9_BIT 9
#define PIOD_IER_P10_MASK 0x400
#define PIOD_IER_P10 0x400
#define PIOD_IER_P10_BIT 10
#define PIOD_IER_P11_MASK 0x800
#define PIOD_IER_P11 0x800
#define PIOD_IER_P11_BIT 11
#define PIOD_IER_P12_MASK 0x1000
#define PIOD_IER_P12 0x1000
#define PIOD_IER_P12_BIT 12
#define PIOD_IER_P13_MASK 0x2000
#define PIOD_IER_P13 0x2000
#define PIOD_IER_P13_BIT 13
#define PIOD_IER_P14_MASK 0x4000
#define PIOD_IER_P14 0x4000
#define PIOD_IER_P14_BIT 14
#define PIOD_IER_P15_MASK 0x8000
#define PIOD_IER_P15 0x8000
#define PIOD_IER_P15_BIT 15
#define PIOD_IER_P16_MASK 0x10000
#define PIOD_IER_P16 0x10000
#define PIOD_IER_P16_BIT 16
#define PIOD_IER_P17_MASK 0x20000
#define PIOD_IER_P17 0x20000
#define PIOD_IER_P17_BIT 17
#define PIOD_IER_P18_MASK 0x40000
#define PIOD_IER_P18 0x40000
#define PIOD_IER_P18_BIT 18
#define PIOD_IER_P19_MASK 0x80000
#define PIOD_IER_P19 0x80000
#define PIOD_IER_P19_BIT 19
#define PIOD_IER_P20_MASK 0x100000
#define PIOD_IER_P20 0x100000
#define PIOD_IER_P20_BIT 20
#define PIOD_IER_P21_MASK 0x200000
#define PIOD_IER_P21 0x200000
#define PIOD_IER_P21_BIT 21
#define PIOD_IER_P22_MASK 0x400000
#define PIOD_IER_P22 0x400000
#define PIOD_IER_P22_BIT 22
#define PIOD_IER_P23_MASK 0x800000
#define PIOD_IER_P23 0x800000
#define PIOD_IER_P23_BIT 23
#define PIOD_IER_P24_MASK 0x1000000
#define PIOD_IER_P24 0x1000000
#define PIOD_IER_P24_BIT 24
#define PIOD_IER_P25_MASK 0x2000000
#define PIOD_IER_P25 0x2000000
#define PIOD_IER_P25_BIT 25
#define PIOD_IER_P26_MASK 0x4000000
#define PIOD_IER_P26 0x4000000
#define PIOD_IER_P26_BIT 26
#define PIOD_IER_P27_MASK 0x8000000
#define PIOD_IER_P27 0x8000000
#define PIOD_IER_P27_BIT 27
#define PIOD_IER_P28_MASK 0x10000000
#define PIOD_IER_P28 0x10000000
#define PIOD_IER_P28_BIT 28
#define PIOD_IER_P29_MASK 0x20000000
#define PIOD_IER_P29 0x20000000
#define PIOD_IER_P29_BIT 29
#define PIOD_IER_P30_MASK 0x40000000
#define PIOD_IER_P30 0x40000000
#define PIOD_IER_P30_BIT 30
#define PIOD_IER_P31_MASK 0x80000000
#define PIOD_IER_P31 0x80000000
#define PIOD_IER_P31_BIT 31

#define PIOD_IDR (*(volatile unsigned long *)0xFFFFFA44)
#define PIOD_IDR_OFFSET 0x44
#define PIOD_IDR_P0_MASK 0x1
#define PIOD_IDR_P0 0x1
#define PIOD_IDR_P0_BIT 0
#define PIOD_IDR_P1_MASK 0x2
#define PIOD_IDR_P1 0x2
#define PIOD_IDR_P1_BIT 1
#define PIOD_IDR_P2_MASK 0x4
#define PIOD_IDR_P2 0x4
#define PIOD_IDR_P2_BIT 2
#define PIOD_IDR_P3_MASK 0x8
#define PIOD_IDR_P3 0x8
#define PIOD_IDR_P3_BIT 3
#define PIOD_IDR_P4_MASK 0x10
#define PIOD_IDR_P4 0x10
#define PIOD_IDR_P4_BIT 4
#define PIOD_IDR_P5_MASK 0x20
#define PIOD_IDR_P5 0x20
#define PIOD_IDR_P5_BIT 5
#define PIOD_IDR_P6_MASK 0x40
#define PIOD_IDR_P6 0x40
#define PIOD_IDR_P6_BIT 6
#define PIOD_IDR_P7_MASK 0x80
#define PIOD_IDR_P7 0x80
#define PIOD_IDR_P7_BIT 7
#define PIOD_IDR_P8_MASK 0x100
#define PIOD_IDR_P8 0x100
#define PIOD_IDR_P8_BIT 8
#define PIOD_IDR_P9_MASK 0x200
#define PIOD_IDR_P9 0x200
#define PIOD_IDR_P9_BIT 9
#define PIOD_IDR_P10_MASK 0x400
#define PIOD_IDR_P10 0x400
#define PIOD_IDR_P10_BIT 10
#define PIOD_IDR_P11_MASK 0x800
#define PIOD_IDR_P11 0x800
#define PIOD_IDR_P11_BIT 11
#define PIOD_IDR_P12_MASK 0x1000
#define PIOD_IDR_P12 0x1000
#define PIOD_IDR_P12_BIT 12
#define PIOD_IDR_P13_MASK 0x2000
#define PIOD_IDR_P13 0x2000
#define PIOD_IDR_P13_BIT 13
#define PIOD_IDR_P14_MASK 0x4000
#define PIOD_IDR_P14 0x4000
#define PIOD_IDR_P14_BIT 14
#define PIOD_IDR_P15_MASK 0x8000
#define PIOD_IDR_P15 0x8000
#define PIOD_IDR_P15_BIT 15
#define PIOD_IDR_P16_MASK 0x10000
#define PIOD_IDR_P16 0x10000
#define PIOD_IDR_P16_BIT 16
#define PIOD_IDR_P17_MASK 0x20000
#define PIOD_IDR_P17 0x20000
#define PIOD_IDR_P17_BIT 17
#define PIOD_IDR_P18_MASK 0x40000
#define PIOD_IDR_P18 0x40000
#define PIOD_IDR_P18_BIT 18
#define PIOD_IDR_P19_MASK 0x80000
#define PIOD_IDR_P19 0x80000
#define PIOD_IDR_P19_BIT 19
#define PIOD_IDR_P20_MASK 0x100000
#define PIOD_IDR_P20 0x100000
#define PIOD_IDR_P20_BIT 20
#define PIOD_IDR_P21_MASK 0x200000
#define PIOD_IDR_P21 0x200000
#define PIOD_IDR_P21_BIT 21
#define PIOD_IDR_P22_MASK 0x400000
#define PIOD_IDR_P22 0x400000
#define PIOD_IDR_P22_BIT 22
#define PIOD_IDR_P23_MASK 0x800000
#define PIOD_IDR_P23 0x800000
#define PIOD_IDR_P23_BIT 23
#define PIOD_IDR_P24_MASK 0x1000000
#define PIOD_IDR_P24 0x1000000
#define PIOD_IDR_P24_BIT 24
#define PIOD_IDR_P25_MASK 0x2000000
#define PIOD_IDR_P25 0x2000000
#define PIOD_IDR_P25_BIT 25
#define PIOD_IDR_P26_MASK 0x4000000
#define PIOD_IDR_P26 0x4000000
#define PIOD_IDR_P26_BIT 26
#define PIOD_IDR_P27_MASK 0x8000000
#define PIOD_IDR_P27 0x8000000
#define PIOD_IDR_P27_BIT 27
#define PIOD_IDR_P28_MASK 0x10000000
#define PIOD_IDR_P28 0x10000000
#define PIOD_IDR_P28_BIT 28
#define PIOD_IDR_P29_MASK 0x20000000
#define PIOD_IDR_P29 0x20000000
#define PIOD_IDR_P29_BIT 29
#define PIOD_IDR_P30_MASK 0x40000000
#define PIOD_IDR_P30 0x40000000
#define PIOD_IDR_P30_BIT 30
#define PIOD_IDR_P31_MASK 0x80000000
#define PIOD_IDR_P31 0x80000000
#define PIOD_IDR_P31_BIT 31

#define PIOD_IMR (*(volatile unsigned long *)0xFFFFFA48)
#define PIOD_IMR_OFFSET 0x48
#define PIOD_IMR_P0_MASK 0x1
#define PIOD_IMR_P0 0x1
#define PIOD_IMR_P0_BIT 0
#define PIOD_IMR_P1_MASK 0x2
#define PIOD_IMR_P1 0x2
#define PIOD_IMR_P1_BIT 1
#define PIOD_IMR_P2_MASK 0x4
#define PIOD_IMR_P2 0x4
#define PIOD_IMR_P2_BIT 2
#define PIOD_IMR_P3_MASK 0x8
#define PIOD_IMR_P3 0x8
#define PIOD_IMR_P3_BIT 3
#define PIOD_IMR_P4_MASK 0x10
#define PIOD_IMR_P4 0x10
#define PIOD_IMR_P4_BIT 4
#define PIOD_IMR_P5_MASK 0x20
#define PIOD_IMR_P5 0x20
#define PIOD_IMR_P5_BIT 5
#define PIOD_IMR_P6_MASK 0x40
#define PIOD_IMR_P6 0x40
#define PIOD_IMR_P6_BIT 6
#define PIOD_IMR_P7_MASK 0x80
#define PIOD_IMR_P7 0x80
#define PIOD_IMR_P7_BIT 7
#define PIOD_IMR_P8_MASK 0x100
#define PIOD_IMR_P8 0x100
#define PIOD_IMR_P8_BIT 8
#define PIOD_IMR_P9_MASK 0x200
#define PIOD_IMR_P9 0x200
#define PIOD_IMR_P9_BIT 9
#define PIOD_IMR_P10_MASK 0x400
#define PIOD_IMR_P10 0x400
#define PIOD_IMR_P10_BIT 10
#define PIOD_IMR_P11_MASK 0x800
#define PIOD_IMR_P11 0x800
#define PIOD_IMR_P11_BIT 11
#define PIOD_IMR_P12_MASK 0x1000
#define PIOD_IMR_P12 0x1000
#define PIOD_IMR_P12_BIT 12
#define PIOD_IMR_P13_MASK 0x2000
#define PIOD_IMR_P13 0x2000
#define PIOD_IMR_P13_BIT 13
#define PIOD_IMR_P14_MASK 0x4000
#define PIOD_IMR_P14 0x4000
#define PIOD_IMR_P14_BIT 14
#define PIOD_IMR_P15_MASK 0x8000
#define PIOD_IMR_P15 0x8000
#define PIOD_IMR_P15_BIT 15
#define PIOD_IMR_P16_MASK 0x10000
#define PIOD_IMR_P16 0x10000
#define PIOD_IMR_P16_BIT 16
#define PIOD_IMR_P17_MASK 0x20000
#define PIOD_IMR_P17 0x20000
#define PIOD_IMR_P17_BIT 17
#define PIOD_IMR_P18_MASK 0x40000
#define PIOD_IMR_P18 0x40000
#define PIOD_IMR_P18_BIT 18
#define PIOD_IMR_P19_MASK 0x80000
#define PIOD_IMR_P19 0x80000
#define PIOD_IMR_P19_BIT 19
#define PIOD_IMR_P20_MASK 0x100000
#define PIOD_IMR_P20 0x100000
#define PIOD_IMR_P20_BIT 20
#define PIOD_IMR_P21_MASK 0x200000
#define PIOD_IMR_P21 0x200000
#define PIOD_IMR_P21_BIT 21
#define PIOD_IMR_P22_MASK 0x400000
#define PIOD_IMR_P22 0x400000
#define PIOD_IMR_P22_BIT 22
#define PIOD_IMR_P23_MASK 0x800000
#define PIOD_IMR_P23 0x800000
#define PIOD_IMR_P23_BIT 23
#define PIOD_IMR_P24_MASK 0x1000000
#define PIOD_IMR_P24 0x1000000
#define PIOD_IMR_P24_BIT 24
#define PIOD_IMR_P25_MASK 0x2000000
#define PIOD_IMR_P25 0x2000000
#define PIOD_IMR_P25_BIT 25
#define PIOD_IMR_P26_MASK 0x4000000
#define PIOD_IMR_P26 0x4000000
#define PIOD_IMR_P26_BIT 26
#define PIOD_IMR_P27_MASK 0x8000000
#define PIOD_IMR_P27 0x8000000
#define PIOD_IMR_P27_BIT 27
#define PIOD_IMR_P28_MASK 0x10000000
#define PIOD_IMR_P28 0x10000000
#define PIOD_IMR_P28_BIT 28
#define PIOD_IMR_P29_MASK 0x20000000
#define PIOD_IMR_P29 0x20000000
#define PIOD_IMR_P29_BIT 29
#define PIOD_IMR_P30_MASK 0x40000000
#define PIOD_IMR_P30 0x40000000
#define PIOD_IMR_P30_BIT 30
#define PIOD_IMR_P31_MASK 0x80000000
#define PIOD_IMR_P31 0x80000000
#define PIOD_IMR_P31_BIT 31

#define PIOD_ISR (*(volatile unsigned long *)0xFFFFFA4C)
#define PIOD_ISR_OFFSET 0x4C
#define PIOD_ISR_P0_MASK 0x1
#define PIOD_ISR_P0 0x1
#define PIOD_ISR_P0_BIT 0
#define PIOD_ISR_P1_MASK 0x2
#define PIOD_ISR_P1 0x2
#define PIOD_ISR_P1_BIT 1
#define PIOD_ISR_P2_MASK 0x4
#define PIOD_ISR_P2 0x4
#define PIOD_ISR_P2_BIT 2
#define PIOD_ISR_P3_MASK 0x8
#define PIOD_ISR_P3 0x8
#define PIOD_ISR_P3_BIT 3
#define PIOD_ISR_P4_MASK 0x10
#define PIOD_ISR_P4 0x10
#define PIOD_ISR_P4_BIT 4
#define PIOD_ISR_P5_MASK 0x20
#define PIOD_ISR_P5 0x20
#define PIOD_ISR_P5_BIT 5
#define PIOD_ISR_P6_MASK 0x40
#define PIOD_ISR_P6 0x40
#define PIOD_ISR_P6_BIT 6
#define PIOD_ISR_P7_MASK 0x80
#define PIOD_ISR_P7 0x80
#define PIOD_ISR_P7_BIT 7
#define PIOD_ISR_P8_MASK 0x100
#define PIOD_ISR_P8 0x100
#define PIOD_ISR_P8_BIT 8
#define PIOD_ISR_P9_MASK 0x200
#define PIOD_ISR_P9 0x200
#define PIOD_ISR_P9_BIT 9
#define PIOD_ISR_P10_MASK 0x400
#define PIOD_ISR_P10 0x400
#define PIOD_ISR_P10_BIT 10
#define PIOD_ISR_P11_MASK 0x800
#define PIOD_ISR_P11 0x800
#define PIOD_ISR_P11_BIT 11
#define PIOD_ISR_P12_MASK 0x1000
#define PIOD_ISR_P12 0x1000
#define PIOD_ISR_P12_BIT 12
#define PIOD_ISR_P13_MASK 0x2000
#define PIOD_ISR_P13 0x2000
#define PIOD_ISR_P13_BIT 13
#define PIOD_ISR_P14_MASK 0x4000
#define PIOD_ISR_P14 0x4000
#define PIOD_ISR_P14_BIT 14
#define PIOD_ISR_P15_MASK 0x8000
#define PIOD_ISR_P15 0x8000
#define PIOD_ISR_P15_BIT 15
#define PIOD_ISR_P16_MASK 0x10000
#define PIOD_ISR_P16 0x10000
#define PIOD_ISR_P16_BIT 16
#define PIOD_ISR_P17_MASK 0x20000
#define PIOD_ISR_P17 0x20000
#define PIOD_ISR_P17_BIT 17
#define PIOD_ISR_P18_MASK 0x40000
#define PIOD_ISR_P18 0x40000
#define PIOD_ISR_P18_BIT 18
#define PIOD_ISR_P19_MASK 0x80000
#define PIOD_ISR_P19 0x80000
#define PIOD_ISR_P19_BIT 19
#define PIOD_ISR_P20_MASK 0x100000
#define PIOD_ISR_P20 0x100000
#define PIOD_ISR_P20_BIT 20
#define PIOD_ISR_P21_MASK 0x200000
#define PIOD_ISR_P21 0x200000
#define PIOD_ISR_P21_BIT 21
#define PIOD_ISR_P22_MASK 0x400000
#define PIOD_ISR_P22 0x400000
#define PIOD_ISR_P22_BIT 22
#define PIOD_ISR_P23_MASK 0x800000
#define PIOD_ISR_P23 0x800000
#define PIOD_ISR_P23_BIT 23
#define PIOD_ISR_P24_MASK 0x1000000
#define PIOD_ISR_P24 0x1000000
#define PIOD_ISR_P24_BIT 24
#define PIOD_ISR_P25_MASK 0x2000000
#define PIOD_ISR_P25 0x2000000
#define PIOD_ISR_P25_BIT 25
#define PIOD_ISR_P26_MASK 0x4000000
#define PIOD_ISR_P26 0x4000000
#define PIOD_ISR_P26_BIT 26
#define PIOD_ISR_P27_MASK 0x8000000
#define PIOD_ISR_P27 0x8000000
#define PIOD_ISR_P27_BIT 27
#define PIOD_ISR_P28_MASK 0x10000000
#define PIOD_ISR_P28 0x10000000
#define PIOD_ISR_P28_BIT 28
#define PIOD_ISR_P29_MASK 0x20000000
#define PIOD_ISR_P29 0x20000000
#define PIOD_ISR_P29_BIT 29
#define PIOD_ISR_P30_MASK 0x40000000
#define PIOD_ISR_P30 0x40000000
#define PIOD_ISR_P30_BIT 30
#define PIOD_ISR_P31_MASK 0x80000000
#define PIOD_ISR_P31 0x80000000
#define PIOD_ISR_P31_BIT 31

#define PIOD_MDER (*(volatile unsigned long *)0xFFFFFA50)
#define PIOD_MDER_OFFSET 0x50
#define PIOD_MDER_P0_MASK 0x1
#define PIOD_MDER_P0 0x1
#define PIOD_MDER_P0_BIT 0
#define PIOD_MDER_P1_MASK 0x2
#define PIOD_MDER_P1 0x2
#define PIOD_MDER_P1_BIT 1
#define PIOD_MDER_P2_MASK 0x4
#define PIOD_MDER_P2 0x4
#define PIOD_MDER_P2_BIT 2
#define PIOD_MDER_P3_MASK 0x8
#define PIOD_MDER_P3 0x8
#define PIOD_MDER_P3_BIT 3
#define PIOD_MDER_P4_MASK 0x10
#define PIOD_MDER_P4 0x10
#define PIOD_MDER_P4_BIT 4
#define PIOD_MDER_P5_MASK 0x20
#define PIOD_MDER_P5 0x20
#define PIOD_MDER_P5_BIT 5
#define PIOD_MDER_P6_MASK 0x40
#define PIOD_MDER_P6 0x40
#define PIOD_MDER_P6_BIT 6
#define PIOD_MDER_P7_MASK 0x80
#define PIOD_MDER_P7 0x80
#define PIOD_MDER_P7_BIT 7
#define PIOD_MDER_P8_MASK 0x100
#define PIOD_MDER_P8 0x100
#define PIOD_MDER_P8_BIT 8
#define PIOD_MDER_P9_MASK 0x200
#define PIOD_MDER_P9 0x200
#define PIOD_MDER_P9_BIT 9
#define PIOD_MDER_P10_MASK 0x400
#define PIOD_MDER_P10 0x400
#define PIOD_MDER_P10_BIT 10
#define PIOD_MDER_P11_MASK 0x800
#define PIOD_MDER_P11 0x800
#define PIOD_MDER_P11_BIT 11
#define PIOD_MDER_P12_MASK 0x1000
#define PIOD_MDER_P12 0x1000
#define PIOD_MDER_P12_BIT 12
#define PIOD_MDER_P13_MASK 0x2000
#define PIOD_MDER_P13 0x2000
#define PIOD_MDER_P13_BIT 13
#define PIOD_MDER_P14_MASK 0x4000
#define PIOD_MDER_P14 0x4000
#define PIOD_MDER_P14_BIT 14
#define PIOD_MDER_P15_MASK 0x8000
#define PIOD_MDER_P15 0x8000
#define PIOD_MDER_P15_BIT 15
#define PIOD_MDER_P16_MASK 0x10000
#define PIOD_MDER_P16 0x10000
#define PIOD_MDER_P16_BIT 16
#define PIOD_MDER_P17_MASK 0x20000
#define PIOD_MDER_P17 0x20000
#define PIOD_MDER_P17_BIT 17
#define PIOD_MDER_P18_MASK 0x40000
#define PIOD_MDER_P18 0x40000
#define PIOD_MDER_P18_BIT 18
#define PIOD_MDER_P19_MASK 0x80000
#define PIOD_MDER_P19 0x80000
#define PIOD_MDER_P19_BIT 19
#define PIOD_MDER_P20_MASK 0x100000
#define PIOD_MDER_P20 0x100000
#define PIOD_MDER_P20_BIT 20
#define PIOD_MDER_P21_MASK 0x200000
#define PIOD_MDER_P21 0x200000
#define PIOD_MDER_P21_BIT 21
#define PIOD_MDER_P22_MASK 0x400000
#define PIOD_MDER_P22 0x400000
#define PIOD_MDER_P22_BIT 22
#define PIOD_MDER_P23_MASK 0x800000
#define PIOD_MDER_P23 0x800000
#define PIOD_MDER_P23_BIT 23
#define PIOD_MDER_P24_MASK 0x1000000
#define PIOD_MDER_P24 0x1000000
#define PIOD_MDER_P24_BIT 24
#define PIOD_MDER_P25_MASK 0x2000000
#define PIOD_MDER_P25 0x2000000
#define PIOD_MDER_P25_BIT 25
#define PIOD_MDER_P26_MASK 0x4000000
#define PIOD_MDER_P26 0x4000000
#define PIOD_MDER_P26_BIT 26
#define PIOD_MDER_P27_MASK 0x8000000
#define PIOD_MDER_P27 0x8000000
#define PIOD_MDER_P27_BIT 27
#define PIOD_MDER_P28_MASK 0x10000000
#define PIOD_MDER_P28 0x10000000
#define PIOD_MDER_P28_BIT 28
#define PIOD_MDER_P29_MASK 0x20000000
#define PIOD_MDER_P29 0x20000000
#define PIOD_MDER_P29_BIT 29
#define PIOD_MDER_P30_MASK 0x40000000
#define PIOD_MDER_P30 0x40000000
#define PIOD_MDER_P30_BIT 30
#define PIOD_MDER_P31_MASK 0x80000000
#define PIOD_MDER_P31 0x80000000
#define PIOD_MDER_P31_BIT 31

#define PIOD_MDDR (*(volatile unsigned long *)0xFFFFFA54)
#define PIOD_MDDR_OFFSET 0x54
#define PIOD_MDDR_P0_MASK 0x1
#define PIOD_MDDR_P0 0x1
#define PIOD_MDDR_P0_BIT 0
#define PIOD_MDDR_P1_MASK 0x2
#define PIOD_MDDR_P1 0x2
#define PIOD_MDDR_P1_BIT 1
#define PIOD_MDDR_P2_MASK 0x4
#define PIOD_MDDR_P2 0x4
#define PIOD_MDDR_P2_BIT 2
#define PIOD_MDDR_P3_MASK 0x8
#define PIOD_MDDR_P3 0x8
#define PIOD_MDDR_P3_BIT 3
#define PIOD_MDDR_P4_MASK 0x10
#define PIOD_MDDR_P4 0x10
#define PIOD_MDDR_P4_BIT 4
#define PIOD_MDDR_P5_MASK 0x20
#define PIOD_MDDR_P5 0x20
#define PIOD_MDDR_P5_BIT 5
#define PIOD_MDDR_P6_MASK 0x40
#define PIOD_MDDR_P6 0x40
#define PIOD_MDDR_P6_BIT 6
#define PIOD_MDDR_P7_MASK 0x80
#define PIOD_MDDR_P7 0x80
#define PIOD_MDDR_P7_BIT 7
#define PIOD_MDDR_P8_MASK 0x100
#define PIOD_MDDR_P8 0x100
#define PIOD_MDDR_P8_BIT 8
#define PIOD_MDDR_P9_MASK 0x200
#define PIOD_MDDR_P9 0x200
#define PIOD_MDDR_P9_BIT 9
#define PIOD_MDDR_P10_MASK 0x400
#define PIOD_MDDR_P10 0x400
#define PIOD_MDDR_P10_BIT 10
#define PIOD_MDDR_P11_MASK 0x800
#define PIOD_MDDR_P11 0x800
#define PIOD_MDDR_P11_BIT 11
#define PIOD_MDDR_P12_MASK 0x1000
#define PIOD_MDDR_P12 0x1000
#define PIOD_MDDR_P12_BIT 12
#define PIOD_MDDR_P13_MASK 0x2000
#define PIOD_MDDR_P13 0x2000
#define PIOD_MDDR_P13_BIT 13
#define PIOD_MDDR_P14_MASK 0x4000
#define PIOD_MDDR_P14 0x4000
#define PIOD_MDDR_P14_BIT 14
#define PIOD_MDDR_P15_MASK 0x8000
#define PIOD_MDDR_P15 0x8000
#define PIOD_MDDR_P15_BIT 15
#define PIOD_MDDR_P16_MASK 0x10000
#define PIOD_MDDR_P16 0x10000
#define PIOD_MDDR_P16_BIT 16
#define PIOD_MDDR_P17_MASK 0x20000
#define PIOD_MDDR_P17 0x20000
#define PIOD_MDDR_P17_BIT 17
#define PIOD_MDDR_P18_MASK 0x40000
#define PIOD_MDDR_P18 0x40000
#define PIOD_MDDR_P18_BIT 18
#define PIOD_MDDR_P19_MASK 0x80000
#define PIOD_MDDR_P19 0x80000
#define PIOD_MDDR_P19_BIT 19
#define PIOD_MDDR_P20_MASK 0x100000
#define PIOD_MDDR_P20 0x100000
#define PIOD_MDDR_P20_BIT 20
#define PIOD_MDDR_P21_MASK 0x200000
#define PIOD_MDDR_P21 0x200000
#define PIOD_MDDR_P21_BIT 21
#define PIOD_MDDR_P22_MASK 0x400000
#define PIOD_MDDR_P22 0x400000
#define PIOD_MDDR_P22_BIT 22
#define PIOD_MDDR_P23_MASK 0x800000
#define PIOD_MDDR_P23 0x800000
#define PIOD_MDDR_P23_BIT 23
#define PIOD_MDDR_P24_MASK 0x1000000
#define PIOD_MDDR_P24 0x1000000
#define PIOD_MDDR_P24_BIT 24
#define PIOD_MDDR_P25_MASK 0x2000000
#define PIOD_MDDR_P25 0x2000000
#define PIOD_MDDR_P25_BIT 25
#define PIOD_MDDR_P26_MASK 0x4000000
#define PIOD_MDDR_P26 0x4000000
#define PIOD_MDDR_P26_BIT 26
#define PIOD_MDDR_P27_MASK 0x8000000
#define PIOD_MDDR_P27 0x8000000
#define PIOD_MDDR_P27_BIT 27
#define PIOD_MDDR_P28_MASK 0x10000000
#define PIOD_MDDR_P28 0x10000000
#define PIOD_MDDR_P28_BIT 28
#define PIOD_MDDR_P29_MASK 0x20000000
#define PIOD_MDDR_P29 0x20000000
#define PIOD_MDDR_P29_BIT 29
#define PIOD_MDDR_P30_MASK 0x40000000
#define PIOD_MDDR_P30 0x40000000
#define PIOD_MDDR_P30_BIT 30
#define PIOD_MDDR_P31_MASK 0x80000000
#define PIOD_MDDR_P31 0x80000000
#define PIOD_MDDR_P31_BIT 31

#define PIOD_MDSR (*(volatile unsigned long *)0xFFFFFA58)
#define PIOD_MDSR_OFFSET 0x58
#define PIOD_MDSR_P0_MASK 0x1
#define PIOD_MDSR_P0 0x1
#define PIOD_MDSR_P0_BIT 0
#define PIOD_MDSR_P1_MASK 0x2
#define PIOD_MDSR_P1 0x2
#define PIOD_MDSR_P1_BIT 1
#define PIOD_MDSR_P2_MASK 0x4
#define PIOD_MDSR_P2 0x4
#define PIOD_MDSR_P2_BIT 2
#define PIOD_MDSR_P3_MASK 0x8
#define PIOD_MDSR_P3 0x8
#define PIOD_MDSR_P3_BIT 3
#define PIOD_MDSR_P4_MASK 0x10
#define PIOD_MDSR_P4 0x10
#define PIOD_MDSR_P4_BIT 4
#define PIOD_MDSR_P5_MASK 0x20
#define PIOD_MDSR_P5 0x20
#define PIOD_MDSR_P5_BIT 5
#define PIOD_MDSR_P6_MASK 0x40
#define PIOD_MDSR_P6 0x40
#define PIOD_MDSR_P6_BIT 6
#define PIOD_MDSR_P7_MASK 0x80
#define PIOD_MDSR_P7 0x80
#define PIOD_MDSR_P7_BIT 7
#define PIOD_MDSR_P8_MASK 0x100
#define PIOD_MDSR_P8 0x100
#define PIOD_MDSR_P8_BIT 8
#define PIOD_MDSR_P9_MASK 0x200
#define PIOD_MDSR_P9 0x200
#define PIOD_MDSR_P9_BIT 9
#define PIOD_MDSR_P10_MASK 0x400
#define PIOD_MDSR_P10 0x400
#define PIOD_MDSR_P10_BIT 10
#define PIOD_MDSR_P11_MASK 0x800
#define PIOD_MDSR_P11 0x800
#define PIOD_MDSR_P11_BIT 11
#define PIOD_MDSR_P12_MASK 0x1000
#define PIOD_MDSR_P12 0x1000
#define PIOD_MDSR_P12_BIT 12
#define PIOD_MDSR_P13_MASK 0x2000
#define PIOD_MDSR_P13 0x2000
#define PIOD_MDSR_P13_BIT 13
#define PIOD_MDSR_P14_MASK 0x4000
#define PIOD_MDSR_P14 0x4000
#define PIOD_MDSR_P14_BIT 14
#define PIOD_MDSR_P15_MASK 0x8000
#define PIOD_MDSR_P15 0x8000
#define PIOD_MDSR_P15_BIT 15
#define PIOD_MDSR_P16_MASK 0x10000
#define PIOD_MDSR_P16 0x10000
#define PIOD_MDSR_P16_BIT 16
#define PIOD_MDSR_P17_MASK 0x20000
#define PIOD_MDSR_P17 0x20000
#define PIOD_MDSR_P17_BIT 17
#define PIOD_MDSR_P18_MASK 0x40000
#define PIOD_MDSR_P18 0x40000
#define PIOD_MDSR_P18_BIT 18
#define PIOD_MDSR_P19_MASK 0x80000
#define PIOD_MDSR_P19 0x80000
#define PIOD_MDSR_P19_BIT 19
#define PIOD_MDSR_P20_MASK 0x100000
#define PIOD_MDSR_P20 0x100000
#define PIOD_MDSR_P20_BIT 20
#define PIOD_MDSR_P21_MASK 0x200000
#define PIOD_MDSR_P21 0x200000
#define PIOD_MDSR_P21_BIT 21
#define PIOD_MDSR_P22_MASK 0x400000
#define PIOD_MDSR_P22 0x400000
#define PIOD_MDSR_P22_BIT 22
#define PIOD_MDSR_P23_MASK 0x800000
#define PIOD_MDSR_P23 0x800000
#define PIOD_MDSR_P23_BIT 23
#define PIOD_MDSR_P24_MASK 0x1000000
#define PIOD_MDSR_P24 0x1000000
#define PIOD_MDSR_P24_BIT 24
#define PIOD_MDSR_P25_MASK 0x2000000
#define PIOD_MDSR_P25 0x2000000
#define PIOD_MDSR_P25_BIT 25
#define PIOD_MDSR_P26_MASK 0x4000000
#define PIOD_MDSR_P26 0x4000000
#define PIOD_MDSR_P26_BIT 26
#define PIOD_MDSR_P27_MASK 0x8000000
#define PIOD_MDSR_P27 0x8000000
#define PIOD_MDSR_P27_BIT 27
#define PIOD_MDSR_P28_MASK 0x10000000
#define PIOD_MDSR_P28 0x10000000
#define PIOD_MDSR_P28_BIT 28
#define PIOD_MDSR_P29_MASK 0x20000000
#define PIOD_MDSR_P29 0x20000000
#define PIOD_MDSR_P29_BIT 29
#define PIOD_MDSR_P30_MASK 0x40000000
#define PIOD_MDSR_P30 0x40000000
#define PIOD_MDSR_P30_BIT 30
#define PIOD_MDSR_P31_MASK 0x80000000
#define PIOD_MDSR_P31 0x80000000
#define PIOD_MDSR_P31_BIT 31

#define PIOD_PUDR (*(volatile unsigned long *)0xFFFFFA60)
#define PIOD_PUDR_OFFSET 0x60
#define PIOD_PUDR_P0_MASK 0x1
#define PIOD_PUDR_P0 0x1
#define PIOD_PUDR_P0_BIT 0
#define PIOD_PUDR_P1_MASK 0x2
#define PIOD_PUDR_P1 0x2
#define PIOD_PUDR_P1_BIT 1
#define PIOD_PUDR_P2_MASK 0x4
#define PIOD_PUDR_P2 0x4
#define PIOD_PUDR_P2_BIT 2
#define PIOD_PUDR_P3_MASK 0x8
#define PIOD_PUDR_P3 0x8
#define PIOD_PUDR_P3_BIT 3
#define PIOD_PUDR_P4_MASK 0x10
#define PIOD_PUDR_P4 0x10
#define PIOD_PUDR_P4_BIT 4
#define PIOD_PUDR_P5_MASK 0x20
#define PIOD_PUDR_P5 0x20
#define PIOD_PUDR_P5_BIT 5
#define PIOD_PUDR_P6_MASK 0x40
#define PIOD_PUDR_P6 0x40
#define PIOD_PUDR_P6_BIT 6
#define PIOD_PUDR_P7_MASK 0x80
#define PIOD_PUDR_P7 0x80
#define PIOD_PUDR_P7_BIT 7
#define PIOD_PUDR_P8_MASK 0x100
#define PIOD_PUDR_P8 0x100
#define PIOD_PUDR_P8_BIT 8
#define PIOD_PUDR_P9_MASK 0x200
#define PIOD_PUDR_P9 0x200
#define PIOD_PUDR_P9_BIT 9
#define PIOD_PUDR_P10_MASK 0x400
#define PIOD_PUDR_P10 0x400
#define PIOD_PUDR_P10_BIT 10
#define PIOD_PUDR_P11_MASK 0x800
#define PIOD_PUDR_P11 0x800
#define PIOD_PUDR_P11_BIT 11
#define PIOD_PUDR_P12_MASK 0x1000
#define PIOD_PUDR_P12 0x1000
#define PIOD_PUDR_P12_BIT 12
#define PIOD_PUDR_P13_MASK 0x2000
#define PIOD_PUDR_P13 0x2000
#define PIOD_PUDR_P13_BIT 13
#define PIOD_PUDR_P14_MASK 0x4000
#define PIOD_PUDR_P14 0x4000
#define PIOD_PUDR_P14_BIT 14
#define PIOD_PUDR_P15_MASK 0x8000
#define PIOD_PUDR_P15 0x8000
#define PIOD_PUDR_P15_BIT 15
#define PIOD_PUDR_P16_MASK 0x10000
#define PIOD_PUDR_P16 0x10000
#define PIOD_PUDR_P16_BIT 16
#define PIOD_PUDR_P17_MASK 0x20000
#define PIOD_PUDR_P17 0x20000
#define PIOD_PUDR_P17_BIT 17
#define PIOD_PUDR_P18_MASK 0x40000
#define PIOD_PUDR_P18 0x40000
#define PIOD_PUDR_P18_BIT 18
#define PIOD_PUDR_P19_MASK 0x80000
#define PIOD_PUDR_P19 0x80000
#define PIOD_PUDR_P19_BIT 19
#define PIOD_PUDR_P20_MASK 0x100000
#define PIOD_PUDR_P20 0x100000
#define PIOD_PUDR_P20_BIT 20
#define PIOD_PUDR_P21_MASK 0x200000
#define PIOD_PUDR_P21 0x200000
#define PIOD_PUDR_P21_BIT 21
#define PIOD_PUDR_P22_MASK 0x400000
#define PIOD_PUDR_P22 0x400000
#define PIOD_PUDR_P22_BIT 22
#define PIOD_PUDR_P23_MASK 0x800000
#define PIOD_PUDR_P23 0x800000
#define PIOD_PUDR_P23_BIT 23
#define PIOD_PUDR_P24_MASK 0x1000000
#define PIOD_PUDR_P24 0x1000000
#define PIOD_PUDR_P24_BIT 24
#define PIOD_PUDR_P25_MASK 0x2000000
#define PIOD_PUDR_P25 0x2000000
#define PIOD_PUDR_P25_BIT 25
#define PIOD_PUDR_P26_MASK 0x4000000
#define PIOD_PUDR_P26 0x4000000
#define PIOD_PUDR_P26_BIT 26
#define PIOD_PUDR_P27_MASK 0x8000000
#define PIOD_PUDR_P27 0x8000000
#define PIOD_PUDR_P27_BIT 27
#define PIOD_PUDR_P28_MASK 0x10000000
#define PIOD_PUDR_P28 0x10000000
#define PIOD_PUDR_P28_BIT 28
#define PIOD_PUDR_P29_MASK 0x20000000
#define PIOD_PUDR_P29 0x20000000
#define PIOD_PUDR_P29_BIT 29
#define PIOD_PUDR_P30_MASK 0x40000000
#define PIOD_PUDR_P30 0x40000000
#define PIOD_PUDR_P30_BIT 30
#define PIOD_PUDR_P31_MASK 0x80000000
#define PIOD_PUDR_P31 0x80000000
#define PIOD_PUDR_P31_BIT 31

#define PIOD_PUER (*(volatile unsigned long *)0xFFFFFA64)
#define PIOD_PUER_OFFSET 0x64
#define PIOD_PUER_P0_MASK 0x1
#define PIOD_PUER_P0 0x1
#define PIOD_PUER_P0_BIT 0
#define PIOD_PUER_P1_MASK 0x2
#define PIOD_PUER_P1 0x2
#define PIOD_PUER_P1_BIT 1
#define PIOD_PUER_P2_MASK 0x4
#define PIOD_PUER_P2 0x4
#define PIOD_PUER_P2_BIT 2
#define PIOD_PUER_P3_MASK 0x8
#define PIOD_PUER_P3 0x8
#define PIOD_PUER_P3_BIT 3
#define PIOD_PUER_P4_MASK 0x10
#define PIOD_PUER_P4 0x10
#define PIOD_PUER_P4_BIT 4
#define PIOD_PUER_P5_MASK 0x20
#define PIOD_PUER_P5 0x20
#define PIOD_PUER_P5_BIT 5
#define PIOD_PUER_P6_MASK 0x40
#define PIOD_PUER_P6 0x40
#define PIOD_PUER_P6_BIT 6
#define PIOD_PUER_P7_MASK 0x80
#define PIOD_PUER_P7 0x80
#define PIOD_PUER_P7_BIT 7
#define PIOD_PUER_P8_MASK 0x100
#define PIOD_PUER_P8 0x100
#define PIOD_PUER_P8_BIT 8
#define PIOD_PUER_P9_MASK 0x200
#define PIOD_PUER_P9 0x200
#define PIOD_PUER_P9_BIT 9
#define PIOD_PUER_P10_MASK 0x400
#define PIOD_PUER_P10 0x400
#define PIOD_PUER_P10_BIT 10
#define PIOD_PUER_P11_MASK 0x800
#define PIOD_PUER_P11 0x800
#define PIOD_PUER_P11_BIT 11
#define PIOD_PUER_P12_MASK 0x1000
#define PIOD_PUER_P12 0x1000
#define PIOD_PUER_P12_BIT 12
#define PIOD_PUER_P13_MASK 0x2000
#define PIOD_PUER_P13 0x2000
#define PIOD_PUER_P13_BIT 13
#define PIOD_PUER_P14_MASK 0x4000
#define PIOD_PUER_P14 0x4000
#define PIOD_PUER_P14_BIT 14
#define PIOD_PUER_P15_MASK 0x8000
#define PIOD_PUER_P15 0x8000
#define PIOD_PUER_P15_BIT 15
#define PIOD_PUER_P16_MASK 0x10000
#define PIOD_PUER_P16 0x10000
#define PIOD_PUER_P16_BIT 16
#define PIOD_PUER_P17_MASK 0x20000
#define PIOD_PUER_P17 0x20000
#define PIOD_PUER_P17_BIT 17
#define PIOD_PUER_P18_MASK 0x40000
#define PIOD_PUER_P18 0x40000
#define PIOD_PUER_P18_BIT 18
#define PIOD_PUER_P19_MASK 0x80000
#define PIOD_PUER_P19 0x80000
#define PIOD_PUER_P19_BIT 19
#define PIOD_PUER_P20_MASK 0x100000
#define PIOD_PUER_P20 0x100000
#define PIOD_PUER_P20_BIT 20
#define PIOD_PUER_P21_MASK 0x200000
#define PIOD_PUER_P21 0x200000
#define PIOD_PUER_P21_BIT 21
#define PIOD_PUER_P22_MASK 0x400000
#define PIOD_PUER_P22 0x400000
#define PIOD_PUER_P22_BIT 22
#define PIOD_PUER_P23_MASK 0x800000
#define PIOD_PUER_P23 0x800000
#define PIOD_PUER_P23_BIT 23
#define PIOD_PUER_P24_MASK 0x1000000
#define PIOD_PUER_P24 0x1000000
#define PIOD_PUER_P24_BIT 24
#define PIOD_PUER_P25_MASK 0x2000000
#define PIOD_PUER_P25 0x2000000
#define PIOD_PUER_P25_BIT 25
#define PIOD_PUER_P26_MASK 0x4000000
#define PIOD_PUER_P26 0x4000000
#define PIOD_PUER_P26_BIT 26
#define PIOD_PUER_P27_MASK 0x8000000
#define PIOD_PUER_P27 0x8000000
#define PIOD_PUER_P27_BIT 27
#define PIOD_PUER_P28_MASK 0x10000000
#define PIOD_PUER_P28 0x10000000
#define PIOD_PUER_P28_BIT 28
#define PIOD_PUER_P29_MASK 0x20000000
#define PIOD_PUER_P29 0x20000000
#define PIOD_PUER_P29_BIT 29
#define PIOD_PUER_P30_MASK 0x40000000
#define PIOD_PUER_P30 0x40000000
#define PIOD_PUER_P30_BIT 30
#define PIOD_PUER_P31_MASK 0x80000000
#define PIOD_PUER_P31 0x80000000
#define PIOD_PUER_P31_BIT 31

#define PIOD_PUSR (*(volatile unsigned long *)0xFFFFFA68)
#define PIOD_PUSR_OFFSET 0x68
#define PIOD_PUSR_P0_MASK 0x1
#define PIOD_PUSR_P0 0x1
#define PIOD_PUSR_P0_BIT 0
#define PIOD_PUSR_P1_MASK 0x2
#define PIOD_PUSR_P1 0x2
#define PIOD_PUSR_P1_BIT 1
#define PIOD_PUSR_P2_MASK 0x4
#define PIOD_PUSR_P2 0x4
#define PIOD_PUSR_P2_BIT 2
#define PIOD_PUSR_P3_MASK 0x8
#define PIOD_PUSR_P3 0x8
#define PIOD_PUSR_P3_BIT 3
#define PIOD_PUSR_P4_MASK 0x10
#define PIOD_PUSR_P4 0x10
#define PIOD_PUSR_P4_BIT 4
#define PIOD_PUSR_P5_MASK 0x20
#define PIOD_PUSR_P5 0x20
#define PIOD_PUSR_P5_BIT 5
#define PIOD_PUSR_P6_MASK 0x40
#define PIOD_PUSR_P6 0x40
#define PIOD_PUSR_P6_BIT 6
#define PIOD_PUSR_P7_MASK 0x80
#define PIOD_PUSR_P7 0x80
#define PIOD_PUSR_P7_BIT 7
#define PIOD_PUSR_P8_MASK 0x100
#define PIOD_PUSR_P8 0x100
#define PIOD_PUSR_P8_BIT 8
#define PIOD_PUSR_P9_MASK 0x200
#define PIOD_PUSR_P9 0x200
#define PIOD_PUSR_P9_BIT 9
#define PIOD_PUSR_P10_MASK 0x400
#define PIOD_PUSR_P10 0x400
#define PIOD_PUSR_P10_BIT 10
#define PIOD_PUSR_P11_MASK 0x800
#define PIOD_PUSR_P11 0x800
#define PIOD_PUSR_P11_BIT 11
#define PIOD_PUSR_P12_MASK 0x1000
#define PIOD_PUSR_P12 0x1000
#define PIOD_PUSR_P12_BIT 12
#define PIOD_PUSR_P13_MASK 0x2000
#define PIOD_PUSR_P13 0x2000
#define PIOD_PUSR_P13_BIT 13
#define PIOD_PUSR_P14_MASK 0x4000
#define PIOD_PUSR_P14 0x4000
#define PIOD_PUSR_P14_BIT 14
#define PIOD_PUSR_P15_MASK 0x8000
#define PIOD_PUSR_P15 0x8000
#define PIOD_PUSR_P15_BIT 15
#define PIOD_PUSR_P16_MASK 0x10000
#define PIOD_PUSR_P16 0x10000
#define PIOD_PUSR_P16_BIT 16
#define PIOD_PUSR_P17_MASK 0x20000
#define PIOD_PUSR_P17 0x20000
#define PIOD_PUSR_P17_BIT 17
#define PIOD_PUSR_P18_MASK 0x40000
#define PIOD_PUSR_P18 0x40000
#define PIOD_PUSR_P18_BIT 18
#define PIOD_PUSR_P19_MASK 0x80000
#define PIOD_PUSR_P19 0x80000
#define PIOD_PUSR_P19_BIT 19
#define PIOD_PUSR_P20_MASK 0x100000
#define PIOD_PUSR_P20 0x100000
#define PIOD_PUSR_P20_BIT 20
#define PIOD_PUSR_P21_MASK 0x200000
#define PIOD_PUSR_P21 0x200000
#define PIOD_PUSR_P21_BIT 21
#define PIOD_PUSR_P22_MASK 0x400000
#define PIOD_PUSR_P22 0x400000
#define PIOD_PUSR_P22_BIT 22
#define PIOD_PUSR_P23_MASK 0x800000
#define PIOD_PUSR_P23 0x800000
#define PIOD_PUSR_P23_BIT 23
#define PIOD_PUSR_P24_MASK 0x1000000
#define PIOD_PUSR_P24 0x1000000
#define PIOD_PUSR_P24_BIT 24
#define PIOD_PUSR_P25_MASK 0x2000000
#define PIOD_PUSR_P25 0x2000000
#define PIOD_PUSR_P25_BIT 25
#define PIOD_PUSR_P26_MASK 0x4000000
#define PIOD_PUSR_P26 0x4000000
#define PIOD_PUSR_P26_BIT 26
#define PIOD_PUSR_P27_MASK 0x8000000
#define PIOD_PUSR_P27 0x8000000
#define PIOD_PUSR_P27_BIT 27
#define PIOD_PUSR_P28_MASK 0x10000000
#define PIOD_PUSR_P28 0x10000000
#define PIOD_PUSR_P28_BIT 28
#define PIOD_PUSR_P29_MASK 0x20000000
#define PIOD_PUSR_P29 0x20000000
#define PIOD_PUSR_P29_BIT 29
#define PIOD_PUSR_P30_MASK 0x40000000
#define PIOD_PUSR_P30 0x40000000
#define PIOD_PUSR_P30_BIT 30
#define PIOD_PUSR_P31_MASK 0x80000000
#define PIOD_PUSR_P31 0x80000000
#define PIOD_PUSR_P31_BIT 31

#define PIOD_ASR (*(volatile unsigned long *)0xFFFFFA70)
#define PIOD_ASR_OFFSET 0x70
#define PIOD_ASR_P0_MASK 0x1
#define PIOD_ASR_P0 0x1
#define PIOD_ASR_P0_BIT 0
#define PIOD_ASR_P1_MASK 0x2
#define PIOD_ASR_P1 0x2
#define PIOD_ASR_P1_BIT 1
#define PIOD_ASR_P2_MASK 0x4
#define PIOD_ASR_P2 0x4
#define PIOD_ASR_P2_BIT 2
#define PIOD_ASR_P3_MASK 0x8
#define PIOD_ASR_P3 0x8
#define PIOD_ASR_P3_BIT 3
#define PIOD_ASR_P4_MASK 0x10
#define PIOD_ASR_P4 0x10
#define PIOD_ASR_P4_BIT 4
#define PIOD_ASR_P5_MASK 0x20
#define PIOD_ASR_P5 0x20
#define PIOD_ASR_P5_BIT 5
#define PIOD_ASR_P6_MASK 0x40
#define PIOD_ASR_P6 0x40
#define PIOD_ASR_P6_BIT 6
#define PIOD_ASR_P7_MASK 0x80
#define PIOD_ASR_P7 0x80
#define PIOD_ASR_P7_BIT 7
#define PIOD_ASR_P8_MASK 0x100
#define PIOD_ASR_P8 0x100
#define PIOD_ASR_P8_BIT 8
#define PIOD_ASR_P9_MASK 0x200
#define PIOD_ASR_P9 0x200
#define PIOD_ASR_P9_BIT 9
#define PIOD_ASR_P10_MASK 0x400
#define PIOD_ASR_P10 0x400
#define PIOD_ASR_P10_BIT 10
#define PIOD_ASR_P11_MASK 0x800
#define PIOD_ASR_P11 0x800
#define PIOD_ASR_P11_BIT 11
#define PIOD_ASR_P12_MASK 0x1000
#define PIOD_ASR_P12 0x1000
#define PIOD_ASR_P12_BIT 12
#define PIOD_ASR_P13_MASK 0x2000
#define PIOD_ASR_P13 0x2000
#define PIOD_ASR_P13_BIT 13
#define PIOD_ASR_P14_MASK 0x4000
#define PIOD_ASR_P14 0x4000
#define PIOD_ASR_P14_BIT 14
#define PIOD_ASR_P15_MASK 0x8000
#define PIOD_ASR_P15 0x8000
#define PIOD_ASR_P15_BIT 15
#define PIOD_ASR_P16_MASK 0x10000
#define PIOD_ASR_P16 0x10000
#define PIOD_ASR_P16_BIT 16
#define PIOD_ASR_P17_MASK 0x20000
#define PIOD_ASR_P17 0x20000
#define PIOD_ASR_P17_BIT 17
#define PIOD_ASR_P18_MASK 0x40000
#define PIOD_ASR_P18 0x40000
#define PIOD_ASR_P18_BIT 18
#define PIOD_ASR_P19_MASK 0x80000
#define PIOD_ASR_P19 0x80000
#define PIOD_ASR_P19_BIT 19
#define PIOD_ASR_P20_MASK 0x100000
#define PIOD_ASR_P20 0x100000
#define PIOD_ASR_P20_BIT 20
#define PIOD_ASR_P21_MASK 0x200000
#define PIOD_ASR_P21 0x200000
#define PIOD_ASR_P21_BIT 21
#define PIOD_ASR_P22_MASK 0x400000
#define PIOD_ASR_P22 0x400000
#define PIOD_ASR_P22_BIT 22
#define PIOD_ASR_P23_MASK 0x800000
#define PIOD_ASR_P23 0x800000
#define PIOD_ASR_P23_BIT 23
#define PIOD_ASR_P24_MASK 0x1000000
#define PIOD_ASR_P24 0x1000000
#define PIOD_ASR_P24_BIT 24
#define PIOD_ASR_P25_MASK 0x2000000
#define PIOD_ASR_P25 0x2000000
#define PIOD_ASR_P25_BIT 25
#define PIOD_ASR_P26_MASK 0x4000000
#define PIOD_ASR_P26 0x4000000
#define PIOD_ASR_P26_BIT 26
#define PIOD_ASR_P27_MASK 0x8000000
#define PIOD_ASR_P27 0x8000000
#define PIOD_ASR_P27_BIT 27
#define PIOD_ASR_P28_MASK 0x10000000
#define PIOD_ASR_P28 0x10000000
#define PIOD_ASR_P28_BIT 28
#define PIOD_ASR_P29_MASK 0x20000000
#define PIOD_ASR_P29 0x20000000
#define PIOD_ASR_P29_BIT 29
#define PIOD_ASR_P30_MASK 0x40000000
#define PIOD_ASR_P30 0x40000000
#define PIOD_ASR_P30_BIT 30
#define PIOD_ASR_P31_MASK 0x80000000
#define PIOD_ASR_P31 0x80000000
#define PIOD_ASR_P31_BIT 31

#define PIOD_BSR (*(volatile unsigned long *)0xFFFFFA74)
#define PIOD_BSR_OFFSET 0x74
#define PIOD_BSR_P0_MASK 0x1
#define PIOD_BSR_P0 0x1
#define PIOD_BSR_P0_BIT 0
#define PIOD_BSR_P1_MASK 0x2
#define PIOD_BSR_P1 0x2
#define PIOD_BSR_P1_BIT 1
#define PIOD_BSR_P2_MASK 0x4
#define PIOD_BSR_P2 0x4
#define PIOD_BSR_P2_BIT 2
#define PIOD_BSR_P3_MASK 0x8
#define PIOD_BSR_P3 0x8
#define PIOD_BSR_P3_BIT 3
#define PIOD_BSR_P4_MASK 0x10
#define PIOD_BSR_P4 0x10
#define PIOD_BSR_P4_BIT 4
#define PIOD_BSR_P5_MASK 0x20
#define PIOD_BSR_P5 0x20
#define PIOD_BSR_P5_BIT 5
#define PIOD_BSR_P6_MASK 0x40
#define PIOD_BSR_P6 0x40
#define PIOD_BSR_P6_BIT 6
#define PIOD_BSR_P7_MASK 0x80
#define PIOD_BSR_P7 0x80
#define PIOD_BSR_P7_BIT 7
#define PIOD_BSR_P8_MASK 0x100
#define PIOD_BSR_P8 0x100
#define PIOD_BSR_P8_BIT 8
#define PIOD_BSR_P9_MASK 0x200
#define PIOD_BSR_P9 0x200
#define PIOD_BSR_P9_BIT 9
#define PIOD_BSR_P10_MASK 0x400
#define PIOD_BSR_P10 0x400
#define PIOD_BSR_P10_BIT 10
#define PIOD_BSR_P11_MASK 0x800
#define PIOD_BSR_P11 0x800
#define PIOD_BSR_P11_BIT 11
#define PIOD_BSR_P12_MASK 0x1000
#define PIOD_BSR_P12 0x1000
#define PIOD_BSR_P12_BIT 12
#define PIOD_BSR_P13_MASK 0x2000
#define PIOD_BSR_P13 0x2000
#define PIOD_BSR_P13_BIT 13
#define PIOD_BSR_P14_MASK 0x4000
#define PIOD_BSR_P14 0x4000
#define PIOD_BSR_P14_BIT 14
#define PIOD_BSR_P15_MASK 0x8000
#define PIOD_BSR_P15 0x8000
#define PIOD_BSR_P15_BIT 15
#define PIOD_BSR_P16_MASK 0x10000
#define PIOD_BSR_P16 0x10000
#define PIOD_BSR_P16_BIT 16
#define PIOD_BSR_P17_MASK 0x20000
#define PIOD_BSR_P17 0x20000
#define PIOD_BSR_P17_BIT 17
#define PIOD_BSR_P18_MASK 0x40000
#define PIOD_BSR_P18 0x40000
#define PIOD_BSR_P18_BIT 18
#define PIOD_BSR_P19_MASK 0x80000
#define PIOD_BSR_P19 0x80000
#define PIOD_BSR_P19_BIT 19
#define PIOD_BSR_P20_MASK 0x100000
#define PIOD_BSR_P20 0x100000
#define PIOD_BSR_P20_BIT 20
#define PIOD_BSR_P21_MASK 0x200000
#define PIOD_BSR_P21 0x200000
#define PIOD_BSR_P21_BIT 21
#define PIOD_BSR_P22_MASK 0x400000
#define PIOD_BSR_P22 0x400000
#define PIOD_BSR_P22_BIT 22
#define PIOD_BSR_P23_MASK 0x800000
#define PIOD_BSR_P23 0x800000
#define PIOD_BSR_P23_BIT 23
#define PIOD_BSR_P24_MASK 0x1000000
#define PIOD_BSR_P24 0x1000000
#define PIOD_BSR_P24_BIT 24
#define PIOD_BSR_P25_MASK 0x2000000
#define PIOD_BSR_P25 0x2000000
#define PIOD_BSR_P25_BIT 25
#define PIOD_BSR_P26_MASK 0x4000000
#define PIOD_BSR_P26 0x4000000
#define PIOD_BSR_P26_BIT 26
#define PIOD_BSR_P27_MASK 0x8000000
#define PIOD_BSR_P27 0x8000000
#define PIOD_BSR_P27_BIT 27
#define PIOD_BSR_P28_MASK 0x10000000
#define PIOD_BSR_P28 0x10000000
#define PIOD_BSR_P28_BIT 28
#define PIOD_BSR_P29_MASK 0x20000000
#define PIOD_BSR_P29 0x20000000
#define PIOD_BSR_P29_BIT 29
#define PIOD_BSR_P30_MASK 0x40000000
#define PIOD_BSR_P30 0x40000000
#define PIOD_BSR_P30_BIT 30
#define PIOD_BSR_P31_MASK 0x80000000
#define PIOD_BSR_P31 0x80000000
#define PIOD_BSR_P31_BIT 31

#define PIOD_ABSR (*(volatile unsigned long *)0xFFFFFA78)
#define PIOD_ABSR_OFFSET 0x78
#define PIOD_ABSR_P0_MASK 0x1
#define PIOD_ABSR_P0 0x1
#define PIOD_ABSR_P0_BIT 0
#define PIOD_ABSR_P1_MASK 0x2
#define PIOD_ABSR_P1 0x2
#define PIOD_ABSR_P1_BIT 1
#define PIOD_ABSR_P2_MASK 0x4
#define PIOD_ABSR_P2 0x4
#define PIOD_ABSR_P2_BIT 2
#define PIOD_ABSR_P3_MASK 0x8
#define PIOD_ABSR_P3 0x8
#define PIOD_ABSR_P3_BIT 3
#define PIOD_ABSR_P4_MASK 0x10
#define PIOD_ABSR_P4 0x10
#define PIOD_ABSR_P4_BIT 4
#define PIOD_ABSR_P5_MASK 0x20
#define PIOD_ABSR_P5 0x20
#define PIOD_ABSR_P5_BIT 5
#define PIOD_ABSR_P6_MASK 0x40
#define PIOD_ABSR_P6 0x40
#define PIOD_ABSR_P6_BIT 6
#define PIOD_ABSR_P7_MASK 0x80
#define PIOD_ABSR_P7 0x80
#define PIOD_ABSR_P7_BIT 7
#define PIOD_ABSR_P8_MASK 0x100
#define PIOD_ABSR_P8 0x100
#define PIOD_ABSR_P8_BIT 8
#define PIOD_ABSR_P9_MASK 0x200
#define PIOD_ABSR_P9 0x200
#define PIOD_ABSR_P9_BIT 9
#define PIOD_ABSR_P10_MASK 0x400
#define PIOD_ABSR_P10 0x400
#define PIOD_ABSR_P10_BIT 10
#define PIOD_ABSR_P11_MASK 0x800
#define PIOD_ABSR_P11 0x800
#define PIOD_ABSR_P11_BIT 11
#define PIOD_ABSR_P12_MASK 0x1000
#define PIOD_ABSR_P12 0x1000
#define PIOD_ABSR_P12_BIT 12
#define PIOD_ABSR_P13_MASK 0x2000
#define PIOD_ABSR_P13 0x2000
#define PIOD_ABSR_P13_BIT 13
#define PIOD_ABSR_P14_MASK 0x4000
#define PIOD_ABSR_P14 0x4000
#define PIOD_ABSR_P14_BIT 14
#define PIOD_ABSR_P15_MASK 0x8000
#define PIOD_ABSR_P15 0x8000
#define PIOD_ABSR_P15_BIT 15
#define PIOD_ABSR_P16_MASK 0x10000
#define PIOD_ABSR_P16 0x10000
#define PIOD_ABSR_P16_BIT 16
#define PIOD_ABSR_P17_MASK 0x20000
#define PIOD_ABSR_P17 0x20000
#define PIOD_ABSR_P17_BIT 17
#define PIOD_ABSR_P18_MASK 0x40000
#define PIOD_ABSR_P18 0x40000
#define PIOD_ABSR_P18_BIT 18
#define PIOD_ABSR_P19_MASK 0x80000
#define PIOD_ABSR_P19 0x80000
#define PIOD_ABSR_P19_BIT 19
#define PIOD_ABSR_P20_MASK 0x100000
#define PIOD_ABSR_P20 0x100000
#define PIOD_ABSR_P20_BIT 20
#define PIOD_ABSR_P21_MASK 0x200000
#define PIOD_ABSR_P21 0x200000
#define PIOD_ABSR_P21_BIT 21
#define PIOD_ABSR_P22_MASK 0x400000
#define PIOD_ABSR_P22 0x400000
#define PIOD_ABSR_P22_BIT 22
#define PIOD_ABSR_P23_MASK 0x800000
#define PIOD_ABSR_P23 0x800000
#define PIOD_ABSR_P23_BIT 23
#define PIOD_ABSR_P24_MASK 0x1000000
#define PIOD_ABSR_P24 0x1000000
#define PIOD_ABSR_P24_BIT 24
#define PIOD_ABSR_P25_MASK 0x2000000
#define PIOD_ABSR_P25 0x2000000
#define PIOD_ABSR_P25_BIT 25
#define PIOD_ABSR_P26_MASK 0x4000000
#define PIOD_ABSR_P26 0x4000000
#define PIOD_ABSR_P26_BIT 26
#define PIOD_ABSR_P27_MASK 0x8000000
#define PIOD_ABSR_P27 0x8000000
#define PIOD_ABSR_P27_BIT 27
#define PIOD_ABSR_P28_MASK 0x10000000
#define PIOD_ABSR_P28 0x10000000
#define PIOD_ABSR_P28_BIT 28
#define PIOD_ABSR_P29_MASK 0x20000000
#define PIOD_ABSR_P29 0x20000000
#define PIOD_ABSR_P29_BIT 29
#define PIOD_ABSR_P30_MASK 0x40000000
#define PIOD_ABSR_P30 0x40000000
#define PIOD_ABSR_P30_BIT 30
#define PIOD_ABSR_P31_MASK 0x80000000
#define PIOD_ABSR_P31 0x80000000
#define PIOD_ABSR_P31_BIT 31

#define PIOD_OWER (*(volatile unsigned long *)0xFFFFFAA0)
#define PIOD_OWER_OFFSET 0xA0
#define PIOD_OWER_P0_MASK 0x1
#define PIOD_OWER_P0 0x1
#define PIOD_OWER_P0_BIT 0
#define PIOD_OWER_P1_MASK 0x2
#define PIOD_OWER_P1 0x2
#define PIOD_OWER_P1_BIT 1
#define PIOD_OWER_P2_MASK 0x4
#define PIOD_OWER_P2 0x4
#define PIOD_OWER_P2_BIT 2
#define PIOD_OWER_P3_MASK 0x8
#define PIOD_OWER_P3 0x8
#define PIOD_OWER_P3_BIT 3
#define PIOD_OWER_P4_MASK 0x10
#define PIOD_OWER_P4 0x10
#define PIOD_OWER_P4_BIT 4
#define PIOD_OWER_P5_MASK 0x20
#define PIOD_OWER_P5 0x20
#define PIOD_OWER_P5_BIT 5
#define PIOD_OWER_P6_MASK 0x40
#define PIOD_OWER_P6 0x40
#define PIOD_OWER_P6_BIT 6
#define PIOD_OWER_P7_MASK 0x80
#define PIOD_OWER_P7 0x80
#define PIOD_OWER_P7_BIT 7
#define PIOD_OWER_P8_MASK 0x100
#define PIOD_OWER_P8 0x100
#define PIOD_OWER_P8_BIT 8
#define PIOD_OWER_P9_MASK 0x200
#define PIOD_OWER_P9 0x200
#define PIOD_OWER_P9_BIT 9
#define PIOD_OWER_P10_MASK 0x400
#define PIOD_OWER_P10 0x400
#define PIOD_OWER_P10_BIT 10
#define PIOD_OWER_P11_MASK 0x800
#define PIOD_OWER_P11 0x800
#define PIOD_OWER_P11_BIT 11
#define PIOD_OWER_P12_MASK 0x1000
#define PIOD_OWER_P12 0x1000
#define PIOD_OWER_P12_BIT 12
#define PIOD_OWER_P13_MASK 0x2000
#define PIOD_OWER_P13 0x2000
#define PIOD_OWER_P13_BIT 13
#define PIOD_OWER_P14_MASK 0x4000
#define PIOD_OWER_P14 0x4000
#define PIOD_OWER_P14_BIT 14
#define PIOD_OWER_P15_MASK 0x8000
#define PIOD_OWER_P15 0x8000
#define PIOD_OWER_P15_BIT 15
#define PIOD_OWER_P16_MASK 0x10000
#define PIOD_OWER_P16 0x10000
#define PIOD_OWER_P16_BIT 16
#define PIOD_OWER_P17_MASK 0x20000
#define PIOD_OWER_P17 0x20000
#define PIOD_OWER_P17_BIT 17
#define PIOD_OWER_P18_MASK 0x40000
#define PIOD_OWER_P18 0x40000
#define PIOD_OWER_P18_BIT 18
#define PIOD_OWER_P19_MASK 0x80000
#define PIOD_OWER_P19 0x80000
#define PIOD_OWER_P19_BIT 19
#define PIOD_OWER_P20_MASK 0x100000
#define PIOD_OWER_P20 0x100000
#define PIOD_OWER_P20_BIT 20
#define PIOD_OWER_P21_MASK 0x200000
#define PIOD_OWER_P21 0x200000
#define PIOD_OWER_P21_BIT 21
#define PIOD_OWER_P22_MASK 0x400000
#define PIOD_OWER_P22 0x400000
#define PIOD_OWER_P22_BIT 22
#define PIOD_OWER_P23_MASK 0x800000
#define PIOD_OWER_P23 0x800000
#define PIOD_OWER_P23_BIT 23
#define PIOD_OWER_P24_MASK 0x1000000
#define PIOD_OWER_P24 0x1000000
#define PIOD_OWER_P24_BIT 24
#define PIOD_OWER_P25_MASK 0x2000000
#define PIOD_OWER_P25 0x2000000
#define PIOD_OWER_P25_BIT 25
#define PIOD_OWER_P26_MASK 0x4000000
#define PIOD_OWER_P26 0x4000000
#define PIOD_OWER_P26_BIT 26
#define PIOD_OWER_P27_MASK 0x8000000
#define PIOD_OWER_P27 0x8000000
#define PIOD_OWER_P27_BIT 27
#define PIOD_OWER_P28_MASK 0x10000000
#define PIOD_OWER_P28 0x10000000
#define PIOD_OWER_P28_BIT 28
#define PIOD_OWER_P29_MASK 0x20000000
#define PIOD_OWER_P29 0x20000000
#define PIOD_OWER_P29_BIT 29
#define PIOD_OWER_P30_MASK 0x40000000
#define PIOD_OWER_P30 0x40000000
#define PIOD_OWER_P30_BIT 30
#define PIOD_OWER_P31_MASK 0x80000000
#define PIOD_OWER_P31 0x80000000
#define PIOD_OWER_P31_BIT 31

#define PIOD_OWDR (*(volatile unsigned long *)0xFFFFFAA4)
#define PIOD_OWDR_OFFSET 0xA4
#define PIOD_OWDR_P0_MASK 0x1
#define PIOD_OWDR_P0 0x1
#define PIOD_OWDR_P0_BIT 0
#define PIOD_OWDR_P1_MASK 0x2
#define PIOD_OWDR_P1 0x2
#define PIOD_OWDR_P1_BIT 1
#define PIOD_OWDR_P2_MASK 0x4
#define PIOD_OWDR_P2 0x4
#define PIOD_OWDR_P2_BIT 2
#define PIOD_OWDR_P3_MASK 0x8
#define PIOD_OWDR_P3 0x8
#define PIOD_OWDR_P3_BIT 3
#define PIOD_OWDR_P4_MASK 0x10
#define PIOD_OWDR_P4 0x10
#define PIOD_OWDR_P4_BIT 4
#define PIOD_OWDR_P5_MASK 0x20
#define PIOD_OWDR_P5 0x20
#define PIOD_OWDR_P5_BIT 5
#define PIOD_OWDR_P6_MASK 0x40
#define PIOD_OWDR_P6 0x40
#define PIOD_OWDR_P6_BIT 6
#define PIOD_OWDR_P7_MASK 0x80
#define PIOD_OWDR_P7 0x80
#define PIOD_OWDR_P7_BIT 7
#define PIOD_OWDR_P8_MASK 0x100
#define PIOD_OWDR_P8 0x100
#define PIOD_OWDR_P8_BIT 8
#define PIOD_OWDR_P9_MASK 0x200
#define PIOD_OWDR_P9 0x200
#define PIOD_OWDR_P9_BIT 9
#define PIOD_OWDR_P10_MASK 0x400
#define PIOD_OWDR_P10 0x400
#define PIOD_OWDR_P10_BIT 10
#define PIOD_OWDR_P11_MASK 0x800
#define PIOD_OWDR_P11 0x800
#define PIOD_OWDR_P11_BIT 11
#define PIOD_OWDR_P12_MASK 0x1000
#define PIOD_OWDR_P12 0x1000
#define PIOD_OWDR_P12_BIT 12
#define PIOD_OWDR_P13_MASK 0x2000
#define PIOD_OWDR_P13 0x2000
#define PIOD_OWDR_P13_BIT 13
#define PIOD_OWDR_P14_MASK 0x4000
#define PIOD_OWDR_P14 0x4000
#define PIOD_OWDR_P14_BIT 14
#define PIOD_OWDR_P15_MASK 0x8000
#define PIOD_OWDR_P15 0x8000
#define PIOD_OWDR_P15_BIT 15
#define PIOD_OWDR_P16_MASK 0x10000
#define PIOD_OWDR_P16 0x10000
#define PIOD_OWDR_P16_BIT 16
#define PIOD_OWDR_P17_MASK 0x20000
#define PIOD_OWDR_P17 0x20000
#define PIOD_OWDR_P17_BIT 17
#define PIOD_OWDR_P18_MASK 0x40000
#define PIOD_OWDR_P18 0x40000
#define PIOD_OWDR_P18_BIT 18
#define PIOD_OWDR_P19_MASK 0x80000
#define PIOD_OWDR_P19 0x80000
#define PIOD_OWDR_P19_BIT 19
#define PIOD_OWDR_P20_MASK 0x100000
#define PIOD_OWDR_P20 0x100000
#define PIOD_OWDR_P20_BIT 20
#define PIOD_OWDR_P21_MASK 0x200000
#define PIOD_OWDR_P21 0x200000
#define PIOD_OWDR_P21_BIT 21
#define PIOD_OWDR_P22_MASK 0x400000
#define PIOD_OWDR_P22 0x400000
#define PIOD_OWDR_P22_BIT 22
#define PIOD_OWDR_P23_MASK 0x800000
#define PIOD_OWDR_P23 0x800000
#define PIOD_OWDR_P23_BIT 23
#define PIOD_OWDR_P24_MASK 0x1000000
#define PIOD_OWDR_P24 0x1000000
#define PIOD_OWDR_P24_BIT 24
#define PIOD_OWDR_P25_MASK 0x2000000
#define PIOD_OWDR_P25 0x2000000
#define PIOD_OWDR_P25_BIT 25
#define PIOD_OWDR_P26_MASK 0x4000000
#define PIOD_OWDR_P26 0x4000000
#define PIOD_OWDR_P26_BIT 26
#define PIOD_OWDR_P27_MASK 0x8000000
#define PIOD_OWDR_P27 0x8000000
#define PIOD_OWDR_P27_BIT 27
#define PIOD_OWDR_P28_MASK 0x10000000
#define PIOD_OWDR_P28 0x10000000
#define PIOD_OWDR_P28_BIT 28
#define PIOD_OWDR_P29_MASK 0x20000000
#define PIOD_OWDR_P29 0x20000000
#define PIOD_OWDR_P29_BIT 29
#define PIOD_OWDR_P30_MASK 0x40000000
#define PIOD_OWDR_P30 0x40000000
#define PIOD_OWDR_P30_BIT 30
#define PIOD_OWDR_P31_MASK 0x80000000
#define PIOD_OWDR_P31 0x80000000
#define PIOD_OWDR_P31_BIT 31

#define PIOD_OWSR (*(volatile unsigned long *)0xFFFFFAA8)
#define PIOD_OWSR_OFFSET 0xA8
#define PIOD_OWSR_P0_MASK 0x1
#define PIOD_OWSR_P0 0x1
#define PIOD_OWSR_P0_BIT 0
#define PIOD_OWSR_P1_MASK 0x2
#define PIOD_OWSR_P1 0x2
#define PIOD_OWSR_P1_BIT 1
#define PIOD_OWSR_P2_MASK 0x4
#define PIOD_OWSR_P2 0x4
#define PIOD_OWSR_P2_BIT 2
#define PIOD_OWSR_P3_MASK 0x8
#define PIOD_OWSR_P3 0x8
#define PIOD_OWSR_P3_BIT 3
#define PIOD_OWSR_P4_MASK 0x10
#define PIOD_OWSR_P4 0x10
#define PIOD_OWSR_P4_BIT 4
#define PIOD_OWSR_P5_MASK 0x20
#define PIOD_OWSR_P5 0x20
#define PIOD_OWSR_P5_BIT 5
#define PIOD_OWSR_P6_MASK 0x40
#define PIOD_OWSR_P6 0x40
#define PIOD_OWSR_P6_BIT 6
#define PIOD_OWSR_P7_MASK 0x80
#define PIOD_OWSR_P7 0x80
#define PIOD_OWSR_P7_BIT 7
#define PIOD_OWSR_P8_MASK 0x100
#define PIOD_OWSR_P8 0x100
#define PIOD_OWSR_P8_BIT 8
#define PIOD_OWSR_P9_MASK 0x200
#define PIOD_OWSR_P9 0x200
#define PIOD_OWSR_P9_BIT 9
#define PIOD_OWSR_P10_MASK 0x400
#define PIOD_OWSR_P10 0x400
#define PIOD_OWSR_P10_BIT 10
#define PIOD_OWSR_P11_MASK 0x800
#define PIOD_OWSR_P11 0x800
#define PIOD_OWSR_P11_BIT 11
#define PIOD_OWSR_P12_MASK 0x1000
#define PIOD_OWSR_P12 0x1000
#define PIOD_OWSR_P12_BIT 12
#define PIOD_OWSR_P13_MASK 0x2000
#define PIOD_OWSR_P13 0x2000
#define PIOD_OWSR_P13_BIT 13
#define PIOD_OWSR_P14_MASK 0x4000
#define PIOD_OWSR_P14 0x4000
#define PIOD_OWSR_P14_BIT 14
#define PIOD_OWSR_P15_MASK 0x8000
#define PIOD_OWSR_P15 0x8000
#define PIOD_OWSR_P15_BIT 15
#define PIOD_OWSR_P16_MASK 0x10000
#define PIOD_OWSR_P16 0x10000
#define PIOD_OWSR_P16_BIT 16
#define PIOD_OWSR_P17_MASK 0x20000
#define PIOD_OWSR_P17 0x20000
#define PIOD_OWSR_P17_BIT 17
#define PIOD_OWSR_P18_MASK 0x40000
#define PIOD_OWSR_P18 0x40000
#define PIOD_OWSR_P18_BIT 18
#define PIOD_OWSR_P19_MASK 0x80000
#define PIOD_OWSR_P19 0x80000
#define PIOD_OWSR_P19_BIT 19
#define PIOD_OWSR_P20_MASK 0x100000
#define PIOD_OWSR_P20 0x100000
#define PIOD_OWSR_P20_BIT 20
#define PIOD_OWSR_P21_MASK 0x200000
#define PIOD_OWSR_P21 0x200000
#define PIOD_OWSR_P21_BIT 21
#define PIOD_OWSR_P22_MASK 0x400000
#define PIOD_OWSR_P22 0x400000
#define PIOD_OWSR_P22_BIT 22
#define PIOD_OWSR_P23_MASK 0x800000
#define PIOD_OWSR_P23 0x800000
#define PIOD_OWSR_P23_BIT 23
#define PIOD_OWSR_P24_MASK 0x1000000
#define PIOD_OWSR_P24 0x1000000
#define PIOD_OWSR_P24_BIT 24
#define PIOD_OWSR_P25_MASK 0x2000000
#define PIOD_OWSR_P25 0x2000000
#define PIOD_OWSR_P25_BIT 25
#define PIOD_OWSR_P26_MASK 0x4000000
#define PIOD_OWSR_P26 0x4000000
#define PIOD_OWSR_P26_BIT 26
#define PIOD_OWSR_P27_MASK 0x8000000
#define PIOD_OWSR_P27 0x8000000
#define PIOD_OWSR_P27_BIT 27
#define PIOD_OWSR_P28_MASK 0x10000000
#define PIOD_OWSR_P28 0x10000000
#define PIOD_OWSR_P28_BIT 28
#define PIOD_OWSR_P29_MASK 0x20000000
#define PIOD_OWSR_P29 0x20000000
#define PIOD_OWSR_P29_BIT 29
#define PIOD_OWSR_P30_MASK 0x40000000
#define PIOD_OWSR_P30 0x40000000
#define PIOD_OWSR_P30_BIT 30
#define PIOD_OWSR_P31_MASK 0x80000000
#define PIOD_OWSR_P31 0x80000000
#define PIOD_OWSR_P31_BIT 31

#define PMC_BASE 0xFFFFFC00

#define PMC_SCER (*(volatile unsigned long *)0xFFFFFC00)
#define PMC_SCER_OFFSET 0x0
#define PMC_SCER_PCL_MASK 0x1
#define PMC_SCER_PCL 0x1
#define PMC_SCER_PCL_BIT 0
#define PMC_SCER_UDP_MASK 0x2
#define PMC_SCER_UDP 0x2
#define PMC_SCER_UDP_BIT 1
#define PMC_SCER_MCKUDP_MASK 0x4
#define PMC_SCER_MCKUDP 0x4
#define PMC_SCER_MCKUDP_BIT 2
#define PMC_SCER_UHP_MASK 0x10
#define PMC_SCER_UHP 0x10
#define PMC_SCER_UHP_BIT 4
#define PMC_SCER_PCK0_MASK 0x100
#define PMC_SCER_PCK0 0x100
#define PMC_SCER_PCK0_BIT 8
#define PMC_SCER_PCK1_MASK 0x200
#define PMC_SCER_PCK1 0x200
#define PMC_SCER_PCK1_BIT 9
#define PMC_SCER_PCK2_MASK 0x400
#define PMC_SCER_PCK2 0x400
#define PMC_SCER_PCK2_BIT 10
#define PMC_SCER_PCK3_MASK 0x800
#define PMC_SCER_PCK3 0x800
#define PMC_SCER_PCK3_BIT 11

#define PMC_SCDR (*(volatile unsigned long *)0xFFFFFC04)
#define PMC_SCDR_OFFSET 0x4
#define PMC_SCDR_PCL_MASK 0x1
#define PMC_SCDR_PCL 0x1
#define PMC_SCDR_PCL_BIT 0
#define PMC_SCDR_UDP_MASK 0x2
#define PMC_SCDR_UDP 0x2
#define PMC_SCDR_UDP_BIT 1
#define PMC_SCDR_MCKUDP_MASK 0x4
#define PMC_SCDR_MCKUDP 0x4
#define PMC_SCDR_MCKUDP_BIT 2
#define PMC_SCDR_UHP_MASK 0x10
#define PMC_SCDR_UHP 0x10
#define PMC_SCDR_UHP_BIT 4
#define PMC_SCDR_PCK0_MASK 0x100
#define PMC_SCDR_PCK0 0x100
#define PMC_SCDR_PCK0_BIT 8
#define PMC_SCDR_PCK1_MASK 0x200
#define PMC_SCDR_PCK1 0x200
#define PMC_SCDR_PCK1_BIT 9
#define PMC_SCDR_PCK2_MASK 0x400
#define PMC_SCDR_PCK2 0x400
#define PMC_SCDR_PCK2_BIT 10
#define PMC_SCDR_PCK3_MASK 0x800
#define PMC_SCDR_PCK3 0x800
#define PMC_SCDR_PCK3_BIT 11

#define PMC_SCSR (*(volatile unsigned long *)0xFFFFFC08)
#define PMC_SCSR_OFFSET 0x8
#define PMC_SCSR_PCL_MASK 0x1
#define PMC_SCSR_PCL 0x1
#define PMC_SCSR_PCL_BIT 0
#define PMC_SCSR_UDP_MASK 0x2
#define PMC_SCSR_UDP 0x2
#define PMC_SCSR_UDP_BIT 1
#define PMC_SCSR_MCKUDP_MASK 0x4
#define PMC_SCSR_MCKUDP 0x4
#define PMC_SCSR_MCKUDP_BIT 2
#define PMC_SCSR_UHP_MASK 0x10
#define PMC_SCSR_UHP 0x10
#define PMC_SCSR_UHP_BIT 4
#define PMC_SCSR_PCK0_MASK 0x100
#define PMC_SCSR_PCK0 0x100
#define PMC_SCSR_PCK0_BIT 8
#define PMC_SCSR_PCK1_MASK 0x200
#define PMC_SCSR_PCK1 0x200
#define PMC_SCSR_PCK1_BIT 9
#define PMC_SCSR_PCK2_MASK 0x400
#define PMC_SCSR_PCK2 0x400
#define PMC_SCSR_PCK2_BIT 10
#define PMC_SCSR_PCK3_MASK 0x800
#define PMC_SCSR_PCK3 0x800
#define PMC_SCSR_PCK3_BIT 11

#define PMC_PCER (*(volatile unsigned long *)0xFFFFFC10)
#define PMC_PCER_OFFSET 0x10
#define PMC_PCER_PID2_MASK 0x4
#define PMC_PCER_PID2 0x4
#define PMC_PCER_PID2_BIT 2
#define PMC_PCER_PID3_MASK 0x8
#define PMC_PCER_PID3 0x8
#define PMC_PCER_PID3_BIT 3
#define PMC_PCER_PID4_MASK 0x10
#define PMC_PCER_PID4 0x10
#define PMC_PCER_PID4_BIT 4
#define PMC_PCER_PID5_MASK 0x20
#define PMC_PCER_PID5 0x20
#define PMC_PCER_PID5_BIT 5
#define PMC_PCER_PID6_MASK 0x40
#define PMC_PCER_PID6 0x40
#define PMC_PCER_PID6_BIT 6
#define PMC_PCER_PID7_MASK 0x80
#define PMC_PCER_PID7 0x80
#define PMC_PCER_PID7_BIT 7
#define PMC_PCER_PID8_MASK 0x100
#define PMC_PCER_PID8 0x100
#define PMC_PCER_PID8_BIT 8
#define PMC_PCER_PID9_MASK 0x200
#define PMC_PCER_PID9 0x200
#define PMC_PCER_PID9_BIT 9
#define PMC_PCER_PID10_MASK 0x400
#define PMC_PCER_PID10 0x400
#define PMC_PCER_PID10_BIT 10
#define PMC_PCER_PID11_MASK 0x800
#define PMC_PCER_PID11 0x800
#define PMC_PCER_PID11_BIT 11
#define PMC_PCER_PID12_MASK 0x1000
#define PMC_PCER_PID12 0x1000
#define PMC_PCER_PID12_BIT 12
#define PMC_PCER_PID13_MASK 0x2000
#define PMC_PCER_PID13 0x2000
#define PMC_PCER_PID13_BIT 13
#define PMC_PCER_PID14_MASK 0x4000
#define PMC_PCER_PID14 0x4000
#define PMC_PCER_PID14_BIT 14
#define PMC_PCER_PID15_MASK 0x8000
#define PMC_PCER_PID15 0x8000
#define PMC_PCER_PID15_BIT 15
#define PMC_PCER_PID16_MASK 0x10000
#define PMC_PCER_PID16 0x10000
#define PMC_PCER_PID16_BIT 16
#define PMC_PCER_PID17_MASK 0x20000
#define PMC_PCER_PID17 0x20000
#define PMC_PCER_PID17_BIT 17
#define PMC_PCER_PID18_MASK 0x40000
#define PMC_PCER_PID18 0x40000
#define PMC_PCER_PID18_BIT 18
#define PMC_PCER_PID19_MASK 0x80000
#define PMC_PCER_PID19 0x80000
#define PMC_PCER_PID19_BIT 19
#define PMC_PCER_PID20_MASK 0x100000
#define PMC_PCER_PID20 0x100000
#define PMC_PCER_PID20_BIT 20
#define PMC_PCER_PID21_MASK 0x200000
#define PMC_PCER_PID21 0x200000
#define PMC_PCER_PID21_BIT 21
#define PMC_PCER_PID22_MASK 0x400000
#define PMC_PCER_PID22 0x400000
#define PMC_PCER_PID22_BIT 22
#define PMC_PCER_PID23_MASK 0x800000
#define PMC_PCER_PID23 0x800000
#define PMC_PCER_PID23_BIT 23
#define PMC_PCER_PID24_MASK 0x1000000
#define PMC_PCER_PID24 0x1000000
#define PMC_PCER_PID24_BIT 24
#define PMC_PCER_PID25_MASK 0x2000000
#define PMC_PCER_PID25 0x2000000
#define PMC_PCER_PID25_BIT 25
#define PMC_PCER_PID26_MASK 0x4000000
#define PMC_PCER_PID26 0x4000000
#define PMC_PCER_PID26_BIT 26
#define PMC_PCER_PID27_MASK 0x8000000
#define PMC_PCER_PID27 0x8000000
#define PMC_PCER_PID27_BIT 27
#define PMC_PCER_PID28_MASK 0x10000000
#define PMC_PCER_PID28 0x10000000
#define PMC_PCER_PID28_BIT 28
#define PMC_PCER_PID29_MASK 0x20000000
#define PMC_PCER_PID29 0x20000000
#define PMC_PCER_PID29_BIT 29
#define PMC_PCER_PID30_MASK 0x40000000
#define PMC_PCER_PID30 0x40000000
#define PMC_PCER_PID30_BIT 30
#define PMC_PCER_PID31_MASK 0x80000000
#define PMC_PCER_PID31 0x80000000
#define PMC_PCER_PID31_BIT 31

#define PMC_PCDR (*(volatile unsigned long *)0xFFFFFC14)
#define PMC_PCDR_OFFSET 0x14
#define PMC_PCDR_PID2_MASK 0x4
#define PMC_PCDR_PID2 0x4
#define PMC_PCDR_PID2_BIT 2
#define PMC_PCDR_PID3_MASK 0x8
#define PMC_PCDR_PID3 0x8
#define PMC_PCDR_PID3_BIT 3
#define PMC_PCDR_PID4_MASK 0x10
#define PMC_PCDR_PID4 0x10
#define PMC_PCDR_PID4_BIT 4
#define PMC_PCDR_PID5_MASK 0x20
#define PMC_PCDR_PID5 0x20
#define PMC_PCDR_PID5_BIT 5
#define PMC_PCDR_PID6_MASK 0x40
#define PMC_PCDR_PID6 0x40
#define PMC_PCDR_PID6_BIT 6
#define PMC_PCDR_PID7_MASK 0x80
#define PMC_PCDR_PID7 0x80
#define PMC_PCDR_PID7_BIT 7
#define PMC_PCDR_PID8_MASK 0x100
#define PMC_PCDR_PID8 0x100
#define PMC_PCDR_PID8_BIT 8
#define PMC_PCDR_PID9_MASK 0x200
#define PMC_PCDR_PID9 0x200
#define PMC_PCDR_PID9_BIT 9
#define PMC_PCDR_PID10_MASK 0x400
#define PMC_PCDR_PID10 0x400
#define PMC_PCDR_PID10_BIT 10
#define PMC_PCDR_PID11_MASK 0x800
#define PMC_PCDR_PID11 0x800
#define PMC_PCDR_PID11_BIT 11
#define PMC_PCDR_PID12_MASK 0x1000
#define PMC_PCDR_PID12 0x1000
#define PMC_PCDR_PID12_BIT 12
#define PMC_PCDR_PID13_MASK 0x2000
#define PMC_PCDR_PID13 0x2000
#define PMC_PCDR_PID13_BIT 13
#define PMC_PCDR_PID14_MASK 0x4000
#define PMC_PCDR_PID14 0x4000
#define PMC_PCDR_PID14_BIT 14
#define PMC_PCDR_PID15_MASK 0x8000
#define PMC_PCDR_PID15 0x8000
#define PMC_PCDR_PID15_BIT 15
#define PMC_PCDR_PID16_MASK 0x10000
#define PMC_PCDR_PID16 0x10000
#define PMC_PCDR_PID16_BIT 16
#define PMC_PCDR_PID17_MASK 0x20000
#define PMC_PCDR_PID17 0x20000
#define PMC_PCDR_PID17_BIT 17
#define PMC_PCDR_PID18_MASK 0x40000
#define PMC_PCDR_PID18 0x40000
#define PMC_PCDR_PID18_BIT 18
#define PMC_PCDR_PID19_MASK 0x80000
#define PMC_PCDR_PID19 0x80000
#define PMC_PCDR_PID19_BIT 19
#define PMC_PCDR_PID20_MASK 0x100000
#define PMC_PCDR_PID20 0x100000
#define PMC_PCDR_PID20_BIT 20
#define PMC_PCDR_PID21_MASK 0x200000
#define PMC_PCDR_PID21 0x200000
#define PMC_PCDR_PID21_BIT 21
#define PMC_PCDR_PID22_MASK 0x400000
#define PMC_PCDR_PID22 0x400000
#define PMC_PCDR_PID22_BIT 22
#define PMC_PCDR_PID23_MASK 0x800000
#define PMC_PCDR_PID23 0x800000
#define PMC_PCDR_PID23_BIT 23
#define PMC_PCDR_PID24_MASK 0x1000000
#define PMC_PCDR_PID24 0x1000000
#define PMC_PCDR_PID24_BIT 24
#define PMC_PCDR_PID25_MASK 0x2000000
#define PMC_PCDR_PID25 0x2000000
#define PMC_PCDR_PID25_BIT 25
#define PMC_PCDR_PID26_MASK 0x4000000
#define PMC_PCDR_PID26 0x4000000
#define PMC_PCDR_PID26_BIT 26
#define PMC_PCDR_PID27_MASK 0x8000000
#define PMC_PCDR_PID27 0x8000000
#define PMC_PCDR_PID27_BIT 27
#define PMC_PCDR_PID28_MASK 0x10000000
#define PMC_PCDR_PID28 0x10000000
#define PMC_PCDR_PID28_BIT 28
#define PMC_PCDR_PID29_MASK 0x20000000
#define PMC_PCDR_PID29 0x20000000
#define PMC_PCDR_PID29_BIT 29
#define PMC_PCDR_PID30_MASK 0x40000000
#define PMC_PCDR_PID30 0x40000000
#define PMC_PCDR_PID30_BIT 30
#define PMC_PCDR_PID31_MASK 0x80000000
#define PMC_PCDR_PID31 0x80000000
#define PMC_PCDR_PID31_BIT 31

#define PMC_PCSR (*(volatile unsigned long *)0xFFFFFC18)
#define PMC_PCSR_OFFSET 0x18
#define PMC_PCSR_PID2_MASK 0x4
#define PMC_PCSR_PID2 0x4
#define PMC_PCSR_PID2_BIT 2
#define PMC_PCSR_PID3_MASK 0x8
#define PMC_PCSR_PID3 0x8
#define PMC_PCSR_PID3_BIT 3
#define PMC_PCSR_PID4_MASK 0x10
#define PMC_PCSR_PID4 0x10
#define PMC_PCSR_PID4_BIT 4
#define PMC_PCSR_PID5_MASK 0x20
#define PMC_PCSR_PID5 0x20
#define PMC_PCSR_PID5_BIT 5
#define PMC_PCSR_PID6_MASK 0x40
#define PMC_PCSR_PID6 0x40
#define PMC_PCSR_PID6_BIT 6
#define PMC_PCSR_PID7_MASK 0x80
#define PMC_PCSR_PID7 0x80
#define PMC_PCSR_PID7_BIT 7
#define PMC_PCSR_PID8_MASK 0x100
#define PMC_PCSR_PID8 0x100
#define PMC_PCSR_PID8_BIT 8
#define PMC_PCSR_PID9_MASK 0x200
#define PMC_PCSR_PID9 0x200
#define PMC_PCSR_PID9_BIT 9
#define PMC_PCSR_PID10_MASK 0x400
#define PMC_PCSR_PID10 0x400
#define PMC_PCSR_PID10_BIT 10
#define PMC_PCSR_PID11_MASK 0x800
#define PMC_PCSR_PID11 0x800
#define PMC_PCSR_PID11_BIT 11
#define PMC_PCSR_PID12_MASK 0x1000
#define PMC_PCSR_PID12 0x1000
#define PMC_PCSR_PID12_BIT 12
#define PMC_PCSR_PID13_MASK 0x2000
#define PMC_PCSR_PID13 0x2000
#define PMC_PCSR_PID13_BIT 13
#define PMC_PCSR_PID14_MASK 0x4000
#define PMC_PCSR_PID14 0x4000
#define PMC_PCSR_PID14_BIT 14
#define PMC_PCSR_PID15_MASK 0x8000
#define PMC_PCSR_PID15 0x8000
#define PMC_PCSR_PID15_BIT 15
#define PMC_PCSR_PID16_MASK 0x10000
#define PMC_PCSR_PID16 0x10000
#define PMC_PCSR_PID16_BIT 16
#define PMC_PCSR_PID17_MASK 0x20000
#define PMC_PCSR_PID17 0x20000
#define PMC_PCSR_PID17_BIT 17
#define PMC_PCSR_PID18_MASK 0x40000
#define PMC_PCSR_PID18 0x40000
#define PMC_PCSR_PID18_BIT 18
#define PMC_PCSR_PID19_MASK 0x80000
#define PMC_PCSR_PID19 0x80000
#define PMC_PCSR_PID19_BIT 19
#define PMC_PCSR_PID20_MASK 0x100000
#define PMC_PCSR_PID20 0x100000
#define PMC_PCSR_PID20_BIT 20
#define PMC_PCSR_PID21_MASK 0x200000
#define PMC_PCSR_PID21 0x200000
#define PMC_PCSR_PID21_BIT 21
#define PMC_PCSR_PID22_MASK 0x400000
#define PMC_PCSR_PID22 0x400000
#define PMC_PCSR_PID22_BIT 22
#define PMC_PCSR_PID23_MASK 0x800000
#define PMC_PCSR_PID23 0x800000
#define PMC_PCSR_PID23_BIT 23
#define PMC_PCSR_PID24_MASK 0x1000000
#define PMC_PCSR_PID24 0x1000000
#define PMC_PCSR_PID24_BIT 24
#define PMC_PCSR_PID25_MASK 0x2000000
#define PMC_PCSR_PID25 0x2000000
#define PMC_PCSR_PID25_BIT 25
#define PMC_PCSR_PID26_MASK 0x4000000
#define PMC_PCSR_PID26 0x4000000
#define PMC_PCSR_PID26_BIT 26
#define PMC_PCSR_PID27_MASK 0x8000000
#define PMC_PCSR_PID27 0x8000000
#define PMC_PCSR_PID27_BIT 27
#define PMC_PCSR_PID28_MASK 0x10000000
#define PMC_PCSR_PID28 0x10000000
#define PMC_PCSR_PID28_BIT 28
#define PMC_PCSR_PID29_MASK 0x20000000
#define PMC_PCSR_PID29 0x20000000
#define PMC_PCSR_PID29_BIT 29
#define PMC_PCSR_PID30_MASK 0x40000000
#define PMC_PCSR_PID30 0x40000000
#define PMC_PCSR_PID30_BIT 30
#define PMC_PCSR_PID31_MASK 0x80000000
#define PMC_PCSR_PID31 0x80000000
#define PMC_PCSR_PID31_BIT 31

#define PMC_MCKR (*(volatile unsigned long *)0xFFFFFC30)
#define PMC_MCKR_OFFSET 0x30
#define PMC_MCKR_CSS_MASK 0x3
#define PMC_MCKR_CSS_BIT 0
#define PMC_MCKR_PRES_MASK 0x1C
#define PMC_MCKR_PRES_BIT 2
#define PMC_MCKR_MDIV_MASK 0x300
#define PMC_MCKR_MDIV_BIT 8

#define PMC_PCK0 (*(volatile unsigned long *)0xFFFFFC40)
#define PMC_PCK0_OFFSET 0x40
#define PMC_PCK0_CSS_MASK 0x3
#define PMC_PCK0_CSS_BIT 0
#define PMC_PCK0_PRES_MASK 0x1C
#define PMC_PCK0_PRES_BIT 2

#define PMC_PCK1 (*(volatile unsigned long *)0xFFFFFC44)
#define PMC_PCK1_OFFSET 0x44
#define PMC_PCK1_CSS_MASK 0x3
#define PMC_PCK1_CSS_BIT 0
#define PMC_PCK1_PRES_MASK 0x1C
#define PMC_PCK1_PRES_BIT 2

#define PMC_PCK2 (*(volatile unsigned long *)0xFFFFFC48)
#define PMC_PCK2_OFFSET 0x48
#define PMC_PCK2_CSS_MASK 0x3
#define PMC_PCK2_CSS_BIT 0
#define PMC_PCK2_PRES_MASK 0x1C
#define PMC_PCK2_PRES_BIT 2

#define PMC_PCK3 (*(volatile unsigned long *)0xFFFFFC4C)
#define PMC_PCK3_OFFSET 0x4C
#define PMC_PCK3_CSS_MASK 0x3
#define PMC_PCK3_CSS_BIT 0
#define PMC_PCK3_PRES_MASK 0x1C
#define PMC_PCK3_PRES_BIT 2

#define PMC_IER (*(volatile unsigned long *)0xFFFFFC60)
#define PMC_IER_OFFSET 0x60
#define PMC_IER_MOSCS_MASK 0x1
#define PMC_IER_MOSCS 0x1
#define PMC_IER_MOSCS_BIT 0
#define PMC_IER_LOCKA_MASK 0x2
#define PMC_IER_LOCKA 0x2
#define PMC_IER_LOCKA_BIT 1
#define PMC_IER_LOCKB_MASK 0x4
#define PMC_IER_LOCKB 0x4
#define PMC_IER_LOCKB_BIT 2
#define PMC_IER_MCKRDY_MASK 0x8
#define PMC_IER_MCKRDY 0x8
#define PMC_IER_MCKRDY_BIT 3
#define PMC_IER_PCK0RDY_MASK 0x100
#define PMC_IER_PCK0RDY 0x100
#define PMC_IER_PCK0RDY_BIT 8
#define PMC_IER_PCK1RDY_MASK 0x200
#define PMC_IER_PCK1RDY 0x200
#define PMC_IER_PCK1RDY_BIT 9
#define PMC_IER_PCK2RDY_MASK 0x400
#define PMC_IER_PCK2RDY 0x400
#define PMC_IER_PCK2RDY_BIT 10
#define PMC_IER_PCK3RDY_MASK 0x800
#define PMC_IER_PCK3RDY 0x800
#define PMC_IER_PCK3RDY_BIT 11

#define PMC_IDR (*(volatile unsigned long *)0xFFFFFC64)
#define PMC_IDR_OFFSET 0x64
#define PMC_IDR_MOSCS_MASK 0x1
#define PMC_IDR_MOSCS 0x1
#define PMC_IDR_MOSCS_BIT 0
#define PMC_IDR_LOCKA_MASK 0x2
#define PMC_IDR_LOCKA 0x2
#define PMC_IDR_LOCKA_BIT 1
#define PMC_IDR_LOCKB_MASK 0x4
#define PMC_IDR_LOCKB 0x4
#define PMC_IDR_LOCKB_BIT 2
#define PMC_IDR_MCKRDY_MASK 0x8
#define PMC_IDR_MCKRDY 0x8
#define PMC_IDR_MCKRDY_BIT 3
#define PMC_IDR_PCK0RDY_MASK 0x100
#define PMC_IDR_PCK0RDY 0x100
#define PMC_IDR_PCK0RDY_BIT 8
#define PMC_IDR_PCK1RDY_MASK 0x200
#define PMC_IDR_PCK1RDY 0x200
#define PMC_IDR_PCK1RDY_BIT 9
#define PMC_IDR_PCK2RDY_MASK 0x400
#define PMC_IDR_PCK2RDY 0x400
#define PMC_IDR_PCK2RDY_BIT 10
#define PMC_IDR_PCK3RDY_MASK 0x800
#define PMC_IDR_PCK3RDY 0x800
#define PMC_IDR_PCK3RDY_BIT 11

#define PMC_SR (*(volatile unsigned long *)0xFFFFFC68)
#define PMC_SR_OFFSET 0x68
#define PMC_SR_MOSCS_MASK 0x1
#define PMC_SR_MOSCS 0x1
#define PMC_SR_MOSCS_BIT 0
#define PMC_SR_LOCKA_MASK 0x2
#define PMC_SR_LOCKA 0x2
#define PMC_SR_LOCKA_BIT 1
#define PMC_SR_LOCKB_MASK 0x4
#define PMC_SR_LOCKB 0x4
#define PMC_SR_LOCKB_BIT 2
#define PMC_SR_MCKRDY_MASK 0x8
#define PMC_SR_MCKRDY 0x8
#define PMC_SR_MCKRDY_BIT 3
#define PMC_SR_PCK0RDY_MASK 0x100
#define PMC_SR_PCK0RDY 0x100
#define PMC_SR_PCK0RDY_BIT 8
#define PMC_SR_PCK1RDY_MASK 0x200
#define PMC_SR_PCK1RDY 0x200
#define PMC_SR_PCK1RDY_BIT 9
#define PMC_SR_PCK2RDY_MASK 0x400
#define PMC_SR_PCK2RDY 0x400
#define PMC_SR_PCK2RDY_BIT 10
#define PMC_SR_PCK3RDY_MASK 0x800
#define PMC_SR_PCK3RDY 0x800
#define PMC_SR_PCK3RDY_BIT 11

#define PMC_IMR (*(volatile unsigned long *)0xFFFFFC6C)
#define PMC_IMR_OFFSET 0x6C
#define PMC_IMR_MOSCS_MASK 0x1
#define PMC_IMR_MOSCS 0x1
#define PMC_IMR_MOSCS_BIT 0
#define PMC_IMR_LOCKA_MASK 0x2
#define PMC_IMR_LOCKA 0x2
#define PMC_IMR_LOCKA_BIT 1
#define PMC_IMR_LOCKB_MASK 0x4
#define PMC_IMR_LOCKB 0x4
#define PMC_IMR_LOCKB_BIT 2
#define PMC_IMR_MCKRDY_MASK 0x8
#define PMC_IMR_MCKRDY 0x8
#define PMC_IMR_MCKRDY_BIT 3
#define PMC_IMR_PCK0RDY_MASK 0x100
#define PMC_IMR_PCK0RDY 0x100
#define PMC_IMR_PCK0RDY_BIT 8
#define PMC_IMR_PCK1RDY_MASK 0x200
#define PMC_IMR_PCK1RDY 0x200
#define PMC_IMR_PCK1RDY_BIT 9
#define PMC_IMR_PCK2RDY_MASK 0x400
#define PMC_IMR_PCK2RDY 0x400
#define PMC_IMR_PCK2RDY_BIT 10
#define PMC_IMR_PCK3RDY_MASK 0x800
#define PMC_IMR_PCK3RDY 0x800
#define PMC_IMR_PCK3RDY_BIT 11

#define CKGR_BASE 0xFFFFFC00

#define CKGR_MOR (*(volatile unsigned long *)0xFFFFFC20)
#define CKGR_MOR_OFFSET 0x20
#define CKGR_MOR_MOSCEN_MASK 0x1
#define CKGR_MOR_MOSCEN 0x1
#define CKGR_MOR_MOSCEN_BIT 0
#define CKGR_MOR_OSCBYPASS_MASK 0x2
#define CKGR_MOR_OSCBYPASS 0x2
#define CKGR_MOR_OSCBYPASS_BIT 1
#define CKGR_MOR_OSCOUNT_MASK 0xFF00
#define CKGR_MOR_OSCOUNT_BIT 8

#define CKGR_MCFR (*(volatile unsigned long *)0xFFFFFC24)
#define CKGR_MCFR_OFFSET 0x24
#define CKGR_MCFR_MAINF_MASK 0xFFFF
#define CKGR_MCFR_MAINF_BIT 0
#define CKGR_MCFR_MAINRDY_MASK 0x10000
#define CKGR_MCFR_MAINRDY 0x10000
#define CKGR_MCFR_MAINRDY_BIT 16

#define CKGR_PLLAR (*(volatile unsigned long *)0xFFFFFC28)
#define CKGR_PLLAR_OFFSET 0x28
#define CKGR_PLLAR_DIVA_MASK 0xFF
#define CKGR_PLLAR_DIVA_BIT 0
#define CKGR_PLLAR_PLLACOUNT_MASK 0x3F00
#define CKGR_PLLAR_PLLACOUNT_BIT 8
#define CKGR_PLLAR_OUTA_MASK 0xC000
#define CKGR_PLLAR_OUTA_BIT 14
#define CKGR_PLLAR_MULA_MASK 0x7FF0000
#define CKGR_PLLAR_MULA_BIT 16

#define CKGR_PLLBR (*(volatile unsigned long *)0xFFFFFC2C)
#define CKGR_PLLBR_OFFSET 0x2C
#define CKGR_PLLBR_DIVB_MASK 0xFF
#define CKGR_PLLBR_DIVB_BIT 0
#define CKGR_PLLBR_PLLBCOUNT_MASK 0x3F00
#define CKGR_PLLBR_PLLBCOUNT_BIT 8
#define CKGR_PLLBR_OUTB_MASK 0xC000
#define CKGR_PLLBR_OUTB_BIT 14
#define CKGR_PLLBR_MULB_MASK 0x7FF0000
#define CKGR_PLLBR_MULB_BIT 16
#define CKGR_PLLBR_USB_96M_MASK 0x10000000
#define CKGR_PLLBR_USB_96M 0x10000000
#define CKGR_PLLBR_USB_96M_BIT 28

#define ST_BASE 0xFFFFFD00

#define ST_CR (*(volatile unsigned long *)0xFFFFFD00)
#define ST_CR_OFFSET 0x0
#define ST_CR_WDRST_MASK 0x1
#define ST_CR_WDRST 0x1
#define ST_CR_WDRST_BIT 0

#define ST_PIMR (*(volatile unsigned long *)0xFFFFFD04)
#define ST_PIMR_OFFSET 0x4
#define ST_PIMR_PIV_MASK 0xFFFF
#define ST_PIMR_PIV_BIT 0

#define ST_WDMR (*(volatile unsigned long *)0xFFFFFD08)
#define ST_WDMR_OFFSET 0x8
#define ST_WDMR_WDV_MASK 0xFFFF
#define ST_WDMR_WDV_BIT 0
#define ST_WDMR_RSTEN_MASK 0x10000
#define ST_WDMR_RSTEN 0x10000
#define ST_WDMR_RSTEN_BIT 16
#define ST_WDMR_EXTEN_MASK 0x20000
#define ST_WDMR_EXTEN 0x20000
#define ST_WDMR_EXTEN_BIT 17

#define ST_RTMR (*(volatile unsigned long *)0xFFFFFD0C)
#define ST_RTMR_OFFSET 0xC
#define ST_RTMR_RTPRES_MASK 0xFFFF
#define ST_RTMR_RTPRES_BIT 0

#define ST_SR (*(volatile unsigned long *)0xFFFFFD10)
#define ST_SR_OFFSET 0x10
#define ST_SR_PITS_MASK 0x1
#define ST_SR_PITS 0x1
#define ST_SR_PITS_BIT 0
#define ST_SR_WDOVF_MASK 0x2
#define ST_SR_WDOVF 0x2
#define ST_SR_WDOVF_BIT 1
#define ST_SR_RTTINC_MASK 0x4
#define ST_SR_RTTINC 0x4
#define ST_SR_RTTINC_BIT 2
#define ST_SR_ALMS_MASK 0x8
#define ST_SR_ALMS 0x8
#define ST_SR_ALMS_BIT 3

#define ST_IER (*(volatile unsigned long *)0xFFFFFD14)
#define ST_IER_OFFSET 0x14
#define ST_IER_PITS_MASK 0x1
#define ST_IER_PITS 0x1
#define ST_IER_PITS_BIT 0
#define ST_IER_WDOVF_MASK 0x2
#define ST_IER_WDOVF 0x2
#define ST_IER_WDOVF_BIT 1
#define ST_IER_RTTINC_MASK 0x4
#define ST_IER_RTTINC 0x4
#define ST_IER_RTTINC_BIT 2
#define ST_IER_ALMS_MASK 0x8
#define ST_IER_ALMS 0x8
#define ST_IER_ALMS_BIT 3

#define ST_IDR (*(volatile unsigned long *)0xFFFFFD18)
#define ST_IDR_OFFSET 0x18
#define ST_IDR_PITS_MASK 0x1
#define ST_IDR_PITS 0x1
#define ST_IDR_PITS_BIT 0
#define ST_IDR_WDOVF_MASK 0x2
#define ST_IDR_WDOVF 0x2
#define ST_IDR_WDOVF_BIT 1
#define ST_IDR_RTTINC_MASK 0x4
#define ST_IDR_RTTINC 0x4
#define ST_IDR_RTTINC_BIT 2
#define ST_IDR_ALMS_MASK 0x8
#define ST_IDR_ALMS 0x8
#define ST_IDR_ALMS_BIT 3

#define ST_IMR (*(volatile unsigned long *)0xFFFFFD1C)
#define ST_IMR_OFFSET 0x1C
#define ST_IMR_PITS_MASK 0x1
#define ST_IMR_PITS 0x1
#define ST_IMR_PITS_BIT 0
#define ST_IMR_WDOVF_MASK 0x2
#define ST_IMR_WDOVF 0x2
#define ST_IMR_WDOVF_BIT 1
#define ST_IMR_RTTINC_MASK 0x4
#define ST_IMR_RTTINC 0x4
#define ST_IMR_RTTINC_BIT 2
#define ST_IMR_ALMS_MASK 0x8
#define ST_IMR_ALMS 0x8
#define ST_IMR_ALMS_BIT 3

#define ST_RTAR (*(volatile unsigned long *)0xFFFFFD20)
#define ST_RTAR_OFFSET 0x20
#define ST_RTAR_ALMV_MASK 0xFFFFF
#define ST_RTAR_ALMV_BIT 0

#define ST_CRTR (*(volatile unsigned long *)0xFFFFFD24)
#define ST_CRTR_OFFSET 0x24
#define ST_CRTR_CRTV_MASK 0xFFFFF
#define ST_CRTR_CRTV_BIT 0

#define RTC_BASE 0xFFFFFE00

#define RTC_CR (*(volatile unsigned long *)0xFFFFFE00)
#define RTC_CR_OFFSET 0x0
#define RTC_CR_UPDTIM_MASK 0x1
#define RTC_CR_UPDTIM 0x1
#define RTC_CR_UPDTIM_BIT 0
#define RTC_CR_UPDCAL_MASK 0x2
#define RTC_CR_UPDCAL 0x2
#define RTC_CR_UPDCAL_BIT 1
#define RTC_CR_TIMEVSEL_MASK 0x300
#define RTC_CR_TIMEVSEL_BIT 8
#define RTC_CR_CALEVSEL_MASK 0x30000
#define RTC_CR_CALEVSEL_BIT 16

#define RTC_MR (*(volatile unsigned long *)0xFFFFFE04)
#define RTC_MR_OFFSET 0x4
#define RTC_MR_HRMOD_MASK 0x1
#define RTC_MR_HRMOD 0x1
#define RTC_MR_HRMOD_BIT 0

#define RTC_TIMR (*(volatile unsigned long *)0xFFFFFE08)
#define RTC_TIMR_OFFSET 0x8
#define RTC_TIMR_SEC_MASK 0x7F
#define RTC_TIMR_SEC_BIT 0
#define RTC_TIMR_MIN_MASK 0x7F00
#define RTC_TIMR_MIN_BIT 8
#define RTC_TIMR_HOUR_MASK 0x3F0000
#define RTC_TIMR_HOUR_BIT 16
#define RTC_TIMR_AMPM_MASK 0x400000
#define RTC_TIMR_AMPM 0x400000
#define RTC_TIMR_AMPM_BIT 22

#define RTC_CALR (*(volatile unsigned long *)0xFFFFFE0C)
#define RTC_CALR_OFFSET 0xC
#define RTC_CALR_CENT_MASK 0x7F
#define RTC_CALR_CENT_BIT 0
#define RTC_CALR_YEAR_MASK 0xFF00
#define RTC_CALR_YEAR_BIT 8
#define RTC_CALR_MONTH_MASK 0x1F0000
#define RTC_CALR_MONTH_BIT 16
#define RTC_CALR_DAY_MASK 0xE00000
#define RTC_CALR_DAY_BIT 21
#define RTC_CALR_DATE_MASK 0x3F000000
#define RTC_CALR_DATE_BIT 24

#define RTC_TIMALR (*(volatile unsigned long *)0xFFFFFE10)
#define RTC_TIMALR_OFFSET 0x10
#define RTC_TIMALR_SEC_MASK 0x7F
#define RTC_TIMALR_SEC_BIT 0
#define RTC_TIMALR_SECEN_MASK 0x80
#define RTC_TIMALR_SECEN 0x80
#define RTC_TIMALR_SECEN_BIT 7
#define RTC_TIMALR_MIN_MASK 0x7F00
#define RTC_TIMALR_MIN_BIT 8
#define RTC_TIMALR_MINEN_MASK 0x8000
#define RTC_TIMALR_MINEN 0x8000
#define RTC_TIMALR_MINEN_BIT 15
#define RTC_TIMALR_HOUR_MASK 0x3F0000
#define RTC_TIMALR_HOUR_BIT 16
#define RTC_TIMALR_AMPM_MASK 0x400000
#define RTC_TIMALR_AMPM 0x400000
#define RTC_TIMALR_AMPM_BIT 22
#define RTC_TIMALR_HOUREN_MASK 0x800000
#define RTC_TIMALR_HOUREN 0x800000
#define RTC_TIMALR_HOUREN_BIT 23

#define RTC_CALALR (*(volatile unsigned long *)0xFFFFFE14)
#define RTC_CALALR_OFFSET 0x14
#define RTC_CALALR_MONTH_MASK 0x1F0000
#define RTC_CALALR_MONTH_BIT 16
#define RTC_CALALR_MTHEN_MASK 0x800000
#define RTC_CALALR_MTHEN 0x800000
#define RTC_CALALR_MTHEN_BIT 23
#define RTC_CALALR_DATE_MASK 0x3F000000
#define RTC_CALALR_DATE_BIT 24
#define RTC_CALALR_DATEEN_MASK 0x80000000
#define RTC_CALALR_DATEEN 0x80000000
#define RTC_CALALR_DATEEN_BIT 31

#define RTC_SR (*(volatile unsigned long *)0xFFFFFE18)
#define RTC_SR_OFFSET 0x18
#define RTC_SR_ACKUPD_MASK 0x1
#define RTC_SR_ACKUPD 0x1
#define RTC_SR_ACKUPD_BIT 0
#define RTC_SR_ALARM_MASK 0x2
#define RTC_SR_ALARM 0x2
#define RTC_SR_ALARM_BIT 1
#define RTC_SR_SEC_MASK 0x4
#define RTC_SR_SEC 0x4
#define RTC_SR_SEC_BIT 2
#define RTC_SR_TIMEV_MASK 0x8
#define RTC_SR_TIMEV 0x8
#define RTC_SR_TIMEV_BIT 3
#define RTC_SR_CALEV_MASK 0x10
#define RTC_SR_CALEV 0x10
#define RTC_SR_CALEV_BIT 4

#define RTC_SCCR (*(volatile unsigned long *)0xFFFFFE1C)
#define RTC_SCCR_OFFSET 0x1C
#define RTC_SCCR_ACKCLR_MASK 0x1
#define RTC_SCCR_ACKCLR 0x1
#define RTC_SCCR_ACKCLR_BIT 0
#define RTC_SCCR_ALRCLR_MASK 0x2
#define RTC_SCCR_ALRCLR 0x2
#define RTC_SCCR_ALRCLR_BIT 1
#define RTC_SCCR_SECCLR_MASK 0x4
#define RTC_SCCR_SECCLR 0x4
#define RTC_SCCR_SECCLR_BIT 2
#define RTC_SCCR_TIMCLR_MASK 0x8
#define RTC_SCCR_TIMCLR 0x8
#define RTC_SCCR_TIMCLR_BIT 3
#define RTC_SCCR_CALCLR_MASK 0x10
#define RTC_SCCR_CALCLR 0x10
#define RTC_SCCR_CALCLR_BIT 4

#define RTC_IER (*(volatile unsigned long *)0xFFFFFE20)
#define RTC_IER_OFFSET 0x20
#define RTC_IER_ACKEN_MASK 0x1
#define RTC_IER_ACKEN 0x1
#define RTC_IER_ACKEN_BIT 0
#define RTC_IER_ALREN_MASK 0x2
#define RTC_IER_ALREN 0x2
#define RTC_IER_ALREN_BIT 1
#define RTC_IER_SECEN_MASK 0x4
#define RTC_IER_SECEN 0x4
#define RTC_IER_SECEN_BIT 2
#define RTC_IER_TIMEN_MASK 0x8
#define RTC_IER_TIMEN 0x8
#define RTC_IER_TIMEN_BIT 3
#define RTC_IER_CALEN_MASK 0x10
#define RTC_IER_CALEN 0x10
#define RTC_IER_CALEN_BIT 4

#define RTC_IDR (*(volatile unsigned long *)0xFFFFFE24)
#define RTC_IDR_OFFSET 0x24
#define RTC_IDR_ACKDIS_MASK 0x1
#define RTC_IDR_ACKDIS 0x1
#define RTC_IDR_ACKDIS_BIT 0
#define RTC_IDR_ALRDIS_MASK 0x2
#define RTC_IDR_ALRDIS 0x2
#define RTC_IDR_ALRDIS_BIT 1
#define RTC_IDR_SECDIS_MASK 0x4
#define RTC_IDR_SECDIS 0x4
#define RTC_IDR_SECDIS_BIT 2
#define RTC_IDR_TIMDIS_MASK 0x8
#define RTC_IDR_TIMDIS 0x8
#define RTC_IDR_TIMDIS_BIT 3
#define RTC_IDR_CALDIS_MASK 0x10
#define RTC_IDR_CALDIS 0x10
#define RTC_IDR_CALDIS_BIT 4

#define RTC_IMR (*(volatile unsigned long *)0xFFFFFE28)
#define RTC_IMR_OFFSET 0x28
#define RTC_IMR_ACK_MASK 0x1
#define RTC_IMR_ACK 0x1
#define RTC_IMR_ACK_BIT 0
#define RTC_IMR_ALR_MASK 0x2
#define RTC_IMR_ALR 0x2
#define RTC_IMR_ALR_BIT 1
#define RTC_IMR_SEC_MASK 0x4
#define RTC_IMR_SEC 0x4
#define RTC_IMR_SEC_BIT 2
#define RTC_IMR_TIM_MASK 0x8
#define RTC_IMR_TIM 0x8
#define RTC_IMR_TIM_BIT 3
#define RTC_IMR_CAL_MASK 0x10
#define RTC_IMR_CAL 0x10
#define RTC_IMR_CAL_BIT 4

#define RTC_VER (*(volatile unsigned long *)0xFFFFFE2C)
#define RTC_VER_OFFSET 0x2C
#define RTC_VER_NVTIM_MASK 0x1
#define RTC_VER_NVTIM 0x1
#define RTC_VER_NVTIM_BIT 0
#define RTC_VER_NVCAL_MASK 0x2
#define RTC_VER_NVCAL 0x2
#define RTC_VER_NVCAL_BIT 1
#define RTC_VER_NVTIMALR_MASK 0x4
#define RTC_VER_NVTIMALR 0x4
#define RTC_VER_NVTIMALR_BIT 2
#define RTC_VER_NVCALAR_MASK 0x8
#define RTC_VER_NVCALAR 0x8
#define RTC_VER_NVCALAR_BIT 3

#define MC_BASE 0xFFFFFF00

#define MC_RCR (*(volatile unsigned long *)0xFFFFFF00)
#define MC_RCR_OFFSET 0x0
#define MC_RCR_RCB_MASK 0x1
#define MC_RCR_RCB 0x1
#define MC_RCR_RCB_BIT 0

#define MC_ASR (*(volatile unsigned long *)0xFFFFFF04)
#define MC_ASR_OFFSET 0x4
#define MC_ASR_UNDADD_MASK 0x1
#define MC_ASR_UNDADD 0x1
#define MC_ASR_UNDADD_BIT 0
#define MC_ASR_MISADD_MASK 0x2
#define MC_ASR_MISADD 0x2
#define MC_ASR_MISADD_BIT 1
#define MC_ASR_ABTSZ_MASK 0x300
#define MC_ASR_ABTSZ_BIT 8
#define MC_ASR_ABTTYP_MASK 0xC00
#define MC_ASR_ABTTYP_BIT 10
#define MC_ASR_MST0_MASK 0x10000
#define MC_ASR_MST0 0x10000
#define MC_ASR_MST0_BIT 16
#define MC_ASR_MST1_MASK 0x20000
#define MC_ASR_MST1 0x20000
#define MC_ASR_MST1_BIT 17
#define MC_ASR_MST2_MASK 0x40000
#define MC_ASR_MST2 0x40000
#define MC_ASR_MST2_BIT 18
#define MC_ASR_MST3_MASK 0x80000
#define MC_ASR_MST3 0x80000
#define MC_ASR_MST3_BIT 19
#define MC_ASR_SVMST0_MASK 0x100000
#define MC_ASR_SVMST0 0x100000
#define MC_ASR_SVMST0_BIT 20
#define MC_ASR_SVMST1_MASK 0x200000
#define MC_ASR_SVMST1 0x200000
#define MC_ASR_SVMST1_BIT 21
#define MC_ASR_SVMST2_MASK 0x400000
#define MC_ASR_SVMST2 0x400000
#define MC_ASR_SVMST2_BIT 22
#define MC_ASR_SVMST3_MASK 0x800000
#define MC_ASR_SVMST3 0x800000
#define MC_ASR_SVMST3_BIT 23

#define MC_AASR (*(volatile unsigned long *)0xFFFFFF08)
#define MC_AASR_OFFSET 0x8
#define MC_AASR_ABTADD_MASK 0x0
#define MC_AASR_ABTADD_BIT 0

#define MC_MPR (*(volatile unsigned long *)0xFFFFFF0C)
#define MC_MPR_OFFSET 0xC
#define MC_MPR_MSTP0_MASK 0x7
#define MC_MPR_MSTP0_BIT 0
#define MC_MPR_MSTP1_MASK 0x70
#define MC_MPR_MSTP1_BIT 4
#define MC_MPR_MSTP2_MASK 0x700
#define MC_MPR_MSTP2_BIT 8
#define MC_MPR_MSTP3_MASK 0x7000
#define MC_MPR_MSTP3_BIT 12

#define EBI_BASE 0xFFFFFF60

#define EBI_CSA (*(volatile unsigned long *)0xFFFFFF60)
#define EBI_CSA_OFFSET 0x0
#define EBI_CSA_CS0A_MASK 0x1
#define EBI_CSA_CS0A 0x1
#define EBI_CSA_CS0A_BIT 0
#define EBI_CSA_CS1A_MASK 0x2
#define EBI_CSA_CS1A 0x2
#define EBI_CSA_CS1A_BIT 1
#define EBI_CSA_CS3A_MASK 0x8
#define EBI_CSA_CS3A 0x8
#define EBI_CSA_CS3A_BIT 3
#define EBI_CSA_CS4A_MASK 0x10
#define EBI_CSA_CS4A 0x10
#define EBI_CSA_CS4A_BIT 4

#define EBI_CFGR (*(volatile unsigned long *)0xFFFFFF64)
#define EBI_CFGR_OFFSET 0x4
#define EBI_CFGR_DBPUC_MASK 0x1
#define EBI_CFGR_DBPUC 0x1
#define EBI_CFGR_DBPUC_BIT 0

#define SMC_BASE 0xFFFFFF70

#define SMC_CSR0 (*(volatile unsigned long *)0xFFFFFF70)
#define SMC_CSR0_OFFSET 0x0
#define SMC_CSR0_NWS_MASK 0x3F
#define SMC_CSR0_NWS_BIT 0
#define SMC_CSR0_WSEN_MASK 0x80
#define SMC_CSR0_WSEN 0x80
#define SMC_CSR0_WSEN_BIT 7
#define SMC_CSR0_TDF_MASK 0xF00
#define SMC_CSR0_TDF_BIT 8
#define SMC_CSR0_BAT_MASK 0x1000
#define SMC_CSR0_BAT 0x1000
#define SMC_CSR0_BAT_BIT 12
#define SMC_CSR0_DBW_MASK 0x6000
#define SMC_CSR0_DBW_BIT 13
#define SMC_CSR0_DRP_MASK 0x8000
#define SMC_CSR0_DRP 0x8000
#define SMC_CSR0_DRP_BIT 15
#define SMC_CSR0_ACSS_MASK 0x30000
#define SMC_CSR0_ACSS_BIT 16
#define SMC_CSR0_RWSETUP_MASK 0x7000000
#define SMC_CSR0_RWSETUP_BIT 24
#define SMC_CSR0_RWHOLD_MASK 0x70000000
#define SMC_CSR0_RWHOLD_BIT 28

#define SMC_CSR1 (*(volatile unsigned long *)0xFFFFFF74)
#define SMC_CSR1_OFFSET 0x4
#define SMC_CSR1_NWS_MASK 0x3F
#define SMC_CSR1_NWS_BIT 0
#define SMC_CSR1_WSEN_MASK 0x80
#define SMC_CSR1_WSEN 0x80
#define SMC_CSR1_WSEN_BIT 7
#define SMC_CSR1_TDF_MASK 0xF00
#define SMC_CSR1_TDF_BIT 8
#define SMC_CSR1_BAT_MASK 0x1000
#define SMC_CSR1_BAT 0x1000
#define SMC_CSR1_BAT_BIT 12
#define SMC_CSR1_DBW_MASK 0x6000
#define SMC_CSR1_DBW_BIT 13
#define SMC_CSR1_DRP_MASK 0x8000
#define SMC_CSR1_DRP 0x8000
#define SMC_CSR1_DRP_BIT 15
#define SMC_CSR1_ACSS_MASK 0x30000
#define SMC_CSR1_ACSS_BIT 16
#define SMC_CSR1_RWSETUP_MASK 0x7000000
#define SMC_CSR1_RWSETUP_BIT 24
#define SMC_CSR1_RWHOLD_MASK 0x70000000
#define SMC_CSR1_RWHOLD_BIT 28

#define SMC_CSR2 (*(volatile unsigned long *)0xFFFFFF78)
#define SMC_CSR2_OFFSET 0x8
#define SMC_CSR2_NWS_MASK 0x3F
#define SMC_CSR2_NWS_BIT 0
#define SMC_CSR2_WSEN_MASK 0x80
#define SMC_CSR2_WSEN 0x80
#define SMC_CSR2_WSEN_BIT 7
#define SMC_CSR2_TDF_MASK 0xF00
#define SMC_CSR2_TDF_BIT 8
#define SMC_CSR2_BAT_MASK 0x1000
#define SMC_CSR2_BAT 0x1000
#define SMC_CSR2_BAT_BIT 12
#define SMC_CSR2_DBW_MASK 0x6000
#define SMC_CSR2_DBW_BIT 13
#define SMC_CSR2_DRP_MASK 0x8000
#define SMC_CSR2_DRP 0x8000
#define SMC_CSR2_DRP_BIT 15
#define SMC_CSR2_ACSS_MASK 0x30000
#define SMC_CSR2_ACSS_BIT 16
#define SMC_CSR2_RWSETUP_MASK 0x7000000
#define SMC_CSR2_RWSETUP_BIT 24
#define SMC_CSR2_RWHOLD_MASK 0x70000000
#define SMC_CSR2_RWHOLD_BIT 28

#define SMC_CSR3 (*(volatile unsigned long *)0xFFFFFF7C)
#define SMC_CSR3_OFFSET 0xC
#define SMC_CSR3_NWS_MASK 0x3F
#define SMC_CSR3_NWS_BIT 0
#define SMC_CSR3_WSEN_MASK 0x80
#define SMC_CSR3_WSEN 0x80
#define SMC_CSR3_WSEN_BIT 7
#define SMC_CSR3_TDF_MASK 0xF00
#define SMC_CSR3_TDF_BIT 8
#define SMC_CSR3_BAT_MASK 0x1000
#define SMC_CSR3_BAT 0x1000
#define SMC_CSR3_BAT_BIT 12
#define SMC_CSR3_DBW_MASK 0x6000
#define SMC_CSR3_DBW_BIT 13
#define SMC_CSR3_DRP_MASK 0x8000
#define SMC_CSR3_DRP 0x8000
#define SMC_CSR3_DRP_BIT 15
#define SMC_CSR3_ACSS_MASK 0x30000
#define SMC_CSR3_ACSS_BIT 16
#define SMC_CSR3_RWSETUP_MASK 0x7000000
#define SMC_CSR3_RWSETUP_BIT 24
#define SMC_CSR3_RWHOLD_MASK 0x70000000
#define SMC_CSR3_RWHOLD_BIT 28

#define SMC_CSR4 (*(volatile unsigned long *)0xFFFFFF80)
#define SMC_CSR4_OFFSET 0x10
#define SMC_CSR4_NWS_MASK 0x3F
#define SMC_CSR4_NWS_BIT 0
#define SMC_CSR4_WSEN_MASK 0x80
#define SMC_CSR4_WSEN 0x80
#define SMC_CSR4_WSEN_BIT 7
#define SMC_CSR4_TDF_MASK 0xF00
#define SMC_CSR4_TDF_BIT 8
#define SMC_CSR4_BAT_MASK 0x1000
#define SMC_CSR4_BAT 0x1000
#define SMC_CSR4_BAT_BIT 12
#define SMC_CSR4_DBW_MASK 0x6000
#define SMC_CSR4_DBW_BIT 13
#define SMC_CSR4_DRP_MASK 0x8000
#define SMC_CSR4_DRP 0x8000
#define SMC_CSR4_DRP_BIT 15
#define SMC_CSR4_ACSS_MASK 0x30000
#define SMC_CSR4_ACSS_BIT 16
#define SMC_CSR4_RWSETUP_MASK 0x7000000
#define SMC_CSR4_RWSETUP_BIT 24
#define SMC_CSR4_RWHOLD_MASK 0x70000000
#define SMC_CSR4_RWHOLD_BIT 28

#define SMC_CSR5 (*(volatile unsigned long *)0xFFFFFF84)
#define SMC_CSR5_OFFSET 0x14
#define SMC_CSR5_NWS_MASK 0x3F
#define SMC_CSR5_NWS_BIT 0
#define SMC_CSR5_WSEN_MASK 0x80
#define SMC_CSR5_WSEN 0x80
#define SMC_CSR5_WSEN_BIT 7
#define SMC_CSR5_TDF_MASK 0xF00
#define SMC_CSR5_TDF_BIT 8
#define SMC_CSR5_BAT_MASK 0x1000
#define SMC_CSR5_BAT 0x1000
#define SMC_CSR5_BAT_BIT 12
#define SMC_CSR5_DBW_MASK 0x6000
#define SMC_CSR5_DBW_BIT 13
#define SMC_CSR5_DRP_MASK 0x8000
#define SMC_CSR5_DRP 0x8000
#define SMC_CSR5_DRP_BIT 15
#define SMC_CSR5_ACSS_MASK 0x30000
#define SMC_CSR5_ACSS_BIT 16
#define SMC_CSR5_RWSETUP_MASK 0x7000000
#define SMC_CSR5_RWSETUP_BIT 24
#define SMC_CSR5_RWHOLD_MASK 0x70000000
#define SMC_CSR5_RWHOLD_BIT 28

#define SMC_CSR6 (*(volatile unsigned long *)0xFFFFFF88)
#define SMC_CSR6_OFFSET 0x18
#define SMC_CSR6_NWS_MASK 0x3F
#define SMC_CSR6_NWS_BIT 0
#define SMC_CSR6_WSEN_MASK 0x80
#define SMC_CSR6_WSEN 0x80
#define SMC_CSR6_WSEN_BIT 7
#define SMC_CSR6_TDF_MASK 0xF00
#define SMC_CSR6_TDF_BIT 8
#define SMC_CSR6_BAT_MASK 0x1000
#define SMC_CSR6_BAT 0x1000
#define SMC_CSR6_BAT_BIT 12
#define SMC_CSR6_DBW_MASK 0x6000
#define SMC_CSR6_DBW_BIT 13
#define SMC_CSR6_DRP_MASK 0x8000
#define SMC_CSR6_DRP 0x8000
#define SMC_CSR6_DRP_BIT 15
#define SMC_CSR6_ACSS_MASK 0x30000
#define SMC_CSR6_ACSS_BIT 16
#define SMC_CSR6_RWSETUP_MASK 0x7000000
#define SMC_CSR6_RWSETUP_BIT 24
#define SMC_CSR6_RWHOLD_MASK 0x70000000
#define SMC_CSR6_RWHOLD_BIT 28

#define SMC_CSR7 (*(volatile unsigned long *)0xFFFFFF8C)
#define SMC_CSR7_OFFSET 0x1C
#define SMC_CSR7_NWS_MASK 0x3F
#define SMC_CSR7_NWS_BIT 0
#define SMC_CSR7_WSEN_MASK 0x80
#define SMC_CSR7_WSEN 0x80
#define SMC_CSR7_WSEN_BIT 7
#define SMC_CSR7_TDF_MASK 0xF00
#define SMC_CSR7_TDF_BIT 8
#define SMC_CSR7_BAT_MASK 0x1000
#define SMC_CSR7_BAT 0x1000
#define SMC_CSR7_BAT_BIT 12
#define SMC_CSR7_DBW_MASK 0x6000
#define SMC_CSR7_DBW_BIT 13
#define SMC_CSR7_DRP_MASK 0x8000
#define SMC_CSR7_DRP 0x8000
#define SMC_CSR7_DRP_BIT 15
#define SMC_CSR7_ACSS_MASK 0x30000
#define SMC_CSR7_ACSS_BIT 16
#define SMC_CSR7_RWSETUP_MASK 0x7000000
#define SMC_CSR7_RWSETUP_BIT 24
#define SMC_CSR7_RWHOLD_MASK 0x70000000
#define SMC_CSR7_RWHOLD_BIT 28

#define SDRAMC_BASE 0xFFFFFF90

#define SDRAMC_MR (*(volatile unsigned long *)0xFFFFFF90)
#define SDRAMC_MR_OFFSET 0x0
#define SDRAMC_MR_MODE_MASK 0xF
#define SDRAMC_MR_MODE_BIT 0
#define SDRAMC_MR_DBW_MASK 0x10
#define SDRAMC_MR_DBW 0x10
#define SDRAMC_MR_DBW_BIT 4

#define SDRAMC_TR (*(volatile unsigned long *)0xFFFFFF94)
#define SDRAMC_TR_OFFSET 0x4
#define SDRAMC_TR_COUNT_MASK 0xFFF
#define SDRAMC_TR_COUNT_BIT 0

#define SDRAMC_CR (*(volatile unsigned long *)0xFFFFFF98)
#define SDRAMC_CR_OFFSET 0x8
#define SDRAMC_CR_NC_MASK 0x3
#define SDRAMC_CR_NC_BIT 0
#define SDRAMC_CR_NR_MASK 0xC
#define SDRAMC_CR_NR_BIT 2
#define SDRAMC_CR_NB_MASK 0x10
#define SDRAMC_CR_NB 0x10
#define SDRAMC_CR_NB_BIT 4
#define SDRAMC_CR_CAS_MASK 0x60
#define SDRAMC_CR_CAS_BIT 5
#define SDRAMC_CR_TWR_MASK 0x380
#define SDRAMC_CR_TWR_BIT 7
#define SDRAMC_CR_TRC_MASK 0x7800
#define SDRAMC_CR_TRC_BIT 11
#define SDRAMC_CR_TRP_MASK 0x78000
#define SDRAMC_CR_TRP_BIT 15
#define SDRAMC_CR_TRCD_MASK 0x780000
#define SDRAMC_CR_TRCD_BIT 19
#define SDRAMC_CR_TRAS_MASK 0x7800000
#define SDRAMC_CR_TRAS_BIT 23
#define SDRAMC_CR_TXSR_MASK 0x78000000
#define SDRAMC_CR_TXSR_BIT 27

#define SDRAMC_SRR (*(volatile unsigned long *)0xFFFFFF9C)
#define SDRAMC_SRR_OFFSET 0xC
#define SDRAMC_SRR_SRCB_MASK 0x1
#define SDRAMC_SRR_SRCB 0x1
#define SDRAMC_SRR_SRCB_BIT 0

#define SDRAMC_LPR (*(volatile unsigned long *)0xFFFFFFA0)
#define SDRAMC_LPR_OFFSET 0x10
#define SDRAMC_LPR_LPCB_MASK 0x1
#define SDRAMC_LPR_LPCB 0x1
#define SDRAMC_LPR_LPCB_BIT 0

#define SDRAMC_IER (*(volatile unsigned long *)0xFFFFFFA4)
#define SDRAMC_IER_OFFSET 0x14
#define SDRAMC_IER_RES_MASK 0x1
#define SDRAMC_IER_RES 0x1
#define SDRAMC_IER_RES_BIT 0

#define SDRAMC_IDR (*(volatile unsigned long *)0xFFFFFFA8)
#define SDRAMC_IDR_OFFSET 0x18
#define SDRAMC_IDR_RES_MASK 0x1
#define SDRAMC_IDR_RES 0x1
#define SDRAMC_IDR_RES_BIT 0

#define SDRAMC_IMR (*(volatile unsigned long *)0xFFFFFFAC)
#define SDRAMC_IMR_OFFSET 0x1C
#define SDRAMC_IMR_RES_MASK 0x1
#define SDRAMC_IMR_RES 0x1
#define SDRAMC_IMR_RES_BIT 0

#define SDRAMC_ISR (*(volatile unsigned long *)0xFFFFFFB0)
#define SDRAMC_ISR_OFFSET 0x20
#define SDRAMC_ISR_RES_MASK 0x1
#define SDRAMC_ISR_RES 0x1
#define SDRAMC_ISR_RES_BIT 0

#define BFC_BASE 0xFFFFFFC0

#define BFC_MR (*(volatile unsigned long *)0xFFFFFFC0)
#define BFC_MR_OFFSET 0x0
#define BFC_MR_BFCOM_MASK 0x3
#define BFC_MR_BFCOM_BIT 0
#define BFC_MR_BFCC_MASK 0xC
#define BFC_MR_BFCC_BIT 2
#define BFC_MR_AVL_MASK 0xF0
#define BFC_MR_AVL_BIT 4
#define BFC_MR_PAGES_MASK 0x700
#define BFC_MR_PAGES_BIT 8
#define BFC_MR_OEL_MASK 0x3000
#define BFC_MR_OEL_BIT 12
#define BFC_MR_BAAEN_MASK 0x10000
#define BFC_MR_BAAEN 0x10000
#define BFC_MR_BAAEN_BIT 16
#define BFC_MR_BFOEH_MASK 0x20000
#define BFC_MR_BFOEH 0x20000
#define BFC_MR_BFOEH_BIT 17
#define BFC_MR_MUXEN_MASK 0x40000
#define BFC_MR_MUXEN 0x40000
#define BFC_MR_MUXEN_BIT 18
#define BFC_MR_RDYEN_MASK 0x80000
#define BFC_MR_RDYEN 0x80000
#define BFC_MR_RDYEN_BIT 19


#endif
