// ADuC7020 register and bit definitions.
//
// Copyright (c) 2006 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef ADuC7020_h
#define ADuC7020_h

#define IRQSTA (*(volatile unsigned long *)0xFFFF0000)
#define IRQSTA_ALL_MASK 0x1
#define IRQSTA_ALL 0x1
#define IRQSTA_ALL_BIT 0
#define IRQSTA_SWI_MASK 0x2
#define IRQSTA_SWI 0x2
#define IRQSTA_SWI_BIT 1
#define IRQSTA_Timer_0_MASK 0x4
#define IRQSTA_Timer_0 0x4
#define IRQSTA_Timer_0_BIT 2
#define IRQSTA_Timer_1_MASK 0x8
#define IRQSTA_Timer_1 0x8
#define IRQSTA_Timer_1_BIT 3
#define IRQSTA_Wake_Up_Timer_MASK 0x10
#define IRQSTA_Wake_Up_Timer 0x10
#define IRQSTA_Wake_Up_Timer_BIT 4
#define IRQSTA_Watchdog_Timer_MASK 0x20
#define IRQSTA_Watchdog_Timer 0x20
#define IRQSTA_Watchdog_Timer_BIT 5
#define IRQSTA_Flash_control_MASK 0x40
#define IRQSTA_Flash_control 0x40
#define IRQSTA_Flash_control_BIT 6
#define IRQSTA_ADC_channel_MASK 0x80
#define IRQSTA_ADC_channel 0x80
#define IRQSTA_ADC_channel_BIT 7
#define IRQSTA_PLL_lock_MASK 0x100
#define IRQSTA_PLL_lock 0x100
#define IRQSTA_PLL_lock_BIT 8
#define IRQSTA_I2C0_Slave_MASK 0x200
#define IRQSTA_I2C0_Slave 0x200
#define IRQSTA_I2C0_Slave_BIT 9
#define IRQSTA_I2C0_Master_MASK 0x400
#define IRQSTA_I2C0_Master 0x400
#define IRQSTA_I2C0_Master_BIT 10
#define IRQSTA_I2C1_Master_MASK 0x800
#define IRQSTA_I2C1_Master 0x800
#define IRQSTA_I2C1_Master_BIT 11
#define IRQSTA_SPI_Slave_MASK 0x1000
#define IRQSTA_SPI_Slave 0x1000
#define IRQSTA_SPI_Slave_BIT 12
#define IRQSTA_SPI_Master_MASK 0x2000
#define IRQSTA_SPI_Master 0x2000
#define IRQSTA_SPI_Master_BIT 13
#define IRQSTA_UART_MASK 0x4000
#define IRQSTA_UART 0x4000
#define IRQSTA_UART_BIT 14
#define IRQSTA_External_IRQ0_MASK 0x8000
#define IRQSTA_External_IRQ0 0x8000
#define IRQSTA_External_IRQ0_BIT 15
#define IRQSTA_Comparator_MASK 0x10000
#define IRQSTA_Comparator 0x10000
#define IRQSTA_Comparator_BIT 16
#define IRQSTA_PSM_MASK 0x20000
#define IRQSTA_PSM 0x20000
#define IRQSTA_PSM_BIT 17
#define IRQSTA_External_IRQ1_MASK 0x40000
#define IRQSTA_External_IRQ1 0x40000
#define IRQSTA_External_IRQ1_BIT 18
#define IRQSTA_PLA_IRQ0_MASK 0x80000
#define IRQSTA_PLA_IRQ0 0x80000
#define IRQSTA_PLA_IRQ0_BIT 19
#define IRQSTA_PLA_IRQ1_MASK 0x100000
#define IRQSTA_PLA_IRQ1 0x100000
#define IRQSTA_PLA_IRQ1_BIT 20
#define IRQSTA_External_IRQ2_MASK 0x200000
#define IRQSTA_External_IRQ2 0x200000
#define IRQSTA_External_IRQ2_BIT 21
#define IRQSTA_External_IRQ3_MASK 0x400000
#define IRQSTA_External_IRQ3 0x400000
#define IRQSTA_External_IRQ3_BIT 22
#define IRQSTA_PWM_trip_MASK 0x800000
#define IRQSTA_PWM_trip 0x800000
#define IRQSTA_PWM_trip_BIT 23
#define IRQSTA_PWM_sync_MASK 0x1000000
#define IRQSTA_PWM_sync 0x1000000
#define IRQSTA_PWM_sync_BIT 24

#define IRQSIG (*(volatile unsigned long *)0xFFFF0004)
#define IRQSIG_ALL_MASK 0x1
#define IRQSIG_ALL 0x1
#define IRQSIG_ALL_BIT 0
#define IRQSIG_SWI_MASK 0x2
#define IRQSIG_SWI 0x2
#define IRQSIG_SWI_BIT 1
#define IRQSIG_Timer_0_MASK 0x4
#define IRQSIG_Timer_0 0x4
#define IRQSIG_Timer_0_BIT 2
#define IRQSIG_Timer_1_MASK 0x8
#define IRQSIG_Timer_1 0x8
#define IRQSIG_Timer_1_BIT 3
#define IRQSIG_Wake_Up_Timer_MASK 0x10
#define IRQSIG_Wake_Up_Timer 0x10
#define IRQSIG_Wake_Up_Timer_BIT 4
#define IRQSIG_Watchdog_Timer_MASK 0x20
#define IRQSIG_Watchdog_Timer 0x20
#define IRQSIG_Watchdog_Timer_BIT 5
#define IRQSIG_Flash_control_MASK 0x40
#define IRQSIG_Flash_control 0x40
#define IRQSIG_Flash_control_BIT 6
#define IRQSIG_ADC_channel_MASK 0x80
#define IRQSIG_ADC_channel 0x80
#define IRQSIG_ADC_channel_BIT 7
#define IRQSIG_PLL_lock_MASK 0x100
#define IRQSIG_PLL_lock 0x100
#define IRQSIG_PLL_lock_BIT 8
#define IRQSIG_I2C0_Slave_MASK 0x200
#define IRQSIG_I2C0_Slave 0x200
#define IRQSIG_I2C0_Slave_BIT 9
#define IRQSIG_I2C0_Master_MASK 0x400
#define IRQSIG_I2C0_Master 0x400
#define IRQSIG_I2C0_Master_BIT 10
#define IRQSIG_I2C1_Master_MASK 0x800
#define IRQSIG_I2C1_Master 0x800
#define IRQSIG_I2C1_Master_BIT 11
#define IRQSIG_SPI_Slave_MASK 0x1000
#define IRQSIG_SPI_Slave 0x1000
#define IRQSIG_SPI_Slave_BIT 12
#define IRQSIG_SPI_Master_MASK 0x2000
#define IRQSIG_SPI_Master 0x2000
#define IRQSIG_SPI_Master_BIT 13
#define IRQSIG_UART_MASK 0x4000
#define IRQSIG_UART 0x4000
#define IRQSIG_UART_BIT 14
#define IRQSIG_External_IRQ0_MASK 0x8000
#define IRQSIG_External_IRQ0 0x8000
#define IRQSIG_External_IRQ0_BIT 15
#define IRQSIG_Comparator_MASK 0x10000
#define IRQSIG_Comparator 0x10000
#define IRQSIG_Comparator_BIT 16
#define IRQSIG_PSM_MASK 0x20000
#define IRQSIG_PSM 0x20000
#define IRQSIG_PSM_BIT 17
#define IRQSIG_External_IRQ1_MASK 0x40000
#define IRQSIG_External_IRQ1 0x40000
#define IRQSIG_External_IRQ1_BIT 18
#define IRQSIG_PLA_IRQ0_MASK 0x80000
#define IRQSIG_PLA_IRQ0 0x80000
#define IRQSIG_PLA_IRQ0_BIT 19
#define IRQSIG_PLA_IRQ1_MASK 0x100000
#define IRQSIG_PLA_IRQ1 0x100000
#define IRQSIG_PLA_IRQ1_BIT 20
#define IRQSIG_External_IRQ2_MASK 0x200000
#define IRQSIG_External_IRQ2 0x200000
#define IRQSIG_External_IRQ2_BIT 21
#define IRQSIG_External_IRQ3_MASK 0x400000
#define IRQSIG_External_IRQ3 0x400000
#define IRQSIG_External_IRQ3_BIT 22
#define IRQSIG_PWM_trip_MASK 0x800000
#define IRQSIG_PWM_trip 0x800000
#define IRQSIG_PWM_trip_BIT 23
#define IRQSIG_PWM_sync_MASK 0x1000000
#define IRQSIG_PWM_sync 0x1000000
#define IRQSIG_PWM_sync_BIT 24

#define IRQEN (*(volatile unsigned long *)0xFFFF0008)
#define IRQEN_ALL_MASK 0x1
#define IRQEN_ALL 0x1
#define IRQEN_ALL_BIT 0
#define IRQEN_Timer_0_MASK 0x4
#define IRQEN_Timer_0 0x4
#define IRQEN_Timer_0_BIT 2
#define IRQEN_Timer_1_MASK 0x8
#define IRQEN_Timer_1 0x8
#define IRQEN_Timer_1_BIT 3
#define IRQEN_Wake_Up_Timer_MASK 0x10
#define IRQEN_Wake_Up_Timer 0x10
#define IRQEN_Wake_Up_Timer_BIT 4
#define IRQEN_Watchdog_Timer_MASK 0x20
#define IRQEN_Watchdog_Timer 0x20
#define IRQEN_Watchdog_Timer_BIT 5
#define IRQEN_Flash_control_MASK 0x40
#define IRQEN_Flash_control 0x40
#define IRQEN_Flash_control_BIT 6
#define IRQEN_ADC_channel_MASK 0x80
#define IRQEN_ADC_channel 0x80
#define IRQEN_ADC_channel_BIT 7
#define IRQEN_PLL_lock_MASK 0x100
#define IRQEN_PLL_lock 0x100
#define IRQEN_PLL_lock_BIT 8
#define IRQEN_I2C0_Slave_MASK 0x200
#define IRQEN_I2C0_Slave 0x200
#define IRQEN_I2C0_Slave_BIT 9
#define IRQEN_I2C0_Master_MASK 0x400
#define IRQEN_I2C0_Master 0x400
#define IRQEN_I2C0_Master_BIT 10
#define IRQEN_I2C1_Master_MASK 0x800
#define IRQEN_I2C1_Master 0x800
#define IRQEN_I2C1_Master_BIT 11
#define IRQEN_SPI_Slave_MASK 0x1000
#define IRQEN_SPI_Slave 0x1000
#define IRQEN_SPI_Slave_BIT 12
#define IRQEN_SPI_Master_MASK 0x2000
#define IRQEN_SPI_Master 0x2000
#define IRQEN_SPI_Master_BIT 13
#define IRQEN_UART_MASK 0x4000
#define IRQEN_UART 0x4000
#define IRQEN_UART_BIT 14
#define IRQEN_External_IRQ0_MASK 0x8000
#define IRQEN_External_IRQ0 0x8000
#define IRQEN_External_IRQ0_BIT 15
#define IRQEN_Comparator_MASK 0x10000
#define IRQEN_Comparator 0x10000
#define IRQEN_Comparator_BIT 16
#define IRQEN_PSM_MASK 0x20000
#define IRQEN_PSM 0x20000
#define IRQEN_PSM_BIT 17
#define IRQEN_External_IRQ1_MASK 0x40000
#define IRQEN_External_IRQ1 0x40000
#define IRQEN_External_IRQ1_BIT 18
#define IRQEN_PLA_IRQ0_MASK 0x80000
#define IRQEN_PLA_IRQ0 0x80000
#define IRQEN_PLA_IRQ0_BIT 19
#define IRQEN_PLA_IRQ1_MASK 0x100000
#define IRQEN_PLA_IRQ1 0x100000
#define IRQEN_PLA_IRQ1_BIT 20
#define IRQEN_External_IRQ2_MASK 0x200000
#define IRQEN_External_IRQ2 0x200000
#define IRQEN_External_IRQ2_BIT 21
#define IRQEN_External_IRQ3_MASK 0x400000
#define IRQEN_External_IRQ3 0x400000
#define IRQEN_External_IRQ3_BIT 22
#define IRQEN_PWM_trip_MASK 0x800000
#define IRQEN_PWM_trip 0x800000
#define IRQEN_PWM_trip_BIT 23
#define IRQEN_PWM_sync_MASK 0x1000000
#define IRQEN_PWM_sync 0x1000000
#define IRQEN_PWM_sync_BIT 24

#define IRQCLR (*(volatile unsigned long *)0xFFFF000C)
#define IRQCLR_ALL_MASK 0x1
#define IRQCLR_ALL 0x1
#define IRQCLR_ALL_BIT 0
#define IRQCLR_Timer_0_MASK 0x4
#define IRQCLR_Timer_0 0x4
#define IRQCLR_Timer_0_BIT 2
#define IRQCLR_Timer_1_MASK 0x8
#define IRQCLR_Timer_1 0x8
#define IRQCLR_Timer_1_BIT 3
#define IRQCLR_Wake_Up_Timer_MASK 0x10
#define IRQCLR_Wake_Up_Timer 0x10
#define IRQCLR_Wake_Up_Timer_BIT 4
#define IRQCLR_Watchdog_Timer_MASK 0x20
#define IRQCLR_Watchdog_Timer 0x20
#define IRQCLR_Watchdog_Timer_BIT 5
#define IRQCLR_Flash_control_MASK 0x40
#define IRQCLR_Flash_control 0x40
#define IRQCLR_Flash_control_BIT 6
#define IRQCLR_ADC_channel_MASK 0x80
#define IRQCLR_ADC_channel 0x80
#define IRQCLR_ADC_channel_BIT 7
#define IRQCLR_PLL_lock_MASK 0x100
#define IRQCLR_PLL_lock 0x100
#define IRQCLR_PLL_lock_BIT 8
#define IRQCLR_I2C0_Slave_MASK 0x200
#define IRQCLR_I2C0_Slave 0x200
#define IRQCLR_I2C0_Slave_BIT 9
#define IRQCLR_I2C0_Master_MASK 0x400
#define IRQCLR_I2C0_Master 0x400
#define IRQCLR_I2C0_Master_BIT 10
#define IRQCLR_I2C1_Master_MASK 0x800
#define IRQCLR_I2C1_Master 0x800
#define IRQCLR_I2C1_Master_BIT 11
#define IRQCLR_SPI_Slave_MASK 0x1000
#define IRQCLR_SPI_Slave 0x1000
#define IRQCLR_SPI_Slave_BIT 12
#define IRQCLR_SPI_Master_MASK 0x2000
#define IRQCLR_SPI_Master 0x2000
#define IRQCLR_SPI_Master_BIT 13
#define IRQCLR_UART_MASK 0x4000
#define IRQCLR_UART 0x4000
#define IRQCLR_UART_BIT 14
#define IRQCLR_External_IRQ0_MASK 0x8000
#define IRQCLR_External_IRQ0 0x8000
#define IRQCLR_External_IRQ0_BIT 15
#define IRQCLR_Comparator_MASK 0x10000
#define IRQCLR_Comparator 0x10000
#define IRQCLR_Comparator_BIT 16
#define IRQCLR_PSM_MASK 0x20000
#define IRQCLR_PSM 0x20000
#define IRQCLR_PSM_BIT 17
#define IRQCLR_External_IRQ1_MASK 0x40000
#define IRQCLR_External_IRQ1 0x40000
#define IRQCLR_External_IRQ1_BIT 18
#define IRQCLR_PLA_IRQ0_MASK 0x80000
#define IRQCLR_PLA_IRQ0 0x80000
#define IRQCLR_PLA_IRQ0_BIT 19
#define IRQCLR_PLA_IRQ1_MASK 0x100000
#define IRQCLR_PLA_IRQ1 0x100000
#define IRQCLR_PLA_IRQ1_BIT 20
#define IRQCLR_External_IRQ2_MASK 0x200000
#define IRQCLR_External_IRQ2 0x200000
#define IRQCLR_External_IRQ2_BIT 21
#define IRQCLR_External_IRQ3_MASK 0x400000
#define IRQCLR_External_IRQ3 0x400000
#define IRQCLR_External_IRQ3_BIT 22
#define IRQCLR_PWM_trip_MASK 0x800000
#define IRQCLR_PWM_trip 0x800000
#define IRQCLR_PWM_trip_BIT 23
#define IRQCLR_PWM_sync_MASK 0x1000000
#define IRQCLR_PWM_sync 0x1000000
#define IRQCLR_PWM_sync_BIT 24

#define SWICFG (*(volatile unsigned long *)0xFFFF0010)
#define SWICFG_IRQ_MASK 0x2
#define SWICFG_IRQ 0x2
#define SWICFG_IRQ_BIT 1
#define SWICFG_FIQ_MASK 0x4
#define SWICFG_FIQ 0x4
#define SWICFG_FIQ_BIT 2

#define FIQSTA (*(volatile unsigned long *)0xFFFF0100)
#define FIQSTA_ALL_MASK 0x1
#define FIQSTA_ALL 0x1
#define FIQSTA_ALL_BIT 0
#define FIQSTA_SWI_MASK 0x2
#define FIQSTA_SWI 0x2
#define FIQSTA_SWI_BIT 1
#define FIQSTA_Timer_0_MASK 0x4
#define FIQSTA_Timer_0 0x4
#define FIQSTA_Timer_0_BIT 2
#define FIQSTA_Timer_1_MASK 0x8
#define FIQSTA_Timer_1 0x8
#define FIQSTA_Timer_1_BIT 3
#define FIQSTA_Wake_Up_Timer_MASK 0x10
#define FIQSTA_Wake_Up_Timer 0x10
#define FIQSTA_Wake_Up_Timer_BIT 4
#define FIQSTA_Watchdog_Timer_MASK 0x20
#define FIQSTA_Watchdog_Timer 0x20
#define FIQSTA_Watchdog_Timer_BIT 5
#define FIQSTA_Flash_control_MASK 0x40
#define FIQSTA_Flash_control 0x40
#define FIQSTA_Flash_control_BIT 6
#define FIQSTA_ADC_channel_MASK 0x80
#define FIQSTA_ADC_channel 0x80
#define FIQSTA_ADC_channel_BIT 7
#define FIQSTA_PLL_lock_MASK 0x100
#define FIQSTA_PLL_lock 0x100
#define FIQSTA_PLL_lock_BIT 8
#define FIQSTA_I2C0_Slave_MASK 0x200
#define FIQSTA_I2C0_Slave 0x200
#define FIQSTA_I2C0_Slave_BIT 9
#define FIQSTA_I2C0_Master_MASK 0x400
#define FIQSTA_I2C0_Master 0x400
#define FIQSTA_I2C0_Master_BIT 10
#define FIQSTA_I2C1_Master_MASK 0x800
#define FIQSTA_I2C1_Master 0x800
#define FIQSTA_I2C1_Master_BIT 11
#define FIQSTA_SPI_Slave_MASK 0x1000
#define FIQSTA_SPI_Slave 0x1000
#define FIQSTA_SPI_Slave_BIT 12
#define FIQSTA_SPI_Master_MASK 0x2000
#define FIQSTA_SPI_Master 0x2000
#define FIQSTA_SPI_Master_BIT 13
#define FIQSTA_UART_MASK 0x4000
#define FIQSTA_UART 0x4000
#define FIQSTA_UART_BIT 14
#define FIQSTA_External_IRQ0_MASK 0x8000
#define FIQSTA_External_IRQ0 0x8000
#define FIQSTA_External_IRQ0_BIT 15
#define FIQSTA_Comparator_MASK 0x10000
#define FIQSTA_Comparator 0x10000
#define FIQSTA_Comparator_BIT 16
#define FIQSTA_PSM_MASK 0x20000
#define FIQSTA_PSM 0x20000
#define FIQSTA_PSM_BIT 17
#define FIQSTA_External_IRQ1_MASK 0x40000
#define FIQSTA_External_IRQ1 0x40000
#define FIQSTA_External_IRQ1_BIT 18
#define FIQSTA_PLA_IRQ0_MASK 0x80000
#define FIQSTA_PLA_IRQ0 0x80000
#define FIQSTA_PLA_IRQ0_BIT 19
#define FIQSTA_PLA_IRQ1_MASK 0x100000
#define FIQSTA_PLA_IRQ1 0x100000
#define FIQSTA_PLA_IRQ1_BIT 20
#define FIQSTA_External_IRQ2_MASK 0x200000
#define FIQSTA_External_IRQ2 0x200000
#define FIQSTA_External_IRQ2_BIT 21
#define FIQSTA_External_IRQ3_MASK 0x400000
#define FIQSTA_External_IRQ3 0x400000
#define FIQSTA_External_IRQ3_BIT 22
#define FIQSTA_PWM_trip_MASK 0x800000
#define FIQSTA_PWM_trip 0x800000
#define FIQSTA_PWM_trip_BIT 23
#define FIQSTA_PWM_sync_MASK 0x1000000
#define FIQSTA_PWM_sync 0x1000000
#define FIQSTA_PWM_sync_BIT 24

#define FIQSIG (*(volatile unsigned long *)0xFFFF0104)
#define FIQSIG_ALL_MASK 0x1
#define FIQSIG_ALL 0x1
#define FIQSIG_ALL_BIT 0
#define FIQSIG_SWI_MASK 0x2
#define FIQSIG_SWI 0x2
#define FIQSIG_SWI_BIT 1
#define FIQSIG_Timer_0_MASK 0x4
#define FIQSIG_Timer_0 0x4
#define FIQSIG_Timer_0_BIT 2
#define FIQSIG_Timer_1_MASK 0x8
#define FIQSIG_Timer_1 0x8
#define FIQSIG_Timer_1_BIT 3
#define FIQSIG_Wake_Up_Timer_MASK 0x10
#define FIQSIG_Wake_Up_Timer 0x10
#define FIQSIG_Wake_Up_Timer_BIT 4
#define FIQSIG_Watchdog_Timer_MASK 0x20
#define FIQSIG_Watchdog_Timer 0x20
#define FIQSIG_Watchdog_Timer_BIT 5
#define FIQSIG_Flash_control_MASK 0x40
#define FIQSIG_Flash_control 0x40
#define FIQSIG_Flash_control_BIT 6
#define FIQSIG_ADC_channel_MASK 0x80
#define FIQSIG_ADC_channel 0x80
#define FIQSIG_ADC_channel_BIT 7
#define FIQSIG_PLL_lock_MASK 0x100
#define FIQSIG_PLL_lock 0x100
#define FIQSIG_PLL_lock_BIT 8
#define FIQSIG_I2C0_Slave_MASK 0x200
#define FIQSIG_I2C0_Slave 0x200
#define FIQSIG_I2C0_Slave_BIT 9
#define FIQSIG_I2C0_Master_MASK 0x400
#define FIQSIG_I2C0_Master 0x400
#define FIQSIG_I2C0_Master_BIT 10
#define FIQSIG_I2C1_Master_MASK 0x800
#define FIQSIG_I2C1_Master 0x800
#define FIQSIG_I2C1_Master_BIT 11
#define FIQSIG_SPI_Slave_MASK 0x1000
#define FIQSIG_SPI_Slave 0x1000
#define FIQSIG_SPI_Slave_BIT 12
#define FIQSIG_SPI_Master_MASK 0x2000
#define FIQSIG_SPI_Master 0x2000
#define FIQSIG_SPI_Master_BIT 13
#define FIQSIG_UART_MASK 0x4000
#define FIQSIG_UART 0x4000
#define FIQSIG_UART_BIT 14
#define FIQSIG_External_IRQ0_MASK 0x8000
#define FIQSIG_External_IRQ0 0x8000
#define FIQSIG_External_IRQ0_BIT 15
#define FIQSIG_Comparator_MASK 0x10000
#define FIQSIG_Comparator 0x10000
#define FIQSIG_Comparator_BIT 16
#define FIQSIG_PSM_MASK 0x20000
#define FIQSIG_PSM 0x20000
#define FIQSIG_PSM_BIT 17
#define FIQSIG_External_IRQ1_MASK 0x40000
#define FIQSIG_External_IRQ1 0x40000
#define FIQSIG_External_IRQ1_BIT 18
#define FIQSIG_PLA_IRQ0_MASK 0x80000
#define FIQSIG_PLA_IRQ0 0x80000
#define FIQSIG_PLA_IRQ0_BIT 19
#define FIQSIG_PLA_IRQ1_MASK 0x100000
#define FIQSIG_PLA_IRQ1 0x100000
#define FIQSIG_PLA_IRQ1_BIT 20
#define FIQSIG_External_IRQ2_MASK 0x200000
#define FIQSIG_External_IRQ2 0x200000
#define FIQSIG_External_IRQ2_BIT 21
#define FIQSIG_External_IRQ3_MASK 0x400000
#define FIQSIG_External_IRQ3 0x400000
#define FIQSIG_External_IRQ3_BIT 22
#define FIQSIG_PWM_trip_MASK 0x800000
#define FIQSIG_PWM_trip 0x800000
#define FIQSIG_PWM_trip_BIT 23
#define FIQSIG_PWM_sync_MASK 0x1000000
#define FIQSIG_PWM_sync 0x1000000
#define FIQSIG_PWM_sync_BIT 24

#define FIQEN (*(volatile unsigned long *)0xFFFF0108)
#define FIQEN_ALL_MASK 0x1
#define FIQEN_ALL 0x1
#define FIQEN_ALL_BIT 0
#define FIQEN_Timer_0_MASK 0x4
#define FIQEN_Timer_0 0x4
#define FIQEN_Timer_0_BIT 2
#define FIQEN_Timer_1_MASK 0x8
#define FIQEN_Timer_1 0x8
#define FIQEN_Timer_1_BIT 3
#define FIQEN_Wake_Up_Timer_MASK 0x10
#define FIQEN_Wake_Up_Timer 0x10
#define FIQEN_Wake_Up_Timer_BIT 4
#define FIQEN_Watchdog_Timer_MASK 0x20
#define FIQEN_Watchdog_Timer 0x20
#define FIQEN_Watchdog_Timer_BIT 5
#define FIQEN_Flash_control_MASK 0x40
#define FIQEN_Flash_control 0x40
#define FIQEN_Flash_control_BIT 6
#define FIQEN_ADC_channel_MASK 0x80
#define FIQEN_ADC_channel 0x80
#define FIQEN_ADC_channel_BIT 7
#define FIQEN_PLL_lock_MASK 0x100
#define FIQEN_PLL_lock 0x100
#define FIQEN_PLL_lock_BIT 8
#define FIQEN_I2C0_Slave_MASK 0x200
#define FIQEN_I2C0_Slave 0x200
#define FIQEN_I2C0_Slave_BIT 9
#define FIQEN_I2C0_Master_MASK 0x400
#define FIQEN_I2C0_Master 0x400
#define FIQEN_I2C0_Master_BIT 10
#define FIQEN_I2C1_Master_MASK 0x800
#define FIQEN_I2C1_Master 0x800
#define FIQEN_I2C1_Master_BIT 11
#define FIQEN_SPI_Slave_MASK 0x1000
#define FIQEN_SPI_Slave 0x1000
#define FIQEN_SPI_Slave_BIT 12
#define FIQEN_SPI_Master_MASK 0x2000
#define FIQEN_SPI_Master 0x2000
#define FIQEN_SPI_Master_BIT 13
#define FIQEN_UART_MASK 0x4000
#define FIQEN_UART 0x4000
#define FIQEN_UART_BIT 14
#define FIQEN_External_IRQ0_MASK 0x8000
#define FIQEN_External_IRQ0 0x8000
#define FIQEN_External_IRQ0_BIT 15
#define FIQEN_Comparator_MASK 0x10000
#define FIQEN_Comparator 0x10000
#define FIQEN_Comparator_BIT 16
#define FIQEN_PSM_MASK 0x20000
#define FIQEN_PSM 0x20000
#define FIQEN_PSM_BIT 17
#define FIQEN_External_IRQ1_MASK 0x40000
#define FIQEN_External_IRQ1 0x40000
#define FIQEN_External_IRQ1_BIT 18
#define FIQEN_PLA_IRQ0_MASK 0x80000
#define FIQEN_PLA_IRQ0 0x80000
#define FIQEN_PLA_IRQ0_BIT 19
#define FIQEN_PLA_IRQ1_MASK 0x100000
#define FIQEN_PLA_IRQ1 0x100000
#define FIQEN_PLA_IRQ1_BIT 20
#define FIQEN_External_IRQ2_MASK 0x200000
#define FIQEN_External_IRQ2 0x200000
#define FIQEN_External_IRQ2_BIT 21
#define FIQEN_External_IRQ3_MASK 0x400000
#define FIQEN_External_IRQ3 0x400000
#define FIQEN_External_IRQ3_BIT 22
#define FIQEN_PWM_trip_MASK 0x800000
#define FIQEN_PWM_trip 0x800000
#define FIQEN_PWM_trip_BIT 23
#define FIQEN_PWM_sync_MASK 0x1000000
#define FIQEN_PWM_sync 0x1000000
#define FIQEN_PWM_sync_BIT 24

#define FIQCLR (*(volatile unsigned long *)0xFFFF010C)
#define FIQCLR_ALL_MASK 0x1
#define FIQCLR_ALL 0x1
#define FIQCLR_ALL_BIT 0
#define FIQCLR_Timer_0_MASK 0x4
#define FIQCLR_Timer_0 0x4
#define FIQCLR_Timer_0_BIT 2
#define FIQCLR_Timer_1_MASK 0x8
#define FIQCLR_Timer_1 0x8
#define FIQCLR_Timer_1_BIT 3
#define FIQCLR_Wake_Up_Timer_MASK 0x10
#define FIQCLR_Wake_Up_Timer 0x10
#define FIQCLR_Wake_Up_Timer_BIT 4
#define FIQCLR_Watchdog_Timer_MASK 0x20
#define FIQCLR_Watchdog_Timer 0x20
#define FIQCLR_Watchdog_Timer_BIT 5
#define FIQCLR_Flash_control_MASK 0x40
#define FIQCLR_Flash_control 0x40
#define FIQCLR_Flash_control_BIT 6
#define FIQCLR_ADC_channel_MASK 0x80
#define FIQCLR_ADC_channel 0x80
#define FIQCLR_ADC_channel_BIT 7
#define FIQCLR_PLL_lock_MASK 0x100
#define FIQCLR_PLL_lock 0x100
#define FIQCLR_PLL_lock_BIT 8
#define FIQCLR_I2C0_Slave_MASK 0x200
#define FIQCLR_I2C0_Slave 0x200
#define FIQCLR_I2C0_Slave_BIT 9
#define FIQCLR_I2C0_Master_MASK 0x400
#define FIQCLR_I2C0_Master 0x400
#define FIQCLR_I2C0_Master_BIT 10
#define FIQCLR_I2C1_Master_MASK 0x800
#define FIQCLR_I2C1_Master 0x800
#define FIQCLR_I2C1_Master_BIT 11
#define FIQCLR_SPI_Slave_MASK 0x1000
#define FIQCLR_SPI_Slave 0x1000
#define FIQCLR_SPI_Slave_BIT 12
#define FIQCLR_SPI_Master_MASK 0x2000
#define FIQCLR_SPI_Master 0x2000
#define FIQCLR_SPI_Master_BIT 13
#define FIQCLR_UART_MASK 0x4000
#define FIQCLR_UART 0x4000
#define FIQCLR_UART_BIT 14
#define FIQCLR_External_IRQ0_MASK 0x8000
#define FIQCLR_External_IRQ0 0x8000
#define FIQCLR_External_IRQ0_BIT 15
#define FIQCLR_Comparator_MASK 0x10000
#define FIQCLR_Comparator 0x10000
#define FIQCLR_Comparator_BIT 16
#define FIQCLR_PSM_MASK 0x20000
#define FIQCLR_PSM 0x20000
#define FIQCLR_PSM_BIT 17
#define FIQCLR_External_IRQ1_MASK 0x40000
#define FIQCLR_External_IRQ1 0x40000
#define FIQCLR_External_IRQ1_BIT 18
#define FIQCLR_PLA_IRQ0_MASK 0x80000
#define FIQCLR_PLA_IRQ0 0x80000
#define FIQCLR_PLA_IRQ0_BIT 19
#define FIQCLR_PLA_IRQ1_MASK 0x100000
#define FIQCLR_PLA_IRQ1 0x100000
#define FIQCLR_PLA_IRQ1_BIT 20
#define FIQCLR_External_IRQ2_MASK 0x200000
#define FIQCLR_External_IRQ2 0x200000
#define FIQCLR_External_IRQ2_BIT 21
#define FIQCLR_External_IRQ3_MASK 0x400000
#define FIQCLR_External_IRQ3 0x400000
#define FIQCLR_External_IRQ3_BIT 22
#define FIQCLR_PWM_trip_MASK 0x800000
#define FIQCLR_PWM_trip 0x800000
#define FIQCLR_PWM_trip_BIT 23
#define FIQCLR_PWM_sync_MASK 0x1000000
#define FIQCLR_PWM_sync 0x1000000
#define FIQCLR_PWM_sync_BIT 24

#define REMAP (*(volatile unsigned char *)0xFFFF0220)

#define RSTSTA (*(volatile unsigned char *)0xFFFF0230)

#define RSTCLR (*(volatile unsigned char *)0xFFFF0234)

#define T0LD (*(volatile unsigned short *)0xFFFF0300)

#define T0VAL (*(volatile unsigned short *)0xFFFF0304)

#define T0CON (*(volatile unsigned short *)0xFFFF0308)
#define T0CON_Prescale_MASK 0xC
#define T0CON_Prescale_BIT 2
#define T0CON_Mode_MASK 0x40
#define T0CON_Mode 0x40
#define T0CON_Mode_BIT 6
#define T0CON_ALL_MASK 0x1
#define T0CON_ALL 0x1
#define T0CON_ALL_BIT 0

#define T0CLRI (*(volatile unsigned char *)0xFFFF030C)

#define T1LD (*(volatile unsigned long *)0xFFFF0320)

#define T1VAL (*(volatile unsigned long *)0xFFFF0324)

#define T1CON (*(volatile unsigned short *)0xFFFF0328)
#define T1CON_Prescale_MASK 0xF
#define T1CON_Prescale_BIT 0
#define T1CON_Format_MASK 0x30
#define T1CON_Format_BIT 4
#define T1CON_Mode_MASK 0x40
#define T1CON_Mode 0x40
#define T1CON_Mode_BIT 6
#define T1CON_Enable_MASK 0x80
#define T1CON_Enable 0x80
#define T1CON_Enable_BIT 7
#define T1CON_CountUp_MASK 0x100
#define T1CON_CountUp 0x100
#define T1CON_CountUp_BIT 8
#define T1CON_Clock_select_MASK 0xE00
#define T1CON_Clock_select_BIT 9
#define T1CON_Event_select_range_MASK 0x1F000
#define T1CON_Event_select_range_BIT 12
#define T1CON_Event_select_MASK 0x20000
#define T1CON_Event_select 0x20000
#define T1CON_Event_select_BIT 17

#define T1CLRI (*(volatile unsigned char *)0xFFFF032C)

#define T1CAP (*(volatile unsigned long *)0xFFFF0330)

#define T2LD (*(volatile unsigned long *)0xFFFF0340)

#define T2VAL (*(volatile unsigned long *)0xFFFF0344)

#define T2CON (*(volatile unsigned short *)0xFFFF0348)
#define T2CON_Prescale_MASK 0xF
#define T2CON_Prescale_BIT 0
#define T2CON_Format_MASK 0x30
#define T2CON_Format_BIT 4
#define T2CON_Mode_MASK 0x40
#define T2CON_Mode 0x40
#define T2CON_Mode_BIT 6
#define T2CON_Enable_MASK 0x80
#define T2CON_Enable 0x80
#define T2CON_Enable_BIT 7
#define T2CON_CountUp_MASK 0x100
#define T2CON_CountUp 0x100
#define T2CON_CountUp_BIT 8

#define T2CLRI (*(volatile unsigned char *)0xFFFF034C)

#define T3LD (*(volatile unsigned short *)0xFFFF0360)

#define T3VAL (*(volatile unsigned short *)0xFFFF0364)

#define T3CON (*(volatile unsigned short *)0xFFFF0368)
#define T3CON_Watchdog_IRQ_option_MASK 0x6
#define T3CON_Watchdog_IRQ_option_BIT 1
#define T3CON_Prescale_MASK 0xC
#define T3CON_Prescale_BIT 2
#define T3CON_Secure_Clear_MASK 0x10
#define T3CON_Secure_Clear 0x10
#define T3CON_Secure_Clear_BIT 4
#define T3CON_Watchdog_Mode_Enable_MASK 0x20
#define T3CON_Watchdog_Mode_Enable 0x20
#define T3CON_Watchdog_Mode_Enable_BIT 5
#define T3CON_Timer_3_Mode_MASK 0x40
#define T3CON_Timer_3_Mode 0x40
#define T3CON_Timer_3_Mode_BIT 6
#define T3CON_Timer_3_Enable_MASK 0x80
#define T3CON_Timer_3_Enable 0x80
#define T3CON_Timer_3_Enable_BIT 7
#define T3CON_Count_up_MASK 0x100
#define T3CON_Count_up 0x100
#define T3CON_Count_up_BIT 8

#define T3CLRI (*(volatile unsigned char *)0xFFFF036C)

#define POWKEY1 (*(volatile unsigned char *)0xFFFF0404)

#define POWCON (*(volatile unsigned char *)0xFFFF0408)
#define POWCON_CD_MASK 0x7
#define POWCON_CD_BIT 0
#define POWCON_FINT_MASK 0x8
#define POWCON_FINT 0x8
#define POWCON_FINT_BIT 3
#define POWCON_PC_MASK 0x70
#define POWCON_PC_BIT 4

#define POWKEY2 (*(volatile unsigned char *)0xFFFF040C)

#define PLLKEY1 (*(volatile unsigned char *)0xFFFF0410)

#define PLLCON (*(volatile unsigned char *)0xFFFF0414)
#define PLLCON_MDCLK_MASK 0x3
#define PLLCON_MDCLK_BIT 0
#define PLLCON_SCLKS_MASK 0x4
#define PLLCON_SCLKS 0x4
#define PLLCON_SCLKS_BIT 2

#define PLLKEY2 (*(volatile unsigned char *)0xFFFF0418)

#define PSMCON (*(volatile unsigned short *)0xFFFF0440)

#define CMPCON (*(volatile unsigned short *)0xFFFF0444)

#define REFCON (*(volatile unsigned char *)0xFFFF048C)

#define ADCCON (*(volatile unsigned short *)0xFFFF0500)
#define ADCCON_Conversion_Type_MASK 0x7
#define ADCCON_Conversion_Type_BIT 0
#define ADCCON_Conversion_Mode_MASK 0x18
#define ADCCON_Conversion_Mode_BIT 3
#define ADCCON_ADC_power_control_MASK 0x20
#define ADCCON_ADC_power_control 0x20
#define ADCCON_ADC_power_control_BIT 5
#define ADCCON_Enable_ADC_Busy_MASK 0x40
#define ADCCON_Enable_ADC_Busy 0x40
#define ADCCON_Enable_ADC_Busy_BIT 6
#define ADCCON_Enable_Conversion_MASK 0x80
#define ADCCON_Enable_Conversion 0x80
#define ADCCON_Enable_Conversion_BIT 7

#define ADCCP (*(volatile unsigned char *)0xFFFF0504)

#define ADCCN (*(volatile unsigned char *)0xFFFF0508)

#define ADCSTA (*(volatile unsigned char *)0xFFFF050C)

#define ADCDAT (*(volatile unsigned long *)0xFFFF0510)

#define ADCRST (*(volatile unsigned char *)0xFFFF0514)

#define ADCGN (*(volatile unsigned short *)0xFFFF0530)

#define ADCOF (*(volatile unsigned short *)0xFFFF0534)

#define DAC0CON (*(volatile unsigned char *)0xFFFF0600)
#define DAC0CON_DAC_range_bits_MASK 0x3
#define DAC0CON_DAC_range_bits_BIT 0
#define DAC0CON_DACCLR_MASK 0x10
#define DAC0CON_DACCLR 0x10
#define DAC0CON_DACCLR_BIT 4
#define DAC0CON_DACCLK_MASK 0x20
#define DAC0CON_DACCLK 0x20
#define DAC0CON_DACCLK_BIT 5
#define DAC0CON_DACBYP_MASK 0x40
#define DAC0CON_DACBYP 0x40
#define DAC0CON_DACBYP_BIT 6

#define DAC0DAT (*(volatile unsigned long *)0xFFFF0604)
#define DAC0DAT_DAC_range_bits_MASK 0xFFF0000
#define DAC0DAT_DAC_range_bits_BIT 16

#define DAC1CON (*(volatile unsigned char *)0xFFFF0608)
#define DAC1CON_DAC_range_bits_MASK 0x3
#define DAC1CON_DAC_range_bits_BIT 0
#define DAC1CON_DACCLR_MASK 0x10
#define DAC1CON_DACCLR 0x10
#define DAC1CON_DACCLR_BIT 4
#define DAC1CON_DACCLK_MASK 0x20
#define DAC1CON_DACCLK 0x20
#define DAC1CON_DACCLK_BIT 5
#define DAC1CON_DACBYP_MASK 0x40
#define DAC1CON_DACBYP 0x40
#define DAC1CON_DACBYP_BIT 6

#define DAC1DAT (*(volatile unsigned long *)0xFFFF060C)
#define DAC1DAT_DAC_range_bits_MASK 0xFFF0000
#define DAC1DAT_DAC_range_bits_BIT 16

#define DAC2CON (*(volatile unsigned char *)0xFFFF0610)
#define DAC2CON_DAC_range_bits_MASK 0x3
#define DAC2CON_DAC_range_bits_BIT 0
#define DAC2CON_DACCLR_MASK 0x10
#define DAC2CON_DACCLR 0x10
#define DAC2CON_DACCLR_BIT 4
#define DAC2CON_DACCLK_MASK 0x20
#define DAC2CON_DACCLK 0x20
#define DAC2CON_DACCLK_BIT 5
#define DAC2CON_DACBYP_MASK 0x40
#define DAC2CON_DACBYP 0x40
#define DAC2CON_DACBYP_BIT 6

#define DAC2DAT (*(volatile unsigned long *)0xFFFF0614)
#define DAC2DAT_DAC_range_bits_MASK 0xFFF0000
#define DAC2DAT_DAC_range_bits_BIT 16

#define DAC3CON (*(volatile unsigned char *)0xFFFF0618)
#define DAC3CON_DAC_range_bits_MASK 0x3
#define DAC3CON_DAC_range_bits_BIT 0
#define DAC3CON_DACCLR_MASK 0x10
#define DAC3CON_DACCLR 0x10
#define DAC3CON_DACCLR_BIT 4
#define DAC3CON_DACCLK_MASK 0x20
#define DAC3CON_DACCLK 0x20
#define DAC3CON_DACCLK_BIT 5
#define DAC3CON_DACBYP_MASK 0x40
#define DAC3CON_DACBYP 0x40
#define DAC3CON_DACBYP_BIT 6

#define DAC3DAT (*(volatile unsigned long *)0xFFFF061C)
#define DAC3DAT_DAC_range_bits_MASK 0xFFF0000
#define DAC3DAT_DAC_range_bits_BIT 16

#define COMTX (*(volatile unsigned char *)0xFFFF0700)

#define COMRX (*(volatile unsigned char *)0xFFFF0700)

#define COMDIV0 (*(volatile unsigned char *)0xFFFF0700)

#define COMIEN0 (*(volatile unsigned char *)0xFFFF0704)
#define COMIEN0_ERBFI_MASK 0x1
#define COMIEN0_ERBFI 0x1
#define COMIEN0_ERBFI_BIT 0
#define COMIEN0_ETBEI_MASK 0x2
#define COMIEN0_ETBEI 0x2
#define COMIEN0_ETBEI_BIT 1
#define COMIEN0_ELSI_MASK 0x4
#define COMIEN0_ELSI 0x4
#define COMIEN0_ELSI_BIT 2
#define COMIEN0_EDSSI_MASK 0x8
#define COMIEN0_EDSSI 0x8
#define COMIEN0_EDSSI_BIT 3

#define COMDIV1 (*(volatile unsigned char *)0xFFFF0704)

#define COMIID0 (*(volatile unsigned char *)0xFFFF0708)

#define COMCON0 (*(volatile unsigned char *)0xFFFF070C)
#define COMCON0_WLS_MASK 0x3
#define COMCON0_WLS_BIT 0
#define COMCON0_STOP_MASK 0x4
#define COMCON0_STOP 0x4
#define COMCON0_STOP_BIT 2
#define COMCON0_PEN_MASK 0x8
#define COMCON0_PEN 0x8
#define COMCON0_PEN_BIT 3
#define COMCON0_EPS_MASK 0x10
#define COMCON0_EPS 0x10
#define COMCON0_EPS_BIT 4
#define COMCON0_SP_MASK 0x20
#define COMCON0_SP 0x20
#define COMCON0_SP_BIT 5
#define COMCON0_BRK_MASK 0x40
#define COMCON0_BRK 0x40
#define COMCON0_BRK_BIT 6
#define COMCON0_DLAB_MASK 0x80
#define COMCON0_DLAB 0x80
#define COMCON0_DLAB_BIT 7

#define COMCON1 (*(volatile unsigned char *)0xFFFF0710)
#define COMCON1_DTR_MASK 0x1
#define COMCON1_DTR 0x1
#define COMCON1_DTR_BIT 0
#define COMCON1_RTS_MASK 0x2
#define COMCON1_RTS 0x2
#define COMCON1_RTS_BIT 1
#define COMCON1_LOOPBACK_MASK 0x10
#define COMCON1_LOOPBACK 0x10
#define COMCON1_LOOPBACK_BIT 4

#define COMSTA0 (*(volatile unsigned char *)0xFFFF0714)
#define COMSTA0_DR_MASK 0x1
#define COMSTA0_DR 0x1
#define COMSTA0_DR_BIT 0
#define COMSTA0_OE_MASK 0x2
#define COMSTA0_OE 0x2
#define COMSTA0_OE_BIT 1
#define COMSTA0_PE_MASK 0x4
#define COMSTA0_PE 0x4
#define COMSTA0_PE_BIT 2
#define COMSTA0_FE_MASK 0x8
#define COMSTA0_FE 0x8
#define COMSTA0_FE_BIT 3
#define COMSTA0_BI_MASK 0x10
#define COMSTA0_BI 0x10
#define COMSTA0_BI_BIT 4
#define COMSTA0_THRE_MASK 0x20
#define COMSTA0_THRE 0x20
#define COMSTA0_THRE_BIT 5
#define COMSTA0_TEMT_MASK 0x40
#define COMSTA0_TEMT 0x40
#define COMSTA0_TEMT_BIT 6

#define COMSTA1 (*(volatile unsigned char *)0xFFFF0718)
#define COMSTA1_DCTS_MASK 0x1
#define COMSTA1_DCTS 0x1
#define COMSTA1_DCTS_BIT 0
#define COMSTA1_DDSR_MASK 0x2
#define COMSTA1_DDSR 0x2
#define COMSTA1_DDSR_BIT 1
#define COMSTA1_TERI_MASK 0x4
#define COMSTA1_TERI 0x4
#define COMSTA1_TERI_BIT 2
#define COMSTA1_DDCD_MASK 0x8
#define COMSTA1_DDCD 0x8
#define COMSTA1_DDCD_BIT 3
#define COMSTA1_CTS_MASK 0x10
#define COMSTA1_CTS 0x10
#define COMSTA1_CTS_BIT 4
#define COMSTA1_DSR_MASK 0x20
#define COMSTA1_DSR 0x20
#define COMSTA1_DSR_BIT 5
#define COMSTA1_RI_MASK 0x40
#define COMSTA1_RI 0x40
#define COMSTA1_RI_BIT 6
#define COMSTA1_DCD_MASK 0x80
#define COMSTA1_DCD 0x80
#define COMSTA1_DCD_BIT 7

#define COMSCR (*(volatile unsigned char *)0xFFFF071C)

#define COMIEN1 (*(volatile unsigned char *)0xFFFF0720)
#define COMIEN1_NAB_MASK 0x1
#define COMIEN1_NAB 0x1
#define COMIEN1_NAB_BIT 0
#define COMIEN1_NABP_MASK 0x2
#define COMIEN1_NABP 0x2
#define COMIEN1_NABP_BIT 1
#define COMIEN1_ETD_MASK 0x4
#define COMIEN1_ETD 0x4
#define COMIEN1_ETD_BIT 2
#define COMIEN1_E9BD_MASK 0x8
#define COMIEN1_E9BD 0x8
#define COMIEN1_E9BD_BIT 3
#define COMIEN1_ENI_MASK 0x10
#define COMIEN1_ENI 0x10
#define COMIEN1_ENI_BIT 4
#define COMIEN1_E9BR_MASK 0x20
#define COMIEN1_E9BR 0x20
#define COMIEN1_E9BR_BIT 5
#define COMIEN1_E9BT_MASK 0x40
#define COMIEN1_E9BT 0x40
#define COMIEN1_E9BT_BIT 6
#define COMIEN1_ENAM_MASK 0x80
#define COMIEN1_ENAM 0x80
#define COMIEN1_ENAM_BIT 7

#define COMIID1 (*(volatile unsigned char *)0xFFFF0724)

#define COMADR (*(volatile unsigned char *)0xFFFF0728)

#define COMDIV2 (*(volatile unsigned short *)0xFFFF072C)
#define COMDIV2_FBN_MASK 0x7FF
#define COMDIV2_FBN_BIT 0
#define COMDIV2_FBM_MASK 0x1FFC
#define COMDIV2_FBM_BIT 2
#define COMDIV2_FBEN_MASK 0x8000
#define COMDIV2_FBEN 0x8000
#define COMDIV2_FBEN_BIT 15

#define I2C0MSTA (*(volatile unsigned char *)0xFFFF0800)
#define I2C0MSTA_Master_TX_FIFO_empty_MASK 0x1
#define I2C0MSTA_Master_TX_FIFO_empty 0x1
#define I2C0MSTA_Master_TX_FIFO_empty_BIT 0
#define I2C0MSTA_Master_transmit_IRQ_MASK 0x2
#define I2C0MSTA_Master_transmit_IRQ 0x2
#define I2C0MSTA_Master_transmit_IRQ_BIT 1
#define I2C0MSTA_Master_receive_IRQ_MASK 0x4
#define I2C0MSTA_Master_receive_IRQ 0x4
#define I2C0MSTA_Master_receive_IRQ_BIT 2
#define I2C0MSTA_Master_receive_FIFO_overflow_MASK 0x8
#define I2C0MSTA_Master_receive_FIFO_overflow 0x8
#define I2C0MSTA_Master_receive_FIFO_overflow_BIT 3
#define I2C0MSTA_No_ACK_MASK 0x10
#define I2C0MSTA_No_ACK 0x10
#define I2C0MSTA_No_ACK_BIT 4
#define I2C0MSTA_Arbitration_loss_MASK 0x20
#define I2C0MSTA_Arbitration_loss 0x20
#define I2C0MSTA_Arbitration_loss_BIT 5
#define I2C0MSTA_Master_busy_MASK 0x40
#define I2C0MSTA_Master_busy 0x40
#define I2C0MSTA_Master_busy_BIT 6
#define I2C0MSTA_Transmit_FIFO_flush_MASK 0x80
#define I2C0MSTA_Transmit_FIFO_flush 0x80
#define I2C0MSTA_Transmit_FIFO_flush_BIT 7

#define I2C0SSTA (*(volatile unsigned char *)0xFFFF0804)
#define I2C0SSTA_Slave_transmit_FIFO_empty_MASK 0x1
#define I2C0SSTA_Slave_transmit_FIFO_empty 0x1
#define I2C0SSTA_Slave_transmit_FIFO_empty_BIT 0
#define I2C0SSTA_Slave_transmit_FIFO_underflow_MASK 0x2
#define I2C0SSTA_Slave_transmit_FIFO_underflow 0x2
#define I2C0SSTA_Slave_transmit_FIFO_underflow_BIT 1
#define I2C0SSTA_Slave_transmit_IRQ_MASK 0x4
#define I2C0SSTA_Slave_transmit_IRQ 0x4
#define I2C0SSTA_Slave_transmit_IRQ_BIT 2
#define I2C0SSTA_Slave_receive_IRQ_MASK 0x8
#define I2C0SSTA_Slave_receive_IRQ 0x8
#define I2C0SSTA_Slave_receive_IRQ_BIT 3
#define I2C0SSTA_Slave_receive_FIFO_overflow_MASK 0x10
#define I2C0SSTA_Slave_receive_FIFO_overflow 0x10
#define I2C0SSTA_Slave_receive_FIFO_overflow_BIT 4
#define I2C0SSTA_No_ACK_MASK 0x20
#define I2C0SSTA_No_ACK 0x20
#define I2C0SSTA_No_ACK_BIT 5
#define I2C0SSTA_Slave_busy_MASK 0x40
#define I2C0SSTA_Slave_busy 0x40
#define I2C0SSTA_Slave_busy_BIT 6
#define I2C0SSTA_Transmit_FIFO_flush_MASK 0x80
#define I2C0SSTA_Transmit_FIFO_flush 0x80
#define I2C0SSTA_Transmit_FIFO_flush_BIT 7

#define I2C0SRX (*(volatile unsigned char *)0xFFFF0808)

#define I2C0STX (*(volatile unsigned char *)0xFFFF080C)

#define I2C0MRX (*(volatile unsigned char *)0xFFFF0810)

#define I2C0MTX (*(volatile unsigned char *)0xFFFF0814)

#define I2C0CNT (*(volatile unsigned char *)0xFFFF0818)

#define I2C0ADR (*(volatile unsigned char *)0xFFFF081C)

#define I2C0BYTE (*(volatile unsigned char *)0xFFFF0824)

#define I2C0ALT (*(volatile unsigned char *)0xFFFF0828)

#define I2C0CFG (*(volatile unsigned char *)0xFFFF082C)
#define I2C0CFG_Slave_enable_MASK 0x1
#define I2C0CFG_Slave_enable 0x1
#define I2C0CFG_Slave_enable_BIT 0
#define I2C0CFG_Master_enable_MASK 0x2
#define I2C0CFG_Master_enable 0x2
#define I2C0CFG_Master_enable_BIT 1
#define I2C0CFG_General_call_enable_MASK 0x8
#define I2C0CFG_General_call_enable 0x8
#define I2C0CFG_General_call_enable_BIT 3
#define I2C0CFG_Hardware_general_call_enable_MASK 0x10
#define I2C0CFG_Hardware_general_call_enable 0x10
#define I2C0CFG_Hardware_general_call_enable_BIT 4
#define I2C0CFG_START_back_off_disable_MASK 0x20
#define I2C0CFG_START_back_off_disable 0x20
#define I2C0CFG_START_back_off_disable_BIT 5
#define I2C0CFG_Loop_back_enable_MASK 0x40
#define I2C0CFG_Loop_back_enable 0x40
#define I2C0CFG_Loop_back_enable_BIT 6
#define I2C0CFG_Master_serial_clock_enable_MASK 0x80
#define I2C0CFG_Master_serial_clock_enable 0x80
#define I2C0CFG_Master_serial_clock_enable_BIT 7

#define I2C0DIV (*(volatile unsigned short *)0xFFFF0830)

#define I2C0ID0 (*(volatile unsigned char *)0xFFFF0838)

#define I2C0ID1 (*(volatile unsigned char *)0xFFFF083C)

#define I2C0ID2 (*(volatile unsigned char *)0xFFFF0840)

#define I2C0ID3 (*(volatile unsigned char *)0xFFFF0844)

#define I2C0CCNT (*(volatile unsigned char *)0xFFFF0848)

#define I2C0FSTA (*(volatile unsigned short *)0xFFFF084C)

#define I2C1MSTA (*(volatile unsigned char *)0xFFFF0900)

#define I2C1SSTA (*(volatile unsigned char *)0xFFFF0904)

#define I2C1SRX (*(volatile unsigned char *)0xFFFF0908)

#define I2C1STX (*(volatile unsigned char *)0xFFFF090C)

#define I2C1MRX (*(volatile unsigned char *)0xFFFF0910)

#define I2C1MTX (*(volatile unsigned char *)0xFFFF0914)

#define I2C1CNT (*(volatile unsigned char *)0xFFFF0918)

#define I2C1ADR (*(volatile unsigned char *)0xFFFF091C)

#define I2C1BYTE (*(volatile unsigned char *)0xFFFF0924)

#define I2C1ALT (*(volatile unsigned char *)0xFFFF0928)

#define I2C1CFG (*(volatile unsigned char *)0xFFFF092C)

#define I2C1DIV (*(volatile unsigned short *)0xFFFF0930)

#define I2C1ID0 (*(volatile unsigned char *)0xFFFF0938)

#define I2C1ID1 (*(volatile unsigned char *)0xFFFF093C)

#define I2C1ID2 (*(volatile unsigned char *)0xFFFF0940)

#define I2C1ID3 (*(volatile unsigned char *)0xFFFF0944)

#define I2C1CCNT (*(volatile unsigned char *)0xFFFF0948)

#define I2C1FSTA (*(volatile unsigned short *)0xFFFF094C)

#define SPISTA (*(volatile unsigned char *)0xFFFF0A00)
#define SPISTA_SPITX_data_register_empty_status_MASK 0x1
#define SPISTA_SPITX_data_register_empty_status 0x1
#define SPISTA_SPITX_data_register_empty_status_BIT 0
#define SPISTA_SPITX_data_register_IRQ_MASK 0x2
#define SPISTA_SPITX_data_register_IRQ 0x2
#define SPISTA_SPITX_data_register_IRQ_BIT 1
#define SPISTA_SPITX_data_register_underflow_status_MASK 0x4
#define SPISTA_SPITX_data_register_underflow_status 0x4
#define SPISTA_SPITX_data_register_underflow_status_BIT 2
#define SPISTA_SPIRX_data_register_full_status_MASK 0x8
#define SPISTA_SPIRX_data_register_full_status 0x8
#define SPISTA_SPIRX_data_register_full_status_BIT 3
#define SPISTA_SPIRX_data_register_IRQ_MASK 0x10
#define SPISTA_SPIRX_data_register_IRQ 0x10
#define SPISTA_SPIRX_data_register_IRQ_BIT 4
#define SPISTA_SPIRX_data_register_overflow_status_MASK 0x20
#define SPISTA_SPIRX_data_register_overflow_status 0x20
#define SPISTA_SPIRX_data_register_overflow_status_BIT 5

#define SPIRX (*(volatile unsigned char *)0xFFFF0A04)

#define SPIYX (*(volatile unsigned char *)0xFFFF0A08)

#define SPIDIV (*(volatile unsigned char *)0xFFFF0A0C)

#define SPICON (*(volatile unsigned short *)0xFFFF0A10)
#define SPICON_Enable_MASK 0x1
#define SPICON_Enable 0x1
#define SPICON_Enable_BIT 0
#define SPICON_Master_mode_enable_MASK 0x2
#define SPICON_Master_mode_enable 0x2
#define SPICON_Master_mode_enable_BIT 1
#define SPICON_Serial_clock_phase_mode_MASK 0x4
#define SPICON_Serial_clock_phase_mode 0x4
#define SPICON_Serial_clock_phase_mode_BIT 2
#define SPICON_Serial_clock_polarity_mode_MASK 0x8
#define SPICON_Serial_clock_polarity_mode 0x8
#define SPICON_Serial_clock_polarity_mode_BIT 3
#define SPICON_LSB_first_transfer_enable_MASK 0x20
#define SPICON_LSB_first_transfer_enable 0x20
#define SPICON_LSB_first_transfer_enable_BIT 5
#define SPICON_Transfer_and_interrupt_mode_MASK 0x40
#define SPICON_Transfer_and_interrupt_mode 0x40
#define SPICON_Transfer_and_interrupt_mode_BIT 6
#define SPICON_SPITX_underflow_mode_MASK 0x80
#define SPICON_SPITX_underflow_mode 0x80
#define SPICON_SPITX_underflow_mode_BIT 7
#define SPICON_SPIRX_underflow_mode_MASK 0x100
#define SPICON_SPIRX_underflow_mode 0x100
#define SPICON_SPIRX_underflow_mode_BIT 8
#define SPICON_Slave_select_input_enable_MASK 0x200
#define SPICON_Slave_select_input_enable 0x200
#define SPICON_Slave_select_input_enable_BIT 9
#define SPICON_Slave_output_enable_MASK 0x400
#define SPICON_Slave_output_enable 0x400
#define SPICON_Slave_output_enable_BIT 10
#define SPICON_Loop_back_enable_MASK 0x800
#define SPICON_Loop_back_enable 0x800
#define SPICON_Loop_back_enable_BIT 11
#define SPICON_Continuous_transfer_enable_MASK 0x1000
#define SPICON_Continuous_transfer_enable 0x1000
#define SPICON_Continuous_transfer_enable_BIT 12

#define PLAELM0 (*(volatile unsigned short *)0xFFFF0B00)
#define PLAELM0_Mux_4_control_MASK 0x1
#define PLAELM0_Mux_4_control 0x1
#define PLAELM0_Mux_4_control_BIT 0
#define PLAELM0_Look_up_table_control_MASK 0x1E
#define PLAELM0_Look_up_table_control_BIT 1
#define PLAELM0_Mux_3_control_MASK 0x20
#define PLAELM0_Mux_3_control 0x20
#define PLAELM0_Mux_3_control_BIT 5
#define PLAELM0_Mux_2_control_MASK 0x40
#define PLAELM0_Mux_2_control 0x40
#define PLAELM0_Mux_2_control_BIT 6
#define PLAELM0_Mux_1_control_MASK 0x180
#define PLAELM0_Mux_1_control_BIT 7
#define PLAELM0_Mux_0_control_MASK 0x600
#define PLAELM0_Mux_0_control_BIT 9

#define PLAELM1 (*(volatile unsigned short *)0xFFFF0B04)
#define PLAELM1_Mux_4_control_MASK 0x1
#define PLAELM1_Mux_4_control 0x1
#define PLAELM1_Mux_4_control_BIT 0
#define PLAELM1_Look_up_table_control_MASK 0x1E
#define PLAELM1_Look_up_table_control_BIT 1
#define PLAELM1_Mux_3_control_MASK 0x20
#define PLAELM1_Mux_3_control 0x20
#define PLAELM1_Mux_3_control_BIT 5
#define PLAELM1_Mux_2_control_MASK 0x40
#define PLAELM1_Mux_2_control 0x40
#define PLAELM1_Mux_2_control_BIT 6
#define PLAELM1_Mux_1_control_MASK 0x180
#define PLAELM1_Mux_1_control_BIT 7
#define PLAELM1_Mux_0_control_MASK 0x600
#define PLAELM1_Mux_0_control_BIT 9

#define PLAELM2 (*(volatile unsigned short *)0xFFFF0B08)
#define PLAELM2_Mux_4_control_MASK 0x1
#define PLAELM2_Mux_4_control 0x1
#define PLAELM2_Mux_4_control_BIT 0
#define PLAELM2_Look_up_table_control_MASK 0x1E
#define PLAELM2_Look_up_table_control_BIT 1
#define PLAELM2_Mux_3_control_MASK 0x20
#define PLAELM2_Mux_3_control 0x20
#define PLAELM2_Mux_3_control_BIT 5
#define PLAELM2_Mux_2_control_MASK 0x40
#define PLAELM2_Mux_2_control 0x40
#define PLAELM2_Mux_2_control_BIT 6
#define PLAELM2_Mux_1_control_MASK 0x180
#define PLAELM2_Mux_1_control_BIT 7
#define PLAELM2_Mux_0_control_MASK 0x600
#define PLAELM2_Mux_0_control_BIT 9

#define PLAELM3 (*(volatile unsigned short *)0xFFFF0B0C)
#define PLAELM3_Mux_4_control_MASK 0x1
#define PLAELM3_Mux_4_control 0x1
#define PLAELM3_Mux_4_control_BIT 0
#define PLAELM3_Look_up_table_control_MASK 0x1E
#define PLAELM3_Look_up_table_control_BIT 1
#define PLAELM3_Mux_3_control_MASK 0x20
#define PLAELM3_Mux_3_control 0x20
#define PLAELM3_Mux_3_control_BIT 5
#define PLAELM3_Mux_2_control_MASK 0x40
#define PLAELM3_Mux_2_control 0x40
#define PLAELM3_Mux_2_control_BIT 6
#define PLAELM3_Mux_1_control_MASK 0x180
#define PLAELM3_Mux_1_control_BIT 7
#define PLAELM3_Mux_0_control_MASK 0x600
#define PLAELM3_Mux_0_control_BIT 9

#define PLAELM4 (*(volatile unsigned short *)0xFFFF0B10)
#define PLAELM4_Mux_4_control_MASK 0x1
#define PLAELM4_Mux_4_control 0x1
#define PLAELM4_Mux_4_control_BIT 0
#define PLAELM4_Look_up_table_control_MASK 0x1E
#define PLAELM4_Look_up_table_control_BIT 1
#define PLAELM4_Mux_3_control_MASK 0x20
#define PLAELM4_Mux_3_control 0x20
#define PLAELM4_Mux_3_control_BIT 5
#define PLAELM4_Mux_2_control_MASK 0x40
#define PLAELM4_Mux_2_control 0x40
#define PLAELM4_Mux_2_control_BIT 6
#define PLAELM4_Mux_1_control_MASK 0x180
#define PLAELM4_Mux_1_control_BIT 7
#define PLAELM4_Mux_0_control_MASK 0x600
#define PLAELM4_Mux_0_control_BIT 9

#define PLAELM5 (*(volatile unsigned short *)0xFFFF0B14)
#define PLAELM5_Mux_4_control_MASK 0x1
#define PLAELM5_Mux_4_control 0x1
#define PLAELM5_Mux_4_control_BIT 0
#define PLAELM5_Look_up_table_control_MASK 0x1E
#define PLAELM5_Look_up_table_control_BIT 1
#define PLAELM5_Mux_3_control_MASK 0x20
#define PLAELM5_Mux_3_control 0x20
#define PLAELM5_Mux_3_control_BIT 5
#define PLAELM5_Mux_2_control_MASK 0x40
#define PLAELM5_Mux_2_control 0x40
#define PLAELM5_Mux_2_control_BIT 6
#define PLAELM5_Mux_1_control_MASK 0x180
#define PLAELM5_Mux_1_control_BIT 7
#define PLAELM5_Mux_0_control_MASK 0x600
#define PLAELM5_Mux_0_control_BIT 9

#define PLAELM6 (*(volatile unsigned short *)0xFFFF0B18)
#define PLAELM6_Mux_4_control_MASK 0x1
#define PLAELM6_Mux_4_control 0x1
#define PLAELM6_Mux_4_control_BIT 0
#define PLAELM6_Look_up_table_control_MASK 0x1E
#define PLAELM6_Look_up_table_control_BIT 1
#define PLAELM6_Mux_3_control_MASK 0x20
#define PLAELM6_Mux_3_control 0x20
#define PLAELM6_Mux_3_control_BIT 5
#define PLAELM6_Mux_2_control_MASK 0x40
#define PLAELM6_Mux_2_control 0x40
#define PLAELM6_Mux_2_control_BIT 6
#define PLAELM6_Mux_1_control_MASK 0x180
#define PLAELM6_Mux_1_control_BIT 7
#define PLAELM6_Mux_0_control_MASK 0x600
#define PLAELM6_Mux_0_control_BIT 9

#define PLAELM7 (*(volatile unsigned short *)0xFFFF0B1C)
#define PLAELM7_Mux_4_control_MASK 0x1
#define PLAELM7_Mux_4_control 0x1
#define PLAELM7_Mux_4_control_BIT 0
#define PLAELM7_Look_up_table_control_MASK 0x1E
#define PLAELM7_Look_up_table_control_BIT 1
#define PLAELM7_Mux_3_control_MASK 0x20
#define PLAELM7_Mux_3_control 0x20
#define PLAELM7_Mux_3_control_BIT 5
#define PLAELM7_Mux_2_control_MASK 0x40
#define PLAELM7_Mux_2_control 0x40
#define PLAELM7_Mux_2_control_BIT 6
#define PLAELM7_Mux_1_control_MASK 0x180
#define PLAELM7_Mux_1_control_BIT 7
#define PLAELM7_Mux_0_control_MASK 0x600
#define PLAELM7_Mux_0_control_BIT 9

#define PLAELM8 (*(volatile unsigned short *)0xFFFF0B20)
#define PLAELM8_Mux_4_control_MASK 0x1
#define PLAELM8_Mux_4_control 0x1
#define PLAELM8_Mux_4_control_BIT 0
#define PLAELM8_Look_up_table_control_MASK 0x1E
#define PLAELM8_Look_up_table_control_BIT 1
#define PLAELM8_Mux_3_control_MASK 0x20
#define PLAELM8_Mux_3_control 0x20
#define PLAELM8_Mux_3_control_BIT 5
#define PLAELM8_Mux_2_control_MASK 0x40
#define PLAELM8_Mux_2_control 0x40
#define PLAELM8_Mux_2_control_BIT 6
#define PLAELM8_Mux_1_control_MASK 0x180
#define PLAELM8_Mux_1_control_BIT 7
#define PLAELM8_Mux_0_control_MASK 0x600
#define PLAELM8_Mux_0_control_BIT 9

#define PLAELM9 (*(volatile unsigned short *)0xFFFF0B24)
#define PLAELM9_Mux_4_control_MASK 0x1
#define PLAELM9_Mux_4_control 0x1
#define PLAELM9_Mux_4_control_BIT 0
#define PLAELM9_Look_up_table_control_MASK 0x1E
#define PLAELM9_Look_up_table_control_BIT 1
#define PLAELM9_Mux_3_control_MASK 0x20
#define PLAELM9_Mux_3_control 0x20
#define PLAELM9_Mux_3_control_BIT 5
#define PLAELM9_Mux_2_control_MASK 0x40
#define PLAELM9_Mux_2_control 0x40
#define PLAELM9_Mux_2_control_BIT 6
#define PLAELM9_Mux_1_control_MASK 0x180
#define PLAELM9_Mux_1_control_BIT 7
#define PLAELM9_Mux_0_control_MASK 0x600
#define PLAELM9_Mux_0_control_BIT 9

#define PLAELM10 (*(volatile unsigned short *)0xFFFF0B28)
#define PLAELM10_Mux_4_control_MASK 0x1
#define PLAELM10_Mux_4_control 0x1
#define PLAELM10_Mux_4_control_BIT 0
#define PLAELM10_Look_up_table_control_MASK 0x1E
#define PLAELM10_Look_up_table_control_BIT 1
#define PLAELM10_Mux_3_control_MASK 0x20
#define PLAELM10_Mux_3_control 0x20
#define PLAELM10_Mux_3_control_BIT 5
#define PLAELM10_Mux_2_control_MASK 0x40
#define PLAELM10_Mux_2_control 0x40
#define PLAELM10_Mux_2_control_BIT 6
#define PLAELM10_Mux_1_control_MASK 0x180
#define PLAELM10_Mux_1_control_BIT 7
#define PLAELM10_Mux_0_control_MASK 0x600
#define PLAELM10_Mux_0_control_BIT 9

#define PLAELM11 (*(volatile unsigned short *)0xFFFF0B2C)
#define PLAELM11_Mux_4_control_MASK 0x1
#define PLAELM11_Mux_4_control 0x1
#define PLAELM11_Mux_4_control_BIT 0
#define PLAELM11_Look_up_table_control_MASK 0x1E
#define PLAELM11_Look_up_table_control_BIT 1
#define PLAELM11_Mux_3_control_MASK 0x20
#define PLAELM11_Mux_3_control 0x20
#define PLAELM11_Mux_3_control_BIT 5
#define PLAELM11_Mux_2_control_MASK 0x40
#define PLAELM11_Mux_2_control 0x40
#define PLAELM11_Mux_2_control_BIT 6
#define PLAELM11_Mux_1_control_MASK 0x180
#define PLAELM11_Mux_1_control_BIT 7
#define PLAELM11_Mux_0_control_MASK 0x600
#define PLAELM11_Mux_0_control_BIT 9

#define PLAELM12 (*(volatile unsigned short *)0xFFFF0B30)
#define PLAELM12_Mux_4_control_MASK 0x1
#define PLAELM12_Mux_4_control 0x1
#define PLAELM12_Mux_4_control_BIT 0
#define PLAELM12_Look_up_table_control_MASK 0x1E
#define PLAELM12_Look_up_table_control_BIT 1
#define PLAELM12_Mux_3_control_MASK 0x20
#define PLAELM12_Mux_3_control 0x20
#define PLAELM12_Mux_3_control_BIT 5
#define PLAELM12_Mux_2_control_MASK 0x40
#define PLAELM12_Mux_2_control 0x40
#define PLAELM12_Mux_2_control_BIT 6
#define PLAELM12_Mux_1_control_MASK 0x180
#define PLAELM12_Mux_1_control_BIT 7
#define PLAELM12_Mux_0_control_MASK 0x600
#define PLAELM12_Mux_0_control_BIT 9

#define PLAELM13 (*(volatile unsigned short *)0xFFFF0B34)
#define PLAELM13_Mux_4_control_MASK 0x1
#define PLAELM13_Mux_4_control 0x1
#define PLAELM13_Mux_4_control_BIT 0
#define PLAELM13_Look_up_table_control_MASK 0x1E
#define PLAELM13_Look_up_table_control_BIT 1
#define PLAELM13_Mux_3_control_MASK 0x20
#define PLAELM13_Mux_3_control 0x20
#define PLAELM13_Mux_3_control_BIT 5
#define PLAELM13_Mux_2_control_MASK 0x40
#define PLAELM13_Mux_2_control 0x40
#define PLAELM13_Mux_2_control_BIT 6
#define PLAELM13_Mux_1_control_MASK 0x180
#define PLAELM13_Mux_1_control_BIT 7
#define PLAELM13_Mux_0_control_MASK 0x600
#define PLAELM13_Mux_0_control_BIT 9

#define PLAELM14 (*(volatile unsigned short *)0xFFFF0B38)
#define PLAELM14_Mux_4_control_MASK 0x1
#define PLAELM14_Mux_4_control 0x1
#define PLAELM14_Mux_4_control_BIT 0
#define PLAELM14_Look_up_table_control_MASK 0x1E
#define PLAELM14_Look_up_table_control_BIT 1
#define PLAELM14_Mux_3_control_MASK 0x20
#define PLAELM14_Mux_3_control 0x20
#define PLAELM14_Mux_3_control_BIT 5
#define PLAELM14_Mux_2_control_MASK 0x40
#define PLAELM14_Mux_2_control 0x40
#define PLAELM14_Mux_2_control_BIT 6
#define PLAELM14_Mux_1_control_MASK 0x180
#define PLAELM14_Mux_1_control_BIT 7
#define PLAELM14_Mux_0_control_MASK 0x600
#define PLAELM14_Mux_0_control_BIT 9

#define PLAELM15 (*(volatile unsigned short *)0xFFFF0B3C)
#define PLAELM15_Mux_4_control_MASK 0x1
#define PLAELM15_Mux_4_control 0x1
#define PLAELM15_Mux_4_control_BIT 0
#define PLAELM15_Look_up_table_control_MASK 0x1E
#define PLAELM15_Look_up_table_control_BIT 1
#define PLAELM15_Mux_3_control_MASK 0x20
#define PLAELM15_Mux_3_control 0x20
#define PLAELM15_Mux_3_control_BIT 5
#define PLAELM15_Mux_2_control_MASK 0x40
#define PLAELM15_Mux_2_control 0x40
#define PLAELM15_Mux_2_control_BIT 6
#define PLAELM15_Mux_1_control_MASK 0x180
#define PLAELM15_Mux_1_control_BIT 7
#define PLAELM15_Mux_0_control_MASK 0x600
#define PLAELM15_Mux_0_control_BIT 9

#define PLACLK (*(volatile unsigned char *)0xFFFF0B40)
#define PLACLK_Block0_clock_source_MASK 0x7
#define PLACLK_Block0_clock_source_BIT 0
#define PLACLK_Block1_clock_source_MASK 0x70
#define PLACLK_Block1_clock_source_BIT 4

#define PLAIRQ (*(volatile unsigned long *)0xFFFF0B44)
#define PLAIRQ_PLAIRQ0_source_MASK 0xF
#define PLAIRQ_PLAIRQ0_source_BIT 0
#define PLAIRQ_PLAIRQ0_enable_MASK 0x10
#define PLAIRQ_PLAIRQ0_enable 0x10
#define PLAIRQ_PLAIRQ0_enable_BIT 4
#define PLAIRQ_PLAIRQ1_source_MASK 0xF00
#define PLAIRQ_PLAIRQ1_source_BIT 8
#define PLAIRQ_PLAIRQ1_enable_MASK 0x1000
#define PLAIRQ_PLAIRQ1_enable 0x1000
#define PLAIRQ_PLAIRQ1_enable_BIT 12

#define PLAADC (*(volatile unsigned long *)0xFFFF0B48)
#define PLAADC_ADC_start_conversion_source_MASK 0xF
#define PLAADC_ADC_start_conversion_source_BIT 0
#define PLAADC_ADC_start_conversion_enable_MASK 0x10
#define PLAADC_ADC_start_conversion_enable 0x10
#define PLAADC_ADC_start_conversion_enable_BIT 4

#define PLADIN (*(volatile unsigned long *)0xFFFF0B4C)

#define PLADOUT (*(volatile unsigned long *)0xFFFF0B50)

#define PLALCK (*(volatile unsigned long *)0xFFFF0B54)

#define GP0CON (*(volatile unsigned long *)0xFFFFF400)
#define GP0CON_Select_function_of_P0_0_MASK 0x3
#define GP0CON_Select_function_of_P0_0_BIT 0
#define GP0CON_Select_function_of_P0_1_MASK 0x30
#define GP0CON_Select_function_of_P0_1_BIT 4
#define GP0CON_Select_function_of_P0_2_MASK 0x300
#define GP0CON_Select_function_of_P0_2_BIT 8
#define GP0CON_Select_function_of_P0_3_MASK 0x3000
#define GP0CON_Select_function_of_P0_3_BIT 12
#define GP0CON_Select_function_of_P0_4_MASK 0x30000
#define GP0CON_Select_function_of_P0_4_BIT 16
#define GP0CON_Select_function_of_P0_5_MASK 0x300000
#define GP0CON_Select_function_of_P0_5_BIT 20
#define GP0CON_Select_function_of_P0_6_MASK 0x3000000
#define GP0CON_Select_function_of_P0_6_BIT 24
#define GP0CON_Select_function_of_P0_7_MASK 0x30000000
#define GP0CON_Select_function_of_P0_7_BIT 28

#define GP1CON (*(volatile unsigned long *)0xFFFFF404)
#define GP1CON_Select_function_of_P1_0_MASK 0x3
#define GP1CON_Select_function_of_P1_0_BIT 0
#define GP1CON_Select_function_of_P1_1_MASK 0x30
#define GP1CON_Select_function_of_P1_1_BIT 4
#define GP1CON_Select_function_of_P1_2_MASK 0x300
#define GP1CON_Select_function_of_P1_2_BIT 8
#define GP1CON_Select_function_of_P1_3_MASK 0x3000
#define GP1CON_Select_function_of_P1_3_BIT 12
#define GP1CON_Select_function_of_P1_4_MASK 0x30000
#define GP1CON_Select_function_of_P1_4_BIT 16
#define GP1CON_Select_function_of_P1_5_MASK 0x300000
#define GP1CON_Select_function_of_P1_5_BIT 20
#define GP1CON_Select_function_of_P1_6_MASK 0x3000000
#define GP1CON_Select_function_of_P1_6_BIT 24
#define GP1CON_Select_function_of_P1_7_MASK 0x30000000
#define GP1CON_Select_function_of_P1_7_BIT 28

#define GP2CON (*(volatile unsigned long *)0xFFFFF408)
#define GP2CON_Select_function_of_P2_0_MASK 0x3
#define GP2CON_Select_function_of_P2_0_BIT 0
#define GP2CON_Select_function_of_P2_1_MASK 0x30
#define GP2CON_Select_function_of_P2_1_BIT 4
#define GP2CON_Select_function_of_P2_2_MASK 0x300
#define GP2CON_Select_function_of_P2_2_BIT 8
#define GP2CON_Select_function_of_P2_3_MASK 0x3000
#define GP2CON_Select_function_of_P2_3_BIT 12
#define GP2CON_Select_function_of_P2_4_MASK 0x30000
#define GP2CON_Select_function_of_P2_4_BIT 16
#define GP2CON_Select_function_of_P2_5_MASK 0x300000
#define GP2CON_Select_function_of_P2_5_BIT 20
#define GP2CON_Select_function_of_P2_6_MASK 0x3000000
#define GP2CON_Select_function_of_P2_6_BIT 24
#define GP2CON_Select_function_of_P2_7_MASK 0x30000000
#define GP2CON_Select_function_of_P2_7_BIT 28

#define GP3CON (*(volatile unsigned long *)0xFFFFF40C)
#define GP3CON_Select_function_of_P3_0_MASK 0x3
#define GP3CON_Select_function_of_P3_0_BIT 0
#define GP3CON_Select_function_of_P3_1_MASK 0x30
#define GP3CON_Select_function_of_P3_1_BIT 4
#define GP3CON_Select_function_of_P3_2_MASK 0x300
#define GP3CON_Select_function_of_P3_2_BIT 8
#define GP3CON_Select_function_of_P3_3_MASK 0x3000
#define GP3CON_Select_function_of_P3_3_BIT 12
#define GP3CON_Select_function_of_P3_4_MASK 0x30000
#define GP3CON_Select_function_of_P3_4_BIT 16
#define GP3CON_Select_function_of_P3_5_MASK 0x300000
#define GP3CON_Select_function_of_P3_5_BIT 20
#define GP3CON_Select_function_of_P3_6_MASK 0x3000000
#define GP3CON_Select_function_of_P3_6_BIT 24
#define GP3CON_Select_function_of_P3_7_MASK 0x30000000
#define GP3CON_Select_function_of_P3_7_BIT 28

#define GP4CON (*(volatile unsigned long *)0xFFFFF410)
#define GP4CON_Select_function_of_P4_0_MASK 0x3
#define GP4CON_Select_function_of_P4_0_BIT 0
#define GP4CON_Select_function_of_P4_1_MASK 0x30
#define GP4CON_Select_function_of_P4_1_BIT 4
#define GP4CON_Select_function_of_P4_2_MASK 0x300
#define GP4CON_Select_function_of_P4_2_BIT 8
#define GP4CON_Select_function_of_P4_3_MASK 0x3000
#define GP4CON_Select_function_of_P4_3_BIT 12
#define GP4CON_Select_function_of_P4_4_MASK 0x30000
#define GP4CON_Select_function_of_P4_4_BIT 16
#define GP4CON_Select_function_of_P4_5_MASK 0x300000
#define GP4CON_Select_function_of_P4_5_BIT 20
#define GP4CON_Select_function_of_P4_6_MASK 0x3000000
#define GP4CON_Select_function_of_P4_6_BIT 24
#define GP4CON_Select_function_of_P4_7_MASK 0x30000000
#define GP4CON_Select_function_of_P4_7_BIT 28

#define GP0DAT (*(volatile unsigned long *)0xFFFFF420)
#define GP0DAT_Data_input_MASK 0xFF
#define GP0DAT_Data_input_BIT 0
#define GP0DAT_Pins_at_reset_MASK 0xFF00
#define GP0DAT_Pins_at_reset_BIT 8
#define GP0DAT_Data_output_MASK 0xFF0000
#define GP0DAT_Data_output_BIT 16
#define GP0DAT_Direction_MASK 0xFF000000
#define GP0DAT_Direction_BIT 24

#define GP0SET (*(volatile unsigned long *)0xFFFFF424)
#define GP0SET_Set_MASK 0xFF0000
#define GP0SET_Set_BIT 16

#define GP0CLR (*(volatile unsigned long *)0xFFFFF428)
#define GP0CLR_Clear_MASK 0xFF0000
#define GP0CLR_Clear_BIT 16

#define GP0PAR (*(volatile unsigned long *)0xFFFFF42C)

#define GP1DAT (*(volatile unsigned long *)0xFFFFF430)
#define GP1DAT_Data_input_MASK 0xFF
#define GP1DAT_Data_input_BIT 0
#define GP1DAT_Pins_at_reset_MASK 0xFF00
#define GP1DAT_Pins_at_reset_BIT 8
#define GP1DAT_Data_output_MASK 0xFF0000
#define GP1DAT_Data_output_BIT 16
#define GP1DAT_Direction_MASK 0xFF000000
#define GP1DAT_Direction_BIT 24

#define GP1SET (*(volatile unsigned long *)0xFFFFF434)
#define GP1SET_Set_MASK 0xFF0000
#define GP1SET_Set_BIT 16

#define GP1CLR (*(volatile unsigned long *)0xFFFFF438)
#define GP1CLR_Clear_MASK 0xFF0000
#define GP1CLR_Clear_BIT 16

#define GP1PAR (*(volatile unsigned long *)0xFFFFF43C)

#define GP2DAT (*(volatile unsigned long *)0xFFFFF440)
#define GP2DAT_Data_input_MASK 0xFF
#define GP2DAT_Data_input_BIT 0
#define GP2DAT_Pins_at_reset_MASK 0xFF00
#define GP2DAT_Pins_at_reset_BIT 8
#define GP2DAT_Data_output_MASK 0xFF0000
#define GP2DAT_Data_output_BIT 16
#define GP2DAT_Direction_MASK 0xFF000000
#define GP2DAT_Direction_BIT 24

#define GP2SET (*(volatile unsigned long *)0xFFFFF444)
#define GP2SET_Set_MASK 0xFF0000
#define GP2SET_Set_BIT 16

#define GP2CLR (*(volatile unsigned long *)0xFFFFF448)
#define GP2CLR_Clear_MASK 0xFF0000
#define GP2CLR_Clear_BIT 16

#define GP3DAT (*(volatile unsigned long *)0xFFFFF450)
#define GP3DAT_Data_input_MASK 0xFF
#define GP3DAT_Data_input_BIT 0
#define GP3DAT_Pins_at_reset_MASK 0xFF00
#define GP3DAT_Pins_at_reset_BIT 8
#define GP3DAT_Data_output_MASK 0xFF0000
#define GP3DAT_Data_output_BIT 16
#define GP3DAT_Direction_MASK 0xFF000000
#define GP3DAT_Direction_BIT 24

#define GP3SET (*(volatile unsigned long *)0xFFFFF454)
#define GP3SET_Set_MASK 0xFF0000
#define GP3SET_Set_BIT 16

#define GP3CLR (*(volatile unsigned long *)0xFFFFF458)
#define GP3CLR_Clear_MASK 0xFF0000
#define GP3CLR_Clear_BIT 16

#define GP4DAT (*(volatile unsigned long *)0xFFFFF460)
#define GP4DAT_Data_input_MASK 0xFF
#define GP4DAT_Data_input_BIT 0
#define GP4DAT_Pins_at_reset_MASK 0xFF00
#define GP4DAT_Pins_at_reset_BIT 8
#define GP4DAT_Data_output_MASK 0xFF0000
#define GP4DAT_Data_output_BIT 16
#define GP4DAT_Direction_MASK 0xFF000000
#define GP4DAT_Direction_BIT 24

#define GP4SET (*(volatile unsigned long *)0xFFFFF464)
#define GP4SET_Set_MASK 0xFF0000
#define GP4SET_Set_BIT 16

#define GP4CLR (*(volatile unsigned long *)0xFFFFF468)
#define GP4CLR_Clear_MASK 0xFF0000
#define GP4CLR_Clear_BIT 16

#define FEESTA (*(volatile unsigned char *)0xFFFFF800)
#define FEESTA_Command_complete_MASK 0x1
#define FEESTA_Command_complete 0x1
#define FEESTA_Command_complete_BIT 0
#define FEESTA_Command_fail_MASK 0x2
#define FEESTA_Command_fail 0x2
#define FEESTA_Command_fail_BIT 1
#define FEESTA_Flash_EE_controller_busy_MASK 0x4
#define FEESTA_Flash_EE_controller_busy 0x4
#define FEESTA_Flash_EE_controller_busy_BIT 2
#define FEESTA_Flash_interrupt_status_bit_MASK 0x8
#define FEESTA_Flash_interrupt_status_bit 0x8
#define FEESTA_Flash_interrupt_status_bit_BIT 3
#define FEESTA_Burst_command_enable_MASK 0x20
#define FEESTA_Burst_command_enable 0x20
#define FEESTA_Burst_command_enable_BIT 5

#define FEEMOD (*(volatile unsigned char *)0xFFFFF804)
#define FEEMOD_Flash_EE_interrupt_enable_MASK 0x10
#define FEEMOD_Flash_EE_interrupt_enable 0x10
#define FEEMOD_Flash_EE_interrupt_enable_BIT 4

#define FEECON (*(volatile unsigned char *)0xFFFFF808)

#define FEEDAT (*(volatile unsigned short *)0xFFFFF80C)

#define FEEADR (*(volatile unsigned short *)0xFFFFF810)

#define FEESIGN (*(volatile unsigned *)0xFFFFF818)

#define FEEPRO (*(volatile unsigned long *)0xFFFFF81C)
#define FEEPRO_Write_protection_pages_0_to_3_MASK 0x1
#define FEEPRO_Write_protection_pages_0_to_3 0x1
#define FEEPRO_Write_protection_pages_0_to_3_BIT 0
#define FEEPRO_Write_protection_pages_4_to_7_MASK 0x2
#define FEEPRO_Write_protection_pages_4_to_7 0x2
#define FEEPRO_Write_protection_pages_4_to_7_BIT 1
#define FEEPRO_Write_protection_pages_8_to_11_MASK 0x4
#define FEEPRO_Write_protection_pages_8_to_11 0x4
#define FEEPRO_Write_protection_pages_8_to_11_BIT 2
#define FEEPRO_Write_protection_pages_12_to_15_MASK 0x8
#define FEEPRO_Write_protection_pages_12_to_15 0x8
#define FEEPRO_Write_protection_pages_12_to_15_BIT 3
#define FEEPRO_Write_protection_pages_16_to_19_MASK 0x10
#define FEEPRO_Write_protection_pages_16_to_19 0x10
#define FEEPRO_Write_protection_pages_16_to_19_BIT 4
#define FEEPRO_Write_protection_pages_20_to_23_MASK 0x20
#define FEEPRO_Write_protection_pages_20_to_23 0x20
#define FEEPRO_Write_protection_pages_20_to_23_BIT 5
#define FEEPRO_Write_protection_pages_24_to_27_MASK 0x40
#define FEEPRO_Write_protection_pages_24_to_27 0x40
#define FEEPRO_Write_protection_pages_24_to_27_BIT 6
#define FEEPRO_Write_protection_pages_28_to_31_MASK 0x80
#define FEEPRO_Write_protection_pages_28_to_31 0x80
#define FEEPRO_Write_protection_pages_28_to_31_BIT 7
#define FEEPRO_Write_protection_pages_32_to_35_MASK 0x100
#define FEEPRO_Write_protection_pages_32_to_35 0x100
#define FEEPRO_Write_protection_pages_32_to_35_BIT 8
#define FEEPRO_Write_protection_pages_36_to_39_MASK 0x200
#define FEEPRO_Write_protection_pages_36_to_39 0x200
#define FEEPRO_Write_protection_pages_36_to_39_BIT 9
#define FEEPRO_Write_protection_pages_40_to_43_MASK 0x400
#define FEEPRO_Write_protection_pages_40_to_43 0x400
#define FEEPRO_Write_protection_pages_40_to_43_BIT 10
#define FEEPRO_Write_protection_pages_44_to_47_MASK 0x800
#define FEEPRO_Write_protection_pages_44_to_47 0x800
#define FEEPRO_Write_protection_pages_44_to_47_BIT 11
#define FEEPRO_Write_protection_pages_48_to_51_MASK 0x1000
#define FEEPRO_Write_protection_pages_48_to_51 0x1000
#define FEEPRO_Write_protection_pages_48_to_51_BIT 12
#define FEEPRO_Write_protection_pages_52_to_53_MASK 0x2000
#define FEEPRO_Write_protection_pages_52_to_53 0x2000
#define FEEPRO_Write_protection_pages_52_to_53_BIT 13
#define FEEPRO_Write_protection_pages_56_to_57_MASK 0x4000
#define FEEPRO_Write_protection_pages_56_to_57 0x4000
#define FEEPRO_Write_protection_pages_56_to_57_BIT 14
#define FEEPRO_Write_protection_pages_60_to_61_MASK 0x8000
#define FEEPRO_Write_protection_pages_60_to_61 0x8000
#define FEEPRO_Write_protection_pages_60_to_61_BIT 15
#define FEEPRO_Write_protection_pages_64_to_65_MASK 0x10000
#define FEEPRO_Write_protection_pages_64_to_65 0x10000
#define FEEPRO_Write_protection_pages_64_to_65_BIT 16
#define FEEPRO_Write_protection_pages_68_to_69_MASK 0x20000
#define FEEPRO_Write_protection_pages_68_to_69 0x20000
#define FEEPRO_Write_protection_pages_68_to_69_BIT 17
#define FEEPRO_Write_protection_pages_72_to_73_MASK 0x40000
#define FEEPRO_Write_protection_pages_72_to_73 0x40000
#define FEEPRO_Write_protection_pages_72_to_73_BIT 18
#define FEEPRO_Write_protection_pages_76_to_77_MASK 0x80000
#define FEEPRO_Write_protection_pages_76_to_77 0x80000
#define FEEPRO_Write_protection_pages_76_to_77_BIT 19
#define FEEPRO_Write_protection_pages_80_to_81_MASK 0x100000
#define FEEPRO_Write_protection_pages_80_to_81 0x100000
#define FEEPRO_Write_protection_pages_80_to_81_BIT 20
#define FEEPRO_Write_protection_pages_84_to_85_MASK 0x200000
#define FEEPRO_Write_protection_pages_84_to_85 0x200000
#define FEEPRO_Write_protection_pages_84_to_85_BIT 21
#define FEEPRO_Write_protection_pages_88_to_89_MASK 0x400000
#define FEEPRO_Write_protection_pages_88_to_89 0x400000
#define FEEPRO_Write_protection_pages_88_to_89_BIT 22
#define FEEPRO_Write_protection_pages_92_to_93_MASK 0x800000
#define FEEPRO_Write_protection_pages_92_to_93 0x800000
#define FEEPRO_Write_protection_pages_92_to_93_BIT 23
#define FEEPRO_Write_protection_pages_96_to_97_MASK 0x1000000
#define FEEPRO_Write_protection_pages_96_to_97 0x1000000
#define FEEPRO_Write_protection_pages_96_to_97_BIT 24
#define FEEPRO_Write_protection_pages_100_to_101_MASK 0x2000000
#define FEEPRO_Write_protection_pages_100_to_101 0x2000000
#define FEEPRO_Write_protection_pages_100_to_101_BIT 25
#define FEEPRO_Write_protection_pages_104_to_105_MASK 0x4000000
#define FEEPRO_Write_protection_pages_104_to_105 0x4000000
#define FEEPRO_Write_protection_pages_104_to_105_BIT 26
#define FEEPRO_Write_protection_pages_108_to_109_MASK 0x8000000
#define FEEPRO_Write_protection_pages_108_to_109 0x8000000
#define FEEPRO_Write_protection_pages_108_to_109_BIT 27
#define FEEPRO_Write_protection_pages_112_to_114_MASK 0x10000000
#define FEEPRO_Write_protection_pages_112_to_114 0x10000000
#define FEEPRO_Write_protection_pages_112_to_114_BIT 28
#define FEEPRO_Write_protection_pages_116_to_119_MASK 0x20000000
#define FEEPRO_Write_protection_pages_116_to_119 0x20000000
#define FEEPRO_Write_protection_pages_116_to_119_BIT 29
#define FEEPRO_Write_protection_pages_120_to_123_MASK 0x40000000
#define FEEPRO_Write_protection_pages_120_to_123 0x40000000
#define FEEPRO_Write_protection_pages_120_to_123_BIT 30
#define FEEPRO_Read_protection_MASK 0x80000000
#define FEEPRO_Read_protection 0x80000000
#define FEEPRO_Read_protection_BIT 31

#define FEEHIDE (*(volatile unsigned long *)0xFFFFF820)

#define PWMCON (*(volatile unsigned short *)0xFFFFFC00)
#define PWMCON_PWMEM_MASK 0x1
#define PWMCON_PWMEM 0x1
#define PWMCON_PWMEM_BIT 0
#define PWMCON_PWM_SYNC_EN_MASK 0x2
#define PWMCON_PWM_SYNC_EN 0x2
#define PWMCON_PWM_SYNC_EN_BIT 1
#define PWMCON_PWMDBL_MASK 0x4
#define PWMCON_PWMDBL 0x4
#define PWMCON_PWMDBL_BIT 2
#define PWMCON_PWM_EXTSYNC_MASK 0x8
#define PWMCON_PWM_EXTSYNC 0x8
#define PWMCON_PWM_EXTSYNC_BIT 3
#define PWMCON_PWM_SYNCSEL_MASK 0x10
#define PWMCON_PWM_SYNCSEL 0x10
#define PWMCON_PWM_SYNCSEL_BIT 4

#define PWMSTA (*(volatile unsigned short *)0xFFFFFC04)
#define PWMSTA_PWMSYNCINT_MASK 0x200
#define PWMSTA_PWMSYNCINT 0x200
#define PWMSTA_PWMSYNCINT_BIT 9
#define PWMSTA_PWMTRIPINT_MASK 0x100
#define PWMSTA_PWMTRIPINT 0x100
#define PWMSTA_PWMTRIPINT_BIT 8
#define PWMSTA_PWMTRIP_MASK 0x8
#define PWMSTA_PWMTRIP 0x8
#define PWMSTA_PWMTRIP_BIT 3
#define PWMSTA_PWMPHASE_MASK 0x1
#define PWMSTA_PWMPHASE 0x1
#define PWMSTA_PWMPHASE_BIT 0

#define PWMDAT0 (*(volatile unsigned short *)0xFFFFFC08)

#define PWMDAT1 (*(volatile unsigned short *)0xFFFFFC0C)

#define PWMCFG (*(volatile unsigned short *)0xFFFFFC10)
#define PWMCFG_CHOPLO_MASK 0x3FE00
#define PWMCFG_CHOPLO_BIT 9
#define PWMCFG_CHOPHI_MASK 0x100
#define PWMCFG_CHOPHI 0x100
#define PWMCFG_CHOPHI_BIT 8
#define PWMCFG_GDCLK_MASK 0xFF
#define PWMCFG_GDCLK_BIT 0

#define PWMCH0 (*(volatile unsigned short *)0xFFFFFC14)

#define PWMCH1 (*(volatile unsigned short *)0xFFFFFC18)

#define PWMCH2 (*(volatile unsigned short *)0xFFFFFC1C)

#define PWMEN (*(volatile unsigned short *)0xFFFFFC20)
#define PWMEN__2H_EN_MASK 0x1
#define PWMEN__2H_EN 0x1
#define PWMEN__2H_EN_BIT 0
#define PWMEN__2L_EN_MASK 0x2
#define PWMEN__2L_EN 0x2
#define PWMEN__2L_EN_BIT 1
#define PWMEN__1H_EN_MASK 0x4
#define PWMEN__1H_EN 0x4
#define PWMEN__1H_EN_BIT 2
#define PWMEN__1L_EN_MASK 0x8
#define PWMEN__1L_EN 0x8
#define PWMEN__1L_EN_BIT 3
#define PWMEN__0H_EN_MASK 0x10
#define PWMEN__0H_EN 0x10
#define PWMEN__0H_EN_BIT 4
#define PWMEN__0L_EN_MASK 0x20
#define PWMEN__0L_EN 0x20
#define PWMEN__0L_EN_BIT 5
#define PWMEN__2H2L_XOVR_MASK 0x40
#define PWMEN__2H2L_XOVR 0x40
#define PWMEN__2H2L_XOVR_BIT 6
#define PWMEN__1H1L_XOVR_MASK 0x80
#define PWMEN__1H1L_XOVR 0x80
#define PWMEN__1H1L_XOVR_BIT 7
#define PWMEN__0H0L_XOVR_MASK 0x100
#define PWMEN__0H0L_XOVR 0x100
#define PWMEN__0H0L_XOVR_BIT 8

#define PWMDAT2 (*(volatile unsigned short *)0xFFFFFC24)


#endif
