/******************************************************************************
  Target Script for R O Software AT91 SBC.

  Copyright (c) 2005 Rowley Associates Limited.

  This file may be distributed under the terms of the License Agreement
  provided with this software.

  THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ******************************************************************************/

function Reset()
{
 // Get the target interface into debug state for the peeks and pokes
  TargetInterface.beginDebugAccess();

  // Disable watchdog
  TargetInterface.pokeWord(0xFFFF8000, 0x2340);
  // Initialize the WD Clock Mode Register
  TargetInterface.pokeWord(0xFFFF8004, 0x373F);
  // Restart the timer
  TargetInterface.pokeWord(0xFFFF8008, 0xC071);
  // Enable the watchdog
  TargetInterface.pokeWord(0xFFFF8000, 0x2341);
  // Enable internal reset generation
  TargetInterface.pokeWord(0xFFFF8000, 0x2343);

  // Set a breakpoint on reset vector
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0x00000000, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);

  // Release target from debug state.
  TargetInterface.endDebugAccess(true);

  // Wait for CPU to reset and hit the breakpoint
  TargetInterface.waitForDebugState(5000);

  // Reset the Embedded ICE macrocell
  TargetInterface.trst();

  // Disable the watchdog
  TargetInterface.pokeWord(0xFFFF8000, 0x2340);
}

function RAMReset()
{
  Reset();
  TargetInterface.pokeWord(0xFFE00000, 0x0100232D);
  TargetInterface.pokeWord(0xFFE00024, 5);
  // Cancel remapping, put SRAM at zero.
  TargetInterface.pokeWord(0xFFE00020, 1);
}

function FLASHReset()
{
  Reset();
}

