/******************************************************************************
  Target Script for TI TMS470.

  Copyright (c) 2005 Rowley Associates Limited.

  This file may be distributed under the terms of the License Agreement
  provided with this software.

  THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ******************************************************************************/

function Reset()
{
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  TargetInterface.runTestIdle();
  TargetInterface.setNSRST(0);
  TargetInterface.setNSRST(1);
  TargetInterface.waitForDebugState(1000);
  TargetInterface.trst();
}

function RAMReset()
{
  Reset();

  // Disable reset on address access violation
  TargetInterface.pokeWord(0xFFFFFFE0, 0x00004007); // SYSECR

  // Map internal SRAM (bank 2) to 0x10300000
  TargetInterface.pokeWord(0xFFFFFE10, 0x00001030); // MFBAHR2
  TargetInterface.pokeWord(0xFFFFFE14, 0x00000080); // MFBALR2

  // Map HET RAM (bank 4) to 0x10800000
  TargetInterface.pokeWord(0xFFFFFE20, 0x00000080); // MFBAHR4
  TargetInterface.pokeWord(0xFFFFFE24, 0x00000020); // MFBALR4

  // Map internal FLASH (bank 0) to 0x10000000
  TargetInterface.pokeWord(0xFFFFFE00, 0x00001000); // MFBAHR0
  TargetInterface.pokeWord(0xFFFFFE04, 0x000001c0); // MFBALR0

  // Duplicate internal SRAM (bank 3) at 0x00000000
  TargetInterface.pokeWord(0xFFFFFE18, 0x00000000); // MFBAHR3
  TargetInterface.pokeWord(0xFFFFFE1C, 0x00000080); // MFBALR3

  // Setup clock ICLK = SYSCLK/16.
  TargetInterface.pokeWord(0xFFFFFD30, 0x0000001E); // PCR: Setup CLKDIV
  TargetInterface.pokeWord(0xFFFFFD30, 0x0000001F); // PCR: Enable CLKDIV
}

function FLASHReset()
{
  Reset();

  // Disable reset on address access violation
  TargetInterface.pokeWord(0xFFFFFFE0, 0x00004007); // SYSECR

  // Map internal SRAM (bank 2) to 0x10300000
  TargetInterface.pokeWord(0xFFFFFE10, 0x00001030); // MFBAHR2
  TargetInterface.pokeWord(0xFFFFFE14, 0x00000080); // MFBALR2

  // Map HET RAM (bank 4) to 0x10800000
  TargetInterface.pokeWord(0xFFFFFE20, 0x00000080); // MFBAHR4
  TargetInterface.pokeWord(0xFFFFFE24, 0x00000020); // MFBALR4

  // Map internal FLASH (bank 1) to 0x00000000
  TargetInterface.pokeWord(0xFFFFFE08, 0x00000000); // MFBAHR1
  TargetInterface.pokeWord(0xFFFFFE0C, 0x000000c0); // MFBALR1

  // Map internal FLASH (bank 0) to 0x10000000
  TargetInterface.pokeWord(0xFFFFFE00, 0x00001000); // MFBAHR0
  TargetInterface.pokeWord(0xFFFFFE04, 0x000001c0); // MFBALR0

  // Setup clock ICLK = SYSCLK/16.
  TargetInterface.pokeWord(0xFFFFFD30, 0x0000001E); // PCR: Setup CLKDIV
  TargetInterface.pokeWord(0xFFFFFD30, 0x0000001F); // PCR: Enable CLKDIV
}

