/*****************************************************************************
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

  .global _start
  .extern C_Entry
  .global stack_start
  .global stack_end

  .text
  .code 32

#define PLLCON  0x0
#define PLLCFG  0x4
#define PLLSTAT 0x8
#define PLLFEED 0xC

/*****************************************************************************
 * Function    : _start                                                      *
 * Description : Minimal startup code for C system.                          *
 *****************************************************************************/
_start:                         
  /* Switch to "User FLASH mode" so interrupt vectors are not remapped */
  ldr r0, MEMMAP
  mov r1, #1
  str r1, [r0]

#ifdef USE_PLL
  /* Setup PLL */
  mov r0, #0xe0000000
  add r0, r0, #0x1fc000
  add r0, r0, #0x80
  /* Configure PLL Multiplier/Divider */
  mov r1, #0x24 /* multipler = 5, divider = 2 */
  str r1, [r0, #PLLCFG]
  /* Enable PLL */
  mov r1, #0x1
  str r1, [r0, #PLLCON]
  mov r1, #0xAA
  str r1, [r0, #PLLFEED]
  mov r1, #0x55
  str r1, [r0, #PLLFEED]
  /* Wait for PLL to lock */
pll_lock_loop:
  ldr r1, [r0, #PLLSTAT]
  tst r1, #0x400
  beq pll_lock_loop
  /* PLL Locked, connect PLL as clock source */
  mov r1, #0x3
  str r1, [r0, #PLLCON]
  mov r1, #0xAA
  str r1, [r0, #PLLFEED]
  mov r1, #0x55
  str r1, [r0, #PLLFEED]
#endif

  /* Setup stack */ 
  add sp, pc, #1024 
  
  /* Jump to main entry point */
  bl C_Entry

  /* Return from main, loop forever. */
loop:
  b loop

MEMMAP:
  .word 0xE01FC040 /* &MEMMAP */
                            
stack_start:
  .fill 1024
stack_end:
                  
