/*****************************************************************************
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/
  .section .vectors, "ax"
  .code 32
  .align 0

#ifdef __FLASH_BUILD

/*****************************************************************************
 * Exception Vectors (Prior to remap)                                        *
 *****************************************************************************/
  b reset_handler 
  b undef_handler
  b swi_handler
  b pabort_handler
  b dabort_handler
  .word 0 
  b irq_handler
  b fiq_handler

#endif

/*****************************************************************************
 * Exception Vectors                                                         *
 *****************************************************************************/
_vectors:
  ldr pc, [pc, #reset_handler_address - . - 8] /* reset */
  ldr pc, [pc, #undef_handler_address - . - 8] /* undefined instruction */
  ldr pc, [pc, #swi_handler_address - . - 8] /* swi handler */
  ldr pc, [pc, #pabort_handler_address - . - 8] /* abort prefetch */
  ldr pc, [pc, #dabort_handler_address - . - 8] /* abort data */
  nop
  ldr pc, [pc, #irq_handler_address - . - 8]
  ldr pc, [pc, #fiq_handler_address - . - 8]

reset_handler_address:
  .word reset_handler
undef_handler_address:
  .word undef_handler
swi_handler_address:
  .word swi_handler
pabort_handler_address:
  .word pabort_handler
dabort_handler_address:
  .word dabort_handler
irq_handler_address:
  .word irq_handler
fiq_handler_address:
  .word fiq_handler

  .section .init, "ax"
  .code 32
  .align 0

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 *                                                                            *
 ******************************************************************************/

reset_handler:
#ifdef __FLASH_BUILD
  ldr lr, =configure_ram
  mov r2, #0xa0000000
  mov r2, r2, asr #0x10
  /* Set up Flash as Segment 1 using CS0, 8 bit, 3 waits (BCR1 = 0x3003) */
  mov r3, #0x3000
  add r3, r3, #0x3
  str r3, [r2, #0x104]
  /* Read Write, non-cacheable, 32 bit, Bank 1 (SDR1 = 0x7802) */
  mov r3, #0x7800
  add r3, r3, #0x2
  str r3, [r2, #0x44]
  /* Set start addresses of segment 1 (START1 = 0x01000000) */
  mov r3, #0x01000000
  str r3, [r2, #0x4]
  /* Set stop addresses of segment 1 (STOP1 = 0x01100000) */
  mov r3, #0x01100000
  str r3, [r2, #0x24]
  /* Jump to program at new memory location */
  mov pc, lr
configure_ram:
  /* Set RAM as segment 2 using CS3=HI CS2=LO , 16 bit, 1 wait (BCR2 = 0x9090) */
  mov r3, #0x9000
  add r3, r3, #0x90
  str r3, [r2, #0x108]
  /* read/write, cachable, 32 bit, Bank 2 (SDR2 = 0x7C04) */
  mov r3, #0x7c00
  add r3, r3, #0x4
  str r3, [r2, #0x48]
  /* Set start addresses of segment 2 (START2 = 0x00000000) */
  mov r3, #0x0
  str r3, [r2, #0x8]
  /* Set stop addresses of segment 2 (START2 = 0x00080000) */
  mov r3, #0x80000
  str r3, [r2, #0x28]
  /* Copy exception vectors into RAM */
  mov r8, #0x00000000
  ldr r9, =_vectors
  ldmia r9!, {r0-r7}
  stmia r8!, {r0-r7}
  ldmia r9!, {r0-r6}
  stmia r8!, {r0-r6}     
#endif /* __FLASH_BUILD */
  b _start

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 * These are declared weak symbols so they can be redefined in user code.     * 
 *                                                                            *
 ******************************************************************************/

undef_handler:
  b undef_handler
  
swi_handler:
  b swi_handler
  
pabort_handler:
  b pabort_handler
  
dabort_handler:
  b dabort_handler
  
irq_handler:
  b irq_handler
  
fiq_handler:
  b fiq_handler

  .weak undef_handler, swi_handler, pabort_handler, dabort_handler, irq_handler, fiq_handler
                                                    

                  
