/*****************************************************************************
  Freescale MC9328MXL loader startup code.

  Copyright (c) 2005 Rowley Associates Limited.
 
  This file may be distributed under the terms of the License Agreement
  provided with this software.
 
  THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *****************************************************************************/
  .text
  .code 32
  .align 0

  .global _start
  .extern C_Entry
  .global stack_start
  .global stack_end

/*****************************************************************************
  Function    : _start
  Description : Minimal startup code for C system.
 *****************************************************************************/
_start:                         
  /* Disable MMU and caches */
  mov r0, #0
  mcr p15, 0, r0, c7, c7, 0          /* Invalidate ICache and DCache */
  mcr p15, 0, r0, c7, c10, 4         /* Drain write buffer */
  mcr p15, 0, r0, c8, c7, 0          /* Invalidate I & D TLBs */
  mrc p15, 0, r0, c1, c0, 0          /* Read MMU control register */
  bic r0, r0, #0x00001000            /* Disable ICache */
  bic r0, r0, #0x00000007            /* Disable DCache, MMU and alignment fault */
#ifdef __BIG_ENDIAN
  orr r0, r0, #0x00000080            /* Set B bit */
#else
  bic r0, r0, #0x00000080            /* Clear B bit */
#endif
  mcr p15, 0, r0, c1, c0, 0          /* Write MMU control register */

  /* Setup stack */ 
  add sp, pc, #1024 
  
  /* Jump to main entry point */
  bl C_Entry

  /* Return from main, loop forever. */
loop:
  b loop
                          
stack_start:
  .fill 1024
stack_end:
                  
