function Evaluator7T_Reset()
{
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  TargetInterface.runTestIdle();
  TargetInterface.setNSRST(0);
  TargetInterface.setNSRST(1);
  TargetInterface.waitForDebugState(1000);
  TargetInterface.trst();
}

function Evaluator7T_ResetWithRamAtZero()
{
  Evaluator7T_Reset();
  /***************************************************************************
   * Register settings for the following memory configuration:               *
   *                                                                         *
   *                     ----------------------                              *
   *                    | ROMCON0 - 512K FLASH | 0x01800000 - 0x0187FFFF     *
   *                    |----------------------|                             *
   *                    | ROMCON2 - 256K SRAM  | 0x00040000 - 0x0007FFFF     *
   *                    |----------------------|                             *
   *                    | ROMCON1 - 256K SRAM  | 0x00000000 - 0x0003FFFF     *
   *                     ----------------------                              *
   *                                                                         *
   ***************************************************************************/
  TargetInterface.pokeWord(0x03FF0000, 0x07FFFFA0); // SYSCFG
  TargetInterface.pokeWord(0x03FF3000, 0x00000000); // CLKCON
  TargetInterface.pokeWord(0x03FF3008, 0x00000000); // EXTACON0
  TargetInterface.pokeWord(0x03FF300C, 0x00000000); // EXTACON1
  TargetInterface.pokeWord(0x03FF3010, 0x0000003E); // EXTDBWIDTH
  TargetInterface.pokeWord(0x03FF3014, 0x18860030); // ROMCON0
  TargetInterface.pokeWord(0x03FF3018, 0x00400010); // ROMCON1
  TargetInterface.pokeWord(0x03FF301C, 0x00801010); // ROMCON2
  TargetInterface.pokeWord(0x03FF3020, 0x08018020); // ROMCON3
  TargetInterface.pokeWord(0x03FF3024, 0x0A020040); // ROMCON4
  TargetInterface.pokeWord(0x03FF3028, 0x0C028040); // ROMCON5
  TargetInterface.pokeWord(0x03FF302C, 0x00000000); // DRAMCON0
  TargetInterface.pokeWord(0x03FF3030, 0x00000000); // DRAMCON1
  TargetInterface.pokeWord(0x03FF3034, 0x00000000); // DRAMCON2
  TargetInterface.pokeWord(0x03FF3038, 0x00000000); // DRAMCON3
  TargetInterface.pokeWord(0x03FF303C, 0x9C218360); // REFEXTCON
}

function Evaluator7T_ResetWithFlashAtZero()
{
  Evaluator7T_Reset();
  /***************************************************************************
   * Register settings for the following memory configuration:               *
   *                                                                         *
   *                     ----------------------  0x00100000                  *
   *                    | ROMCON2 - 256K SRAM  |                             *
   *                    |----------------------| 0x000C0000                  *
   *                    | ROMCON1 - 256K SRAM  |                             *
   *                    |----------------------| 0x00080000                  *
   *                    | ROMCON0 - 512K FLASH |                             *
   *                    |                      |                             *
   *                     ----------------------  0x00000000                  *
   *                                                                         *
   * NOTE: Reset memory configuration for this Flash configuration is        *
   * only required so that there is some RAM to download the Flash loader    *
   * into.                                                                   * 
   ***************************************************************************/  
  TargetInterface.pokeWord(0x03FF0000, 0x07FFFFA0); // SYSCFG
  TargetInterface.pokeWord(0x03FF3000, 0x00000000); // CLKCON
  TargetInterface.pokeWord(0x03FF3008, 0x00000000); // EXTACON0
  TargetInterface.pokeWord(0x03FF300C, 0x00000000); // EXTACON1
  TargetInterface.pokeWord(0x03FF3010, 0x0000003E); // EXTDBWIDTH
  TargetInterface.pokeWord(0x03FF3014, 0x00800030); // ROMCON0
  TargetInterface.pokeWord(0x03FF3018, 0x00C02010); // ROMCON1
  TargetInterface.pokeWord(0x03FF301C, 0x01003010); // ROMCON2
  TargetInterface.pokeWord(0x03FF3020, 0x08018020); // ROMCON3
  TargetInterface.pokeWord(0x03FF3024, 0x0A020040); // ROMCON4
  TargetInterface.pokeWord(0x03FF3028, 0x0C028040); // ROMCON5
  TargetInterface.pokeWord(0x03FF302C, 0x00000000); // DRAMCON0
  TargetInterface.pokeWord(0x03FF3030, 0x00000000); // DRAMCON1
  TargetInterface.pokeWord(0x03FF3034, 0x00000000); // DRAMCON2
  TargetInterface.pokeWord(0x03FF3038, 0x00000000); // DRAMCON3
  TargetInterface.pokeWord(0x03FF303C, 0x9C218360); // REFEXTCON
}

