// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                     iSYSTEM ITPXA250 LED Example
//
// Description
// -----------
// This example demonstrates writing to the GPIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/PXA250.h>

extern void delay(volatile unsigned int d);

static void
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      GPCR0 = 0x18;
      delay(m);
      GPSR0 = 0x18;
      delay(n);
    }

  for (; m; m--, n++)
    {
      GPCR0 = 0x18;
      delay(m);
      GPSR0 = 0x18;
      delay(n);
    }
}

int
main(void)
{
  GPDR0 |= 0x18;
  while (1)
    {
      cycle(200);
      cycle(300);
      delay(200000);
    }
  return 0;
}

