// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/PXA250.h>

#define TIMER0_INT 26

#define CORE_CLOCK_FREQUENCY 3686400
#define TIMER_CORE_CLOCK_DIVIDER 1
#define TIMER_FREQUENCY 1000
#define TIMER_RECHARGE (CORE_CLOCK_FREQUENCY / TIMER_CORE_CLOCK_DIVIDER / TIMER_FREQUENCY)

static CTL_ISR_FN_t userTimerISR;

unsigned long idleCount;

static void
timerISR(void)
{
  OSSR = 1; /* Clear the timer interrupt */
  OSMR0 = OSCR + TIMER_RECHARGE;
  userTimerISR();
}

void
SetTimerISR(CTL_ISR_FN_t isr)
{
  ICLR &= ~(1 << TIMER0_INT); /* Timer interrupt generates IRQ interrupts */
  ICMR |= 1 << TIMER0_INT; /* Unmask the timer interrupt */
  OSMR0 = OSCR + TIMER_RECHARGE;
  OIER |= 1; /* Enable OSMR0 match interrupt */
  userTimerISR = isr;
  ctl_set_isr(TIMER0_INT, 1, CTL_ISR_TRIGGER_LOW_LEVEL, timerISR, 0);
  ctl_unmask_isr(TIMER0_INT);
}

unsigned long
TicksPerSecond(void)
{
  return 1000;
}

void
Idle()
{
  ++idleCount;
}


