// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
////////////////////////////////////////////////////////////////////////////////
//
//                          TMS470 Interrupt Example
//
// Description
// -----------
// This example demonstrates a simple interrupt handler. When running, pressing
// the "B1" and "B2" buttons cause the irq_handler to execute which toggles
// the LEDs.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/TMS470.h>

#define GIO_INT_A 5
#define GIO_INT_B 29

#define BUTTON1 2
#define BUTTON2 3

void irq_handler(void) __attribute__ ((interrupt ("IRQ")));

void
irq_handler(void)
{
  unsigned long i;
  switch ((0xFF & IRQIVEC) - 1)
    {
      case GIO_INT_A:
        HETDOUT ^= 0x0000FFFF; /* Toggle LEDs */
        GIOFLG1 = GIOFLG1;
        break;
      case GIO_INT_B:
        GIOFLG1 = GIOFLG1;
        HETDOUT ^= 0xFFFF0000; /* Toggle LEDs */
        break;
    }
}

int
main(void)
{
  /* Enable global IRQ interrupts */
  __ARMLIB_enableIRQ();

  /* Initialise LEDs */
  HETDIR  = 0xFFFFFFFF;        
  HETDOUT = 0xFFFFFFFF;

  /* Setup GIO Interrupts */
  GIOPRY1 |= 1 << BUTTON1; /* Make button 1 interrupt high priority */
  GIOPRY1 &= ~(1 << BUTTON2); /* Make button 2 interrupt low priority */
  GIOPOL1 &= ~(1 << BUTTON1); /* Make button 1 interrupt on falling edge */  
  GIOPOL1 |= 1 << BUTTON2; /* Make button 2 interrupt on rising edge */
  GIOENA1 |= (1 << BUTTON1) | (1 << BUTTON2); /* Enable button interrupts */

  /* Unmask interrupts */
  REQMASK = (1 << GIO_INT_A) | (1 << GIO_INT_B);

  /* Infinite loop */
  for (;;);
}

