/*=================================< string.h >==============================*/

void StrToUpper(char *string);

/*--------------------------------< SprintWord >-----------------------------*/
// This is a very lightweight substitute for sprintf or itoa.
// Parameters	:	str		Pointer to string to write to
//						wVal		16 bit unsigned int to convert to a string
//						bWidth	Number of significant digits.  Leading Zero's 
//									will be added if necessary.
// Returns 	:		nothing
void SprintWord(char *str, unsigned short wVal, int bWidth);

/*---------------------------------< SprintHex >-----------------------------*/
// This is a very lightweight substitute for sprintf or itoa.  Converts
// a number to a hexadecimal string.
// Parameters	:	str		Pointer to string to write to
//						wVal		16 bit unsigned int to convert to a string
//						bWidth	Number of significant digits.  Leading Zero's 
//									will be added if necessary.
// Returns 	:		nothing
void SprintHex(char *str, unsigned int wVal, int bWidth);

/*--------------------------------< ASCIIToInt >-----------------------------*/
// Converts the specified number of ASCII Hex digits to an integer.  ASCII
// alpha digits must be upper-case.
// ie.  "1A' = 26
// Parameters 	:	bBytes	Number of ASCII digits to convert (1..6)
//						pData		Pointer to ASCII digits to convert
// Returns :		WORD		Value of Hex string.
WORD AsciiToInt(BYTE bBytes, PBYTE pData);


// end of string.h
