/*================================< Regs.h >=================================*/
//
// Peripheral Register definitions for Sharp LH79520
// 
// 06/22/02 J.Guy

// Clocks and system stuff
#define RCPC_BASE (0x0fffe2000)
#define RCPCCTRL (*(volatile unsigned int *)(RCPC_BASE + 0x000))
#define RCPCREMAP (*(volatile unsigned int *)(RCPC_BASE + 0x008))
#define HCLKPRE (*(volatile unsigned int *)(RCPC_BASE + 0x018))
#define CPUCLKPRE (*(volatile unsigned int *)(RCPC_BASE + 0x01c))
#define PERCLKCTRL (*(volatile unsigned int *)(RCPC_BASE + 0x024))
#define PERCLKCTRL2 (*(volatile unsigned int *)(RCPC_BASE + 0x028))
#define AHBCLKCTRL (*(volatile unsigned int *)(RCPC_BASE + 0x02c))
#define PERCLKSEL (*(volatile unsigned int *)(RCPC_BASE + 0x030))
#define PERCLKSEL2 (*(volatile unsigned int *)(RCPC_BASE + 0x034))
#define PWM1_PRE (*(volatile unsigned int *)(RCPC_BASE + 0x03c))
#define LCDCLKPRE (*(volatile unsigned int *)(RCPC_BASE + 0x040))
#define SSPPSVAL (*(volatile unsigned int *)(RCPC_BASE + 0x044))

// Real Time Clock
#define RTC_BASE (0x0fffe0000)
#define RTCDR (*(volatile unsigned int *)(RTC_BASE + 0x000))
#define RTCMR (*(volatile unsigned int *)(RTC_BASE + 0x004))
#define RTCSTAT (*(volatile unsigned int *)(RTC_BASE + 0x008))
#define RTCLR (*(volatile unsigned int *)(RTC_BASE + 0x00c))
#define RTCCR (*(volatile unsigned int *)(RTC_BASE + 0x010))

// Static Memory Controller
#define SMCREG_BASE (0x0ffff1000)
#define SMCBCR0 (*(volatile unsigned int *)(SMCREG_BASE + 0x000))
#define SMCBCR1 (*(volatile unsigned int *)(SMCREG_BASE + 0x004))
#define SMCBCR2 (*(volatile unsigned int *)(SMCREG_BASE + 0x008))
#define SMCBCR3 (*(volatile unsigned int *)(SMCREG_BASE + 0x00c))
#define SMCBCR4 (*(volatile unsigned int *)(SMCREG_BASE + 0x010))
#define SMCBCR5 (*(volatile unsigned int *)(SMCREG_BASE + 0x014))
#define SMCBCR6 (*(volatile unsigned int *)(SMCREG_BASE + 0x018))

// GPIO Ports
#define GPIO_BASE0 (0x0fffdf000)
#define PORTA_DATA (*(volatile unsigned int *)(GPIO_BASE0 + 0x000))
#define PORTA_DDR (*(volatile unsigned int *)(GPIO_BASE0 + 0x008))
#define PORTB_DATA (*(volatile unsigned int *)(GPIO_BASE0 + 0x004))
#define PORTB_DDR (*(volatile unsigned int *)(GPIO_BASE0 + 0x00c))
#define GPIO_BASE1 (0x0fffde000)
#define PORTC_DATA (*(volatile unsigned int *)(GPIO_BASE1 + 0x000))
#define PORTC_DDR (*(volatile unsigned int *)(GPIO_BASE1 + 0x008))
#define GPIO_BASE2 (0x0fffdd000)
#define PORTF_DATA (*(volatile unsigned int *)(GPIO_BASE2 + 0x004))
#define PORTF_DDR (*(volatile unsigned int *)(GPIO_BASE2 + 0x00c))
#define GPIO_BASE3 (0x0fffdc000)
#define PORTH_DATA (*(volatile unsigned int *)(GPIO_BASE3 + 0x004))
#define PORTH_DDR (*(volatile unsigned int *)(GPIO_BASE3 + 0x00c))

// I/O Control
#define IOCONBASE (0x0fffe5000)
#define MEMMUX (*(volatile unsigned int *)(IOCONBASE + 0x000))
#define UARTMUX (*(volatile unsigned int *)(IOCONBASE + 0x010))
#define MISCMUX (*(volatile unsigned int *)(IOCONBASE + 0x008))
#define LCDMUX (*(volatile unsigned int *)(IOCONBASE + 0x004))
#define SSPMUX (*(volatile unsigned int *)(IOCONBASE + 0x014))

// PWM
#define PWM_BASE (0x0fffc3000)
#define PWM1_TC (*(volatile unsigned int *)(PWM_BASE + 0x020))
#define PWM1_DC (*(volatile unsigned int *)(PWM_BASE + 0x024))
#define PWM1_EN (*(volatile unsigned int *)(PWM_BASE + 0x028))

// UART 0
#define UART0BASE	(0xfffc0000)
#define UART0DR (*(volatile unsigned int *)(UART0BASE + 0x000))
#define UART0RSR (*(volatile unsigned int *)(UART0BASE + 0x004))
#define UART0ECR (*(volatile unsigned int *)(UART0BASE + 0x004))
#define UART0FR (*(volatile unsigned int *)(UART0BASE + 0x018))
#define UART0IBRD (*(volatile unsigned int *)(UART0BASE + 0x024))
#define UART0FBRD (*(volatile unsigned int *)(UART0BASE + 0x028))
#define UART0LCR_H (*(volatile unsigned int *)(UART0BASE + 0x02c))
#define UART0CR (*(volatile unsigned int *)(UART0BASE + 0x030))
#define UART0ILFS (*(volatile unsigned int *)(UART0BASE + 0x034))
#define UART0IMSC (*(volatile unsigned int *)(UART0BASE + 0x038))
#define UART0RIS (*(volatile unsigned int *)(UART0BASE + 0x03c))
#define UART0MIS (*(volatile unsigned int *)(UART0BASE + 0x040))
#define UART0ICR (*(volatile unsigned int *)(UART0BASE + 0x044))

// UART 1
#define UART1BASE	(0xfffc1000)
#define UART1DR (*(volatile unsigned int *)(UART1BASE + 0x000))
#define UART1RSR (*(volatile unsigned int *)(UART1BASE + 0x004))
#define UART1ECR (*(volatile unsigned int *)(UART1BASE + 0x004))
#define UART1FR (*(volatile unsigned int *)(UART1BASE + 0x018))
#define UART1IBRD (*(volatile unsigned int *)(UART1BASE + 0x024))
#define UART1FBRD (*(volatile unsigned int *)(UART1BASE + 0x028))
#define UART1LCR_H (*(volatile unsigned int *)(UART1BASE + 0x02c))
#define UART1CR (*(volatile unsigned int *)(UART1BASE + 0x030))
#define UART1ILFS (*(volatile unsigned int *)(UART1BASE + 0x034))
#define UART1IMSC (*(volatile unsigned int *)(UART1BASE + 0x038))
#define UART1RIS (*(volatile unsigned int *)(UART1BASE + 0x03c))
#define UART1MIS (*(volatile unsigned int *)(UART1BASE + 0x040))
#define UART1ICR (*(volatile unsigned int *)(UART1BASE + 0x044))

// LCD Controller
#define CLCDCBASE	(0xffff4000)
#define LCDTIMING0 (*(volatile unsigned int *)(CLCDCBASE + 0x000))
#define LCDTIMING1 (*(volatile unsigned int *)(CLCDCBASE + 0x004))
#define LCDTIMING2 (*(volatile unsigned int *)(CLCDCBASE + 0x008))
#define LCDUPBASE (*(volatile unsigned int *)(CLCDCBASE + 0x010))
#define LCDLPBASE (*(volatile unsigned int *)(CLCDCBASE + 0x014))
#define LCDINTREN (*(volatile unsigned int *)(CLCDCBASE + 0x018))
#define LCDCONTROL (*(volatile unsigned int *)(CLCDCBASE + 0x01c))
#define LCDSTATUS (*(volatile unsigned int *)(CLCDCBASE + 0x020))
#define LCDINTR (*(volatile unsigned int *)(CLCDCBASE + 0x024))
#define LCDUPCURR (*(volatile unsigned int *)(CLCDCBASE + 0x028))
#define LCDLPCURR (*(volatile unsigned int *)(CLCDCBASE + 0x02c))
#define LCDPALETTE (*(volatile unsigned int *)(CLCDCBASE + 0x200))
#define PLCDPALETTE ((volatile unsigned int *)(CLCDCBASE + 0x200))
#define ALCDPALETTE (CLCDCBASE + 0x200)

// HRTFT Controller (Part of LCD)
#define HRTFTBASE	(0xfffe4000)
#define HRTFTSETUP (*(volatile unsigned int *)(HRTFTBASE + 0x000))
#define HRTFTCONT (*(volatile unsigned int *)(HRTFTBASE + 0x004))
#define HRTFTTIME1 (*(volatile unsigned int *)(HRTFTBASE + 0x008))
#define HRTFTTIME2 (*(volatile unsigned int *)(HRTFTBASE + 0x00c))

// SDRAM Controller
#define SDRCBASE	(0xffff2000)
#define SDRCCONFIG0 (*(volatile unsigned int *)(SDRCBASE + 0x000))
#define SDRCCONFIG1 (*(volatile unsigned int *)(SDRCBASE + 0x004))
#define SDRCREFTIMER (*(volatile unsigned int *)(SDRCBASE + 0x008))
#define SDRCWBTIMEOUT (*(volatile unsigned int *)(SDRCBASE + 0x00c))

// SYNC SERIAL PORT 
#define SSPBASE (0xfffc6000)
#define SSPCR0 (*(volatile unsigned int *)(SSPBASE + 0x000))
#define SSPCR1 (*(volatile unsigned int *)(SSPBASE + 0x004))
#define SSPDR (*(volatile unsigned int *)(SSPBASE + 0x008))
#define SSPSR (*(volatile unsigned int *)(SSPBASE + 0x00c))
#define SSPCPSR (*(volatile unsigned int *)(SSPBASE + 0x010))
#define SSPICR (*(volatile unsigned int *)(SSPBASE + 0x014))
#define SSPIIR (*(volatile unsigned int *)(SSPBASE + 0x014))
#define SSPRXTO (*(volatile unsigned int *)(SSPBASE + 0x018))



/* end of regs.h */
