/*===============================< I2C.h >===================================*/

#include <stddefs.h>

// State and return codes
#define I2C_OFF 0               
#define I2C_IDLE 1
#define I2C_START 2
#define I2C_RXBYTE 3
#define I2C_ADDR 4
#define I2C_TXBYTE 5
#define I2C_NOACK 6

// Addresses of I2C devices - there's only one !
#define I2C_7013	0xec		// CH7013

/*=========================< Function Prototypes >===========================*/

/*----------------------------< I2cInitialize >------------------------------*/
// Configures a 3 LH79520 port pins to act as control signals.
// Parameters	:	bSpeed	Don't care
// Returns:			BYTE		Always TRUE
BYTE I2cInitialise(BYTE bSpeed);

/*-------------------------------< I2cTalk >---------------------------------*/
// Completes an I2c Transaction.  Writes the specified number of bytes then
// receives the specified number of bytes (optional).  The specified buffer
// will be used for both write and read transactions.
// Parameters 	:	bAddr			I2C Address to write to
//						bTxCount		Number of bytes to write (1-255)
//						bRxCount		Number of bytes to read  (0-255)
//						pBuffer		Pointer to buffer 
// Returns			BYTE			Final I2C state
BYTE I2cTalk(  BYTE bAddr, 
               BYTE bTxCount, 
               BYTE bRxCount,  
               PBYTE pBuffer);
              

// end of i2c.h
