// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/ML674000.h>

#define LED (*(volatile unsigned char *)0xF0000000)

void
BoardInit(void)
{
}

unsigned long
TicksPerSecond(void)
{
  return 503;
}

static CTL_ISR_FN_t userButtonISR;
static void
buttonISR(void)
{
  userButtonISR();
}

void
SetButtonPressedISR(CTL_ISR_FN_t isr)
{
  userButtonISR = isr;
  ctl_set_isr(28, 1, CTL_ISR_TRIGGER_NEGATIVE_EDGE, buttonISR, 0);
  ctl_unmask_isr(28);
}

void
SetLeds(unsigned v)
{
  LED = (unsigned char)v;
}

