// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                    Freescale MC9328MXL LED Example
//
// Description
// -----------
// This example demonstrates writing to the GPIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/MC9328MXL.h>

extern void delay(volatile unsigned int d);

#define LEDS ((1 << 2) | (1 << 23))

static void
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      GPIO_DR_A |= LEDS;
      delay(m);
      GPIO_DR_A &= ~LEDS;
      delay(n);
    }

  for (; m; m--, n++)
    {
      GPIO_DR_A |= LEDS;
      delay(m);
      GPIO_DR_A &= ~LEDS;
      delay(n);
    }
}

int
main(void)
{
  int i, j;

  GPIO_DDIR_A |= LEDS;
  GPIO_GIUS_A |= 1 << 2;
  GPIO_OCR1_A |= 3 << 4;
  GPIO_OCR2_A |= 3 << 14;

  for (i = 0;; i++)
    {
      cycle(1000);
      cycle(2000);
      delay(1000000);
    }
  return 0;
}
