// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                    Cogent CSB637 LED Example
//
// Description
// -----------
// This example demonstrates writing to the GPIO ports.
//
////////////////////////////////////////////////////////////////////////////////

#include "targets/AT91RM9200.h"

#define LED (1 << 2)

static void
delay(volatile unsigned int d)
{
  for (;d ;--d);
}

static void
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      PIOB_CODR = LED;
      delay(m);
      PIOB_SODR = LED;
      delay(n);
    }

  for (; m; m--, n++)
    {
      PIOB_CODR = LED;
      delay(m);
      PIOB_SODR = LED;
      delay(n);
    }
}

int
main(void)
{
  int i, j;

  PIOB_PER = LED;
  PIOB_OER = LED;

  for (i = 0;; i++)
    {
      cycle(1500);
      cycle(3000);
      delay(400000);
    }
  return 0;
}

